function BoardDraggingTool() {
  go.DraggingTool.call(this);
  this.fieldTemplate = null;  // THIS NEEDS TO BE SET before a drag starts
  this.temporaryPart = null;
  this.lastDraggingPoint;
  this.fromParentNodeData;
}
go.Diagram.inherit(BoardDraggingTool, go.DraggingTool);

// override this method
BoardDraggingTool.prototype.findDraggablePart = function () {
  var diagram = this.diagram;
  var obj = diagram.findObjectAt(diagram.lastInput.documentPoint);
  while (obj !== null && obj.type !== go.Panel.TableRow) obj = obj.panel;
  if (obj !== null && obj.type === go.Panel.TableRow &&
    this.fieldTemplate !== null && this.temporaryPart === null) {
    var tempPart =
      go.GraphObject.make(go.Node, "Table",
        { layerName: "Tool", locationSpot: go.Spot.Center },
        this.fieldTemplate.copy());  // copy the template!

    this.fromParentNodeData = obj.part.data;

    this.temporaryPart = tempPart;
    // assume OBJ is now a Panel representing a field, bound to field data
    // update the temporary Part via data binding
    tempPart.location = diagram.lastInput.documentPoint;  // need to set location explicitly
    diagram.add(tempPart);  // add to Diagram before setting data
    tempPart.data = obj.data;  // bind to the same field data as being dragged
    return tempPart;
  }
  var offset = diagram.lastInput.documentPoint.copy().subtract(diagram.firstInput.documentPoint);
  return go.DraggingTool.prototype.findDraggablePart.call(this);
};

BoardDraggingTool.prototype.doActivate = function () {
  if (this.temporaryPart === null) return go.DraggingTool.prototype.doActivate.call(this);
  var diagram = this.diagram;
  this.standardMouseSelect();
  this.isActive = true;
  // instead of the usual result of computeEffectiveCollection, just use the temporaryPart alone
  var map = new go.Map(/*go.Part, go.DraggingInfo*/);
  map.set(this.temporaryPart, new go.DraggingInfo(diagram.lastInput.documentPoint.copy()));
  this.draggedParts = map;
  this.startTransaction("Drag Field");
  diagram.isMouseCaptured = true;
};

BoardDraggingTool.prototype.doDeactivate = function () {
  if (this.temporaryPart === null) return go.DraggingTool.prototype.doDeactivate.call(this);
  var diagram = this.diagram;
  // make sure the temporary Part is no longer in the Diagram
  diagram.remove(this.temporaryPart);
  this.temporaryPart = null;
  // now do all the standard deactivation cleanup,
  // including setting isActive = false, clearing out draggedParts, calling stopTransaction(),
  // and setting diagram.isMouseCaptured = false
  go.DraggingTool.prototype.doDeactivate.call(this);
};

BoardDraggingTool.prototype.doMouseMove = function () {
  // console.log("BoardDraggingTool.prototype.doMouseMove");
  if (!this.isActive) return;
  if (this.temporaryPart === null) return go.DraggingTool.prototype.doMouseMove.call(this);
  var diagram = this.diagram;
  // just move the temporaryPart (in draggedParts), without regard to moving or copying permissions of the Node
  var offset = diagram.lastInput.documentPoint.copy().subtract(diagram.firstInput.documentPoint);
  this.moveParts(this.draggedParts, offset, false);

  this.lastDraggingPoint = this.temporaryPart.location.copy();
};

BoardDraggingTool.prototype.doMouseUp = function () {
  if (!this.isActive) return;
  if (this.temporaryPart === null) return go.DraggingTool.prototype.doMouseUp.call(this);
  var diagram = this.diagram;

  var draggingItemData = this.temporaryPart.data;
  var dest = diagram.findPartAt(this.lastDraggingPoint, false);

  if (dest != null && dest.data) {
    if (dest.data.isGroup || dest.data.data) {

      var fromParent = this.fromParentNodeData;
      var fromGroup = { tc: fromParent.teamContainer };

      var toGroup;
      var toParent;

      var dropInfo = undefined;

      var parentNode;
      if (dest.data.isGroup) {
        var thisTool = this;
        dest.memberParts.each(function (part) {
          if (part.data && part.data.data && part.data.data.id === thisTool.fromParentNodeData.data.id) {
            parentNode = part;
          }
        });
      } else {
        parentNode = dest;
      }
      if (!parentNode) {
        toParent = undefined;
        toGroup = { teamId: dest.data.teamId, containerId: dest.data.containerId };
      }
      else {
        toParent = parentNode.data;
        toGroup = { tc: parentNode.data.teamContainer };
        dropInfo = _this.getDropInfoChild(draggingItemData, parentNode, this.lastDraggingPoint);
      }
      // item, fromGroup, fromParent , toGroup, toParent, dropInfo
      _this.$emit("drop-board-child", draggingItemData, fromGroup, fromParent, toGroup, toParent, dropInfo);
    }
  }

  this.transactionResult = "Inserted Field";
  this.stopTool();
};