function BoardDiagramLayout() {
  TableLayout.call(this);
}
go.Diagram.inherit(BoardDiagramLayout, TableLayout);
BoardDiagramLayout.prototype.doLayout = function (coll) {

  var diagram = this.diagram;
  var _this = this;
  if (diagram === null) return;
 
  diagram.startTransaction("BoardDiagramLayout");

  if (boardInstance.activeBoard && boardInstance.activeBoard.containers) {

    var totalSpace = diagram.viewportBounds.width - 50;
    var totalCollapsedSpace = 0;
    var columnWidthCollapsed = 50;

    var collapsedColumns = {};
    var collapsedRows = {};
    var expandedColumns = 0;
    _.each(diagram.model.nodeDataArray, node => {
      if (node.category) {
        if (node.category == "Column Header") {
          if (!node.expanded) {
            node.title = "";
            node.width = columnWidthCollapsed;
            collapsedColumns[node.data.id] = true;
            totalCollapsedSpace += columnWidthCollapsed;
          } else {
            node.title = node.data.title;
            node.width = NaN;
            expandedColumns++;
          }
        }
        else if (node.category == "Row Sider") {
          if (!node.expanded) {
            collapsedRows[node.data.id] = true;
          }
          else {

          }
        }
      }
    });

    var totalAvailableSpace = totalSpace - totalCollapsedSpace;
    var columnWidthExpanded = expandedColumns <= 4 ? (totalAvailableSpace / expandedColumns) : totalAvailableSpace / 4;

    diagram.findTopLevelGroups().each(function (lane) {
      if (!(lane instanceof go.Group)) return;
      var shape = lane.selectionObject;
      if (shape !== null && lane.data.containerId) {  // change the desiredSize to be big enough in both directions
        if (collapsedColumns[lane.data.containerId]) {
          shape.width = columnWidthCollapsed;
        } else {
          shape.width = columnWidthExpanded;
        }
        // if (collapsedRows[lane.data.teamId]) {
        //   shape.height = 50;
        // } else {
        //   shape.height = NaN;
        // }
      }
    });
  }
  diagram.commitTransaction("BoardDiagramLayout");

  // // now do all of the usual stuff, according to whatever properties have been set on this GridLayout
  TableLayout.prototype.doLayout.call(this, coll);
};