// class BacklogItemModel extends  bryntum.schedulerpro.EventModel {
// 	static get fields() {
// 		return [
// 			// Add new field
// 			//
// 			{name: 'orgId', type: 'number', defaultValue: -1},
// 			{name: 'ttype', type: 'string', defaultValue: ''},
// 			{name: 'statusColor',type : 'string',defaultValue: "#7c50b1"},
// 			{name:'statusClass',type:'string',defaultValue:'e'},
//
// 		];
// 	}
// }

var totalPlannedCount = 0;
const defaultGroupColor ="#3DC198";
const itemPopupOrigins ={
	PLANNED : "planned",
	UNPLANNED: "unplanned"
}

// Azure SVG icon as base64 data URI for PDF export compatibility
const AZURE_SVG_DATA_URI = 'data:image/svg+xml;base64,' + btoa(
	'<svg width="45" height="37" viewBox="0 0 45 37" fill="none" xmlns="http://www.w3.org/2000/svg">' +
	'<path fill-rule="evenodd" clip-rule="evenodd" d="M27.731 6.28969L21.2049 19.863L32.6945 33.615L11.3699 36.1151L44.4597 36.4726L27.731 6.28969Z" fill="#008AD7"/>' +
	'<path fill-rule="evenodd" clip-rule="evenodd" d="M26.444 0.931641L11.4618 13.88L0.339844 33.2579L9.80728 32.2754L26.444 0.931641Z" fill="#008AD7"/>' +
	'</svg>'
);

/**
 * Creates an Azure icon image tag with inline SVG for PDF export compatibility
 * @param {string} additionalClasses - Additional CSS classes to add
 * @param {string} alt - Alt text for the image
 * @returns {string} HTML img tag with inline SVG
 */
function createAzureIcon(additionalClasses = '', alt = 'Dates from ADO Iteration Path') {
	const classes = 'azurico' + (additionalClasses ? ' ' + additionalClasses : '');
	return `<img src="${AZURE_SVG_DATA_URI}" class="${classes}" alt="${alt}" />`;
}

/**
 * Creates a date adjusted alert indicator with tooltip
 * @param {string} additionalClasses - Additional CSS classes to add
 * @returns {string} HTML span with alert icon and tooltip
 */
function createDateAdjustedAlert(additionalClasses = '') {
	const classes = 'key azico ml-5 tooltip' + (additionalClasses ? ' ' + additionalClasses : '');
	return `<span class="${classes}" style="color: #ff9800;">
		<i class="ti-alert-triangle ico" style="font-size: 14px;"></i>
		<div class="hovtooltipB sml tprht">Start date was after end date. End date adjusted to start date + 1 month.</div>
	</span>`;
}

// Enhanced UX Helper Functions for Items Roadmap
function addEnhancedItemsStyles() {
    if (document.getElementById('items-roadmap-enhanced-styles')) return;

    const style = document.createElement('style');
    style.id = 'items-roadmap-enhanced-styles';
    style.textContent = `
        /* Enhanced Items Roadmap Styles */
        @keyframes slideInRight {
            from { transform: translateX(20px); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
        
        .enhanced-milestone-section {
            animation: slideInRight 0.3s ease-out;
        }
        
        .enhanced-group-header {
            transition: all 0.2s ease;
        }
        
        .enhanced-add-btn:hover {
            animation: pulse 1.5s infinite;
        }
        
        .enhanced-count {
            transition: all 0.3s ease;
        }
        
        .enhanced-kendis-tree-item-row {
            transition: all 0.2s ease;
        }
        
        .enhanced-kendis-tree-item-row:hover {
            transform: translateY(-1px);
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .enhanced-resource-actions {
            transition: all 0.2s ease;
        }
        
        .enhanced-action-icon:hover {
            transform: scale(1.05) !important;
            box-shadow: 0 2px 8px rgba(0,0,0,0.15);
        }
        
        .enhanced-unplanned-count {
            transition: all 0.3s ease;
        }
        
        .enhanced-unplanned-count:hover {
            transform: scale(1.05);
            box-shadow: 0 2px 8px rgba(255, 107, 107, 0.3);
        }
        
        .enhanced-children-counts {
            transition: all 0.3s ease;
        }
        
        .enhanced-children-counts .unplanned-count:hover {
            color: #dc3545 !important;
            font-weight: bold;
        }
        
        .enhanced-children-counts .planned-count {
            font-weight: 500;
        }
        
        /* Enhanced styling for the new count display */
       /* .unplanned-count.clickable {
            background: rgba(255, 107, 107, 0.1);
            padding: 2px 6px;
            border-radius: 12px;
            border: 1px solid #ff6b6b;
            transition: all 0.3s ease;
        }
        
        .unplanned-count.clickable:hover {
            background: rgba(255, 107, 107, 0.2);
            transform: scale(1.05);
            box-shadow: 0 2px 8px rgba(255, 107, 107, 0.3);
        }
        
        .planned-count.clickable {
            background: rgba(40, 167, 69, 0.1);
            padding: 2px 6px;
            border-radius: 12px;
            border: 1px solid #28a745;
            transition: all 0.3s ease;
        }
        
        .planned-count.clickable:hover {
            background: rgba(40, 167, 69, 0.2);
            transform: scale(1.05);
            box-shadow: 0 2px 8px rgba(40, 167, 69, 0.3);
        } */
        
        /* Enhanced tooltip animations */
        .enhanced-tooltip {
            animation: slideInRight 0.2s ease-out;
        }
        
        /* Responsive improvements */
        @media (max-width: 768px) {
            .enhanced-kendis-tree-item-row {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .enhanced-resource-actions {
                margin-top: 8px;
                width: 100%;
                justify-content: flex-start;
            }
        }
    `;
    document.head.appendChild(style);
}

// Initialize enhanced styles when DOM is ready
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', addEnhancedItemsStyles);
} else {
    addEnhancedItemsStyles();
}

function getBackLogItemIconUrl(item, root) {
	let itemIconUrl = "";
	if(item && item.fields) {
		if(!_.isEmpty(item.fields.tfsProjectId)) {
			itemIconUrl = item.fields.itemTypeIcon;
		} else if (item.fields.issuetype || item.almFields && item.almFields.issuetype) {
			itemIconUrl = styleJiraIcon(root, item);
		}
	}
	return itemIconUrl ? itemIconUrl : '';
}
function getPaginationToolBarConfig(_this) {
	return [
		{
			type: 'button',
			text: '<',
			cls: 'kendis-prev-page-button',
			hidden: true,
			onClick: () => {
				_this.$options.paginator.prevPage()
			},
			ref: 'prevBtn' // Reference for enabling/disabling
		},
		{
			type: 'combo',
			ref: 'kendis-items-roadmap-page-size-dropdown-widget',
			cls: ['kendis-page-size-dropdown-cls'],
			editable: false,
			hidden: true,
			items: [25,50,100],
			width: 100,
			onChange({value}) {
				_this.$options.paginator.setPageSize(value)
				let pageNumbers = _this.$options.paginator.getAllPageNumbers();
				_this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-index-dropdown-widget'].items = pageNumbers
				_this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-index-dropdown-widget'].value = pageNumbers[0];
			}
		},
		{
			type: 'combo',
			ref: 'kendis-items-roadmap-page-index-dropdown-widget',
			cls: ['kendis-page-index-dropdown-cls'],
			editable: false,
			hidden: true,
			valueField: 'index',
			displayField: 'display',
			// label : 'page#',
			// labelPosition: 'above',
			width: 100,
			items: _this.$options.paginator.getAllPageNumbers(),
			onChange({source}) {
				_this.$options.paginator.goToPage(source.value)
			}
		},
		{
			type: 'button',
			text: '>',
			cls: 'kendis-next-page-button',
			hidden: true,
			onClick: () => {
				_this.$options.paginator.nextPage()
			},
			ref: 'nextBtn' // Reference for enabling/disabling
		}
	]
}
// Event Renderer Helper Functions
function getEventType(eventRecord) {
	if (eventRecord.fields?.itemType === "Milestone") return 'milestone';
	if (eventRecord.fields?.itemType === "Phase") return 'phase';
	if (eventRecord.isHeader) return 'header';
	if (eventRecord.isChild || eventRecord.ttype === "child_item") return 'childItem';
	return 'item';
}

// Resource Renderer Helper Functions
function getResourceType(record, _this) {
	if (_this.showIndividualItemResources && record.get('isItem')) return 'itemResource';
	if (!_this.showIndividualItemResources && record.id.endsWith('_items')) return 'itemsResource';
	if (record.id === "-1001") return 'milestoneResource';
	if (metaDependantGroups.includes(_this.groupBy.value)) return 'metaGroup';
	if (!metaDependantGroups.includes(_this.groupBy.value)) return 'nonMetaGroup';
	if (_this.groupBy.value === "Section") return 'sectionGroup';
	// Check for items resource in old mode (format: sectionId_items)
	return 'defaultGroup';
}

function renderItemResource(record, _this, data) {
	const baseColor = record.get('color') ? record.get('color') : defaultGroupColor;
	const lightColor = lightenHexColor(baseColor, 0, 0.19);

	// Apply enhanced styling
	applyEnhancedItemResourceStyling(data.cellElement, baseColor, lightColor);

	const item = _this.itemsByIdMap[record.get('orgId')];
	let keyHtml = '';
	if (!_.isEmpty(item.almKey)) {
		keyHtml = `<a class='key ftsb fs-13 jiraKeyHandle kendisOnly' style='min-width: auto;' href='${item.url}' target='_blank'>${item.almKey}</a>`;
	} else if (!_.isEmpty(item.fields?.externalKey)) {
		keyHtml = `<a class='key ftsb fs-13 jiraKeyHandle kendisOnly' style='min-width: auto;' href='${item.fields.externalLink}' target='_blank'>${item.fields.externalKey}</a>`;
	} else if (!_.isEmpty(item.kendisKey)) {
		keyHtml = `<a class='key ftsb fs-13 jiraKeyHandle kendisOnly' style='min-width: auto;' target='_blank'>${item.kendisKey}</a>`;
	}
	const backlogItemIconUrl = getBackLogItemIconUrl(item, _this.$root);
	const iconSpan = createResourceIconSpan(backlogItemIconUrl, item);

	// Get children counts from cache
	const unplannedCount = _this.unplannedChildrenCountCache[record.get('orgId')] || 0;
	const plannedCount = _this.plannedChildrenCountCache[record.get('orgId')] || 0;

	const childrenCountDisplay = createChildrenCountDisplay(unplannedCount, plannedCount, record, _this);
	const toggleButton = createToggleButton(record, _this);
	return `
		<div class="kendis-tree-item-row">
			<div class="DFA">
			${toggleButton}						
			<span class="p-rel" style="top:-2px;">${iconSpan}</span>
			<div class="item-key DAB">
				${keyHtml}
				<div class="resource-actions trnsn DAJ enhanced-resource-actions">					
					<div class="action-icon DAJ ti-plus ico c-point nwbtn btn1 add-new-child tooltip" 
						 onclick="event.stopPropagation(); roadmapVue.onAddNewChild('${record.id}');">
						 <div class="hovtooltipB sml tprht">Create New Child</div>
					</div>
					<div class="action-icon DAJ ti-link ico c-point nwbtn btn2 add-existing-child tooltip" 
						 onclick="event.stopPropagation(); roadmapVue.onAddExistingChild('${record.id}');">
						 <div class="hovtooltipB sml tprht">Add Existing Child</div>
					</div>
					<div class="action-icon DAJ ti-pencil ico c-point nwbtn btn3 edit-item tooltip" 
						 onclick="event.stopPropagation(); roadmapVue.editItemResource('${record.id}');">
						 <div class="hovtooltipB sml tprht">Edit Item</div>
					</div>
				</div>
			</div>
			</div>
			<div class="item-title-road mb-5 mt-5 aa">${record.name}</div>
			<div class="DFA">${childrenCountDisplay}</div>							
		</div>`;
}

function renderMilestoneResource(record, _this, data) {
	const childResourceCount = _this.getGlobalMilestoneCount();
	applyEnhancedMilestoneResourceStyling(data.cellElement);
	if(!record.expanded){
		data.size.height = 40;
	}else{
		data.size.height = 80;
	}

	return `
		<div class="titleout resource-scheduler enhanced-milestone-section">
			<i class="arrdokrw mr-10 trnsn c-point DIB ${data.record.expanded ? 'active' : ''} objective-arrow"></i>
			<div class="milestone-header">Milestones</div>
			${childResourceCount > 0 ? `<div class='ncntval DAJ ml-10'>${childResourceCount}</div>` : ''}
			<a class='add ico ti-plus addbtnw DAJ ml-10 mlstn' 
			   href='javascript:void(0);' 
			   onclick='roadmapVue.showMilestoneMenu(event); event.stopPropagation();'
			   title="Add New Milestone"></a>
		</div>`;
}

function renderMetaGroup(record, _this, data) {
	const childResourceCount = getChildResourceCount(record);
	const groupTitle = _this.getGroupTitleFromMeta(record.id, _this.groupBy.value);
	applyEnhancedGroupStyling(data.cellElement, record);

	return `<div class="titleout resource-scheduler enhanced-group-header">
		<div class='roadmapLevels resource-scheduler'><span>${groupTitle}</span></div>
		${childResourceCount > 0 ? `<div class='ml-10 cntval enhanced-count'>${childResourceCount}</div>` : ''}
	</div>`;
}

function renderNonMetaGroup(record, _this, data) {
	const childResourceCount = getChildResourceCount(record);
	applyEnhancedGroupStyling(data.cellElement, record);

	return `<div class="titleout resource-scheduler enhanced-group-header">
		<div class='roadmapLevels resource-scheduler'>${record.name}</div>
		${childResourceCount > 0 ? `<div class='ml-10 cntval enhanced-count'>${childResourceCount}</div>` : ''}
	</div>`;
}

function renderSectionGroup(record, _this, data) {
	const isDefaultSection = record.id === "null";

	if (isDefaultSection) {
		return renderDefaultSectionGroup(record, _this, data);
	} else {
		return renderRegularSectionGroup(record, _this, data);
	}
}

function renderDefaultSectionGroup(record, _this, data) {
	const itemCount = _this.getSectionItemCount(record.id);
	applyEnhancedGroupStyling(data.cellElement, record);

	return `
		<div class="titleout resource-scheduler enhanced-group-header">
			<div class='roadmapLevels'>${record.name}</div>
			
			<a class='add ico ti-plus addButtonMile ml-10 enhanced-add-btn' 
			   href='javascript:void(0);' 
			   onclick='roadmapVue.onClickCreateNew("${record.id}"); event.stopPropagation();'
			   title="Add New Item"></a>
		</div>`;
}

function renderRegularSectionGroup(record, _this, data) {
	const milestoneCount = _this.getSectionMilestoneCount(record.id);
	const itemCount = _this.getSectionItemCount(record.id);
	const totalCount = milestoneCount + itemCount;
	const lastResourceId = roadmapVue.$options.roadmap.resourceStore.last.id;

	applyEnhancedGroupStyling(data.cellElement, record);

	return `
		<div class="titleout resource-scheduler enhanced-group-header">
			<div class='roadmapLevels'>${record.name}</div>
			<a class='add ico ti-plus addButtonMile ml-10 enhanced-add-btn' 
			   href='javascript:void(0);' 
			   onclick='roadmapVue.onClickCreateNew("${record.id}"); event.stopPropagation();'
			   title="Add New Item"></a>
			<a class='add ico ti-star addButtonMile ml-10 enhanced-add-btn' 
			   href='javascript:void(0);' 
			   onclick='roadmapVue.showSectionMilestoneMenu("${record.id}", event); event.stopPropagation();'
			   title="Add Milestone to this Section"></a>
			${record.id === lastResourceId ?
			"<a class='add ico ti-folder addButtonMile ml-10 enhanced-add-btn' href='javascript:void(0);' onclick='roadmapVue.addSectionAtEnd(event)' title='Add New Section'></a>" : ""}
		</div>`;
}

function renderDefaultGroup(record, _this, data) {
	const childResourceCount = getChildResourceCount(record);
	applyEnhancedGroupStyling(data.cellElement, record);

	return `<div class="titleout resource-scheduler enhanced-group-header">
		<div class='roadmapLevels resource-scheduler'>${record.name}</div>
	</div>`;
}

function renderItemsResource(record, _this, data) {
	// Count items in this items resource
	const itemCount = _this.getSectionItemCount(record.id.replace('_items', ''));
	applyEnhancedGroupStyling(data.cellElement, record);

	return `<div class="titleout resource-scheduler enhanced-group-header">
		 
	</div>`;
}

function renderOldModeResource(record, _this, data) {
	applyOldModeStyling(data.cellElement, record);

	if (record.id === "-1001") {
		return renderOldModeMilestoneResource(record, _this);
	}

	if (metaDependantGroups.includes(_this.groupBy.value)) {
		return renderOldModeMetaGroup(record, _this);
	}

	if (_this.groupBy.value === "Section") {
		return renderOldModeSectionGroup(record, _this);
	}

	// Check for items resource in old mode
	if (record.id.endsWith('_items')) {
		return renderItemsResource(record, _this, data);
	}

	return renderOldModeDefaultGroup(record);
}

function renderOldModeMilestoneResource(record, _this) {
	const countOfAssignments = _this.$options.roadmap.assignmentStore.getAssignmentsForResource(record).length;

	return `
		<div class="titleout resource-scheduler aa">
			Milestones 
			${countOfAssignments > 0 ? `<div class='ncntval DAJ ml-10 mlll'>${countOfAssignments}</div>` : ''}
			<a class='add ico ti-plus addbtnw DAJ ml-10 mlstn' href='javascript:void(0);' onclick='roadmapVue.showMilestoneMenu(event)'></a>
		</div>`;
}

function renderOldModeMetaGroup(record, _this) {
	const groupTitle = _this.getGroupTitleFromMeta(record.id, _this.groupBy.value);

	return `<div class="titleout resource-scheduler">
		<div class='roadmapLevels resource-scheduler'><span>${groupTitle}</span></div>
	</div>`;
}

function renderOldModeSectionGroup(record, _this) {
	const isDefaultSection = record.id === "null";
	const lastResourceId = roadmapVue.$options.roadmap.resourceStore.last.id;

	if (isDefaultSection) {
		const itemCount = _this.getSectionItemCount(record.id);
		return `
			<div class="titleout resource-scheduler">
				<div class='roadmapLevels'>${record.name}</div>
				${itemCount > 0 ? `<div class='ml-10 cntval'>${itemCount}</div>` : ''}
				<a class='add ico ti-plus addButtonMile ml-10' 
				   href='javascript:void(0);' 
				   onclick='roadmapVue.onClickCreateNew("${record.id}"); event.stopPropagation();'
				   title="Add New Item"></a>
			</div>`;
	} else {
		const milestoneCount = _this.getSectionMilestoneCount(record.id);
		const itemCount = _this.getSectionItemCount(record.id);
		const totalCount = milestoneCount + itemCount;

		return `
			<div class="titleout resource-scheduler">
				<div class='roadmapLevels'>${record.name}</div>
				${totalCount > 0 ? `<div class='ml-10 cntval'>${totalCount}</div>` : ''}
				<a class='add ico ti-plus addButtonMile ml-10' 
				   href='javascript:void(0);' 
				   onclick='roadmapVue.onClickCreateNew("${record.id}"); event.stopPropagation();'
				   title="Add New Item"></a>
				<a class='add ico ti-star addButtonMile ml-10' 
				   href='javascript:void(0);' 
				   onclick='roadmapVue.showSectionMilestoneMenu("${record.id}", event); event.stopPropagation();'
				   title="Add Milestone to this Section"></a>
				${record.id === lastResourceId ?
					"<a class='add ico ti-folder addButtonMile ml-10' href='javascript:void(0);' onclick='roadmapVue.addSectionAtEnd(event)' title='Add New Section'></a>" : ""}
			</div>`;
	}
}

function renderOldModeDefaultGroup(record) {
	return `<div class="titleout resource-scheduler">
		<div class='roadmapLevels resource-scheduler'>${record.name}</div>
		<a class='add ico ti-plus addButtonMile ml-10' 
		   href='javascript:void(0);' 
		   onclick='roadmapVue.onClickCreateNew("${record.id}"); event.stopPropagation();'
		   title="Add New Item">
		</a>
	</div>`;
}

function applyEnhancedItemResourceStyling(cellElement, baseColor, lightColor) {
	cellElement.style.background = '#fff';
	cellElement.style.color = '#fff';
	cellElement.style.borderLeft = `4px solid ${baseColor}`;
	cellElement.style.transition = 'all 0.2s ease';
	cellElement.style.position = 'relative';
	cellElement.style.overflow = 'hidden';
}

function applyEnhancedMilestoneResourceStyling(cellElement) {
	cellElement.style.background = '#4587D5';
	cellElement.style.borderLeft = '4px solid #3764B0';
	cellElement.style.transition = 'all 0.2s ease';
	cellElement.style.position = 'relative';
	cellElement.style.overflow = 'hidden';
}

function applyEnhancedGroupStyling(cellElement, record) {
	const baseColor = record.color || (record.originalData && record.originalData.color) || defaultGroupColor;
	const lightColor = lightenHexColor(baseColor, 0, 0.19);
	cellElement.style.backgroundColor = `${baseColor}`;
	cellElement.style.backgroundImage = `linear-gradient(rgba(255, 255, 255, .8), rgba(255, 255, 255, .8))`;
	cellElement.style.color = '#fff';
	cellElement.style.borderLeft = `4px solid ${baseColor}`;
	cellElement.style.transition = 'all 0.2s ease';
	cellElement.style.position = 'relative';
	cellElement.style.overflow = 'hidden';
}

function applyOldModeStyling(cellElement, record) {
	cellElement.style.backgroundColor = lightenHexColor(record.color ? record.color : defaultGroupColor, 30, 0.2);
	cellElement.style.color = '#fff';
}

function getChildResourceCount(record) {
	let childResourceCount = 0;
	if (record.children && record.children.length > 0) {
		// Count only item resources (not planned/to be planned resources)
		childResourceCount = record.children.filter(child => child.get && child.get('isItem')).length;
	}
	return childResourceCount;
}

function createResourceIconSpan(backlogItemIconUrl, item) {
	if (!backlogItemIconUrl) return '';

	const isJira = item.fields?.tfsProjectId === undefined;
	const iconContent = isJira
		? `<span class="jira ${backlogItemIconUrl}"></span>`
		: `<img src="${backlogItemIconUrl}" class="azurico" alt="" />`;

	return `<span class="key fs-13">${iconContent}</span>`;
}

function createChildrenCountDisplay(unplannedCount, plannedCount, record, _this) {
	let childrenCountDisplay = '';

	// Check if this unplanned count is currently selected/highlighted
	const isUnplannedSelected = _this.unplannedGridMode &&
		_this.unplannedGridMode.mode === 'filtered' &&
		_this.unplannedGridMode.parentItemId === record.get('orgId');

	// Unplanned count (red, clickable)
	if (unplannedCount > 0) {
		const highlightClass = isUnplannedSelected ? 'unplanned-count-selected' : '';
		childrenCountDisplay += `
		<span class="unplanned-count DFA tooltip plncnt unpd mr-8 ${highlightClass}" onclick="event.stopPropagation(); roadmapVue.onShowUnplannedChildrenClick('${record.id}', '${record.get('orgId')}');">
			Unplanned: <span class="nbr DAJ">${unplannedCount}</span>
			<div class="hovtooltipBbtm sml">View Unplanned Child Items</div>
		</span>`;
	}

	// Planned count (green, clickable)
	if (plannedCount > 0) {
		childrenCountDisplay += `
		<span class="planned-count DFA tooltip plncnt plnd" onclick="event.stopPropagation(); roadmapVue.onShowPlannedChildrenClick('${record.id}', '${record.get('orgId')}');">
			Planned: <span class="nbr DAJ">${plannedCount}</span>
			<div class="hovtooltipBbtm sml">View Planned Child Items</div>
		</span>`;
	}

	return childrenCountDisplay;
}

function createToggleButton(record, _this) {
	// Get planned children count for this item
	const plannedCount = _this.plannedChildrenCountCache[record.get('orgId')] || 0;

	// Only show toggle button if there are planned children
	if (plannedCount > 0) {
		// Check if children are loaded and visible
		const itemResource = _this.$options.roadmap.resourceStore.getById(record.id);
		const childrenLoaded = itemResource ? itemResource.childrenLoaded : false;
		const childrenVisible = itemResource ? itemResource.childrenVisible : false;

		if (childrenLoaded) {
			// Children are loaded, show toggle arrow
			let toggleIcon = childrenVisible ? 'ti-angle-down' : 'ti-angle-right';
			let toggleTitle = childrenVisible ? 'Hide Planned Children' : 'Show Planned Children';
			const itemId = record.get("id").replace(/\\/g, '\\\\'); // Escape backslashes for HTML
			return `<div class="action-icon DFCB toggle-children" 
				 onclick="event.stopPropagation(); roadmapVue.toggleItemChildren('${itemId}');"
				 title="${toggleTitle}"
				 style="cursor: pointer; opacity: 1; margin-right: 8px;">
				<i class="${toggleIcon} ico"></i>
			</div>`;
		} else {
			// Children not loaded yet, show load button with arrow
			const itemId = record.get("id").replace(/\\/g, '\\\\'); // Escape backslashes for HTML
			return `<div class="action-icon DFCB load-children" 
				 onclick="event.stopPropagation(); roadmapVue.toggleItemChildren('${itemId}');"
				 title="Load Planned Children"
				 style="cursor: pointer; opacity: 1; margin-right: 8px;">
				<i class="ti-angle-right ico"></i>
			</div>`;
		}
	}

	return '';
}

function renderMilestoneEvent(eventRecord) {
	return `
		<div class=''>
			<span class='kendis-items-roadmap-item-title' style="margin-left: 20px;">
				${eventRecord.kendisKey}
			</span>
		</div>`;
}

function renderPhaseEvent(eventRecord) {
	return `
		<div class=''>
			<span href="javascript:void(0);" class='kendis-ir-item-key'>
				${eventRecord.kendisKey}
			</span>
			<span class='kendis-items-roadmap-item-title'>
				${eventRecord.title}
			</span>
		</div>`;
}

function renderHeaderEvent(event, _this) {
	const resourceId = event.eventRecord.resource.id;
	const isDefaultSection = resourceId === "null";
	const itemColor = getItemColor(event.eventRecord, _this);

	if (_this.groupBy.value === "Section") {
		return renderSectionHeader(event, resourceId, isDefaultSection, itemColor, _this);
	} else {
		return renderNonSectionHeader(event, itemColor, _this);
	}
}

function renderSectionHeader(event, resourceId, isDefaultSection, itemColor, _this) {
	const itemCount = _this.getSectionItemCount(resourceId);
	const titleClass = getTitleClass(itemColor);

	if (isDefaultSection) {
		return renderDefaultSectionHeader(event, resourceId, itemCount, titleClass);
	} else {
		return renderRegularSectionHeader(event, resourceId, itemCount, titleClass, _this);
	}
}

function renderDefaultSectionHeader(event, resourceId, itemCount, titleClass) {
	return `
		<div class='DFA'>
			<span class='kendis-items-roadmap-item-title elips ${titleClass}'>
				${event.eventRecord.title}
			</span>
			${itemCount > 0 ? `<div class='ml-10 ncntval DAJ' title="Number of items in this section">${itemCount}</div>` : ''}
			${createAddItemButton(resourceId)}
		</div>`;
}

function renderRegularSectionHeader(event, resourceId, itemCount, titleClass, _this) {
	const milestoneCount = _this.getSectionMilestoneCount(resourceId);

	return `
		<div class='DFA'>
			<span class='kendis-items-roadmap-item-title elips ${titleClass}'>
				${event.eventRecord.title}
			</span>
			${itemCount > 0 ? `<div class='ml-10 ncntval DAJ a' title="Number of items in this section">${itemCount}</div>` : ''}
			${createAddItemButton(resourceId)}
			${milestoneCount > 0 ? `<div class='ml-10 ncntval DAJ b' title="Number of milestones and phases in this section">${milestoneCount}</div>` : ''}
			${createAddMilestoneButton(resourceId)}
		</div>`;
}

function renderNonSectionHeader(event, itemColor, _this) {
	const titleClass = getTitleClass(itemColor);

	// Get proper item count based on current mode
	let itemCount = 0;

	if (_this.showIndividualItemResources) {
		// In "show children" mode, count child resources (item resources) under this group
		const groupResource = event.eventRecord.resource;
		if (groupResource && groupResource.children) {
			// Count child resources that are item resources (end with _item_)
			itemCount = groupResource.children.filter(child =>
				child.id && child.id.includes('_item_')
			).length;
		}
	} else {
		// In normal mode, use the existing logic
		const count = _this.$options.roadmap.assignmentStore.getAssignmentsForResource(event.eventRecord.resource).length;
		itemCount = count - 1; // Subtract 1 for the header event itself
	}

	return `
		<div class='DFA'>
			<span class='kendis-items-roadmap-item-title elips ${titleClass}'>
				${event.eventRecord.title}
			</span>
			${itemCount > 0 ? `<div class='ml-10 ncntval DAJ c' title="Number of items in this group">${itemCount}</div>` : ''}					
		</div>`;
}

function renderItemEvent(event, _this) {
	const item = _this.itemsByIdMap[event.eventRecord.get('orgId')];

	if (!item) {
		return renderDefaultEvent(event.eventRecord.data, _this);
	}

	const itemColor = getItemColor(event.eventRecord, _this);
	const backlogItemIconUrl = getBackLogItemIconUrl(item, _this.$root);
	const titleClass = getTitleClass(itemColor);

	const iconSpan = createIconSpan(backlogItemIconUrl, item);
	const keySpan = createKeySpan(item);
	const titleSpan = createTitleSpan(event.eventRecord.title, titleClass);

	// Add iteration indicator if dates come from iteration path
	const iterationIndicator = event.eventRecord.get('dateSource') === 'iteration'
		? '<span class="key azico ml-5">' + createAzureIcon() + '</span>'
		: '';

	// Add date adjusted alert indicator if dates were adjusted
	const dateAdjustedIndicator = event.eventRecord.get('dateAdjusted')
		? createDateAdjustedAlert()
		: '';

	return `
		<div class='DFA'>
			${iconSpan}
			${keySpan}
			${titleSpan}
			${iterationIndicator}
			${dateAdjustedIndicator}
		</div>`;
}

function renderChildItemEvent(event, _this) {
	const childItem = _this.itemsByIdMap[event.eventRecord.get('orgId')];

	if (!childItem) {
		return renderDefaultEvent(event.eventRecord.data, _this);
	}

	const itemColor = getItemColor(event.eventRecord, _this);
	const backlogItemIconUrl = getBackLogItemIconUrl(childItem, _this.$root);
	const titleClass = getTitleClass(itemColor);

	const iconSpan = createIconSpan(backlogItemIconUrl, childItem);
	const keySpan = createKeySpan(childItem);
	const titleSpan = createTitleSpan(event.eventRecord.title, titleClass);

	// Add iteration indicator if dates come from iteration path
	const iterationIndicator = event.eventRecord.get('dateSource') === 'iteration'
		? '<span class="key azico ml-5">' + createAzureIcon() + '</span>'
		: '';

	// Add date adjusted alert indicator if dates were adjusted
	const dateAdjustedIndicator = event.eventRecord.get('dateAdjusted')
		? createDateAdjustedAlert()
		: '';

	return `
		<div class='DFA child-item-event'>
			${iconSpan}
			${keySpan}
			${titleSpan}
			${iterationIndicator}
			${dateAdjustedIndicator}
		</div>`;
}

function renderDefaultEvent(eventRecord, _this) {
	const itemColor = getItemColor(eventRecord, _this);
	const titleClass = getTitleClass(itemColor);

	return `
		<div class='DFA'>
			<span class='kendis-items-roadmap-item-title elips ${titleClass}'>
				${eventRecord.title}
			</span>
		</div>`;
}

function getItemColor(eventRecord, _this) {
	const item = _this.itemsByIdMap[eventRecord.get('orgId')];
	return item?.fields?.Color || "";
}

function getTitleClass(itemColor) {
	return itemColor !== "" && isDarkColor(itemColor) ? 'whtclr' : '';
}

function createAddItemButton(resourceId) {
	return `
		<a class='add ico ti-plus addbtnw DAJ ml-10 aa' 
		   href='javascript:void(0);' 
		   onclick='roadmapVue.onClickCreateNew("${resourceId}"); event.stopPropagation();'
		   title="Add New Item to this Section">
		</a>`;
}

function createAddMilestoneButton(resourceId) {
	return `
		<a class='add ico ti-plus addbtnw DAJ ml-10 mlstn bb' 
		   href='javascript:void(0);' 
		   onclick='roadmapVue.showSectionMilestoneMenu("${resourceId}", event); event.stopPropagation();'
		   title="Add Milestone to this Section">
		</a>`;
}

function createIconSpan(backlogItemIconUrl, item) {
	if (!backlogItemIconUrl) return '';

	const isJira = item.fields?.tfsProjectId === undefined;
	const iconContent = isJira
		? `<span class="jira ${backlogItemIconUrl}"></span>`
		: `<img src="${backlogItemIconUrl}" class="azurico" alt="" />`;

	return `<span class="key azico">${iconContent}</span>`;
}

function createKeySpan(item) {
	const key = item ? generateKey(item) : '';
	const url = item?.url || '';

	return `<span href="${url}" class="kendis-ir-item-key">${key}</span>`;
}

function createTitleSpan(title, titleClass) {
	return `<span class='kendis-items-roadmap-item-title elips ${titleClass}'>${title}</span>`;
}

function renderBacklogItemTooltip(item, record, _this, options = {}) {
	if (!item) return null;

	// Default options
	const {
		showGroup = false,
		showDescription = false,
		groupName = null
	} = options;

	// Get item key and icon (same pattern as event tooltip)
	const backlogItemIconUrl = getBackLogItemIconUrl(item, _this.$root);
	const iconSpan = backlogItemIconUrl ?
		`<span>${item.fields?.tfsProjectId === undefined ? 
			`<span class="jira ${backlogItemIconUrl}"></span>` : `<img src="${backlogItemIconUrl}" class="azurico" alt="" />`}</span>` : '';
	const keyOutput = `${iconSpan} ${generateKey(item)}`;

	// Get status information
	const statusOutput = item.status ? item.status.title : 'No status';

	// Build tooltip using the same pattern as event tooltip
	let content = `<dl class="kendis-dl">
		<dt class="kendis-key-label"><span class="lbl">Key:</span> ${keyOutput}</dt>
		<dt class="kendis-title-label"><span class="lbl">Title:</span> ${item.title}</dt>`;

	// Add group information if requested
	if (showGroup && groupName) {
		content += `<dt class="kendis-group-label"><span class="lbl">Group:</span> ${groupName}</dt>`;
	}

	// Add status
	content += `<dt class="kendis-status-label"><span class="lbl">Status:</span> ${statusOutput}</dt>`;

	// Add description if requested
	if (showDescription && item.fields?.Description) {
		content += `<dt class="kendis-description-label"><span class="lbl">Description:</span> ${item.fields.Description}</dt>`;
	}

	// Only show iteration path for TFS accounts
	if (_this.almAccountType === 'tfs' && item.fields?.tfsIterationPath) {
		content += `<dt class="kendis-iteration-label"><span class="lbl">Iteration Path:</span> ${item.fields.tfsIterationPath}</dt>`;
	}

	// Add TFS iteration indicator if applicable
	if (record && record.get('dateSource') === 'iteration') {
		content += `<dt class="kendis-indicator-label"><span class="lbl">Note:</span> Uses ADO Iteration Path Dates ` + createAzureIcon('ml-5') + ` </dt>`;
	}

	// Add date adjustment indicator if applicable
	if (record && record.get('dateAdjusted')) {
		content += `<dt class="kendis-indicator-label"><span class="lbl">Warning:</span> Start date was after end date. End date adjusted to start date + 1 month.</dt>`;
	}

	content += `</dl>`;

	return content;
}

function renderItemResourceTooltip(record, _this) {
	// Get the item data from the record
	const itemId = record.get('orgId');
	const item = _this.itemsByIdMap[itemId];

	// Use the common tooltip renderer
	return renderBacklogItemTooltip(item, record, _this, {
		showGroup: false,
		showDescription: false
	});
}

function getItemsViewRoadmapConfig(roadmapComponent,project) {
    let _this = roadmapComponent;
    return {
		//milestone config
		// Available modes are :
		// 'default'  - no layout
		// 'data'     - from milestoneWidth
		// 'estimate' - length * char width
		// 'measure'  _ precise but slowest
		milestoneLayoutMode : 'data',
		infiniteScroll: true,

		// eventModelClass: BacklogItemModel,


		// Width per char in px when using 'estimate'
		milestoneCharWidth : 7,

		// How to align milestones in relation to their (start)date
		milestoneAlign : 'center',

		// Always render milestone as separate diamond ◆ + label
		// (can be toggled in the demo to stretch the milestone to fit the label in the diamond)
		milestoneTextPosition : 'always-outside',


		startDate: roadMapStartDate,
        endDate: roadMapEndDate,
        autoCreate: false,
        // Event sorter to show milestones and phases on top of items
		overlappingEventSorter: (a, b) => {
           //use ttype to sort

		   //iff its the header then header to top
		   if(a.get('isHeader') && !b.get('isHeader')){
			return -1;
		   }
		   if(!a.get('isHeader') && b.get('isHeader')){
			return 1;
		   }


		//    console.log(a.get('ttype'), b.get('ttype'));

		   //milestone and phase should appear on top of items
		   if((a.get('ttype') === "milestone" || a.get('ttype') === "phase") && b.get('ttype') === "item"){
			return -1;
		   }
		   if(a.get('ttype') === "item" && (b.get('ttype') === "milestone" || b.get('ttype') === "phase")){
			return 1;
		   }

		   // Parent items should appear on top of child items within the same resource
		   if(a.get('isParent') && !b.get('isParent')){
			return -1;
		   }
		   if(!a.get('isParent') && b.get('isParent')){
			return 1;
		   }

            // If both are milestones/phases or both are items, sort by start date
            return a.startDate - b.startDate;
        },
		useInitialAnimation : 'slide-from-left',
        // infiniteScroll: true,
        // subGridConfigs: {
        //     locked: {
        //         width: 50
        //     }
        // },
		// presets : [
		// 	PRESET_WEEK_ROADMAP,
		// 	PRESET_MONTH_ROADMAP,
		// 	PRESET_QUARTER_ROADMAP,
		// 	// PRESET_HALF_ROADMAP,
		// 	PRESET_YEAR_ROADMAP,
		// ],
        columns: [
			{
				text: `Groups`,
				field: 'name',
				type: 'tree',
				minWidth: 230,
				htmlEncode : false,
				resizable  : false,
				sortable : false,
				filterable : false,
				groupable: false,
				hideable: false,
				editor: false, //disabling the inline edit
				  // Hide default tree icons
				  expandedFolderIconCls  : null,
				  collapsedFolderIconCls : null,
				  leafIconCls            : null,
				beforeCellEditStart : ({record}) => {
					if(record.id===milestoneResourceId || record.id==="null"){
						return false;
					}
					return true;
				},
				finalizeCellEdit : ({value,oldValue,record}) => {
					if(record.id===milestoneResourceId || record.id==="null"){
						return "Cannot edit Milestones";
					}
					if(value.trim().length === 0){
						return "Section name cannot be empty";
					}
					if(_this.$options.roadmapSectionsCrud.checkNameExists(value.trim())){
						return "Section name already exists";
					}
					_this.$options.roadmapSectionsCrud.updateSectionName(record.id, value.trim());
					return true;
				},
				renderer: function (data) {
					const record = data.record;
					const resourceType = getResourceType(record, _this);

					// Handle different resource types with dedicated methods
					if (_this.showIndividualItemResources) {
						// NEW MODE: Enhanced styling
						switch (resourceType) {
							case 'itemResource':
								return renderItemResource(record, _this, data);
							case 'milestoneResource':
								return renderMilestoneResource(record, _this, data);
							case 'metaGroup':
								return renderMetaGroup(record, _this, data);
							case 'sectionGroup':
								return renderSectionGroup(record, _this, data);
							case 'defaultGroup':
								return renderDefaultGroup(record, _this, data);
							default:
								return renderDefaultGroup(record, _this, data);
						}
					} else {
						// OLD MODE: Enhanced styling with items resources
						switch (resourceType) {
							case 'itemsResource':
								return renderItemsResource(record, _this, data);
							case 'metaGroup':
								return renderMetaGroup(record, _this, data);
							case 'nonMetaGroup':
								return renderNonMetaGroup(record, _this, data);
							case 'milestoneResource':
								return renderMilestoneResource(record, _this, data);
							default:
								return renderOldModeResource(record, _this, data);
						}
					}
				},
				headerRenderer: ({ column }) => {
					const  {iconUrl,itemTypeName} = _this.issueTypeIconUrl(_this.roadmap.level);
					return iconUrl ? `<img src="${iconUrl}" alt="." class="FL mr-5 ml-5" style="width:16px;margin-top: -1px;" /> ${itemTypeName}` : `Groups`;
				}
			}
		],
		eventRenderer(event) {
			const eventRecord = event.eventRecord.data;
			const eventType = getEventType(eventRecord);

			// Handle different event types with dedicated methods
			switch (eventType) {
				case 'milestone':
					return renderMilestoneEvent(eventRecord);
				case 'phase':
					return renderPhaseEvent(eventRecord);
				case 'header':
					return renderHeaderEvent(event, _this);
				case 'childItem':
					return renderChildItemEvent(event, _this);
				case 'item':
					return renderItemEvent(event, _this);
				default:
					return renderDefaultEvent(eventRecord, _this);
			}
		},
        listeners: {

            //////////////////////////////////////////
            ///////     event listners
            // beforeEventDelete: function(event) {
            //  return false;
            // },
            // beforeDragCreate({ resource }) {
            //  // Prevent drag creating on the topmost resource
            //  return canEditTask;
            // },
			// renderRow(props) {
			// 	let resource = props.record;
			// 	props.row.element.style.backgroundColor = lightenHexColor(resource.color ? resource.color : defaultGroupColor,30,0.2);
			// },
			gridRowBeforeDragStart({ source, context, event }) {
				if(_this.showIndividualItemResources){
					return false;
				}
				if(_this.groupBy.value !== "Section" || context.records[0].id === milestoneResourceId || context.records[0].id === "null"){
					return false;
				}

				let record = context.records[0];
				return record.id !== milestoneResourceId|| record.id !== "null";
			},
			async gridRowBeforeDropFinalize({source, context, event}) {
				try {
					let nextSectionId = context.insertBefore ? context.insertBefore.id : null;
					if(nextSectionId==="null" || nextSectionId === "-1001"){
						context.valid = false;
						return
					}
					let draggedResourceId = context.records[0].id;
					let previousRecord
					if(nextSectionId) {
						previousRecord = roadmapVue.$options.roadmap.resourceStore.getPrev(nextSectionId);
					}else{
						previousRecord = roadmapVue.$options.roadmap.resourceStore.last
					}
					let previousResourceId = previousRecord &&
					(previousRecord.id !== milestoneResourceId || previousRecord.id === "null") ? previousRecord.id : null;
					_this.$options.roadmapSectionsCrud.updateSectionSequence(draggedResourceId, previousResourceId, nextSectionId);
					context.valid = true;
				} catch (e) {
					console.log(e);
					context.valid = false;
				}
			},

			// Tree node expansion listener - disabled since we use manual toggle
			// expandNode({ source, record }) {
			// 	// Only load children for top-level items (not groups or milestones)
			// 	if (record.get('isItem')  && !record.get('childrenLoaded')) {
			// 		_this.loadItemChildren(record);
			// 	}
			// },

		cellClick({record,column,event}) {
			let scheduler = _this.$options.roadmap;
			if (event.target.classList.contains('b-fa-pencil-alt')) {
				scheduler.features.cellEdit.startEditing({
					id: record.id,
					field: column.field
				});
				return
			}
			if (event.target.closest('.roadmap-arrow-show-resource-items') || event.target.closest('.resource-scheduler')) {
				if(record.id===milestoneResourceId){
					//toggle the milestone resource
					toggleResourceExpand(record, _this.groupBy.value, _this.$options.roadmap);
					scheduler.toggleCollapse(record);
					scheduler.refresh();
					return;
				}
				if (!record.eventLayout) {
					record.eventLayout = "stack";
				} else if (record.eventLayout === "none") {
					record.eventLayout = "stack";
				} else {
					record.eventLayout = undefined;
				}
				toggleResourceExpand(record, _this.groupBy.value, _this.$options.roadmap);
				scheduler.toggleCollapse(record);
				scheduler.refresh();
			}
		},

			beforeeventadd: ({ eventRecord }) => {
				if (!eventRecord.title) {
					eventRecord.title = 'New item';
				}
			},

			eventClick: function (event) {
                let eventRecord = event.eventRecord;
                let resourceRecord = event.resourceRecord;
				let scheduler = _this.$options.roadmap;
                let itemId = eventRecord.get('isChild')?_this.getChildItemId(eventRecord.id):eventRecord.id.split('_')[0];
				if( eventRecord.get('isHeader')){
					toggleResourceExpand(eventRecord.resource,_this.groupBy.value,_this.$options.roadmap);
					scheduler.toggleCollapse(eventRecord.resource);
					return;
				}
                if(_this.itemsByIdMap[itemId]){
					// Use the common method to open the item edit popup
					_this.openItemEditPopup(eventRecord, resourceRecord, itemId);
	                }else if(_this.milestoneMapById[itemId]){
						let item = _this.milestoneMapById[itemId];
						if (item) {
		                    item = _.cloneDeep(item);
		                    _this.onCreateMilestonePopup(null, item);
		                }
					}
            },
            eventResizeEnd: function (event) {
                let startDate = event.eventRecord.startDate;
                let endDate = event.eventRecord.endDate;
                let itemId = event.eventRecord.get('orgId');
                if(_this.itemsByIdMap[itemId]){
					let item = _this.itemsByIdMap[itemId];
	                if (item) {
	                    item = _.cloneDeep(item);
	                    if (!item.fields) {
	                        item.fields = {};
	                    }
						item._fields = {}
						if(item.fields.StartDate){
							item._fields.StartDate = item.fields.StartDate;
						}
						if(item.fields.EndDate){
							item._fields.EndDate = item.fields.EndDate;
						}
	                    let changes = {
	                        date: {
	                            startDate: startDate,
	                            endDate: endDate,
	                        }
	                    }
	                    _this.itemEditPopup.eventRecord = event.eventRecord;
	                    _this.itemEditPopup.changes = changes;
	                    _this.itemEditPopup.item = item;
	                    _this.itemEditPopup.show = true;
	                }
					
				}else if(_this.milestoneMapById[itemId]){
							
						let item = _this.milestoneMapById[itemId];
						
						if (item) {
		                    item = _.cloneDeep(item);
		
		                    if (!item.fields) {
		                        item.fields = {};
		                    }
		                    item.fields.StartDate = startDate;
		                    item.fields.EndDate = endDate;

		                    let changes = {
		                        date: {
		                            startDate: startDate,
		                            endDate: endDate,
		                        }
		                    }
		                     _this.itemEditPopup.eventRecord = event.eventRecord;
		                    _this.itemEditPopup.changes = changes;
		                    _this.itemEditPopup.item = item;
		                    _this.itemEditPopup.show = true;
		                }
						
					}
                
            },
            afterEventDrop: function (event) {},
			beforeEventDropFinalize: function (event) {
				const { startDate, endDate, newResource, resourceRecord: oldResource, eventRecord } = event.context;
				const targetItem = _this.getTargetItem(eventRecord);
				const eventType = _this.getEventType(eventRecord);

				// Validate drag operation based on event type
				if (!_this.validateDragOperation(event, eventRecord, newResource, oldResource, eventType)) {
					event.context.valid = false;
					return;
				}

				// Handle the drop based on grouping and event type
				_this.handleEventDrop(event, eventRecord, newResource, oldResource, targetItem, startDate, endDate);
			},
			beforeDragCreate:function({source,resourceRecord,date}){
				if([groupByValues.Section].includes(_this.groupBy.value)  || resourceRecord.id === milestoneResourceId){
					return true;
				}
				showBryntumToastMessage("Item creation not supported here","warning");
				return false;
			},
            beforeDragCreateFinalize: function (event) {

                console.log("trigered beforeDragCreateFinalize");
                let eventRecord = event.eventRecord;
                let resourceRecord = event.resourceRecord;
                let elementRect = event.eventElement.getBoundingClientRect();
                if(resourceRecord.id === milestoneResourceId){
					_this.onCreateMilestonePopup();
				}else {
					_this.addToBoardPopup.position = {left: elementRect.left, top: elementRect.top};

	                if (!_.isEmpty(_this.store.almAccounts)) {
	                    _this.addToBoardPopup.alm = _this.store.almAccounts[0];
	                }
	                _this.addToBoardPopup.boardItems = _.map(_this.$options.roadmap.eventStore.allRecords, rcd => rcd.id);
	                _this.addToBoardPopup.item = {startDate: event.context.startDate, endDate: event.context.endDate};

	                if(resourceRecord && resourceRecord.id && resourceRecord.id !== "null"){
						_this.addToBoardPopup.item.objectId = resourceRecord.id;
					}

	                _this.addToBoardPopup.eventRecord = eventRecord;
	                _this.addToBoardPopup.resourceRecord = resourceRecord;
	                _this.addToBoardPopup.level = parseInt(_this.roadmap.level);
					_this.onAddToBoardPopupCreateNew( _this.addToBoardPopup.item)
	                // _this.addToBoardPopup.show = true;
				}
				event.context.finalize(false); //remove the created event on drag
				// expandResource(_this.$options.roadmap,resourceRecord,_this.groupBy.value)
			}

        },
		onCollapseNode({ record }) {
			record.expanded = false;
			let groupId = record.id;
			_this.$options.roadmap.eventStore.filter({
				id: `filter-${groupId}-${_this.groupBy.value}`,
				filterBy: event => event.id.includes('full-span-event') ||
					(event.resource && event.resource.id !== groupId),
			});
		},
		onExpandNode({ record }) {
			record.expanded = true;
			let groupId = record.id;
			_this.$options.roadmap.eventStore.removeFilter(`filter-${groupId}-${_this.groupBy.value}`);
		},

		eventStyle: 'rounded',
        features: {
			eventDragCreate:false,
			eventDrag:{
				showTooltip:false,
			},
			tree: true, // Enable tree structure for resources
			pdfExport : {
				exportServer :  `${window.location.origin}/proxy/pdf-export/roadmaps`, // Required
				translateURLsToAbsolute : window.location.origin,  // Use current base URL dynamically
				alignRows: true,
				paperFormat:'A0',
				rowsRange : 'all',
				scheduleRange:'currentview',
				orientation: 'portrait',
				fetchOptions : {
					credentials : 'include',
					headers : {
						'X-CSRF-TOKEN': document.querySelector('meta[name="_csrf"]').getAttribute('content'),
						'X-Requested-With': 'XMLHttpRequest',
						'Content-Type': 'application/json;charset=UTF-8',
					}
				},
				showErrorToast:false,
				sendAsBinary : true,

			},
			scheduleTooltip : false,
			scrollButtons : {
				labelRenderer({ resourceRecord, isBefore, nbrEvents }) {
					return `${nbrEvents}`;
				}
			},
			cellTooltip : {
				hideOnDelegateChange : true,
				forSelector:'a.key',
				tooltipRenderer : ({ record, column }) => {
						let content = '';
					try{



						const resourceType = getResourceType(record, _this);

						// Handle different resource types with dedicated methods
						if (_this.showIndividualItemResources) {
							// NEW MODE: Enhanced styling
							switch (resourceType) {
								case 'itemResource':
									return renderItemResourceTooltip(record, _this);

								default:
									return record[column.field]
							}
						} else {
							content = record[column.field]
						}
						return content;
					} catch (e) {
						console.log(e);
						showTopMessage("Something went wrong", 'warning');
						return content;
					}
				},
				hoverDelay      : 1000,
				hideOnDelegateChange : true

			},
			eventTooltip: {
				hideOnDelegateChange : true,
				hoverDelay      : 1000,
				template: (data) => {
					if (data.eventRecord.get('isHeader')) {
						return `<dl class="kendis-group-header"><dd>${data.eventRecord.title}</dd></dl>`;
					}

					const isItem = data.eventRecord.get('ttype') === "item" ||
					 data.eventRecord.get('ttype') === "child_item";
					const item = isItem ? _this.itemsByIdMap[data.eventRecord.get('orgId')] : null;

					// For items, use the common tooltip renderer
					if (isItem && item) {
						const groupOutput = data.eventRecord.resource?.name || 'No group';
						let content = renderBacklogItemTooltip(item, data.eventRecord, _this, {
							showGroup: false,
							showDescription: false,
							groupName: groupOutput
						});

						// Add time information for events
						let itemMilestone = _this.milestoneMapById[data.eventRecord.get('orgId')];
						let timeOutput;
						if(itemMilestone && itemMilestone.fields.itemType === "Milestone"){
							timeOutput = data.eventRecord.startDate && data.eventRecord.endDate ?
								`${vueInstance.$options.ROADMAP_MODULE.DateHelper.format(data.eventRecord.startDate, 'MMMM D, YYYY')}`
								: 'Date(s) not available';
						}else{
							timeOutput = data.eventRecord.startDate && data.eventRecord.endDate ?
								`${vueInstance.$options.ROADMAP_MODULE.DateHelper.format(data.eventRecord.startDate, 'MMMM D, YYYY')} - ${vueInstance.$options.ROADMAP_MODULE.DateHelper.format(data.eventRecord.endDate, 'MMMM D, YYYY')}`
								: 'Date(s) not available';
						}

						// Insert time information before closing dl tag
						content = content.replace('</dl>', `<dt class="kendis-time-label"><span class="lbl">Planned Date:</span> ${timeOutput}</dt></dl>`);
						return content;
					}

					// For non-items (milestones, etc.), use the original logic
					const keyOutput = data.eventRecord.get('kendisKey');
					let itemMilestone = _this.milestoneMapById[data.eventRecord.get('orgId')];

					let timeOutput;
					if(itemMilestone && itemMilestone.fields.itemType === "Milestone"){
						timeOutput = data.eventRecord.startDate && data.eventRecord.endDate ?
							`${vueInstance.$options.ROADMAP_MODULE.DateHelper.format(data.eventRecord.startDate, 'MMMM D, YYYY')}`
							: 'Date(s) not available';
					}else{
						timeOutput = data.eventRecord.startDate && data.eventRecord.endDate ?
							`${vueInstance.$options.ROADMAP_MODULE.DateHelper.format(data.eventRecord.startDate, 'MMMM D, YYYY')} - ${vueInstance.$options.ROADMAP_MODULE.DateHelper.format(data.eventRecord.endDate, 'MMMM D, YYYY')}`
							: 'Date(s) not available';
					}

					return `<dl class="kendis-dl">
						<dt class="kendis-key-label"><span class="lbl">Key:</span> ${keyOutput}</dt>
						<dt class="kendis-title-label"><span class="lbl">Title:</span> ${data.eventRecord.title}</dt>
						<dt class="kendis-time-label"><span class="lbl">Planned Date:</span> ${timeOutput}</dt>
					</dl>`;
				}
			},
			scheduleMenu: false,//disabling the scheduler menus

			columnLines: false,
			rowReorder : {
				showGrip : true,
				gripOnly : false,
			},
			cellMenu : {
				processItems: ({record, items}) => {
					// When showIndividualItemResources is true, only show cell menu on section resources
					if (_this.showIndividualItemResources) {
						// Check if this is a section resource (not an item resource)
						const isSectionResource = record.id === "null" ||
							(record.id !== milestoneResourceId &&
							 !record.id.includes('_item_') &&
							 _this.groupBy.value === groupByValues.Section);

						if (!isSectionResource) {
							// Hide all menu items for item resources
							delete items.addSection;
							delete items.editSection;
							delete items.removeRow;
							return items;
						}
					}

					// When showIndividualItemResources is false and grouped by section, hide cell menu on items resources
					if (!_this.showIndividualItemResources && _this.groupBy.value === groupByValues.Section) {
						// Check if this is an items resource (where items of the section exist)
						const isItemsResource = record.id.includes('_items');

						if (isItemsResource) {
							// Hide all menu items for items resources
							delete items.addSection;
							delete items.editSection;
							delete items.removeRow;
							return items;
						}
					}

					// Check if the record is a milestone or should be treated specially
					if (_this.groupBy.value!==groupByValues.Section){
						delete items.addSection;
						delete items.editSection;
						delete items.removeRow;
						return items;
					}
					if (record.id === milestoneResourceId ) {
						// Remove certain options for special cases
						delete items.editSection;
						delete items.removeRow;
					}
					if(record.id === "null"){
						delete items.removeRow;
					}
					return items;
				},
				items : {
					addSection : {
						text : 'Add Section',
						icon : 'b-fa b-fa-fw b-fa-plus',
						weight : 1,
						onItem: ({ record }) => {
							if (record.id === milestoneResourceId) return;

							let nextResource = roadmapVue.$options.roadmap.resourceStore.getNext(record.id);
							let newSequence = nextResource ? (record.sequence + nextResource.sequence) / 2 : record.sequence + 1.0;

							if (record.id === "null") {
								newSequence = nextResource ? nextResource.sequence - 0.1 : 1.0;
							}

							let newSection = {
								name: roadmapComponent.$options.roadmapSectionsCrud.getNewSectionName(),
								parentRoadmapId: _this.roadmap.id,
								sequence: newSequence,
							};

							roadmapComponent.$options.roadmapSectionsCrud.addSection(newSection,roadmapVue.$options.roadmap.resourceStore.indexOf(record));
						}
					},
					editSection:{
						html : 'Edit Section',
						icon : 'b-fa b-fa-fw b-fa-edit',
						weight : 2,
						onItem: ({ record }) => {
							if (record.id === milestoneResourceId ) return;
							//open popup
							if( record.id === "null"){
								roadmapComponent.sectionPopup.section = roadmapComponent.$options.roadmapSectionsCrud.getDefaultSection()
							}else{
								roadmapComponent.sectionPopup.section = roadmapComponent.$options.roadmapSectionsCrud.getSectionById(record.id);
							}
							roadmapComponent.sectionPopup.show = true;

						}
					},
					removeRow : {
						text : 'Remove Section',
						icon : 'b-fa b-fa-fw b-fa-trash',
						weight : 3,

						onItem : async ({record}) => {
							if (record.id === "-1001" || record.id === "null") {
								return
							}
							const result = await vueInstance.$options.ROADMAP_MODULE.MessageDialog.confirm({
								title: 'Confirm Removal',
								message: 'Are you sure you want to remove this section?',
								okButton: 'Yes',
								cancelButton: 'No',
								cls:'remove-section-confirm-popup'
							});

							if (result === vueInstance.$options.ROADMAP_MODULE.MessageDialog.okButton) {
								roadmapComponent.$options.roadmapSectionsCrud.removeSection(record);
								showBryntumToastMessage(`Section removed.`,"success");
							} else {
								showBryntumToastMessage(`Removal cancelled.`,"success");
							}
						}
					}
				}
			},
            stripe: true,
			columnAutoWidth: true,
			// lockRows : {
			// 	filterFn : r => r.id === '-1001'
			// },
			    eventMenu: {
				processItems({ eventRecord, items }) {
					if(eventRecord.get('isHeader')){
						return false;
					}
					const isChildItem = eventRecord.get('isChild') || eventRecord.id.includes('_child_');

					// Hide "Move to Section" for child items in individual item resources mode
					if (_this.showIndividualItemResources) {
						if (isChildItem) {
							delete items.linkToRoadmapSection;
							console.log('Hidden "Move to Section" for child item:', eventRecord.title);
						}
					}

					// let itemMilestone = _this.milestoneMapById[eventRecord.get('orgId')];
					// if (!_.isEmpty(itemMilestone) || eventRecord.ttype === "group") {
					// 	return false;
					// }
					if(_.isEmpty(_this.milestoneMapById)){
						delete items.linkedMilestones;
						delete items.linkToMilestone;
					}else{
						let item = _this.itemsByIdMap[eventRecord.get('orgId')];
						if (!_.isEmpty(item) && !_.isEmpty(item.milestoneRelations)) {
							let taskIds = item.milestoneRelations.map(milestone => milestone.baseItemId);
							items.linkToMilestone.menu = items.linkToMilestone.menu.filter(menu => !taskIds.includes(menu.milestoneId));
							items.linkedMilestones.menu = items.linkedMilestones.menu.filter(menu => taskIds.includes(menu.milestoneId));

							if (_.isEmpty(items.linkToMilestone.menu)) {
								delete items.linkToMilestone;
							}
							if (_.isEmpty(items.linkedMilestones.menu)) {
								delete items.linkedMilestones;
							}
						} else {
							delete items.linkedMilestones;
						}
					}

					// Remove the link to roadmap section option if the group by is not section
					// But allow it for milestones and phases when grouped by Section
					let isMilestoneOrPhase = eventRecord.get('ttype') === 'milestone' || eventRecord.get('ttype') === 'phase';

					if(_this.groupBy.value !== groupByValues.Section){
						delete items.linkToRoadmapSection;
					}else{
						if(isChildItem){
							delete items.linkToRoadmapSection;
						}
						else{

						// Show "Move to Section" for both items and milestones/phases
						// Use the ID utils to extract the current section ID
						let currentSectionId = _this.$options.idUtils.getCurrentSectionIdFromEvent(eventRecord);

						if(currentSectionId==="null"){
							items.linkToRoadmapSection.menu.items = items.linkToRoadmapSection.menu.items.filter( menu => !menu.defaultSection );
						}else{
							items.linkToRoadmapSection.menu.items = items.linkToRoadmapSection.menu.items.filter(menu => menu.sectionId !== currentSectionId);
						}
						if (_.isEmpty(items.linkToRoadmapSection.menu.items)) {
							delete items.linkToRoadmapSection;
						}

						// Update the text based on event type
						if (isMilestoneOrPhase) {
							items.linkToRoadmapSection.text = 'Move Milestone to Section';
							delete items.linkedMilestones;
							delete items.linkToMilestone;
							delete items.unassignEvent;
						} else {
							items.linkToRoadmapSection.text = 'Move to Section';
						}
					}

					}
				},
                items: {
                    // Custom item with inline handler
                    editEvent: false, // Disable edit option
                    deleteEvent: false, // Disable delete option
                    addEvent: false, // Disable add event option
                    cutEvent: false, // Disable cut option
                    copyEvent: false, // Disable cut option
                    splitEvent: false, // Disable cut option
					unassignEvent: {
                        text: 'Plan Later',
                        icon: 'b-fa b-fa-fw b-fa-arrow-circle-right',
                        weight: 200,
                        onItem: ({eventRecord, resourceRecord}) => {
							if(!_this.showIndividualItemResources){
								// Legacy mode: Use existing unassign method
								let schedule = _this.$options.roadmap;
								let unplannedGrid = _this.$options.unplannedGrid;
								const relatedEvents =  _this.$options.roadmap.eventStore.allRecords
									.filter(event => event.get('orgId') === eventRecord.get('orgId'));
								for(let event of relatedEvents){
									schedule.assignmentStore.remove(
										schedule.assignmentStore.getAssignmentsForEvent(eventRecord)
									);
								}
								_this.handleUnassignPlannedEvent(relatedEvents, schedule, unplannedGrid);
								console.log(`Event '${eventRecord.title}' has been unassigned`);
							} else {
								// New mode: Handle parent vs child items differently
								_this.handleUnassignInIndividualMode(eventRecord, resourceRecord);
							}
                        }
                    },
                    linkToMilestone: {
						
						text   : 'Link New Milestone',
					    icon   : 'b-fa b-fa-fw b-fa-link',
                		cls    : 'b-separator',
                        weight : 540,
                        menu   : [],
                        onItem({ eventRecord }) {
                            
                        }
						
					},
					linkedMilestones: {
						text: 'Linked Milestones',
						icon: 'b-fa b-fa-fw b-fa-link',
						cls: 'b-separator',
						weight: 541,
						menu: [],
						onItem({ eventRecord }) {
						}
					},
					linkToRoadmapSection:{
						text : 'Move to Section',
						icon : 'b-fa b-fa-fw b-fa-link',
						cls : 'b-separator',
						weight : 542,
						menu : {
							 // height : '400px',
							items:[]
						},
					}
                },
            },
            eventEdit: {
                items: {
                    // Custom field for picking icon
                    iconCls: {
                        type: 'iconcombo',
                        // Name should match a record field, to read and write value from that field
                        name: 'iconCls',
                        label: 'Icon',
                        weight: 200
                    }
                }
            },
            dependencies: false,
            timeRanges: {
				showHeaderElements: true, // Set to true if you want markers in the header as well
                showCurrentTimeLine: {name:getFormattedDate(new Date())}, // Optional, depending on whether you want the current time line
            }
        },
        timeRanges: _this.getTimeRanges(),
        timeAxis: {mainUnit: 'day', autoAdjust: false},
        viewPreset: {
			base              : 'dayAndWeek',
			tickWidth         : 40,
			displayDateFormat : 'LL',
			timeResolution    : {
				increment : 1,
				unit      : 'd'
			},
			headers : [
				{
					unit       : 'w',
					align      : 'start',
					dateFormat : 'LL'
				},
				{
					unit       : 'd',
					align      : 'center',
					dateFormat : 'DD'
				}
			]
		},
        rowHeight: 80,
        barMargin: 20,
        project: project,
        insertFirst: "roadmap",
		splitterWidth: 2,

        // startDate  : new Date(2023, 11, 1, 8),
        // endDate    : new Date(2025, 11, 1, 18),


    }
}
function countPlannedItem(resource){
	let plannedCount = 0;
	if(!_.isEmpty(resource.groupItems)){
		for(let item of resource.groupItems){
			if((item && item.fields && item.fields.StartDate && item.fields.EndDate)
				|| (item.timeCapsuleRelation && item.timeCapsuleRelation.customId)) {
				plannedCount++;
				totalPlannedCount++;
			}
		}
	}
	return plannedCount;
}
function getUnplannedGridConfig(_this,project){
	return {
		ref         : 'unplanned',
		appendTo    : 'roadmap',
		title       : 'Unplanned Items',
		collapsible : true,
		flex 		: '0 0 300px',
		ui          : 'toolbar',
		emptyText	: 'No Items',
		cls			: styledClasses.collectionGrid,
		collapsed	: true,
		project 	: project,
		store   	: {
			modelClass	: 	Task,
			data		:	[],
		},
		readOnly : true,
		onCollapse({ source : Panel }) {
			_this.showUnplannedGroupBy = false;

		},
		onExpand({ source : Panel }) {
			if(!_this.$options.firstOpenUnplannedGrid  && !_this.isGridChildMode){
				_this.$options.firstOpenUnplannedGrid = true;
				_this.loadUnplannedOnClick();
			}
			// Only show group by when not in grid child mode
			if (!_this.isGridChildMode) {
				_this.showUnplannedGroupBy = true;
				// Initialize and populate the group by combo in the grid toolbar
				_this.initUnplannedGridGroupBy();
			}
		},

		listeners	:{


			expandNode({ source, record }) {
				let groupIdToLoad = record.id;
				if(record.children===true){
					_this.loadUnplannedOnClick(groupIdToLoad);
				}
			},
			cellClick: function({record, column, cellElement, event}) {

				// if(record.isGroup){
				// 	if (event.target.closest('.unplanned-group-cls')) {
				// 		//expand node
				// 		if (record.isExpanded() === false) {
				// 			if (record.children === true) {
				// 				_this.loadUnplannedOnClick(record.id);
				// 			}
				// 			_this.$options.unplannedGrid.expand(record);
				// 		} else {
				// 			_this.$options.unplannedGrid.collapse(record);
				// 		}
				// 	}
				// 	return
				// }
				if(record.isGroup){
					return
				}

				// Disable cell click functionality - no longer opens edit popup
				// let itemId = record.id.split('_')[0];
				// let item = _this.itemsByIdMap[itemId];

				// if (item) {

				// 	item = _.cloneDeep(item);
				// 	_this.itemPopup.eventRecord = record;
				// 	_this.itemPopup.origin = itemPopupOrigins.UNPLANNED
				// 	// _this.itemPopup.resourceRecord = resourceRecord;
				// 	_this.itemPopup.item = item;

                //     _this.itemPopup.parent = undefined;
				// 	let itemLevel = getHierarchyLevelForItem(record, _this.itemsByIdMap, _this.releaseTrain, _this.store.backlogHierarchyLevels, _this.currentHierarchyLevel);
				// 	_this.itemPopup.level = itemLevel;

				// 	_this.itemPopup.alm = undefined;
				// 	_this.itemPopup.tfsProjects = undefined;
				// 	if (!_.isEmpty(_this.store.almAccounts)) {
				// 		_this.itemPopup.alm = _this.store.almAccounts[0]
				// 	}
				// 	if (_this.store.tfsProjects) {
				// 		_this.itemPopup.tfsProjects = _this.store.tfsProjects;
				// 	}

				// 	_this.itemPopup.show = true;
				// }
			},
			remove: function({records}) {
				if(	_this.isdragRemoveFromGrid ){
					_this.isdragRemoveFromGrid = false;
					return
				}
				//unlink item from board
				let item = records[0];
				if (item) {
					askFromSweetAlertWrapper("Do you want to unlink this item from the board?",
						[function () {

							let requestBody = {
								"boardId": _this.roadmap.id,
								"artId": _this.releaseTrain.id,
								"backlogItemsIds": [item.id]
							};
							axios.put('/roadmap/unlink-backlog-item-from-board', requestBody).then(response => {
								if (response.status === 200 && response.data.message) {
									// alertFromSweetAlertWrapper(response.data.message);
								}
							});
						}], [function () {
							unplannedGrid.store.add(item);
							console.log("Item re-added to the grid since no option was selected.");
						}]);
				}

			}
		},
		strips		: {
			right: {
				cls: 'kendis-grid-stripes',
				type: 'panel',
				dock: 'top',
				// collapsible : true,
				items: [
					{
						type: 'toolbar',
						cls: 'kendis-search-addbutton-toolbar',
						// hideWhenEmpty: true,
						items: [
							{
								type: 'text',
								ref: 'searchField',
								clearable: true,
								cls: 'kendis-grid-search',
								label: '<i class="b-icon b-icon-search"></i>',
								flex: 1,
								placeholder:'Search...',
								// hidden: true,
								// onInput  : () => {
								// 	const searchField = _this.$options.unplannedGrid.widgetMap.searchField;
								// 	_this.$options.unplannedGrid.features.search.search(searchField.value)
								// }
								onChange: () => {
									try {
										const searchField = _this.$options.unplannedGrid.widgetMap.searchField;

										// Get the trimmed and lowercased search value
										const searchValue = searchField.value.trim().toLowerCase();

										_this.unplannedFilter.searchText = searchValue;

										// Check if we're in grid child mode (filtered mode)
										if (_this.isGridChildMode) {
											// Use local search only - filter the current grid data
											if (searchValue === '') {
												// If search is empty, restore the original filtered data
												const parentItemId = _this.unplannedGridMode.parentItemId;
												const unplannedChildren = _this.unplannedChildrenCache[parentItemId] || [];
												const gridData = unplannedChildren.map(child => ({
													id: `${child.id}_unplanned`,
													_id: `${child.id}_unplanned`,
													title: child.title,
													status: child.status || { title: "unplanned" },
													statusClass: child.statusClass || 'unplanned',
													orgId: child.id,
													isGroup: false,
													searchableKey: _this.generateSearchableKey(child),
													isChild: true,
													cls: styledClasses.rawViewUnplannedItems
												}));
												_this.$options.unplannedGrid.store.removeAll();
												_this.$options.unplannedGrid.store.add(gridData);
											} else {
												// Filter the current grid data locally
												const currentData = _this.$options.unplannedGrid.store.allRecords;
												const filteredData = currentData.filter(item => {
													const title = item.title?.trim().toLowerCase();
													const searchableKey = item.searchableKey?.trim().toLowerCase();
													return title?.includes(searchValue) || (searchableKey && searchableKey.includes(searchValue));
												});
												_this.$options.unplannedGrid.store.removeAll();
												_this.$options.unplannedGrid.store.add(filteredData);
											}
										} else {
											// Normal mode - use backend search
											if(searchValue === ''){
												_this.loadUnplannedOnClick();
												return
											}
											_this.loadUnplannedOnClick();
										}

									} catch (e) {
										console.log(e);
										showTopMessage("Something went wrong", 'warning');
									}
								}
							},
							{
								type: 'combo',
								ref: 'groupByCombo',
								cls: 'kendis-grid-groupby',
								label: '',
								width: 150,
								displayField: 'title',
								valueField: 'id',
								store: {
									data: [] // Will be populated from _this.groupBy.options
								},
								placeholder: 'Select Group',
								hidden: _this.isGridChildMode, // Hide when in filtered mode
								onChange: ({ value }) => {
									// Update the groupByUnplanned value and trigger the change
									_this.groupByUnplanned.value = value;
									_this.onGroupBySelectValueUnplanned();
								}
							},
							{
								type: 'button',
								ref: 'resetButton',
								text: 'Reset',
								cls: 'kendis-reset-button',
								tooltip: 'Reset to show all unplanned items',
								hidden: true, // Initially hidden, shown when in filtered mode
								onClick: () => {
									_this.resetUnplannedGrid();
								}
							},
						]
					},
				]
			}

		},
		features 	: {
			tree : true,
			stripe 	: true,
			sort   	: 'name',
			search	: true,
			filter	: false,
			cellTooltip: {
				hoverDelay: 1000,
				hideOnDelegateChange : true,
				tooltipRenderer : (data) => {
					let content = '';
					try{
						// Skip tooltips for group rows
						if (data.record.get('isGroup')) return null;

						// Get the actual item data
						const itemId = data.record._id.split('_')[0];
						const item = _this.itemsByIdMap[itemId];

						// Get group information
						const groupOutput = data.record.get('parentGroupName') || 'No group';

						// Use the common tooltip renderer
						content = renderBacklogItemTooltip(item, data.record, _this, {
							showGroup: false,
							showDescription: true,
							groupName: groupOutput
						});
					} catch (e) {
						console.log(e);
						showTopMessage("Something went wrong", 'warning');
					}
					return content;
				}
			},

			// group 	: {
			// 	field: '-1',
			// 	collapseIconCls: '',
			// 	expandIconCls: '',
			// 	renderer: ({ isFirstColumn, count, groupRowFor, record }) => {
			// 		if (!isFirstColumn) return '';
			//
			// 		const groupByValue = _this.groupBy.value;
			// 		// const getGroupTitle = (group) => group ? `${group.title} (${count})` : '...';
			//
			// 		if (!groupRowFor || groupRowFor === "null" || groupRowFor === "!!novalue!!") {
			// 			return `No Group (${count})`;
			// 		}
			//
			// 		if (metaDependantGroups.includes(_this.groupBy.value)){
			// 			let groupTitle = _this.getGroupTitleFromMeta(groupRowFor);
			// 			return groupTitle ? `${groupTitle} (${count})` : '...';
			// 		}
			//
			// 		switch (groupByValue) {
			// 			case "Parent":
			// 				const parent = _this.$options.itemsParentsMap.get(groupRowFor);
			// 				let generatedKey= generateKey(parent);
			// 				if(generatedKey && generatedKey!==''){
			// 					return parent ? `
			// 				<div class="val prow">
			// 					<span class="key fs-13">${generatedKey}</span>
			// 					<span> ${parent.title} (${count})</span>
			// 				</div>` : '...';
			// 				}else{
			// 					return parent ? `${parent.title} (${count})` : '...';
			// 				}
			//
			// 			case "Section":
			// 				const section = _this.$options.roadmapSectionsCrud.getSectionById(groupRowFor);
			// 				return section ? `${section.name} (${count})` : '...';
			// 			case groupByValues.kendisStatus:
			// 				return groupRowFor ? `${groupRowFor} (${count})` : '...';
			// 			default:
			// 				return groupRowFor ? `${groupRowFor} (${count})` : '...';
			// 		}
			// 	}
			// },
			cellMenu : {
				items: {
					removeRow: false, // Disable edit option
					cut: false, // Disable delete option
					copy: false, // Disable add event option
					paste: false, // Disable cut option
					search: false, // Disable cut option
					planItem: {
						text: 'Plan Item',
						icon: 'b-fa b-fa-fw b-fa-calendar-plus',
						weight: 200,
						onItem: ({record}) => {
							roadmapVue.planUnplannedItem(record);
						}
					},
				}
			}
		},
		// bbar:getPaginationToolBarConfig(_this),
		// Add tooltip feature for unplanned grid items


		columns 	: [
			{
				text       : ' ',
				flex       : 1,
				field      : 'title',
				type : 'tree',
				htmlEncode : false,
				cls: 'kendis-grid-item-column',
				// enableCellContextMenu: false,
				sortable : false,
				filterable : false,
				groupable: false,
				hideable: false,

				renderer: function (unplannedTask) {

					if(unplannedTask.record.get('isGroup')){
						let title = _this.generateGroupName(unplannedTask.record.id);
						// Safety check for title
						if (!title || title === 'undefined' || title === 'null') {
							console.warn(`Invalid group title for ${unplannedTask.record.id}:`, title);
							title = 'Unknown Group';
						}

						let count = 0;
						let showCount = false;

						// Debug logging for count issues
						console.log(`Group count debug for ${unplannedTask.record.id}:`, {
							children: unplannedTask.record.children,
							count: unplannedTask.record.count,
							childrenType: typeof unplannedTask.record.children,
							isArray: Array.isArray(unplannedTask.record.children)
						});

						// Handle different count scenarios safely
						if (unplannedTask.record.children === true) {
							// Children are loaded but not expanded
							if (unplannedTask.record.count !== undefined && unplannedTask.record.count !== null) {
								count = unplannedTask.record.count;
								showCount = true;
							}
						} else if (Array.isArray(unplannedTask.record.children)) {
							// Children array is available
							count = unplannedTask.record.children.length;
							showCount = true;
						}

						// Only show count if it's valid and greater than 0
						if (showCount && count > 0 && count !== undefined && count !== null && !isNaN(count)) {
							console.log(`Showing count for group ${unplannedTask.record.id}: ${count}`);
							return `<div class="unplanned-group-cls elips">${title} (${count})</div>`;
						} else {
							// Show title without count when count is invalid or 0
							console.log(`No count shown for group ${unplannedTask.record.id} - count: ${count}, showCount: ${showCount}`);
							return `<div class="unplanned-group-cls elips">${title}</div>`;
						}
					}

					let record = _this.itemsByIdMap[unplannedTask.record._id.split('_')[0]];
					if(!record){
						return unplannedTask.record.title;
					}
					let itemStatus = unplannedTask.record.get('status') || { title: "misc" };
					// let itemStatusClass = unplannedTask.record.get('statusClass')
					let itemStatusClass = "d"; // Default status class
					if (record.status) {
						switch (record.status.category) {
							case "ToDo":
								itemStatusClass = "a";
								break;
							case "InProgress":
								itemStatusClass = "b";
								break;
							case "Done":
								itemStatusClass = "c";
								break;
						}
					}
					let backlogItemIconUrl = getBackLogItemIconUrl(record, _this.$root);

					let iconSpan = backlogItemIconUrl ? `
					
					<span class="iconspan a p-abs" style="margin-left: -20px;">
						${record.fields?.tfsProjectId === undefined ? `<span class="jira ${backlogItemIconUrl}"></span>` : `<img src="${backlogItemIconUrl}" class="azurico" alt="" />`}
					</span>` : '';

					try {
						let html = `${iconSpan}<div class='DFA w-full'><div class='elips'>`;
						if (!_.isEmpty(record.almKey)) {
							html += `<a class='key ftsb fs-13 jiraKeyHandle kendisOnly' style='min-width: auto;' href='${record.url}' target='_blank'>${record.almKey}</a>`;
						} else if (!_.isEmpty(record.fields?.externalKey)) {
							html += `<a class='key ftsb fs-13 jiraKeyHandle kendisOnly' style='min-width: auto;' href='${record.fields.externalLink}' target='_blank'>${record.fields.externalKey}</a>`;
						} else if (!_.isEmpty(record.kendisKey)) {
							html += `<a class='key ftsb fs-13 jiraKeyHandle kendisOnly' style='min-width: auto;' target='_blank'>${record.kendisKey}</a>`;
						}

					// Add iteration indicator for child items if they would use iteration path dates
					const dateSource = unplannedTask.record.get('dateSource');
					const iterationIndicator = dateSource === 'iteration'
						? '<span class="iteration-indicator child-iteration-indicator" title="Uses ADO Iteration Path dates if planned">' + createAzureIcon('ml-5') + '</span>'
						: '';

						html += `<span class="recordtitle">${record.title}</span>${iterationIndicator}
							</div>
						</div>
					
						<div class='status dot fst kendis-item-status-dot'>
							<div class='sts ${itemStatusClass} tooltip'>
								<div class='hovtooltipB sml tprht' style='right: -8px !important; top: 20px;'>${itemStatus.title}</div>
							</div>
						</div>
					
						<div class="resource-actions trnsn DAJ">
							<span class="ti-calendar action-icon DAJ ico c-point nwbtn tooltip plan-item-btn" 
								onclick="event.stopPropagation(); roadmapVue.planUnplannedItem('${unplannedTask.record.id}');">
								<span class="hovtooltipB sml tprht">Plan this item</span>							
							</span>
							<span class="ti-pencil action-icon DAJ ico c-point nwbtn tooltip edit-item-btn" 
								onclick="event.stopPropagation(); roadmapVue.editUnplannedItem('${unplannedTask.record.id}');">
								<span class="hovtooltipB sml tprht">Edit this item</span>							
							</span>
						</div>
					`;
						return html;
					} catch (e) {
						console.log(e);
					}
										return record.title;
				}
			},
			// {
			// 	text: 'Status',   // Column header text
			// 	field: 'status.title',   // The field from your data model that this column will display
			// 	enableCellContextMenu: false,
			// 	flex       : 1,
			// 	sortable : false,
			// 	filterable : false,
			// 	groupable: false,
			// 	hideable: false,
			// },
		],
		rowHeight 	: 50,
		minWidth	: 300,
	}
}

/**
 * Returns the correct hierarchy level for an item or child item.
 * @param {Object} record - The event or grid record (must have .id and .get('isChild'))
 * @param {Object} itemsByIdMap - Map of all items by ID
 * @param {Object} releaseTrain - The current release train object (must have .id)
 * @param {Array} backlogHierarchyLevels - Array of hierarchy level objects (must have .level)
 * @param {String|Object} currentHierarchyLevel - The default/current hierarchy level
 * @returns {Object} The hierarchy level object for the item
 */
function getHierarchyLevelForItem(record, itemsByIdMap, releaseTrain, backlogHierarchyLevels, currentHierarchyLevel) {
    let itemLevel = currentHierarchyLevel;
    if (record.originalData.isChild) {
        // For child items, get the parent item and calculate child level
        const eventIdParts = record.id.split('_');

            const parentItemId = eventIdParts[0]; // Second part is parent item ID
            const parentItem = itemsByIdMap[parentItemId];
            if (parentItem ) {
                const parentLevel = currentHierarchyLevel.level;
                const currentIndex = _.findIndex(backlogHierarchyLevels, {level: parentLevel});
                const childLevel = backlogHierarchyLevels[currentIndex + 1];
                if (childLevel) {
                    itemLevel = childLevel;
                }
            }

    }
    return itemLevel;
}