const kendisWidgetOkrsProgressGraph = Vue.component('kendis-widget-progress-graph', {
    template: `
        <div class="obj-graphout a">
            <chart1 class="chart" v-if="chartData.show" :options="stackedAreaChart.options"/>
        </div>
    `,
    props: {
        graphData: {
            type: Object,
            default: () => ({})
        },
        baseItemId: {
            type: String,
            default: () => ""
        }
    },
    components: {
    },
    data() {
        return {
            stackedAreaChart: {
                show: false,
                options: {
                    title: {
                        text: 'Progress Percentage'
                    },
                    chart: {
                        type: 'area',
                        zoomType: 'x',
                        height: 0,
                        events: {
                            load: function () {
                                const chart = this;
                                const maxDataValue = Math.max(...chart.series[0].data.map(point => point.y));

                                // Set custom axis max if conditions are met
                                let yAxisMax = maxDataValue > 10 ? maxDataValue : 50;

                                chart.yAxis[0].update({
                                    max: yAxisMax
                                });
                            }
                        }
                    },
                    yAxis: {
                        labels: {
                            formatter: function () {
                                return this.value + '%';
                            }
                        },
                        max: null,
                        tickInterval: 10,
                    },
                    xAxis: {
                        categories: []
                    },
                    tooltip: {
                        shared: true,
                        useHTML: true,
                        backgroundColor: 'rgba(255, 255, 255, 0.9)',
                        borderColor: '#ccc',
                        borderRadius: 5,
                        borderWidth: 1,
                        shadow: true,
                        hideDelay: 0, // Ensure the tooltip hides immediately
                        stickOnContact: false, // Prevent tooltip from lingering
                        style: {
                            padding: '10px',
                            color: '#333',
                            fontSize: '12px',
                            transition: 'opacity 0.5s',
                            whiteSpace: 'nowrap', // Prevent text wrapping
                            maxWidth: '150px', // Set a maximum width for the tooltip
                            outside: true

                        },
                        positioner: function (labelWidth, labelHeight, point) {
                            var x = point.plotX + this.chart.plotLeft - labelWidth / 2,
                                y = point.plotY + this.chart.plotTop - labelHeight - 10; // Adjust vertical position

                            // Check if the tooltip goes out of the right side of the window
                            if (x + labelWidth > this.chart.chartWidth) {
                                x = this.chart.chartWidth - labelWidth - 20; // Align to the right
                            }

                            // Ensure the tooltip doesn't overflow the top boundary
                            if (y < 0) {
                                y = 0;
                                x -= 50;
                            }

                            return { x: x, y: y };
                        },
                        formatter: function () {
                            var total = 0;
                            var filteredPoints = this.points;

                            filteredPoints.forEach(function (point) {
                                total += point.y;
                            });

                            var tooltipContent = '<div class="garphsTooltipwraper"><div class="DFCB hd"><label>Progress: </label> <div>' + total + '</div></div>';

                            tooltipContent += filteredPoints.map(function (point) {
                                return '<div class="DFCB">' +                                    
		                                    '<label> <span class="DIB dot" style="background-color:' + point.series.color + ';"></span>Title:</label>'+
		                                    '<div class="elips" style="max-width:350px;">' + point.series.name + '</div>' +
	                                    '</div>'+
                                    '<div class="DFCB"><label>Date:</label> <div> ' + point.x + ' </div>'+
                                '</div> ';
                            }).join('');

                            tooltipContent += '</div>';
                            return tooltipContent;
                        }
                    },
                    plotOptions: {
                        area: {
                            stacking: 'normal',
                            lineColor: '#666666',
                            lineWidth: 1,
                            marker: {
                                lineWidth: 1,
                                lineColor: '#666666'
                            },
                        },
                        series: {
                            dataLabels: {
                                enabled: true,
                                format: '{y}%'
                            }
                        }
                    },
                    series: [],
                }
            },
            errorCase: false,
            chartData: {
                isSynced: false,
                show: false,
                options: new Object(),
                timestampInfo: '',
            },
            selectedInterval: 'weekly',
            dateRange: [null, null],
            dateFormat: 'yyyy-MM-dd',
            startPickerOpen: true,
            endPickerOpen: true,
        }
    },

    created(){
        this.initializeProgressGraph();

    },

    methods: {
        initializeProgressGraph: function (){
            this.stackedAreaChart.options.series = [{
                name: this.graphData.itemIdsMap[this.baseItemId],
                data: this.graphData.series[this.baseItemId],
                fillColor: {
                    linearGradient: {
                        x1: 0,
                        y1: 0,
                        x2: 0,
                        y2: 1
                    },
                    stops: [
                        [0, Highcharts.getOptions().colors[0]],
                        [
                            1,
                            Highcharts.color(
                                Highcharts.getOptions().colors[0]
                            ).setOpacity(0).get('rgba')
                        ]
                    ]
                },
            }];
            if (!_.isEmpty(this.graphData.intervalDates)) {
                const monthMap = {
                    '1': 'Jan',
                    '2': 'Feb',
                    '3': 'Mar',
                    '4': 'Apr',
                    '5': 'May',
                    '6': 'Jun',
                    '7': 'Jul',
                    '8': 'Aug',
                    '9': 'Sep',
                    '10': 'Oct',
                    '11': 'Nov',
                    '12': 'Dec'
                };
                const quarterMap = {
                    '1': 'Q1',
                    '2': 'Q1',
                    '3': 'Q2',
                    '4': 'Q2',
                    '5': 'Q2',
                    '6': 'Q2',
                    '7': 'Q3',
                    '8': 'Q3',
                    '9': 'Q3',
                    '10': 'Q4',
                    '11': 'Q4',
                    '12': 'Q4'
                };

                const intervalDates = [];

                let currentDate = new Date(this.graphData.intervalDates[0]);
                let month = currentDate.getMonth();
                switch (this.graphData.intervals) {
                    case 'daily':
                        for (let i = 0; i < this.graphData.intervalDates.length; i++) {
                            intervalDates.push(this.$parent.getExactDate(new Date(this.graphData.intervalDates[i])));
                        }
                        break;
                    case 'weekly':
                        currentDate.setDate(currentDate.getDate() - 7);
                        for (let i = 0; i < this.graphData.intervalDates.length; i++) {
                            let endDate = new Date(this.graphData.intervalDates[i]);
                            let startDate = new Date(endDate);
                            startDate.setDate(startDate.getDate()-6);
                            intervalDates.push(`Week ${i +1} <br> (` + (this.$parent.getExactDate(startDate) + "-" + this.$parent.getExactDate(endDate)) + ')')
                            currentDate = endDate;
                        }
                        break;
                    case 'monthly':
                        if(currentDate.getMonth() === month){
                            currentDate.setMonth(month - 1);
                            currentDate.setDate(currentDate.getDate() - 1);
                        }
                        for (let i = 0; i < this.graphData.intervalDates.length; i++) {
                            let endDate = new Date(this.graphData.intervalDates[i]);
                            let startDate = new Date(currentDate);
                            startDate.setDate(startDate.getDate() +1);
                            intervalDates.push(monthMap[startDate.getMonth() + 1] + ` (${this.$parent.getExactDate(startDate)} - ${this.$parent.getExactDate(endDate)})`);
                            currentDate = endDate;
                        }
                        break;
                    case 'quarterly':
                        currentDate.setMonth(month - 3);
                        if(currentDate.getMonth() === month - 2){
                            currentDate.setMonth(month - 1);
                        }
                        for (let i = 0; i < this.graphData.intervalDates.length; i++) {
                            let endDate = new Date(this.graphData.intervalDates[i]);
                            intervalDates.push(
                                quarterMap[currentDate.getMonth() + 1] +
                                ` (${this.$parent.getExactDate(currentDate)} - ${this.$parent.getExactDate(endDate)})`
                            );
                            currentDate = endDate;
                        }
                        break;
                        default:
                            console.error("Unknown interval type");
                    }
                this.stackedAreaChart.options.xAxis.categories = intervalDates;

            }
            Vue.nextTick(()=> {
                Vue.set(this.chartData, "show", true);
            });
        },
    },
    computed: {
    },
});

