const kendisWidgetGeneralPurposeCriteria = Vue.component('kendis-widget-general-purpose-criteria', {
    template: `
    <div id="overlay" class="overlay" style="display: block;">    
        <div class="ui-dialog selectionPopUp">
            <div v-if="showloader" class="loader">
                <div>
                    <div class="loaderinteg"></div>
                </div>
            </div>
            <div class="selectionPopUpHeader DFCB pd-20 pb-0">
                <span class="fs-18 ftsb widgetPopUpTitle">
                    Notes Widget
                </span>
            <em title="Close" class="rmv-ico ti-close rnd DAJ p-intial" @click="handelCloseSelection"></em>
        </div>
        <div class="selectionPopUpContentWraper">
            <div class="rec lblm">
                <div class="DFA">
                    <label>
                        Enter Title of Graph *
                        <span class="tooltip ml-10 dropTip ttl">
                            <em class="infotxt"></em> 
                            <div class="hovtooltip hov-l-z">
                                Enter the title that better explains your graph.
                            </div>
                        </span>
                    </label>
                </div>
                <input 
                    id="graphTitle" 
                    :maxlength="dynamicMaxLength" 
                    name="Enter Name" 
                    class="txsrch filterinput mr-10"  
                    placeholder="Type Widget Name" 
                    v-model="graphName" 
                    type="text" 
                />
            </div>
            <div class="rec lblm">
                <div class="DFA">
                    <label>
                        Notes *
<!--                        <span class="tooltip ml-10 dropTip ttl">-->
<!--                            <em class="infotxt"></em> -->
<!--                            <div class="hovtooltip hov-l-z">-->
<!--                                Enter the title that better explains your graph.-->
<!--                            </div>-->
<!--                        </span>-->
                    </label>
                </div>
                <div class="txt pd prow">
                    <div 
                        v-if="!editRiscDescAction" 
                        v-html="description" 
                        class="ck-content" 
                        >
                    </div>
                    <ckeditor 
                        v-if="editRiscDescAction"
                        :editor="editor" 
                        v-model="description" 
                        :config="editorConfig" 
                        @ready="onEditorReady"
                    >
<!--                    :disabled="!editRiscDescAction"-->
                    </ckeditor>
                </div>
            </div>
        </div>
        <div class="rec btn">
             <button  type="button" class="button rds4 FR" @click="saveGeneralPurposeWidget()">Save</button> 
        </div>
        </div>    
    </div>`,

    props: {
        graphTypeOptionTitle: null,
        optionTypeTitle: null,
        graphTypeTitle: null,
        dashboardSelected: null,
        widgetType: null,
        existingGraphName: {
            type: String,
            default: ''
        },
        existingDescription: {
            type: String,
            default: ''
        },
        isEdit: {
            type: Boolean,
            default: false
        },
        widgetId: {
            default: ''
        }
    },

    data() {
        return {
            showloader: false,
            dynamicMaxLength: 100,
            graphName: '',
            widgetObj: [],
            addWidget: false,
            editRiscDescAction: false,
            selectedRisk: {
                riskDesc: '',
            },
            editorConfig: {
                toolbar: ["undo", "redo", '|', "heading", "bold", "italic", '|', "blockQuote", "link", "numberedList", "bulletedList", "insertTable", "fontFamily", "fontSize"],
                // "mediaEmbed"
                mediaEmbed: {
                    previewsInData: true
                },

            },
            description: '',
            editor: ClassicEditor,
        };
    },

    created() {
    },

    components: {
        'ckeditor': CKEditor.component,
    },

    computed: {},

    mounted() {
        this.editRiscDescAction = true;
        if (this.existingGraphName && this.isEdit) {
            this.graphName = this.existingGraphName;
        }
        if (this.isEdit) {
            this.description = this.existingDescription || '';
        }
    },

    methods: {
        onEditorReady(editorInstance) {
            this.$nextTick(() => {
                try {
                    editorInstance.editing.view.focus();
                    this.editRiscDescAction = true;
                } catch (e) {
                    console.error(e);
                }
            });
        },

        handelCloseSelection: function () {
            if (this.isEdit) {
                this.$emit('edit-close');
            } else {
                this.$emit('close', {id: this.widgetId});
            }
        },

        saveGeneralPurposeWidget: function () {
            if (!this.validateGeneralPurposeWidget()) {
                return;
            }

            let requestBody = {
                graphName: this.graphName,
                description: this.description,
                graphTypeTitle: this.graphTypeTitle,
                optionTypeTitle: this.optionTypeTitle,
                type: this.widgetType
            }

            this.$emit('populate-graph', requestBody);
        },

        validateGeneralPurposeWidget() {
            let error = false;
            let linkError = false;

            // Validate Graph Title
            if (_.isEmpty(this.graphName.trim())) {
                $("#graphTitle").addClass("red");
                error = true;
            } else {
                $("#graphTitle").removeClass("red");
            }

            // Validate Description
            let $desc = $('.selectionPopUp .ck-editor__editable, .selectionPopUp .ck-content');

            if (_.isEmpty(this.description) || this.description.trim() === '' || this.description === '<p><br></p>') {
                $desc.addClass("red-b");
                error = true;
            } else {
                $desc.removeClass("red-b");
                const urlPattern = new RegExp(
                    '^(https?:\\/\\/)' +                                // protocol
                    '(' +
                    'localhost' +                                   // allow localhost
                    '|(([a-zA-Z\\d]([a-zA-Z\\d-]*[a-zA-Z\\d])*)\\.)+[a-zA-Z]{2,}' +  // domain
                    '|(\\d{1,3}\\.){3}\\d{1,3}' +                   // IPv4
                    ')' +
                    '(\\:\\d+)?(\\/[-a-zA-Z\\d%_.~+]*)*' +              // port and path
                    '(\\?[;&a-zA-Z\\d%_.~+=-]*)?' +                     // query string
                    '(\\#[-a-zA-Z\\d_/]*)?$', 'i'                       // <-- allow slashes in fragment
                );

                const div = document.createElement('div');
                div.innerHTML = this.description;

                const links = Array.from(div.querySelectorAll('a'));

                for (let link of links) {
                    const href = link.getAttribute('href');
                    if (!urlPattern.test(href)) {
                        linkError = true;
                        $desc.addClass("red-b");
                        error = true;
                        break;
                    }
                }
            }

            if (error) {
                if (_.isEmpty(this.graphName.trim())) {
                    showTopMessage("Graph title is required.", "warning", 2000);
                } else if(linkError) {
                    showTopMessage("One or more links in the description are not valid.", "warning", 2000);
                }else{
                    showTopMessage("Please enter a valid description.", "warning", 2000);
                }
                return false;
            }

            return true;
        }
    }

});
