const kendisWidgetCycleTimeGraph = Vue.component('kendis-widget-cycle-time', {
    template: `
    <div  style="height: 100%;">
         <div class="" style="height: 100%;">
             <div   class="cfdGraphCard">
				<div v-if="loading" class="loader">
                  <div>
                    <div class="loaderinteg"/>
                  </div>
                </div> 
				<div v-if="widgetObj.state !== 'new'" class="graphInnerContainer">
                    <div class="cardHeader" ref="header">
                        <div>
                            <div class="tooltip c-deflt">
                            	<h4 class="cardTitle elips">{{widgetObj.name}}</h4>
                                <div class="hovtooltip">{{widgetObj.name}}</div>
                            </div>
                                       
                            <div v-if="!addWidget" class="tooltip criteria">
                                <p class="clickable-text">Criteria Details</p>
                                <div class="hovtooltip criteriaDetailTip">
                                    <div class="graphName">{{widgetObj.category}}</div>
                                    <kendis-widget-criteria-details :graphCriteria="graphCriteria" :type ="!_.isEmpty(widgetObj.type) ? widgetObj.type:''"/>                                          
                                </div>
                            </div>
                        </div> 
                        <div class="DAJE"> 
                        	<div v-if="!addWidget && !_.isEmpty(widgetObj.allGroupBys)" class="DF filterOptions" :class="[widgetObj.graphCriteria?.chartType === 'column' ? 'JE- mr-20a' : '']">
                            <div class="selectcont cardHeaderSelect">
                               <vz-select 
                                    :multiple="true" 
                                    label="title" 
                                    empty-selection-text="Select Group By"
                                    :selected-title="selectedGroupByMessage()" 
                                    class="multi-filter"
                                    value-type="value" 
                                    v-model="groupBySelected" 
                                    :options="chartData.allGroupBys"
                                    :groups-enabled="false"
                                    :show-select-all-on-group="false"
                                    track-by="id"
                                    @select="handleGroupBySelection"  
                                />
                            </div>
                        	</div>
                        	
	            			<div v-if="widgetObj.graphCriteria?.chartType !== 'column' && !addWidget" class="averageTxt">
	                        <div v-if="widgetObj.type === 'flow-time-graph' && chartData.average !== 'NaN' ">
	                            <div class="DF AlignBase">
	                                <h2 class="fs-34">{{chartData.average}} </h2>
	                                <span style="margin-left: 5px">Days</span>
	                            </div>
	                        </div>
	            			</div>
                    
                            <div class="DFA">
                              <div class="selectcont cardHeaderSelect mr-10">
                                 <vz-select 
                                 v-model="filteredSelectedTeams"
                                 :options="filterTeams"        
                                 :multiple="true"  
                                 empty-selection-text="Select Team" 
                                 :selected-title="selectedTeamMessage(filteredSelectedTeams)" 
                                 label="title" 
                                 track-by="title" 
                                 value-type="value" 
                                 @select="onSelectTeamSprintFilterData"
                                 @open="filterDataPopulate"
                                  />   
                              </div>
                              <div class="selectcont cardHeaderSelect">
                                 <vz-select 
                                 v-model="filteredSelectedSprints"
                                 :options="filterSprints"        
                                 :multiple="true"  
                                 empty-selection-text="Select Sprints" 
                                 :selected-title="selectedSprintMessage(filteredSelectedSprints)" 
                                 label="title" 
                                 track-by="title" 
                                 value-type="value" 
                                 @select="onSelectTeamSprintFilterData"
                                 @open="filterDataPopulate"
                                  />   
                              </div>
                            </div>
                            
                    </div>
                    </div>
                    
                   <div v-if="errorCase" class="h-full DFA JC">
                   <div>
                        <img src="/assets/icons/Dashboard/empty-widget-item.svg" alt=".." class="mr-10">
                        <p class="txt-cntr">Criteria not fulfilled. Try with different selection criteria. </p>
                        <p class="txt-cntr"><a class="und c-point" href="#">Learn more</a></p>
                   </div>
                   </div>
                   <chart1 class="chart" v-if="chartData.show && errorCase === false"  :options="chartData.options"></chart1>
                   <div v-if="addWidget">
                        <button type="button" class="button rds4 FR" @click="openCycleTimeCriteria" >Select Criteria</button> 
                   </div>
                   <div class="cardFooter" ref="footer"> 
                       <div class="DFA gap-1">
                            <span class="tooltip DF c-point lastUpdate iconContainer" v-if="!addWidget">
                                <img src="assets/icons/last-update.svg" alt="" />  
                                <span class="hovtooltip refreshTime">Last Updated At:{{chartData.timestampInfo}} </span>
                            </span>
                            <div class="refresh c-point tooltip iconContainer" @click="handleSyncWidget()" v-if="dashboardActionAllowed(myRole,'SyncWidget') && !addWidget">
                                <img v-if="chartData.isSynced == false" src="/assets/icons/refresh-gray.svg" alt=".." :class="{ active: chartData.isSyncing }" class="refreshIcon">
                                <img v-if="chartData.isSynced " src="/assets/icons/new/check.svg" alt=".." class="checkIcon">
                                <div class="hovtooltip ftsb wht-nwrp refreshIconTip">
                                    Refresh
                               </div>
                            </div>
                            <div class="settingsContainer c-point iconContainer" @click="handleSettingsClick" v-if="dashboardActionAllowed(myRole,'WidgetSettings') && !addWidget">
                                <img  src="assets/icons/setting3.svg" alt="" />  
                                <vuepopup v-if="showGraphSettings" @close="showGraphSettings = false;">
                                    <ul v-if="settingsLoading" class="drop_box"   style="display: block;cursor: pointer">
                                        <li  class="loader">
                                              <div>
                                                <div class="loaderinteg"/>
                                              </div>
                                        </li>             
                                    </ul> 
                                    <ul v-else class="drop_box" style="display: block;cursor: pointer">
                                        <li class="boxItem"   @click="openCycleTimeEditCriteria()"> 
                                            <img src="/assets/icons/Dashboard/edit-gray.svg" alt=".." class=""> Edit 
                                        </li>	
                                        <li class="boxItem" @click="handleDuplicateWidget()">  
                                            <img src="/assets/icons/Dashboard/dublicate-gray.svg" alt=".." class=""> Duplicate 
                                        </li>							
                                        <li class="boxItem" @click="handleRemoveWidget()">  
                                            <img src="/assets/icons/Dashboard/delete-gray.svg" alt=".." class=""> Remove 
                                        </li>                          
                                    </ul>
                                </vuepopup>
                            </div>
                            <div class="settingsContainer c-point iconContainer" @click="handleRemoveWidget()" v-if="addWidget">
                                <img src="/assets/icons/Dashboard/delete-gray.svg" alt=".." class="">  
                            </div>             
                       </div>
                      <p v-if="!addWidget && errorCase === false" @click = "handleDetailList()" class="clickable-text">Detail List</p>
                   </div>
				</div>
		     </div>    
        </div>
        <kendis-dashboard-selection-popup v-if="openSelectionPopup"  :graphTypeOptionTitle = "widgetObj.graphCriteria.graphTypeOptionTitle" :optionTypeTitle = "widgetObj.graphCriteria.optionTypeTitle" :graphTypeTitle = "widgetObj.graphCriteria.graphTypeTitle" :widgetType = "widgetObj.type" @close="handelCloseSelection" @populate-graph="onClickPopulateCycleTimeGraph"/>
		<kendis-graph-edit-popup v-if="openEditPopup" :selectedWidget="widgetObj" :dashboardSelected="dashboardSelectedId" @close="handleEditPopupClosure"  @updateWidget="onClickPopulateCycleTimeGraph"> </kendis-graph-edit-popup>
        <dashboard-list-items-popup v-if="isPopupOpen" @close="closeItemsPopup"  :data="popupData"/>	
    </div>			
    `,
    mixins:[rightsMixin],

    props: {widgetData: null, dashboardSelectedId: null,myRole:null},

    data() {
        return {
            filteredSelectedTeams: [],
            resultMapTeamSprint:{},
            allDataOfItems:[],
            dataOfItems:[],
            dumpDataOfItems:[],
            filterTeams: [],
            filteredSelectedSprints:[],
            filterSprints:[],
            settingsLoading:false,
            loading: false,
            addWidget: false,
            showGraphSettings: false,
            openSelectionPopup: false,
            openEditPopup: false,
            statusListing: {
                startOfStatusListing: [],
                startOfSelectedStatus: {},
                endOfStatusListing: [],
                endOfSelectedStatus: {},
            },
            chartData: {
                show: false,
                options: {},
                isSynced: false,
                timestampInfo: '',
            },
            //chart criteria details
            graphCriteria: {
                type:"cycle-time-graph",
            },
            //popup data
            popupData: [],
            isPopupOpen: false,
            groupBySelected: [],

            //Chart Object
            cycleTimeGraph: {
                show: false,
                options: {
                    chart: {
						height: 0,
                        type: 'column',
                        zoomType: 'x',
                        resetZoomButton: {
                            position: {
                                align: 'left', // Align to the left
                                verticalAlign: 'top', // Align to the top
                                x: 10, // X offset for positioning
                                y: 10 // Y offset for positioning
                            }
                        }
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            autoRotation: [-45, -90],
                            style: {
                                fontSize: '13px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        },
                        title: {
                            text: 'Number of Days'
                        }
                    },
                    yAxis: {
                        title: {
                            text: 'Number of Items'
                        },
                        type: 'logarithmic'
                    },
                    legend: {
                        enabled: false,
                        maxHeight: 55,
                        navigation: {
                            enabled: true // Enable legend navigation/pagination
                        },
                    },
                    colors: [ "#E3554E", "#E3554E","#E64735","#D83E34","#C6352E","#B92F27","#AA241C","#FF949D","#F03F3D","#F11F15", "#D30A00","#E6357C",
                        "#E69F35","#DD527C","#D83E67","#C73A63","#B1365D","#9C3258","#752B4C","#FFA4C4","#F56193","#EB2B65", "#BE0E46","#D83EB4",
                        "#D8623E","#A251B2","#9238A4","#85349E","#732E95","#64298B","#47217A","#F3B8FF","#D379E4","#B436CD", "#6C079D","#5C38A4",
                        "#A43880","#7A5CB6","#6441A9","#5B3CA3","#4F349A","#452E91","#342381","#CFB9FF","#A180E8","#370CAC", "#4152A9","#4152A9",
                        "#606DB3","#4554A7","#3F4C9D","#364292","#2F3885","#23276F","#C0CCFF","#8D9FEF","#546EFB","#162BB2", "#4585A7","#6745A7",
                        "#5DA3E7","#4B94E3","#4587D5","#3E75C3","#3764B0","#2C4790","#9FD3FF","#7AC2FF","#339AFF","#2069D0","#4BE0E3","#4E4BE3"
                        ,"#57C3D5","#52B9CD","#4CA9BA","#4594A1","#408089","#355C5F","#ADF5FF","#72E3F4","#14DDFF","#00A5C0","#52CDA4","#527BCD"
                        ,"#4CA398","#409387","#3B867A","#36766A","#31665C","#294A41","#B0F4ED","#6EE1D4","#16CAB3","#097B66","#40935D","#407693",
                        "#94C06A","#82B552","#74A64A","#629240","#507E37","#315D25","#CBF6A1","#A3E465","#7BCE2C","#4B9F0F","#B3B552","#52B554",
                        "#FFD069","#FDC964","#FABD5E","#F6AC59","#F29E55","#EA8750","#FFE9B1","#FFDB81","#FFBA23","#FF8F12","#FD7E64","#E4FD64",
                        "#877068","#74574D","#684E46","#58423B","#493632","#392926","#E0D8CF","#C2AAA1","#9C6B5A","#703B2B","#744D57","#746A4D",
                        "#BDBDBD","#9E9E9E","#757575","#616161","#424242","#212121","#EDEDED","#D8D8D8","#959595","#434343","#9E9E9E",
                        "#7D8F99","#7D8F99","#596D77","#495961","#3B464C","#2A3135","#DAE5EB","#B4C9D4","#7397AB","#4A6675","#658883","#658883"], //
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                            dataLabels: {
                                enabled: true,
                                inside: false, // Position data labels outside the bars
                                y: -15, // Adjust vertical position
                                style: {
                                    color: 'black', // Change color for visibility
                                    textOutline: '1px contrast(white)', // Add outline for contrast
                                },
                                formatter: function() {
                                    return this.y !== 0 ? this.y : ''; // Show value only if not zero
                                }
                            },
                            borderRadius: 5,
                        },
                        series: {
                            stickyTracking: false,
                            label: {
                                connectorAllowed: false
                            },
                        }
                    },
                    tooltip: {
                        useHTML: true,
                        backgroundColor: 'white',
                        borderWidth: 0,
                        borderRadius: 5,
                        formatter: function () {
                            return '' +
                                '<div class="garphsTooltipwraper">' +
                                '<div class="DFCB"><label>Items: </label> <div>' + this.point.y + '</div></div>' +
                                '</div>';
                        }
                    },
                    series: [],
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen', 'separator', 'downloadPDF', 'downloadJPEG', 'downloadPNG', 'downloadXLS']
                            }
                        }
                    }
                }
            },
            widgetObj:[],
            chartType:"",
            errorCase:false,
            itemtags:{},
            itemTagsMeta:{},
        }
    },

    components: {
        //add components here
        'kendis-dashboard-selection-popup': kendisDashboardSelectionPopup,
        "kendis-graph-edit-popup": kendisGraphEditPopup,
        'kendis-widget-criteria-details': kendisWidgetCriteraiDetails,
        'dashboard-list-items-popup': dashboardPopupComponent,
    },

    mounted() {
        //Create a new Widget if id is null
        if (this.widgetData.state == "new") {
            this.addWidget = true;
            this.widgetObj = this.widgetData;
            disableBodyScroll();
            this.openSelectionPopup = true;
        } else {
            //fetch widget data, process it and load the graph
            this.fetchCycleTimeWidgetData();
        }
    },

    created() {
    },

    computed: {
        selectedTeamMessage: function () {
            return function (selectedTeam) {
                let teamMessage = "Teams";
                if (selectedTeam) {
                    teamMessage = teamMessage + " (" + selectedTeam.length + ")";
                }
                return teamMessage;
            }
        },
        selectedSprintMessage : function(){
            return function(selectedSprint){
                let sprintMessage = "Sprints";
                if(selectedSprint){
                    sprintMessage = sprintMessage + " (" + selectedSprint.length + ")";
                }
                return sprintMessage;
            }
        },
    },

    methods: {
        filterDataPopulate() {
            let teamIdsMap=this.widgetObj.graphCriteria.itemIdsMap;
            const resultMap = {
                itemIds: teamIdsMap.flatMap(group => group[1])
            };
            if(_.isEmpty(this.filterTeams) || _.isEmpty(this.filterSprints))
            {
                axios.post('/dashboard/fetch-all-item-details/', resultMap)
                    .then(response => {
                        let dataResult = response.data;

                        this.filterTeams=[];
                        this.filterTeams = response.data
                            .map(item => {
                                // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                return item.teams && Object.keys(item.teams).length > 0
                                    ? item.teams
                                    : { "No Team": "No Team-color:#594a21" };
                            });
                        this.filterSprints=[];
                        this.filterSprints = response.data
                            .map(item => {
                                // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                return item.sprints && Object.keys(item.sprints).length > 0
                                    ? item.sprints
                                    : { "No Sprint": "No Sprint" };
                            });

                        this.resultMapTeamSprint={};
                        this.dataOfItems=dataResult.forEach(item => {
                            const itemId = item.itemId;

                            // Extract team names (before "-")
                            const teamNames = Object.values(item.teams || {}).map(t => t.split("-")[0]);

                            // Extract sprints
                            const sprintNames = Object.values(item.sprints || {});

                            this.resultMapTeamSprint[itemId] = {
                                teams: teamNames,
                                sprints: sprintNames
                            };
                        });

                        this.filterTeamsForDropDown();
                        this.filterSprintsForDropDown();
                    })
                    .catch(error => {
                        console.error(error);
                    });
            }

        },
        onSelectTeamSprintFilterData() {
            let filterTeam=this.filteredSelectedTeams
            this.initializeCycleTimeGraphData(this.widgetObj);
        },
        //Widget related functions
        handleSettingsClick:function(){
            this.settingsLoading = true;
            //Check if the user has access rights for Edit Options
            axios.get('/dashboard/getUserDashboardAccessRole/'+ this.dashboardSelectedId)
                .then(response => {
                    this.myRole = response.data.userRole;
                    if(this.dashboardActionAllowed(this.myRole,"WidgetSettings")){
                        this.showGraphSettings = true;
                        this.settingsLoading = false;
                    }
                    else{
                        showTopMessage("Please ask the author to provide editor access to continue.","warning","8000");
                        this.settingsLoading = false;
                        location.reload();
                    }
                })
                .catch(e => {
                    this.settingsLoading = false;
                });
        },
        //handle the flow for cancel of selection
        handelCloseSelection:function(){
            enableBodyScroll();
            this.openSelectionPopup = false;
            this.$emit('handleRemovalAction', {id: this.widgetObj.id});
        },
        selectedGroupByMessage: function () {
            let selectedGrouping = this.chartData.allGroupBys?.map(groupBy => groupBy.id) || [];
            let title = "";
            if (!_.isEmpty(selectedGrouping) && !_.isEmpty(this.graphCriteria.selectedGroupBy)) {
                if (this.graphCriteria.selectedGroupBy.length >= 10) {
                    title = this.graphCriteria.selectedGroupBy.slice(0, 15) + "..." + " (" + selectedGrouping.length + ")";
                } else {
                    title = this.graphCriteria.selectedGroupBy + "s" + " (" + selectedGrouping.length + ")";
                }
            }
            return title;
        },

        fetchCycleTimeWidgetData: function () {
            let data = {};
            data.widgetId = this.widgetData.id;
            this.loading = true;
            axios.post("/dashboard/getSingleWidget/", data).then(response => {
                this.widgetObj = response.data.widget;
                this.initializeCycleTimeGraphData(this.widgetObj);
            }).catch(e => {
                this.errorCase = true;
                console.log("Some Error Occurred While Loading Single Cycle Time", e);
                this.loading = false;
            });
        },

        //methods for Cycle Time processing

        openCycleTimeCriteria: function () {
            disableBodyScroll();
            this.openSelectionPopup = true;
        },

        openCycleTimeEditCriteria: function () {
            disableBodyScroll();
            this.openEditPopup = true;
        },
        handleEditPopupClosure(){
            enableBodyScroll();
            this.openEditPopup = false;
        },
        closeItemsPopup(){
            enableBodyScroll();
            this.isPopupOpen = false;
        },
        onClickPopulateCycleTimeGraph: function (requestBody) {
            this.filterTeams=[];
            this.filterSprints=[];
            this.loading = true;
            enableBodyScroll();
            this.openSelectionPopup = false;
            this.openEditPopup = false;
            let reqBody = {};
            if (requestBody.xAxis === 'weekly' || requestBody.xAxis == 'sprints' || requestBody.xAxis == 'monthly') {
                this.selectedInterval = requestBody.xAxis;
            } else {
                this.selectedInterval = requestBody.selectedInterval;
            }
            reqBody = {
                sessionBoardId: requestBody.sessionBoardId,
                startStatus: requestBody.statusListing.startOfSelectedStatus,
                endStatus: requestBody.statusListing.endOfSelectedStatus,
                tenant: requestBody.tenant,
                interval: requestBody.selectedInterval,
                issueType: requestBody.selectedIssueType,
                boardItemsFilter: requestBody.boardItemsFilter,
                radioTypeSelection : requestBody.radioButtonSelection,
                itemtags : requestBody.itemtags,
            };
            this.itemtags = requestBody.itemtags;
            this.itemTagsMeta = requestBody.itemTagsMeta;
            this.boardId = requestBody.selectedBoard._id;
            this.boardTenant = requestBody.tenant;
            this.graphTypeTitle = requestBody.graphTypeTitle;
            this.optionTypeTitle = requestBody.optionTypeTitle;
            this.sessionBoardId = requestBody.sessionBoardId;
            this.selectedBoard = requestBody.selectedBoard;
            this.selectedGraph = requestBody.selectedGraph;
            this.graphName = requestBody.graphName;
            this.selectedFilterType = requestBody.selectedFilterType;
            this.statusListing = requestBody.statusListing;
            this.selectedCondition = requestBody.statusIds;
            this.selectedInterval = requestBody.selectedInterval;
            this.radioButtonSelection = requestBody.radioButtonSelection;
            this.selectedIssueType = requestBody.selectedIssueType;
            this.issueTypeTitleList = requestBody.selectedIssueTypeTitleList;
            this.boardItemsFilter = requestBody.boardItemsFilter;
            this.selectedBoardTitle = requestBody.selectedBoardTitle;
            this.selectedToStatus = requestBody.selectedToStatus;
            this.selectedFromStatus = requestBody.selectedFromStatus;
            reqBody.widgetType = requestBody.optionTypeTitle;
            let _this = this;
            axios.post('/dashboard/create-timeseries-data', reqBody)
                .then(response => {
                    if (!response.data) {
                        throw new Error('Response data is empty');
                    }
                    let widgetData;
                    widgetData = _this.makeGraphObjectForCycleTimeDBStorage(response.data);
                    if (!_.isEmpty(widgetData)) {
                        return axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widgetData);
                    } else {
                        throw new Error('Processed widget data is empty');
                    }
                })
                .then(response => {
                    let updatedWidget = response.data.widget;
                    this.widgetObj = updatedWidget;
                    this.initializeCycleTimeGraphData(updatedWidget);
                    this.loading = false;
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    _this.loading = false;
                });
        },

        makeGraphObjectForCycleTimeDBStorage: function (response) {
            let widgetData = {};
            if (response !== null) {
                let graphDataMap = response.intervals;
                let itemDaysMap = response.itemDaysMap;
                let itemIdsMap = response.itemIdsMap;
                let itemDatesMap = response.itemDatesMap;
                let itemStatusMap = response.itemStatusMap;
                const transformeditemIdsMapData = Object.entries(itemIdsMap || {}).map(([key, value]) => [key, value]);
                let categories = [];
                const transformedData = Object.entries(graphDataMap).map(([key, value]) => [key, value]);
                let widgetData = {};
                let selectedItems = [];
                if (!_.isEmpty(this.statusListing.startOfSelectedStatus) && !_.isEmpty(this.statusListing.endOfSelectedStatus)) {
                    selectedItems.push(this.statusListing.startOfSelectedStatus);
                    selectedItems.push(this.statusListing.endOfSelectedStatus);
                }

                let dataOfGraph = {
                    "graphType": this.selectedGraph,
                    "selectedItems": selectedItems,
                    "boardId": this.boardId,
                    "sessionBoardId": this.sessionBoardId,
                    "graphTypeTitle": this.graphTypeTitle,
                    "optionTypeTitle": this.optionTypeTitle,
                    "selectedBoardTenant": this.boardTenant,
                    "intervals": this.selectedInterval,
                    "radioButtonSelection": this.radioButtonSelection,
                    "selectedIssueType": this.selectedIssueType,
                    "chartType": "column",
                    "boardItemsFilter": this.boardItemsFilter,
                    "fromStatusTitle": this.selectedToStatus,
                    "toStatusTitle": this.selectedFromStatus,
                    "issueTypeTitle": this.issueTypeTitleList,
                    "boardTitle": this.selectedBoardTitle,
                    "itemDaysMap": itemDaysMap,
                    "itemIdsMap": transformeditemIdsMapData,
                    "itemsGroupMap": itemDatesMap,
                    "itemTags":this.itemtags,
                    "itemTagsMetaMap" : this.itemTagsMeta,
                    "itemStatusMap":itemStatusMap,
                };
                widgetData = {
                    name: this.graphName,
                    graphCriteria: dataOfGraph,
                    graphAdditionalCriteria: transformedData,
                    id: this.widgetObj.id,
                    state:'old',
                };

                return widgetData;
            }
        },

        //Chart Population Functions
        initializeCycleTimeGraph: function () {
            let _this = this;
            this.cycleTimeGraph = {
                show: false,
                options: {
                    chart: {
                        type: 'column',
                        zoomType: 'x',
                        height: 0,
                        resetZoomButton: {
                            position: {
                                align: 'left', // Align to the left
                                verticalAlign: 'top', // Align to the top
                                x: 10, // X offset for positioning
                                y: 10 // Y offset for positioning
                            }
                        }
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            autoRotation: [-45, -90],
                            style: {
                                fontSize: '13px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            text: 'Number of Items'
                        },
                        type: 'logarithmic' // Set the y-axis to logarithmic scale
                    },
                    legend: {
                        layout: 'horizontal',
                        align: 'center',
                        verticalAlign: 'bottom',
                        useHTML: true,
                        itemStyle: {
                            pointerEvents: 'none' // Disable pointer events on legend items
                        },
                        maxHeight: 55,
                        navigation: {
                            enabled: true // Enable legend navigation/pagination
                        },
                    },
                    tooltip: {
                        pointFormat: 'Items: <b>{point.y:.1f} items</b>'
                    },
                    colors: [ "#E3554E", "#E3554E","#E64735","#D83E34","#C6352E","#B92F27","#AA241C","#FF949D","#F03F3D","#F11F15", "#D30A00","#E6357C",
                        "#E69F35","#DD527C","#D83E67","#C73A63","#B1365D","#9C3258","#752B4C","#FFA4C4","#F56193","#EB2B65", "#BE0E46","#D83EB4",
                        "#D8623E","#A251B2","#9238A4","#85349E","#732E95","#64298B","#47217A","#F3B8FF","#D379E4","#B436CD", "#6C079D","#5C38A4",
                        "#A43880","#7A5CB6","#6441A9","#5B3CA3","#4F349A","#452E91","#342381","#CFB9FF","#A180E8","#370CAC", "#4152A9","#4152A9",
                        "#606DB3","#4554A7","#3F4C9D","#364292","#2F3885","#23276F","#C0CCFF","#8D9FEF","#546EFB","#162BB2", "#4585A7","#6745A7",
                        "#5DA3E7","#4B94E3","#4587D5","#3E75C3","#3764B0","#2C4790","#9FD3FF","#7AC2FF","#339AFF","#2069D0","#4BE0E3","#4E4BE3"
                        ,"#57C3D5","#52B9CD","#4CA9BA","#4594A1","#408089","#355C5F","#ADF5FF","#72E3F4","#14DDFF","#00A5C0","#52CDA4","#527BCD"
                        ,"#4CA398","#409387","#3B867A","#36766A","#31665C","#294A41","#B0F4ED","#6EE1D4","#16CAB3","#097B66","#40935D","#407693",
                        "#94C06A","#82B552","#74A64A","#629240","#507E37","#315D25","#CBF6A1","#A3E465","#7BCE2C","#4B9F0F","#B3B552","#52B554",
                        "#FFD069","#FDC964","#FABD5E","#F6AC59","#F29E55","#EA8750","#FFE9B1","#FFDB81","#FFBA23","#FF8F12","#FD7E64","#E4FD64",
                        "#877068","#74574D","#684E46","#58423B","#493632","#392926","#E0D8CF","#C2AAA1","#9C6B5A","#703B2B","#744D57","#746A4D",
                        "#BDBDBD","#9E9E9E","#757575","#616161","#424242","#212121","#EDEDED","#D8D8D8","#959595","#434343","#9E9E9E",
                        "#7D8F99","#7D8F99","#596D77","#495961","#3B464C","#2A3135","#DAE5EB","#B4C9D4","#7397AB","#4A6675","#658883","#658883"], //
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                            dataLabels: {
                                enabled: true,
                                inside: false, // Position data labels outside the bars
                                y: -15, // Adjust vertical position
                                style: {
                                    color: 'black', // Change color for visibility
                                    textOutline: '1px contrast(white)', // Add outline for contrast
                                },
                                formatter: function() {
                                    return this.y !== 0 ? this.y : ''; // Show value only if not zero
                                }
                            },
                            borderRadius: 5,
                        },
                        series: {
                            stickyTracking: false,
                            label: {
                                connectorAllowed: false
                            },
                            point: {
                                events: {
                                    click: function () {
                                        const chart = this.series.chart;
                                        const allLegendsVisible = chart.series.every(series => series.visible);
                                        const xAxisIndex = this.name;
                                        let itemIds = [];
                                        if (this.series.options.chartType != 'column') {
                                            if (allLegendsVisible) {
                                                itemIds = chart.series
                                                    .flatMap(series => series.options.itemIds[xAxisIndex] || [])
                                                    .filter(id => id !== "");
                                            } else {
                                                itemIds = chart.series
                                                    .filter(series => series.visible)
                                                    .flatMap(series => series.options.itemIds[xAxisIndex] || [])
                                                    .filter(id => id !== "");
                                            }
                                        } else {
                                            itemIds = this.series.options.itemIds[xAxisIndex];
                                        }
                                        _this.onClickDataPoints(itemIds, this.series.options.graphName, this.series.options.fromStatusTitle, this.series.options.toStatusTitle, this.series.options.graphType,this.series.name);
                                    }
                                }
                            }

                        }
                    },
                    series: [{
                        name: 'Number of Days',
                        colorByPoint: true,
                        groupPadding: 0,
                        data: [],
                        dataLabels: {
                            enabled: true,
                            inside: false, // Position data labels outside the bars
                            y: -10, // Adjust vertical position
                            style: {
                                color: 'black', // Change color for visibility
                                textOutline: '1px contrast(white)', // Add outline for contrast
                            },
                            formatter: function() {
                                return this.y !== 0 ? this.y : ''; // Show value only if not zero
                            }
                        },
                    }],
                    responsive: {
                        rules: [{
                            condition: {
                                maxWidth: 500
                            },
                            chartOptions: {
                                legend: {
                                    layout: 'horizontal',
                                    align: 'center',
                                    verticalAlign: 'bottom',
                                    maxHeight: 55,
                                    navigation: {
                                        enabled: true // Enable legend navigation/pagination
                                    },
                                }
                            }
                        }]
                    },
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen', 'separator', 'downloadPDF', 'downloadJPEG', 'downloadPNG', 'downloadXLS']
                            }
                        }
                    }
                }
            };
        },

        initializeCycleTimeGraphData: function (data) {
            if(_.isEmpty(data.graphAdditionalCriteria)){
                this.errorCase= true;
            }
            else{
                this.errorCase= false;
            }
            this.populateCycleTimeChart(data);
            let timestamp = '';
            if (data.updatedOn) {
                timestamp = data.updatedOn;
            } else {
                timestamp = data.createdOn;
            }
            let graphCriteria = {
                graphType: null,
                selectedBoardTitle: null,
                selectedIssueType: null,
                selectedGroupBy: null,
                selectedXAxis: null,
                selectedInterval: null,
                selectedToStatus: null,
                selectedFromStatus: null,
                sessionBoardId:null,
            };
            graphCriteria.sessionBoardId=data.graphCriteria.sessionBoardId;
            graphCriteria.chartType = data.graphCriteria.chartType;
            graphCriteria.selectedBoardTitle = data.graphCriteria.boardTitle;
            graphCriteria.selectedToStatus = data.graphCriteria.toStatusTitle;
            graphCriteria.selectedFromStatus = data.graphCriteria.fromStatusTitle;
            graphCriteria.selectedIssueType = data.graphCriteria.issueTypeTitle;
            if (data.graphCriteria.intervals == 'sprints' || data.graphCriteria.intervals == 'weekly' || data.graphCriteria.intervals == 'monthly') {
                graphCriteria.selectedXAxis = data.graphCriteria.intervals;
            } else {
                graphCriteria.selectedXAxis = "Days";
                graphCriteria.selectedInterval = data.graphCriteria.intervals;
            }
            const dateData = new Date(timestamp);
            if (data.graphCriteria.graphType === '3') {
                processedGraph = {
                    options: Object.assign({}, this.cycleTimeGraph.options),
                    show: true,
                    id: data.id,
                    timestampInfo: dateData.toLocaleString(),
                    name: data.name,
                    isSynced: false,
                    isSyncing: false,
                    columns: data.columns,
                    rows: data.rows,
                    posX: data.posX,
                    posY: data.posY,
                    loading:false,
                    graphCriteria: graphCriteria,
                    type: "flow-time-graph",
                    category : "Flow Time",
                    itemDaysMap: data.graphCriteria.itemDaysMap ? data.graphCriteria.itemDaysMap : {},
                    itemStatusMap : data.graphCriteria.itemStatusMap? data.graphCriteria.itemStatusMap : {},
                };
                // Ensuring reactivity
                this.$set(this.chartData, 'show', false);
                this.$set(this,'chartData', processedGraph);
                this.$set(this, 'addWidget', false);
                this.$set(this, 'graphCriteria', graphCriteria);
                this.$set(this, 'loading', false);

                let _this = this;
                this.$nextTick(() => {
                    _this.setGraphHeight();
                    _this.chartData.show = true;
                });
            }
        },

        populateCycleTimeChart: function (widget) {
            this.initializeCycleTimeGraph();
            let graphOptions = _.cloneDeep(this.cycleTimeGraph.options);
            if (_.isEmpty(widget.graphAdditionalCriteria)) {
                let dummyData = [];
                for (let i = 0; i < widget.graphAdditionalCriteria.length; i++) {
                    const pair = widget.graphAdditionalCriteria[i];
                    const interval = pair[0];
                    graphOptions.series[0].data.push([pair[0], pair[1]]);

                    const itemIds = widget.graphCriteria.itemIdsMap.find(([key]) => key.includes(`{${interval}=`));

                    if (itemIds) {
                        graphOptions.series[0].itemIds[interval] = itemIds[1]; // Item IDs for that interval
                    }
                }
            } else {
                graphOptions.series[0].data = widget.graphAdditionalCriteria.map(pair => [pair[0], pair[1]]);
                graphOptions.series[0].itemIds = {};

                widget.graphAdditionalCriteria.forEach(pair => {
                    const interval = pair[0];
                    const itemIds = widget.graphCriteria.itemIdsMap.find(([key]) => key.includes(`{${interval}=`));
                    if (itemIds) {
                        graphOptions.series[0].itemIds[interval] = itemIds[1];
                    } else {
                        graphOptions.series[0].itemIds[interval] = [];
                    }
                    graphOptions.series[0].graphName = widget.name;
                    graphOptions.series[0].graphType = widget.graphCriteria.optionTypeTitle;
                    graphOptions.series[0].chartType = widget.graphCriteria.chartType;
                    graphOptions.series[0].fromStatusTitle = widget.graphCriteria.fromStatusTitle;
                    graphOptions.series[0].toStatusTitle = widget.graphCriteria.toStatusTitle;
                });
                if(this.filteredSelectedTeams!=undefined || this.filteredSelectedSprints!=undefined ||this.filteredSelectedTeams.length!=0 ||  this.filteredSelectedSprints.length!=0){
                    if(this.filteredSelectedTeams==undefined ||  this.filteredSelectedSprints==undefined){
                        graphOptions.series[0].data = Object.entries(graphOptions.series[0].itemIds).map(([range, items]) => {
                            return [range, 0];
                        });
                    }
                    else if(this.filterTeams.length>this.filteredSelectedTeams.length || this.filterSprints.length>this.filteredSelectedSprints.length){
                        const filteredTeams = new Set(this.filteredSelectedTeams);
                        const filteredSprints = new Set(this.filteredSelectedSprints);

                        for (const range in graphOptions.series[0].itemIds) {
                            const items = graphOptions.series[0].itemIds[range];

                            graphOptions.series[0].itemIds[range] = items.filter(itemId => {
                                const teamInfo = this.resultMapTeamSprint[itemId];
                                if (!teamInfo) return false;

                                const teams = teamInfo.teams;
                                const sprints = teamInfo.sprints;

                                // Check team match
                                const hasTeamMatch = (
                                    (teams.length === 0 && filteredTeams.has("No Team")) ||
                                    teams.some(team => filteredTeams.has(team))
                                );

                                // Check sprint match
                                const hasSprintMatch = (
                                    (sprints.length === 0 && filteredSprints.has("No Sprint")) ||
                                    sprints.some(sprint => filteredSprints.has(sprint))
                                );

                                // Keep item only if both team and sprint conditions match
                                return hasTeamMatch && hasSprintMatch;
                            });
                        }
                        graphOptions.series[0].data = Object.entries(graphOptions.series[0].itemIds).map(([range, items]) => {
                            return [range, items.length];
                        });
                    }
                }
            }
            this.cycleTimeGraph.options = graphOptions;
        },

        //Helper functions for formatting
        formattedCompletionStatus(status) {
            if (!_.isEmpty(status)) {
                return status.split(',').map(item => item.trim()).join(', ');
            } else {
                return '';
            }
        },

        formatInnerDate: function (dateString) {
            const parts = dateString.split(" ");
            const month = parts[1];
            const day = parts[2];
            const year = parts[5];
            return `${month} ${day} ${year}`;
        },

        formatBoardItemsTitle: function (input) {
            if (!input) {
                return '';
            }

            return input
                .split('-')
                .map(word => word.charAt(0).toUpperCase() + word.slice(1))
                .join(' ');
        },

        getStartDate: function (key, relevantDates) {
            if (relevantDates.hasOwnProperty(key)) {
                let dateList = relevantDates[key];
                if (dateList.length > 0) {
                    return dateList[0];
                } else {
                    console.error("The list for the key is empty.");
                    return null;
                }
            } else {
                console.error("The key does not exist in the relevantDates map.");
                return null;
            }
        },

        getEndDate: function (key, relevantDates) {
            if (relevantDates.hasOwnProperty(key)) {
                let dateList = relevantDates[key];
                if (dateList.length > 0) {
                    return dateList[dateList.length - 1];
                } else {
                    console.error("The list for the key is empty.");
                    return null;
                }
            } else {
                console.error("The key does not exist in the relevantDates map.");
                return null;
            }
        },

        calculateAverageOfDataPoints: function (dataPoints) {
            let sum = 0;
            for (let i = 0; i < dataPoints.length; i++) {
                sum += dataPoints[i][1];
            }
            let average = sum / dataPoints.length;
            return average.toFixed(1);
        },

        handleGroupBySelection: function (selected) {

            let tempselectedGroupBy = selected == undefined ? [] : selected;
            let selectedGraph = this.chartData;
            let selectedGraphOptions = selectedGraph.options;
            let selectedWidget = this.widgetData;
            let selectedGroupBy = selectedGraph.allGroupBys.filter(groupBy =>
                tempselectedGroupBy.includes(groupBy.id)
            );
            let dummyData = [];
            let graphOptions = null;
            if (selectedGraph.type == 'flow-time-graph') {
                this.initializeCycleTimeGraph();
                graphOptions = _.cloneDeep(this.flowTimeGraph.options);
            }
            graphOptions.xAxis.categories = selectedWidget.graphCriteria.categories;
            graphOptions.chart.type = selectedWidget.graphCriteria.chartType;
            if (!_.isEmpty(selectedWidget.graphAdditionalCriteria)) {
                let index = 0;
                let teamMap = new Map();
                for (const pair of selectedWidget.graphAdditionalCriteria) {
                    dummyData = [];
                    const pairKey = pair[0].split('=')[0].replace('{', ''); // Extracts "Iteration 2"
                    const pairValue = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                    if (!teamMap.has(pairValue)) {
                        teamMap.set(pairValue, Array(selectedWidget.graphCriteria.categories.length).fill(0));
                    }
                }
                if (selectedGroupBy != null) {
                    for (const pair of selectedWidget.graphAdditionalCriteria) {
                        dummyData = [];
                        const iteration = pair[0].split('=')[0].replace('{', ''); // Extracts "Iteration 2"
                        const team = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                        const teamData = teamMap.get(team);
                        if (selectedGroupBy.some(groupBy => groupBy.title === team)) {
                            const iterationIndex = selectedWidget.graphCriteria.categories.indexOf(iteration);
                            if (iterationIndex !== -1) {
                                if (!teamMap.has(team)) {
                                    teamMap.set(team, Array(selectedWidget.graphCriteria.categories.length).fill(0));
                                }
                                const teamData = teamMap.get(team);
                                teamData[iterationIndex] += pair[1];
                                teamMap.set(team, teamData);
                            }
                        }
                    }
                    for (const [key, value] of teamMap) {
                        graphOptions.series[index] = {
                            name: key,
                            data: value
                        };
                        index++;
                    }
                    if (_.isEmpty(graphOptions.series)) {
                        graphOptions.series[0] = {
                            name: "No Data",
                            data: []
                        };
                    }
                }
            } else {
            }
            if (selectedGraph.type == 'flow-time-graph') {
                graphOptions.chart.type = selectedWidget.graphCriteria.chartType;
                this.flowTimeGraph.options = graphOptions;
            }
            let timestamp = '';
            if (selectedWidget.updatedOn) {
                timestamp = selectedWidget.updatedOn;
            } else {
                timestamp = selectedWidget.createdOn;
            }
            const dateData = new Date(timestamp);
            let average = this.filteredDataPointsAvg(selectedWidget.graphAdditionalCriteria, selectedGroupBy);
            if (average == 'NaN') {
                average = 0.0;
            }
            if (selectedWidget.graphCriteria.chartType !== 'column') {
                if (selectedGraph.type == 'flow-time-graph') {
                    if (selectedWidget.graphCriteria.chartType == 'line') {
                        this.flowTimeGraph.options.yAxis.plotLines = [{
                            value: average,
                            dashStyle: 'shortDash',
                            width: 1
                        }];
                    }
                }
            }
            let allGroupBys = [];
            if (!_.isEmpty(selectedWidget.allGroupBys)) {
                allGroupBys = selectedWidget.allGroupBys;
            }
            const keys = Object.keys(allGroupBys);
            const transformedallGroupBys = keys.map(key => ({
                id: key,
                title: allGroupBys[key]
            }));

            let graphCriteria = {
                graphType: null,
                selectedBoardTitle: null,
                selectedIssueType: null,
                selectedGroupBy: null,
                selectedXAxis: null,
                selectedInterval: null,
                selectedToStatus: null,
                selectedFromStatus: null,
            };
            graphCriteria.chartType = selectedWidget.graphCriteria.chartType;
            graphCriteria.graphType = selectedWidget.graphCriteria.graphType;
            graphCriteria.selectedBoardTitle = selectedWidget.graphCriteria.boardTitle;
            graphCriteria.selectedIssueType = selectedWidget.graphCriteria.issueTypeTitle;
            graphCriteria.selectedGroupBy = selectedWidget.graphCriteria.groupByTitle ? selectedWidget.graphCriteria.groupByTitle : selectedWidget.graphCriteria.groupBy;

            if (selectedWidget.graphCriteria.intervals == 'sprints' || selectedWidget.graphCriteria.intervals == 'weekly' || selectedWidget.graphCriteria.intervals == 'monthly') {
                graphCriteria.selectedXAxis = selectedWidget.graphCriteria.intervals;
            } else {
                graphCriteria.selectedXAxis = "Days";
                graphCriteria.selectedInterval = selectedWidget.graphCriteria.intervals;
            }
            graphCriteria.selectedToStatus = selectedWidget.graphCriteria.toStatusTitle;
            graphCriteria.selectedFromStatus = selectedWidget.graphCriteria.fromStatusTitle;
            let option = null;
            let type = null;
            let category = null;
            if (selectedGraph.type == "flow-time-graph") {
                option = this.flowTimeGraph.options;
                type = "flow-time-graph";
                category = "Cycle Time";
            }

            let updatedItemsMap = selectedWidget.graphCriteria.itemDaysMap ? selectedWidget.graphCriteria.itemDaysMap : selectedWidget.graphCriteria.itemStatusMap;
            let filteredItems = {};
            for (const key in selectedWidget.graphCriteria.itemTeamsMap) {
                const team = key.split(':')[1].trim();
                let itemId = key.split(':')[0];
                if (selectedGroupBy.some(groupBy => groupBy.title === team)) {
                    for (const key2 in updatedItemsMap) {
                        let tempId = key2.split(':')[0].trim();
                        let tempName = key2.split(':')[1].trim();
                        if (itemId === tempId) {
                            itemId += ':';
                            itemId += tempName;
                            filteredItems[itemId] = updatedItemsMap[itemId];
                        }
                    }
                }
            }
            let filteredGroupBy = {};

            let processedGraph = {
                options: Object.assign({}, option),
                show: true,
                id: selectedWidget.id,
                timestampInfo: dateData.toLocaleString(),
                name: selectedWidget.name,
                isSynced: false,
                isSyncing: false,
                type: type,
                category: category,
                average: average,
                allGroupBys: transformedallGroupBys,
                graphCriteria: graphCriteria,
                yAxis: selectedWidget.graphCriteria.yAxis ? selectedWidget.graphCriteria.yAxis : "",
                itemDaysMap: selectedGraph.type !== "flow-load-graph" ? filteredItems : [],
                itemStatusMap: selectedGraph.type == "flow-load-graph" ? filteredItems : [],
                itemGroupbyMap: filteredGroupBy,
                itemTeamsMap: selectedWidget.graphCriteria.itemTeamsMap ? selectedWidget.graphCriteria.itemTeamsMap : {},
                itemSprintsMap: selectedWidget.graphCriteria.itemSprintsMap ? selectedWidget.graphCriteria.itemSprintsMap : {},
                posX: selectedGraph.posX,
                posY: selectedGraph.posY,
                columns: selectedGraph.columns,
                rows: selectedGraph.rows
            }

            this.chartData = processedGraph;
           
            // let _this = this;
            // Vue.nextTick(()=>{
            //     if (_this.gridStack) {
            //         let widgetElement = document.getElementById(selectedWidget.id);
            //         _this.gridStack.update(widgetElement);
            //     }
            // });
        },

        filteredDataPointsAvg: function (data, selectedGroupBy) {
            if (!_.isEmpty(selectedGroupBy)) {
                let dataPoints = [];
                let dummyData = [];
                for (const pair of data) {
                    const pairValue = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                    if (selectedGroupBy.some(groupBy => groupBy.title === pairValue)) {
                        dummyData.push(pair[1]);
                    }
                }
                let sum = 0;
                for (let i = 0; i < dummyData.length; i++) {
                    sum += dummyData[i];
                }
                let avg = sum / dummyData.length;
                return avg.toFixed(1);
            }
            return 0;
        },

        //Widget Removal & Duplicate
        handleRemoveWidget: function () {
            askFromSweetAlertWrapper(
                "Are you sure you want to remove this widget?",
                [() => this.$emit('handleRemovalAction', {id: this.widgetObj.id}), null],
                [takeNoAction]
            );
        },

        handleDuplicateWidget: function () {
			this.widgetObj.posX = this.widgetData.posX;
			this.widgetObj.posY = this.widgetData.posY;
			this.widgetObj.columns = this.widgetData.columns;
			this.widgetObj.rows = this.widgetData.rows;
            askFromSweetAlertWrapper(
                "Are you sure you want to duplicate this widget?",
                [() => this.$emit('handleDuplicateAction', {widget: this.widgetObj}), null],
                [takeNoAction]
            );
        },


        //Syncing of Cycle Time Graph
        handleSyncWidget: function (widgetSelected) {
            const data = {
                dashboardId: this.dashboardSelectedId,
                widgetId: this.widgetObj.id
            };
            this.loading = true;
            widgetSelected = this.widgetObj;
            axios.post("/dashboard/syncDashboardWidgetCFD", data)
                .then(response => {
                    if (response.data) {
                        this.boardId = widgetSelected.graphCriteria.boardId;
                        this.sessionBoardId = widgetSelected.graphCriteria.sessionBoardId;
                        this.graphTypeTitle = widgetSelected.graphCriteria.graphTypeTitle;
                        this.optionTypeTitle = widgetSelected.graphCriteria.optionTypeTitle;
                        this.boardTenant = widgetSelected.graphCriteria.selectedBoardTenant;
                        this.xAxis = widgetSelected.graphCriteria.intervals;
                        this.radioButtonSelection = widgetSelected.graphCriteria.radioButtonSelection;
                        this.selectedIssueType = widgetSelected.graphCriteria.selectedIssueType;
                        this.selectedBoardTitle = widgetSelected.graphCriteria.boardTitle;
                        this.issueTypeTitleList = widgetSelected.graphCriteria.issueTypeTitle;
                        this.selectedFromStatus = widgetSelected.graphCriteria.fromStatusTitle;
                        this.startDate = widgetSelected.graphCriteria.startDate;
                        this.endDate = widgetSelected.graphCriteria.endDate;
                        this.selectedActiveStatus = widgetSelected.graphCriteria.selectedActiveStatus;
                        this.selectedWaitingStatus = widgetSelected.graphCriteria.selectedInProgressStatus;
                        this.selectedCompletedStatus = widgetSelected.graphCriteria.selectedCompletedStatus;
                        this.boardItemsFilter = widgetSelected.graphCriteria.boardItemsFilter;
                        this.widgetId = widgetSelected.id;
                        this.graphName = widgetSelected.name;
                        this.selectedCondition = widgetSelected.graphCriteria.selectedItems;
                        this.statusListing.startOfSelectedStatus = widgetSelected?.graphCriteria?.selectedItems[0];
                        this.statusListing.endOfSelectedStatus = widgetSelected?.graphCriteria?.selectedItems[1];
                        this.selectedToStatus = widgetSelected.graphCriteria.fromStatusTitle;
                        this.selectedFromStatus = widgetSelected.graphCriteria.toStatusTitle;
                        this.itemtags = widgetSelected.graphCriteria.itemTags;
                        this.itemTagsMeta = widgetSelected.graphCriteria.itemTagsMetaMap;

                        const widgetData = this.makeGraphObjectForCycleTimeDBStorage(response.data);

                        if (!_.isEmpty(widgetData)) {
                            return axios.post(`/dashboard/${this.dashboardSelectedId}/widget/save`, widgetData);
                        } else {
                            throw new Error('Processed widget data is empty');
                        }
                    } else {
                        throw new Error('Response data is empty');
                    }
                })
                .then(response => {
                    const updatedWidget = response.data.widget;
                    this.widgetObj = updatedWidget;
                    this.initializeCycleTimeGraphData(updatedWidget);
                    this.loading = false;
                    this.chartData.isSyncing = false;
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    this.loading = false;
                });
        },
         handleRerenderWidget: function () {
			let _this = this;
			
			this.setGraphHeight();
			Vue.set(_this.chartData, "show", false);
			Vue.nextTick(()=> {
				Vue.set(_this.chartData, "show", true);
			});
		},
		setGraphHeight: function () {

			let unitWidth = this.$el.offsetHeight;
			
			let headerHeight = this.$refs.header.offsetHeight;
			let footerHeight = this.$refs.footer.offsetHeight;
			let totalHeightInPixels = unitWidth;
			this.chartData.options.chart.height = totalHeightInPixels - headerHeight - footerHeight  - 100;
		},

        //Detail List
        handleDetailList: function (data) {
            let selectedGraph = this.widgetObj;
            let grouping = selectedGraph.graphCriteria.selectedGroupBy;
            let fromStatusTitle = this.graphCriteria.selectedToStatus
            let toStatusTitle = this.graphCriteria.selectedFromStatus;
            let itemDaysMap = this.chartData.itemDaysMap;
            let itemDatesMAp = selectedGraph.graphCriteria.itemsGroupMap;
            let itemStatusMap = this.chartData.itemStatusMap;
            let itemGroupbyMap = {};
            let itemTeamsMap = {};
            let itemSprintsMap = {};
            let chartType = this.graphCriteria.chartType;
            this.loadItemsPopup(itemDaysMap, selectedGraph.name, this.chartData.average, this.widgetData.type, fromStatusTitle, toStatusTitle, itemDatesMAp, grouping, itemTeamsMap, itemSprintsMap, chartType,itemStatusMap);
        },

        loadItemsPopup: function (itemDaysMap, graphName, average, graphType, from, to, itemsGroupMap, grouping, itemTeamsMap, itemSprintsMap, chartType,itemStatusMap) {
            this.popupData = [];
            this.popupData.graphType = "Flow Metrices";
            this.popupData.graphSpecificType = graphType;
            this.popupData.popupTitle = graphName;
            this.popupData.average = average;
            this.popupData.itemStatusMap = itemStatusMap;
            this.popupData.itemDaysMap = itemDaysMap;
            this.popupData.total = _.size(itemDaysMap);
            this.popupData.grouping = grouping;
            this.popupData.chartType = chartType;
            this.popupData.fromStatus = from;
            this.popupData.toStatus = to;
            this.popupData.radioButtonSelection = this.widgetObj.graphCriteria.radioButtonSelection;
            this.popupData.itemDatesMap = itemsGroupMap;
            disableBodyScroll();
            this.isPopupOpen = true;
        },
        //Points Click Actions
        onClickDataPoints: function (itemIds, name, toStatus, fromStatus, type,nameOfGroupby) {
            this.popupData = [];
            this.popupData.graphType = "Flow Metrices";
            this.popupData.graphSpecificType = "cycle-time-graph-detail-view"; //"flow-time-graph-detail";
            this.popupData.itemIds = itemIds;
            this.popupData.total = _.size(itemIds);
            this.popupData.popupTitle = name;
            let itemIdSet = new Set(itemIds);  // Convert itemIds array to a Set

            let filteredItemDaysMap = !_.isEmpty(itemIds) ? Object.fromEntries(
                Object.entries(this.widgetObj.graphCriteria.itemDaysMap).filter(([key]) => {
                    let itemId = key.slice(7, key.indexOf(":"));  // Extract itemId efficiently
                    return itemIdSet.has(itemId);
                })
            ) : {};

            let filteredItemDatesMap = !_.isEmpty(itemIds) ? Object.fromEntries(
                Object.entries(this.widgetObj.graphCriteria.itemsGroupMap).filter(([key]) => {
                    let itemId = key.slice(7, key.indexOf(":"));  // Extract itemId efficiently
                    return itemIdSet.has(itemId);
                })
            ) : {};
            if( this.widgetObj.graphCriteria.radioButtonSelection === 'statusCategory' ){
                if(!_.isEmpty(this.widgetObj.graphCriteria.itemStatusMap)){
                    let filteredItemStatusMap = !_.isEmpty(itemIds) ? Object.fromEntries(
                        Object.entries(this.widgetObj.graphCriteria.itemStatusMap).filter(([key, value]) => {
                            return itemIds?.includes(key);
                        })
                    ):{};
                    this.popupData.itemStatusMap = filteredItemStatusMap;
                }
            }
            this.popupData.itemDaysMap = filteredItemDaysMap;
            this.popupData.itemDatesMap = filteredItemDatesMap;
            this.popupData.chartType = this.widgetObj.graphCriteria.chartType;
            this.popupData.fromStatus = fromStatus;
            this.popupData.toStatus = toStatus;
            this.popupData.radioButtonSelection = this.widgetObj.graphCriteria.radioButtonSelection;
            disableBodyScroll();
            this.isPopupOpen = true;
        },
        filterTeamsForDropDown:function(){


            this.filterTeams = [...new Set(
                this.filterTeams
                    .flatMap(item => Object.values(item)) // Extract all values from the map
                    .filter(value => value !== undefined) // Exclude undefined values
                    .map(value => value.split('-color')[0]) // Extract the part before "-color"
            )]
                .sort((a, b) => {
                    if (a === "No Team") return 1; // Always move "No Team" to the end
                    if (b === "No Team") return -1;
                    return a.localeCompare(b); // Sort alphabetically for other items
                })
                .map((title, index) => ({ id: index + 1, title })); // Add IDs


            this.filteredSelectedTeams = this.filterTeams
                .filter(team => team.title !== undefined)
                .map(team => team.title);
        },
        filterSprintsForDropDown:function(){
            this.filterSprints = [...new Set(
                this.filterSprints
                    .flatMap(item => Object.values(item)) // Extract all values from the map
                    .filter(value => value !== undefined) // Exclude undefined values
            )]
                .sort((a, b) => {
                    if (a === "No Sprint") return 1; // Always move "No Sprint" to the end
                    if (b === "No Sprint") return -1;
                    return a.localeCompare(b); // Sort alphabetically for other items
                })
                .map((title, index) => ({ id: index + 1, title })); // Add IDs


            this.filteredSelectedSprints = this.filterSprints.map(sprint => sprint.title);
        },

    },

})