
const kendisWidgetCompletedStoriesCriteria = Vue.component('kendis-widget-completed-stories-criteria', {
    template:`
		<div id="overlay" class="overlay" style="display: block;">	
			<div class="ui-dialog selectionPopUp">
				<div v-if="showloader" class="loader">
					<div>
						<div class="loaderinteg"></div>
					</div>  
				</div>
				<div class="selectionPopUpHeader DFCB  pd-20 pb-0">
					<span class="fs-18 ftsb widgetPopUpTitle">
						{{this.graphTypeOptionTitle}} / {{this.optionTypeTitle}} / {{this.graphTypeTitle}}
					</span>
					<em title="Close" class="rmv-ico ti-close rnd DAJ p-intial" @click="$emit('close')"></em>
<!--					<em title="Back" class=" mr-10 ti-arrow-left " @click="$emit('back',graphTypeOptionTitle)"></em>-->
				</div>
				<div class="selectionPopUpContentWraper">
				        <div  class="rec lblm">         
                        <label>Enter Title of Graph 
                             <span class="tooltip ml-10 dropTip ttl">
                                 <em class="infotxt"></em> 
                                 <div class="hovtooltip">Enter the title that better explains your graph.</div>
                             </span>
                        </label>                        
                       <input id="graphTitle" maxlength="255" name="Enter Name" class="txsrch filterinput mr-10"  placeholder="Type Graph Name to Save …" v-model="graphName" type="text" />
                       </div>
					<div v-if="(!_.isEmpty(boardListing))" class="rec lblm">
						<label>Select Board</label>
						<div id="piBoard" class="selectcont nwsl FL w-half"><vz-select v-model="selectedBoard" :options="boardListing" empty-selection-text="Select Program Board" label="title" track-by="_id" value-type="object" @close="" @select="getStatusOrIssueTypeDataOnTheBasiesOfSelection()"/></div>
						<span class="tooltip ml-10 dropTip nxt">
						        <em class="infotxt"></em> 
						        <div class="hovtooltip">
                                   Choose a Program board from the dropdown list menu. The list displays the boards you have access to.
                                </div>
                        </span>
					</div>	

                        <div v-if="((!_.isEmpty(issueTypesList) && graphSelected && !_.isEmpty(selectedBoard)  && !_.isEmpty(teamTarget)   && !_.isEmpty(boardListing)  && _.isEmpty(selectedCollection)) || (   !_.isEmpty(selectedBoard) )) " class="rec lblm">
						<label>Select Issue Type</label>
						<div class="DF">
                            <div id="issueType" class="selectcont FL d w-half">
                                <vz-select 
                                    :multiple="true" 
                                    label="name"
                                    empty-selection-text="Select Issue Type" 
                                    class="multi-filter"
                                    value-type="value" 
                                    v-model="selectedIssueType" 
                                    :options="issueTypesList"
                                    :groups-enabled=false
                                    :show-select-all-on-group=false
                                    track-by="id"
                                    @select="clearFilterIfEmptyIssueTypes"
                                />
                            </div>	
                            <span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Choose one or more issue types from the dropdown menu. The widget will display items with the selected issue types from the chosen PI board.
                                </div>
                            </span>
                        </div>	
					</div>
					<div v-if="!_.isEmpty(boardListing) && !_.isEmpty(selectedBoard)  && _.isEmpty(collections)" class="rec lblm">
					    <div class="DFA">
                            <label>Select Status Criteria
                             <span class="tooltip ml-10 dropTip">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip selectStatusCri">
                                    Select either “Individual Status”, “Status Category” or “Creation Date”. The statuses dropdown will adjust based on your choice. Selecting “Status Category” will include all statuses under that category. Selecting the “Creation Date” will select creation date and adjust dropdown to choose “To-Status” of the items.
                                </div>
                             </span>
                             </label>
                         </div>
						<div style="display: inline-block;">
							<div v-for="(option, index) in radioOptions" :key="index" style="display: inline-block;">
								<input  
								type="radio" 
                                :id="option.value" 
                                :value="option.value" 
                                v-model="pickedRadioType" 
                                :checked="index === 0" 
                                @change="handleRadioChange(option.value)" 
                                style="display: inline-block; margin-right: 5px;"  />
								<label :for="option.value" style="display: inline-block; margin-right: 15px;">{{ option.label }}</label>
							</div>
						</div>
					</div>	
					
					<div v-if="!_.isEmpty(filterTypes) && !_.isEmpty(selectedCollection) &&  !_.isEmpty(teamTarget) && !_.isEmpty(selectedGraph) && _.isEmpty(boardListing) && !_.isEmpty(collections)  && graphSelected == true" class="rec lblm">
						<label>Select Graph Groupby</label>
						<div class="DF">
                            <div class="selectcont nwsl FL">
                                <vz-select v-model="selectedFilterType" :options="filterTypes" empty-selection-text="Select Graph Groupby" label="name" track-by="id" value-type="value" @close="" @select="handleFilterTypeSelection()" />
                            </div>
                            <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip">
                                        text test here
                                    </div>
                            </span>
                        </div>
					</div>				

					<div v-if="graphSelected && !_.isEmpty(teamTarget) && !_.isEmpty(selectedFilter) && !_.isEmpty(selectedFilterType) && !_.isEmpty(selectedCollection) " class="rec lblm">
						<label>Select Criteria</label>
						<div class="rec" v-for="(filter,filterIndex) in selectedFilters" :key="filterIndex">	
								<div v-if="filter.id === 'status' && selectedFilterType == 'status' && filterSelected" class="selectcont FL d">
									<vz-select 
										:multiple="true" 
										label="title" 
										track-by="key" 
										:title="filter.title" 
										:disabled="!filter.editable"
										empty-selection-text="Select Status Criteria" 
										class="multi-filter"
										value-type="value" 
										v-model="selectedCondition" 
										:options="optionsList"
										:groups-enabled=true
										:show-select-all-on-group=true
										:key="filter.title"
									/>
								</div>	
								
								<div v-if="filter.id === 'teams' && selectedFilterType == 'teams' && filterSelected" class="selectcont FL d">
									<vz-select :multiple="true" label="title" track-by="id" :title="filter.title"
										empty-selection-text="Select Teams Criteria" class="multi-filter" 
										value-type="value" v-model="selectedCondition" 
										:options="optionsList"
										:groups-enabled=false
									/>
								</div>		
								<span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip">
                                    Select either “Individual Status”, “Status Category” or “Creation Date”. The statuses dropdown will adjust based on your choice. Selecting “Status Category” will include all statuses under that category. Selecting the “Creation Date” will select creation date and adjust dropdown to choose “To-Status” of the items.
                                    </div>
                                </span>				
						</div>
					</div>
					<div v-if="(pickedRadioType === 'status' ) && !_.isEmpty(selectedBoard)  && _.isEmpty(selectedCollection) " class="rec lblm">
						<label>Select Completion Status Criteria</label>
						<div id="selected-condition" class="selectcont FL d w-half">
							<vz-select 
								:multiple="true"
								label="title"   
								empty-selection-text="Select Status" 
								class="multi-filter"
								value-type="value" 
								v-model="selectedCondition" 
								:options="statusList"
								:groups-enabled=true
								:show-select-all-on-group=true
								track-by="ids"
							/>
						</div>	
						<span class="tooltip ml-10 dropTip nxt">
                            <em class="infotxt"></em> 
                            <div class="hovtooltip">
                                Please select one or more Statuses to be displayed.
                            </div>
                        </span>	
					</div>

					<div  v-if=" pickedRadioType == 'statusCategory' && !_.isEmpty(selectedBoard)  && _.isEmpty(selectedCollection) " class="rec lblm">
                                <label>Select Completion Status Categories</label>
                                <div id="selected-condition" class="selectcont FL d w-half"><vz-select v-model="selectedCondition" :multiple="true"  :options="categoryList" empty-selection-text="Select Status Category" label="title" track-by="ids" value-type="value" @close=""/></div>
                            <span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Please select one or more Statuses to be displayed.
                                </div>
                            </span>	
                           
                     </div>		
                        <div v-if="((!_.isEmpty(issueTypesList) && graphSelected && !_.isEmpty(selectedBoard)  && !_.isEmpty(teamTarget)   && !_.isEmpty(boardListing)  && _.isEmpty(selectedCollection)) || (   !_.isEmpty(selectedBoard) )) "  class="rec lblm">
						<div class="DFA">
					        <label>Enter Team Target (in percentage)
					        <span class="tooltip ml-10 dropTip ttl">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">Enter Team Target (in percentage) that better explains your graph.</div>
                            </span>
                            </label>
                        </div>
                                <input id="teamTargetId" maxlength="5" name="Enter Name"  class="txsrch filterinput mr-10 FL d w-half" placeholder="Type Team Target"  v-model="teamTarget" type="text" @input="validatePositiveInput"/>					
                         </div>
				</div>
				<div class="rec btn">
					 <button  type="button" class="button rds4 FR" @click="getGraphDataOnTheBasiesOfSelection()">Save</button> 
				</div>
			</div>	
		</div>
	`,

    props : {
        graphTypeOptionTitle    : null,
        optionTypeTitle         : null,
        graphTypeTitle          : null,
        dashboardSelected       : null,
        widgetType              : null
    },

    watch : {},

    data() {
        return {
            graphName:'',
            boardListing: [],
            selectedBoard: {},
            eventStartDate: '',
            eventEndDate: '',
            cfdResponceData: {},
            boardTeamListing: [],
            selectedBoardTeams: {},
            boardSprintListing: [],
            selectedBoardSprint: {},
            statusListing: {
                startOfStatusListing: [],
                startOfSelectedStatus: {},
                endOfStatusListing: [],
                endOfSelectedStatus: {},
            },
            format: 'MMM dd yyyy',
            collections: [],
            selectedCollection: '',
            filterList: [],
            additionalFilterCriteriaList: [{name: "Status Category", id: "statusCategory"}],
            additionalGraphOptionList: [{name: "Column With Breakdown", id: "colBreakDown"}],
            selectedFilter: null,
            selectedAdditionalFilterCriteria: null,
            selectedAdditionalGraphOption: null,
            selectedCondition: [],
            selectedStatusCategory: "0",
            filterSelected: false,
            graphsList: [{name: "Pie Chart", id: "1"}, {name: "Bar Chart", id: "2"}, {name: "Column Chart", id: '3'}],
            graphsListCFD: [{name: "Column Chart", id: '3'}, {
                name: "Basic Area Chart",
                id: '4'
            }, {name: "Stacked Area Chart", id: '5'}],
            graphsListFlowTime: [{name: "Column Chart", id: '3'}],
            filterTypes: [{name: "Status", id: "status"}, {name: "Teams", id: "teams"}],
            filterTypesCFD: [{name: "CFD", id: "cfd"}],
            selectedFilterType: null,
            selectedGraph: '3',
            graphSelected: false,
            popupData: [],
            selectedFilters:[
                {
                    id: "status",
                    title: "Status",
                    values: [],
                    operator: 'IN',
                    disabled: true,
                    remove: true,
                    editable: true
                },
                {id: "teams", title: "Teams", values: [], operator: 'IN', disabled: true, remove: true, editable: true}
            ],
            selectedInterval: '40',
            intervalList: [{id: '5', title: '5'}, {id: '10', title: '10'}, {id: '20', title: '20'}, {
                id: '40',
                title: '40'
            }, {id: '50', title: '50'}, {id: 'custom', title: 'custom'}],

            customInterval: null,
            pagination: {
                avoidPaginatorAtFirstLoad: true,
                pageSize: 50,
                pageIndex: 0,
                pageSizeOptions: [50, 100, 200],
                totalItemSize: 0
            },
            nextPageFirstItem: undefined,
            selectedTileItems: [],
            conditionsList: [],
            filteredData: [],
            teamTarget: '',
            widgets: [],
            collectionSelected: false,
            filterTypeSelected: false,
            optionsList: [],
            statusList: [],
            selectedStatus: null,
            radioOptions: [
                {label: 'Status', value: 'status'},
                {label: 'Status Category', value: 'statusCategory'},
            ],
            radioOptionsLeadTime: [
                {label: 'Status', value: 'status'},
                {label: 'Status Category', value: 'statusCategory'},
                {label: 'Creation date', value: 'creationDate'},
            ],
            leadTimePickedRadioType:'creationDate',
            radioOptionsDistributionTime: [{label: 'Percentage', value: 'percentage'}, {label: 'Numbers', value: 'numbers'},],
            pickedYAxisRadioType:'numbers',
            pickedRadioType: 'status',
            categoryList:[],
            selectedIssueType:null,
            issueTypesList:[],
            additionalCriteriaForFlowTime : [{name: "Issue Type", id: "issueType"}],
            selectedAdditionalCriteriaForFlowTime:null,
            showloader:false,
            flowTimeLineGroupByList:[
                {name:"Teams",id:"teams"},
                {name:"Assignee",id:"assignee"}
            ],
            selectedFlowTimeLineGroupBy:null,
            xAxisList:[
                {name:"Sprints",id:"sprints"},
                {name:"Weekly",id:"weekly"},
                {name:"Monthly",id:"monthly"},
            ],
            xAxisListForFlowTime:[
                {name:"Sprints",id:"sprints"},
                {name:"Weekly",id:"weekly"},
                {name:"Monthly",id:"monthly"},
            ],

            selectedXAxis:"sprints",
            sessionBoard:[],
            boardType:null,
            tfsProjects:[],
            jiraFieldsMap:{},
            selectedActiveStatus:[],
            toggleCreationDate:false,
            toggleAdvanceCriteria:false,
            toggleAdvanceCalculation:false,
            cfdCriteriaList:[{id:'default',title:'Select'},{id: 'teams', title: 'Teams'}],
            selectedCFDCriteria:null,
            criteriaContentList:[],
            selectedCriteriaContent:null,
            completedStatuses :null,
            activeStatuses:null,
            inProgressStatuses:null,
            toggleAvgLeadTime :false,
            toggleAvgCycleTime:false,
            toggleAvgWIPTime:false,
            toggleAvgArrivalTime:false,
            toggleAvgThroughputTime:false,
            teams:[],
            sprints:[],
            fromStatusList:[],
            toStatusList:[],
            activeStatusList:[],
            inProgressStatusList:[],
            issueType:null,
            meta : {},
            chartType:'line',
            chartTypeList:[{'id':'line',name:'Line Graph'},{'id':'column',name:'Stack Graph'}],
            boardItemsFilterList:[{'id':'all-items',name:'All Items'},{'id':'planned-items',name:'Planned Items'},{'id':'unplanned-items',name:'Unplanned Items'}],
            boardItemsFilter:'planned-items',
            searchTerm:'',
            selectedIssueType: '',  // Selected issue type
            selectedItems: [],      // Stores selected item IDs
            searchResults: [],       // Stores search results from the API
            filter:{},
            filterwithMeta:{},
        }
    },
    watch: {
        pickedRadioType(newValue, oldValue) {
            this.selectedCondition = [];
        },
    },
    created() {
        this.getBoardOrOrgDataOnTheBasiesOfSelection();
        if(this.optionTypeTitle === 'Cumulative Flow Diagram'){
            this.xAxisList.splice(1, 0, { name: "Days", id: "days" });
        }
    },

    mounted() {
        if(this.graphTypeOptionTitle === 'Cumulative Flow Diagram' || this.graphTypeOptionTitle === 'Flow Time Metrics'){
            this.selectedFilterType ='cfd';
            this.graphSelected = true;
            this.selectedGraph = '5';
            if(this.optionTypeTitle === 'Lead Time Graph'){
                this.pickedRadioType = 'creationDate';
            }
        }

    },

    computed: {

        checkExternalValue() {
            return function (value) {
                return value === true;
            };
        },
    },

    components: {
        vuejsDatepicker,
        VueAdsPagination : window["vue-ads-pagination"].default,
        VueAdsPageButton : window["vue-ads-pagination"].VueAdsPageButton,
    },

    methods: {
        filterSelectedBoardSprint(selectedBoardSprint) {
            const { id, title, label, startDate, endDate } = selectedBoardSprint;
            return { id, title, label, startDate, endDate };
        },
        validatePositiveInput(event) {
            const input = event.target.value;

            // Regex to match numbers between 0-100 with up to 2 decimal places
            const validPattern = /^(100(\.0{0,2})?|(\d{1,2}(\.\d{0,2})?))$/;

            if (validPattern.test(input)) {
                this.teamTarget = input; // Allow valid input
            } else {
                // Remove invalid characters
                const correctedValue = input
                    .replace(/[^0-9.]/g, '') // Remove non-numeric and non-dot characters
                    .replace(/^0+(?!\.|$)/, '') // Remove leading zeros unless a decimal
                    .replace(/(\.\d{2})\d+/, '$1'); // Limit decimals to 2 digits

                // Ensure value is capped at 100
                this.teamTarget = parseFloat(correctedValue) > 100 ? '100' : correctedValue;
            }
        },
        clearFilterIfEmptyIssueTypes(){
            if(_.isEmpty(this.selectedIssueType)){
                this.resetFilter();
            }
        },

        resetFilter() {
            this.filter = {};
            this.filterwithMeta={};
            this.selectedItems = [];
        },

        handleSearch() {
            this.validateItemSearchCriteria();
        },
        validateItemSearchCriteria() {
            let error = false;

            if (_.isEmpty(this.selectedBoard)) {
                $("#piBoard").addClass("red");
                error = true;
            } else {
                $("#piBoard").removeClass("red");
            }

            if (_.isEmpty(this.selectedIssueType)) {
                $("#issueType").addClass("red");
                error = true;
            } else {
                $("#issueType").removeClass("red");
            }

            if (_.isEmpty(this.searchTerm.trim())) {
                $("#searchTerm").addClass("red");
                error = true;
            } else {
                $("#searchTerm").removeClass("red");
            }
            if (_.isEmpty(this.teamTarget.trim())) {
                $("#teamTargetId").addClass("red");
                error = true;
            } else {
                $("#teamTargetId").removeClass("red");
            }

            if (error) {
                showTopMessage("Please enter something to search","warning", 2000);
            } else {
                let data = {
                    sessionBoardId: this.selectedBoard.activeSessionBoard,
                    issueTypes: this.selectedIssueType,
                    searchText: this.searchTerm
                };

                axios.post('/dashboard/searchItems/', data).then(response => {
                    let itemsList = response.data.itemsList;
                    this.searchResults = itemsList;
                    let $container = $("#srch-lst-cont");
                    $container.empty();
                    let htmlArray = [];

                    itemsList.forEach(itm => {
                        let key = itm.jiraKey ? itm.jiraKey : itm.tfsId;
                        if(key==undefined){
                            key="";
                        }
                        let ui = '<span class="item-title"><a target="_blank">' + key + '</a> ' + itm.title + '</span>';
                        let selectedClass = !_.isEmpty(this.selectedItems) ? (this.selectedItems?.indexOf(itm.id) > -1 ? 'SELECTED-ITEM' : ''): '';

                        let backgroundColorStyle = !_.isEmpty(this.selectedItems) ? (this.selectedItems?.indexOf(itm.id) > -1 ?
                            ' style="background-color: rgba(0, 0, 0, 0.05); color: #fff;"' : ''):'';

                        let tickIcon = !_.isEmpty(this.selectedItems) ? (this.selectedItems?.indexOf(itm.id) > -1 ?
                            '<span class="tick-icon">&#10003;</span>' : ''):''; // Checkmark

                        htmlArray.push('<li class="ITM ' + selectedClass + '"' + backgroundColorStyle +
                            ' data-id="' + itm.id + '" data-title="' + itm.title  + '" data-key="' + key + '" >' + ui + tickIcon + '</li>');
                    });


                    if (htmlArray.length === 0) {
                        htmlArray.push('<span class="NO-RESULT nofound DB mt-10">No search results</span>');
                    }

                    $container.html('<ul id="rslt">' + htmlArray.join('') + '</ul>');

                    this.$nextTick(() => {
                        document.querySelectorAll('#rslt li').forEach(item => {
                            item.addEventListener('click', (event) => {
                                this.toggleItemSelection(event.currentTarget.getAttribute('data-id'),event.currentTarget.getAttribute('data-title'),event.currentTarget.getAttribute('data-key'));
                            });
                        });

                        document.querySelectorAll('#rslt li .clickable-link').forEach(link => {
                            link.addEventListener('click', (event) => {
                                event.preventDefault();
                                event.stopPropagation();
                                let li = event.target.closest('li');
                                this.toggleItemSelection(li.getAttribute('data-id'),li.getAttribute('data-title'), li.getAttribute('data-key'));
                            });
                        });
                    });

                    console.log("Selected Items",this.selectedItems);
                    $container.show();
                }).catch(error => {
                    console.log("Error occurred", error);
                });
            }
        },
        toggleItemSelection(id, title, key) {
            let index = !_.isEmpty(this.selectedItems) ? this.selectedItems.indexOf(id) : -1;
            if (index === -1) {
                if (id !== null && id !== undefined) {
                    if (_.isEmpty(this.filter)) {
                        this.filter = {};
                        this.filterwithMeta={};
                    }
                    Vue.set(this.filter, id, title);
                    Vue.set(this.filterwithMeta, id, { title: title, key: key });
                } else {
                    console.log("Invalid id, item not inserted:", id);
                }
                this.selectedItems.push(id);
            } else {
                this.selectedItems.splice(index, 1);
                if (id in this.filter) {
                    Vue.delete(this.filter, id);
                    Vue.delete(this.filterwithMeta, id);
                }
            }
            this.updateSelectedStyles(id);
        },
        onRemoveTag: function(id) {
            let index = this.selectedItems?.findIndex(itemIds => itemIds === id);

            if (index !== -1) {
                this.selectedItems.splice(index, 1);
                if (id in this.filter) {
                    Vue.delete(this.filter, id);
                    Vue.delete(this.filterwithMeta, id);
                }
            }
        },
        updateSelectedStyles(jiraId) {
            const elements = document.querySelectorAll(`[data-id="${jiraId}"]`);
            elements.forEach(el => {
                if (this.selectedItems.indexOf(jiraId) > -1) {
                    el.style.backgroundColor = 'rgba(0, 0, 0, 0.05)';
                    el.style.color = '#fff';

                    if (!el.querySelector('.tick-icon')) {
                        const tickIcon = document.createElement('span');
                        tickIcon.className = 'tick-icon';
                        tickIcon.innerHTML = '&#10003;';
                        //tickIcon.style.marginLeft = '8px';
                        el.appendChild(tickIcon);
                    }
                } else {
                    el.style.backgroundColor = '';
                    el.style.color = '';

                    const tickIcon = el.querySelector('.tick-icon');
                    if (tickIcon) {
                        el.removeChild(tickIcon);
                    }
                }
            });
        },

        isNumber:function(value) {
            return /^-?\d+$/.test(value);
        },
        checkAllThingsAreSelectedToEnableSaveButton : function(){
            if(_.isEmpty(this.selectedIssueType)){
                this.filter = {};
                this.filterwithMeta = {};
                this.selectedItems = {};
            }
            if(this.optionTypeTitle === 'Cumulative Flow Diagram'){
                if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.boardItemsFilter)  && !_.isEmpty(this.selectedCondition) && !_.isEmpty(this.selectedXAxis) && !_.isEmpty(this.teamTarget) && !_.isEmpty(this.pickedRadioType)){
                    if(!_.isEmpty(this.selectedCFDCriteria)  ){
                        if(this.selectedCFDCriteria === 'teams' && _.isEmpty(this.selectedCriteriaContent))
                        {
                            $("#criteria-content").addClass("red");
                            $("#graphTitle").removeClass("red");
                            $("#piBoard").removeClass("red");
                            $("#teamTargetId").removeClass("red");
                            $("#selected-condition").removeClass("red");

                            return false;
                        }
                    }
                    return true;
                }
                else{
                    if(_.isEmpty(this.teamTarget)){
                        $("#teamTargetId").addClass("red");
                    }
                    if (!_.isEmpty(this.teamTarget)) {
                        if (this.teamTarget.trim() === "") {
                            $("#teamTargetId").addClass("red");
                        } else {
                            $("#teamTargetId").removeClass("red");
                        }
                    }

                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }if(_.isEmpty(this.teamTarget)){
                        $("#teamTargetId").addClass("red");
                    }
                    if(!_.isEmpty(this.teamTarget)){
                        $("#teamTargetId").removeClass("red");
                    }
                    if( _.isEmpty(this.selectedCondition)){
                        $("#selected-condition").addClass("red");
                    }
                    if( !_.isEmpty(this.selectedCondition)){
                        $("#selected-condition").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").removeClass("red");
                    }
                    if(_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").addClass("red");
                    }
                    if(!_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").removeClass("red");
                    }
                    return false;
                }
            }
            else if(this.optionTypeTitle =='Item Completion by Teams'){

                if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedBoardSprint) && !_.isEmpty(this.selectedIssueType)  && !_.isEmpty(this.teamTarget) && !_.isEmpty(this.pickedRadioType) &&  !_.isEmpty(this.selectedActiveStatus) ){
                    return true;
                }else{
                    return false;
                }
            }
            // else if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedCondition) && this.eventStartDate != ''  && this.eventEndDate != '' && !_.isEmpty(this.teamTarget)){
            //     /*if(!_.isEmpty(requestBody) && ( (requestBody["teams"] && !_.isEmpty(selectedBoardTeams)) || (requestBody["sprints"] && !_.isEmpty(selectedBoardSprint)) )){
            //         return true;
            //
            //     }else if(_.isEmpty(requestBody)){
            //
            //         return true;
            //     }*/
            //     return true;
            // }
            else {
                if ( !_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedIssueType)&& !_.isEmpty(this.graphName)  && !_.isEmpty(this.selectedCondition) && (this.teamTarget!=undefined && this.teamTarget!=null && this.teamTarget!="")) {
                    return true;
                } else {
                    if(_.isEmpty(this.selectedBoard)){
                        if(_.isEmpty(this.selectedBoard)){
                            $("#piBoard").addClass("red");
                        }
                    }
                    else{
                            $("#piBoard").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedIssueType)){
                        if(_.isEmpty(this.selectedIssueType)){
                            $("#issueType").addClass("red");
                        }
                    }
                    else{
                            $("#issueType").removeClass("red");
                    }
                    if(_.isEmpty(this.graphName)){
                            $("#graphTitle").addClass("red");
                    }
                    else{
                            $("#graphTitle").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedCondition)){
                            $("#selected-condition").addClass("red");
                    }
                    else{
                            $("#selected-condition").removeClass("red");
                    }
                    if(this.teamTarget!=undefined && this.teamTarget!=null && this.teamTarget!=""){
                            $("#teamTargetId").removeClass("red");
                    }
                    else{
                            $("#teamTargetId").addClass("red");
                    }
                    return false;
                }
            }
        },

        getEmptyMeta : function(){
            return {
                _teamsMap 			: _.keyBy(this.sessionBoard.teams,'id'),
                _sprintsMap 		: _.keyBy(this.sessionBoard.containers,'id'),
                linkTypes			: [],
                _parentStatuses		: [],
                _childStatuses 		: [],
                _allIssueTypes		: [],
                _jiraProjectIssueTypes : []
            };
        },
        handleGroupBySelection:function(){
            let requestBody = {};
            requestBody.groupBy = this.selectedFlowTimeLineGroupBy;
            requestBody.boardId = this.selectedBoard.activeSessionBoard;
            if(this.selectedFlowTimeLineGroupBy === 'jiraProject'){
                requestBody.boardId = this.selectedBoard._id;
            }
            axios.post('/dashboard/fetchGroupByOptions/' , requestBody).then(response => {
                console.log("response: ", response);
            })
        },

        handleAdvanceSelection:function(){
            if(this.selectedCFDCriteria == 'teams')
            { this.criteriaContentList =  this.teams; }
            else if(this.selectedCFDCriteria == 'sprints'){
                this.criteriaContentList =  this.sprints;
            }else{
                this.selectedCriteriaContent = [];
            }
        },

        toggleAvgLeadTimeCal() {
            this.toggleAvgLeadTime = !this.toggleAvgLeadTime;
        },

        toggleAvgCycleTimeCal(){
            this.toggleAvgCycleTime = !this.toggleAvgCycleTime;
        },

        toggleAvgWIPTimeCal(){
            this.toggleAvgWIPTime = !this.toggleAvgWIPTime;
        },

        toggleAvgArrivalTimeCal(){
            this.toggleAvgArrivalTime = !this.toggleAvgArrivalTime;
        },

        toggleAvgThroughputTimeCal(){
            this.toggleAvgThroughputTime = !this.toggleAvgThroughputTime;
        },

        toggleAdvanceCriteriaAccordian(){
            this.toggleAdvanceCriteria = !this.toggleAdvanceCriteria;
        },

        toggleAdvanceCalculationAccordian(){
            this.toggleAdvanceCalculation = !this.toggleAdvanceCalculation;
        },

        toggleCreationDateButton(){
            this.toggleCreationDate = !this.toggleCreationDate;
            this.statusListing.endOfSelectedStatus = {};
            this.statusListing.startOfSelectedStatus = {};
        },

        onClickAddWidget : function(){
            this.openDashboardWidgetsOptions = true;
        },

        onSelectingStatusFilterDataForEndStatus : function(){
            this.statusListing.endOfSelectedStatus = {};
            let indexOfSelectedItem = _.findIndex(this.statusListing.startOfStatusListing, this.statusListing.startOfSelectedStatus);

            if(indexOfSelectedItem > -1){

                let newArray = _.cloneDeep(this.statusListing.startOfStatusListing);
                newArray.splice(0,indexOfSelectedItem);
                this.statusListing.endOfStatusListing = newArray;
            }
        },

        getBoardOrOrgDataOnTheBasiesOfSelection : function(){
            if(this.graphTypeTitle == "For items in PI" || this.graphTypeTitle == "For items in a Team in PI" || this.graphTypeTitle == "For items in a Sprint in PI" ){
                this.getAllAccessableBoardsListing();
            }
            else if(this.graphTypeTitle === "For Backlog Items (Org)"){
                this.fetchAllCollections();
            }
        },

        getStatusOrIssueTypeDataOnTheBasiesOfSelection : function(){
            this.selectedItems = [];
            this.filter = {};
            this.getAllAccessableBoardStartEndStatusListing(this.selectedBoard._id);
            this.getPIStartEndDates(this.selectedBoard.activeSessionBoard);
            // if(this.graphTypeTitle == "For items in a Team in PI"){
            //     this.getSelectedBoardTeamAndSprintList(true);
            //
            // }else if(this.graphTypeTitle == "For items in a Sprint in PI"){
            //     this.getSelectedBoardTeamAndSprintList(null,true);
            // }
            this.getSelectedBoardTeamAndSprintList(true,true);
            this.getCFDAdvanceCriteria(this.selectedBoard._id);
            this.getIssueTypes(this.selectedBoard.activeSessionBoard);

        },

        handleAdditionalCriteriaForFlowTime:function(){
            if(this.selectedBoard.activeSessionBoard){
                this.getIssueTypes(this.selectedBoard.activeSessionBoard);
            }
        },
        getIssueTypes: function(boardId) {
            let param = { alm: true };
            this.showloader = true;

            axios.get('/dashboard/fetchALMTFSMeta/' + boardId)
                .then(response => {
                    this.showloader = false;

                    if (_.isEmpty(response.data)) {
                        return;
                    }

                    if (response.data.jiraFields) {
                        this.processJiraFields(response.data);
                    } else if (response.data.tfsProject) {
                        this.processTfsProjects(response.data);
                    }
                    const kendisOnlyIssueType = {
                        id: "Kendis Only",
                        name: "Kendis Only",
                        iconUrl: ""
                    };
                    if (!this.issueTypesList.some(item => item.id === kendisOnlyIssueType.id)) {
                        this.issueTypesList.unshift(kendisOnlyIssueType);
                    }

                    this.createBacklogGroups();
                })
                .catch(error => {
                    this.showloader = false;
                    console.error(error);
                });
        },

        processJiraFields: function(data) {
            this.boardType = 'jiraBoard';
            let allIssueTypes = [];

            if (!_.isEmpty(data.jiraProjectIssueTypes)) {
                data.jiraProjectIssueTypes?.forEach(issueTypeGroup => {
                    if(!_.isEmpty(issueTypeGroup.issueTypes)){
                        let issueTypes = JSON.parse(issueTypeGroup.issueTypes);
                        allIssueTypes = allIssueTypes.concat(issueTypes);
                    }
                });

                let uniqueIssueTypes = new Set();
                let filteredIssueTypes = [];

                allIssueTypes.forEach(item => {
                    if (!uniqueIssueTypes.has(item.id)) {
                        uniqueIssueTypes.add(item.id);
                        filteredIssueTypes.push({ id: item.id, name: item.name, iconUrl: item.iconUrl });
                    }
                });

                this.issueTypesList = filteredIssueTypes;

            } else {
                this.issueTypesList = [];
            }
            this.sessionBoard = data.sessionBoard;
            this.jiraFieldsMap = JSON.parse(data.jiraFields);
        },

        processTfsProjects: function(data) {
            this.boardType = 'tfsBoard';
            let filteredIssueTypes = [];
            let seenIssueTypes = new Set();

            if (!_.isEmpty(data.tfsProject)) {
                data.tfsProject.forEach(project => {
                    if(!_.isEmpty(project.itemTypesStr)){
                        let obj = JSON.parse(project.itemTypesStr).value;

                        obj.forEach(item => {
                            if (!seenIssueTypes.has(item.name)) {
                                seenIssueTypes.add(item.name);
                                filteredIssueTypes.push({ id: item.name, name: item.name, iconUrl: item.url });
                            }
                        });
                    }
                });

                this.issueTypesList = filteredIssueTypes;
                this.tfsProjects = data.tfsProject;
            } else {
                this.issueTypesList = [];
                // Optionally show an alert here
            }
        }
        ,
        populateTeamsAndSprintData : function(response,requestBody){

            if(requestBody['teams']){

                let teamSequence = response['teamSequence'];
                let teamsGroupBy = _.groupBy(response['teams'],'_id');

                for(let teamId of teamSequence){
                    if(teamsGroupBy[teamId]) {
                        this.boardTeamListing.push(teamsGroupBy[teamId][0]);
                    }
                }
            }

            if(requestBody['sprints']){

                this.boardSprintListing = response["sprints"];
                this.boardSprintListing=this.boardSprintListing.filter(sprint =>sprint.startDate && sprint.endDate);
                const getDateOnly = timestamp => {
                    const date = new Date(timestamp);
                    return new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime();
                };

                const currentDate = getDateOnly(Date.now()); // Normalize current date to 00:00:00

                this.boardSprintListing = this.boardSprintListing.filter(sprint => {
                    return sprint.startDate && getDateOnly(sprint.startDate) <= currentDate;
                });

// Find the sprint that matches the current date (date comparison only)
                this.selectedBoardSprint = this.boardSprintListing.find(sprint =>
                    currentDate >= getDateOnly(sprint.startDate) && currentDate <= getDateOnly(sprint.endDate)
                );

                if (!this.selectedBoardSprint) {
                    // If no sprint matches the current date, find the closest sprint
                    this.selectedBoardSprint = this.boardSprintListing.reduce((closest, sprint) => {
                        const currentDiff = Math.abs(sprint.startDate - currentDate);
                        const closestDiff = closest ? Math.abs(closest.startDate - currentDate) : Infinity;

                        return currentDiff < closestDiff ? sprint : closest;
                    }, null);
                }
            }
        },


        getSelectedBoardTeamAndSprintList : function(teamFlag,sprintFlag){
            let requestBody = {};
            if(teamFlag){
                requestBody['teams'] = 'teams';
            }

            if(sprintFlag){
                requestBody['sprints'] = 'sprints';
            }

            let _this = this;
            let boardId = this.selectedBoard.activeSessionBoard;
            axios.post('/dashboard/get-board-teams-sprints/'+ boardId , requestBody)
                .then(response => {

                    try{
                        if (response.data) {

                            this.populateTeamsAndSprintData(response.data,requestBody);
                        }
                    }catch(e){
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }

                }).catch(error => {
                console.log(error);
                handleErrorSprintReportMsg(error);
            });
        },

        getAllAccessableBoardStatusListing : function(boardId){
            let _this = this;
            axios.get('/dashboard/get-status-listing/'+ boardId)
                .then(response => {
                    try{
                        let groupedItems = {};

                        for (let status of response.data) {
                            if (!groupedItems[status.title]) {
                                groupedItems[status.title] = {
                                    title: status.title,
                                    ids: [],
                                    category: status.category,
                                };
                            }
                            groupedItems[status.title].ids.push(status.id);
                        }

                        let resultList = Object.values(groupedItems);

                        if (resultList) {
                            _this.statusListing.startOfStatusListing = resultList;
                            let categoryMap = new Map();
                            for (let i = 0; i < _this.statusListing.startOfStatusListing.length; i++) {
                                let category =_this.statusListing.startOfStatusListing[i].category ;
                                if (!categoryMap.has(category)) {
                                    categoryMap.set(category, []);
                                }
                                let condition = {"ids":_this.statusListing.startOfStatusListing[i].ids, "title": _this.statusListing.startOfStatusListing[i].title}
                                categoryMap.get(category).push(condition);
                            }
                            let sortedEntries = Array.from(categoryMap.entries());
                            const order = ["ToDo", "InProgress", "Done","Misc"];
                            sortedEntries.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));
                            categoryMap = new Map(sortedEntries);
                            let categoryList = [];
                            categoryMap.forEach((items, category) => {
                                categoryList.push({
                                    title: category,
                                    items: items
                                });
                            });
                            _this.statusList=categoryList;
                        }
                    }catch(e){
                        //  showTopMessage("Some error has occurred while fetching board statuses",'warning','4000');
                        this.showloader =false;
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }

                }).catch(error => {
                //  showTopMessage("Some error has occurred while fetching board statuses",'warning','4000');
                this.showloader =false;
                console.log(error);
                handleErrorSprintReportMsg(error);
            });
        },
        getPIStartEndDates: function(boardId) {
            let _this = this;
            axios.get('/dashboard/get-start-end-date/' + boardId)
                .then(response => {
                    try {
                        if (!_.isEmpty(response.data)) {
                            _this.eventStartDate = new Date(response.data.startDate);
                            _this.eventEndDate = new Date(response.data.endDate);
                        } else {
                            let currentDate = new Date();
                            _this.eventStartDate = currentDate;
                            _this.eventEndDate = currentDate;
                        }
                    } catch (e) {
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }
                })
                .catch(error => {
                    console.log(error);
                    handleErrorSprintReportMsg(error);
                });
        },

        getAllAccessableBoardStartEndStatusListing: function (boardId) {
            let _this = this;
            axios.get('/dashboard/get-status-listing/' + boardId)
                .then(response => {
                    try {
                        let groupedItems = {};

                        for (let status of response.data) {
                            if (!groupedItems[status.title]) {
                                groupedItems[status.title] = {
                                    title: status.title,
                                    ids: [],
                                    category: status.category,
                                };
                            }
                            groupedItems[status.title].ids.push(status.id);
                        }

                        let resultList = Object.values(groupedItems);

                        if (resultList) {
                            _this.statusListing.startOfStatusListing = resultList;
                            _this.statusListing.endOfStatusListing = resultList;

                            let categoryMap = new Map();
                            let statuscategoryMap = new Map();

                            for (let i = 0; i < resultList.length; i++) {
                                let category = resultList[i].category;
                                if (!categoryMap.has(category)) {
                                    categoryMap.set(category, []);
                                }
                                if (!statuscategoryMap.has(category)) {
                                    statuscategoryMap.set(category, []);
                                }
                                let condition = {
                                    ids: resultList[i].ids,
                                    title: resultList[i].title
                                };
                                categoryMap.get(category).push(condition);
                                let conditionStatusCategory = resultList[i].ids;
                                statuscategoryMap.get(category).push(conditionStatusCategory);
                            }

                            let sortedEntries = Array.from(categoryMap.entries());
                            let sortedEntriesForStatusCategory = Array.from(statuscategoryMap.entries());

                            const order = ["ToDo", "InProgress", "Done", "Misc"];
                            sortedEntries.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));
                            sortedEntriesForStatusCategory.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));

                            let transformedEntriesForStatusCategory = sortedEntriesForStatusCategory.map(entry => {
                                let category = entry[0];
                                let nestedArrays = entry[1];
                                let uniqueIdsList = [];
                                for (let i = 0; i < nestedArrays.length; i++) {
                                    let nestedArray = nestedArrays[i];
                                    for (let j = 0; j < nestedArray.length; j++) {
                                        if (!uniqueIdsList.includes(nestedArray[j])) {
                                            uniqueIdsList.push(nestedArray[j]);
                                        }
                                    }
                                }
                                return {
                                    key: category,
                                    value: {
                                        ids: uniqueIdsList
                                    }
                                };
                            });

                            categoryMap = new Map(sortedEntries);

                            let categoryList = [];
                            categoryMap.forEach((items, category) => {
                                categoryList.push({
                                    title: category,
                                    items: items
                                });
                            });

                            let statusCategoryList = [];
                            transformedEntriesForStatusCategory.forEach((items) => {
                                statusCategoryList.push({
                                    title: items.key,
                                    ids: items.value.ids.join(","),
                                });
                            });
                            _this.statusList = categoryList;
                            _this.fromStatusList = categoryList;
                            _this.toStatusList = categoryList;
                            _this.categoryList = statusCategoryList;
                        }
                    } catch (e) {
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }
                })
                .catch(error => {
                    console.log(error);
                    handleErrorSprintReportMsg(error);
                });
        }
        ,

        getCFDAdvanceCriteria:function(boardId){
            let _this = this;
            axios.get('/dashboard/get-cfd-advance-criteria/'+ boardId)
                .then(response => {
                    try {
                        this.teams = response.data.teams;
                        this.sprints = response.data.sprints;
                    }
                    catch (e){
                        console.error(e);
                    }
                });

        },

        getAllAccessableBoardsListing : function(){
            let _this = this;
            this.showloader =true;
            axios.get('/dashboard/get-board-listing/')
                .then(response => {
                    try{
                        if (response.data) {
                            _this.boardListing = response.data;
                        }
                        if( _.isEmpty(_this.boardListing)){
                            showTopMessage("No PI Board is present, Please create a new PI Board and Select that to continue",'warning',5000);
                            this.showloader =false;
                            return;
                        }
                        this.showloader =false

                    }catch(e){
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                        this.showloader =false
                    }
                }).catch(error => {
                console.log(error);
                handleErrorSprintReportMsg(error);
                this.showloader =false
            });
        },

        fetchAllCollections: function () {
            let _this = this;
            let data = {};
            data.fetchTypes = false;
            axios.post("/dashboard/fetch-all-release-trains", data)
                .then(response => {
                    if (response.data) {
                        _this.collections = response.data.releaseTrains;
                    }
                }).catch(error => {
                console.error(error);
            });
        },

        handleGraphSelection:function(){
            this.graphSelected=true;
        },

        handleCollectionSelection: function () {
            this.collectionSelected=true;
            this.filterList=[];
            if(!_.isEmpty(this.selectedFilterType)){
                this.handleFilterTypeSelection();
            }
        },

        handleFilterTypeSelection:function(){
            this.filterTypeSelected=true;
            let _this = this;
            if(_this.selectedFilterType !='cfd') {
                data = {"releaseTrainID": _this.selectedCollection.id, "filterType": _this.selectedFilterType};
                axios.post("/dashboard/fetch-release-train-filters", data)
                    .then(response => {
                        _this.filterList = response.data.releaseTrainFilters;
                        this.filterSelected = false;
                    }).catch(error => {
                    console.error(error);
                });
                this.pagination.pageIndex = 0;
                this.pagination.totalItemSize = 0;
            }
        },

        handleFilterSelection:function(){
            this.loadBacklogItems(this.selectedFilterType);
            this.pagination.pageIndex = 0;
            this.pagination.totalItemSize = 0;
            this.filterSelected=true;
            this.pagination.pageIndex = 0;
            this.pagination.totalItemSize = 0;
        },

        loadBacklogItems: function(filterBy) {
            let _this = this;
            let data = {};
            data.hierachLevel = "" + this.selectedFilter.level;
            data.fetchParents  = true;
            data.filterBy=filterBy;
            data.requestId = getNewUUID();
            data.filter = this.selectedFilter.criteria;
            if (data.filter && !_.isEmpty(data.filter.rules)) {
            }else {
                delete data.filter;
            }
            axios.post('/dashboard/' + this.selectedCollection.id + '/retrieveItems', data)
                .then(res => {
                    if (res.data) {
                        var items = [];
                        items = res.data;
                        this.filteredData=[];
                        this.filteredData=items;
                        this.populateConditionsDropdown(items);
                        if(this.selectedFilterType == "teams"){
                            this.selectedCondition = this.conditionsList.map(condition => condition.id);
                        }
                    }
                }).catch(error => {
                console.error(error);
            });
        },

        populateConditionsDropdown:function(responseData){
            this.conditionsList=[];
            if(this.selectedFilterType === "status"){
                const statusMap = responseData.statusMap;
                const statusList = statusMap.statusList;
                this.conditionsList=statusList;
                let categoryMap = new Map();
                for (let i = 0; i < this.conditionsList.length; i++) {
                    let category = this.conditionsList[i].key.split("-")[0];
                    if (!categoryMap.has(category)) {
                        categoryMap.set(category, []);
                    }
                    let condition = {"id":this.conditionsList[i].id,"count":this.conditionsList[i].count,"key": this.conditionsList[i].key, "title": this.conditionsList[i].title}
                    categoryMap.get(category).push(condition);
                }
                let categoryList = [];
                categoryMap.forEach((items, category) => {
                    categoryList.push({
                        title: category,
                        items: items
                    });
                });
                this.optionsList=categoryList;
            }else if(this.selectedFilterType === "teams"){
                const teamsMap = responseData.teamsMap;
                const teamsList = teamsMap.teamsList;
                this.conditionsList=teamsList;
                this.optionsList=teamsList;
            }
            this.filterSelected=true;
        },
        getTitleById:function(id) {
            for (const group of this.flowTimeLineGroupByList) {
                for (const item of group.items) {
                    if (item.id === id) {
                        return item.title;
                    }
                }
            }
            return null; // Return null if no match found
        },

        createBacklogGroups : function (){
            let almData = [];
            let kendisData = {
                id:"kendisGroups",
                items : [{id:'teams',title:"Team"},
                    {id:"cardType",title:"Card Type"},
                    // {id:"plannedUnplanned",title:"Planned/Unplanned"},
                ],
                title : "Group by"
            }
            this.flowTimeLineGroupByList = [];
            if (this.boardType === 'jiraBoard') {
                let additionalFieldArray = [];
                if(!_.isEmpty(this.sessionBoard.session)) {
                    // if (this.sessionBoard.session.jiraFeatureParentEnabled) {
                    //     additionalFieldArray.push({title: 'Parent', id: 'jiraField-parent'});
                    // }
                    // if (this.sessionBoard.session.additionalFieldsEnabled && this.sessionBoard.session.additionalFieldsValuesFeature) {
                    //     for (let featureField of this.sessionBoard.session.additionalFieldsValuesFeature) {
                    //         let fieldData = this.jiraFieldsMap.find(item => (item.key == featureField.key));
                    //         if (fieldData) {
                    //             if (this.sessionBoard.session.jiraFeatureParentEnabled && fieldData.key == 'parent') {
                    //                 continue;
                    //             }
                    //             additionalFieldArray.push({title: fieldData.name, id: 'jiraField-' + fieldData.key});
                    //         }
                    //     }
                    // }
                    // if (this.sessionBoard.session.additionalFieldsEnabled && this.sessionBoard.session.additionalFieldsValuesUserStory) {
                    //     for (let featureField of this.sessionBoard.session.additionalFieldsValuesUserStory) {
                    //         let fieldData = this.jiraFieldsMap.find(item => (item.key == featureField.key));
                    //         if (fieldData) {
                    //             if (this.sessionBoard.session.jiraFeatureParentEnabled && fieldData.key == 'parent') {
                    //                 continue;
                    //             }
                    //             additionalFieldArray.push({title: fieldData.name, id: 'jiraField-' + fieldData.key});
                    //         }
                    //     }
                    // }
                    // if (additionalFieldArray.length > 0) {
                    //     almData = {
                    //         id: "almGroups",
                    //         items: additionalFieldArray,
                    //         title: "By Jira Additional Fields"
                    //     }
                    // }
                    if (!_.isEmpty(this.sessionBoard.session.almConfigurations)) {
                        kendisData.items.push({id: 'jiraProject', title: "Jira Project"});  //tbc
                    }
                }
            }
            else if(this.boardType === 'tfsBoard'){
                almData = {
                    id: "almGroups",
                    items: [{ id: 'tfsProject', title: "Project" },
                        { id: 'areaPath', title: "Area Path" },
                        // { id: 'epic', title: "Parent-Epic" }
                    ],
                    title: "By Azure DevOps Fields"
                }; //tbc
                let duplicationCheckMap = {};
                // _.each(this.tfsProjects, project=> {
                //     if (project.selectedFields) {
                //         _.each(project.selectedFields, fieldMap=> {
                //             if (!duplicationCheckMap[fieldMap.referenceName]) {
                //                 duplicationCheckMap[fieldMap.referenceName] = true;
                //                 let groupByOption = {};
                //                 groupByOption.title = fieldMap.name;
                //                 groupByOption.id = "tfsField-"+fieldMap.referenceName;
                //                 groupByOption.key = fieldMap.referenceName;
                //                 groupByOption.dataType = fieldMap.type;
                //                 almData.items.push(groupByOption);
                //             }
                //         });
                //     }
                // });
            }
            this.flowTimeLineGroupByList.push(kendisData);
            this.flowTimeLineGroupByList.push(almData);
        },

        handleRadioChange(value) {
            this.statusListing.startOfSelectedStatus = "";
            this.statusListing.endOfSelectedStatus = "";
        },

        handleBoardFilterSelection: function() {
            // Handle Cumulative Flow Diagram criteria
            const handleCfdCriteriaList = () => {
                const indexOfTeams = this.cfdCriteriaList.findIndex(item => item.id === 'teams');
                if (this.boardItemsFilter === 'unplanned-items' ) {
                    if (indexOfTeams !== -1) {
                        this.cfdCriteriaList.splice(indexOfTeams, 1);
                        this.selectedCFDCriteria = '';
                    }
                } else {
                    if (indexOfTeams === -1) {
                        this.cfdCriteriaList.push({ id: 'teams', title: 'Team' });
                    }
                }
            };

            // If CFD, handle and return early
            if (this.optionTypeTitle === 'Cumulative Flow Diagram') {
                handleCfdCriteriaList();
                return;
            }

            // Finding the "kendisGroups" object
            const kendisGroups = this.flowTimeLineGroupByList.find(group => group.id === 'kendisGroups');
            if (kendisGroups) {
                const items = kendisGroups.items;

                const removeItemById = (array, id) => {
                    const index = array.findIndex(item => item.id === id);
                    if (index !== -1) array.splice(index, 1);
                };

                const addItemToTop = (array, item) => {
                    if (!array.some(existingItem => existingItem.id === item.id)) {
                        if (array.length > 15) {
                            array.push(item);
                        } else {
                            array.unshift(item);
                        }
                    }
                };

                // Handle group by options based on board filter selection
                const teamsItem = { id: 'teams', title: 'Team' };
                if (this.boardItemsFilter === 'unplanned-items') {
                    removeItemById(items, 'teams');
                } else {
                    addItemToTop(items, teamsItem);
                }
            }
        },
        getGraphDataOnTheBasiesOfSelection : function(){
            if(_.isEmpty(this.boardListing)){
                showTopMessage('You need to create a new board to get started','warning',2000);
            }
            else if(!this.checkAllThingsAreSelectedToEnableSaveButton()){
                showTopMessage("Please provide all the information","warning", 2000);
            }
            else if(this.selectedBoardSprint==null){
                showTopMessage('You need to create a sprint to get started','warning',2000);
            }
            else {
                if (this.graphTypeOptionTitle == "Coaches Goals") {
                    if (this.optionTypeTitle == 'Completion by Teams') {
                        let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                        let selectedCriteriaStatuses = "";
                        if (this.toggleCreationDate === false) {
                            if (this.pickedRadioType == 'statusCategory') {
                                let startIds = this.selectedCondition.join(',').split(',');
                                let uniqueTitles = new Set();

                                for (const status of this.categoryList) {
                                    if (startIds.some(id => status.ids.includes(id))) {
                                        if (!uniqueTitles.has(status.title)) {
                                            uniqueTitles.add(status.title);
                                            selectedCriteriaStatuses += (selectedCriteriaStatuses ? ',' : '') + status.title;
                                        }
                                    }
                                }
                            }
                            else if (this.pickedRadioType == 'status') {
                                let startIds = this.selectedCondition.join(',').split(',');
                                let uniqueTitles = new Set();

                                for (const status of this.statusList) {
                                    for (const item of status.items) {
                                        if (startIds.some(id => item.ids.includes(id))) {
                                            if (!uniqueTitles.has(item.title)) {
                                                uniqueTitles.add(item.title);
                                                selectedCriteriaStatuses += (selectedCriteriaStatuses ? ',' : '') + item.title;
                                            }
                                        }
                                    }
                                }
                            }

                        }
                        let requestBody = {
                            graphName:this.graphName,
                            selectedBoardSprint:this.filterSelectedBoardSprint(this.selectedBoardSprint),
                            sessionBoardId: this.selectedBoard.activeSessionBoard,
                            selectedStatusIds: this.selectedCondition,
                            tenant: this.selectedBoard.tenant,
                            selectedGraph: this.selectedGraph,
                            teamTarget: this.teamTarget,
                            selectedFilterType: this.selectedFilterType,
                            selectedBoard: this.selectedBoard,
                            orignalStartDate: this.eventStartDate,
                            orignalEndDate: this.eventEndDate,
                            startDate: isValidDate(this.eventStartDate) ? this.eventStartDate.format("d mmm yyyy") : '',
                            endDate: isValidDate(this.eventEndDate) ? this.eventEndDate.format("d mmm yyyy") : '',
                            optionTypeTitle: this.optionTypeTitle,
                            graphTypeTitle: this.graphTypeTitle,
                            selectedStatusTitle: selectedCriteriaStatuses,
                            xAxis: this.selectedXAxis,
                            advanceCriteria: this.selectedCFDCriteria,
                            selectedAdvanceCriteria: this.selectedCriteriaContent,
                            selectedActiveStatus: _.isEmpty(this.activeStatuses) ? '' : this.activeStatuses,
                            selectedWaitingStatus: _.isEmpty(this.inProgressStatuses) ? [] : this.inProgressStatuses,
                            selectedCompletedStatus: _.isEmpty(this.completedStatuses) ? [] : this.completedStatuses,
                            toggleAvgLeadTime: this.toggleAvgLeadTime,
                            toggleAvgCycleTime: this.toggleAvgCycleTime,
                            toggleAvgWIPTime: this.toggleAvgWIPTime,
                            toggleAvgArrivalTime: this.toggleAvgArrivalTime,
                            toggleAvgThroughputTime: this.toggleAvgThroughputTime,
                            toggleAdvanceCriteria: this.toggleAdvanceCriteria,
                            toggleAdvanceCalculation: this.toggleAdvanceCalculation,
                            selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                            selectedIssueTypeTitleMap: this.issueTypesList
                                ?.filter(item => this.selectedIssueType?.includes(item.id))
                                .reduce((acc, item) => {
                                    acc[item.id] = item.name;
                                    return acc;
                                }, {}),
                            // selectedIssueTypeTitleList: this.issueTypesList.filter(item => this.selectedIssueType.includes(item.id)).map(item => item.name),
                            selectedBoardTitle: selectedBoardTitle,
                            radioButtonSelection: this.pickedRadioType,
                            boardItemsFilter : this.boardItemsFilter,
                            itemtags : this.filter,
                            itemTagsMeta: this.filterwithMeta,
                        }
                        this.$emit('populate-graph', requestBody);
                    }
                }
            }
        },


    },
})
