const kendisWidgetCfd = Vue.component('kendis-widget-cfd', {
    template: `
        <div style="height: 100%;">
        	 <div style="height: 100%;">
                 <div  class="cfdGraphCard">
                        <div v-if="loading" class="loader">
                            <div>
                                <div class="loaderinteg"/>
                            </div>
                        </div> 
                        <div v-if="widgetObj.state !== 'new'" class="leftView">
                            <div  class="DF JB h-full" style="flex-direction: column;">
                                <div class="leftHeader">
                                    <div class="tooltip c-deflt">
                                        <h4 class="cardTitle">{{truncateName(widgetObj.name)}}</h4>
                                        <div class="hovtooltip">{{widgetObj.name}}</div>
                                    </div>
                                    <div v-if="!addWidget">
                                    <!-- <p class="DF" style="color: #5C697C;">
                                        {{widgetObj.category}}
                                        <span class="tooltip ml-10 flowTip">
                                            <em class="infotxt"></em>
                                            <div class="hovtooltip">
                                                The Cumulative Flow Diagram (CFD) shows the number of work items in each stage of a workflow over time, helping visualize progress, work in progress (WIP), and bottlenecks.
                                            </div>
                                        </span>
                                    </p> -->
                                  
                                        <div v-if=" widgetObj.type === 'flow-time-line-graph' || widgetObj.type === 'flow-efficiency-graph' || widgetObj.type === 'flow-velocity-graph' || widgetObj.type === 'flow-load-graph' || widgetObj.type === 'flow-distribution-graph' || widgetObj.type === 'cfd-graph' " class="tooltip criteria">
                                            <p class="clickable-text w-100">Criteria Details</p>
                                            <div class="hovtooltip criteriaDetailTip">
                                            	<div class="graphName">{{widgetObj.category}}</div>
                                                <kendis-widget-criteria-details :graphCriteria="graphCriteria" :type ="!_.isEmpty(widgetObj.type) ? widgetObj.type:''"/>                                          
                                            </div>
                                        </div>
                                         
                                    </div>
                                </div> 
                                <div class="cfdGraphCard leftView leftHeader">
                                    <div v-if="showCustomFilter">
                                    	<div class="prow item-log mb-20">
                                        	<label>Start Date</label>
                                            <div class="date sdat"><input type="date" class="item-date" v-model="selectedStartDate" @change="onDateChange"/></div>
                                        </div>
                                        <div id="item-end-date-f" class="prow item-log mb-20">
                                        	<label>End Date</label>
                                            <div class="date edat"><input type="date" class="item-date" v-model="selectedEndDate" @change="onDateChange"/></div>                                          
                                        </div>
                                    </div>
                                </div> 
                                <div v-if=" 1 == 2 && widgetObj.type === 'cfd-graph'" class="avrgList">
                                    <div v-if="widgetObj.graphCriteria.toggleAvgCycleTime && widgetObj.graphCriteria.avgCycleTime" class="avrgListItem">
                                        <img src="assets/icons/avrg.svg" alt="avrg"  class="mr-5" /> 
                                        Average Cycle Time: {{widgetObj.graphCriteria.avgCycleTime}} Days
                                        <span class="tooltip ml-10 flowTip">
                                            <em class="infotxt"></em> 
                                            <div class="hovtooltip">text test here</div>
                                        </span>
                                    </div>
                                    <div v-if="widgetObj.graphCriteria.toggleAvgLeadTime && widgetObj.graphCriteria.avgLeadTime" class="avrgListItem">
                                        <img src="assets/icons/avrg.svg" alt="avrg" class="mr-5" /> 
                                        Average Lead Time: {{widgetObj.graphCriteria.avgLeadTime}} Days
                                        <span class="tooltip ml-10 flowTip">
                                            <em class="infotxt"></em> 
                                            <div class="hovtooltip"> text test here</div>
                                        </span>
                                    </div>
                                    <div v-if="widgetObj.graphCriteria.toggleAvgWIPTime && widgetObj.graphCriteria.avgWIPTime" class="avrgListItem">
                                        <img src="assets/icons/avrg.svg" alt="avrg" class="mr-5" /> 
                                        Average Work In Progress Items: {{widgetObj.graphCriteria.avgWIPTime}} Items
                                        <span class="tooltip ml-10 flowTip">
                                           <em class="infotxt"></em> 
                                           <div class="hovtooltip">text test here</div>
                                        </span>
                                    </div>
                                    <div v-if="widgetObj.graphCriteria.toggleAvgArrivalTime && widgetObj.graphCriteria.avgWIPTime" class="avrgListItem">
                                        <img src="assets/icons/avrg.svg" alt="avrg" class="mr-5" /> 
                                        Average Arrival Rate: {{widgetObj.graphCriteria.avgWIPTime}} Days
                                        <span class="tooltip ml-10 flowTip">
                                            <em class="infotxt"></em> 
                                            <div class="hovtooltip">text test here</div>
                                        </span>
                                    </div>
                                    <div v-if="widgetObj.graphCriteria.toggleAvgThroughputTime && widgetObj.graphCriteria.avgThroughputTime" class="avrgListItem">
                                        <img src="assets/icons/avrg.svg" alt="avrg" class="mr-5" /> 
                                        Average Throughput: {{widgetObj.graphCriteria.avgThroughputTime}} Days
                                        <span class="tooltip ml-10 flowTip">
                                           <em class="infotxt"></em> 
                                           <div class="hovtooltip">text test here</div>
                                        </span>
                                    </div>
                                </div>
                                <div class="cardFooter"> 
                                    <div class="DFA gap-1">
                                        <span class="tooltip DF c-point lastUpdate iconContainer" v-if="!addWidget">
                                            <img src="assets/icons/last-update.svg" alt="avrg" />  
                                            <span class="hovtooltip refreshTime">Last Updated At:{{chartData.timestampInfo}} </span>
                                        </span>
                                        <div class="refresh c-point tooltip iconContainer" @click="handleSyncWidget()" v-if="dashboardActionAllowed(myRole,'SyncWidget') && !addWidget">
                                            <img v-if="chartData.isSynced == false" src="/assets/icons/refresh-gray.svg" alt="Refresh" :class="{ active: chartData.isSyncing }" class="refreshIcon" />
                                            <img v-if="chartData.isSynced " src="/assets/icons/new/check.svg" alt="check" class="checkIcon" />
                                            <div class="hovtooltip ftsb wht-nwrp refreshIconTip">Refresh</div>
                                        </div>
                                        <div class="settingsContainer c-point iconContainer" @click="handleSettingsClick" v-if="dashboardActionAllowed(myRole,'WidgetSettings') && !addWidget">
                                            <img  src="assets/icons/setting3.svg" alt="" />  
                                            <vuepopup v-if="showGraphSettings" @close="showGraphSettings = false;">
                                                <ul v-if="settingsLoading" class="drop_box" style="display: block;cursor: pointer">
                                                    <li class="loader"><div><div class="loaderinteg"/></div></li>             
                                                </ul> 
                                                <ul v-else class="drop_box" style="display: block;cursor: pointer">
                                                    <li class="boxItem" @click="openEditCriteria()"> 
                                                        <img src="/assets/icons/Dashboard/edit-gray.svg" alt="Edit" /> Edit 
                                                    </li>	
                                                    <li class="boxItem" @click="handleDuplicateWidget()">  
                                                        <img src="/assets/icons/Dashboard/dublicate-gray.svg" alt="Duplicate" /> Duplicate 
                                                    </li>							
                                                    <li class="boxItem" @click="handleRemoveWidget()">  
                                                        <img src="/assets/icons/Dashboard/delete-gray.svg" alt="Remove"/> Remove 
                                                    </li>                          
                                                </ul>
                                            </vuepopup>
                                        </div>
<!--                                         <div class="settingsContainer c-point iconContainer" @click="handleRemoveWidget()" v-if="addWidget">-->
<!--                                            <img src="/assets/icons/Dashboard/delete-gray.svg" alt=".." class="">  -->
<!--                                         </div>-->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="rightView">
                            <div v-if="widgetObj.loading" class="loader"><div><div class="loaderinteg"/></div></div> 
                            <div v-else class="h-full">
                              <div class="DF pl-40 filterdate">                   
                                    <span class="bxtagnw DAJ c-point" :class="{ active: activeFilter === '7D' }" @click="getDefinedFilterDate('7D')">7D</span>
                                    <span class="bxtagnw DAJ c-point" :class="{ active: activeFilter === '14D' }" @click="getDefinedFilterDate('14D')">14D</span>
                                    <span class="bxtagnw DAJ c-point" :class="{ active: activeFilter === '1M' }" @click="getDefinedFilterDate('1M')">1M</span>
                                    <span class="bxtagnw DAJ c-point" :class="{ active: activeFilter === '3M' }" @click="getDefinedFilterDate('3M')">3M</span>
                                    <span class="bxtagnw DAJ c-point" :class="{ active: activeFilter === '6M' }" @click="getDefinedFilterDate('6M')">6M</span>
                                    <span class="bxtagnw DAJ c-point" :class="{ active: activeFilter === '1Y' }" @click="getDefinedFilterDate('1Y')">1Y</span>
                                    <span class="bxtagnw DAJ c-point" :class="{ active: activeFilter === 'Custom' }" @click="showCustomDateModule()">Custom</span>
                                    <span v-if="activeFilter !='0' && activeFilter!=null" class="bxtagnw DAJ c-point" :class="{ active: activeFilter === 'Reset' }" @click="getDefinedFilterDate('Reset')">Reset</span>

                                </div>
                                <div v-if="errorCase" class="h-90p DFA JC">
                                    <div>
                                        <img src="/assets/icons/Dashboard/empty-widget-item.svg" alt=".." class="mr-10">
                                        <p class="txt-cntr">Please make sure your board contains sprint dates</p>
                                        <p class="txt-cntr"><a class="und c-point" href="#">Learn more</a></p>
                                    </div>
                                </div>

                              
                                <div v-if="errorCaseNoData==true && errorCase==false" class="h-90p DFA JC">
                                    <div>
                                        <img src="/assets/icons/Dashboard/empty-widget-item.svg" alt=".." class="mr-10">
                                        <p class="txt-cntr">No Data Available, As per selected Criteria.</p>
                                        <p class="txt-cntr"><a class="und c-point" href="#">Learn more</a></p>
                                    </div>
                                </div>
                                <chart1  class="chart" style="height: 90%;" v-if="chartData.show && errorCase === false && errorCaseNoData===false" :options="chartData.options"/>
                            </div>
                            <!-- <div v-if = "addWidget" >-->
                            <!--<button  type="button" class="button rds4 FR" @click="openCFDCriteria" >Select Criteria</button> -->
                            <!--</div>-->
                        </div>
                 </div>
            </div>
			<kendis-dashboard-selection-popup v-if="openSelectionPopup"  :graphTypeOptionTitle = "widgetObj.graphCriteria.graphTypeOptionTitle" :optionTypeTitle = "widgetObj.graphCriteria.optionTypeTitle" :graphTypeTitle = "widgetObj.graphCriteria.graphTypeTitle" :widgetType = "widgetObj.type" @close="handelCloseSelection" @populate-graph="onClickPopulateGraph"/>
			<kendis-graph-edit-popup v-if="openEditPopup" :selectedWidget="widgetObj" :dashboardSelected="dashboardSelectedId" @close="handleEditPopupClosure"  @updateWidget="onClickPopulateGraphWithResetFilter"> </kendis-graph-edit-popup>
            <dashboard-list-items-popup v-if="isPopupOpen" @close="closeItemsPopup"  :data="popupData"/>	
        </div>
    `,
    mixins:[rightsMixin],
    props: {widgetData: null, dashboardSelectedId: null,myRole:null},

    data() {
        return {
            settingsLoading:false,
            loading: false,
            addWidget: false,
            showGraphSettings: false,
            openSelectionPopup: false,
            openEditPopup: false,
            //CFD Widget Object Data
            boardTenant: '',
            graphTypeTitle: '',
            optionTypeTitle: '',
            sessionBoardId: '',
            selectedBoard: null,
            startDate: null,
            selectedStartDate: null,
            selectedEndDate:null,
            endDate: null,
            customDate1:null,
            customDate2:null,
            filterMonths:null,
            isSyncingFilter:false,
            updatedWidgetObj:null,
            saveFilter:true,
            resetCustomFilter:true,
            selectedGraph: null,
            dateFiltered:false,
            graphName: null,
            selectedFilterType: null,
            selectedCondition: null,
            advanceCriteria: null,
            selectedAdvanceCriteria: null,
            activeFilter: null,
            showCustomFilter:false,
            issueType: null,
            selectedActiveStatus: null,
            selectedWaitingStatus: null,
            selectedCompletedStatus: null,
            toggleAvgLeadTime: null,
            toggleAvgCycleTime: null,
            toggleAvgWIPTime: null,
            toggleAvgArrivalTime: null,
            toggleAvgThroughputTime: null,
            toggleAdvanceCriteria: null,
            toggleAdvanceCalculation: null,
            xAxis: null,
            radioButtonSelection: null,
            selectedBoardTitle: null,
            selectedFromStatus: null,
            issueTypeTitleList: null,
            advanceCriteria: null,
            selectedAdvanceCriteria: null,
            selectedIssueType: null,
            boardItemsFilter: null,
            selectedIssueTypeTitleMap: null,
            widgetId: null,
            boardId:null,
            //Chart: Stacked Area chart
            stackedAreaChart: {
                show: false,
                options: {
                    legend: {
                        layout: 'horizontal',
                        align: 'center',
                        verticalAlign: 'bottom',
                        useHTML: true,
                        itemStyle: {
                            pointerEvents: 'none' // Disable pointer events on legend items
                        },
                        maxHeight: 55,
                        navigation: {
                            enabled: true // Enable legend navigation/pagination
                        },
                    },
                    chart: {
                        type: 'area',
                        zoomType: 'x',
                        height: 0,
                        resetZoomButton: {
                            position: {
                                align: 'left', // Align to the left
                                verticalAlign: 'top', // Align to the top
                                x: 10, // X offset for positioning
                                y: 10 // Y offset for positioning
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            useHTML: true,
                            text: 'Count of Items'
                        }
                    },
                    xAxis: {
                        categories: []
                    },
                    tooltip: {
                        shared: true,
                        headerFormat: '<span style="font-size:12px"><b>{point.key}</b></span><br>'
                    },
                    plotOptions: {
                        series: {
                            stickyTracking: false
                        },
                        area: {
                            stacking: 'normal',
                            lineColor: '#666666',
                            lineWidth: 1,
                            marker: {
                                lineWidth: 1,
                                lineColor: '#666666'
                            }
                        }
                    },
                    series: [],
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen', 'separator', 'downloadPDF', 'downloadJPEG', 'downloadPNG', 'downloadXLS']
                            }
                        }
                    }
                }
            },
            chartData: {
                isSynced: false,
                show: true,
                options: new Object(),
                timestampInfo: '',
            },
            //chart criteria details
            graphCriteria: {
                type:"cfd-graph",
            },
            //popup data
            popupData: [],
            isPopupOpen: false,
            widgetObj:[],
            errorCase:false,
            errorCaseNoData:false,
            itemtags:{},
           itemTagsMeta:{},
        }
    },
    computed: {
        minStartDate() {
            return this.startDate ? this.formatDateForInput(this.startDate) : '2024-11-11'; // Provide a default value if startDate is empty
        },
        maxStartDate() {
            return this.selectedEndDate ? this.selectedEndDate : this.formatDateForInput(this.endDate); // Provide a default value if startDate is empty
        },
        maxEndDate(){
            return this.endDate?this.formatDateForInput(this.endDate ):new Date();
        }
    },
    components: {
        //add components here
        'kendis-dashboard-selection-popup': kendisDashboardSelectionPopup,
        "kendis-graph-edit-popup":kendisGraphEditPopup,
        'kendis-widget-criteria-details': kendisWidgetCriteraiDetails,
        'dashboard-list-items-popup': dashboardPopupComponent,
    },

    mounted() {
        //Create a new Widget if id is null
        if (this.widgetData.state == "new") {
            this.addWidget = true;
            this.widgetObj = this.widgetData;
            disableBodyScroll();
            this.openSelectionPopup = true;
        } else {
            //fetch widget data, process it and load the graph
            this.saveFilter=true;
            this.resetCustomFilter=true;
            this.fetchWidgetData();
        }
        
    },

    created() {},

    methods: {
        truncateName(name) {
            if(!_.isEmpty(name)){
                if (name.length > 130) {
                    return name.substring(0, 130) + '...';
                }
            }
            return name;
        },

        showCustomDateModule(){
            this.selectedStartDate=null;
            this.selectedEndDate=null;
            this.resetCustomFilter=false;
            this.showCustomFilter =true;
                this.activeFilter="Custom";
        },
        getLastMonths(totalMonths) {
            const months = [];
            const today = new Date();
            for (let i = 0; i < totalMonths; i++) {
                const date = new Date(today.getFullYear(), today.getMonth() - i, 1); // Set day to the 1st of the month
                const monthName = date.toLocaleString('default', { month: 'long' }); // Full month name
                const yearShort = date.getFullYear().toString().slice(-2); // Extract last two digits of the year
                months.push(`${monthName} ${yearShort}`); // Combine month and year
            }
            return months.reverse(); // Reverse to get the months in chronological order
        },
        getDefinedFilterDate(dateRange){
            this.showCustomFilter=false;
            this.resetCustomFilter=false;
            if(dateRange=='7D'){
                const currentDate = new Date(); // Get today's date
                const oneWeekAgo = new Date(currentDate.getTime() - 7 * 24 * 60 * 60 * 1000);
                this.customDate1=this.formatDate(currentDate);
                this.customDate2=this.formatDate(oneWeekAgo);
                this.activeFilter='7D';
            }
            else if(dateRange=='14D'){
                const currentDate = new Date(); // Get today's date
                const twoWeekAgo = new Date(currentDate.getTime() - 14 * 24 * 60 * 60 * 1000);
                this.customDate1=this.formatDate(currentDate);
                this.customDate2=this.formatDate(twoWeekAgo);
                this.activeFilter='14D';
            }
            else if(dateRange=='1M'){
                const currentDate = new Date(); // Get today's date
                const oneMonthAgo = new Date(currentDate); // Create a new date object for manipulation
                // Subtract one month
                oneMonthAgo.setMonth(oneMonthAgo.getMonth() - 1);
                this.customDate1=this.formatDate(currentDate);
                this.customDate2=this.formatDate(oneMonthAgo);
                this.activeFilter='1M';
            }
            else if(dateRange=='3M'){
                const currentDate = new Date(); // Get today's date
                const threeMonthAgo = new Date(currentDate); // Create a new date object for manipulation
                // Subtract one month
                threeMonthAgo.setMonth(threeMonthAgo.getMonth() - 3);
                this.filterMonths=this.getLastMonths(3);
                this.customDate1=this.formatDate(currentDate);
                this.customDate2=this.formatDate(threeMonthAgo);
                this.activeFilter='3M';
            }else if(dateRange=='6M'){
                const currentDate = new Date(); // Get today's date
                const sixMonthAgo = new Date(currentDate); // Create a new date object for manipulation
                // Subtract one month
                sixMonthAgo.setMonth(sixMonthAgo.getMonth() - 6);
                this.customDate1=this.formatDate(currentDate);
                this.customDate2=this.formatDate(sixMonthAgo);
                this.filterMonths=this.getLastMonths(6);
                this.activeFilter='6M';
            }
            else if(dateRange=='1Y'){
                const currentDate = new Date(); // Get today's date
                const oneYearAgo = new Date(currentDate); // Create a new date object for manipulation
                // Subtract one month
                oneYearAgo.setFullYear(oneYearAgo.getFullYear() - 1);
                this.customDate1=this.formatDate(currentDate);
                this.customDate2=this.formatDate(oneYearAgo);
                this.filterMonths=this.getLastMonths(12);
                this.activeFilter='1Y';
            }
            else if(dateRange=="Custom"){
                this.customDate2=this.formatDate(this.selectedStartDate);
                this.customDate1=this.formatDate(this.selectedEndDate);
                this.activeFilter='Custom';
            }
            else if(dateRange=="Reset"){
                this.activeFilter='Reset';
                this.initializeCFDGraphData(this.widgetObj);
                this.activeFilter='0';
            }
            if(this.widgetObj.graphCriteria.intervals=='days' && (this.activeFilter=='7D' || this.activeFilter=='14D' || this.activeFilter=='1M' || this.activeFilter=='Custom')){
                if(this.activeFilter=='Custom'){
                    this.showCustomFilter=true;

                }
                if(this.isSyncingFilter){
                    this.dateFiltered=true;
                    this.initializeCFDGraphData(this.updatedWidgetObj);
                    this.dateFiltered=false;
                }
                else{
                    this.dateFiltered=true;
                    this.initializeCFDGraphData(this.widgetObj)
                    this.dateFiltered=false;
                }
            }
            else if(this.widgetObj.graphCriteria.intervals!='days' && (this.activeFilter=='7D' || this.activeFilter=='14D' || this.activeFilter=='1M' || this.activeFilter=='Custom')){
                if(this.activeFilter=='Custom'){
                    this.showCustomFilter=true;
                }
                let requestBody={};
                requestBody.sessionBoardId=this.widgetObj.graphCriteria.sessionBoardId;
                requestBody.selectedStatusIds=this.widgetObj.graphCriteria.selectedItems;
                requestBody.startDate=this.widgetObj.graphCriteria.startDate;
                requestBody.endDate=this.widgetObj.graphCriteria.endDate;
                requestBody.tenant=this.widgetObj.graphCriteria.selectedBoardTenant;
                requestBody.xAxis='days';
                requestBody.advanceCriteria= this.widgetObj.graphCriteria.advanceCriteria;
                requestBody.selectedAdvanceCriteria= this.widgetObj.graphCriteria.selectedAdvanceCriteria;
                requestBody.issueType= this.widgetObj.graphCriteria.selectedIssueType;
                requestBody.selectedActiveStatus= this.widgetObj.graphCriteria.selectedActiveStatus;
                //requestBody.selectedWaitingStatus= requestBody.selectedWaitingStatus;
                requestBody.selectedCompletedStatus= this.widgetObj.graphCriteria.selectedCompletedStatus;
                requestBody.toggleAvgLeadTime= this.widgetObj.graphCriteria.toggleAvgLeadTime;
                requestBody.toggleAvgCycleTime= this.widgetObj.graphCriteria.toggleAvgCycleTime;
                requestBody.toggleAvgWIPTime= this.widgetObj.graphCriteria.toggleAvgWIPTime;
                requestBody.toggleAvgArrivalTime= this.widgetObj.graphCriteria.toggleAvgArrivalTime;
                requestBody.toggleAvgThroughputTime= this.widgetObj.graphCriteria.toggleAvgThroughputTime;
                requestBody.toggleAdvanceCriteria= this.widgetObj.graphCriteria.toggleAdvanceCriteria;
                requestBody.toggleAdvanceCalculation= this.widgetObj.graphCriteria.toggleAdvanceCalculation;
                //requestBody.issueTypeMap= requestBody.selectedIssueTypeTitleMap;
                requestBody.radioButtonSelection= this.widgetObj.graphCriteria.radioButtonSelection;
                requestBody.boardItemsFilter= this.widgetObj.graphCriteria.boardItemsFilter;
                requestBody.dashboardId = this.dashboardSelectedId;
                requestBody.itemtags = this.widgetObj.graphCriteria.itemTags;
                requestBody.itemTagsMetaMap=this.widgetObj.graphCriteria.itemTagsMetaMap;
                requestBody.selectedBoard={}
                requestBody.selectedBoard._id=this.widgetObj.graphCriteria.boardId;
                requestBody.optionTypeTitle=this.widgetObj.graphCriteria.optionTypeTitle;
                requestBody.selectedIssueType= _.isEmpty(this.widgetObj.graphCriteria.selectedIssueType) ? [] : this.widgetObj.graphCriteria.selectedIssueType;
                this.dateFiltered=true;
                this.saveFilter=false;
                this.onClickPopulateGraph(requestBody);
            }
            else if(this.widgetObj.graphCriteria.intervals!='monthly' && this.activeFilter=='3M' || this.activeFilter=='6M' || this.activeFilter=='1Y'){
                let requestBody={};
                requestBody.sessionBoardId=this.widgetObj.graphCriteria.sessionBoardId;
                requestBody.selectedStatusIds=this.widgetObj.graphCriteria.selectedItems;
                requestBody.startDate=this.widgetObj.graphCriteria.startDate;
                requestBody.endDate=this.widgetObj.graphCriteria.endDate;
                requestBody.tenant=this.widgetObj.graphCriteria.selectedBoardTenant;
                requestBody.xAxis='monthly';
                requestBody.advanceCriteria= this.widgetObj.graphCriteria.advanceCriteria;
                requestBody.selectedAdvanceCriteria= this.widgetObj.graphCriteria.selectedAdvanceCriteria;
                requestBody.issueType= this.widgetObj.graphCriteria.selectedIssueType;
                requestBody.selectedActiveStatus= this.widgetObj.graphCriteria.selectedActiveStatus;
                //requestBody.selectedWaitingStatus= requestBody.selectedWaitingStatus;
                requestBody.selectedCompletedStatus= this.widgetObj.graphCriteria.selectedCompletedStatus;
                requestBody.toggleAvgLeadTime= this.widgetObj.graphCriteria.toggleAvgLeadTime;
                requestBody.toggleAvgCycleTime= this.widgetObj.graphCriteria.toggleAvgCycleTime;
                requestBody.toggleAvgWIPTime= this.widgetObj.graphCriteria.toggleAvgWIPTime;
                requestBody.toggleAvgArrivalTime= this.widgetObj.graphCriteria.toggleAvgArrivalTime;
                requestBody.toggleAvgThroughputTime= this.widgetObj.graphCriteria.toggleAvgThroughputTime;
                requestBody.toggleAdvanceCriteria= this.widgetObj.graphCriteria.toggleAdvanceCriteria;
                requestBody.toggleAdvanceCalculation= this.widgetObj.graphCriteria.toggleAdvanceCalculation;
                //requestBody.issueTypeMap= requestBody.selectedIssueTypeTitleMap;
                requestBody.radioButtonSelection= this.widgetObj.graphCriteria.radioButtonSelection;
                requestBody.boardItemsFilter= this.widgetObj.graphCriteria.boardItemsFilter;
                requestBody.dashboardId = this.dashboardSelectedId;
                requestBody.itemtags = this.widgetObj.graphCriteria.itemTags;
                requestBody.itemTagsMetaMap=this.widgetObj.graphCriteria.itemTagsMetaMap;
                requestBody.selectedBoard={}
                requestBody.selectedBoard._id=this.widgetObj.graphCriteria.boardId;
                requestBody.optionTypeTitle=this.widgetObj.graphCriteria.optionTypeTitle;
                requestBody.selectedIssueType= _.isEmpty(this.widgetObj.graphCriteria.selectedIssueType) ? [] : this.widgetObj.graphCriteria.selectedIssueType;
                this.dateFiltered=true;
                this.saveFilter=false;
                this.onClickPopulateGraph(requestBody);
            }
            else if(this.widgetObj.graphCriteria.intervals=='monthly' && this.activeFilter=='3M' || this.activeFilter=='6M' || this.activeFilter=='1Y'){
                if(this.isSyncingFilter){
                    this.dateFiltered=true;
                    this.initializeCFDGraphData(this.updatedWidgetObj);
                    this.dateFiltered=false;
                }
                else{
                    this.dateFiltered=true;
                    this.initializeCFDGraphData(this.widgetObj)
                    this.dateFiltered=false;
                }
            }
        },
         formatDate(dateString) {
             if(dateString!=null){
                 const date = new Date(dateString); // Create Date object from string
                 const options = { month: 'short' };
                 const month = date.toLocaleString('en-US', options); // Get short month name
                 const day = String(date.getDate()).padStart(2, '0'); // Add leading zero to day if needed
                 const year = date.getFullYear(); // Get year

                 return `${month} ${day} ${year}`;
             }
              // Format the date
        },
        onDateChange(){
             // if(this.selectedStartDate && this.selectedEndDate && this.widgetObj.graphCriteria.intervals=='days'){
             //     this.dateFiltered=true;
             //     this.customDate2=this.selectedStartDate;
             //     this.customDate1=this.selectedEndDate;
             //     this.initializeCFDGraphData(this.widgetObj)
             //     this.dateFiltered=false;
             // }
             // else
            if(this.selectedStartDate && this.selectedEndDate && this.widgetObj.graphCriteria.intervals){
                 let requestBody={};
                 this.customDate2=this.selectedStartDate;
                 this.customDate1=this.selectedEndDate;
                 requestBody.sessionBoardId=this.widgetObj.graphCriteria.sessionBoardId;
                 requestBody.selectedStatusIds=this.widgetObj.graphCriteria.selectedItems;
                 requestBody.startDate=this.widgetObj.graphCriteria.startDate;
                 requestBody.endDate=this.widgetObj.graphCriteria.endDate;
                 requestBody.tenant=this.widgetObj.graphCriteria.selectedBoardTenant;
                 requestBody.xAxis='days';
                 requestBody.advanceCriteria= this.widgetObj.graphCriteria.advanceCriteria;
                 requestBody.selectedAdvanceCriteria= this.widgetObj.graphCriteria.selectedAdvanceCriteria;
                 requestBody.issueType= this.widgetObj.graphCriteria.selectedIssueType;
                 requestBody.selectedActiveStatus= this.widgetObj.graphCriteria.selectedActiveStatus;
                 //requestBody.selectedWaitingStatus= requestBody.selectedWaitingStatus;
                 requestBody.selectedCompletedStatus= this.widgetObj.graphCriteria.selectedCompletedStatus;
                 requestBody.toggleAvgLeadTime= this.widgetObj.graphCriteria.toggleAvgLeadTime;
                 requestBody.toggleAvgCycleTime= this.widgetObj.graphCriteria.toggleAvgCycleTime;
                 requestBody.toggleAvgWIPTime= this.widgetObj.graphCriteria.toggleAvgWIPTime;
                 requestBody.toggleAvgArrivalTime= this.widgetObj.graphCriteria.toggleAvgArrivalTime;
                 requestBody.toggleAvgThroughputTime= this.widgetObj.graphCriteria.toggleAvgThroughputTime;
                 requestBody.toggleAdvanceCriteria= this.widgetObj.graphCriteria.toggleAdvanceCriteria;
                 requestBody.toggleAdvanceCalculation= this.widgetObj.graphCriteria.toggleAdvanceCalculation;
                 //requestBody.issueTypeMap= requestBody.selectedIssueTypeTitleMap;
                 requestBody.radioButtonSelection= this.widgetObj.graphCriteria.radioButtonSelection;
                 requestBody.boardItemsFilter= this.widgetObj.graphCriteria.boardItemsFilter;
                 requestBody.dashboardId = this.dashboardSelectedId;
                requestBody.itemtags = this.widgetObj.graphCriteria.itemTags;
                requestBody.itemTagsMetaMap=this.widgetObj.graphCriteria.itemTagsMetaMap;
                requestBody.selectedBoard={}
                 requestBody.selectedBoard._id=this.widgetObj.graphCriteria.boardId;
                 requestBody.optionTypeTitle=this.widgetObj.graphCriteria.optionTypeTitle;
                 requestBody.selectedIssueType= _.isEmpty(this.widgetObj.graphCriteria.selectedIssueType) ? [] : this.widgetObj.graphCriteria.selectedIssueType;
                 this.dateFiltered=true;
                this.saveFilter=false;
                this.onClickPopulateGraph(requestBody);
             }

        },
        formatDateForInput(dateString) {
            if(dateString){
                const [month, year] = dateString.split(' ');

                // Map month names to their respective month numbers
                const months = {
                    "January": 0,
                    "February": 1,
                    "March": 2,
                    "April": 3,
                    "May": 4,
                    "June": 5,
                    "July": 6,
                    "August": 7,
                    "September": 8,
                    "October": 9,
                    "November": 10,
                    "December": 11
                };

                // Ensure the month exists in the mapping
                if (!(month in months)) {
                    throw new Error("Invalid month name");
                }

                // Handle the year as a 2-digit year (assuming 2000s)
                const fullYear = year.length === 2 ? '20' + year : year;

                // Construct a valid Date object, using 1 as the default day
                const formattedDate = new Date(`${fullYear}-${months[month] + 1}-01`);

                // Adjust for timezone offset and return in ISO format (YYYY-MM-DD)
                const localDate = new Date(formattedDate.getTime() - formattedDate.getTimezoneOffset() * 60000);
                console.log(localDate.toISOString().split('T')[0]);
                return localDate.toISOString().split('T')[0];
            }
            return new Date();
        },
        closeItemsPopup(){
            enableBodyScroll();
            this.isPopupOpen = false;
        },
        handleSettingsClick:function(){
            this.settingsLoading = true;
            //Check if the user has access rights for Edit Options
            axios.get('/dashboard/getUserDashboardAccessRole/'+ this.dashboardSelectedId)
                .then(response => {
                    this.myRole = response.data.userRole;
                    if(this.dashboardActionAllowed(this.myRole,"WidgetSettings")){
                        this.showGraphSettings = true;
                        this.settingsLoading = false;
                    }
                    else{
                        showTopMessage("Please ask the author to provide editor access to continue.","warning","8000");
                        this.settingsLoading = false;
                        location.reload();
                    }
                })
                .catch(e => {
                    this.settingsLoading = false;
                });
        },
        //handle the flow for cancel of selection
        handelCloseSelection:function(){
            enableBodyScroll();
            this.openSelectionPopup = false;
            this.$emit('handleRemovalAction', {id: this.widgetObj.id});
        },
        //Widget related functions
        fetchWidgetData: function () {
            let data = {};
            data.widgetId = this.widgetData.id;
            this.loading = true;
            axios.post("/dashboard/getSingleWidget/", data).then(response => {
                this.widgetObj = response.data.widget;
                this.selectedBoard = { _id: response.data.widget.graphCriteria.sessionBoardId };
                this.initializeCFDGraphData(this.widgetObj);
            }).catch(e => {
                this.errorCase = true;
                console.log("Some Error Occurred While Loading single CFD", e);
                this.loading = false;
            });
        },

        handleIssueGroupBySelection: function () {
            let tempData = {
                "graphId": this.graphId,
                "selectedGroupBy": this.selectedIssueTypeGroupBy,
                "graphType": this.graph.type
            };
            this.$emit('handleIssueGroupSelection', tempData);
        },


        handleGroupBySelection: function () {
            let data = {
                "graphId": this.graph.id,
                "selectedGroupBy": this.selectedGroupBy,
                "graphType": this.graph.type
            };
            this.$emit('handleGroupSelection', data);
        },

        handleDetailList: function () {
            this.isWidgetExpanded = false;
            let data = {"graphId": this.graph.id, "graphType": this.graph.type}
            this.$emit('handleDetailList', data);
        },

        //methods for CFD processing
        updateWidget: function (widgetData) {
            if (!_.isEmpty(widgetData)) {
                if (!this.widgetId) {
                    let position = _this.getNewGridPosition(widgetData);
                    widgetData.posX = position.x;
                    widgetData.posY = position.y;
                }
                return axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widgetData);
            } else {
                throw new Error('Processed widget data is empty');
            }
        },

        openCFDCriteria: function () {
            disableBodyScroll();
            this.openSelectionPopup = true;
        },

        openEditCriteria: function () {
            disableBodyScroll();
            this.openEditPopup = true;
        },
        handleEditPopupClosure(){
            enableBodyScroll();
            this.openEditPopup = false;
        },
        onClickPopulateGraphWithResetFilter(requestBody){
            this.showCustomFilter=false;
            this.resetCustomFilter=true;
            this.onClickPopulateGraph(requestBody)
        },
        onClickPopulateGraph: function (requestBody) {
            this.loading = true;
            enableBodyScroll();
            this.openSelectionPopup = false;
            this.openEditPopup = false;
            let reqBody = {};
            if(this.resetCustomFilter){
                this.activeFilter='0';
            }
            reqBody = {
                sessionBoardId: requestBody.sessionBoardId,
                selectedStatusIds: requestBody.selectedStatusIds,
                startDate: requestBody.startDate,
                endDate: requestBody.endDate,
                tenant: requestBody.tenant,
                xAxis: requestBody.xAxis,
                advanceCriteria: requestBody.advanceCriteria,
                selectedAdvanceCriteria: requestBody.selectedAdvanceCriteria,
                issueType: requestBody.selectedIssueType,
                selectedActiveStatus: requestBody.selectedActiveStatus,
                selectedWaitingStatus: requestBody.selectedWaitingStatus,
                selectedCompletedStatus: requestBody.selectedCompletedStatus,
                toggleAvgLeadTime: requestBody.toggleAvgLeadTime,
                toggleAvgCycleTime: requestBody.toggleAvgCycleTime,
                toggleAvgWIPTime: requestBody.toggleAvgWIPTime,
                toggleAvgArrivalTime: requestBody.toggleAvgArrivalTime,
                toggleAvgThroughputTime: requestBody.toggleAvgThroughputTime,
                toggleAdvanceCriteria: requestBody.toggleAdvanceCriteria,
                toggleAdvanceCalculation: requestBody.toggleAdvanceCalculation,
                issueTypeMap: requestBody.selectedIssueTypeTitleMap,
                radioButtonSelection: requestBody.radioButtonSelection,
                boardItemsFilter: requestBody.boardItemsFilter,
                dashboardId : this.dashboardSelectedId,
                itemtags : requestBody.itemtags,
            };
            this.itemtags = requestBody.itemtags;
            this.itemTagsMeta = requestBody.itemTagsMeta;
            this.boardTenant = requestBody.tenant;
            this.graphTypeTitle = requestBody.graphTypeTitle;
            this.optionTypeTitle = requestBody.optionTypeTitle;
            this.sessionBoardId = requestBody.sessionBoardId;
            this.selectedBoard = requestBody.selectedBoard;
            this.startDate = requestBody.orignalStartDate;
            this.endDate = requestBody.orignalEndDate;
            this.selectedGraph = requestBody.selectedGraph;
            this.graphName = requestBody.graphName;
            this.selectedFilterType = requestBody.selectedFilterType;
            this.selectedCondition = requestBody.selectedStatusIds;
            this.advanceCriteria = requestBody.advanceCriteria;
            this.selectedAdvanceCriteria = requestBody.selectedAdvanceCriteria;
            this.issueType = requestBody.selectedIssueType;
            this.selectedActiveStatus = requestBody.selectedActiveStatus;
            this.selectedWaitingStatus = requestBody.selectedWaitingStatus;
            this.selectedCompletedStatus = requestBody.selectedCompletedStatus;
            this.toggleAvgLeadTime = requestBody.toggleAvgLeadTime;
            this.toggleAvgCycleTime = requestBody.toggleAvgCycleTime;
            this.toggleAvgWIPTime = requestBody.toggleAvgWIPTime;
            this.toggleAvgArrivalTime = requestBody.toggleAvgArrivalTime;
            this.toggleAvgThroughputTime = requestBody.toggleAvgThroughputTime;
            this.toggleAdvanceCriteria = requestBody.toggleAdvanceCriteria;
            this.toggleAdvanceCalculation = requestBody.toggleAdvanceCalculation;
            this.xAxis = requestBody.xAxis;
            this.radioButtonSelection = requestBody.radioButtonSelection;
            this.selectedBoardTitle = requestBody.selectedBoardTitle;
            this.selectedFromStatus = requestBody.selectedStatusTitle;
            this.issueTypeTitleList = requestBody.selectedIssueTypeTitleList;
            this.advanceCriteria = requestBody.advanceCriteria;
            this.selectedAdvanceCriteria = requestBody.selectedAdvanceCriteria;
            this.selectedIssueType = requestBody.selectedIssueType;
            this.boardItemsFilter = requestBody.boardItemsFilter;
            this.selectedIssueTypeTitleMap = requestBody.selectedIssueTypeTitleMap;
            this.widgetId = this.widgetObj.id;
            this.boardId= this.selectedBoard._id;
            reqBody.widgetType = requestBody.optionTypeTitle;

            let _this = this;
            axios.post('/dashboard/create-timeseries-data', reqBody)
                .then(response => {
                    if (!response.data) {
                        throw new Error('Response data is empty');
                    }
                    let widgetData;
                    widgetData = _this.makeGraphObjectForDBStorage(response.data);
                    widgetData.graphCriteria.saveFilter=this.saveFilter;
                    if (!_.isEmpty(widgetData)) {
                        return axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widgetData);
                    } else {
                        throw new Error('Processed widget data is empty');
                    }
                })
                .then(response => {
                    let updatedWidget = response.data.widget;
                    if(this.saveFilter){
                        this.widgetObj = updatedWidget;
                    }
                    this.initializeCFDGraphData(updatedWidget);
                    this.saveFilter=true;
                    this.loading = false;
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    this.loading = false;
                });
        },

        makeGraphObjectForDBStorage: function (response) {
            let widgetData = {};
            if (response) {
                let graphDataMap = response.intervals;
                let categories = response.categories;
                let allGroupBys = response.allGroupBysMap;
                let itemStatusMap = response.itemStatusMap;
                let issueTypeMap = response.allIssueTypesMap;
                let itemIdsMap = response.itemIdsMap;
                let relevantdates = response.intervalDates;
                let groupIdColorMap = response.groupIdColorMap;
                let avgCycleTime = "";
                let avgLeadTime = "";
                let avgArrivalTime = "";
                let avgThroughputTime = "";
                let avgWIPTime = "";
                if (response.avgCycleTime) {
                    avgCycleTime = response.avgCycleTime;
                }
                if (response.avgLeadTime) {
                    avgLeadTime = response.avgLeadTime;
                }
                if (response.avgArrivalTime) {
                    avgArrivalTime = response.avgArrivalTime;
                }
                if (response.avgThroughputTime) {
                    avgThroughputTime = response.avgThroughputTime;
                }
                if (response.avgWIPTime) {
                    avgWIPTime = response.avgWIPTime;
                }
                let selectedItems = [];
                const transformedData = Object.entries(graphDataMap).map(([key, value]) => [key, value]);
                const transformedDataForItemIds = Object.entries(itemIdsMap).map(([key, value]) => [key, value]);

                if (!_.isEmpty(this.selectedCondition)) {
                    for (let i = 0; i < this.selectedCondition.length; i++) {
                        selectedItems.push(this.selectedCondition[i]);
                    }
                }
                const keys = Object.keys(allGroupBys);
                const transformedallGroupBys = keys.map(key => ({
                    id: key,
                    title: allGroupBys[key]
                }));

                let dataofGraph = {
                    "graphType": "area",
                    "selectedItems": selectedItems,
                    "boardId": this.boardId,
                    "sessionBoardId": this.sessionBoardId,
                    "graphTypeTitle": this.graphTypeTitle,
                    "optionTypeTitle": this.optionTypeTitle,
                    "selectedBoardTenant": this.boardTenant,
                    "intervals": this.xAxis,
                    "radioButtonSelection": this.radioButtonSelection,
                    "selectedIssueType": this.selectedIssueType,
                    "categories": categories,
                    "boardTitle": this.selectedBoardTitle,
                    "itemStatusMap": itemStatusMap,
                    "issueTypeTitle": this.issueTypeTitleList,
                    "fromStatusTitle": this.selectedFromStatus,
                    "avgCycleTime": avgCycleTime,
                    "avgLeadTime": avgLeadTime,
                    "avgArrivalTime": avgArrivalTime,
                    "avgThroughputTime": avgThroughputTime,
                    "avgWIPTime": avgWIPTime,
                    "toggleAvgLeadTime": this.toggleAvgLeadTime,
                    "toggleAvgCycleTime": this.toggleAvgCycleTime,
                    "toggleAvgWIPTime": this.toggleAvgWIPTime,
                    "toggleAvgArrivalTime": this.toggleAvgArrivalTime,
                    "toggleAvgThroughputTime": this.toggleAvgThroughputTime,
                    "toggleAdvanceCalculation": this.toggleAdvanceCalculation,
                    "toggleAdvanceCriteria": this.toggleAdvanceCriteria,
                    "startDate": this.startDate,
                    "endDate": this.endDate,
                    "selectedActiveStatus": _.isEmpty(this.selectedActiveStatus) ? '' : this.selectedActiveStatus,
                    "selectedInProgressStatus": _.isEmpty(this.selectedWaitingStatus) ? [] : this.selectedWaitingStatus,
                    "selectedCompletedStatus": _.isEmpty(this.selectedCompletedStatus) ? [] : this.selectedCompletedStatus,
                    "advanceCriteria": this.advanceCriteria,
                    "selectedAdvanceCriteria": this.selectedAdvanceCriteria,
                    "boardItemsFilter": this.boardItemsFilter,
                    "issueTypeMap": this.selectedIssueTypeTitleMap,
                    "itemIdsMap": transformedDataForItemIds,
                    "relevantDates":relevantdates,
                    "groupIdColorMap" : groupIdColorMap,
                    "itemTags":this.itemtags,
                    "itemTagsMetaMap" : this.itemTagsMeta,
                };
                widgetData = {
                    name: this.graphName,
                    graphCriteria: dataofGraph,
                    graphAdditionalCriteria: transformedData,
                    id: this.widgetId,
                    allGroupBys: allGroupBys,
                    state: "old",
                    category: "Cumulative Flow Diagram",
                }
            }
            return widgetData;
        },

        //Chart Population Functions
        initializeStackedAreaGraph: function () {
            let _this = this;
            this.stackedAreaChart = {
                show: false,
                
                options: {
                    legend: {
                        layout: 'horizontal',
                        align: 'center',
                        verticalAlign: 'bottom',
                        useHTML: true,
                        itemStyle: {
                            pointerEvents: 'none' // Disable pointer events on legend items
                        },
                        maxHeight: 55,
                        navigation: {
                            enabled: true // Enable legend navigation/pagination
                        },
                    },
                    chart: {
						height: 0,
                        type: 'area',
                        zoomType: 'x',
                        resetZoomButton: {
                            position: {
                                align: 'left', // Align to the left
                                verticalAlign: 'top', // Align to the top
                                x: 10, // X offset for positioning
                                y: 10 // Y offset for positioning
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            useHTML: true,
                            text: 'Count of Items'
                        }
                    },
                    xAxis: {
                        categories: [],
                        labels: {
                            formatter: function() {
                                let isDaysInterval = _this.widgetObj?.graphCriteria?.intervals === "days" ? true :false ;
                                let isMonthsInterval = _this.widgetObj?.graphCriteria?.intervals === "monthly" ? true :false ;
                                let isOthersInterval = _this.widgetObj?.graphCriteria?.intervals === "weekly" || _this.widgetObj?.graphCriteria?.intervals === "sprints" ? true :false ;
                                let isFilterApplied = _this.activeFilter === '0' || _this.activeFilter===null ?false:true;

                                if (isOthersInterval && !isFilterApplied) {
                                    const parts = this.value.split('\n');
                                    return '<span style="display: block; text-align: center;">' + parts[0] + '</span>' + // Week name above
                                        '<span style="display: block; text-align: center;font-size: 12px; color: #5c697c;">' + parts[1] + '</span>'; // Date range below
                                }
                                else if (isOthersInterval && (isFilterApplied &&  (_this.activeFilter == '1M' || _this.activeFilter == '3M' || _this.activeFilter == '6M' || _this.activeFilter == '1Y' ))) {
                                    const parts = this.value.split('\n');
                                    return '<span style="display: block; text-align: center;">' + this.value + '</span>';
                                }
                                else if(isMonthsInterval || (isFilterApplied &&  (_this.activeFilter == '1M' || _this.activeFilter == '3M' || _this.activeFilter == '6M' || _this.activeFilter == '1Y' ))){
                                    return '<span style="display: block; text-align: center;">' + this.value + '</span>';
                                }
                                else if(isDaysInterval || (isOthersInterval && isFilterApplied &&(( _this.activeFilter !== '3M' || _this.activeFilter !== '6M' || _this.activeFilter !== '1Y' )))){
                                    return this.value;
                                }

                            },
                            useHTML: true
                        }
                    },
                    tooltip: {
                        shared: true,
                        useHTML: true,
                        backgroundColor: 'rgba(255, 255, 255, 0.9)',
                        borderColor: '#ccc',
                        borderRadius: 5,
                        borderWidth: 1,
                        shadow: true,
                        hideDelay: 0, // Ensure the tooltip hides immediately
                        stickOnContact: false, // Prevent tooltip from lingering
                        style: {
                            padding: '10px',
                            color: '#333',
                            fontSize: '12px'
                        },
                        formatter: function () {
                            var total = 0;
                            var filteredPoints = this.points.filter(function (point) {
                                return point.y > 0;
                            });

                            filteredPoints.forEach(function (point) {
                                total += point.y;
                            });

                            var tooltipContent = '<div class="garphsTooltipwraper"><div class="DFCB"><label>Total Items: </label><div>' + total + '</div></div><hr>';

                            tooltipContent += filteredPoints.map(function (point) {
                                return '<div class="DFCB">' +
                                    '<span style="display:inline-block; width:10px; height:10px; background-color:' + point.series.color + '; border-radius:50%; margin-right:1px;"></span>' +
                                    '<label>' + point.series.name + ':</label>' +
                                    '<div>' + point.y + " Items" + '</div></div>';
                            }).join('');

                            tooltipContent += '</div>';
                            return tooltipContent;
                        }
                    },
                    plotOptions: {
                        series: {
                            stickyTracking: false
                        },
                        area: {
                            stacking: 'normal',
                            marker: {
                                enabled: false
                            },
                            point: {
                                events: {
                                    mouseOver: function () {
                                    this.series.chart.tooltip.refresh([this]);
                                    },
                                    mouseOut: function () {
                                        this.series.chart.tooltip.hide();
                                    },
                                    click: function () {
                                        const xAxisIndex = this.index;
                                        _this.onClickCFDDataPoints(this.series.options.itemIds[xAxisIndex]);
                                    },
                                }
                            }
                        }
                    },
                    series: [],
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen', 'separator', 'downloadPDF', 'downloadJPEG', 'downloadPNG', 'downloadXLS']
                            }
                        }
                    }
                }
            }
        },

         formatTimestamp(timestamp) {
            const date = new Date(Number(timestamp));
            const month = (date.getMonth() + 1).toString().padStart(2, '0');
            const day = date.getDate().toString().padStart(2, '0');
            const year = date.getFullYear();

            return `${month}/${day}/${year}`;
        },


        initializeCFDGraphData: function (data) {
            var processedGraph = {};
            if (data !== null) {
                if (data.type === 'cfd-graph') {
                    if(_.isEmpty(data.graphCriteria.categories)){
                      this.errorCase= true;
                    }
                    else{
                        this.errorCase= false;
                    }
                    this.populateCFDChart(data);
                    let timestamp = '';
                    if (data.updatedOn) {
                        timestamp = data.updatedOn;
                    } else {
                        timestamp = data.createdOn;
                    }
                    const dateData = new Date(timestamp);
                    let allGroupBys = [];
                    if (!_.isEmpty(data.allGroupBys)) {
                        allGroupBys = data.allGroupBys;
                    }
                    const keys = Object.keys(allGroupBys);
                    const transformedallGroupBys = keys.map(key => ({
                        id: key,
                        title: allGroupBys[key]
                    }));
                    let allIssueTypes = [];
                    if (!_.isEmpty(data.graphCriteria.issueTypeMap)) {
                        allIssueTypes = data.graphCriteria.issueTypeMap;
                    }
                    const keys2 = Object.keys(allIssueTypes);
                    const transformedIssueTypeallGroupBys = keys2.map(key => ({
                        id: key,
                        title: allIssueTypes[key]
                    }));
                    const issueTypeValues = Object.values(data.graphCriteria.issueTypeMap); // array of the values issue type titles
                    let graphCriteria = {
                        graphType: null,
                        selectedBoardTitle: null,
                        selectedIssueType: null,
                        selectedGroupBy: null,
                        selectedXAxis: null,
                        selectedInterval: null,
                        selectedFromStatus: null,
                        avgCycleTime: null,
                        avgLeadTime: null,
                        avgArrivalTime: null,
                        avgThroughputTime: null,
                        avgWIPTime: null,
                        toggleAvgLeadTime: null,
                        toggleAvgCycleTime: null,
                        toggleAvgWIPTime: null,
                        toggleAvgArrivalTime: null,
                        toggleAvgThroughputTime: null,
                        toggleAdvanceCalculation: null,
                        toggleAdvanceCriteria: null,
                        advanceCriteria: null,
                        boardItemsFilter: null,
                        selectedIssueType: null,
                        sessionBoardId:null,
                    };
                    graphCriteria.sessionBoardId=data.graphCriteria.sessionBoardId;
                    graphCriteria.graphType = 'Area';
                    graphCriteria.selectedBoardTitle = data.graphCriteria.boardTitle;
                    graphCriteria.selectedIssueType = data.graphCriteria.issueTypeTitle;
                    graphCriteria.selectedGroupBy = data.graphCriteria.groupByTitle ? data.graphCriteria.groupByTitle : data.graphCriteria.groupBy;
                    if (data.graphCriteria.intervals == 'sprints' || data.graphCriteria.intervals == 'weekly' || data.graphCriteria.intervals == 'monthly') {
                        graphCriteria.selectedXAxis = _.capitalize(data.graphCriteria.intervals);
                    } else {
                        graphCriteria.selectedXAxis = "Days";
                        graphCriteria.selectedInterval = data.graphCriteria.intervals;
                    }
                    graphCriteria.selectedFromStatus = data.graphCriteria.fromStatusTitle;
                    graphCriteria.toggleAvgLeadTime = data.graphCriteria.toggleAvgLeadTime;
                    graphCriteria.toggleAvgCycleTime = data.graphCriteria.toggleAvgCycleTime;
                    graphCriteria.toggleAvgWIPTime = data.graphCriteria.toggleAvgWIPTime;
                    graphCriteria.toggleAvgArrivalTime = data.graphCriteria.toggleAvgArrivalTime;
                    graphCriteria.toggleAvgThroughputTime = data.graphCriteria.toggleAvgThroughputTime;
                    graphCriteria.toggleAdvanceCalculation = data.graphCriteria.toggleAdvanceCalculation;
                    graphCriteria.toggleAdvanceCriteria = data.graphCriteria.toggleAdvanceCriteria;
                    graphCriteria.avgCycleTime = data.graphCriteria.avgCycleTime;
                    graphCriteria.avgLeadTime = data.graphCriteria.avgLeadTime;
                    graphCriteria.avgArrivalTime = data.graphCriteria.avgArrivalTime;
                    graphCriteria.avgThroughputTime = data.graphCriteria.avgThroughputTime;
                    graphCriteria.avgWIPTime = data.graphCriteria.avgWIPTime;
                    graphCriteria.boardItemsFilter = this.formatBoardItemsTitle(data.graphCriteria.boardItemsFilter);
                    graphCriteria.advanceCriteria = _.capitalize(data.graphCriteria.advanceCriteria);
                    graphCriteria.selectedIssueType = issueTypeValues;
                    processedGraph = {
                        options: Object.assign({}, this.stackedAreaChart.options),
                        show: true,
                        id: data.id,
                        timestampInfo: dateData.toLocaleString(),
                        name: data.name,
                        isSynced: false,
                        isSyncing: false,
                        type: "cfd-graph",
                        category: "Cumulative Flow",
                        allGroupBys: transformedallGroupBys,
                        graphCriteria: graphCriteria,
                        itemStatusMap: data.graphCriteria.itemStatusMap,
                        allIssueTypes: transformedIssueTypeallGroupBys,
                        columns: data.columns,
                        rows: data.rows,
                        posX: data.posX,
                        posY: data.posY,
                        itemStatusMap : data.graphCriteria.itemStatusMap? data.graphCriteria.itemStatusMap : {},
                    };
                    // Ensuring reactivity
                    this.$set(this.chartData, 'show', false);
                    this.$set(this.chartData, 'options', processedGraph.options);
                    this.$set(this.chartData, 'timestampInfo', dateData.toLocaleString());
                    this.$set(this, 'graphCriteria', graphCriteria);
                    this.$set(this, 'addWidget', false);
                    this.$set(this, 'loading', false);
                    let _this = this;
                    this.$nextTick(() => {
                        _this.setGraphHeight();
                        _this.chartData.show = true;
                        this.loading = false;
                    });
                }
            }
        },

        populateCFDChart: function (widget) {
            const data = [];
            let categories = [];
            let dataOfGraph = [];

            this.initializeStackedAreaGraph();
            let dummyData = [];
            let graphOptions = _.cloneDeep(this.stackedAreaChart.options);
            this.errorCaseNoData=false;
            if (widget.graphCriteria.intervals == 'days') {
                if (!_.isEmpty(widget.graphCriteria.categories)) {
                    const formattedDates = widget.graphCriteria.categories.map(dateString => {
                        const parts = dateString.split(" "); // Split the string by spaces
                        const month = parts[1];
                        const day = parts[2];
                        const year = parts[5];
                        return `${month} ${day} ${year}`;
                    });
                    graphOptions.xAxis.categories = formattedDates;
                }
            }
            else if(widget.graphCriteria.intervals == 'monthly'){

                const formattedList = Object.keys(widget.graphCriteria.relevantDates).map(sprint => {
                    const [startTimestamp, endTimestamp] = widget.graphCriteria.relevantDates[sprint];
                    const parts = sprint.split(" "); // Split the string by spaces
                    const month = parts[0];
                    const endDate = this.formatTimestamp(endTimestamp);
                    const year = endDate.slice(-2);
                    return `${month} ${year}`;
                });
                graphOptions.xAxis.categories = formattedList;
            }
            else {
                    const formattedList = Object.keys(widget.graphCriteria.relevantDates).map(sprint => {
                    const [startTimestamp, endTimestamp] = widget.graphCriteria.relevantDates[sprint];
                    const startDate = this.formatTimestamp(startTimestamp);
                    const endDate = this.formatTimestamp(endTimestamp);
                    return `${sprint}\n(${startDate} - ${endDate})`;
                });
               // graphOptions.xAxis.categories = widget.graphCriteria.categories;
                graphOptions.xAxis.categories = formattedList;
            }

            if (!_.isEmpty(widget.graphAdditionalCriteria)) {
                let index = 0;
                let itemStatusMap = {};
                if (widget.graphCriteria.itemStatusMap != null) {
                    if (!_.isEmpty(widget.graphCriteria.itemStatusMap)) {
                        itemStatusMap = widget.graphCriteria.itemStatusMap;
                    }
                }
                const teamMap = new Map();
                for (const pair of widget.graphAdditionalCriteria) {
                    const key = pair[0];
                    const value = pair[1];

                    const iteration = key.split('=')[0].replace('{', '').trim();
                    const team = key.split('=')[1].replace('}', '').trim();

                    if (!teamMap.has(team)) {
                        teamMap.set(team, {
                            counts: new Array(widget.graphCriteria.categories.length).fill(0),
                            itemIds: new Array(widget.graphCriteria.categories.length).fill([])
                        });
                    }

                    const teamData = teamMap.get(team);
                    const iterationIndex = widget.graphCriteria.categories.indexOf(iteration);
                    teamData.counts[iterationIndex] += value;

                    const itemIdsEntry = widget.graphCriteria.itemIdsMap.find(entry => entry[0] === key);
                    const itemIds = itemIdsEntry ? itemIdsEntry[1] : [];
                    teamData.itemIds[iterationIndex] = teamData.itemIds[iterationIndex].concat(itemIds);
                    teamMap.set(team, teamData);
                }

                let indexx = 0;
                for (const [key, value] of teamMap) {
                    const nonZeroData = value.counts.filter(item => item !== 0); // Filter out zero values
                    if (nonZeroData.length > 0) {
                        graphOptions.series[indexx] = {
                            name: key,
                            data: value.counts,
                            itemIds: value.itemIds,
                            color: !_.isEmpty(widget.graphCriteria.groupIdColorMap) ? widget.graphCriteria.groupIdColorMap[key] : '#FF0000',
                        };
                        indexx++;
                    }
                }
            }
                this.startDate=graphOptions.xAxis.categories[0];
                this.endDate=graphOptions.xAxis.categories[graphOptions.xAxis.categories.length-1];


            if(this.dateFiltered && this.customDate1!=null && this.customDate2!=null && (this.activeFilter=='7D' || this.activeFilter=='14D' || this.activeFilter=='1M' || this.activeFilter=='Custom') ){
                let startIndex=this.formatDate(this.customDate2);
                let endIndex= this.formatDate(this.customDate1);
                startIndex=graphOptions.xAxis.categories.indexOf(startIndex);
                endIndex=graphOptions.xAxis.categories.indexOf(endIndex);
                if((new Date(this.customDate2) < new Date(this.startDate)) && startIndex==-1 &&endIndex==-1){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(0,graphOptions.xAxis.categories.indexOf(this.endDate) +1);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(0,graphOptions.xAxis.categories.indexOf(this.endDate) +1);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(0,graphOptions.xAxis.categories.indexOf(this.endDate)+1);
                }
                else if((new Date(this.customDate2) > new Date(this.startDate)) && startIndex!=-1 &&endIndex!=-1){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(startIndex ,endIndex +1);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(startIndex,endIndex + 1);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(startIndex,endIndex +1);
                }
                else if(startIndex==-1 && endIndex==-1){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(startIndex, endIndex + 1);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(startIndex, endIndex + 1);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(startIndex, endIndex + 1);
                }
                else if(startIndex==-1 && endIndex!=-1){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(0,endIndex+1);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(0,endIndex+1);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(0,endIndex+1);
                }
                else if(startIndex!=-1){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(startIndex);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(startIndex);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(startIndex);
                }
                else if((new Date(this.customDate2) > new Date(this.startDate))){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = [];
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = [];
                    });
                    graphOptions.xAxis.categories=[];
                }
                this.dateFiltered=false;
                // this.customDate1=null;
                // this.customDate2=null;
            }
            else if(this.dateFiltered && widget.graphCriteria.intervals=='days' && (this.activeFilter=='7D' || this.activeFilter=='14D' || this.activeFilter=='1M' || this.activeFilter=='Custom')){
                let startIndex=this.formatDate(this.selectedStartDate);
                let endIndex= this.formatDate(this.selectedEndDate);
                startIndex=graphOptions.xAxis.categories.indexOf(startIndex);
                endIndex=graphOptions.xAxis.categories.indexOf(endIndex);
                if((new Date(this.customDate2) < new Date(this.startDate)) && startIndex==-1 &&endIndex==-1){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(0,graphOptions.xAxis.categories.indexOf(this.endDate) +1);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(0,graphOptions.xAxis.categories.indexOf(this.endDate) +1);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(0,graphOptions.xAxis.categories.indexOf(this.endDate)+1);
                }
                else if((new Date(this.customDate2) > new Date(this.startDate)) && startIndex!=-1 &&endIndex!=-1){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(startIndex ,endIndex +1);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(startIndex,endIndex + 1);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(startIndex,endIndex +1);
                }
                else if(startIndex==-1 && endIndex==-1 && this.selectedStartDate!=undefined && this.selectedEndDate!=undefined){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(startIndex, endIndex + 1);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(startIndex, endIndex + 1);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(startIndex, endIndex + 1);
                }
                else if(startIndex!=-1){
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(startIndex);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(startIndex);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(startIndex);
                }
                this.dateFiltered=false;
                // this.customDate1=null;
                // this.customDate2=null;
            }
            else if(widget.graphCriteria.intervals=='monthly' && (this.activeFilter=='3M' || this.activeFilter=='6M' || this.activeFilter=='1Y')){

                let matchingIndexes=this.findMatchingIndexes(graphOptions.xAxis.categories,this.filterMonths);
                if(matchingIndexes!=0){
                    let startIndex=matchingIndexes[0];
                    let endIndex= matchingIndexes[matchingIndexes.length-1];
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = seriesItem.itemIds.slice(startIndex, endIndex + 1);
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = seriesItem.data.slice(startIndex, endIndex + 1);
                    });
                    graphOptions.xAxis.categories=graphOptions.xAxis.categories.slice(startIndex, endIndex + 1);
                }
                else{
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.itemIds = [];
                    });
                    graphOptions.series.forEach(seriesItem => {
                        seriesItem.data = [];
                    });
                    graphOptions.xAxis.categories=[];
                }

                this.dateFiltered=false;
            }

            if(graphOptions.series.length>0 && graphOptions.series[0].data.length>0){
                this.stackedAreaChart.options = graphOptions;
            }
            else{
                this.errorCaseNoData=true;
            }
            },
        findMatchingIndexes(receivedArray, monthList) {
            return monthList.map(monthItem => {
                const [month, year] = monthItem.split(" ");
                return receivedArray.findIndex(item => {
                    const [receivedMonth, receivedYear] = item.split(" ");
                    return receivedMonth === month && receivedYear === year;
                });
            }).filter(index => index !== -1);
        },

        //Helper functions for formatting
        formattedCompletionStatus(status) {
            if (!_.isEmpty(status)) {
                return status.split(',').map(item => item.trim()).join(', ');
            } else {
                return '';
            }
        },

        formatInnerDate: function (dateString) {
            const parts = dateString.split(" ");
            const month = parts[1];
            const day = parts[2];
            const year = parts[5];
            return `${month} ${day} ${year}`;
        },

        formatBoardItemsTitle: function (input) {
            if (!input) {
                return '';
            }

            return input
                .split('-')
                .map(word => word.charAt(0).toUpperCase() + word.slice(1))
                .join(' ');
        },

        //Widget Removal & Duplicate
        handleRemoveWidget: function () {
            askFromSweetAlertWrapper(
                "Are you sure you want to remove this widget?",
                [() => this.$emit('handleRemovalAction', {id: this.widgetObj.id}), null],
                [takeNoAction]
            );
        },

        handleDuplicateWidget: function () {
			
			this.widgetObj.posX = this.widgetData.posX;
			this.widgetObj.posY = this.widgetData.posY;
			this.widgetObj.columns = this.widgetData.columns;
			this.widgetObj.rows = this.widgetData.rows;
			
            askFromSweetAlertWrapper(
                "Are you sure you want to duplicate this widget?",
                [() => this.$emit('handleDuplicateAction', {widget: this.widgetObj}), null],
                [takeNoAction]
            );
        },

        // Graph Detail View on Click of Points
        onClickCFDDataPoints: function (itemIds) {
            this.popupData = [];
            this.popupData.graphType = "Cumulative Flow Diagram";
            this.popupData.graphSpecificType = "cfd";
            this.popupData.itemIds = itemIds;
            this.popupData.total = itemIds.length;
            if(!_.isEmpty(this.widgetObj.graphCriteria.itemStatusMap) && this.widgetObj.graphCriteria.radioButtonSelection === 'statusCategory'){
                let filteredItemStatusMap = !_.isEmpty(itemIds) ? Object.fromEntries(
                    Object.entries(this.widgetObj.graphCriteria.itemStatusMap).filter(([key, value]) => {
                        let itemId = key.split(":")[0].replace("itemId_", "");
                        return itemIds?.includes(itemId);
                    })
                ):{};
                this.popupData.itemStatusMap = filteredItemStatusMap;
            }
            this.popupData.radioButtonSelection = this.widgetObj.graphCriteria.radioButtonSelection;
            this.popupData.popupTitle = "Cumulative Flow Diagram - Detail View";
            this.popupData.chartType = "bar";
            disableBodyScroll();
            this.isPopupOpen = true;
        },

        //method for graph sync
        handleSyncWidget: function (widgetSelected) {
            const data = {
                dashboardId: this.dashboardSelectedId,
                widgetId: this.widgetObj.id
            };
            this.loading = true;
            widgetSelected = this.widgetObj;
            axios.post("/dashboard/syncDashboardWidgetCFD", data)
                .then(response => {
                    if (response.data) {
                        this.boardId = widgetSelected.graphCriteria.boardId;
                        this.sessionBoardId = widgetSelected.graphCriteria.sessionBoardId;
                        this.graphTypeTitle = widgetSelected.graphCriteria.graphTypeTitle;
                        this.optionTypeTitle = widgetSelected.graphCriteria.optionTypeTitle;
                        this.boardTenant=widgetSelected.graphCriteria.selectedBoardTenant;
                        this.xAxis=widgetSelected.graphCriteria.intervals;
                        this.radioButtonSelection = widgetSelected.graphCriteria.radioButtonSelection;
                        this.selectedIssueType =  widgetSelected.graphCriteria.selectedIssueType;
                        this.selectedBoardTitle = widgetSelected.graphCriteria.boardTitle;
                        this.issueTypeTitleList = widgetSelected.graphCriteria.issueTypeTitle;
                        this.selectedFromStatus = widgetSelected.graphCriteria.fromStatusTitle;
                        this.toggleAvgLeadTime  = widgetSelected.graphCriteria.toggleAvgLeadTime;
                        this.toggleAvgCycleTime=widgetSelected.graphCriteria.toggleAvgCycleTime;
                        this.toggleAvgWIPTime=widgetSelected.graphCriteria.toggleAvgWIPTime;
                        this.toggleAvgArrivalTime=widgetSelected.graphCriteria.toggleAvgArrivalTime;
                        this.toggleAvgThroughputTime=widgetSelected.graphCriteria.toggleAvgThroughputTime;
                        this.toggleAdvanceCalculation=widgetSelected.graphCriteria.toggleAdvanceCalculation;
                        this.toggleAdvanceCriteria=widgetSelected.graphCriteria.toggleAdvanceCriteria;
                        this.startDate=widgetSelected.graphCriteria.startDate;
                        this.endDate=widgetSelected.graphCriteria.endDate;
                        this.selectedActiveStatus=widgetSelected.graphCriteria.selectedActiveStatus;
                        this.selectedWaitingStatus=widgetSelected.graphCriteria.selectedInProgressStatus;
                        this.selectedCompletedStatus=widgetSelected.graphCriteria.selectedCompletedStatus;
                        this.advanceCriteria=widgetSelected.graphCriteria.advanceCriteria;
                        this.selectedAdvanceCriteria=widgetSelected.graphCriteria.selectedAdvanceCriteria;
                        this.boardItemsFilter=widgetSelected.graphCriteria.boardItemsFilter;
                        this.widgetId = widgetSelected.id;
                        this.graphName = widgetSelected.name;
                        this.selectedCondition = widgetSelected.graphCriteria.selectedItems;
                        this.itemtags = widgetSelected.graphCriteria.itemTags;
                        this.itemTagsMeta = widgetSelected.graphCriteria.itemTagsMetaMap;

                        const widgetData = this.makeGraphObjectForDBStorage(response.data);

                        if (!_.isEmpty(widgetData)) {
                            return axios.post(`/dashboard/${this.dashboardSelectedId}/widget/save`, widgetData);
                        } else {
                            throw new Error('Processed widget data is empty');
                        }
                    } else {
                        throw new Error('Response data is empty');
                    }
                })
                .then(response => {
                    const updatedWidget = response.data.widget;
                    if(this.activeFilter==null || this.activeFilter=='0'){
                        this.widgetObj = updatedWidget;
                        this.initializeCFDGraphData(updatedWidget);
                        this.chartData.isSyncing = false;
                    }
                    else{
                        this.isSyncingFilter=true;
                        this.updatedWidgetObj=updatedWidget;
                        this.getDefinedFilterDate(this.activeFilter);
                        this.isSyncingFilter=false;
                    }
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    this.loading = false;
                });
        },
        handleRerenderWidget: function () {
			let _this = this;
			this.setGraphHeight();
			Vue.set(_this.widgetObj, "loading", true);
			Vue.nextTick(()=> {
				Vue.set(_this.widgetObj, "loading", false);
			});
		},
		setGraphHeight: function () {
			let unitHeight = this.$el.offsetHeight;
			this.chartData.options.chart.height = unitHeight - 100;
		}

    },

})
