const criteraiDetailsPie = Vue.component('criteria-details-pie', {
    template: `
		<div>
		   
			<div v-if="!_.isEmpty(graphCriteria.selectedIssueType) && !['cfd-graph', 'flow-time-graph', 'cycle-time-graph', 'lead-time-graph'].includes(type)" class="DFCB">
                <label>Issue Type: </label>
                <div class="" style="max-width: 180px;">{{graphCriteria.selectedIssueType.join(', ')}}</div>
			</div>	
			<div v-if="!_.isEmpty(graphCriteria.selectedIssueType) && !['cfd-graph', 'flow-time-graph', 'cycle-time-graph', 'lead-time-graph'].includes(type)" class="DFCB">
                <label>Issue Type: </label>
                <div class="" style="max-width: 180px;">{{graphCriteria.selectedIssueType.join(', ')}}</div>
			</div>	
			<div v-if="!_.isEmpty(graphCriteria.selectedCollection)" class="DFCB x-axis">
                <label>Collection Name</label>
                <div class="">
                    <a class="clickable-text" :href="collectionHyperlink" target="_blank">
                        {{_.capitalize(graphCriteria.selectedCollection)}}
                    </a>
                </div>
			</div>	
			<div v-if="!_.isEmpty(graphCriteria.selectedFilter)" class="DFCB x-axis">
                <label>Selected Filter</label>
                <div class="">{{_.capitalize(graphCriteria.selectedFilter)}}</div>
			</div>	
			<div v-if="!_.isEmpty(graphCriteria.selectedGroupBy)" class="DFCB">
                <label>Group By: </label>
                <div v-if="graphCriteria.selectedGroupBy === 'Session'">
                    PI Boards
                </div>
                <div v-else class="">{{groupTitle}}</div>
			</div>		               
        </div>
                         
		`, data() {
        return {};
    },

    props: {
        graphCriteria: {
            type: Object, required: true
        },
        type: {
            type: String, required: true
        },
        groupTitle: null,
        releaseTrainId: null
    },

    created() {

    },

    mounted() {
    },

    computed: {
        collectionHyperlink() {
            // Construct the base URL and append the session query parameter
            const baseURL = `${window.location.protocol}//${window.location.hostname}${window.location.port ? ':' + window.location.port : ''}`;
            return `${baseURL}/org#/ART/${this.releaseTrainId}/backlog`;
        },
        formattedActiveStatus() {
            if (!_.isEmpty(this.graphCriteria.selectedFromStatus)) {
                return this.graphCriteria.selectedFromStatus.split(',').map(item => item.trim()).join(', ');
            } else {
                return '';
            }
        },
        formattedWaitingStatus() {
            if (!_.isEmpty(this.graphCriteria.selectedToStatus)) {
                return this.graphCriteria.selectedToStatus.split(',').map(item => item.trim()).join(', ');
            } else {
                return '';
            }
        },
    },

    methods: {},
})
