
const flowVelocityCriteria = Vue.component('flow-velocity-criteria', {
    template:`
		<div id="overlay" class="overlay" style="display: block;">	
			<div class="ui-dialog selectionPopUp">
				<div v-if="showloader" class="loader">
					<div>
						<div class="loaderinteg"></div>
					</div>
				</div>
				<div class="selectionPopUpHeader DFCB  pd-20 pb-0">
					<span class="fs-18 ftsb widgetPopUpTitle">
						 {{this.optionTypeTitle}}
					</span>
					<em title="Close" class="rmv-ico ti-close rnd DAJ p-intial" @click="$emit('close')"></em>
<!--					<em title="Back" class=" mr-10 ti-arrow-left " @click="$emit('back',graphTypeOptionTitle)"></em>-->
				</div>
				<div class="selectionPopUpContentWraper">
					<div  class="rec lblm">
						<div class="DFA">
					        <label>Enter Title of Graph
					        <span class="tooltip ml-10 dropTip ttl">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">Enter the title that better explains your graph.</div>
                            </span>
                            </label>
                        </div>
						<input id="graphTitle" maxlength="255" name="Enter Name" class="txsrch filterinput mr-10"  placeholder="Type Widget Name" v-model="graphName" type="text" />
					</div>
					<div v-if="_.isEmpty(boardListing) && optionTypeTitle !== 'Time in Status' && optionTypeTitle !== 'Lead Time Graph' && optionTypeTitle !=='Flow Time Graph' && optionTypeTitle !== 'Flow Efficiency Graph' && optionTypeTitle !== 'Flow Velocity Graph' && optionTypeTitle !== 'Flow Load Graph' && optionTypeTitle !== 'Flow Distribution Graph' && !_.isEmpty(collections)" class="rec lblm">
						<label>Select Graph Type</label>
						<div class="selectcont nwsl FL w-half">
							<vz-select v-model="selectedGraph" :options="graphsList" empty-selection-text="Select Graph" label="name" track-by="id" value-type="value" @close="" @select="handleGraphSelection()" />
						</div>
						<span class="tooltip ml-10 dropTip nxt">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip">
                                text test here
                            </div>
                        </span>
					</div> 
					<div v-if=" optionTypeTitle == 'Flow Time Graph' || optionTypeTitle == 'Flow Efficiency Graph' || optionTypeTitle == 'Flow Velocity Graph' || optionTypeTitle == 'Flow Load Graph' || optionTypeTitle == 'Flow Distribution Graph' " class="rec lblm" >
					    <label>Select Chart Type</label>
					    <div class="selectcont nwsl FL w-half">
					    	<vz-select v-model="chartType" :options="chartTypeList" empty-selection-text="Select Chart Type" label="name" track-by="name" value-type="value" @close=""  />
					    </div>
					    <span class="tooltip ml-10 dropTip nxt">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip visualizing">Choose the chart type for visualizing your data (e.g., bar, line, or stack view).</div>
					        <!--
					        <div class="hovtooltip selectChart">
                                Select the desired graph type from the dropdown menu to visualize the data.
                                <br/><br/>
                                <span class="titleName">Stack Graph:</span> A stack-up graph displays cumulative data segments, showing how different parts contribute to the whole over time or categories. Ideal for visualizing component contributions.
                                <br/><br/>                                    
                                <span class="titleName">Line Graph:</span> A line graph connects data points with a continuous line, effectively illustrating trends and changes over time. Perfect for tracking progress and patterns.
                            </div> -->
                        </span>
                    </div> 
					<div v-if=" optionTypeTitle !== 'Cumulative Flow Diagram' && optionTypeTitle !== 'Time in Status' && optionTypeTitle !== 'Lead Time Graph' && optionTypeTitle !=='Flow Time Graph' && optionTypeTitle !== 'Flow Efficiency Graph' && optionTypeTitle !== 'Flow Velocity Graph' && optionTypeTitle !== 'Flow Load Graph' && optionTypeTitle !== 'Flow Distribution Graph' && _.isEmpty(collections)" class="rec lblm">
						<label>Select Graph Type</label>
						<div class="selectcont nwsl FL w-half">
							<vz-select v-model="selectedGraph" :options="graphsListCFD" empty-selection-text="Select Graph" label="name" track-by="id" value-type="value" @close="" @select="handleGraphSelection()" />
						</div>
						<span class="tooltip ml-10 dropTip nxt">
						        <em class="infotxt"></em> 
						        <div class="hovtooltip visualizing">Choose the chart type for visualizing your data (e.g., bar, line, or stack view).</div>
						        <!--
						        <div class="hovtooltip">
                                    Select the desired graph type from the dropdown menu to visualize the data.

                                    <span class="ftsb">Stack Graph:</span> "A stack-up graph displays cumulative data segments, showing how different parts contribute to the whole over time or categories. Ideal for visualizing component contributions."
                                    
                                    <br/>
                                    
                                    <span class="ftsb">Line Graph:</span> "A line graph connects data points with a continuous line, effectively illustrating trends and changes over time. Perfect for tracking progress and patterns."
                                </div>-->
                        </span>
					</div>			
					<div v-if="!_.isEmpty(boardListing) && !_.isEmpty(selectedBoard) && optionTypeTitle === 'Lead Time Graph' && _.isEmpty(collections)" class="rec lblm">
						<label>Select Statues Criteria</label>
						<div style="display: inline-block;">
                            <div v-for="(option, index) in radioOptionsLeadTime" :key="index" style="display: inline-block;">
                              <input 
                                type="radio" 
                                :id="option.value" 
                                :value="option.value" 
                                v-model="pickedRadioType" 
                                :checked="index === 0" 
                                @change="handleRadioChange(option.value)" 
                                style="display: inline-block; margin-right: 5px;" 
                              />
                              <label :for="option.value" style="display: inline-block; margin-right: 15px;">
                                {{ option.label }}
                              </label>
                            </div>
                          </div>
						<span class="tooltip dropTip nxt">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip">
                               Select either individual “Status” or “Status Category”. The statuses dropdown will adjust based on your choice. Selecting “Status Category” will include all statuses under that category.
                            </div>
                        </span>
					</div>
					<div v-if="!_.isEmpty(collections) && !_.isEmpty(graphName)  && graphSelected == true" class="rec lblm">
						<label>Select Collection</label>
						<div class="DF">
                            <div class="selectcont nwsl FL"><vz-select v-model="selectedCollection" :options="collections" empty-selection-text="Select Collection" label="title" track-by="id" value-type="object" @close="" @select="handleCollectionSelection()"/></div>
                            <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip">
                                        text test here
                                    </div>
                            </span>
                        </div>
					</div>				
					<div v-if="(!_.isEmpty(boardListing) &&  optionTypeTitle === 'Cumulative Flow Diagram'  && _.isEmpty(collections)) || ( (!_.isEmpty(boardListing) && ( optionTypeTitle === 'Flow Time Graph' || optionTypeTitle === 'Flow Efficiency Graph' || optionTypeTitle === 'Flow Velocity Graph'  || optionTypeTitle === 'Flow Load Graph' || optionTypeTitle === 'Flow Distribution Graph' || optionTypeTitle === 'Time in Status' || optionTypeTitle === 'Lead Time Graph' ) && _.isEmpty(collections)))" class="rec lblm">
						<label>Select Board</label>
						<div id="piBoard" class="selectcont nwsl FL w-half"><vz-select v-model="selectedBoard" :options="boardListing" empty-selection-text="Select Program Board" label="title" track-by="_id" value-type="object" @close="" @select="getStatusOrIssueTypeDataOnTheBasiesOfSelection()"/></div>
						<span class="tooltip ml-10 dropTip nxt">
						        <em class="infotxt"></em> 
						        <div class="hovtooltip">
                                   Choose a Program board from the dropdown list menu. The list displays the boards you have access to.
                                </div>
                        </span>
					</div>	
					
					<div v-if=" (!_.isEmpty(boardListing))" class="rec lblm" >
					    <label>Please select board items</label>
					    <div id="boardItemsFilter" class="selectcont nwsl FL w-half">
					    	<vz-select v-model="boardItemsFilter" :options="boardItemsFilterList" empty-selection-text="Select board items" label="name" track-by="id" value-type="value" @close="" @select="handleBoardFilterSelection()"  />
					    </div>
					    <span class="tooltip ml-10 dropTip nxt">
						        <em class="infotxt"></em> 
						        <div class="hovtooltip selectBordItems">
                                   Select items for the graph.
                                   <ul class="tooltipList ">
                                        <li>'ALL' includes both PI board-planned and backlog items.</li>
                                        <li>'Planned items' are scheduled in the PI board.</li>
                                        <li>'Unplanned items' remain in the backlog.</li>
                                   </ul>
                                </div>
                        </span>
                    </div> 

					<div v-if="!_.isEmpty(boardListing) && (optionTypeTitle =='Item Completion by Teams' || optionTypeTitle === 'Time in Status' ||  optionTypeTitle === 'Cumulative Flow Diagram' || optionTypeTitle ==='Flow Time Graph' || optionTypeTitle === 'Flow Velocity Graph' || optionTypeTitle === 'Flow Load Graph' || optionTypeTitle === 'Flow Distribution Graph' ) && !_.isEmpty(selectedBoard)  && _.isEmpty(collections)" class="rec lblm">
					    <div class="DFA">
                            <label>Select Status Criteria
                             <span class="tooltip ml-10 dropTip">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip selectStatusCri">
                                    Select either individual “Status” or “Status Category”. The statuses dropdown will adjust based on your choice. Selecting “Status Category” will include all statuses under that category.
                                </div>
                             </span>
                             </label>
                         </div>
						<div style="display: inline-block;">
							<div v-for="(option, index) in radioOptions" :key="index" style="display: inline-block;">
								<input  
								type="radio" 
                                :id="option.value" 
                                :value="option.value" 
                                v-model="pickedRadioType" 
                                :checked="index === 0" 
                                @change="handleRadioChange(option.value)" 
                                style="display: inline-block; margin-right: 5px;"  />
								<label :for="option.value" style="display: inline-block; margin-right: 15px;">{{ option.label }}</label>
							</div>
						</div>
					</div>	
					
					<div v-if="!_.isEmpty(filterTypes) && !_.isEmpty(selectedCollection) &&  !_.isEmpty(graphName) && !_.isEmpty(selectedGraph) && _.isEmpty(boardListing) && !_.isEmpty(collections)  && graphSelected == true" class="rec lblm">
						<label>Select Graph Groupby</label>
						<div class="DF">
                            <div class="selectcont nwsl FL">
                                <vz-select v-model="selectedFilterType" :options="filterTypes" empty-selection-text="Select Graph Groupby" label="name" track-by="id" value-type="value" @close="" @select="handleFilterTypeSelection()" />
                            </div>
                            <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip">
                                        text test here
                                    </div>
                            </span>
                        </div>
					</div>				
					<div v-if="!_.isEmpty(filterList)" class="rec lblm">
							<label>Select Datasource Filters</label>
							<div class="DF">
                                <div class="selectcont nwsl FL"><vz-select v-model="selectedFilter" :options="filterList" empty-selection-text="Select Data Source Filter" label="name" track-by="id" value-type="object" @close="" @select="handleFilterSelection()" /></div>
                                <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip">
                                        text test here
                                    </div>
                                </span>
                            </div>
						</div>
					<div v-if="_.isEmpty(filterList) && !_.isEmpty(collections) && filterTypeSelected && graphSelected == true && !_.isEmpty(selectedCollection)" class="rec lblm">
							No Filters Available
					</div>
					<div v-if="graphSelected && !_.isEmpty(graphName) && !_.isEmpty(selectedFilter) && !_.isEmpty(selectedFilterType) && !_.isEmpty(selectedCollection) " class="rec lblm">
						<label>Select Criteria</label>
						<div class="rec" v-for="(filter,filterIndex) in selectedFilters" :key="filterIndex">	
								<div v-if="filter.id === 'status' && selectedFilterType == 'status' && filterSelected" class="selectcont FL d">
									<vz-select 
										:multiple="true" 
										label="title" 
										track-by="key" 
										:title="filter.title" 
										:disabled="!filter.editable"
										empty-selection-text="Select Status Criteria" 
										class="multi-filter"
										value-type="value" 
										v-model="selectedCondition" 
										:options="optionsList"
										:groups-enabled=true
										:show-select-all-on-group=true
										:key="filter.title"
									/>
								</div>	
								
								<div v-if="filter.id === 'teams' && selectedFilterType == 'teams' && filterSelected" class="selectcont FL d">
									<vz-select :multiple="true" label="title" track-by="id" :title="filter.title"
										empty-selection-text="Select Teams Criteria" class="multi-filter" 
										value-type="value" v-model="selectedCondition" 
										:options="optionsList"
										:groups-enabled=false
									/>
								</div>		
								<span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip">
                                    	Select either individual “Status” or “Status Category”. The statuses dropdown will adjust based on your choice. Selecting “Status Category” will include all statuses under that category.
                                    </div>
                                </span>				
						</div>
					</div>
					<div v-if="  optionTypeTitle !== 'Time in Status'  &&  ( optionTypeTitle === 'Cumulative Flow Diagram' && pickedRadioType === 'status' ) && optionTypeTitle !== 'Flow Time Graph' && optionTypeTitle !== 'Lead Time Graph' && graphSelected && !_.isEmpty(selectedBoard) && selectedFilterType == 'cfd'   && !_.isEmpty(selectedFilterType) && !_.isEmpty(boardListing)  && _.isEmpty(selectedCollection) " class="rec lblm">
						<label>Select Statuses</label>
						<div id="selected-condition" class="selectcont FL d w-half">
							<vz-select 
								:multiple="true" 
								label="title" 
								empty-selection-text="Select Status" 
								class="multi-filter"
								value-type="value" 
								v-model="selectedCondition" 
								:options="statusList"
								:groups-enabled=true
								:show-select-all-on-group=true
								track-by="ids"
							/>
						</div>	
						<span class="tooltip ml-10 dropTip nxt">
                            <em class="infotxt"></em> 
                            <div class="hovtooltip">
                                Please select one or more Statuses to be displayed on the CFD graph.
                            </div>
                        </span>	
					</div>

					<div  v-if=" pickedRadioType == 'statusCategory' &&  optionTypeTitle === 'Cumulative Flow Diagram'   && !_.isEmpty(selectedBoard)  && _.isEmpty(selectedCollection) " class="rec lblm">
                                <label>Select Status Categories</label>
                                <div id="selected-condition" class="selectcont FL d w-half"><vz-select v-model="selectedCondition" :multiple="true"  :options="categoryList" empty-selection-text="Select Status Category" label="title" track-by="ids" value-type="value" @close=""/></div>
                            <span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Please select one or more Statuses to be displayed on the CFD graph.
                                </div>
                            </span>	
                    </div>		
					

					<div v-if=" ( optionTypeTitle === 'Flow Efficiency Graph' || ( optionTypeTitle === 'Flow Velocity Graph' && pickedRadioType == 'status' ) || ( optionTypeTitle =='Item Completion by Teams' || optionTypeTitle === 'Flow Distribution Graph' && pickedRadioType == 'status' ))  && !_.isEmpty(selectedBoard) " class="rec lblm">
						<label v-if= " optionTypeTitle === 'Flow Efficiency Graph' ">Status for Active Time (Cycle Time)</label>
						<label v-if= " optionTypeTitle === 'Flow Velocity Graph' || optionTypeTitle =='Item Completion by Teams'">Status Criteria for Item Completion</label>
						<label v-if= " optionTypeTitle === 'Flow Distribution Graph' ">Distribution Status Criteria</label>
						<div  id="activeStatus" class="selectcont FL d w-half">
							<vz-select 
								:multiple="true" 
								label="title" 
								empty-selection-text="Select Status" 
								class="multi-filter"
								value-type="value" 
								v-model="selectedActiveStatus" 
								:options="statusList"
								:groups-enabled=true
								:show-select-all-on-group=false
								track-by="ids"
							/>
						</div>	
    					<span class="tooltip ml-10 dropTip nxt" v-if= " optionTypeTitle === 'Flow Efficiency Graph' ">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip">
                               Choose a Program board from the dropdown list menu. The list displays the boards you have access to.
                            </div>
                        </span>
                        <span class="tooltip ml-10 dropTip nxt"  v-if= " optionTypeTitle === 'Flow Velocity Graph' || optionTypeTitle =='Item Completion by Teams'">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip">
                               Choose a Program board from the dropdown list menu. The list displays the boards you have access to.
                            </div>
                        </span>
                        <span class="tooltip ml-10 dropTip nxt" v-if= " optionTypeTitle === 'Flow Distribution Graph' ">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip">
                               Please select one or more Statuses to view items’ data on the graph.
                            </div>
                        </span>
					</div>	
					
					<div v-if=" pickedRadioType == 'statusCategory' && (optionTypeTitle === 'Flow Velocity Graph' || optionTypeTitle === 'Flow Distribution Graph' )  && !_.isEmpty(graphName)   && !_.isEmpty(selectedBoard)  && _.isEmpty(selectedCollection) " class="rec lblm">
                            <label v-if= " optionTypeTitle === 'Flow Velocity Graph' ">Select Completion Status Category</label>
                            <label v-if= " optionTypeTitle === 'Flow Distribution Graph' ">Distribution Status Criteria</label>
                            <div class="selectcont FL d w-half">
                            <vz-select v-model="selectedActiveStatus" 
                             :multiple="true" 
                             :options="categoryList" 
                              empty-selection-text="Select Status Category"
                              label="title" 
                              track-by="ids" 
                              value-type="value" @close=""/>
                              </div>
                            <span class="tooltip ml-10 dropTip nxt" v-if= " optionTypeTitle === 'Flow Velocity Graph' ">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Please select one or more Statuses Categories to be displayed on the flow velocity graph.
                                </div>
                            </span>
                            <span class="tooltip ml-10 dropTip nxt" v-if= " optionTypeTitle === 'Flow Distribution Graph' ">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Please select one or more Status categories to view items’ data on the graph.
                                </div>
                            </span>	
                     </div>			
					
					<div v-if=" optionTypeTitle === 'Flow Efficiency Graph' && !_.isEmpty(selectedBoard)" class="rec lblm">
                        <label>
                        	Lead Time Definition
                        	 <span class="tooltip ml-10 dropTip rhttip">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    If the From Creation Date toggle is on, the start status dropdown will be disabled and the system counts total time from creation date of issue till selected End Status.
                                </div>
                            </span>	
                        </label>
                        <label>From Creation Date</label>
                        <div class="switch-button-class">
                            <input type="checkbox" id="creationCheckbox" @click="toggleCreationDateButton()"  :class="[checkExternalValue(toggleCreationDate) ? 'checked' : 'unchecked']">
                            <span><label for="creationCheckbox"></label></span>
                        </div>
				    </div>
					
					<div class="DFA FL w-full gap-2">
					    <div v-if="(optionTypeTitle === 'Flow Efficiency Graph' && (!toggleCreationDate)  && !_.isEmpty(selectedBoard) )  || ( pickedRadioType == 'status' && ( ( ( optionTypeTitle === 'Time in Status' || optionTypeTitle === 'Lead Time Graph') && graphSelected ) || optionTypeTitle === 'Flow Time Graph' )   && !_.isEmpty(selectedBoard) ) " class="rec lblm">
                            <label>From Status</label>
                            <div class="DF">
                                <div  id="fromStatus" class="selectcont FL d">
                                    <vz-select 
                                        :multiple="false" 
                                        label="title" 
                                        empty-selection-text="Select From Status" 
                                        class="multi-filter"
                                        value-type="value" 
                                        v-model="statusListing.startOfSelectedStatus" 
                                        :options="fromStatusList"
                                        :groups-enabled=true
                                        :show-select-all-on-group=false
                                        track-by="ids"
                                    />
                                </div>	
                                <span class="tooltip ml-10 dropTip nxt">
                                   <em class="infotxt"></em> 
                                   <div class="hovtooltip fromStatus">
                                     Please select the initial status to start tracking the cycle time from this point. For example,
    								 <br/>
    								 From status is selected as “To Do” and To status is selected as “Done”, it will calculate cycle time of items which moved from “To Do” status till “Done” status.
                                  </div>
                                </span>	
                            </div>
                        </div>		
					<div v-if=" ( optionTypeTitle === 'Flow Efficiency Graph'   && !_.isEmpty(selectedBoard) ) || (optionTypeTitle === 'Lead Time Graph' && (pickedRadioType == 'status' || pickedRadioType == 'creationDate') && !_.isEmpty(selectedBoard))  || ( pickedRadioType == 'status' && ( ( ( optionTypeTitle === 'Time in Status') && graphSelected ) || optionTypeTitle === 'Flow Time Graph' )   && !_.isEmpty(selectedBoard) ) " class="rec lblm">
                            <label>To Status</label>
                            <div class="DF">
                                <div id="toStatus" class="selectcont FL d">
                                    <vz-select 
                                        :multiple="false" 
                                        label="title" 
                                        empty-selection-text="Select To Status" 
                                        class="multi-filter"
                                        value-type="value" 
                                        v-model="statusListing.endOfSelectedStatus" 
                                        :options="toStatusList"
                                        :groups-enabled=true
                                        :show-select-all-on-group=false
                                        track-by="ids"
                                    />
                                </div>	
                                <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip toStatus">
                                        Please select the ending status to track the time till this point. For example,
                                        <br/>
                                        From status is selected as “To Do” and To status is selected as “Done”, it will start calculating time from “To Do” status till “Done” status.
                                    </div>
                                </span>	
                            </div>
                        </div>
					</div>	
					<div class="DFA FL w-full gap-2">
                        <div v-if=" ( pickedRadioType == 'status' && optionTypeTitle === 'Flow Load Graph'  )   && !_.isEmpty(selectedBoard)  && !_.isEmpty(graphName)   && _.isEmpty(selectedCollection)  " class="rec lblm w-half pr-32">
                            <label>Active Criteria</label>
                            <div class="DF">
                            <div id ="activeCriteria" class="selectcont FL d">
                                <vz-select 
                                    :multiple="true" 
                                    label="title" 
                                    empty-selection-text="Select Active Criteria" 
                                    class="multi-filter"
                                    value-type="value" 
                                    v-model="activeStatusList" 
                                    :options="statusList"
                                    :groups-enabled=true
                                    :show-select-all-on-group=false
                                    track-by="ids"
                                />
                            </div>	
                            <span class="tooltip ml-10 dropTip nxt rhttip">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Select one or more statuses to define the Active Criteria. For example,
	                                    <br />
    									Active criteria is selected as “To Do” and Waiting criteria is selected as “Done”, it will calculate flow load of items based on their active time while moving from “To Do” to “Done” status.
                                </div>
                            </span>	
                            </div>
                        </div>		
                        <div v-if=" ( pickedRadioType == 'status' && optionTypeTitle === 'Flow Load Graph'  )   && !_.isEmpty(selectedBoard)  && !_.isEmpty(graphName)    && _.isEmpty(selectedCollection) " class="rec lblm w-half pr-32">
                            <label>Waiting Criteria</label>
                            <div class="DF">
                            <div id="waitingCriteria" class="selectcont FL d" style="width: 94%">
                                <vz-select 
                                    :multiple="true" 
                                    label="title" 
                                    empty-selection-text="Select Waiting Criteria" 
                                    class="multi-filter"
                                    value-type="value" 
                                    v-model="inProgressStatusList" 
                                    :options="statusList"
                                    :groups-enabled=true
                                    :show-select-all-on-group=false
                                    track-by="ids"
                                />
                            </div>	
							<span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Select one or more statuses to define the Waiting Criteria. For example,
	                                <br />
    								Active criteria is selected as “To Do” and Waiting criteria is selected as “Done”, it will calculate flow load of items based on their waiting time while moving from “To Do” to “Done” status.
                                </div>
                            </span>
                            </div>
                        </div>
					</div>	

					<div class="DFA FL w-full gap-2"> 
                        <div v-if="!_.isEmpty(boardSprintListing)" class="rec lblm">
                            <label>Select Sprint</label>
                            <div  class="selectcont FL d">
                                <vz-select 
                                    :multiple="true" 
                                    label="title" 
                                    empty-selection-text="Select Program Board Sprint" 
                                    class="multi-filter"
                                    value-type="object" 
                                    v-model="selectedBoardSprint" 
                                    :options="boardSprintListing"
                                    :show-select-all-on-group=false
                                    track-by="id"
                                />
                            </div>	
                            <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip">
                                        text test here
                                    </div>
                            </span>	
                        </div>
					</div>	
					<div class="DFA FL w-full gap-2">						
                        <div v-if=" pickedRadioType == 'statusCategory' && ( ( ( optionTypeTitle === 'Time in Status' || optionTypeTitle === 'Lead Time Graph' || optionTypeTitle === 'Flow Efficiency Graph') && graphSelected) || optionTypeTitle === 'Flow Time Graph' )  && !_.isEmpty(selectedBoard) " class="rec lblm">
                            <label>From Status Category</label>
                            <div class="DF">
                                <div id="fromStatus" class="selectcont nwsl FL"><vz-select v-model="statusListing.startOfSelectedStatus" :options="categoryList" empty-selection-text="Select From Category" label="title" track-by="ids" value-type="value" @close=""/></div>                                
                                <span class="tooltip ml-10 dropTip nxt">
                                   <em class="infotxt"></em> 
                                   <div class="hovtooltip fromStatus">
                                     Please select the initial status category to start tracking the time from this point. For example,
                                     <br/>       
                                     From status category is selected as “To Do” and To status category is selected as “Done”, it will start calculating time from “To Do” status category till “Done” status.
                                  </div>
                                </span>		
                            </div>
                        </div>		
                        <div v-if=" pickedRadioType == 'statusCategory' && ( ( ( optionTypeTitle === 'Time in Status' || optionTypeTitle === 'Lead Time Graph' || optionTypeTitle === 'Flow Efficiency Graph') && graphSelected) || optionTypeTitle === 'Flow Time Graph' )  && !_.isEmpty(selectedBoard) " class="rec lblm">
                            <label>To Status Category</label>
                            <div class="DF">
                                <div id="toStatus" class="selectcont nwsl FL"><vz-select v-model="statusListing.endOfSelectedStatus" :options="categoryList" empty-selection-text="Select To Category" label="title" track-by="ids" value-type="value" @close=""/></div>                               
                                <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip toStatus">                                        
                                        Please select the ending status to track the cycle time till this point. For example,
    									<br/>
    									From status is selected as “To Do” and To status is selected as “Done”, it will calculate cycle time of the items which moved from “To Do” status till “Done” status.
                                    </div>
                                </span>
                            </div>	
                        </div>	
					</div>	
					
					<div class="DFA FL w-full gap-2">						
                        <div v-if=" ( pickedRadioType == 'statusCategory' && optionTypeTitle === 'Flow Load Graph'  )   && !_.isEmpty(selectedBoard)  && !_.isEmpty(graphName)  && _.isEmpty(selectedCollection)  " class="rec lblm w-half pr-32">
                            <label>Active Criteria</label>
                            <div class="DF">
                                <div id ="activeCriteria" class="selectcont nwsl FL"><vz-select v-model="activeStatusList" :multiple="true"  :options="categoryList" empty-selection-text="Select Active Criteria" label="title" track-by="ids" value-type="value" @close=""/></div>
                                <span class="tooltip ml-10 dropTip nxt rhttip">
	                                <em class="infotxt"></em> 
	                                <div class="hovtooltip">
	                                    Select one or more statuses to define the Active Criteria. For example,
	                                    <br />
    									Active criteria is selected as “To Do” and Waiting criteria is selected as “Done”, it will calculate flow load of items based on their active time while moving from “To Do” to “Done” status.
	                                </div>
	                            </span>	
                            </div>	
                        </div>		
                        <div v-if=" ( pickedRadioType == 'statusCategory' && optionTypeTitle === 'Flow Load Graph'  )   && !_.isEmpty(selectedBoard) && !_.isEmpty(graphName) && _.isEmpty(selectedCollection)  " class="rec lblm w-half pr-32">
                            <label>Waiting Criteria</label>
                            <div class="DF">
                                <div id="waitingCriteria" class="selectcont nwsl FL" style="width: 94%"><vz-select v-model="inProgressStatusList" :multiple="true"  :options="categoryList" empty-selection-text="Select Waiting Criteria" label="title" track-by="ids" value-type="value" @close=""/></div>
                                <span class="tooltip ml-10 dropTip nxt">
	                                <em class="infotxt"></em> 
	                                <div class="hovtooltip">
	                                    Select one or more statuses to define the Waiting Criteria. For example,
		                                <br />
	    								Active criteria is selected as “To Do” and Waiting criteria is selected as “Done”, it will calculate flow load of items based on their waiting time while moving from “To Do” to “Done” status.
	                                </div>
	                            </span>
                            </div>	
                        </div>	
					</div>		
				
					<div v-if="((!_.isEmpty(issueTypesList)  &&  ((optionTypeTitle === 'Time in Status'  ) || optionTypeTitle === 'Lead Time Graph'  ) && graphSelected && !_.isEmpty(selectedBoard)  && !_.isEmpty(graphName)   && !_.isEmpty(boardListing)  && _.isEmpty(selectedCollection)) || (( optionTypeTitle =='Item Completion by Teams' || optionTypeTitle =='Flow Time Graph' || optionTypeTitle == 'Flow Efficiency Graph' || optionTypeTitle == 'Flow Velocity Graph' || optionTypeTitle == 'Flow Load Graph' || optionTypeTitle == 'Flow Distribution Graph'  ) && !_.isEmpty(selectedBoard) )) " class="rec lblm">
						<label>Select Issue Type</label>
						<div class="DF">
                            <div id="issueType" class="selectcont FL d w-half">
                                <vz-select 
                                    :multiple="true" 
                                    label="name"
                                    empty-selection-text="Select Issue Type" 
                                    class="multi-filter"
                                    value-type="value" 
                                    v-model="selectedIssueType" 
                                    :options="issueTypesList"
                                    :groups-enabled=false
                                    :show-select-all-on-group=false
                                    track-by="id"
                                    @select="clearFilterIfEmptyIssueTypes"
                                />
                            </div>	
                            <span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Choose one or more issue types from the dropdown menu. The widget will display items with the selected issue types from the chosen Program board.
                                </div>
                            </span>
                        </div>	
					</div>
					<div v-if="!_.isEmpty(selectedIssueType) && optionTypeTitle !== 'Cumulative Flow Diagram' " class="prow">
                        <label class="p-rel">Select Items <a v-if="!_.isEmpty(this.filterwithMeta)" href="javascript:void(0);" class="reset und" @click="resetFilter">Reset</a></label>
                        <div class="DF">
                            <div id="srch-cont" class="srchout prow">
                                <div id="searchTerm" class="sin">
                                    <div class="c1">
                                        <input 
                                            id="input-srch-ext" 
                                            class="srfld form-control" 
                                            type="text" 
                                            placeholder="To search, please type ID or Title..." 
                                            v-model="searchTerm" 
                                            @input="handleSearch"
                                        />                                        
                                    </div>
                                    <div id="srch-lst-cont" class="link-over drop_box cssHidea"></div>
                                </div>
                            </div>
                            <span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Search and select items of the chosen issue type to display their data exclusively on the graph.
                                </div>
                            </span>
                        </div>
                    </div>
                    <div v-if="!_.isEmpty(selectedIssueType) && optionTypeTitle !== 'Cumulative Flow Diagram'">
                        <span  class="search_tags">
                            <ul id="search-text_tags">
                                <li v-for="(title, id) in filterwithMeta" :key="id" class="tooltip">
                                    {{ title.key }} 
                                    <i @click="onRemoveTag(id)" class="ti-close"></i>
                                    <div class="hovtooltip">{{ title.title }} </div>
                                </li>
                            </ul>
                        </span>
                    </div>
					
					<div v-if="(optionTypeTitle === 'Flow Time Graph' || optionTypeTitle === 'Flow Efficiency Graph' || optionTypeTitle == 'Flow Velocity Graph' || optionTypeTitle == 'Flow Load Graph' || optionTypeTitle == 'Flow Distribution Graph' ) && !_.isEmpty(selectedBoard)" class="rec lblm">
						<label>Group by</label>
						<div>
                            <div id="groupBy" class="selectcont nwsl FL w-half">
                                <vz-select  id="groupByBacklogDashboard" :multiple="false" label="title" empty-selection-text="Group By" class="multi-filter"
                                track-by="id" value-type="value" :options="flowTimeLineGroupByList" :groups-enabled="true" v-model = "selectedFlowTimeLineGroupBy"
                                group-values="items" group-label="title" selected-title-class=""
                                :show-select-all-on-group="false" 
                                @select ="handleGroupBySelection"
                                >	
                                </vz-select>						
                            </div>
                            <span class="tooltip ml-10 dropTip nxt">
                                  <em class="infotxt"></em> 
                                  <div class="hovtooltip groupByTip">
                                      Select a criterion to group the data displayed in the widget. For example, choosing "Teams" will show the team-wise data, helping you analyze performance or metrics based on the selected grouping.
                                  </div>
                            </span>
                        </div>
					</div>
<!--					<div v-if="!_.isEmpty(selectedFlowTimeLineGroupBy) && !_.isEmpty(selectedGroupByContentList)" class="rec lblm">-->
<!--					    <div>-->
<!--					        -->
<!--                        </div>-->
<!--                    </div>-->
<!--					<div v-if=" !_.isEmpty(boardListing) && optionTypeTitle === 'Flow Distribution Graph' && chartType === 'column'  && !_.isEmpty(selectedBoard)  && _.isEmpty(collections)" class="rec lblm">-->
<!--						<label>Y-Axis Criteria</label>-->
<!--						<div style="display: inline-block;">-->
<!--							<div v-for="(option, index) in radioOptionsDistributionTime" :key="index" style="display: inline-block;">-->
<!--								<input type="radio" :id="option.value" :value="option.value" v-model="pickedYAxisRadioType" :checked="index === 0" style="display: inline-block; margin-right: 5px;" />-->
<!--								<label :for="option.value" style="display: inline-block; margin-right: 15px;">{{ option.label }}</label>-->
<!--							</div>-->
<!--						</div>-->
<!--					</div>-->
				
					<div class="DFA FL w-full gap-2">
                        <div v-if="( optionTypeTitle === 'Flow Velocity Graph' || optionTypeTitle === 'Flow Load Graph' || optionTypeTitle === 'Flow Distribution Graph' || optionTypeTitle === 'Cumulative Flow Diagram' )" class="rec lblm w-half">					
                            <label>X Axis</label>
                            <div class="DF">
                                <div  id="xAxis" class="selectcont nwsl FL">
                                    <vz-select v-model="selectedXAxis" :options="xAxisList" empty-selection-text="X Axis" label="name" track-by="id" value-type="value" @close=""/>
                                </div>                              
                                <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em>
                                    <div class="hovtooltip xAxis">
                                        Choose the time frame for tracking progress. Options include sprints for viewing sprint-wise progress, days for daily updates and other intervals to see data over specific periods.
                                    </div>
                                </span>
                            </div>
                        </div>
                         <div v-if="(optionTypeTitle === 'Flow Time Graph' || optionTypeTitle === 'Flow Efficiency Graph' )" class="rec lblm w-half">					
                            <label>X Axis</label>
                            <div class="DF">
                                <div id="xAxis" class="selectcont nwsl FL">
                                    <vz-select v-model="selectedXAxis" :options="xAxisListForFlowTime" empty-selection-text="X Axis" label="name" track-by="id" value-type="value" @close=""/>
                                </div>
                                <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em>
                                    <div class="hovtooltip xAxis">
                                        Choose the time frame for tracking progress. Options include sprints for viewing sprint-wise progress, days for daily updates and other intervals to see data over specific periods.
                                    </div>
                                </span>
                            </div>
                        </div>
                        <div v-if=" (optionTypeTitle === 'Lead Time Graph')   || ((optionTypeTitle =='Flow Time Graph' || optionTypeTitle == 'Flow Efficiency Graph' || optionTypeTitle == 'Flow Velocity Graph' ) && selectedXAxis === 'days')||(!_.isEmpty(statusListing.endOfSelectedStatus) && selectedGraph === '3' && !_.isEmpty(statusListing.startOfSelectedStatus)) || ( ((pickedRadioType === 'status' && (!_.isEmpty(this.statusListing.endOfSelectedStatus) && !_.isEmpty(this.statusListing.startOfSelectedStatus))) || (pickedRadioType === 'statusCategory' && (!_.isEmpty(this.statusListing.endOfSelectedStatus) && !_.isEmpty(this.statusListing.startOfSelectedStatus))) || pickedRadioType === 'creationDate') && selectedGraph === '3')" class="rec lblm w-half intrvl">
						    <label>Select Interval</label>
						    <div class="DF">
							    <div id="interval" class="selectcont nwsl FL"><vz-select v-model="selectedInterval" :options="intervalList" empty-selection-text="Select Interval" label="title" track-by="id" value-type="value" /></div>
							    <span class="tooltip ml-10 dropTip nxt">
	                                <em class="infotxt"></em> 
	                                <div class="hovtooltip">
	                                    Select number of days for time interval to view the number of items that completed their journey between the specified From-To statuses within the chosen duration.  For example, selecting an interval of 5 days will display the items that moved from the selected start status to the end status in a 5 days interval.
	                                </div>
	                            </span>
                            </div>
					    </div>
					    <div v-if="(selectedInterval == 'custom' && ( optionTypeTitle === 'Lead Time Graph' || optionTypeTitle === 'Time in Status' )) || (selectedInterval == 'custom' && ( optionTypeTitle =='Flow Time Graph' || optionTypeTitle == 'Flow Efficiency Graph' || optionTypeTitle == 'Flow Velocity Graph' || optionTypeTitle === 'Flow Load Graph' ) ) " class="rec lblm w-half">
                            <label>Enter Interval (Days)</label>
                            <div class="DFA">
	                            <div id="custom-days-interval" class="rc z"><input type="text" v-model="customInterval" class="pi" placeholder="Enter Interval"></div>
                            </div>
                        </div>
					</div>	
			
					<div v-if="selectedFilterType == 'teams' && !_.isEmpty(selectedCondition) && selectedGraph =='2' " class="rec lblm">
							<label>Select Additional Graph GroupBy</label>
							<div class="selectcont nwsl FL"><vz-select v-model="selectedAdditionalFilterCriteria" :options="additionalFilterCriteriaList" empty-selection-text="Select Additional Graph GroupBy" label="name" track-by="id" value-type="object" @close="" /></div>
					</div>
					<div v-if="selectedFilterType == 'teams' && !_.isEmpty(selectedCondition) && !_.isEmpty(selectedAdditionalFilterCriteria) && selectedGraph =='2' " class="rec lblm">
							<label>Select Additional Graph Type</label>
							<div class="selectcont nwsl FL"><vz-select v-model="selectedAdditionalGraphOption" :options="additionalGraphOptionList" empty-selection-text="Select Additional Graph Type" label="name" track-by="id" value-type="object" @close="" /></div>
					</div>					
					<div v-if="!_.isEmpty(selectedCondition) && !_.isEmpty(boardTeamListing)" class="rec lblm">
						<label>Select Program Board Teams</label>
						<div class="selectcont nwsl FL"><vz-select :multiple=true v-model="selectedBoardTeams" :options="boardTeamListing" empty-selection-text="Select Program Board Teams" label="title" track-by="_id" value-type="object" @select=""/></div>
					</div>					
					<div v-if="!_.isEmpty(selectedCondition) && !_.isEmpty(boardSprintListing)" class="rec lblm">
						<label>Select Program Board Sprint</label>
						<div class="selectcont nwsl FL"><vz-select :multiple=true v-model="selectedBoardSprint" :options="boardSprintListing" empty-selection-text="Select Program Board Sprint" label="title" track-by="_id" value-type="object" /></div>
					</div>	
					<div class="DFA FL w-full gap-2">
                        <div v-if=" ( ( optionTypeTitle === 'Flow Load Graph' ||  optionTypeTitle === 'Flow Distribution Graph'  ) && selectedXAxis == 'days' && !_.isEmpty(selectedBoard)) " class="rec lblm a">
                                <label>Event Start Date</label>
                                <div class="rc z"><vuejs-datepicker :format="format" v-model="eventStartDate" placeholder="Start date" class="pi dates hasDatepicker activeText"> </vuejs-datepicker></div>
                        </div>					
                        <div v-if=" ( ( optionTypeTitle === 'Flow Load Graph' ||  optionTypeTitle === 'Flow Distribution Graph'  ) && selectedXAxis == 'days' && !_.isEmpty(selectedBoard))"  class="rec lblm a">
                                <label>Event End Date</label>
                                <div class="rc z"><vuejs-datepicker :format="format" v-model="eventEndDate" placeholder="End date" class="pi dates hasDatepicker activeText"> </vuejs-datepicker></div>
                        </div>
					</div>	
					<div class="FL w-full"  v-if=" optionTypeTitle === 'Cumulative Flow Diagram' && !_.isEmpty(selectedBoard) " >
                       <div class="advanceBg c-point" @click = "toggleAdvanceCriteriaAccordian">
                            <img src="assets/icons/green-arrow.svg" alt="" class="mr-5 accordArrow" :class="{'active' : toggleAdvanceCriteria}"> Advance Criteria
                       </div>
                       <div v-if="toggleAdvanceCriteria" class="pd-10">
                           <div v-if="cfdCriteriaList.length > 1 && boardItemsFilter !== 'unplanned-items' " class="rec lblm">
                                <label>Select Group Criteria</label>
                                <div class="DF">
                                    <div class="selectcont nwsl FL w-half">
                                        <vz-select  :multiple="false" label="title" empty-selection-text="Criteria" class="multi-filter"
                                        track-by="id" value-type="value" :options="cfdCriteriaList"  v-model = "selectedCFDCriteria"
                                         selected-title-class=""
                                        :show-select-all-on-group="false" 
                                        @select = "handleAdvanceSelection"
                                        >	
                                        </vz-select>						
                                    </div>
                                    <span class="tooltip ml-10 dropTip nxt">
                                        <em class="infotxt"></em> 
                                        <div class="hovtooltip selectGroupCri">
                                            Select a criterion to group the data displayed in the widget. For example, choosing "Teams" will show the data team-wise, helping you analyze performance or metrics based on the selected grouping.
                                        </div>
                                    </span>
                                </div>
                           </div>
                           <div v-if="!_.isEmpty(selectedCFDCriteria) && selectedCFDCriteria == 'teams' " class="rec lblm">
                                <label>Select Team</label>
                                <div class="DF">
                                    <div class="selectcont nwsl FL w-half">
                                        <vz-select  :multiple="true" label="title" empty-selection-text="Criteria" class="multi-filter"
                                        track-by="id" value-type="value" :options="criteriaContentList"  v-model = "selectedCriteriaContent"
                                         selected-title-class=""
                                        :show-select-all-on-group="false" 
                                        
                                        >	
                                        </vz-select>						
                                    </div>
                                    <span class="tooltip ml-10 dropTip nxt">
                                        <em class="infotxt"></em> 
                                        <div class="hovtooltip">
                                            Select among the grouped criteria to view filtered data.
                                        </div>
                                    </span>
                                </div>
                           </div>
                           <div v-if=" ( !_.isEmpty(issueTypesList) && optionTypeTitle == 'Cumulative Flow Diagram' && !_.isEmpty(boardListing) && !_.isEmpty(selectedBoard)) " class="rec lblm">
                                <label>Select Issue Type</label>
                                <div class="DF">
                                    <div id="issueType" class="selectcont FL d w-half">
                                        <vz-select 
                                            :multiple="true" 
                                            label="name" 
                                            empty-selection-text="Select Issue Type" 
                                            class="multi-filter"
                                            value-type="value" 
                                            v-model="selectedIssueType" 
                                            :options="issueTypesList"
                                            :groups-enabled=false
                                            :show-select-all-on-group=false
                                            track-by="id"
                                            @select="clearFilterIfEmptyIssueTypes"
                                        />
                                    </div>
                                    <span class="tooltip ml-10 dropTip nxt">
                                        <em class="infotxt"></em> 
                                        <div class="hovtooltip selectIssueType">
                                            Choose one or more issue types from the dropdown menu. The widget will display items with the selected issue types from the chosen Program board.
                                        </div>
                                    </span>	
                               </div> 
                           </div>   
                           <div v-if="!_.isEmpty(selectedIssueType) && optionTypeTitle === 'Cumulative Flow Diagram' " class="prow">
                                <label class="p-rel">Select Items <a v-if="!_.isEmpty(this.filterwithMeta)" href="javascript:void(0);" class="reset und" @click="resetFilter"> Reset</a></label>
                                <div class="DF">
                                    <div id="srch-cont" class="srchout prow">
                                        <div id="searchTerm" class="sin">
                                            <div class="c1">
                                                <input 
                                                    id="input-srch-ext" 
                                                    class="srfld form-control" 
                                                    type="text" 
                                                    placeholder="To search, please type ID or Title..." 
                                                    v-model="searchTerm" 
                                                    @input="handleSearch"
                                                />                                                
                                            </div>
                                            <div id="srch-lst-cont" class="link-over drop_box cssHidea"></div>
                                        </div>
                                    </div>
                                    <span class="tooltip ml-10 dropTip nxt">
		                                <em class="infotxt"></em> 
		                                <div class="hovtooltip">
		                                    Search and select items of the chosen issue type to display their data exclusively on the graph.
		                                </div>
		                            </span>                                    
                                </div>
                            </div>
                            <div v-if="!_.isEmpty(selectedIssueType) && optionTypeTitle === 'Cumulative Flow Diagram'">
                                <span  class="search_tags">
                                    <ul id="search-text_tags">
                                        <li v-for="(title, id) in filterwithMeta" :key="id" class="tooltip">
                                            {{ title.key }} 
                                            <i @click="onRemoveTag(id)" class="ti-close"></i>
                                            <div class="hovtooltip">{{ title.title }} </div>
                                        </li>
                                    </ul>
                                </span>
                            </div>

                       </div> 
					</div>
                    <!-- Added impossible condition 1==2 to hide advance calculation for now as per business -->
					<div class="FL w-full" v-if=" 1 == 2 && optionTypeTitle === 'Cumulative Flow Diagram' && !_.isEmpty(selectedBoard) " >
                       <div class="advanceBg c-point" @click = "toggleAdvanceCalculationAccordian">
                               <img src="assets/icons/green-arrow.svg" alt="" class="mr-5 accordArrow" :class="{'active' : toggleAdvanceCalculation}"> Advance Calculation
                       </div>
                       <div v-if="toggleAdvanceCalculation" class="pd-10">
                            <div v-if=" ( !_.isEmpty(selectedBoard)   ) " class="rec lblm">
                                <label>Active Status Criteria</label>
                                <div class="DF">
                                    <div  class="selectcont FL w-half">
                                        <vz-select 
                                            :multiple="false" 
                                            label="title" 
                                            empty-selection-text="Select Active Status Criteria" 
                                            class="multi-filter"
                                            value-type="value" 
                                            v-model="activeStatuses" 
                                            :options="statusList"
                                            :groups-enabled=true
                                            :show-select-all-on-group=false
                                            track-by="ids"
                                        />
                                </div>	
                                    <span class="tooltip ml-10 dropTip nxt">
                                            <em class="infotxt"></em> 
                                            <div class="hovtooltip">
                                                text test here
                                            </div>
                                    </span>	
                                 </div>
                             </div>		
                            <div v-if=" ( !_.isEmpty(selectedBoard)   ) " class="rec lblm">
                                <label>In Progress Status Criteria</label>
                                <div class="DF">
                                    <div  class="selectcont FL w-half">
                                        <vz-select 
                                            :multiple="true" 
                                            label="title" 
                                            empty-selection-text="Select In Progress Status Criteria" 
                                            class="multi-filter"
                                            value-type="value" 
                                            v-model="inProgressStatuses" 
                                            :options="statusList"
                                            :groups-enabled=true
                                            :show-select-all-on-group=false
                                            track-by="ids"
                                        />
                                    </div>	
                                        <span class="tooltip ml-10 dropTip nxt">
                                                <em class="infotxt"></em> 
                                                <div class="hovtooltip">
                                                    text test here
                                                </div>
                                        </span>	
                                </div>
					        </div>	
                            <div v-if=" ( !_.isEmpty(selectedBoard)   ) " class="rec lblm">
                                <label>Completion Status Criteria</label>
                                <div class="DF">
                                    <div  class="selectcont FL w-half">
                                        <vz-select 
                                            :multiple="true" 
                                            label="title" 
                                            empty-selection-text="Select Completion Status Criteria" 
                                            class="multi-filter"
                                            value-type="value" 
                                            v-model="completedStatuses" 
                                            :options="statusList"
                                            :groups-enabled=true
                                            :show-select-all-on-group=false
                                            track-by="ids"
                                        />
                                    </div>	
                                        <span class="tooltip ml-10 dropTip nxt">
                                                <em class="infotxt"></em> 
                                                <div class="hovtooltip">
                                                    text test here
                                                </div>
                                        </span>	
                                    </div>
					           </div>	
					           <div v-if="  !_.isEmpty(selectedBoard)" class="rec lblm">
                                    <label>Calculate Average Lead Time</label>
                                    <div class="switch-button-class"  >
                                        <input type="checkbox" id="creationCheckbox1" @click="toggleAvgLeadTimeCal()"  :class="[checkExternalValue(toggleAvgLeadTime) ? 'checked' : 'unchecked']">
                                        <span><label for="creationCheckbox1"></label></span>
                                    </div>
                                </div>
                                <div v-if="   !_.isEmpty(selectedBoard)" class="rec lblm">
                                    <label>Calculate Average Cycle Time</label>
                                    <div class="switch-button-class"  >
                                        <input type="checkbox" id="creationCheckbox2" @click="toggleAvgCycleTimeCal()"  :class="[checkExternalValue(toggleAvgCycleTime) ? 'checked' : 'unchecked']">
                                        <span><label for="creationCheckbox2"></label></span>
                                    </div>
                                </div>
                                <div v-if=" !_.isEmpty(selectedBoard)" class="rec lblm">
                                    <label>Calculate Average Work In Progress</label>
                                    <div class="switch-button-class"  >
                                        <input type="checkbox" id="creationCheckbox3" @click="toggleAvgWIPTimeCal()"  :class="[checkExternalValue(toggleAvgWIPTime) ? 'checked' : 'unchecked']">
                                        <span><label for="creationCheckbox3"></label></span>
                                    </div>
                                </div>  
                                <div v-if=" !_.isEmpty(selectedBoard)" class="rec lblm">
                                    <label>Calculate average Arrival Rate</label>
                                    <div class="switch-button-class"  >
                                        <input type="checkbox" id="creationCheckbox4" @click="toggleAvgArrivalTimeCal()"  :class="[checkExternalValue(toggleAvgArrivalTime) ? 'checked' : 'unchecked']">
                                        <span><label for="creationCheckbox4"></label></span>
                                    </div>
                                </div>
                                <div v-if=" !_.isEmpty(selectedBoard)" class="rec lblm">
                                    <label>Calculate Average Throughput</label>
                                    <div class="switch-button-class"  >
                                        <input type="checkbox" id="creationCheckbox5" @click="toggleAvgThroughputTimeCal()"  :class="[checkExternalValue(toggleAvgThroughputTime) ? 'checked' : 'unchecked']">
                                        <span><label for="creationCheckbox5"></label></span>
                                    </div>
                                </div>
					        </div>		
                    </div>
				</div>
				<div class="rec btn">
					 <button  type="button" class="button rds4 FR" @click="getGraphDataOnTheBasiesOfSelection()">Save</button> 
				</div>
			</div>	
		</div>
	`,

    props : {
        graphTypeOptionTitle    : null,
        optionTypeTitle         : null,
        graphTypeTitle          : null,
        dashboardSelected       : null,
        widgetType              : null
    },

    watch : {},

    data() {
        return {
            boardListing: [],
            selectedBoard: {},
            eventStartDate: '',
            eventEndDate: '',
            cfdResponceData: {},
            boardTeamListing: [],
            selectedBoardTeams: {},
            boardSprintListing: [],
            selectedBoardSprint: {},
            statusListing: {
                startOfStatusListing: [],
                startOfSelectedStatus: {},
                endOfStatusListing: [],
                endOfSelectedStatus: {},
            },
            format: 'MMM dd yyyy',
            collections: [],
            selectedCollection: '',
            filterList: [],
            additionalFilterCriteriaList: [{name: "Status Category", id: "statusCategory"}],
            additionalGraphOptionList: [{name: "Column With Breakdown", id: "colBreakDown"}],
            selectedFilter: null,
            selectedAdditionalFilterCriteria: null,
            selectedAdditionalGraphOption: null,
            selectedCondition: [],
            selectedStatusCategory: "0",
            filterSelected: false,
            graphsList: [{name: "Pie Chart", id: "1"}, {name: "Bar Chart", id: "2"}, {name: "Column Chart", id: '3'}],
            graphsListCFD: [{name: "Column Chart", id: '3'}, {
                name: "Basic Area Chart",
                id: '4'
            }, {name: "Stacked Area Chart", id: '5'}],
            graphsListFlowTime: [{name: "Column Chart", id: '3'}],
            filterTypes: [{name: "Status", id: "status"}, {name: "Teams", id: "teams"}],
            filterTypesCFD: [{name: "CFD", id: "cfd"}],
            selectedFilterType: null,
            selectedGraph: '3',
            graphSelected: false,
            popupData: [],
            selectedFilters:[
                {
                    id: "status",
                    title: "Status",
                    values: [],
                    operator: 'IN',
                    disabled: true,
                    remove: true,
                    editable: true
                },
                {id: "teams", title: "Teams", values: [], operator: 'IN', disabled: true, remove: true, editable: true}
            ],
            selectedInterval: '40',
            intervalList: [{id: '5', title: '5'}, {id: '10', title: '10'}, {id: '20', title: '20'}, {
                id: '40',
                title: '40'
            }, {id: '50', title: '50'}, {id: 'custom', title: 'custom'}],

            customInterval: null,
            pagination: {
                avoidPaginatorAtFirstLoad: true,
                pageSize: 50,
                pageIndex: 0,
                pageSizeOptions: [50, 100, 200],
                totalItemSize: 0
            },
            nextPageFirstItem: undefined,
            selectedTileItems: [],
            conditionsList: [],
            filteredData: [],
            graphName: '',
            widgets: [],
            collectionSelected: false,
            filterTypeSelected: false,
            optionsList: [],
            statusList: [],
            selectedStatus: null,
            radioOptions: [
                {label: 'Status', value: 'status'},
                {label: 'Status Category', value: 'statusCategory'},
            ],
            radioOptionsLeadTime: [
                {label: 'Status', value: 'status'},
                {label: 'Status Category', value: 'statusCategory'},
                {label: 'Creation date', value: 'creationDate'},
            ],
            leadTimePickedRadioType:'creationDate',
            radioOptionsDistributionTime: [{label: 'Percentage', value: 'percentage'}, {label: 'Numbers', value: 'numbers'},],
            pickedYAxisRadioType:'numbers',
            pickedRadioType: 'status',
            categoryList:[],
            selectedIssueType:null,
            issueTypesList:[],
            additionalCriteriaForFlowTime : [{name: "Issue Type", id: "issueType"}],
            selectedAdditionalCriteriaForFlowTime:null,
            showloader:false,
            flowTimeLineGroupByList:[
                {name:"Teams",id:"teams"},
                {name:"Assignee",id:"assignee"}
            ],
            selectedFlowTimeLineGroupBy:null,
            xAxisList:[
                {name:"Sprints",id:"sprints"},
                {name:"Weekly",id:"weekly"},
                {name:"Monthly",id:"monthly"},
            ],
            xAxisListForFlowTime:[
                {name:"Sprints",id:"sprints"},
                {name:"Weekly",id:"weekly"},
                {name:"Monthly",id:"monthly"},
            ],

            selectedXAxis:"sprints",
            sessionBoard:[],
            boardType:null,
            tfsProjects:[],
            jiraFieldsMap:{},
            selectedActiveStatus:[],
            toggleCreationDate:false,
            toggleAdvanceCriteria:false,
            toggleAdvanceCalculation:false,
            cfdCriteriaList:[{id:'default',title:'Select'},{id: 'teams', title: 'Teams'}],
            selectedCFDCriteria:null,
            criteriaContentList:[],
            selectedCriteriaContent:null,
            completedStatuses :null,
            activeStatuses:null,
            inProgressStatuses:null,
            toggleAvgLeadTime :false,
            toggleAvgCycleTime:false,
            toggleAvgWIPTime:false,
            toggleAvgArrivalTime:false,
            toggleAvgThroughputTime:false,
            teams:[],
            sprints:[],
            fromStatusList:[],
            toStatusList:[],
            activeStatusList:[],
            inProgressStatusList:[],
            issueType:null,
            meta : {},
            chartType:'Line Graph',
            chartTypeName:'',
            chartTypeList:[{'id':'line',name:'Line Graph'},{'id':'column',name:'Stack Graph'},{'id':'column',name:'Bar Graph'}],
            boardItemsFilterList:[{'id':'all-items',name:'All Items'},{'id':'planned-items',name:'Planned Items'},{'id':'unplanned-items',name:'Unplanned Items'}],
            boardItemsFilter:'planned-items',
            searchTerm:'',
            selectedIssueType: '',  // Selected issue type
            selectedItems: [],      // Stores selected item IDs
            searchResults: [],       // Stores search results from the API
            filter:{},
            filterwithMeta:{},
        }
    },
    watch: {
        pickedRadioType(newValue, oldValue) {
            this.selectedCondition = [];
        },
    },
    created() {
        this.getBoardOrOrgDataOnTheBasiesOfSelection();
        if(this.optionTypeTitle === 'Cumulative Flow Diagram'){
            this.xAxisList.splice(1, 0, { name: "Days", id: "days" });
        }

        if(this.optionTypeTitle === 'Flow Load Graph' || this.optionTypeTitle === 'Flow Distribution Graph'){
            this.xAxisList = [
                {name:"Sprints",id:"sprints"},
            ]
        }
    },

    mounted() {
        if(this.graphTypeOptionTitle === 'Cumulative Flow Diagram' || this.graphTypeOptionTitle === 'Flow Time Metrics'){
            this.selectedFilterType ='cfd';
            this.graphSelected = true;
            this.selectedGraph = '5';
            if(this.optionTypeTitle === 'Lead Time Graph'){
                this.pickedRadioType = 'creationDate';
            }
        }

    },

    computed: {

        checkExternalValue() {
            return function (value) {
                return value === true;
            };
        },
    },

    components: {
        vuejsDatepicker,
        VueAdsPagination : window["vue-ads-pagination"].default,
        VueAdsPageButton : window["vue-ads-pagination"].VueAdsPageButton,
    },

    methods: {
        getChartIdByName(name) {
            const chart = this.chartTypeList.find(item => item.name === name);
            return chart ? chart.id : null;
        },
        clearFilterIfEmptyIssueTypes(){
            if(_.isEmpty(this.selectedIssueType)){
                this.resetFilter();
            }
        },

        resetFilter() {
            this.filter = {};
            this.filterwithMeta={};
            this.selectedItems = [];
        },

        handleSearch() {
            this.validateItemSearchCriteria();
        },
        validateItemSearchCriteria() {
            let error = false;

            if (_.isEmpty(this.selectedBoard)) {
                $("#piBoard").addClass("red");
                error = true;
            } else {
                $("#piBoard").removeClass("red");
            }

            if (_.isEmpty(this.selectedIssueType)) {
                $("#issueType").addClass("red");
                error = true;
            } else {
                $("#issueType").removeClass("red");
            }

            if (_.isEmpty(this.searchTerm.trim())) {
                $("#srch-lst-cont").css("display", "none");
                error = true;
            }
            else {
                $("#srch-lst-cont").css("display", "block");
            }

            if (error) {
                // showTopMessage("Please enter something to search","warning", 2000);
            } else {
                let data = {
                    sessionBoardId: this.selectedBoard.activeSessionBoard,
                    issueTypes: this.selectedIssueType,
                    searchText: this.searchTerm
                };

                axios.post('/dashboard/searchItems/', data).then(response => {
                    let itemsList = response.data.itemsList;
                    this.searchResults = itemsList;
                    let $container = $("#srch-lst-cont");
                    $container.empty();
                    let htmlArray = [];

                    itemsList.forEach(itm => {
                        let key = itm.jiraKey ? itm.jiraKey : itm.tfsId;
                        let ui = '<span class="item-title"><a target="_blank">' + key + '</a> ' + itm.title + '</span>';
                        let selectedClass = !_.isEmpty(this.selectedItems) ? (this.selectedItems?.indexOf(itm.id) > -1 ? 'SELECTED-ITEM' : ''): '';

                        let backgroundColorStyle = !_.isEmpty(this.selectedItems) ? (this.selectedItems?.indexOf(itm.id) > -1 ?
                            ' style="background-color: rgba(0, 0, 0, 0.05); color: #fff;"' : ''):'';

                        let tickIcon = !_.isEmpty(this.selectedItems) ? (this.selectedItems?.indexOf(itm.id) > -1 ?
                            '<span class="tick-icon">&#10003;</span>' : ''):''; // Checkmark

                        htmlArray.push('<li class="ITM ' + selectedClass + '"' + backgroundColorStyle +
                            ' data-id="' + itm.id + '" data-title="' + itm.title  + '" data-key="' + key + '" >' + ui + tickIcon + '</li>');
                    });


                    if (htmlArray.length === 0) {
                        htmlArray.push('<span class="NO-RESULT nofound DB mt-10">No search results</span>');
                    }

                    $container.html('<ul id="rslt">' + htmlArray.join('') + '</ul>');

                    this.$nextTick(() => {
                        document.querySelectorAll('#rslt li').forEach(item => {
                            item.addEventListener('click', (event) => {
                                this.toggleItemSelection(event.currentTarget.getAttribute('data-id'),event.currentTarget.getAttribute('data-title'),event.currentTarget.getAttribute('data-key'));
                            });
                        });

                        document.querySelectorAll('#rslt li .clickable-link').forEach(link => {
                            link.addEventListener('click', (event) => {
                                event.preventDefault();
                                event.stopPropagation();
                                let li = event.target.closest('li');
                                this.toggleItemSelection(li.getAttribute('data-id'),li.getAttribute('data-title'), li.getAttribute('data-key'));
                            });
                        });
                    });

                    console.log("Selected Items",this.selectedItems);
                    $container.show();
                }).catch(error => {
                    console.log("Error occurred", error);
                });
            }
        },
        toggleItemSelection(id, title, key) {
            let index = !_.isEmpty(this.selectedItems) ? this.selectedItems.indexOf(id) : -1;
            if (index === -1) {
                if (id !== null && id !== undefined) {
                    if (_.isEmpty(this.filter)) {
                        this.filter = {};
                        this.filterwithMeta={};
                    }
                    Vue.set(this.filter, id, title);
                    Vue.set(this.filterwithMeta, id, { title: title, key: key });
                } else {
                    console.log("Invalid id, item not inserted:", id);
                }
                this.selectedItems.push(id);
            } else {
                this.selectedItems.splice(index, 1);
                if (id in this.filter) {
                    Vue.delete(this.filter, id);
                    Vue.delete(this.filterwithMeta, id);
                }
            }
            this.updateSelectedStyles(id);
        },
        onRemoveTag: function(id) {
            let index = this.selectedItems?.findIndex(itemIds => itemIds === id);

            if (index !== -1) {
                this.selectedItems.splice(index, 1);
                if (id in this.filter) {
                    Vue.delete(this.filter, id);
                    Vue.delete(this.filterwithMeta, id);
                }
            }
        },
        updateSelectedStyles(jiraId) {
            const elements = document.querySelectorAll(`[data-id="${jiraId}"]`);
            elements.forEach(el => {
                if (this.selectedItems.indexOf(jiraId) > -1) {
                    el.style.backgroundColor = 'rgba(0, 0, 0, 0.05)';
                    el.style.color = '#fff';

                    if (!el.querySelector('.tick-icon')) {
                        const tickIcon = document.createElement('span');
                        tickIcon.className = 'tick-icon';
                        tickIcon.innerHTML = '&#10003;';
                        //tickIcon.style.marginLeft = '8px';
                        el.appendChild(tickIcon);
                    }
                } else {
                    el.style.backgroundColor = '';
                    el.style.color = '';

                    const tickIcon = el.querySelector('.tick-icon');
                    if (tickIcon) {
                        el.removeChild(tickIcon);
                    }
                }
            });
        },

        isNumber:function(value) {
            return /^-?\d+$/.test(value);
        },
        checkAllThingsAreSelectedToEnableSaveButton : function(){
            if(_.isEmpty(this.selectedIssueType)){
                this.filter = {};
                this.filterwithMeta = {};
                this.selectedItems = {};
            }
            if(this.optionTypeTitle == 'Time in Status'){
                let error = false;
                if(!_.isEmpty(this.statusListing.startOfSelectedStatus) &&!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedGraph)  && !_.isEmpty(this.graphName) && !_.isEmpty(this.statusListing.endOfSelectedStatus) && !_.isEmpty(this.selectedInterval)){
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                        error = true;
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                            error = true;
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }
                    if(!_.isEmpty(this.selectedInterval)){
                        if(this.selectedInterval == 'custom'){
                            if(_.isEmpty(this.customInterval) || !this.isNumber(this.customInterval)){
                                $("#custom-days-interval").addClass("red");
                                error = true;
                            }
                            else if(!_.isEmpty(this.customInterval) && this.isNumber(this.customInterval)){
                                if (parseInt(this.customInterval) <= 0) {
                                    $("#custom-days-interval").addClass("red");
                                    error = true;
                                } else {
                                    $("#custom-days-interval").removeClass("red");
                                }
                            }
                        }
                        $("#interval").removeClass("red");
                    }
                    if (error){
                        return false;
                    }
                    return true;
                } else {
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }
                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }
                    if(this.pickedRadioType === 'status' || this.pickedRadioType === 'statusCategory'){
                        if(_.isEmpty(this.statusListing.startOfSelectedStatus)){
                            $("#fromStatus").addClass("red");
                        }
                        if(!_.isEmpty(this.statusListing.startOfSelectedStatus)){
                            $("#fromStatus").removeClass("red");
                        }
                        if(_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").addClass("red");
                        }
                        if(!_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").removeClass("red");
                        }
                    }
                    if(_.isEmpty(this.selectedInterval)){
                        $("#interval").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedInterval)){
                        if(this.selectedInterval == 'custom'){
                            if(_.isEmpty(this.customInterval) || !this.isNumber(this.customInterval)){
                                $("#custom-days-interval").addClass("red");
                            }
                            else if(!_.isEmpty(this.customInterval) && this.isNumber(this.customInterval)){
                                if (parseInt(this.customInterval) <= 0) {
                                    $("#custom-days-interval").addClass("red");
                                } else {
                                    $("#custom-days-interval").removeClass("red");
                                }
                            }
                        }
                        $("#interval").removeClass("red");
                    }
                    return false;
                }
            }
            else if(this.optionTypeTitle == 'Lead Time Graph'){
                if(!_.isEmpty(this.selectedBoard)  && !_.isEmpty(this.graphName)  && !_.isEmpty(this.pickedRadioType) && !_.isEmpty(this.boardItemsFilter) && !_.isEmpty(this.selectedInterval)){
                    let error = false;
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                        error = true;
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                            error = true;
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }
                    if(this.pickedRadioType === 'status' || this.pickedRadioType === 'statusCategory'){
                        if(_.isEmpty(this.statusListing.startOfSelectedStatus)){
                            $("#fromStatus").addClass("red");
                            error = true;
                        }
                        if(!_.isEmpty(this.statusListing.startOfSelectedStatus)){
                            $("#fromStatus").removeClass("red");
                        }
                        if(_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").addClass("red");
                            error = true;
                        }
                        if(!_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").removeClass("red");
                        }
                    }
                    if(this.pickedRadioType === 'creationDate'){
                        if(_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").addClass("red");
                            error = true;
                        }
                        if(!_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").removeClass("red");
                        }
                    }
                    if(!_.isEmpty(this.selectedInterval)){
                        if(this.selectedInterval == 'custom'){
                            if(_.isEmpty(this.customInterval) || !this.isNumber(this.customInterval)){
                                $("#custom-days-interval").addClass("red");
                                error = true;
                            }
                            else if(!_.isEmpty(this.customInterval) && this.isNumber(this.customInterval)){
                                if (parseInt(this.customInterval) <= 0) {
                                    $("#custom-days-interval").addClass("red");
                                    error = true;
                                } else {
                                    $("#custom-days-interval").removeClass("red");
                                }
                            }
                        }
                        $("#interval").removeClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }

                    if(error){
                        return false;
                    }
                    return true;
                }
                else{
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }
                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }
                    if(this.pickedRadioType === 'status' || this.pickedRadioType === 'statusCategory'){
                        if(_.isEmpty(this.statusListing.startOfSelectedStatus)){
                            $("#fromStatus").addClass("red");
                        }
                        if(!_.isEmpty(this.statusListing.startOfSelectedStatus)){
                            $("#fromStatus").removeClass("red");
                        }
                        if(_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").addClass("red");
                        }
                        if(!_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").removeClass("red");
                        }
                    }
                    if(this.pickedRadioType === 'creationDate'){
                        if(_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").addClass("red");
                        }
                        if(!_.isEmpty(this.statusListing.endOfSelectedStatus)){
                            $("#toStatus").removeClass("red");
                        }
                    }
                    if(_.isEmpty(this.selectedInterval)){
                        $("#interval").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedInterval)){
                        if(this.selectedInterval == 'custom'){
                            if(_.isEmpty(this.customInterval) || !this.isNumber(this.customInterval)){
                                $("#custom-days-interval").addClass("red");
                            }
                            else if(!_.isEmpty(this.customInterval) && this.isNumber(this.customInterval)){
                                if (parseInt(this.customInterval) <= 0) {
                                    $("#custom-days-interval").addClass("red");
                                } else {
                                    $("#custom-days-interval").removeClass("red");
                                }
                            }
                        }
                        $("#interval").removeClass("red");
                    }
                    return false;
                }
            }
            else if(this.optionTypeTitle === 'Flow Time Graph'){
                if( !_.isEmpty(this.graphName) && !_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedFlowTimeLineGroupBy) && !_.isEmpty(this.selectedXAxis) && !_.isEmpty(this.selectedFlowTimeLineGroupBy)  && !_.isEmpty(this.pickedRadioType) && !_.isEmpty(this.statusListing.startOfSelectedStatus) && !_.isEmpty(this.statusListing.endOfSelectedStatus) && !_.isEmpty(this.boardItemsFilter) ){
                    if(this.boardItemsFilter =='unplanned-items'){
                        if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                        else if(this.selectedFlowTimeLineGroupBy === 'teams'){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                    }
                    return true;
                } else{
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }
                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }
                    if(_.isEmpty(this.statusListing.startOfSelectedStatus)){
                        $("#fromStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.statusListing.startOfSelectedStatus)){
                        $("#fromStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").removeClass("red");
                    }
                    if(_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").addClass("red");
                    }
                    if(!_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").removeClass("red");
                    }
                    return false;
                }
            }
            else if(this.optionTypeTitle === 'Flow Efficiency Graph'){
                if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedXAxis) &&  !_.isEmpty(this.selectedActiveStatus)   && !_.isEmpty(this.selectedFlowTimeLineGroupBy)  && !_.isEmpty(this.graphName)  && (( this.toggleCreationDate == false && !_.isEmpty(this.statusListing.startOfSelectedStatus) && !_.isEmpty(this.statusListing.endOfSelectedStatus)) || ( this.toggleCreationDate == true && _.isEmpty(this.statusListing.startOfSelectedStatus) && !_.isEmpty(this.statusListing.endOfSelectedStatus)) ) ){
                    if(this.boardItemsFilter =='unplanned-items'){
                        if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                        else if(this.selectedFlowTimeLineGroupBy === 'teams'){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                    }
                    return true;
                }else{
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }
                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }
                    if(_.isEmpty(this.statusListing.startOfSelectedStatus)){
                        $("#fromStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.statusListing.startOfSelectedStatus)){
                        $("#fromStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedActiveStatus)){
                        $("#activeStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedActiveStatus)){
                        $("#activeStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").removeClass("red");
                    }
                    if(_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").addClass("red");
                    }
                    if(!_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").removeClass("red");
                    }
                    return false;
                }
            }
            else if(this.optionTypeTitle === 'Flow Velocity Graph'){
                if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedXAxis)  && !_.isEmpty(this.selectedFlowTimeLineGroupBy)  && !_.isEmpty(this.graphName) && !_.isEmpty(this.pickedRadioType) &&  !_.isEmpty(this.selectedActiveStatus) ){
                    if(this.boardItemsFilter =='unplanned-items'){
                        if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                        else if(this.selectedFlowTimeLineGroupBy === 'teams'){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                    }
                    return true;
                }else{
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }
                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }
                    if(_.isEmpty(this.statusListing.startOfSelectedStatus)){
                        $("#fromStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.statusListing.startOfSelectedStatus)){
                        $("#fromStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedActiveStatus)){
                        $("#activeStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedActiveStatus)){
                        $("#activeStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").removeClass("red");
                    }
                    if(_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").addClass("red");
                    }
                    if(!_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").removeClass("red");
                    }
                    return false;
                }
            }
            else if(this.optionTypeTitle === 'Flow Load Graph'){
                if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedXAxis) && !_.isEmpty(this.selectedFlowTimeLineGroupBy)  && !_.isEmpty(this.graphName)   && !_.isEmpty(this.activeStatusList) && !_.isEmpty(this.inProgressStatusList)) {
                    if(this.boardItemsFilter =='unplanned-items'){
                        if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                        else if(this.selectedFlowTimeLineGroupBy === 'teams'){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                    }
                    return true;
                } else{
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }
                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }
                    if(_.isEmpty(this.activeStatusList)){
                        $("#activeCriteria").addClass("red");
                    }
                    if(!_.isEmpty(this.activeStatusList)){
                        $("#activeCriteria").removeClass("red");
                    }
                    if(_.isEmpty(this.inProgressStatusList)){
                        $("#waitingCriteria").addClass("red");
                    }
                    if(!_.isEmpty(this.inProgressStatusList)){
                        $("#waitingCriteria").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").removeClass("red");
                    }
                    if(_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").addClass("red");
                    }
                    if(!_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").removeClass("red");
                    }
                    return false;
                }
            }
            else if(this.optionTypeTitle === 'Flow Distribution Graph'){
                if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedXAxis) && !_.isEmpty(this.pickedYAxisRadioType) && !_.isEmpty(this.selectedFlowTimeLineGroupBy)  && !_.isEmpty(this.graphName) && !_.isEmpty(this.pickedRadioType) &&  !_.isEmpty(this.selectedActiveStatus) ){
                    if(this.boardItemsFilter =='unplanned-items'){
                        if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                        else if(this.selectedFlowTimeLineGroupBy === 'teams'){
                            $("#groupBy").addClass("red");
                            return false;
                        }
                    }
                    return true;
                }else{
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }
                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }
                    if(_.isEmpty(this.statusListing.startOfSelectedStatus)){
                        $("#fromStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.statusListing.startOfSelectedStatus)){
                        $("#fromStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedActiveStatus)){
                        $("#activeStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedActiveStatus)){
                        $("#activeStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").removeClass("red");
                    }
                    if(_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").addClass("red");
                    }
                    if(!_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").removeClass("red");
                    }
                    return false;
                }
            }
            else if(this.optionTypeTitle === 'Cumulative Flow Diagram'){
                if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.boardItemsFilter)  && !_.isEmpty(this.selectedCondition) && !_.isEmpty(this.selectedXAxis) && !_.isEmpty(this.graphName) && !_.isEmpty(this.pickedRadioType)){
                    if(!_.isEmpty(this.selectedCFDCriteria)  ){
                        if(this.selectedCFDCriteria === 'teams' && _.isEmpty(this.selectedCriteriaContent))
                        {
                            $("#criteria-content").addClass("red");
                            $("#graphTitle").removeClass("red");
                            $("#piBoard").removeClass("red");
                            $("#selected-condition").removeClass("red");
                            $("#xAxis").removeClass("red");
                            $("#boardItemsFilter").removeClass("red");

                            return false;
                        }
                    }
                    return true;
                }
                else{
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }

                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }
                    if( _.isEmpty(this.selectedCondition)){
                        $("#selected-condition").addClass("red");
                    }
                    if( !_.isEmpty(this.selectedCondition)){
                        $("#selected-condition").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").removeClass("red");
                    }
                    if(_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").addClass("red");
                    }
                    if(!_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").removeClass("red");
                    }
                    return false;
                }
            }
            else if(this.optionTypeTitle =='Item Completion by Teams'){

                if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedBoardSprint) && !_.isEmpty(this.selectedIssueType)  && !_.isEmpty(this.graphName) && !_.isEmpty(this.pickedRadioType) &&  !_.isEmpty(this.selectedActiveStatus) ){
                    return true;
                }else{
                    return false;
                }
            }
            else if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedCondition) && this.eventStartDate != ''  && this.eventEndDate != ''){
                /*if(!_.isEmpty(requestBody) && ( (requestBody["teams"] && !_.isEmpty(selectedBoardTeams)) || (requestBody["sprints"] && !_.isEmpty(selectedBoardSprint)) )){
                    return true;

                }else if(_.isEmpty(requestBody)){

                    return true;
                }*/
                return true;
            }else
            if(!_.isEmpty(this.selectedCollection)&& !_.isEmpty(this.selectedFilter) && !_.isEmpty(this.selectedCondition)&& !_.isEmpty(this.graphName)){
                return true;
            }
            else{
                return false;
            }
        },

        getEmptyMeta : function(){
            return {
                _teamsMap 			: _.keyBy(this.sessionBoard.teams,'id'),
                _sprintsMap 		: _.keyBy(this.sessionBoard.containers,'id'),
                linkTypes			: [],
                _parentStatuses		: [],
                _childStatuses 		: [],
                _allIssueTypes		: [],
                _jiraProjectIssueTypes : []
            };
        },
        handleGroupBySelection:function(){
            let requestBody = {};
            requestBody.groupBy = this.selectedFlowTimeLineGroupBy;
            requestBody.boardId = this.selectedBoard.activeSessionBoard;
            if(this.selectedFlowTimeLineGroupBy === 'jiraProject'){
                requestBody.boardId = this.selectedBoard._id;
            }
            axios.post('/dashboard/fetchGroupByOptions/' , requestBody).then(response => {
                console.log("response: ", response);
            })
        },

        handleAdvanceSelection:function(){
            if(this.selectedCFDCriteria == 'teams')
            { this.criteriaContentList =  this.teams; }
            else if(this.selectedCFDCriteria == 'sprints'){
                this.criteriaContentList =  this.sprints;
            }else{
                this.selectedCriteriaContent = [];
            }
        },

        toggleAvgLeadTimeCal() {
            this.toggleAvgLeadTime = !this.toggleAvgLeadTime;
        },

        toggleAvgCycleTimeCal(){
            this.toggleAvgCycleTime = !this.toggleAvgCycleTime;
        },

        toggleAvgWIPTimeCal(){
            this.toggleAvgWIPTime = !this.toggleAvgWIPTime;
        },

        toggleAvgArrivalTimeCal(){
            this.toggleAvgArrivalTime = !this.toggleAvgArrivalTime;
        },

        toggleAvgThroughputTimeCal(){
            this.toggleAvgThroughputTime = !this.toggleAvgThroughputTime;
        },

        toggleAdvanceCriteriaAccordian(){
            this.toggleAdvanceCriteria = !this.toggleAdvanceCriteria;
        },

        toggleAdvanceCalculationAccordian(){
            this.toggleAdvanceCalculation = !this.toggleAdvanceCalculation;
        },

        toggleCreationDateButton(){
            this.toggleCreationDate = !this.toggleCreationDate;
            this.statusListing.endOfSelectedStatus = {};
            this.statusListing.startOfSelectedStatus = {};
        },

        onClickAddWidget : function(){
            this.openDashboardWidgetsOptions = true;
        },

        onSelectingStatusFilterDataForEndStatus : function(){
            this.statusListing.endOfSelectedStatus = {};
            let indexOfSelectedItem = _.findIndex(this.statusListing.startOfStatusListing, this.statusListing.startOfSelectedStatus);

            if(indexOfSelectedItem > -1){

                let newArray = _.cloneDeep(this.statusListing.startOfStatusListing);
                newArray.splice(0,indexOfSelectedItem);
                this.statusListing.endOfStatusListing = newArray;
            }
        },

        getBoardOrOrgDataOnTheBasiesOfSelection : function(){
            if(this.graphTypeTitle == "For items in PI" || this.graphTypeTitle == "For items in a Team in PI" || this.graphTypeTitle == "For items in a Sprint in PI" ){
                this.getAllAccessableBoardsListing();
            }
            else if(this.graphTypeTitle === "For Backlog Items (Org)"){
                this.fetchAllCollections();
            }
        },

        getStatusOrIssueTypeDataOnTheBasiesOfSelection : function(){
            this.selectedItems = [];
            this.filter = {};
            if(this.optionTypeTitle == "Cumulative Flow Diagram"){
                this.getAllAccessableBoardStartEndStatusListing(this.selectedBoard._id);
                this.getPIStartEndDates(this.selectedBoard.activeSessionBoard);
                if(this.graphTypeTitle == "For items in a Team in PI"){
                    this.getSelectedBoardTeamAndSprintList(true);

                }else if(this.graphTypeTitle == "For items in a Sprint in PI"){
                    this.getSelectedBoardTeamAndSprintList(null,true);
                }
                this.getCFDAdvanceCriteria(this.selectedBoard._id);
                this.getIssueTypes(this.selectedBoard.activeSessionBoard);
            }
            else if(this.optionTypeTitle === 'Time in Status' || this.optionTypeTitle === 'Lead Time Graph' || this.optionTypeTitle === 'Flow Time Graph' || this.optionTypeTitle === 'Flow Efficiency Graph' || this.optionTypeTitle === 'Flow Velocity Graph' || this.optionTypeTitle === 'Flow Load Graph' || this.optionTypeTitle === 'Flow Distribution Graph' ){
                if(this.optionTypeTitle === 'Time in Status'){
                    this.selectedGraph = '3';
                }
                this.getAllAccessableBoardStartEndStatusListing(this.selectedBoard._id);
                this.getPIStartEndDates(this.selectedBoard.activeSessionBoard);
                if(this.optionTypeTitle === 'Lead Time Graph' || this.optionTypeTitle === 'Time in Status' || this.optionTypeTitle === 'Flow Time Graph' || this.optionTypeTitle === 'Flow Efficiency Graph' || this.optionTypeTitle === 'Flow Velocity Graph' || this.optionTypeTitle === 'Flow Load Graph' || this.optionTypeTitle === 'Flow Distribution Graph'){
                    {
                        if (this.selectedBoard.activeSessionBoard) {
                            this.getIssueTypes(this.selectedBoard.activeSessionBoard);
                        }
                    }
                }
            }else if(this.optionTypeTitle == "Item Completion by Teams"){
                this.getSelectedBoardTeamAndSprintList(null,true);
                this.handleAdditionalCriteriaForFlowTime();
                this.getAllAccessableBoardStatusListing(this.selectedBoard._id);

            }
        },

        handleAdditionalCriteriaForFlowTime:function(){
            if(this.selectedBoard.activeSessionBoard){
                this.getIssueTypes(this.selectedBoard.activeSessionBoard);
            }
        },
        getIssueTypes: function(boardId) {
            let param = { alm: true };
            this.showloader = true;

            axios.get('/dashboard/fetchALMTFSMeta/' + boardId)
                .then(response => {
                    this.showloader = false;

                    if (_.isEmpty(response.data)) {
                        return;
                    }

                    if (response.data.jiraFields) {
                        this.processJiraFields(response.data);
                    } else if (response.data.tfsProject) {
                        this.processTfsProjects(response.data);
                    }

                    this.createBacklogGroups();
                })
                .catch(error => {
                    this.showloader = false;
                    console.error(error);
                });
        },

        processJiraFields: function(data) {
            this.boardType = 'jiraBoard';
            let allIssueTypes = [];

            if (!_.isEmpty(data.jiraProjectIssueTypes)) {
                data.jiraProjectIssueTypes?.forEach(issueTypeGroup => {
                    if(!_.isEmpty(issueTypeGroup.issueTypes)){
                        let issueTypes = JSON.parse(issueTypeGroup.issueTypes);
                        allIssueTypes = allIssueTypes.concat(issueTypes);
                    }
                });

                let uniqueIssueTypes = new Set();
                let filteredIssueTypes = [];

                allIssueTypes.forEach(item => {
                    if (!uniqueIssueTypes.has(item.id)) {
                        uniqueIssueTypes.add(item.id);
                        filteredIssueTypes.push({ id: item.id, name: item.name, iconUrl: item.iconUrl });
                    }
                });

                this.issueTypesList = filteredIssueTypes;

            } else {
                this.issueTypesList = [];
            }
            this.sessionBoard = data.sessionBoard;
            this.jiraFieldsMap = JSON.parse(data.jiraFields);
        },

        processTfsProjects: function(data) {
            this.boardType = 'tfsBoard';
            let filteredIssueTypes = [];
            let seenIssueTypes = new Set();

            if (!_.isEmpty(data.tfsProject)) {
                data.tfsProject.forEach(project => {
                    if(!_.isEmpty(project.itemTypesStr)){
                        let obj = JSON.parse(project.itemTypesStr).value;

                        obj.forEach(item => {
                            if (!seenIssueTypes.has(item.name)) {
                                seenIssueTypes.add(item.name);
                                filteredIssueTypes.push({ id: item.name, name: item.name, iconUrl: item.url });
                            }
                        });
                    }
                });

                this.issueTypesList = filteredIssueTypes;
                this.tfsProjects = data.tfsProject;
            } else {
                this.issueTypesList = [];
                // Optionally show an alert here
            }
        }
        ,

        getGraphDataOnTheBasiesOfSelection : function(){
            if(_.isEmpty(this.boardListing)){
                showTopMessage('You need to create a new board to get started','warning',2000);
            }
            else if(!this.checkAllThingsAreSelectedToEnableSaveButton()){
                showTopMessage("Please provide all the information","warning", 2000);
            }
            else {
                if (this.graphTypeOptionTitle == "Cumulative Flow Diagram") {
                    if (this.optionTypeTitle == 'Cumulative Flow Diagram') {
                        let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                        let selectedCriteriaStatuses = "";
                        if (this.toggleCreationDate === false) {
                            if (this.pickedRadioType == 'statusCategory') {
                                let startIds = this.selectedCondition.join(',').split(',');
                                let uniqueTitles = new Set();

                                for (const status of this.categoryList) {
                                    if (startIds.some(id => status.ids.includes(id))) {
                                        if (!uniqueTitles.has(status.title)) {
                                            uniqueTitles.add(status.title);
                                            selectedCriteriaStatuses += (selectedCriteriaStatuses ? ',' : '') + status.title;
                                        }
                                    }
                                }
                            }
                            else if (this.pickedRadioType == 'status') {
                                let startIds = this.selectedCondition.join(',').split(',');
                                let uniqueTitles = new Set();

                                for (const status of this.statusList) {
                                    for (const item of status.items) {
                                        if (startIds.some(id => item.ids.includes(id))) {
                                            if (!uniqueTitles.has(item.title)) {
                                                uniqueTitles.add(item.title);
                                                selectedCriteriaStatuses += (selectedCriteriaStatuses ? ',' : '') + item.title;
                                            }
                                        }
                                    }
                                }
                            }

                        }
                        let requestBody = {
                            sessionBoardId: this.selectedBoard.activeSessionBoard,
                            selectedStatusIds: this.selectedCondition,
                            tenant: this.selectedBoard.tenant,
                            selectedGraph: this.selectedGraph,
                            graphName: this.graphName,
                            selectedFilterType: this.selectedFilterType,
                            selectedBoard: this.selectedBoard,
                            orignalStartDate: this.eventStartDate,
                            orignalEndDate: this.eventEndDate,
                            startDate: isValidDate(this.eventStartDate) ? this.eventStartDate.format("d mmm yyyy") : '',
                            endDate: isValidDate(this.eventEndDate) ? this.eventEndDate.format("d mmm yyyy") : '',
                            optionTypeTitle: this.optionTypeTitle,
                            graphTypeTitle: this.graphTypeTitle,
                            selectedStatusTitle: selectedCriteriaStatuses,
                            xAxis: this.selectedXAxis,
                            advanceCriteria: this.selectedCFDCriteria,
                            selectedAdvanceCriteria: this.selectedCriteriaContent,
                            selectedActiveStatus: _.isEmpty(this.activeStatuses) ? '' : this.activeStatuses,
                            selectedWaitingStatus: _.isEmpty(this.inProgressStatuses) ? [] : this.inProgressStatuses,
                            selectedCompletedStatus: _.isEmpty(this.completedStatuses) ? [] : this.completedStatuses,
                            toggleAvgLeadTime: this.toggleAvgLeadTime,
                            toggleAvgCycleTime: this.toggleAvgCycleTime,
                            toggleAvgWIPTime: this.toggleAvgWIPTime,
                            toggleAvgArrivalTime: this.toggleAvgArrivalTime,
                            toggleAvgThroughputTime: this.toggleAvgThroughputTime,
                            toggleAdvanceCriteria: this.toggleAdvanceCriteria,
                            toggleAdvanceCalculation: this.toggleAdvanceCalculation,
                            selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                            selectedIssueTypeTitleMap: this.issueTypesList
                                ?.filter(item => this.selectedIssueType?.includes(item.id))
                                .reduce((acc, item) => {
                                    acc[item.id] = item.name;
                                    return acc;
                                }, {}),
                            // selectedIssueTypeTitleList: this.issueTypesList.filter(item => this.selectedIssueType.includes(item.id)).map(item => item.name),
                            selectedBoardTitle: selectedBoardTitle,
                            radioButtonSelection: this.pickedRadioType,
                            boardItemsFilter : this.boardItemsFilter,
                            itemtags : this.filter,
                            itemTagsMeta: this.filterwithMeta,
                        }
                        this.$emit('populate-graph', requestBody);
                    }
                }
                else if (this.graphTypeOptionTitle == "Flow Time Metrics") {
                    if (this.optionTypeTitle == 'Time in Status' || this.optionTypeTitle == 'Lead Time Graph') {
                        let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                        let selectedToStatus = null;
                        let selectedFromStatus = null;
                        if (this.pickedRadioType == 'statusCategory') {
                            selectedToStatus = this.categoryList.find(item => item.ids == this.statusListing.startOfSelectedStatus).title;
                            selectedFromStatus = this.categoryList.find(item => item.ids == this.statusListing.endOfSelectedStatus).title;
                        } else if (this.pickedRadioType == 'status') {
                            const startIds = this.statusListing.startOfSelectedStatus.split(',');
                            const endIds = this.statusListing.endOfSelectedStatus.split(',');
                            for (const status of this.statusList) {
                                for (const item of status.items) {
                                    if (startIds.some(id => item.ids.includes(id))) {
                                        selectedToStatus = item.title;
                                    }
                                    if (endIds.some(id => item.ids.includes(id))) {
                                        selectedFromStatus = item.title;
                                    }
                                }
                            }
                        }
                        else if(this.pickedRadioType == 'creationDate'){
                            const endIds = this.statusListing.endOfSelectedStatus.split(',');
                            for (const status of this.statusList) {
                                for (const item of status.items) {
                                    if (endIds.some(id => item.ids.includes(id))) {
                                        selectedFromStatus = item.title;
                                    }
                                }
                            }
                        }
                        let requestBody = {
                            selectedBoard: this.selectedBoard,
                            sessionBoardId: this.selectedBoard.activeSessionBoard,
                            tenant: this.selectedBoard.tenant,
                            selectedGraph: '3',
                            graphName: this.graphName,
                            selectedFilterType: 'cfd',
                            statusListing: this.statusListing,
                            selectedInterval: this.selectedInterval == 'custom' ? this.customInterval : this.selectedInterval,
                            optionTypeTitle: this.optionTypeTitle,
                            graphTypeTitle: this.graphTypeTitle,
                            radioButtonSelection: this.pickedRadioType,
                            selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                            selectedIssueTypeTitleList: this?.issueTypesList?.filter(item => this.selectedIssueType?.includes(item.id)).map(item => item.name),
                            boardItemsFilter : this.boardItemsFilter,
                            selectedToStatus: selectedToStatus,
                            selectedFromStatus: selectedFromStatus,
                            selectedBoardTitle: selectedBoardTitle,
                            itemtags : this.filter,
                            itemTagsMeta: this.filterwithMeta,
                        }
                        if (!_.isEmpty(this.selectedBoardTeams)) {
                            let idsArray = this.selectedBoardTeams.map(item => item._id);
                            requestBody["teams"] = idsArray;
                        }

                        if (!_.isEmpty(this.selectedBoardSprint)) {
                            let idsArray = this.selectedBoardSprint.map(item => item._id);
                            requestBody["sprints"] = idsArray;
                        }

                        this.$emit('populate-graph', requestBody);
                    }
                    else if (this.optionTypeTitle == 'Flow Time Graph') {
                        let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                        let selectedToStatus = null;
                        let selectedFromStatus = null;
                        if (this.pickedRadioType == 'statusCategory') {
                            selectedToStatus = this.categoryList.find(item => item.ids == this.statusListing.startOfSelectedStatus).title;
                            selectedFromStatus = this.categoryList.find(item => item.ids == this.statusListing.endOfSelectedStatus).title;
                        }
                        else if (this.pickedRadioType == 'status') {
                            const startIds = this.statusListing.startOfSelectedStatus.split(',');
                            const endIds = this.statusListing.endOfSelectedStatus.split(',');
                            for (const status of this.statusList) {
                                for (const item of status.items) {
                                    if (startIds.some(id => item.ids.includes(id))) {
                                        selectedToStatus = item.title;
                                    }
                                    if (endIds.some(id => item.ids.includes(id))) {
                                        selectedFromStatus = item.title;
                                    }
                                }
                            }
                        }
                        let requestBody = {
                            selectedBoard: this.selectedBoard,
                            sessionBoardId: this.selectedBoard.activeSessionBoard,
                            tenant: this.selectedBoard.tenant,
                            selectedGraph: this.selectedGraph,
                            graphName: this.graphName,
                            selectedFilterType: 'cfd',
                            statusListing: this.statusListing,
                            selectedInterval: this.selectedInterval == 'custom' ? this.customInterval : this.selectedInterval,
                            optionTypeTitle: this.optionTypeTitle,
                            graphTypeTitle: this.graphTypeTitle,
                            radioButtonSelection: this.pickedRadioType,
                            selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                            groupBy: this.selectedFlowTimeLineGroupBy,
                            groupByTitle: this.getTitleById(this.selectedFlowTimeLineGroupBy),
                            xAxis: this.selectedXAxis,
                            selectedBoardTitle: selectedBoardTitle,
                            selectedToStatus: selectedToStatus,
                            selectedFromStatus: selectedFromStatus,
                            selectedIssueTypeTitleList: this.issueTypesList.filter(item => this.selectedIssueType?.includes(item.id)).map(item => item.name),
                            chartType: this.chartType,
                            boardItemsFilter : this.boardItemsFilter,
                            itemtags : this.filter,
                            itemTagsMeta: this.filterwithMeta,
                        }
                        this.$emit('populate-graph', requestBody);
                    }
                    else if (this.optionTypeTitle == 'Flow Efficiency Graph') {
                        let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                        let selectedToStatus = null;
                        let selectedFromStatus = null;
                        if (this.toggleCreationDate == false) {
                            const startIds = this.statusListing.startOfSelectedStatus.split(',');
                            const endIds = this.statusListing.endOfSelectedStatus.split(',');
                            for (const status of this.statusList) {
                                for (const item of status.items) {
                                    if (startIds.some(id => item.ids.includes(id))) {
                                        selectedToStatus = item.title;
                                    }
                                    if (endIds.some(id => item.ids.includes(id))) {
                                        selectedFromStatus = item.title;
                                    }
                                }
                            }
                        } else if(this.toggleCreationDate){
                            const endIds = this.statusListing.endOfSelectedStatus.split(',');
                            for (const status of this.statusList) {
                                for (const item of status.items) {
                                    if (endIds.some(id => item.ids.includes(id))) {
                                        selectedFromStatus = item.title;
                                    }
                                }
                            }
                        }
                        let requestBody = {
                            selectedBoard: this.selectedBoard,
                            sessionBoardId: this.selectedBoard.activeSessionBoard,
                            tenant: this.selectedBoard.tenant,
                            selectedGraph: this.selectedGraph,
                            graphName: this.graphName,
                            selectedFilterType: 'cfd',
                            statusListing: this.statusListing,
                            selectedInterval: this.selectedInterval == 'custom' ? this.customInterval : this.selectedInterval,
                            optionTypeTitle: this.optionTypeTitle,
                            graphTypeTitle: this.graphTypeTitle,
                            radioButtonSelection: this.pickedRadioType,
                            selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                            activeTimeStatus: this.selectedActiveStatus.join(','),
                            toggleCreationDate: this.toggleCreationDate,
                            groupBy: this.selectedFlowTimeLineGroupBy,
                            xAxis: this.selectedXAxis,
                            selectedBoardTitle: selectedBoardTitle,
                            selectedToStatus: selectedToStatus,
                            selectedFromStatus: selectedFromStatus,
                            selectedIssueTypeTitleList: this.issueTypesList.filter(item => this.selectedIssueType?.includes(item.id)).map(item => item.name),
                            groupByTitle: this.getTitleById(this.selectedFlowTimeLineGroupBy),
                            chartType: this.chartType,
                            boardItemsFilter : this.boardItemsFilter,
                            itemtags : this.filter,
                            itemTagsMeta: this.filterwithMeta,
                        }
                        this.$emit('populate-graph', requestBody);
                    }
                    else if (this.optionTypeTitle == 'Flow Velocity Graph') {
                        let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                        let selectedFromStatus = null;
                        let toStatusSet = new Set();
                        if (this.toggleCreationDate == false) {
                            for (let i = 0; i < this.selectedActiveStatus.length; i++) {
                                const startIds = this.selectedActiveStatus.at(-1).split(',');
                                const endIds = this.selectedActiveStatus.at(i).split(',');
                                for (const status of this.statusList) {
                                    for (const item of status.items) {
                                        if (endIds.some(id => item.ids.includes(id))) {
                                            if (this.pickedRadioType == 'statusCategory') {
                                                toStatusSet.add(status.title);
                                            }
                                            else{
                                                toStatusSet.add(item.title);
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        let selectedToStatus = Array.from(toStatusSet);
                        selectedToStatus = selectedToStatus.join(',');
                        let requestBody = {
                            selectedBoard: this.selectedBoard,
                            sessionBoardId: this.selectedBoard.activeSessionBoard,
                            tenant: this.selectedBoard.tenant,
                            selectedGraph: this.selectedGraph,
                            graphName: this.graphName,
                            selectedFilterType: 'cfd',
                            statusListing: this.statusListing,
                            selectedInterval: this.selectedInterval == 'custom' ? this.customInterval : this.selectedInterval,
                            optionTypeTitle: this.optionTypeTitle,
                            graphTypeTitle: this.graphTypeTitle,
                            radioButtonSelection: this.pickedRadioType,
                            selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                            activeTimeStatus: this.selectedActiveStatus,
                            groupBy: this.selectedFlowTimeLineGroupBy,
                            xAxis: this.selectedXAxis,
                            selectedBoardTitle: selectedBoardTitle,
                            selectedToStatus: selectedToStatus,
                            selectedIssueTypeTitleList: this.issueTypesList.filter(item => this.selectedIssueType?.includes(item.id)).map(item => item.name),
                            groupByTitle: this.getTitleById(this.selectedFlowTimeLineGroupBy),
                            chartType: this.getChartIdByName(this.chartType),
                            chartTypeName: this.chartType,
                            boardItemsFilter : this.boardItemsFilter,
                            itemtags : this.filter,
                            itemTagsMeta: this.filterwithMeta,
                        }
                        this.$emit('populate-graph', requestBody);
                    }
                    else if (this.optionTypeTitle == 'Flow Load Graph') {
                        let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                        let toStatusSet = new Set();
                        let fromStatusSet = new Set();
                        for (const statusString of this.activeStatusList) {
                            const startIds = statusString.split(',');
                            for (const status of this.statusList) {
                                for (const item of status.items) {
                                    if (startIds.some(id => item.ids.includes(id))) {
                                        if (this.pickedRadioType == 'statusCategory') {
                                            fromStatusSet.add(status.title);
                                        }
                                        else{
                                            fromStatusSet.add(item.title);
                                        }
                                    }
                                }
                            }
                        }

                        for (const statusString of this.inProgressStatusList) {
                            const endIds = statusString.split(',');
                            for (const status of this.statusList) {
                                for (const item of status.items) {
                                    if (endIds.some(id => item.ids.includes(id))) {
                                        if (this.pickedRadioType == 'statusCategory') {
                                            toStatusSet.add(status.title);
                                        }
                                        else{
                                            toStatusSet.add(item.title);
                                        }
                                    }
                                }
                            }
                        }

                        let selectedToStatus = Array.from(toStatusSet);
                        selectedToStatus = selectedToStatus;
                        let selectedFromStatus = Array.from(fromStatusSet);
                        selectedFromStatus = selectedFromStatus;

                        let requestBody = {
                            selectedBoard: this.selectedBoard,
                            sessionBoardId: this.selectedBoard.activeSessionBoard,
                            tenant: this.selectedBoard.tenant,
                            selectedGraph: this.selectedGraph,
                            graphName: this.graphName,
                            activeStatuses: this.activeStatusList,
                            waitingStatuses: this.inProgressStatusList,
                            selectedFilterType: 'cfd',
                            optionTypeTitle: this.optionTypeTitle,
                            graphTypeTitle: this.graphTypeTitle,
                            radioButtonSelection: this.pickedRadioType,
                            selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                            groupBy: this.selectedFlowTimeLineGroupBy,
                            xAxis: this.selectedXAxis,
                            selectedBoardTitle: selectedBoardTitle,
                            selectedToStatus: selectedToStatus,
                            selectedFromStatus: selectedFromStatus,
                            selectedIssueTypeTitleList: this.issueTypesList.filter(item => this.selectedIssueType?.includes(item.id)).map(item => item.name),
                            orignalStartDate: this.eventStartDate,
                            orignalEndDate: this.eventEndDate,
                            startDate: isValidDate(this.eventStartDate) && this.eventStartDate?.format("d mmm yyyy"),
                            endDate: isValidDate(this.eventEndDate) && this.eventStartDate?.format("d mmm yyyy"),
                            groupByTitle: this.getTitleById(this.selectedFlowTimeLineGroupBy),
                            chartType: this.chartType,
                            boardItemsFilter : this.boardItemsFilter,
                            itemtags : this.filter,
                            itemTagsMeta: this.filterwithMeta,
                        }
                        this.$emit('populate-graph', requestBody);
                    }
                    else if (this.optionTypeTitle == 'Flow Distribution Graph') {

                        let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                        const selectedToStatus = [];
                        const selectedFromStatus = [];

                        for (const statusString of this.selectedActiveStatus) {
                            const startIds = statusString.split(',');
                            for (const status of this.statusList) {
                                for (const item of status.items) {
                                    if (startIds.some(id => item.ids.includes(id))) {
                                        selectedFromStatus.push(item.title);
                                    }
                                }
                            }
                        }

                        let requestBody = {
                            selectedBoard: this.selectedBoard,
                            sessionBoardId: this.selectedBoard.activeSessionBoard,
                            tenant: this.selectedBoard.tenant,
                            selectedGraph: this.selectedGraph,
                            graphName: this.graphName,
                            selectedFilterType: 'cfd',
                            optionTypeTitle: this.optionTypeTitle,
                            graphTypeTitle: this.graphTypeTitle,
                            radioButtonSelection: this.pickedRadioType,
                            selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                            groupBy: this.selectedFlowTimeLineGroupBy,
                            xAxis: this.selectedXAxis,
                            yAxis: this.pickedYAxisRadioType,
                            selectedBoardTitle: selectedBoardTitle,
                            selectedFromStatus: selectedFromStatus,
                            selectedDistributionStatus: this.selectedActiveStatus,
                            selectedIssueTypeTitleList: this.issueTypesList.filter(item => this.selectedIssueType?.includes(item.id)).map(item => item.name),
                            selectedIssueTypeTitleMap: this.issueTypesList
                                ?.filter(item => this.selectedIssueType?.includes(item.id))
                                .reduce((acc, item) => {
                                    acc[item.id] = item.name;
                                    return acc;
                                }, {}),
                            orignalStartDate: this.eventStartDate,
                            orignalEndDate: this.eventEndDate,
                            startDate: isValidDate(this.eventStartDate) && this.eventStartDate?.format("d mmm yyyy"),
                            endDate: isValidDate(this.eventEndDate) && this.eventEndDate?.format("d mmm yyyy"),
                            groupByTitle: this.getTitleById(this.selectedFlowTimeLineGroupBy),
                            chartType: this.chartType,
                            boardItemsFilter : this.boardItemsFilter,
                            itemtags : this.filter,
                            itemTagsMeta: this.filterwithMeta,
                        }
                        this.$emit('populate-graph', requestBody);

                    }
                }
                else if (this.graphTypeOptionTitle == "Custom Graphs") {
                    if (this.optionTypeTitle == 'Item Completion by Teams') {
                        //if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.selectedBoardSprint) && !_.isEmpty(this.selectedIssueType)  && !_.isEmpty(this.graphName) && !_.isEmpty(this.pickedRadioType) &&  !_.isEmpty(this.selectedActiveStatus) )
                        let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                        let selectedSprintIds = this.selectedBoardSprint.map(sprint => sprint.id);

                        const selectedFromStatus = [];
                        for (const statusString of this.selectedActiveStatus) {
                            const startIds = statusString.split(',');
                            for (const status of this.statusList) {
                                for (const item of status.items) {
                                    if (startIds.some(id => item.ids.includes(id))) {
                                        selectedFromStatus.push(status.title);
                                    }
                                }
                            }
                        }

                        let requestBody = {
                            selectedBoard: this.selectedBoard,
                            sessionBoardId: this.selectedBoard.activeSessionBoard,
                            tenant: this.selectedBoard.tenant,
                            selectedGraph: this.selectedGraph,
                            graphName: this.graphName,
                            selectedActiveStatus: this.selectedActiveStatus,
                            selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                            radioButtonSelection: this.pickedRadioType,
                            selectedSprintIds: selectedSprintIds,
                            selectedIssueTypeTitleList: this.issueTypesList.filter(item => this.selectedIssueType?.includes(item.id)).map(item => item.name),
                            selectedBoardTitle: selectedBoardTitle,
                            toggleCreationDate: this.toggleCreationDate,
                            optionTypeTitle: this.optionTypeTitle,
                            graphTypeTitle: this.graphTypeTitle,

                        }
                        this.$emit('populate-graph', requestBody);

                    } else {
                        var conditionsList = this.conditionsList;
                        var selectedItems = this.selectedCondition;
                        var selectedGraph = this.selectedGraph;
                        var graphName = this.graphName;
                        var selectedCollectionId = this.selectedCollection.id;
                        var dataofGraph = {
                            "graphType": selectedGraph,
                            "itemList": conditionsList,
                            "selectedItems": selectedItems,
                            "hierarchyLevel": "" + this.selectedFilter.level,
                            "chartType": "others",
                        };
                        this.widgets = [];
                        var widgetData = {};
                        if (!_.isEmpty(this.selectedAdditionalFilterCriteria) && !_.isEmpty(this.selectedAdditionalGraphOption)) {
                            widgetData = {
                                name: graphName,
                                type: this.selectedFilterType,
                                graphCriteria: dataofGraph,
                                releaseTrainId: selectedCollectionId,
                                criteria: this.selectedFilter,
                                selectedAdditionalGraphOption: this.selectedAdditionalGraphOption.id,
                                selectedAdditionalFilterCriteria: this.selectedAdditionalFilterCriteria.id,
                            };
                            //let's call for additional data population here
                            var data = {};
                            //in future lets add the hiererical level here
                            data.groupBy = this.selectedAdditionalFilterCriteria.id;
                            data.parentGroup = this.selectedFilterType;
                            data.selectedItems = selectedItems;
                            data.releaseTrainID = this.selectedCollection.id;
                            axios.post("/dashboard/" + this.dashboardSelected + "/retrieveAdditionalItems/", data).then(response => {
                                const itemList = response.data.itemsList;
                                //widgetData.graphAdditionalCriteria
                                var graphAdditionalCriteriaList = [];
                                for (let i = 0; i < itemList.length; i++) {
                                    var graphAdditionalCriteria = {};
                                    graphAdditionalCriteria.title = itemList[i].title;
                                    graphAdditionalCriteria.id = itemList[i].id;
                                    graphAdditionalCriteria.itemList = itemList[i].statusList;
                                    graphAdditionalCriteriaList.push(graphAdditionalCriteria);
                                }
                                widgetData.graphAdditionalCriteria = graphAdditionalCriteriaList;
                                axios.post("/dashboard/" + this.dashboardSelected + "/widget/save", widgetData).then(response => {
                                    this.graphName = "";
                                    this.selectedCollection.id = "";
                                    this.selectedGraph = "";
                                    this.selectedCondition = [];
                                    this.conditionsList = [];
                                    this.$emit('closeSelection', response.data.widget);
                                }).catch(e => {
                                    console.error(e);
                                })
                            }).catch(error => {
                                console.error(error)
                            });
                        } else {
                            widgetData = {
                                name: graphName,
                                type: this.selectedFilterType,
                                graphCriteria: dataofGraph,
                                releaseTrainId: selectedCollectionId,
                                criteria: this.selectedFilter,
                            }
                            axios.post("/dashboard/" + this.dashboardSelected + "/widget/save", widgetData).then(response => {
                                this.graphName = "";
                                this.selectedCollection.id = "";
                                this.selectedGraph = "";
                                this.selectedCondition = [];
                                this.conditionsList = [];
                                this.$emit('closeSelection', response.data.widget);
                            }).catch(e => {
                                console.error(e);
                            })
                        }

                    }
                }

            }
        },

        populateTeamsAndSprintData : function(response,requestBody){

            if(requestBody['teams']){

                let teamSequence = response['teamSequence'];
                let teamsGroupBy = _.groupBy(response['teams'],'_id');

                for(let teamId of teamSequence){

                    this.boardTeamListing.push(teamsGroupBy[teamId][0]);
                }
            }

            if(requestBody['sprints']){

                this.boardSprintListing = response["sprints"];
            }
        },

        getSelectedBoardTeamAndSprintList : function(teamFlag,sprintFlag){
            let requestBody = {};
            if(teamFlag){
                requestBody['teams'] = 'teams';
            }

            if(sprintFlag){
                requestBody['sprints'] = 'sprints';
            }

            let _this = this;
            let boardId = this.selectedBoard.activeSessionBoard;
            axios.post('/dashboard/get-board-teams-sprints/'+ boardId , requestBody)
                .then(response => {

                    try{
                        if (response.data) {

                            this.populateTeamsAndSprintData(response.data,requestBody);
                        }
                    }catch(e){
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }

                }).catch(error => {
                console.log(error);
                handleErrorSprintReportMsg(error);
            });
        },

        getAllAccessableBoardStatusListing : function(boardId){
            let _this = this;
            axios.get('/dashboard/get-status-listing/'+ boardId)
                .then(response => {
                    try{
                        let groupedItems = {};

                        for (let status of response.data) {
                            if (!groupedItems[status.title]) {
                                groupedItems[status.title] = {
                                    title: status.title,
                                    ids: [],
                                    category: status.category,
                                };
                            }
                            groupedItems[status.title].ids.push(status.id);
                        }

                        let resultList = Object.values(groupedItems);

                        if (resultList) {
                            _this.statusListing.startOfStatusListing = resultList;
                            let categoryMap = new Map();
                            for (let i = 0; i < _this.statusListing.startOfStatusListing.length; i++) {
                                let category =_this.statusListing.startOfStatusListing[i].category ;
                                if (!categoryMap.has(category)) {
                                    categoryMap.set(category, []);
                                }
                                let condition = {"ids":_this.statusListing.startOfStatusListing[i].ids, "title": _this.statusListing.startOfStatusListing[i].title}
                                categoryMap.get(category).push(condition);
                            }
                            let sortedEntries = Array.from(categoryMap.entries());
                            const order = ["ToDo", "InProgress", "Done","Misc"];
                            sortedEntries.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));
                            categoryMap = new Map(sortedEntries);
                            let categoryList = [];
                            categoryMap.forEach((items, category) => {
                                categoryList.push({
                                    title: category,
                                    items: items
                                });
                            });
                            _this.statusList=categoryList;
                        }
                    }catch(e){
                        //  showTopMessage("Some error has occurred while fetching board statuses",'warning','4000');
                        this.showloader =false;
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }

                }).catch(error => {
                //  showTopMessage("Some error has occurred while fetching board statuses",'warning','4000');
                this.showloader =false;
                console.log(error);
                handleErrorSprintReportMsg(error);
            });
        },
        getPIStartEndDates: function(boardId) {
            let _this = this;
            axios.get('/dashboard/get-start-end-date/' + boardId)
                .then(response => {
                    try {
                        if (!_.isEmpty(response.data)) {
                            _this.eventStartDate = new Date(response.data.startDate);
                            _this.eventEndDate = new Date(response.data.endDate);
                        } else {
                            let currentDate = new Date();
                            _this.eventStartDate = currentDate;
                            _this.eventEndDate = currentDate;
                        }
                    } catch (e) {
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }
                })
                .catch(error => {
                    console.log(error);
                    handleErrorSprintReportMsg(error);
                });
        },

        getAllAccessableBoardStartEndStatusListing: function (boardId) {
            let _this = this;
            axios.get('/dashboard/get-status-listing/' + boardId)
                .then(response => {
                    console.log("response.data",response.data);
                    try {
                        let groupedItems = {};

                        for (let status of response.data) {
                            if (!groupedItems[status.title]) {
                                groupedItems[status.title] = {
                                    title: status.title,
                                    ids: [],
                                    category: status.category,
                                };
                            }
                            groupedItems[status.title].ids.push(status.id);
                        }

                        let resultList = Object.values(groupedItems);

                        if (resultList) {
                            _this.statusListing.startOfStatusListing = resultList;
                            _this.statusListing.endOfStatusListing = resultList;

                            let categoryMap = new Map();
                            let statuscategoryMap = new Map();

                            for (let i = 0; i < resultList.length; i++) {
                                let category = resultList[i].category;
                                if (!categoryMap.has(category)) {
                                    categoryMap.set(category, []);
                                }
                                if (!statuscategoryMap.has(category)) {
                                    statuscategoryMap.set(category, []);
                                }
                                let condition = {
                                    ids: resultList[i].ids,
                                    title: resultList[i].title
                                };
                                categoryMap.get(category).push(condition);
                                let conditionStatusCategory = resultList[i].ids;
                                statuscategoryMap.get(category).push(conditionStatusCategory);
                            }

                            let sortedEntries = Array.from(categoryMap.entries());
                            let sortedEntriesForStatusCategory = Array.from(statuscategoryMap.entries());

                            const order = ["ToDo", "InProgress", "Done", "Misc"];
                            sortedEntries.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));
                            sortedEntriesForStatusCategory.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));

                            let transformedEntriesForStatusCategory = sortedEntriesForStatusCategory.map(entry => {
                                let category = entry[0];
                                let nestedArrays = entry[1];
                                let uniqueIdsList = [];
                                for (let i = 0; i < nestedArrays.length; i++) {
                                    let nestedArray = nestedArrays[i];
                                    for (let j = 0; j < nestedArray.length; j++) {
                                        if (!uniqueIdsList.includes(nestedArray[j])) {
                                            uniqueIdsList.push(nestedArray[j]);
                                        }
                                    }
                                }
                                return {
                                    key: category,
                                    value: {
                                        ids: uniqueIdsList
                                    }
                                };
                            });

                            categoryMap = new Map(sortedEntries);

                            let categoryList = [];
                            categoryMap.forEach((items, category) => {
                                categoryList.push({
                                    title: category,
                                    items: items
                                });
                            });

                            let statusCategoryList = [];
                            transformedEntriesForStatusCategory.forEach((items) => {
                                statusCategoryList.push({
                                    title: items.key,
                                    ids: items.value.ids.join(","),
                                });
                            });
                            _this.statusList = categoryList;
                            _this.fromStatusList = categoryList;
                            _this.toStatusList = categoryList;
                            _this.categoryList = statusCategoryList;
                            // const todoCategory = _this.categoryList.find(cat => cat.title === 'ToDo');
                            // const doneCategory = _this.categoryList.find(cat => cat.title === 'Done');
                            //
                            // if (todoCategory) {
                            //     const todoIds = todoCategory.ids.split(',');
                            //     _this.statusListing.startOfSelectedStatus = [todoIds];
                            // }
                            // if (doneCategory) {
                            //     const doneIds = doneCategory.ids.split(',');
                            //     _this.statusListing.endOfSelectedStatus = [doneIds];
                            // }
                            // }
                        }
                        console.log(this.categoryList);
                        console.log(this.statusList);
                    } catch (e) {
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }
                })
                .catch(error => {
                    console.log(error);
                    handleErrorSprintReportMsg(error);
                });
        }
        ,

        getCFDAdvanceCriteria:function(boardId){
            let _this = this;
            axios.get('/dashboard/get-cfd-advance-criteria/'+ boardId)
                .then(response => {
                    try {
                        this.teams = response.data.teams;
                        this.sprints = response.data.sprints;
                    }
                    catch (e){
                        console.error(e);
                    }
                });

        },

        getAllAccessableBoardsListing : function(){
            let _this = this;
            this.showloader =true;
            axios.get('/dashboard/get-board-listing/')
                .then(response => {
                    try{
                        if (response.data) {
                            _this.boardListing = response.data;
                        }
                        if( _.isEmpty(_this.boardListing)){
                            showTopMessage("No PI Board is present, Please create a new PI Board and Select that to continue",'warning',5000);
                            this.showloader =false;
                            return;
                        }
                        this.showloader =false

                    }catch(e){
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                        this.showloader =false
                    }
                }).catch(error => {
                console.log(error);
                handleErrorSprintReportMsg(error);
                this.showloader =false
            });
        },

        fetchAllCollections: function () {
            let _this = this;
            let data = {};
            data.fetchTypes = false;
            axios.post("/dashboard/fetch-all-release-trains", data)
                .then(response => {
                    if (response.data) {
                        _this.collections = response.data.releaseTrains;
                    }
                }).catch(error => {
                console.error(error);
            });
        },

        handleGraphSelection:function(){
            this.graphSelected=true;
        },

        handleCollectionSelection: function () {
            this.collectionSelected=true;
            this.filterList=[];
            if(!_.isEmpty(this.selectedFilterType)){
                this.handleFilterTypeSelection();
            }
        },

        handleFilterTypeSelection:function(){
            this.filterTypeSelected=true;
            let _this = this;
            if(_this.selectedFilterType !='cfd') {
                data = {"releaseTrainID": _this.selectedCollection.id, "filterType": _this.selectedFilterType};
                axios.post("/dashboard/fetch-release-train-filters", data)
                    .then(response => {
                        _this.filterList = response.data.releaseTrainFilters;
                        this.filterSelected = false;
                    }).catch(error => {
                    console.error(error);
                });
                this.pagination.pageIndex = 0;
                this.pagination.totalItemSize = 0;
            }
        },

        handleFilterSelection:function(){
            this.loadBacklogItems(this.selectedFilterType);
            this.pagination.pageIndex = 0;
            this.pagination.totalItemSize = 0;
            this.filterSelected=true;
            this.pagination.pageIndex = 0;
            this.pagination.totalItemSize = 0;
        },

        loadBacklogItems: function(filterBy) {
            let _this = this;
            let data = {};
            data.hierachLevel = "" + this.selectedFilter.level;
            data.fetchParents  = true;
            data.filterBy=filterBy;
            data.requestId = getNewUUID();
            data.filter = this.selectedFilter.criteria;
            if (data.filter && !_.isEmpty(data.filter.rules)) {
            }else {
                delete data.filter;
            }
            axios.post('/dashboard/' + this.selectedCollection.id + '/retrieveItems', data)
                .then(res => {
                    if (res.data) {
                        var items = [];
                        items = res.data;
                        this.filteredData=[];
                        this.filteredData=items;
                        this.populateConditionsDropdown(items);
                        if(this.selectedFilterType == "teams"){
                            this.selectedCondition = this.conditionsList.map(condition => condition.id);
                        }
                    }
                }).catch(error => {
                console.error(error);
            });
        },

        populateConditionsDropdown:function(responseData){
            this.conditionsList=[];
            if(this.selectedFilterType === "status"){
                const statusMap = responseData.statusMap;
                const statusList = statusMap.statusList;
                this.conditionsList=statusList;
                let categoryMap = new Map();
                for (let i = 0; i < this.conditionsList.length; i++) {
                    let category = this.conditionsList[i].key.split("-")[0];
                    if (!categoryMap.has(category)) {
                        categoryMap.set(category, []);
                    }
                    let condition = {"id":this.conditionsList[i].id,"count":this.conditionsList[i].count,"key": this.conditionsList[i].key, "title": this.conditionsList[i].title}
                    categoryMap.get(category).push(condition);
                }
                let categoryList = [];
                categoryMap.forEach((items, category) => {
                    categoryList.push({
                        title: category,
                        items: items
                    });
                });
                this.optionsList=categoryList;
            }else if(this.selectedFilterType === "teams"){
                const teamsMap = responseData.teamsMap;
                const teamsList = teamsMap.teamsList;
                this.conditionsList=teamsList;
                this.optionsList=teamsList;
            }
            this.filterSelected=true;
        },
        getTitleById:function(id) {
            for (const group of this.flowTimeLineGroupByList) {
                for (const item of group.items) {
                    if (item.id === id) {
                        return item.title;
                    }
                }
            }
            return null; // Return null if no match found
        },

        createBacklogGroups : function (){
            let almData = [];
            let kendisData = {
                id:"kendisGroups",
                items : [{id:'teams',title:"Team"},
                    {id:"cardType",title:"Card Type"},
                    // {id:"plannedUnplanned",title:"Planned/Unplanned"},
                ],
                title : "Group by"
            }
            this.flowTimeLineGroupByList = [];
            if (this.boardType === 'jiraBoard') {
                let additionalFieldArray = [];
                if(!_.isEmpty(this.sessionBoard.session)) {
                    // if (this.sessionBoard.session.jiraFeatureParentEnabled) {
                    //     additionalFieldArray.push({title: 'Parent', id: 'jiraField-parent'});
                    // }
                    // if (this.sessionBoard.session.additionalFieldsEnabled && this.sessionBoard.session.additionalFieldsValuesFeature) {
                    //     for (let featureField of this.sessionBoard.session.additionalFieldsValuesFeature) {
                    //         let fieldData = this.jiraFieldsMap.find(item => (item.key == featureField.key));
                    //         if (fieldData) {
                    //             if (this.sessionBoard.session.jiraFeatureParentEnabled && fieldData.key == 'parent') {
                    //                 continue;
                    //             }
                    //             additionalFieldArray.push({title: fieldData.name, id: 'jiraField-' + fieldData.key});
                    //         }
                    //     }
                    // }
                    // if (this.sessionBoard.session.additionalFieldsEnabled && this.sessionBoard.session.additionalFieldsValuesUserStory) {
                    //     for (let featureField of this.sessionBoard.session.additionalFieldsValuesUserStory) {
                    //         let fieldData = this.jiraFieldsMap.find(item => (item.key == featureField.key));
                    //         if (fieldData) {
                    //             if (this.sessionBoard.session.jiraFeatureParentEnabled && fieldData.key == 'parent') {
                    //                 continue;
                    //             }
                    //             additionalFieldArray.push({title: fieldData.name, id: 'jiraField-' + fieldData.key});
                    //         }
                    //     }
                    // }
                    // if (additionalFieldArray.length > 0) {
                    //     almData = {
                    //         id: "almGroups",
                    //         items: additionalFieldArray,
                    //         title: "By Jira Additional Fields"
                    //     }
                    // }
                    if (!_.isEmpty(this.sessionBoard.session.almConfigurations)) {
                        kendisData.items.push({id: 'jiraProject', title: "Jira Project"});  //tbc
                    }
                }
            }
            else if(this.boardType === 'tfsBoard'){
                almData = {
                    id: "almGroups",
                    items: [{ id: 'tfsProject', title: "Project" },
                        { id: 'areaPath', title: "Area Path" },
                        // { id: 'epic', title: "Parent-Epic" }
                    ],
                    title: "By Azure DevOps Fields"
                }; //tbc
                let duplicationCheckMap = {};
                // _.each(this.tfsProjects, project=> {
                //     if (project.selectedFields) {
                //         _.each(project.selectedFields, fieldMap=> {
                //             if (!duplicationCheckMap[fieldMap.referenceName]) {
                //                 duplicationCheckMap[fieldMap.referenceName] = true;
                //                 let groupByOption = {};
                //                 groupByOption.title = fieldMap.name;
                //                 groupByOption.id = "tfsField-"+fieldMap.referenceName;
                //                 groupByOption.key = fieldMap.referenceName;
                //                 groupByOption.dataType = fieldMap.type;
                //                 almData.items.push(groupByOption);
                //             }
                //         });
                //     }
                // });
            }
            this.flowTimeLineGroupByList.push(kendisData);
            this.flowTimeLineGroupByList.push(almData);

            if(this.optionTypeTitle === 'Flow Load Graph' || this.optionTypeTitle === 'Flow Distribution Graph'){
                var teamData = {
                    id: "kendisGroups",
                    items: [{id: 'teams', title: "Team"},
                    ],
                    title: "Group by"
                }
                this.flowTimeLineGroupByList = [];
                this.flowTimeLineGroupByList.push(teamData);
            }
        },

        handleRadioChange(value) {
            this.statusListing.startOfSelectedStatus = "";
            this.statusListing.endOfSelectedStatus = "";
        },

        handleBoardFilterSelection: function() {
            // Handle Cumulative Flow Diagram criteria
            const handleCfdCriteriaList = () => {
                const indexOfTeams = this.cfdCriteriaList.findIndex(item => item.id === 'teams');
                if (this.boardItemsFilter === 'unplanned-items' ) {
                    if (indexOfTeams !== -1) {
                        this.cfdCriteriaList.splice(indexOfTeams, 1);
                        this.selectedCFDCriteria = '';
                    }
                } else {
                    if (indexOfTeams === -1) {
                        this.cfdCriteriaList.push({ id: 'teams', title: 'Team' });
                    }
                }
            };

            // If CFD, handle and return early
            if (this.optionTypeTitle === 'Cumulative Flow Diagram') {
                handleCfdCriteriaList();
                return;
            }

            // Finding the "kendisGroups" object
            const kendisGroups = this.flowTimeLineGroupByList.find(group => group.id === 'kendisGroups');
            if (kendisGroups) {
                const items = kendisGroups.items;

                const removeItemById = (array, id) => {
                    const index = array.findIndex(item => item.id === id);
                    if (index !== -1) array.splice(index, 1);
                };

                const addItemToTop = (array, item) => {
                    if (!array.some(existingItem => existingItem.id === item.id)) {
                        if (array.length > 15) {
                            array.push(item);
                        } else {
                            array.unshift(item);
                        }
                    }
                };

                // Handle group by options based on board filter selection
                const teamsItem = { id: 'teams', title: 'Team' };
                if (this.boardItemsFilter === 'unplanned-items') {
                    removeItemById(items, 'teams');
                } else {
                    addItemToTop(items, teamsItem);
                }
            }
        },

    },
})
