const kendisDashboardWidgetFactory = Vue.component('kendis-dashboard-widget-factory', {
    template:`
        <div 
            class="grid-stack-item "
        	:id="widgetData.id"
    		:name="widgetData.name"
    		:gs-x="widgetData.posX"
    		:gs-y="widgetData.posY"
    		:gs-w="widgetData.columns"
    		:gs-h="widgetData.rows"
            >
    		<div class="grid-stack-item-content graphCard">
    		
                <!-- PI Board Graphs -->
    		
	            <kendis-widget-cfd  ref="cfd" v-if="widget.type == 'cfd-graph' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
	            <kendis-widget-flow-time ref="flowTime" v-if="widget.type == 'flow-time-graph' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
	            <kendis-widget-flow-efficiency ref="flowEfficiency" v-if="widget.type == 'flow-efficiency-graph' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
	            <kendis-widget-flow-velocity ref="flowVelocity" v-if="widget.type == 'flow-velocity-graph' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
	            <kendis-widget-flow-load ref="flowLoad" v-if="widget.type == 'flow-load-graph' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
	            <kendis-widget-flow-distribution ref="flowDistribution" v-if="widget.type == 'flow-distribution-graph' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
	            <kendis-widget-cycle-time ref="cycleTime" v-if="widget.type == 'cycle-time-graph' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
	            <kendis-widget-lead-time ref="leadTime" v-if="widget.type == 'lead-time-graph' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
                
                <!-- Collection Graphs --> 
                <kendis-widget-collection-pie-column ref="collectionsPieChart" v-if="widget.type == 'collections-pie-chart' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role" :globalColorsMap="globalColorsMap"/>
                <kendis-widget-collection-column ref="collectionsColChart" v-if="widget.type == 'collections-col-chart' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role" :globalColorsMap="globalColorsMap"/>

	            <kendis-widget-completed-stories ref="completedStories" v-if="widget.type == 'completed-stories' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
	            <kendis-widget-general-purpose ref="generalPurpose" v-if="widget.type == 'general-purpose' " :dashboardSelectedId ="dashboardSelectedId" :widgetData="widget" @handleRemovalAction ="passWidgetIdToHome" @handleDuplicateAction ="passWidgetDataToHome" :myRole ="role"/>
            </div>
        </div>
    `,
    props: {widgetData: null,dashboardSelectedId:null,myRole:null, globalColorsMap: null},
    mixins:[rightsMixin],

    data() {
        return {
            widget:[],
            role:null,
        }
    },

    mounted() {
        EventBus.$on('syncAllWidgets', this.syncAllWidgets);
         EventBus.$on('rerenderWidget', this.rerenderWidget);
         
        let _this = this;
        if(_this.widgetData !== null){
            this.widget = _this.widgetData;
            this.role = _this.myRole;
        }
    },
    beforeDestroy() {
        EventBus.$off('syncAllWidgets', this.syncAllWidgets);
        EventBus.$off('rerenderWidget', this.rerenderWidget);
    },
    created() {
    },

    components: {
       //add individual widget components here

        //PI Board Widgets
        'kendis-widget-cfd':kendisWidgetCfd,
        'kendis-widget-flow-time':kendisWidgetFlowTimeGraph,
        'kendis-widget-flow-efficiency':kendisWidgetflowefficiencyGraph,
        'kendis-widget-flow-velocity':kendisWidgetFlowVelocityGraph,
        'kendis-widget-flow-load':kendisWidgetFlowLoadGraph,
        'kendis-widget-flow-distribution':kendisWidgetFlowDistributionGraph,
        'kendis-widget-cycle-time':kendisWidgetCycleTimeGraph,
        'kendis-widget-lead-time':kendisWidgetLeadTimeGraph,

        //Collection Widgets
        'kendis-widget-collection-pie-column':kendisWidgetCollectionPieColumn,
        'kendis-widget-collection-column':kendisWidgetCollectionColumn,

        'kendis-widget-completed-stories':kendisWidgetCompletedStories,
        'kendis-widget-general-purpose':kendisWidgetGeneralPurpose,
    },

    methods:    {

        syncAllWidgets() {
            const widgetTypes = [
                'cfd-graph',
                'flow-time-graph',
                'flow-efficiency-graph',
                'flow-velocity-graph',
                'flow-load-graph',
                'flow-distribution-graph',
                'cycle-time-graph',
                'lead-time-graph',
                'collections-pie-chart',
                'collections-col-chart',
                'completed-stories-graphs',
                'general-purpose'
            ];

            widgetTypes.forEach(type => {
                const refName = this.getRefNameByType(type);
                if (this.$refs[refName]) {
                    this.$refs[refName].handleSyncWidget(this.widget);
                }
            });
        },
        rerenderWidget(widgetId) {
            const widgetTypes = [
                'cfd-graph',
                'flow-time-graph',
                'flow-efficiency-graph',
                'flow-velocity-graph',
                'flow-load-graph',
                'flow-distribution-graph',
                'cycle-time-graph',
                'lead-time-graph',
                'collections-pie-chart',
                'collections-col-chart',
                'completed-stories-graphs',
                'general-purpose'
            ];

            widgetTypes.forEach(type => {
                const refName = this.getRefNameByType(type);
                if (this.$refs[refName] && this.widget.id == widgetId) {
                    this.$refs[refName].handleRerenderWidget();
                }
            });
        },

        getRefNameByType(type) {
            switch (type) {
                case 'cfd-graph':
                    return 'cfd';
                case 'flow-time-graph':
                    return 'flowTime';
                case 'flow-efficiency-graph':
                    return 'flowEfficiency';
                case 'flow-velocity-graph':
                    return 'flowVelocity';
                case 'flow-load-graph':
                    return 'flowLoad';
                case 'flow-distribution-graph':
                    return 'flowDistribution';
                case 'cycle-time-graph':
                    return 'cycleTime';
                case 'lead-time-graph':
                    return 'leadTime';
                case 'collections-pie-chart':
                    return 'collectionsPieChart';
                case 'collections-col-chart':
                    return 'collectionsColChart';
                case 'completed-stories-graphs':
                    return 'completedStories';
                case 'general-purpose':
                    return 'generalPurpose';
                default:
                    return '';
            }
        },
        //Method to pass data to relevant widget
        createNewWidget:function(widgetData){
            this.widget     =   widgetData;
        },

        passWidgetIdToHome:function(payload){
            const {id} = payload;
            this.$emit('handleRemoveAction', {id:id})
        },

        passWidgetDataToHome:function(payload){
            const {widget} = payload;
            this.$emit('handleDuplicateAction', {widget:widget})
        },
    }
});