
const kendisDashboardRow = Vue.component('kendis-dashboard-row', { 
    template:`
	  <tr class="tableRow">
		<td class="tableItem star" @click="onClickFavorite($event)">
	  		<span class="fav" :class="{'active':dashboard.favorite}"></span>
		</td>
		<td  @click="onClickDashboard" class="tableItem id">
	  		<a class="key c-point fs-13 ftsb">
	  			{{ dashboard.key }}
			</a>
		</td>
		<td @click="onClickDashboard" class="tableItem dashTitle ftsb c-point">				
  			{{dashboard.name}}
		</td>
		<td class="tableItem owner ftsb">
			<div class="DFA tooltip">
	  			<div class="pic mr-10">
					<!--<img src="">-->
	  				<div class="initial" style="background-color:#1991EB">{{findInitials(dashboard.owner ? dashboard.owner.fullName : '')}}</div>
	  			</div>
	  			<div class="hovtooltip">
					{{dashboard.owner.fullName}}
				</div>
	  		</div>
		</td>
		<td class="tableItem sharing ftsb">
			<div  v-if="dashboard.shared" class="shareName">
				<template v-if="dashboard.sharedWithAll">All Users</template>
				<template v-else>Shared</template>
			</div>
			<div v-else-if="dashboard.sharedWithAll" class="shareName">All Users</div>
			<div v-else class="shareName">Private</div>
		</td>
		<td v-if="dashboard.updatedOn" class="tableItem updated ftsb">
	  		{{handleDate(dashboard.updatedOn)}}
		</td>
		<td class="tableItem updated ftsb" v-if="!dashboard.updatedOn">
	  		N/A
		</td>
		<td class="tableItem created ftsb">
	  		{{handleDate(dashboard.createdOn)}}
		</td>
		<td class="tableItem  ftsb menu">
	  		<span v-if="moreMenu.options.length > 0" class="ti-more-alt" @click="toggleDropdown">
	  			
			</span>
			<vuepopup v-if="moreMenu.show" @close="moreMenu.show = false;">
				<div :ref="dropBoxRef"  class="moreMenu" style="display: block;">
					<ul>
						<li v-for="option in moreMenu.options" @click="onMoreMenuSelectOption(option);" class="c-point">{{option.title}}</li>
					</ul>
				</div>
			</vuepopup>
		</td>
	  </tr>
						  
		`,

    props : ["dashboard"],
    mixins:[rightsMixin],
    watch : {},

    data() {
        return {
			moreMenu: {
				show: false,
				options:[]
			},
        }
    },

    created() {
		if (this.dashboardActionAllowed(this.dashboard.myRole,"EditDashboard")) {
			this.moreMenu.options.push({id:"edit", title:"Edit Dashboard"});
		}
		if (this.dashboardActionAllowed(this.dashboard.myRole,"EditDashboard")) {
			this.moreMenu.options.push({id:"share", title:"Share Settings"});
		}
		if (this.dashboardActionAllowed(this.dashboard.myRole,"DeleteDashboard")) {
			this.moreMenu.options.push({id:"delete", title:"Delete"});
		}
    },

    mounted() {
    },

    computed: {
		dropBoxRef() {
			return `dropBox-${this.dashboard.key}`;
		}
    },

    components: {

    },

    methods: {
		toggleDropdown(event) {
			this.moreMenu.show = !this.moreMenu.show;

			this.$nextTick(() => {
				if (this.moreMenu.show) {
					const dropBox = this.$refs[this.dropBoxRef];
					const container = dropBox.closest('.boardsListContainer');

					if (dropBox && container) {
						const rect = dropBox.getBoundingClientRect();
						const containerRect = container.getBoundingClientRect();

						if (rect.bottom > containerRect.bottom) {
							dropBox.style.top = 'auto';
							dropBox.style.bottom = '70%';
							// dropBox.style.transform = 'translateY(-20px)';
						} else {
							dropBox.style.top = '16px';
							dropBox.style.bottom = 'auto';
							dropBox.style.transform = 'translateY(20px)';
						}
					} else {
						console.error('Dropdown element or container not found.', this.dropBoxRef);
					}
				}
			});
		},
        handleDate:function(date){
            const dateData = new Date(date);
            return dateData.toLocaleDateString();
        },
		findInitials:function(name) {
            // Handle cases where an object might be passed instead of a string
            if (!name || typeof name !== 'string') {
                return '';
            }
            if(name === ''){
                return '';
            }
            const words = name.split(' ');
            let initials = '';

            // for (let i = 0; i < words.length; i++) {
            const initial = words[0][0].toUpperCase();
            initials += initial;
            // }
            return initials;
        },
        
        ///////////////////////////////////////
        //////////    EVENTS
        onClickDashboard:function(){
			this.$emit("open",this.dashboard);
        },
        onClickFavorite: function (event) {
			event.stopPropagation();
			this.$emit("favorite",this.dashboard);
		},
		onMoreMenuSelectOption: function (option) {
			this.moreMenu.show = false;
			this.$emit("action", option.id , this.dashboard);
		}
    },
})


const kendisDashboardListview = Vue.component('kendis-dashboard-listview', { 
    template:`

		<div id="kendisdashboardlisting" class="active nw-analtc dashboardListing">
			<div v-if="loading" class="loader"><div><div class="loaderinteg"/></div></div> 
			<div class="DFCB dashboardListingHeader mintabs mv">
				<!-- <h4 class="listingTitle DFA"><img src="/assets/icons/dashboard.svg" alt=".." class="mr-10" />Dashboard</h4> -->
					<div v-if="isGlobal" class="DF tbin">
					<div class="tabs ftsb active">  Dashboards</div>
					<div class="tabs ftsb" @click="onClickNavigateToReports"> Reports</div>
					</div>
				<div class="DFA">
					<div class="ti-search sreachIcon p-rel mr-10">
						<input v-model="search.text" type="text" placeholder="Search..." class="listingSearch" @input="onSearchInput">
					</div>					
				</div>
			</div>
			<kendis-dashboard-homepage v-if="openDashboard" :dashboardSelectedId="selectedDashboard" :selectedDashboardName="selectedDashboardName" @close="openDashboard = false;"> </kendis-dashboard-homepage>
			<kendis-create-dashboard v-if="dashboardPopup.show" :dashboard="dashboardPopup.dashboard" :dashindex="dashboardPopup.tabIndex"
				@created="onDashboardPopupCreated" 
				@updated="onDashboardPopupUpdated"
				@close="onDashboardPopupClose"
				@roleUpdate="onRoleUpdateForAll"
				>
			</kendis-create-dashboard>
			<div class="dashboardTabsWraper" :class="[
				  _.isEmpty(selectedTabDashboards) && tabIndex === 0 ? ['FavEmptyDashboardScreen', 'emptyTab'] : '',
				  _.isEmpty(selectedTabDashboards) && tabIndex === 1 ? ['AllemptyDashboardScreen', 'emptyTab'] : '',
				  _.isEmpty(selectedTabDashboards) && tabIndex === 2 ? ['MyEmptyDashboardScreen', 'emptyTab'] : '',
				  _.isEmpty(selectedTabDashboards) && tabIndex === 3 ? ['sharedEmptyDashboardScreen', 'emptyTab'] : ''
				]">
				<div class="DFCB">
					<div class="tabswrap">
						<span class="tabItem ftsb clrblck" :class="[tabIndex==0?'active':'']" @click="onChangeTab(0)"><img src="/assets/icons/star-filled-gray.svg" alt=".." class="mr-5" style="margin-bottom: -3px;">Favorites <span class="infotxt  ml-5 lngtip tooltip pl-10 tipher pl-10"><span class="hovtooltip wht-nwrp">See dashboards you've marked as favorites for quick access.</span></span></span>
						<span class="tabItem ftsb clrblck" :class="[tabIndex==1?'active':'']" @click="onChangeTab(1)">All <span class="infotxt  ml-5 lngtip tooltip pl-10 tipher"><span class="hovtooltip wht-nwrp">Shows all dashboards, including created by you, shared with you, and favorites.</span></span></span> 
						<span class="tabItem ftsb clrblck" :class="[tabIndex==2?'active':'']" @click="onChangeTab(2)">My Dashboards <span class="infotxt  ml-5 lngtip tooltip pl-10 tipher"><span class="hovtooltip wht-nwrp">Access dashboards created by you in your account.</span></span></span> 
						<span class="tabItem ftsb clrblck" :class="[tabIndex==3?'active':'']" @click="onChangeTab(3)"> Shared with me <span class="infotxt  ml-5 lngtip tooltip pl-10 tipher"><span class="hovtooltip wht-nwrp">Access dashboards shared with you by other team members.</span></span></span> 
					</div>
					<div class="DFA"><div v-if="!isPremiumUser" class="infotxt mr-10">Available only for Premium Cloud Users</div> <button :type="isPremiumUser ? 'button' : 'disabled'" class="button headerButton" @click="onClickCreatDashboard()" :disabled="!isPremiumUser">+ Create Dashboard</button></div>
				</div>
				<div class="boardsListContainer scrollBar" :class="_.isEmpty(selectedTabDashboards)?'emptyTabScreen':''">
					<div v-if="_.isEmpty(selectedTabDashboards)" class="nofound">No dashboard found here</div>
					<div class="tableContainer" v-if="!_.isEmpty(selectedTabDashboards)">
						<table class="listTable">
						  <tr class="tableRow" >
						  	
						  	<th class="tabelHeading star"></th>
						 	<th class="tabelHeading id">ID</th>
							<th class="tabelHeading dashTitle" @click="onClickSortDashboards('title')">
								Title
								<img v-if="sortBy.value =='title' " img src="/assets/icons/Dashboard/sort.svg" alt=".." class="ml-5 c-point sortIcon" :class="{'active':(this.sortBy.ascending)}"/>
							</th>
							<th class="tabelHeading owner" @click="onClickSortDashboards('owner')">
								Owner
								<img v-if="sortBy.value =='owner' " img src="/assets/icons/Dashboard/sort.svg" alt=".." class="ml-5 c-point sortIcon" :class="{'active':(this.sortBy.ascending)}"/>
							</th>
							<th class="tabelHeading sharing" >
								Sharing
							</th>
							<th class="tabelHeading updated" @click="onClickSortDashboards('updated')">
								Updated
								<img v-if="sortBy.value =='updated' " img src="/assets/icons/Dashboard/sort.svg" alt=".." class="ml-5 c-point sortIcon" :class="{'active':(this.sortBy.ascending)}"/>
							</th>
							<th class="tabelHeading created" @click="onClickSortDashboards('created')">
								Created
								<img v-if="sortBy.value =='created' " img src="/assets/icons/Dashboard/sort.svg" alt=".." class="ml-5 c-point sortIcon" :class="{'active':(this.sortBy.ascending)}"/>
							</th>
							<th class="tabelHeading menu">
								
							</th>
						  </tr >
						  
						  <template v-for="dashboard in selectedTabDashboards">
						  	<kendis-dashboard-row v-if="dashboard.filterOn" :dashboard="dashboard" 
						  		:key="dashboard.key"
							  	@open="onDashboardRowOpen"
							  	@favorite="onDashboardRowFavorite"
							  	@action="onDashboardRowAction"
							  	/>
						  </template>
						</table>
					</div>
				</div>
				<div  class="txt-cntr" v-if="_.isEmpty(selectedTabDashboards) && tabIndex==0 ">
						<div class="emptyTextWrapFav">
							<h1 class="fs-18">No favorites yet!</h1>
							<p>Explore dashboards and click the <span class="fs-18">✩</span> to add your favorites here for quick access.</p>
						</div> 
				</div>
				<div  class="txt-cntr" v-if="_.isEmpty(selectedTabDashboards) && tabIndex==1 ">
						<div class="emptyTextWrap">
							<div>
							<h1 class="fs-18">Create your first Dashboard</h1>
							<p>Create Analyze Share</p>
							<div class="DF JC"><button :type="isPremiumUser ? 'button' : 'disabled'" class="button rds4" @click="onClickCreatDashboard()">+ Create your first dashboard</button></div>
						</div>
						</div> 
				</div>
				<div  class="txt-cntr" v-if="_.isEmpty(selectedTabDashboards) && tabIndex==2 ">
						<div class="emptyTextWrap">
							<h1 class="fs-18">Create your first Dashboard</h1>
							<p>Create Analyze Share</p>
							<div class="DF JC"><button :type="isPremiumUser ? 'button' : 'disabled'" class="button rds4" @click="onClickCreatDashboard()">+ Create your first dashboard</button></div>
						</div> 
				</div>
				<div  class="txt-cntr" v-if="_.isEmpty(selectedTabDashboards) && tabIndex==3 ">
						<div class="emptyTextWrapShrd">
							<h1 class="fs-18">No shared dashboards yet!</h1>
							<p>Dashboards shared with you will appear here. Check back soon!</p>
						</div> 
				</div>
			</div>
		</div>
		`,

    props : {
		isGlobal: {
            type: Boolean,
			default: () => { return true }
        }
	},
    watch : {},

    data() {
        return {

            tabIndex : 1,

            openDashboard: false,

            dashboardPopup: {
				show: false,
				dashboard: undefined,
				tabIndex : 0
			},

            allDashboards:[],
            selectedTabDashboards: [],

            selectedDashboard:{},
            openCreateDashboard:false,
            selectedDashboardName:'',

            sortBy: {
				value: "created",
				ascending: true,
			},
			search: {
				text: ""
			},
			loading:false,
			
			loggedInUser : undefined,
        }
    },

    created() {
		this.loggedInUser = loggedInUser;
    },

    mounted() {
		this.loading = true;
        this.fetchAllDashBoards();
    },

    computed: {
		isPremiumUser: function () {
			if (this.loggedInUser.userCompanies && this.loggedInUser.userCompanies.length > 0) {
				let userCompany = this.loggedInUser.userCompanies[0];
				if (userCompany && userCompany.company) {
					return userCompany.company.isPremium;
				}
			}
			return false;
		}
		
		/*public Boolean getIsPremium() {
		if(PropertyValidator.isValid(this.getPaymentPackageConfig())) {
			if((PropertyValidator.isValid(this.getPaymentPackageConfig().getSAML()) && this.getPaymentPackageConfig().getSAML().equals(Boolean.TRUE)) ||
				(PropertyValidator.isValid(this.getPaymentPackageConfig().getLiveChat()) && this.getPaymentPackageConfig().getLiveChat().equals(Boolean.TRUE)) ||
				(PropertyValidator.isValid(this.getPaymentPackageConfig().getoAuth()) && this.getPaymentPackageConfig().getoAuth().equals(Boolean.TRUE)) ||
				(PropertyValidator.isValid(this.getPaymentPackageConfig().getSecurity()) && this.getPaymentPackageConfig().getSecurity().equals(Boolean.TRUE)) ||
				(PropertyValidator.isValid(this.getPaymentPackageConfig().getSolutionBoard()) && this.getPaymentPackageConfig().getSolutionBoard().equals(Boolean.TRUE))) {
				return true;
			}
			else {
				return false;
			}
		}
		else {
			return false;
		}
	}*/
	
    },

    components: {
    'kendis-dashboard-homepage': kendisDashboardHomepage,
    'kendis-create-dashboard'  : kendisCreateDashboard,
    },

    methods: {
        
        /////////////////////////////////////////
        //////////////   LOGIC
        filterDashboardsAccordingToTab: function () {
			
			this.search.text = "";
			
			let filteredDashboards = [];
			if (this.tabIndex == 0) {
				//...   favorite
				_.each(this.allDashboards, dashboard=> {
					dashboard.filterOn = true;
					if (dashboard.favorite) {
						filteredDashboards.push(dashboard);
					}
				});
			}
			else if (this.tabIndex == 1) {
				//...   all
				_.each(this.allDashboards, dashboard=> {
					dashboard.filterOn = true;
					filteredDashboards.push(dashboard);
				});
			}
			else if (this.tabIndex == 2) {
				//...   my
				_.each(this.allDashboards, dashboard=> {
					dashboard.filterOn = true;
					if (dashboard.owner 
						&& dashboard.owner.id == loggedInUser.id) {
						filteredDashboards.push(dashboard);
					}
				});
			}
			else if (this.tabIndex == 3) {
				//...   shared
				_.each(this.allDashboards, dashboard=> {
					dashboard.filterOn = true;
					if (dashboard.sharedWithMe) {
						filteredDashboards.push(dashboard);
					}
				});
			}
			
			this.selectedTabDashboards = filteredDashboards;
		},
		applySort: function () {
			let _this = this;
			if (this.sortBy.value == 'created') {
				this.selectedTabDashboards = this.selectedTabDashboards.sort((a, b) => {
					if (a.createdOn && b.createdOn) {
						if (_this.sortBy.ascending) {
							return a.createdOn > b.createdOn ? 1 : -1;
						}
						else {
							return a.createdOn > b.createdOn ? -1 : 1;
						}
					}
					else {
						return 1;
					}
				});
			}
			else if (this.sortBy.value == 'updated') {
				
				this.selectedTabDashboards = this.selectedTabDashboards.sort((a, b) => {
					if (a.updatedOn && b.updatedOn) {
						if (_this.sortBy.ascending) {
							return a.updatedOn > b.updatedOn ? 1 : -1;
						}
						else {
							return a.updatedOn > b.updatedOn ? -1 : 1;
						}
					}
					else {
						return 1;
					}
				});
			}
			else if (this.sortBy.value == 'title') {
								
				this.selectedTabDashboards = this.selectedTabDashboards.sort((a, b) => {
					if (_this.sortBy.ascending) {
						return a.name.toLowerCase() > b.name.toLowerCase() ? 1 : -1;
					}
					else {
						return a.name.toLowerCase() > b.name.toLowerCase() ? -1 : 1;
					}
				});
			}
			else if (this.sortBy.value == 'owner') {
				
				this.selectedTabDashboards = this.selectedTabDashboards.sort((a, b) => {
					if (a.owner && b.owner) {
						if (_this.sortBy.ascending) {
							return a.owner.fullName.toLowerCase() > b.owner.fullName.toLowerCase() ? 1 : -1;
						}
						else {
							return a.owner.fullName.toLowerCase() > b.owner.fullName.toLowerCase() ? -1 : 1;
						}
					}
					else {
						return 1;
					}
				});
			}
		},
        applyFilter: function () {
			if (!_.isEmpty(this.search.text)) {
				
				let lowerQuery = this.search.text.toLowerCase();
				_.each(this.selectedTabDashboards, dashboard=> {
					let lowerName = dashboard.name.toLowerCase();
					let lowerKey = dashboard.key.toLowerCase();
					
					if (lowerName.includes(lowerQuery) || lowerKey.includes(lowerQuery)) {
						dashboard.filterOn = true;
					}
					else {
						dashboard.filterOn = false;
					}
				});
			}
			else {
				_.each(this.selectedTabDashboards, dashboard=> {
					dashboard.filterOn = true;
				});
			}
		},
        /////////////////////////////////////////
        //////////////   API CALLS
        fetchAllDashBoards: function(){
			
			let _this = this;
			let _url = "/dashboard/getAllDashboards";
			if(window.location.pathname == '/org'){
				let params = _this.$route.fullPath.split('/');
				if(params && params[2]){
					_url = "/dashboard/sub-list/workSpaceKeys/"+params[2];
				}
			}else if(window.location.pathname == '/solutions' && vueInstance && vueInstance.activeSolutionId){
				_url = "/dashboard/sub-list/solutionBoardIds/"+vueInstance.activeSolutionId;
			}
            axios.get(_url).then(response=>{
				
				if (response.data) {
					let dashboards = response.data.dashboards;
					_.each(dashboards, dashboard=> {
						let favorite = false;
						if (dashboard.favoriteMapByUserId
							&& dashboard.favoriteMapByUserId[loggedInUser.id]) {
							favorite = true;
						}
						dashboard.favorite = favorite;
					});
					_this.allDashboards = dashboards;
                	_this.filterDashboardsAccordingToTab();
					this.loading = false;
				}
                
            }).catch(e=>{
				this.loading = false;
                console.error(e);
            })
        },
        markDashboardFavorite: function(dashboard, favorite){
			
			let _this = this;
			
			let data = {};
			data.dashboardId = dashboard.id;
			data.favorite = favorite;
			
			axios.post("/dashboard/markFavoriteDashboard", data)
				.then(response => {
					if (response.data) {
						if (response.data.success) {
							
							dashboard.favoriteMapByUserId = response.data.dashboard.favoriteMapByUserId;
							
							if (favorite) {
								dashboard.favorite = true;
								showTopMessage("Dashboard is marked as Favorite.","success");
							}
							else {
								showTopMessage("Dashboard is removed from Favorite list.","success");
								dashboard.favorite = false;
								if (_this.tabIndex == 0) {
									let index = _.findIndex(_this.selectedTabDashboards,{id: dashboard.id});
									if (index >= 0) {
										_this.selectedTabDashboards.splice(index, 1);
									}
								}
							}
						}
					}
				}).catch(e => {

				})
        },
        deleteDashboard: function(dashboard){
			
			let _this = this;
			
			axios.delete("/dashboard/deleteDashboard/"+dashboard.id)
				.then(response => {
					if (response.data) {
						if (response.data.success) {
							showTopMessage("Dashboard has been deleted",'success');
							_this.spliceDashboard(dashboard);
						}
					}
				}).catch(e => {

				})
        },
        spliceDashboard: function(dashboard){
			let _this = this;
			let index = _.findIndex(_this.selectedTabDashboards, { id: dashboard.id });
			if (index >= 0) {
				_this.selectedTabDashboards.splice(index, 1);
			}
			index = _.findIndex(_this.allDashboards, { id: dashboard.id });
			if (index >= 0) {
				_this.allDashboards.splice(index, 1);
			}
		},
        /////////////////////////////////////////
        //////////////   EVENTS
        onClickNavigateToReports: function () {
			window.location = "/report";
		},
        onDashboardPopupCreated:function(dashboard){
			
			this.openCreateDashboard=false;
			this.dashboardPopup.show=false;
			
			if (this.allDashboards.length > 0) {
				this.allDashboards.splice(0, 0, dashboard);
			}
			else {
				this.allDashboards.push(dashboard);
			}
            this.filterDashboardsAccordingToTab();
		},
		onDashboardPopupUpdated: function (dashboard, closePopup) {
			
			if (closePopup) {
				this.openCreateDashboard=false;
				this.dashboardPopup.show=false;
			}
			
			let existing = _.find(this.allDashboards, {id: dashboard.id});
			if (existing) {
				existing.name = dashboard.name;
				existing.description = dashboard.description;
				existing.shared = dashboard.shared;
				existing.workSpaceKeys = dashboard.workSpaceKeys;
				existing.solutionBoardIds = dashboard.solutionBoardIds;
				
				let exists = true;
				if(window.location.pathname == '/org'){
					let params = this.$route.fullPath.split('/');
					if(params && params[2]){
						if(_.indexOf(existing.workSpaceKeys,params[2]) < 0 && _.indexOf(existing.workSpaceKeys,'-') < 0){
							exists = false;
						}
					}
				}else if(window.location.pathname == '/solutions' && vueInstance && vueInstance.activeSolutionId){
					if(_.indexOf(existing.solutionBoardIds,vueInstance.activeSolutionId) < 0){
						exists = false;
					}
				}
				if(!exists){
					this.spliceDashboard(dashboard);
				}
			}
		},
		onRoleUpdateForAll : function (flag) {
			let existing = _.find(this.allDashboards, {id: this.dashboardPopup.dashboard.id});
			if (existing) {
				existing.sharedWithAll = flag;
			}
		},
        onChangeTab: function (tab) {
            this.tabIndex = tab;
            this.filterDashboardsAccordingToTab();
            this.applySort();
        },
		onSearchInput: function () {
			this.applyFilter();
		},
        onClickCreatDashboard: function(){
			if (!this.isPremiumUser) {
				return;
			}
			this.dashboardPopup.dashboard = undefined;
            this.dashboardPopup.show = true;
        },
        onClickSortDashboards: function (sortKey) {
			if (sortKey == this.sortBy.value) {
				this.sortBy.ascending = !this.sortBy.ascending;
			}
			else {
				this.sortBy.ascending = true;
				this.sortBy.value = sortKey;
			}
			this.applySort();
		},
		//........   dashboard popup
		onDashboardPopupClose: function () {
			this.dashboardPopup.dashboard = undefined;
			this.dashboardPopup.show = false;
		},
        //........   dashboard row 
        onDashboardRowOpen: function(dashboard){
			if(this.isGlobal){
				this.$router.push({ path: dashboard.key});
			}else{
				this.$router.push({ path: this.$route.path+'/'+dashboard.key});
			}
            // this.selectedDashboard = dashboard.id;
            // this.selectedDashboardName = dashboard.name;
            // this.openDashboard = true;
        },
        onDashboardRowFavorite: function (dashboard) {
			if (dashboard.favorite) {
				this.markDashboardFavorite(dashboard, false);
			}else {
				this.markDashboardFavorite(dashboard, true);
			}
		},
		onDashboardRowAction: function (action ,dashboard) {
			if (action == "edit") {
				this.dashboardPopup.dashboard = dashboard;
				this.dashboardPopup.show = true;
				this.dashboardPopup.tabIndex = 0;
			}
			else if (action == "delete") {
				let _this = this;
				askFromSweetAlertWrapper('Do you want to delete this dashboard?', [()=>{
					_this.deleteDashboard(dashboard);
				}], [takeNoAction]);
			}else if(action == 'share') {
				this.dashboardPopup.dashboard = dashboard;
				this.dashboardPopup.show = true;
				this.dashboardPopup.tabIndex = 1;
			}
		}
    },
})

var dashboardFilesLoaded = true;
const dynamicPopupRendererMixin = {
    data() {
        return {

        }
    },
    methods: {
		closeHomePage: function(){
			this.dashboardSelectedId = '';
			let fullPath = this.$route.fullPath;
			fullPath = fullPath.split('/');
			fullPath.splice(fullPath.length - 1);
			window.location.hash = fullPath.join('/');
		},
        getFormElementObject: function (formConfig) {
            let formValues = {};
            Object.keys(formConfig.elements).forEach(key => {
                formValues[key] = formConfig.elements[key].value;
            });
            return formValues;
        },
        resetFormElementValues: function (formConfig) {
            Object.keys(formConfig.elements).forEach(key => {
                if(!_.isEmpty(formConfig.elements[key].element.defaultValue)) {
                    formConfig.elements[key].value = formConfig.elements[key].element.defaultValue;
                } else if(key == 'id') {
                    formConfig.elements[key].value = undefined;
                } else {
                    formConfig.elements[key].value = "";
                }

            });
        },
        initializeFormElementValue: function (formConfig, formObject) {
            Object.keys(formObject).forEach(key => {
                if(formConfig.elements.hasOwnProperty(key)) {
                    formConfig.elements[key].value = formObject[key];
                }
            });
        },
        resetButtonsVisibility: function(formConfig) {
            Object.keys(formConfig.buttons).forEach(key => {
                formConfig.buttons[key].show = formConfig.buttons[key].element.visibility;
            });
        }
    }
}

const DASHBOARDS = Vue.component('dashboard-list', {
    template: `
        <div>
        	<div v-if="dashboardFilesLoaded == false" class="loader" style="width: calc(100% - 16%);margin-left: 16%;">
				<div>
					<div class="loaderinteg"></div>
					<div >loading dashboards...</div>
				</div>
			</div>
			<span v-else style="width: calc(100% - 16%);margin-left: 16%;">
	        	<kendis-dashboard-listview v-if="_.isEmpty(dashboardSelectedId)" :is-global="false" ref="dashboardlisting" ></kendis-dashboard-listview>
	        	<kendis-dashboard-homepage v-else :is-global="false" :dashboardSelectedId="dashboardSelectedId" ref="dashboardHome" @close="closeHomePage" style="width: calc(100% - 16%);margin-left: 16%;"></kendis-dashboard-listview>
			</span>
        </div>
    `,
    mixins: [dynamicPopupRendererMixin],
    props: {
        dashboardSelectedId: {
            type: String,
			default: () => { return '' }
        }
    },
    data(){
        return {
            dashboardFilesLoaded:false
        };
    },
    created() {
		this.init();
	},
    mounted() {
    },
    components: {
		//'kendis-dashboard-listview': kendisDashboardListview,
		//'kendis-dashboard-homepage': kendisDashboardHomepage,
	},
    computed: {

    },
    methods: {
		init : function(){
			let _this = this;
			var waitingForFiles = setInterval(function() {	
				try{
					if(typeof dashboardFilesLoaded !== 'undefined' && dashboardFilesLoaded === true) {
						clearInterval(waitingForFiles);
						_this.dashboardFilesLoaded = true;
					}
				}catch(e){}            
			}, 50);	
		}
    }
});