const BACKLOG_ITEM_COPY = Vue.component("backlog-item-copy", {
    name: "backlog-item-copy",
    template: `
		<div class="rec">					
			<div class="rc c3 DF kyout">
				<a v-if="item.almKey" class="key ftsb jiraKeyHandle kendisOnly" :href="item.url" target="_blank">
					    {{item.almKey}}
				</a>
				<a v-else-if="item.fields && item.fields.externalKey" :href="item.fields.externalLink" class="key ftsb jiraKeyHandle kendisOnly" target="_blank">
					    {{item.fields.externalKey}}
				</a>
				<a v-else-if="item.kendisKey" class="key ftsb jiraKeyHandle kendisOnly" target="_blank">
					    {{item.kendisKey}}
				</a>
				<div v-else>--</div>
				<div class="ti-bell kyico bell c-point" v-if="item.fields && item.fields.AlmSyncError" style="color:red;" @click="onClickShowAlmError"></div>
				<div class="ti-light-bulb kyico bulb" v-if="item.dirty && !isChild" title="This item needs ReSnyc"></div>
			</div> 
			<div v-for="column in columns">
				<div v-if="column == 'status'" class="rc c3 status  DF">
						<span class="sts ftsb" v-if="item.status" :class="item.status.title == 'ToDo' ? 'a' : item.status.title == 'InProgress' ? 'b' : item.status.title == 'Done' ? 'c' : 'd' " >
						    {{item.status.title}}
						</span>
						<span v-else>--</span>-
					</div>			
				<div v-else-if="column == 'estimate'" class="rc c3 spctg" :title="totalEstimateTooltip">
						<span class="ftsb">{{item.totalEstimate}}</span>
					</div>
				<div v-else-if="column == 'teams'" class="rc c3 tm DF">
						<template v-if="root.flags.teams === true"><div>
							<div class="tm lbl-bg tooltip" v-for="(team,key) in item.teamData" v-if="team && team.id" v-bind:style="{color:team.color}">
								<div class="line" v-bind:style="{'background-color':(team.color+30)}"></div>
								{{team.label}}<div class="hovtooltipB">{{team.title}}</div>
							</div>
						</div></template>
						<span v-else>--</span>
					</div>
				<div v-else-if="column == 'sprints'" class="rc c3 sp DF">
						<template v-if="root.flags.containers === true"><div>
							<div v-for="sprint in item.containerData" v-if="sprint && sprint.id" class="spttg nsw mxwd tooltip">
								<span>{{sprint.label}}</span>
								<div class="hovtooltipB">{{sprint.title}}</div>
							</div>
						</div></template>
						<span v-else>--</span>
					</div>
				<div v-else-if="column == 'startDate'" class="rc c3 spctg"><span v-if="item.fields && item.fields.StartDate">{{formatDate(item.fields.StartDate,'dd mmm, yy')}}</span><span v-else>--</span></div>
				<div v-else-if="column == 'endDate'" class="rc c3 spctg"><span v-if="item.fields && item.fields.EndDate">{{formatDate(item.fields.EndDate,'dd mmm, yy')}}</span><span v-else>--</span></div>							
				<div v-else-if="column == 'boards'" class="rc c3 blnk">
				    <template v-if="root.flags.boards === true">
					    <div v-for="boardLink in item.boardsData" class="spttg nsw mxwd tooltip">
							<span  class="sss">
								{{boardLink.prefix?boardLink.prefix:boardLink.title}}
							</span>
							<div class="hovtooltipB ">{{boardLink.title}}</div>								
						</div>
					</template>
					<span v-else>--</span>
				</div>
				<div v-else-if="column == 'solutionBoards'" class="rc c3 blnk">
						<template v-if="root.flags.solutionBoards === true"><div>
							<div v-for="boardLink in item.solutionBoardsData" class="spttg nsw mxwd tooltip">
								<span >
									{{boardLink.prefix?boardLink.prefix:boardLink.title}}
									<div class="hovtooltipB">{{boardLink.title}}</div>
								</span>
							</div>
						</div></template>
						<span v-else>--</span>
					</div>
				<div v-else-if="column == 'batches'" class="rc c3 DF">
						<template v-if="root.flags.batches === true">
						<div>
							<div v-for="batch in batchesList" class="spttg nsw mxwd tooltip">
								<span v-if = "batch.key && batch.title" @click="redirectToUrl(batch.key)">{{batch.key}} : {{batch.title}}</span>
							    <div class="hovtooltipB ">{{batch.title}}</div>								
							</div>
							</div>
						</template>
						<span v-else>--</span>
					</div>
                <div v-else-if="column == 'fetchedBy'" class="rc c3 DF">
                        {{item.fetchedBy.fullName}}
                    </div>
				<div v-else-if="column == 'responsible'" class="rc c3 DF">
						<span v-if="item.fields.AssignedTo && item.fields.AssignedTo.displayName">{{item.fields.AssignedTo.displayName}}</span>
						<span v-if="item.fields.assignee">{{item.fields.assignee.displayName}}</span>
						<span v-else>--</span>
					</div>
				<div v-else-if="column == 'updated'" class="rc c3 DF">
						<span v-if="column == 'updated'">{{formatDate(item.updatedOn,'dd mmm, yy')}}</span>
						<span v-else>--</span>
					</div>
				<div v-else-if="column == 'created'" class="rc c3 DF">
					    <span v-if="column=='created'">{{formatDate(item.createdOn,'dd mmm, yy')}}</span>
						<span v-else>--</span>
					</div>
				<div v-else-if="column == 'creater'" class="rc c3 DF">
						<span v-if="item.fields.CreatedBy && item.fields.CreatedBy.displayName">{{item.fields.CreatedBy.displayName}}</span>
						<span v-if="item.fields.reporter">{{item.fields.reporter.displayName}}</span>
						<span v-else>--</span>
					</div>
				<div v-else-if="column == 'fetchedBy'" class="rc c3 DF">
						<span v-if="item.fetchedBy">{{item.fetchedBy.fullName}}</span>
						<span v-else>--</span>
					</div>
                <!--<div v-else-if="column == 'priority'" class="rc c3 DF">-->
                <!--<span v-if="item.fetchedBy">&#45;&#45;</span>-->
                <!--<span v-else>&#45;&#45;</span>-->
                <!--</div>-->
				<div v-else class="rc c3 DF">
					<span>--</span>
				</div>
			</div>
		</div>
		`,
    props: ["item", "level", "releaseTrainId","columns"],
    data() {
        return {
            almError: {
                show: false,
                message: ""
            },
            batchesList:[],
            teamsList:[],
            sprintsList:[],

            root:{flags:{
                    teams:false,
                    status:false,
                    boards:false,
                    containers:false,
                    solutionBoards:false,
                    batches:false
                }
            }
        }
    },
    created() {
    },
    components: {
    },
    mounted() {
        this.loadBatchesItems();
        this.root.flags.teams=true;
        this.root.flags.status=true;
        this.root.flags.boards=true;
        this.root.flags.containers=true;
        this.root.flags.solutionBoards=true;
    },
    watch: {},
    computed: {
        totalEstimateTooltip() {
            return "Rollup Estimate";
        },
    },
    methods: {
        loadBatchesItems() {
            _.each(this.getItemRelations(this.item, "batchRelations"), link => {
                if ( link.linkType == "Batch") {
                    axios.get('batch/get-batch-by-id/'+link.baseItemId).then(response=>{
                        this.batchesList.push(response.data.objective);
                    }).catch(e=>{
                        console.error(e);
                    })
                }
            });
            this.root.flags.batches=true;
        },
        getItemRelations(item, link){
            if(item[link]) return item[link];
            else return [];
        },
        formatDate: function(date, format) {
            if (date) {
                return dateFormat(date, format);
            }
            return "";
        },
        redirectToUrl: function (key) {
            let url =  "batches#/" + key;
            window.open(url, "_blank");
        },
        getMetaDetail: function(type, bid) {
            let item = {};
            if (type='batches' && this.batches[bid]) {
                item = this.batches[bid];
            }
            return item;
        },
        onClickShowAlmError: function () {
            if(this.getAlmAccountType == 'jira'){
                handleJiraError(this.item.fields);
                return;
            }
            let error = JSON.parse(this.item.fields.AlmErrorMesaage);
            this.almError.message = error.message;
            this.almError.show = true;
        },
    }
});
try{
Vue.use(VueRouter);
Vue.use(Pinia.PiniaVuePlugin);
Vue.use(Pinia.createPinia());
Vue.use(VueObserveVisibility);
}catch(e){}
//Pinia store used to store items of graph, to make it available for all components.
const iconsStore = Pinia.defineStore('iconsStore', {
    state() {
        return {
            cssMap: "",
            cssVu: "",
        }
    },
    getters: {
        getCssMap() {
            return this.cssMap;
        },
        getCssVu() {
            return this.cssVu;
        },
    },
    actions: {
        setCssMap(items) {
            this.cssMap = items;
        },
        setCssVu({widgetId, itemList}) {
            this.cssVu[widgetId] = itemList;
        },
    },
});

const dashboardPopupComponent = Vue.component('dashboard-list-items-popup', {
    template:`
     <div id="overlay" class="overlay" style="display: block;">	
         <div v-if="data.graphType === 'Custom Graphs' " class="dependpop additionalClass">			
                <div v-if="loader.show" class="loader"><div><div class="loaderinteg"></div></div></div>
                <div class="head analyticsPopup">
                   <div class="DFA gap-1">
                      <span class="fs-18 ftsb">{{mainTitle}}</span>
                      <span class="calcTxt first ftsb">Total : {{totalItemsCount}}</span> 
                      <span class="calcTxt ftsb">Done  : {{doneItemsCount(popupData)}}</span> 
                      <span class="calcTxt last ftsb">Percentage  : {{compleationPercentage(popupData)}} %</span> 
                   </div>       
                   <em @click="hide()" title="Close" class="rmv-ico ti-close rnd DAJ p-intial"></em>                                                                
                </div>
                <div class="DropsSec DFA JE">        
                    <div class="p-rel srchTop">
								<i class="ti-search srchfiltico"></i>
								<input v-model="filters.searchText" type="text" placeholder="Search..." class="activeText filtersearch" @change="onFiltersChangeSearchText">
				    </div>
                    <div class="selectcont column whtar ml-10 w-200">
                             <vz-select :multiple="true" empty-selection-text="Columns"  
                                class="multi-filter" value-type="value"
                                :options="$options.columnOptions" v-model="columns.selected"
                                :show-select-all=true @select="onColumnsSelectValue" />
                    </div>                        
                </div>  
                <div class="cntr mrow mb-15">
                    <div v-if="noData" class="nofound fs-14">{{noDataMsg}}</div>                                     
                    <div v-if="data != undefined && popupData != undefined && popupData.length > 0" class="table prow graphDetailPopUp">
                        <div class="rec hd">
                            <div class="rc c3 id">Key</div>
                            <div v-for="column in columns.selected" class="rc c3">
                                <span v-if="$options.columsMap[column]">
                                    {{ $options.columsMap[column].title }}
                                </span>
                            </div>
                        </div>    
                        <div class="prow">      
                            <div v-for="(backlogItem,backlogItemIndex) in popupData">
                                <backlog-item-copy  
                                    :key="backlogItem.id"
                                    :item="backlogItem"
                                    :release-train-id="data.releaseTrainID"
                                    :level="1"
                                    :columns="columns.selected"
                                    >
                                </backlog-item-copy>
                            </div>  
                        </div>                                            
                    </div>
                    <!-- <div v-if="!noData && popupData.length < 1" class="nofound fs-14 prow">No match found</div>-->
                </div>
                <div class="prow pagging pb-15">
                       <input hidden="hidden" type="number" title="temporary binding due to redrening issue"></input>
                       <template>
                           <div class="paginator" >
                               <vue-ads-pagination  :total-items="pagination.totalItemSize" :items-per-page="pagination.pageSize" v-on:page-change="onPaginatorChangePage">
                                    <template slot-scope="props"><div class="txt">{{ props.start }} to {{ props.end }} of {{ props.total }} Items</div></template>
                               </vue-ads-pagination>
                           </div>
                           <span class="selectcont pgsize">
                               <select v-model="pagination.pageSize" class="" @change="onChangePageSize">
                                    <option v-for="option in pagination.pageSizeOptions" :value="option">{{option}}</option>
                                </select>
                            </span>
                        </template>
                    </div>

            </div>
              
         <div v-if="data.graphType === 'Flow Metrices' || data.graphType === 'Cumulative Flow Diagram' || data.graphType === 'Completion by Teams' || data.graphType == 'Flow Metrics' " class="dependpop graphDetailPopUpContainer">			
                <div v-if="loader.show" class="loader"><div><div class="loaderinteg"></div></div></div>
                <div class="graphDetailPopUpHeader">
                   <div class="DFA">
                      <span class="fs-22 ftsb">{{data.popupTitle}}</span>
                      <!-- <span class="graphDetailPopUpHeaderCount">{{data.total}}</span>-->
                   </div> 
                   <div class="DFA gap-2">  
						<div class="ti-search sreachIcon p-rel">
							<input v-model="search.text" type="text" placeholder="Search..." class="listingSearch rds4" @input="onSearchInput" />
						</div>					

                       <div class="selectcont rhtsd statusDrop">
                             <vz-select :multiple="true" empty-selection-text="Columns"
                             selected-title="Columns" class="multi-filter" value-type="value"
                                :options="$options.columnOptions" v-model="columns.selected"
                                 @select="onColumnsSelectValue" />
                       </div>              
                        <div class="p-rel c-point impout">
                        	<div class="slctdn rds4" onclick="showOverLay(this,'#analytics-popup_export')" data-overlayopener="analytics-popup_export">
	                        	<a href="javascript:void(0);"><em class="ti-import"></em></a>
		                        <ul class="drop_box" id="analytics-popup_export" style="display: none;">
			                        <li @click="exportChartDetail('csv')"><a class="applyfilter" href="javascript:void(0);">Export CSV</a></li>
			                        <li @click="exportChartDetail('xls')"><a class="applyfilter" href="javascript:void(0);">Export Excel</a></li>
		                        </ul>
	                        </div>
                        </div>
                       <em @click="hide()" title="Close" class="rmv-ico ti-close rnd DAJ"></em>
                   </div>                                                                
                </div> 
                <div class="graphDetailPopUpinnerHeader" v-if="dataOfItems.length >= 0">   
                    <div>
                    <div class="fs-16 DFA" v-if="data.graphSpecificType == 'flow-time-graph' || data.graphSpecificType == 'cycle-time-graph' || data.graphSpecificType == 'cycle-time-graph-detail-view' || data.graphSpecificType == 'lead-time-graph' || data.graphSpecificType == 'lead-time-graph-detail-view' || data.graphSpecificType == 'flow-time-graph-detail' ">
                        <span class="status-badge mr-5">{{fromStatus}}</span> To <span class="status-badge ml-5">{{toStatus}}</span>
                    </div>
                    </div>  
                    <div class="DFA">
                    <div class="DFA">
                    	<div class="selectcont dropItem rhtsd rds4 ml-10 w-a h-auto" v-if="columns?.selected?.includes('statusOfItem') && data.graphSpecificType=='cs'">
							<vz-select v-model="filteredSelectedStatus" :options="filterStatus" :multiple="true"  empty-selection-text="Select Status" :selected-title="selectedStatusMessage(filteredSelectedStatus)" label="title" track-by="title" value-type="value" @select="onSelectSprintOrTeamFilterData('Status')" />							
						</div>   
                    	<div class="selectcont dropItem rhtsd rds4 ml-10 w-a h-auto">
							<vz-select v-model="filteredSelectedTeams" :options="filterTeams" :multiple="true"  empty-selection-text="Select Team" :selected-title="selectedTeamMessage(filteredSelectedTeams)" label="title" track-by="title" value-type="value" @select="onSelectSprintOrTeamFilterData('Team')" />							
						</div>
						<div class="selectcont dropItem rhtsd rds4 ml-10 w-a h-auto">
							<vz-select v-model="filteredSelectedSprints" :options="filterSprints" :multiple="true"  empty-selection-text="Select Sprints" :selected-title="selectedSprintMessage(filteredSelectedSprints)" label="title" track-by="title" value-type="value" @select="onSelectSprintOrTeamFilterData('Sprint')" />							
						</div>
						<div class="selectcont dropItem rhtsd rds4 ml-10 w-a h-auto">
							<vz-select v-model="filteredSelectedIssueTypes" :options="filterIssueTypes" :multiple="true"  empty-selection-text="Select Issue Type" :selected-title="selectedIssueTypeMessage(filteredSelectedIssueTypes)" label="title" track-by="title" value-type="value" @select="onSelectSprintOrTeamFilterData('IssueType')" />							
						</div>
					</div>
                    <div class="itemBox ml-30" v-if="data.average !== 'NaN' && data.chartType !== 'column' && data.graphSpecificType !== 'cfd' &&  data.graphSpecificType !== 'flow-time-graph-detail' &&  data.graphSpecificType !== 'flow-velocity-graph-detail'  && data.graphSpecificType !== 'flow-efficiency-graph-detail'  && data.graphSpecificType !== 'flow-velocity-graph'   && data.graphSpecificType !== 'flow-load-graph'  && data.graphSpecificType !== 'flow-distribution-graph'   ">
                        <div class="DF AlignBase">
                            <h2 class="fs-34">{{data.average}}</h2>
                            <span v-if="data.graphSpecificType == 'flow-time=line-graph'" class="ml-5">Days</span>
                            <span v-if="data.graphSpecificType == 'flow-efficiency-graph'"  class="ml-5">%</span>
                            <span v-if="data.graphSpecificType == 'flow-velocity-graph' || data.graphSpecificType == 'flow-load-graph' || data.graphSpecificType == 'flow-distribution-graph' "  class="ml-5">Items</span>                      
                        </div>
                        <div class="ftsb ml-5" style="color: #5C697C;" v-if="data.graphSpecificType!='cs'"> 
                            Average of items displayed
                            <span class="tooltip  ml-10">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip rds4" style="right: 0px;">
                                    The average number of days taken by all features to move through the selected workflows.
                                </div>
                            </span>
                         </div>
                    </div>
                    </div>
                    <!-- <div class="itemBox" v-if="data.total !== 'NaN' && data.graphSpecificType === 'cfd' || data.graphSpecificType === 'flow-time-graph-detail'  || data.graphSpecificType === 'flow-efficiency-graph-detail' || data.graphSpecificType === 'flow-velocity-graph' || data.graphSpecificType === 'flow-load-graph' || data.graphSpecificType === 'flow-distribution-graph' ">-->
                    <!-- <div class="DF AlignBase">-->
                    <!--<h2 class="fs-34"> -->
                    <!--{{pagination.totalItemSize}} -->
                    <!--</h2>-->
                    <!--<span v-if="data.graphSpecificType == 'flow-time-graph'"  class="ml-5">Days</span>-->
                    <!--<span v-if="data.graphSpecificType == 'flow-efficiency-graph'"  class="ml-5">%</span>-->
                    <!--<span v-if=" data.graphSpecificType == 'cycle-time-graph' || data.graphSpecificType == 'cycle-time-graph-detail-view' || data.graphSpecificType == 'lead-time-graph' || data.graphSpecificType === 'lead-time-graph-detail-view' || data.graphSpecificType == 'flow-velocity-graph' || data.graphSpecificType == 'flow-load-graph' || data.graphSpecificType == 'flow-distribution-graph' " class="ml-5">Items</span>                      -->
                    <!--</div>-->
                    <!--<div class="ml-5 ftsb" style="color: #5C697C;"> -->
                    <!--Number of items displayed-->
                    <!--<span class="tooltip  ml-10">-->
                    <!--<em class="infotxt"></em> -->
                    <!--<div class="hovtooltip rds4" style="right: 0px;">-->
                    <!--text test here-->
                    <!--</div>-->
                    <!--</span>-->
                    <!--</div>-->
                    <!--</div>-->
                </div> 
                
                <div class="cntr mrow mb-5 scrollBar of-a detail-pad">
                    <div v-if="dataOfItems.length < 1" class="nofound mb-50 fs-14">{{noDataMsg}}</div>                                  
                    <ul v-if=" data != undefined && dataOfItems.length > 0" class="table prow graphDetailPopUp" id="items">
                        <li class="rec hd mb-0">
                            <div class="rc c3 id c-point" data-header="details" @click="onClickSort('title')">Details
                            	<img v-if="sortBy.value =='title' " src="/assets/icons/Dashboard/sort.svg" alt=".." class="ml-5 c-point sortIcon" :class="{'active':(this.sortBy.ascending)}"/>
                            </div>
                            <span style="display: none" data-header="title">Title</span>
                            <div v-for="column in columns.selected" class="rc c4" :class="[isSortableColumn($options.columsMap[column].title)?'c-point':'']">
                                <span v-if="$options.columsMap[column]" @click="onClickSort($options.columsMap[column].title)" class="tooltip">
                                    <span :data-header="$options.columsMap[column].dataHeader" >
                                    {{$options.columsMap[column].title}}
                                        <div v-if="$options.columsMap[column].title === 'Efficiency %'" class="hovtooltip">
                                            Efficiency = (Time in Active Statuses ÷ Total Time) × 100%
                                        </div>
                                    </span>
                                	<img 
                                      v-if="isSortableColumn($options.columsMap[column].title) && sortBy.value === $options.columsMap[column].title" 
                                      src="/assets/icons/Dashboard/sort.svg" 
                                      alt="Sort icon" 
                                      class="ml-5 c-point sortIcon" 
                                      :class="{ 'active': sortBy.ascending }" 
                                	/>
                                </span>
                            </div>
                        </li>  
                        <div class="prow poupupItemsList scrollBar">  
                            <li class="rec mb-0 DFA" v-for="(item) in dataOfItems" v-if="item.filterOn">
                            	<div class="rc c3 DF">
                                        <div class="ftname tooltip mr-20" v-if="item.almUrl && data.graphSpecificType=='cs'" :class="{ breakthrough: item.itemRemoved }">
                                             <a class="key ftsb jiraKeyHandle kendisOnly"  :href="item ? item.parentItemUrl : ''"  target="_blank">
                                                <span class="tfico FL">
<!--                                                 <img v-if="item?.jiraFieldByKey?.parent" :src="item?.jiraFieldByKey?.parent?.fields?.issuetype?.iconUrl" class="azurico" alt="Azure" />-->
                                                    <img v-if="item?.parentIcon" :src="item?.parentIcon" class="azurico" alt="Azure" />					
                                                </span>
                                               
                                                <span v-if="item.key" data-header="details">{{ item?.parentKey  }}</span>
                                                <span v-else data-header="details" style="display: none;">-</span>
                                             </a>
                                              <div class="hovtooltip"> <span data-header="details">{{ item?.parentKey  }}</span></div>
                                        </div> 
                                        <div class=" kyout" v-if="item.title" :class="{ breakthrough: item.itemRemoved }">
                                             <a class="key ftsb jiraKeyHandle kendisOnly p-rel" target="_blank" :href="item ? item.itemURL : ''">
                                                <span class="tooltip tfico FL">
                                                    <img v-if="item.tfsItemTypeIcon" :src="item.tfsItemTypeIcon" class="azurico" alt="Azure" />					
                                                    <span v-if="item.tfsItemTypeIcon" class="hovtooltipBleft">{{item.tfsItemType}}</span>
                                                    <span v-else :class="itemIcon(item)" title="" :data-jira-issue-type-id="item.jiraIssueTypeId" :data-jira-project-key="item.jiraProjectKey" ></span>						
                                                    <!-- <span v-if="item.jiraIssueTypeId" class="hovtooltipBbtm">{{item.jiraFieldByKeyIssueType['name']}}</span>-->
                                                </span>
                                                <span v-if="item.key" data-header="details">{{ item.key }}</span>
                                                <span v-else data-header="details" style="display: none;">-</span>
                                             </a>
                                             <span class="txl p-rel" v-if="!_.isEmpty(item.title)" :title="item.title" data-header="title">{{item.title}}</span>
                                            <div v-else class="pl-5">-</div>
                                            <span v-if="item.itemRemoved === true" class="itemRemoved redtxt red-brd">Removed</span>
                                        </div>
                            	</div>  
                                        <div v-for="column in columns.selected" class="rc c4 status">
                                            <div v-if=" (data.graphSpecificType =='flow-load-graph' || data.graphSpecificType =='flow-distribution-graph') && (column == 'time' || column == 'status'  || column == 'efficiency' || column == 'items' || column == 'itemType')">
                                                <span v-if="item.days">
                                                    <span  class="sts new FL" v-bind:class="{ a: item.category=='ToDo',b: item.category=='InProgress',c: item.category=='Done',e: item.category=='Misc' }" data-header="status">{{item.days}}</span> <span v-if ="column == 'time'"> Days</span>
                                                </span>
                                                <span v-else class="pl-5">-</span>
                                            </div>	
                                            <div v-if=" (data.graphSpecificType !=='flow-load-graph' && data.graphSpecificType !=='flow-distribution-graph') && (column == 'time' || column == 'status'  || column == 'efficiency' || column == 'items' || column == 'itemType')">
                                                <span class="sts new FL" v-if="item.days">
                                                    <span data-header="status">{{item.days}}</span> <span v-if ="column == 'time'"> Days</span>
                                                </span>
                                                <span v-else class="pl-5">-</span>
                                            </div>	
                                            <div v-if="(column == 'statusOfItem' &&  data.radioButtonSelection =='statusCategory' && data.graphSpecificType!='cs')">
                                                <span class="sts new FL" v-bind:class="{ a: item.category=='ToDo',b: item.category=='InProgress',c: item.category=='Done',e: item.category=='Misc' }" v-if="item.status">
                                                    {{item.status}} </span>
                                                </span>
                                                <span v-else class="pl-5">-</span>
                                            </div>	
                                            <div v-if="column == 'statusOfItem' && data.graphSpecificType=='cs'">
                                                <span class="sts new FL" v-bind:class="{ a: item.category=='ToDo',b: item.category=='InProgress',c: item.category=='Done',e: item.category=='Misc' }" v-if="item.status">
                                                    {{item.status}} </span>
                                                </span> 
                                                <span v-else class="pl-5">-</span>
                                            </div>	
                                            <div v-if="column == 'estimate' && data.graphSpecificType=='cs'">
                                                <span class="sts new FL" v-if="item.status">
                                                    {{item.totalEstimate}} </span>
                                                </span> 
                                                <span v-else class="pl-5">-</span>
                                            </div>

                                            
                                            <!--<div v-if="column == 'groupBy'"  class="rc c3 status  DF">-->
                                            <!--<span class="sts ftsb" v-if="item.groupBy"  >-->
                                            <!--{{item.groupBy.join(',')}}-->
                                            <!--</span>-->
                                            <!--<span v-else>&#45;&#45;</span>-->
                                            <!--</div>-->
                                            <div v-if="column == 'startDate'" class="DF DW gap-1">
                                                <template v-if="!_.isEmpty(item.startDate)">
                                                    <div>
                                                    <span v-if="item.days">
                                                        <span data-header="startDate">{{formatDate(item.startDate)}}</span>
                                                    </span>
                                                    </div>
                                                </template>
                                                <span v-else class="pl-5">-</span>
                                            </div>
                                            <div v-if="column == 'date' && data.graphSpecificType=='cs'" class="DF DW gap-1">
                                                <template>
                                                    <div>
                                                    <span v-if="item.date">
                                                        <span class="sts new" data-header="Date" @click="onClickSort('date')" @mouseenter="showFullDate = item.date" @mouseleave="showFullDate = null"> {{ showFullDate === item.date ? toolTipDateSimplifiedSprints(item.date) : formatDateSimplifiedSprints(item.date) }}</span>
                                                    </span>
                                                        <span v-else class="pl-5">-</span>
                                                    </div>      
                                                </template>
                                            </div>
                                             <div v-if="column == 'endDate'" class="DF DW gap-1">
                                                <template v-if="!_.isEmpty(item.endDate)">
                                                    <div>
                                                    <span class="" v-if="item.days" data-header="endDate">
                                                        <span data-header="endDate">{{formatDate(item.endDate)}}</span>
                                                    </span>
                                                    </div>
                                                </template>
                                                <span v-else class="pl-5">-</span>
                                            </div>
                                            <div v-if="column == 'teams'" class="DF DW gap-1">
                                                <template v-if="!_.isEmpty(item.teams)">
                                                    <div
                                                        v-for="(teamValue, teamKey) in item.teams" :key="teamKey"
                                                        class="team-badge DAJ tooltip c-deflt"
                                                        :style="{ backgroundColor: teamValue.split('-color:')[1]+30, color: teamValue.split('-color:')[1] }">
                                                        {{teamKey}}
                                                        <div class="hovtooltip">
                                                            <span data-header="team">{{ teamValue.split('-color:')[0] }}</span>
                                                        </div>
                                                    </div>
                                                </template>
                                                <span v-else class="pl-5" data-header="team">-</span>
                                            </div>
                                          
                                          <div v-if="column == 'sprint'" class="DF DW gap-1">
                                            <template v-if="!_.isEmpty(item.sprints)">
                                                  <div class="sprint-badge tooltip c-deflt" v-for="(sprintValue, sprintKey) in item.sprints" :key="sprintKey">
                                                    {{ sprintKey }}
                                                    <div class="hovtooltip">
                                                        <span data-header="sprint">{{ sprintValue }}</span>
                                                    </div>
                                                  </div>
                                            </template>
                                            <span v-else class="pl-5" data-header="sprint">-</span>
                                          </div>
                                           <div v-if="column === 'assignee'" class="DF DW gap-1" >
                                                <template v-if="!_.isEmpty(item.assignee)">
                                                    <div v-if="_.isEmpty(item.assignee.avatarUrls)" class="DFA">
                                                        <div class="DFA tooltip assigneeBadge">
                                                            <div class="pic mr-10" data-header="assignee" @click="onClickSort('assignee')">
                                                                <div class="initial" :style="{ backgroundColor: '#1991EB' }">
                                                                    {{ findInitials(item.assignee.displayName) }}
                                                                </div>
                                                            </div>
                                                            <div class="hovtooltip">{{ item.assignee.displayName }}</div>                                                            
                                                        </div>                                                        
                                                    </div>
                                                    <div v-else class="DFA">                                                        
                                                        <div class="pic mr-5 tooltip">
                                                            <img :src="item.assignee.avatarUrls['32x32']" alt="Assignee Avatar" class="mr-5" />
                                                             <div class="hovtooltip">
                                                                {{ item.assignee.displayName }}
                                                            </div>
                                                        </div>
                                                        
                                                    </div>
                                                </template>
                                                <span v-else class="pl-5" data-header="assignee">-</span>
                                           </div>
                                        </div> 
                            </li>    
                        </div>                                        
                    </ul>
                    
                    
                    
                    
                    
                    <!-- <div v-if="!noData && dataOfItems.length < 1" class="nofound fs-14 prow">No match found</div>-->
                </div>
                <div class="prow pagging pb-15" style="padding-left: 70px;">
                       <input hidden="hidden" type="number" title="temporary binding due to redrening issue"></input>
                       <template>
                           <div class="paginator">
                               <vue-ads-pagination :total-items="data.total" :items-per-page="pagination.pageSize" v-on:page-change="onPaginatorChangePage">
                                    <template slot-scope="props"><div class="txt">{{ props.start }} to {{ props.end }} of {{ props.total }} Items</div></template>
                               </vue-ads-pagination>
                           </div>
                           <span class="selectcont pgsize" style="margin-left: 0;">
                               <select v-model="pagination.pageSize" class="" @change="onChangePageSizeofpopup">
                                    <option v-for="option in pagination.pageSizeOptions" :value="option">{{option}}</option>
                               </select>
                           </span>
                       </template>
                </div>
            </div>
    </div>
	`,
    store: iconsStore,
    props: {data:null},
    data() {
        return {
            noData					: false,
            noDataMsg				: 'No Data',
            mainTitle				: '',
            totalItemsCount         : '',
            subTitle				: '',
            type					: '',
            popupData				: [],
            selectedSprint			: [],
            selectedTeam			: [],
            filterTeams             : [],
            parentInfo              : [],
            filteredSelectedTeams   : [],
            filterSprints           : [],
            filterStatus            :[],
            filteredSelectedSprints  : [],
            filterIssueTypes            : [],
            filteredSelectedIssueTypes    : [],
            filteredSelectedStatus    : [],
            showFullDate:null,
            priorityMap : {
                "ToDo": 1,
                "InProgress": 2,
                "Done": 3,
                "Misc": 4
            },
            sortableColumns: ['title', 'Assignee', 'Time (in Days)','Start Date','End Date'], // Columns where the sort icon should appear
            $options                :{columsMap:{},columnOptions:[]},
            columns: {
                selected: [],
                selectedMap: {}
            },
            pagination: {
                avoidPaginatorAtFirstLoad: true,
                pageSize: 20,
                pageIndex: 0,
                pageSizeOptions: [10, 20, 50, 100],
                totalItemSize: 0,
            },
            loader: {
                show: false,
                title: ""
            },
            backlogItemsLoaded: false,
            filters: {
                searchText: "",
                isApplied: false,
                filterCriteria: {},
                filter: {},
                filtersCount : 0,
                show: false
            },
            dataOfItems:[],
            allDataOfItems: [],
            dumpDataOfItems:[],
            loaded:false,
            graphSpecificType:null,
            fromStatus : null,
            toStatus : null,
            grouping : null,
            groupByString:'',
            sortBy: {
                value: "created",
                ascending: true,
            },
            search: {
                text: ""
            },
        }
    },
    watch:{
        'search.text': {
            handler(newVal) {
                this.onSearchInput(newVal);
            },
            immediate: true
        }
    },
    components: {
        'backlog-item-copy' :BACKLOG_ITEM_COPY,
        VueAdsPagination: window["vue-ads-pagination"].default,
        VueAdsPageButton: window["vue-ads-pagination"].VueAdsPageButton,
    },
    mounted() {
       if(this.data.graphType =='Custom Graphs'){ this.initializeItemsData();}
       else if(this.data.graphType === 'Flow Metrices'){
          // if(this.data.graphSpecificType == 'cycle-time-graph-detail-view' ){
          //      this.loadCFDItems();
           // }
           // else{
               this.loadItemsofPI();
           // }
           this.setOptionColumnForFlowTime(this.data.graphSpecificType);
           this.graphType = this.data.graphType;

           if(this.data.graphSpecificType == 'cycle-time-graph' || this.data.graphSpecificType == 'lead-time-graph' || this.data.graphSpecificType == 'lead-time-graph-detail-view'  || this.data.graphSpecificType == 'cycle-time-graph-detail-view' || this.data.graphSpecificType == 'flow-time-graph' || this.data.graphSpecificType == 'flow-efficiency-graph' || this.data.graphSpecificType == 'flow-time-graph-detail'){
                this.fromStatus = this.data.toStatus;
                this.toStatus = this.data.fromStatus;
           }

       }
       else if(this.data.graphType == 'Cumulative Flow Diagram' || this.data.graphType == 'Completion by Teams'){
           this.setOptionColumnForFlowTime(this.data.graphSpecificType);
           this.loadCFDItems();
           if(this.data.graphSpecificType == 'flow-time-graph-detail'){
               this.fromStatus = this.data.toStatus;
               this.toStatus = this.data.fromStatus;
           }
       }
    },
    created () {
        this.$options.columnOptions = [];
    },
    computed: {
        selectedTeamMessage : function(){
            return function(selectedTeam){
                let teamMessage = "Teams";
                if(selectedTeam){
                    teamMessage = teamMessage + " (" + selectedTeam.length + ")";
                }
                return teamMessage;
            }
        },
        selectedSprintMessage : function(){
            return function(selectedSprint){
                let sprintMessage = "Sprints";
                if(selectedSprint){
                    sprintMessage = sprintMessage + " (" + selectedSprint.length + ")";
                }
                return sprintMessage;
            }
        },selectedStatusMessage : function(){
            return function(selectedStatus){
                let statusMessage = "Status";
                if(selectedStatus){
                    selectedStatus = statusMessage + " (" + selectedStatus.length + ")";
                }
                return selectedStatus;
            }
        },
        selectedIssueTypeMessage: function(){
            return function(selectedIssueType){
                let issueTypeMessage = "Issue Type";
                if(selectedIssueType){
                    issueTypeMessage = issueTypeMessage + " (" + selectedIssueType.length + ")";
                }
                return issueTypeMessage;
            }
        },
        totalItems : function (){
            return function(popupData){
                if(!_.isEmpty(popupData)){
                    return popupData.total;
                }else {
                    return 0;
                }
            }
        },
        itemIcon() {
            return (item) => {
                return styleJiraIcon(this.$root,{ jiraFieldByKey : { issuetype : item?.jiraFieldByKeyIssueType}})
            };
        },
        doneItemsCount : function(){
            return function(popupData){
                if(!_.isEmpty(popupData)){
                    let doneCount = 0;
                    _.each(popupData,item=>{
                        if(item.status.category != undefined){
                            if(item.status.category === "Done"){
                                doneCount++;
                            }
                        }
                    })
                    return this.checkNumberIsNotNaN(doneCount);
                }else {
                    return 0;
                }
            }
        },
        compleationPercentage : function(){
            return function(popupData){
                if(!_.isEmpty(popupData)){
                    let doneCount  = 0;
                    let totalCount = 0;
                    _.each(popupData,item=>{
                        if(item.status.category == "Done" ){
                            doneCount++
                        }
                        totalCount++;
                    })
                    return this.checkNumberIsNotNaN((doneCount / totalCount) * 100)
                }else {
                    return 0;
                }
            }
        },
        showEmptyListScreen () {
            return  this.backlogItemsLoaded && this.popupData.length == 0;
        },
        formatDate:function(){
            return (date)=>{
                const dateParts = date.split(' ');
                const day = dateParts[2];
                const month = dateParts[1];
                const year = dateParts[5];
                return `${day}-${month}-${year}`;
            }
        },
        formatDateSimplifiedSprints: function () {
            return (timestamp) => {
                const date = new Date(timestamp); // Convert timestamp to a Date object
                const day = date.getDate().toString().padStart(2, '0'); // Add leading zero if needed
                const month = date.toLocaleString('default', { month: 'short' }); // Get short month name (e.g., "Jan")
                const year = date.getFullYear(); // Get full year
                return `${day} ${month}`;
            };
        },
        toolTipDateSimplifiedSprints: function () {
            return (timestamp) => {
                const date = new Date(timestamp); // Convert timestamp to a Date object
                const day = date.getDate().toString().padStart(2, '0'); // Add leading zero if needed
                const month = date.toLocaleString('default', { month: 'short' }); // Get short month name (e.g., "Jan")
                const year = date.getFullYear(); // Get full year
                return `${day} ${month} ${year}`;
            };

        }
    },
    methods: {

        onSelectSprintOrTeamFilterData: function(filterType){
            if((this.filteredSelectedTeams==undefined || this.filteredSelectedTeams.length==0)){
                _.each(this.allDataOfItems, dashboard=> {
                    dashboard.filterOn = false;});
            }
            if(this.data.graphType=="Completion by Teams"){
                if((this.filteredSelectedStatus==undefined || this.filteredSelectedStatus.length==0)){
                    _.each(this.allDataOfItems, dashboard=> {
                        dashboard.filterOn = false;});
                }
            }
            if((this.filteredSelectedSprints==undefined || this.filteredSelectedSprints.length==0)){
                _.each(this.allDataOfItems, dashboard=> {
                    dashboard.filterOn = false;});
            }
            if((this.filteredSelectedIssueTypes==undefined || this.filteredSelectedIssueTypes.length==0)){
                _.each(this.allDataOfItems, dashboard=> {
                    dashboard.filterOn = false;});
            }
            if(this.data.graphType=="Completion by Teams"){
                if((this.filteredSelectedTeams==undefined || this.filteredSelectedTeams.length==0)  || (this.filteredSelectedSprints==undefined || this.filteredSelectedSprints.length==0) || (this.filteredSelectedIssueTypes==undefined || this.filteredSelectedIssueTypes.length==0)){
                    _.each(this.allDataOfItems, dashboard=> {
                        dashboard.filterOn = false;});
                }
                else if(this.filterTeams.length === this.filteredSelectedTeams.length && this.filterSprints.length === this.filteredSelectedSprints.length && this.filterIssueTypes.length === this.filteredSelectedIssueTypes.length && this.filterStatus.length === this.filteredSelectedStatus.length){
                    _.each(this.allDataOfItems, dashboard=> {
                        dashboard.filterOn = true;});
                }
                else if(this.filteredSelectedTeams.length>0){
                    this.allDataOfItems.forEach(dataItem => {
                        const teamKeys =Object.values(dataItem.teams || {})
                            .map(value => value.split('-color')[0]);
                        const sprintKeys = Object.values(dataItem.sprints || {});
                        const issueType = dataItem?.issueType;
                        const status = dataItem?.status;
                        let hasMatchingTeam=true;
                        let hasMatchingSprint=true;
                        let hasMatchingIssueType=true;
                        let hasMatchingStatus=true;
                        if(this.filteredSelectedTeams.length!=0)
                        {
                            hasMatchingTeam = teamKeys.some(team => this.filteredSelectedTeams.includes(team));

                        }
                        if(this.filteredSelectedTeams.length!=0)
                        {
                            hasMatchingSprint = sprintKeys.some(sprint => this.filteredSelectedSprints.includes(sprint));
                        }
                        if(this.filteredSelectedIssueTypes.length!=0){
                            hasMatchingIssueType = this.filteredSelectedIssueTypes.includes(dataItem.issueType);
                        }
                        if(this.filteredSelectedStatus.length!=0){
                            hasMatchingStatus = this.filteredSelectedStatus.includes(dataItem.status);
                        }

                        dataItem.filterOn = hasMatchingTeam && hasMatchingSprint && hasMatchingIssueType && hasMatchingStatus;
                    });
                }
            }
            else{
                if((this.filteredSelectedTeams==undefined || this.filteredSelectedTeams.length==0)  || (this.filteredSelectedSprints==undefined || this.filteredSelectedSprints.length==0) || (this.filteredSelectedIssueTypes==undefined || this.filteredSelectedIssueTypes.length==0)){
                    _.each(this.allDataOfItems, dashboard=> {
                        dashboard.filterOn = false;});
                }
                else if(this.filterTeams.length === this.filteredSelectedTeams.length && this.filterSprints.length === this.filteredSelectedSprints.length && this.filterIssueTypes.length === this.filteredSelectedIssueTypes.length){
                    _.each(this.allDataOfItems, dashboard=> {
                        dashboard.filterOn = true;});
                }
                else if(this.filteredSelectedTeams.length>0){
                    this.allDataOfItems.forEach(dataItem => {
                        const teamKeys =Object.values(dataItem.teams || {})
                            .map(value => value.split('-color')[0]);
                        const sprintKeys = Object.values(dataItem.sprints || {});
                        const issueType = dataItem?.issueType;
                        let hasMatchingTeam=true;
                        let hasMatchingSprint=true;
                        let hasMatchingIssueType=true;
                        if(this.filteredSelectedTeams.length!=0)
                        {
                            hasMatchingTeam = teamKeys.some(team => this.filteredSelectedTeams.includes(team));

                        }
                        if(this.filteredSelectedTeams.length!=0)
                        {
                            hasMatchingSprint = sprintKeys.some(sprint => this.filteredSelectedSprints.includes(sprint));
                        }
                        if(this.filteredSelectedIssueTypes.length!=0){
                            hasMatchingIssueType = this.filteredSelectedIssueTypes.includes(dataItem.issueType);
                        }

                        dataItem.filterOn = hasMatchingTeam && hasMatchingSprint && hasMatchingIssueType;
                    });
                }
            }
            this.onChangePageSizeofpopup();
        },
        isSortableColumn(title) {
            return this.sortableColumns.includes(title);
        },
        onSearchInput: function () {
            this.applyFilter();
        },
        applyFilter: function () {
            if (!_.isEmpty(this.search.text)) {
                let lowerQuery = this.search.text.toLowerCase();
                let tempData=[...this.dataOfItems];
                this.dataOfItems=[];
                _.each(this.allDataOfItems, dashboard=> {
                    let lowerName = dashboard.title.toLowerCase();
                    let lowerKey = dashboard.key ? String(dashboard.key).toLowerCase() : "";  // Convert to string only if key exists
                    if(dashboard.filterOn===true){
                        if (lowerName.includes(lowerQuery) || lowerKey.includes(lowerQuery)) {
                            dashboard.filterOn = true;
                        }
                        else {
                            dashboard.filterOn = false;
                        }
                    }
                });
            }
            else {
                // _.each(this.allDataOfItems, dashboard=> {
                //     dashboard.filterOn = true;
                // });
                this.onSelectSprintOrTeamFilterData("filter");
            }
            this.onChangePageSizeofpopup();

            //  this.data.total=this.dataOfItems.length;
        },
        applySort: function () {
            let _this = this;
            if(this.pagination.pageIndex==0){
                if (this.sortBy.value == 'title') {
                    this.allDataOfItems = this.allDataOfItems.sort((a, b) => {
                        if (_this.sortBy.ascending) {
                            return a.title.toLowerCase() > b.title.toLowerCase() ? 1 : -1;
                        }
                        else {
                            return a.title.toLowerCase() > b.title.toLowerCase() ? -1 : 1;
                        }
                    });
                }
                else if (this.sortBy.value == 'Assignee') {
                    this.allDataOfItems = this.allDataOfItems.sort((a, b) => {
                        const aName = a.assignee ? a.assignee.displayName.toLowerCase() : '';
                        const bName = b.assignee ? b.assignee.displayName.toLowerCase() : '';

                        if (_this.sortBy.ascending) {
                            if (aName > bName) return 1; // a comes after b
                            if (aName < bName) return -1; // a comes before b
                            return 0; // a and b are equal
                        } else {
                            if (aName < bName) return 1; // a comes after b
                            if (aName > bName) return -1; // a comes before b
                            return 0; // a and b are equal
                        }
                    });
                }
                else if (this.sortBy.value == 'Time (in Days)') {

                    this.allDataOfItems.sort((a, b) => {
                        const aDays = parseInt(a.days) || 0; // Extracts 31 from "31 Days" or defaults to 0 if not a valid number
                        const bDays = parseInt(b.days) || 0; // Extracts 1 from "1 Day" or defaults to 0 if not a valid number

                        if (this.sortBy.ascending) {
                            return aDays - bDays; // Ascending order
                        } else {
                            return bDays - aDays; // Descending order
                        }
                    });
                }
                else if(this.sortBy.value == 'Start Date')
                {
                    this.allDataOfItems.sort((a, b) => {
                        // Clean up the date string by removing the time zone and year part
                        const cleanDateA = a.startDate.replace(/ PKT \d{4}/, '');
                        const cleanDateB = b.startDate.replace(/ PKT \d{4}/, '');

                        // Parse the cleaned-up date strings into Date objects
                        const dateA = new Date(cleanDateA);
                        const dateB = new Date(cleanDateB);

                        // Ensure the dates are valid before sorting
                        if (isNaN(dateA) || isNaN(dateB)) {
                            return 0; // If dates are invalid, don't change the order
                        }

                        // Perform the sorting based on the "ascending" flag
                        if (this.sortBy.ascending) {
                            return dateA - dateB; // Sorts in ascending order
                        } else {
                            return dateB - dateA; // Sorts in descending order
                        }
                    });
                }
                else if(this.sortBy.value == 'End Date')
                {
                    this.allDataOfItems.sort((a, b) => {
                        // Clean up the date string by removing the time zone and year part
                        const cleanDateA = a.endDate.replace(/ PKT \d{4}/, '');
                        const cleanDateB = b.endDate.replace(/ PKT \d{4}/, '');

                        // Parse the cleaned-up date strings into Date objects
                        const dateA = new Date(cleanDateA);
                        const dateB = new Date(cleanDateB);

                        // Ensure the dates are valid before sorting
                        if (isNaN(dateA) || isNaN(dateB)) {
                            return 0; // If dates are invalid, don't change the order
                        }

                        // Perform the sorting based on the "ascending" flag
                        if (this.sortBy.ascending) {
                            return dateA - dateB; // Sorts in ascending order
                        } else {
                            return dateB - dateA; // Sorts in descending order
                        }
                    });
                }
                else if(this.sortBy.value == 'Date')
                {
                    this.allDataOfItems.sort((a, b) => {
                        const itemDate=this.toolTipDateSimplifiedSprints(a.date);
                        const item2Date=this.toolTipDateSimplifiedSprints(b.date);

                        // Clean up the date string by removing the time zone and year part
                        const cleanDateA = itemDate.replace(/ PKT \d{4}/, '');
                        const cleanDateB = item2Date.replace(/ PKT \d{4}/, '');

                        // Parse the cleaned-up date strings into Date objects
                        const dateA = new Date(cleanDateA);
                        const dateB = new Date(cleanDateB);

                        // Ensure the dates are valid before sorting
                        if (isNaN(dateA) || isNaN(dateB)) {
                            return 0; // If dates are invalid, don't change the order
                        }

                        // Perform the sorting based on the "ascending" flag
                        if (this.sortBy.ascending) {
                            return dateA - dateB; // Sorts in ascending order
                        } else {
                            return dateB - dateA; // Sorts in descending order
                        }
                    });
                }
                this.onChangePageSizeofpopup();
            }
            else{
                if (this.sortBy.value == 'title') {
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        if (_this.sortBy.ascending) {
                            return a.title.toLowerCase() > b.title.toLowerCase() ? 1 : -1;
                        }
                        else {
                            return a.title.toLowerCase() > b.title.toLowerCase() ? -1 : 1;
                        }
                    });
                }
                else if (this.sortBy.value == 'Assignee') {
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        const aName = a.assignee ? a.assignee.displayName.toLowerCase() : '';
                        const bName = b.assignee ? b.assignee.displayName.toLowerCase() : '';

                        if (_this.sortBy.ascending) {
                            if (aName > bName) return 1; // a comes after b
                            if (aName < bName) return -1; // a comes before b
                            return 0; // a and b are equal
                        } else {
                            if (aName < bName) return 1; // a comes after b
                            if (aName > bName) return -1; // a comes before b
                            return 0; // a and b are equal
                        }
                    });
                }
                else if (this.sortBy.value == 'Time (in Days)') {

                    this.dataOfItems.sort((a, b) => {
                        const aDays = parseInt(a.days) || 0; // Extracts 31 from "31 Days" or defaults to 0 if not a valid number
                        const bDays = parseInt(b.days) || 0; // Extracts 1 from "1 Day" or defaults to 0 if not a valid number

                        if (this.sortBy.ascending) {
                            return aDays - bDays; // Ascending order
                        } else {
                            return bDays - aDays; // Descending order
                        }
                    });
                }
                else if(this.sortBy.value == 'Start Date')
                {
                    this.dataOfItems.sort((a, b) => {
                        // Clean up the date string by removing the time zone and year part
                        const cleanDateA = a.startDate.replace(/ PKT \d{4}/, '');
                        const cleanDateB = b.startDate.replace(/ PKT \d{4}/, '');

                        // Parse the cleaned-up date strings into Date objects
                        const dateA = new Date(cleanDateA);
                        const dateB = new Date(cleanDateB);

                        // Ensure the dates are valid before sorting
                        if (isNaN(dateA) || isNaN(dateB)) {
                            return 0; // If dates are invalid, don't change the order
                        }

                        // Perform the sorting based on the "ascending" flag
                        if (this.sortBy.ascending) {
                            return dateA - dateB; // Sorts in ascending order
                        } else {
                            return dateB - dateA; // Sorts in descending order
                        }
                    });
                }
                else if(this.sortBy.value == 'End Date')
                {
                    this.dataOfItems.sort((a, b) => {
                        // Clean up the date string by removing the time zone and year part
                        const cleanDateA = a.endDate.replace(/ PKT \d{4}/, '');
                        const cleanDateB = b.endDate.replace(/ PKT \d{4}/, '');

                        // Parse the cleaned-up date strings into Date objects
                        const dateA = new Date(cleanDateA);
                        const dateB = new Date(cleanDateB);

                        // Ensure the dates are valid before sorting
                        if (isNaN(dateA) || isNaN(dateB)) {
                            return 0; // If dates are invalid, don't change the order
                        }

                        // Perform the sorting based on the "ascending" flag
                        if (this.sortBy.ascending) {
                            return dateA - dateB; // Sorts in ascending order
                        } else {
                            return dateB - dateA; // Sorts in descending order
                        }
                    });
                }
            }

        },
        onClickSort:function(sortKey){
            if (sortKey == this.sortBy.value) {
                this.sortBy.ascending = !this.sortBy.ascending;
            }
            else {
                this.sortBy.ascending = true;
                this.sortBy.value = sortKey;
            }
this.applySort();
            },
            findInitials:function(name) {
                // Handle cases where an object might be passed instead of a string
                if (!name || typeof name !== 'string') {
                    return '';
                }
                if(name === ''){
                    return '';
                }
                const words = name.split(' ');
                let initials = '';
    
                // for (let i = 0; i < words.length; i++) {
                const initial = words[0][0].toUpperCase();
                initials += initial;
                // }
                return initials;
            },
        initializeItemsData:function (){
            this.mainTitle=this.data.mainTitle;
            this.totalItemsCount=this.data.total;
            if(this.totalItemsCount<=0){
                this.noData = true;
                this.type	= '';
            }
            let columns = localStorage.getItem(this.data.releaseTrainID + "_GraphBacklog_Columns");
            if (!_.isEmpty(columns)) {
                try {
                    columns = JSON.parse(columns);
                    this.columns.selected = columns;
                }
                catch(error) {
                }
            }
            this.setOptionColumn();
            this.loadItemsOfBacklog();
        },
         putIconDataIntheMap(cssMap, issueType){
            if(issueType.id != '10100'){
                //return;
            }
            let iconKey = 'jira-icon_'+issueType.id;
            cssMap[iconKey] = '.'+iconKey+':before {content:""; background-image: url("'+issueType.iconUrl+'");} /*'+issueType.name+'*/';
            if(cssMap.idByUrl == undefined){
                cssMap.idByUrl = {};
            }
            cssMap.idByUrl[issueType.iconUrl] = issueType.id;

            return iconKey;
        },
        loadItemsOfBacklog () {
            let pageStart = "" + (this.pagination.pageIndex);
            let pageSize = "" + (this.pagination.pageSize);
            let filter = this.getFilterCriteria();
            if (filter && !_.isEmpty(filter.rules)) {
                this.filters.isApplied = true;
                let key=filter.rules.at(0).value;
                pageStart="0";
                pageSize="200";
                filter=key;
            }else {
                this.filters.isApplied = false;
                filter="";
            }
            var data = {};
            data.releaseTrainId = this.data.releaseTrainID;
            data.itemSelected = this.data.itemSelected;
            data.filter = this.data.filterSelected;
            data.page = pageStart;
            data.sizeOfPage = pageSize;
            data.filterData = filter;
            data.hierachLevel = this.data.level;
            data.fetchParents = true;
            data.requestId=getNewUUID();
            data.selectedFilterType=this.data.selectedFilterType;
            if(!_.isEmpty(this.data.additionalCriteria))
            {
                data.selectedTeam = this.data.selectedTeam;
                data.additionalCriteria = this.data.additionalCriteria;
            }
            this.pagination.totalItemSize=this.totalItemsCount;
            this.loader.text = "Data loading ...";
            this.loader.show = true;
            axios.post("/dashboard/retrieveItemsData",data).
            then(response=>{
                this.popupData = response.data;
                this.loader.show = false;
            }).catch(error=>{
                console.error(error);
            });
        },
        getFilterCriteria: function () {
            let filters = _.cloneDeep(this.filters.filterCriteria);
            if (_.isEmpty(filters)) {
                filters = {condition:"AND"};
            }
            if (!_.isEmpty(this.filters.searchText)) {
                if (!filters.rules) {
                    filters.rules = [];
                }
                let titleFilter = _.find(filters.rules,{key:"title-id"});
                if (!titleFilter) {
                    titleFilter = {key:"title-id",value:[],operator:"EQUALS",type:"text"};
                    filters.rules.push(titleFilter);
                }
                titleFilter.value.push(this.filters.searchText);
            }
            return filters;
        },
        onFiltersChangeSearchText: function () {
            this.pagination.pageIndex = 0;
            this.pagination.totalItemSize = 0;
            this.loadItemsOfBacklog();
        },
        setOptionColumn:function(){
            if (_.isEmpty(this.columns.selected)) {
                this.columns.selected = ["status", "children", "estimate", "boards"];
            }
            this.$options.columsMap = {};
            this.$options.columsMap["status"] = { id: "status", title: "Status", sortCommand: "statusTitle", sort: false, class:"c3" };
            this.$options.columsMap["estimate"] = { id: "estimate", title: "Estimate (SP)", sortCommand: "totalEstimate", sort: false , class:"c3", toolTip:"Rollup Estimate"};
            this.$options.columsMap["teams"] = { id: "teams", title: "Teams (Kendis)", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["sprints"] = { id: "sprints", title: "Sprints (Kendis)", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["startDate"] = { id: "startDate", title: "Start Date", sortCommand: "startDate", sort: true , class:"c3"};
            this.$options.columsMap["endDate"] = { id: "endDate", title: "End Date", sortCommand: "endDate", sort: true , class:"c3"};
            this.$options.columsMap["date"] = { id: "date", title: "Date", sortCommand: "date", sort: true , class:"c3"};
            this.$options.columsMap["boards"] = { id: "boards", title: "Kendis Board", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["batches"] = { id: "batches", title: "Batches", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["solutionBoards"] = { id: "solutionBoards", title: "Solution Boards", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["fetchedBy"] = { id: "fetchedBy", title: "Fetched By", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["responsible"] = { id: "responsible", title: "Responsible", sortCommand: "fields.CreatedBy", sort: true , class:"c3"}
            this.$options.columsMap["updated"] = { id: "updated", title: "Updated On", sortCommand: "updatedOn", sort: true , class:"c3"}
            this.$options.columsMap["created"] = { id: "created", title: "Created On", sortCommand: "createdOn", sort: true , class:"c3"}
            this.$options.columsMap["creater"] = { id: "creater", title: "Creator", sortCommand: "", sort: false , class:"c3"}
            this.$options.columnOptions = Object.values(this.$options.columsMap);
        },

        setOptionColumnForFlowTime:function(type){
            if(type === 'cycle-time-graph' || type === 'cycle-time-graph-detail-view' || type === 'lead-time-graph' || type === 'lead-time-graph-detail-view'){
                if (_.isEmpty(this.columns.selected)) {
                    // this.columns.selected = ["time","groupBy", "teams", "sprint"];
                    if(this.data.radioButtonSelection == 'statusCategory') {
                    this.columns.selected = ["time","statusOfItem","startDate","endDate","teams","sprint","assignee"];
                    }
                    else {
                        this.columns.selected = ["time","startDate","endDate","teams","sprint","assignee"];
                    }
                }
                this.$options.columsMap = {};
                if(this.data.radioButtonSelection == 'statusCategory') {
                    this.$options.columsMap["statusOfItem"] = {
                        id: "statusOfItem",
                        title: "Status of Item",
                        class: "c3",
                        toolTip: "Status of Items"
                    };
                }
                this.$options.columsMap["time"] = { id: "time", title: "Time (in Days)", class:"c3", toolTip:"Time in Days",dataHeader:"status"};
                this.$options.columsMap["startDate"] = { id: "startDate", title: "Start Date", class:"c3", toolTip:"Start Date",dataHeader:"startDate"};
                this.$options.columsMap["endDate"] = { id: "endDate", title: "End Date", class:"c3", toolTip:"End Date",dataHeader:"endDate"};
                this.$options.columsMap["teams"] = { id: "teams", title: "Teams", class:"c3",dataHeader:"team"};
                this.$options.columsMap["sprint"] = { id: "sprint", title: "Sprint", class:"c3",dataHeader:"sprint"};
                this.$options.columsMap["assignee"] = { id: "assignee", title: "Assignee", class:"c3",dataHeader:"assignee"};
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            }
            else if(type == 'flow-time-graph'){
                if (_.isEmpty(this.columns.selected)) {
                    // this.columns.selected = ["time","groupBy", "teams", "sprint"];
                    if(this.data.radioButtonSelection == 'statusCategory') {
                        this.columns.selected = ["time","statusOfItem","teams", "sprint","assignee"];
                    }
                    else{
                        this.columns.selected = ["time","teams", "sprint","assignee"];
                    }
                }
                this.$options.columsMap = {};
                this.$options.columsMap["time"] = { id: "time", title: "Time (in Days)", class:"c3", toolTip:"Time in Days"};
                if(this.data.radioButtonSelection == 'statusCategory') {
                    this.$options.columsMap["statusOfItem"] = {
                        id: "statusOfItem",
                        title: "Status of Item",
                        class: "c3",
                        toolTip: "Status of Items"
                    };
                }
                this.$options.columsMap["teams"] = { id: "teams", title: "Teams", class:"c3",dataHeader:"team"};
                this.$options.columsMap["sprint"] = { id: "sprint", title: "Sprint", class:"c3",dataHeader:"sprint"};
                this.$options.columsMap["assignee"] = { id: "assignee", title: "Assignee", class:"c3",dataHeader:"assignee"};
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            }
           else if(type == 'flow-efficiency-graph'){
                if (_.isEmpty(this.columns.selected)) {
                    this.columns.selected = ["efficiency", "teams", "sprint","assignee"];
                }
                this.$options.columsMap = {};
                this.$options.columsMap["efficiency"] = { id: "efficiency", title: "Efficiency %", class:"c3", toolTip:"Efficiency in %",dataHeader:"status"};
                // this.$options.columsMap["groupBy"] = { id: "groupBy", title: "Group By ("+this.grouping+")", class:"c3", toolTip:"Groupby"};
                this.$options.columsMap["teams"] = { id: "teams", title: "Teams", class:"c3",dataHeader:"team"};
                this.$options.columsMap["sprint"] = { id: "sprint", title: "Sprint", class:"c3",dataHeader:"sprint"};
                this.$options.columsMap["assignee"] = { id: "assignee", title: "Assignee", class:"c3",dataHeader:"assignee"};
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            }
          else if(type == 'flow-velocity-graph'){
                if (_.isEmpty(this.columns.selected)) {
                    if(this.data.radioButtonSelection == 'statusCategory') {
                        this.columns.selected = ["teams","statusOfItem", "sprint","assignee"];
                    }
                    else{
                        this.columns.selected = ["teams", "sprint","assignee"];
                    }
                }
                this.$options.columsMap = {};
                if(this.data.radioButtonSelection == 'statusCategory') {
                    this.$options.columsMap["statusOfItem"] = {
                        id: "statusOfItem",
                        title: "Status of Item",
                        class: "c3",
                        toolTip: "Status of Items"
                    };
                }
                // this.$options.columsMap["items"] = { id: "items", title: "No. of Items", class:"c3", toolTip:"Number of Items in Completion Status"};
                this.$options.columsMap["items"] = { id: "items", title: "No. of Items", class:"c3", toolTip:"Number of Items in Completion Status",dataHeader:"status"};
                // this.$options.columsMap["groupBy"] = { id: "groupBy", title: "Group By ("+this.grouping+")", class:"c3", toolTip:"Groupby"};
                this.$options.columsMap["teams"] = { id: "teams", title: "Teams", class:"c3",dataHeader:"team"};
                this.$options.columsMap["sprint"] = { id: "sprint", title: "Sprint", class:"c3",dataHeader:"sprint"};
                this.$options.columsMap["assignee"] = { id: "assignee", title: "Assignee", class:"c3",dataHeader:"assignee"};
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            }
          else  if(type == 'flow-load-graph' || type == 'flow-distribution-graph'){
                if (_.isEmpty(this.columns.selected)) {
                    this.columns.selected = ["status", "teams", "sprint","assignee"];
                }
                this.$options.columsMap = {};
                this.$options.columsMap["status"] = { id: "status", title: "Status of Item", class:"c3", toolTip:"Status of Items",dataHeader:"status"};
                this.$options.columsMap["teams"] = { id: "teams", title: "Teams", class:"c3",dataHeader:"team"};
                this.$options.columsMap["sprint"] = { id: "sprint", title: "Sprint", class:"c3",dataHeader:"sprint"};
                this.$options.columsMap["assignee"] = { id: "assignee", title: "Assignee", class:"c3",dataHeader:"assignee"};
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            }
          else if(type == 'cfd' || type == 'cs' || type == 'flow-time-graph-detail' ||type == 'flow-efficiency-graph-detail' || type == 'flow-velocity-graph-detail' || type == 'flow-load-graph-detail' || type == 'flow-distribution-graph-detail'){
                if (_.isEmpty(this.columns.selected)) {
                    if((this.data.radioButtonSelection == 'statusCategory' || this.data.radioButtonSelection == 'status') && type == 'cs') {
                        this.columns.selected = ["estimate", "statusOfItem", "teams", "sprint", "date", "assignee"];
                    }
                    else{
                        if(this.data.radioButtonSelection == 'statusCategory') {
                            this.columns.selected = ["teams","statusOfItem", "sprint","assignee"];
                        }
                        else{
                            this.columns.selected = ["teams", "sprint","assignee"];
                        }
                    }

                }
                this.$options.columsMap = {};
                if(this.data.radioButtonSelection == 'statusCategory' || (this.data.radioButtonSelection == 'status' && type == 'cs')) {
                    this.$options.columsMap["statusOfItem"] = {
                        id: "statusOfItem",
                        title: "Status of Item",
                        class: "c3",
                        toolTip: "Status of Items"
                    };
                }
                this.$options.columsMap["teams"] = { id: "teams", title: "Teams", class:"c3",dataHeader:"team"};
                this.$options.columsMap["sprint"] = { id: "sprint", title: "Sprint", class:"c3",dataHeader:"sprint"};
                this.$options.columsMap["assignee"] = { id: "assignee", title: "Assignee", class:"c3",dataHeader:"assignee"};
                this.$options.columsMap["date"] = { id: "date", title: "Date", class:"c3", toolTip:"Date",dataHeader:"date"};
                this.$options.columsMap["estimate"] = { id: "estimate", title: "Estimate (SP)",class:"c3", dataHeader:"estimate"};

                this.$options.columnOptions = Object.values(this.$options.columsMap);
            }
        },
        checkNumberIsNotNaN: function(number){

            if(isNaN(number)){
                return 0;
            }else{
                return parseFloat(number.toFixed(2));
            }
        },
        hide : function(){
            this.$emit('close');
        },
        customExport:function(requestBody) {
            requestBody.headers = [];
            requestBody.items = [];

            // Define the columns that should be checked and added
            const possibleColumns = ['key', 'title'];
            if(this.columns.selected!=undefined){
                if(this.columns.selected.includes('status') || this.columns.selected.includes('efficiency')){
                    possibleColumns.push('days');
                }
                if(this.columns.selected.includes('teams')){
                    possibleColumns.push('teams');
                }
                if(this.columns.selected.includes('time')){
                    possibleColumns.push('days');
                }
                if(this.columns.selected.includes('sprint')){
                    possibleColumns.push('sprints');
                }
                if(this.columns.selected.includes('startDate')){
                    possibleColumns.push('startDate');
                }
                if(this.columns.selected.includes('endDate')){
                    possibleColumns.push('endDate');
                }
                if(this.columns.selected.includes('assignee')){
                    possibleColumns.push('assignee');
                }
            }

            let columnsAdded = []; // Initialize with no columns initially
            // Loop through all data items
            let filteredItems = this.allDataOfItems.filter(item => item.filterOn);

            for (var i = 0; i < filteredItems.length; i++) {
                var item = filteredItems[i];

                let check=false;
                // Dynamically check for the presence of specified columns and add them
                possibleColumns.forEach(column => {
                    if (!columnsAdded.includes(column)) {
                        columnsAdded.push(column); // Add column to headers if it exists in the item
                    }
                });

                // Process headers for the first iteration
                if (i === 0) {
                    columnsAdded.forEach(column => {
                        let headerName = column.charAt(0).toUpperCase() + column.slice(1).replace(/([A-Z])/g, ' $1');
                        if(this.columns.selected!=undefined){
                            if(this.columns.selected.includes('status') && headerName=='Days'){
                                headerName='Status of Item';
                            }
                            if(this.columns.selected.includes('efficiency') && headerName=='Days'){
                                headerName='Efficiency %';
                            }
                        }
                        requestBody.headers.push({ value: column, header: headerName });
                    });
                }

                // Add the item data for each row
                var rowItem = {};

                // Add the selected fields based on the dynamically determined columns
                columnsAdded.forEach(column => {
                    if (item.hasOwnProperty(column)) {
                        const columnData = item[column];

                        if ((column.toLowerCase() === 'teams' || column.toLowerCase() === 'sprints')
                            && typeof columnData === 'object' && columnData !== null) {
                            // Handle 'teams' or 'sprints' by joining keys if they are objects
                            rowItem[column] = Object.keys(columnData).join(", ");
                        } else if (column.toLowerCase() === 'assignee' && columnData && columnData.displayName) {
                            // Handle 'assignee' by using displayName if present
                            rowItem[column] = columnData.displayName;
                        } else if (Array.isArray(columnData)) {
                            // If it's an array, join values with commas
                            rowItem[column] = columnData.join(", ");
                        } else if (typeof columnData === 'object' && columnData !== null) {
                            // Handle any other objects by converting to a JSON string
                            rowItem[column] = JSON.stringify(columnData);
                        } else if (column.toLowerCase() === 'startdate' || column.toLowerCase() === 'enddate') {
                            // Handle date fields with a custom format
                            const dateParts = columnData.match(/^(\w{3}) (\w{3}) (\d{2}) (\d{2}:\d{2}:\d{2}) \w{3} (\d{4})$/);
                            if (dateParts) {
                                // Convert to a format like "Month Day, Year"
                                const parsedDate = new Date(`${dateParts[2]} ${dateParts[3]}, ${dateParts[5]} ${dateParts[4]}`);
                                rowItem[column] = parsedDate.toLocaleDateString();  // Format date as string
                            } else {
                                rowItem[column] = 'Invalid Date';
                            }
                        } else {
                            // Assign simple key-value for non-object and non-array values
                            rowItem[column] = columnData;
                        }
                    } else {
                        // If the column is not found in the item, assign an empty string
                        rowItem[column] = '';
                    }
                });


                // Add the item to the exportable items
                requestBody.items.push(rowItem);
            }


            return requestBody;
        },
        exportChartDetail : function(type){
            var rows = $('#items li,.data');
            var requestBody = {};
            requestBody.title = this.data.popupTitle;
            requestBody = this.customExport(requestBody);
            sendExportRequest(type, requestBody);
        },
        onColumnsSelectValue: function(valuse) {
            localStorage.setItem(this.data.releaseTrainID + "_GraphBacklog_Columns", JSON.stringify(valuse));
        },
        onChangePageSize() {
            this.pagination.pageIndex = 0;
            this.loadItemsOfBacklog();
        },
        onChangePageSizeofpopup() {
            this.pagination.pageIndex = 0;
            if(!this.loaded){
                if(this.data.graphType == 'Cumulative Flow Diagram' ){
                    this.loadCFDItems();
                }
                else{
                    // if(this.data.graphSpecificType == 'cycle-time-graph-detail-view' || this.data.graphSpecificType == 'lead-time-graph-detail-view' ){
                    //     this.loadCFDItems();
                    // }
                    // else{
                    this.loadItemsofPI();
                    // }
                }
            }
            else{
                this.paginationHandler();
            }
        },
        onPaginatorChangePage(pageNumber, start, end) {
            this.pagination.pageIndex = pageNumber;
            if(!this.loaded){
                if(this.data.graphType == 'Cumulative Flow Diagram' ){
                    this.loadCFDItems();
                }
                else if(this.data.graphType == 'Flow Metrices' ){
                    // if(this.data.graphSpecificType == 'cycle-time-graph-detail-view' || this.data.graphSpecificType == 'lead-time-graph-detail-view'  ){
                    //     this.loadCFDItems();
                    // }
                    // else{
                    this.loadItemsofPI();
                    // }
                }
                else{
                    this.loadItemsofPI();
                } if(this.data.graphType == 'Cumulative Flow Diagram' ){
                    this.loadCFDItems();
                }
                else if(this.data.graphType == 'Flow Metrices' ){
                    // if(this.data.graphSpecificType == 'cycle-time-graph-detail-view' || this.data.graphSpecificType == 'lead-time-graph-detail-view'  ){
                    //     this.loadCFDItems();
                    // }
                    // else{
                    this.loadItemsofPI();
                    // }
                }
                else{
                    this.loadItemsofPI();
                }
            }
           else{
               this.paginationHandler();
            }
            this.pagination.avoidPaginatorAtFirstLoad = false;
        },
        paginationHandler:function(){
            let pageStart = this.pagination.pageIndex;
            let pageSize = this.pagination.pageSize;
            let startIndex = pageStart * pageSize;
            let endIndex = startIndex + pageSize;
            this.dataOfItems = this.allDataOfItems
                .filter(item => item.filterOn) // Only keep items where filterOn is true
                .slice(startIndex, endIndex);
            this.data.total= this.allDataOfItems
                .filter(item => item.filterOn).length;

        },
        loadItemsofPI: function() {
            let pageStart = this.pagination.pageIndex;
            let pageSize = this.pagination.pageSize;
            let itemsDaysMapList = this.data.itemDaysMap;
            let itemDatesMapList = this.data.itemDatesMap;
            this.grouping = this.data.grouping;
            let itemTeamsMap = this.data.itemTeamsMap;
            let itemSprintsMap = this.data.itemSprintsMap;
            let itemGroupbyMap = this.data.itemGroupbyMap;
            if (!_.isEmpty(itemsDaysMapList)) {
                let itemDatesArray = [];
                let combinedArray =[];
                let itemsArray = Object.entries(itemsDaysMapList).map(([id, value]) => ({ id, value }));
                if(!_.isEmpty(itemDatesMapList)){
                     itemDatesArray = Object.entries(itemDatesMapList).map(([id, value]) => ({ id, value }));
                     combinedArray = itemDatesArray.map(item2 => {
                        const item1 = itemsArray.find(item1 => item1.id === item2.id);
                        return {
                            id: item2.id,
                            value: {
                                daydifference: item1 ? item1.value.toString() : null,
                                startDate: item2.value[0],
                                endDate: item2.value[1],
                            }
                        };
                    });
                }
                let startIndex = pageStart * pageSize;
                if (startIndex >= itemsArray.length) {startIndex = itemsArray.length - 1;}
                let endIndex = Math.min(startIndex + pageSize, itemsArray.length);
                let paginatedItems =[];
                if(!_.isEmpty(combinedArray)){
                    paginatedItems = combinedArray.slice(startIndex, endIndex);
                } else{
                     paginatedItems = itemsArray.slice(startIndex, endIndex);
                }
                let paginatedItemsObject = {};
                if(!_.isEmpty(combinedArray)){
                    for (let item of paginatedItems) {
                        paginatedItemsObject[item.id] = {
                            days: item.value.daydifference,
                            startDate:item.value.startDate,
                            endDate:item.value.endDate,
                            teams:[],
                            sprints:[],
                        };
                    }
                } else{
                    for (let item of paginatedItems) {
                        paginatedItemsObject[item.id] = {
                           days: item.value,
                           groupby: !_.isEmpty(itemGroupbyMap)? itemGroupbyMap[item.id] : [],
                           // teams:itemTeamsMap[item.id]||[],
                           // sprints:itemSprintsMap[item.id]||[]
                            teams:[],
                            sprints:[],
                        };
                    }
                }
                this.pagination.totalItemSize = paginatedItems.length;
                this.loader.text = "Data loading ...";
                this.loader.show = true;
                if (!_.isEmpty(paginatedItemsObject)) {

                    //Commented the code as it was fetching only the page size items

                    // axios.post('/dashboard/fetch-item-details-list/', paginatedItemsObject)
                    //     .then(response => {
                    //         // Set the array
                    //         this.dataOfItems = response.data.map(item => {
                    //             item.filterOn = true; // Add `filterOn` attribute to each item
                    //             return item;
                    //         });
                    //         this.loader.show = false;
                    //     })
                    //     .catch(error => {
                    //         console.error(error);
                    //         this.loader.show = false;
                    //     });

                    let paginatedItems =[];
                    if(!_.isEmpty(combinedArray)){
                        paginatedItems = combinedArray;
                    } else{
                        paginatedItems = itemsArray;
                    }
                    let paginatedItemsObjectAllData = {};
                    if(!_.isEmpty(combinedArray)){
                        for (let item of paginatedItems) {
                            paginatedItemsObjectAllData[item.id] = {
                                days: item.value.daydifference,
                                startDate:item.value.startDate,
                                endDate:item.value.endDate,
                                teams:[],
                                sprints:[],
                            };
                        }
                    } else{
                        for (let item of paginatedItems) {
                            paginatedItemsObjectAllData[item.id] = {
                                days: item.value,
                                groupby: !_.isEmpty(itemGroupbyMap)? itemGroupbyMap[item.id] : [],
                                // teams:itemTeamsMap[item.id]||[],
                                // sprints:itemSprintsMap[item.id]||[]
                                teams:[],
                                sprints:[],
                            };
                        }
                    }
                    this.data.total=paginatedItems.length;
                    this.loader.text = "Data loading ...";
                    this.loader.show = true;
                    axios.post('/dashboard/fetch-item-details-list/', paginatedItemsObjectAllData)
                        .then(response => {
                            this.dataOfItems = response.data;
                            if(this.data.radioButtonSelection ==='statusCategory'){
                                if(!_.isEmpty(this.data.itemStatusMap)){
                                    this.dataOfItems.forEach(item => {
                                    const status = this.data.itemStatusMap[item.itemId];
                                    if (status) {
                                        let [before, after] = status[0].split("status_category:");
                                        item.status = before;
                                        item.category = after;
                                    } else {
                                        item.status = '';
                                    }
                                    });
                                }
                            }
                            if(this.data.graphSpecificType == 'flow-load-graph' || this.data.graphSpecificType == 'flow-distribution-graph'){
                                this.dataOfItems.forEach( item => {
                                    const status = item.days;
                                    let [before, after] = status.split("status_category:");
                                    item.days = before;
                                    item.category = after;
                                })
                            }

                            // Set the array
                            this.filterTeams=[];
                            // this.filterTeams = response.data
                            //     .filter(item => item.teams) // Only keep items that have a `teams` attribute
                            //     .map(item => item.teams);
                            this.filterTeams = response.data
                                .map(item => {
                                    // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                    return item.teams && Object.keys(item.teams).length > 0
                                        ? item.teams
                                        : { "No Team": "No Team-color:#594a21" };
                                });
                            this.filterSprints=[];
                            // this.filterSprints = response.data
                            //     .filter(item => item.sprints) // Only keep items that have a `sprints` attribute
                            //     .map(item => item.sprints);
                            this.filterSprints = response.data
                                .map(item => {
                                    // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                    return item.sprints && Object.keys(item.sprints).length > 0
                                        ? item.sprints
                                        : { "No Sprint": "No Sprint" };
                                });
                            this.filterIssueTypes=[];
                            this.filterIssueTypes = response.data
                                .map(item => {
                                    // Check if tfsItemType exists and is not empty
                                    if (item.tfsItemType && item.tfsItemType.trim() !== "") {
                                        return item.tfsItemType;
                                    }
                                    // Otherwise, check if jiraFieldByKeyIssueType exists and has a name
                                    if (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name) {
                                        return item.jiraFieldByKeyIssueType.name;
                                    }
                                    // Return undefined if neither condition is met
                                    return "Kendis Only";
                                })
                                // Filter out any undefined values
                                .filter(Boolean);
                            this.allDataOfItems = response.data.map(item => {
                                item.filterOn = true; // Add `filterOn` attribute to each item
                                return item;
                            });
                            this.allDataOfItems = this.allDataOfItems.map(item => {
                                // Check for tfsItemType or fallback to jiraFieldByKeyIssueType.name
                                if (item.tfsItemType && item.tfsItemType.trim() !== "") {
                                    item.issueType = item.tfsItemType;  // Set issueType to tfsItemType if available
                                } else if (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name) {
                                    item.issueType = item.jiraFieldByKeyIssueType.name;  // Otherwise, set issueType to jiraFieldByKeyIssueType.name
                                } else {
                                    item.issueType = "Kendis Only"; // Optionally set to null if neither condition is met
                                }
                                if (!item.teams || Object.keys(item.teams).length === 0) {
                                    item.teams = { "No Team": "No Team-color:#594a21" };
                                }
                                if (!item.sprints || Object.keys(item.sprints).length === 0) {
                                    item.sprints = { "No Sprint": "No Sprint" };
                                }
                                return item; // Return the modified item
                            });
                            this.dumpDataOfItems = response.data.map(item => {
                                item.filterOn = true; // Add `filterOn` attribute to each item
                                return item;
                            });
                            this.dataOfItems=this.allDataOfItems.slice(startIndex, endIndex);
                            this.loader.show = false;
                            this.loaded=true;
                            this.filterTeamsForDropDown();
                            this.filterSprintsForDropDown();
                            this.filterIssueTypeForDropDown();
                        })
                        .catch(error => {
                            console.error(error);
                            this.loader.show = false;
                        });
                }
            }
        },

        loadCFDItems:function(){
            let pageStart = this.pagination.pageIndex;
            let pageSize = this.pagination.pageSize;
            let startIndex = pageStart * pageSize;
            if (startIndex >= this.data.itemIds.length) {startIndex = this.data.itemIds.length - 1;}
            let endIndex = Math.min(startIndex + pageSize, this.data.itemIds.length);
            let paginatedItems = this.data.itemIds.slice(startIndex, endIndex);
            let paginatedItemsObject = {"itemIds":paginatedItems};
            this.pagination.totalItemSize = paginatedItems.length;
            this.loader.text = "Data loading ...";
            this.loader.show = true;
            if (!_.isEmpty(paginatedItemsObject)) {

                //Commented the code as it was fetching only the page size items
                
                // axios.post('/dashboard/fetch-cfd-item-details/', paginatedItemsObject)
                //     .then(response => {
                //         // Set the array
                //         this.dataOfItems = response.data.map(item => {
                //             item.filterOn = true; // Add `filterOn` attribute to each item
                //             return item;
                //         });
                //         this.loader.show = false;
                //     })
                //     .catch(error => {
                //         console.error(error);
                //         this.loader.show = false;
                //     });
                //
                let paginatedItems = this.data.itemIds;
                this.data.total=paginatedItems.length;
                let sessionBoardId=this.data.sessionBoardId;
                let paginatedItemsObjectAllData = {"itemIds":paginatedItems,"sessionBoardId":sessionBoardId};
                this.loader.text = "Data loading ...";
                this.loader.show = true;
                axios.post('/dashboard/fetch-cfd-item-details/', paginatedItemsObjectAllData)
                    .then(response => {
                        this.dataOfItems = response.data;
                        if(this.data.radioButtonSelection ==='statusCategory'){
                            if(!_.isEmpty(this.data.itemStatusMap)){
                                this.dataOfItems.forEach(item => {
                                    const status = this.data.itemStatusMap[item.itemId];
                                    if (status) {
                                        let [before, after] = status[0].split("status_category:");
                                        item.status = before;
                                        item.category = after;
                                    } else {
                                        item.status = '';
                                    }
                                });
                            }
                        }
                        this.filterTeams=[];
                        // this.filterTeams = response.data
                        //     .filter(item => item.teams) // Only keep items that have a `teams` attribute
                        //     .map(item => item.teams);
                        this.filterTeams = response.data
                            .map(item => {
                                // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                return item.teams && Object.keys(item.teams).length > 0
                                    ? item.teams
                                    : { "No Team": "No Team-color:#594a21" };
                            });
                        this.filterSprints=[];
                        // this.filterSprints = response.data
                        //     .filter(item => item.sprints) // Only keep items that have a `sprints` attribute
                        //     .map(item => item.sprints);
                        this.filterSprints = response.data
                            .map(item => {
                                // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                return item.sprints && Object.keys(item.sprints).length > 0
                                    ? item.sprints
                                    : { "No Sprint": "No Sprint" };
                            });
                        this.filterIssueTypes=[];
                        this.filterIssueTypes = response.data
                            .map(item => {
                                // Check if tfsItemType exists and is not empty
                                if (item.tfsItemType && item.tfsItemType.trim() !== "") {
                                    return item.tfsItemType;
                                }
                                // Otherwise, check if jiraFieldByKeyIssueType exists and has a name
                                if (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name) {
                                    return item.jiraFieldByKeyIssueType.name;
                                }
                                // Return undefined if neither condition is met
                                return "Kendis Only";
                            })
                            // Filter out any undefined values
                            .filter(Boolean);
                        this.allDataOfItems = response.data.map(item => {
                            item.filterOn = true; // Add `filterOn` attribute to each item
                            return item;
                        });
                        this.allDataOfItems = this.allDataOfItems.map(item => {
                            // Check for tfsItemType or fallback to jiraFieldByKeyIssueType.name
                            if (item.tfsItemType && item.tfsItemType.trim() !== "") {
                                item.issueType = item.tfsItemType;  // Set issueType to tfsItemType if available
                            } else if (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name) {
                                item.issueType = item.jiraFieldByKeyIssueType.name;  // Otherwise, set issueType to jiraFieldByKeyIssueType.name
                            } else {
                                item.issueType = "Kendis Only"; // Optionally set to null if neither condition is met
                            }
                            if (!item.teams || Object.keys(item.teams).length === 0) {
                                item.teams = { "No Team": "No Team-color:#594a21" };
                            }
                            if (!item.sprints || Object.keys(item.sprints).length === 0) {
                                item.sprints = { "No Sprint": "No Sprint" };
                            }
                            return item; // Return the modified item
                        });
                        this.dumpDataOfItems = response.data.map(item => {
                            item.filterOn = true; // Add `filterOn` attribute to each item
                            return item;
                        });
                        this.allDataOfItems.sort((a, b) => {
                            // First sort by `jiraFieldByKey.parent.key` in ascending order
                            const keyA = a?.jiraFieldByKey?.parent?.key || '';
                            const keyB = b?.jiraFieldByKey?.parent?.key || '';
                            const keyComparison = keyA.localeCompare(keyB);

                            if (keyComparison !== 0) {
                                return keyComparison; // If keys are not equal, sort by key
                            }

                            // If keys are equal, sort by `status` priority
                            const priorityA = this.priorityMap[a.status] || Infinity; // Default to Infinity if status not in priorityMap
                            const priorityB = this.priorityMap[b.status] || Infinity;

                            return priorityA - priorityB; // Sort by status priority
                        });
                        this.dataOfItems=this.allDataOfItems.slice(startIndex, endIndex);
                        this.loader.show = false;
                        this.loaded=true;
                        this.filterTeamsForDropDown();
                        this.filterSprintsForDropDown();
                        this.filterIssueTypeForDropDown();
                        this.filterStatusForDropDown();
                    })
                    .catch(error => {
                        console.error(error);
                        this.loader.show = false;
                    });
            }
        },
        filterTeamsForDropDown:function(){


            this.filterTeams = [...new Set(
                this.filterTeams
                    .flatMap(item => Object.values(item)) // Extract all values from the map
                    .filter(value => value !== undefined) // Exclude undefined values
                    .map(value => value.split('-color')[0]) // Extract the part before "-color"
            )]
                .sort((a, b) => {
                    if (a === "No Team") return 1; // Always move "No Team" to the end
                    if (b === "No Team") return -1;
                    return a.localeCompare(b); // Sort alphabetically for other items
                })
                .map((title, index) => ({ id: index + 1, title })); // Add IDs


            this.filteredSelectedTeams = this.filterTeams
                .filter(team => team.title !== undefined)
                .map(team => team.title);
        },
        filterSprintsForDropDown:function(){
            this.filterSprints = [...new Set(
                this.filterSprints
                    .flatMap(item => Object.values(item)) // Extract all values from the map
                    .filter(value => value !== undefined) // Exclude undefined values
            )]
                .sort((a, b) => {
                    if (a === "No Sprint") return 1; // Always move "No Sprint" to the end
                    if (b === "No Sprint") return -1;
                    return a.localeCompare(b); // Sort alphabetically for other items
                })
                .map((title, index) => ({ id: index + 1, title })); // Add IDs


            this.filteredSelectedSprints = this.filterSprints.map(sprint => sprint.title);
        },
        filterIssueTypeForDropDown:function(){
            this.filterIssueTypes = [...new Set(this.filterIssueTypes.filter(item => item !== undefined))]
                .map((item, index) => ({ id: index + 1, title: item }));
            this.filteredSelectedIssueTypes=this.filterIssueTypes.map(team => team.title);
        },
        filterStatusForDropDown:function(){
            let uniqueStatuses = [...new Set(this.dataOfItems.map(item => item.status))];

            // Sort based on priority
            uniqueStatuses.sort((a, b) => {
                return (this.priorityMap[a] || 999) - (this.priorityMap[b] || 999);
            });

            this.filterStatus = uniqueStatuses.map((status, index) => ({
                id: index,   // Assign incremental ID
                title: status
            }));
            this.filteredSelectedStatus=uniqueStatuses;
        }
    }
});
