const kendisDashboardGraphOptions=Vue.component('kendis-dashboard-graph-options', {

    template:`
			<div id="overlay" class="overlay widgetOverlay" style="display: block;">	
			<div class="ui-dialog widgetLibraryPopup">
				<div class="widgetPopUpHeader DFCB">
					<span class="fs-18 ftsb widgetPopUpTitle">
						Widget Library
					</span>
					<em title="Close" class="rmv-ico ti-close rnd DAJ p-intial" @click="$emit('close')"></em>
				</div>
				<div class="widgetPopUpContentWraper">
                       <div class="widgetsListWrapper">
                        <ul class="widgetsList">
                            <li class="widgetsListItem" v-for="(graphType, index) in graphTypeGroups" 
                                :class="{ active: isActive(graphType.title) }"
                                @click="handleClickOFGraphBaseType(graphType.title)">
                                {{ graphType.title }}
                            </li>
                        </ul>
                      </div>

                     <div class="widgetsCardsListWrapper"  >
                        <div class="fs-18 ftsb mb-10 pd-10">Featured Widgets</div>
                        <ul class="widgetsCardsList" >
                            <li class="widgetsCard" v-for="(graphsType,index) in onSelectGraphTypeGiveOptions" @click = " onSelectFlowTimeGraph(selectedGraphType,graphsType,'For items in PI')" >
                                <div class="infotxt tooltip" v-if="!_.isEmpty(graphsType.tooltip)">
                                    <div class="hovtooltip" style="width: 200px;">{{graphsType.tooltip}}</div>
                                </div>
                                <div class="cardContent">
                                    <img :src="graphsType.imgSrc" alt=".." class="refreshIcon">
                                    <div>{{graphsType.title}}</div>
                                </div>
                            </li>
                        </ul>
                    </div>
				</div>
			</div>
			</div>
		`,

    props : {},
    watch : {},

    data() {
        return {
            graphTypeGroups 		: [],
            graphTypeGroupsOptions  : [],
            isOpened:false,
            graphBaseTypes:[],
            selectedGraphBaseType:null,
            selectedGraphType:'Flow Time Metrics',
            flowtimeGraphTypesOption:[],
            cfdGraphTypesOption:[],
            simplifiedSprintReportTypesOption:[]
        }
    },

    created() {
        this.loadGraphTypesGroups();
        this.onClickExpandGraphTypeGroupGetAllOpetions();
    },

    mounted() {
    },

    computed: {
		onSelectGraphTypeGiveOptions : function(){
			
			return this.graphTypeGroupsOptions[this.selectedGraphType];
		}
    },

    components: {

    },

    methods: {
        handleClickOFGraphBaseType:function(data){
            this.selectedGraphType = data;
        },
        isActive(title) {
            return title === this.selectedGraphType;
        },
        handleClickOFGraphType:function(data){
            this.selectedGraphType = data;
        },

        loadGraphTypesGroups : function(){
            let graphsTypes = [
                 {title : 'Collection Metrics'			 , label:'CM'    , id : 3,	expandedFlag : false},
                {title : 'Flow Time Metrics'		 , label:'DTM'	 , id : 1,	expandedFlag : false},
                {title : 'Coaches Goals'	     , label:'SS'    , id : 2,	expandedFlag : false},
                {title : 'Cumulative Flow Diagram' 	 , label:'CFD'  , id : 3    ,  expandedFlag : false},
                {title : 'General Purpose' 	 , label:'Notes'  , id : 4    ,  expandedFlag : false},
            ]
            this.graphTypeGroups = graphsTypes;
            let graphBaseTypes=[
                {title : 'Program Boards' 	 	, 	label:'PB'	,   id: 1 ,  expandedFlag : false},
                {title : 'Objectives & OKRs'	,	label:'OO'	,	id: 2 ,	expandedFlag : false},
                {title : 'Batches'				,	label:'BT'	,	id: 3 ,	expandedFlag : false},
                {title : 'Risk'					,	label:'RK'	,	id: 4 ,	expandedFlag : false},
                {title : 'Organization View'	,	label:'OV'	,	id: 5 ,	expandedFlag : false},
            ]
            this.graphBaseTypes = graphBaseTypes;
        },
        onClickExpandGraphTypeGroup : function(index){
            this.graphTypeGroups[index].expandedFlag = !this.graphTypeGroups[index].expandedFlag;

        },
        onClickExpandGraphTypeGroupGetAllOpetions : function(){
            let data = [
                {title : 'For items in PI' 	 			 , label : 'For items in PI'			, id : 1 },
                {title : 'For items in a Team in PI' 	 , label : 'For items in a Team in PI'	, id : 2 },
                {title : 'For items in a Sprint in PI' 	 , label : 'For items in a Sprint in PI', id : 3 },
                {title : 'For items in a Batch' 	 	 , label : 'For items in a Batch'		, id : 4 },
                {title : 'For Backlog Items (Org)' 	 	 , label : 'For Backlog Items (Org)'	, id : 5 },]

            let graphsTypesOptions = [
                 {title : 'Cumulative Flow Diagram' 	 , label : 'Cumulative Flow Diagram' , id : 1 , data : data ,imgSrc :'/assets/icons/cumulative -Flow -diagram.svg',type:'cfd-graph',tooltip:"The Cumulative Flow Diagram (CFD) shows the number of work items in each stage of a workflow over time, helping visualize progress, work in progress (WIP), and bottlenecks."},
            ]
            this.cfdGraphTypesOption=graphsTypesOptions;

            let piegraphdata 			  = [{title : 'For Backlog Items (Org)' , label : 'For Backlog Items (Org)', id : 1 },];

            let widgetGraphTypesOptions   = [
				{title : 'By Backlog' 	 	 				 , label : 'By Backlog'      			   , id : 1 , data : [] ,imgSrc:'/assets/icons/dpendcy-wheel.svg'},
				{title : 'Item Completion by Teams' 	 	 , label : 'Item Completion by Teams'      , id : 2 , data :  [] ,imgSrc: '/assets/icons/scope-team.svg'},
			]
            let flowtimeGraphTypesOption  = [{title : 'For items in PI' , label : 'For items in PI', id : 1 },{title : 'For Backlog Items (Org)' , label : 'For Backlog Items (Org)', id : 2 }];
            let collectionTypesOption  = [{title : 'For Backlog Items' , label : 'For Backlog Items', id : 1 },{title : 'For Backlog Items (Org)' , label : 'For Backlog Items (Org)', id : 2 }];

            this.flowtimeGraphTypesOption = flowtimeGraphTypesOption;
            
            let flowTimeGraphTypesOptions = [
	                {title : 'Time in Status' 	 	 	, label : 'Time in Status'			, id : 1 , data : flowtimeGraphTypesOption ,imgSrc: '/assets/icons/time-status.svg', type:'cycle-time-graph',category:'Cycle Time Graph', tooltip:"Cycle Time Widget displays the time it takes the items to transition from one status to another based on selected criteria."},
	                {title : 'Lead Time Graph'  	 	, label : 'Lead Time Graph'			, id : 2 , data : flowtimeGraphTypesOption ,imgSrc: '/assets/icons/lead-time.svg', type:'lead-time-graph',category:'Lead Time Graph', tooltip:"Lead Time Widget displays the time taken by the items to transition from their creation date to Done date (or from the user defined start and end status), helping track progress and task duration."},
	                {title : 'Flow Time Graph'  	, label : 'Flow Time Graph'	, id : 3 , data : flowtimeGraphTypesOption ,imgSrc: '/assets/icons/flow-time.svg', type:'flow-time-graph',category:'Flow Time Graph', tooltip:"Flow Time widget displays the time (in days) taken by the PI items to transition between the workflows based on selected criteria."},
	                {title : 'Flow Efficiency Graph' 	, label : 'Flow Efficiency Graph'	, id : 4 , data : flowtimeGraphTypesOption ,imgSrc: '/assets/icons/flow-efficency.svg', type:'flow-efficiency-graph',category:'Flow Efficiency Graph', tooltip:"A Flow Efficiency graph shows the percentage of active time compared to the total time an item spends in a workflow, helping users assess how efficiently work is progressing based on selected criteria."},
	                {title : 'Flow Velocity Graph'   	, label : 'Flow Velocity Graph'		, id : 5 , data : flowtimeGraphTypesOption ,imgSrc: '/assets/icons/flow-velocity.svg', type:'flow-velocity-graph',category:'Flow Velocity Graph', tooltip:"Flow Velocity Widget displays the number of completed items over a specified time period, tracking completion trends and workflow efficiency."},
	                {title : 'Flow Load Graph'  		, label : 'Flow Load Graph'			, id : 5 , data : flowtimeGraphTypesOption ,imgSrc: '/assets/icons/flow-load.svg', type:'flow-load-graph',category:'Flow Load Graph', tooltip:"Flow Load Widget displays the total number of active and waiting items, based on selected criteria and grouping." },
	                {title : 'Flow Distribution Graph'  , label : 'Flow Distribution Graph'	, id : 6 , data : flowtimeGraphTypesOption ,imgSrc: '/assets/icons/flow-distribution.svg', type:'flow-distribution-graph',category:'Flow Distribution Graph', tooltip:"Flow Distribution Widget displays the distribution of items over time, based on selected statuses and grouping criteria."},
	             ];


            let collectionGraphsTypesOptions = [
                {title : 'Pie Chart' , label : 'Pie Chart' , id : 1 , data : collectionTypesOption ,imgSrc: '/assets/icons/time-status.svg', type:'collections-pie-chart',category:'Pie Chart', tooltip:"This pie chart helps you make informed decisions by showing how items in your collection backlog are distributed across different categories. Use it to quickly assess the current state of your backlog and prioritize actions based on the selected grouping."},
                {title : 'Column Chart' , label : 'Column Chart' , id : 1 , data : collectionTypesOption ,imgSrc: '/assets/icons/time-status.svg', type:'collections-col-chart',category:'Column Chart',tooltip:"This column chart displays the distribution of items in your release train backlog based on the selected grouping field. Each column represents a category within the chosen field, allowing you to compare the number of items across different groups at a glance."},

            ];


            // let simplifiedSprintReportTypesOption=[
            //     {title : 'Completion by Teams', label : 'Completion by Teams', id : 1 , data : [] ,imgSrc: '/assets/icons/time-status.svg', type:'completed-stories',category:'Completion by Teams'},
            //     // {title : 'Scope Change', label : 'Scope Change', id : 1 , data : [] ,imgSrc: '/assets/icons/time-status.svg', type:'scope-change',category:'Scope Change'},
            //
            // ]
            let simplifiedSprintReportTypesOption=[
                {title : 'Completion by Teams', label : 'Completion by Teams', id : 1 , data : [] ,imgSrc: '/assets/icons/time-status.svg', type:'completed-stories',category:'Completion by Teams'},
                // {title : 'Scope Change', label : 'Scope Change', id : 1 , data : [] ,imgSrc: '/assets/icons/time-status.svg', type:'scope-change',category:'Scope Change'},

            ]


            let generalPurposeOptions=[
                {title : 'Notes', label : 'Notes', id : 1 , data : [] ,imgSrc: '/assets/icons/notes-54.svg', type:'general-purpose',category:'General Purpose', tooltip:"A personal notepad for your dashboard. Write, format, and save rich-text notes—ideal for reminders, brainstorming, or quick references."},
            ]


            // this.graphTypeGroupsOptions["Custom Graphs"] = widgetGraphTypesOptions;
            this.graphTypeGroupsOptions["Flow Time Metrics"] = flowTimeGraphTypesOptions;

            this.graphTypeGroupsOptions["Coaches Goals"] = simplifiedSprintReportTypesOption;

            this.graphTypeGroupsOptions["Cumulative Flow Diagram"] = graphsTypesOptions;

            this.graphTypeGroupsOptions["Collection Metrics"] = collectionGraphsTypesOptions;

            this.graphTypeGroupsOptions["General Purpose"] = generalPurposeOptions;

        },

        onSelectFlowTimeGraph:function(graphTypeOpt,optionType,graphType){
            let selectedGroup = this.graphTypeGroups.find(item=>item.title == graphTypeOpt);
            if(optionType.title === 'By Backlog'){
                graphType = 'For Backlog Items (Org)';
            }
            let selectedGraphType = this.flowtimeGraphTypesOption.find(item=>item.title == graphType);
            delete optionType.data
            let selectedOptions = {graphTypeOption : selectedGroup, optionType: optionType ,graphType : selectedGraphType};
            this.$emit('close',selectedOptions);
        },
        
        onSelectCFDGraph:function(graphTypeOpt,optionType,graphType){
            let selectedGroup = this.graphTypeGroups.find(item=>item.title == graphTypeOpt);
            let selectedGraphType = this.flowtimeGraphTypesOption.find(item=>item.title == graphType);
            delete optionType.data
            let selectedOptions = {graphTypeOption : selectedGroup, optionType: optionType ,graphType : selectedGraphType};
            this.$emit('close',selectedOptions);
        },
        
        onSelectGraphFromGivenOptions : function(graphTypeOpt,optionType,graphType){
            delete optionType.data
            let selectedOptions = {graphTypeOption : graphTypeOpt, optionType: optionType ,graphType : graphType};
            this.$emit('close',selectedOptions);
        }
    },
})
