const CONFIG_POPUP =
{
	name: "configuration-popup",
	template:
`
<div class="confgpopup">
	<div id="overlay" class="overlay" style="display: block;"></div>
	
	<div class="add-pop ui-dialog confgin p-fix" style="display: block;">
		<div class="head">	
			<span v-if="!myConfig.id" class="hdins">New Connection <span class="infotxt tooltip mht ml-10"><span class="hovtooltipB wid3 lft">Create a new connection by selecting your Azure DevOps organization, project, and work item types.</span></span> </span>
			<span v-else class="hdins">Edit Connection</span>			
			<em href="javascript:void(0);" title="Close" class="rmv-ico ti-close" @click="onClickCancelButton"></em>
		</div>
		
		<tfs-link-projects v-if="linkPropjectPopup.show"
			:alm="almAccount"
			:config-id="myConfig.id"
			@close="onProjectPopupClose"
			@linked="onProjectPopupLinked"
		/>
		
		<div v-if="loader.show" class="loader"><div><div class="loaderinteg"></div><span class="LOADER-TITLE" v-html="loader.text"></span></div></div>
		<div class="py-20 px-40 prow">
			<div id="div-tabs" class="mrow tbout">
				<ul id="ul-tabs" class="maintabs grn">
					<li class="tabgenrl ftsb" :class="{'active':(tabIndex == 0)}" @click="onChangeTab(0);">Connection Info</li> 
					<li v-if="myConfig.id && almAccount && almAccount.type == 'tfs'" class="tabgenrl ftsb" :class="{'active':(tabIndex == 1)}" @click="onChangeTab(1);">AzureDevops Projects</li> 
					<li v-if="myConfig.id && almAccount && almAccount.type == 'tfs'" class="tabgenrl ftsb" :class="{'active':(tabIndex == 2)}" @click="onChangeTab(2);">Risk Mapping</li>
				</ul>
			</div>
		
		<div class="cntr prow maintbcont">
			<template v-if="tabIndex == 0">
				<div class="rec lblm">
					<label>Connection Name</label> 
					<input v-model="myConfig.title" maxlength="255" placeholder="Max. 255 characters" type="text" class="prfx rnd4" :class="{'red':validationErrors.title}"/>
				</div>
				
				<div class="rec lblm half">
					<label>Alm Account</label> 
					<div class="selectcont rnd4" :class="{'required':validationErrors.almAccount}">
						<vz-select :multiple="false" title="Alm Account" :disabled="myConfig.id"
							empty-selection-text="" class="multi-filter" label="name"
							value-type="object" :options="almAccounts"
							v-model="almAccount" @select="onGeneralChangeAlm"
							/>
					</div>
				</div>
			</template>
			
			<template v-if="tabIndex == 1">				
			<div class="rec">
				<div class="gtfthd rnd4">
					<span class="ftsb lb">Project List</span>					
					<a href="javascript:void(0);" class="url FR ftsb" @click="onTfsProjectAddProject">Add Project</a> 
				</div>
				<ul>
					<li v-for="project in tfsProjects" class="FILTER mrec">
						<div class="rc c1 mn">
							<em class="ti-angle-down arrd"></em>
							{{project.name}}
							<a href="javascript:void(0);" id="icttp-prjResync" title="Resync Project" class="vwflt url rsy ftsb" @click="onTfsProjectClickResync(project);"><em class="refsh-resyncico DIB mr-5 mt-1 FL"></em>Resync</a>
							<!-- <a href="javascript:void(0);" id="icttp-prjRemove" title="Remove Project" class="vwflt url rmv ti-close red-t" @click="onTfsProjectClickRemove(project);">Remove</a> -->
						</div>
					</li>
				</ul>
			</div>
			</template>
			
			<template v-if="tabIndex == 2">
				<div class="rskmpng prow">					
					<div class="rec lblm">
						<label class="ftsb lb">Select Azure DevOps Project * <a href="javascript:void(0);" class="url FR ftsb" @click="onRiskMappingLoadProject">Add Project</a></label>
						<div class="selectcont rnd4" :class="{required:riskMapping.validationError.tfsProjectId}">
							<vz-select :multiple="false" title="Azure DevOps Project"
								empty-selection-text="" class="multi-filter" label="name"
								:options="riskMapping.tfsProjects"
								value-type="value"
								v-model="riskMapping.tfsProjectId" @select="onRiskMappingSelectProject"
								/>
						</div>
					</div>
					<template v-if="riskMapping.tfsProjectId">
						<div class="rec lblm">
							<label>Item Type *</label> 
							<div class="selectcont rnd4" :class="{required:riskMapping.validationError.itemType}">
								<vz-select :multiple="false" title=""
									empty-selection-text="" class="multi-filter" 
									value-type="value"
									:options="riskMapping.itemTypes"
									v-model="riskMapping.itemType"
									@select="onSelectRiskItemType"
									/>
							</div>
						</div>
						<div class="rec lblm">
							<label>Link Type *</label> 
							<div class="selectcont rnd4" :class="{required:riskMapping.validationError.linkType}">
								<vz-select :multiple="false" title=""
									empty-selection-text="" class="multi-filter" 
									:options="riskMapping.linkTypes"
									value-type="value"
									v-model="riskMapping.linkType"
									/>
							</div>
						</div>						
						<div class="rec lblm" v-for="fieldMapping in riskMapping.fieldMappings">
							<label>{{fieldMapping.name}} {{(fieldMapping.mandatory ? ' *' : '')}}</label> 
							<div class="selectcont rnd4" :class="{required:fieldMapping.error}">
								
								<template v-if="fieldMapping.id == 'raisedDate' || fieldMapping.id == 'resolutionDate'">
									<vz-select :multiple="false" title=""
										empty-selection-text="" class="multi-filter" 
										:options="riskMapping.dateFieldOptions"
										value-type="value"
										v-model="fieldMapping.value"
										/>
								</template>
								<template v-else-if="fieldMapping.id == 'description' || fieldMapping.id == 'mitigationAction'">
									<vz-select :multiple="false" title=""
										empty-selection-text="" class="multi-filter" 
										:options="riskMapping.richTextFieldOptions"
										value-type="value"
										v-model="fieldMapping.value"
										/>
								</template>
								<template v-else>
									<vz-select :multiple="false" title=""
										empty-selection-text="" class="multi-filter" 
										:options="riskMapping.fieldsOptions"
										value-type="value"
										v-model="fieldMapping.value"
										/>
								</template>
								
							</div>
						</div>
						
						<div class="rec lblm" v-for="(fieldMapping, index) in riskMapping.customFieldMappings" :key="fieldMapping.id" >
							<label>{{fieldMapping.name}}</label> 
							<div class="selectcont rnd4" :class="{required:fieldMapping.error}">
								<vz-select :multiple="false" title=""
									empty-selection-text="" class="multi-filter" 
									:options="riskMapping.fieldsOptions"
									value-type="object"
									:value="fieldMapping.value"
									@select="onSelectCustomFieldValue(fieldMapping, $event);"
									/>
								<em @click="onClickRemoveCustomField(fieldMapping, index);" title="Remove" class="rmv-ico ti-close c-point"></em>
							</div>
							
						</div>
						<div class="rec lblm" >
							<div class="selectcont rnd4" :class="{required:riskMapping.customFields.addFieldError}">
								<vz-select :multiple="false" title=""
									empty-selection-text="" class="multi-filter" 
									:options="riskMapping.fieldsOptions"
									value-type="object"
									v-model="riskMapping.customFields.addFieldValue"
									/>
							</div>	
							<a href="javascript:void(0);" @click="onClickAddCustomField" class="ti-plus addf mt-10 DIB"> Add Field </a>
						</div>	
					</template>
				</div>
			</template>
			
		</div>
		<div v-if="tabIndex == 0" class="rec btn">
			<button class="FR rnd6" @click="onClickSaveButton(false);">Save</button>
			<button class="FR rnd6 mr-10" @click="onClickSaveButton(true);">Save & Close</button>
			<a href="javascript:void(0);" class="cncl FR" @click="onClickCancelButton">Close</a>
		</div>
		<div v-if="tabIndex == 2" class="rec btn">
			<button class="FR rnd6" @click="onRiskMappingClickSaveButton(false);">Save</button>
			<button class="FR rnd6 mr-10" @click="onRiskMappingClickSaveButton(true);">Save & Close</button>
		</div>
	</div>
	</div>
</div>
`,
	props: ["config"],
	
	data() {
		return {
			loader: {
				show: false,
				text: ""
			},
			
			tabIndex: 0,
			
			//......   general tab
			myConfig:{
				title: "",
			},
			validationErrors: {
				title: false,
				almAccount: false,
			},
			
			almAccounts:[],
			almAccount: undefined,
			
			//.....   tfs projects
			linkPropjectPopup: {
				show: false,
			},
			tfsProjects: [],
			
			//.....   risk mapping
			riskMapping: {
				tfsProjects: [],
				tfsProject: undefined,
				tfsProjectId: undefined,
				tfsProjectName: undefined,
				
				itemTypes:[],
				itemType: undefined,
				
				fieldMappings: [
					{id:"title",name:"Title", value: "System.Title", error: false, mandatory: true},
					{id:"status",name:"Status", value: "System.State", error: false, mandatory: true},
					{id:"raisedDate",name:"Raised On", value: undefined, error: false, mandatory: false},
					{id:"resolutionDate",name:"Target Resolution Date", value: undefined, error: false, mandatory: false},
					
					{id:"description",name:"Description", value: undefined, error: false, mandatory: false},
					{id:"mitigationAction",name:"Mitigation Actions", value: undefined, error: false, mandatory: false}
				],
				
				customFields: {
					addFieldValue: undefined,
					addFieldError: false,	
				},
				customFieldMappings: [ ],
				
				linkTypes: [],
				linkType: undefined,
				
				fieldsOptions : [],
				dateFieldOptions: [],
				richTextFieldOptions: [],
				
				validationError: {
					tfsProjectId: false,
					itemType: false,
					linkType: false
				}
			}
		}
	},
	created() {
		if (this.config) {
			this.myConfig = _.cloneDeep(this.config);
			if (!this.myConfig.title) {
				this.myConfig.title = "";
			}
			if (!this.config.id) {
				this.loadMetaGeneral();
			}
			else {
				if (this.myConfig.almAccount) {
					this.almAccount = this.myConfig.almAccount;
					this.almAccounts = [this.almAccount];
				}
			}
		}
		else {
			
		}
	},
	mounted() {

	},
	computed: {

	},
	methods: {
		///////////////////////////////////////////
		/////////    LOGIC
		validateSaveConfig: function () {
			this.myConfig.title = this.myConfig.title.trim();
			this.validationErrors.title = _.isEmpty(this.myConfig.title);
			
			this.validationErrors.almAccount = _.isEmpty(this.almAccount);
			
			if (this.validationErrors.title || this.validationErrors.almAccount) {
				return false;
			}
			
			return true;
		},
		validateSaveRiskMapping: function () {
			this.riskMapping.validationError.tfsProjectId = _.isEmpty(this.riskMapping.tfsProjectId);
			this.riskMapping.validationError.itemType = _.isEmpty(this.riskMapping.itemType);
			this.riskMapping.validationError.linkType = _.isEmpty(this.riskMapping.linkType);
			
			let anyFeild = false;
			_.each(this.riskMapping.fieldMappings, fieldMapping=> {
				if (fieldMapping.mandatory) {
					fieldMapping.error = _.isEmpty(fieldMapping.value);
					if (fieldMapping.error) {
						anyFeild = true;
					}
				}
			});
			if (this.riskMapping.validationError.tfsProjectId ||
				this.riskMapping.validationError.itemType || 
				this.riskMapping.validationError.linkType || 
				anyFeild) {
				
				return false;
			}
			return true;
		},
		riskSetSelectedProject: function (project, resetMapping) {
			if (resetMapping) {
				this.resetRiskMapping();
			}
			
			this.riskMapping.tfsProject = project;
			this.riskMapping.tfsProjectTfsId = project.tfsId;
			this.riskMapping.tfsProjectName = project.name;
			
			let itemTypesJSON = JSON.parse(this.riskMapping.tfsProject.itemTypesJSON);
			if (itemTypesJSON) {
				let itemTypes = [];
				_.each(itemTypesJSON.value, itemType=> {
					let data = {id: itemType.referenceName, title: itemType.name};
					itemTypes.push(data);
				});
				this.riskMapping.itemTypes = itemTypes;
			}
			if (this.riskMapping.riskItemTypeName) {
				this.riskSetSelectedItemType();
			}
		},
		riskSetSelectedItemType: function () {
			
			let itemTypesJSON = JSON.parse(this.riskMapping.tfsProject.itemTypesJSON);
			if (itemTypesJSON) {
				var itemTypeJson = _.find(itemTypesJSON.value, { name: this.riskMapping.riskItemTypeName });
				if (itemTypeJson) {
					var fields = itemTypeJson.fieldsWithAllowedValues.value;

					let ignoreSystemFeildsMap = {};
					//ignoreSystemFeildsMap["System.Title"] = true;
					//ignoreSystemFeildsMap["System.State"] = true;
					ignoreSystemFeildsMap["System.IterationId"] = true;
					ignoreSystemFeildsMap["System.AreaId"] = true;

					let allfields = [];
					let richTextFieldOptions = [];
					let dateFieldOptions = [];

					_.each(fields, field => {
						if (!ignoreSystemFeildsMap[field.referenceName]) {
							let data = { id: field.referenceName, title: field.name, type: field.type };
							allfields.push(data);

							if (field.type == "html") {
								richTextFieldOptions.push(data);
							}
							else if (field.type == "dateTime" || field.type == "date") {
								dateFieldOptions.push(data);
							}
						}
					});

					this.riskMapping.richTextFieldOptions = richTextFieldOptions;
					this.riskMapping.fieldsOptions = allfields;
					this.riskMapping.dateFieldOptions = dateFieldOptions;
				}
			}
			
		},
		resetRiskMapping: function () {
			
			this.riskMapping.riskItemTypeName = undefined;
			this.riskMapping.itemType = undefined;
			this.riskMapping.linkType = undefined;
			this.riskMapping.fieldsOprions = [];
			
			
			this.riskMapping.customFields.addFieldValue = undefined;
			this.riskMapping.customFields.addFieldError = false;
			
			this.riskMapping.customFieldMappings = [];
			
			_.each(this.riskMapping.fieldMappings,fieldMapping=> {
				if (fieldMapping.id == "title") {
					fieldMapping.value = "System.Title";
				}else if (fieldMapping.id == "status") {
					fieldMapping.value = "System.State";
				}
				else
					fieldMapping.value = undefined;
			});
		},
		initRiskMappingTab: function () {
			
			this.riskMapping.tfsProjectId    = this.myConfig.tfsProjectId;
			this.riskMapping.tfsProjectTfsId = this.myConfig.tfsProjectTfsId;
			this.riskMapping.tfsProjectName  = this.myConfig.tfsProjectName;
			
			if (this.riskMapping.tfsProjectId) {
				this.riskMapping.linkType = this.myConfig.riskLinkType;
				this.riskMapping.itemType = this.myConfig.riskItemType;
				this.riskMapping.riskItemTypeName = this.myConfig.riskItemTypeName;

				let rfmMap = {};
				_.each(this.myConfig.riskFieldsMappings, rfm => {
					rfmMap[rfm.id] = rfm;
				});
				_.each(this.riskMapping.fieldMappings, fieldMap => {
					if (rfmMap[fieldMap.id]) {
						fieldMap.value = rfmMap[fieldMap.id].value;
					}
				});
				if (this.myConfig.riskCsutomFieldsMappings) {
					
					let riskCsutomFieldsMappings = [];
					_.each(this.myConfig.riskCsutomFieldsMappings, cfm=> {
						let data = _.clone(cfm);
						data.value = _.clone(data);
						riskCsutomFieldsMappings.push(data);
					});
					this.riskMapping.customFieldMappings = riskCsutomFieldsMappings;
				}
			}
			this.loadMetaRiskMapping();
		},
		///////////////////////////////////////////
		/////////    API
		loadMetaGeneral: function () {
			
			let _this = this;
			
			_this.loader.text = "";
			_this.loader.show = true;
			
			axios.get("/configAndMapping/configMetaGeneral")
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						let almAccounts = response.data.almAccounts;
						almAccounts = _.filter(almAccounts, account=> {
							return account.type && account.type == "tfs";
						});
						_this.almAccounts = almAccounts;
					}
				})
				.catch(error => {
					_this.loader.show = false;
				});
		},
		loadMetaTfsProjects: function () {
			
			let _this = this;
			
			_this.loader.text = "";
			_this.loader.show = true;
			
			axios.get("/configAndMapping/configMetaTfsProjects/"+this.myConfig.id)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						let tfsProjects = response.data.tfsProjects;
						_this.tfsProjects = tfsProjects;
					}
				})
				.catch(error => {
					_this.loader.show = false;
				});
		},
		loadMetaRiskMapping: function () {
			
			let _this = this;
			
			_this.loader.text = "";
			_this.loader.show = true;
			
			axios.get("/configAndMapping/configMetaRiskMapping/"+this.myConfig.id)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						let tfsProjects = response.data.tfsProjects;
						_this.riskMapping.tfsProjects = tfsProjects;
						
						let tfsLinkTypes = response.data.tfsLinkTypes;
						if (tfsLinkTypes.almError) {
							let reason = tfsLinkTypes.almError.reason;
							alertFromSweetAlertWrapper(reason);
							return;
						}
						tfsLinkTypes = JSON.parse(tfsLinkTypes);
						if (tfsLinkTypes) {
							
							let linkTypes = [];
							_.each(tfsLinkTypes.value,v=> {
								let data = {};
								data.id = v.referenceName;
								data.title = v.name;
								linkTypes.push(data);
							});
							_this.riskMapping.linkTypes = linkTypes;
						}
						
						if (response.data.selectedTfsProject) {
							_this.riskSetSelectedProject(response.data.selectedTfsProject, false);
						}
					}
				})
				.catch(error => {
					_this.loader.show = false;
				});
		},
		saveConfig: function (config, close) {
			
			let _this = this;
			
			_this.loader.text = "";
			_this.loader.show = true;
			
			if (this.almAccount) {
				config.almAccount = this.almAccount;
			}
			
			axios.post("/configAndMapping/saveConfig", config)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						if (response.data.success) {
							let newConfig = response.data.config;
							_this.myConfig = newConfig;
							showTopMessage("Configuration has been saved","success");
							if (!config.id) {
								_this.$emit("created", newConfig, close);
							}
							else {
								_this.$emit("updated", newConfig, close);
							}
						}
					}
				})
				.catch(error => {
					_this.loader.show = false;
				});
		},
		///////////////////////////////////////////
		/////////    EVENTS
		onClickCancelButton: function () {
			this.$emit("close");
		},
		onClickSaveButton: function (close) {
			if (this.validateSaveConfig()) {
				this.saveConfig(this.myConfig, close);
			}
		},
		onGeneralChangeAlm: function () {
			
		},
		onChangeTab: function (index) {
			
			if (index != 0) {
				if (!this.myConfig.id) {
					return;
				}
			}
			
			this.tabIndex = index;
			if (index == 1) {
				this.loadMetaTfsProjects();
			}
			else if (index == 2) {
				this.initRiskMappingTab ();
			}
		},
		//.........  tfs project
		onTfsProjectAddProject: function () {			
			this.linkPropjectPopup.show = true;
		},
		onTfsProjectClickResync: function (project) {
			
			let _this = this;

			_this.loader.text = "Wait" + getAlmUserInfoHTML(true, this.almAccount);
			_this.loader.show = true;
			
			let data = {};
			
			data.tfsProjectId = project.tfsId;
			data.almId = this.almAccount.id;
			
			var requestId = getNewUUID();
			var syncId = getNewUUID();
            data.syncId = syncId + "#" + requestId;
            
            data.metaMap = "{}";

            startPoll(requestId, "onResyncTfsProjectCompleted", _this);
			
			axios.post("/releasetrain/resync-tfs-project", data)
				.then(response => {
					//_this.loader.show = false;
				})
				.catch(error => {
					_this.loader.show = false;
				});
		},
		onResyncTfsProjectCompleted: function (response) {
			requestParam = JSON.parse(response.requestParam);
			this.loader.show = false;
			if (requestParam) {
				if (requestParam.success) {
					let project = requestParam.project;
				}
			}
		},
		onTfsProjectClickRemove: function (project) {
			
		},
		//........   link tfs project popup
		onProjectPopupClose: function () {
			this.linkPropjectPopup.show = false;
		},
		onProjectPopupLinked: function (project) {
			if (this.tabIndex == 1) {
				this.tfsProjects.push(project);
			}
			else if (this.tabIndex == 2) {
				this.riskMapping.tfsProjects.push(project);
			}
		},
		//......    risk mapping
		onSelectRiskItemType: function (itemType) {
			let field = _.find(this.riskMapping.itemTypes,{id: itemType});
			if (field) {
				this.riskMapping.riskItemTypeName = field.title;
				this.riskSetSelectedItemType();
			}
		},
		onRiskMappingLoadProject: function () {
			this.linkPropjectPopup.show = true;
		},
		onRiskMappingClickSaveButton: function (close) {
			if (this.validateSaveRiskMapping()) {
				
				let config = _.cloneDeep(this.myConfig);
				
				config.tfsProjectId = this.riskMapping.tfsProjectId;
				config.tfsProjectTfsId = this.riskMapping.tfsProjectTfsId;
				config.tfsProjectName = this.riskMapping.tfsProjectName;
				
				config.riskItemType = this.riskMapping.itemType;
				config.riskItemTypeName = this.riskMapping.riskItemTypeName;
				
				config.riskLinkType = this.riskMapping.linkType;
				
				let riskFieldsMappings = [];
				_.each(this.riskMapping.fieldMappings,mapping=>{
					let data = {};
					data.id = mapping.id;
					data.title = mapping.title;
					data.value = mapping.value;
					riskFieldsMappings.push(data);
				});
				let customFieldMappings = [];
				_.each(this.riskMapping.customFieldMappings,mapping=>{
					let data = {};
					data.id = mapping.id;
					data.name = mapping.name;
					data.type = mapping.type;
					customFieldMappings.push(data);
				});
				config.riskCsutomFieldsMappings = customFieldMappings;
				config.riskFieldsMappings = riskFieldsMappings;
				
				this.saveConfig(config, close);
				
			}
		},
		onRiskMappingSelectProject: function () {
			
			let _this = this;

			_this.loader.text = "";
			_this.loader.show = true;
			
			axios.get("/configAndMapping/getTfsProjectDetails/"+this.riskMapping.tfsProjectId+"/"+this.almAccount.id)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						if (response.data.success) {
							let tfsProject = response.data.tfsProject;
							_this.riskSetSelectedProject(tfsProject, true);
						}
					}
				})
				.catch(error => {
					_this.loader.show = false;
				});
		},
		onClickAddCustomField: function () {
			
			if (_.isEmpty(this.riskMapping.customFields.addFieldValue)) {
				this.riskMapping.customFields.addFieldError = true;
				return;
			}			
			let field = this.riskMapping.customFields.addFieldValue;
			
			let find = _.find(this.riskMapping.customFieldMappings,{id: field.id});
			if (!find) {
				find = _.find(this.riskMapping.fieldMappings,{value: field.id});
			}
			
			if (find) {
				showTopMessage("Field already selected","warning");
				return;
			}
			
			let data = {id:field.id, name:field.title, type:field.type, value: field};
			this.riskMapping.customFieldMappings.push(data);
			
			this.riskMapping.customFields.addFieldValue = undefined;
			this.riskMapping.customFields.addFieldError = false;
		},
		onClickRemoveCustomField: function (customFieldMapping, index) {
			this.riskMapping.customFieldMappings.splice(index, 1);
		},
		onSelectCustomFieldValue: function (customFieldMapping, value) {
			
			customFieldMapping.id = value.id;
			customFieldMapping.name = value.title;
			customFieldMapping.type = value.type;
			customFieldMapping.value = value;
		}
	}
};
