// Add CSS for error tooltip styling
const errorTooltipStyle = document.createElement('style');
errorTooltipStyle.textContent = `
    .b-sch-tooltip-error {
        color: #ff4444;
        font-weight: bold;
        margin-top: 5px;
        padding: 3px 6px;
        background-color: #ffe6e6;
        border-radius: 3px;
        border-left: 3px solid #ff4444;
    }
`;
if (!document.getElementById('bryntum-drag-helper-error-styles')) {
    errorTooltipStyle.id = 'bryntum-drag-helper-error-styles';
    document.head.appendChild(errorTooltipStyle);
}

class UnplannedGrid extends  bryntum.schedulerpro.TreeGrid {
    /**
     * Original class name getter. See Widget.$name docs for the details.
     * @returns {string}
     */
    static get $name() {
        return 'UnplannedGrid';
    }

    // Factoryable type name
    static get type() {
        return 'unplannedgrid';
    }

}
class Task extends  bryntum.schedulerpro.EventModel {


    static get defaults() {
        return {
            // In this demo, default duration for tasks will be hours (instead of days)
            durationUnit : 'd',

            // Use a default name, for better look in the grid if unassigning a new event
            title	 : 'New event',

            // Use a default icon also
            iconCls : 'b-fa b-fa-asterisk'
        };
    }
}
class DragHelperItemsRoadmap extends bryntum.schedulerpro.DragHelper {
    static get configurable() {
        return {
            callOnFunctions      : true,
            // Don't drag the actual row element, clone it
            cloneTarget          : true,
            // We size the cloned element manually
            autoSizeClonedTarget : false,
            // Only allow drops on the schedule area
            dropTargetSelector   : '.b-timeline-subgrid',
            // Only allow drag of row elements inside on the unplanned grid
            targetSelector       : '.b-grid-row:not(.b-group-row)'
        };
    }

    afterConstruct() {
        // Configure DragHelper with schedule's scrollManager to allow scrolling while dragging
        this.scrollManager = this.schedule.scrollManager;
    }
    createProxy(element) {
        const
            { schedule }    = this,
            { eventHeight } = schedule.features,
            // newSize         = schedule.timeAxisViewModel.getDistanceForDuration(job.durationMS);
            newSize = 200

        try {
            let event = this.grid.getRecordFromElement(element)
            let cacheditem = roadmapVue.itemsByIdMap[event.originalData.id.split('_')[0]]
            // Make a drag proxy element that looks like an event bar
            return vueInstance.$options.ROADMAP_MODULE.DomHelper.createElement({
                className: 'b-sch-event-wrap b-nested-event b-unassigned kendis-dragged-item',
                style: {
                    width: newSize,
                    height: eventHeight,
                    zIndex: '999'
                },
                children: [
                    {
                        className: 'kendis-dragged-proxy',
                        style: {
                            backgroundColor: 'hsl(200deg 100% 70%)',
                            width: newSize,
                        },
                        children: [
                            {
                                className: 'kendis-dragged-proxy-key',
                                text: generateKey(cacheditem),
                            },
                            {
                                className: 'kendis-dragged-proxy-text elips',
                                text: cacheditem.title
                            }
                        ]
                    }
                ]
            });
        }catch (e) {
            console.log(e);

            return vueInstance.$options.ROADMAP_MODULE.DomHelper.createElement({
                text: event.title
            });
        }
    }
    /*createProxy(element) {
        const
            proxy        = document.createElement('div'),
            { schedule } = this,
            task         = this.grid.getRecordFromElement(element),
            durationInPx = schedule.timeAxisViewModel.getDistanceForDuration(task.durationMS);

        // Fake an event bar
        proxy.classList.add('b-sch-event-wrap', 'b-sch-style-border', 'b-unassigned-class', 'b-sch-horizontal');
        proxy.innerHTML = `<div class="b-sch-event b-has-content b-sch-event-withicon">
        <div class="b-sch-event-content">
         ${task.title}
        </div>
        </div>`;

        if (schedule.isHorizontal) {
            proxy.style.height = `100px`;
            proxy.style.width  = `200px`;
        }
        else {
            proxy.style.height = `100px`;
            proxy.style.width  = `200px`;
        }

        return proxy;
    }*/

    onDragStart({ context }) {
        roadmapVue.isdragRemoveFromGrid = true;
        const
            me                          = this,
            { schedule }                = me,
            { eventTooltip, eventDrag } = schedule.features;

        // save a reference to the task so we can access it later
        context.task = me.grid.getRecordFromElement(context.grabbed);

        // Store child mode context for validation during drop
        context.isChildMode = roadmapVue.isGridChildMode;
        if (roadmapVue.isGridChildMode) {
            context.parentItemId = roadmapVue.unplannedGridMode.parentItemId;
            context.parentItem = roadmapVue.unplannedGridMode.parentItem;
        }

        // Prevent tooltips from showing while dragging
        eventTooltip.disabled = true;

        schedule.enableScrollingCloseToEdges(schedule.timeAxisSubGrid);

        if (eventDrag.showTooltip && !me.tip) {
            me.tip = new bryntum.schedulerpro.Tooltip({
                align      : 'b-t',
                forElement : context.element,
                cls        : 'b-popup b-sch-event-tooltip'
            });
        }
    }

    onDrag({ event, context }) {
        const
            me           = this,
            { schedule } = me,
            { task }     = context,
            coordinate   = vueInstance.$options.ROADMAP_MODULE.DomHelper[`getTranslate${schedule.isHorizontal ? 'X' : 'Y'}`](context.element),
            startDate    = schedule.getDateFromCoordinate(coordinate, 'round', false, true),
            endDate      = startDate && vueInstance.$options.ROADMAP_MODULE.DateHelper.add(startDate, task.duration, task.durationUnit),
            // Coordinates required when used in vertical mode, since it does not use actual columns
            resource     = context.target && schedule.resolveResourceRecord(context.target, [event.offsetX, event.offsetY]);

        // Prevent drag and drop when isGridChildMode is enabled
        if (roadmapVue.isGridChildMode) {
            // if (me.tip) {
            //     me.tip.html = `
            //         <div class="b-sch-event-title">${task.name}</div>
            //         <div class="b-sch-tooltip-error">Cannot drag items when viewing filtered children</div>
            //     `;
            //     me.tip.showBy(context.element);
            // }
            context.valid = true;

            // Save reference to resource so we can use it in onTaskDrop
            context.resource  = resource;
            context.startDate = startDate;
    
            return;
        }





        // Don't allow drops anywhere, only allow drops if the drop is on the timeaxis and on top of a Resource
        let isValid = Boolean(startDate && resource) &&
            (schedule.allowOverlap || schedule.isDateRangeAvailable(startDate, endDate, null, resource));

        // Additional validation for group by section
        if (isValid && resource && roadmapVue.groupBy.value === "Section") {
            // In new mode (showIndividualItemResources = true): only allow drops on group resources, not item resources
            if (roadmapVue.showIndividualItemResources && resource.get && resource.get('isItem')) {
                isValid = false;
                // Show tooltip indicating why drop is not allowed
                if (me.tip) {
                    me.tip.html = `
                        <div class="b-sch-event-title">${task.name}</div>
                        <div class="b-sch-tooltip-error">Cannot drop on item resource when grouped by Section</div>
                    `;
                    me.tip.showBy(context.element);
                }
            } else {
                // It's a valid drop target, show normal tooltip
                if (me.tip) {
                    const
                        dateFormat         = schedule.displayDateFormat,
                        formattedStartDate = vueInstance.$options.ROADMAP_MODULE.DateHelper.format(startDate, dateFormat),
                        formattedEndDate   = vueInstance.$options.ROADMAP_MODULE.DateHelper.format(endDate, dateFormat);

                    me.tip.html = `
                        <div class="b-sch-event-title">${task.name}</div>
                        <div class="b-sch-tooltip-startdate">Starts: ${formattedStartDate}</div>
                        <div class="b-sch-tooltip-enddate">Ends: ${formattedEndDate}</div>
                    `;
                    me.tip.showBy(context.element);
                }
            }
        } else if (isValid && me.tip) {
            // Normal case (not group by section) or invalid drop
            const
                dateFormat         = schedule.displayDateFormat,
                formattedStartDate = vueInstance.$options.ROADMAP_MODULE.DateHelper.format(startDate, dateFormat),
                formattedEndDate   = vueInstance.$options.ROADMAP_MODULE.DateHelper.format(endDate, dateFormat);

            me.tip.html = `
                <div class="b-sch-event-title">${task.name}</div>
                <div class="b-sch-tooltip-startdate">Starts: ${formattedStartDate}</div>
                <div class="b-sch-tooltip-enddate">Ends: ${formattedEndDate}</div>
            `;
            me.tip.showBy(context.element);
        }

        context.valid = isValid;

        // Save reference to resource so we can use it in onTaskDrop
        context.resource  = resource;
        context.startDate = startDate;

        if (me.tip && context.valid) {
            const
                dateFormat         = schedule.displayDateFormat,
                formattedStartDate = vueInstance.$options.ROADMAP_MODULE.DateHelper.format(startDate, dateFormat),
                formattedEndDate   = vueInstance.$options.ROADMAP_MODULE.DateHelper.format(endDate, dateFormat);

            me.tip.html = `
							<div class="b-sch-event-title">${task.name}</div>
							<div class="b-sch-tooltip-startdate">Starts: ${formattedStartDate}</div>
							<div class="b-sch-tooltip-enddate">Ends: ${formattedEndDate}</div>
            				`;
            me.tip.showBy(context.element);
        }
        else {
            if (me && me.tip) {
                me.tip.hide();
            }
        }
    }

    onDrop({ context, event }) {
        const { schedule } = this;
        const { task, target, resource, valid, element, startDate } = context;

        // Handle child mode restrictions
        if (context.isChildMode) {
            // Validate that the child item is being dropped to its parent resource
            const parentItemId = context.parentItemId;
            const parentItem = context.parentItem;
            
            if (!parentItemId || !parentItem) {
                showTopMessage("Invalid parent item context. Cannot drop child item.", 'warning');
                return;
            }
            
            // Find the parent item resource in the scheduler
            const scheduler = roadmapVue.$options.roadmap;
            const parentItemResource = scheduler.resourceStore.find(resource => {
                return resource.get('orgId') === parentItemId;
            });
            
            if (!parentItemResource) {
                showTopMessage("Parent item resource not found. Cannot drop child item.", 'warning');
                return;
            }
            
            // Check if the drop target is the parent resource
            if (resource && resource.id !== parentItemResource.id) {
                showTopMessage(`Child items can only be dropped to their parent resource: ${parentItem.title}`, 'warning');
                return;
            }
            
            // If validation passes, proceed with the drop and show item edit popup
            console.log('Child item dropped to parent resource, proceeding with item edit popup');
            
            // For child items, we'll handle the planning in the item edit popup
            // Skip the normal planning logic and go directly to item edit popup
            this.handleChildItemDrop(context, task, resource, startDate);
            return;
        }

        if (resource?.id === "-1001") {
            showTopMessage("Cannot drop the Item in Milestones", 'warning');
            return;
        }

        // Additional validation for group by section: prevent drops on item resources
        if (roadmapVue.groupBy.value === "Section" && resource && resource.get && resource.get('isItem')) {
            showTopMessage("Cannot drop on item resource when grouped by Section. Drop on the section resource instead.", 'warning');
            return;
        }
        
        // Additional validation for group by section: prevent drops on _items resources when not showing individual items
        if (roadmapVue.groupBy.value === "Section" && !roadmapVue.showIndividualItemResources && resource && resource.id && resource.id.endsWith('_items')) {
            showTopMessage("Please drop the item on the section header, not on the items area. This ensures proper section assignment.", 'warning');
            return;
        }

        // if (roadmapVue.groupBy.value === "timeCapsuleRelation") {
        //     console.log('Drop canceled based on the condition.');
        //     this.tip?.show('Cannot drop the task here.', element);
        //     return;
        // }

        this.tip?.hide();
        schedule.disableScrollingCloseToEdges(schedule.timeAxisSubGrid);

        if (valid && target && startDate) {

            let item = roadmapVue.itemsByIdMap[task.originalData.id.split('_')[0]];
            let endDate = vueInstance.$options.ROADMAP_MODULE.DateHelper.add(startDate, 30, task.durationUnit);
            if (item) {
                item = _.cloneDeep(item);

                if (!item.fields) {
                    item.fields = {};
                }
                item.fields.StartDate = startDate;
                item.fields.EndDate = endDate;
                item._fields ={
                    StartDate: "",
                    EndDate: ""
                }

                // Resolve the correct resource using group ID resolution if needed
                this.resolveResourceForPlanning(task, resource).then(resolvedResource => {
                    // roadmapVue.itemEditPopup.eventRecord = event.eventRecord;
                    roadmapVue.itemEditPopup.changes = {
                        date: {
                            startDate: startDate,
                            endDate: endDate,
                        }
                    };
                    roadmapVue.itemEditPopup.planningItemParams = {
                        task: task,
                        resource: resolvedResource,
                    }
                    roadmapVue.itemEditPopup.item = item;
                    roadmapVue.itemEditPopup.show = true;
                }).catch(error => {
                    console.error('Error resolving resource for planning:', error);
                    // Fallback to original resource
                    roadmapVue.itemEditPopup.changes = {
                        date: {
                            startDate: startDate,
                            endDate: endDate,
                        }
                    };
                    roadmapVue.itemEditPopup.planningItemParams = {
                        task: task,
                        resource: resource,
                    }
                    roadmapVue.itemEditPopup.item = item;
                    roadmapVue.itemEditPopup.show = true;
                });
            }
        }
        schedule.features.eventTooltip.disabled = false;
    }
    set schedule(schedule) {
        this._schedule = schedule;

        // Configure DragHelper with schedule's scrollManager to allow scrolling while dragging
        this.scrollManager = schedule.scrollManager;
    }

    get schedule() {
        return this._schedule;
    }

    onDragAbort() {
        if(this && this.tip){
            this.tip.hide();
        }
    }

    /**
     * Handle dropping a child item to its parent resource
     * @param {Object} context - Drag context
     * @param {Object} task - Task being dropped
     * @param {Object} resource - Target resource
     * @param {Date} startDate - Start date for the item
     */
    handleChildItemDrop(context, task, resource, startDate) {
        const { schedule } = this;
        
        // Hide tooltip and disable scrolling
        this.tip?.hide();
        schedule.disableScrollingCloseToEdges(schedule.timeAxisSubGrid);
        
        // Get the item data
        let item = roadmapVue.itemsByIdMap[task.originalData.id.split('_')[0]];
        let endDate = vueInstance.$options.ROADMAP_MODULE.DateHelper.add(startDate, 30, task.durationUnit);
        
        if (item) {
            item = _.cloneDeep(item);

            if (!item.fields) {
                item.fields = {};
            }
            item.fields.StartDate = startDate;
            item.fields.EndDate = endDate;
            item._fields = {
                StartDate: "",
                EndDate: ""
            };

            // Set up the item edit popup for child item planning (following existing pattern)
            roadmapVue.itemEditPopup.changes = {
                date: {
                    startDate: startDate,
                    endDate: endDate,
                }
            };
            roadmapVue.itemEditPopup.planningItemParams = {
                task: task,
                resource: resource,
                isFilteredMode: true,
                parentItemId: context.parentItemId
            };
            roadmapVue.itemEditPopup.item = item;
            roadmapVue.itemEditPopup.show = true;
            
            console.log('Child item edit popup opened for:', item.title);
        }
    }

    /**
     * Resolves the correct resource for planning based on group ID resolution
     * @param {Object} task - The task being planned
     * @param {Object} resource - The original resource
     * @returns {Promise<Object>} - The resolved resource
     */
    async resolveResourceForPlanning(task, resource) {
        try {
            // Check if the unplanned and planned group by configurations are different
            const unplannedGroupBy = roadmapVue.groupByUnplanned.value;
            const plannedGroupBy = roadmapVue.groupBy.value;
            
            if (unplannedGroupBy === plannedGroupBy) {
                // If group by configurations are the same, use the original resource
                return resource;
            }
            
            // Use group ID resolution API to find the correct group
            const itemId = task.originalData.id.split('_')[0];
            const resolvedGroupId = await roadmapVue.resolveGroupIdForItemTransition(
                itemId, 
                'planned', 
                plannedGroupBy
            );

            if (resolvedGroupId && resolvedGroupId !== 'null') {
                // Find the appropriate resource based on the resolved group ID
                const resolvedResource = await roadmapVue.findResourceForGroupId(resolvedGroupId, plannedGroupBy, true);
                if (resolvedResource) {
                    console.log(`Resolved resource from ${resource.id} to ${resolvedResource.id} for group by transition`);
                    return resolvedResource;
                } else {
                    console.warn(`Failed to find resource for group ID: ${resolvedGroupId}`);
                }
            } else {
                console.warn(`Group ID resolution returned null or invalid value: ${resolvedGroupId}`);
            }
            
            // Fallback to original resource if resolution fails
            return resource;
            
        } catch (error) {
            console.error('Error in resolveResourceForPlanning:', error);
            return resource;
        }
    }
}
class DragHelperBatchPlanningRoadmap extends bryntum.schedulerpro.DragHelper {
    static get configurable() {
        return {
            callOnFunctions: true,
            // Don't drag the actual row element, clone it
            cloneTarget: true,
            // We size the cloned element manually
            autoSizeClonedTarget: false,
            // Only allow drops on parent events
            dropTargetSelector   : '.b-nested-events-parent',
            // Only allow drag of row elements inside on the unplanned grid
            targetSelector: '.b-grid-row:not(.b-group-row)'
        };
    }

    afterConstruct() {
        // Configure DragHelper with schedule's scrollManager to allow scrolling while dragging
        this.scrollManager = this.schedule.scrollManager;
    }
    // createProxy(element) {
    // 	const
    // 		proxy        = document.createElement('div'),
    // 		{ schedule } = this,
    // 		task         = this.grid.getRecordFromElement(element),
    // 		durationInPx = schedule.timeAxisViewModel.getDistanceForDuration(task.durationMS);
    //
    // 	// Fake an event bar
    // 	proxy.classList.add('b-sch-event-wrap', 'b-sch-style-border', 'b-unassigned-class', 'b-sch-horizontal');
    // 	proxy.style.zIndex='999'
    //
    // 	proxy.innerHTML = `<div class="b-sch-event b-has-content b-sch-event-withicon">
    // 	<div class="b-sch-event-content">
    // 	 ${task.title}
    // 	</div>
    // 	</div>`;
    //
    // 	if (schedule.isHorizontal) {
    // 		proxy.style.height = `100px`;
    // 		proxy.style.width  = `200px`;
    // 	}
    // 	else {
    // 		proxy.style.height = `100px`;
    // 		proxy.style.width  = `200px`;
    // 	}
    //
    // 	return proxy;
    // }
    createProxy(element) {
        const
            { schedule }    = this,
            event             = this.grid.getRecordFromElement(element),
            { eventHeight } = schedule.features.nestedEvents,
            // newSize         = schedule.timeAxisViewModel.getDistanceForDuration(job.durationMS);
            newSize = 200

        try {
            // Make a drag proxy element that looks like an event bar
            return vueInstance.$options.ROADMAP_MODULE.DomHelper.createElement({
                className: 'b-sch-event-wrap b-nested-event b-unassigned kendis-dragged-item',
                style: {
                    width: newSize,
                    height: eventHeight,
                    zIndex: '999'
                },
                children: [
                    {
                        className: 'kendis-dragged-proxy',
                        style: {
                            backgroundColor: 'hsl(200deg 100% 70%)',
                            width: newSize,
                        },
                        children: [
                            {
                                className: 'kendis-dragged-proxy-key',
                                text: generateKey(event.originalData),
                            },
                            {
                                className: 'kendis-dragged-proxy-text elips',
                                text: event.title
                            }
                        ]
                    }
                ]
            });
        }catch (e) {
            console.log(e);

            return vueInstance.$options.ROADMAP_MODULE.DomHelper.createElement({
                text: event.title
            });
        }
    }

    onDragStart({context}) {
        roadmapVue.isdragRemoveFromGrid = true;
        const
            me = this,
            {schedule} = me,
            {eventTooltip, eventDrag} = schedule.features;
        try {
            eventDrag.showTooltip = false //disable tooltip

            // save a reference to the task so we can access it later
            context.task = me.grid.getRecordFromElement(context.grabbed);

            // Prevent tooltips from showing while dragging
            eventTooltip.disabled = true;

            schedule.enableScrollingCloseToEdges(schedule.timeAxisSubGrid);

            if (eventDrag.showTooltip && !me.tip) {
                me.tip = new bryntum.schedulerpro.Tooltip({
                    align: 'b-t',
                    forElement: context.element,
                    cls: 'b-popup b-sch-event-tooltip'
                });
            }
        }catch (e) {
            showTopMessage("Something went wrong!!!",'warning');
            console.log(e)
        }
    }

    onDrag({event, context}) {
        const
            me = this,
            {schedule} = me,
            {task} = context,
            coordinate = vueInstance.$options.ROADMAP_MODULE.DomHelper[`getTranslate${schedule.isHorizontal ? 'X' : 'Y'}`](context.element),
            startDate = schedule.getDateFromCoordinate(coordinate, 'round', false, true),
            endDate = startDate && vueInstance.$options.ROADMAP_MODULE.DateHelper.add(startDate, task.duration, task.durationUnit),
            // Coordinates required when used in vertical mode, since it does not use actual columns
            resource = context.target && schedule.resolveResourceRecord(context.target, [event.offsetX, event.offsetY]);

        // Don't allow drops anywhere, only allow drops if the drop is on the timeaxis and on top of a Resource
        if (roadmapVue.batchPermissions && (roadmapVue.batchPermissions.MANAGE_BATCH_GROUP || roadmapVue.batchPermissions.LINK_UNLINK_BATCH_ITEMS)) {
            context.valid =   Boolean(startDate && resource) &&
                (schedule.allowOverlap || schedule.isDateRangeAvailable(startDate, endDate, null, resource));
        }else{
            showTopMessage("You do not have permission to link/unlink items to batches.",'warning');
            context.valid = false;
        }

        // Save reference to resource so we can use it in onTaskDrop
        context.resource = resource;
        context.startDate = startDate;

        if (me.tip && context.valid) {
            const
                dateFormat = schedule.displayDateFormat,
                formattedStartDate = vueInstance.$options.ROADMAP_MODULE.DateHelper.format(startDate, dateFormat),
                formattedEndDate = vueInstance.$options.ROADMAP_MODULE.DateHelper.format(endDate, dateFormat);

            me.tip.html = `
							<div class="b-sch-event-title">${task.name}</div>
							<div class="b-sch-tooltip-startdate">Starts: ${formattedStartDate}</div>
							<div class="b-sch-tooltip-enddate">Ends: ${formattedEndDate}</div>
            				`;
            me.tip.showBy(context.element);
        } else {
            if (me && me.tip) {
                me.tip.hide();
            }
        }
    }
    async onDrop({context}) {
        try {
            const
                {schedule} = this,
                {task, element, startDate} = context;
            schedule.disableScrollingCloseToEdges(schedule.timeAxisSubGrid);
            schedule.features.eventTooltip.disabled = false;
            const targetParent = schedule.resolveEventRecord(context.target.closest('.b-nested-events-parent'));
            let targetItem = roadmapVue.itemsByIdMap[task.originalData.orgId];

            if(!targetParent){
                showTopMessage("Item cannot be dropped here. Please drop items in the designated batches only.",'warning');
                return
            }
            const targetParentId = ParentIdUtils.getBatchId(targetParent.id)
            let targetBatch = roadmapVue.batchesMap[targetParentId];
            // let children  = schedule.eventStore.allRecords.filter(event => event.parentId === targetParent.id)
            // if (children.find(child => child.id.includes(task.id))) {
            //     // Optionally, show a message to the user why the drop was canceled
            //     alertFromSweetAlertWrapper("Item already linked to the batch.");
            //     return;
            // }

            if(isItemArchivedFromAllCollectionsAttachedToBatch(targetItem,targetBatch.baseItemLinks,true)
                || validateItemAlreadyLinkedAnyCollection(targetItem.id, targetBatch)){
                return
            }
            // If drop was done in a valid location, set the startDate and nest the event
            //async confirmation
            if (context.valid) {
                askFromSweetAlertWrapper("Are you sure you want to link this item to the batch?",
                    [async function () {
                        // Dropped on a scheduled event, create a dependency between them
                        if (targetParent) {
                            if (targetParent.children.find(child => ChildIdUtils.getItemId(child.id) === task.id)) {
                                // Optionally, show a message to the user why the drop was canceled
                                alertFromSweetAlertWrapper("Item already linked to the batch.");
                                return;
                            }
                            element.classList.remove('b-drag-proxy');
                            // We hand over the data + existing element to the Scheduler and let it do the scheduling
                            let uniqueEventId = ChildIdUtils.createLinkedItemEventId(task.id, targetParentId);
                            let {
                                itemEvent,
                                itemAssignment
                            } = createItemEventForBatchesView(targetItem, targetParent.endDate, targetParent.startDate, null, targetParentId,true);
                            await schedule.scheduleEvent({
                                eventRecord: itemEvent,
                                parentEventRecord: targetParent,
                                startDate: itemEvent.startDate,
                                element
                            });
                            //link to targetParent and save the item
                            if (targetItem) {
                                roadmapVue.attachItemWithBatch(targetItem, ParentIdUtils.getBatchId(targetParent.id), roadmapVue.selectedReleaseTrain.id);
                            }
                            //refresh scheduler
                            roadmapVue.$options.roadmap.refresh();
                        }

                    }], [function () {

                    }]);
            }

        }catch (e) {
            showTopMessage("Something went wrong!!!",'warning');
            console.log(e)
        }
    }

    set schedule(schedule) {
        this._schedule = schedule;

        // Configure DragHelper with schedule's scrollManager to allow scrolling while dragging
        this.scrollManager = schedule.scrollManager;
    }

    get schedule() {
        return this._schedule;
    }

    onDragAbort() {
        if(this && this.tip) {
            this.tip.hide();
        }
    }
}