/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.SecurityPolicy;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.authentication.rememberme.RememberMeDisablerFilter;
import org.springframework.web.filter.OncePerRequestFilter;

public class RememberMeDisablerFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RememberMeDisablerFilter.class);
    private final UserRepository userRepository;

    public RememberMeDisablerFilter(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if ("/login".equals(request.getServletPath()) && "POST".equalsIgnoreCase(request.getMethod())) {
            User user;
            String email = request.getParameter("u");
            String rmbValue = request.getParameter("rmb");
            if (email != null) {
                LOGGER.debug("Login attempt for user email: " + email);
            }
            if (rmbValue != null) {
                LOGGER.debug("Remember-me checkbox value: " + rmbValue);
            }
            if ((user = this.userRepository.findByEmailIgnoreCase(email)) != null && user.getIsActive().booleanValue()) {
                List userCompanyList = user.getUserCompanies();
                ArrayList<Company> companies = new ArrayList<Company>();
                if (PropertyValidator.isValid((Collection)userCompanyList)) {
                    for (UserCompany uc : userCompanyList) {
                        if (uc.getCompany().isArchive()) continue;
                        companies.add(uc.getCompany());
                    }
                    Company c = !companies.isEmpty() ? (Company)companies.get(0) : null;
                    LOGGER.debug("Found company: {}", (Object)c);
                    SecurityPolicy sp = c != null ? c.getSecurityPolicy() : null;
                    boolean strict = sp != null && (sp.getSessionInactivityTimeout() != null || sp.getSessionMaxAge() != null);
                    LOGGER.debug("Security policy strict mode: {}", (Object)strict);
                    if (strict) {
                        1 wrapper = new /* Unavailable Anonymous Inner Class!! */;
                        filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
                        return;
                    }
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

