/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.vos;

import com.viztrend.safe.persistence.entity.BoardSprints;
import com.viztrend.safe.persistence.entity.BoardTeam;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.ExternalLink;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskMatrixCoordinate;
import com.viztrend.safe.persistence.entity.TFSAttributes;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.vos.ConversationVO;
import com.viztrend.safe.vos.ItemVO;
import com.viztrend.safe.vos.RiskRegisterVO;
import com.viztrend.safe.vos.StatusVO;
import com.viztrend.safe.vos.UserVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RiskVO
implements Serializable {
    private String id;
    private Integer riskNumber;
    private String riskTitle;
    private String riskDesc;
    private String mitigationActions;
    private RiskMatrixCoordinate impact;
    private StatusVO status;
    private RiskMatrixCoordinate probability;
    private Date raisedDate;
    private Date resolutionDate;
    private Integer conversationCount;
    private UserVO responsible;
    private List<BoardTeam> boardTeams;
    private List<BoardSprints> boardSprints;
    private List<Map> linkedPiBoards;
    private List<Map> linkedSolutionBoards;
    private List<Map> linkedOrgCollections;
    private List<String> linkedItemsIds;
    private List<ItemVO> linkedItems = new ArrayList();
    private List<ExternalLink> externalLinks;
    private RiskRegisterVO riskRegister;
    private List<ConversationVO> conversations = new ArrayList();
    private Boolean notifyWatchers;
    private Map<String, Object> linkedItemsById;
    private Map<String, String> activeBoardIds;
    private String appUrl;
    private Map<String, Object> fields;
    private TFSAttributes tfsAttributes;

    public RiskVO() {
    }

    public RiskVO(Risk risk) {
        this.id = risk.getId();
        this.riskNumber = risk.getRiskNumber();
        this.riskTitle = risk.getRiskTitle();
        this.riskDesc = risk.getRiskDesc();
        this.mitigationActions = risk.getMitigationActions();
        this.impact = risk.getImpact();
        this.status = PropertyValidator.isValid((Object)risk.getStatus()) ? new StatusVO(risk.getStatus()) : null;
        this.probability = risk.getProbability();
        this.raisedDate = risk.getRaisedDate();
        this.resolutionDate = risk.getResolutionDate();
        this.conversationCount = risk.getConversationCount();
        this.responsible = PropertyValidator.isValid((Object)risk.getResponsible()) ? new UserVO(risk.getResponsible()) : null;
        this.linkedItemsIds = risk.getLinkedItemsIds();
        this.externalLinks = risk.getExternalLinks();
        this.riskRegister = PropertyValidator.isValid((Object)risk.getRiskRegister()) ? new RiskRegisterVO(risk.getRiskRegister()) : null;
        this.notifyWatchers = risk.getNotifyWatchers();
        this.boardTeams = PropertyValidator.isValid((Collection)risk.getBoardTeams()) ? new ArrayList(risk.getBoardTeams()) : null;
        this.boardSprints = PropertyValidator.isValid((Collection)risk.getBoardSprints()) ? new ArrayList(risk.getBoardSprints()) : null;
        this.linkedItemsIds = PropertyValidator.isValid((Collection)risk.getLinkedItemsIds()) ? new ArrayList(risk.getLinkedItemsIds()) : null;
        this.linkedPiBoards = PropertyValidator.isValid((Collection)risk.getLinkedPiBoards()) ? new ArrayList(risk.getLinkedPiBoards()) : null;
        this.linkedSolutionBoards = PropertyValidator.isValid((Collection)risk.getLinkedSolutionBoards()) ? new ArrayList(risk.getLinkedSolutionBoards()) : null;
        List list = this.linkedOrgCollections = PropertyValidator.isValid((Collection)risk.getLinkedOrgCollections()) ? new ArrayList(risk.getLinkedOrgCollections()) : null;
        if (risk.getTfsAttributes() != null) {
            if (this.getTfsAttributes() == null) {
                this.setTfsAttributes(new TFSAttributes());
            }
            this.getTfsAttributes().setTfsFilter(risk.getTfsAttributes().getTfsFilter());
            this.getTfsAttributes().setTfsLinkType(risk.getTfsAttributes().getTfsLinkType());
            this.getTfsAttributes().setTfsId(risk.getTfsAttributes().getTfsId());
            this.getTfsAttributes().setTfsURL(risk.getTfsAttributes().getTfsURL());
            this.getTfsAttributes().setTfsProjectId(risk.getTfsAttributes().getTfsProjectId());
            this.getTfsAttributes().setTfsProject(risk.getTfsAttributes().getTfsProject());
            this.getTfsAttributes().setTfsItemType(risk.getTfsAttributes().getTfsItemType());
            this.getTfsAttributes().setTfsIterationPath(risk.getTfsAttributes().getTfsIterationPath());
            this.getTfsAttributes().setTfsAreaPath(risk.getTfsAttributes().getTfsAreaPath());
            this.getTfsAttributes().setTfsItemTypeIcon(risk.getTfsAttributes().getTfsItemTypeIcon());
            this.getTfsAttributes().setTfsLinkedItems(risk.getTfsAttributes().getTfsLinkedItems());
            this.getTfsAttributes().setTfsFieldByKey(risk.getTfsAttributes().getTfsFieldByKey());
            this.getTfsAttributes().setTfsFieldMap(risk.getTfsAttributes().getTfsFieldMap());
        }
        if (PropertyValidator.isValid((Collection)risk.getLinkedItems())) {
            this.linkedItems = new ArrayList();
            for (Item item : risk.getLinkedItems()) {
                this.linkedItems.add(new ItemVO(item));
            }
        }
        if (PropertyValidator.isValid((Collection)risk.getConversations())) {
            for (Conversation conversation : risk.getConversations()) {
                this.conversations.add(new ConversationVO(conversation));
            }
        }
        this.linkedItemsById = PropertyValidator.isValid((Object)risk.getLinkedItemsById()) ? new HashMap(risk.getLinkedItemsById()) : null;
        this.activeBoardIds = PropertyValidator.isValid((Object)risk.getActiveBoardIds()) ? new HashMap(risk.getActiveBoardIds()) : null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getRiskNumber() {
        return this.riskNumber;
    }

    public void setRiskNumber(Integer riskNumber) {
        this.riskNumber = riskNumber;
    }

    public String getRiskTitle() {
        return this.riskTitle;
    }

    public void setRiskTitle(String riskTitle) {
        this.riskTitle = riskTitle;
    }

    public String getRiskDesc() {
        return this.riskDesc;
    }

    public void setRiskDesc(String riskDesc) {
        this.riskDesc = riskDesc;
    }

    public String getMitigationActions() {
        return this.mitigationActions;
    }

    public void setMitigationActions(String mitigationActions) {
        this.mitigationActions = mitigationActions;
    }

    public RiskMatrixCoordinate getImpact() {
        return this.impact;
    }

    public void setImpact(RiskMatrixCoordinate impact) {
        this.impact = impact;
    }

    public StatusVO getStatus() {
        return this.status;
    }

    public void setStatus(StatusVO status) {
        this.status = status;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public RiskMatrixCoordinate getProbability() {
        return this.probability;
    }

    public void setProbability(RiskMatrixCoordinate probability) {
        this.probability = probability;
    }

    public Date getRaisedDate() {
        return this.raisedDate;
    }

    public void setRaisedDate(Date raisedDate) {
        this.raisedDate = raisedDate;
    }

    public Date getResolutionDate() {
        return this.resolutionDate;
    }

    public void setResolutionDate(Date resolutionDate) {
        this.resolutionDate = resolutionDate;
    }

    public Integer getConversationCount() {
        return this.conversationCount;
    }

    public void setConversationCount(Integer conversationCount) {
        this.conversationCount = conversationCount;
    }

    public UserVO getResponsible() {
        return this.responsible;
    }

    public void setResponsible(UserVO responsible) {
        this.responsible = responsible;
    }

    public List<BoardTeam> getBoardTeams() {
        return this.boardTeams;
    }

    public void setBoardTeams(List<BoardTeam> boardTeams) {
        this.boardTeams = boardTeams;
    }

    public List<BoardSprints> getBoardSprints() {
        return this.boardSprints;
    }

    public void setBoardSprints(List<BoardSprints> boardSprints) {
        this.boardSprints = boardSprints;
    }

    public List<String> getLinkedItemsIds() {
        return this.linkedItemsIds;
    }

    public void setLinkedItemsIds(List<String> linkedItemsIds) {
        this.linkedItemsIds = linkedItemsIds;
    }

    public List<ItemVO> getLinkedItems() {
        return this.linkedItems;
    }

    public void setLinkedItems(List<ItemVO> linkedItems) {
        this.linkedItems = linkedItems;
    }

    public List<ExternalLink> getExternalLinks() {
        return this.externalLinks;
    }

    public void setExternalLinks(List<ExternalLink> externalLinks) {
        this.externalLinks = externalLinks;
    }

    public RiskRegisterVO getRiskRegister() {
        return this.riskRegister;
    }

    public void setRiskRegister(RiskRegisterVO riskRegister) {
        this.riskRegister = riskRegister;
    }

    public List<ConversationVO> getConversations() {
        return this.conversations;
    }

    public void setConversations(List<ConversationVO> conversations) {
        this.conversations = conversations;
    }

    public Boolean getNotifyWatchers() {
        return this.notifyWatchers;
    }

    public void setNotifyWatchers(Boolean notifyWatchers) {
        this.notifyWatchers = notifyWatchers;
    }

    public Map<String, Object> getLinkedItemsById() {
        return this.linkedItemsById;
    }

    public void setLinkedItemsById(Map<String, Object> linkedItemsById) {
        this.linkedItemsById = linkedItemsById;
    }

    public Map<String, String> getActiveBoardIds() {
        return this.activeBoardIds;
    }

    public void setActiveBoardIds(Map<String, String> activeBoardIds) {
        this.activeBoardIds = activeBoardIds;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public List<Map> getLinkedPiBoards() {
        return this.linkedPiBoards;
    }

    public void setLinkedPiBoards(List<Map> linkedPiBoards) {
        this.linkedPiBoards = linkedPiBoards;
    }

    public List<Map> getLinkedSolutionBoards() {
        return this.linkedSolutionBoards;
    }

    public void setLinkedSolutionBoards(List<Map> linkedSolutionBoards) {
        this.linkedSolutionBoards = linkedSolutionBoards;
    }

    public List<Map> getLinkedOrgCollections() {
        return this.linkedOrgCollections;
    }

    public void setLinkedOrgCollections(List<Map> linkedOrgCollections) {
        this.linkedOrgCollections = linkedOrgCollections;
    }

    public TFSAttributes getTfsAttributes() {
        return this.tfsAttributes;
    }

    public void setTfsAttributes(TFSAttributes tfsAttributes) {
        this.tfsAttributes = tfsAttributes;
    }
}

