/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.vos;

import com.google.common.collect.Lists;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.JiraIssue2;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.alm.jira.bo.JiraStatus;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.JiraProjectIssueTypes;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResyncParamsVO
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResyncParamsVO.class);
    private static final long serialVersionUID = 2513017637426289336L;
    public String keyText = "Other Items";
    public String key = null;
    public String syncId = null;
    public String event = null;
    public String releaseTrainId = null;
    public String sessionBoardId = null;
    public Integer backlogLevel = null;
    public String itemIds = null;
    public Integer parentLevel = null;
    public String parentLevelJQL = null;
    public String childLevelJQL = null;
    public boolean isWebhook = false;
    public boolean isAlmBacklog = false;
    public boolean isReadOnly = false;
    public boolean isReferesh = false;
    public boolean isNotification = false;
    public boolean isAutoSync = false;
    public boolean isSmartSync = false;
    public boolean forceUpdate = false;
    public boolean removeEmptyCards = false;
    public boolean ignoreChild = false;
    public boolean byPassChildSave = false;
    public boolean validateFilter = false;
    public Boolean bucketSync = false;
    public Map<String, Object> checkedForADD = null;
    public Map<String, Object> checkedForDEL = null;
    public Map<String, Object> checkedKeyForDEL = null;
    public Map<String, String> jiraIdsMap = null;
    public Map<String, String> userMapping = null;
    public Map<String, Object> levelMeta = null;
    public Session session = null;
    public JiraFilter filter = null;
    public String filterStr = null;
    public Set<ItemJiraFieldMap> extraFields = null;
    public List<JiraField> fields = null;
    public JiraField sprintField = null;
    public JiraField epicLinkField = null;
    public Set<String> newProjects = null;
    public Map<String, JiraFilter> jiraIssueFilterMap = null;
    public AlmConfigurations almConfigurations = null;
    public Map<String, List<JiraIssueLinkType>> links = null;
    public List<ItemSyncMapper> syncMapper = null;
    public Map<String, List<Integer>> syncMappersBySprintId = null;
    public Map<String, List<Integer>> syncMappersByTeamId = null;
    public List<Item> items = null;
    public List<Item> childItems = null;
    public List<JiraIssue> jiraIssuesParent = null;
    public Set<JiraIssue> jiraIssuesChild = null;
    public Set<String> childKeys = null;
    public Set<String> parentKeys = null;
    public String itemTypeParent = null;
    public String itemTypeChild = null;
    public SolutionBoard solutionBoard = null;
    public List<Session> sessions = null;
    public List<SessionBoard> sessionBoards = null;
    public Boolean liveItemSync = Boolean.FALSE;
    public Map<String, JiraProjectIssueTypes> projects = null;
    public List<BacklogMappingLinks> uplevel = null;
    public Map<String, String> backlogAlmIds = null;
    public Map<String, BacklogItem> backlog = null;
    public Map<String, Item> boardItems = null;
    public Map<String, Map<String, String>> backlogParentId = null;
    public Map<String, Map<String, String>> backlogOldParent = null;
    public Map<String, Set<String>> backlogSatuses = null;
    public Integer childLevel = null;
    public String cid = null;
    public User user = null;

    public ResyncParamsVO() {
    }

    public ResyncParamsVO(Map<String, Object> resyncParams) {
        if (resyncParams != null) {
            this.userMapping = (Map)resyncParams.get("userMapping");
            this.checkedForADD = (Map)resyncParams.get("checkedForADD");
            this.checkedForDEL = (Map)resyncParams.get("checkedForDEL");
            this.checkedKeyForDEL = (Map)resyncParams.get("checkedKeyForDEL");
            this.isReferesh = Boolean.TRUE.equals(resyncParams.get("isRefresh"));
            this.isNotification = Boolean.TRUE.equals(resyncParams.get("isNotification"));
            this.isAutoSync = Boolean.TRUE.equals(resyncParams.get("isAutoSync"));
            this.isSmartSync = Boolean.TRUE.equals(resyncParams.get("isSmartSync"));
            this.forceUpdate = Boolean.TRUE.equals(resyncParams.get("forceUpdate"));
            this.bucketSync = Boolean.TRUE.equals(resyncParams.get("bucketSync"));
            if (resyncParams.containsKey("jiraIdsMap")) {
                this.jiraIdsMap = (Map)resyncParams.get("jiraIdsMap");
                this.ignoreChild = Boolean.TRUE.equals(resyncParams.get("ignoreChild"));
            }
        }
    }

    public ResyncParamsVO(Map<String, Object> resyncParams, SolutionBoard solutionBoard) {
        if (resyncParams != null) {
            this.solutionBoard = solutionBoard;
            this.checkedForADD = (Map)resyncParams.get("checkedForADD");
            this.checkedForDEL = (Map)resyncParams.get("checkedForDEL");
            this.checkedKeyForDEL = (Map)resyncParams.get("checkedKeyForDEL");
            this.syncId = (String)resyncParams.get("syncId");
            this.event = (String)resyncParams.get("event");
            this.isReadOnly = Boolean.TRUE.equals(resyncParams.get("isReadOnly"));
            this.isReferesh = Boolean.TRUE.equals(resyncParams.get("isRefresh"));
            this.isNotification = Boolean.TRUE.equals(resyncParams.get("isNotification"));
            this.forceUpdate = Boolean.TRUE.equals(resyncParams.get("forceUpdate"));
            this.ignoreChild = Boolean.TRUE.equals(resyncParams.get("ignoreChild"));
            this.validateFilter = Boolean.TRUE.equals(resyncParams.get("validateFilter"));
            this.almConfigurations = new AlmConfigurations();
        }
    }

    public String getBoardId() {
        if (this.sessionBoardId != null) {
            return this.sessionBoardId;
        }
        if (this.releaseTrainId != null) {
            return this.releaseTrainId;
        }
        if (this.solutionBoard != null) {
            return this.solutionBoard.getId();
        }
        return null;
    }

    public Boolean isValidChildInFilter(JiraIssue2 jiraIssue, Map<String, String> dataMap, String refJiraId) {
        JiraFilter filter = null;
        if (PropertyValidator.isValid((Object)this.filter.getId()) && !this.filter.getId().contains("AddExisting")) {
            filter = this.filter;
        } else if (PropertyValidator.isValid((Object)this.jiraIssueFilterMap) && !this.jiraIssueFilterMap.isEmpty()) {
            filter = (JiraFilter)this.jiraIssueFilterMap.get(dataMap.get(refJiraId));
        }
        if (PropertyValidator.isValid(filter)) {
            jiraIssue.setJiraFilterId(filter.getId());
            if (PropertyValidator.isValid((Object)filter.getChildIssueTypes())) {
                if (Boolean.FALSE.equals(filter.getChildIssueTypes().get(jiraIssue.issueTypeId()))) {
                    return false;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    public Object findParent(String project, Session session, Map<String, Object> jiraFields) {
        String key = JiraField.FIXED.parent.toString();
        Object parent = null;
        if (this.uplevel != null) {
            if (session != null) {
                if (this.uplevel.size() == 0) {
                    this.uplevel.add(new BacklogMappingLinks());
                }
                if (((BacklogMappingLinks)this.uplevel.get(0)).getLinkTypes() == null) {
                    ((BacklogMappingLinks)this.uplevel.get(0)).setLinkTypes(new ArrayList());
                    ((BacklogMappingLinks)this.uplevel.get(0)).getLinkTypes().add(new JiraIssueLinkType());
                }
                ((JiraIssueLinkType)((BacklogMappingLinks)this.uplevel.get(0)).getLinkTypes().get(0)).putJiraIssueLinkType(session.getJiraFeatureParentLinkType(), Boolean.valueOf(false));
                this.uplevel.set(0, new BacklogMappingLinks(((BacklogMappingLinks)this.uplevel.get(0)).getLinkTypes(), null));
            }
            ((BacklogMappingLinks)this.uplevel.get(0)).setProjectKey(project);
            Object tmp = jiraFields.get(key);
            this.processForParent(project, jiraFields, (Collection)jiraFields.get(JiraField.FIXED.issuelinks.toString()), this.uplevel, key);
            parent = jiraFields.get(key);
            if (session != null) {
                jiraFields.put(key, tmp);
            }
        }
        return parent;
    }

    public List<String> processForParent(String projectKey, Map<String, Object> jiraFields, Collection<Map<String, Object>> iLinks, List<BacklogMappingLinks> linkMappings, String parentFieldKey) {
        ArrayList<String> parentId = null;
        for (BacklogMappingLinks mapping : linkMappings) {
            if (PropertyValidator.isValid((Collection)mapping.getLinkTypes())) {
                for (JiraIssueLinkType jiraIssueLinkType : mapping.getLinkTypes()) {
                    JiraField pl;
                    Object val;
                    String parentKey;
                    if (jiraIssueLinkType.getReverse() == null) {
                        jiraIssueLinkType.setReverse(Boolean.valueOf(true));
                    }
                    if ("+1".equals(jiraIssueLinkType.getId()) && jiraFields.get(this.epicLinkField.getJiraId()) != null) {
                        parentId = new ArrayList();
                        parentId.add(String.valueOf(jiraFields.get(this.epicLinkField.getJiraId())));
                    }
                    if (PropertyValidator.isValid((Object)jiraIssueLinkType.getId()) && (jiraIssueLinkType.getId().contains("customfield") || jiraIssueLinkType.getId().equals("parent")) && (parentKey = this.getJiraParentKey(val = jiraFields.get((pl = new JiraField(jiraIssueLinkType.getId(), jiraIssueLinkType.getId(), jiraIssueLinkType.getName())).getId()), "key")) != null) {
                        parentId = new ArrayList();
                        parentId.add(parentKey);
                    }
                    if (parentId == null) continue;
                    break;
                }
            }
            if (parentId == null) continue;
            break;
        }
        Map<String, Object> one = null;
        if (parentId == null) {
            parentId = new ArrayList<String>();
            List links = this.getFeatureChildIds(projectKey, iLinks, linkMappings, null);
            if (links != null && links.size() > 0) {
                for (int i = 0; i < links.size(); ++i) {
                    if (links.get(i) == null) continue;
                    parentId.add((String)((Map)links.get(i)).get("id"));
                    if (one != null) continue;
                    one = (Map)links.get(i);
                }
            }
        } else if (parentFieldKey != null) {
            HashMap prt = (HashMap)jiraFields.get(parentFieldKey);
            if (prt != null && !parentId.equals(prt.get("id")) && !parentId.equals(prt.get("key"))) {
                one = prt;
            } else if (parentFieldKey != null && parentId.size() > 0 && PropertyValidator.isValid(parentId.get(0)) && parentFieldKey != null) {
                prt = new HashMap();
                prt.put("epicId", parentId.get(0));
                one = prt;
            }
        }
        if (parentFieldKey != null) {
            jiraFields.put(parentFieldKey, one);
        }
        return parentId;
    }

    public void processForChildren(String issueKEY, String issueID, String projectKey, Collection<Map<String, Object>> iLinks, AlmAccount almAccount, JiraIssueLinkType epicChildsLinkType, List<BacklogMappingLinks> childLinkMappings, Set<String> epicIds, Set<String> featureChildIds, Set<String> parentLinkIds, Collection<JiraField> parentLinkFields, Map<String, Boolean> projectKeysMap, Map<String, String> parentLinkKeyJiraIdMap, Map<String, String> epicKeyJiraIdMap, StringBuilder logs, ImportUtil importUtil) {
        boolean pickCurrentParentChild;
        boolean bl = pickCurrentParentChild = this.jiraIdsMap == null || this.jiraIdsMap != null && !this.jiraIdsMap.containsKey(issueID);
        if (issueID != null) {
            parentLinkKeyJiraIdMap.put(issueKEY, issueID);
        }
        for (BacklogMappingLinks childMappingLink : childLinkMappings) {
            if (!this.byPassChildSave && pickCurrentParentChild && PropertyValidator.isValid((Collection)childMappingLink.getLinkTypes()) && (this.isAlmBacklog || projectKey.equals(childMappingLink.getProjectKey()))) {
                for (JiraIssueLinkType jiraIssueLinkType : childMappingLink.getLinkTypes()) {
                    JiraField pl;
                    if (!PropertyValidator.isValid((Object)jiraIssueLinkType.getId()) || !jiraIssueLinkType.getId().contains("customfield") && !jiraIssueLinkType.getId().equals("parent")) continue;
                    if (issueID != null) {
                        parentLinkIds.add(issueID);
                    }
                    if (this.fields.indexOf(pl = new JiraField(jiraIssueLinkType.getId(), jiraIssueLinkType.getId(), jiraIssueLinkType.getName())) == -1) {
                        this.fields.add(pl);
                    }
                    parentLinkFields.add(pl);
                    if (logs == null) continue;
                    logs.append("\nparent link selected [" + jiraIssueLinkType.getId() + "]");
                }
            }
            if (projectKeysMap == null || childMappingLink == null || childMappingLink.getProjectKey() == null) continue;
            projectKeysMap.put(childMappingLink.getProjectKey(), true);
        }
        if (!this.byPassChildSave && pickCurrentParentChild) {
            List childIds = null;
            if (this.session == null || !this.session.getJiraSynapseRTEnabled().booleanValue()) {
                childIds = this.getFeatureChildIds(projectKey, iLinks, childLinkMappings, logs);
            }
            if (PropertyValidator.isValid((Collection)childIds)) {
                for (int i = 0; i < childIds.size(); ++i) {
                    if (childIds.get(i) == null) continue;
                    String childId = (String)((Map)childIds.get(i)).get("id");
                    ((Map)this.backlogParentId.get(this.getBoardId())).put(childId, issueID);
                    if (featureChildIds == null) continue;
                    featureChildIds.add(childId);
                }
            }
            if (issueID != null) {
                epicKeyJiraIdMap.put(issueKEY, issueID);
            }
            for (BacklogMappingLinks childMappingLink : childLinkMappings) {
                if (!PropertyValidator.isValid((Collection)childMappingLink.getLinkTypes()) || !this.isAlmBacklog && !projectKey.equals(childMappingLink.getProjectKey()) || !childMappingLink.getLinkTypes().contains(epicChildsLinkType)) continue;
                if (issueID != null) {
                    epicIds.add(issueID);
                }
                if (logs == null) break;
                logs.append("\nepic link selected [" + issueID + "]");
                break;
            }
        }
    }

    public void setChildQueries(String nextLevelJQL, LinkedList<StringBuilder> jqls, Set<String> epicIds, Set<String> linkedIds, Set<String> parentLinkIds, Set<JiraField> parentFields) {
        StringBuilder pre = new StringBuilder();
        if (nextLevelJQL != null) {
            pre.append(nextLevelJQL).append(" AND ");
        }
        if (PropertyValidator.isValid(linkedIds)) {
            List subSetsIds = Lists.partition(new ArrayList<String>(linkedIds), (int)100);
            for (List list : subSetsIds) {
                jqls.push(new StringBuilder(pre).append("id IN (").append(String.join((CharSequence)",", list)).append(") "));
            }
        }
        if (PropertyValidator.isValid(epicIds)) {
            jqls.push(new StringBuilder(pre).append("'").append(this.almConfigurations.getAlmAccount().getJiraEpicLinkClause()).append("' in (").append(String.join((CharSequence)",", epicIds)).append(") "));
        }
        if (PropertyValidator.isValid(parentLinkIds)) {
            StringBuilder ngs = new StringBuilder();
            for (JiraField jiraField : parentFields) {
                if (ngs.length() == 0) {
                    ngs.append((CharSequence)pre).append("(");
                } else {
                    ngs.append(" OR ");
                }
                ngs.append("'").append(jiraField.getName()).append("' in (").append(String.join((CharSequence)",", parentLinkIds)).append(") ");
            }
            if (ngs.length() > 0) {
                ngs.append(")");
            }
            jqls.push(ngs);
        }
    }

    public List<String> getFeatureChildIdsViaSynapseRT(String issueKey, AlmAccount almAccount, ImportUtil importUtil) {
        try {
            String result = importUtil.retrieveItemSynapseChildren(issueKey, almAccount);
            ArrayList<String> childIds = new ArrayList<String>();
            JSONArray resultArray = new JSONArray(result);
            for (int i = 0; i < resultArray.length(); ++i) {
                JSONObject obj = resultArray.getJSONObject(i);
                childIds.add(obj.getString("id"));
            }
            return childIds;
        }
        catch (Exception e) {
            LOGGER.debug("Exception while retriving Synapse Childern ::   : " + e.getMessage());
            return null;
        }
    }

    public Map<String, Status> convertStatusListToMap(List<Status> statuses, String sessionId, Map<String, String> projectMap) {
        HashMap<String, Status> statusMap = new HashMap<String, Status>();
        if (PropertyValidator.isValid(statuses)) {
            for (Status st : statuses) {
                String key = "";
                key = this.isAlmBacklog ? sessionId + "_" + st.getJiraProjKey() + "_" + st.getJiraIssueTypeId() + "_" + st.getJiraStatusId() : sessionId + "_" + st.getJiraProjKey() + "_" + st.getItemType() + "_" + st.getJiraIssueTypeId() + "_" + st.getJiraStatusId();
                st.setSyncRequired(null);
                statusMap.put(key, st);
                if (projectMap == null || PropertyValidator.isValid((Object)projectMap.get(st.getJiraProjKey()))) continue;
                projectMap.put(st.getJiraProjKey(), st.getJiraProjKey());
            }
        }
        return statusMap;
    }

    public List<Map<String, Object>> getFeatureChildIds(String prkectKey, Collection<Map<String, Object>> iLinks, List<BacklogMappingLinks> childLinkMappings, StringBuilder logs) {
        ArrayList<Map<String, Object>> storyIdsTofetch = new ArrayList<Map<String, Object>>();
        if (PropertyValidator.isValid(iLinks) && PropertyValidator.isValid(childLinkMappings)) {
            for (BacklogMappingLinks mappingLink : childLinkMappings) {
                if (!PropertyValidator.isValid((Collection)mappingLink.getLinkTypes()) || !this.isAlmBacklog && !prkectKey.equals(mappingLink.getProjectKey())) continue;
                for (JiraIssueLinkType jiraIssueLinkType : mappingLink.getLinkTypes()) {
                    boolean reverse = Boolean.TRUE.equals(jiraIssueLinkType.getReverse());
                    for (Map<String, Object> link : iLinks) {
                        try {
                            Map linkType = (Map)link.get("type");
                            Map inIssue = (Map)link.get("inwardIssue");
                            Map outIssue = (Map)link.get("outwardIssue");
                            boolean use = true;
                            if (jiraIssueLinkType.getId().equals(linkType.get("id"))) {
                                String id;
                                boolean in = false;
                                boolean out = false;
                                if ("IN".equalsIgnoreCase(jiraIssueLinkType.getDirection()) && jiraIssueLinkType.getName().equalsIgnoreCase(jiraIssueLinkType.getInward())) {
                                    in = !reverse;
                                    out = reverse;
                                } else if ("OUT".equalsIgnoreCase(jiraIssueLinkType.getDirection()) && jiraIssueLinkType.getName().equalsIgnoreCase(jiraIssueLinkType.getOutward())) {
                                    in = reverse;
                                    out = !reverse;
                                } else if (linkType.get("direction") == null || "".equalsIgnoreCase((String)linkType.get("direction"))) {
                                    in = true;
                                    out = true;
                                }
                                if (in && PropertyValidator.isValid((Object)inIssue)) {
                                    id = (String)((Map)((Map)inIssue.get("fields")).get("issuetype")).get("id");
                                    if (mappingLink.jiraIssueTypes != null && !Boolean.TRUE.equals(mappingLink.jiraIssueTypes.get(id))) {
                                        use = false;
                                    }
                                    if (use) {
                                        storyIdsTofetch.add(inIssue);
                                    }
                                }
                                if (out && PropertyValidator.isValid((Object)outIssue)) {
                                    id = (String)((Map)((Map)outIssue.get("fields")).get("issuetype")).get("id");
                                    if (mappingLink.jiraIssueTypes != null && !Boolean.TRUE.equals(mappingLink.jiraIssueTypes.get(id))) {
                                        use = false;
                                    }
                                    if (use) {
                                        storyIdsTofetch.add(outIssue);
                                    }
                                }
                            } else {
                                use = false;
                            }
                            if (use || logs == null) continue;
                            logs.append("\n");
                            if (outIssue != null) {
                                Map type = (Map)((Map)outIssue.get("fields")).get("issuetype");
                                logs.append("[" + outIssue.get("key") + " - ").append(type.get("name")).append(" - ").append(type.get("id")).append("]");
                            }
                            if (inIssue != null) {
                                Map type = (Map)((Map)inIssue.get("fields")).get("issuetype");
                                logs.append(", [" + inIssue.get("key") + " - ").append(type.get("name")).append(" - ").append(type.get("id")).append("]");
                            }
                            logs.append("skipped due to issue type or link type Id [" + jiraIssueLinkType.getId() + "] direction [" + jiraIssueLinkType.getDirection() + "] name [" + jiraIssueLinkType.getName() + "] not matched");
                        }
                        catch (Exception e) {
                            LOGGER.debug("getFeatureChildIds:from BacklogMappingLinks mapping ::   : " + StringUtils.getTraceString((Throwable)e));
                        }
                    }
                }
            }
        }
        return storyIdsTofetch;
    }

    public List<Status> retrieveAndConvertJiraStatuses(String prjKey, AlmAccount almAcc, String sessionId, Map<String, Status> stMap, boolean returnAllStatuses, ImportUtil importUtil, StatusRepository statusRepository) {
        List issueTypes = importUtil.retrieveJiraStatuses(prjKey, almAcc.getUrl(), almAcc.getUsername(), almAcc.getPassword(), almAcc);
        return this.processJiraStatuses(prjKey, almAcc, sessionId, stMap, returnAllStatuses, issueTypes, statusRepository);
    }

    public List<Status> processJiraStatuses(String prjKey, AlmAccount almAcc, String sessionId, Map<String, Status> stMap, boolean returnAllStatuses, List<JiraIssueType> issueTypes, StatusRepository statusRepository) {
        List dbStatusList = new ArrayList();
        String parentType = null;
        String childType = null;
        if (!this.isAlmBacklog) {
            parentType = this.itemTypeParent;
            childType = this.itemTypeChild;
            if (!PropertyValidator.isValid((Object)parentType)) {
                parentType = Item.Type.Feature.name();
            }
            if (!PropertyValidator.isValid((Object)childType)) {
                childType = Item.Type.UserStory.name();
            }
            dbStatusList = statusRepository.findBySessionId(sessionId);
            if (stMap == null) {
                stMap = this.convertStatusListToMap(dbStatusList, sessionId, null);
            } else {
                stMap.putAll(this.convertStatusListToMap(dbStatusList, sessionId, null));
            }
        }
        LOGGER.debug(" :: Before retrieveAndConvertJiraStatuses..  ");
        ArrayList<Status> statuses = new ArrayList<Status>();
        ArrayList<Status> newStatuses = new ArrayList<Status>();
        for (JiraIssueType jiraIssueType : issueTypes) {
            if (jiraIssueType.getStatuses() == null) continue;
            for (JiraStatus jStatsus : jiraIssueType.getStatuses()) {
                Status itemStatus = jStatsus.convertToKendisStatus(prjKey, jiraIssueType.getId());
                if (this.isAlmBacklog) {
                    itemStatus.setAlmId(almAcc.getId());
                } else {
                    itemStatus.setItemType(parentType);
                    itemStatus.setSessionId(sessionId);
                }
                String key = "";
                key = this.isAlmBacklog ? sessionId + "_" + itemStatus.getJiraProjKey() + "_" + itemStatus.getJiraIssueTypeId() + "_" + itemStatus.getJiraStatusId() : sessionId + "_" + itemStatus.getJiraProjKey() + "_" + itemStatus.getItemType() + "_" + itemStatus.getJiraIssueTypeId() + "_" + itemStatus.getJiraStatusId();
                if (stMap.get(key) == null) {
                    itemStatus.setId(ObjectId.get().toString());
                    stMap.put(key, itemStatus);
                    newStatuses.add(itemStatus);
                    if (itemStatus.getTenant() == null) {
                        itemStatus.setTenant(almAcc.getTenant());
                    }
                } else {
                    Status persistedStatus = (Status)stMap.get(key);
                    itemStatus.setId(persistedStatus.getId());
                    itemStatus.setTenant(persistedStatus.getTenant());
                    if (!persistedStatus.getCategory().equals(persistedStatus.getJiraStatusOriginalCategory())) {
                        itemStatus.setCategory(persistedStatus.getCategory());
                        itemStatus.setUpdated(true);
                    }
                }
                statuses.add(itemStatus);
                if (this.isAlmBacklog) continue;
                Status subItemStatus = new Status(itemStatus);
                if (this.isAlmBacklog) {
                    subItemStatus.setAlmId(almAcc.getId());
                } else {
                    subItemStatus.setItemType(childType);
                    subItemStatus.setSessionId(sessionId);
                }
                subItemStatus.setSuspendActivity(true);
                subItemStatus.setJiraStatusOriginalCategory(AlmUtils.getMappedStatusCategory((String)jStatsus.getStatusCategory().getKey()));
                key = sessionId + "_" + subItemStatus.getJiraProjKey() + "_" + subItemStatus.getItemType() + "_" + subItemStatus.getJiraIssueTypeId() + "_" + subItemStatus.getJiraStatusId();
                if (stMap.get(key) == null) {
                    subItemStatus.setId(ObjectId.get().toString());
                    stMap.put(key, subItemStatus);
                    newStatuses.add(itemStatus);
                } else {
                    Status persistedStatus = (Status)stMap.get(key);
                    subItemStatus.setId(persistedStatus.getId());
                    if (!persistedStatus.getCategory().equals(persistedStatus.getJiraStatusOriginalCategory())) {
                        subItemStatus.setCategory(persistedStatus.getCategory());
                        itemStatus.setUpdated(true);
                    }
                }
                statuses.add(subItemStatus);
            }
        }
        if (PropertyValidator.isValid(statuses)) {
            List subSetsStatuses = Lists.partition(new ArrayList(statuses), (int)100);
            for (List subSetStatuses : subSetsStatuses) {
                statusRepository.save((Iterable)subSetStatuses);
                LOGGER.debug("saving statuses");
            }
        }
        if (returnAllStatuses) {
            return statusRepository.findByJiraProjKeyAndSessionId(prjKey, sessionId);
        }
        return newStatuses;
    }

    public String getJiraParentKey(Object val, String key) {
        String parentKey = null;
        if (val instanceof Map) {
            Map obj = (Map)val;
            if (obj.containsKey("hasEpicLinkFieldDependency") && obj.containsKey("data")) {
                obj = (Map)obj.get("data");
            }
            if (obj.containsKey(key) && obj.get(key) != null) {
                parentKey = String.valueOf(obj.get(key));
            }
        } else if (val instanceof String) {
            parentKey = String.valueOf(val);
        }
        return parentKey;
    }

    public void restBacklogItems() {
        if (this.isAlmBacklog) {
            this.backlog = new HashMap();
        } else {
            this.boardItems = new HashMap();
        }
    }

    public void putBoardItem(String itemId, JiraIssue2 issue, Map<String, Object> fieldForIds, Integer issueLevel, AlmAccount alm) {
        issue.setGeneratedKendisId(itemId == null ? ObjectId.get().toString() : itemId);
        Item item = issue.getItemFromJiraIssue(fieldForIds, this.extraFields, alm);
        item.setId(issue.getGeneratedKendisId());
        String key = (this.solutionBoard != null ? this.solutionBoard.getId() : this.session.getId()) + "_" + issue.projectKey() + "_" + issue.getItemTypeTobeConvertedInto() + "_" + issue.issueTypeId() + "_" + issue.statusId();
        if (this.backlogSatuses.get(key) == null) {
            this.backlogSatuses.put(key, new HashSet());
        }
        ((Set)this.backlogSatuses.get(key)).add(issue.getId());
        if (this.filter != null && this.filter.getId() != null) {
            item.setJiraFilter(this.filter.getId());
        }
        this.projects.put(issue.projectKey(), new JiraProjectIssueTypes(alm, Boolean.valueOf(true), issue));
        this.boardItems.put(item.getId(), item);
        this.backlogAlmIds.put(issue.getId(), item.getId());
        this.backlogAlmIds.put(issue.getKey(), item.getId());
        this.backlogAlmIds.put(item.getId(), issue.getId());
        this.backlogAlmIds.put(item.getId() + "_key", issue.getKey());
    }

    public void putBacklogItem(String itemId, JiraIssue2 issue, Integer issueLevel, AlmAccount alm, CustomRepositoryImpl customRepositoryImpl) {
        issue.setGeneratedKendisId(itemId == null ? ObjectId.get().toString() : itemId);
        BacklogItem baseItem = issue.fillBackLogItem(this.cid, null, this.fields, alm, this.user, customRepositoryImpl);
        String key = alm.getId() + "_" + issue.projectKey() + "_" + issue.issueTypeId() + "_" + issue.statusId();
        if (this.backlogSatuses.get(key) == null) {
            this.backlogSatuses.put(key, new HashSet());
        }
        ((Set)this.backlogSatuses.get(key)).add(issue.getId());
        if (issueLevel != null && issueLevel < this.parentLevel) {
            baseItem.setDirty(Boolean.valueOf(true));
        }
        if (this.filter != null && this.filter.getId() != null) {
            baseItem.getFilterIds().add(this.filter.getId());
        }
        if (this.releaseTrainId != null) {
            baseItem.linkToRTE(this.releaseTrainId, issueLevel);
            if (issueLevel != null) {
                // empty if block
            }
        }
        this.projects.put(issue.projectKey(), new JiraProjectIssueTypes(alm, Boolean.valueOf(true), issue));
        this.backlog.put(baseItem.getId(), baseItem);
        this.backlogAlmIds.put(issue.getId(), baseItem.getId());
        this.backlogAlmIds.put(issue.getKey(), baseItem.getId());
        this.backlogAlmIds.put(baseItem.getId(), issue.getId());
        this.backlogAlmIds.put(baseItem.getId() + "_key", issue.getKey());
    }

    public Item getBoardItem(String id) {
        String kid = (String)this.backlogAlmIds.get(id);
        if (kid != null && this.backlog.containsKey(kid)) {
            return (Item)this.boardItems.get(kid);
        }
        return null;
    }

    public BacklogItem getBacklogItem(String id) {
        String kid = (String)this.backlogAlmIds.get(id);
        if (kid != null && this.backlog.containsKey(kid)) {
            return (BacklogItem)this.backlog.get(kid);
        }
        return null;
    }

    public void pushSyncChange(String key, Object newItemMap, Object newChildMap, Object missingItemMap, Object missingChildMap, PushResponseRepository pushResponseRepository) {
        if (this.isReadOnly) {
            HashMap data = new HashMap();
            if (!PropertyValidator.isValid((Object)key) || key.contains("AddExisting")) {
                key = this.keyText;
            }
            if (key == null) {
                key = "";
            }
            data.put(key, new HashMap());
            if (newItemMap != null) {
                ((HashMap)data.get(key)).put("newParent", newItemMap);
            }
            if (newChildMap != null) {
                ((HashMap)data.get(key)).put("newChild", newChildMap);
            }
            if (missingItemMap != null) {
                ((HashMap)data.get(key)).put("missingParent", missingItemMap);
            }
            if (missingChildMap != null) {
                ((HashMap)data.get(key)).put("missingChild", missingChildMap);
            }
            if (PropertyValidator.isValid((Collection)this.newProjects)) {
                ((HashMap)data.get(key)).put("newProjects", this.newProjects);
            }
            if (PropertyValidator.isValid((Object)this.filter) && this.filter.getLastSyncDate() != null) {
                ((HashMap)data.get(key)).put("lastSyncDate", this.filter.getLastSyncDate().getTime());
            }
            KendisUtils.pushProgressUpdates((String)"ResyncLogging", (String)this.syncId, data, (PushResponseRepository)pushResponseRepository, (boolean)true);
        }
    }

    public HashMap<String, Object> pushData(Collection<String> keys, Collection<String> artIds) {
        HashMap<String, Object> push = new HashMap<String, Object>();
        if (this.releaseTrainId != null) {
            push.put("viewId", "releaseTrainId");
            push.put("releaseTrainId", this.releaseTrainId == null ? "isJira" : this.releaseTrainId);
            push.put("releaseTrains", artIds);
        } else {
            push.put("viewId", "boardId");
            push.put("boardId", this.getBoardId());
            push.put("partialSyncing", "items");
        }
        push.put("url", this.almConfigurations.getAlmAccount().getUrl());
        push.put("keys", keys);
        return push;
    }
}

