/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.vos;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.vos.ItemJiraDependencyVO;
import com.viztrend.safe.vos.ItemLinkVO;
import com.viztrend.safe.vos.ItemSessionBoardVO;
import com.viztrend.safe.vos.SessionVO;
import com.viztrend.safe.vos.SolutionBoardVO;
import com.viztrend.safe.vos.StatusVO;
import com.viztrend.safe.vos.TeamContainerVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ItemVO
implements Serializable {
    private String id;
    private String title;
    private String jiraKey;
    private String kendisKey;
    private String tfsId;
    private StatusVO status;
    private String jiraIssueTypeId;
    private Map<String, Object> jiraFieldByKey;
    private Map<String, String> jiraFieldTextByKey;
    private Map<String, Object> tfsFieldByKey;
    private String tfsIterationPath;
    private String type;
    private ItemVO parent;
    private SolutionBoardVO solutionBoard;
    private List<ItemSessionBoardVO> sessionBoards;
    private List<ItemJiraDependencyVO> jiraDependencies;
    private List<TeamContainerVO> teamContainers;
    private String tfsItemTypeIcon;
    private Double storyPoints = 0.0;
    private String jiraId;
    private Map<String, Object> fields;
    private TeamContainerVO phoenixTC;
    private List<ItemLinkVO> itemLinks;
    private ArrayList<ItemLinkVO> solutionSourceItemLinks;
    private ArrayList<ItemLinkVO> solutionTargetItemLinks;
    private Date startDate;
    private Date endDate;
    private Date dueDate;
    private IssueType issueType;
    private String externalReferenceURL;
    private String tfsURL;
    private String jiraURL;
    private String tfsProject;
    private String tfsAreaPath;
    private List<ItemJiraFieldMap> tfsFieldMap;
    private Boolean isAlmLinked;

    public ItemVO(String id) {
        this.id = id;
    }

    public ItemVO(Item item) {
        if (PropertyValidator.isValid((Object)item)) {
            this.createItemVOFromItem(item);
        }
    }

    public ItemVO(DBObject itemVo, ItemSessionBoardVO sessionBoard, StatusVO status, IssueType issueType, ItemVO parent, ArrayList<TeamContainerVO> teamContainers) {
        DBObject _tfsFieldByKey;
        this.id = String.valueOf(itemVo.get("_id"));
        this.kendisKey = (String)itemVo.get("kendisKey");
        this.title = (String)itemVo.get("title");
        this.type = (String)itemVo.get("type");
        if (itemVo.get("storyPoints") != null) {
            this.storyPoints = (Double)itemVo.get("storyPoints");
        }
        this.dueDate = (Date)itemVo.get("dueDate");
        this.startDate = (Date)itemVo.get("startDate");
        this.endDate = (Date)itemVo.get("endDate");
        this.status = status;
        this.parent = parent;
        this.tfsId = (String)itemVo.get("tfsId");
        this.tfsURL = (String)itemVo.get("tfsURL");
        this.tfsItemTypeIcon = (String)itemVo.get("tfsItemTypeIcon");
        this.tfsIterationPath = (String)itemVo.get("tfsIterationPath");
        this.tfsProject = (String)itemVo.get("tfsProject");
        this.tfsAreaPath = (String)itemVo.get("tfsAreaPath");
        if (itemVo.get("tfsFieldMap") != null) {
            ArrayList<ItemJiraFieldMap> tfsFieldMap = new ArrayList<ItemJiraFieldMap>();
            BasicDBList _tfsFieldByKey2 = (BasicDBList)itemVo.get("tfsFieldMap");
            for (Object o : _tfsFieldByKey2) {
                DBObject itemJiraFieldMapObject = (DBObject)o;
                ItemJiraFieldMap itemJiraFieldMap = new ItemJiraFieldMap(itemJiraFieldMapObject);
                tfsFieldMap.add(itemJiraFieldMap);
            }
            this.tfsFieldMap = tfsFieldMap;
        }
        if (itemVo.get("tfsFieldByKey") != null) {
            _tfsFieldByKey = (DBObject)itemVo.get("tfsFieldByKey");
            this.tfsFieldByKey = (Map)_tfsFieldByKey;
        }
        if (itemVo.get("jiraFieldByKey") != null) {
            _tfsFieldByKey = (DBObject)itemVo.get("jiraFieldByKey");
            this.jiraFieldByKey = (Map)_tfsFieldByKey;
        }
        if (itemVo.get("fields") != null) {
            this.fields = (Map)itemVo.get("fields");
        }
        this.jiraId = (String)itemVo.get("jiraId");
        this.jiraKey = (String)itemVo.get("jiraKey");
        this.jiraURL = (String)itemVo.get("jiraURL");
        this.jiraIssueTypeId = (String)itemVo.get("jiraIssueTypeId");
        this.externalReferenceURL = (String)itemVo.get("externalReferenceURL");
        this.teamContainers = teamContainers;
        this.issueType = issueType;
        if (PropertyValidator.isValid((Object)sessionBoard)) {
            this.sessionBoards = new ArrayList();
            ItemSessionBoardVO sbCopy = new ItemSessionBoardVO(sessionBoard.getId());
            SessionVO s = new SessionVO();
            s.setId(sessionBoard.getSession().getId());
            s.setTitle(sessionBoard.getSession().getTitle());
            s.setParentItem(sessionBoard.getSession().getParentItem());
            s.setChildItem(sessionBoard.getSession().getChildItem());
            s.setJiraFlaggedFieldEnabled(sessionBoard.getSession().getJiraFlaggedFieldEnabled());
            s.setKendisFlaggedFieldEnabled(sessionBoard.getSession().getKendisFlaggedFieldEnabled());
            sbCopy.setSession(s);
            this.sessionBoards.add(sbCopy);
        }
        this.startDate = (Date)itemVo.get("startDate");
        this.endDate = (Date)itemVo.get("endDate");
    }

    public ItemVO(Item item, boolean includeDBRefs) {
        if (includeDBRefs) {
            this.createItemVOFromItem(item);
        } else {
            this.createItemWithoutDBRefs(item);
        }
    }

    private void createItemWithoutDBRefs(Item item) {
        this.id = item.getId();
        this.title = item.getTitle();
        this.jiraKey = item.getJiraKey();
        this.jiraURL = item.getJiraURL();
        this.kendisKey = item.getKendisKey();
        this.tfsId = item.getTfsId();
        this.tfsURL = item.getTfsURL();
        this.jiraIssueTypeId = item.getJiraIssueTypeId();
        this.jiraFieldByKey = item.getJiraFieldByKey();
        this.jiraFieldTextByKey = item.getJiraFieldTextByKey();
        this.type = item.getType();
        this.storyPoints = item.getStoryPoints();
        this.tfsItemTypeIcon = item.getTfsItemTypeIcon();
        this.jiraId = item.getJiraId();
        this.fields = item.getFields();
        this.startDate = item.getStartDate();
        this.endDate = item.getEndDate();
        this.dueDate = item.getDueDate();
        this.issueType = item.getIssueType();
        this.externalReferenceURL = item.getExternalReferenceURL();
        this.tfsFieldByKey = item.getTfsFieldByKey();
        this.tfsIterationPath = item.getTfsIterationPath();
        this.isAlmLinked = item.getIsAlmLinked();
    }

    private void createItemVOFromItem(Item item) {
        this.createItemWithoutDBRefs(item);
        this.phoenixTC = PropertyValidator.isValid((Object)item.getPhoenixTC()) ? new TeamContainerVO(item.getPhoenixTC()) : null;
        this.status = PropertyValidator.isValid((Object)item.getStatus()) ? new StatusVO(item.getStatus()) : null;
        this.parent = PropertyValidator.isValid((Object)item.getParent()) ? new ItemVO(item.getParent()) : null;
        SolutionBoardVO solutionBoardVO = this.solutionBoard = PropertyValidator.isValid((Object)item.getSolutionBoard()) ? new SolutionBoardVO(item.getSolutionBoard()) : null;
        if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
            this.itemLinks = new ArrayList();
            item.getItemLinks().forEach(itemLink -> this.itemLinks.add(new ItemLinkVO(itemLink)));
        }
        if (PropertyValidator.isValid((Collection)item.getSolutionSourceItemLinks())) {
            this.solutionSourceItemLinks = new ArrayList();
            item.getSolutionSourceItemLinks().forEach(itemLink -> this.solutionSourceItemLinks.add(new ItemLinkVO(itemLink)));
        }
        if (PropertyValidator.isValid((Collection)item.getSolutionTargetItemLinks())) {
            this.solutionTargetItemLinks = new ArrayList();
            item.getSolutionTargetItemLinks().forEach(itemLink -> this.solutionTargetItemLinks.add(new ItemLinkVO(itemLink)));
        }
        if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            this.sessionBoards = new ArrayList();
            item.getSessionBoards().forEach(sessionBoard -> this.sessionBoards.add(new ItemSessionBoardVO(sessionBoard)));
        }
        if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
            this.jiraDependencies = new ArrayList();
            item.getJiraDependencies().forEach(itemJiraDependency -> {
                if (PropertyValidator.isValid((Object)itemJiraDependency)) {
                    this.jiraDependencies.add(new ItemJiraDependencyVO(itemJiraDependency));
                }
            });
        }
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            this.teamContainers = new ArrayList();
            item.getTeamContainers().forEach(teamContainer -> this.teamContainers.add(new TeamContainerVO(teamContainer)));
        }
        this.isAlmLinked = item.getIsAlmLinked();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public StatusVO getStatus() {
        return this.status;
    }

    public void setStatus(StatusVO status) {
        this.status = status;
    }

    public String getJiraIssueTypeId() {
        return this.jiraIssueTypeId;
    }

    public void setJiraIssueTypeId(String jiraIssueTypeId) {
        this.jiraIssueTypeId = jiraIssueTypeId;
    }

    public Map<String, Object> getJiraFieldByKey() {
        return this.jiraFieldByKey;
    }

    public void setJiraFieldByKey(Map<String, Object> jiraFieldByKey) {
        this.jiraFieldByKey = jiraFieldByKey;
    }

    public Map<String, String> getJiraFieldTextByKey() {
        return this.jiraFieldTextByKey;
    }

    public void setJiraFieldTextByKey(Map<String, String> jiraFieldTextByKey) {
        this.jiraFieldTextByKey = jiraFieldTextByKey;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ItemVO getParent() {
        return this.parent;
    }

    public void setParent(ItemVO parent) {
        this.parent = parent;
    }

    public SolutionBoardVO getSolutionBoard() {
        return this.solutionBoard;
    }

    public void setSolutionBoard(SolutionBoardVO solutionBoard) {
        this.solutionBoard = solutionBoard;
    }

    public List<ItemSessionBoardVO> getSessionBoards() {
        return this.sessionBoards;
    }

    public void setSessionBoards(List<ItemSessionBoardVO> sessionBoards) {
        this.sessionBoards = sessionBoards;
    }

    public List<ItemJiraDependencyVO> getJiraDependencies() {
        return this.jiraDependencies;
    }

    public void setJiraDependencies(List<ItemJiraDependencyVO> jiraDependencies) {
        this.jiraDependencies = jiraDependencies;
    }

    public String getJiraKey() {
        return this.jiraKey;
    }

    public void setJiraKey(String jiraKey) {
        this.jiraKey = jiraKey;
    }

    public String getKendisKey() {
        return this.kendisKey;
    }

    public void setKendisKey(String kendisKey) {
        this.kendisKey = kendisKey;
    }

    public String getTfsId() {
        return this.tfsId;
    }

    public void setTfsId(String tfsId) {
        this.tfsId = tfsId;
    }

    public List<TeamContainerVO> getTeamContainers() {
        return this.teamContainers;
    }

    public void setTeamContainers(List<TeamContainerVO> teamContainers) {
        this.teamContainers = teamContainers;
    }

    public String getTfsItemTypeIcon() {
        return this.tfsItemTypeIcon;
    }

    public void setTfsItemTypeIcon(String tfsItemTypeIcon) {
        this.tfsItemTypeIcon = tfsItemTypeIcon;
    }

    public Double getStoryPoints() {
        return this.storyPoints;
    }

    public void setStoryPoints(Double storyPoints) {
        this.storyPoints = storyPoints;
    }

    public String getJiraId() {
        return this.jiraId;
    }

    public void setJiraId(String jiraId) {
        this.jiraId = jiraId;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public TeamContainerVO getPhoenixTC() {
        return this.phoenixTC;
    }

    public void setPhoenixTC(TeamContainerVO phoenixTC) {
        this.phoenixTC = phoenixTC;
    }

    public List<ItemLinkVO> getItemLinks() {
        return this.itemLinks;
    }

    public void setItemLinks(List<ItemLinkVO> itemLinks) {
        this.itemLinks = itemLinks;
    }

    public ArrayList<ItemLinkVO> getSolutionSourceItemLinks() {
        return this.solutionSourceItemLinks;
    }

    public void setSolutionSourceItemLinks(ArrayList<ItemLinkVO> solutionSourceItemLinks) {
        this.solutionSourceItemLinks = solutionSourceItemLinks;
    }

    public ArrayList<ItemLinkVO> getSolutionTargetItemLinks() {
        return this.solutionTargetItemLinks;
    }

    public void setSolutionTargetItemLinks(ArrayList<ItemLinkVO> solutionTargetItemLinks) {
        this.solutionTargetItemLinks = solutionTargetItemLinks;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public void setIssueType(IssueType issueType) {
        this.issueType = issueType;
    }

    public String getExternalReferenceURL() {
        return this.externalReferenceURL;
    }

    public void setExternalReferenceURL(String externalReferenceURL) {
        this.externalReferenceURL = externalReferenceURL;
    }

    public String getTfsURL() {
        return this.tfsURL;
    }

    public void setTfsURL(String tfsURL) {
        this.tfsURL = tfsURL;
    }

    public String getJiraURL() {
        return this.jiraURL;
    }

    public void setJiraURL(String jiraURL) {
        this.jiraURL = jiraURL;
    }

    public Map<String, Object> getTfsFieldByKey() {
        return this.tfsFieldByKey;
    }

    public void setTfsFieldByKey(Map<String, Object> tfsFieldByKey) {
        this.tfsFieldByKey = tfsFieldByKey;
    }

    public String getTfsIterationPath() {
        return this.tfsIterationPath;
    }

    public void setTfsIterationPath(String tfsIterationPath) {
        this.tfsIterationPath = tfsIterationPath;
    }

    public String getTfsProject() {
        return this.tfsProject;
    }

    public void setTfsProject(String tfsProject) {
        this.tfsProject = tfsProject;
    }

    public String getTfsAreaPath() {
        return this.tfsAreaPath;
    }

    public void setTfsAreaPath(String tfsAreaPath) {
        this.tfsAreaPath = tfsAreaPath;
    }

    public List<ItemJiraFieldMap> getTfsFieldMap() {
        return this.tfsFieldMap;
    }

    public void setTfsFieldMap(List<ItemJiraFieldMap> tfsFieldMap) {
        this.tfsFieldMap = tfsFieldMap;
    }

    public Boolean getIsAlmLinked() {
        return this.isAlmLinked;
    }

    public void setIsAlmLinked(Boolean isAlmLinked) {
        this.isAlmLinked = isAlmLinked;
    }
}

