/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.vos;

import com.viztrend.safe.persistence.entity.BaseEntity;
import org.springframework.data.annotation.Transient;

public class Attachment
extends BaseEntity {
    private String filename;
    private String fileType;
    private String filepath;
    private String contentType;
    private Long filesize;
    private String mimeType;
    private Long externalItemId;
    private String referenceKey;
    @Transient
    private byte[] attachmentData;
    private Boolean isImage;
    private String thumbURL;
    private String tempId;
    private Boolean external = false;
    private Boolean image = false;
    private Boolean mockup = false;
    private Double sequence = System.nanoTime() / 100000L;
    private Long itemId;
    private String createdOnStr;

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    public Long getExternalItemId() {
        return this.externalItemId;
    }

    public void setExternalItemId(Long externalItemId) {
        this.externalItemId = externalItemId;
    }

    public byte[] getAttachmentData() {
        return this.attachmentData;
    }

    public void setAttachmentData(byte[] attachmentData) {
        this.attachmentData = attachmentData;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setIsImage(Boolean isImage) {
        this.isImage = isImage;
    }

    public boolean getIsImage() {
        this.image = this.mimeType != null && this.mimeType.startsWith("image") && !this.mimeType.startsWith("image/tiff");
        return this.image;
    }

    public void setThumbURL(String thumbURL) {
        this.thumbURL = thumbURL;
    }

    public String getThumbURL() {
        return this.thumbURL;
    }

    public String getTempId() {
        return this.tempId;
    }

    public void setTempId(String tempId) {
        this.tempId = tempId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void setFilesize(Long filesize) {
        this.filesize = filesize;
    }

    public Long getFilesize() {
        return this.filesize;
    }

    public String getFormatedFilesize() {
        if (this.filesize == null) {
            return null;
        }
        if ((double)this.filesize.longValue() < Math.pow(2.0, 20.0)) {
            return Math.round((double)this.filesize.longValue() / Math.pow(2.0, 10.0)) + " KB";
        }
        return Math.round((double)this.filesize.longValue() / Math.pow(2.0, 20.0)) + " MB";
    }

    public Boolean getExternal() {
        return this.external == null ? false : this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public Boolean getMockup() {
        return this.mockup;
    }

    public void setMockup(Boolean mockup) {
        this.mockup = mockup;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public String getCreatedOnStr() {
        return this.createdOnStr;
    }

    public void setCreatedOnStr(String createdOnStr) {
        this.createdOnStr = createdOnStr;
    }

    public Boolean getImage() {
        return this.image;
    }

    public void setImage(Boolean image) {
        this.image = image;
    }

    public String getReferenceKey() {
        return this.referenceKey;
    }

    public void setReferenceKey(String referenceKey) {
        this.referenceKey = referenceKey;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

