/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TwoFactorAuthUtil {
    public static final int TIME_STEP_SECONDS = 30;
    private static int NUM_DIGITS_OUTPUT = 6;
    private final String blockOfZeros;

    public TwoFactorAuthUtil() {
        StringBuilder sb = new StringBuilder(NUM_DIGITS_OUTPUT);
        for (int i = 0; i < NUM_DIGITS_OUTPUT; ++i) {
            sb.append('0');
        }
        this.blockOfZeros = sb.toString();
    }

    public String generateBase32Secret() {
        StringBuilder sb = new StringBuilder();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 16; ++i) {
            int val = random.nextInt(32);
            if (val < 26) {
                sb.append((char)(65 + val));
                continue;
            }
            sb.append((char)(50 + (val - 26)));
        }
        return sb.toString();
    }

    public String generateCurrentNumber(String secret) throws GeneralSecurityException {
        return this.generateCurrentNumber(secret, System.currentTimeMillis());
    }

    public String generateCurrentNumber(String secret, long currentTimeMillis) throws GeneralSecurityException {
        byte[] key = this.decodeBase32(secret);
        byte[] data = new byte[8];
        long value = currentTimeMillis / 1000L / 30L;
        int i = 7;
        while (value > 0L) {
            data[i] = (byte)(value & 0xFFL);
            value >>= 8;
            --i;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[hash.length - 1] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = offset; i2 < offset + 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return this.zeroPrepend(truncatedHash %= 1000000L, NUM_DIGITS_OUTPUT);
    }

    public boolean verifyCodeWithTolerance(String secret, String code, long currentTimeMillis, int windowSize) throws GeneralSecurityException {
        for (int i = -windowSize; i <= windowSize; ++i) {
            long time = currentTimeMillis + (long)(i * 30) * 1000L;
            String candidate = this.generateCurrentNumber(secret, time);
            if (!candidate.equals(code)) continue;
            return true;
        }
        return false;
    }

    public String qrImageUrl(String keyId, String secret) {
        try {
            return String.format("otpauth://totp/%s?secret=%s", keyId, secret);
        }
        catch (Exception e) {
            return null;
        }
    }

    String zeroPrepend(long num, int digits) {
        String hashStr = Long.toString(num);
        if (hashStr.length() >= digits) {
            return hashStr;
        }
        StringBuilder sb = new StringBuilder(digits);
        int zeroCount = digits - hashStr.length();
        sb.append(this.blockOfZeros, 0, zeroCount);
        sb.append(hashStr);
        return sb.toString();
    }

    byte[] decodeBase32(String str) {
        int numBytes = (str.length() * 5 + 4) / 8;
        byte[] result = new byte[numBytes];
        int resultIndex = 0;
        int which = 0;
        int working = 0;
        block10: for (int i = 0; i < str.length(); ++i) {
            int val;
            char ch = str.charAt(i);
            if (ch >= 'a' && ch <= 'z') {
                val = ch - 97;
            } else if (ch >= 'A' && ch <= 'Z') {
                val = ch - 65;
            } else if (ch >= '2' && ch <= '7') {
                val = 26 + (ch - 50);
            } else {
                if (ch == '=') {
                    which = 0;
                    break;
                }
                throw new IllegalArgumentException("Invalid base-32 character: " + ch);
            }
            switch (which) {
                case 0: {
                    working = (val & 0x1F) << 3;
                    which = 1;
                    continue block10;
                }
                case 1: {
                    result[resultIndex++] = (byte)(working |= (val & 0x1C) >> 2);
                    working = (val & 3) << 6;
                    which = 2;
                    continue block10;
                }
                case 2: {
                    working |= (val & 0x1F) << 1;
                    which = 3;
                    continue block10;
                }
                case 3: {
                    result[resultIndex++] = (byte)(working |= (val & 0x10) >> 4);
                    working = (val & 0xF) << 4;
                    which = 4;
                    continue block10;
                }
                case 4: {
                    result[resultIndex++] = (byte)(working |= (val & 0x1E) >> 1);
                    working = (val & 1) << 7;
                    which = 5;
                    continue block10;
                }
                case 5: {
                    working |= (val & 0x1F) << 2;
                    which = 6;
                    continue block10;
                }
                case 6: {
                    result[resultIndex++] = (byte)(working |= (val & 0x18) >> 3);
                    working = (val & 7) << 5;
                    which = 7;
                    continue block10;
                }
                case 7: {
                    result[resultIndex++] = (byte)(working |= val & 0x1F);
                    which = 0;
                }
            }
        }
        if (which != 0) {
            result[resultIndex++] = (byte)working;
        }
        if (resultIndex != result.length) {
            result = Arrays.copyOf(result, resultIndex);
        }
        return result;
    }
}

