/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import java.io.FileReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class SSLUtil {
    public static void main(String[] args) {
        try {
            MongoClientOptions mongoClientOptions = null;
            String crtFile = "/Users/arbabhamd/Documents/certs/localhost.crt";
            String keyFile = "/Users/arbabhamd/Documents/certs/mongodb.pem";
            String caCrtFile = "/Users/arbabhamd/Documents/certs/ca_localhost.crt";
            String password = "";
            MongoClientOptions.Builder builder = MongoClientOptions.builder();
            mongoClientOptions = builder.sslEnabled(true).sslInvalidHostNameAllowed(true).sslContext(SSLUtil.getSSLContext((String)crtFile, (String)caCrtFile, (String)keyFile, (String)password)).serverSelectionTimeout(1000).build();
            MongoClient mongoClient = new MongoClient(Arrays.asList(new ServerAddress("localhost", Integer.parseInt("27018"))), mongoClientOptions);
            DBCursor cursor = mongoClient.getDB("kendis").getCollection("activeNode").find();
            while (cursor.hasNext()) {
                DBObject obj = cursor.next();
                System.out.println(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SSLContext getSSLContext(String caCrtFile, String crtFile, String keyFile, String password) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
            PEMParser reader = new PEMParser((Reader)new FileReader(caCrtFile));
            X509CertificateHolder caCertHolder = (X509CertificateHolder)reader.readObject();
            reader.close();
            X509Certificate caCert = certificateConverter.getCertificate(caCertHolder);
            reader = new PEMParser((Reader)new FileReader(crtFile));
            X509CertificateHolder certHolder = (X509CertificateHolder)reader.readObject();
            reader.close();
            X509Certificate cert = certificateConverter.getCertificate(certHolder);
            reader = new PEMParser((Reader)new FileReader(keyFile));
            Object keyObject = reader.readObject();
            reader.close();
            PEMDecryptorProvider provider = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
            JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
            KeyPair key = keyObject instanceof PEMEncryptedKeyPair ? keyConverter.getKeyPair(((PEMEncryptedKeyPair)keyObject).decryptKeyPair(provider)) : keyConverter.getKeyPair((PEMKeyPair)keyObject);
            KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            caKeyStore.load(null, null);
            caKeyStore.setCertificateEntry("ca-certificate", caCert);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(caKeyStore);
            KeyStore clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            clientKeyStore.load(null, null);
            clientKeyStore.setCertificateEntry("certificate", cert);
            clientKeyStore.setKeyEntry("private-key", key.getPrivate(), password.toCharArray(), new Certificate[]{cert});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(clientKeyStore, password.toCharArray());
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return context;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

