/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.vos.Attachment;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Scanner;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class S3Utils {
    @Autowired
    private Environment env;
    private String bucketName;
    private static String uploadBucket = "kendis-uploads";
    private static AWSCredentials credentails;
    private static final Logger LOGGER;

    @PostConstruct
    public void S3UtilsPost() {
        this.bucketName = this.env.getProperty("aws.s3.jira.webhook.bucket");
        credentails = new BasicAWSCredentials(this.env.getProperty("aws.accessKey"), this.env.getProperty("aws.secretKey"));
    }

    public List<String> getWebhookData(int size) {
        ArrayList<String> webhooks = new ArrayList<String>();
        TransferManager tm = new TransferManager(credentails);
        ListObjectsRequest listReq = new ListObjectsRequest();
        listReq.setBucketName(this.bucketName);
        listReq.setMaxKeys(Integer.valueOf(size));
        List s3ObjectSummaries = tm.getAmazonS3Client().listObjects(listReq).getObjectSummaries();
        s3ObjectSummaries.sort(new /* Unavailable Anonymous Inner Class!! */);
        for (S3ObjectSummary s3ObjectSummary : s3ObjectSummaries) {
            S3Object object = tm.getAmazonS3Client().getObject(this.bucketName, s3ObjectSummary.getKey());
            S3ObjectInputStream objectData = object.getObjectContent();
            webhooks.add(S3Utils.convertStreamToString((InputStream)objectData));
        }
        return webhooks;
    }

    public static void uploadFile(Attachment attachment) {
        try {
            String existingBucketName = uploadBucket;
            String fileName = attachment.getFilename();
            if (PropertyValidator.isValid((Object)fileName)) {
                if (fileName.contains(".")) {
                    fileName = fileName.substring(0, fileName.indexOf("."));
                }
                fileName = fileName + "-" + attachment.getFilepath();
                attachment.setFilepath(fileName);
            }
            ByteArrayInputStream inpuStream = new ByteArrayInputStream(attachment.getAttachmentData());
            TransferManager tm = new TransferManager(credentails);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(attachment.getMimeType());
            PutObjectRequest putObjectRequest = new PutObjectRequest(existingBucketName, attachment.getFilepath(), (InputStream)inpuStream, meta);
            tm.getAmazonS3Client().putObject(putObjectRequest);
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
        }
    }

    public static String getSecureUrl(String schemaName, String fileName, boolean isProfile) throws Exception {
        AmazonS3Client s3 = new AmazonS3Client(credentails);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 5);
        URL url = null;
        url = s3.generatePresignedUrl(uploadBucket, fileName, calendar.getTime(), HttpMethod.GET);
        return url.toString();
    }

    public void deleteKey(String key) {
        TransferManager tm = new TransferManager(credentails);
        tm.getAmazonS3Client().deleteObject(this.bucketName, key);
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    static {
        LOGGER = LoggerFactory.getLogger(S3Utils.class);
    }
}

