/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.PushMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class PushSender {
    @Autowired
    private static SimpMessagingTemplate broker;
    @Autowired
    static AppInitConfigRepository appInitConfigRepository;
    public static List<String> ipList;
    public static boolean multiNode;
    public static AppInitConfig appInitConfig;
    public static Map<String, Integer> mapCount;
    private static final Logger LOGGER;
    private static CloseableHttpClient httpclient;
    private static PoolingHttpClientConnectionManager connManager;
    @Autowired
    private static Environment env;

    @Autowired
    public void setInitConfigRepository(AppInitConfigRepository appInitConfigRepository) {
        PushSender.appInitConfigRepository = appInitConfigRepository;
    }

    @Autowired
    public PushSender(SimpMessagingTemplate broker, Environment env) {
        PushSender.broker = broker;
        PushSender.env = env;
    }

    public static void sendMsg(String cid, String msg) {
        try {
            if (!multiNode) {
                PushSender.sendPushMsg((String)cid, (String)msg);
            } else {
                for (String ip : ipList) {
                    if (ip.equals("127.0.0.1")) continue;
                    PushThread pushThread = new PushThread(cid, msg, env.getProperty("isLocalDeployment"), ip);
                    Thread t = new Thread((Runnable)pushThread);
                    t.start();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
        }
    }

    public static void sendMsg(String msg) {
        if (UserContextUtil.getUserContext() != null) {
            PushSender.sendMsg((String)UserContextUtil.getUserContext().getCurrentCompanyId(), (String)msg);
        }
    }

    public static void sendPushMsg(String cid, String msg) {
        if (msg != null) {
            broker.convertAndSend((Object)("/topic/synitem/" + cid), (Object)new PushMessage(msg));
        }
    }

    public static void sendPushMsgForGamePlay(String msg) {
        broker.convertAndSend((Object)"/topic/gameplay/", (Object)new PushMessage(msg));
    }

    public static void sendPushMsg(String msg) {
        if (msg != null && PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            broker.convertAndSend((Object)("/topic/synitem/" + UserContextUtil.getUserContext().getCurrentCompanyId()), (Object)new PushMessage(msg));
        }
    }

    static /* synthetic */ Environment access$000() {
        return env;
    }

    static /* synthetic */ CloseableHttpClient access$100() {
        return httpclient;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static {
        ipList = new ArrayList();
        multiNode = false;
        mapCount = new HashMap();
        LOGGER = LoggerFactory.getLogger(PushSender.class);
        try {
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            connManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build());
            connManager.setMaxTotal(1000);
            connManager.setDefaultMaxPerRoute(50);
            int timeout = 5;
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
            httpclient = HttpClients.custom().setDefaultRequestConfig(config).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)connManager).build();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }
}

