/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoSyncUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoSyncUtils.class);

    public static String storeData(String key, String inputData, AppConfig.MongoConfig mongoConfig) {
        try {
            BasicDBObject metaData = new BasicDBObject();
            metaData.put("issueTypesRef", (Object)key);
            ByteArrayInputStream stream = new ByteArrayInputStream(inputData.getBytes(StandardCharsets.UTF_8));
            mongoConfig.gridFsTemplate().store((InputStream)stream, "projectIssueTypes.json", "application/json", (DBObject)metaData).toString();
            return key;
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public static String storeDataBytes(String key, String fileName, String content_type, InputStream stream, AppConfig.MongoConfig mongoConfig) {
        try {
            BasicDBObject metaData = new BasicDBObject();
            metaData.put("issueTypesRef", (Object)key);
            GridFSFile savedFile = mongoConfig.gridFsTemplate().store(stream, fileName, content_type, (DBObject)metaData);
            return savedFile.getId().toString();
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public static InputStream retrieveStreamDataById(String id, AppConfig.MongoConfig mongoConfig) {
        try {
            GridFSDBFile GridFSDBFile2 = mongoConfig.gridFsTemplate().findOne(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id))));
            if (PropertyValidator.isValid((Object)GridFSDBFile2)) {
                return GridFSDBFile2.getInputStream();
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return null;
    }

    public static String retrieveData(String key, AppConfig.MongoConfig mongoConfig) {
        try {
            List GridFSDBFile2 = mongoConfig.gridFsTemplate().find(new Query((CriteriaDefinition)Criteria.where((String)"metadata.issueTypesRef").is((Object)key)));
            if (GridFSDBFile2.size() > 0) {
                InputStream is = ((GridFSDBFile)GridFSDBFile2.get(0)).getInputStream();
                String result = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                return result;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
        }
        return null;
    }

    public static InputStream retrieveStreamData(String key, AppConfig.MongoConfig mongoConfig) {
        try {
            List GridFSDBFile2 = mongoConfig.gridFsTemplate().find(new Query((CriteriaDefinition)Criteria.where((String)"metadata.issueTypesRef").is((Object)key)));
            if (GridFSDBFile2.size() > 0) {
                InputStream is = ((GridFSDBFile)GridFSDBFile2.get(0)).getInputStream();
                return is;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
        }
        return null;
    }

    public static String removeData(String key, AppConfig.MongoConfig mongoConfig) {
        try {
            mongoConfig.gridFsTemplate().delete(new Query((CriteriaDefinition)Criteria.where((String)"metadata.issueTypesRef").is((Object)key)));
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
        }
        return null;
    }

    public static boolean isDataFound(String key, AppConfig.MongoConfig mongoConfig) {
        try {
            List GridFSDBFile2 = mongoConfig.gridFsTemplate().find(new Query((CriteriaDefinition)Criteria.where((String)"metadata.issueTypesRef").is((Object)key)));
            if (GridFSDBFile2.size() > 0) {
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while checking metadata.issueTypesRef :" + StringUtils.getTraceString((Throwable)ex));
        }
        return false;
    }
}

