/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import com.viztrend.safe.utils.SystemUtil;
import java.io.File;
import java.util.List;
import org.slf4j.LoggerFactory;

public class LoggerUtil {
    private static String context = "PerformanceLogs";
    private static Logger logbackLogger = LoggerUtil.getLogger();

    private static Logger getLogger() {
        if (logbackLogger == null) {
            String logFileLoc = new File(SystemUtil.props.get("logging.file").toString()).getParent();
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            RollingFileAppender fileAppender = new RollingFileAppender();
            fileAppender.setContext((Context)loggerContext);
            fileAppender.setName("timestamp");
            fileAppender.setFile(logFileLoc + "/performance/performance.log");
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)loggerContext);
            encoder.setPattern("%r %thread %level - %msg%n");
            encoder.start();
            fileAppender.setEncoder((Encoder)encoder);
            fileAppender.start();
            logbackLogger = loggerContext.getLogger(context);
            logbackLogger.addAppender((Appender)fileAppender);
            List loggerList = loggerContext.getLoggerList();
            for (Logger logger : loggerList) {
                if (!logger.getName().contains(context)) continue;
                logger.setLevel(Level.INFO);
            }
        }
        return logbackLogger;
    }

    public static void printPerformanceLogs(String log) {
        logbackLogger.info(log);
    }
}

