/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.codec.Base64;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.viztrend.safe.controller.PlanController;
import com.viztrend.safe.persistence.entity.Config;
import com.viztrend.safe.persistence.entity.MailConfig;
import com.viztrend.safe.persistence.repository.ConfigRepository;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.FileSystemResource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class LocalMailSender
implements ApplicationContextAware {
    private ConfigRepository configRepository;
    private Environment env;
    private String from;
    static final STGroup g = new STGroupFile("stemplates/mail_template_group.stg");
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanController.class);
    private ApplicationContext context;

    public static void main(String[] args) {
        MailConfig config = new MailConfig();
        config.setHost("host");
        config.setPort(33);
        config.setUserName("userName");
        config.setPassword("password");
        LocalMailSender sender = new LocalMailSender(config);
        for (int i = 0; i < 1000; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("testString", "mynamecom@" + i);
            sender.sendMail("mynamecom@" + i, "asdfd", "voteResultsEmail", map, true);
            LOGGER.debug("======================================================================");
        }
    }

    public LocalMailSender() {
    }

    public LocalMailSender(MailConfig mc) {
        this.initMailSender(mc);
    }

    @PostConstruct
    public JavaMailSenderImpl init() {
        try {
            if (this.configRepository == null) {
                this.configRepository = (ConfigRepository)this.context.getBean(ConfigRepository.class);
            }
            if (this.env == null) {
                this.env = (Environment)this.context.getBean(Environment.class);
            }
            if (!PropertyValidator.isValid((Collection)this.configRepository.findAll())) {
                return new JavaMailSenderImpl();
            }
            Config config = (Config)this.configRepository.findAll().get(0);
            return this.getConfig(config.getMailConfig());
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public JavaMailSenderImpl getConfig(MailConfig mc) {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(mc.getHost());
        mailSender.setPort(mc.getPort());
        mailSender.setUsername(mc.getUserName());
        try {
            mailSender.setPassword(mc.getDecryptedPasswordIfEncrypt());
        }
        catch (Exception e) {
            LOGGER.error("error while decryption :" + StringUtils.getTraceString((Throwable)e));
        }
        this.from = mc.getFrom();
        Properties props = mailSender.getJavaMailProperties();
        props.put("mail.transport.protocol", mc.getMail_transport_protocol());
        props.put("mail.smtp.auth", mc.getMail_smtp_auth());
        props.put("mail.smtp.starttls.enable", mc.getMail_smtp_starttls_enable());
        props.setProperty("mail.smtp.allow8bitmime", "true");
        props.setProperty("mail.smtps.allow8bitmime", "true");
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            props.put("mail.debug", "true");
        } else {
            props.put("mail.debug", "false");
        }
        return mailSender;
    }

    public JavaMailSenderImpl initMailSender(MailConfig mc) {
        return this.getConfig(mc);
    }

    public JavaMailSenderImpl getJavaMailSender() {
        return this.init();
    }

    public void sendMail(String to, String bcc, String subject, String template, Map<String, Object> kvMap, boolean isHtml) {
        SendMailThread smt = new SendMailThread(this, this, to, bcc, subject, template, kvMap, isHtml, null);
        Thread t = new Thread((Runnable)smt);
        t.start();
    }

    public void sendMail(String to, String bcc, String subject, String template, Map<String, Object> kvMap, boolean isHtml, FileSystemResource fileSystemResource) {
        SendMailThread smt = new SendMailThread(this, this, to, bcc, subject, template, kvMap, isHtml, fileSystemResource);
        Thread t = new Thread((Runnable)smt);
        t.start();
    }

    public void sendMail(String to, String subject, String template, Map<String, Object> kvMap, boolean isHtml) {
        SendMailThread smt = new SendMailThread(this, this, to, null, subject, template, kvMap, isHtml, null);
        Thread t = new Thread((Runnable)smt);
        t.start();
    }

    public void sendMail(String to, String subject, String html, boolean isHtml) {
        GroupSendMailThread smt = new GroupSendMailThread(this, this, to, null, subject, html, isHtml, null);
        Thread t = new Thread((Runnable)smt);
        t.start();
    }

    public void sendMail(List<String> to, String subject, String template, Map<String, Object> kvMap, boolean isHtml) {
        SendMailThread smt = new SendMailThread(this, this, to, null, subject, template, kvMap, isHtml, null);
        Thread t = new Thread((Runnable)smt);
        t.start();
    }

    public void sendTestMail(String to, String subject, String template, Map<String, Object> kvMap, boolean isHtml, MailConfig mc) throws Exception {
        JavaMailSenderImpl javaMailSender = this.initMailSender(mc);
        MimeMessage message = javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setTo(new InternetAddress(to));
        helper.setFrom(new InternetAddress(this.from));
        helper.setSubject(subject);
        String html = LocalMailSender.generateHtml((String)template, kvMap);
        helper.setText(html, isHtml);
        javaMailSender.send(helper.getMimeMessage());
    }

    public String generateSosPDF(String html) throws Exception {
        String fileName = this.env.getProperty("temp.file.location") + "/sos.pdf";
        try {
            FileOutputStream file = new FileOutputStream(new File(fileName));
            Document document = new Document(PageSize.A4.rotate());
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)file);
            InputStream iss = null;
            iss = this.getClass().getResourceAsStream("/static/assets/css./sos-a.css");
            String cssContent = IOUtils.toString((InputStream)iss);
            iss.close();
            String css = "<style>";
            css = css + cssContent;
            css = css + "</style>";
            css = css + html;
            document.open();
            ByteArrayInputStream is = new ByteArrayInputStream(css.getBytes());
            XMLWorkerHelper.getInstance().parseXHtml(writer, document, (InputStream)is);
            document.close();
            ((OutputStream)file).close();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        return fileName;
    }

    public String generateDescriptionPDF(String html) throws Exception {
        String fileName = this.env.getProperty("temp.file.location") + "/sos.pdf";
        try {
            FileOutputStream file = new FileOutputStream(new File(fileName));
            Document document = new Document(PageSize.A4.rotate());
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)file);
            document.open();
            ByteArrayInputStream is = new ByteArrayInputStream(html.getBytes());
            XMLWorkerHelper.getInstance().parseXHtml(writer, document, (InputStream)is);
            document.close();
            ((OutputStream)file).close();
        }
        catch (Exception ex) {
            LOGGER.error(ex.toString());
        }
        return fileName;
    }

    public String generatePDF(String template, Map<String, Object> kvMap, String _fileName) throws Exception {
        String html = LocalMailSender.generateHtml((String)template, kvMap);
        String fileName = this.env.getProperty("temp.file.location") + "/" + _fileName + ".pdf";
        FileOutputStream file = new FileOutputStream(new File(fileName));
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)file);
        Image image1 = Image.getInstance((String)"classpath:/static/assets/imgs/logo-new.png");
        image1.setAbsolutePosition(30.0f, 750.0f);
        image1.scaleAbsolute(100.0f, 22.0f);
        document.open();
        document.add((Element)image1);
        ByteArrayInputStream is = new ByteArrayInputStream(html.getBytes());
        XMLWorkerHelper.getInstance().parseXHtml(writer, document, (InputStream)is);
        document.close();
        ((OutputStream)file).close();
        return fileName;
    }

    public String generatePDFWithImage(String template, Map<String, Object> kvMap, String _fileName) throws Exception {
        String imgData = (String)kvMap.get("imgData");
        String fileName = this.env.getProperty("temp.file.location") + "/" + _fileName + ".pdf";
        FileOutputStream file = new FileOutputStream(new File(fileName));
        byte[] fileBytes = Base64.decode((String)imgData);
        ((OutputStream)file).write(fileBytes);
        return fileName;
    }

    public static synchronized String generateHtml(String template, Map<String, Object> kvMap) {
        ST st = g.getInstanceOf(template);
        if (PropertyValidator.isValid(kvMap)) {
            Iterator<Map.Entry<String, Object>> it = kvMap.entrySet().iterator();
            String objectMapper = new String();
            try {
                objectMapper = new ObjectMapper().writeValueAsString(kvMap);
                while (it.hasNext()) {
                    Map.Entry<String, Object> kv = it.next();
                    st.add(kv.getKey(), kv.getValue());
                }
                return st.render();
            }
            catch (Exception ex) {
                LOGGER.error("Template : " + template);
                LOGGER.error(" Object : " + objectMapper);
            }
        }
        return null;
    }

    public static synchronized String generateHtml(String template) {
        ST st = g.getInstanceOf(template);
        return st.render();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    static /* synthetic */ String access$000(LocalMailSender x0) {
        return x0.from;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

