/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import java.math.BigInteger;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class LexoRankUtil {
    private static final int FIXED_LENGTH = 10;
    private static final int ALPHABET_SIZE = 26;
    private static final char FIRST_CHAR = 'a';
    private static final char LAST_CHAR = 'z';
    private static final char MIDDLE_CHAR = 'n';
    private static final String START_POSITION = "aaa";
    private static final String END_POSITION = "zzz";

    public static int compareLexoRanks(String rank1, String rank2) {
        if (rank1 == null && rank2 == null) {
            return 0;
        }
        if (rank1 == null) {
            return -1;
        }
        if (rank2 == null) {
            return 1;
        }
        return rank1.compareTo(rank2);
    }

    private static String normalizeRank(String rank) {
        if (rank == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(rank);
        while (sb.length() < 10) {
            sb.append('a');
        }
        return sb.toString();
    }

    public static String generateFirstLexoRank() {
        return "aaa";
    }

    public static String generateLastLexoRank() {
        return "zzz";
    }

    public static boolean isValidLexoRank(String rank) {
        if (rank == null || rank.isEmpty()) {
            return false;
        }
        for (char c : rank.toCharArray()) {
            if (c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static String getMinLexoRank() {
        return "aaa";
    }

    public static String getMaxLexoRank() {
        return "zzz";
    }

    public static String generateLexoRankBetween(String leftRank, String rightRank) {
        if (leftRank == null) {
            leftRank = "aaa";
        }
        if (rightRank == null) {
            rightRank = "zzz";
        }
        if (LexoRankUtil.compareLexoRanks((String)leftRank, (String)rightRank) >= 0) {
            return LexoRankUtil.generateRankAfter((String)leftRank);
        }
        int maxLen = Math.max(leftRank.length(), rightRank.length());
        BigInteger left = LexoRankUtil.toBigInteger((String)LexoRankUtil.padRight((String)leftRank, (int)maxLen));
        BigInteger right = LexoRankUtil.toBigInteger((String)LexoRankUtil.padRight((String)rightRank, (int)maxLen));
        BigInteger diff = right.subtract(left);
        if (diff.compareTo(BigInteger.ONE) <= 0) {
            String candidate = leftRank;
            while (candidate.compareTo(rightRank) >= 0 || candidate.equals(leftRank)) {
                candidate = candidate + 'n';
            }
            return candidate;
        }
        BigInteger mid = left.add(right).shiftRight(1);
        String midStr = LexoRankUtil.fromBigInteger((BigInteger)mid, (int)maxLen);
        if (midStr.equals(leftRank) || midStr.equals(rightRank)) {
            return leftRank + 'n';
        }
        return midStr;
    }

    private static BigInteger toBigInteger(String rank) {
        BigInteger value = BigInteger.ZERO;
        for (int i = 0; i < rank.length(); ++i) {
            int digit = rank.charAt(i) - 97;
            value = value.multiply(BigInteger.valueOf(26L)).add(BigInteger.valueOf(digit));
        }
        return value;
    }

    private static String fromBigInteger(BigInteger value, int minLength) {
        if (value.compareTo(BigInteger.ZERO) < 0) {
            return LexoRankUtil.repeatChar((char)'a', (int)Math.max(1, minLength));
        }
        StringBuilder sb = new StringBuilder();
        BigInteger base = BigInteger.valueOf(26L);
        BigInteger val = value;
        if (val.equals(BigInteger.ZERO)) {
            sb.append('a');
        } else {
            while (val.compareTo(BigInteger.ZERO) > 0) {
                BigInteger[] qr = val.divideAndRemainder(base);
                val = qr[0];
                int digit = qr[1].intValue();
                sb.append((char)(97 + digit));
            }
            sb.reverse();
        }
        while (sb.length() < minLength) {
            sb.insert(0, 'a');
        }
        return sb.toString();
    }

    private static String repeatChar(char c, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static String padRight(String s, int length) {
        if (s.length() >= length) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < length) {
            sb.append('a');
        }
        return sb.toString();
    }

    public static String generateRankAfter(String rank) {
        if (rank == null) {
            return LexoRankUtil.normalizeRank((String)"aaa");
        }
        if (!LexoRankUtil.isValidLexoRank((String)rank)) {
            return LexoRankUtil.normalizeRank((String)(rank + 'a'));
        }
        if (rank.equals("zzz")) {
            return LexoRankUtil.normalizeRank((String)(rank + 'a'));
        }
        int length = rank.length();
        BigInteger val = LexoRankUtil.toBigInteger((String)rank).add(BigInteger.ONE);
        String next = LexoRankUtil.fromBigInteger((BigInteger)val, (int)length);
        if (next.equals(rank)) {
            return LexoRankUtil.normalizeRank((String)(rank + 'a'));
        }
        return LexoRankUtil.normalizeRank((String)next);
    }

    public static String generateRankBefore(String rank) {
        if (rank == null) {
            return LexoRankUtil.normalizeRank((String)"zzz");
        }
        if (!LexoRankUtil.isValidLexoRank((String)rank)) {
            return LexoRankUtil.normalizeRank((String)(rank + 'z'));
        }
        if (LexoRankUtil.isSmallest((String)rank)) {
            return LexoRankUtil.normalizeRank((String)(rank + 'z'));
        }
        BigInteger val = LexoRankUtil.toBigInteger((String)rank);
        if (val.compareTo(BigInteger.ZERO) <= 0) {
            return LexoRankUtil.normalizeRank((String)(rank + 'z'));
        }
        BigInteger prev = val.subtract(BigInteger.ONE);
        String prevStr = LexoRankUtil.fromBigInteger((BigInteger)prev, (int)rank.length());
        if (prevStr.equals(rank)) {
            return LexoRankUtil.normalizeRank((String)(rank + 'z'));
        }
        return LexoRankUtil.normalizeRank((String)prevStr);
    }

    public static String generateSequenceForIndex(int index) {
        int remaining;
        if (index < 0) {
            return "aaa";
        }
        StringBuilder result = new StringBuilder();
        result.append("aaa");
        if (remaining == 0) {
            return result.toString();
        }
        StringBuilder suffix = new StringBuilder();
        for (remaining = index; remaining > 0; remaining /= 26) {
            int charIndex = remaining % 26;
            suffix.append((char)(97 + charIndex));
        }
        result.append(suffix.reverse().toString());
        return result.toString();
    }

    public static String generateUniqueSequence(String baseSequence, List<String> existingSequences, String excludeSequence) {
        int attempts;
        if (baseSequence == null) {
            baseSequence = "aaa";
        }
        if (!LexoRankUtil.hasSequenceConflict((String)baseSequence, existingSequences, (String)excludeSequence)) {
            return baseSequence;
        }
        String candidateSequence = baseSequence;
        int maxAttempts = 20;
        for (attempts = 0; LexoRankUtil.hasSequenceConflict((String)candidateSequence, existingSequences, (String)excludeSequence) && attempts < maxAttempts; ++attempts) {
            candidateSequence = LexoRankUtil.generateLexoRankBetween((String)candidateSequence, (String)LexoRankUtil.getMaxLexoRank());
        }
        if (attempts >= maxAttempts) {
            candidateSequence = baseSequence + "_" + System.currentTimeMillis();
        }
        return candidateSequence;
    }

    public static boolean hasSequenceConflict(String sequence, List<String> existingSequences, String excludeSequence) {
        if (sequence == null || existingSequences == null || existingSequences.isEmpty()) {
            return false;
        }
        for (String existingSequence : existingSequences) {
            if (excludeSequence != null && sequence.equals(excludeSequence) || !sequence.equals(existingSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSmallest(String rank) {
        return rank != null && rank.matches("^a+$");
    }

    public static String generateEvenSmaller(String rank) {
        return rank.length() > 1 ? rank.substring(0, rank.length() - 1) : "a";
    }
}

