/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.viztrend.safe.utils.EncryptedToken;
import com.viztrend.safe.utils.SystemUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class EncDecUtility {
    private static byte[] linebreak = new byte[0];
    public static String secret = "evnwr3ufg9ghf330";
    private static SecretKey key;
    private static Cipher cipher;
    private static org.apache.commons.codec.binary.Base64 coder;
    private static String keyId;
    private static String secretKey;
    private static String salt;
    static Map<String, EncryptedToken> keysMap;
    public static boolean use265Bit;
    @Autowired
    private Environment env;
    private static AWSKMS AWSKMS_CLIENT;

    @PostConstruct
    public void EncDecUtilityPostConst() {
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.env.getProperty("aws.accessKey"), this.env.getProperty("aws.secretKey"));
        AWSKMS_CLIENT = (AWSKMS)((AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).withRegion(Regions.US_EAST_1)).build();
        keyId = this.env.getProperty("aws.kms_key_id");
    }

    public static String encrypt256(String strToEncrypt) throws Exception {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(secretKey.toCharArray(), salt.getBytes(), 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKey, ivspec);
        return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes("UTF-8")));
    }

    public static String decrypt256(String strToDecrypt) throws Exception {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(secretKey.toCharArray(), salt.getBytes(), 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)secretKey, ivspec);
        return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)));
    }

    public static String encryptKMS(String plain) throws Exception {
        if (SystemUtil.isLocalDeployment) {
            throw new RuntimeException("not supported");
        }
        ByteBuffer plaintext = ByteBuffer.wrap(plain.getBytes());
        EncryptRequest req = new EncryptRequest().withKeyId(keyId).withPlaintext(plaintext);
        ByteBuffer ciphertext = AWSKMS_CLIENT.encrypt(req).getCiphertextBlob();
        byte[] base64EncodedValue = com.amazonaws.util.Base64.encode((byte[])ciphertext.array());
        String value = new String(base64EncodedValue, Charset.forName("UTF-8"));
        return value;
    }

    public static String decryptKMS(String cipher) {
        if (SystemUtil.isLocalDeployment) {
            throw new RuntimeException("not supported");
        }
        EncryptedToken encryptedToken = (EncryptedToken)keysMap.get(cipher);
        if (encryptedToken != null && encryptedToken.getExpiry().after(new Date())) {
            return encryptedToken.getPlainText();
        }
        DecryptRequest decReq = new DecryptRequest().withCiphertextBlob(ByteBuffer.wrap(com.amazonaws.util.Base64.decode((byte[])cipher.getBytes(Charset.forName("UTF-8")))));
        ByteBuffer plantextBuffer = AWSKMS_CLIENT.decrypt(decReq).getPlaintext();
        String plainValue = new String(plantextBuffer.array(), Charset.forName("UTF-8"));
        keysMap.put(cipher, new EncryptedToken(plainValue, 8));
        return plainValue;
    }

    public static boolean isKMSEncryption(String value) {
        if (SystemUtil.isLocalDeployment) {
            return false;
        }
        try {
            EncDecUtility.decryptKMS((String)value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isEncrypted(String value) {
        try {
            EncDecUtility.decrypt((String)value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
    }

    public static String encrypt(String plainText) throws Exception {
        if (SystemUtil.isLocalDeployment || AWSKMS_CLIENT == null) {
            if (!use265Bit) {
                cipher.init(1, key);
                byte[] cipherText = cipher.doFinal(plainText.getBytes());
                return new String(coder.encode(cipherText));
            }
            return EncDecUtility.encrypt256((String)plainText);
        }
        return EncDecUtility.encryptKMS((String)plainText);
    }

    public static String decrypt(String codedText) throws Exception {
        if (SystemUtil.isLocalDeployment || !EncDecUtility.isKMSEncryption((String)codedText)) {
            try {
                byte[] encypted = coder.decode(codedText.getBytes());
                if (encypted == null || encypted.length < 1) {
                    throw new RuntimeException("enc failed");
                }
                cipher.init(2, key);
                byte[] decrypted = cipher.doFinal(encypted);
                return new String(decrypted);
            }
            catch (Exception ex) {
                return EncDecUtility.decrypt256((String)codedText);
            }
        }
        return EncDecUtility.decryptKMS((String)codedText);
    }

    public static String encryptSimple(String plainText) throws Exception {
        cipher.init(1, key);
        byte[] cipherText = cipher.doFinal(plainText.getBytes());
        return new String(coder.encode(cipherText));
    }

    public static String decryptSimple(String codedText) throws Exception {
        byte[] encypted = coder.decode(codedText.getBytes());
        cipher.init(2, key);
        byte[] decrypted = cipher.doFinal(encypted);
        return new String(decrypted);
    }

    @Deprecated
    public static String decryptTemp(String codedText) throws Exception {
        byte[] encypted = coder.decode(codedText.getBytes());
        cipher.init(2, key);
        byte[] decrypted = cipher.doFinal(encypted);
        return new String(decrypted);
    }

    public static String decryptByFactor(String code, Integer factor) {
        return Integer.toString(Integer.parseInt(code) / factor);
    }

    public static String encryptByFactor(String code, Integer factor) {
        return Integer.toString(Integer.parseInt(code) * factor);
    }

    public static String bCryptPasswordEncoder(String value) {
        return new BCryptPasswordEncoder().encode((CharSequence)value);
    }

    public static String getRandomPassword(int len) {
        String sampleSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*_=+-.?<>)";
        Random randomize = new Random();
        char[] password = new char[len];
        for (int i = 0; i < len; ++i) {
            password[i] = sampleSet.charAt(randomize.nextInt(sampleSet.length()));
        }
        return new String(password);
    }

    public static String getHash256(String secret, String message) {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] hash = sha256_HMAC.doFinal(message.getBytes());
            StringBuffer result = new StringBuffer();
            for (byte b : hash) {
                result.append(String.format("%02x", b));
            }
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        secretKey = "evnwr3ufg9ghf330";
        salt = "sltsvevnwr3ufgghhjng9ghf330";
        keysMap = new HashMap();
        use265Bit = false;
        try {
            key = new SecretKeySpec(secret.getBytes(), "AES");
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding", "SunJCE");
            coder = new org.apache.commons.codec.binary.Base64(32, linebreak, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

