/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DBUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBUtils.class);

    public static void parseDocument(DBObject item) {
        if (item.containsField("_id")) {
            item.put("id", (Object)String.valueOf(item.get("_id")));
        }
        item.removeField("_id");
        item.removeField("_class");
        item.removeField("tenant");
        DBUtils.parseDbProperty((DBObject)item, (String)"parent", (boolean)false);
        DBUtils.parseDbProperty((DBObject)item, (String)"status", (boolean)false);
        DBUtils.parseDbProperty((DBObject)item, (String)"issueType", (boolean)false);
        DBUtils.parseDbProperty((DBObject)item, (String)"fetchedBy", (boolean)false);
        DBUtils.parseDbProperty((DBObject)item, (String)"solutionBoard", (boolean)false);
        DBUtils.parseDbProperty((DBObject)item, (String)"itemLinks", (boolean)true);
        DBUtils.parseDbProperty((DBObject)item, (String)"jiraDependencies", (boolean)true);
        DBUtils.parseDbProperty((DBObject)item, (String)"sessionBoards", (boolean)true);
        DBUtils.parseDbProperty((DBObject)item, (String)"teamContainers", (boolean)true);
    }

    public static DBObject parseDbFef(DBObject o) {
        try {
            if (PropertyValidator.isValid((Object)o)) {
                String[] nested;
                if (o.containsField("_id")) {
                    o.put("id", (Object)String.valueOf(o.get("_id")));
                } else if (o.containsField("$id")) {
                    o.put("id", (Object)String.valueOf(o.get("$id")));
                }
                o.removeField("_id");
                o.removeField("$id");
                o.removeField("_class");
                o.removeField("tenant");
                o.removeField("collectionName");
                for (String name : nested = new String[]{"team", "container", "wfStatus", "workFlow", "reporter", "responsible"}) {
                    if (!o.containsField(name)) continue;
                    o.put(name, (Object)DBUtils.parseDbFef((DBRef)((DBRef)o.get(name))));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return o;
    }

    public static Map parseDbFef(DBRef ref) {
        if (PropertyValidator.isValid((Object)ref)) {
            HashMap<String, String> val = new HashMap<String, String>();
            val.put("id", String.valueOf(ref.getId()));
            return val;
        }
        return null;
    }

    public static void parseDbProperty(DBObject group, String dbname, boolean isArray) {
        if (dbname == null) {
            if (group instanceof DBObject) {
                DBUtils.parseDbFef((DBObject)group);
            } else if (group instanceof DBRef) {
                DBUtils.parseDbFef((DBRef)((DBRef)group));
            }
        }
        if (group.containsField(dbname)) {
            Object val = null;
            if (group.get(dbname) instanceof BasicDBList) {
                BasicDBList dbList = (BasicDBList)group.get(dbname);
                ArrayList<DBObject> list = null;
                for (int i = 0; i < dbList.size(); ++i) {
                    if (dbList.get(i) instanceof DBObject) {
                        val = DBUtils.parseDbFef((DBObject)((DBObject)dbList.get(i)));
                    } else if (dbList.get(i) instanceof DBRef) {
                        val = DBUtils.parseDbFef((DBRef)((DBRef)dbList.get(i)));
                    }
                    if (!isArray) break;
                    if (list == null) {
                        list = new ArrayList<DBObject>();
                    }
                    list.add((DBObject)val);
                }
                if (isArray) {
                    val = list;
                }
            } else if (group.get(dbname) instanceof DBObject) {
                val = DBUtils.parseDbFef((DBObject)((DBObject)group.get(dbname)));
            } else if (group.get(dbname) instanceof DBRef) {
                val = DBUtils.parseDbFef((DBRef)((DBRef)group.get(dbname)));
            }
            if (val != null) {
                group.put(dbname, val);
            }
        }
    }

    public static BasicDBObject createLookup(String from, String localField, String foreignField, String as) {
        return new BasicDBObject("$lookup", (Object)new BasicDBObject().append("from", (Object)from).append("localField", (Object)localField).append("foreignField", (Object)foreignField).append("as", (Object)as));
    }

    public static BasicDBObject createUnWind(String unwindField) {
        return new BasicDBObject("$unwind", (Object)unwindField);
    }

    public static BasicDBObject createUnWindWithPath(String path, boolean preserveNullAndEmptyArrays) {
        return new BasicDBObject("$unwind", (Object)new BasicDBObject("path", (Object)path).append("preserveNullAndEmptyArrays", (Object)preserveNullAndEmptyArrays));
    }

    public static String getIdFromBsonDocument(BsonDocument document, String ... key) {
        if (!PropertyValidator.isValid((Object)document) || document.isEmpty()) {
            return null;
        }
        String objectKey = DBUtils.getKeyFromParameters((String[])key);
        if (!PropertyValidator.isValid((Object)document.get((Object)objectKey))) {
            return null;
        }
        BsonValue value = document.get((Object)objectKey);
        String id = null;
        if (value.getBsonType() == BsonType.STRING) {
            BsonString strValue = value.asString();
            id = strValue.getValue();
        } else if (value.getBsonType() == BsonType.OBJECT_ID) {
            BsonObjectId objectId = value.asObjectId();
            id = objectId.getValue().toString();
        }
        return id;
    }

    public static String getIdFromDBObject(BasicDBObject dbObject, String ... key) {
        String id;
        if (!PropertyValidator.isValid((Object)dbObject) || dbObject.isEmpty()) {
            return null;
        }
        String objectKey = "_id";
        if (key != null && key.length > 0) {
            objectKey = key[0];
        }
        if (!PropertyValidator.isValid((Object)dbObject.get(objectKey))) {
            return null;
        }
        if (dbObject.get("_id") instanceof String) {
            id = (String)dbObject.get(objectKey);
        } else {
            ObjectId objectId = (ObjectId)dbObject.get(objectKey);
            id = objectId.toString();
        }
        return id;
    }

    private static String getKeyFromParameters(String ... key) {
        String objectKey = "_id";
        if (key != null && key.length > 0) {
            objectKey = key[0];
        }
        return objectKey;
    }

    public static boolean isEmptyObject(Object object) {
        return object == null || "{}".equals(object.toString());
    }

    public static BasicDBObject getBasicDBObjectFromDBObject(Object object) {
        BasicDBList objectList;
        if (DBUtils.isEmptyObject((Object)object)) {
            return null;
        }
        if (object instanceof BasicDBObject) {
            return (BasicDBObject)object;
        }
        if (object instanceof DBRef) {
            BasicDBObject dbo = new BasicDBObject();
            dbo.put((Object)"id", (Object)((DBRef)object).getId().toString());
            return dbo;
        }
        if (object instanceof BasicDBList && (objectList = (BasicDBList)object).get(0) instanceof DBRef) {
            for (int i = 0; i < objectList.size(); ++i) {
                BasicDBObject dbo = new BasicDBObject();
                dbo.put((Object)"id", (Object)((DBRef)objectList.get(i)).getId().toString());
                objectList.set(i, (Object)dbo);
            }
        }
        return null;
    }

    public static List<ItemJiraFieldMap> getListOfItemJiraFieldMapFromDBObject(Object object) {
        try {
            if (DBUtils.isEmptyObject((Object)object)) {
                return null;
            }
            ArrayList<ItemJiraFieldMap> itemJiraFieldMapList = new ArrayList<ItemJiraFieldMap>();
            if (object instanceof BasicDBList) {
                BasicDBList dbList = (BasicDBList)object;
                for (Object item : dbList) {
                    if (!(item instanceof BasicDBObject)) continue;
                    itemJiraFieldMapList.add(new ItemJiraFieldMap((BasicDBObject)item));
                }
            }
            return itemJiraFieldMapList;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public static BasicDBObject baseEntityProjection() {
        return new BasicDBObject().append("_id", (Object)1).append("archive", (Object)1).append("tenant", (Object)1).append("rowStatus", (Object)1);
    }

    public static BasicDBObject createCondition(BasicDBObject ifCondition, String thenCondition, BasicDBObject elseCondition) {
        return new BasicDBObject("$cond", (Object)new BasicDBObject().append("if", (Object)ifCondition).append("then", (Object)thenCondition).append("else", (Object)elseCondition));
    }

    public static boolean isHexString(String str) {
        return str != null && str.matches("^[0-9a-fA-F]{24}$");
    }

    public static boolean isUUID(String str) {
        return str != null && str.matches("^[0-9a-fA-F\\-]{36}$");
    }

    public static String toCaseInsensitiveRegex(String value) {
        return "^" + Pattern.quote(value) + "$";
    }
}

