/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.vos.ContainerVO;
import com.viztrend.safe.vos.ConversationVO;
import com.viztrend.safe.vos.ItemJiraDependencyVO;
import com.viztrend.safe.vos.ItemLinkVO;
import com.viztrend.safe.vos.ItemSessionBoardVO;
import com.viztrend.safe.vos.ItemVO;
import com.viztrend.safe.vos.RiskRegisterVO;
import com.viztrend.safe.vos.RiskVO;
import com.viztrend.safe.vos.SessionVO;
import com.viztrend.safe.vos.SolutionBoardVO;
import com.viztrend.safe.vos.StatusVO;
import com.viztrend.safe.vos.TeamContainerVO;
import com.viztrend.safe.vos.TeamVO;
import com.viztrend.safe.vos.UserVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class BusinessToVOUtils {
    public static List<TeamVO> convertTeamsToTeamVOs(List<Team> teams) {
        if (!PropertyValidator.isValid(teams)) {
            return null;
        }
        return teams.stream().map(TeamVO::new).collect(Collectors.toList());
    }

    public static List<ContainerVO> convertContainersToContainerVOs(List<Container> containers) {
        if (!PropertyValidator.isValid(containers)) {
            return null;
        }
        return containers.stream().map(ContainerVO::new).collect(Collectors.toList());
    }

    public static List<SessionVO> convertSessionsToSessionVOs(List<Session> sessions) {
        if (!PropertyValidator.isValid(sessions)) {
            return null;
        }
        return sessions.stream().map(SessionVO::new).collect(Collectors.toList());
    }

    public static List<ItemSessionBoardVO> convertSessionBoardsToSessionBoardVOs(List<SessionBoard> sessionBoards) {
        if (!PropertyValidator.isValid(sessionBoards)) {
            return null;
        }
        return sessionBoards.stream().map(ItemSessionBoardVO::new).collect(Collectors.toList());
    }

    public static List<ItemVO> convertItemsToItemVOs(List<Item> items) {
        if (!PropertyValidator.isValid(items)) {
            return null;
        }
        return items.stream().map(ItemVO::new).collect(Collectors.toList());
    }

    public static Status convertStatusVoToStatus(StatusVO statusVO) {
        if (!PropertyValidator.isValid((Object)statusVO)) {
            return null;
        }
        Status status = new Status();
        status.setId(statusVO.getId());
        status.setTitle(statusVO.getTitle());
        status.setColor(statusVO.getColor());
        status.setCategory(statusVO.getCategory());
        status.setJiraProjKey(statusVO.getJiraProjKey());
        status.setJiraIssueTypeId(statusVO.getJiraIssueTypeId());
        status.setJiraStatusId(statusVO.getJiraStatusId());
        status.setJiraStatusCatId(statusVO.getJiraStatusCatId());
        status.setJiraStatusOriginalCategory(statusVO.getJiraStatusOriginalCategory());
        status.setTfsId(statusVO.getTfsId());
        status.setTfsProject(statusVO.getTfsProject());
        status.setTfsProjectId(statusVO.getTfsProjectId());
        status.setSessionId(statusVO.getSessionId());
        status.setSolutionId(statusVO.getSolutionId());
        status.setAlmId(statusVO.getAlmId());
        return status;
    }

    public static RiskRegister convertRiskRegisterVoToRiskRegister(RiskRegisterVO riskRegisterVO) {
        if (!PropertyValidator.isValid((Object)riskRegisterVO)) {
            return null;
        }
        RiskRegister riskRegister = new RiskRegister();
        riskRegister.setId(riskRegisterVO.getId());
        riskRegister.setRegisterName(riskRegisterVO.getRegisterName());
        return riskRegister;
    }

    public static User convertUserVoToUser(UserVO userVO) {
        if (!PropertyValidator.isValid((Object)userVO)) {
            return null;
        }
        User user = new User();
        user.setId(userVO.getId());
        user.setUserName(userVO.getUserName());
        user.setFirstName(userVO.getFirstName());
        user.setLastName(userVO.getLastName());
        user.setFullName(userVO.getFullName());
        user.setEmail(userVO.getEmail());
        user.setPicturePath(userVO.getPicturePath());
        user.setBackgroundColor(userVO.getBackgroundColor());
        user.setImgPath(userVO.getImgPath());
        user.setUserType(userVO.getUserType());
        return user;
    }

    public static Conversation convertConverstationVoToConversation(ConversationVO conversationVO) {
        if (!PropertyValidator.isValid((Object)conversationVO)) {
            return null;
        }
        Conversation conversation = new Conversation();
        conversation.setId(conversationVO.getId());
        conversation.setAppUrl(conversationVO.getAppUrl());
        conversation.setUser(BusinessToVOUtils.convertUserVoToUser((UserVO)conversationVO.getUser()));
        conversation.setText(conversationVO.getText());
        conversation.setMine(conversationVO.isMine());
        conversation.setCreatedOn(conversationVO.getCreatedOn());
        conversation.setUpdatedOn(conversationVO.getUpdatedOn());
        conversation.setMentions(conversationVO.getMentions());
        conversation.setEdit(conversationVO.isEdit());
        conversation.setFirst(conversationVO.isFirst());
        conversation.setLast(conversationVO.isLast());
        return conversation;
    }

    public static Risk convertRiskVoToRisk(RiskVO riskVO, Risk risk) {
        if (!PropertyValidator.isValid((Object)riskVO)) {
            return risk;
        }
        risk.setId(riskVO.getId());
        risk.setRiskNumber(riskVO.getRiskNumber());
        risk.setRiskTitle(riskVO.getRiskTitle());
        risk.setRiskDesc(riskVO.getRiskDesc());
        risk.setMitigationActions(riskVO.getMitigationActions());
        risk.setImpact(riskVO.getImpact());
        risk.setStatus(BusinessToVOUtils.convertStatusVoToStatus((StatusVO)riskVO.getStatus()));
        risk.setProbability(riskVO.getProbability());
        risk.setRaisedDate(riskVO.getRaisedDate());
        risk.setResolutionDate(riskVO.getResolutionDate());
        risk.setConversationCount(riskVO.getConversationCount());
        risk.setLinkedItemsIds(riskVO.getLinkedItemsIds());
        risk.setExternalLinks(riskVO.getExternalLinks());
        risk.setNotifyWatchers(riskVO.getNotifyWatchers());
        risk.setBoardTeams(riskVO.getBoardTeams());
        risk.setBoardSprints(riskVO.getBoardSprints());
        risk.setLinkedItemsIds(riskVO.getLinkedItemsIds());
        risk.setLinkedItemsById(riskVO.getLinkedItemsById());
        risk.setActiveBoardIds(riskVO.getActiveBoardIds());
        risk.setRiskRegister(BusinessToVOUtils.convertRiskRegisterVoToRiskRegister((RiskRegisterVO)riskVO.getRiskRegister()));
        risk.setAppUrl(riskVO.getAppUrl());
        risk.setFields(riskVO.getFields());
        risk.setLinkedPiBoards(riskVO.getLinkedPiBoards());
        risk.setLinkedSolutionBoards(riskVO.getLinkedSolutionBoards());
        risk.setLinkedOrgCollections(riskVO.getLinkedOrgCollections());
        if (PropertyValidator.isValid((Collection)riskVO.getLinkedItems())) {
            ArrayList<Item> linkedItems = new ArrayList<Item>();
            for (ItemVO item : riskVO.getLinkedItems()) {
                linkedItems.add(BusinessToVOUtils.convertItemVoToItem((ItemVO)item));
            }
            risk.setLinkedItems(linkedItems);
        }
        ArrayList<Conversation> conversations = new ArrayList<Conversation>();
        for (ConversationVO conversation : riskVO.getConversations()) {
            conversations.add(BusinessToVOUtils.convertConverstationVoToConversation((ConversationVO)conversation));
        }
        risk.setConversations(conversations);
        return risk;
    }

    public static Item convertItemVoToItem(ItemVO itemVO) {
        if (!PropertyValidator.isValid((Object)itemVO)) {
            return null;
        }
        Item item = new Item();
        item.setId(itemVO.getId());
        item.setTitle(itemVO.getTitle());
        item.setJiraKey(itemVO.getJiraKey());
        item.setJiraURL(itemVO.getJiraURL());
        item.setKendisKey(itemVO.getKendisKey());
        item.setTfsId(itemVO.getTfsId());
        item.setTfsURL(itemVO.getTfsURL());
        item.setJiraIssueTypeId(itemVO.getJiraIssueTypeId());
        item.setJiraFieldByKey(itemVO.getJiraFieldByKey());
        item.setJiraFieldTextByKey(itemVO.getJiraFieldTextByKey());
        item.setType(itemVO.getType());
        item.setStoryPoints(itemVO.getStoryPoints());
        item.setTfsItemTypeIcon(itemVO.getTfsItemTypeIcon());
        item.setJiraId(itemVO.getJiraId());
        item.setFields(itemVO.getFields());
        item.setStartDate(itemVO.getStartDate());
        item.setEndDate(itemVO.getEndDate());
        item.setDueDate(itemVO.getDueDate());
        item.setIssueType(itemVO.getIssueType());
        item.setExternalReferenceURL(itemVO.getExternalReferenceURL());
        item.setTfsFieldByKey(itemVO.getTfsFieldByKey());
        item.setTfsIterationPath(itemVO.getTfsIterationPath());
        item.setPhoenixTC(BusinessToVOUtils.convertTeamContainerVoToTeamContainers((TeamContainerVO)itemVO.getPhoenixTC()));
        item.setStatus(BusinessToVOUtils.convertStatusVoToStatus((StatusVO)itemVO.getStatus()));
        item.setParent(BusinessToVOUtils.convertItemVoToItem((ItemVO)itemVO.getParent()));
        item.setSolutionBoard(BusinessToVOUtils.convertSolutionBoardVoToSolutionBoard((SolutionBoardVO)itemVO.getSolutionBoard()));
        if (PropertyValidator.isValid((Collection)itemVO.getItemLinks())) {
            ArrayList itemLinks = new ArrayList();
            itemVO.getItemLinks().forEach(itemLink -> itemLinks.add(BusinessToVOUtils.convertItemLinkVoToItemLink((ItemLinkVO)itemLink)));
            item.setItemLinks(itemLinks);
        }
        if (PropertyValidator.isValid((Collection)itemVO.getSolutionSourceItemLinks())) {
            ArrayList solutionSourceItemLinks = new ArrayList();
            itemVO.getSolutionSourceItemLinks().forEach(itemLink -> solutionSourceItemLinks.add(BusinessToVOUtils.convertItemLinkVoToItemLink((ItemLinkVO)itemLink)));
            item.setSolutionSourceItemLinks(solutionSourceItemLinks);
        }
        if (PropertyValidator.isValid((Collection)itemVO.getSolutionTargetItemLinks())) {
            ArrayList solutionTargetItemLinks = new ArrayList();
            itemVO.getSolutionTargetItemLinks().forEach(itemLink -> solutionTargetItemLinks.add(BusinessToVOUtils.convertItemLinkVoToItemLink((ItemLinkVO)itemLink)));
            item.setSolutionTargetItemLinks(solutionTargetItemLinks);
        }
        if (PropertyValidator.isValid((Collection)itemVO.getSessionBoards())) {
            ArrayList sessionBoards = new ArrayList();
            itemVO.getSessionBoards().forEach(sessionBoard -> sessionBoards.add(BusinessToVOUtils.convertItemSessionBoardVoToSessionBoard((ItemSessionBoardVO)sessionBoard)));
            item.setSessionBoards(sessionBoards);
        }
        if (PropertyValidator.isValid((Collection)itemVO.getJiraDependencies())) {
            ArrayList jiraDependencies = new ArrayList();
            itemVO.getJiraDependencies().forEach(itemJiraDependency -> {
                if (PropertyValidator.isValid((Object)itemJiraDependency)) {
                    jiraDependencies.add(BusinessToVOUtils.convertItemJiraDepVoToItemJiraDep((ItemJiraDependencyVO)itemJiraDependency));
                }
            });
            item.setJiraDependencies(jiraDependencies);
        }
        if (PropertyValidator.isValid((Collection)itemVO.getTeamContainers())) {
            ArrayList teamContainers = new ArrayList();
            itemVO.getTeamContainers().forEach(teamContainer -> teamContainers.add(BusinessToVOUtils.convertTeamContainerVoToTeamContainers((TeamContainerVO)teamContainer)));
            item.setTeamContainers(teamContainers);
        }
        return item;
    }

    public static SessionBoard convertItemSessionBoardVoToSessionBoard(ItemSessionBoardVO itemSessionBoardVO) {
        if (!PropertyValidator.isValid((Object)itemSessionBoardVO)) {
            return null;
        }
        SessionBoard sessionBoard = new SessionBoard();
        sessionBoard.setId(itemSessionBoardVO.getId());
        sessionBoard.setSession(BusinessToVOUtils.convertSessionVoToSession((SessionVO)itemSessionBoardVO.getSession()));
        sessionBoard.setObjectivesMap(itemSessionBoardVO.getObjectivesMap());
        return sessionBoard;
    }

    public static TeamContainer convertTeamContainerVoToTeamContainers(TeamContainerVO teamContainerVO) {
        if (!PropertyValidator.isValid((Object)teamContainerVO)) {
            return null;
        }
        TeamContainer teamContainer = new TeamContainer();
        teamContainer.setId(teamContainerVO.getId());
        teamContainer.setTeam(BusinessToVOUtils.convertTeamVoToTeam((TeamVO)teamContainerVO.getTeam()));
        teamContainer.setContainer(teamContainerVO.getContainer());
        return teamContainer;
    }

    public static Session convertSessionVoToSession(SessionVO sessionVO) {
        if (!PropertyValidator.isValid((Object)sessionVO)) {
            return null;
        }
        Session session = new Session();
        session.setId(sessionVO.getId());
        session.setTitle(sessionVO.getTitle());
        session.setAlmEnabled(sessionVO.isAlmEnabled());
        session.setParentItem(sessionVO.getParentItem());
        session.setChildItem(sessionVO.getChildItem());
        session.setJiraFlaggedFieldEnabled(sessionVO.getJiraFlaggedFieldEnabled());
        session.setKendisFlaggedFieldEnabled(sessionVO.getKendisFlaggedFieldEnabled());
        return session;
    }

    public static Team convertTeamVoToTeam(TeamVO teamVO) {
        if (!PropertyValidator.isValid((Object)teamVO)) {
            return null;
        }
        Team team = new Team();
        team.setId(teamVO.getId());
        team.setTitle(teamVO.getTitle());
        team.setLabel(teamVO.getLabel());
        team.setColor(teamVO.getColor());
        team.setBoardId(teamVO.getBoardId());
        team.setProjectId(teamVO.getProjectId());
        team.setIssueTypeId(teamVO.getIssueTypeId());
        return team;
    }

    public static ItemLink convertItemLinkVoToItemLink(ItemLinkVO itemLinkVO) {
        if (!PropertyValidator.isValid((Object)itemLinkVO)) {
            return null;
        }
        ItemLink itemLink = new ItemLink();
        itemLink.setId(itemLinkVO.getId());
        itemLink.setTitle(itemLinkVO.getTitle());
        itemLink.setStatus(itemLinkVO.getStatus());
        itemLink.setType(itemLinkVO.getType());
        return itemLink;
    }

    public static ItemJiraDependency convertItemJiraDepVoToItemJiraDep(ItemJiraDependencyVO itemJiraDependencyVO) {
        if (!PropertyValidator.isValid((Object)itemJiraDependencyVO)) {
            return null;
        }
        ItemJiraDependency itemJiraDependency = new ItemJiraDependency();
        itemJiraDependency.setId(itemJiraDependencyVO.getId());
        itemJiraDependency.setJiraDependencyId(itemJiraDependencyVO.getJiraDependencyId());
        itemJiraDependency.setTargetJiraIssue(itemJiraDependencyVO.getTargetJiraIssue());
        itemJiraDependency.setTargetTFSItem(itemJiraDependencyVO.getTargetTFSItem());
        itemJiraDependency.setLinkType(itemJiraDependencyVO.getLinkType());
        itemJiraDependency.setIsTFS(itemJiraDependencyVO.getTFS());
        return itemJiraDependency;
    }

    public static SolutionBoard convertSolutionBoardVoToSolutionBoard(SolutionBoardVO solutionBoardVO) {
        if (!PropertyValidator.isValid((Object)solutionBoardVO)) {
            return null;
        }
        SolutionBoard solutionBoard = new SolutionBoard();
        solutionBoard.setId(solutionBoardVO.getId());
        return solutionBoard;
    }
}

