/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class BlindSSLSocketFactory
extends SocketFactory {
    private static SocketFactory blindFactory = null;

    public static SocketFactory getDefault() {
        return new BlindSSLSocketFactory();
    }

    @Override
    public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
        return blindFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return blindFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
        return blindFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return blindFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
        boolean validateCert = false;
        System.out.println("Testing LDAPS connection with validateCert: " + validateCert);
        Hashtable<String, String> env = new Hashtable<String, String>();
        String url = "ldaps://xxxxx.amazonaws.com:636";
        String domain = "LOXVO.COM";
        String login = "xxxxxxx";
        String password = "xxxxxx";
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", login + "@" + domain);
        env.put("java.naming.security.credentials", password);
        if (url.startsWith("ldaps") && !validateCert) {
            env.put("java.naming.ldap.factory.socket", BlindSSLSocketFactory.class.getName());
        }
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            System.out.println("Successfull bind to " + url + "!");
        }
        catch (AuthenticationException e) {
            System.out.println("The credentials could not be validated!");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    static {
        TrustManager[] blindTrustMan = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, blindTrustMan, new SecureRandom());
            blindFactory = sc.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
    }
}

