/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.Attachment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class AttachmentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentUtils.class);

    public static boolean storeData(Attachment attachment, AppConfig.MongoConfig mongoConfig) {
        try {
            BasicDBObject metaData = new BasicDBObject();
            metaData.put("key", (Object)attachment.getReferenceKey());
            metaData.put("tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant());
            ByteArrayInputStream stream = new ByteArrayInputStream(attachment.getAttachmentData());
            mongoConfig.gridFsTemplate().store((InputStream)stream, attachment.getFilename(), attachment.getContentType(), (DBObject)metaData).toString();
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            return false;
        }
    }

    public static byte[] retrieveData(String key, AppConfig.MongoConfig mongoConfig) {
        try {
            List GridFSDBFile2 = mongoConfig.gridFsTemplate().find(new Query((CriteriaDefinition)Criteria.where((String)"metadata.key").is((Object)key)));
            if (GridFSDBFile2 != null) {
                int bytesRead;
                InputStream is = ((GridFSDBFile)GridFSDBFile2.get(0)).getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                return outputStream.toByteArray();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while retrieving attachment: " + StringUtils.getTraceString((Throwable)ex));
        }
        return null;
    }

    public static boolean removeData(String key, AppConfig.MongoConfig mongoConfig) {
        try {
            mongoConfig.gridFsTemplate().delete(new Query((CriteriaDefinition)Criteria.where((String)"metadata.key").is((Object)key)));
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Error while removing attachment :" + StringUtils.getTraceString((Throwable)ex));
            return false;
        }
    }

    public static String uploadImageFromBase64(String base64Data, String filename, AppConfig.MongoConfig mongoConfig) throws Exception {
        String base64Content;
        if (!PropertyValidator.isValid((Object)base64Data)) {
            throw new IllegalArgumentException("Base64 data is required");
        }
        String contentType = "image/png";
        if (base64Data.contains(",")) {
            String[] parts = base64Data.split(",");
            if (parts.length == 2) {
                int start;
                int end;
                String header = parts[0];
                if (header.contains("image/") && (end = header.indexOf(";", start = header.indexOf("image/"))) > start) {
                    contentType = header.substring(start, end);
                }
                base64Content = parts[1];
            } else {
                base64Content = base64Data;
            }
        } else {
            base64Content = base64Data;
        }
        byte[] imageBytes = Base64.getDecoder().decode(base64Content);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
        BasicDBObject metaData = new BasicDBObject();
        metaData.put("filename", (Object)filename);
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && PropertyValidator.isValid((Object)UserContextUtil.getUserContext().getLoggedInUser())) {
            metaData.put("tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant());
        }
        GridFSFile gridFSFile = mongoConfig.gridFsTemplate().store((InputStream)inputStream, filename, contentType, (DBObject)metaData);
        LOGGER.info("Successfully uploaded base64 image to MongoDB GridFS: {} with ID: {}", (Object)filename, (Object)gridFSFile.getId().toString());
        return gridFSFile.getId().toString();
    }
}

