/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.AlmInfo;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlmErrorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlmErrorUtils.class);
    static Gson gsonPush = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (date, type, jsonSerializationContext) -> new JsonPrimitive((Number)date.getTime())).create();

    public static String buildAlmPushJson(Item item, String sessionBoardId, String event, String message, Boolean almErrorFix, Boolean isWebhook) {
        JSONObject pushJson = null;
        try {
            pushJson = new JSONObject();
            pushJson.put("AlmErrorFix", (Object)almErrorFix);
            if (PropertyValidator.isValid((Object)item.getScore())) {
                pushJson.put("score", (Object)item.getScore());
            }
            if (PropertyValidator.isValid((Object)item.getAlmScoreField())) {
                pushJson.put("almScoreField", (Object)item.getAlmScoreField());
            }
            if (PropertyValidator.isValid((Object)item.getParent())) {
                HashMap<String, String> parent1 = new HashMap<String, String>();
                parent1.put("id", item.getParent() == null ? null : item.getParent().getId());
                pushJson.put("parent", parent1);
                pushJson.put("parentId", parent1.get("id"));
                ObjectMapper mapper = new ObjectMapper();
                try {
                    Item parent = item.getParent(item.getParent(), true);
                    pushJson.put("webhookParent", (Object)gsonPush.toJson((Object)parent));
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (PropertyValidator.isValid((Object)item.getTitle())) {
                pushJson.put("title", (Object)item.getTitle());
            }
            pushJson.put("flagged", (Object)item.getFlagged());
            if (PropertyValidator.isValid((Object)item.getDueDate())) {
                pushJson.put("dueDate", item.getDueDate().getTime());
            }
            if (PropertyValidator.isValid((Object)item.getStartDate())) {
                pushJson.put("startDate", item.getStartDate().getTime());
            }
            if (PropertyValidator.isValid((Object)item.getEndDate())) {
                pushJson.put("endDate", item.getEndDate().getTime());
            }
            ObjectMapper mapper = new ObjectMapper();
            if (PropertyValidator.isValid((Object)item.getStatus())) {
                pushJson.put("status", (Object)item.getStatus());
                pushJson.put("statusTitle", (Object)item.getStatus().getTitle());
                pushJson.put("statusId", (Object)item.getStatus().getId());
                try {
                    pushJson.put("webHookStatus", (Object)mapper.writeValueAsString((Object)item.getStatus()));
                }
                catch (JsonProcessingException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (PropertyValidator.isValid((Object)item.getStoryPoints())) {
                pushJson.put("storyPoint", (Object)item.getStoryPoints());
                pushJson.put("storyPoints", (Object)item.getStoryPoints());
            }
            if (PropertyValidator.isValid((Object)item.getJiraIssueTypeId())) {
                pushJson.put("jiraIssueTypeId", (Object)item.getJiraIssueTypeId());
            }
            if (PropertyValidator.isValid((Object)item.isArchive())) {
                pushJson.put("archive", item.isArchive());
            }
            if (Item.USER_STORY.equals(item.getType())) {
                List teamConts;
                if (PropertyValidator.isValid((Collection)item.getTeamContainers()) && PropertyValidator.isValid((Object)((TeamContainer)(teamConts = item.getTeamContainers()).get(0)).getContainer()) && PropertyValidator.isValid((Object)((TeamContainer)teamConts.get(0)).getTeam())) {
                    JSONObject obj = new JSONObject();
                    obj.put("teamContainerId", (Object)((TeamContainer)teamConts.get(0)).getId());
                    obj.put("containerId", (Object)((TeamContainer)teamConts.get(0)).getContainer().getId());
                    obj.put("teamId", (Object)((TeamContainer)teamConts.get(0)).getTeam().getId());
                    pushJson.put("teamContainer", (Object)obj);
                }
                if (isWebhook == Boolean.TRUE) {
                    pushJson.put("isWebhook", true);
                }
            }
            if (Item.FEATURE.equals(item.getType()) && PropertyValidator.isValid((Object)item.getSubItemEstimate())) {
                pushJson.put("subItemEstimate", (Object)item.getSubItemEstimate());
            }
            try {
                if (PropertyValidator.isValid((Object)item.getJiraFieldByKey())) {
                    pushJson.put("jiraFieldJson", (Object)mapper.writeValueAsString((Object)item.getJiraFieldByKey()));
                }
            }
            catch (JsonProcessingException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            try {
                if (PropertyValidator.isValid((Object)item.getJiraFieldByKey())) {
                    item.putCustomeValuesAsText(item.getJiraFieldByKey(), (Collection)((SessionBoard)item.getSessionBoards().get(0)).getSession().combineAdditionalFields(null, null, true, null), null);
                    pushJson.put("jiraFieldJsonText", (Object)mapper.writeValueAsString((Object)item.getJiraFieldTextByKey()));
                }
            }
            catch (JsonProcessingException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            AlmErrorUtils.fillPushJson((JSONObject)pushJson, (Item)item, (String)sessionBoardId, (String)event, (String)message);
            return pushJson.toString();
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public static void fillPushJson(JSONObject pushJson, Item item, String sessionBoardId, String event, String message) {
        pushJson.put("isJira", true);
        pushJson.put("type", (Object)item.getType());
        pushJson.put("id", (Object)item.getId());
        pushJson.put("deletedInJira", item.isDeletedInJira());
        if (PropertyValidator.isValid((Object)item.getAlmWarning())) {
            pushJson.put("almWarning", (Object)item.getAlmWarning());
        }
        if (PropertyValidator.isValid((Object)item.getErrorInAlmSync())) {
            pushJson.put("errorInAlmSync", (Object)item.getErrorInAlmSync());
        }
        if (PropertyValidator.isValid((Object)item.getJiraKey())) {
            pushJson.put("jiraKey", (Object)item.getJiraKey());
        }
        if (PropertyValidator.isValid((Object)item.getJiraId())) {
            pushJson.put("jiraId", (Object)item.getJiraId());
        }
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            pushJson.put("boardId", (Object)sessionBoardId);
        }
        if (PropertyValidator.isValid((Object)message)) {
            pushJson.put("AlmErrrorMsg", (Object)message);
        }
        pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"boardId\":\"" + sessionBoardId + "\", \"isJira\":" + Boolean.TRUE + "}"));
    }

    public static String buildAlmPushJsonForTFS(Item item, String sessionBoardId, String event, List<Item> newChildsAdded, List<Item> existingChildsUpdated, List<Item> existingChildsRemoved, List<ItemJiraDependency> newTFSDependencies, List<ItemJiraDependency> removedTFSDependencies, Gson gsonExclusive, String message) {
        JSONObject pushJson = null;
        try {
            pushJson = new JSONObject();
            pushJson.put("isTFS", true);
            pushJson.put("type", (Object)item.getType());
            pushJson.put("id", (Object)item.getId());
            if (PropertyValidator.isValid((Object)message)) {
                pushJson.put("AlmErrrorMsg", (Object)message);
            }
            if (PropertyValidator.isValid((Object)sessionBoardId)) {
                pushJson.put("boardId", (Object)sessionBoardId);
            }
            item = new Item(item);
            pushJson.put("item", (Object)gsonExclusive.toJson((Object)item));
            ArrayList<Item> newItems = null;
            ArrayList<Item> existingItems = null;
            ArrayList<Item> itemsRemoved = null;
            if (PropertyValidator.isValid(newChildsAdded)) {
                newItems = new ArrayList<Item>();
                for (Item itm : newChildsAdded) {
                    newItems.add(new Item(itm));
                }
                pushJson.put("newChildsAdded", (Object)gsonExclusive.toJson(newItems));
            }
            if (PropertyValidator.isValid(existingChildsUpdated)) {
                existingItems = new ArrayList<Item>();
                for (Item itm : existingChildsUpdated) {
                    existingItems.add(new Item(itm));
                }
                pushJson.put("existingChildsUpdated", (Object)gsonExclusive.toJson(existingItems));
            }
            if (PropertyValidator.isValid(existingChildsRemoved)) {
                itemsRemoved = new ArrayList<Item>();
                for (Item itm : existingChildsRemoved) {
                    itemsRemoved.add(new Item(itm));
                }
                pushJson.put("existingChildsRemoved", (Object)gsonExclusive.toJson(itemsRemoved));
            }
            if (PropertyValidator.isValid(newTFSDependencies)) {
                pushJson.put("newTFSDependencies", (Object)gsonExclusive.toJson(newTFSDependencies));
            }
            if (PropertyValidator.isValid(removedTFSDependencies)) {
                pushJson.put("removedTFSDependencies", (Object)gsonExclusive.toJson(removedTFSDependencies));
            }
            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"boardId\":\"" + sessionBoardId + "\", \"isTFS\":" + Boolean.TRUE + "}"));
            return pushJson.toString();
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public static String buildAlmPushJsonForBacklogItemTFSWebhook(BacklogItem item, boolean isUpdated, String event, ArrayList<BacklogItem> childrenAdded, ArrayList<String> childrenRemoved, ArrayList<BacklogItem> parentAdded, ArrayList<String> parentRemoved, Gson gsonExclusive, String errorMessage, String releaseTrainId) {
        JSONObject pushJson = null;
        try {
            pushJson = new JSONObject();
            pushJson.put("isTFS", true);
            pushJson.put("isRT", true);
            pushJson.put("id", (Object)item.getId());
            if (PropertyValidator.isValid((Object)errorMessage)) {
                pushJson.put("AlmErrrorMsg", (Object)errorMessage);
            }
            pushJson.put("item", (Object)gsonExclusive.toJson((Object)item));
            pushJson.put("itemUpdated", isUpdated);
            pushJson.put("releaseTrainId", (Object)releaseTrainId);
            if (PropertyValidator.isValid(childrenAdded)) {
                pushJson.put("childrenAdded", (Object)gsonExclusive.toJson(childrenAdded));
            }
            if (PropertyValidator.isValid(childrenRemoved)) {
                pushJson.put("childrenRemoved", (Object)gsonExclusive.toJson(childrenRemoved));
            }
            if (PropertyValidator.isValid(parentAdded)) {
                pushJson.put("parentAdded", (Object)gsonExclusive.toJson(parentAdded));
            }
            if (PropertyValidator.isValid(parentRemoved)) {
                pushJson.put("parentRemoved", (Object)gsonExclusive.toJson(parentRemoved));
            }
            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"isTFS\":" + Boolean.TRUE + "}"));
            return pushJson.toString();
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public static AlmError buildAlmErrorObj(Item item, String sessionBoardId, User loggedInUser, ViztrendJiraException vje, Boolean isStatusErr) {
        AlmError almError = new AlmError();
        if (PropertyValidator.isValid((Object)((Object)vje))) {
            if (PropertyValidator.isValid((Object)vje.getAlmError())) {
                almError = vje.getAlmError();
                almError.tenant = loggedInUser.retCurrentTenant();
                if (loggedInUser.getId() != null) {
                    almError.setCreatedBy(loggedInUser.getId());
                }
                almError.setCreatedOn(new Date());
                almError.setSessionBoardId(sessionBoardId);
                almError.setDescription(vje.getMessage());
                almError.setItem(item);
            } else {
                almError.tenant = loggedInUser.tenant;
                if (loggedInUser.getId() != null) {
                    almError.setCreatedBy(loggedInUser.getId());
                }
                almError.setCreatedOn(new Date());
                almError.setSessionBoardId(sessionBoardId);
                almError.setDescription(vje.getMessage());
                almError.setItem(item);
            }
        } else {
            almError.tenant = loggedInUser.tenant;
            if (loggedInUser.getId() != null) {
                almError.setCreatedBy(loggedInUser.getId());
            }
            almError.setCreatedOn(new Date());
            almError.setSessionBoardId(sessionBoardId);
            if (PropertyValidator.isValid((Object)item)) {
                almError.setDescription(item.getAlmErrorMessage());
            }
            almError.setItem(item);
            if (isStatusErr.booleanValue()) {
                almError.setType("Status");
            }
        }
        return almError;
    }

    public static AlmInfo buildAlmInfoObj(Item item, String message, String sessionBoardId, User loggedInUser, int type) {
        AlmInfo almInfo = new AlmInfo();
        almInfo.setTenant(item.getTenant());
        almInfo.setCreatedOn(new Date());
        almInfo.setSessionBoardId(sessionBoardId);
        almInfo.setDescription(message);
        almInfo.setType(type);
        almInfo.setItem(item);
        return almInfo;
    }
}

