/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.strategy;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class FloatTypeAdapter
extends TypeAdapter<Float> {
    public void write(JsonWriter out, Float value) throws IOException {
        if (Float.isNaN(value.floatValue())) {
            out.value(0.0);
        } else {
            out.value((Number)value);
        }
    }

    public Float read(JsonReader in) throws IOException {
        float value = in.nextLong();
        if (Float.isNaN(value)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(value);
    }
}

