/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.strategy;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.IOException;

public class DoubleTypeAdapter
extends TypeAdapter<Double> {
    public void write(JsonWriter out, Double value) throws IOException {
        if (PropertyValidator.isValid((Object)value) && Double.isNaN(value)) {
            out.value(0.0);
        } else {
            out.value((Number)value);
        }
    }

    public Double read(JsonReader in) throws IOException {
        Double value = in.nextDouble();
        if (Double.isNaN(value)) {
            return 0.0;
        }
        return value;
    }
}

