/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.ArrayMap;
import com.google.common.collect.Sets;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.alm.jira.ExportUtil;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssue2;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkPayload;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraItem;
import com.viztrend.safe.alm.jira.bo.JiraStatus;
import com.viztrend.safe.alm.jira.bo.JiraWebhookMappedData;
import com.viztrend.safe.alm.jira.bo.JiraWebhookPayload;
import com.viztrend.safe.alm.jira.bo.TFSIssue;
import com.viztrend.safe.alm.jira.bo.TFSWebhookMappedData;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.alm.tfs.TFSTeamMapping;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BacklogMapping;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.JiraProjectIssueTypes;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Sprint;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemSyncMapperRepository;
import com.viztrend.safe.persistence.repository.JiraFieldRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.persistence.repository.JiraWebhookRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SprintRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSAlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.TFSWebhookRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.WebhookActivityRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.RTItemTfsSyncService;
import com.viztrend.safe.service.ReleaseTrainServiceImpl;
import com.viztrend.safe.service.ScoreCardService;
import com.viztrend.safe.service.SprintReportServics;
import com.viztrend.safe.service.TFSRiskService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.WebHookSyncService;
import com.viztrend.safe.service.WebHookSyncServiceImpl;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmErrorUtils;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.S3Utils;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.SystemUtil;
import com.viztrend.safe.utils.WebhookActivityUtil;
import com.viztrend.safe.vos.ResyncParamsVO;
import com.viztrend.safe.vos.WebHookEntryVO;
import com.viztrend.safe.vos.WebhookCloudResponseVO;
import com.viztrend.safe.vos.WebhookResponseVO;
import com.viztrend.safe.vos.WebhookVO;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="WebHookSyncService")
@Transactional
public class WebHookSyncServiceImpl
implements WebHookSyncService {
    @Autowired
    private ImportUtil importUtil;
    @Autowired
    private ExportUtil exportUtil;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private JiraFieldRepository jiraFieldRepository;
    @Autowired
    private PlanService planService;
    @Autowired
    private TFSservice tfsService;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    ItemLinkRepository itemLinkRepository;
    @Autowired
    private SprintRepository sprintRepository;
    @Autowired
    private ItemSyncMapperRepository itemSyncMapperRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    private TFSAlmConfigurationsRepository tfsAlmConfigurationsRepository;
    @Autowired
    private JiraWebhookRepository jiraWebhookRepository;
    @Autowired
    private TFSWebhookRepository tfsWebhookRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private ItemLinkTypeRepository itemLinkTypeRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private WebhookActivityRepository webhookActivityRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private Environment ENV;
    @Autowired
    private S3Utils s3util;
    @Autowired
    private Gson gson;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RTItemTfsSyncService rtItemTfsSyncService;
    @Autowired
    private TFSRiskService tfsRiskService;
    @Autowired
    private SprintReportServics sprintReportServics;
    @Autowired
    private ReleaseTrainServiceImpl releaseTrainServiceImpl;
    @Autowired
    private ScoreCardService scoreCardService;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebHookSyncServiceImpl.class);
    private static final Logger LOGGERHEALTH = LoggerFactory.getLogger((String)"health");
    private static final Logger LOGGER_WH_HEALTH = LoggerFactory.getLogger((String)"wh_health");
    private static final JiraIssueLinkType epicChildsLinkType = new JiraIssueLinkType("+1", "", "Epic Link", "Epic Link", "Epic Link", "UP");
    public static long elbLastActive = 0L;
    static Boolean dataProcessing = false;
    static Boolean tfsDataProcessing = false;

    public JiraIssue2 getIssue(String id, JiraWebhookPayload payload, AlmAccount almAccount) {
        if (payload.issuesMap == null) {
            payload.issuesMap = new HashMap();
        }
        if (payload.issuesMap.get(id) == null) {
            JiraIssue2 issue = new JiraIssue2(id, id, almAccount == null ? "" : almAccount.getUrl());
            issue.setFields(this.getEmptyJiraJson(id));
            issue.getFields().put(JiraField.FIXED.summary.name(), "");
            issue.getFields().put(JiraField.FIXED.project.name(), this.getEmptyJiraJson(""));
            issue.getFields().put(JiraField.FIXED.issuetype.name(), this.getEmptyJiraJson(""));
            payload.putIssue(issue);
        }
        return (JiraIssue2)payload.issuesMap.get(id);
    }

    public void printLogs(String almId, String log) {
        if (almId != null) {
            LOGGER_WH_HEALTH.debug("webhoook log from alm : " + almId);
        }
        LOGGER_WH_HEALTH.debug(log);
    }

    public void printLogs(String almId, Collection<String> logs) {
        if (almId != null) {
            LOGGER_WH_HEALTH.debug("webhoook log from alm : " + almId);
        }
        LOGGER_WH_HEALTH.debug(String.join((CharSequence)"\n", logs));
    }

    private JiraItem anyParentChildLink(JiraWebhookPayload payload, JiraField epicLabel, JiraField epicLink, Boolean debugMode) {
        boolean epicLinkChangeEvent = false;
        boolean parentLinkChangeEvent = false;
        JiraItem epicChangeLog = null;
        JiraItem parentLinkChangeLog = null;
        if ("jira:issue_updated".equals(payload.getWebhookEvent())) {
            List changeLogs;
            if (payload.getChangelog() != null && PropertyValidator.isValid((Collection)payload.getChangelog().getItems()) && PropertyValidator.isValid((Collection)(changeLogs = payload.getChangelog().getItems()))) {
                payload.logActivity("10. valid changelog for issue_updated");
                for (JiraItem changeLogItem : changeLogs) {
                    LinkedHashMap new_name;
                    if (!PropertyValidator.isValid((Object)changeLogItem)) continue;
                    if (PropertyValidator.isValid((Object)epicLabel) && (epicLabel.getJiraId().equalsIgnoreCase(changeLogItem.getFieldId()) || epicLabel.getJiraId().equalsIgnoreCase(changeLogItem.getField()))) {
                        epicLinkChangeEvent = true;
                        epicChangeLog = changeLogItem;
                    } else if (PropertyValidator.isValid((Object)epicLink) && (epicLink.getJiraId().equalsIgnoreCase(changeLogItem.getFieldId()) || epicLink.getJiraId().equalsIgnoreCase(changeLogItem.getField()))) {
                        epicLinkChangeEvent = true;
                        epicChangeLog = changeLogItem;
                    } else if ("IssueParentAssociation".equals(changeLogItem.getField())) {
                        epicLinkChangeEvent = true;
                        epicChangeLog = changeLogItem;
                    }
                    if (!PropertyValidator.isValid((Object)changeLogItem.getFieldId()) || !(payload.getIssue().getFields().get(changeLogItem.getFieldId()) instanceof LinkedHashMap) || (new_name = (LinkedHashMap)payload.getIssue().getFields().get(changeLogItem.getFieldId())).isEmpty() || !PropertyValidator.isValid(new_name.get("hasEpicLinkFieldDependency"))) continue;
                    parentLinkChangeEvent = true;
                    parentLinkChangeLog = changeLogItem;
                }
            }
            payload.epicLinkChangeEvent = epicLinkChangeEvent;
            payload.parentLinkChangeEvent = parentLinkChangeEvent;
            payload.epicChangeLog = epicChangeLog;
            payload.parentLinkChangeLog = parentLinkChangeLog;
        } else if (payload.anyParentChildLinkOnCreation()) {
            payload.setWebhookEvent("jira:issue_updated");
        }
        if (payload.epicChangeLog != null) {
            return payload.epicChangeLog;
        }
        if (payload.parentLinkChangeLog != null) {
            return payload.parentLinkChangeLog;
        }
        return null;
    }

    private Map<String, Object> getAlmFields(JiraField sprintField, JiraField epicLinkField, JiraIssue2 jiraIssue, AlmAccount almAccount) throws Exception {
        JiraProjectIssueTypes jiraProjectIssueType;
        Map project;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        JiraField storyPointField = almAccount.getStoryPointField();
        if (!PropertyValidator.isValid((Object)storyPointField)) {
            storyPointField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountIdAndTenant("Story Points", almAccount.getId(), almAccount.getTenant());
        }
        if (PropertyValidator.isValid((Object)almAccount.getNextGenStoryPointField()) && PropertyValidator.isValid((Object)jiraIssue) && PropertyValidator.isValid((Object)jiraIssue.getFields()) && PropertyValidator.isValid((Object)(project = (Map)jiraIssue.getFields().get("project"))) && PropertyValidator.isValid((Object)(jiraProjectIssueType = this.jiraProjectIssueTypesRepository.findProjectStyleByAlmAccountIdAndJiraProjectKey(almAccount.getId(), (String)project.get("key")))) && "next-gen".equals(jiraProjectIssueType.getStyle())) {
            storyPointField = almAccount.getNextGenStoryPointField();
        }
        fields.put("Story Points", storyPointField);
        JiraField dueDateField = almAccount.getDueDateField();
        if (!PropertyValidator.isValid((Object)dueDateField)) {
            dueDateField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountIdAndTenant("duedate", almAccount.getId(), almAccount.getTenant());
        }
        fields.put("duedate", dueDateField);
        JiraField startDateField = almAccount.getStartDateField();
        if (!PropertyValidator.isValid((Object)startDateField)) {
            startDateField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountIdAndTenant("startDate", almAccount.getId(), almAccount.getTenant());
        }
        fields.put("startDate", startDateField);
        JiraField endDateField = almAccount.getEndDateField();
        if (!PropertyValidator.isValid((Object)endDateField)) {
            endDateField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountIdAndTenant("endDate", almAccount.getId(), almAccount.getTenant());
        }
        fields.put("endDate", endDateField);
        Double sysSequence = new Double(System.nanoTime() / 100000L);
        fields.put("sequence", sysSequence);
        fields.put("epicLink", epicLinkField);
        fields.put("Sprint", sprintField);
        return fields;
    }

    public void updateJiraWebhookItem(String unMappedDataId, JiraWebhookMappedData jiraWebhookMappedData, String accId, String keyForDel, Long sequence, List<String> logs) {
        boolean handleJiraDepToCheckItemChanged = false;
        JiraWebhookPayload jWebHookPayload = jiraWebhookMappedData.getJiraWebhookPayload();
        if (jWebHookPayload == null) {
            if (jiraWebhookMappedData.getJiraWebhookPayloadStr() == null) {
                logs.add("Jira json payload not found (updateJiraWebhookItem) ");
                return;
            }
            jWebHookPayload = (JiraWebhookPayload)this.gson.fromJson(jiraWebhookMappedData.getJiraWebhookPayloadStr(), JiraWebhookPayload.class);
            jiraWebhookMappedData.setJiraWebhookPayload(jWebHookPayload);
        }
        jWebHookPayload.logs = logs;
        AlmAccount almAccount = this.almAccountRepository.findById(accId);
        jiraWebhookMappedData.setAlmAccount(almAccount);
        WebhookActivityUtil.getInstance().reset();
        try {
            ArrayList<String> webhookJiraIds = new ArrayList<String>();
            if (jiraWebhookMappedData.getJiraId() != null) {
                webhookJiraIds.add(jiraWebhookMappedData.getJiraId());
                logs.add("Adding Jira ID to webhook Jira IDs.");
            }
            if (jiraWebhookMappedData.getJiraSourceIssueId() != null) {
                webhookJiraIds.add(jiraWebhookMappedData.getJiraSourceIssueId());
                logs.add("Adding Jira Source Issue ID to webhook Jira IDs.");
            }
            if (jiraWebhookMappedData.getJiraDestinationIssueId() != null) {
                webhookJiraIds.add(jiraWebhookMappedData.getJiraDestinationIssueId());
                logs.add("Adding Jira Source Destination ID to webhook Jira IDs.");
            }
            Boolean debugMode = Boolean.FALSE;
            if (PropertyValidator.isValid((Object)almAccount)) {
                debugMode = almAccount.isDebug();
            }
            List almConfigs = this.almConfigurationsRepository.findConfigsByAlmAccount(almAccount);
            jWebHookPayload.logActivity("1. Going to update Item");
            HashMap almConfigsMap = new HashMap();
            if (!PropertyValidator.isValid((Collection)almConfigs)) {
                jWebHookPayload.logError("2.[skipped] No Configurations founds");
                WebhookActivityUtil.getInstance().reset();
                return;
            }
            logs.add("ALM_CONFIGURATIONS_FOUND_AGAINST_ALM_ACC");
            if (!PropertyValidator.isValid((Object)almAccount)) {
                this.jiraWebhookRepository.delete((Serializable)((Object)unMappedDataId));
                jWebHookPayload.logError("3.[skipped] Payload not used");
                WebhookActivityUtil.getInstance().reset();
                return;
            }
            ResyncParamsVO syncUtil = new ResyncParamsVO();
            JiraField sprintField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountIdAndTenant("com.pyxis.greenhopper.jira:gh-sprint", almAccount.getId(), almAccount.getTenant());
            JiraField epicLinkField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountIdAndTenant("com.pyxis.greenhopper.jira:gh-epic-label", almAccount.getId(), almAccount.getTenant());
            syncUtil.epicLinkField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountIdAndTenant("com.pyxis.greenhopper.jira:gh-epic-link", almAccount.getId(), almAccount.getTenant());
            syncUtil.uplevel = new ArrayList();
            JiraItem relation = null;
            boolean found = false;
            if (PropertyValidator.isValid(webhookJiraIds)) {
                Boolean itemsExist = this.itemRepository.existsByJiraIdInAndTenantAndArchive(webhookJiraIds, jiraWebhookMappedData.getTenantId(), false);
                relation = this.anyParentChildLink(jWebHookPayload, epicLinkField, syncUtil.epicLinkField, debugMode);
                if (itemsExist.equals(Boolean.FALSE)) {
                    if (relation != null) {
                        ArrayList<String> otherIds = new ArrayList<String>();
                        if (PropertyValidator.isValid((Object)relation.getTo()) && relation.getTo() instanceof String) {
                            otherIds.add((String)relation.getTo());
                        } else if (PropertyValidator.isValid((Object)relation.getFrom()) && relation.getFrom() instanceof String) {
                            otherIds.add((String)relation.getFrom());
                        }
                        itemsExist = this.itemRepository.existsByJiraIdInAndTenantAndArchive(otherIds, jiraWebhookMappedData.getTenantId(), false);
                        if (itemsExist.equals(Boolean.TRUE)) {
                            found = true;
                        }
                    }
                } else {
                    found = true;
                }
            }
            Item savedItem = null;
            if (PropertyValidator.isValid((Collection)almConfigs)) {
                List sessions = this.sessionRepository.findByAlmConfigurationsInAndArchiveOrderByCreatedOn(almConfigs, false);
                ArrayList<String> sessionBoardIds = new ArrayList<String>();
                HashMap<String, String> mappedBucketTypes = new HashMap<String, String>();
                if (PropertyValidator.isValid((Collection)sessions)) {
                    LinkedList<ObjectId> sessionIds = new LinkedList<ObjectId>();
                    for (int i = 0; i < sessions.size(); ++i) {
                        sessionIds.add(new ObjectId(((Session)sessions.get(i)).getId()));
                        if (jWebHookPayload.getIssue() == null || !Boolean.TRUE.equals(((Session)sessions.get(i)).getBucketEnabled()) || ((Session)sessions.get(i)).getBuckets() == null) continue;
                        Set issueTypeIds = ((Session)sessions.get(i)).getBuckets().keySet();
                        Iterator iterator = issueTypeIds.iterator();
                        while (iterator.hasNext()) {
                            int index;
                            String issueTypeId = (String)iterator.next();
                            if (!PropertyValidator.isValid((Collection)((IssueType)((Session)sessions.get(i)).getBuckets().get(issueTypeId)).getJiraTypes()) || (index = ((IssueType)((Session)sessions.get(i)).getBuckets().get(issueTypeId)).getJiraTypes().indexOf(jWebHookPayload.getIssue().issueTypeId())) <= -1) continue;
                            mappedBucketTypes.put(((Session)sessions.get(i)).getActiveSessionBoard(), issueTypeId);
                        }
                    }
                    List sessionBoards = this.nativeFindBySessionInAndParentBoardIsNullOrderByCreatedOnDesc(sessionIds, jiraWebhookMappedData.getTenantId());
                    for (SessionBoard sessionBoard : sessionBoards) {
                        if (!"Close".equals(sessionBoard.getState().getTitle())) {
                            sessionBoardIds.add(sessionBoard.getId());
                            continue;
                        }
                        mappedBucketTypes.remove(sessionBoard.getId());
                    }
                }
                if (!found && mappedBucketTypes.isEmpty()) {
                    jWebHookPayload.logError("3.1 Payload not used");
                    return;
                }
                jWebHookPayload.logActivity("open boards with items : " + String.join((CharSequence)",", sessionBoardIds));
                if (relation == null) {
                    relation = this.anyParentChildLink(jWebHookPayload, epicLinkField, syncUtil.epicLinkField, debugMode);
                }
                jWebHookPayload.cid = this.companyRepository.findByTenant(almAccount.getTenant()).getId();
                boolean epicLinkChangeEvent = Boolean.TRUE.equals(jWebHookPayload.epicLinkChangeEvent);
                boolean parentLinkChangeEvent = Boolean.TRUE.equals(jWebHookPayload.parentLinkChangeEvent);
                JiraItem epicChangeLog = jWebHookPayload.epicChangeLog;
                JiraItem parentLinkChangeLog = jWebHookPayload.parentLinkChangeLog;
                List items = new ArrayList();
                boolean issueLinkEventDeleted = false;
                boolean issueLinkEventCreated = false;
                boolean issueDeletedEvent = false;
                boolean issueUpdatedEvent = false;
                Map almFields = this.getAlmFields(sprintField, epicLinkField, jWebHookPayload.getIssue(), almAccount);
                if (!PropertyValidator.isValid(almFields.get("Story Points")) || !PropertyValidator.isValid(almFields.get("duedate"))) {
                    try {
                        this.jiraWebhookRepository.delete((Serializable)((Object)unMappedDataId));
                        jWebHookPayload.logActivity("4. Story point and/or due date fields not found, removing payload.2");
                    }
                    catch (Exception e) {
                        LOGGER.warn("SP and/or duedate not set error. ", (Throwable)e);
                        jWebHookPayload.logError("[skipped] Story point and/or due date not set error.");
                    }
                    return;
                }
                jWebHookPayload.logActivity("STORY_POINT_AND_DUE_DATE_FIELD_FOUND");
                if (PropertyValidator.isValid(sessionBoardIds)) {
                    ArrayList<String> jiraIds;
                    JiraIssueLinkPayload issueLinkPayload;
                    if ("issuelink_created".equals(jWebHookPayload.getWebhookEvent())) {
                        jWebHookPayload.logActivity("6. finding items for issuelink_created case processing");
                        issueLinkPayload = jWebHookPayload.getIssueLink();
                        issueLinkEventCreated = true;
                        jiraIds = new ArrayList<String>();
                        jiraIds.add(issueLinkPayload.getSourceIssueId());
                        jiraIds.add(issueLinkPayload.getDestinationIssueId());
                        items.addAll(this.itemRepository.findItemByJiraIdInAndSessionBoardsIdInAndTenantAndArchive(jiraIds, sessionBoardIds, almAccount.getTenant(), false));
                    } else if ("issuelink_deleted".equals(jWebHookPayload.getWebhookEvent())) {
                        jWebHookPayload.logActivity("7. finding items for issuelink_deleted case processing");
                        issueLinkPayload = jWebHookPayload.getIssueLink();
                        issueLinkEventDeleted = true;
                        jiraIds = new ArrayList();
                        jiraIds.add(issueLinkPayload.getSourceIssueId());
                        jiraIds.add(issueLinkPayload.getDestinationIssueId());
                        items.addAll(this.itemRepository.findItemByJiraIdInAndSessionBoardsIdInAndTenantAndArchive(jiraIds, sessionBoardIds, almAccount.getTenant(), false));
                    } else if ("jira:issue_deleted".equals(jWebHookPayload.getWebhookEvent())) {
                        jWebHookPayload.logActivity("8. finding items for issue_deleted case processing");
                        issueDeletedEvent = true;
                        items = this.itemRepository.findByJiraIdAndSessionBoardsIdInAndTenantAndArchive(jWebHookPayload.getIssue().getId(), sessionBoardIds, almAccount.getTenant(), false);
                    } else if ("jira:issue_updated".equals(jWebHookPayload.getWebhookEvent())) {
                        jWebHookPayload.logActivity("9. finding items for issue_updated case processing");
                        issueUpdatedEvent = true;
                    }
                } else {
                    jWebHookPayload.logActivity("No session boards found linked with Alm Account.");
                }
                Boolean updateParentItem = Boolean.TRUE;
                boolean epicLinked = false;
                boolean handleParentLink = true;
                if (epicLinkChangeEvent) {
                    jWebHookPayload.logActivity("11. found epicLinkChange Event, beginning processing.");
                    epicChildsLinkType.setName(almAccount.getJiraEpicLinkLabel());
                    epicChildsLinkType.setInward(almAccount.getJiraEpicLinkLabel());
                    epicChildsLinkType.setOutward(almAccount.getJiraEpicLinkLabel());
                    epicLinked = this.handleEpicLink(epicChangeLog, jWebHookPayload, almAccount, almFields, almConfigsMap, sprintField, sessionBoardIds, almAccount.getJiraEpicLinkLabel(), epicChildsLinkType);
                    jWebHookPayload.logActivity("12. epicLinkChange Event completed");
                }
                if (parentLinkChangeEvent) {
                    JiraIssueLinkType linkType = new JiraIssueLinkType(parentLinkChangeLog.getFieldId(), null, null, null, null, null);
                    jWebHookPayload.logActivity("13. parentLinkChange Event, parent Log: " + parentLinkChangeLog.toString() + ", linktype log: " + linkType.toString());
                    parentLinkChangeLog.setTo((Object)parentLinkChangeLog.getToString());
                    parentLinkChangeLog.setFrom((Object)parentLinkChangeLog.getFromString());
                    if (PropertyValidator.isValid((Object)parentLinkChangeLog.getToString()) && PropertyValidator.isValid((Object)parentLinkChangeLog.getFromString()) && parentLinkChangeLog.getToString().equals(parentLinkChangeLog.getFromString())) {
                        handleParentLink = false;
                    }
                    if (handleParentLink) {
                        jWebHookPayload.logActivity("parentLinkChange event found, beginning processing.");
                        epicLinked = this.handleEpicLink(parentLinkChangeLog, jWebHookPayload, almAccount, almFields, almConfigsMap, sprintField, sessionBoardIds, "Parent LINK", linkType);
                        jWebHookPayload.logActivity("14. parentLinkChange Event completed");
                    }
                }
                if (!epicLinked && (epicLinkChangeEvent || parentLinkChangeEvent && handleParentLink)) {
                    jWebHookPayload.logError("[skipped] No Epic Link or Parent Link found");
                }
                jWebHookPayload.issuesMap = new HashMap();
                if (issueUpdatedEvent) {
                    jWebHookPayload.putIssue(jWebHookPayload.getIssue());
                    jWebHookPayload.logActivity("15. finding items to settle issue_updated event");
                    items = this.itemRepository.findByJiraIdAndSessionBoardsIdInAndTenantAndArchive(jWebHookPayload.getIssue().getId(), sessionBoardIds, almAccount.getTenant(), false);
                } else if (issueLinkEventCreated) {
                    // empty if block
                }
                Double sysSequence = (Double)almFields.get("sequence");
                if (PropertyValidator.isValid(items)) {
                    jWebHookPayload.logActivity("16. found [" + items.size() + "] items to settle issue_updated event");
                    HashMap<String, Boolean> jiraDepedenciesFetched = new HashMap<String, Boolean>();
                    HashSet<String> itemSavedCount = new HashSet<String>();
                    for (Item item : items) {
                        JiraIssueLinkPayload link;
                        AlmAccount taggedAlmAccount;
                        boolean saved = false;
                        jWebHookPayload.logActivity("16.1. checking for Item : [" + item.getJiraKey() + "] " + item.getId());
                        if (PropertyValidator.isValid((Object)item.getFetchedBy()) && PropertyValidator.isValid((Object)(taggedAlmAccount = JiraUtils.getTaggedAlmUser((User)item.getFetchedBy(), (AlmAccount)almAccount)))) {
                            almAccount = taggedAlmAccount;
                        }
                        if (jWebHookPayload.getUser() != null) {
                            item.setWebHookActivityBy(jWebHookPayload.getUser().getDisplayName());
                        }
                        sysSequence = sysSequence + 1000.0;
                        SessionBoard board = (SessionBoard)item.getSessionBoards().get(0);
                        String boardID = board.getId();
                        int featrueParentFlag = -1;
                        if (jWebHookPayload.getIssue() != null && jWebHookPayload.getIssue().getFields() != null) {
                            HashMap newValueFields = jWebHookPayload.getIssue().getFields();
                            this.scoreCardService.updateScorecardFieldsAccordingToMappedFields(((SessionBoard)item.getSessionBoards().get(0)).getSession(), item, (Map)newValueFields);
                        }
                        if (issueLinkEventCreated) {
                            int flag;
                            jWebHookPayload.logActivity("17. found issuelinkcreated Event");
                            boolean handleJiraDependency = false;
                            if (board.getSession().getJiraDependencyEnabled().booleanValue()) {
                                for (String linkType : board.getSession().getJiraLinkTypes()) {
                                    if (!linkType.contains(jWebHookPayload.getIssueLink().getIssueLinkType().getId())) continue;
                                    handleJiraDependency = true;
                                    break;
                                }
                            }
                            if (handleJiraDependency) {
                                jWebHookPayload.logActivity("18. handle jira dependencies condition matched");
                                if (!Boolean.TRUE.equals(jiraDepedenciesFetched.get(boardID))) {
                                    jWebHookPayload.logActivity("JIRA_DEPENDENCIES_NOT_FETCHED_AGAINST_BOARD_ID");
                                    ArrayList<String> jiraIds = new ArrayList<String>();
                                    Object issues = null;
                                    new HashSet();
                                    for (Item it : items) {
                                        jiraIds.add(it.getJiraId());
                                    }
                                    if (PropertyValidator.isValid(jiraIds)) {
                                        jiraDepedenciesFetched.put(boardID, true);
                                        this.addJiraLine(jWebHookPayload, almAccount.getId(), board, webhookJiraIds);
                                    }
                                }
                            } else {
                                jWebHookPayload.logActivity("20. Processing link creation event");
                                saved = this.handleLinkCreation(item, jWebHookPayload, almAccount, almFields, almConfigsMap, sprintField, sequence);
                            }
                            if (Boolean.TRUE.equals(board.getSession().getJiraFeatureParentEnabled()) && Item.Type.Feature.name().equals(item.getType()) && (link = jWebHookPayload.getIssueLink()) != null && link.getIssueLinkType() != null && (flag = this.applyParentOfParentFromIssueLink(jWebHookPayload, item, board.getSession(), syncUtil)) != 0) {
                                featrueParentFlag = 1;
                            }
                        } else if (issueLinkEventDeleted) {
                            Map parent;
                            jWebHookPayload.logActivity("52. issueLinkEventDeleted found true");
                            boolean handleJiraDependency = false;
                            if (board.getSession().getJiraDependencyEnabled().booleanValue()) {
                                link = board.getSession().getJiraLinkTypes().iterator();
                                while (link.hasNext()) {
                                    String linkType = (String)link.next();
                                    if (!linkType.contains(jWebHookPayload.getIssueLink().getIssueLinkType().getId())) continue;
                                    handleJiraDependency = true;
                                    if (handleJiraDepToCheckItemChanged) break;
                                    handleJiraDepToCheckItemChanged = true;
                                    break;
                                }
                            }
                            if (Boolean.TRUE.equals(board.getSession().getJiraFeatureParentEnabled()) && Item.Type.Feature.name().equals(item.getType()) && (link = jWebHookPayload.getIssueLink()) != null && item.getJiraFieldByKey() != null && (parent = (Map)item.getJiraFieldByKey().get(JiraField.FIXED.parent.toString())) != null) {
                                String pid = (String)parent.get("id");
                                if (item.getJiraId().equals(link.getSourceIssueId()) && link.getDestinationIssueId().equals(pid)) {
                                    item.putFeatureParent(null);
                                    featrueParentFlag = 1;
                                } else if (item.getJiraId().equals(link.getDestinationIssueId()) && link.getSourceIssueId().equals(pid)) {
                                    item.putFeatureParent(null);
                                    featrueParentFlag = 1;
                                }
                            }
                            if (handleJiraDependency) {
                                jWebHookPayload.logActivity("53. identify handleJiraDependency");
                                List itemJiraDependencies = this.itemJiraDependencyRepository.findByJiraDependencyIdAndSessionBoardId(String.valueOf(jWebHookPayload.getIssueLink().getId()), boardID);
                                if (PropertyValidator.isValid((Collection)item.getJiraDependencies()) && PropertyValidator.isValid((Collection)itemJiraDependencies)) {
                                    item.getJiraDependencies().removeIf(itemJiraDependencies::contains);
                                }
                                ArrayList<Object> parentItems = new ArrayList<Object>();
                                parentItems.add(this.itemRepository.save((Object)item));
                                saved = true;
                                if (featrueParentFlag == 1) {
                                    featrueParentFlag = 2;
                                }
                                jWebHookPayload.logActivity("COMPLETED_PROCESSING_FOR_ITEM_JIRA_DEPENDENCY_LINK_DELETION");
                                JSONObject pushJson = new JSONObject();
                                ObjectMapper mapper = new ObjectMapper();
                                String itemsStr = null;
                                String jiraDepIdsStr = null;
                                ArrayList jiraDependencyIdsList = new ArrayList();
                                if (PropertyValidator.isValid((Collection)itemJiraDependencies)) {
                                    jWebHookPayload.logActivity("HANDLING_ITEM_LINK_DEPENDENCIES_FOR_JIRA_ITEM");
                                    itemJiraDependencies.forEach(dep -> jiraDependencyIdsList.add(dep.getJiraDependencyId()));
                                    jiraDepIdsStr = String.join((CharSequence)",", jiraDependencyIdsList);
                                    List itemLinks = this.itemLinkRepository.findByAlmLinkIdIn(jiraDependencyIdsList);
                                    if (PropertyValidator.isValid((Collection)itemLinks)) {
                                        jWebHookPayload.logActivity("ITEM_LINKS_FOUND_TO_BE_PROCESSED_WITH_JIRA_DEPENDENCY_LIST");
                                        for (ItemLink link2 : itemLinks) {
                                            if (!PropertyValidator.isValid((Object)link2.getAlmLinkId())) continue;
                                            link2.setAlmLinkId(null);
                                        }
                                        this.itemLinkRepository.save((Iterable)itemLinks);
                                        jWebHookPayload.logActivity("54. itemLinks saved");
                                    }
                                }
                                if (PropertyValidator.isValid(parentItems)) {
                                    try {
                                        itemsStr = mapper.writeValueAsString(parentItems);
                                        pushJson.put("isJira", true);
                                        pushJson.put("type", (Object)"Feature");
                                        pushJson.put("items", (Object)itemsStr);
                                        pushJson.put("push", (Object)"Self");
                                        pushJson.put("jiraIds", (Object)jiraDepIdsStr);
                                        pushJson.put("metaMap", (Object)("{\"event\":\"DeleteJiraDependency\", \"isJira\":true, \"boardId\":\"" + boardID + "\"}"));
                                        this.pushWebhook(jWebHookPayload.cid, pushJson.toString());
                                    }
                                    catch (JSONException e) {
                                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                                    }
                                    catch (JsonProcessingException e) {
                                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                                    }
                                }
                            } else {
                                jWebHookPayload.logActivity("55. Going to handle link deletion case");
                                saved = this.handleLinkDeletion(item, jWebHookPayload, almAccount, almFields, almConfigsMap, sprintField, sequence);
                                jWebHookPayload.logActivity("56. Link deletion event processing completed.");
                            }
                        } else if (issueDeletedEvent) {
                            Object tc2;
                            jWebHookPayload.logActivity("57. issueDeletedEvent found true");
                            item.setSource(1);
                            item.setArchive(true);
                            List itemLinks = null;
                            if (Item.FEATURE.equalsIgnoreCase(item.getType())) {
                                jWebHookPayload.logActivity("58. Arhciving item as feature");
                                this.customRepository.setBulkArchiveUserStoriesByParent(item, true);
                                ArrayList<String> tcIds = new ArrayList<String>();
                                if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                                    for (Object tc2 : item.getTeamContainers()) {
                                        tcIds.add(tc2.getId());
                                    }
                                    itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcIds, tcIds);
                                    if (PropertyValidator.isValid((Collection)itemLinks)) {
                                        KendisUtils.archiveItemLinks((ItemLinkRepository)this.itemLinkRepository, (List)itemLinks);
                                        List itemsNeedToUpdated = this.itemRepository.findByItemLinksIn(itemLinks);
                                        if (PropertyValidator.isValid((Collection)itemsNeedToUpdated)) {
                                            tc2 = itemsNeedToUpdated.iterator();
                                            while (tc2.hasNext()) {
                                                Item item2 = (Item)tc2.next();
                                                item2.getItemLinks().removeAll(itemLinks);
                                            }
                                            this.itemRepository.save((Iterable)itemsNeedToUpdated);
                                            jWebHookPayload.logActivity("Successfully updated items.");
                                        }
                                    }
                                }
                            } else {
                                jWebHookPayload.logActivity("59. Arhciving item as Userstory");
                                List childItems = this.itemRepository.findByParentId(item.getParent().getId());
                                Double totalEstimate = 0.0;
                                tc2 = childItems.iterator();
                                while (tc2.hasNext()) {
                                    Item childItem = (Item)tc2.next();
                                    totalEstimate = totalEstimate + childItem.getStoryPoints();
                                }
                                this.customRepository.updateItemStoryPoints(item.getParent().getId(), totalEstimate);
                            }
                            jWebHookPayload.logActivity("Finding item links using user story or source user story id.");
                            itemLinks = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId(item.getId(), item.getId());
                            if (PropertyValidator.isValid((Collection)itemLinks)) {
                                jWebHookPayload.logActivity("Item links found.");
                                List linkedItems = this.itemRepository.findByItemLinksIn(itemLinks);
                                if (PropertyValidator.isValid((Collection)linkedItems)) {
                                    for (Item linkedItem : linkedItems) {
                                        linkedItem.getItemLinks().removeAll(itemLinks);
                                    }
                                    this.itemRepository.save((Iterable)linkedItems);
                                    jWebHookPayload.logActivity("Successfully saved linked items.");
                                }
                            } else {
                                jWebHookPayload.logActivity("Item links not found.");
                            }
                            savedItem = (Item)this.itemRepository.save((Object)item);
                            saved = true;
                            jWebHookPayload.logActivity("Item saved.");
                            this.pushWebhook(jWebHookPayload.cid, AlmErrorUtils.buildAlmPushJson((Item)item, (String)boardID, (String)"WebhookDelete", (String)"Item has been deleted in JIRA", (Boolean)false, (Boolean)true));
                        } else if (issueUpdatedEvent) {
                            jWebHookPayload.logActivity("60. Issue update event processing started.");
                            saved = this.handleUpdateEvent(item, savedItem, jWebHookPayload, almFields, almAccount, sessions, almConfigsMap, syncUtil, updateParentItem);
                            jWebHookPayload.logActivity("61. Issue Update Event Completed");
                        }
                        mappedBucketTypes.remove(boardID);
                        if (featrueParentFlag > -1 && featrueParentFlag < 2 && item.getJiraFieldByKey() != null) {
                            this.customRepositoryImpl.updateFeauteParent(item.getId(), item.getJiraFieldByKey().get(JiraField.FIXED.parent.name()));
                            this.pushWebhook(jWebHookPayload.cid, AlmErrorUtils.buildAlmPushJson((Item)item, (String)boardID, (String)"Update", null, (Boolean)false, (Boolean)true));
                            saved = true;
                        }
                        if (saved) {
                            itemSavedCount.add(boardID);
                            continue;
                        }
                        jWebHookPayload.logActivity("16.1. not saved for Item : [" + item.getJiraKey() + "] " + item.getId());
                    }
                    if (itemSavedCount.size() < sessionBoardIds.size()) {
                        jWebHookPayload.logError("items saved in Boards : " + String.join((CharSequence)",", itemSavedCount));
                    }
                } else {
                    jWebHookPayload.logError("Could not find items to settle event");
                }
                if (!mappedBucketTypes.isEmpty()) {
                    jWebHookPayload.logActivity("trying to create new child in buckets in boards from jira issue.");
                    List buckets = this.itemRepository.findByIssueTypeIdInAndSessionBoardsInAndTenantAndArchive(mappedBucketTypes.values(), mappedBucketTypes.keySet(), almAccount.getTenant(), false);
                    for (Item item : buckets) {
                        JiraIssue2 issue = jWebHookPayload.getIssue();
                        Map status = (Map)issue.getFields().get(JiraField.FIXED.status.name());
                        issue.getFields().put(JiraField.FIXED.status.name(), null);
                        Item newChild = this.createNewChildFromJiraIssue(null, item, issue, almFields, almConfigsMap, sprintField, almAccount, jWebHookPayload.logs);
                        issue.getFields().put(JiraField.FIXED.status.name(), status);
                        if (PropertyValidator.isValid((Collection)newChild.getTeamContainers())) {
                            List dupilcate = this.customRepositoryImpl.findItemTTL(issue.getId() + "_" + ((SessionBoard)newChild.getSessionBoards().get(0)).getId());
                            if (PropertyValidator.isValid((Collection)dupilcate)) continue;
                            newChild.setWebhookSequence(sequence);
                            newChild.setStatus(this.getKendisStatus(issue, Item.Type.UserStory.name(), newChild));
                            newChild = (Item)this.itemRepository.save((Object)newChild);
                            this.markNewItem(issue.getId(), jWebHookPayload, newChild);
                            this.pushWebhook(jWebHookPayload.cid, AlmErrorUtils.buildAlmPushJson((Item)newChild, (String)((SessionBoard)newChild.getSessionBoards().get(0)).getId(), (String)"Update", null, (Boolean)false, (Boolean)true));
                            continue;
                        }
                        jWebHookPayload.logActivity("[skipped] jira issue skipped because bucket criteria not matched");
                    }
                }
                try {
                    WebhookActivityUtil.getInstance().reset();
                }
                catch (Exception exception) {
                    jWebHookPayload.logError("Exception occurred while checking jira item changed: ");
                    jWebHookPayload.logError(StringUtils.getTraceString((Throwable)exception));
                }
                if (PropertyValidator.isValid((Object)jWebHookPayload.newItems)) {
                    this.fixNewEmptyItems(jWebHookPayload, almFields, almConfigsMap, sprintField, almAccount);
                }
            }
            if (unMappedDataId != null) {
                try {
                    this.jiraWebhookRepository.delete((Serializable)((Object)unMappedDataId));
                }
                catch (Exception e) {
                    LOGGER.warn("Multiple instance sync issue ", (Throwable)e);
                }
            } else if (keyForDel != null) {
                try {
                    this.s3util.deleteKey(keyForDel);
                }
                catch (Exception e) {
                    LOGGER.warn("updateJiraWebhookItem --> Failed to delete file from s3 ");
                }
            }
        }
        catch (Exception e) {
            String ex = "FAILED to apply changes from jira Webhook: for ALM Id: " + accId + " stack trace: " + StringUtils.getTraceString((Throwable)e);
            LOGGER.error(ex);
            jWebHookPayload.logError(ex);
        }
    }

    private void fixNewEmptyItems(JiraWebhookPayload payload, Map<String, Object> fields, Map<String, AlmConfigurations> almConfigs, JiraField sprintField, AlmAccount almAccount) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private void addJiraLine(JiraWebhookPayload payload, String almId, SessionBoard board, List<String> jiraIds) {
        new Thread(() -> {
            ArrayList<String> logs = new ArrayList<String>();
            logs.add("\n-------------------addJiraLine-------------------");
            logs.add("USING_JIRA_IDS_FROM_ITEMS_TO_PROCESS_ITEMS");
            List parentItems = this.almSyncService.retrieveAndSaveJiraDependencies(jiraIds, null, board, null, "ADD", logs);
            JSONObject pushJson = new JSONObject();
            ObjectMapper mapper = new ObjectMapper();
            String itemsStr = null;
            if (PropertyValidator.isValid((Collection)parentItems)) {
                logs.add("19. found items to settle jira dependencies");
                try {
                    itemsStr = mapper.writeValueAsString((Object)parentItems);
                    pushJson.put("isJira", true);
                    pushJson.put("type", (Object)"Feature");
                    pushJson.put("items", (Object)itemsStr);
                    pushJson.put("push", (Object)"Self");
                    pushJson.put("metaMap", (Object)("{\"event\":\"AddJiraDependency\", \"isJira\":true, \"boardId\":\"" + board.getId() + "\"}"));
                    PushSender.sendMsg((String)payload.cid, (String)pushJson.toString());
                }
                catch (JSONException e) {
                    payload.logError(StringUtils.getTraceString((Throwable)e));
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                catch (JsonProcessingException e) {
                    payload.logError(StringUtils.getTraceString((Throwable)e));
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            logs.add("\n------------------- ------------------- -------------------\n");
            this.printLogs(almId, logs);
        }).start();
    }

    private void onChangeJiraSprint(SessionBoard board, Item us, HashMap<String, Object> jiraIssueFields, Map<String, AlmConfigurations> almConfigs, String jiraSprintId, List<String> logs) {
        block8: {
            try {
                Item parentItem = us.getParent();
                if (PropertyValidator.isValid((Object)parentItem)) {
                    if (logs != null) {
                        logs.add("CHANGING_SPRINT_FOR_ITEM");
                    }
                    List subItemExistingTCs = null;
                    KendisUtils.addChanges((boolean)false, (boolean)true, (Item)parentItem, (Item)parentItem);
                    subItemExistingTCs = us.getTeamContainers();
                    if (PropertyValidator.isValid((Collection)subItemExistingTCs)) {
                        subItemExistingTCs.removeIf(v -> !PropertyValidator.isValid((Object)v));
                        if (PropertyValidator.isValid((Collection)subItemExistingTCs)) {
                            us.setTeamContainers(subItemExistingTCs);
                        }
                    }
                    if (!PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                        parentItem.setTeamContainers(new ArrayList());
                    }
                    ResyncParamsVO syncUtils = new ResyncParamsVO();
                    syncUtils.sessionBoardId = board.getId();
                    syncUtils.session = board.getSession();
                    syncUtils.almConfigurations = this.getConfigById(board.getSession(), almConfigs);
                    this.customRepositoryImpl.parseSyncMapperBySprintId(syncUtils);
                    boolean parentUpdated = JiraUtils.addjustChildTC((Boolean)false, (Item)us, (Item)parentItem, (ResyncParamsVO)syncUtils, (List)subItemExistingTCs, (TeamContainerRepository)this.teamContainerRepository, (ItemRepository)this.itemRepository, null, jiraIssueFields, (String)jiraSprintId, logs);
                    if (parentUpdated) {
                        ArrayList<Item> parentItems = new ArrayList<Item>();
                        parentItems.add(parentItem);
                        this.customRepositoryImpl.bulkLogs(board.getId(), parentItems, null, null, board.getTenant());
                    }
                }
            }
            catch (Exception e) {
                String ex = "FAILED to apply changes from jira Webhook...onChangeJiraSprint : " + StringUtils.getTraceString((Throwable)e);
                LOGGER.error(ex);
                if (logs == null) break block8;
                logs.add(ex);
            }
        }
    }

    private boolean handleLinkCreation(Item item, JiraWebhookPayload jWebHookPayload, AlmAccount almAccount, Map<String, Object> fields, Map<String, AlmConfigurations> almConfigs, JiraField sprintField, Long linkSequence) {
        boolean saved = false;
        jWebHookPayload.logActivity("21. link creation event handler");
        if (Item.FEATURE.equals(item.getType())) {
            jWebHookPayload.logActivity("22. link creation event handler for feature");
            JiraIssueLinkPayload link = jWebHookPayload.getIssueLink();
            String destinationJiraId = null;
            if (PropertyValidator.isValid((Collection)item.getLinkTypes()) && !PropertyValidator.isValid((Object)item.getJiraFilter())) {
                destinationJiraId = this.getDestinationJiraId(item.getLinkTypes(), link, item, jWebHookPayload, almAccount);
                jWebHookPayload.logActivity("23. link creation event handler for feature target Id : " + destinationJiraId);
            } else {
                AlmConfigurations almConfig = this.getConfigById(item, almConfigs);
                jWebHookPayload.logActivity("GETTING_ALM_CONFIG_FROM_ITEM");
                if (PropertyValidator.isValid((Object)item.getJiraFilter())) {
                    Object filter;
                    jWebHookPayload.logActivity("JIRA_FILTER_EXISTS_FOR_ITEM");
                    if (PropertyValidator.isValid((Collection)almConfig.getFeatureFilter()) && PropertyValidator.isValid((Collection)(filter = (JiraFilter)almConfig.getFeatureFilter().stream().filter(r -> r.getId().equals(item.getJiraFilter())).findFirst().orElse(null)).getFeatureLinkMappings())) {
                        jWebHookPayload.logActivity("FEATURE_LINK_MAPPINGS_FOUND_FROM_FILTER");
                        for (BacklogMappingLinks linksMapping : filter.getFeatureLinkMappings()) {
                            if (!item.getJiraProjectKey().equals(linksMapping.getProjectKey())) continue;
                            jWebHookPayload.logActivity("ITEM_PROJECT_KEY_MATCHES_LINK_MAPPING_PROJECT_KEY");
                            if (!PropertyValidator.isValid((Collection)linksMapping.getLinkTypes())) continue;
                            jWebHookPayload.logActivity("LINK_TYPES_FOUND_FROM_LINK_MAPPINGS");
                            destinationJiraId = this.getDestinationJiraId(linksMapping.getLinkTypes(), link, item, jWebHookPayload, almAccount);
                            if (null == destinationJiraId) continue;
                            jWebHookPayload.logActivity("24. link creation event handler for feature target Id : " + destinationJiraId);
                            break;
                        }
                    }
                } else if (PropertyValidator.isValid((Collection)almConfig.getFeatureLinkMappings())) {
                    jWebHookPayload.logActivity("FEATURE_FILTER_MAPPINGS_FROUND_FROM_ALM_CONFIG");
                    for (BacklogMappingLinks linksMapping : almConfig.getFeatureLinkMappings()) {
                        if (!item.getJiraProjectKey().equals(linksMapping.getProjectKey())) continue;
                        jWebHookPayload.logActivity("ITEM_PROJECT_KEY_MATCHES_LINK_MAPPING_PROJECT_KEY");
                        if (!PropertyValidator.isValid((Collection)linksMapping.getLinkTypes())) continue;
                        jWebHookPayload.logActivity("LINK_TYPES_FOUND_FROM_LINK_MAPPINGS");
                        destinationJiraId = this.getDestinationJiraId(linksMapping.getLinkTypes(), link, item, jWebHookPayload, almAccount);
                        if (null == destinationJiraId) continue;
                        jWebHookPayload.logActivity("25. link creation event handler for feature target Id : " + destinationJiraId);
                        break;
                    }
                }
            }
            jWebHookPayload.logActivity("26. check whether this item exists already on the same board with some other parent");
            List existingItems = this.itemRepository.findByJiraIdAndSessionBoardsInAndTenantAndArchive(destinationJiraId, item.getSessionBoards(), item.getTenant(), false);
            if (PropertyValidator.isValid((Collection)existingItems)) {
                jWebHookPayload.logActivity("27. Item found with other parent on same board");
                for (Item existingItem : existingItems) {
                    if (jWebHookPayload.getTimestamp() == null || !"jira_gh_epic_story".equals(jWebHookPayload.getIssueLink().getIssueLinkType().getStyle())) continue;
                    existingItem.setJiraWebhookTimeStamp(Long.valueOf(Long.parseLong(jWebHookPayload.getTimestamp())));
                    this.itemRepository.save((Object)existingItem);
                    saved = true;
                    jWebHookPayload.logActivity("Item: " + existingItem.getJiraKey() + " already exists on board, persisting its Jira Webhook Timestamp");
                }
                jWebHookPayload.logActivity("28. Item settled with other parent case");
            } else {
                jWebHookPayload.logActivity("29. Going to deal with destination id");
                if (PropertyValidator.isValid((Object)destinationJiraId)) {
                    JiraIssue2 jIssue = this.getIssue(destinationJiraId, jWebHookPayload, almAccount);
                    if (jWebHookPayload.newItems == null) {
                        jWebHookPayload.newItems = new ArrayMap();
                    }
                    Item newChild = this.createNewChildFromJiraIssue(null, item, jIssue, fields, almConfigs, sprintField, almAccount, jWebHookPayload.logs);
                    List dupilcate = this.customRepositoryImpl.findItemTTL(jIssue.getId() + "_" + ((SessionBoard)newChild.getSessionBoards().get(0)).getId());
                    if (!PropertyValidator.isValid((Collection)dupilcate)) {
                        newChild.setWebhookSequence(linkSequence);
                        newChild = (Item)this.itemRepository.save((Object)newChild);
                        saved = true;
                        this.markNewItem(jIssue.getId(), jWebHookPayload, newChild);
                        jWebHookPayload.logActivity("31. save new child  with just ID, fetching will be done in thread.");
                    }
                }
            }
        }
        return saved;
    }

    private boolean handleEpicLink(JiraItem epicChangeLog, JiraWebhookPayload jWebHookPayload, AlmAccount almAccount, Map<String, Object> fields, Map<String, AlmConfigurations> almConfigs, JiraField sprintField, List<String> sessionBoards, String linkType, JiraIssueLinkType issueLinkType) {
        Object filter;
        boolean saved = false;
        jWebHookPayload.logActivity("32. Inside handle epic link");
        ArrayList<String> jiraIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)epicChangeLog.getTo())) {
            jiraIds.add((String)epicChangeLog.getTo());
        }
        HashSet<String> parentIdsForEmptyCards = new HashSet<String>();
        List epicItems = this.itemRepository.findByJiraIdInAndSessionBoardsIdInAndTenantAndArchiveAndType(jiraIds, sessionBoards, almAccount.getTenant(), false, Item.FEATURE);
        jWebHookPayload.logActivity("33. " + (PropertyValidator.isValid((Collection)epicItems) ? "found " + epicItems.size() + "epic items." : "No epic items found."));
        if (PropertyValidator.isValid((Collection)epicItems)) {
            jWebHookPayload.logActivity("34. Going to indentify should process link flag for each epic");
            HashMap itemsForLogs = new HashMap();
            for (Object item : epicItems) {
                Item epicChild;
                Object linksMapping;
                boolean processEpicLnk;
                jWebHookPayload.logActivity("35. Checking for Epic : " + item.getJiraKey());
                if (PropertyValidator.isValid((Object)epicChangeLog.getTo()) && item.getJiraId().equals((String)epicChangeLog.getTo())) {
                    jWebHookPayload.logActivity("35.1. item jira id matched with epic change log 'to' value");
                    processEpicLnk = false;
                    jWebHookPayload.logActivity("Checking if item link should be processed.");
                    if (PropertyValidator.isValid((Collection)item.getLinkTypes()) && !PropertyValidator.isValid((Object)item.getJiraFilter())) {
                        processEpicLnk = this.shouldProcessLink(item.getLinkTypes(), issueLinkType, linkType, almAccount);
                    } else {
                        AlmConfigurations almConfig = this.getConfigById((Item)item, almConfigs);
                        if (PropertyValidator.isValid((Object)item.getJiraFilter())) {
                            if (PropertyValidator.isValid((Collection)almConfig.getFeatureFilter()) && PropertyValidator.isValid((Collection)(filter = (JiraFilter)almConfig.getFeatureFilter().stream().filter(arg_0 -> WebHookSyncServiceImpl.lambda$handleEpicLink$4((Item)item, arg_0)).findFirst().orElse(null)).getFeatureLinkMappings())) {
                                for (BacklogMappingLinks linksMapping2 : filter.getFeatureLinkMappings()) {
                                    if (!item.getJiraProjectKey().equals(linksMapping2.getProjectKey()) || !PropertyValidator.isValid((Collection)linksMapping2.getLinkTypes()) || !(processEpicLnk = this.shouldProcessLink(linksMapping2.getLinkTypes(), issueLinkType, linkType, almAccount))) continue;
                                    break;
                                }
                            }
                        } else if (PropertyValidator.isValid((Collection)almConfig.getFeatureLinkMappings())) {
                            filter = almConfig.getFeatureLinkMappings().iterator();
                            while (filter.hasNext()) {
                                linksMapping = (BacklogMappingLinks)filter.next();
                                if (!item.getJiraProjectKey().equals(linksMapping.getProjectKey()) || !PropertyValidator.isValid((Collection)linksMapping.getLinkTypes()) || !(processEpicLnk = this.shouldProcessLink(linksMapping.getLinkTypes(), issueLinkType, linkType, almAccount))) continue;
                                break;
                            }
                        }
                    }
                    jWebHookPayload.logActivity("36. processEpicLnk for Epic : " + (processEpicLnk ? "should be processed." : "should not be processed"));
                    boolean createNewItem = true;
                    List existingItems = this.itemRepository.findByJiraIdAndSessionBoardsInAndTenantAndArchive(jWebHookPayload.getIssue().getId(), item.getSessionBoards(), item.getTenant(), false);
                    if (PropertyValidator.isValid((Collection)existingItems)) {
                        jWebHookPayload.logActivity("37. check whether this item exists already on the same board with some other parent");
                        createNewItem = false;
                        for (Item existingItem : existingItems) {
                            boolean isExistingKendisParent;
                            boolean isExistingJiraParent = PropertyValidator.isValid((Object)epicChangeLog.getFrom()) && PropertyValidator.isValid((Object)existingItem.getParent()) && existingItem.getParent().getJiraId().equals((String)epicChangeLog.getFrom());
                            boolean bl = isExistingKendisParent = PropertyValidator.isValid((Object)existingItem.getParent()) && !PropertyValidator.isValid((Object)existingItem.getParent().getJiraId());
                            if (!isExistingJiraParent && !isExistingKendisParent) continue;
                            JiraIssue2 jIssue = jWebHookPayload.getIssue();
                            jWebHookPayload.logActivity("38. updatating association for Item : " + existingItem.getJiraKey());
                            String oldPID = "";
                            if (existingItem.getParent() != null) {
                                oldPID = existingItem.getParent().getId();
                            }
                            existingItem.setParent((Item)item);
                            boolean isNexusBoard = false;
                            if (item.getSessionBoards() != null && item.getSessionBoards().size() > 0 && ((SessionBoard)item.getSessionBoards().get(0)).getSession() != null && "nexus".equals(((SessionBoard)item.getSessionBoards().get(0)).getSession().getSessionType())) {
                                isNexusBoard = true;
                            }
                            if (existingItem.getType().equals(Item.USER_STORY) || isNexusBoard) {
                                jWebHookPayload.logActivity("39. onChangeJiraSprint called" + existingItem.getJiraKey());
                                this.onChangeJiraSprint((SessionBoard)item.getSessionBoards().get(0), existingItem, jIssue.getFields(), almConfigs, sprintField.getJiraId(), jWebHookPayload.logs);
                            }
                            if (jWebHookPayload.getUser() != null) {
                                existingItem.setWebHookActivityBy(jWebHookPayload.getUser().getDisplayName());
                            }
                            existingItem.setSource(1);
                            this.itemRepository.save((Object)existingItem);
                            saved = true;
                            jWebHookPayload.logActivity("40. Item Saved.");
                            createNewItem = false;
                            try {
                                this.pushWebhook(jWebHookPayload.cid, AlmErrorUtils.buildAlmPushJson((Item)existingItem, (String)((SessionBoard)existingItem.getSessionBoards().get(0)).getId(), (String)"Update", null, (Boolean)false, (Boolean)true));
                            }
                            catch (Exception ex) {
                                LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
                            }
                            LOGGER.trace("Item exists on board." + existingItems);
                            if (existingItem.storySprintChanged() || existingItem.storyTeamChanged()) {
                                parentIdsForEmptyCards.add(item.getId());
                                continue;
                            }
                            if (oldPID == null || oldPID.equals(item.getId())) continue;
                            parentIdsForEmptyCards.add(oldPID);
                        }
                    }
                    if (!Boolean.TRUE.equals(processEpicLnk) || !createNewItem) continue;
                    jWebHookPayload.logActivity("41. processEpicLnk true and createNewItem also true");
                    if (jWebHookPayload.newItems == null) {
                        jWebHookPayload.newItems = new ArrayMap();
                    }
                    Item newChild = this.createNewChildFromJiraIssue(null, (Item)item, jWebHookPayload.getIssue(), fields, almConfigs, sprintField, almAccount, jWebHookPayload.logs);
                    List dupilcate = this.customRepositoryImpl.findItemTTL(jWebHookPayload.getIssue().getId() + "_" + ((SessionBoard)newChild.getSessionBoards().get(0)).getId());
                    if (PropertyValidator.isValid((Collection)dupilcate)) continue;
                    this.itemRepository.save((Object)newChild);
                    saved = true;
                    this.markNewItem(jWebHookPayload.getIssue().getId(), jWebHookPayload, newChild);
                    jWebHookPayload.logActivity("42. Creating new child  with just ID, fetching will be done in thread.");
                    continue;
                }
                if (PropertyValidator.isValid((Object)epicChangeLog.getTo()) || !PropertyValidator.isValid((Object)epicChangeLog.getFrom()) || !item.getJiraId().equals((String)epicChangeLog.getFrom())) continue;
                jWebHookPayload.logActivity("43. item jira id matched with epic change log 'from' value");
                processEpicLnk = false;
                jWebHookPayload.logActivity("Checking if item link should be processed.");
                if (PropertyValidator.isValid((Collection)item.getLinkTypes()) && !PropertyValidator.isValid((Object)item.getJiraFilter())) {
                    processEpicLnk = this.shouldProcessLink(item.getLinkTypes(), issueLinkType, linkType, almAccount);
                } else {
                    AlmConfigurations almConfig = this.getConfigById((Item)item, almConfigs);
                    if (PropertyValidator.isValid((Object)item.getJiraFilter())) {
                        if (PropertyValidator.isValid((Collection)almConfig.getFeatureFilter()) && PropertyValidator.isValid((Collection)(filter = (JiraFilter)almConfig.getFeatureFilter().stream().filter(arg_0 -> WebHookSyncServiceImpl.lambda$handleEpicLink$5((Item)item, arg_0)).findFirst().orElse(null)).getFeatureLinkMappings())) {
                            for (BacklogMappingLinks linksMapping2 : filter.getFeatureLinkMappings()) {
                                if (!item.getJiraProjectKey().equals(linksMapping2.getProjectKey()) || !PropertyValidator.isValid((Collection)linksMapping2.getLinkTypes()) || !(processEpicLnk = this.shouldProcessLink(linksMapping2.getLinkTypes(), issueLinkType, linkType, almAccount))) continue;
                                break;
                            }
                        }
                    } else if (PropertyValidator.isValid((Collection)almConfig.getFeatureLinkMappings())) {
                        filter = almConfig.getFeatureLinkMappings().iterator();
                        while (filter.hasNext()) {
                            linksMapping = (BacklogMappingLinks)filter.next();
                            if (!item.getJiraProjectKey().equals(linksMapping.getProjectKey()) || !PropertyValidator.isValid((Collection)linksMapping.getLinkTypes()) || !(processEpicLnk = this.shouldProcessLink(linksMapping.getLinkTypes(), issueLinkType, linkType, almAccount))) continue;
                            break;
                        }
                    }
                }
                jWebHookPayload.logActivity("44. processEpicLnk for Epic : " + (processEpicLnk ? "should be processed." : "should not be processed"));
                if (!processEpicLnk || !PropertyValidator.isValid((Object)(epicChild = this.itemRepository.findByParentAndJiraIdAndTenantAndArchive((Item)item, jWebHookPayload.getIssue().getId(), item.getTenant(), false)))) continue;
                if (jWebHookPayload.getUser() != null) {
                    epicChild.setWebHookActivityBy(jWebHookPayload.getUser().getDisplayName());
                }
                epicChild.setSource(1);
                epicChild.setArchive(true);
                this.itemRepository.save((Object)epicChild);
                saved = true;
                jWebHookPayload.logActivity("45. epicChild saved.");
                this.pushWebhook(jWebHookPayload.cid, AlmErrorUtils.buildAlmPushJson((Item)epicChild, (String)((SessionBoard)epicChild.getSessionBoards().get(0)).getId(), (String)"WebhookDelete", (String)"Item has been de-linked in JIRA", (Boolean)false, (Boolean)true));
            }
            if (PropertyValidator.isValid(itemsForLogs)) {
                Set bids = itemsForLogs.keySet();
                for (String bid : bids) {
                    this.customRepositoryImpl.bulkLogs(bid, (Collection)itemsForLogs.get(bid), null, null, almAccount.getTenant());
                }
            }
        }
        if (PropertyValidator.isValid((Object)epicChangeLog.getFrom())) {
            jWebHookPayload.logActivity("46. Handle epicChangeLog 'From' case");
            2 ids = new /* Unavailable Anonymous Inner Class!! */;
            epicItems = this.itemRepository.findByJiraIdInAndSessionBoardsIdInAndTenantAndArchiveAndType((List)ids, sessionBoards, almAccount.getTenant(), false, Item.FEATURE);
            if (PropertyValidator.isValid((Collection)epicItems)) {
                jWebHookPayload.logActivity("47. Found Epics to deal 'From' case");
                for (Object item : epicItems) {
                    Item epicChild;
                    jWebHookPayload.logActivity("48. checking of Epic : " + item.getJiraKey());
                    boolean processEpicLnk = false;
                    if (PropertyValidator.isValid((Collection)item.getLinkTypes()) && !PropertyValidator.isValid((Object)item.getJiraFilter())) {
                        processEpicLnk = this.shouldProcessLink(item.getLinkTypes(), issueLinkType, linkType, almAccount);
                    } else {
                        AlmConfigurations almConfig = this.getConfigById((Item)item, almConfigs);
                        if (PropertyValidator.isValid((Object)item.getJiraFilter())) {
                            if (PropertyValidator.isValid((Collection)almConfig.getFeatureFilter()) && PropertyValidator.isValid((Collection)(filter = (JiraFilter)almConfig.getFeatureFilter().stream().filter(arg_0 -> WebHookSyncServiceImpl.lambda$handleEpicLink$6((Item)item, arg_0)).findFirst().orElse(null)).getFeatureLinkMappings())) {
                                for (BacklogMappingLinks linksMapping2 : filter.getFeatureLinkMappings()) {
                                    if (!item.getJiraProjectKey().equals(linksMapping2.getProjectKey()) || !PropertyValidator.isValid((Collection)linksMapping2.getLinkTypes()) || !(processEpicLnk = this.shouldProcessLink(linksMapping2.getLinkTypes(), issueLinkType, linkType, almAccount))) continue;
                                    break;
                                }
                            }
                        } else if (PropertyValidator.isValid((Collection)almConfig.getFeatureLinkMappings())) {
                            for (Object linksMapping : almConfig.getFeatureLinkMappings()) {
                                if (!item.getJiraProjectKey().equals(linksMapping.getProjectKey()) || !PropertyValidator.isValid((Collection)linksMapping.getLinkTypes()) || !(processEpicLnk = this.shouldProcessLink(linksMapping.getLinkTypes(), issueLinkType, linkType, almAccount))) continue;
                                break;
                            }
                        }
                    }
                    jWebHookPayload.logActivity("49. processEpicLnk flag : " + (processEpicLnk ? "should be processed." : "should not be processed"));
                    if (!processEpicLnk || !PropertyValidator.isValid((Object)(epicChild = this.itemRepository.findByParentAndJiraIdAndTenantAndArchive((Item)item, jWebHookPayload.getIssue().getId(), item.getTenant(), false)))) continue;
                    if (jWebHookPayload.getUser() != null) {
                        epicChild.setWebHookActivityBy(jWebHookPayload.getUser().getDisplayName());
                    }
                    epicChild.setSource(1);
                    epicChild.setArchive(true);
                    this.itemRepository.save((Object)epicChild);
                    saved = true;
                    jWebHookPayload.logActivity("50. Epic child saved");
                    this.pushWebhook(jWebHookPayload.cid, AlmErrorUtils.buildAlmPushJson((Item)epicChild, (String)((SessionBoard)epicChild.getSessionBoards().get(0)).getId(), (String)"WebhookDelete", (String)"Item has been de-linked in JIRA", (Boolean)false, (Boolean)true));
                }
            } else {
                jWebHookPayload.logActivity("Could not find Epics to deal 'From' case");
            }
        }
        this.pushEmptyCardsTC(parentIdsForEmptyCards, jWebHookPayload.cid, almAccount.getTenant());
        return saved;
    }

    private void pushWebhook(String cid, String data) {
        PushSender.sendMsg((String)cid, (String)data);
        LOGGER.debug("webhook data [" + cid + "] pushed");
    }

    private void pushEmptyCardsTC(Collection<String> parentIds, String cid, String tenant) {
        if (PropertyValidator.isValid(parentIds)) {
            this.customRepositoryImpl.removeEmptyCards(parentIds, cid, tenant);
        }
    }

    private boolean handleLinkDeletion(Item item, JiraWebhookPayload jWebHookPayload, AlmAccount almAccount, Map<String, Object> fields, Map<String, AlmConfigurations> almConfigs, JiraField sprintField, Long linkSequence) {
        boolean saved = false;
        LOGGER.trace("INSIDE handleLinkDeletion.");
        if (Item.USER_STORY.equals(item.getType())) {
            jWebHookPayload.logActivity("ITEM_TYPE_VERIFIED_AS_USER_STORY");
            JiraIssueLinkPayload link = jWebHookPayload.getIssueLink();
            String destinationJiraId = null;
            jWebHookPayload.logActivity("GETTING_DESTINATION_JIRA_ID_FOR_ITEM");
            if (PropertyValidator.isValid((Collection)item.getParent().getLinkTypes()) && !PropertyValidator.isValid((Object)item.getJiraFilter())) {
                jWebHookPayload.logActivity("PARENT_LINK_TYPES_AND_ITEM_JIRA_FILTER_IS_NOT_PRESENT");
                destinationJiraId = this.getDestinationJiraId(item.getParent().getLinkTypes(), link, item.getParent(), jWebHookPayload, almAccount);
            } else if (PropertyValidator.isValid((Object)item.getParent().getLinkType()) && !PropertyValidator.isValid((Object)item.getJiraFilter())) {
                jWebHookPayload.logActivity("PARENT_LINK_TYPE_AND_ITEM_JIRA_FILTER_IS_NOT_PRESENT");
                ArrayList<JiraIssueLinkType> linktypes = new ArrayList<JiraIssueLinkType>();
                linktypes.add(item.getParent().getLinkType());
                destinationJiraId = this.getDestinationJiraId(linktypes, link, item.getParent(), jWebHookPayload, almAccount);
            } else {
                jWebHookPayload.logActivity("PARENT_LINK_TYPE_IS_NOT_PRESENT_OR_JIRA_FILTER_IS_PRESENT");
                AlmConfigurations almConfig = this.getConfigById(item, almConfigs);
                if (PropertyValidator.isValid((Object)item.getParent().getJiraFilter())) {
                    JiraFilter filter;
                    jWebHookPayload.logActivity("JIRA_FILTER_EXISTS_FOR_ITEM");
                    if (PropertyValidator.isValid((Collection)almConfig.getFeatureFilter()) && PropertyValidator.isValid((Collection)(filter = (JiraFilter)almConfig.getFeatureFilter().stream().filter(r -> r.getId().equals(item.getParent().getJiraFilter())).findFirst().orElse(null)).getFeatureLinkMappings())) {
                        jWebHookPayload.logActivity("FEATURE_LINK_MAPPINGS_FOUND_FROM_FILTER");
                        for (BacklogMappingLinks linksMapping : filter.getFeatureLinkMappings()) {
                            if (!item.getParent().getJiraProjectKey().equals(linksMapping.getProjectKey())) continue;
                            jWebHookPayload.logActivity("PROJECT_KEY_FROM_LINK_MAPPING_MATCHES_JIRA_PROJECT_KEY_OF_PARENT_ITEM");
                            if (!PropertyValidator.isValid((Collection)linksMapping.getLinkTypes())) continue;
                            jWebHookPayload.logActivity("LINK_TYPES_FOUND_FROM_LINK_MAPPINGS");
                            destinationJiraId = this.getDestinationJiraId(linksMapping.getLinkTypes(), link, item.getParent(), jWebHookPayload, almAccount);
                            if (null == destinationJiraId) continue;
                            break;
                        }
                    }
                } else if (PropertyValidator.isValid((Collection)almConfig.getFeatureLinkMappings())) {
                    jWebHookPayload.logActivity("ITEM_JIRA_FILTER_NOT_PRESENT_USING_FEATURE_LINK_MAPPINGS_FROM_ALM_CONFIG");
                    for (BacklogMappingLinks linksMapping : almConfig.getFeatureLinkMappings()) {
                        if (!item.getParent().getJiraProjectKey().equals(linksMapping.getProjectKey())) continue;
                        jWebHookPayload.logActivity("PROJECT_KEY_FROM_LINK_MAPPING_MATCHES_JIRA_PROJECT_KEY_OF_PARENT_ITEM");
                        if (!PropertyValidator.isValid((Collection)linksMapping.getLinkTypes())) continue;
                        jWebHookPayload.logActivity("LINK_TYPES_FOUND_FROM_LINK_MAPPINGS");
                        destinationJiraId = this.getDestinationJiraId(linksMapping.getLinkTypes(), link, item.getParent(), jWebHookPayload, almAccount);
                        if (null == destinationJiraId) continue;
                        break;
                    }
                }
            }
            if (PropertyValidator.isValid((Object)destinationJiraId)) {
                if (link.getSystemLink().booleanValue()) {
                    jWebHookPayload.logActivity("SYSTEM_LINK_FOUND_FOR_ITEM");
                    JiraIssue2 jiraDestinationIssue = this.getIssue(destinationJiraId, jWebHookPayload, almAccount);
                    JiraField epicField = (JiraField)fields.get("epicLink");
                    jWebHookPayload.logActivity("GETTING_JIRA_DESTINATION_ISSUE_AND_EPIC_FIELD");
                    if (PropertyValidator.isValid(jiraDestinationIssue.getFields().get(epicField.getJiraId()))) {
                        jWebHookPayload.logActivity("EPIC_FIELD_JIRA_ID_EXISTS_IN_JIRA_DESTINATION_ISSUE_MAPPING");
                        String parentEpicKey = (String)jiraDestinationIssue.getFields().get(epicField.getJiraId());
                        jWebHookPayload.logActivity("GETTING_PARENT_EPIC_KEY_USING_JIRA_DESTINATION_ISSUE");
                        if (PropertyValidator.isValid((Object)parentEpicKey)) {
                            jWebHookPayload.logActivity("PARENT_EPIC_KEY_FOUND_GETTING_JIRA_PARENT_EPIC");
                            JiraIssue2 jiraParentEpic = this.getIssue(parentEpicKey, jWebHookPayload, almAccount);
                            if (link.getSourceIssueId().equals(jiraParentEpic.getId())) {
                                jWebHookPayload.logActivity("SOURCE_ISSUE_JIRA_ID_SAME_AS_PARENT_EPIC_JIRA_ID");
                                return false;
                            }
                        }
                    }
                }
                List existingItems = this.itemRepository.findByJiraIdAndSessionBoardsInAndTenantAndArchive(destinationJiraId, item.getSessionBoards(), item.getTenant(), false);
                jWebHookPayload.logActivity("FETCHED_ITEMS_USING_DESTINATION_JIRA_ID");
                if (PropertyValidator.isValid((Collection)existingItems)) {
                    jWebHookPayload.logActivity("EXISTING_ITEMS_FOUND_USING_DESTINATION_JIRA_ID");
                    ArrayList<Item> exitingItemsToBeUpdated = new ArrayList<Item>();
                    for (Item existingItem : existingItems) {
                        if (existingItem.getJiraWebhookTimeStamp() == null || existingItem.getJiraWebhookTimeStamp() - Long.parseLong(jWebHookPayload.getTimestamp()) > 1000L) {
                            existingItem.setArchive(true);
                            existingItem.setSuspendActivity(true);
                            existingItem = (Item)this.itemRepository.save((Object)existingItem);
                            saved = true;
                            jWebHookPayload.logActivity("ITEMS_PROCESSED_FOR_LINK_DELETION");
                            this.pushWebhook(jWebHookPayload.cid, AlmErrorUtils.buildAlmPushJson((Item)existingItem, (String)((SessionBoard)existingItem.getSessionBoards().get(0)).getId(), (String)"WebhookDelete", (String)"Item has been de-linked in JIRA", (Boolean)false, (Boolean)true));
                            exitingItemsToBeUpdated.add(existingItem);
                            continue;
                        }
                        jWebHookPayload.logActivity("Deletion skipped for item link with this title: " + existingItem.getJiraKey());
                    }
                    this.customRepositoryImpl.saveLogsForDeletedItems(exitingItemsToBeUpdated);
                } else {
                    jWebHookPayload.logActivity("Could not find any existing items");
                }
            } else {
                jWebHookPayload.logActivity("Could not find Jira Destination ID.");
            }
        }
        return saved;
    }

    private Status getKendisStatus(JiraIssue2 jIssue, String type, Item parent) {
        return this.getKendisStatus(jIssue, type, ((SessionBoard)parent.getSessionBoards().get(0)).getSession().getId(), parent.getTenant());
    }

    private Status getKendisStatus(JiraIssue2 jIssue, String type, String sessionId, String tenant) {
        Status status = null;
        String sid = jIssue.statusId();
        if (!PropertyValidator.isValid((Object)sid)) {
            return null;
        }
        status = this.statusRepository.findByJiraProjKeyAndItemTypeAndJiraIssueTypeIdAndJiraStatusIdAndTenantAndArchiveAndSessionId(jIssue.projectKey(), type, jIssue.issueTypeId(), sid, tenant, Boolean.valueOf(false), sessionId);
        if (status == null) {
            LOGGER.debug("getKendisStatus --> It seems we have pulled a new project. Lets go fetch statuses");
            status = new Status();
            status.setSuspendActivity(true);
            status.setJiraProjKey(jIssue.projectKey());
            status.setJiraIssueTypeId(jIssue.issueTypeId());
            status.setJiraStatusCatId(jIssue.statusCategory("id").replace(".0", ""));
            status.setJiraStatusId(jIssue.statusId());
            status.setTitle(jIssue.status());
            status.setItemType(type);
            status.setCategory(AlmUtils.getMappedStatusCategory((String)jIssue.statusCategory("key")));
            status.setSessionId(sessionId);
            status.setSyncRequired(Boolean.valueOf(true));
            status.setTenant(tenant);
            this.statusRepository.save((Object)status);
        }
        return status;
    }

    private Item createNewChildFromJiraIssue(Item newChild, Item item, JiraIssue2 jIssue, Map<String, Object> fields, Map<String, AlmConfigurations> almConfigs, JiraField sprintField, AlmAccount almAccount, List<String> logs) {
        if (item.getId() != null && item.getTitle() == null) {
            item = this.itemRepository.findById(item.getId());
        }
        Session session = ((SessionBoard)item.getSessionBoards().get(0)).getSession();
        AlmConfigurations almConfigurations = this.getConfigById(session, almConfigs);
        Set<ItemJiraFieldMap> extraFields = null;
        if (session != null) {
            extraFields = session.combineAdditionalFields(null, (JiraField)fields.get("Sprint"), true, null);
        }
        if (!PropertyValidator.isValid(extraFields)) {
            extraFields = new HashSet();
        }
        if (!PropertyValidator.isValid(extraFields)) {
            extraFields = new HashSet();
        }
        if (PropertyValidator.isValid((Object)session.getJiraFlaggedField())) {
            extraFields.add(session.getJiraFlaggedField());
        }
        if (PropertyValidator.isValid((Collection)almConfigurations.getTeamMappings())) {
            for (BacklogMapping bm : almConfigurations.getTeamMappings()) {
                if (!PropertyValidator.isValid((Collection)bm.getJiraFieldMap())) continue;
                for (ItemJiraFieldMap ijf : bm.getJiraFieldMap()) {
                    extraFields.add(ijf);
                }
            }
        }
        if (newChild == null) {
            newChild = new Item();
        }
        if (newChild.getId() == null) {
            newChild.setId(ObjectId.get().toString());
        }
        newChild.fillFromJira(jIssue.getId(), jIssue.getKey(), jIssue.getSelf(), null, null, almAccount);
        newChild.fillFromJira(null, (Map)jIssue.getFields(), fields);
        if (PropertyValidator.isValid(extraFields)) {
            newChild.putCustomeFieldValues((Map)jIssue.getFields(), extraFields, false);
        }
        KendisUtils.addChanges((boolean)false, (boolean)true, (Item)newChild, null);
        Status status = this.getKendisStatus(jIssue, Item.Type.UserStory.name(), item);
        if (PropertyValidator.isValid((Object)status)) {
            newChild.setStatus(status);
        }
        newChild.setParent(item);
        newChild.setTenant(item.getTenant());
        newChild.setType(Item.USER_STORY);
        newChild.setSource(1);
        newChild.setSessionBoards(item.getSessionBoards());
        newChild.setJiraFilter(item.getJiraFilter());
        newChild.setLinkType(item.getLinkType());
        newChild.setLinkTypes(item.getLinkTypes());
        newChild.setSuspendActivity(true);
        if (newChild.getType().equals(Item.USER_STORY) && sprintField != null) {
            this.onChangeJiraSprint((SessionBoard)item.getSessionBoards().get(0), newChild, jIssue.getFields(), almConfigs, sprintField.getJiraId(), logs);
        }
        return newChild;
    }

    private void markNewItem(String issueId, JiraWebhookPayload payload, Item newChild) {
        if (payload != null) {
            if (payload.getUser() != null && payload.getUser().getDisplayName() != null) {
                newChild.setWebHookActivityBy(payload.getUser().getDisplayName());
                newChild.setCreatedBy(payload.getUser().getDisplayName());
            }
            if (payload.newItems != null) {
                if (payload.newItems.get(issueId) == null) {
                    payload.newItems.put(issueId, new ArrayList());
                }
                ((List)payload.newItems.get(issueId)).add(newChild);
                if (newChild.getJiraFieldByKey() == null) {
                    newChild.setJiraFieldByKey(new HashMap());
                }
                newChild.getJiraFieldByKey().put("webhook_event", payload.getWebhookEvent());
            }
        }
    }

    private HashMap<String, Object> getEmptyJiraJson(String id) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Object getParentOfParentItems(JiraIssue2 issue, Session session, AlmAccount almAccount, JiraWebhookPayload payload, ResyncParamsVO syncUtil) {
        String parentId;
        Object parent = syncUtil.findParent(issue.projectKey(), session, (Map)issue.getFields());
        if (parent != null && parent instanceof Map && PropertyValidator.isValid((Object)(parentId = (String)((Map)parent).get("epicId")))) {
            parent = this.getEmptyJiraJson(parentId);
        }
        return parent;
    }

    private int applyParentOfParentFromIssueLink(JiraWebhookPayload payload, Item item, Session session, ResyncParamsVO syncUtil) {
        JiraIssueLinkPayload link = payload.getIssueLink();
        if (session.getJiraFeatureParentLinkType().indexOf(payload.getIssueLink().getIssueLinkType().getId()) > -1) {
            String jiraId = null;
            String otherJiraId = null;
            if (item.getJiraId().equals(link.getSourceIssueId())) {
                jiraId = item.getJiraId();
                otherJiraId = link.getDestinationIssueId();
            } else if (item.getJiraId().equals(link.getDestinationIssueId())) {
                jiraId = item.getJiraId();
                otherJiraId = link.getSourceIssueId();
            }
            if (jiraId != null && otherJiraId != null) {
                Object parent = null;
                JiraIssue2 issue = null;
                if (payload.issuesMap != null && payload.issuesMap.get(jiraId) != null) {
                    issue = (JiraIssue2)payload.issuesMap.get(jiraId);
                    parent = this.getParentOfParentItems(issue, session, null, payload, syncUtil);
                } else {
                    parent = this.getEmptyJiraJson(otherJiraId);
                }
                if (parent != null) {
                    item.putFeatureParent(parent);
                    return 1;
                }
            }
        }
        return 0;
    }

    private String getDestinationJiraId(List<JiraIssueLinkType> linkTypesToSearchFrom, JiraIssueLinkPayload link, Item item, JiraWebhookPayload jWebHookPayload, AlmAccount almAccount) {
        String destinationJiraId = null;
        ArrayList<String> availableLinkTypeNames = new ArrayList<String>();
        jWebHookPayload.logActivity("PROCESSING_TO_RETRIEVE_DESTINATION_JIRA_ID");
        for (JiraIssueLinkType jiraIssueLinkType : linkTypesToSearchFrom) {
            block17: {
                block15: {
                    block18: {
                        block16: {
                            jiraIssueLinkType.getId();
                            availableLinkTypeNames.add(jiraIssueLinkType.getInward());
                            availableLinkTypeNames.add(jiraIssueLinkType.getOutward());
                            if (!jiraIssueLinkType.getJiraId().equals(link.getIssueLinkType().getId())) break block15;
                            jWebHookPayload.logActivity("Issue link type id successfully matched with id in jira issue link payload.");
                            if (!"IN".equalsIgnoreCase(jiraIssueLinkType.getDirection()) || !jiraIssueLinkType.getName().equalsIgnoreCase(jiraIssueLinkType.getInward())) break block16;
                            jWebHookPayload.logActivity("Inward case matched.");
                            if (PropertyValidator.isValid((Object)link.getDestinationIssueId())) {
                                jWebHookPayload.logActivity("Destination issue id is present in issue link payload.");
                                if (item.getJiraId().equals(link.getDestinationIssueId())) {
                                    jWebHookPayload.logActivity("Successfully matched item jira id with destination issue id from issue link payload, returning source issue id: " + link.getSourceIssueId());
                                    destinationJiraId = link.getSourceIssueId();
                                    break;
                                }
                            }
                            break block17;
                        }
                        if (!"OUT".equalsIgnoreCase(jiraIssueLinkType.getDirection()) || !jiraIssueLinkType.getName().equalsIgnoreCase(jiraIssueLinkType.getOutward())) break block18;
                        jWebHookPayload.logActivity("Outward case matched.");
                        if (PropertyValidator.isValid((Object)link.getSourceIssueId())) {
                            jWebHookPayload.logActivity("Source issue id is present in issue link payload.");
                            if (item.getJiraId().equals(link.getSourceIssueId())) {
                                jWebHookPayload.logActivity("Successfully matched item jira id with destination issue id from issue link payload, returning destination issue id: " + link.getSourceIssueId());
                                destinationJiraId = link.getDestinationIssueId();
                                break;
                            }
                        }
                        break block17;
                    }
                    if (jiraIssueLinkType.getDirection() != null && !"".equalsIgnoreCase(jiraIssueLinkType.getDirection())) break block17;
                    jWebHookPayload.logActivity("No direction found.");
                    if (PropertyValidator.isValid((Object)link.getSourceIssueId())) {
                        jWebHookPayload.logActivity("Source issue id is present in issue link payload.");
                        if (item.getJiraId().equals(link.getSourceIssueId())) {
                            jWebHookPayload.logActivity("Successfully matched item jira id with destination issue id from issue link payload, returning destination issue id: " + link.getSourceIssueId());
                            destinationJiraId = link.getDestinationIssueId();
                            break;
                        }
                    }
                    if (!PropertyValidator.isValid((Object)link.getDestinationIssueId())) break block17;
                    jWebHookPayload.logActivity("Destination issue id is present in issue link payload.");
                    if (item.getJiraId().equals(link.getDestinationIssueId())) {
                        jWebHookPayload.logActivity("Successfully matched item jira id with destination issue id from issue link payload, returning source issue id: " + link.getSourceIssueId());
                        destinationJiraId = link.getSourceIssueId();
                        break;
                    }
                    break block17;
                }
                String linkName = jiraIssueLinkType.getName().toLowerCase();
                String parentLink = "Parent LINK".toLowerCase();
                boolean isParentChild = link.getIssueLinkType().getName().equals("Parent-Child Link");
                boolean isEpicChild = link.getIssueLinkType().getName().equals("Epic-Story Link");
                if (linkName.equals(parentLink) && isParentChild || parentLink.indexOf(linkName) > -1 && (isParentChild || isEpicChild)) {
                    jWebHookPayload.logActivity("Issue link type id does not match with id in jira issue link payload, checking for \"Parent-Child Link\"");
                    if (item.getJiraId().equals(link.getSourceIssueId())) {
                        jWebHookPayload.logActivity("Successfully matched item jira id with destination issue id from issue link payload, returning destination issue id: " + link.getSourceIssueId());
                        destinationJiraId = link.getDestinationIssueId();
                        break;
                    }
                } else if (jiraIssueLinkType.getName().equals(almAccount.getJiraEpicLinkLabel()) && isEpicChild) {
                    jWebHookPayload.logActivity("Both Issue link type id and parent link case do not match, checking for \"Epic-Story Link\"");
                    if (item.getJiraId().equals(link.getSourceIssueId())) {
                        jWebHookPayload.logActivity("Successfully matched item jira id with destination issue id from issue link payload, returning destination issue id: " + link.getSourceIssueId());
                        destinationJiraId = link.getDestinationIssueId();
                        break;
                    }
                }
            }
            jWebHookPayload.logActivity("No condition matched inside 'linkTypesToSearchFrom' for jiraIssueLinkType: " + jiraIssueLinkType);
        }
        if (PropertyValidator.isValid(destinationJiraId)) {
            jWebHookPayload.logActivity("Destination Jira ID retrieved: " + destinationJiraId);
        } else {
            jWebHookPayload.logActivity("Could not retrieve Destination Jira ID");
            jWebHookPayload.logActivity("ERROR : Available link types are: [" + availableLinkTypeNames + "], The link type received is: [" + link.getIssueLinkType().getInwardName() + "," + link.getIssueLinkType().getOutwardName() + "]");
        }
        return destinationJiraId;
    }

    private boolean shouldProcessLink(List<JiraIssueLinkType> linkTypesToSearchFrom, JiraIssueLinkType link, String linkType, AlmAccount almAccount) {
        if ("Parent LINK".equals(linkType)) {
            return this.shouldProcessParentLink(linkTypesToSearchFrom, link);
        }
        if (almAccount.getJiraEpicLinkLabel().equals(linkType)) {
            return this.shouldProcessEpicLink(linkTypesToSearchFrom, link, almAccount);
        }
        return false;
    }

    private boolean shouldProcessEpicLink(List<JiraIssueLinkType> linkTypesToSearchFrom, JiraIssueLinkType link, AlmAccount almAccount) {
        boolean processEpicLink = false;
        for (JiraIssueLinkType jiraIssueLinkType : linkTypesToSearchFrom) {
            if ("+1".equals(jiraIssueLinkType.getJiraId()) && almAccount.getJiraEpicLinkLabel().equalsIgnoreCase(link.getName())) {
                processEpicLink = true;
                continue;
            }
            if (!"parent".equals(jiraIssueLinkType.getJiraId()) || !almAccount.getJiraEpicLinkLabel().equalsIgnoreCase(link.getName())) continue;
            processEpicLink = true;
        }
        return processEpicLink;
    }

    private boolean shouldProcessParentLink(List<JiraIssueLinkType> linkTypesToSearchFrom, JiraIssueLinkType link) {
        boolean processEpicLink = false;
        for (JiraIssueLinkType jiraIssueLinkType : linkTypesToSearchFrom) {
            LOGGER.info("Link :" + link.toString());
            LOGGER.info("Link jiraId :" + link.getJiraId());
            if (!jiraIssueLinkType.getJiraId().equals(link.getJiraId()) && !jiraIssueLinkType.getId().equals(link.getId())) continue;
            processEpicLink = true;
        }
        return processEpicLink;
    }

    private boolean handleUpdateEvent(Item item, Item savedItem, JiraWebhookPayload jWebHookPayload, Map<String, Object> almFields, AlmAccount almAccount, List<Session> sessions, Map<String, AlmConfigurations> almConfigs, ResyncParamsVO syncUtil, Boolean updateParent) {
        jWebHookPayload.logActivity("62. Inside Issue Update Handler item:" + item.getJiraKey());
        boolean deleteParentTC = false;
        boolean saved = false;
        TeamContainer oldTC = new TeamContainer();
        TeamContainer newTC = new TeamContainer();
        JiraField dueDateField = (JiraField)almFields.get("duedate");
        JiraField startDateField = (JiraField)almFields.get("startDate");
        JiraField endDateField = (JiraField)almFields.get("endDate");
        JiraField sprintField = (JiraField)almFields.get("Sprint");
        JiraField storyPointField = (JiraField)almFields.get("Story Points");
        if (PropertyValidator.isValid((Object)item)) {
            JiraIssue2 jIssue = jWebHookPayload.getIssue();
            item.setSource(1);
            Session itemSession = ((SessionBoard)item.getSessionBoards().get(0)).getSession();
            AlmConfigurations almConfigurations = this.getConfigById(itemSession, almConfigs);
            ItemJiraFieldMap sessionFlaggedField = itemSession.getJiraFlaggedField();
            ItemJiraFieldMap sharedSprintField = null;
            boolean isSharedSprintUpdated = false;
            try {
                if (itemSession.getJiraSharedSprintFieldEnabled().booleanValue()) {
                    ItemJiraFieldMap itemField;
                    String value;
                    Object obj;
                    ArrayList<String> sharedSprintMismatches = new ArrayList<String>();
                    jWebHookPayload.logActivity("Shared sprint is enabled for item session");
                    jWebHookPayload.logActivity("63. Found Shared Sprint flag true");
                    sharedSprintField = itemSession.getJiraSharedSprintField();
                    WebhookActivityUtil.getInstance().setSharedSprintField(sharedSprintField);
                    item.setJiraFieldMap(new ArrayList());
                    if (sharedSprintField.getType().equals("JSONObject")) {
                        obj = null;
                        jWebHookPayload.logActivity("Shared sprint type matched with JSONObject.");
                        try {
                            if (PropertyValidator.isValid(jIssue.getFields().get(sharedSprintField.getKey()))) {
                                jWebHookPayload.logActivity("Shared sprint field key matched with issue fields from webhook payload.");
                                obj = new JSONObject((Map)jIssue.getFields().get(sharedSprintField.getKey()));
                            } else {
                                sharedSprintMismatches.add("Could not match shared sprint field with any fields from webhook payload.");
                                sharedSprintMismatches.add("Shared sprint field set is: " + sharedSprintField.getKey());
                                obj = null;
                            }
                            jWebHookPayload.logActivity("64. Shared Sprint Field is JSONObject");
                        }
                        catch (Exception e) {
                            LOGGER.error("Error ::   : " + StringUtils.getTraceString((Throwable)e));
                        }
                        try {
                            if (obj != null && obj.has("id")) {
                                value = String.valueOf(obj.get("id"));
                                JSONObject jsonValue = new JSONObject();
                                jsonValue.put("id", (Object)value);
                                ItemJiraFieldMap itemField2 = new ItemJiraFieldMap(sharedSprintField.getKey(), jsonValue.toString(), sharedSprintField.getType());
                                if (!PropertyValidator.isValid((Collection)item.getJiraFieldMap())) {
                                    item.setJiraFieldMap(new ArrayList());
                                }
                                item.getJiraFieldMap().add(itemField2);
                                isSharedSprintUpdated = true;
                                jWebHookPayload.logActivity("64.1. Shared Sprint Field is JSONObject id settled");
                            }
                        }
                        catch (JSONException e) {
                            LOGGER.error("Error ::   : " + StringUtils.getTraceString((Throwable)e));
                        }
                    } else if (sharedSprintField.getType().equals("JSONArray")) {
                        ArrayList fieldArray;
                        jWebHookPayload.logActivity("65. Shared Sprint Field is JSONArray");
                        if ("labels".equals(sharedSprintField.getJiraType())) {
                            jWebHookPayload.logActivity("Jira type from shared sprint field matched with labels.");
                            fieldArray = (ArrayList)jIssue.getFields().get(sharedSprintField.getKey());
                            if (PropertyValidator.isValid((Collection)fieldArray)) {
                                Gson gson = new Gson();
                                itemField = new ItemJiraFieldMap(sharedSprintField.getKey(), gson.toJson((Object)fieldArray), sharedSprintField.getType());
                                if (!PropertyValidator.isValid((Collection)item.getJiraFieldMap())) {
                                    item.setJiraFieldMap(new ArrayList());
                                }
                                item.getJiraFieldMap().add(itemField);
                                isSharedSprintUpdated = true;
                            } else {
                                sharedSprintMismatches.add("Could not get create field array from issue in webhook payload by using key from shared sprint field.");
                                sharedSprintMismatches.add("Shared sprint field set is: " + sharedSprintField.getKey());
                                sharedSprintMismatches.add("Shared sprint field jira type is: " + sharedSprintField.getJiraType());
                            }
                        } else {
                            jWebHookPayload.logActivity("Jira type from shared sprint field did not match with labels.");
                            fieldArray = (ArrayList)jIssue.getFields().get(sharedSprintField.getKey());
                            ArrayList<Object> jobjects = new ArrayList<Object>();
                            if (PropertyValidator.isValid((Collection)fieldArray)) {
                                for (Object fieldValue : fieldArray) {
                                    if (fieldValue instanceof Map) {
                                        String value2 = (String)((Map)fieldValue).get("id");
                                        HashMap<String, Object> jobj = new HashMap<String, Object>();
                                        jobj.put("id", value2);
                                        jobjects.add(jobj);
                                        continue;
                                    }
                                    if (!(fieldValue instanceof String)) continue;
                                    jobjects.add(String.valueOf(fieldValue));
                                }
                                if (PropertyValidator.isValid(jobjects)) {
                                    Gson gson = new Gson();
                                    ItemJiraFieldMap itemField2 = new ItemJiraFieldMap(sharedSprintField.getKey(), gson.toJson(jobjects), sharedSprintField.getType());
                                    if (!PropertyValidator.isValid((Collection)item.getJiraFieldMap())) {
                                        item.setJiraFieldMap(new ArrayList());
                                    }
                                    item.getJiraFieldMap().add(itemField2);
                                    item.setFlagged(sharedSprintField.getIsFlagged());
                                    isSharedSprintUpdated = true;
                                } else {
                                    sharedSprintMismatches.add("Field array does not have any attribute of type string or map.");
                                }
                            } else {
                                sharedSprintMismatches.add("Could not get create field array from issue in webhook payload by using key from shared sprint field.");
                                sharedSprintMismatches.add("Shared sprint field set is: " + sharedSprintField.getKey());
                                sharedSprintMismatches.add("Shared sprint field jira type is: " + sharedSprintField.getJiraType());
                            }
                        }
                    } else if (sharedSprintField.getType().equals("String")) {
                        jWebHookPayload.logActivity("65. Shared Sprint Field is String");
                        obj = null;
                        try {
                            if (jIssue.getFields().get(sharedSprintField.getKey()) instanceof String) {
                                obj = (String)jIssue.getFields().get(sharedSprintField.getKey());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Error ::   : " + StringUtils.getTraceString((Throwable)e));
                        }
                        ItemJiraFieldMap itemField3 = new ItemJiraFieldMap(sharedSprintField.getKey(), (String)obj, sharedSprintField.getType());
                        if (!PropertyValidator.isValid((Collection)item.getJiraFieldMap())) {
                            item.setJiraFieldMap(new ArrayList());
                        }
                        item.getJiraFieldMap().add(itemField3);
                        isSharedSprintUpdated = true;
                    } else if (sharedSprintField.getType().equals("Double")) {
                        jWebHookPayload.logActivity("65. Shared Sprint Field is Double");
                        obj = null;
                        try {
                            obj = (Double)jIssue.getFields().get(sharedSprintField.getKey());
                        }
                        catch (Exception e) {
                            LOGGER.error("Error ::   : " + StringUtils.getTraceString((Throwable)e));
                        }
                        value = "";
                        if (PropertyValidator.isValid((Object)obj)) {
                            value = String.valueOf(obj);
                        }
                        itemField = new ItemJiraFieldMap(sharedSprintField.getKey(), value, sharedSprintField.getType());
                        if (!PropertyValidator.isValid((Collection)item.getJiraFieldMap())) {
                            item.setJiraFieldMap(new ArrayList());
                        }
                        item.getJiraFieldMap().add(itemField);
                        isSharedSprintUpdated = true;
                    }
                    if (!isSharedSprintUpdated) {
                        jWebHookPayload.logActivity("ERROR : Shared sprint field type received is: [" + sharedSprintField.getType() + "] " + String.join((CharSequence)",\t", sharedSprintMismatches));
                    }
                }
                if (PropertyValidator.isValid((Object)itemSession.getWsjfEnabled()) && jIssue.getFields().containsKey(itemSession.getwsjfAlmFieldKey())) {
                    item.setAlmScoreField((Double)jIssue.getFields().get(itemSession.getwsjfAlmFieldKey()));
                }
            }
            catch (Exception exp) {
                jWebHookPayload.logError("Exception ::   : " + StringUtils.getTraceString((Throwable)exp));
            }
            jWebHookPayload.logActivity("66. Shared Sprint Flag : " + isSharedSprintUpdated);
            if (jWebHookPayload.getChangelog() != null && PropertyValidator.isValid((Collection)jWebHookPayload.getChangelog().getItems())) {
                List changeLogs = jWebHookPayload.getChangelog().getItems();
                jWebHookPayload.logActivity("VERIFYING_CHANGE_LOG_IN_WEBHOOK");
                if (PropertyValidator.isValid((Collection)changeLogs)) {
                    jWebHookPayload.logActivity("PROCESSING_CHANGE_LOG_IN_WEBHOOK");
                    for (JiraItem changeLogItem : changeLogs) {
                        if (!PropertyValidator.isValid((Object)changeLogItem)) continue;
                        boolean targetDependenciesMeta = true;
                        Set extraFields = itemSession.combineAdditionalFields(null, sprintField, true, null);
                        if (PropertyValidator.isValid((Object)itemSession.getJiraFlaggedField())) {
                            extraFields.add(itemSession.getJiraFlaggedField());
                        }
                        if (PropertyValidator.isValid((Collection)almConfigurations.getTeamMappings())) {
                            for (BacklogMapping bm : almConfigurations.getTeamMappings()) {
                                if (!PropertyValidator.isValid((Collection)bm.getJiraFieldMap())) continue;
                                for (ItemJiraFieldMap ijf : bm.getJiraFieldMap()) {
                                    extraFields.add(ijf);
                                }
                            }
                        }
                        item.putCustomeFieldValues((Map)jIssue.getFields(), (Collection)extraFields, true);
                        if (Boolean.TRUE.equals(itemSession.getJiraFeatureParentEnabled())) {
                            item.putFeatureParent(this.getParentOfParentItems(jIssue, itemSession, almAccount, jWebHookPayload, syncUtil));
                        }
                        if ("summary".equalsIgnoreCase(changeLogItem.getFieldId()) || "summary".equalsIgnoreCase(changeLogItem.getField())) {
                            this.updateItemByProperty(changeLogItem.getField(), jWebHookPayload, item, dueDateField, startDateField, endDateField, sessions, almAccount);
                            targetDependenciesMeta = true;
                        } else if (PropertyValidator.isValid((Object)sessionFlaggedField) && (sessionFlaggedField.getKey().equals(changeLogItem.getFieldId()) || sessionFlaggedField.getKey().equals(changeLogItem.getField()))) {
                            ItemJiraFieldMap itemFlaggedField = new ItemJiraFieldMap();
                            if (PropertyValidator.isValid((Object)changeLogItem.getFieldId())) {
                                itemFlaggedField.setKey(changeLogItem.getFieldId());
                            } else {
                                itemFlaggedField.setKey(changeLogItem.getField());
                            }
                            itemFlaggedField.setType("JSONArray");
                            itemFlaggedField.setIsFlagged(Boolean.valueOf(true));
                            if (PropertyValidator.isValid((Object)changeLogItem.getTo())) {
                                String[] changes = changeLogItem.getTo().toString().substring(1, changeLogItem.getTo().toString().length() - 1).split(",");
                                JSONArray valueArray = new JSONArray();
                                for (Object object : changes) {
                                    try {
                                        JSONObject value = new JSONObject();
                                        if (!PropertyValidator.isValid((Object)object)) continue;
                                        value.put("id", (Object)((String)object).trim());
                                        valueArray.put((Object)value);
                                    }
                                    catch (JSONException e) {
                                        LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
                                    }
                                }
                                itemFlaggedField.setValue(valueArray.toString());
                            } else {
                                itemFlaggedField.setValue(null);
                            }
                            if (PropertyValidator.isValid((Collection)item.getJiraFieldMap())) {
                                if (!PropertyValidator.isValid((Object)itemFlaggedField.getValue())) {
                                    item.getJiraFieldMap().remove(itemFlaggedField);
                                    item.setFlagged(Boolean.valueOf(false));
                                } else {
                                    for (ItemJiraFieldMap fieldMap : item.getJiraFieldMap()) {
                                        if (!fieldMap.getKey().equals(itemFlaggedField.getKey())) continue;
                                        fieldMap.setValue(itemFlaggedField.getValue());
                                        break;
                                    }
                                    item.setFlagged(Boolean.valueOf(true));
                                }
                            } else {
                                ArrayList<ItemJiraFieldMap> fieldMaps = new ArrayList<ItemJiraFieldMap>();
                                fieldMaps.add(itemFlaggedField);
                                item.setJiraFieldMap(fieldMaps);
                                if (PropertyValidator.isValid((Object)itemFlaggedField.getValue())) {
                                    item.setFlagged(Boolean.valueOf(true));
                                } else {
                                    item.setFlagged(Boolean.valueOf(false));
                                }
                            }
                        } else if (!"fixVersions".equalsIgnoreCase(changeLogItem.getField()) && !"fixVersions".equalsIgnoreCase(changeLogItem.getFieldId())) {
                            if (PropertyValidator.isValid((Object)dueDateField) && PropertyValidator.isValid((Object)dueDateField.getJiraId()) && (dueDateField.getJiraId().equalsIgnoreCase(changeLogItem.getFieldId()) || dueDateField.getJiraId().equalsIgnoreCase(changeLogItem.getField()) || PropertyValidator.isValid((Object)dueDateField.getName()) && PropertyValidator.isValid((Object)changeLogItem.getField()) && dueDateField.getName().equals(changeLogItem.getField()))) {
                                this.updateItemByProperty("duedate", jWebHookPayload, item, dueDateField, startDateField, endDateField, sessions, almAccount);
                            } else if (PropertyValidator.isValid((Object)startDateField) && PropertyValidator.isValid((Object)startDateField.getJiraId()) && (startDateField.getJiraId().equalsIgnoreCase(changeLogItem.getFieldId()) || startDateField.getJiraId().equalsIgnoreCase(changeLogItem.getField()) || PropertyValidator.isValid((Object)startDateField.getName()) && PropertyValidator.isValid((Object)changeLogItem.getField()) && startDateField.getName().equals(changeLogItem.getField()))) {
                                this.updateItemByProperty("startDate", jWebHookPayload, item, dueDateField, startDateField, endDateField, sessions, almAccount);
                            } else if (PropertyValidator.isValid((Object)endDateField) && PropertyValidator.isValid((Object)endDateField.getJiraId()) && (endDateField.getJiraId().equalsIgnoreCase(changeLogItem.getFieldId()) || endDateField.getJiraId().equalsIgnoreCase(changeLogItem.getField()) || PropertyValidator.isValid((Object)endDateField.getName()) && PropertyValidator.isValid((Object)changeLogItem.getField()) && endDateField.getName().equals(changeLogItem.getField()))) {
                                this.updateItemByProperty("endDate", jWebHookPayload, item, dueDateField, startDateField, endDateField, sessions, almAccount);
                            } else if ("status".equalsIgnoreCase(changeLogItem.getFieldId()) || "status".equalsIgnoreCase(changeLogItem.getField())) {
                                this.updateItemByProperty(changeLogItem.getFieldId() == null ? changeLogItem.getField() : changeLogItem.getFieldId(), jWebHookPayload, item, dueDateField, startDateField, endDateField, sessions, almAccount);
                                targetDependenciesMeta = true;
                            } else if ("Sprint".equalsIgnoreCase(changeLogItem.getField()) || sprintField != null && sprintField.getJiraId() != null && sprintField.getJiraId().equalsIgnoreCase(changeLogItem.getFieldId()) || PropertyValidator.isValid((Object)sharedSprintField) && (sharedSprintField.getKey().equals(changeLogItem.getField()) || sharedSprintField.getKey().equals(changeLogItem.getFieldId())) || isSharedSprintUpdated) {
                                jWebHookPayload.logActivity("70. Sprint update found");
                                if (jWebHookPayload.newItems == null) {
                                    jWebHookPayload.newItems = new ArrayMap();
                                }
                                this.markNewItem(jIssue.getId(), jWebHookPayload, item);
                                if (item.getParent() != null) {
                                    if (jWebHookPayload.newItems.get("parents") == null) {
                                        jWebHookPayload.newItems.put("parents", new ArrayList());
                                    }
                                    ((List)jWebHookPayload.newItems.get("parents")).add(new Item(item.getParent().getId()));
                                }
                            }
                        }
                        if (!targetDependenciesMeta) continue;
                        this.updateItemByProperty("targetDependenciesMeta", jWebHookPayload, item, dueDateField, startDateField, endDateField, sessions, almAccount);
                    }
                }
            }
            boolean skipFeatureUpdateInJira = false;
            if (PropertyValidator.isValid((Object)storyPointField)) {
                jWebHookPayload.logActivity("PROCESSING_ITEM_FOR_STORY_POINT_FIELD");
                Double incomingSpoints = (Double)jIssue.getFields().get(storyPointField.getJiraId());
                if (!item.getType().equals("Feature")) {
                    if (PropertyValidator.isValid((Object)item.getStoryPoints()) && item.getStoryPoints().equals(incomingSpoints)) {
                        skipFeatureUpdateInJira = true;
                    } else if (PropertyValidator.isValid((Object)item.getSubItemEstimate()) && item.getSubItemEstimate().equals(incomingSpoints)) {
                        skipFeatureUpdateInJira = true;
                    }
                }
                if (PropertyValidator.isValid((Object)incomingSpoints)) {
                    jWebHookPayload.logActivity("SETTING_INCOMING_STORY_POINTS_IN_ITEM");
                    incomingSpoints = StringUtils.round((double)incomingSpoints, (int)2);
                    item.setStoryPoints(incomingSpoints);
                }
            }
            item.setSource(1);
            savedItem = (Item)this.itemRepository.save((Object)item);
            saved = true;
            jWebHookPayload.logActivity("ITEM_SAVED_SUCCESSFULLY");
            if (deleteParentTC) {
                this.deleteParentTeamContainer(jWebHookPayload, item.getParent(), oldTC, almAccount);
            }
            if (savedItem.getType().equals(Item.Type.UserStory.name())) {
                this.planService.updateTcInLinksOnChangeCell(savedItem);
            }
            this.pushWebhook(jWebHookPayload.cid, AlmErrorUtils.buildAlmPushJson((Item)savedItem, (String)((SessionBoard)savedItem.getSessionBoards().get(0)).getId(), (String)"Update", null, (Boolean)false, (Boolean)true));
            if (PropertyValidator.isValid((Object)storyPointField) && !skipFeatureUpdateInJira && !item.getType().equals("Feature") && PropertyValidator.isValid((Object)item.getParent().getId())) {
                List childItems = this.itemRepository.findByParentAndTenantAndArchive(savedItem.getParent(), savedItem.getTenant(), false);
                Double totalEstimate = 0.0;
                for (Item childItem : childItems) {
                    totalEstimate = totalEstimate + childItem.getStoryPoints();
                }
                try {
                    this.customRepository.updateItemStoryPoints(savedItem.getParent().getId(), totalEstimate);
                    saved = true;
                    this.pushWebhook(jWebHookPayload.cid, AlmErrorUtils.buildAlmPushJson((Item)item.getParent(), (String)((SessionBoard)savedItem.getSessionBoards().get(0)).getId(), (String)"Update", null, (Boolean)false, (Boolean)true));
                }
                catch (Exception er) {
                    LOGGER.error("FAILED: to update story points in db for feature in ALM from Webhook ", (Throwable)er);
                }
                savedItem.getParent().setSubItemEstimate(totalEstimate);
                updateParent = false;
            }
        }
        return saved;
    }

    private AlmConfigurations getConfigById(Session session, Map<String, AlmConfigurations> almConfigs) {
        String id = ((AlmConfigurations)session.getAlmConfigurations().get(0)).getId();
        AlmConfigurations config = almConfigs.get(id);
        if (config == null) {
            config = this.almConfigurationsRepository.findConfigById(id);
            almConfigs.put(id, config);
        }
        return almConfigs.get(id);
    }

    private AlmConfigurations getConfigById(Item item, Map<String, AlmConfigurations> almConfigs) {
        String id = ((AlmConfigurations)((SessionBoard)item.getSessionBoards().get(0)).getSession().getAlmConfigurations().get(0)).getId();
        AlmConfigurations config = almConfigs.get(id);
        if (config == null) {
            config = this.almConfigurationsRepository.findConfigById(id);
            almConfigs.put(id, config);
        }
        return almConfigs.get(id);
    }

    private void updateItemByProperty(String property, JiraWebhookPayload jWebHookPayload, Item item, JiraField dueDateField, JiraField startDateField, JiraField endDateField, List<Session> sessions, AlmAccount almAccount) {
        jWebHookPayload.logActivity("Updating item by property: " + property);
        if ("summary".equals(property)) {
            jWebHookPayload.logActivity("PROCESSING_ITEM_UPDATE_FOR_SUMMARY");
            item.setTitle(jWebHookPayload.getIssue().getFields().get("summary").toString());
            if (PropertyValidator.isValid((Object)item.getJiraId())) {
                try {
                    List dependencies = this.itemJiraDependencyRepository.findByTargetJiraIssueJiraId(item.getJiraId());
                    if (PropertyValidator.isValid((Collection)dependencies)) {
                        for (ItemJiraDependency dependency : dependencies) {
                            dependency.getTargetJiraIssue().getFields().setSummary(item.getTitle());
                        }
                        this.itemJiraDependencyRepository.save((Iterable)dependencies);
                    }
                }
                catch (Exception e) {
                    String ex = ":: Exception while saving dependencies - Summary" + StringUtils.getTraceString((Throwable)e);
                    LOGGER.error(ex);
                    jWebHookPayload.logError(ex);
                }
            }
        }
        if ("duedate".equals(property)) {
            jWebHookPayload.logActivity("PROCESSING_ITEM_FOR_DUE_DATE_UPDATE");
            if (item.getType().equals(Item.FEATURE)) {
                jWebHookPayload.logActivity("ITEM_TYPE_IS_FEATURE");
                if (PropertyValidator.isValid(jWebHookPayload.getIssue().getFields().get(dueDateField.getJiraId()))) {
                    jWebHookPayload.logActivity("MAPPING_VERIFIED_AND_SETTING_NEW_DATE");
                    item.setDueDate(PropertyValidator.parseDate((String)jWebHookPayload.getIssue().getFields().get(dueDateField.getJiraId()).toString(), (String)"yyyy-MM-dd"));
                } else {
                    item.setDueDate(null);
                }
            }
        }
        if ("startDate".equals(property)) {
            jWebHookPayload.logActivity("PROCESSING_ITEM_FOR_START_DATE_UPDATE");
            if (item.getType().equals(Item.FEATURE)) {
                if (PropertyValidator.isValid(jWebHookPayload.getIssue().getFields().get(startDateField.getJiraId()))) {
                    jWebHookPayload.logActivity("MAPPING_VERIFIED_AND_SETTING_NEW_START_DATE");
                    item.setStartDate(PropertyValidator.parseDate((String)jWebHookPayload.getIssue().getFields().get(startDateField.getJiraId()).toString(), (String)"yyyy-MM-dd"));
                } else {
                    item.setStartDate(null);
                }
            }
        }
        if ("endDate".equals(property)) {
            jWebHookPayload.logActivity("PROCESSING_ITEM_FOR_END_DATE_UPDATE");
            if (item.getType().equals(Item.FEATURE)) {
                if (PropertyValidator.isValid(jWebHookPayload.getIssue().getFields().get(endDateField.getJiraId()))) {
                    jWebHookPayload.logActivity("MAPPING_VERIFIED_AND_SETTING_NEW_END_DATE");
                    item.setEndDate(PropertyValidator.parseDate((String)jWebHookPayload.getIssue().getFields().get(endDateField.getJiraId()).toString(), (String)"yyyy-MM-dd"));
                } else {
                    item.setEndDate(null);
                }
            }
        }
        if ("status".equals(property)) {
            jWebHookPayload.logActivity("PROCESSING_ITEM_FOR_STATUS_CHANGE");
            JiraIssue2 jiraIssue = jWebHookPayload.getIssue();
            jWebHookPayload.logActivity("GETTING_ISSUE_TYPE_ID_PROJECT_KEY_AND_STATUS_ID");
            Map jiraProjectObj = (Map)jiraIssue.getFields().get("project");
            Map jiraIssueTypeObj = (Map)jiraIssue.getFields().get("issuetype");
            Map jiraStatusObj = (Map)jiraIssue.getFields().get("status");
            String issueTypeId = (String)jiraIssueTypeObj.get("id");
            String projectKey = (String)jiraProjectObj.get("key");
            String statusId = (String)jiraStatusObj.get("id");
            String associatedSessionId = null;
            jWebHookPayload.logActivity("GETTING_ASSOCIATED_SESSION_ID");
            for (Session sesion : sessions) {
                if (!PropertyValidator.isValid((Object)sesion.getActiveSessionBoard()) || !sesion.getActiveSessionBoard().equals(((SessionBoard)item.getSessionBoards().get(0)).getId())) continue;
                associatedSessionId = sesion.getId();
            }
            Gson g = new Gson();
            JiraStatus jiraStatus = (JiraStatus)g.fromJson(g.toJson(jiraIssue.getFields().get("status")), JiraStatus.class);
            if (PropertyValidator.isValid((Object)jiraStatus)) {
                try {
                    List dependencies = this.itemJiraDependencyRepository.findByTargetJiraIssueJiraId(item.getJiraId());
                    if (PropertyValidator.isValid((Collection)dependencies)) {
                        for (ItemJiraDependency dependency : dependencies) {
                            dependency.getTargetJiraIssue().getFields().setStatus(jiraStatus);
                        }
                        this.itemJiraDependencyRepository.save((Iterable)dependencies);
                    }
                }
                catch (Exception e) {
                    String ex = ":: Exception while saving Jira Status" + StringUtils.getTraceString((Throwable)e);
                    LOGGER.error(ex);
                    jWebHookPayload.logError(ex);
                }
            }
            if (PropertyValidator.isValid(associatedSessionId)) {
                Status oldStatus = item.getStatus();
                jWebHookPayload.logActivity("RETRIEVING_STATUS_FROM_DATABASE_USING_ISSUE_TYPE_PROJECT_KEY_AND_STATUS_ID");
                Status status = this.getKendisStatus(jiraIssue, item.getType(), associatedSessionId, almAccount.getTenant());
                if (PropertyValidator.isValid((Object)status)) {
                    jWebHookPayload.logActivity("VALID_STATUS_RETRIEVED_AGAINST_PARAMETERS");
                    item.setStatus(status);
                    this.planService.updateItemLinksStatusBasedOnItemStatus(item, oldStatus, (SessionBoard)item.getSessionBoards().get(0), jWebHookPayload.cid);
                } else {
                    LOGGER.error("WebhookSyncService --> IN VALID STATUS was found from db. " + jWebHookPayload);
                }
            } else {
                LOGGER.error("WebhookSyncService --> IN-VALID associatedSessionId. Update skipped for Status Field. " + jWebHookPayload);
                jWebHookPayload.logActivity("Invalid associated session ID. Update skipped for Status Field.");
            }
        }
        if ("targetDependenciesMeta".equals(property)) {
            jWebHookPayload.logActivity("PROCESSING_ITEM_UPDATE_FOR_TARGET_DEPENDENCIES_META");
            Gson g = new Gson();
            JiraStatus jiraStatus = (JiraStatus)g.fromJson(g.toJson(jWebHookPayload.getIssue().getFields().get("status")), JiraStatus.class);
            String title = jWebHookPayload.getIssue().getFields().get("summary").toString();
            if (PropertyValidator.isValid((Object)item.getJiraId())) {
                try {
                    List dependencies = this.itemJiraDependencyRepository.findByTargetJiraIssueJiraId(item.getJiraId());
                    if (PropertyValidator.isValid((Collection)dependencies)) {
                        for (ItemJiraDependency dependency : dependencies) {
                            dependency.getTargetJiraIssue().getFields().setSummary(title);
                            if (!PropertyValidator.isValid((Object)jiraStatus)) continue;
                            dependency.getTargetJiraIssue().getFields().setStatus(jiraStatus);
                        }
                        this.itemJiraDependencyRepository.save((Iterable)dependencies);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error(":: Exception while saving dependencies");
                }
            }
        }
        jWebHookPayload.logActivity("Completed processing for updating item by property: " + property);
    }

    private boolean updateItemLinksStatusBasedOnItemStatusTFS(Item item, Status oldStatus, Session session, HashMap<String, TeamContainer> oldAndNewTeamContainerMap, AlmAccount almAccount) {
        boolean canReopen;
        String key;
        if (item.getType().equals(Item.USER_STORY)) {
            key = session.getSubItemLinkStatusDependentOn();
            canReopen = session.getReOpenDependencyIfSubItemReOpen();
        } else {
            key = session.getItemLinkStatusDependentOn();
            canReopen = session.getReOpenDependencyIfItemReOpen();
        }
        if (PropertyValidator.isValid(oldAndNewTeamContainerMap)) {
            ArrayList allItemLinks = new ArrayList();
            List outboundItemLinks = item.getItemLinks();
            TeamContainer oldTeamContainer = oldAndNewTeamContainerMap.get("old");
            TeamContainer newTeamContainer = oldAndNewTeamContainerMap.get("new");
            if (PropertyValidator.isValid((Object)newTeamContainer) && PropertyValidator.isValid((Object)oldTeamContainer)) {
                List inboundItemLinks;
                if (PropertyValidator.isValid((Collection)outboundItemLinks)) {
                    for (int i = 0; i < outboundItemLinks.size(); ++i) {
                        ItemLink link = (ItemLink)outboundItemLinks.get(i);
                        link.setSourceTeamContainerId(newTeamContainer.getId());
                        link.setSourceFeatureId(item.getParent().getId());
                    }
                    allItemLinks.addAll(outboundItemLinks);
                }
                if (PropertyValidator.isValid((Collection)(inboundItemLinks = this.itemLinkRepository.findByTargetUserStoryId(item.getId())))) {
                    for (int i = 0; i < inboundItemLinks.size(); ++i) {
                        ItemLink link = (ItemLink)inboundItemLinks.get(i);
                        link.setTargetTeamContainerId(newTeamContainer.getId());
                        link.setTargetFeatureId(item.getParent().getId());
                    }
                    allItemLinks.addAll(inboundItemLinks);
                }
                if (PropertyValidator.isValid(allItemLinks)) {
                    this.itemLinkRepository.save(allItemLinks);
                }
            }
        }
        if (PropertyValidator.isValid((Object)key) && !key.equals("-1")) {
            boolean resolveDependencies = false;
            boolean openDependencies = false;
            List statuses = this.statusRepository.findByWorkFlow(session.getDependencyWorkFlow());
            Status openStatus = null;
            Status closeStatus = null;
            for (Status st : statuses) {
                if (openStatus == null && st.getCategory().equals("ToDo")) {
                    openStatus = st;
                }
                if (closeStatus != null || !st.getCategory().equals("Done")) continue;
                closeStatus = st;
            }
            if (PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory()) && PropertyValidator.isValid((Object)oldStatus) && PropertyValidator.isValid((Object)oldStatus.getCategory()) && item.getStatus().getCategory().equals("Done") && !oldStatus.getCategory().equals(item.getStatus().getCategory())) {
                resolveDependencies = true;
            }
            if (canReopen && PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory()) && PropertyValidator.isValid((Object)oldStatus) && PropertyValidator.isValid((Object)oldStatus.getCategory()) && oldStatus.getCategory().equals("Done") && !oldStatus.getCategory().equals(item.getStatus().getCategory())) {
                openDependencies = true;
            }
            if (openDependencies || resolveDependencies) {
                List itemLinks = new ArrayList();
                List itemJiraDependencies = new ArrayList();
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(item.getId(), item.getId());
                List kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
                if (Item.USER_STORY.equals(item.getType())) {
                    itemLinks = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId(item.getId(), item.getId());
                } else {
                    ArrayList tcIds = new ArrayList();
                    if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                        item.getTeamContainers().forEach(tc -> {
                            if (PropertyValidator.isValid((Object)tc)) {
                                tcIds.add(tc.getId());
                            }
                        });
                    }
                    if (PropertyValidator.isValid(tcIds)) {
                        itemLinks.addAll(this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcIds, tcIds));
                    }
                }
                List<ItemLink> linksToBeUpdated = new ArrayList();
                ArrayList<ItemJiraDependency> itemJiraDependencyToBeUpdated = new ArrayList<ItemJiraDependency>();
                if (PropertyValidator.isValid(itemLinks)) {
                    for (ItemLink itemLink : itemLinks) {
                        boolean ignoreUpdateIfManualResolved = false;
                        boolean ignoreIfWrongItem = true;
                        if (Item.FEATURE.equals(item.getType())) {
                            if (key.equals(Session.DependencyStatusOption.Source.toString()) && PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId()) || key.equals(Session.DependencyStatusOption.Target.toString()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) continue;
                            ignoreUpdateIfManualResolved = session.getIgnoreUpdateIfManualResolvedForItem() != false && itemLink.getIsManuallyResolved() != false;
                        } else {
                            ignoreUpdateIfManualResolved = session.getIgnoreUpdateIfManualResolvedForSubItem() != false && itemLink.getIsManuallyResolved() != false;
                        }
                        ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, item.getId(), kendisLinkTypes, key, session);
                        if (ignoreUpdateIfManualResolved || ignoreIfWrongItem) continue;
                        if (resolveDependencies) {
                            itemLink.setStatus("Resolved");
                            itemLink.setWfStatus(closeStatus);
                            itemLink.setResolvedOn(new Date());
                            itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                            linksToBeUpdated.add(itemLink);
                            continue;
                        }
                        itemLink.setStatus("Open");
                        itemLink.setWfStatus(openStatus);
                        itemLink.setResolvedOn(null);
                        itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                        linksToBeUpdated.add(itemLink);
                    }
                    linksToBeUpdated = this.itemLinkRepository.save(linksToBeUpdated);
                }
                if (PropertyValidator.isValid(itemJiraDependencies)) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        boolean ignoreIfWrongItem = true;
                        ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, item.getId(), kendisLinkTypes, key, session);
                        if (ignoreIfWrongItem) continue;
                        if (resolveDependencies) {
                            jD.setWfStatus(closeStatus);
                        } else {
                            jD.setWfStatus(openStatus);
                        }
                        itemJiraDependencyToBeUpdated.add(jD);
                    }
                    this.itemJiraDependencyRepository.save(itemJiraDependencyToBeUpdated);
                }
                if (PropertyValidator.isValid(itemJiraDependencyToBeUpdated) || PropertyValidator.isValid(linksToBeUpdated)) {
                    Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (date, type, jsonSerializationContext) -> new JsonPrimitive((Number)date.getTime())).create();
                    JSONObject pushJson = null;
                    try {
                        pushJson = new JSONObject();
                        pushJson.put("isTFS", true);
                        pushJson.put("isWebhook", true);
                        pushJson.put("type", (Object)item.getType());
                        pushJson.put("id", (Object)item.getId());
                        String sessionBoardId = ((SessionBoard)item.getSessionBoards().get(0)).getId();
                        if (PropertyValidator.isValid((Object)sessionBoardId)) {
                            pushJson.put("boardId", (Object)sessionBoardId);
                        }
                        item = new Item(item);
                        pushJson.put("item", (Object)gsonExclusive.toJson((Object)item));
                        pushJson.put("updatedLinks", (Object)gsonExclusive.toJson(linksToBeUpdated));
                        pushJson.put("updatedItemJiraDependencies", (Object)gsonExclusive.toJson(itemJiraDependencyToBeUpdated));
                        pushJson.put("metaMap", (Object)("{\"event\":\"TFSWebHookItemLinksUpdated\", \"boardId\":\"" + sessionBoardId + "\", \"isTFS\":" + Boolean.TRUE + "}"));
                        String cid = this.companyRepository.findByTenant(almAccount.getTenant()).getId();
                        PushSender.sendMsg((String)cid, (String)pushJson.toString());
                    }
                    catch (JSONException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRateString="${webhook.scheduler.rate}")
    public void retrieveAllUnMappedData() {
        try {
            if (!dataProcessing.booleanValue() && WebHookSyncServiceImpl.isElbActive()) {
                dataProcessing = true;
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"isProcessed").is((Object)false));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"hasError").is((Object)false));
                query.with((Pageable)new PageRequest(0, 1000));
                query.with(new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "sequence")}));
                char[] c = JiraWebhookMappedData.class.getSimpleName().toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                String jiraWebhookMappedData = new String(c);
                List unMappedData = this.mongoTemplate.findAllAndRemove(query, jiraWebhookMappedData);
                int size = unMappedData.size();
                if (size > 0) {
                    if (PropertyValidator.isValid((Collection)unMappedData)) {
                        for (JiraWebhookMappedData webhookData : unMappedData) {
                            this.processJiraWebhook(webhookData);
                        }
                    }
                    LOGGER.debug("JIRA Data processed size:" + unMappedData.size());
                }
            } else if (!PropertyValidator.isValid((Object)System.getenv("enableTimeSeries")) || System.getenv("enableTimeSeries").equals("false")) {
                LOGGER.info("Jira webhook Scheduled Stopped");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed retrieveAllUnMappedData: ", (Throwable)e);
        }
        finally {
            dataProcessing = false;
        }
    }

    public void processJiraWebhook(JiraWebhookMappedData webhookData) {
        ArrayList<String> logs = new ArrayList<String>();
        logs.add("\n-----Tenant : [" + webhookData.getTenant() + "] webhook [" + webhookData.getJiraWebhookEvent() + "] logs at : " + new Date(Long.parseLong(webhookData.getJiraWebhookPayload().getTimestamp())) + "");
        if ("sprint_started".equals(webhookData.getJiraWebhookEvent()) || "sprint_closed".equals(webhookData.getJiraWebhookEvent())) {
            logs.add("-----------------------processing sprint webhook-----------------------");
            this.onJiraSprintStatusChange(webhookData.getMongoId(), webhookData, webhookData.getAlmAccountId(), logs);
            logs.addAll(webhookData.getJiraWebhookPayload().logs);
        } else {
            if (webhookData.getJiraWebhookPayload() != null && webhookData.getJiraWebhookPayload().getIssue() != null) {
                logs.add("jira webhook key :  [" + webhookData.getJiraWebhookPayload().getIssue().getKey() + "] ");
            }
            logs.add("-----------------------processing pi item webhook-----------------------");
            this.updateJiraWebhookItem(webhookData.getMongoId(), webhookData, webhookData.getAlmAccountId(), null, webhookData.getSequence(), logs);
            logs.add("-----------------------processing org item webhook-----------------------");
            this.updateBackLogItem(webhookData, logs);
        }
        if (PropertyValidator.isValid(logs)) {
            this.printLogs(webhookData.getAlmAccountId(), logs);
        }
    }

    private static boolean isElbActive() {
        if (!SystemUtil.isProductionCloudEnv()) {
            return true;
        }
        long timeDiff = System.currentTimeMillis() - elbLastActive;
        if (timeDiff > 30000L) {
            LOGGERHEALTH.error("Schedule timeout since : " + timeDiff / 1000L + " seconds");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRateString="${webhook.scheduler.rate}")
    public void retrieveAllTFSUnMappedData() {
        try {
            if (!tfsDataProcessing.booleanValue() && WebHookSyncServiceImpl.isElbActive()) {
                tfsDataProcessing = true;
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"isProcessed").is((Object)false));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"hasError").is((Object)false));
                query.with((Pageable)new PageRequest(0, 1000));
                query.with(new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "sequence")}));
                char[] c = TFSWebhookMappedData.class.getSimpleName().toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                String tFSWebhookMappedData = new String(c);
                List unMappedData = this.mongoTemplate.findAllAndRemove(query, tFSWebhookMappedData);
                int size = unMappedData.size();
                if (size > 0) {
                    LOGGER.debug("Data retrieve for processing :" + unMappedData.size());
                    if (PropertyValidator.isValid((Collection)unMappedData)) {
                        for (TFSWebhookMappedData data : unMappedData) {
                            this.updateTFSWebhookItem(data);
                        }
                    }
                    LOGGER.debug("TFS Data processed size :" + unMappedData.size());
                }
            } else if (!PropertyValidator.isValid((Object)System.getenv("enableTimeSeries")) || System.getenv("enableTimeSeries").equals("false")) {
                LOGGER.info("TFS webhook Scheduled Stopped");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed retrieveAllUnMappedData: ", (Throwable)e);
        }
        finally {
            tfsDataProcessing = false;
        }
    }

    private Session sessionFromDBObject(DBObject sessionDbObject) {
        Session session = new Session();
        session.setId(String.valueOf(sessionDbObject.get("_id")));
        session.setTitle((String)sessionDbObject.get("title"));
        session.setActiveSessionBoard((String)sessionDbObject.get("activeSessionBoard"));
        if (sessionDbObject.containsField("startSprintWebhookEnabled")) {
            session.setStartSprintWebhookEnabled((Boolean)sessionDbObject.get("startSprintWebhookEnabled"));
        }
        if (sessionDbObject.containsField("endSprintWebhookEnabled")) {
            session.setEndSprintWebhookEnabled((Boolean)sessionDbObject.get("endSprintWebhookEnabled"));
        }
        if (sessionDbObject.containsField("startDateAction")) {
            session.setStartDateAction((String)sessionDbObject.get("startDateAction"));
        }
        if (sessionDbObject.containsField("bucketEnabled")) {
            session.setBucketEnabled((Boolean)sessionDbObject.get("bucketEnabled"));
        }
        if (sessionDbObject.containsField("tfsAlmConfigurations")) {
            DBRef tfsAlmConfigurationsRef = (DBRef)sessionDbObject.get("tfsAlmConfigurations");
            TFSAlmConfigurations almConfigurations = new TFSAlmConfigurations();
            almConfigurations.setId(String.valueOf(tfsAlmConfigurationsRef.getId()));
            session.setTfsAlmConfigurations(almConfigurations);
        }
        if (sessionDbObject.containsField("buckets")) {
            session.setBuckets(new HashMap());
            DBObject bucketsObject = (DBObject)sessionDbObject.get("buckets");
            for (String key : bucketsObject.keySet()) {
                DBObject issueTypeObject = (DBObject)bucketsObject.get(key);
                IssueType issueType = this.issueTypeFromDbObject(issueTypeObject);
                session.getBuckets().put(key, issueType);
            }
        }
        if (sessionDbObject.containsField("excludeTfsStatuses")) {
            session.setExcludeTfsStatuses(new ArrayList());
            BasicDBList excludeTfsStatuses = (BasicDBList)sessionDbObject.get("excludeTfsStatuses");
            for (Object status : excludeTfsStatuses) {
                session.getExcludeTfsStatuses().add(status.toString());
            }
        }
        if (sessionDbObject.containsField("excludeTfsItemTypes")) {
            session.setExcludeTfsItemTypes(new ArrayList());
            BasicDBList excludeTfsItemTypes = (BasicDBList)sessionDbObject.get("excludeTfsItemTypes");
            for (Object itemType : excludeTfsItemTypes) {
                session.getExcludeTfsItemTypes().add(itemType.toString());
            }
        }
        return session;
    }

    private IssueType issueTypeFromDbObject(DBObject issueTypeDbObject) {
        String value;
        int i;
        IssueType issuetype = new IssueType();
        issuetype.setId(String.valueOf(issueTypeDbObject.get("_id")));
        issuetype.setArchive(((Boolean)issueTypeDbObject.get("archive")).booleanValue());
        issuetype.setTitle((String)issueTypeDbObject.get("title"));
        if (issueTypeDbObject.containsKey("color")) {
            issuetype.setColor((String)issueTypeDbObject.get("color"));
        }
        if (issueTypeDbObject.containsKey("textColor")) {
            issuetype.setTextColor((String)issueTypeDbObject.get("textColor"));
        }
        if (issueTypeDbObject.containsKey("almAccountId")) {
            issuetype.setAlmAccountId((String)issueTypeDbObject.get("almAccountId"));
        }
        if (issueTypeDbObject.containsKey("tfsProcessId")) {
            issuetype.setTfsProcessId((String)issueTypeDbObject.get("tfsProcessId"));
        }
        if (issueTypeDbObject.containsKey("isBucket")) {
            issuetype.setIsBucket((Boolean)issueTypeDbObject.get("isBucket"));
        }
        if (issueTypeDbObject.containsKey("jiraTypes")) {
            BasicDBList jiraTypesObj = (BasicDBList)issueTypeDbObject.get("jiraTypes");
            ArrayList<String> jiraTypes = new ArrayList<String>();
            for (i = 0; i < jiraTypesObj.size(); ++i) {
                value = (String)jiraTypesObj.get(i);
                jiraTypes.add(value);
            }
            issuetype.setJiraTypes(jiraTypes);
        }
        if (issueTypeDbObject.containsKey("tfsTypes")) {
            BasicDBList tfsTypesObj = (BasicDBList)issueTypeDbObject.get("tfsTypes");
            ArrayList<String> tfsTypes = new ArrayList<String>();
            for (i = 0; i < tfsTypesObj.size(); ++i) {
                value = (String)tfsTypesObj.get(i);
                tfsTypes.add(value);
            }
            issuetype.setTfsTypes(tfsTypes);
        }
        if (issueTypeDbObject.containsKey("almTypes")) {
            BasicDBList almTypesObj = (BasicDBList)issueTypeDbObject.get("almTypes");
            ArrayList almTypes = new ArrayList();
            for (i = 0; i < almTypesObj.size(); ++i) {
                value = (DBObject)almTypesObj.get(i);
                HashMap<String, String> type = new HashMap<String, String>();
                type.put("name", (String)value.get("name"));
                type.put("referenceName", (String)value.get("referenceName"));
                almTypes.add(type);
            }
            issuetype.setAlmTypes(almTypes);
        }
        return issuetype;
    }

    private boolean isItemValidToAddForSession(Item item, Session session) {
        if (PropertyValidator.isValid((Collection)session.getExcludeTfsStatuses()) && PropertyValidator.isValid((Object)item.getStatus()) && session.getExcludeTfsStatuses().contains(item.getStatus().getTitle())) {
            return false;
        }
        return !PropertyValidator.isValid((Collection)session.getExcludeTfsItemTypes()) || !PropertyValidator.isValid((Object)item.getTfsItemType()) || !session.getExcludeTfsItemTypes().contains(item.getTfsItemType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTFSWebhookItem(TFSWebhookMappedData unMappedData) {
        ArrayList<String> executionLogs;
        ArrayList<String> logs;
        block184: {
            logs = new ArrayList<String>();
            executionLogs = new ArrayList<String>();
            String tfsId = "N/A";
            String tenant = "N/A";
            try {
                ArrayList<SessionBoard> sessionIdsToCheckItemChanged = null;
                WebhookActivityUtil.getInstance().reset();
                boolean issueLinkEventDeleted = false;
                boolean issueLinkEventCreated = false;
                boolean issueDeletedEvent = false;
                boolean issueUpdatedEvent = false;
                boolean issueCreatedEvent = false;
                AlmAccount almAccount = new AlmAccount();
                almAccount.setId(unMappedData.getAlmAccountId());
                List almConfigs = this.tfsAlmConfigurationsRepository.findConfigurationsByAlmAccount(almAccount);
                if (!PropertyValidator.isValid((Collection)almConfigs) && unMappedData.getId() != null) {
                    this.tfsWebhookRepository.delete((Serializable)((Object)unMappedData.getId()));
                    LOGGER.debug("------------------------------------------- WEBHOOK tfsWebhookRepository.delete(unMappedData.getId())  ----------------------");
                }
                if (!PropertyValidator.isValid((Collection)almConfigs)) {
                    this.tfsWebhookRepository.delete((Serializable)((Object)unMappedData.getId()));
                    LOGGER.debug("------------------------------------------- WEBHOOK tfsWebhookRepository.delete(unMappedData.getId())  ----------------------");
                    WebhookActivityUtil.getInstance().logActivity("No Alm configurations found, skipping webhook update.");
                    WebhookActivityUtil.getInstance().reset();
                    this.printLogs(unMappedData.getAlmAccountId(), executionLogs);
                    return;
                }
                ArrayList almConfigsIds = new ArrayList();
                almConfigs.stream().forEach(confi -> almConfigsIds.add(new ObjectId(confi.getId())));
                almAccount = ((TFSAlmConfigurations)almConfigs.get(0)).getAlmAccount();
                if (almAccount != null && almAccount.getTenant() != null) {
                    tenant = almAccount.getTenant();
                }
                if (!PropertyValidator.isValid((Object)almAccount)) {
                    this.tfsWebhookRepository.delete((Serializable)((Object)unMappedData.getId()));
                    LOGGER.debug("------------------------------------------- WEBHOOK tfsWebhookRepository.delete(unMappedData.getId())  ----------------------");
                    WebhookActivityUtil.getInstance().logActivity("Alm account not found from alm configs, skipping webhook update.");
                    WebhookActivityUtil.getInstance().reset();
                    this.printLogs(unMappedData.getAlmAccountId(), executionLogs);
                    return;
                }
                Item savedItem = null;
                Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (date, type, jsonSerializationContext) -> new JsonPrimitive((Number)date.getTime())).create();
                if (PropertyValidator.isValid((Collection)almConfigs)) {
                    KendisUtils.printLOG((String)("------------------------------------------- WEBHOOK DATA PROCESSING ALM Account ---------------------- :: " + unMappedData.getAlmAccountId()), (boolean)almAccount.isDebug());
                    KendisUtils.printLOG((String)"------------------------------------------- WEBHOOK Data inside almconfigs  ----------------------", (boolean)almAccount.isDebug());
                    ArrayList<String> sessionIds = new ArrayList<String>();
                    Query sessionQuery = new Query();
                    sessionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tfsAlmConfigurations.$id").in(almConfigsIds));
                    sessionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").in(new Object[]{false}));
                    sessionQuery.fields().include("title");
                    sessionQuery.fields().include("id");
                    sessionQuery.fields().include("activeSessionBoard");
                    sessionQuery.fields().include("startSprintWebhookEnabled");
                    sessionQuery.fields().include("endSprintWebhookEnabled");
                    sessionQuery.fields().include("startDateAction");
                    sessionQuery.fields().include("bucketEnabled");
                    sessionQuery.fields().include("buckets");
                    sessionQuery.fields().include("tfsAlmConfigurations");
                    sessionQuery.fields().include("excludeTfsStatuses");
                    sessionQuery.fields().include("excludeTfsItemTypes");
                    DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("session").find(sessionQuery.getQueryObject());
                    ArrayList<Session> sessions = new ArrayList<Session>();
                    boolean sessionCount = false;
                    while (dbCursorDomain.hasNext()) {
                        DBObject sessionObject = dbCursorDomain.next();
                        Session session = this.sessionFromDBObject(sessionObject);
                        sessions.add(session);
                    }
                    KendisUtils.printLOG((String)"------------------------------------------- findByTfsAlmConfigurationsInAndArchiveOrderByCreatedOn completed  ----------------------", (boolean)almAccount.isDebug());
                    ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                    ArrayList<String> sessionBoardIds = new ArrayList<String>();
                    HashMap<String, Session> sessionMapBySbId = new HashMap<String, Session>();
                    HashMap<String, String> checkedSessionBoards = new HashMap<String, String>();
                    if (PropertyValidator.isValid(sessions)) {
                        for (Session session : sessions) {
                            sessionIds.add(session.getId());
                            if (!PropertyValidator.isValid((Object)session.getActiveSessionBoard())) continue;
                            checkedSessionBoards.put(session.getActiveSessionBoard(), session.getActiveSessionBoard());
                            sessionBoardIds.add(session.getActiveSessionBoard());
                            sessionMapBySbId.put(session.getActiveSessionBoard(), session);
                            sessionBoards.add(new SessionBoard(session.getActiveSessionBoard()));
                        }
                        sessionIdsToCheckItemChanged = sessionBoards;
                    }
                    KendisUtils.printLOG((String)"------------------------------------------- after session loop completed  ----------------------", (boolean)almAccount.isDebug());
                    if (PropertyValidator.isValid(sessionBoardIds)) {
                        List sbs = this.sessionBoardRepository.findBoardsByIdIn(sessionBoardIds);
                        KendisUtils.printLOG((String)"------------------------------------------- after sessionBoardRepository.findByIdIn  ----------------------", (boolean)almAccount.isDebug());
                        HashMap<String, Object> openSessionBoardsMap = new HashMap<String, Object>();
                        if (PropertyValidator.isValid((Collection)sbs)) {
                            for (Object sb : sbs) {
                                Boolean isFinalState = sb.getState().getIsFinal();
                                if (isFinalState == null) {
                                    isFinalState = false;
                                }
                                if (isFinalState.booleanValue()) continue;
                                openSessionBoardsMap.put(sb.getId(), sb);
                            }
                        }
                        KendisUtils.printLOG((String)"------------------------------------------- after openSessionBoardsMap  ----------------------", (boolean)almAccount.isDebug());
                        ArrayList<SessionBoard> openSessionBoards = new ArrayList<SessionBoard>();
                        for (SessionBoard sb : sessionBoards) {
                            if (!openSessionBoardsMap.containsKey(sb.getId())) continue;
                            openSessionBoards.add(sb);
                        }
                        sessionBoards = openSessionBoards;
                    }
                    KendisUtils.printLOG((String)"------------------------------------------- after openSessionBoardsMap  ----------------------", (boolean)almAccount.isDebug());
                    KendisUtils.printLOG((String)"------------------------------------------- WEBHOOK Data SessionBoards Fetched ----------------------", (boolean)almAccount.isDebug());
                    List items = new ArrayList();
                    List statuses = this.statusRepository.findBySessionIdIn(sessionIds);
                    HashMap statusMap = this.getStatusesMap(statuses);
                    KendisUtils.printLOG((String)"------------------------------------------- WEBHOOK Data Status Map Created ----------------------", (boolean)almAccount.isDebug());
                    HashMap<String, Object> extraFields = new HashMap<String, Object>();
                    extraFields.put("statusMap", statusMap);
                    String activityId = unMappedData.getActivityId();
                    JSONObject tfsPayLoad = unMappedData.payload();
                    String eventType = "";
                    if (tfsPayLoad.has("eventType")) {
                        eventType = tfsPayLoad.getString("eventType");
                    }
                    JSONObject tfsItemObject = tfsPayLoad.getJSONObject("resource");
                    String cid = this.companyRepository.findByTenant(almAccount.getTenant()).getId();
                    if (!tfsItemObject.isNull("workItemId")) {
                        tfsId = tfsItemObject.getString("workItemId");
                    } else if (!tfsItemObject.isNull("id")) {
                        tfsId = tfsItemObject.getString("id");
                    }
                    executionLogs.add("[TFS:" + tfsId + "|TENANT:" + tenant + "] in processing webhook");
                    List syncMappers = null;
                    HashMap<String, TFSTeamMapping> tfsTeamMapping = null;
                    KendisUtils.printLOG((String)("------------------------------------------- WEBHOOK Data EVENT TYPE ---------------------- " + eventType), (boolean)almAccount.isDebug());
                    HashMap<String, Boolean> itemFoundSessionBoard = new HashMap<String, Boolean>();
                    if (eventType.equals("workitem.updated") && PropertyValidator.isValid(items = this.itemRepository.findByTfsIdAndSessionBoardsInAndTenantAndArchive(tfsId, sessionBoards, almAccount.getTenant(), false))) {
                        for (Item item : items) {
                            if (!PropertyValidator.isValid((Object)item.getType()) || !item.getType().equals(Item.USER_STORY)) continue;
                            itemFoundSessionBoard.put(((SessionBoard)item.getSessionBoards().get(0)).getId(), true);
                            checkedSessionBoards.remove(((SessionBoard)item.getSessionBoards().get(0)).getId());
                        }
                    }
                    if (eventType.equals("workitem.created") || eventType.equals("workitem.updated") && !checkedSessionBoards.isEmpty()) {
                        JSONObject tfsFields = null;
                        if (!tfsItemObject.isNull("revision")) {
                            JSONObject tfsItemRevision = tfsItemObject.getJSONObject("revision");
                            if (!tfsItemRevision.isNull("fields")) {
                                tfsFields = tfsItemRevision.getJSONObject("fields");
                            }
                        } else if (!tfsItemObject.isNull("fields")) {
                            tfsFields = tfsItemObject.getJSONObject("fields");
                        }
                        if (tfsFields != null) {
                            Iterator relationsAddedObj;
                            Double sysSequence = new Double(System.nanoTime() / 100000L);
                            extraFields = new HashMap();
                            extraFields.put("sequence", sysSequence);
                            extraFields.put("statusMap", statusMap);
                            extraFields.put("type", Item.USER_STORY.toString());
                            String parentId = null;
                            if (!tfsItemObject.isNull("relations") && (relationsAddedObj = tfsItemObject.get("relations")) instanceof JSONArray) {
                                JSONArray relationsAdded = (JSONArray)relationsAddedObj;
                                for (int i = 0; i < relationsAdded.length(); ++i) {
                                    try {
                                        JSONObject newAddedObject = relationsAdded.getJSONObject(i);
                                        String rel = newAddedObject.getString("rel");
                                        String url = newAddedObject.getString("url");
                                        String newAddedTFSId = url.substring(url.lastIndexOf("/") + 1);
                                        if (!rel.equals("System.LinkTypes.Hierarchy-Reverse")) continue;
                                        parentId = newAddedTFSId;
                                        continue;
                                    }
                                    catch (Exception e) {
                                        StringWriter sw = new StringWriter();
                                        PrintWriter pw = new PrintWriter(sw);
                                        e.printStackTrace(pw);
                                        String sStackTrace = sw.toString();
                                        logs.add(" ::  Exception ..  " + sStackTrace);
                                    }
                                }
                            }
                            if (parentId == null) {
                                for (SessionBoard sessionBoard : sessionBoards) {
                                    Item bucketItem;
                                    Boolean isFoundInMap = (Boolean)itemFoundSessionBoard.get(sessionBoard.getId());
                                    if (isFoundInMap == null) {
                                        isFoundInMap = false;
                                    }
                                    if (isFoundInMap.booleanValue()) continue;
                                    Session session = (Session)sessionMapBySbId.get(sessionBoard.getId());
                                    extraFields.put("sessionId", session.getId());
                                    List tfsProjects = this.tfsProjectRepository.findProjectBySessionId(session.getId());
                                    HashMap<String, TFSProject> tfsProjectsMap = new HashMap<String, TFSProject>();
                                    HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
                                    if (PropertyValidator.isValid((Collection)tfsProjects)) {
                                        for (TFSProject tfsProject : tfsProjects) {
                                            tfsProjectsMap.put(tfsProject.getTfsId(), tfsProject);
                                            tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
                                        }
                                    }
                                    String iterationPath = (String)tfsFields.get("System.IterationPath");
                                    String areaPath = (String)tfsFields.get("System.AreaPath");
                                    Item newItem = this.getKendisItemFromTFSItem(tfsItemObject, tfsFields, extraFields, tfsProjectsMap, tfsProjectsMapByName);
                                    newItem.setTfsAreaPath(areaPath);
                                    newItem.setTfsIterationPath(iterationPath);
                                    boolean isValid = this.isItemValidToAddForSession(newItem, session);
                                    if (!isValid || !PropertyValidator.isValid((Object)newItem.getTfsProject()) || !PropertyValidator.isValid((Object)newItem.getTfsIterationPath()) || newItem.getTfsIterationPath().equals(newItem.getTfsProject()) || !PropertyValidator.isValid((Object)(bucketItem = this.handleBucketAssignmentOnParentRemoval(newItem, session, almAccount)))) continue;
                                    tfsTeamMapping = new HashMap();
                                    TFSAlmConfigurations tfsAlmConfigurations = this.customRepository.findTeamMappingByConfigurationId(session.getTfsAlmConfigurations().getId());
                                    if (PropertyValidator.isValid((Object)tfsAlmConfigurations) && PropertyValidator.isValid((Collection)tfsAlmConfigurations.getTeamMappings())) {
                                        for (TFSTeamMapping mappedTeam : tfsAlmConfigurations.getTeamMappings()) {
                                            tfsTeamMapping.put(mappedTeam.getKendisTeamId(), mappedTeam);
                                        }
                                    }
                                    syncMappers = this.customRepositoryImpl.findItemSyncMapperBySessionBoard(sessionBoard, almAccount.getTenant());
                                    newItem.setTenant(almAccount.getTenant());
                                    newItem.setType(Item.USER_STORY);
                                    newItem.setParent(bucketItem);
                                    newItem.setSessionBoards(Arrays.asList(sessionBoard));
                                    newItem.setTeamContainers(new ArrayList());
                                    this.mapItemFromItemSyncMapper(newItem, bucketItem, syncMappers, iterationPath, areaPath, tfsTeamMapping, almConfigs, session);
                                    newItem.setCreatedOn(new Date());
                                    newItem.setSource(1);
                                    newItem.setWebHookActivityBy("Via Webhook");
                                    if (!PropertyValidator.isValid((Collection)newItem.getTeamContainers())) continue;
                                    List<String> itemsTfsIds = Arrays.asList(newItem.getTfsId());
                                    Query query = new Query();
                                    query.fields().include("tfsId");
                                    query.fields().include("sessionBoards");
                                    query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"tfsId").in(itemsTfsIds), Criteria.where((String)"archive").is((Object)false), Criteria.where((String)"sessionBoards.$id").in(Arrays.asList(new ObjectId(sessionBoard.getId())))}));
                                    DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("item").find(query.getQueryObject());
                                    if (dbCursorPrefix.size() > 0) continue;
                                    this.itemRepository.save((Object)newItem);
                                    this.itemRepository.save((Object)bucketItem);
                                    PushSender.sendMsg((String)cid, (String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)bucketItem, (String)((SessionBoard)bucketItem.getSessionBoards().get(0)).getId(), (String)"TFSWebHookItemUpdated", Arrays.asList(newItem), Arrays.asList(new Item[0]), Arrays.asList(new Item[0]), Arrays.asList(new ItemJiraDependency[0]), Arrays.asList(new ItemJiraDependency[0]), (Gson)gsonExclusive, null));
                                }
                            }
                        }
                    }
                    if (eventType.equals("workitem.updated")) {
                        if (PropertyValidator.isValid((Object)almAccount.getTestingWebhookForTFS())) {
                            Map webhookMap = almAccount.getTestingWebhookForTFS();
                            String boardId = (String)webhookMap.get(tfsId);
                            almAccount.setTestingWebhookForTFS(null);
                            this.almAccountRepository.save((Object)almAccount);
                            String event = "TestingWebhookForTFS";
                            JSONObject pushJson = new JSONObject();
                            JSONObject pushItemJson = new JSONObject();
                            JSONObject tfsFields = tfsItemObject.getJSONObject("fields");
                            JSONObject title = tfsFields.getJSONObject("System.Title");
                            pushItemJson.put("id", (Object)tfsId);
                            pushItemJson.put("title", (Object)title);
                            pushJson.put("isTFS", true);
                            pushJson.put("boardId", (Object)boardId);
                            pushJson.put("item", (Object)pushItemJson);
                            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"boardId\":\"" + boardId + "\", \"isTFS\":" + Boolean.TRUE + "}"));
                            String pushJsonString = pushJson.toString();
                            PushSender.sendMsg((String)cid, (String)pushJsonString);
                        }
                        items = this.itemRepository.findByTfsIdAndSessionBoardsInAndTenantAndArchive(tfsId, sessionBoards, almAccount.getTenant(), false);
                        KendisUtils.printLOG((String)"------------------------------------------- WEBHOOK Data Items Listed ---------------------- ", (boolean)almAccount.isDebug());
                    }
                    if (eventType.equals("workitem.deleted")) {
                        items = this.itemRepository.findByTfsIdAndSessionBoardsInAndTenantAndArchive(tfsId, sessionBoards, almAccount.getTenant(), false);
                    }
                    List existingChildsUpdated = null;
                    List existingChildsRemoved = null;
                    List newChildsAdded = null;
                    KendisUtils.printLOG((String)("------------------------------------------- WEBHOOK Data Items PROCESSING For ---------------------- :: " + cid), (boolean)almAccount.isDebug());
                    String almRevision = tfsItemObject.getString("rev");
                    if (PropertyValidator.isValid(items)) {
                        WebhookActivityUtil.getInstance().logActivity("Found items to settle for work item update event.");
                    } else {
                        WebhookActivityUtil.getInstance().addOneTfsCausedBy("No items found to settle for work item update event.");
                    }
                    HashMap<String, String> fieldsChangesMap = new HashMap<String, String>();
                    if (tfsItemObject.keySet().contains("fields")) {
                        JSONObject myTfsFields = tfsItemObject.getJSONObject("fields");
                        for (Object key : myTfsFields.keySet()) {
                            String keyStr = (String)key;
                            fieldsChangesMap.put(keyStr, keyStr);
                        }
                    }
                    int itemProcessCount = 0;
                    for (Item item : items) {
                        ++itemProcessCount;
                        KendisUtils.printLOG((String)"------------------------------------------- WEBHOOK Data PER Item Exec ---------------------- ", (boolean)almAccount.isDebug());
                        KendisUtils.printLOG((String)("#### Item Id :: " + item.getTfsId()), (boolean)almAccount.isDebug());
                        KendisUtils.printLOG((String)("#### Item Project :: " + item.getTfsProject()), (boolean)almAccount.isDebug());
                        Status oldStatus = null;
                        List tfsProjects = null;
                        ArrayList<ItemJiraDependency> newTFSDependencies = new ArrayList<ItemJiraDependency>();
                        ArrayList removedTFSDependencies = new ArrayList();
                        syncMappers = null;
                        String parentIdToCheckForRemoveEmpty = null;
                        if (eventType.equals("workitem.deleted")) {
                            WebhookActivityUtil.getInstance().logActivity("workitem.deleted event matched");
                            item.setArchive(true);
                            item.setSource(1);
                            item.setWebHookActivityBy("Via Webhook");
                            if (Item.FEATURE.equalsIgnoreCase(item.getType())) {
                                this.customRepository.setBulkArchiveUserStoriesByParent(item, true);
                            } else {
                                List childItems = this.itemRepository.findByParentId(item.getParent().getId());
                                Double totalEstimate = 0.0;
                                for (Item childItem : childItems) {
                                    totalEstimate = totalEstimate + childItem.getStoryPoints();
                                }
                                this.customRepository.updateItemStoryPoints(item.getParent().getId(), totalEstimate);
                            }
                            savedItem = (Item)this.itemRepository.save((Object)item);
                            WebhookActivityUtil.getInstance().logActivity("Item saved successfully");
                            PushSender.sendMsg((String)cid, (String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)savedItem, (String)((SessionBoard)savedItem.getSessionBoards().get(0)).getId(), (String)"TFSWebHookItemDeleted", newChildsAdded, existingChildsUpdated, existingChildsRemoved, null, null, (Gson)gsonExclusive, null));
                        }
                        if (eventType.equals("workitem.updated")) {
                            Session session;
                            KendisUtils.printLOG((String)"### INSIDE  workitem.updated", (boolean)almAccount.isDebug());
                            WebhookActivityUtil.getInstance().logActivity("workitem.updated matched against event type.");
                            if (tfsItemObject.keySet().contains("fields")) {
                                JSONObject myTfsFields = tfsItemObject.getJSONObject("fields");
                                HashMap<String, Object> newValueFields = new HashMap<String, Object>();
                                for (Object key : myTfsFields.keySet()) {
                                    String keyStr = (String)key;
                                    JSONObject value = (JSONObject)myTfsFields.get(keyStr);
                                    if (!value.keySet().contains("newValue") || value.get("newValue") == null) continue;
                                    newValueFields.put(keyStr, value.get("newValue"));
                                }
                                this.scoreCardService.updateScorecardFieldsAccordingToMappedFields(((SessionBoard)item.getSessionBoards().get(0)).getSession(), item, newValueFields);
                            }
                            oldStatus = item.getStatus();
                            tfsTeamMapping = new HashMap<String, TFSTeamMapping>();
                            if (PropertyValidator.isValid((Object)((SessionBoard)item.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)((SessionBoard)item.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getTeamMappings())) {
                                for (TFSTeamMapping mappedTeam : ((SessionBoard)item.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getTeamMappings()) {
                                    tfsTeamMapping.put(mappedTeam.getKendisTeamId(), mappedTeam);
                                }
                            }
                            KendisUtils.printLOG((String)"### TFS MAPPINGS Listed", (boolean)almAccount.isDebug());
                            if (!tfsItemObject.isNull("relations")) {
                                String sStackTrace;
                                PrintWriter pw;
                                StringWriter sw;
                                String url;
                                String rel;
                                String removedTFSId;
                                JSONObject removedObject;
                                Object bucketItem;
                                String sStackTrace2;
                                Iterator pw2;
                                Object sw2;
                                String newAddedTFSId;
                                String url2;
                                String rel2;
                                JSONObject newAddedObject;
                                syncMappers = this.customRepositoryImpl.findItemSyncMapperBySessionBoard((SessionBoard)item.getSessionBoards().get(0), ((SessionBoard)item.getSessionBoards().get(0)).getTenant());
                                tfsProjects = this.tfsProjectRepository.findProjectBySessionId(((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
                                HashMap<String, TFSProject> tfsProjectsMap = new HashMap<String, TFSProject>();
                                HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
                                if (PropertyValidator.isValid((Collection)tfsProjects)) {
                                    for (TFSProject tfsProject : tfsProjects) {
                                        tfsProjectsMap.put(tfsProject.getTfsId(), tfsProject);
                                        tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
                                    }
                                }
                                KendisUtils.printLOG((String)"### TFS PROJECTS LISTED ", (boolean)almAccount.isDebug());
                                JSONObject relationsObject = tfsItemObject.getJSONObject("relations");
                                if (!(relationsObject.isNull("added") || PropertyValidator.isValid((Object)item.getParent()) && PropertyValidator.isValid((Object)item.getParent().getId()))) {
                                    KendisUtils.printLOG((String)"### relationsObject Added ", (boolean)almAccount.isDebug());
                                    JSONArray relationsAdded = relationsObject.getJSONArray("added");
                                    HashSet<String> newAddedTfsIds = new HashSet<String>();
                                    for (int i = 0; i < relationsAdded.length(); ++i) {
                                        try {
                                            newAddedObject = relationsAdded.getJSONObject(i);
                                            rel2 = newAddedObject.getString("rel");
                                            url2 = newAddedObject.getString("url");
                                            newAddedTFSId = url2.substring(url2.lastIndexOf("/") + 1);
                                            if (item.getTfsLinkTypes().indexOf(rel2) <= -1) continue;
                                            newAddedTfsIds.add(newAddedTFSId);
                                            continue;
                                        }
                                        catch (Exception e) {
                                            sw2 = new StringWriter();
                                            pw2 = new PrintWriter((Writer)sw2);
                                            e.printStackTrace((PrintWriter)((Object)pw2));
                                            sStackTrace2 = ((StringWriter)sw2).toString();
                                            logs.add(" ::  Exception ..  " + sStackTrace2);
                                        }
                                    }
                                    if (PropertyValidator.isValid(newAddedTfsIds)) {
                                        KendisUtils.printLOG((String)"### newAddedTfsIds ", (boolean)almAccount.isDebug());
                                        List existingChildItems = this.itemRepository.findByTfsIdInAndSessionBoardsInAndTenantAndArchive(newAddedTfsIds, item.getSessionBoards(), almAccount.getTenant(), false);
                                        HashSet<String> existingItemIds = new HashSet<String>();
                                        if (PropertyValidator.isValid((Collection)existingChildItems)) {
                                            Session session2 = (Session)sessionMapBySbId.get(((SessionBoard)item.getSessionBoards().get(0)).getId());
                                            for (Item it2 : existingChildItems) {
                                                bucketItem = this.handleBucketAssignmentOnParentRemoval(it2, session2, almAccount);
                                                it2.setParent(item);
                                                this.mapItemFromItemSyncMapper(it2, item, syncMappers, it2.getTfsIterationPath(), it2.getTfsAreaPath(), tfsTeamMapping, almConfigs, (Session)sessionMapBySbId.get(((SessionBoard)item.getSessionBoards().get(0)).getId()));
                                                existingItemIds.add(it2.getTfsId());
                                                it2.setSource(1);
                                                it2.setWebHookActivityBy("Via Webhook");
                                                if (bucketItem == null) continue;
                                                PushSender.sendMsg((String)cid, (String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)bucketItem, (String)((SessionBoard)bucketItem.getSessionBoards().get(0)).getId(), (String)"TFSWebHookItemUpdated", new ArrayList(), new ArrayList(), Arrays.asList(it2), new ArrayList(), new ArrayList(), (Gson)gsonExclusive, null));
                                            }
                                            newChildsAdded = this.itemRepository.save((Iterable)existingChildItems);
                                            KendisUtils.printLOG((String)"### existingChildItems saved ", (boolean)almAccount.isDebug());
                                        }
                                        Sets.SetView missingItemIds = Sets.difference(newAddedTfsIds, existingItemIds);
                                        ArrayList<Item> missingItems = new ArrayList<Item>();
                                        HashSet<String> uniqeTFSIds = new HashSet<String>();
                                        if (PropertyValidator.isValid((Collection)missingItemIds)) {
                                            try {
                                                String idsChildStr = String.join((CharSequence)",", (Iterable<? extends CharSequence>)missingItemIds);
                                                KendisUtils.printLOG((String)"### fetching missing childs", (boolean)almAccount.isDebug());
                                                String childItemsStr = "";
                                                if (PropertyValidator.isValid((Object)item.getFetchedBy())) {
                                                    AlmAccount taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)item.getFetchedBy(), (AlmAccount)almAccount);
                                                    childItemsStr = this.tfsUtils.getItems("1", idsChildStr, taggedAlmAccount);
                                                } else {
                                                    almAccount.setIsTaggedUser(Boolean.valueOf(true));
                                                    childItemsStr = this.tfsUtils.getItems("1", idsChildStr, almAccount);
                                                }
                                                JSONObject dataObjects = new JSONObject(childItemsStr);
                                                String count = dataObjects.getString("count");
                                                JSONArray itemsArray = dataObjects.getJSONArray("value");
                                                Double sysSequence = new Double(System.nanoTime() / 100000L);
                                                extraFields = new HashMap();
                                                extraFields.put("sequence", sysSequence);
                                                extraFields.put("statusMap", statusMap);
                                                extraFields.put("type", Item.USER_STORY.toString());
                                                extraFields.put("sessionId", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
                                                for (int i = 0; i < itemsArray.length(); ++i) {
                                                    try {
                                                        JSONObject itemObject = itemsArray.getJSONObject(i);
                                                        JSONObject tfsFields = itemObject.getJSONObject("fields");
                                                        String iterationPath = (String)tfsFields.get("System.IterationPath");
                                                        String areaPath = (String)tfsFields.get("System.AreaPath");
                                                        Item missingItem = this.getKendisItemFromTFSItem(itemObject, tfsFields, extraFields, tfsProjectsMap, tfsProjectsMapByName);
                                                        Session currentSession = (Session)sessionMapBySbId.get(((SessionBoard)item.getSessionBoards().get(0)).getId());
                                                        boolean isValid = this.isItemValidToAddForSession(missingItem, currentSession);
                                                        if (!isValid) continue;
                                                        if (((SessionBoard)item.getSessionBoards().get(0)).getSession().getTeamFieldEnable().booleanValue()) {
                                                            areaPath = (String)tfsFields.get(((SessionBoard)item.getSessionBoards().get(0)).getSession().getTeamFieldTeamRefrence());
                                                            missingItem.setTfsAreaPath(areaPath);
                                                        }
                                                        missingItem.setTenant(almAccount.getTenant());
                                                        missingItem.setType(Item.USER_STORY);
                                                        missingItem.setTfsFilter(item.getTfsFilter());
                                                        missingItem.setParent(item);
                                                        missingItem.setSessionBoards(item.getSessionBoards());
                                                        if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                                                            item.setTeamContainers(new ArrayList());
                                                        }
                                                        missingItem.setTeamContainers(new ArrayList());
                                                        this.mapItemFromItemSyncMapper(missingItem, item, syncMappers, iterationPath, areaPath, tfsTeamMapping, almConfigs, (Session)sessionMapBySbId.get(((SessionBoard)item.getSessionBoards().get(0)).getId()));
                                                        missingItem.setCreatedOn(new Date());
                                                        missingItem.setSource(1);
                                                        missingItem.setWebHookActivityBy("Via Webhook");
                                                        if (uniqeTFSIds.contains(missingItem.getTfsId())) continue;
                                                        uniqeTFSIds.add(missingItem.getTfsId());
                                                        missingItems.add(missingItem);
                                                        continue;
                                                    }
                                                    catch (JSONException e1) {
                                                        StringWriter sw3 = new StringWriter();
                                                        PrintWriter pw3 = new PrintWriter(sw3);
                                                        e1.printStackTrace(pw3);
                                                        String sStackTrace3 = sw3.toString();
                                                        logs.add(" :: JSON Exception ..  " + sStackTrace3);
                                                    }
                                                }
                                            }
                                            catch (Exception e) {
                                                StringWriter sw4 = new StringWriter();
                                                PrintWriter pw4 = new PrintWriter(sw4);
                                                e.printStackTrace(pw4);
                                                String sStackTrace4 = sw4.toString();
                                                logs.add(" :: Exception while conversiion ..  " + sStackTrace4);
                                            }
                                            if (PropertyValidator.isValid(missingItems)) {
                                                List missingItemsTfsIds = missingItems.stream().map(_item -> _item.getTfsId()).collect(Collectors.toList());
                                                Query query = new Query();
                                                query.fields().include("tfsId");
                                                query.fields().include("sessionBoards");
                                                query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"tfsId").in(missingItemsTfsIds), Criteria.where((String)"archive").is((Object)false), Criteria.where((String)"sessionBoards.$id").in(Arrays.asList(new ObjectId(((SessionBoard)item.getSessionBoards().get(0)).getId())))}));
                                                DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("item").find(query.getQueryObject());
                                                if (dbCursorPrefix.size() > 0) {
                                                    while (dbCursorPrefix.hasNext()) {
                                                        DBObject itemObj = dbCursorPrefix.next();
                                                        if (!itemObj.containsField("tfsId")) continue;
                                                        String _tfsId = (String)itemObj.get("tfsId");
                                                        missingItems.removeIf(it -> it.getTfsId().equals(_tfsId));
                                                    }
                                                }
                                                if (PropertyValidator.isValid(missingItems)) {
                                                    newChildsAdded = this.itemRepository.save(missingItems);
                                                    KendisUtils.printLOG((String)"### missing items saved ", (boolean)almAccount.isDebug());
                                                }
                                            }
                                        }
                                    } else {
                                        WebhookActivityUtil.getInstance().addOneTfsCausedBy("No new TFS ID found from webhook.");
                                    }
                                }
                                if (!(relationsObject.isNull("removed") || PropertyValidator.isValid((Object)item.getParent()) && PropertyValidator.isValid((Object)item.getParent().getId()))) {
                                    KendisUtils.printLOG((String)"### inside relationsObject removed", (boolean)almAccount.isDebug());
                                    JSONArray relationsRemoved = relationsObject.getJSONArray("removed");
                                    HashSet<String> removedTfsIds = new HashSet<String>();
                                    for (int i = 0; i < relationsRemoved.length(); ++i) {
                                        try {
                                            removedObject = relationsRemoved.getJSONObject(i);
                                            rel2 = removedObject.getString("rel");
                                            url2 = removedObject.getString("url");
                                            removedTFSId = url2.substring(url2.lastIndexOf("/") + 1);
                                            if (item.getTfsLinkTypes().indexOf(rel2) <= -1) continue;
                                            removedTfsIds.add(removedTFSId);
                                            continue;
                                        }
                                        catch (Exception e) {
                                            sw2 = new StringWriter();
                                            pw2 = new PrintWriter((Writer)sw2);
                                            e.printStackTrace((PrintWriter)((Object)pw2));
                                            sStackTrace2 = ((StringWriter)sw2).toString();
                                            logs.add(" ::  Exception ..  " + sStackTrace2);
                                        }
                                    }
                                    if (PropertyValidator.isValid(removedTfsIds)) {
                                        ArrayList parentChangeTfsIds = new ArrayList(removedTfsIds);
                                        List existingChildItemsToBeRemoved = this.itemRepository.findByTfsIdInAndSessionBoardsInAndParentAndTenantAndArchive(removedTfsIds, item.getSessionBoards(), item, almAccount.getTenant(), false);
                                        if (PropertyValidator.isValid((Collection)existingChildItemsToBeRemoved)) {
                                            for (Item childItem : existingChildItemsToBeRemoved) {
                                                parentIdToCheckForRemoveEmpty = childItem.getParent().getId();
                                                parentChangeTfsIds.remove(childItem.getTfsId());
                                                session = (Session)sessionMapBySbId.get(((SessionBoard)item.getSessionBoards().get(0)).getId());
                                                bucketItem = this.handleBucketAssignmentOnParentRemoval(childItem, session, almAccount);
                                                if (bucketItem != null) {
                                                    childItem.setTeamContainers(new ArrayList());
                                                    this.mapItemFromItemSyncMapper(childItem, (Item)bucketItem, syncMappers, childItem.getTfsIterationPath(), childItem.getTfsAreaPath(), tfsTeamMapping, almConfigs, session);
                                                    if (PropertyValidator.isValid((Collection)childItem.getTeamContainers())) {
                                                        childItem.setParent((Item)bucketItem);
                                                        this.itemRepository.save(bucketItem);
                                                        ArrayList<Item> _childrenAdded = new ArrayList<Item>();
                                                        _childrenAdded.add(childItem);
                                                        PushSender.sendMsg((String)cid, (String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)bucketItem, (String)((SessionBoard)bucketItem.getSessionBoards().get(0)).getId(), (String)"TFSWebHookItemUpdated", _childrenAdded, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (Gson)gsonExclusive, null));
                                                        continue;
                                                    }
                                                    childItem.setArchive(Boolean.TRUE.booleanValue());
                                                    childItem.setSource(1);
                                                    childItem.setWebHookActivityBy("Via Webhook");
                                                    continue;
                                                }
                                                childItem.setArchive(Boolean.TRUE.booleanValue());
                                                childItem.setSource(1);
                                                childItem.setWebHookActivityBy("Via Webhook");
                                            }
                                            existingChildsRemoved = this.itemRepository.save((Iterable)existingChildItemsToBeRemoved);
                                            KendisUtils.printLOG((String)"### existingChildsRemoved ", (boolean)almAccount.isDebug());
                                        } else {
                                            WebhookActivityUtil.getInstance().addOneTfsCausedBy("No existing items found to be removed.");
                                        }
                                        if (PropertyValidator.isValid(parentChangeTfsIds)) {
                                            HashSet set = new HashSet(parentChangeTfsIds);
                                            List parentRemovedItems = this.itemRepository.findByTfsIdInAndSessionBoardsInAndTenantAndArchive(set, item.getSessionBoards(), almAccount.getTenant(), false);
                                            if (PropertyValidator.isValid((Collection)parentRemovedItems)) {
                                                session = (Session)sessionMapBySbId.get(((SessionBoard)item.getSessionBoards().get(0)).getId());
                                                for (Item parentRemovedItem : parentRemovedItems) {
                                                    parentIdToCheckForRemoveEmpty = parentRemovedItem.getParent().getId();
                                                    parentRemovedItem.setParent(null);
                                                }
                                                this.itemRepository.save((Iterable)parentRemovedItems);
                                            }
                                            existingChildsRemoved = parentRemovedItems;
                                            KendisUtils.printLOG((String)"### existingChildsRemoved parentChangeTfsIds", (boolean)almAccount.isDebug());
                                        }
                                    } else {
                                        WebhookActivityUtil.getInstance().addOneTfsCausedBy("No TFS ID to remove found from webhook.");
                                    }
                                }
                                if (!relationsObject.isNull("removed") && item.getType().equals(Item.FEATURE) && PropertyValidator.isValid((Object)item.getTfsFieldByKey()) && item.getTfsFieldByKey().containsKey("ParentId")) {
                                    JSONArray relationsRemoved = relationsObject.getJSONArray("removed");
                                    for (int i = 0; i < relationsRemoved.length(); ++i) {
                                        try {
                                            JSONObject removedObject2 = relationsRemoved.getJSONObject(i);
                                            rel = removedObject2.getString("rel");
                                            url = removedObject2.getString("url");
                                            String removedTFSId2 = url.substring(url.lastIndexOf("/") + 1);
                                            if (!rel.equals("System.LinkTypes.Hierarchy-Reverse")) continue;
                                            item.getTfsFieldByKey().remove("ParentId");
                                            item.getTfsFieldByKey().remove("ParentTitle");
                                            item.getTfsFieldByKey().remove("ParentIcon");
                                            item.getTfsFieldByKey().remove("ParentURL");
                                            break;
                                        }
                                        catch (Exception e) {
                                            sw = new StringWriter();
                                            pw = new PrintWriter(sw);
                                            e.printStackTrace(pw);
                                            sStackTrace = sw.toString();
                                            logs.add(" ::  Exception ..  " + sStackTrace);
                                        }
                                    }
                                }
                                if (!relationsObject.isNull("added") && item.getType().equals(Item.FEATURE)) {
                                    JSONArray relationsAdded = relationsObject.getJSONArray("added");
                                    for (int i = 0; i < relationsAdded.length(); ++i) {
                                        try {
                                            JSONObject addedObject = relationsAdded.getJSONObject(i);
                                            rel = addedObject.getString("rel");
                                            url = addedObject.getString("url");
                                            String addedTFSId = url.substring(url.lastIndexOf("/") + 1);
                                            if (!rel.equals("System.LinkTypes.Hierarchy-Reverse")) continue;
                                            if (item.getTfsFieldByKey() == null) {
                                                item.setTfsFieldByKey(new HashMap());
                                            }
                                            item.getTfsFieldByKey().put("ParentId", addedTFSId);
                                            String idsChildStr = addedTFSId;
                                            String childItemsStr = null;
                                            if (PropertyValidator.isValid((Object)item.getFetchedBy())) {
                                                AlmAccount taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)item.getFetchedBy(), (AlmAccount)almAccount);
                                                childItemsStr = this.tfsUtils.getItems("1", idsChildStr, taggedAlmAccount);
                                            } else {
                                                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                                                childItemsStr = this.tfsUtils.getItems("1", idsChildStr, almAccount);
                                            }
                                            JSONObject _dataObjects = new JSONObject(childItemsStr);
                                            String _count = _dataObjects.getString("count");
                                            JSONArray _itemsArray = _dataObjects.getJSONArray("value");
                                            for (int j = 0; j < _itemsArray.length(); ++j) {
                                                JSONObject itemObject = _itemsArray.getJSONObject(j);
                                                JSONObject tfsFields = itemObject.getJSONObject("fields");
                                                String title = (String)tfsFields.get("System.Title");
                                                String workItemType = (String)tfsFields.get("System.WorkItemType");
                                                String _url = null;
                                                if (!itemObject.isNull("_links")) {
                                                    JSONObject links = itemObject.getJSONObject("_links");
                                                    JSONObject linkHTML = links.getJSONObject("html");
                                                    _url = linkHTML.getString("href");
                                                }
                                                item.getTfsFieldByKey().put("ParentTitle", title);
                                                item.getTfsFieldByKey().put("ParentURL", _url);
                                                TFSProject tfsProject = (TFSProject)tfsProjectsMap.get(item.getTfsProjectId());
                                                if (!PropertyValidator.isValid((Object)tfsProject)) continue;
                                                String itemTypeIconUrl = (String)tfsProject.getIconByItemType().get(workItemType);
                                                item.getTfsFieldByKey().put("ParentIcon", itemTypeIconUrl);
                                            }
                                            break;
                                        }
                                        catch (Exception e) {
                                            sw = new StringWriter();
                                            pw = new PrintWriter(sw);
                                            e.printStackTrace(pw);
                                            sStackTrace = sw.toString();
                                            logs.add(" ::  Exception ..  " + sStackTrace);
                                        }
                                    }
                                }
                                if (!relationsObject.isNull("added") && PropertyValidator.isValid((Collection)((SessionBoard)item.getSessionBoards().get(0)).getSession().getJiraLinkTypes())) {
                                    KendisUtils.printLOG((String)"### !relationsObject.isNull(\"added\")", (boolean)almAccount.isDebug());
                                    JSONArray relationsAdded = relationsObject.getJSONArray("added");
                                    HashSet<String> newAddedTfsIds = new HashSet<String>();
                                    WebhookActivityUtil.getInstance().putInConditionChecker("item.getSessionBoards().get(0).getSession().getJiraLinkTypes().indexOf(rel) > -1", false);
                                    for (int i = 0; i < relationsAdded.length(); ++i) {
                                        try {
                                            newAddedObject = relationsAdded.getJSONObject(i);
                                            rel2 = newAddedObject.getString("rel");
                                            String relURL = newAddedObject.getString("url");
                                            newAddedTFSId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                            KendisUtils.printLOG((String)("### newAddedTFSId :: " + newAddedTFSId), (boolean)almAccount.isDebug());
                                            if (((SessionBoard)item.getSessionBoards().get(0)).getSession().getJiraLinkTypes().indexOf(rel2) <= -1) continue;
                                            WebhookActivityUtil.getInstance().putInConditionChecker("item.getSessionBoards().get(0).getSession().getJiraLinkTypes().indexOf(rel) > -1", true);
                                            newAddedTfsIds.add(newAddedTFSId);
                                            ItemJiraDependency tfsDependency = new ItemJiraDependency();
                                            if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
                                                tfsDependency.setSessionBoardId(((SessionBoard)item.getSessionBoards().get(0)).getId());
                                            }
                                            tfsDependency.setIsTFS(Boolean.valueOf(true));
                                            tfsDependency.setSourceItemId(item.getId());
                                            Item targetItem = this.itemRepository.findTFSIdBySessionBoardsIdInAndTfsIdAndTenantAndArchive(((SessionBoard)item.getSessionBoards().get(0)).getId(), newAddedTFSId, almAccount.getTenant(), false);
                                            if (PropertyValidator.isValid((Object)targetItem)) {
                                                tfsDependency.setTargetItemId(targetItem.getId());
                                            }
                                            String targetItemURL = relURL.replace("_apis/wit/workItems", "_workitems/edit");
                                            String sourceItemStatus = null;
                                            if (PropertyValidator.isValid((Object)item.getStatus())) {
                                                sourceItemStatus = item.getStatus().getTitle();
                                            }
                                            TFSIssue tfsSourceIssue = new TFSIssue(item.getTfsId(), item.getTitle(), sourceItemStatus, item.getTfsURL(), item.getTfsApiURL());
                                            TFSIssue tfsTargetIssue = new TFSIssue(newAddedTFSId, null, null, targetItemURL, relURL);
                                            tfsDependency.setSourceTFSItem(tfsSourceIssue);
                                            tfsDependency.setTargetTFSItem(tfsTargetIssue);
                                            tfsDependency.setTenant(almAccount.getTenant());
                                            tfsDependency.setTfsLinkType(rel2);
                                            if (!PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                                                item.setJiraDependencies(new ArrayList());
                                            }
                                            boolean isDependencyAlreadyCreated = false;
                                            if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                                                for (ItemJiraDependency existingDependency : item.getJiraDependencies()) {
                                                    if (!PropertyValidator.isValid((Object)existingDependency) || !PropertyValidator.isValid((Object)tfsDependency.getSourceItemId()) || !PropertyValidator.isValid((Object)tfsDependency.getTargetItemId()) || !PropertyValidator.isValid((Object)tfsDependency.getTfsLinkType()) || !tfsDependency.getSourceItemId().equals(existingDependency.getSourceItemId()) || !tfsDependency.getTargetItemId().equals(existingDependency.getTargetItemId()) || !tfsDependency.getTfsLinkType().equals(existingDependency.getTfsLinkType())) continue;
                                                    isDependencyAlreadyCreated = true;
                                                }
                                            }
                                            if (!isDependencyAlreadyCreated) {
                                                tfsDependency.setRaisedOn(new Date());
                                                tfsDependency = (ItemJiraDependency)this.itemJiraDependencyRepository.save((Object)tfsDependency);
                                                item.getJiraDependencies().add(tfsDependency);
                                                newTFSDependencies.add(tfsDependency);
                                            }
                                            KendisUtils.printLOG((String)"### (!relationsObject.isNull Ended", (boolean)almAccount.isDebug());
                                            continue;
                                        }
                                        catch (Exception e) {
                                            sw2 = new StringWriter();
                                            pw2 = new PrintWriter((Writer)sw2);
                                            e.printStackTrace((PrintWriter)((Object)pw2));
                                            sStackTrace2 = ((StringWriter)sw2).toString();
                                            logs.add(" ::  Exception ..  " + sStackTrace2);
                                        }
                                    }
                                    if (WebhookActivityUtil.getInstance().getConditionCheckerValue("item.getSessionBoards().get(0).getSession().getJiraLinkTypes().indexOf(rel) > -1")) {
                                        WebhookActivityUtil.getInstance().putInConditionChecker("item.getSessionBoards().get(0).getSession().getJiraLinkTypes().indexOf(rel) > -1", false);
                                    } else {
                                        WebhookActivityUtil.getInstance().putInConditionChecker("item.getSessionBoards().get(0).getSession().getJiraLinkTypes().indexOf(rel) > -1", false);
                                        WebhookActivityUtil.getInstance().addOneTfsCausedBy("Invalid link types received from webhook, please enter valid link types.");
                                        WebhookActivityUtil.getInstance().addOneTfsCausedBy("Available link types are: " + ((SessionBoard)item.getSessionBoards().get(0)).getSession().getJiraLinkTypes());
                                    }
                                }
                                if (!relationsObject.isNull("removed") && PropertyValidator.isValid((Collection)((SessionBoard)item.getSessionBoards().get(0)).getSession().getJiraLinkTypes())) {
                                    JSONArray relationsRemoved = relationsObject.getJSONArray("removed");
                                    HashMap<String, String> removedTfsIdsMapWithRelation = new HashMap<String, String>();
                                    for (int i = 0; i < relationsRemoved.length(); ++i) {
                                        try {
                                            removedObject = relationsRemoved.getJSONObject(i);
                                            rel2 = removedObject.getString("rel");
                                            url2 = removedObject.getString("url");
                                            removedTFSId = url2.substring(url2.lastIndexOf("/") + 1);
                                            if (((SessionBoard)item.getSessionBoards().get(0)).getSession().getJiraLinkTypes().indexOf(rel2) <= -1) continue;
                                            removedTfsIdsMapWithRelation.put(removedTFSId, rel2);
                                            continue;
                                        }
                                        catch (Exception e) {
                                            sw2 = new StringWriter();
                                            pw2 = new PrintWriter((Writer)sw2);
                                            e.printStackTrace((PrintWriter)((Object)pw2));
                                            sStackTrace2 = ((StringWriter)sw2).toString();
                                            logs.add(" ::  Exception ..  " + sStackTrace2);
                                        }
                                    }
                                    ArrayList<String> jiraDependencyIdsList = new ArrayList<String>();
                                    if (PropertyValidator.isValid(removedTfsIdsMapWithRelation)) {
                                        ArrayList itemJiraDependenciesToBeDeleted = new ArrayList();
                                        if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                                            ArrayList<ItemJiraDependency> jiraDepToBeRemoved = new ArrayList<ItemJiraDependency>();
                                            for (ItemJiraDependency jiraDep : item.getJiraDependencies()) {
                                                if (!PropertyValidator.isValid((Object)jiraDep) || !removedTfsIdsMapWithRelation.containsKey(jiraDep.getTargetTFSItem().getTfsId()) || !((String)removedTfsIdsMapWithRelation.get(jiraDep.getTargetTFSItem().getTfsId())).equals(jiraDep.getTfsLinkType())) continue;
                                                jiraDepToBeRemoved.add(jiraDep);
                                                if (!PropertyValidator.isValid((Object)jiraDep.getJiraDependencyId())) continue;
                                                jiraDependencyIdsList.add(jiraDep.getJiraDependencyId());
                                            }
                                            if (PropertyValidator.isValid(jiraDepToBeRemoved)) {
                                                item.getJiraDependencies().removeAll(jiraDepToBeRemoved);
                                                itemJiraDependenciesToBeDeleted.addAll(jiraDepToBeRemoved);
                                            }
                                        }
                                        if (PropertyValidator.isValid(itemJiraDependenciesToBeDeleted)) {
                                            List itemLinks;
                                            try {
                                                this.itemJiraDependencyRepository.delete(itemJiraDependenciesToBeDeleted);
                                            }
                                            catch (Exception jiraDepToBeRemoved) {
                                                // empty catch block
                                            }
                                            removedTFSDependencies.addAll(itemJiraDependenciesToBeDeleted);
                                            LOGGER.debug("TFS Dependencies removed...::::::::::::::::::::::::::");
                                            if (PropertyValidator.isValid(jiraDependencyIdsList) && PropertyValidator.isValid((Collection)(itemLinks = this.itemLinkRepository.findByAlmLinkIdIn(jiraDependencyIdsList)))) {
                                                for (ItemLink link : itemLinks) {
                                                    if (!PropertyValidator.isValid((Object)link.getAlmLinkId())) continue;
                                                    link.setAlmLinkId(null);
                                                }
                                                this.itemLinkRepository.save((Iterable)itemLinks);
                                            }
                                            KendisUtils.printLOG((String)"TFS Dependencies removed...::::::::::::::::::::::::::", (boolean)almAccount.isDebug());
                                        } else {
                                            WebhookActivityUtil.getInstance().addOneTfsCausedBy("No Jira dependencies found to be to removed.");
                                        }
                                    } else {
                                        WebhookActivityUtil.getInstance().addOneTfsCausedBy("No TFS ID with relations found to remove.");
                                    }
                                }
                            }
                            HashMap oldAndNewTeamContainerMap = null;
                            KendisUtils.printLOG((String)"### ready for updated ", (boolean)almAccount.isDebug());
                            if (!tfsItemObject.isNull("fields")) {
                                Session currentSession;
                                boolean isValid;
                                WebhookActivityUtil.getInstance().logActivity("Retrieving fields for item update.");
                                JSONObject tfsResourceFields = tfsItemObject.getJSONObject("fields");
                                if (!tfsItemObject.isNull("revision")) {
                                    WebhookActivityUtil.getInstance().logActivity("Retrieving revision to use values from to update item values.");
                                    JSONObject tfsItemRevision = tfsItemObject.getJSONObject("revision");
                                    if (!tfsItemRevision.isNull("fields")) {
                                        Object tfsProject;
                                        WebhookActivityUtil.getInstance().logActivity("Retrieving fields from webhook revision.");
                                        KendisUtils.printLOG((String)"### inside fields to update", (boolean)almAccount.isDebug());
                                        JSONObject tfsFields = tfsItemRevision.getJSONObject("fields");
                                        Double sysSequence = new Double(System.nanoTime() / 100000L);
                                        extraFields.put("sequence", sysSequence);
                                        extraFields.put("type", item.getType());
                                        extraFields.put("sessionId", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
                                        HashMap<String, TFSProject> tfsProjectsMap = new HashMap<String, TFSProject>();
                                        HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
                                        String oldItemTitle = null;
                                        String oldItemStatus = null;
                                        if (!PropertyValidator.isValid((Collection)tfsProjects)) {
                                            tfsProjects = this.tfsProjectRepository.findProjectBySessionId(((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
                                        }
                                        if (PropertyValidator.isValid((Collection)tfsProjects)) {
                                            ItemLink link;
                                            WebhookActivityUtil.getInstance().logActivity("TFS Projects found against session ID.");
                                            link = tfsProjects.iterator();
                                            while (link.hasNext()) {
                                                tfsProject = (TFSProject)link.next();
                                                tfsProjectsMap.put(tfsProject.getTfsId(), (TFSProject)tfsProject);
                                                tfsProjectsMapByName.put(tfsProject.getName(), (TFSProject)tfsProject);
                                            }
                                        } else {
                                            WebhookActivityUtil.getInstance().addOneTfsCausedBy("No TFS Projects found against session ID.");
                                        }
                                        oldItemTitle = item.getTitle();
                                        if (PropertyValidator.isValid((Object)item.getStatus())) {
                                            oldItemStatus = item.getStatus().getTitle();
                                        }
                                        item = this.getKendisItemFromTFSItem(item, tfsItemRevision, tfsFields, extraFields, tfsProjectsMap, tfsProjectsMapByName, fieldsChangesMap);
                                        KendisUtils.printLOG((String)"### tfs item converted", (boolean)almAccount.isDebug());
                                        if (((SessionBoard)item.getSessionBoards().get(0)).getSession().getTeamFieldEnable().booleanValue()) {
                                            String areaPath = (String)tfsFields.get(((SessionBoard)item.getSessionBoards().get(0)).getSession().getTeamFieldTeamRefrence());
                                            item.setTfsAreaPath(areaPath);
                                        }
                                        if (PropertyValidator.isValid((Object)item.getTfsId()) && (!item.getTitle().equalsIgnoreCase(oldItemTitle) || PropertyValidator.isValid((Object)item.getStatus()) && !item.getStatus().getTitle().equalsIgnoreCase(oldItemStatus))) {
                                            List dependencyToUpdate = this.itemJiraDependencyRepository.findBySourceTFSItemTfsId(item.getTfsId());
                                            tfsProject = dependencyToUpdate.iterator();
                                            while (tfsProject.hasNext()) {
                                                ItemJiraDependency dependency = (ItemJiraDependency)tfsProject.next();
                                                dependency.getSourceTFSItem().setTitle(item.getTitle());
                                                if (!PropertyValidator.isValid((Object)item.getStatus())) continue;
                                                dependency.getSourceTFSItem().setStatus(item.getStatus().getTitle());
                                            }
                                            this.itemJiraDependencyRepository.save((Iterable)dependencyToUpdate);
                                        }
                                        if (((SessionBoard)item.getSessionBoards().get(0)).getSession().getwsjfAlmEnabled().booleanValue() && tfsFields.has(((SessionBoard)item.getSessionBoards().get(0)).getSession().getwsjfAlmFieldKey())) {
                                            item.setAlmScoreField(new Double(((Integer)tfsFields.get(((SessionBoard)item.getSessionBoards().get(0)).getSession().getwsjfAlmFieldKey())).intValue()));
                                        }
                                    }
                                }
                                if (!(isValid = this.isItemValidToAddForSession(item, currentSession = (Session)sessionMapBySbId.get(((SessionBoard)item.getSessionBoards().get(0)).getId()))) && PropertyValidator.isValid((Object)item.getParent())) {
                                    item.setArchive(true);
                                    savedItem = (Item)this.itemRepository.save((Object)item);
                                    PushSender.sendMsg((String)cid, (String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)item, (String)((SessionBoard)item.getSessionBoards().get(0)).getId(), (String)"TFSWebHookItemDeleted", Arrays.asList(new Item[0]), Arrays.asList(new Item[0]), Arrays.asList(new Item[0]), null, null, (Gson)gsonExclusive, null));
                                    continue;
                                }
                                if (!(!PropertyValidator.isValid((Object)item.getParent()) || tfsResourceFields.isNull("System.IterationPath") && tfsResourceFields.isNull("System.AreaPath"))) {
                                    JSONObject tfsItemRevision = tfsItemObject.getJSONObject("revision");
                                    if (!tfsItemRevision.isNull("fields")) {
                                        JSONObject tfsFields = tfsItemRevision.getJSONObject("fields");
                                        String areaPath = (String)tfsFields.get("System.AreaPath");
                                        if (((SessionBoard)item.getSessionBoards().get(0)).getSession().getTeamFieldEnable().booleanValue()) {
                                            areaPath = (String)tfsFields.get(((SessionBoard)item.getSessionBoards().get(0)).getSession().getTeamFieldTeamRefrence());
                                            item.setTfsAreaPath(areaPath);
                                        }
                                        String iterationPath = (String)tfsFields.get("System.IterationPath");
                                        if (!PropertyValidator.isValid((Collection)syncMappers)) {
                                            syncMappers = this.customRepositoryImpl.findItemSyncMapperBySessionBoard((SessionBoard)item.getSessionBoards().get(0), ((SessionBoard)item.getSessionBoards().get(0)).getTenant());
                                        }
                                        if (PropertyValidator.isValid((Collection)syncMappers)) {
                                            Item parentItem = this.itemRepository.findById(item.getParent().getId());
                                            if (!PropertyValidator.isValid(tfsTeamMapping)) {
                                                tfsTeamMapping = new HashMap();
                                                if (PropertyValidator.isValid((Object)((SessionBoard)item.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)((SessionBoard)item.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getTeamMappings())) {
                                                    for (TFSTeamMapping mappedTeam : ((SessionBoard)item.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getTeamMappings()) {
                                                        tfsTeamMapping.put(mappedTeam.getKendisTeamId(), mappedTeam);
                                                    }
                                                }
                                            }
                                            KendisUtils.printLOG((String)"### mapItemFromItemSyncMapper ", (boolean)almAccount.isDebug());
                                            oldAndNewTeamContainerMap = this.mapItemFromItemSyncMapper(item, parentItem, syncMappers, iterationPath, areaPath, tfsTeamMapping, almConfigs, (Session)sessionMapBySbId.get(((SessionBoard)item.getSessionBoards().get(0)).getId()));
                                            if (PropertyValidator.isValid((Object)item.getParent())) {
                                                parentIdToCheckForRemoveEmpty = item.getParent().getId();
                                            }
                                            if (!PropertyValidator.isValid((Collection)item.getTeamContainers()) && PropertyValidator.isValid((Object)item.getParent())) {
                                                session = ((SessionBoard)item.getSessionBoards().get(0)).getSession();
                                                String bucketItemTypeId = this.getBucketItemTypeForTfsItem(item, ((SessionBoard)item.getSessionBoards().get(0)).getSession());
                                                boolean isParentBucket = false;
                                                if (session.getBucketEnabled() != null && session.getBucketEnabled().booleanValue() && PropertyValidator.isValid((Object)session.getBuckets()) && PropertyValidator.isValid((Object)parentItem.getIssueType()) && session.getBuckets().containsKey(parentItem.getIssueType().getId())) {
                                                    isParentBucket = true;
                                                }
                                                if (bucketItemTypeId != null && isParentBucket) {
                                                    item.setParent(null);
                                                    item.setArchive(true);
                                                    PushSender.sendMsg((String)cid, (String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)parentItem, (String)((SessionBoard)parentItem.getSessionBoards().get(0)).getId(), (String)"TFSWebHookItemUpdated", new ArrayList(), new ArrayList(), Arrays.asList(item), new ArrayList(), new ArrayList(), (Gson)gsonExclusive, null));
                                                }
                                            }
                                            parentItem = (Item)this.itemRepository.save((Object)parentItem);
                                        }
                                    } else {
                                        WebhookActivityUtil.getInstance().addOneTfsCausedBy("No fields retrieved from webhook revision.");
                                    }
                                }
                            }
                            item.setWebHookActivityBy("Via Webhook");
                            item.setSource(1);
                            savedItem = (Item)this.itemRepository.save((Object)item);
                            KendisUtils.printLOG((String)"### savedItem = itemRepository.save(item); ", (boolean)almAccount.isDebug());
                            if (parentIdToCheckForRemoveEmpty != null) {
                                this.pushEmptyCardsTC(Arrays.asList(parentIdToCheckForRemoveEmpty), cid, almAccount.getTenant());
                            }
                            WebhookActivityUtil.getInstance().logActivity("Item saved successfully");
                            if (PropertyValidator.isValid((Object)oldStatus)) {
                                Session session3 = ((SessionBoard)item.getSessionBoards().get(0)).getSession();
                                if (PropertyValidator.isValid((Object)item.getFetchedBy())) {
                                    AlmAccount taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)item.getFetchedBy(), (AlmAccount)almAccount);
                                    this.updateItemLinksStatusBasedOnItemStatusTFS(item, oldStatus, session3, oldAndNewTeamContainerMap, taggedAlmAccount);
                                } else {
                                    almAccount.setIsTaggedUser(Boolean.valueOf(true));
                                    this.updateItemLinksStatusBasedOnItemStatusTFS(item, oldStatus, session3, oldAndNewTeamContainerMap, almAccount);
                                }
                            }
                            KendisUtils.printLOG((String)"------------------------------------------- WEBHOOK Data PER Item Exec ENDED ---------------------- ", (boolean)almAccount.isDebug());
                            PushSender.sendMsg((String)cid, (String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)savedItem, (String)((SessionBoard)savedItem.getSessionBoards().get(0)).getId(), (String)"TFSWebHookItemUpdated", newChildsAdded, existingChildsUpdated, existingChildsRemoved, newTFSDependencies, removedTFSDependencies, (Gson)gsonExclusive, null));
                            continue;
                        }
                        if (!eventType.equals("workitem.created")) continue;
                    }
                }
                try {
                    boolean isTfsItemChanged = true;
                    if (!isTfsItemChanged) {
                        WebhookActivityUtil.getInstance().extractMismatchLogForTfs();
                        WebhookActivityUtil.getInstance().saveTfsError(almAccount, this.itemRepository, this.webhookActivityRepository);
                        break block184;
                    }
                    WebhookActivityUtil.getInstance().reset();
                }
                catch (Exception ex) {
                    logs.add("Error occurred while checking for webhook success: " + StringUtils.getTraceString((Throwable)ex));
                }
            }
            catch (Exception e) {
                logs.add("FAILED to apply changes from TFS Webhook .... " + StringUtils.getTraceString((Throwable)e));
            }
            finally {
                if (unMappedData.getId() != null) {
                    try {
                        this.tfsWebhookRepository.delete((Serializable)((Object)unMappedData.getId()));
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
        }
        this.printLogs(unMappedData.getAlmAccountId(), executionLogs);
        this.printLogs(unMappedData.getAlmAccountId(), logs);
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private HashMap<String, TeamContainer> mapItemFromItemSyncMapper(Item childItem, Item parentItem, List<ItemSyncMapper> syncMappers, String iterationPath, String areaPath, HashMap<String, TFSTeamMapping> tfsTeamMapping, List<TFSAlmConfigurations> almConfigs, Session session) {
        boolean itemMapped = false;
        HashMap<String, TeamContainer> teamContainersMap = new HashMap<String, TeamContainer>();
        if (PropertyValidator.isValid((Collection)childItem.getTeamContainers())) {
            teamContainersMap.put("old", (TeamContainer)childItem.getTeamContainers().get(0));
            childItem.setContainer(((TeamContainer)childItem.getTeamContainers().get(0)).getContainer());
            childItem.setTeam(((TeamContainer)childItem.getTeamContainers().get(0)).getTeam());
        }
        childItem.setTeamContainers(new ArrayList());
        if (PropertyValidator.isValid((Object)iterationPath)) {
            ArrayList<ItemSyncMapper> matchedSyncMappers = new ArrayList<ItemSyncMapper>();
            WebhookActivityUtil.getInstance().putInConditionChecker("tfsTeamMapping.containsKey(x.getTeam().getId())", false);
            for (ItemSyncMapper x : syncMappers) {
                if (!PropertyValidator.isValid((Object)x) || !PropertyValidator.isValid((Object)x.getTfsSprint()) || !iterationPath.equals(x.getTfsSprint().getIterationPath()) || !tfsTeamMapping.containsKey(x.getTeam().getId())) continue;
                WebhookActivityUtil.getInstance().putInConditionChecker("tfsTeamMapping.containsKey(x.getTeam().getId())", true);
                Session itemSession = null;
                if (PropertyValidator.isValid((Object)parentItem) && PropertyValidator.isValid((Collection)parentItem.getSessionBoards())) {
                    itemSession = ((SessionBoard)parentItem.getSessionBoards().get(0)).getSession();
                }
                if (itemSession != null && !itemSession.getAreaPathDisabled().booleanValue()) {
                    TFSTeamMapping _tfsTeamMapping = tfsTeamMapping.get(x.getTeam().getId());
                    if (!PropertyValidator.isValid((Object)areaPath)) continue;
                    if (_tfsTeamMapping.getIncludeSubAreaPaths().booleanValue()) {
                        boolean check1 = areaPath.equals(_tfsTeamMapping.getTfsAreaPath()) || areaPath.startsWith(_tfsTeamMapping.getTfsAreaPath() + "\\");
                        boolean check2 = true;
                        if (PropertyValidator.isValid((Collection)_tfsTeamMapping.getTfsAreaPathsForTeam())) {
                            check2 = false;
                            for (String aPath : _tfsTeamMapping.getTfsAreaPathsForTeam()) {
                                if (!areaPath.equals(aPath) && !areaPath.startsWith(aPath + "\\")) continue;
                                check2 = true;
                                break;
                            }
                        }
                        if (!check1 && !check2) continue;
                        matchedSyncMappers.add(x);
                        continue;
                    }
                    if (!areaPath.equals(_tfsTeamMapping.getTfsAreaPath()) && (!PropertyValidator.isValid((Collection)_tfsTeamMapping.getTfsAreaPathsForTeam()) || !_tfsTeamMapping.getTfsAreaPathsForTeam().contains(areaPath))) continue;
                    matchedSyncMappers.add(x);
                    continue;
                }
                matchedSyncMappers.add(x);
            }
            if (WebhookActivityUtil.getInstance().getConditionCheckerValue("tfsTeamMapping.containsKey(x.getTeam().getId())")) {
                WebhookActivityUtil.getInstance().putInConditionChecker("tfsTeamMapping.containsKey(x.getTeam().getId())", false);
            } else {
                WebhookActivityUtil.getInstance().putInConditionChecker("tfsTeamMapping.containsKey(x.getTeam().getId())", false);
                WebhookActivityUtil.getInstance().addOneTfsCausedBy("Team mapping does not contain ID for sync mappers.");
            }
            if (PropertyValidator.isValid(matchedSyncMappers)) {
                if (matchedSyncMappers.size() > 1) {
                    for (ItemSyncMapper syncMapper : matchedSyncMappers) {
                        TFSTeamMapping _tfsTeamMapping = tfsTeamMapping.get(syncMapper.getTeam().getId());
                        if (!areaPath.equals(_tfsTeamMapping.getTfsAreaPath()) && (!PropertyValidator.isValid((Collection)_tfsTeamMapping.getTfsAreaPathsForTeam()) || !_tfsTeamMapping.getTfsAreaPathsForTeam().contains(areaPath))) continue;
                        matchedSyncMappers.clear();
                        matchedSyncMappers.add(syncMapper);
                        break;
                    }
                }
                WebhookActivityUtil.getInstance().putInConditionChecker("PropertyValidator.isValid(parentTeamContainer) && itemSyncMapper.getTeam() != null && itemSyncMapper.getContainer() != null && parentTeamContainer.getTeam().equals(itemSyncMapper.getTeam()) && parentTeamContainer.getContainer().equals(itemSyncMapper.getContainer())", false);
                for (ItemSyncMapper itemSyncMapper : matchedSyncMappers) {
                    if (PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                        for (TeamContainer parentTeamContainer : parentItem.getTeamContainers()) {
                            if (!PropertyValidator.isValid((Object)parentTeamContainer) || itemSyncMapper.getTeam() == null || itemSyncMapper.getContainer() == null || !parentTeamContainer.getTeam().equals((Object)itemSyncMapper.getTeam()) || !parentTeamContainer.getContainer().equals((Object)itemSyncMapper.getContainer())) continue;
                            WebhookActivityUtil.getInstance().putInConditionChecker("PropertyValidator.isValid(parentTeamContainer) && itemSyncMapper.getTeam() != null && itemSyncMapper.getContainer() != null && parentTeamContainer.getTeam().equals(itemSyncMapper.getTeam()) && parentTeamContainer.getContainer().equals(itemSyncMapper.getContainer())", true);
                            childItem.setTeamContainers(new ArrayList());
                            childItem.getTeamContainers().add(parentTeamContainer);
                            teamContainersMap.put("new", parentTeamContainer);
                            itemMapped = true;
                            childItem.applySprintDates(session, null, null);
                            break;
                        }
                    }
                    if (itemMapped || itemSyncMapper.getTeam() == null || itemSyncMapper.getContainer() == null) continue;
                    TeamContainer teamContainer = new TeamContainer();
                    teamContainer.setTeam(itemSyncMapper.getTeam());
                    teamContainer.setContainer(itemSyncMapper.getContainer());
                    if (!PropertyValidator.isValid((Object)teamContainer.getTenant()) && PropertyValidator.isValid(almConfigs) && PropertyValidator.isValid((Object)almConfigs.get(0)) && PropertyValidator.isValid((Object)almConfigs.get(0).getTenant())) {
                        teamContainer.setTenant(almConfigs.get(0).getTenant());
                    }
                    teamContainer.setSuspendActivity(true);
                    teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)teamContainer);
                    childItem.setTeamContainers(new ArrayList());
                    teamContainersMap.put("new", teamContainer);
                    childItem.getTeamContainers().add(teamContainer);
                    childItem.applySprintDates(session, null, null);
                    if (!PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                        parentItem.setTeamContainers(new ArrayList());
                    }
                    parentItem.getTeamContainers().add(teamContainer);
                }
                if (!WebhookActivityUtil.getInstance().getConditionCheckerValue("PropertyValidator.isValid(parentTeamContainer) && itemSyncMapper.getTeam() != null && itemSyncMapper.getContainer() != null && parentTeamContainer.getTeam().equals(itemSyncMapper.getTeam()) && parentTeamContainer.getContainer().equals(itemSyncMapper.getContainer())")) {
                    WebhookActivityUtil.getInstance().putInConditionChecker("PropertyValidator.isValid(parentTeamContainer) && itemSyncMapper.getTeam() != null && itemSyncMapper.getContainer() != null && parentTeamContainer.getTeam().equals(itemSyncMapper.getTeam()) && parentTeamContainer.getContainer().equals(itemSyncMapper.getContainer())", false);
                } else {
                    WebhookActivityUtil.getInstance().putInConditionChecker("PropertyValidator.isValid(parentTeamContainer) && itemSyncMapper.getTeam() != null && itemSyncMapper.getContainer() != null && parentTeamContainer.getTeam().equals(itemSyncMapper.getTeam()) && parentTeamContainer.getContainer().equals(itemSyncMapper.getContainer())", false);
                    WebhookActivityUtil.getInstance().addOneTfsCausedBy("Could not match parent sync mapping with any team container mapping for item.");
                }
            } else {
                WebhookActivityUtil.getInstance().addOneTfsCausedBy("Provided sprint: " + iterationPath + " or provided Area path: " + areaPath + " does not match with any mapped sprints.");
            }
        }
        return teamContainersMap;
    }

    private HashMap<String, Status> getStatusesMap(List<Status> statuses) {
        HashMap<String, Status> statusMap = new HashMap<String, Status>();
        for (Status status : statuses) {
            String key = status.getSessionId() + status.getTfsProject() + status.getItemType() + status.getTitle();
            statusMap.put(key, status);
        }
        return statusMap;
    }

    private Item getKendisItemFromTFSItem(JSONObject itemObject, JSONObject tfsFields, Map<String, Object> extraFields, Map<String, TFSProject> tfsProjectsMap, Map<String, TFSProject> tfsProjectsMapByName) {
        Item item = new Item();
        item.setId(ObjectId.get().toString());
        item.setSequence(Double.valueOf((Double)extraFields.get("sequence") + 1000.0));
        item.setBacklogSequence(Double.valueOf((Double)extraFields.get("sequence") + 1000.0));
        String tfsId = null;
        if (!itemObject.isNull("workItemId")) {
            tfsId = itemObject.getString("workItemId");
        } else if (!itemObject.isNull("id")) {
            tfsId = itemObject.getString("id");
        }
        try {
            String url = itemObject.getString("url");
            String rev = itemObject.getString("rev");
            String areaPath = (String)tfsFields.get("System.AreaPath");
            String teamProject = (String)tfsFields.get("System.TeamProject");
            String title = (String)tfsFields.get("System.Title");
            String state = (String)tfsFields.get("System.State");
            String workItemType = (String)tfsFields.get("System.WorkItemType");
            if (!itemObject.isNull("_links")) {
                JSONObject linkHTML;
                JSONObject links = itemObject.getJSONObject("_links");
                if (!links.isNull("html")) {
                    linkHTML = links.getJSONObject("html");
                    item.setTfsURL(linkHTML.getString("href"));
                } else if (!links.isNull("parent")) {
                    linkHTML = links.getJSONObject("parent");
                    item.setTfsURL(linkHTML.getString("href"));
                }
            }
            String[] urlComponents = url.split("/");
            String projectId = null;
            projectId = urlComponents.length >= 9 ? urlComponents[4] : urlComponents[3];
            try {
                TFSProject tfsProject = null;
                if (tfsProjectsMap.containsKey(projectId)) {
                    tfsProject = tfsProjectsMap.get(projectId);
                } else if (tfsProjectsMapByName.containsKey(teamProject)) {
                    tfsProject = tfsProjectsMapByName.get(teamProject);
                    projectId = tfsProject.getTfsId();
                }
                if (PropertyValidator.isValid((Object)tfsProject)) {
                    Object dueDateStr;
                    Double storyPoint;
                    if (PropertyValidator.isValid((Object)tfsProject.getIconByItemType())) {
                        String itemTypeIconUrl = (String)tfsProject.getIconByItemType().get(workItemType);
                        item.setTfsItemTypeIcon(itemTypeIconUrl);
                    } else {
                        item.setTfsItemTypeIcon(null);
                    }
                    if (Item.FEATURE.equals((String)extraFields.get("type"))) {
                        if (PropertyValidator.isValid((Object)tfsProject.getItemEstimationField()) && !tfsFields.isNull(tfsProject.getItemEstimationField())) {
                            storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProject.getItemEstimationField())));
                            if (PropertyValidator.isValid((Object)storyPoint)) {
                                storyPoint = StringUtils.round((double)storyPoint, (int)2);
                            }
                            item.setStoryPoints(storyPoint);
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemDueDateField()) && !tfsFields.isNull(tfsProject.getItemDueDateField())) {
                            dueDateStr = (String)tfsFields.get(tfsProject.getItemDueDateField());
                            item.setDueDate(PropertyValidator.parseDate((String)dueDateStr, (String)"yyyy-MM-dd"));
                        }
                    } else if (Item.USER_STORY.equals((String)extraFields.get("type"))) {
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemEstimationField()) && !tfsFields.isNull(tfsProject.getSubItemEstimationField())) {
                            storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProject.getSubItemEstimationField())));
                            if (PropertyValidator.isValid((Object)storyPoint)) {
                                storyPoint = StringUtils.round((double)storyPoint, (int)2);
                            }
                            item.setStoryPoints(storyPoint);
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemDueDateField()) && !tfsFields.isNull(tfsProject.getSubItemDueDateField())) {
                            dueDateStr = (String)tfsFields.get(tfsProject.getSubItemDueDateField());
                            item.setDueDate(PropertyValidator.parseDate((String)dueDateStr, (String)"yyyy-MM-dd"));
                        }
                    }
                    if (PropertyValidator.isValid((Collection)tfsProject.getSelectedFields())) {
                        for (HashMap field : tfsProject.getSelectedFields()) {
                            String key = (String)field.get("referenceName");
                            String type = (String)field.get("type");
                            ItemJiraFieldMap fieldMap = null;
                            boolean newField = false;
                            if (PropertyValidator.isValid((Collection)item.getTfsFieldMap())) {
                                fieldMap = item.getTfsFieldMap().stream().filter(fm -> fm.getKey().equals(key)).findAny().orElse(null);
                            }
                            if (fieldMap == null) {
                                fieldMap = new ItemJiraFieldMap();
                                newField = true;
                            }
                            fieldMap.setKey(key);
                            fieldMap.setName((String)field.get("name"));
                            fieldMap.setType((String)field.get("type"));
                            if (tfsFields.has(key)) {
                                Object value = tfsFields.get(key);
                                if (type.equals("integer") || type.equals("double") || type.equals("boolean") || type.equals("dateTime")) {
                                    String _value = String.valueOf(value);
                                    fieldMap.setValue(_value);
                                } else if (value instanceof String) {
                                    fieldMap.setValue((String)value);
                                }
                            }
                            if (!newField) continue;
                            if (item.getTfsFieldMap() == null) {
                                item.setTfsFieldMap(new ArrayList());
                            }
                            item.getTfsFieldMap().add(fieldMap);
                        }
                    }
                }
            }
            catch (ClassCastException castException) {
                castException.printStackTrace();
                LOGGER.error("tfsId : " + tfsId + " : " + StringUtils.getTraceString((Throwable)castException));
            }
            String statusKey = (String)extraFields.get("sessionId") + teamProject + workItemType + state;
            item.setStatus((Status)((HashMap)extraFields.get("statusMap")).get(statusKey));
            item.setTfsId(tfsId);
            item.setTitle(title);
            item.setTfsItemType(workItemType);
            item.setTfsProject(teamProject);
            item.setTfsProjectId(projectId);
            item.setTfsApiURL(url);
            item.setTfsAreaPath(areaPath);
            item.setAlmRevision(rev);
            item.setTfsFieldByKey(new HashMap());
            try {
                Map userMap;
                Object assignedTo;
                if (!tfsFields.isNull("System.AssignedTo")) {
                    assignedTo = tfsFields.get("System.AssignedTo");
                    userMap = this.rtItemTfsSyncService.getTfsUserMap(assignedTo);
                    item.getTfsFieldByKey().put("AssignedTo", userMap);
                }
                if (!tfsFields.isNull("System.CreatedBy")) {
                    assignedTo = tfsFields.get("System.CreatedBy");
                    userMap = this.rtItemTfsSyncService.getTfsUserMap(assignedTo);
                    item.getTfsFieldByKey().put("CreatedBy", userMap);
                }
            }
            catch (Exception e) {
                LOGGER.error("tfsId : " + tfsId + " : " + StringUtils.getTraceString((Throwable)e));
            }
            if (!tfsFields.isNull("System.CreatedDate")) {
                String createdDate = tfsFields.getString("System.CreatedDate");
                item.getTfsFieldByKey().put("CreatedDate", createdDate);
            }
            if (!tfsFields.isNull("System.ChangedDate")) {
                String changedDate = tfsFields.getString("System.ChangedDate");
                item.getTfsFieldByKey().put("ChangedDate", changedDate);
            }
        }
        catch (JSONException e) {
            LOGGER.error("tfsId : " + tfsId + " : " + StringUtils.getTraceString((Throwable)e));
        }
        return item;
    }

    private Item getKendisItemFromTFSItem(Item kendisItem, JSONObject itemObject, JSONObject tfsFields, Map<String, Object> extraFields, Map<String, TFSProject> tfsProjectsMap, Map<String, TFSProject> tfsProjectsMapByName, HashMap<String, String> fieldsChangesMap) {
        String tfsId = itemObject.getString("id");
        try {
            Map userMap;
            Object assignedTo;
            if (kendisItem.getTfsFieldMap() == null) {
                kendisItem.setTfsFieldMap(new ArrayList());
            }
            String url = itemObject.getString("url");
            String areaPathField = "System.AreaPath";
            String teamProjectField = "System.TeamProject";
            String iterationPathField = "System.IterationPath";
            String titleField = "System.Title";
            String stateField = "System.State";
            String workItemTypeField = "System.WorkItemType";
            String areaPath = (String)tfsFields.get(areaPathField);
            String teamProject = (String)tfsFields.get(teamProjectField);
            String iterationPath = (String)tfsFields.get(iterationPathField);
            String title = (String)tfsFields.get(titleField);
            String state = (String)tfsFields.get(stateField);
            String workItemType = (String)tfsFields.get(workItemTypeField);
            String[] urlComponents = url.split("/");
            String projectId = null;
            projectId = urlComponents.length >= 9 ? urlComponents[4] : urlComponents[3];
            try {
                TFSProject tfsProject = null;
                if (tfsProjectsMap.containsKey(projectId)) {
                    tfsProject = tfsProjectsMap.get(projectId);
                } else if (tfsProjectsMapByName.containsKey(teamProject)) {
                    tfsProject = tfsProjectsMapByName.get(teamProject);
                    projectId = tfsProject.getTfsId();
                }
                if (PropertyValidator.isValid((Object)tfsProject)) {
                    Object endDateStr;
                    String startDateStr;
                    String dueDateStr;
                    Double storyPoint;
                    WebhookActivityUtil.getInstance().logActivity("TFS project found from project mapping using given project ID.");
                    if (Item.FEATURE.equals((String)extraFields.get("type"))) {
                        WebhookActivityUtil.getInstance().logActivity("Item type matched as Feature.");
                        if (PropertyValidator.isValid((Object)tfsProject.getItemEstimationField()) && !tfsFields.isNull(tfsProject.getItemEstimationField()) && fieldsChangesMap.get(tfsProject.getItemEstimationField()) != null) {
                            WebhookActivityUtil.getInstance().logActivity("Item estimation field matched from tfs project, setting story points in kendis item.");
                            storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProject.getItemEstimationField())));
                            if (PropertyValidator.isValid((Object)storyPoint)) {
                                storyPoint = StringUtils.round((double)storyPoint, (int)2);
                            }
                            kendisItem.setStoryPoints(storyPoint);
                        } else if (PropertyValidator.isValid((Object)tfsProject.getItemEstimationField())) {
                            WebhookActivityUtil.getInstance().putTfsErrorLookup("storyPoints", tfsProject.getItemEstimationField() + " not found in fields map from tfs webhook, please verify field mapping for project.");
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemDueDateField()) && !tfsFields.isNull(tfsProject.getItemDueDateField()) && fieldsChangesMap.get(tfsProject.getItemDueDateField()) != null) {
                            WebhookActivityUtil.getInstance().logActivity("Item due date field matched from tfs project, setting due date in kendis item.");
                            dueDateStr = (String)tfsFields.get(tfsProject.getItemDueDateField());
                            kendisItem.setDueDate(PropertyValidator.parseDate((String)dueDateStr, (String)"yyyy-MM-dd"));
                        } else if (PropertyValidator.isValid((Object)tfsProject.getItemDueDateField())) {
                            WebhookActivityUtil.getInstance().putTfsErrorLookup("dueDate", tfsProject.getItemDueDateField() + " not found in fields map from tfs webhook, please verify field mapping for project.");
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemStartDateField()) && !tfsFields.isNull(tfsProject.getItemStartDateField()) && fieldsChangesMap.get(tfsProject.getItemStartDateField()) != null) {
                            WebhookActivityUtil.getInstance().logActivity("Item start date field matched from tfs project, setting start date in kendis item.");
                            startDateStr = (String)tfsFields.get(tfsProject.getItemStartDateField());
                            kendisItem.setStartDate(PropertyValidator.parseDate((String)startDateStr, (String)"yyyy-MM-dd"));
                        } else if (PropertyValidator.isValid((Object)tfsProject.getItemStartDateField())) {
                            WebhookActivityUtil.getInstance().putTfsErrorLookup("startDate", tfsProject.getItemStartDateField() + " not found in fields map from tfs webhook, please verify field mapping for project.");
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemEndDateField()) && !tfsFields.isNull(tfsProject.getItemEndDateField()) && fieldsChangesMap.get(tfsProject.getItemEndDateField()) != null) {
                            WebhookActivityUtil.getInstance().logActivity("Item end date field matched from tfs project, setting end date in kendis item.");
                            endDateStr = (String)tfsFields.get(tfsProject.getItemEndDateField());
                            kendisItem.setEndDate(PropertyValidator.parseDate((String)endDateStr, (String)"yyyy-MM-dd"));
                        } else if (PropertyValidator.isValid((Object)tfsProject.getItemEndDateField())) {
                            WebhookActivityUtil.getInstance().putTfsErrorLookup("endDate", tfsProject.getItemEndDateField() + " not found in fields map from tfs webhook, please verify field mapping for project.");
                        }
                    } else if (Item.USER_STORY.equals((String)extraFields.get("type"))) {
                        WebhookActivityUtil.getInstance().logActivity("Item type matched as User Story.");
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemEstimationField()) && !tfsFields.isNull(tfsProject.getSubItemEstimationField()) && fieldsChangesMap.get(tfsProject.getSubItemEstimationField()) != null) {
                            WebhookActivityUtil.getInstance().logActivity("Sub item estimation field matched from tfs project, setting story points in kendis item.");
                            storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProject.getSubItemEstimationField())));
                            if (PropertyValidator.isValid((Object)storyPoint)) {
                                storyPoint = StringUtils.round((double)storyPoint, (int)2);
                            }
                            kendisItem.setStoryPoints(storyPoint);
                        } else if (PropertyValidator.isValid((Object)tfsProject.getSubItemEstimationField())) {
                            WebhookActivityUtil.getInstance().putTfsErrorLookup("subStoryPoints", tfsProject.getSubItemEstimationField() + " not found in fields map from tfs webhook, please verify field mapping for project.");
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemDueDateField()) && !tfsFields.isNull(tfsProject.getSubItemDueDateField()) && fieldsChangesMap.get(tfsProject.getSubItemDueDateField()) != null) {
                            WebhookActivityUtil.getInstance().logActivity("Sub item due date field matched from tfs project, setting due date in kendis item.");
                            dueDateStr = (String)tfsFields.get(tfsProject.getSubItemDueDateField());
                            kendisItem.setDueDate(PropertyValidator.parseDate((String)dueDateStr, (String)"yyyy-MM-dd"));
                        } else if (PropertyValidator.isValid((Object)tfsProject.getSubItemDueDateField())) {
                            WebhookActivityUtil.getInstance().putTfsErrorLookup("subDueDate", tfsProject.getSubItemDueDateField() + " not found in fields map from tfs webhook, please verify field mapping for project.");
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemStartDateField()) && !tfsFields.isNull(tfsProject.getSubItemStartDateField()) && fieldsChangesMap.get(tfsProject.getSubItemStartDateField()) != null) {
                            WebhookActivityUtil.getInstance().logActivity("Sub item start date field matched from tfs project, setting start date in kendis item.");
                            startDateStr = (String)tfsFields.get(tfsProject.getSubItemStartDateField());
                            kendisItem.setStartDate(PropertyValidator.parseDate((String)startDateStr, (String)"yyyy-MM-dd"));
                        } else if (PropertyValidator.isValid((Object)tfsProject.getSubItemStartDateField())) {
                            WebhookActivityUtil.getInstance().putTfsErrorLookup("subStartDate", tfsProject.getSubItemStartDateField() + " not found in fields map from tfs webhook, please verify field mapping for project.");
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemEndDateField()) && !tfsFields.isNull(tfsProject.getSubItemEndDateField()) && fieldsChangesMap.get(tfsProject.getSubItemEndDateField()) != null) {
                            WebhookActivityUtil.getInstance().logActivity("Sub item end date field matched from tfs project, setting end date in kendis item.");
                            endDateStr = (String)tfsFields.get(tfsProject.getSubItemEndDateField());
                            kendisItem.setEndDate(PropertyValidator.parseDate((String)endDateStr, (String)"yyyy-MM-dd"));
                        } else if (PropertyValidator.isValid((Object)tfsProject.getSubItemEndDateField())) {
                            WebhookActivityUtil.getInstance().putTfsErrorLookup("subEndDate", tfsProject.getSubItemEndDateField() + " not found in fields map from tfs webhook, please verify field mapping for project.");
                        }
                    }
                    if (PropertyValidator.isValid((Collection)tfsProject.getSelectedFields())) {
                        for (HashMap field : tfsProject.getSelectedFields()) {
                            String key = (String)field.get("referenceName");
                            String type = (String)field.get("type");
                            if (fieldsChangesMap.get(key) == null) continue;
                            ItemJiraFieldMap fieldMap = null;
                            boolean newField = false;
                            if (PropertyValidator.isValid((Collection)kendisItem.getTfsFieldMap())) {
                                fieldMap = kendisItem.getTfsFieldMap().stream().filter(fm -> fm.getKey().equals(key)).findAny().orElse(null);
                            }
                            if (fieldMap == null) {
                                fieldMap = new ItemJiraFieldMap();
                                newField = true;
                            }
                            fieldMap.setKey(key);
                            fieldMap.setName((String)field.get("name"));
                            fieldMap.setType((String)field.get("type"));
                            if (tfsFields.has(key)) {
                                Object value = tfsFields.get(key);
                                if (type.equals("integer") || type.equals("double") || type.equals("boolean") || type.equals("dateTime")) {
                                    String _value = String.valueOf(value);
                                    fieldMap.setValue(_value);
                                } else if (value instanceof String) {
                                    fieldMap.setValue((String)value);
                                }
                            }
                            if (!newField) continue;
                            if (kendisItem.getTfsFieldMap() == null) {
                                kendisItem.setTfsFieldMap(new ArrayList());
                            }
                            kendisItem.getTfsFieldMap().add(fieldMap);
                        }
                    }
                } else {
                    WebhookActivityUtil.getInstance().addOneTfsCausedBy("No TFS project found from project mapping using given project ID.");
                }
            }
            catch (Exception ex) {
                LOGGER.error("tfsId : " + tfsId + " : " + StringUtils.getTraceString((Throwable)ex));
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            }
            if (fieldsChangesMap.get(stateField) != null) {
                String statusKey = (String)extraFields.get("sessionId") + teamProject + workItemType + state;
                kendisItem.setStatus((Status)((HashMap)extraFields.get("statusMap")).get(statusKey));
            }
            kendisItem.setTfsId(tfsId);
            if (fieldsChangesMap.get(titleField) != null) {
                kendisItem.setTitle(title);
            }
            kendisItem.setTfsItemType(workItemType);
            kendisItem.setTfsProject(teamProject);
            kendisItem.setTfsProjectId(projectId);
            kendisItem.setTfsApiURL(url);
            if (fieldsChangesMap.get(areaPathField) != null) {
                kendisItem.setTfsAreaPath(areaPath);
            }
            if (fieldsChangesMap.get(iterationPathField) != null) {
                kendisItem.setTfsIterationPath(iterationPath);
            }
            if (kendisItem.getTfsFieldByKey() == null) {
                kendisItem.setTfsFieldByKey(new HashMap());
            }
            if (!tfsFields.isNull("System.AssignedTo")) {
                assignedTo = tfsFields.get("System.AssignedTo");
                userMap = this.rtItemTfsSyncService.getTfsUserMap(assignedTo);
                kendisItem.getTfsFieldByKey().put("AssignedTo", userMap);
            }
            if (!tfsFields.isNull("System.CreatedBy")) {
                assignedTo = tfsFields.get("System.CreatedBy");
                userMap = this.rtItemTfsSyncService.getTfsUserMap(assignedTo);
                kendisItem.getTfsFieldByKey().put("CreatedBy", userMap);
            }
            if (!tfsFields.isNull("System.CreatedDate") && fieldsChangesMap.get("System.CreatedDate") != null) {
                kendisItem.getTfsFieldByKey().put("CreatedDate", tfsFields.get("System.CreatedDate"));
            }
            if (!tfsFields.isNull("System.ChangedDate") && fieldsChangesMap.get("System.ChangedDate") != null) {
                kendisItem.getTfsFieldByKey().put("ChangedDate", tfsFields.get("System.ChangedDate"));
            }
        }
        catch (JSONException e) {
            LOGGER.error("tfsId : " + tfsId + " : " + StringUtils.getTraceString((Throwable)e));
        }
        catch (Exception e) {
            LOGGER.error("tfsId : " + tfsId + " : " + StringUtils.getTraceString((Throwable)e));
        }
        return kendisItem;
    }

    private String getUserNameFromAdoWebhookUserInfo(String userInfo) {
        if (userInfo == null) {
            return null;
        }
        String[] userInfoParts = userInfo.split("<");
        if (userInfoParts.length == 2) {
            String displayName = userInfoParts[0];
            displayName = displayName.trim();
            String uniqueName = userInfoParts[1];
            uniqueName = uniqueName.replace(">", "");
            return displayName;
        }
        return userInfo;
    }

    private String getBucketItemTypeForTfsItem(Item item, Session session) {
        if (item == null || session == null || !Boolean.TRUE.equals(session.getBucketEnabled())) {
            return null;
        }
        return this.getItemTypeIdForTfsWebhook(session, item.getTfsItemType());
    }

    private String getItemTypeIdForTfsWebhook(Session session, String tfsItemType) {
        if (PropertyValidator.isValid((Object)session.getBuckets())) {
            Set keys = session.getBuckets().keySet();
            for (String key : keys) {
                IssueType issueType = (IssueType)session.getBuckets().get(key);
                List _types = issueType.getAlmTypes();
                if (!PropertyValidator.isValid((Collection)_types)) continue;
                for (Map o : _types) {
                    String type = (String)o.get("name");
                    if (type == null || !type.endsWith(tfsItemType)) continue;
                    return key;
                }
            }
        }
        return null;
    }

    private List<Item> findBucketItems(Session session, String itemTypeId, String tenant) {
        if (session == null || itemTypeId == null) {
            return new ArrayList<Item>();
        }
        ArrayList<String> sessionBoardsIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)session.getActiveSessionBoard())) {
            sessionBoardsIds.add(session.getActiveSessionBoard());
        }
        if (sessionBoardsIds.isEmpty()) {
            return new ArrayList<Item>();
        }
        List allItems = this.itemRepository.findByIssueTypeIdInAndSessionBoardsInAndTenantAndArchive(Arrays.asList(itemTypeId), sessionBoardsIds, tenant, false);
        ArrayList<Item> bucketItems = new ArrayList<Item>();
        for (Item item : allItems) {
            if (item.getParent() != null) continue;
            bucketItems.add(item);
        }
        return bucketItems;
    }

    private Item handleBucketAssignmentOnParentRemoval(Item item, Session session, AlmAccount almAccount) {
        if (item == null || session == null || !Boolean.TRUE.equals(session.getBucketEnabled())) {
            return null;
        }
        String bucketItemTypeId = this.getBucketItemTypeForTfsItem(item, session);
        if (bucketItemTypeId == null) {
            return null;
        }
        List bucketItems = this.findBucketItems(session, bucketItemTypeId, almAccount.getTenant());
        if (bucketItems.isEmpty()) {
            LOGGER.debug("[Bucket] No bucket items found for type: " + bucketItemTypeId + " for item: " + item.getTfsId());
            return null;
        }
        Item bucketItem = (Item)bucketItems.get(0);
        LOGGER.debug("[Bucket] Assigned item " + item.getTfsId() + " to bucket item " + bucketItem.getId() + " of type " + bucketItemTypeId);
        return bucketItem;
    }

    public String createWebhook(AlmAccount almAccount) {
        WebhookVO webhookVO = new WebhookVO();
        ArrayList<String> events = new ArrayList<String>();
        webhookVO.setName("Kendis Webhook with Account " + almAccount.getName());
        webhookVO.setUrl("http://dev.kendis.io/webhook/" + almAccount.getId());
        events.add("jira:issue_created");
        events.add("jira:issue_updated");
        events.add("jira:issue_deleted");
        events.add("issuelink_created");
        events.add("issuelink_deleted");
        events.add("sprint_started");
        events.add("sprint_closed");
        webhookVO.setEvents(events);
        webhookVO.setExcludeIssueDetails(Boolean.valueOf(true));
        String result = null;
        try {
            result = this.exportUtil.createWebhookInJira(webhookVO, almAccount);
        }
        catch (Exception e) {
            events = new ArrayList();
            events.add("jira:issue_created");
            events.add("jira:issue_updated");
            events.add("jira:issue_deleted");
            webhookVO.setEvents(events);
            webhookVO.setExcludeIssueDetails(Boolean.valueOf(true));
            result = this.exportUtil.createWebhookInJira(webhookVO, almAccount);
        }
        if (PropertyValidator.isValid((Object)result)) {
            return result;
        }
        return null;
    }

    public String createWebhook(String kendisBaseURL, AlmAccount almAccount) {
        Boolean isLocalDeployment;
        boolean isCloud;
        WebhookVO webhookVO = new WebhookVO();
        ArrayList<String> events = new ArrayList<String>();
        boolean bl = isCloud = PropertyValidator.isValid((Object)almAccount.getJiraOauthToken()) && almAccount.getJiraOauthToken().isCloud();
        if (!isCloud) {
            webhookVO.setName("Kendis Webhook with Account " + almAccount.getName());
        }
        if ((isLocalDeployment = new Boolean(Boolean.TRUE)).booleanValue()) {
            webhookVO.setUrl(kendisBaseURL + "/" + almAccount.getId());
        } else {
            String s3WebhookBaseUrl = this.ENV.getProperty("aws.api.jira.webhook.url");
            webhookVO.setUrl(s3WebhookBaseUrl + "/" + almAccount.getId());
        }
        events.add("jira:issue_created");
        events.add("jira:issue_updated");
        events.add("jira:issue_deleted");
        if (!isCloud) {
            events.add("issuelink_created");
            events.add("issuelink_deleted");
            events.add("sprint_started");
            events.add("sprint_closed");
            webhookVO.setEvents(events);
            webhookVO.setExcludeIssueDetails(Boolean.valueOf(true));
        } else {
            webhookVO.setExcludeIssueDetails(null);
            ArrayList<WebHookEntryVO> webhooks = new ArrayList<WebHookEntryVO>();
            WebHookEntryVO webHookEntryVO = new WebHookEntryVO();
            webHookEntryVO.setEvents(events);
            webHookEntryVO.setJqlFilter("project != null");
            webhooks.add(webHookEntryVO);
            webhookVO.setWebhooks(webhooks);
        }
        String result = null;
        try {
            result = this.exportUtil.createWebhookInJira(webhookVO, almAccount);
        }
        catch (Exception e) {
            events = new ArrayList();
            events.add("jira:issue_created");
            events.add("jira:issue_updated");
            events.add("jira:issue_deleted");
            if (!isCloud) {
                webhookVO.setEvents(events);
                webhookVO.setExcludeIssueDetails(Boolean.valueOf(true));
            } else {
                ArrayList<WebHookEntryVO> webhooks = new ArrayList<WebHookEntryVO>();
                WebHookEntryVO webHookEntryVO = new WebHookEntryVO();
                webHookEntryVO.setEvents(events);
                webHookEntryVO.setJqlFilter("project != null");
                webhooks.add(webHookEntryVO);
                webhookVO.setWebhooks(webhooks);
            }
            result = this.exportUtil.createWebhookInJira(webhookVO, almAccount);
        }
        if (PropertyValidator.isValid((Object)result)) {
            if (isCloud) {
                6 T = new /* Unavailable Anonymous Inner Class!! */;
                WebhookCloudResponseVO webhookCloudRes = (WebhookCloudResponseVO)this.gson.fromJson(result, T.getType());
                List webhookRegistrationResult = webhookCloudRes.getWebhookRegistrationResult();
                if (PropertyValidator.isValid((Collection)((WebHookEntryVO)webhookRegistrationResult.get(0)).getErrors())) {
                    return null;
                }
                almAccount.setWebhookURL(webhookVO.getUrl());
                almAccount.setWebhookId(((WebHookEntryVO)webhookRegistrationResult.get(0)).getCreatedWebhookId());
                return result;
            }
            almAccount.setWebhookURL(webhookVO.getUrl());
            return result;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebhookResponseVO checkJiraWebhookExist(String accId, AlmAccount almAcc, String originUrl) {
        String webhooks = this.importUtil.retrieveJiraWebhooks(almAcc.getUrl(), almAcc.getUsername(), almAcc.getPassword(), almAcc);
        String _url = "";
        Boolean isLocalDeployment = new Boolean(Boolean.TRUE);
        if (isLocalDeployment.booleanValue()) {
            _url = originUrl + "/webhook/" + accId;
        } else {
            String s3WebhookBaseUrl = this.ENV.getProperty("aws.api.jira.webhook.url");
            _url = s3WebhookBaseUrl + "/" + accId;
        }
        String url = _url;
        if (!PropertyValidator.isValid((Object)webhooks)) return null;
        if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && almAcc.getJiraOauthToken().isCloud()) {
            if (!PropertyValidator.isValid((Object)almAcc.getWebhookId())) return null;
            7 T = new /* Unavailable Anonymous Inner Class!! */;
            WebhookCloudResponseVO webhookCloudRes = (WebhookCloudResponseVO)this.gson.fromJson(webhooks, T.getType());
            WebhookResponseVO webhookResponse = new WebhookResponseVO();
            if (!PropertyValidator.isValid((Object)webhookCloudRes)) return null;
            webhookResponse.setWebhookCloudResponse(webhookCloudRes);
            return webhookResponse;
        }
        8 T = new /* Unavailable Anonymous Inner Class!! */;
        List responseResult = (List)this.gson.fromJson(webhooks, T.getType());
        WebhookResponseVO webhook = responseResult.stream().filter(r -> r.getUrl().equals(url)).findFirst().orElse(null);
        if (!PropertyValidator.isValid((Object)webhook)) return null;
        return webhook;
    }

    public String deleteWebhook(AlmAccount almAcc) {
        return JiraUtils.executeJiraDeleteRequest((String)almAcc.getWebhookURL(), (String)almAcc.getUsername(), (String)almAcc.getPassword(), (AlmAccount)almAcc, null, (Environment)this.ENV);
    }

    private void deleteParentTeamContainer(JiraWebhookPayload payload, Item parentItem, TeamContainer oldTC, AlmAccount almAccount) {
        payload.logActivity("Deleting parent team container for parent item: " + parentItem.getTitle());
        if (PropertyValidator.isValid((Collection)parentItem.getTeamContainers()) && oldTC != null && oldTC.getId() != null && !this.itemRepository.existsByTypeAndTeamContainersIn(Item.USER_STORY, (List)new /* Unavailable Anonymous Inner Class!! */).booleanValue()) {
            Item freshCopy = parentItem;
            ArrayList<String> teamContainerIds = new ArrayList<String>();
            teamContainerIds.add(oldTC.getId());
            HashMap<String, Boolean> itemLinksMap = new HashMap<String, Boolean>();
            int indexToRemove = -1;
            List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(teamContainerIds, teamContainerIds);
            if (PropertyValidator.isValid((Collection)itemLinks)) {
                for (ItemLink itemLink : itemLinks) {
                    itemLinksMap.put(itemLink.getSourceTeamContainerId(), true);
                    itemLinksMap.put(itemLink.getTargetTeamContainerId(), true);
                }
            }
            for (int i = 0; i < freshCopy.getTeamContainers().size(); ++i) {
                if (!((TeamContainer)freshCopy.getTeamContainers().get(i)).getId().equals(oldTC.getId())) continue;
                if (Boolean.TRUE.equals(itemLinksMap.get(oldTC.getId()))) break;
                indexToRemove = i;
                break;
            }
            if (indexToRemove > -1) {
                TeamContainer removedTC = (TeamContainer)freshCopy.getTeamContainers().remove(indexToRemove);
                this.itemRepository.save((Object)freshCopy);
                payload.logActivity("Successfully removed parent team container.");
                try {
                    String itemsStr = null;
                    ObjectMapper mapper = new ObjectMapper();
                    JSONObject pushJson = new JSONObject();
                    itemsStr = mapper.writeValueAsString((Object)freshCopy);
                    pushJson.put("isJira", false);
                    pushJson.put("type", (Object)"Feature");
                    pushJson.put("item", (Object)itemsStr);
                    pushJson.put("push", (Object)"Self");
                    pushJson.put("metaMap", (Object)("{\"event\":\"CellRemove\", \"isJira\":true, \"teamContainerId\":\"" + removedTC.getId() + "\", \"boardId\":\"" + ((SessionBoard)freshCopy.getSessionBoards().get(0)).getId() + "\"}"));
                    PushSender.sendMsg((String)payload.cid, (String)pushJson.toString());
                }
                catch (JSONException e) {
                    payload.logError(StringUtils.getTraceString((Throwable)e));
                }
                catch (JsonProcessingException e) {
                    payload.logError(StringUtils.getTraceString((Throwable)e));
                }
            }
        }
    }

    private void onJiraSprintStatusChange(String unMappedDataId, JiraWebhookMappedData jiraWebhookMappedData, String accId, List<String> logs) {
        JiraWebhookPayload jWebHookPayload = jiraWebhookMappedData.getJiraWebhookPayload();
        try {
            if (jWebHookPayload == null) {
                if (jiraWebhookMappedData.getJiraWebhookPayloadStr() == null) {
                    logs.add("Jira json payload not found (onJiraSprintStatusChange) ");
                    return;
                }
                jWebHookPayload = (JiraWebhookPayload)this.gson.fromJson(jiraWebhookMappedData.getJiraWebhookPayloadStr(), JiraWebhookPayload.class);
                jiraWebhookMappedData.setJiraWebhookPayload(jWebHookPayload);
            }
            jWebHookPayload.logs = logs;
            AlmAccount almAccount = this.almAccountRepository.findById(accId);
            List almConfigs = this.almConfigurationsRepository.findConfigsByAlmAccount(almAccount);
            if (!PropertyValidator.isValid((Collection)almConfigs)) {
                if (unMappedDataId != null) {
                    this.jiraWebhookRepository.delete((Serializable)((Object)unMappedDataId));
                }
                jWebHookPayload.logActivity("No alm configurations found for Alm Account.");
                return;
            }
            if (!PropertyValidator.isValid((Object)almAccount)) {
                this.jiraWebhookRepository.delete((Serializable)((Object)unMappedDataId));
                jWebHookPayload.logActivity("Alm account not found from configurations.");
                return;
            }
            Boolean isSpillOver = Boolean.FALSE;
            if ("sprint_closed".equals(jiraWebhookMappedData.getJiraWebhookEvent())) {
                isSpillOver = Boolean.TRUE;
            }
            String cid = this.companyRepository.findByTenant(almAccount.getTenant()).getId();
            HashMap<String, String> metaMap = new HashMap<String, String>();
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("type", "Board");
            metaMap.put("event", "DEBUG");
            metaMap.put("type", "Board");
            response.put("metaMap", this.gson.toJson(metaMap));
            List sessions = this.sessionRepository.findByAlmConfigurationsInAndArchiveOrderByCreatedOn(almConfigs, false);
            if (PropertyValidator.isValid((Collection)sessions)) {
                ArrayList<SessionBoard> boards = new ArrayList<SessionBoard>();
                HashMap<String, Session> mapBoardId = new HashMap<String, Session>();
                for (Session session : sessions) {
                    boards.add(new SessionBoard(session.getActiveSessionBoard()));
                    mapBoardId.put(session.getActiveSessionBoard(), session);
                }
                List jiraSprint = this.sprintRepository.findSprintsSprintByJiraIdAndIsVersionAndAlmAccountId(jWebHookPayload.getSprint().getId(), Boolean.valueOf(false), almAccount.getId());
                if (PropertyValidator.isValid((Collection)jiraSprint)) {
                    List mapping = this.itemSyncMapperRepository.findBySprintInAndSessionBoardIn(jiraSprint, boards);
                    if (PropertyValidator.isValid((Collection)mapping)) {
                        HashMap<String, Boolean> mapAction = new HashMap<String, Boolean>();
                        for (ItemSyncMapper itemSyncMapper : mapping) {
                            SessionBoard board = itemSyncMapper.getSessionBoard();
                            if (itemSyncMapper.getTeam() == null || itemSyncMapper.getContainer() == null) continue;
                            String bts = board.getId() + itemSyncMapper.getTeam().getId() + itemSyncMapper.getContainer().getId();
                            if (!mapBoardId.containsKey(board.getId()) || mapAction.containsKey(bts)) continue;
                            boolean takeAction = false;
                            if (!Boolean.TRUE.equals(isSpillOver) && Boolean.TRUE.equals(((Session)mapBoardId.get(board.getId())).getStartSprintWebhookEnabled())) {
                                takeAction = true;
                            } else if (Boolean.TRUE.equals(isSpillOver) && Boolean.TRUE.equals(((Session)mapBoardId.get(board.getId())).getEndSprintWebhookEnabled())) {
                                takeAction = true;
                            }
                            if (takeAction) {
                                ArrayList<String> tids = new ArrayList<String>();
                                tids.add(itemSyncMapper.getTeam().getId());
                                ArrayList<String> sids = new ArrayList<String>();
                                sids.add(itemSyncMapper.getContainer().getId());
                                HashMap map = new HashMap();
                                KendisUtils.putStartEndSprintParam(map, (SessionBoard)board, tids, sids);
                                this.customRepositoryImpl.saveSpillOverOver("Webhook", map, tids, sids, cid, null, isSpillOver, jWebHookPayload.getSprint(), null, true);
                                if (isSpillOver.booleanValue() && !board.getStatus().equalsIgnoreCase("Closed")) {
                                    this.sprintReportServics.callSprintReportFunctionWithDelay(board.getSession().getId(), itemSyncMapper.getContainer().getId(), null, null, "Webhook");
                                }
                            }
                            mapAction.put(bts, true);
                        }
                    }
                    for (Sprint sprint : jiraSprint) {
                        if (!PropertyValidator.isValid((Object)jWebHookPayload.getSprint().getState()) || jWebHookPayload.getSprint().getState().equals(sprint.getState())) continue;
                        sprint.setState(jWebHookPayload.getSprint().getState());
                    }
                    this.sprintRepository.save((Iterable)jiraSprint);
                    jWebHookPayload.logActivity("Successfully updated Jira sprint.");
                } else {
                    jWebHookPayload.logActivity("No sprint found for Jira ID or Alm account.");
                }
            }
        }
        catch (Exception e) {
            String ex = StringUtils.getTraceString((Throwable)e);
            LOGGER.error("FAILED to apply changes from jira sprint start Webhook.");
            LOGGER.error(ex);
            JiraWebhookMappedData webhookData = null;
            if (PropertyValidator.isValid((Object)unMappedDataId)) {
                webhookData = (JiraWebhookMappedData)this.jiraWebhookRepository.findOne((Serializable)((Object)unMappedDataId));
            } else {
                webhookData = new JiraWebhookMappedData();
                webhookData.setJiraWebhookPayload(jWebHookPayload);
                webhookData.setAlmAccountId(accId);
            }
            webhookData.setErrorDescription(ex);
            webhookData.setHasError(Boolean.valueOf(true));
            jWebHookPayload.logError("Exception :: FAILED to apply changes from jira sprint start Webhook.");
            jWebHookPayload.logError(ex);
        }
    }

    public void updateBackLogItem(JiraWebhookMappedData webhook, List<String> logs) {
        if (webhook.getJiraWebhookPayload() == null) {
            if (webhook.getJiraWebhookPayloadStr() == null) {
                logs.add("Jira json payload not found (updateBackLogItem) ");
                return;
            }
            webhook.setJiraWebhookPayload((JiraWebhookPayload)this.gson.fromJson(webhook.getJiraWebhookPayloadStr(), JiraWebhookPayload.class));
        }
        JiraWebhookPayload payload = webhook.getJiraWebhookPayload();
        JiraIssue2 issue = webhook.getJiraWebhookPayload().getIssue();
        ArrayList<JiraIssue2> issues = new ArrayList<JiraIssue2>();
        HashSet<String> jiraIds = new HashSet<String>();
        payload.logs = logs;
        try {
            boolean issueUpdatedEvent = false;
            String jiraId = "";
            if (issue != null) {
                jiraId = issue.getId();
                if ("jira:issue_updated".equals(payload.getWebhookEvent())) {
                    issueUpdatedEvent = true;
                    payload.logActivity("ENABLING_CHECK_FOR_ISSUE_UPDATED_EVENT");
                }
                issues.add(issue);
                jiraIds.add(jiraId);
            } else if (payload.getIssueLink() != null) {
                JiraIssueLinkPayload issueLinkPayload = payload.getIssueLink();
                jiraIds.add(issueLinkPayload.getSourceIssueId());
                jiraIds.add(issueLinkPayload.getDestinationIssueId());
                JiraIssue2 js = this.getIssue(issueLinkPayload.getSourceIssueId(), payload, null);
                if (js != null && js.getFields() != null && !js.getFields().containsKey("empty")) {
                    issues.add(js);
                }
                if ((js = this.getIssue(issueLinkPayload.getDestinationIssueId(), payload, null)) != null && js.getFields() != null && !js.getFields().containsKey("empty")) {
                    issues.add(js);
                }
            }
            new Thread(() -> {
                try {
                    String cid = this.companyRepository.findByTenant(webhook.getTenantId()).getId();
                    AlmAccount almAccount = webhook.getAlmAccount();
                    if (almAccount == null || almAccount.getUsername() == null) {
                        almAccount = this.almAccountRepository.findById(webhook.getAlmAccountId());
                    }
                    if ("issuelink_deleted".equals(payload.getWebhookEvent())) {
                        this.customRepositoryImpl.onJiraRemoveIssue(Boolean.valueOf(false), cid, jiraIds, jiraIds, almAccount);
                    } else if ("jira:issue_deleted".equals(payload.getWebhookEvent())) {
                        this.customRepositoryImpl.onJiraRemoveIssue(Boolean.valueOf(true), cid, jiraIds, null, almAccount);
                    } else if (PropertyValidator.isValid((Collection)issues) || PropertyValidator.isValid((Collection)jiraIds)) {
                        this.releaseTrainServiceImpl.onJiraSyncWhbhook(cid, issues, jiraIds, almAccount, payload.getWebhookEvent());
                    }
                }
                catch (Exception e) {
                    this.printLogs(webhook.getAlmAccount().getId(), StringUtils.getTraceString((Throwable)e));
                }
            }).start();
            if (issueUpdatedEvent) {
                payload.logActivity("COMPLETED_PROCESSING_FOR_UPDATE_EVENT");
            }
            WebhookActivityUtil.getInstance().reset();
            if (webhook.getMongoId() != null) {
                try {
                    this.jiraWebhookRepository.delete((Serializable)((Object)webhook.getMongoId()));
                }
                catch (Exception e) {
                    LOGGER.warn("Multiple instance sync issue ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            String ex = "ALM Id:" + webhook.getAlmAccountId() + "stack trace: " + StringUtils.getTraceString((Throwable)e) + " webhook payload:" + webhook.getJiraWebhookPayloadStr();
            LOGGER.error(ex);
            payload.logError(ex);
        }
    }

    private boolean isTfsItemChanged(TFSWebhookMappedData tfsWebhookMappedData, List<SessionBoard> sessionIds, String tenant) {
        try {
            JSONObject tfsPayLoad = tfsWebhookMappedData.payload();
            String eventType = tfsPayLoad.getString("eventType");
            if (!PropertyValidator.isValid(sessionIds)) {
                WebhookActivityUtil.getInstance().addOneTfsCausedBy("No session boards found.");
            }
            if ("workitem.updated".equals(eventType)) {
                JSONObject tfsItemObject = tfsPayLoad.getJSONObject("resource");
                String tfsId = null;
                if (!tfsItemObject.isNull("workItemId")) {
                    tfsId = tfsItemObject.getString("workItemId");
                } else if (!tfsItemObject.isNull("id")) {
                    tfsId = tfsItemObject.getString("id");
                }
                WebhookActivityUtil.getInstance().setTfsId(tfsId);
                List itemsFromDb = this.itemRepository.findByTfsIdAndSessionBoardsInAndTenantAndArchive(tfsId, sessionIds, tenant, false);
                if (!tfsItemObject.isNull("relations")) {
                    JSONObject relationsObject = tfsItemObject.getJSONObject("relations");
                    for (Item item : itemsFromDb) {
                        Set deletedTfsIds;
                        Item childItem;
                        Iterator iterator;
                        Object childItems;
                        JSONArray relationsAdded;
                        if (!(relationsObject.isNull("added") || PropertyValidator.isValid((Object)item.getParent()) && PropertyValidator.isValid((Object)item.getParent().getId()))) {
                            relationsAdded = relationsObject.getJSONArray("added");
                            Set newAddedTfsIds = this.getTfsIdsFromUrlAndItemLinkTypes(relationsAdded, item);
                            childItems = this.itemRepository.findByTfsIdInAndSessionBoardsInAndTenantAndArchive(newAddedTfsIds, sessionIds, tenant, false);
                            iterator = childItems.iterator();
                            while (iterator.hasNext()) {
                                childItem = (Item)iterator.next();
                                if (PropertyValidator.isValid((Object)childItem.getParent())) continue;
                                return false;
                            }
                        }
                        if (!(relationsObject.isNull("removed") || PropertyValidator.isValid((Object)item.getParent()) && PropertyValidator.isValid((Object)item.getParent().getId()) || !PropertyValidator.isValid((Collection)(childItems = this.itemRepository.findByTfsIdInAndSessionBoardsInAndTenantAndArchive(deletedTfsIds = this.getTfsIdsFromUrlAndItemLinkTypes(relationsAdded = relationsObject.getJSONArray("removed"), item), sessionIds, tenant, false))))) {
                            iterator = childItems.iterator();
                            while (iterator.hasNext()) {
                                childItem = (Item)iterator.next();
                                if (!PropertyValidator.isValid((Object)childItem.getParent())) continue;
                                return false;
                            }
                        }
                        if (!relationsObject.isNull("added") && PropertyValidator.isValid((Collection)((SessionBoard)item.getSessionBoards().get(0)).getSession().getJiraLinkTypes())) {
                            relationsAdded = relationsObject.getJSONArray("added");
                            for (int i = 0; i < relationsAdded.length(); ++i) {
                                if (!this.checkErrorExistForItemDependency(relationsAdded.getJSONObject(i), item, tenant, true)) continue;
                                return false;
                            }
                        }
                        if (relationsObject.isNull("removed") || !PropertyValidator.isValid((Collection)((SessionBoard)item.getSessionBoards().get(0)).getSession().getJiraLinkTypes())) continue;
                        relationsAdded = relationsObject.getJSONArray("removed");
                        for (int i = 0; i < relationsAdded.length(); ++i) {
                            if (!this.checkErrorExistForItemDependency(relationsAdded.getJSONObject(i), item, tenant, false)) continue;
                            return false;
                        }
                    }
                }
                if (!tfsItemObject.isNull("fields")) {
                    for (Item item : itemsFromDb) {
                        HashMap<String, TFSProject> tfsProjectsMap = new HashMap<String, TFSProject>();
                        HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
                        List tfsProjects = this.tfsProjectRepository.findProjectBySessionId(((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
                        if (PropertyValidator.isValid((Collection)tfsProjects)) {
                            for (TFSProject tfsProject : tfsProjects) {
                                tfsProjectsMap.put(tfsProject.getTfsId(), tfsProject);
                                tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
                            }
                        }
                        if (!tfsItemObject.isNull("revision")) {
                            JSONObject tfsItemRevision = tfsItemObject.getJSONObject("revision");
                            if (!tfsItemRevision.isNull("fields")) {
                                JSONObject tfsFields = tfsItemRevision.getJSONObject("fields");
                                String iterationPath = (String)tfsFields.get("System.IterationPath");
                                String areaPath = (String)tfsFields.get("System.AreaPath");
                                TFSProject tfsProject = this.getTfsProjectFromWebhook(tfsFields, tfsItemRevision, tfsProjectsMap, tfsProjectsMapByName);
                                if (!PropertyValidator.isValid((Object)tfsProject)) continue;
                                HashMap<String, String> itemFieldNames = new HashMap<String, String>();
                                HashMap<String, String> tfsProjectFields = new HashMap<String, String>();
                                if (Item.FEATURE.equals(item.getType())) {
                                    tfsProjectFields.put("storyPoints", tfsProject.getItemEstimationField());
                                    tfsProjectFields.put("dueDate", tfsProject.getItemDueDateField());
                                    tfsProjectFields.put("startDate", tfsProject.getItemStartDateField());
                                    tfsProjectFields.put("endDate", tfsProject.getItemEndDateField());
                                    itemFieldNames.put("storyPoints", "storyPoints");
                                    itemFieldNames.put("dueDate", "dueDate");
                                    itemFieldNames.put("startDate", "startDate");
                                    itemFieldNames.put("endDate", "endDate");
                                } else if (Item.USER_STORY.equals(item.getType())) {
                                    tfsProjectFields.put("storyPoints", tfsProject.getSubItemEstimationField());
                                    tfsProjectFields.put("dueDate", tfsProject.getSubItemDueDateField());
                                    tfsProjectFields.put("startDate", tfsProject.getSubItemStartDateField());
                                    tfsProjectFields.put("endDate", tfsProject.getSubItemEndDateField());
                                    itemFieldNames.put("storyPoints", "subStoryPoints");
                                    itemFieldNames.put("dueDate", "subDueDate");
                                    itemFieldNames.put("startDate", "subStartDate");
                                    itemFieldNames.put("endDate", "subEndDate");
                                }
                                this.compareItemWithTfsWebhookRevision(item, tfsFields, tfsProjectFields, itemFieldNames);
                                if (!PropertyValidator.isValid((Object)item.getParent()) || tfsFields.isNull("System.IterationPath") && tfsFields.isNull("System.AreaPath")) continue;
                                if (!PropertyValidator.isValid((Object)item.getTfsAreaPath()) || !item.getTfsAreaPath().equals(areaPath)) {
                                    return false;
                                }
                                if (PropertyValidator.isValid((Object)item.getTfsIterationPath()) && item.getTfsIterationPath().equals(iterationPath)) continue;
                                return false;
                            }
                            WebhookActivityUtil.getInstance().addOneTfsCausedBy("No fields retrieved from webhook revision.");
                            continue;
                        }
                        WebhookActivityUtil.getInstance().addOneTfsCausedBy("No revision found in webhook.");
                    }
                    return !PropertyValidator.isValid((Collection)WebhookActivityUtil.getInstance().getTfsFailedFields());
                }
            } else if ("workitem.deleted".equals(eventType)) {
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error occurred in isTfsItemChanged: ", (Throwable)ex);
        }
        return true;
    }

    private void compareItemWithTfsWebhookRevision(Item item, JSONObject tfsFields, Map<String, String> tfsProjectFields, Map<String, String> itemFieldNames) {
        if (PropertyValidator.isValid(tfsProjectFields) && PropertyValidator.isValid(itemFieldNames)) {
            if (PropertyValidator.isValid((Object)tfsProjectFields.get("storyPoints")) && !tfsFields.isNull(tfsProjectFields.get("storyPoints"))) {
                double storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProjectFields.get("storyPoints"))));
                if (PropertyValidator.isValid((Object)storyPoint)) {
                    storyPoint = StringUtils.round((double)storyPoint, (int)2);
                    if (PropertyValidator.isValid((Object)item.getStoryPoints()) && item.getStoryPoints() != storyPoint) {
                        WebhookActivityUtil.getInstance().addTfsFailedField(itemFieldNames.get("storyPoints"));
                    }
                }
            } else if (PropertyValidator.isValid((Object)tfsProjectFields.get("storyPoints"))) {
                WebhookActivityUtil.getInstance().addTfsFailedField(itemFieldNames.get("storyPoints"));
            }
            if (PropertyValidator.isValid((Object)tfsProjectFields.get("dueDate")) && !tfsFields.isNull(tfsProjectFields.get("dueDate"))) {
                String dueDateStr = (String)tfsFields.get(tfsProjectFields.get("dueDate"));
                if (PropertyValidator.isValid((Object)dueDateStr) && PropertyValidator.isValid((Object)item.getDueDate()) && dueDateStr.equals(item.getDueDate().toString())) {
                    WebhookActivityUtil.getInstance().addTfsFailedField(itemFieldNames.get("dueDate"));
                }
            } else if (PropertyValidator.isValid((Object)tfsProjectFields.get("dueDate"))) {
                WebhookActivityUtil.getInstance().addTfsFailedField(itemFieldNames.get("dueDate"));
            }
            if (PropertyValidator.isValid((Object)tfsProjectFields.get("startDate")) && !tfsFields.isNull(tfsProjectFields.get("startDate"))) {
                String startDateStr = (String)tfsFields.get(tfsProjectFields.get("startDate"));
                if (PropertyValidator.isValid((Object)startDateStr) && PropertyValidator.isValid((Object)item.getStartDate()) && startDateStr.equals(item.getStartDate().toString())) {
                    WebhookActivityUtil.getInstance().addTfsFailedField(itemFieldNames.get("startDate"));
                }
            } else if (PropertyValidator.isValid((Object)tfsProjectFields.get("startDate"))) {
                WebhookActivityUtil.getInstance().addTfsFailedField(itemFieldNames.get("startDate"));
            }
            if (PropertyValidator.isValid((Object)tfsProjectFields.get("endDate")) && !tfsFields.isNull(tfsProjectFields.get("endDate"))) {
                String endDateStr = (String)tfsFields.get(tfsProjectFields.get("endDate"));
                if (PropertyValidator.isValid((Object)endDateStr) && PropertyValidator.isValid((Object)item.getEndDate()) && endDateStr.equals(item.getEndDate().toString())) {
                    WebhookActivityUtil.getInstance().addTfsFailedField(itemFieldNames.get("endDate"));
                }
            } else if (PropertyValidator.isValid((Object)tfsProjectFields.get("endDate"))) {
                WebhookActivityUtil.getInstance().addTfsFailedField(itemFieldNames.get("endDate"));
            }
        }
    }

    private TFSProject getTfsProjectFromWebhook(JSONObject tfsFields, JSONObject tfsItemRevision, Map<String, TFSProject> tfsProjectsMap, Map<String, TFSProject> tfsProjectsMapByName) {
        String url = tfsItemRevision.getString("url");
        String[] urlComponents = url.split("/");
        String teamProject = (String)tfsFields.get("System.TeamProject");
        TFSProject tfsProject = null;
        String projectId = urlComponents.length >= 9 ? urlComponents[4] : urlComponents[3];
        try {
            tfsProject = tfsProjectsMap.containsKey(projectId) ? tfsProjectsMap.get(projectId) : tfsProjectsMapByName.get(teamProject);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return tfsProject;
    }

    private Set<String> getTfsIdsFromUrlAndItemLinkTypes(JSONArray relations, Item item) {
        HashSet<String> newAddedTfsIds = new HashSet<String>();
        for (int i = 0; i < relations.length(); ++i) {
            try {
                JSONObject newAddedObject = relations.getJSONObject(i);
                String rel = newAddedObject.getString("rel");
                String newAddedTFSId = this.getTfsIdFromUrl(newAddedObject);
                if (!item.getTfsLinkTypes().contains(rel)) continue;
                newAddedTfsIds.add(newAddedTFSId);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(" ::  Exception while getting new tfs id: isTfsItemChanged ::  " + e);
            }
        }
        return newAddedTfsIds;
    }

    private String getTfsIdFromUrl(JSONObject jsonObject) {
        String newAddedTFSId = null;
        try {
            String url = jsonObject.getString("url");
            newAddedTFSId = url.substring(url.lastIndexOf("/") + 1);
        }
        catch (Exception e) {
            LOGGER.error(" ::  Exception while getting new tfs id: getTfsIdFromUrl ::  " + e);
        }
        return newAddedTFSId;
    }

    private boolean checkErrorExistForItemDependency(JSONObject jsonObject, Item item, String tenant, boolean dependencyAdded) {
        String rel = jsonObject.getString("rel");
        String newAddedTFSId = this.getTfsIdFromUrl(jsonObject);
        boolean dependecyFound = false;
        if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
            ItemJiraDependency tfsDependency = new ItemJiraDependency();
            tfsDependency.setSourceItemId(item.getId());
            tfsDependency.setTfsLinkType(rel);
            Item targetItem = this.itemRepository.findTFSIdBySessionBoardsIdInAndTfsIdAndTenantAndArchive(((SessionBoard)item.getSessionBoards().get(0)).getId(), newAddedTFSId, tenant, false);
            if (PropertyValidator.isValid((Object)targetItem)) {
                tfsDependency.setTargetItemId(targetItem.getId());
            }
            for (int i = 0; i < item.getJiraDependencies().size(); ++i) {
                ItemJiraDependency existingDependency = (ItemJiraDependency)item.getJiraDependencies().get(i);
                if (!PropertyValidator.isValid((Object)existingDependency)) continue;
                if (PropertyValidator.isValid((Object)tfsDependency.getSourceItemId()) && PropertyValidator.isValid((Object)tfsDependency.getTargetItemId()) && PropertyValidator.isValid((Object)tfsDependency.getTfsLinkType()) && tfsDependency.getSourceItemId().equals(existingDependency.getSourceItemId()) && tfsDependency.getTargetItemId().equals(existingDependency.getTargetItemId()) && tfsDependency.getTfsLinkType().equals(existingDependency.getTfsLinkType())) {
                    dependecyFound = true;
                    if (dependencyAdded) continue;
                    return true;
                }
                if (!dependencyAdded || i != item.getJiraDependencies().size() - 1 || dependecyFound) continue;
                return true;
            }
        } else {
            return dependencyAdded;
        }
        return false;
    }

    private List<SessionBoard> nativeFindBySessionInAndParentBoardIsNullOrderByCreatedOnDesc(List<ObjectId> sessionIds, String tenant) {
        if (!PropertyValidator.isValid(sessionIds)) {
            return new LinkedList<SessionBoard>();
        }
        LinkedList<SessionBoard> sessionBoards = new LinkedList<SessionBoard>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject((Map)new BasicDBObject().append("session.$id", (Object)new BasicDBObject("$in", sessionIds)).append("parentBoard", null).append("archive", (Object)false).append("tenant", (Object)tenant)));
        BasicDBObject sortStage = new BasicDBObject("$sort", (Object)new BasicDBObject("createdOn", (Object)-1));
        BasicDBObject stateLookup = DBUtils.createLookup((String)"state", (String)"state.$id", (String)"_id", (String)"state");
        BasicDBObject stateUnwind = DBUtils.createUnWindWithPath((String)"$state", (boolean)true);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("id", (Object)1).append("state.title", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, stateLookup, stateUnwind, sortStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                DBObject dbObject = (DBObject)dbCursor.next();
                SessionBoard sessionBoard = new SessionBoard();
                sessionBoard.setId(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)dbObject), (String[])new String[0]));
                if (PropertyValidator.isValid((Object)dbObject.get("state"))) {
                    BasicDBObject stateObj = (BasicDBObject)dbObject.get("state");
                    State state = new State();
                    state.setTitle(stateObj.getString("title"));
                    sessionBoard.setState(state);
                }
                sessionBoards.add(sessionBoard);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return sessionBoards;
    }

    private static /* synthetic */ boolean lambda$handleEpicLink$6(Item item, JiraFilter r) {
        return r.getId().equals(item.getJiraFilter());
    }

    private static /* synthetic */ boolean lambda$handleEpicLink$5(Item item, JiraFilter r) {
        return r.getId().equals(item.getJiraFilter());
    }

    private static /* synthetic */ boolean lambda$handleEpicLink$4(Item item, JiraFilter r) {
        return r.getId().equals(item.getJiraFilter());
    }

    static /* synthetic */ ALMSyncService access$000(WebHookSyncServiceImpl x0) {
        return x0.almSyncService;
    }

    static /* synthetic */ Item access$100(WebHookSyncServiceImpl x0, Item x1, Item x2, JiraIssue2 x3, Map x4, Map x5, JiraField x6, AlmAccount x7, List x8) {
        return x0.createNewChildFromJiraIssue(x1, x2, x3, x4, x5, x6, x7, x8);
    }

    static /* synthetic */ void access$200(WebHookSyncServiceImpl x0, String x1, String x2) {
        x0.pushWebhook(x1, x2);
    }

    static /* synthetic */ ItemRepository access$300(WebHookSyncServiceImpl x0) {
        return x0.itemRepository;
    }

    static /* synthetic */ CustomRepositoryImpl access$400(WebHookSyncServiceImpl x0) {
        return x0.customRepositoryImpl;
    }

    static /* synthetic */ void access$500(WebHookSyncServiceImpl x0, Collection x1, String x2, String x3) {
        x0.pushEmptyCardsTC(x1, x2, x3);
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }

    static /* synthetic */ RTItemTfsSyncService access$700(WebHookSyncServiceImpl x0) {
        return x0.rtItemTfsSyncService;
    }

    static /* synthetic */ TFSRiskService access$800(WebHookSyncServiceImpl x0) {
        return x0.tfsRiskService;
    }
}

