/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.entity.ALMFilter;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.TFSWebhookMappedData;
import com.viztrend.safe.alm.tfs.TFSFilter;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.ConfigAndMapping;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAttributes;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.ConfigAndMappingRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.service.TFSRiskService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@Component(value="TFSRiskService")
public class TFSRiskServiceImpl
implements TFSRiskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TFSRiskServiceImpl.class);
    @Autowired
    private ConfigAndMappingRepository configAndMappingRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private ItemRepository itemRepository;

    /*
     * Unable to fully structure code
     */
    public HashMap<String, Object> saveMultipleRiskOnTFS(List<Risk> risks, RiskRegister riskRegister, HashMap<String, Object> params) throws Exception {
        result = new HashMap<String, Object>();
        successfulRisks = new ArrayList<E>();
        failedRisks = new ArrayList<Risk>();
        TFSRiskServiceImpl.LOGGER.info("Starting saveMultipleRiskOnTFS for {} risks", (Object)risks.size());
        config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)riskRegister.getConfigId());
        if (PropertyValidator.isValid((Object)config)) {
            if (PropertyValidator.isValid((Collection)config.getRiskFieldsMappings())) {
                workItemType = config.getRiskItemTypeName();
                almAccount = config.getAlmAccount();
                riskFeildsMapById = new HashMap<String, Map>();
                for (Map fieldMapping : config.getRiskFieldsMappings()) {
                    riskFeildsMapById.put((String)fieldMapping.get("id"), fieldMapping);
                }
                body = new JSONObject();
                requests = new JSONArray();
                for (Risk risk : risks) {
                    if (!PropertyValidator.isValid((Object)risk.getTfsAttributes()) || !PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsId())) {
                        TFSRiskServiceImpl.LOGGER.warn("Risk {} does not have TFS attributes or TFS ID, skipping", (Object)risk.getId());
                        failedRisks.add(risk);
                        continue;
                    }
                    fields = new JSONArray();
                    if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsIterationPath())) {
                        obj = new JSONObject();
                        obj.put("path", (Object)"/fields/System.IterationPath");
                        obj.put("value", (Object)risk.getTfsAttributes().getTfsIterationPath());
                        fields.put((Object)obj);
                    }
                    if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsAreaPath())) {
                        obj = new JSONObject();
                        obj.put("path", (Object)"/fields/System.AreaPath");
                        obj.put("value", (Object)risk.getTfsAttributes().getTfsAreaPath());
                        fields.put((Object)obj);
                    }
                    if (PropertyValidator.isValid((Object)(titleFieldMapping = (Map)riskFeildsMapById.get("title")))) {
                        path = "/fields/" + (String)titleFieldMapping.get("value");
                        obj = new JSONObject();
                        obj.put("path", (Object)path);
                        obj.put("value", (Object)risk.getRiskTitle());
                        fields.put((Object)obj);
                    }
                    if (PropertyValidator.isValid((Object)(statusFieldMapping = (Map)riskFeildsMapById.get("status")))) {
                        path = "/fields/" + (String)statusFieldMapping.get("value");
                        obj = new JSONObject();
                        obj.put("path", (Object)path);
                        obj.put("value", (Object)risk.getStatus().getTitle());
                        fields.put((Object)obj);
                    }
                    if (PropertyValidator.isValid((Object)(raisedDateFieldMapping = (Map)riskFeildsMapById.get("raisedDate"))) && PropertyValidator.isValid(raisedDateFieldMapping.get("value")) && PropertyValidator.isValid((Object)risk.getRaisedDate())) {
                        path = "/fields/" + (String)raisedDateFieldMapping.get("value");
                        obj = new JSONObject();
                        obj.put("path", (Object)path);
                        tz = TimeZone.getTimeZone("UTC");
                        df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                        _date = df.format(risk.getRaisedDate());
                        obj.put("value", (Object)_date);
                        fields.put((Object)obj);
                    }
                    if (PropertyValidator.isValid((Object)(resolutionDateFieldMapping = (Map)riskFeildsMapById.get("resolutionDate"))) && PropertyValidator.isValid(resolutionDateFieldMapping.get("value")) && PropertyValidator.isValid((Object)risk.getResolutionDate())) {
                        path = "/fields/" + (String)resolutionDateFieldMapping.get("value");
                        obj = new JSONObject();
                        obj.put("path", (Object)path);
                        tz = TimeZone.getTimeZone("UTC");
                        df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                        _date = df.format(risk.getResolutionDate());
                        obj.put("value", (Object)_date);
                        fields.put((Object)obj);
                    }
                    if (PropertyValidator.isValid((Object)(descriptionFieldMapping = (Map)riskFeildsMapById.get("description"))) && PropertyValidator.isValid((Object)(value = (String)descriptionFieldMapping.get("value"))) && value.length() != 0) {
                        path = "/fields/" + value;
                        obj = new JSONObject();
                        obj.put("path", (Object)path);
                        if (PropertyValidator.isValid((Object)risk.getRiskDesc())) {
                            obj.put("value", (Object)risk.getRiskDesc());
                        } else {
                            obj.put("value", (Object)"");
                        }
                        fields.put((Object)obj);
                    }
                    if (PropertyValidator.isValid((Object)(mitigationFieldMapping = (Map)riskFeildsMapById.get("mitigationAction"))) && PropertyValidator.isValid((Object)(value = (String)mitigationFieldMapping.get("value"))) && value.length() != 0) {
                        path = "/fields/" + (String)value;
                        obj = new JSONObject();
                        obj.put("path", (Object)path);
                        if (PropertyValidator.isValid((Object)risk.getMitigationActions())) {
                            obj.put("value", (Object)risk.getMitigationActions());
                        } else {
                            obj.put("value", (Object)"");
                        }
                        fields.put((Object)obj);
                    }
                    if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Collection)risk.getTfsAttributes().getTfsFieldMap())) {
                        value = risk.getTfsAttributes().getTfsFieldMap().iterator();
                        while (value.hasNext()) {
                            tfsField = (ItemJiraFieldMap)value.next();
                            obj = new JSONObject();
                            obj.put("path", (Object)("/fields/" + tfsField.getKey()));
                            addField = true;
                            readonly = false;
                            if (tfsField.getReadonly().booleanValue()) {
                                readonly = true;
                                addField = false;
                            }
                            if (tfsField.getType().equals("boolean")) {
                                obj.put("value", Boolean.parseBoolean(tfsField.getValue()));
                            } else if (tfsField.getType().equals("integer")) {
                                if (PropertyValidator.isValid((Object)tfsField.getValue())) {
                                    obj.put("value", Integer.parseInt(tfsField.getValue()));
                                } else {
                                    addField = false;
                                }
                            } else if (tfsField.getType().equals("double")) {
                                if (PropertyValidator.isValid((Object)tfsField.getValue())) {
                                    obj.put("value", Double.parseDouble(tfsField.getValue()));
                                } else {
                                    addField = false;
                                }
                            } else if (PropertyValidator.isValid((Object)tfsField.getValue())) {
                                obj.put("value", (Object)tfsField.getValue());
                            } else {
                                addField = false;
                            }
                            if (!addField) continue;
                            fields.put((Object)obj);
                        }
                    }
                    for (a = 0; a < fields.length(); ++a) {
                        obj = (JSONObject)fields.get(a);
                        obj.put("op", (Object)"add");
                    }
                    request = new JSONObject();
                    request.put("method", (Object)"PATCH");
                    uri = "/_apis/wit/workitems/" + risk.getTfsAttributes().getTfsId() + "?api-version=5.1";
                    request.put("uri", (Object)uri);
                    headers = new JSONObject();
                    headers.put("Content-Type", (Object)"application/json-patch+json");
                    request.put("headers", (Object)headers);
                    request.put("body", (Object)fields);
                    requests.put((Object)request);
                }
                if (requests.length() > 0) {
                    body.put("requests", (Object)requests);
                    url = "/_apis/wit/$batch";
                    requestBody = requests.toString();
                    TFSRiskServiceImpl.LOGGER.info("Sending batch request to TFS with {} requests", (Object)requests.length());
                    TFSRiskServiceImpl.LOGGER.debug("Batch request body: {}", (Object)requestBody);
                    try {
                        tfsResponse = this.tfsUtils.postRequest(url, requestBody, almAccount);
                        if (PropertyValidator.isValid((Object)tfsResponse)) {
                            TFSRiskServiceImpl.LOGGER.info("Received TFS response with status code: {}", (Object)tfsResponse.getStatusCode());
                            responseContent = tfsResponse.getContent();
                            if (PropertyValidator.isValid((Object)responseContent)) {
                                TFSRiskServiceImpl.LOGGER.debug("TFS batch response content: {}", (Object)responseContent);
                                try {
                                    batchResponse = new JSONObject(responseContent);
                                    if (!batchResponse.has("responses")) ** GOTO lbl250
                                }
                                catch (JSONException batchResponse) {}
                            }
                            TFSRiskServiceImpl.LOGGER.error("TFS response content is null or empty");
                            result.put("success", false);
                            result.put("error", "Empty response from TFS batch API");
                        }
                        TFSRiskServiceImpl.LOGGER.error("TFS response is null");
                        result.put("success", false);
                        result.put("error", "No response from TFS batch API");
                    }
                    catch (ViztrendJiraException vje) {
                        TFSRiskServiceImpl.LOGGER.error("TFS API exception during batch request: {}", (Object)StringUtils.getTraceString((Throwable)vje));
                        for (Risk risk : risks) {
                            try {
                                freshRisk = (Risk)this.riskRepository.findOne((Serializable)risk.getId());
                                if (freshRisk == null) continue;
                                freshRisk.setErrorInAlmSync(Boolean.valueOf(true));
                                freshRisk.setAlmErrorMessage(vje.getMessage());
                                this.riskRepository.save((Object)freshRisk);
                                failedRisks.add(freshRisk);
                            }
                            catch (Exception e) {
                                TFSRiskServiceImpl.LOGGER.error("Error updating risk {} with API error: {}", (Object)risk.getId(), (Object)e.getMessage());
                                failedRisks.add(risk);
                            }
                        }
                        result.put("success", false);
                        result.put("error", vje.getMessage());
                    }
                    catch (Exception e) {
                        TFSRiskServiceImpl.LOGGER.error("Unexpected error during batch request: {}", (Object)StringUtils.getTraceString((Throwable)e));
                        result.put("success", false);
                        result.put("error", "Unexpected error: " + e.getMessage());
                        for (Risk risk : risks) {
                            failedRisks.add(risk);
                        }
                    }
                } else {
                    TFSRiskServiceImpl.LOGGER.warn("No valid requests to send - all risks failed validation");
                    result.put("success", false);
                    result.put("error", "No valid risks to process");
                }
            } else {
                TFSRiskServiceImpl.LOGGER.error("Risk fields mappings not found in config");
                result.put("success", false);
                result.put("error", "Risk fields mappings not configured");
            }
        } else {
            TFSRiskServiceImpl.LOGGER.error("Config not found for risk register {}", (Object)riskRegister.getId());
            result.put("success", false);
            result.put("error", "Configuration not found");
        }
lbl250:
        // 10 sources

        hasSuccessfulRisks = successfulRisks.size() > 0;
        result.put("success", hasSuccessfulRisks);
        result.put("successfulRisks", successfulRisks);
        result.put("failedRisks", failedRisks);
        result.put("totalProcessed", risks.size());
        result.put("successCount", successfulRisks.size());
        result.put("failureCount", failedRisks.size());
        TFSRiskServiceImpl.LOGGER.info("Batch update completed: {} successful, {} failed out of {} total", new Object[]{successfulRisks.size(), failedRisks.size(), risks.size()});
        return result;
    }

    public HashMap<String, Object> saveRiskOnTFS(Risk risk, RiskRegister riskRegister, HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> result;
        block46: {
            result = new HashMap<String, Object>();
            boolean isUpdate = (Boolean)params.get("update");
            ConfigAndMapping config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)riskRegister.getConfigId()));
            if (PropertyValidator.isValid((Object)config)) {
                if (PropertyValidator.isValid((Collection)config.getRiskFieldsMappings())) {
                    JSONObject obj;
                    Object value;
                    Map mitigationFieldMapping;
                    JSONObject obj2;
                    String value2;
                    Map descriptionFieldMapping;
                    Map resolutionDateFieldMapping;
                    Map raisedDateFieldMapping;
                    Map statusFieldMapping;
                    Map titleFieldMapping;
                    JSONObject obj3;
                    String workItemType = config.getRiskItemTypeName();
                    AlmAccount almAccount = config.getAlmAccount();
                    HashMap<String, Status> statusMapByTitle = new HashMap<String, Status>();
                    List statuses = this.statusRepository.findByTfsProjectIdAndAlmIdAndItemType(config.getTfsProjectTfsId(), almAccount.getId(), workItemType);
                    for (Object st : statuses) {
                        statusMapByTitle.put(st.getTitle(), (Status)st);
                    }
                    HashMap<String, Map> riskFeildsMapById = new HashMap<String, Map>();
                    for (Map fieldMapping : config.getRiskFieldsMappings()) {
                        riskFeildsMapById.put((String)fieldMapping.get("id"), fieldMapping);
                    }
                    JSONArray fields = new JSONArray();
                    JSONObject itemTypeObj = new JSONObject();
                    itemTypeObj.put("path", (Object)"/fields/System.WorkItemType");
                    itemTypeObj.put("value", (Object)workItemType);
                    fields.put((Object)itemTypeObj);
                    if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsIterationPath())) {
                        obj3 = new JSONObject();
                        obj3.put("path", (Object)"/fields/System.IterationPath");
                        obj3.put("value", (Object)risk.getTfsAttributes().getTfsIterationPath());
                        fields.put((Object)obj3);
                    }
                    if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsAreaPath())) {
                        obj3 = new JSONObject();
                        obj3.put("path", (Object)"/fields/System.AreaPath");
                        obj3.put("value", (Object)risk.getTfsAttributes().getTfsAreaPath());
                        fields.put((Object)obj3);
                    }
                    if (PropertyValidator.isValid((Object)(titleFieldMapping = (Map)riskFeildsMapById.get("title")))) {
                        String path = "/fields/" + (String)titleFieldMapping.get("value");
                        JSONObject obj4 = new JSONObject();
                        obj4.put("path", (Object)path);
                        obj4.put("value", (Object)risk.getRiskTitle());
                        fields.put((Object)obj4);
                    }
                    if (PropertyValidator.isValid((Object)(statusFieldMapping = (Map)riskFeildsMapById.get("status")))) {
                        String path = "/fields/" + (String)statusFieldMapping.get("value");
                        JSONObject obj5 = new JSONObject();
                        obj5.put("path", (Object)path);
                        obj5.put("value", (Object)risk.getStatus().getTitle());
                        fields.put((Object)obj5);
                    }
                    if (PropertyValidator.isValid((Object)(raisedDateFieldMapping = (Map)riskFeildsMapById.get("raisedDate"))) && PropertyValidator.isValid(raisedDateFieldMapping.get("value")) && PropertyValidator.isValid((Object)risk.getRaisedDate())) {
                        String path = "/fields/" + (String)raisedDateFieldMapping.get("value");
                        JSONObject obj6 = new JSONObject();
                        obj6.put("path", (Object)path);
                        TimeZone tz = TimeZone.getTimeZone("UTC");
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                        String _date = df.format(risk.getRaisedDate());
                        obj6.put("value", (Object)_date);
                        fields.put((Object)obj6);
                    }
                    if (PropertyValidator.isValid((Object)(resolutionDateFieldMapping = (Map)riskFeildsMapById.get("resolutionDate"))) && PropertyValidator.isValid(resolutionDateFieldMapping.get("value")) && PropertyValidator.isValid((Object)risk.getResolutionDate())) {
                        String path = "/fields/" + (String)resolutionDateFieldMapping.get("value");
                        JSONObject obj7 = new JSONObject();
                        obj7.put("path", (Object)path);
                        TimeZone tz = TimeZone.getTimeZone("UTC");
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                        String _date = df.format(risk.getResolutionDate());
                        obj7.put("value", (Object)_date);
                        fields.put((Object)obj7);
                    }
                    if (PropertyValidator.isValid((Object)(descriptionFieldMapping = (Map)riskFeildsMapById.get("description"))) && PropertyValidator.isValid((Object)(value2 = (String)descriptionFieldMapping.get("value"))) && value2.length() != 0) {
                        String path = "/fields/" + value2;
                        obj2 = new JSONObject();
                        obj2.put("path", (Object)path);
                        if (PropertyValidator.isValid((Object)risk.getRiskDesc())) {
                            obj2.put("value", (Object)risk.getRiskDesc());
                        } else {
                            obj2.put("value", (Object)"");
                        }
                        fields.put((Object)obj2);
                    }
                    if (PropertyValidator.isValid((Object)(mitigationFieldMapping = (Map)riskFeildsMapById.get("mitigationAction"))) && PropertyValidator.isValid((Object)(value = (String)mitigationFieldMapping.get("value"))) && ((String)value).length() != 0) {
                        String path = "/fields/" + (String)value;
                        obj = new JSONObject();
                        obj.put("path", (Object)path);
                        if (PropertyValidator.isValid((Object)risk.getMitigationActions())) {
                            obj.put("value", (Object)risk.getMitigationActions());
                        } else {
                            obj.put("value", (Object)"");
                        }
                        fields.put((Object)obj);
                    }
                    if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Collection)risk.getTfsAttributes().getTfsFieldMap())) {
                        for (ItemJiraFieldMap tfsField : risk.getTfsAttributes().getTfsFieldMap()) {
                            obj = new JSONObject();
                            obj.put("path", (Object)("/fields/" + tfsField.getKey()));
                            boolean addField = true;
                            boolean readonly = false;
                            if (tfsField.getReadonly().booleanValue()) {
                                readonly = true;
                                addField = false;
                            }
                            if (tfsField.getType().equals("boolean")) {
                                obj.put("value", Boolean.parseBoolean(tfsField.getValue()));
                            } else if (tfsField.getType().equals("integer")) {
                                if (PropertyValidator.isValid((Object)tfsField.getValue())) {
                                    obj.put("value", Integer.parseInt(tfsField.getValue()));
                                } else {
                                    addField = false;
                                }
                            } else if (tfsField.getType().equals("double")) {
                                if (PropertyValidator.isValid((Object)tfsField.getValue())) {
                                    obj.put("value", Double.parseDouble(tfsField.getValue()));
                                } else {
                                    addField = false;
                                }
                            } else if (PropertyValidator.isValid((Object)tfsField.getValue())) {
                                obj.put("value", (Object)tfsField.getValue());
                            } else {
                                addField = false;
                            }
                            if (!addField) continue;
                            fields.put((Object)obj);
                        }
                    }
                    if (!isUpdate && PropertyValidator.isValid((Collection)risk.getLinkedItemsIds())) {
                        List linkedItems = this.itemRepository.findByIdIn(risk.getLinkedItemsIds());
                        for (Item item : linkedItems) {
                            if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                            JSONObject relationObject = new JSONObject();
                            JSONObject valueObject = new JSONObject();
                            valueObject.put("rel", (Object)config.getRiskLinkType());
                            valueObject.put("url", (Object)item.getTfsURL());
                            relationObject.put("path", (Object)"/relations/-");
                            relationObject.put("value", (Object)valueObject);
                            fields.put((Object)relationObject);
                        }
                    }
                    for (int a = 0; a < fields.length(); ++a) {
                        obj2 = (JSONObject)fields.get(a);
                        obj2.put("op", (Object)"add");
                    }
                    String fieldsStr = fields.toString();
                    try {
                        String responseContent;
                        String url = isUpdate ? "/" + config.getTfsProjectTfsId() + "/_apis/wit/workitems/" + risk.getTfsAttributes().getTfsId() : "/" + config.getTfsProjectTfsId() + "/_apis/wit/workitems/$" + UriUtils.encode((String)workItemType, (String)"UTF-8");
                        String requestBody = fieldsStr;
                        TFSResponse tfsResponse = this.tfsUtils.patchRequest(url, requestBody, almAccount);
                        if (!PropertyValidator.isValid((Object)tfsResponse) || !PropertyValidator.isValid((Object)(responseContent = tfsResponse.getContent()))) break block46;
                        try {
                            JSONObject tfsItem = new JSONObject(responseContent);
                            JSONObject tfsFields = tfsItem.getJSONObject("fields");
                            Risk freshItem = (Risk)this.riskRepository.findOne((Serializable)((Object)risk.getId()));
                            if (freshItem.getTfsAttributes() == null) {
                                freshItem.setTfsAttributes(new TFSAttributes());
                            }
                            String tfsId = tfsItem.getString("id");
                            String rev = tfsItem.getString("rev");
                            if (!tfsItem.isNull("_links")) {
                                JSONObject links = tfsItem.getJSONObject("_links");
                                JSONObject linkHTML = links.getJSONObject("html");
                                freshItem.getTfsAttributes().setTfsURL(linkHTML.getString("href"));
                            }
                            freshItem.getTfsAttributes().setTfsId(tfsId);
                            freshItem.setErrorInAlmSync(Boolean.valueOf(false));
                            freshItem.setAlmErrorMessage(null);
                            this.riskRepository.save((Object)freshItem);
                            HashMap<String, Object> metaMap = new HashMap<String, Object>();
                            metaMap.put("riskRegisterId", riskRegister.getId());
                            metaMap.put("event", "TFSRiskCreate");
                            metaMap.put("success", true);
                            String requestId = null;
                            if (params.containsKey("requestId")) {
                                requestId = (String)params.get("requestId");
                            }
                            if (requestId != null) {
                                this.sendPushResonse(freshItem, requestId, metaMap);
                            }
                        }
                        catch (JSONException e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    catch (ViztrendJiraException e) {
                        Risk freshItem = (Risk)this.riskRepository.findOne((Serializable)((Object)risk.getId()));
                        freshItem.setErrorInAlmSync(Boolean.valueOf(true));
                        freshItem.setAlmErrorMessage(e.getMessage());
                        this.riskRepository.save((Object)freshItem);
                        HashMap<String, Object> metaMap = new HashMap<String, Object>();
                        metaMap.put("riskRegisterId", riskRegister.getId());
                        metaMap.put("event", "TFSRiskCreate");
                        metaMap.put("success", false);
                        String requestId = null;
                        if (params.containsKey("requestId")) {
                            requestId = (String)params.get("requestId");
                        }
                        if (requestId != null) {
                            this.sendPushResonse(freshItem, requestId, metaMap);
                        }
                    }
                }
            } else {
                result.put("success", false);
            }
        }
        return result;
    }

    public HashMap<String, Object> createLinksOnTFS(Risk risk, List<Item> items, HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)risk.getRiskRegister().getConfigId())) {
            ConfigAndMapping config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)risk.getRiskRegister().getConfigId()));
            if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsId()) && PropertyValidator.isValid((Object)config) && PropertyValidator.isValid((Collection)config.getRiskFieldsMappings())) {
                AlmAccount almAccount = config.getAlmAccount();
                for (Item item : items) {
                    if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                    HashMap<String, JSONObject> fields = new HashMap<String, JSONObject>();
                    JSONObject relationObject = new JSONObject();
                    relationObject.put("rel", (Object)config.getRiskLinkType());
                    relationObject.put("url", (Object)item.getTfsURL());
                    fields.put("relation", relationObject);
                    TFSResponse response = this.tfsUtils.updateItemInTFS(risk.getTfsAttributes().getTfsId(), fields, almAccount);
                    if (response.getStatusCode() != 200 && response.getStatusCode() != 201) continue;
                }
            }
        }
        return result;
    }

    public HashMap<String, Object> removeLinksOnTFS(Risk risk, List<Item> items, HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)risk.getRiskRegister().getConfigId())) {
            ConfigAndMapping config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)risk.getRiskRegister().getConfigId()));
            if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsId()) && PropertyValidator.isValid((Object)config) && PropertyValidator.isValid((Collection)config.getRiskFieldsMappings())) {
                AlmAccount almAccount = config.getAlmAccount();
                for (Item item : items) {
                    if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                    this.tfSservice.removeRelationInTFS(risk.getTfsAttributes().getTfsId(), item.getTfsId(), almAccount);
                }
            }
        }
        return result;
    }

    public HashMap<String, Object> removeLinksOnTFSWithItemIds(Risk risk, List<String> itemIds, HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)risk.getRiskRegister().getConfigId())) {
            ConfigAndMapping config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)risk.getRiskRegister().getConfigId()));
            if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsId()) && PropertyValidator.isValid((Object)config) && PropertyValidator.isValid((Collection)config.getRiskFieldsMappings())) {
                AlmAccount almAccount = config.getAlmAccount();
                for (String itemId : itemIds) {
                    this.tfSservice.removeRelationInTFS(risk.getTfsAttributes().getTfsId(), itemId, almAccount);
                }
            }
        }
        return result;
    }

    public HashMap<String, Object> fetchAndSaveTfsFilters(List<String> itemIds, TFSFilter filter, String riskRegisterId, Map<String, Object> params, AlmAccount almAccount) throws Exception {
        ConfigAndMapping config;
        HashMap<String, Object> result = new HashMap<String, Object>();
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        result.put("success", false);
        if (PropertyValidator.isValid((Object)riskRegister) && PropertyValidator.isValid((Object)riskRegister.getConfigId()) && PropertyValidator.isValid((Object)(config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)riskRegister.getConfigId()))))) {
            HashMap fetchItemResult = this.fetchTfsItems(itemIds, filter, riskRegister, config, params, almAccount);
            boolean success = (Boolean)fetchItemResult.get("success");
            if (success) {
                result.put("success", true);
                result.put("risks", fetchItemResult.get("risks"));
                User user = UserContextUtil.getUserContext().getLoggedInUser();
                ALMFilter almFilter = new ALMFilter();
                almFilter.setAlmAccount(almAccount);
                almFilter.setTfsFilter(filter);
                User newUser = new User();
                newUser.setId(user.getId());
                filter.setFilterFetchedBy(newUser);
                filter.setUpdatedOn(new Date());
                filter.setCreatedOn(new Date());
                if (riskRegister.getAlmFilters() == null) {
                    riskRegister.setAlmFilters(new ArrayList());
                }
                riskRegister.getAlmFilters().add(almFilter);
                this.riskRegisterRepository.save((Object)riskRegister);
                result.put("filter", almFilter);
            } else {
                result.put("success", false);
                if (fetchItemResult.containsKey("reason")) {
                    result.put("reason", fetchItemResult.get("reason"));
                }
            }
        }
        return result;
    }

    public HashMap<String, Object> addExistingTfsItems(List<String> itemIds, String riskRegisterId, Map<String, Object> params) throws Exception {
        ConfigAndMapping config;
        HashMap<String, Object> result = new HashMap<String, Object>();
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        result.put("success", false);
        if (PropertyValidator.isValid((Object)riskRegister) && PropertyValidator.isValid((Object)riskRegister.getConfigId()) && PropertyValidator.isValid((Object)(config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)riskRegister.getConfigId()))))) {
            List alreadyExist = this.riskRepository.findByTfsAttributes_TfsIdInAndRiskRegisterId(itemIds, riskRegisterId);
            if (PropertyValidator.isValid((Collection)alreadyExist)) {
                result.put("success", false);
                result.put("reason", "AlreadyExist");
            } else {
                HashMap fetchItemResult = this.fetchTfsItems(itemIds, null, riskRegister, config, params, config.getAlmAccount());
                boolean success = (Boolean)fetchItemResult.get("success");
                if (success) {
                    result.put("success", true);
                    result.put("risks", fetchItemResult.get("risks"));
                } else {
                    result.put("success", false);
                    if (fetchItemResult.containsKey("reason")) {
                        result.put("reason", fetchItemResult.get("reason"));
                    }
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HashMap<String, Object> resyncRisks(List<String> itemIds, String tfsFilterId, String riskRegisterId, Map<String, Object> params) throws Exception {
        ConfigAndMapping config;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        if (!PropertyValidator.isValid((Object)riskRegister) || !PropertyValidator.isValid((Object)riskRegister.getConfigId()) || !PropertyValidator.isValid((Object)(config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)riskRegister.getConfigId()))))) return result;
        if (PropertyValidator.isValid(itemIds)) {
            HashMap fetchItemResult = this.fetchTfsItems(itemIds, null, riskRegister, config, params, config.getAlmAccount());
            boolean success = (Boolean)fetchItemResult.get("success");
            if (success) {
                result.put("success", true);
                for (String key : fetchItemResult.keySet()) {
                    result.put(key, fetchItemResult.get(key));
                }
                return result;
            } else {
                result.put("success", false);
                if (!fetchItemResult.containsKey("reason")) return result;
                result.put("isTfs", true);
                result.put("reason", fetchItemResult.get("reason"));
            }
            return result;
        } else {
            ALMFilter filter;
            if (!PropertyValidator.isValid((Object)tfsFilterId) || !PropertyValidator.isValid((Object)(filter = (ALMFilter)riskRegister.getAlmFilters().stream().filter(almf -> {
                if (PropertyValidator.isValid((Object)almf.getTfsFilter())) {
                    return almf.getTfsFilter().getTfsId().equals(tfsFilterId);
                }
                return false;
            }).findAny().orElse(null))) || !PropertyValidator.isValid((Object)filter.getTfsFilter())) return result;
            TFSFilter tfsFilter = filter.getTfsFilter();
            try {
                List _itemIds = this.getTfsItemsFromFilter(tfsFilter, config.getAlmAccount());
                HashMap fetchItemResult = this.fetchTfsItems(_itemIds, tfsFilter, riskRegister, config, params, config.getAlmAccount());
                boolean success = (Boolean)fetchItemResult.get("success");
                if (success) {
                    result.put("success", true);
                    for (String key : fetchItemResult.keySet()) {
                        result.put(key, fetchItemResult.get(key));
                    }
                    return result;
                }
                result.put("success", false);
                if (!fetchItemResult.containsKey("reason")) return result;
                result.put("reason", fetchItemResult.get("reason"));
                return result;
            }
            catch (ViztrendJiraException vje) {
                LOGGER.error(StringUtils.getTraceString((Throwable)vje));
                result.put("success", false);
                result.put("isTfs", true);
                result.put("reason", vje.getAlmError());
            }
        }
        return result;
    }

    private List<String> getTfsItemsFromFilter(TFSFilter tfsFilter, AlmAccount almAccount) {
        try {
            String tfsItemIdsStr;
            ArrayList<String> tfsIds = new ArrayList<String>();
            String wiql = null;
            if (PropertyValidator.isValid((Object)tfsFilter.getIsWiql()) && tfsFilter.getIsWiql().booleanValue()) {
                wiql = tfsFilter.getQueryJSON();
                wiql = wiql.replace("\"", "'");
                String queryStr = "{query:\"" + wiql + "\"}";
                TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(queryStr, almAccount, false);
                tfsItemIdsStr = tfsResponse.getContent();
            } else {
                tfsItemIdsStr = this.tfsUtils.getWorkItemsByTFSQueryId(this.tfsUtils.encodeValue(tfsFilter.getTfsProjectId()), tfsFilter.getTfsId(), almAccount);
            }
            try {
                JSONObject jsonObject = new JSONObject(tfsItemIdsStr);
                String queryType = jsonObject.getString("queryType");
                ArrayList<String> relations = new ArrayList<String>();
                if (queryType.equals("flat")) {
                    JSONArray workItemsArray = jsonObject.getJSONArray("workItems");
                    for (int i = 0; i < workItemsArray.length(); ++i) {
                        JSONObject wiObject = workItemsArray.getJSONObject(i);
                        String itemId = wiObject.getString("id");
                        tfsIds.add(itemId);
                    }
                } else {
                    JSONArray workItemsArray = new JSONArray();
                    JSONArray workItemsRelationsArray = jsonObject.getJSONArray("workItemRelations");
                    ArrayList<String> subItemIds = new ArrayList<String>();
                    for (int i = 0; i < workItemsRelationsArray.length(); ++i) {
                        JSONObject wirObject = workItemsRelationsArray.getJSONObject(i);
                        Object sourceObject = null;
                        JSONObject targetObject = null;
                        String relation = null;
                        if (wirObject.isNull("source") && !wirObject.isNull("target")) {
                            targetObject = wirObject.getJSONObject("target");
                        }
                        if (!wirObject.isNull("rel")) {
                            relation = wirObject.getString("rel");
                        }
                        if (PropertyValidator.isValid(targetObject)) {
                            JSONObject workItemObject = new JSONObject();
                            String itemId = targetObject.getString("id");
                            String itemURL = targetObject.getString("url");
                            tfsIds.add(itemId);
                            workItemObject.put("id", (Object)itemId);
                            workItemObject.put("url", (Object)itemURL);
                            workItemsArray.put((Object)workItemObject);
                        }
                        if (PropertyValidator.isValid((Object)targetObject)) {
                            String itemId = targetObject.getString("id");
                            subItemIds.add(itemId);
                        }
                        if (!PropertyValidator.isValid((Object)relation)) continue;
                        relations.add(relation);
                    }
                }
                return tfsIds;
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                return null;
            }
        }
        catch (ViztrendJiraException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    private HashMap<String, Object> fetchTfsItems(List<String> itemIds, TFSFilter filter, RiskRegister riskRegister, ConfigAndMapping config, Map<String, Object> params, AlmAccount almAccount) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        Boolean isReadonly = (Boolean)params.get("readonly");
        if (isReadonly == null) {
            isReadonly = Boolean.FALSE;
        }
        TFSProject tfsProject = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)config.getTfsProjectId()));
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        User loggedInUserRef = new User();
        loggedInUserRef.setId(loggedInUser.getId());
        ArrayList<Map> risksToBeAdded = new ArrayList<Map>();
        ArrayList<Map> risksToBeRemoved = new ArrayList<Map>();
        if (PropertyValidator.isValid((Object)tfsProject)) {
            List filterRsiks;
            HashMap filterRisksMap = new HashMap();
            if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)(filterRsiks = this.riskRepository.findByTfsAttributes_TfsFilterAndRiskRegisterId(filter.getTfsId(), riskRegister.getId())))) {
                filterRsiks.stream().forEach(ri -> filterRisksMap.put(ri.getTfsAttributes().getTfsId(), ri.toSimpleObject()));
            }
            List statuses = this.statusRepository.findByTfsProjectIdAndAlmIdAndItemType(tfsProject.getTfsId(), config.getAlmAccount().getId(), config.getRiskItemTypeName());
            HashMap<String, Status> statusMapByTitle = new HashMap<String, Status>();
            for (Object status : statuses) {
                statusMapByTitle.put(status.getTitle(), (Status)status);
            }
            HashMap<String, Map> riskFeildsMapById = new HashMap<String, Map>();
            for (Map fieldMapping : config.getRiskFieldsMappings()) {
                riskFeildsMapById.put((String)fieldMapping.get("id"), fieldMapping);
            }
            ArrayList<Risk> risksToBeSaved = new ArrayList<Risk>();
            if (!isReadonly.booleanValue() && params.containsKey("dontAddRisks")) {
                Map dontAddRisks = (Map)params.get("dontAddRisks");
                itemIds = itemIds.stream().filter(itemId -> dontAddRisks.get(itemId) == null).collect(Collectors.toList());
            }
            List subSetsOfTfsItems = Lists.partition(new ArrayList<String>(itemIds), (int)100);
            for (List subSetOfTfsItems : subSetsOfTfsItems) {
                String tfsItemIdsStr = String.join((CharSequence)",", subSetOfTfsItems);
                List existingRisks = this.riskRepository.findByTfsAttributes_TfsIdInAndRiskRegisterId(subSetOfTfsItems, riskRegister.getId());
                HashMap<String, Risk> existingRisksByTfsId = new HashMap<String, Risk>();
                if (PropertyValidator.isValid((Collection)existingRisks)) {
                    for (Risk risk : existingRisks) {
                        existingRisksByTfsId.put(risk.getTfsAttributes().getTfsId(), risk);
                    }
                }
                String tsfItemsStr = null;
                try {
                    tsfItemsStr = this.tfsUtils.getItems("1", tfsItemIdsStr, almAccount);
                    JSONObject tfsItemsJSON = new JSONObject(tsfItemsStr);
                    JSONArray tfsItemsJSONArray = tfsItemsJSON.getJSONArray("value");
                    boolean anyItemTypeMatched = false;
                    for (int i = 0; i < tfsItemsJSONArray.length(); ++i) {
                        JSONArray relationsArray;
                        HashMap itemInfo;
                        JSONObject itemObject = tfsItemsJSONArray.getJSONObject(i);
                        JSONObject tfsFields = itemObject.getJSONObject("fields");
                        String itemTfsId = itemObject.getString("id");
                        String itemType = tfsFields.getString("System.WorkItemType");
                        if (!config.getRiskItemTypeName().equals(itemType)) continue;
                        anyItemTypeMatched = true;
                        Risk existingRisk = (Risk)existingRisksByTfsId.get(itemTfsId);
                        if (PropertyValidator.isValid((Object)existingRisk)) {
                            JSONArray relationsArray2;
                            itemInfo = this.riskFromRawJSON(existingRisk, tfsProject, itemObject, tfsFields, statusMapByTitle, riskFeildsMapById, config);
                            if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid(filterRisksMap.get(existingRisk.getTfsAttributes().getTfsId()))) {
                                filterRisksMap.remove(existingRisk.getTfsAttributes().getTfsId());
                            }
                            if (!itemInfo.containsKey("risk")) continue;
                            Risk updatedRisk = (Risk)itemInfo.get("risk");
                            if (PropertyValidator.isValid((Object)filter)) {
                                updatedRisk.getTfsAttributes().setTfsFilter(filter.getTfsId());
                            }
                            updatedRisk.getTfsAttributes().setTfsLinkedItems(new ArrayList());
                            if (!itemObject.isNull("relations") && PropertyValidator.isValid((Object)(relationsArray2 = itemObject.getJSONArray("relations")))) {
                                for (int j = 0; j < relationsArray2.length(); ++j) {
                                    JSONObject relationObject = relationsArray2.getJSONObject(j);
                                    String relationType = relationObject.getString("rel");
                                    String relationURL = relationObject.getString("url");
                                    if (!config.getRiskLinkType().equals(relationType)) continue;
                                    String itemId2 = relationURL.substring(relationURL.lastIndexOf("/") + 1);
                                    updatedRisk.getTfsAttributes().getTfsLinkedItems().add(itemId2);
                                }
                            }
                            risksToBeSaved.add(updatedRisk);
                            continue;
                        }
                        itemInfo = this.riskFromRawJSON(null, tfsProject, itemObject, tfsFields, statusMapByTitle, riskFeildsMapById, config);
                        if (!itemInfo.containsKey("risk")) continue;
                        Risk newRisk = (Risk)itemInfo.get("risk");
                        if (PropertyValidator.isValid((Object)filter)) {
                            if (PropertyValidator.isValid(filterRisksMap.get(newRisk.getTfsAttributes().getTfsId()))) {
                                filterRisksMap.remove(newRisk.getTfsAttributes().getTfsId());
                            } else {
                                risksToBeAdded.add(newRisk.toSimpleObject());
                            }
                        }
                        newRisk.setFetchedBy(loggedInUserRef);
                        if (PropertyValidator.isValid((Object)filter)) {
                            newRisk.getTfsAttributes().setTfsFilter(filter.getTfsId());
                        }
                        RiskRegister newRiskRegister = new RiskRegister();
                        newRiskRegister.setId(riskRegister.getId());
                        newRisk.setRiskRegister(newRiskRegister);
                        newRisk.getTfsAttributes().setTfsLinkedItems(new ArrayList());
                        if (!itemObject.isNull("relations") && PropertyValidator.isValid((Object)(relationsArray = itemObject.getJSONArray("relations")))) {
                            for (int j = 0; j < relationsArray.length(); ++j) {
                                JSONObject relationObject = relationsArray.getJSONObject(j);
                                String relationType = relationObject.getString("rel");
                                String relationURL = relationObject.getString("url");
                                if (!config.getRiskLinkType().equals(relationType)) continue;
                                String itemId3 = relationURL.substring(relationURL.lastIndexOf("/") + 1);
                                newRisk.getTfsAttributes().getTfsLinkedItems().add(itemId3);
                            }
                        }
                        risksToBeSaved.add(newRisk);
                    }
                    if (anyItemTypeMatched) continue;
                    result.put("success", false);
                    result.put("reason", "ItemTypeNotMatched");
                }
                catch (ViztrendJiraException vje) {
                    result.put("success", false);
                    result.put("reason", vje.getAlmError());
                }
            }
            if (!isReadonly.booleanValue()) {
                if (PropertyValidator.isValid(risksToBeSaved)) {
                    List savedRisks = this.riskRepository.save(risksToBeSaved);
                    savedRisks.stream().forEach(r -> r.setRiskRegister(new RiskRegister(r.getRiskRegister().getId())));
                    result.put("risks", savedRisks);
                }
                HashMap deleteRisks = new HashMap();
                if (params.containsKey("deleteRisks")) {
                    deleteRisks = (HashMap)params.get("deleteRisks");
                }
                if (!filterRisksMap.isEmpty()) {
                    ArrayList<String> risksIdsToDelete = new ArrayList<String>();
                    for (String key : filterRisksMap.keySet()) {
                        Map risk = (Map)filterRisksMap.get(key);
                        String riskId = null;
                        if (risk.containsKey("tfsAttributes")) {
                            HashMap tfsAttributes = (HashMap)risk.get("tfsAttributes");
                            riskId = (String)tfsAttributes.get("tfsId");
                        }
                        if (!deleteRisks.containsKey(riskId)) continue;
                        risksIdsToDelete.add((String)risk.get("id"));
                    }
                    if (PropertyValidator.isValid(risksIdsToDelete)) {
                        this.riskRepository.deleteByIdIn(risksIdsToDelete);
                    }
                }
                result.put("readonly", false);
            } else {
                if (!filterRisksMap.isEmpty()) {
                    for (String key : filterRisksMap.keySet()) {
                        Map risk = (Map)filterRisksMap.get(key);
                        risksToBeRemoved.add(risk);
                    }
                }
                if (PropertyValidator.isValid((Object)filter)) {
                    result.put("filterId", filter.getTfsId());
                }
                result.put("readonly", true);
                result.put("riskToAdd", risksToBeAdded);
                result.put("riskToRemove", risksToBeRemoved);
            }
        }
        return result;
    }

    public void tfsWebhookItemReceived(TFSWebhookMappedData webhookMappedData) {
        AlmAccount almAccount = this.almAccountRepository.findById(webhookMappedData.getAlmAccountId());
        if (PropertyValidator.isValid((Object)almAccount)) {
            JSONObject webHookJson = webhookMappedData.payload();
            String eventType = webHookJson.getString("eventType");
            JSONObject tfsItemObject = webHookJson.getJSONObject("resource");
            String tfsId = null;
            if (!tfsItemObject.isNull("workItemId")) {
                tfsId = tfsItemObject.getString("workItemId");
            } else if (!tfsItemObject.isNull("id")) {
                tfsId = tfsItemObject.getString("id");
            }
            List risks = this.riskRepository.findByTfsAttributes_TfsId(tfsId);
            if (PropertyValidator.isValid((Collection)risks) && !eventType.equals("workitem.deleted") && eventType.equals("workitem.updated")) {
                for (Risk risk : risks) {
                    Object status2;
                    TFSProject tfsProject;
                    ConfigAndMapping config;
                    RiskRegister riskRegister = risk.getRiskRegister();
                    if (!PropertyValidator.isValid((Object)riskRegister.getConfigId()) || !PropertyValidator.isValid((Object)(config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)riskRegister.getConfigId())))) || !PropertyValidator.isValid((Object)config.getTfsProjectId()) || !PropertyValidator.isValid((Object)(tfsProject = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)config.getTfsProjectId()))))) continue;
                    List statuses = this.statusRepository.findByTfsProjectIdAndAlmIdAndItemType(tfsProject.getTfsId(), config.getAlmAccount().getId(), config.getRiskItemTypeName());
                    HashMap<String, Status> statusMapByTitle = new HashMap<String, Status>();
                    for (Object status2 : statuses) {
                        statusMapByTitle.put(status2.getTitle(), (Status)status2);
                    }
                    HashMap<String, Map> riskFeildsMapById = new HashMap<String, Map>();
                    status2 = config.getRiskFieldsMappings().iterator();
                    while (status2.hasNext()) {
                        Map fieldMapping = (Map)status2.next();
                        riskFeildsMapById.put((String)fieldMapping.get("id"), fieldMapping);
                    }
                    Risk newRisk = null;
                    if (!tfsItemObject.isNull("revision")) {
                        JSONObject tfsFields;
                        JSONObject tfsItemRevision = tfsItemObject.getJSONObject("revision");
                        HashMap itemInfo = this.riskFromRawJSON(risk, tfsProject, tfsItemRevision, tfsFields = tfsItemRevision.getJSONObject("fields"), statusMapByTitle, riskFeildsMapById, config);
                        if (itemInfo.containsKey("risk")) {
                            newRisk = (Risk)itemInfo.get("risk");
                        }
                    } else {
                        newRisk = risk;
                    }
                    JSONObject relationsObject = null;
                    if (!tfsItemObject.isNull("relations")) {
                        relationsObject = tfsItemObject.getJSONObject("relations");
                    }
                    if (relationsObject != null) {
                        String relTfsId;
                        String url;
                        String rel;
                        JSONObject relationObject;
                        if (!relationsObject.isNull("added")) {
                            JSONArray relationsAdded = relationsObject.getJSONArray("added");
                            for (int i = 0; i < relationsAdded.length(); ++i) {
                                relationObject = relationsAdded.getJSONObject(i);
                                rel = relationObject.getString("rel");
                                url = relationObject.getString("url");
                                relTfsId = url.substring(url.lastIndexOf("/") + 1);
                                if (!rel.equals(config.getRiskLinkType())) continue;
                                if (newRisk.getTfsAttributes().getTfsLinkedItems() == null) {
                                    newRisk.getTfsAttributes().setTfsLinkedItems(new ArrayList());
                                }
                                newRisk.getTfsAttributes().getTfsLinkedItems().add(relTfsId);
                            }
                        }
                        if (!relationsObject.isNull("removed")) {
                            JSONArray relationsRemoved = relationsObject.getJSONArray("removed");
                            for (int i = 0; i < relationsRemoved.length(); ++i) {
                                relationObject = relationsRemoved.getJSONObject(i);
                                rel = relationObject.getString("rel");
                                url = relationObject.getString("url");
                                relTfsId = url.substring(url.lastIndexOf("/") + 1);
                                if (!rel.equals(config.getRiskLinkType()) || newRisk.getTfsAttributes().getTfsLinkedItems() == null) continue;
                                newRisk.getTfsAttributes().getTfsLinkedItems().remove(relTfsId);
                            }
                        }
                    }
                    newRisk = (Risk)this.riskRepository.save((Object)newRisk);
                }
            }
        }
    }

    private AlmAccount getTaggedAlmIfAny(AlmAccount almAccount) {
        AlmAccount taggedAlmAccount;
        AlmAccount tempALMAccount = new AlmAccount();
        tempALMAccount.setId(almAccount.getId());
        tempALMAccount.setUrl(almAccount.getUrl());
        tempALMAccount.setUsername(almAccount.getUsername());
        tempALMAccount.setPassword(almAccount.getPassword());
        tempALMAccount.setAzureOAuthToken(almAccount.getAzureOAuthToken());
        tempALMAccount.setSecretKey(almAccount.getSecretKey());
        tempALMAccount.setClientId(almAccount.getClientId());
        tempALMAccount.setIsTaggedUser(Boolean.valueOf(false));
        tempALMAccount.setAdminAlmAcc(almAccount.getAdminAlmAcc());
        tempALMAccount.setOAuthTokenOwnerUserId(almAccount.getOAuthTokenOwnerUserId());
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        if (loggedInUser != null && PropertyValidator.isValid((Object)(taggedAlmAccount = TFSUtils.getTaggedAlmUserCopyAlm((User)loggedInUser, (AlmAccount)almAccount)))) {
            tempALMAccount.setUsername(taggedAlmAccount.getUsername());
            tempALMAccount.setPassword(taggedAlmAccount.getPassword());
            tempALMAccount.setAzureOAuthToken(taggedAlmAccount.getAzureOAuthToken());
            tempALMAccount.setIsTaggedUser(Boolean.valueOf(true));
            tempALMAccount.setAdminAlmAcc(taggedAlmAccount.getAdminAlmAcc());
            tempALMAccount.setOAuthTokenOwnerUserId(taggedAlmAccount.getOAuthTokenOwnerUserId());
        }
        return tempALMAccount;
    }

    private void sendPushResonse(Risk freshItem, String requestId, HashMap<String, Object> metaMap) {
        try {
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            metaMap.put("event", "TFSRiskCreate");
            JSONObject pushJson = new JSONObject();
            HashMap<String, Risk> pushData = new HashMap<String, Risk>();
            pushData.put("risk", freshItem);
            String itemStr = gsonExclusive.toJson(pushData);
            pushJson.put("data", (Object)itemStr);
            pushJson.put("tfs", true);
            String metaMapStr = gsonExclusive.toJson(metaMap);
            pushJson.put("metaMap", (Object)metaMapStr);
            PushSender.sendMsg((String)pushJson.toString());
            this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(true)));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public HashMap<String, Object> removeFilter(String riskRegisterId, String tfsFilterId, Map<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Boolean removeData = (Boolean)params.get("removeData");
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        if (PropertyValidator.isValid((Object)riskRegister)) {
            if (PropertyValidator.isValid((Collection)riskRegister.getAlmFilters())) {
                int index = IntStream.range(0, riskRegister.getAlmFilters().size()).parallel().filter(i -> {
                    ALMFilter f = (ALMFilter)riskRegister.getAlmFilters().get(i);
                    return PropertyValidator.isValid((Object)f.getTfsFilter()) && f.getTfsFilter().getTfsId().equals(tfsFilterId);
                }).findFirst().orElse(-1);
                if (index > -1) {
                    riskRegister.getAlmFilters().remove(index);
                    this.riskRegisterRepository.save((Object)riskRegister);
                    result.put("success", true);
                    if (removeData.booleanValue()) {
                        this.riskRepository.deleteByTfsAttributes_TfsFilterAndRiskRegisterId(tfsFilterId, riskRegisterId);
                    }
                } else {
                    result.put("success", false);
                }
            } else {
                result.put("success", false);
            }
        } else {
            result.put("success", false);
        }
        return result;
    }

    private HashMap<String, Object> riskFromRawJSON(Risk risk, TFSProject project, JSONObject itemObject, JSONObject tfsFields, HashMap<String, Status> statusMapByTitle, HashMap<String, Map<String, String>> riskFeildsMapById, ConfigAndMapping config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (risk == null) {
            risk = new Risk();
            risk.setId(ObjectId.get().toString());
        }
        String tfsId = itemObject.getString("id");
        String url = itemObject.getString("url");
        if (risk.getTfsAttributes() == null) {
            risk.setTfsAttributes(new TFSAttributes());
        }
        risk.getTfsAttributes().setTfsId(tfsId);
        String areaPath = (String)tfsFields.get("System.AreaPath");
        String teamProject = (String)tfsFields.get("System.TeamProject");
        String iterationPath = (String)tfsFields.get("System.IterationPath");
        String workItemType = (String)tfsFields.get("System.WorkItemType");
        if (teamProject.equals(project.getName())) {
            String path;
            Map<String, String> mitigationFieldMapping;
            String path2;
            Map<String, String> descriptionFieldMapping;
            String path3;
            Map<String, String> resolutionDateFieldMapping;
            String path4;
            Map<String, String> raisedDateFieldMapping;
            String statusTitle;
            Status status;
            String path5;
            Map<String, String> statusFieldMapping;
            String path6;
            Map<String, String> titleFieldMapping;
            String displayName;
            String assignedTo;
            Object userObject;
            JSONObject links;
            if (!itemObject.isNull("_links") && !(links = itemObject.getJSONObject("_links")).isNull("html")) {
                JSONObject linkHTML = links.getJSONObject("html");
                risk.getTfsAttributes().setTfsURL(linkHTML.getString("href"));
            }
            risk.getTfsAttributes().setTfsProject(teamProject);
            risk.getTfsAttributes().setTfsProjectId(project.getTfsId());
            risk.getTfsAttributes().setTfsAreaPath(areaPath);
            risk.getTfsAttributes().setTfsIterationPath(iterationPath);
            risk.getTfsAttributes().setTfsItemType(workItemType);
            if (project.getIconByItemType().containsKey(workItemType)) {
                risk.getTfsAttributes().setTfsItemTypeIcon((String)project.getIconByItemType().get(workItemType));
            }
            risk.getTfsAttributes().setTfsFieldByKey(new HashMap());
            if (!tfsFields.isNull("System.AssignedTo")) {
                userObject = tfsFields.get("System.AssignedTo");
                if (userObject instanceof String) {
                    assignedTo = (String)userObject;
                    risk.getTfsAttributes().getTfsFieldByKey().put("AssignedTo", this.getUserNameFromAdoWebhookUserInfo(assignedTo));
                } else {
                    assignedTo = (JSONObject)userObject;
                    displayName = (String)assignedTo.get("displayName");
                    risk.getTfsAttributes().getTfsFieldByKey().put("AssignedTo", displayName);
                }
            }
            if (!tfsFields.isNull("System.CreatedBy")) {
                userObject = tfsFields.get("System.CreatedBy");
                if (userObject instanceof String) {
                    assignedTo = (String)userObject;
                    risk.getTfsAttributes().getTfsFieldByKey().put("CreatedBy", this.getUserNameFromAdoWebhookUserInfo(assignedTo));
                } else {
                    assignedTo = (JSONObject)userObject;
                    displayName = (String)assignedTo.get("displayName");
                    risk.getTfsAttributes().getTfsFieldByKey().put("CreatedBy", displayName);
                }
            }
            if (PropertyValidator.isValid(titleFieldMapping = riskFeildsMapById.get("title")) && tfsFields.has(path6 = titleFieldMapping.get("value"))) {
                risk.setRiskTitle(tfsFields.getString(path6));
            }
            if (PropertyValidator.isValid(statusFieldMapping = riskFeildsMapById.get("status")) && tfsFields.has(path5 = statusFieldMapping.get("value")) && PropertyValidator.isValid((Object)(status = statusMapByTitle.get(statusTitle = tfsFields.getString(path5))))) {
                risk.setStatus(status);
            }
            if (PropertyValidator.isValid(raisedDateFieldMapping = riskFeildsMapById.get("raisedDate")) && tfsFields.has(path4 = raisedDateFieldMapping.get("value"))) {
                String dateStr = (String)tfsFields.get(path4);
                dateStr = this.correctDate(dateStr);
                Date date = PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
                risk.setRaisedDate(date);
            }
            if (PropertyValidator.isValid(resolutionDateFieldMapping = riskFeildsMapById.get("resolutionDate")) && tfsFields.has(path3 = resolutionDateFieldMapping.get("value"))) {
                String dateStr = (String)tfsFields.get(path3);
                dateStr = this.correctDate(dateStr);
                Date date = PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
                risk.setResolutionDate(date);
            }
            if (PropertyValidator.isValid(descriptionFieldMapping = riskFeildsMapById.get("description")) && PropertyValidator.isValid((Object)descriptionFieldMapping.get("value")) && tfsFields.has(path2 = descriptionFieldMapping.get("value"))) {
                String val = (String)tfsFields.get(path2);
                risk.setRiskDesc(val);
            }
            if (PropertyValidator.isValid(mitigationFieldMapping = riskFeildsMapById.get("mitigationAction")) && PropertyValidator.isValid((Object)mitigationFieldMapping.get("value")) && tfsFields.has(path = mitigationFieldMapping.get("value"))) {
                String val = (String)tfsFields.get(path);
                risk.setMitigationActions(val);
            }
            if (PropertyValidator.isValid((Collection)config.getRiskCsutomFieldsMappings())) {
                for (Map field : config.getRiskCsutomFieldsMappings()) {
                    String key = (String)field.get("id");
                    String type = (String)field.get("type");
                    String name = (String)field.get("name");
                    ItemJiraFieldMap fieldMap = null;
                    boolean newField = false;
                    if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Collection)risk.getTfsAttributes().getTfsFieldMap())) {
                        fieldMap = risk.getTfsAttributes().getTfsFieldMap().stream().filter(fm -> fm.getKey().equals(key)).findAny().orElse(null);
                    }
                    if (fieldMap == null) {
                        fieldMap = new ItemJiraFieldMap();
                        newField = true;
                    }
                    fieldMap.setKey(key);
                    fieldMap.setName(name);
                    fieldMap.setType(type);
                    if (tfsFields.has(key)) {
                        Object value = tfsFields.get(key);
                        if (type.equals("integer") || type.equals("double") || type.equals("boolean") || type.equals("dateTime")) {
                            String _value = String.valueOf(value);
                            fieldMap.setValue(_value);
                        } else if (value instanceof String) {
                            fieldMap.setValue((String)value);
                        }
                    }
                    if (!newField) continue;
                    if (risk.getTfsAttributes() == null) {
                        risk.setTfsAttributes(new TFSAttributes());
                    }
                    if (risk.getTfsAttributes().getTfsFieldMap() == null) {
                        risk.getTfsAttributes().setTfsFieldMap(new ArrayList());
                    }
                    risk.getTfsAttributes().getTfsFieldMap().add(fieldMap);
                }
            }
            result.put("risk", risk);
        }
        return result;
    }

    private String correctDate(String _date) {
        String[] _dateParts = _date.split("\\.");
        if (_dateParts.length == 2) {
            return _dateParts[0] + "Z";
        }
        return _date;
    }

    private String getUserNameFromAdoWebhookUserInfo(String userInfo) {
        if (userInfo == null) {
            return null;
        }
        String[] userInfoParts = userInfo.split("<");
        if (userInfoParts.length == 2) {
            String displayName = userInfoParts[0];
            displayName = displayName.trim();
            String uniqueName = userInfoParts[1];
            uniqueName = uniqueName.replace(">", "");
            return displayName;
        }
        return userInfo;
    }
}

