/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.StrategicThemePriority;
import com.viztrend.safe.persistence.entity.StrategicThemesType;
import com.viztrend.safe.persistence.repository.StrategicThemePriorityRepository;
import com.viztrend.safe.persistence.repository.StrategicThemesTypeRepository;
import com.viztrend.safe.service.StrategicThemeService;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StrategicThemeServiceImpl
implements StrategicThemeService {
    @Autowired
    private StrategicThemesTypeRepository strategicThemesTypeRepository;
    @Autowired
    private StrategicThemePriorityRepository strategicThemePriorityRepository;

    public HashMap<String, Object> createThemeType(HashMap<String, Object> request) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String title = request.getOrDefault("title", null);
        if (PropertyValidator.isValid((Object)title)) {
            StrategicThemesType themesType = new StrategicThemesType();
            themesType.setTitle(title);
            themesType = (StrategicThemesType)this.strategicThemesTypeRepository.save((Object)themesType);
            response.put("success", true);
            response.put("type", themesType);
        } else {
            response.put("success", false);
            response.put("reason", "Invalid Title");
        }
        return response;
    }

    public HashMap<String, Object> editThemeType(HashMap<String, Object> request) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String title = request.getOrDefault("title", null);
        String id = request.getOrDefault("id", null);
        Object sequenceObj = request.get("sequence");
        Double sequence = null;
        if (sequenceObj instanceof Long) {
            sequence = ((Long)sequenceObj).doubleValue();
        } else if (sequenceObj instanceof Double) {
            sequence = (Double)sequenceObj;
        } else if (sequenceObj instanceof Integer) {
            sequence = ((Integer)sequenceObj).doubleValue();
        }
        if (PropertyValidator.isValid((Object)title) && PropertyValidator.isValid((Object)id)) {
            StrategicThemesType themesType = (StrategicThemesType)this.strategicThemesTypeRepository.findOne((Serializable)((Object)id));
            themesType.setTitle(title);
            if (PropertyValidator.isValid((Object)sequence)) {
                themesType.setSequence(sequence);
            }
            themesType = (StrategicThemesType)this.strategicThemesTypeRepository.save((Object)themesType);
            response.put("success", true);
            response.put("type", themesType);
        } else {
            response.put("success", false);
            response.put("reason", "Invalid Id or Title");
        }
        return response;
    }

    public HashMap<String, Object> createThemePriority(HashMap<String, Object> request) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String title = request.getOrDefault("title", null);
        if (PropertyValidator.isValid((Object)title)) {
            StrategicThemePriority themePriority = new StrategicThemePriority();
            themePriority.setTitle(title);
            themePriority = (StrategicThemePriority)this.strategicThemePriorityRepository.save((Object)themePriority);
            response.put("success", true);
            response.put("type", themePriority);
        } else {
            response.put("success", false);
            response.put("reason", "Invalid Title");
        }
        return response;
    }

    public HashMap<String, Object> editThemePriority(HashMap<String, Object> request) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String title = request.getOrDefault("title", null);
        String id = request.getOrDefault("id", null);
        Object sequenceObj = request.get("sequence");
        Double sequence = null;
        if (sequenceObj instanceof Long) {
            sequence = ((Long)sequenceObj).doubleValue();
        } else if (sequenceObj instanceof Double) {
            sequence = (Double)sequenceObj;
        } else if (sequenceObj instanceof Integer) {
            sequence = ((Integer)sequenceObj).doubleValue();
        }
        if (PropertyValidator.isValid((Object)title) && PropertyValidator.isValid((Object)id)) {
            StrategicThemePriority themePriority = (StrategicThemePriority)this.strategicThemePriorityRepository.findOne((Serializable)((Object)id));
            themePriority.setTitle(title);
            if (PropertyValidator.isValid((Object)sequence)) {
                themePriority.setSequence(sequence);
            }
            themePriority = (StrategicThemePriority)this.strategicThemePriorityRepository.save((Object)themePriority);
            response.put("success", true);
            response.put("type", themePriority);
        } else {
            response.put("success", false);
            response.put("reason", "Invalid Id or Title");
        }
        return response;
    }

    public HashMap<String, Object> deleteThemeType(HashMap<String, Object> request) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String id = request.getOrDefault("id", null);
        if (PropertyValidator.isValid((Object)id)) {
            StrategicThemesType themesType = (StrategicThemesType)this.strategicThemesTypeRepository.findOne((Serializable)((Object)id));
            themesType.setRowStatus(1);
            this.strategicThemesTypeRepository.delete((Object)themesType);
            response.put("success", true);
            response.put("type", themesType);
        } else {
            response.put("success", false);
            response.put("reason", "Invalid Id");
        }
        return response;
    }

    public HashMap<String, Object> deleteThemePriority(HashMap<String, Object> request) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String id = request.getOrDefault("id", null);
        if (PropertyValidator.isValid((Object)id)) {
            StrategicThemePriority themePriority = (StrategicThemePriority)this.strategicThemePriorityRepository.findOne((Serializable)((Object)id));
            this.strategicThemePriorityRepository.delete((Object)themePriority);
            response.put("success", true);
            response.put("type", themePriority);
        } else {
            response.put("success", false);
            response.put("reason", "Invalid Id");
        }
        return response;
    }
}

