/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.util.JSON;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ExportUtil;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.JiraIssue2;
import com.viztrend.safe.alm.jira.bo.JiraIssueLink;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.TFSIssue;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.controller.SolutionController;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.EpicFeature;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionAlmSettings;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkFlowItemType;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmErrorRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.EpicFeaturesRepository;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.SolutionAreaService;
import com.viztrend.safe.service.SolutionService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmErrorUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="solutionService")
@Transactional
class SolutionServiceImpl
implements SolutionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionController.class);
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private WorkFlowItemTypeRepository workFlowItemTypeRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private EpicFeaturesRepository epicFeaturesRepository;
    @Autowired
    private ExportUtil exportUtil;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private ALMSyncService almService;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private AlmErrorRepository almErrorRepository;
    @Autowired
    private PlanService planService;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private SolutionAreaService solutionAreaService;

    SolutionServiceImpl() {
    }

    public HashMap<String, Object> getSolutionData(String solutionId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionId));
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionBoard.$id").is((Object)new ObjectId(solutionId)));
            query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
            DBCursor dbCursorPrefix = this.customRepository.getMongoTemplate().getCollection("item").find(query.getQueryObject()).sort((DBObject)new BasicDBObject("backlogSequence", (Object)1));
            List allItems = dbCursorPrefix.toArray();
            HashMap duplicationAvoidMap = new HashMap();
            ArrayList statuses = new ArrayList();
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapById = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
            ArrayList itemLinks = new ArrayList();
            ArrayList almLinks = new ArrayList();
            ArrayList almSolLinks = new ArrayList();
            ArrayList<Item> epics = new ArrayList<Item>();
            ArrayList<Item> features = new ArrayList<Item>();
            ArrayList<Item> currentBoardItems = new ArrayList<Item>();
            if (PropertyValidator.isValid((Collection)allItems)) {
                for (DBObject vo2 : allItems) {
                    Item item2 = this.createItemForSolution(vo2, duplicationAvoidMap, statuses, itemLinks, almLinks, almSolLinks, null, null, issueTypeMapById);
                    item2.setSolutionBoard(solutionBoard);
                    currentBoardItems.add(item2);
                    if (item2.getType().equals(Item.EPIC)) {
                        epics.add(item2);
                        continue;
                    }
                    features.add(item2);
                }
            }
            List allItemLinks = this.itemLinkRepository.findByIdIn(itemLinks);
            List allAlmLinks = this.itemJiraDependencyRepository.findByIdIn(almLinks);
            List allAlmSolLinks = this.itemJiraDependencyRepository.findByIdIn(almSolLinks);
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(statuses));
            dbCursorPrefix = this.customRepository.getMongoTemplate().getCollection("status").find(query.getQueryObject());
            List statusesRaw = dbCursorPrefix.toArray();
            ArrayList<Status> allStatuses = new ArrayList<Status>();
            if (PropertyValidator.isValid((Collection)statusesRaw)) {
                statusesRaw.forEach(vo -> allStatuses.add(new Status(vo)));
            }
            HashMap itemLinksMap = new HashMap();
            HashMap almLinksMap = new HashMap();
            HashMap almSolLinksMap = new HashMap();
            HashMap statusesMap = new HashMap();
            if (PropertyValidator.isValid((Collection)allItemLinks)) {
                allItemLinks.forEach(item -> itemLinksMap.put(item.getId(), item));
            }
            if (PropertyValidator.isValid((Collection)allAlmLinks)) {
                allAlmLinks.forEach(item -> almLinksMap.put(item.getId(), item));
            }
            if (PropertyValidator.isValid((Collection)allAlmSolLinks)) {
                allAlmSolLinks.forEach(item -> almSolLinksMap.put(item.getId(), item));
            }
            if (PropertyValidator.isValid(allStatuses)) {
                allStatuses.forEach(item -> {
                    item.setWorkFlow(null);
                    item.setWorkFlowItemType(null);
                    statusesMap.put(item.getId(), item);
                });
            }
            if (PropertyValidator.isValid(currentBoardItems)) {
                Iterator iterator = currentBoardItems.iterator();
                while (iterator.hasNext()) {
                    List orgAlmLinks;
                    List _temLinks;
                    Item it;
                    Item item3 = it = (Item)iterator.next();
                    item3.setStatus((Status)statusesMap.get(item3.getStatus().getId()));
                    ArrayList solutionSourceItemLinks = item3.getSolutionSourceItemLinks();
                    if (PropertyValidator.isValid((Collection)solutionSourceItemLinks)) {
                        ArrayList newItemLinks = new ArrayList();
                        solutionSourceItemLinks.forEach(link -> {
                            ItemLink savedLink = (ItemLink)itemLinksMap.get(link.getId());
                            if (PropertyValidator.isValid((Object)savedLink.getSolutionId()) && savedLink.getSolutionId().equals(solutionId)) {
                                newItemLinks.add(savedLink);
                            }
                        });
                        item3.setSolutionSourceItemLinks(newItemLinks);
                    }
                    if (PropertyValidator.isValid((Collection)(_temLinks = item3.getItemLinks()))) {
                        ArrayList newItemLinks = new ArrayList();
                        _temLinks.forEach(link -> {
                            ItemLink savedLink = (ItemLink)itemLinksMap.get(link.getId());
                            newItemLinks.add(savedLink);
                        });
                        item3.setItemLinks(newItemLinks);
                    }
                    if (!PropertyValidator.isValid((Collection)(orgAlmLinks = item3.getJiraDependencies()))) continue;
                    ArrayList newJiraLinks = new ArrayList();
                    orgAlmLinks.forEach(link -> {
                        if (PropertyValidator.isValid((Object)link)) {
                            newJiraLinks.add(almLinksMap.get(link.getId()));
                        }
                    });
                    item3.setJiraDependencies(newJiraLinks);
                }
            }
            List epicFeatures = this.epicFeaturesRepository.findBySolutionBoardId(solutionId);
            response.put("status", "success");
            response.put("epicFeatures", epicFeatures);
            response.put("epics", epics);
            response.put("features", features);
            return response;
        }
        catch (Exception ex) {
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "Server exception while fetching data.");
            return response;
        }
    }

    public List<TFSProject> getSolutionAllTfsProjects(SolutionBoard solutionBoard) {
        List tfsProjects = this.tfsProjectRepository.findBySolutionId(solutionBoard.getId());
        return tfsProjects;
    }

    public HashMap<String, Object> searchSolutionBoards(String search) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        Query query = new Query();
        Criteria tenantCriteria = Criteria.where((String)"tenant").is((Object)tenant);
        query.addCriteria((CriteriaDefinition)tenantCriteria);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        String options = "i";
        Criteria searchCriteria = null;
        searchCriteria = Criteria.where((String)"title").regex(search, options);
        query.addCriteria((CriteriaDefinition)searchCriteria);
        List solutionBoards = this.mongoTemplate.find(query, SolutionBoard.class);
        ArrayList<SolutionBoard> allowedSolutionBoards = new ArrayList<SolutionBoard>();
        if (PropertyValidator.isValid((Collection)solutionBoards)) {
            HashMap solutionAreaAndCollections = this.solutionAreaService.getSolutionAreasAndCollections(null);
            List allowedSolutionAreas = (List)solutionAreaAndCollections.get("solutionAreas");
            List allowedWorkspaces = (List)solutionAreaAndCollections.get("workspaces");
            HashMap solutionAreaAndCollectionsMap = new HashMap();
            if (PropertyValidator.isValid((Collection)allowedSolutionAreas)) {
                allowedSolutionAreas.stream().forEach(sa -> solutionAreaAndCollectionsMap.put(sa.getId(), sa.getId()));
            }
            if (PropertyValidator.isValid((Collection)allowedWorkspaces)) {
                allowedWorkspaces.stream().forEach(sa -> solutionAreaAndCollectionsMap.put(sa.getId(), sa.getId()));
            }
            for (SolutionBoard solBoard : solutionBoards) {
                if (solBoard.getSolutionArea() == null && solBoard.getWorkSpace() == null) {
                    allowedSolutionBoards.add(solBoard);
                    continue;
                }
                if ((!PropertyValidator.isValid((Object)solBoard.getSolutionArea()) || !solutionAreaAndCollectionsMap.containsKey(solBoard.getSolutionArea().getId())) && (!PropertyValidator.isValid((Object)solBoard.getWorkSpace()) || !solutionAreaAndCollectionsMap.containsKey(solBoard.getWorkSpace().getId()))) continue;
                allowedSolutionBoards.add(solBoard);
            }
        }
        response.put("boards", allowedSolutionBoards);
        return response;
    }

    public HashMap<String, Object> getArchivedSolutionBoards() throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        Query query = new Query();
        Criteria tenantCriteria = Criteria.where((String)"tenant").is((Object)tenant);
        query.addCriteria((CriteriaDefinition)tenantCriteria);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)1));
        List solutionBoards = this.mongoTemplate.find(query, SolutionBoard.class);
        ArrayList<SolutionBoard> allowedSolutionBoards = new ArrayList<SolutionBoard>();
        if (PropertyValidator.isValid((Collection)solutionBoards)) {
            HashMap solutionAreaAndCollections = this.solutionAreaService.getSolutionAreasAndCollections(null);
            List allowedSolutionAreas = (List)solutionAreaAndCollections.get("solutionAreas");
            List allowedWorkspaces = (List)solutionAreaAndCollections.get("workspaces");
            HashMap solutionAreaAndCollectionsMap = new HashMap();
            if (PropertyValidator.isValid((Collection)allowedSolutionAreas)) {
                allowedSolutionAreas.stream().forEach(sa -> solutionAreaAndCollectionsMap.put(sa.getId(), sa.getId()));
            }
            if (PropertyValidator.isValid((Collection)allowedWorkspaces)) {
                allowedWorkspaces.stream().forEach(sa -> solutionAreaAndCollectionsMap.put(sa.getId(), sa.getId()));
            }
            for (SolutionBoard solBoard : solutionBoards) {
                if (solBoard.getSolutionArea() == null && solBoard.getWorkSpace() == null) {
                    allowedSolutionBoards.add(solBoard);
                    continue;
                }
                if ((!PropertyValidator.isValid((Object)solBoard.getSolutionArea()) || !solutionAreaAndCollectionsMap.containsKey(solBoard.getSolutionArea().getId())) && (!PropertyValidator.isValid((Object)solBoard.getWorkSpace()) || !solutionAreaAndCollectionsMap.containsKey(solBoard.getWorkSpace().getId()))) continue;
                allowedSolutionBoards.add(solBoard);
            }
        }
        response.put("boards", allowedSolutionBoards);
        return response;
    }

    public HashMap<String, Object> getStarredBoards() throws Exception {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User currentUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Query query = new Query();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"favouriteForUsers").in(new Object[]{currentUser.getId()}));
        List solutionBoards = this.mongoTemplate.find(query, SolutionBoard.class);
        if (PropertyValidator.isValid((Collection)solutionBoards)) {
            for (SolutionBoard sb : solutionBoards) {
                sb.setFavouriteForCuurrentUser(true);
            }
        }
        responseJson.put("boards", solutionBoards);
        return responseJson;
    }

    public HashMap<String, Object> starABoard(Map<String, Object> params) throws Exception {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User currentUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String solutionBoardId = (String)params.get("solutionBoardId");
        Boolean starred = (Boolean)params.get("starred");
        SolutionBoard solutionboard = this.solutionBoardRepository.findById(solutionBoardId);
        if (PropertyValidator.isValid((Object)solutionboard)) {
            if (solutionboard.getFavouriteForUsers() == null) {
                solutionboard.setFavouriteForUsers(new ArrayList());
            }
            if (starred.booleanValue()) {
                String existingUID = solutionboard.getFavouriteForUsers().stream().filter(uid -> uid.equals(currentUser.getId())).findAny().orElse(null);
                if (existingUID == null) {
                    solutionboard.getFavouriteForUsers().add(currentUser.getId());
                }
                solutionboard.setFavouriteForCuurrentUser(true);
            } else {
                solutionboard.getFavouriteForUsers().remove(currentUser.getId());
                solutionboard.setFavouriteForCuurrentUser(false);
            }
            this.solutionBoardRepository.save((Object)solutionboard);
            responseJson.put("board", solutionboard);
            responseJson.put("success", true);
        } else {
            responseJson.put("success", false);
        }
        return responseJson;
    }

    public HashMap<String, Object> getAllAccessibleBoards(Map<String, Object> params) throws Exception {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User currentUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashMap<String, Object> response = new HashMap<String, Object>();
        List solutionBoards = this.solutionBoardRepository.findAll();
        HashMap solutionAreaAndCollections = this.solutionAreaService.getSolutionAreasAndCollections(null);
        List allowedSolutionAreas = (List)solutionAreaAndCollections.get("solutionAreas");
        List allowedWorkspaces = (List)solutionAreaAndCollections.get("workspaces");
        ArrayList<SolutionBoard> allowedSolutionBoards = new ArrayList<SolutionBoard>();
        HashMap solutionAreaAndCollectionsMap = new HashMap();
        if (PropertyValidator.isValid((Collection)allowedSolutionAreas)) {
            allowedSolutionAreas.stream().forEach(sa -> solutionAreaAndCollectionsMap.put(sa.getId(), sa.getId()));
        }
        if (PropertyValidator.isValid((Collection)allowedWorkspaces)) {
            allowedWorkspaces.stream().forEach(sa -> solutionAreaAndCollectionsMap.put(sa.getId(), sa.getId()));
        }
        for (SolutionBoard solBoard : solutionBoards) {
            if (solBoard.getSolutionArea() == null && solBoard.getWorkSpace() == null) {
                allowedSolutionBoards.add(this.minimisedSolutionBoard(solBoard));
                continue;
            }
            if ((!PropertyValidator.isValid((Object)solBoard.getSolutionArea()) || !solutionAreaAndCollectionsMap.containsKey(solBoard.getSolutionArea().getId())) && (!PropertyValidator.isValid((Object)solBoard.getWorkSpace()) || !solutionAreaAndCollectionsMap.containsKey(solBoard.getWorkSpace().getId()))) continue;
            allowedSolutionBoards.add(this.minimisedSolutionBoard(solBoard));
        }
        response.put("boards", allowedSolutionBoards);
        return response;
    }

    private SolutionBoard minimisedSolutionBoard(SolutionBoard solutionBoard) {
        SolutionBoard copy = new SolutionBoard();
        copy.setId(solutionBoard.getId());
        copy.setTitle(solutionBoard.getTitle());
        return copy;
    }

    public HashMap<String, Object> getPiBoardData(String sessionBoardId, String solutionId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            SessionBoard board = new SessionBoard(sessionBoardId);
            sessionBoards.add(board);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.FEATURE));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoardId)));
            query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
            DBCursor dbCursorPrefix = this.customRepository.getMongoTemplate().getCollection("item").find(query.getQueryObject()).sort((DBObject)new BasicDBObject("backlogSequence", (Object)1));
            List allItems = dbCursorPrefix.toArray();
            HashMap teamMapById = new HashMap();
            HashMap containerMapById = new HashMap();
            List containers = sessionBoard.getContainers();
            List teams = sessionBoard.getTeams();
            containers.forEach(container -> containerMapById.put(container.getId(), container));
            teams.forEach(team -> teamMapById.put(team.getId(), team));
            ArrayList statuses = new ArrayList();
            HashMap duplicationAvoidMap = new HashMap();
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapById = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
            ArrayList itemLinks = new ArrayList();
            ArrayList almLinks = new ArrayList();
            ArrayList almSolLinks = new ArrayList();
            ArrayList<Item> parentItems = new ArrayList<Item>();
            ArrayList<Item> currentBoardItems = new ArrayList<Item>();
            Collection configFields = this.getItemJiraFieldMap(sessionBoard);
            if (PropertyValidator.isValid((Collection)allItems)) {
                for (DBObject vo2 : allItems) {
                    Item item2 = this.createItemForSolution(vo2, duplicationAvoidMap, statuses, itemLinks, almLinks, almSolLinks, teamMapById, containerMapById, issueTypeMapById);
                    SessionBoard itemSessionBoard = new SessionBoard();
                    itemSessionBoard.setId(sessionBoardId);
                    ArrayList<SessionBoard> sbs = new ArrayList<SessionBoard>();
                    sbs.add(itemSessionBoard);
                    item2.setSessionBoards(sbs);
                    currentBoardItems.add(item2);
                    if (PropertyValidator.isValid((Object)item2.getJiraFieldByKey())) {
                        item2.putCustomeValuesAsText(item2.getJiraFieldByKey(), configFields, null);
                    }
                    parentItems.add(item2);
                }
            }
            List allItemLinks = this.itemLinkRepository.findByIdIn(itemLinks);
            List allAlmLinks = this.itemJiraDependencyRepository.findByIdIn(almLinks);
            List allAlmSolLinks = this.itemJiraDependencyRepository.findByIdIn(almSolLinks);
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(statuses));
            dbCursorPrefix = this.customRepository.getMongoTemplate().getCollection("status").find(query.getQueryObject());
            List statusesRaw = dbCursorPrefix.toArray();
            ArrayList<Status> allStatuses = new ArrayList<Status>();
            if (PropertyValidator.isValid((Collection)statusesRaw)) {
                statusesRaw.forEach(vo -> allStatuses.add(new Status(vo)));
            }
            HashMap itemLinksMap = new HashMap();
            HashMap almLinksMap = new HashMap();
            HashMap almSolLinksMap = new HashMap();
            HashMap statusesMap = new HashMap();
            if (PropertyValidator.isValid((Collection)allItemLinks)) {
                allItemLinks.forEach(item -> itemLinksMap.put(item.getId(), item));
            }
            if (PropertyValidator.isValid((Collection)allAlmLinks)) {
                allAlmLinks.forEach(item -> almLinksMap.put(item.getId(), item));
            }
            if (PropertyValidator.isValid((Collection)allAlmSolLinks)) {
                allAlmSolLinks.forEach(item -> almSolLinksMap.put(item.getId(), item));
            }
            if (PropertyValidator.isValid(allStatuses)) {
                allStatuses.forEach(item -> {
                    item.setWorkFlow(null);
                    item.setWorkFlowItemType(null);
                    statusesMap.put(item.getId(), item);
                });
            }
            if (PropertyValidator.isValid(currentBoardItems)) {
                Iterator iterator = currentBoardItems.iterator();
                while (iterator.hasNext()) {
                    List orgAlmLinks;
                    List _temLinks;
                    Item it;
                    Item item3 = it = (Item)iterator.next();
                    item3.setStatus((Status)statusesMap.get(item3.getStatus().getId()));
                    ArrayList solutionSourceItemLinks = item3.getSolutionSourceItemLinks();
                    if (PropertyValidator.isValid((Collection)solutionSourceItemLinks)) {
                        ArrayList newItemLinks = new ArrayList();
                        solutionSourceItemLinks.forEach(link -> {
                            ItemLink savedLink = (ItemLink)itemLinksMap.get(link.getId());
                            if (PropertyValidator.isValid((Object)savedLink) && PropertyValidator.isValid((Object)savedLink.getSolutionId()) && savedLink.getSolutionId().equals(solutionId)) {
                                newItemLinks.add(savedLink);
                            }
                        });
                        item3.setSolutionSourceItemLinks(newItemLinks);
                    }
                    if (PropertyValidator.isValid((Collection)(_temLinks = item3.getItemLinks()))) {
                        ArrayList newItemLinks = new ArrayList();
                        _temLinks.forEach(link -> {
                            ItemLink savedLink = (ItemLink)itemLinksMap.get(link.getId());
                            if (PropertyValidator.isValid((Object)savedLink)) {
                                newItemLinks.add(savedLink);
                            }
                        });
                        item3.setItemLinks(newItemLinks);
                    }
                    if (!PropertyValidator.isValid((Collection)(orgAlmLinks = item3.getJiraDependencies()))) continue;
                    ArrayList newJiraLinks = new ArrayList();
                    orgAlmLinks.forEach(link -> {
                        ItemJiraDependency newLink;
                        if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)(newLink = (ItemJiraDependency)almLinksMap.get(link.getId())))) {
                            newJiraLinks.add(newLink);
                        }
                    });
                    item3.setJiraDependencies(newJiraLinks);
                }
            }
            response.put("items", parentItems);
            if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                List tfsProjects = this.tfsProjectRepository.findBySessionId(sessionBoard.getSession().getId());
                if (PropertyValidator.isValid((Collection)tfsProjects)) {
                    for (int i = 0; i < tfsProjects.size(); ++i) {
                        TFSProject project = (TFSProject)tfsProjects.get(i);
                        List itemTypes = this.workFlowItemTypeRepository.findBySessionIdAndTfsProjectId(sessionBoard.getSession().getId(), project.getTfsId());
                        project.setItemTypes(itemTypes);
                        WorkFlow workflow = this.workFlowRepository.findBySessionIdAndTfsProjectId(sessionBoard.getSession().getId(), project.getTfsId());
                        project.setWorkFlow(workflow);
                        List workflowStatuses = this.statusRepository.findByWorkFlow(workflow);
                        if (PropertyValidator.isValid((Collection)workflowStatuses)) {
                            workflowStatuses.forEach(st -> {
                                WorkFlowItemType itemType = new WorkFlowItemType();
                                itemType.setId(st.getWorkFlowItemType().getId());
                                itemType.setTitle(st.getWorkFlowItemType().getTitle());
                                st.setWorkFlowItemType(itemType);
                            });
                        }
                        workflow.setStatuses(workflowStatuses);
                    }
                }
                response.put("tfsProjects", tfsProjects);
            }
            return response;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "Server exception while fetching data.");
            return response;
        }
    }

    public HashMap<String, Object> createItemLinks(ArrayList<ItemLink> itemLinks, Item sourceItem, SolutionBoard solutionBoard, String metaMap) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Item unsafeSourceItem = null;
        if (PropertyValidator.isValid((Object)sourceItem) && PropertyValidator.isValid((Object)sourceItem.getId())) {
            unsafeSourceItem = this.itemRepository.findById(sourceItem.getId());
        }
        if (PropertyValidator.isValid(unsafeSourceItem)) {
            Item saveSourceItem = unsafeSourceItem;
            if (PropertyValidator.isValid(itemLinks)) {
                ArrayList<Item> targetItems = new ArrayList<Item>();
                HashMap<String, Item> targetItemMap = new HashMap<String, Item>();
                if (saveSourceItem.getSolutionSourceItemLinks() == null) {
                    saveSourceItem.setSolutionSourceItemLinks(new ArrayList());
                }
                ArrayList linkErros = new ArrayList();
                for (int i = 0; i < itemLinks.size(); ++i) {
                    ItemLink itemLink = itemLinks.get(i);
                    boolean linkArleadyExist = false;
                    boolean linkValid = this.validateItemLinkForSave(itemLink);
                    Item targetItem = null;
                    if (linkValid && (targetItem = (Item)targetItemMap.get(itemLink.getTargetItemId())) == null && PropertyValidator.isValid((Object)(targetItem = this.itemRepository.findById(itemLink.getTargetItemId())))) {
                        targetItemMap.put(targetItem.getId(), targetItem);
                        targetItems.add(targetItem);
                        linkArleadyExist = this.isLinkAlreadyExist(itemLink, saveSourceItem, targetItem);
                    }
                    if (PropertyValidator.isValid(targetItem) && linkValid && !linkArleadyExist) {
                        String linkType;
                        if (targetItem.getSolutionTargetItemLinks() == null) {
                            targetItem.setSolutionTargetItemLinks(new ArrayList());
                        }
                        targetItem.getSolutionTargetItemLinks().add(itemLink);
                        saveSourceItem.getSolutionSourceItemLinks().add(itemLink);
                        AlmAccount sourceAlmAccount = this.almAccountRepository.findById(itemLink.getSourceAlmId());
                        AlmAccount targetAlmAccount = this.almAccountRepository.findById(itemLink.getTargetAlmId());
                        if (!PropertyValidator.isValid((Object)sourceAlmAccount) || !PropertyValidator.isValid((Object)targetAlmAccount)) continue;
                        SolutionAlmSettings solutionAlmSettings = null;
                        if (PropertyValidator.isValid((Collection)solutionBoard.getSolutionAlmSettings())) {
                            solutionAlmSettings = solutionBoard.getSolutionAlmSettings().stream().filter(sas -> sas.getAlmAccountId().equals(sourceAlmAccount.getId())).findAny().orElse(null);
                        }
                        if (!PropertyValidator.isValid(solutionAlmSettings) || !solutionAlmSettings.getDependencyEnabled().booleanValue() || !sourceAlmAccount.getUrl().equals(targetAlmAccount.getUrl()) || (linkType = (String)solutionAlmSettings.getLinkTypes().stream().filter(sas -> sas.equals(itemLink.getType())).findAny().orElse(null)) == null) continue;
                        if (sourceAlmAccount.getType().equals("tfs")) {
                            HashMap<String, JSONObject> fields = new HashMap<String, JSONObject>();
                            JSONObject relationObject = new JSONObject();
                            try {
                                relationObject.put("rel", (Object)itemLink.getType());
                                relationObject.put("url", (Object)targetItem.getTfsURL());
                                fields.put("relation", relationObject);
                                Item safeTargetItem = targetItem;
                                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                            }
                            catch (JSONException e) {
                                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                            }
                            continue;
                        }
                        if (!sourceAlmAccount.getType().equals("jira")) continue;
                        Item safeTargetItem = targetItem;
                        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                        continue;
                    }
                    HashMap<String, String> error = new HashMap<String, String>();
                    error.put("sourceItem", itemLink.getSourceItemId());
                    error.put("targetItem", itemLink.getTargetItemId());
                    if (!linkValid) {
                        error.put("reason", "Invalid link");
                    } else if (linkArleadyExist) {
                        error.put("reason", "link already exist.");
                    } else {
                        error.put("reason", "Target not found");
                    }
                    linkErros.add(error);
                    itemLinks.remove(i);
                    --i;
                }
                if (PropertyValidator.isValid(itemLinks)) {
                    List links = this.itemLinkRepository.save(itemLinks);
                    this.itemRepository.save((Object)saveSourceItem);
                    this.itemRepository.save(targetItems);
                    Gson g = new Gson();
                    String element = g.toJson((Object)links, new /* Unavailable Anonymous Inner Class!! */.getType());
                    JSONObject pushJson = new JSONObject();
                    try {
                        JSONObject metaMapJson = new JSONObject(metaMap);
                        JSONArray linksJSON = new JSONArray(element);
                        metaMapJson.put("itemLinks", (Object)linksJSON);
                        pushJson.put("type", (Object)"Links");
                        pushJson.put("metaMap", (Object)metaMapJson.toString());
                        PushSender.sendMsg((String)pushJson.toString());
                    }
                    catch (JSONException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
                response.put("status", "success");
                response.put("itemLinks", itemLinks);
                response.put("linkErrors", linkErros);
                response.put("sourceItem", saveSourceItem);
            } else {
                response.put("status", "failure");
                response.put("statusCode", "0");
                response.put("reason", "No link to save.");
            }
        } else {
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "Invalid source item.");
        }
        return response;
    }

    public HashMap<String, Object> createItemLinks1(Item item, SolutionBoard solutionBoard, String metaMap) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Item unsafeSourceItem = null;
        if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Object)item.getId())) {
            unsafeSourceItem = this.itemRepository.findById(item.getId());
        }
        ArrayList<ItemLink> itemLinks = new ArrayList<ItemLink>();
        if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
            for (int i = 0; i < item.getItemLinks().size(); ++i) {
                ItemLink safeItemLink;
                Item safeItem;
                Item safeTargetItem;
                ItemLink safeItemLink2;
                Item safeItem2;
                JSONObject relationObject;
                HashMap<String, JSONObject> fields;
                String linkType;
                ItemLink itemLinkFinal;
                ItemLink itemLink = (ItemLink)item.getItemLinks().get(i);
                itemLink = (ItemLink)this.itemLinkRepository.save((Object)itemLink);
                itemLinks.add(itemLink);
                if (unsafeSourceItem.getItemLinks() == null) {
                    unsafeSourceItem.setItemLinks(new ArrayList());
                }
                unsafeSourceItem.getItemLinks().add(itemLink);
                Item targetItem = this.itemRepository.findById(itemLink.getTargetFeatureId() != null ? itemLink.getTargetFeatureId() : itemLink.getTargetItemId());
                if (PropertyValidator.isValid((Object)itemLink.getSessionBoardId())) {
                    SessionBoard sessionBoard = this.sessionBoardRepository.findById(itemLink.getSessionBoardId());
                    if (!sessionBoard.getSession().getJiraDependencyEnabled().booleanValue()) continue;
                    AlmAccount sourceAlmAccount = this.almAccountRepository.findById(itemLink.getSourceAlmId());
                    AlmAccount targetAlmAccount = this.almAccountRepository.findById(itemLink.getTargetAlmId());
                    if (!PropertyValidator.isValid((Object)sourceAlmAccount) || !PropertyValidator.isValid((Object)targetAlmAccount)) continue;
                    itemLinkFinal = itemLink;
                    linkType = sessionBoard.getSession().getJiraLinkTypes().stream().filter(sas -> sas.equals(itemLinkFinal.getType())).findAny().orElse(null);
                    if (linkType == null) continue;
                    if (sourceAlmAccount.getType().equals("tfs")) {
                        fields = new HashMap<String, JSONObject>();
                        relationObject = new JSONObject();
                        try {
                            relationObject.put("rel", (Object)itemLink.getType());
                            relationObject.put("url", (Object)targetItem.getTfsURL());
                            fields.put("relation", relationObject);
                            safeItem2 = unsafeSourceItem;
                            safeItemLink2 = itemLink;
                            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                        }
                        catch (JSONException e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                        continue;
                    }
                    if (!sourceAlmAccount.getType().equals("jira")) continue;
                    safeTargetItem = targetItem;
                    safeItem = unsafeSourceItem;
                    safeItemLink = itemLink;
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    continue;
                }
                AlmAccount sourceAlmAccount = this.almAccountRepository.findById(itemLink.getSourceAlmId());
                AlmAccount targetAlmAccount = this.almAccountRepository.findById(itemLink.getTargetAlmId());
                if (!PropertyValidator.isValid((Object)sourceAlmAccount) || !PropertyValidator.isValid((Object)targetAlmAccount)) continue;
                SolutionAlmSettings solutionAlmSettings = null;
                if (PropertyValidator.isValid((Collection)solutionBoard.getSolutionAlmSettings())) {
                    solutionAlmSettings = solutionBoard.getSolutionAlmSettings().stream().filter(sas -> sas.getAlmAccountId().equals(sourceAlmAccount.getId())).findAny().orElse(null);
                }
                if (!PropertyValidator.isValid(solutionAlmSettings) || !solutionAlmSettings.getDependencyEnabled().booleanValue() || !sourceAlmAccount.getUrl().equals(targetAlmAccount.getUrl())) continue;
                itemLinkFinal = itemLink;
                linkType = solutionAlmSettings.getLinkTypes().stream().filter(sas -> sas.equals(itemLinkFinal.getType())).findAny().orElse(null);
                if (linkType == null) continue;
                if (sourceAlmAccount.getType().equals("tfs")) {
                    fields = new HashMap();
                    relationObject = new JSONObject();
                    try {
                        relationObject.put("rel", (Object)itemLink.getType());
                        relationObject.put("url", (Object)targetItem.getTfsURL());
                        fields.put("relation", relationObject);
                        safeItem2 = unsafeSourceItem;
                        safeItemLink2 = itemLink;
                        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    }
                    catch (JSONException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    continue;
                }
                if (!sourceAlmAccount.getType().equals("jira")) continue;
                safeTargetItem = targetItem;
                safeItem = unsafeSourceItem;
                safeItemLink = itemLink;
                SolutionAlmSettings safeSolutionAlmSettings = solutionAlmSettings;
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
        }
        Item savedItem = (Item)this.itemRepository.save((Object)unsafeSourceItem);
        response.put("item", savedItem);
        response.put("links", itemLinks);
        if (PropertyValidator.isValid(itemLinks)) {
            Gson g = new Gson();
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            String itemLinksStr = g.toJson(itemLinks, new /* Unavailable Anonymous Inner Class!! */.getType());
            String itemStr = gsonExclusive.toJson((Object)savedItem, new /* Unavailable Anonymous Inner Class!! */.getType());
            JSONObject pushJson = new JSONObject();
            try {
                JSONObject metaMapJson = new JSONObject(metaMap);
                JSONObject itemJson = new JSONObject(itemStr);
                JSONArray linksJSON = new JSONArray(itemLinksStr);
                metaMapJson.put("itemLinks", (Object)linksJSON);
                metaMapJson.put("item", (Object)itemJson);
                pushJson.put("type", (Object)"Links");
                pushJson.put("metaMap", (Object)metaMapJson.toString());
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return response;
    }

    public HashMap<String, Object> deleteItemLinks(ArrayList<ItemLink> itemLinks, String metaMap) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (PropertyValidator.isValid(itemLinks)) {
            ArrayList<Item> targetItems = new ArrayList<Item>();
            HashMap<String, Item> targetItemMap = new HashMap<String, Item>();
            ArrayList<Item> sourceItems = new ArrayList<Item>();
            HashMap<String, Item> sourceItemMap = new HashMap<String, Item>();
            for (int i = 0; i < itemLinks.size(); ++i) {
                int linkIndex;
                ArrayList links;
                Item sourceItem;
                ItemLink itemLink = itemLinks.get(i);
                Item targetItem = (Item)targetItemMap.get(itemLink.getTargetItemId());
                if (targetItem == null && PropertyValidator.isValid((Object)(targetItem = this.itemRepository.findById(itemLink.getTargetItemId())))) {
                    targetItemMap.put(targetItem.getId(), targetItem);
                    targetItems.add(targetItem);
                }
                if ((sourceItem = (Item)sourceItemMap.get(itemLink.getSourceItemId())) == null && PropertyValidator.isValid((Object)(sourceItem = this.itemRepository.findById(itemLink.getSourceItemId())))) {
                    sourceItemMap.put(sourceItem.getId(), sourceItem);
                    sourceItems.add(sourceItem);
                }
                if (PropertyValidator.isValid((Object)targetItem) && PropertyValidator.isValid((Collection)(links = targetItem.getSolutionTargetItemLinks()))) {
                    linkIndex = IntStream.range(0, links.size()).filter(ind -> itemLink.getId().equals(((ItemLink)links.get(ind)).getId())).findFirst().orElse(-1);
                    if (linkIndex > -1) {
                        links.remove(linkIndex);
                    }
                    if (links.isEmpty()) {
                        targetItem.setSolutionTargetItemLinks(null);
                    }
                }
                if (!PropertyValidator.isValid((Object)sourceItem) || !PropertyValidator.isValid((Collection)(links = sourceItem.getSolutionSourceItemLinks()))) continue;
                linkIndex = IntStream.range(0, links.size()).filter(ind -> itemLink.getId().equals(((ItemLink)links.get(ind)).getId())).findFirst().orElse(-1);
                if (linkIndex > -1) {
                    links.remove(linkIndex);
                }
                if (!links.isEmpty()) continue;
                targetItem.setSolutionSourceItemLinks(null);
            }
            this.itemLinkRepository.delete(itemLinks);
            if (PropertyValidator.isValid(sourceItems)) {
                this.itemRepository.save(sourceItems);
            }
            if (PropertyValidator.isValid(targetItems)) {
                this.itemRepository.save(targetItems);
            }
            response.put("status", "success");
            response.put("itemLinks", itemLinks);
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("type", (Object)"Links");
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        } else {
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "No link to delete.");
        }
        return response;
    }

    public HashMap<String, Object> deleteItemLinks1(ArrayList<ItemLink> itemLinks, String metaMap) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (PropertyValidator.isValid(itemLinks)) {
            ArrayList<Item> targetItems = new ArrayList<Item>();
            HashMap<String, Item> targetItemMap = new HashMap<String, Item>();
            ArrayList<Item> sourceItems = new ArrayList<Item>();
            HashMap<String, Item> sourceItemMap = new HashMap<String, Item>();
            for (int i = 0; i < itemLinks.size(); ++i) {
                int linkIndex;
                ArrayList links;
                Item sourceItem;
                ItemLink itemLink = itemLinks.get(i);
                Item targetItem = (Item)targetItemMap.get(itemLink.getTargetItemId());
                if (targetItem == null && PropertyValidator.isValid((Object)(targetItem = this.itemRepository.findById(itemLink.getTargetItemId())))) {
                    targetItemMap.put(targetItem.getId(), targetItem);
                    targetItems.add(targetItem);
                }
                if ((sourceItem = (Item)sourceItemMap.get(itemLink.getSourceItemId())) == null && PropertyValidator.isValid((Object)(sourceItem = this.itemRepository.findById(itemLink.getSourceItemId())))) {
                    sourceItemMap.put(sourceItem.getId(), sourceItem);
                    sourceItems.add(sourceItem);
                }
                if (PropertyValidator.isValid((Object)targetItem) && PropertyValidator.isValid((Collection)(links = targetItem.getSolutionTargetItemLinks()))) {
                    linkIndex = IntStream.range(0, links.size()).filter(ind -> itemLink.getId().equals(((ItemLink)links.get(ind)).getId())).findFirst().orElse(-1);
                    if (linkIndex > -1) {
                        links.remove(linkIndex);
                    }
                    if (links.isEmpty()) {
                        targetItem.setSolutionTargetItemLinks(null);
                    }
                }
                if (!PropertyValidator.isValid((Object)sourceItem) || !PropertyValidator.isValid((Collection)(links = sourceItem.getSolutionSourceItemLinks()))) continue;
                linkIndex = IntStream.range(0, links.size()).filter(ind -> itemLink.getId().equals(((ItemLink)links.get(ind)).getId())).findFirst().orElse(-1);
                if (linkIndex > -1) {
                    links.remove(linkIndex);
                }
                if (!links.isEmpty()) continue;
                targetItem.setSolutionSourceItemLinks(null);
            }
            this.itemLinkRepository.delete(itemLinks);
            if (PropertyValidator.isValid(sourceItems)) {
                this.itemRepository.save(sourceItems);
            }
            if (PropertyValidator.isValid(targetItems)) {
                this.itemRepository.save(targetItems);
            }
            response.put("status", "success");
            response.put("itemLinks", itemLinks);
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("type", (Object)"Links");
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        } else {
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "No link to delete.");
        }
        return response;
    }

    public HashMap<String, Object> deleteAlmLink1(Item item, String linkId, String solutionId, String almId, String metaMap) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)item) && item.getJiraDependencies() != null) {
            int index = -1;
            for (int i = 0; i < item.getJiraDependencies().size(); ++i) {
                ItemJiraDependency link = (ItemJiraDependency)item.getJiraDependencies().get(i);
                if (!PropertyValidator.isValid((Object)link) || !link.getId().equals(linkId)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                ItemJiraDependency link = (ItemJiraDependency)item.getJiraDependencies().get(index);
                item.getJiraDependencies().remove(index);
                item = (Item)this.itemRepository.save((Object)item);
                this.itemJiraDependencyRepository.delete((Object)link);
                response.put("status", "success");
                response.put("item", item);
                response.put("linkId", linkId);
                Item reverseItem = null;
                ItemJiraDependency reverseDependency = null;
                if (PropertyValidator.isValid((Object)link.getSourceItemId()) && PropertyValidator.isValid((Object)link.getTargetItemId()) && PropertyValidator.isValid((Object)(reverseDependency = this.itemJiraDependencyRepository.findBySourceItemIdAndTargetItemId(link.getTargetItemId(), link.getSourceItemId())))) {
                    reverseItem = this.itemRepository.findById(reverseDependency.getSourceItemId());
                    this.itemJiraDependencyRepository.delete((Object)reverseDependency);
                    response.put("reverseLinkId", reverseDependency.getId());
                    if (PropertyValidator.isValid((Object)reverseItem)) {
                        reverseItem.getJiraDependencies().remove(reverseDependency);
                        this.itemRepository.save((Object)reverseItem);
                        response.put("reverseItem", reverseItem);
                    }
                }
                this.almSyncService.deleteKendisAndAlmLink((Object)link, item, null);
                AlmAccount almAccount = this.almAccountRepository.findById(almId);
                if (almAccount.getType().equals("tfs")) {
                    String sourceTfsId = link.getSourceTFSItem().getTfsId();
                    String targetTfsId = link.getTargetTFSItem().getTfsId();
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                } else if (PropertyValidator.isValid((Object)link)) {
                    User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
                    String jiraIssueLinkId = link.getJiraDependencyId();
                    String almAccountId = almAccount.getId();
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                }
                if (PropertyValidator.isValid((Object)metaMap)) {
                    JSONObject pushJson = new JSONObject();
                    try {
                        pushJson.put("type", (Object)"Links");
                        Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                        HashMap<String, Object> pushData = new HashMap<String, Object>();
                        pushData.put("item", item);
                        pushData.put("linkId", link.getId());
                        if (PropertyValidator.isValid((Object)reverseItem) && PropertyValidator.isValid((Object)reverseDependency)) {
                            pushData.put("reverseItem", reverseItem);
                            pushData.put("reverseLinkId", reverseDependency.getId());
                        }
                        String itemStr = gsonExclusive.toJson(pushData);
                        pushJson.put("data", (Object)itemStr);
                        pushJson.put("metaMap", (Object)metaMap);
                        PushSender.sendMsg((String)pushJson.toString());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return response;
    }

    public HashMap<String, Object> deleteAlmLink(Item item, String linkId, String solutionId, String almId, String metaMap) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Collection)item.getSolutionAlmDependencies())) {
            int index = -1;
            for (int i = 0; i < item.getSolutionAlmDependencies().size(); ++i) {
                ItemJiraDependency link = (ItemJiraDependency)item.getSolutionAlmDependencies().get(i);
                if (!link.getId().equals(linkId)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                ItemJiraDependency link = (ItemJiraDependency)item.getSolutionAlmDependencies().get(index);
                item.getSolutionAlmDependencies().remove(index);
                item = (Item)this.itemRepository.save((Object)item);
                this.itemJiraDependencyRepository.delete((Object)link);
                Item reverseItem = null;
                ItemJiraDependency reverseDependency = null;
                if (PropertyValidator.isValid((Object)link.getSourceItemId()) && PropertyValidator.isValid((Object)link.getTargetItemId()) && PropertyValidator.isValid((Object)(reverseDependency = this.itemJiraDependencyRepository.findBySourceItemIdAndTargetItemIdAndSolutionId(link.getTargetItemId(), link.getSourceItemId(), solutionId)))) {
                    reverseItem = this.itemRepository.findById(reverseDependency.getSourceItemId());
                    response.put("reverseLinkId", reverseDependency.getId());
                    this.itemJiraDependencyRepository.delete((Object)reverseDependency);
                    if (PropertyValidator.isValid((Object)reverseItem)) {
                        reverseItem.getSolutionAlmDependencies().remove(reverseDependency);
                        this.itemRepository.save((Object)reverseItem);
                        response.put("reverseItem", reverseItem);
                    }
                    if (PropertyValidator.isValid((Object)reverseItem)) {
                        AlmAccount almAccount = this.almAccountRepository.findById(almId);
                        String sourceTfsId = item.getTfsId();
                        String targetTfsId = reverseItem.getTfsId();
                        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    }
                }
                response.put("status", "success");
                response.put("item", item);
                response.put("linkId", linkId);
                if (PropertyValidator.isValid((Object)metaMap)) {
                    JSONObject pushJson = new JSONObject();
                    try {
                        pushJson.put("type", (Object)"Links");
                        Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                        HashMap<String, Object> pushData = new HashMap<String, Object>();
                        pushData.put("item", item);
                        pushData.put("linkId", link.getId());
                        if (PropertyValidator.isValid((Object)reverseItem) && PropertyValidator.isValid((Object)reverseDependency)) {
                            pushData.put("reverseItem", reverseItem);
                            pushData.put("reverseLinkId", reverseDependency.getId());
                        }
                        String itemStr = gsonExclusive.toJson(pushData);
                        pushJson.put("data", (Object)itemStr);
                        pushJson.put("metaMap", (Object)metaMap);
                        PushSender.sendMsg((String)pushJson.toString());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                response.put("status", "failure");
                response.put("reason", "Dependency does't exist");
            }
        } else {
            response.put("status", "failure");
            response.put("reason", "Invalid input");
        }
        return response;
    }

    public HashMap<String, Object> updateItemLink(String sessionBoardId, String itemId, ArrayList<ItemLink> itemLinks, String metaMap) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (PropertyValidator.isValid(itemLinks)) {
            ItemLink itemLink = itemLinks.get(0);
            this.itemLinkRepository.save((Object)itemLink);
            response.put("status", "success");
            response.put("link", itemLink);
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("type", (Object)"Links");
                Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                HashMap<String, String> pushData = new HashMap<String, String>();
                pushData.put("sessionBoardId", sessionBoardId);
                pushData.put("itemId", itemId);
                pushData.put("link", (String)itemLink);
                String itemStr = gsonExclusive.toJson(pushData);
                pushJson.put("data", (Object)itemStr);
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        } else {
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "No link to save.");
        }
        return response;
    }

    public HashMap<String, Object> linkTFSProjectWithSolution(String solutionId, String tfsProjectId, String almAccountId, String metaMap, String requestId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
        List tfsProjects = this.tfSservice.linkTFSProjectsWithSolution(tfsProjectId, solutionId, almAccount, null);
        if (PropertyValidator.isValid((Collection)tfsProjects)) {
            for (int i = 0; i < tfsProjects.size(); ++i) {
                TFSProject project = (TFSProject)tfsProjects.get(i);
                WorkFlow workFlow = new WorkFlow();
                workFlow.setTitle("workflow-" + project.getName());
                workFlow.setSolutionId(solutionId);
                workFlow.setTfsProject(project.getName());
                workFlow.setTfsProjectId(project.getTfsId());
                workFlow = (WorkFlow)this.workFlowRepository.save((Object)workFlow);
                project.setWorkFlow(workFlow);
                ArrayList<Status> statuses = new ArrayList<Status>();
                ArrayList<WorkFlowItemType> itemTypes = new ArrayList<WorkFlowItemType>();
                String itemTypeStr = project.getItemTypesStr();
                if (PropertyValidator.isValid((Object)itemTypeStr)) {
                    try {
                        JSONObject typesObjectJSON = new JSONObject(itemTypeStr);
                        JSONArray typesArrayJSON = typesObjectJSON.getJSONArray("value");
                        for (int j = 0; j < typesArrayJSON.length(); ++j) {
                            JSONObject typeJSON = typesArrayJSON.getJSONObject(j);
                            JSONArray statesArrayJSON = null;
                            if (!typeJSON.isNull("states")) {
                                statesArrayJSON = typeJSON.getJSONArray("states");
                            } else {
                                String responseStatesStr = this.tfsUtils.getItemTypeStates(project.getTfsId(), typeJSON.getString("name"), almAccount);
                                JSONObject statesJSON = new JSONObject(responseStatesStr);
                                statesArrayJSON = statesJSON.getJSONArray("value");
                            }
                            JSONObject trasitionsJSON = typeJSON.getJSONObject("transitions");
                            DBObject trasitionsDBObject = (DBObject)JSON.parse((String)trasitionsJSON.toString());
                            WorkFlowItemType itemType = new WorkFlowItemType(typeJSON.getString("name"), typeJSON.getString("referenceName"));
                            itemType.setSolutionId(solutionId);
                            itemType.setTfsProject(project.getName());
                            itemType.setTfsProjectId(project.getTfsId());
                            itemType.setIsDisabled(Boolean.valueOf(typeJSON.getBoolean("isDisabled")));
                            itemType.setTransitions(trasitionsDBObject);
                            itemType = (WorkFlowItemType)this.workFlowItemTypeRepository.save((Object)itemType);
                            itemTypes.add(itemType);
                            for (int k = 0; k < statesArrayJSON.length(); ++k) {
                                JSONObject stateJSON = statesArrayJSON.getJSONObject(k);
                                Status status = new Status();
                                status.setTfsProject(project.getName());
                                status.setTfsProjectId(project.getTfsId());
                                status.setWorkFlowItemType(itemType);
                                status.setItemType(itemType.getTitle());
                                status.setTitle(stateJSON.getString("name"));
                                status.setColor(stateJSON.getString("color"));
                                status.setCategory(this.tfsToKendisStatusCategory(stateJSON.getString("category")));
                                status.setSolutionId(solutionId);
                                statuses.add(status);
                                WorkFlow wf = new WorkFlow();
                                wf.setId(workFlow.getId());
                                status.setWorkFlow(wf);
                            }
                        }
                    }
                    catch (JSONException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
                project.setItemTypes(itemTypes);
                if (statuses.isEmpty()) continue;
                List savedStatuses = this.statusRepository.save(statuses);
                workFlow.setStatuses(savedStatuses);
            }
        }
        responseJson.put("tfsProjects", tfsProjects);
        return responseJson;
    }

    public HashMap<String, Object> resyncTFSProject(String projectId, String solutionId, String metaMap, String requestId) {
        HashMap<String, Object> responseJson;
        block19: {
            responseJson = new HashMap<String, Object>();
            TFSProject projectToBeResync = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)projectId));
            if (!PropertyValidator.isValid((Object)projectToBeResync)) {
                responseJson.put("status", "failure");
                responseJson.put("reason", "Invalid project id");
                responseJson.put("code", "0");
                return responseJson;
            }
            SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionId));
            WorkFlow workflowToBeDeleted = this.workFlowRepository.findBySolutionIdAndTfsProjectId(solutionId, projectToBeResync.getTfsId());
            List workflowItemTypesToBeDeleted = this.workFlowItemTypeRepository.findBySolutionIdAndTfsProjectId(solutionId, projectToBeResync.getTfsId());
            List statusesToBeDeleted = this.statusRepository.findByWorkFlow(workflowToBeDeleted);
            try {
                List tfsProjects = this.tfSservice.linkTFSProjectsWithSolution(projectToBeResync.getTfsId(), solutionId, projectToBeResync.getAlmAccount(), projectToBeResync);
                if (PropertyValidator.isValid((Collection)tfsProjects)) {
                    this.workFlowRepository.delete((Object)workflowToBeDeleted);
                    this.workFlowItemTypeRepository.delete((Iterable)workflowItemTypesToBeDeleted);
                    this.statusRepository.delete((Iterable)statusesToBeDeleted);
                    TFSProject tfsProject = (TFSProject)tfsProjects.get(0);
                    if (PropertyValidator.isValid((Object)tfsProject)) {
                        WorkFlow workFlow = new WorkFlow();
                        workFlow.setTitle("workflow-" + tfsProject.getName());
                        workFlow.setSolutionId(solutionId);
                        workFlow.setTfsProject(tfsProject.getName());
                        workFlow.setTfsProjectId(tfsProject.getTfsId());
                        workFlow = (WorkFlow)this.workFlowRepository.save((Object)workFlow);
                        tfsProject.setWorkFlow(workFlow);
                        ArrayList<Status> statuses = new ArrayList<Status>();
                        ArrayList<WorkFlowItemType> itemTypes = new ArrayList<WorkFlowItemType>();
                        String itemTypeStr = tfsProject.getItemTypesStr();
                        if (PropertyValidator.isValid((Object)itemTypeStr)) {
                            try {
                                JSONObject typesObjectJSON = new JSONObject(itemTypeStr);
                                JSONArray typesArrayJSON = typesObjectJSON.getJSONArray("value");
                                for (int j = 0; j < typesArrayJSON.length(); ++j) {
                                    JSONObject typeJSON = typesArrayJSON.getJSONObject(j);
                                    JSONArray statesArrayJSON = null;
                                    if (!typeJSON.isNull("states")) {
                                        statesArrayJSON = typeJSON.getJSONArray("states");
                                    } else {
                                        String responseStatesStr = this.tfsUtils.getItemTypeStates(tfsProject.getTfsId(), typeJSON.getString("name"), projectToBeResync.getAlmAccount());
                                        JSONObject statesJSON = new JSONObject(responseStatesStr);
                                        statesArrayJSON = statesJSON.getJSONArray("value");
                                    }
                                    JSONObject trasitionsJSON = typeJSON.getJSONObject("transitions");
                                    DBObject trasitionsDBObject = (DBObject)JSON.parse((String)trasitionsJSON.toString());
                                    WorkFlowItemType itemType = new WorkFlowItemType(typeJSON.getString("name"), typeJSON.getString("referenceName"));
                                    itemType.setSolutionId(solutionId);
                                    itemType.setTfsProject(tfsProject.getName());
                                    itemType.setTfsProjectId(tfsProject.getTfsId());
                                    itemType.setTransitions(trasitionsDBObject);
                                    itemType.setIsDisabled(Boolean.valueOf(typeJSON.getBoolean("isDisabled")));
                                    itemType = (WorkFlowItemType)this.workFlowItemTypeRepository.save((Object)itemType);
                                    itemTypes.add(itemType);
                                    for (int k = 0; k < statesArrayJSON.length(); ++k) {
                                        JSONObject stateJSON = statesArrayJSON.getJSONObject(k);
                                        Status status = new Status();
                                        status.setTfsProject(tfsProject.getName());
                                        status.setTfsProjectId(tfsProject.getTfsId());
                                        status.setWorkFlowItemType(itemType);
                                        status.setItemType(itemType.getTitle());
                                        status.setTitle(stateJSON.getString("name"));
                                        status.setColor(stateJSON.getString("color"));
                                        status.setCategory(this.tfsToKendisStatusCategory(stateJSON.getString("category")));
                                        status.setSolutionId(solutionId);
                                        statuses.add(status);
                                        WorkFlow wf = new WorkFlow();
                                        wf.setId(workFlow.getId());
                                        status.setWorkFlow(wf);
                                    }
                                }
                            }
                            catch (JSONException e) {
                                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                            }
                        }
                        tfsProject.setItemTypes(itemTypes);
                        if (!statuses.isEmpty()) {
                            List savedStatuses = this.statusRepository.save(statuses);
                            workFlow.setStatuses(savedStatuses);
                        }
                    }
                    List items = this.itemRepository.findBySolutionBoardIdAndTypeAndTfsProjectIdAndTfsIdIsNotNull(solutionId, Item.EPIC.toString(), tfsProject.getTfsId());
                    HashMap tfsIdsGroupByUser = new HashMap();
                    HashMap usersMap = new HashMap();
                    if (PropertyValidator.isValid((Collection)items)) {
                        items.forEach(item -> {
                            if (PropertyValidator.isValid((Object)item.getFetchedBy())) {
                                if (!tfsIdsGroupByUser.containsKey(item.getFetchedBy().getId())) {
                                    tfsIdsGroupByUser.put(item.getFetchedBy().getId(), new ArrayList());
                                    usersMap.put(item.getFetchedBy().getId(), item.getFetchedBy());
                                }
                                ((List)tfsIdsGroupByUser.get(item.getFetchedBy().getId())).add(item.getTfsId());
                            } else {
                                if (!tfsIdsGroupByUser.containsKey(null)) {
                                    tfsIdsGroupByUser.put(null, new ArrayList());
                                    usersMap.put(null, null);
                                }
                                ((List)tfsIdsGroupByUser.get(null)).add(item.getTfsId());
                            }
                        });
                        AlmAccount almAccount = tfsProject.getAlmAccount();
                        ArrayList allEpics = new ArrayList();
                        ArrayList allNewFeatures = new ArrayList();
                        ArrayList allUpdatedFeatures = new ArrayList();
                        ArrayList appEpicFeatureMap = new ArrayList();
                        for (String userId : tfsIdsGroupByUser.keySet()) {
                            AlmAccount taggedAlmAccount;
                            List tfsIdsByUser = (List)tfsIdsGroupByUser.get(userId);
                            User fetchByUser = (User)usersMap.get(userId);
                            if (PropertyValidator.isValid((Object)fetchByUser) && PropertyValidator.isValid((Object)(taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)fetchByUser, (AlmAccount)almAccount)))) {
                                almAccount = taggedAlmAccount;
                            }
                            HashMap result = this.tfSservice.fetchTFSEpicItems(tfsIdsByUser, null, solutionBoard, null, tfsProject.getAlmAccount(), requestId, Boolean.valueOf(true));
                            ArrayList epics = (ArrayList)result.get("epics");
                            ArrayList newFeatures = (ArrayList)result.get("newFeatures");
                            ArrayList updatedFeatures = (ArrayList)result.get("updatedFeatures");
                            ArrayList epicFeatureMap = (ArrayList)result.get("epicFeatureMap");
                            if (PropertyValidator.isValid((Collection)epics)) {
                                allEpics.addAll(epics);
                            }
                            if (PropertyValidator.isValid((Collection)newFeatures)) {
                                allNewFeatures.addAll(newFeatures);
                            }
                            if (PropertyValidator.isValid((Collection)updatedFeatures)) {
                                allUpdatedFeatures.addAll(updatedFeatures);
                            }
                            if (!PropertyValidator.isValid((Collection)epicFeatureMap)) continue;
                            appEpicFeatureMap.addAll(epicFeatureMap);
                        }
                    }
                    responseJson.put("status", "success");
                    responseJson.put("tfsProject", tfsProject);
                    break block19;
                }
                responseJson.put("status", "failure");
                responseJson.put("reason", "Project not found.");
            }
            catch (Exception ex) {
                responseJson.put("status", "failure");
                responseJson.put("reason", "Unknown error occures.");
            }
        }
        return responseJson;
    }

    boolean validateItemLinkForSave(ItemLink link) {
        return PropertyValidator.isValid((Object)link.getSourceSessionId()) && PropertyValidator.isValid((Object)link.getTargetSessionId()) && PropertyValidator.isValid((Object)link.getSourceItemId()) && PropertyValidator.isValid((Object)link.getTargetItemId()) && PropertyValidator.isValid((Object)link.getStatus()) && PropertyValidator.isValid((Object)link.getType()) && PropertyValidator.isValid((Object)link.getLevel()) && link.getLevel().equals(ItemLink.Level.Solution.toString());
    }

    boolean isLinkAlreadyExist(ItemLink itemLink, Item sourceItem, Item targetItem) {
        boolean linkArleadyExist = false;
        for (ItemLink link : sourceItem.getSolutionSourceItemLinks()) {
            if (!link.getSolutionId().equals(itemLink.getSolutionId()) || !link.getTargetItemId().equals(targetItem.getId())) continue;
            linkArleadyExist = true;
            break;
        }
        if (!linkArleadyExist && PropertyValidator.isValid((Collection)targetItem.getSolutionSourceItemLinks())) {
            for (ItemLink link : targetItem.getSolutionSourceItemLinks()) {
                if (!link.getSolutionId().equals(itemLink.getSolutionId()) || !link.getTargetItemId().equals(sourceItem.getId())) continue;
                linkArleadyExist = true;
                break;
            }
        }
        return linkArleadyExist;
    }

    private Collection<ItemJiraFieldMap> getItemJiraFieldMap(SessionBoard sessionBoard) {
        ArrayList<ItemJiraFieldMap> configFields = new ArrayList<ItemJiraFieldMap>();
        if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAdditionalFieldsValuesFeature())) {
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.reporter.name(), null, "JSONObject"));
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.assignee.name(), null, "JSONObject"));
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.updated.name(), null, "string"));
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.created.name(), null, "string"));
            List tmp = null;
            tmp = sessionBoard.getSession().getAdditionalFieldsValuesFeature();
            if (PropertyValidator.isValid((Collection)tmp)) {
                for (ItemJiraFieldMap field : tmp) {
                    field.setClientTimeZone(sessionBoard.getSession().getClientTimeZone());
                    configFields.add(field);
                }
            }
            if (PropertyValidator.isValid((Collection)(tmp = sessionBoard.getSession().getAdditionalFieldsValuesUserStory()))) {
                for (ItemJiraFieldMap field : tmp) {
                    field.setClientTimeZone(sessionBoard.getSession().getClientTimeZone());
                    configFields.add(field);
                }
            }
        }
        return configFields;
    }

    private String tfsToKendisStatusCategory(String tfs) {
        if (tfs.equals("Proposed")) {
            return "ToDo";
        }
        if (tfs.equals("In Progress") || tfs.equals("InProgress")) {
            return "InProgress";
        }
        if (tfs.equals("Resolved")) {
            return "Done";
        }
        if (tfs.equals("Completed")) {
            return "Done";
        }
        return "Misc";
    }

    private ItemLink solutionTargetItemLink(ItemLink link) {
        ItemLink newLink = new ItemLink();
        newLink.setId(link.getId());
        newLink.setSourceSessionId(link.getSourceSessionId());
        newLink.setSourceItemId(link.getSourceItemId());
        newLink.setSourceContainerId(link.getSourceContainerId());
        return newLink;
    }

    private Item createItemForSolution(DBObject vo, HashMap<String, String> avoidDuplicationMapById, ArrayList<Object> allStatuses, ArrayList<String> itemLinks, ArrayList<String> almLinks, ArrayList<String> almSolLinks, HashMap<String, Team> teamMapById, HashMap<String, Container> containerMapById, HashMap<String, IssueType> issueTypeMapById) {
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        Status status = new Status();
        DBRef statusRef = (DBRef)vo.get("status");
        if (statusRef != null && statusRef.getId() != null) {
            String statusId = String.valueOf(statusRef.getId());
            status.setId(statusId);
            if (avoidDuplicationMapById.get(statusId) == null) {
                avoidDuplicationMapById.put(statusId, statusId);
                allStatuses.add(statusRef.getId());
            }
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList _ssitemLinks = new ArrayList();
        List ssitemLinksRef = (List)vo.get("solutionSourceItemLinks");
        if (PropertyValidator.isValid((Collection)ssitemLinksRef)) {
            ssitemLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                if (avoidDuplicationMapById.get(linkId) == null) {
                    avoidDuplicationMapById.put(linkId, linkId);
                    itemLinks.add(linkId);
                }
                _ssitemLinks.add(link);
            });
        }
        ArrayList _stitemLinks = new ArrayList();
        List stitemLinksRef = (List)vo.get("itemLinks");
        if (PropertyValidator.isValid((Collection)stitemLinksRef)) {
            stitemLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                if (avoidDuplicationMapById.get(linkId) == null) {
                    avoidDuplicationMapById.put(linkId, linkId);
                    itemLinks.add(linkId);
                }
                _stitemLinks.add(link);
            });
        }
        ArrayList _almLinks = new ArrayList();
        List almLinksRef = (List)vo.get("jiraDependencies");
        if (PropertyValidator.isValid((Collection)almLinksRef) && almLinks != null) {
            almLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                if (avoidDuplicationMapById.get(linkId) == null) {
                    avoidDuplicationMapById.put(linkId, linkId);
                    almLinks.add(linkId);
                }
                _almLinks.add(link);
            });
        }
        ArrayList _almSolLinks = new ArrayList();
        List almSolLinksRef = (List)vo.get("solutionAlmDependencies");
        if (PropertyValidator.isValid((Collection)almSolLinksRef) && almSolLinks != null) {
            almSolLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                if (avoidDuplicationMapById.get(linkId) == null) {
                    avoidDuplicationMapById.put(linkId, linkId);
                    almSolLinks.add(linkId);
                }
                _almSolLinks.add(link);
            });
        }
        List teamContainersRef = (List)vo.get("teamContainers");
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid(teamMapById) && PropertyValidator.isValid(containerMapById) && PropertyValidator.isValid((Collection)teamContainersRef)) {
            for (int i = 0; i < teamContainersRef.size(); ++i) {
                DBRef tcRef = (DBRef)teamContainersRef.get(i);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(tcRef.getId()));
                DBCursor dbCursorDomain = this.customRepository.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
                if (!dbCursorDomain.hasNext()) continue;
                DBObject tcObject = dbCursorDomain.next();
                DBRef teamRef = (DBRef)tcObject.get("team");
                DBRef containerRef = (DBRef)tcObject.get("container");
                if (teamRef == null || containerRef == null) continue;
                Team team = teamMapById.get(String.valueOf(teamRef.getId()));
                Container container = containerMapById.get(String.valueOf(containerRef.getId()));
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(String.valueOf(tcObject.get("_id")));
                teamContainer.setOriginItemId((String)tcObject.get("originItemId"));
                teamContainer.setTeam(team);
                teamContainer.setContainer(container);
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getId()) || !PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)container.getId())) continue;
                teamContainers.add(teamContainer);
            }
        }
        ArrayList _jiraLinkTypes = new ArrayList();
        Item item = new Item(vo, status, issueType, parent, _ssitemLinks, _stitemLinks, _almLinks, _almSolLinks, teamContainers, _jiraLinkTypes);
        if (PropertyValidator.isValid((Object)vo.get("jiraFieldByKey"))) {
            item.setJiraFieldByKey((Map)vo.get("jiraFieldByKey"));
        }
        return item;
    }

    private Item addRelationLinkInTFS(String solutionId, Item actionItem, AlmAccount almAccount, HashMap<String, Object> fields, Item targetItem, ItemLink itemLink) {
        try {
            TFSResponse response = this.tfsUtils.updateItemInTFS(actionItem.getTfsId(), fields, almAccount);
            if (response.getStatusCode() == 200 || response.getStatusCode() == 201) {
                ItemJiraDependency tfsDependency = new ItemJiraDependency();
                if (PropertyValidator.isValid((Collection)actionItem.getSessionBoards())) {
                    tfsDependency.setSessionBoardId(((SessionBoard)actionItem.getSessionBoards().get(0)).getId());
                }
                String jiraDepedencyId = actionItem.getTfsId() + "-" + targetItem.getTfsId();
                tfsDependency.setAlmId(almAccount.getId());
                tfsDependency.setSolutionId(solutionId);
                tfsDependency.setIsTFS(Boolean.valueOf(true));
                tfsDependency.setSourceItemId(actionItem.getId());
                tfsDependency.setTargetItemId(targetItem.getId());
                String sourceStatusTitle = null;
                if (PropertyValidator.isValid((Object)actionItem.getStatus())) {
                    sourceStatusTitle = actionItem.getStatus().getTitle();
                }
                String targetStatusTitle = null;
                if (PropertyValidator.isValid((Object)targetItem.getStatus())) {
                    targetStatusTitle = targetItem.getStatus().getTitle();
                }
                TFSIssue tfsSourceIssue = new TFSIssue(actionItem.getTfsId(), actionItem.getTitle(), sourceStatusTitle, actionItem.getTfsURL(), actionItem.getTfsApiURL());
                TFSIssue tfsTargetIssue = new TFSIssue(targetItem.getTfsId(), targetItem.getTitle(), targetStatusTitle, targetItem.getTfsURL(), targetItem.getTfsApiURL());
                tfsDependency.setSourceTFSItem(tfsSourceIssue);
                tfsDependency.setTargetTFSItem(tfsTargetIssue);
                tfsDependency.setTfsLinkType(itemLink.getType());
                tfsDependency.setJiraDependencyId(jiraDepedencyId);
                tfsDependency = (ItemJiraDependency)this.itemJiraDependencyRepository.save((Object)tfsDependency);
                if (!PropertyValidator.isValid((Collection)actionItem.getJiraDependencies())) {
                    actionItem.setJiraDependencies(new ArrayList());
                }
                actionItem.getJiraDependencies().add(tfsDependency);
                Item updateItem = (Item)this.itemRepository.save((Object)actionItem);
                itemLink.setSyncTfs(Boolean.valueOf(true));
                itemLink.setAlmLinkId(jiraDepedencyId);
                this.itemLinkRepository.save((Object)itemLink);
                Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                JSONObject pushJson = new JSONObject();
                HashMap<String, Object> pushData = new HashMap<String, Object>();
                pushData.put("item", updateItem);
                pushData.put("link", itemLink);
                String itemStr = gsonExclusive.toJson(pushData);
                pushJson.put("data", (Object)itemStr);
                pushJson.put("type", (Object)"Links");
                pushJson.put("metaMap", (Object)("{\"event\":\"DepedencyUpdateIdTFS\", \"boardId\":\"" + solutionId + "\"}"));
                PushSender.sendMsg((String)pushJson.toString());
                ItemJiraDependency reverseDependency = new ItemJiraDependency();
                if (PropertyValidator.isValid((Collection)targetItem.getSessionBoards())) {
                    reverseDependency.setSessionBoardId(((SessionBoard)targetItem.getSessionBoards().get(0)).getId());
                }
                reverseDependency.setIsTFS(Boolean.valueOf(true));
                reverseDependency.setAlmId(almAccount.getId());
                reverseDependency.setSolutionId(solutionId);
                reverseDependency.setSourceItemId(targetItem.getId());
                reverseDependency.setTargetItemId(actionItem.getId());
                reverseDependency.setSourceTFSItem(tfsTargetIssue);
                reverseDependency.setTargetTFSItem(tfsSourceIssue);
                reverseDependency.setJiraDependencyId(jiraDepedencyId);
                String linkType = itemLink.getType();
                String[] parts = linkType.split("-");
                if (PropertyValidator.isValid((String[])parts) && parts.length == 2) {
                    String _linkType = parts[0] + "-";
                    if (parts[1].equals("Forward")) {
                        _linkType = _linkType + "Reverse";
                    } else if (parts[1].equals("Reverse")) {
                        _linkType = _linkType + "Forward";
                    }
                    reverseDependency.setTfsLinkType(_linkType);
                } else {
                    reverseDependency.setTfsLinkType(linkType);
                }
                reverseDependency = (ItemJiraDependency)this.itemJiraDependencyRepository.save((Object)reverseDependency);
                if (!PropertyValidator.isValid((Collection)targetItem.getJiraDependencies())) {
                    targetItem.setJiraDependencies(new ArrayList());
                }
                targetItem.getJiraDependencies().add(reverseDependency);
                Item updateTargetItem = (Item)this.itemRepository.save((Object)targetItem);
                pushJson = new JSONObject();
                try {
                    pushJson.put("isSystem", true);
                    pushJson.put("type", (Object)"Links");
                    gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                    pushData = new HashMap();
                    pushData.put("item", actionItem);
                    pushData.put("link", tfsDependency);
                    pushData.put("itemLink", itemLink);
                    pushData.put("reverseItem", updateTargetItem);
                    pushData.put("reverseLink", reverseDependency);
                    itemStr = gsonExclusive.toJson(pushData);
                    pushJson.put("data", (Object)itemStr);
                    pushJson.put("metaMap", (Object)("{\"event\":\"CreateTFSDependency\", \"boardId\":\"" + solutionId + "\"}"));
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ViztrendJiraException vje) {
            Item freshItem = this.itemRepository.findById(actionItem.getId());
            freshItem.setMetaMap(actionItem.getMetaMap());
            LOGGER.warn("Failed to save TFS issue.");
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            freshItem.setErrorInAlmSync(Boolean.valueOf(true));
            freshItem.setAlmErrorMessage(vje.getMessage());
            this.itemRepository.save((Object)freshItem);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            LOGGER.error("Updating TFS item :: FAILED.. error message saved in item.", (Throwable)vje);
            this.almErrorRepository.save((Object)AlmErrorUtils.buildAlmErrorObj((Item)freshItem, (String)((SessionBoard)freshItem.getSessionBoards().get(0)).getId(), (User)loggedInUser, (ViztrendJiraException)vje, (Boolean)false));
            PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)freshItem, (String)((SessionBoard)freshItem.getSessionBoards().get(0)).getId(), (String)"AlmError", null, null, null, null, null, (Gson)gsonExclusive, (String)vje.getMessage()));
        }
        return null;
    }

    public List<EpicFeature> changeEpic(HashMap<String, Object> payload) throws Exception {
        try {
            LinkedHashMap linkMap;
            String id = (String)payload.get("itemId");
            String parentId = (String)payload.get("parentId");
            String parentKey = (String)payload.get("parentKey");
            String newParentKey = (String)payload.get("newParentKey");
            String newParentKendisId = (String)payload.get("newParentKendisId");
            String almAccountId = (String)payload.get("almAccountId");
            String newParentTFSUrl = (String)payload.get("newParentTFSUrl");
            String solutionBoardId = (String)payload.get("solutionBoardId");
            JiraIssueLinkType jiraLink = null;
            Object tfsLink = null;
            String tfsLinkReferenceName = null;
            Item item = this.itemRepository.findById(id);
            boolean isJira = false;
            ArrayList<String> keys = new ArrayList<String>();
            AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
            ObjectMapper map = new ObjectMapper();
            if (item.getTfsId() == null) {
                isJira = true;
                keys.add(item.getJiraKey());
                linkMap = (LinkedHashMap)payload.get("linkType");
                jiraLink = new JiraIssueLinkType();
                jiraLink.setJiraId((String)linkMap.get("id"));
                jiraLink.setDirection((String)linkMap.get("direction"));
                jiraLink.setName((String)linkMap.get("name"));
                jiraLink.setAlmAccountId((String)linkMap.get("almAccountId"));
            } else {
                keys.add(item.getTfsId());
                linkMap = (LinkedHashMap)payload.get("linkType");
                tfsLinkReferenceName = (String)linkMap.get("referenceName");
            }
            if (isJira && jiraLink != null) {
                HashMap<String, String> updateJson;
                if ("+1".equals(jiraLink.getJiraId()) || "parent".equals(jiraLink.getJiraId())) {
                    updateJson = new HashMap<String, String>();
                    updateJson = new HashMap();
                    updateJson.put(almAccount.getJiraEpicLinkLabel(), (String)payload.get("newParentKey"));
                    updateJson.put("almAccount", (String)almAccount);
                    updateJson.put("AlmAccountId", almAccount.getId());
                    updateJson.put("projectKey", (String)payload.get("newParentProjectKey"));
                    updateJson.put("issuetype", item.getJiraIssueTypeId());
                    this.exportUtil.updateIssueInJira(item.getJiraId(), almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), updateJson, null, false);
                } else if (PropertyValidator.isValid((Object)jiraLink.getJiraId()) && jiraLink.getJiraId().contains("customfield")) {
                    updateJson = new HashMap();
                    updateJson = new HashMap();
                    updateJson.put(jiraLink.getJiraId(), (String)payload.get("newParentKey"));
                    updateJson.put("almAccount", (String)almAccount);
                    updateJson.put("AlmAccountId", almAccount.getId());
                    updateJson.put("projectKey", (String)payload.get("newParentProjectKey"));
                    updateJson.put("issuetype", item.getJiraIssueTypeId());
                    this.exportUtil.updateIssueInJira(item.getJiraId(), almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), updateJson, null, false);
                } else {
                    this.deleteExistingLink(item.getJiraId(), parentId, null, almAccount);
                    if ("IN".equals(jiraLink.getDirection())) {
                        this.exportUtil.createJiraIssueLink(item.getJiraId(), (String)payload.get("newParentId"), jiraLink.getId(), almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                    } else {
                        this.exportUtil.createJiraIssueLink((String)payload.get("newParentId"), item.getJiraId(), jiraLink.getId(), almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                    }
                }
            } else if (tfsLinkReferenceName != null) {
                if (PropertyValidator.isValid((Object)tfsLinkReferenceName) && tfsLinkReferenceName.endsWith("-Forward")) {
                    tfsLinkReferenceName = tfsLinkReferenceName.replace("-Forward", "-Reverse");
                } else if (PropertyValidator.isValid((Object)tfsLinkReferenceName) && tfsLinkReferenceName.endsWith("-Reverse")) {
                    tfsLinkReferenceName = tfsLinkReferenceName.replace("-Reverse", "-Forward");
                }
                HashMap<String, Object> fields = new HashMap<String, Object>();
                JSONObject relationObject = new JSONObject();
                try {
                    relationObject.put("rel", (Object)tfsLinkReferenceName);
                    relationObject.put("url", (Object)newParentTFSUrl);
                    fields.put("relation", relationObject);
                }
                catch (JSONException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                if (PropertyValidator.isValid((Object)parentKey)) {
                    this.tfSservice.removeRelationInTFS(item.getTfsId(), parentKey, almAccount);
                }
                this.tfsUtils.updateItemInTFS(item.getTfsId(), fields, almAccount);
            }
            List<EpicFeature> epicFeatures = new ArrayList();
            if (PropertyValidator.isValid((Object)parentKey)) {
                epicFeatures = this.epicFeaturesRepository.findByEpicKeyAndFeatureKeyInAndSolutionBoardId(parentKey, keys, solutionBoardId);
                if (PropertyValidator.isValid(epicFeatures)) {
                    for (EpicFeature epicFeature : epicFeatures) {
                        epicFeature.setEpicKey(newParentKey);
                        epicFeature.setEpicId(newParentKendisId);
                    }
                    epicFeatures = this.epicFeaturesRepository.save(epicFeatures);
                }
            } else {
                EpicFeature epicFeature = new EpicFeature();
                epicFeature.setEpicKey(newParentKey);
                if (item.getTfsId() == null) {
                    epicFeature.setFeatureKey(item.getJiraKey());
                } else {
                    epicFeature.setFeatureKey(item.getTfsId());
                }
                epicFeature.setEpicId(newParentKendisId);
                epicFeature.setSolutionBoardId(solutionBoardId);
                epicFeature.setSessionId(((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
                epicFeatures.add((EpicFeature)this.epicFeaturesRepository.save((Object)epicFeature));
            }
            return epicFeatures;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    public List<EpicFeature> removeEpic(HashMap<String, Object> payload) {
        try {
            ArrayList<EpicFeature> epicFeatures = new ArrayList();
            User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
            String id = (String)payload.get("itemId");
            String epicId = (String)payload.get("epicId");
            String parentKey = (String)payload.get("parentKey");
            String almAccountId = (String)payload.get("almAccountId");
            String solutionBoardId = (String)payload.get("solutionBoardId");
            AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
            Item item = this.itemRepository.findById(id);
            Item parent = this.itemRepository.findById(epicId);
            ArrayList<String> keys = new ArrayList<String>();
            if (item.getTfsId() == null) {
                String filters = (String)payload.get("jiraFilters");
                Gson g = new Gson();
                List jiraFilters = (List)g.fromJson(filters, new /* Unavailable Anonymous Inner Class!! */.getType());
                keys.add(item.getJiraKey());
                JiraIssue2 jiraIssue = this.almService.retrieveJiraIssue(item.getJiraId(), almAccount);
                this.planService.removeLinkInJira(item, parent, jiraIssue, null, jiraFilters, almAccount, almAccount.getUsername(), almAccount.getPassword(), loggedInUser);
            } else {
                keys.add(item.getTfsId());
            }
            epicFeatures = this.epicFeaturesRepository.findByEpicKeyAndFeatureKeyInAndSolutionBoardId(parentKey, keys, solutionBoardId);
            if (PropertyValidator.isValid(epicFeatures)) {
                this.epicFeaturesRepository.delete(epicFeatures);
            }
            return epicFeatures;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    public List<Item> fetchChild(Collection<String> keys, SolutionBoard solutionBoard, boolean setParent) {
        List epicFeatures = this.epicFeaturesRepository.findByEpicKeyInAndSolutionBoardId(keys, solutionBoard.getId());
        HashMap<String, String> childKeys = new HashMap<String, String>();
        for (EpicFeature ef : epicFeatures) {
            childKeys.put(ef.getFeatureKey(), ef.getEpicKey());
        }
        ArrayList<ObjectId> activeSessionBoardIds = new ArrayList<ObjectId>();
        if (PropertyValidator.isValid((Collection)solutionBoard.getPiSessionBoards())) {
            List boards = solutionBoard.getPiSessionBoards();
            for (SessionBoard board : boards) {
                activeSessionBoardIds.add(new ObjectId(board.getId()));
            }
        } else {
            List sessions = this.sessionRepository.findByIdIn((List)solutionBoard.getPiSessions());
            for (Session session : sessions) {
                activeSessionBoardIds.add(new ObjectId(session.getActiveSessionBoard()));
            }
        }
        List child = this.customRepository.getMongoTemplate().find(KendisUtils.getChildQuery((String)solutionBoard.getId(), activeSessionBoardIds, childKeys.keySet()), Item.class);
        if (setParent) {
            Iterator iterator = child.iterator();
            while (iterator.hasNext()) {
                Item item;
                item.setParentKey((String)childKeys.get((item = (Item)iterator.next()).getTfsId() == null ? item.getJiraKey() : item.getTfsId()));
            }
        }
        return child;
    }

    private void addIssueLinkInJira(String solutionId, ItemLink updateLink, Item sourceItem, Item targetItem, String linkType, AlmAccount almAccount, List<String> jiraLinkTypes, String syncId) {
        try {
            String sourceId = sourceItem.getJiraId();
            ArrayList<String> targetJiraIds = new ArrayList<String>();
            targetJiraIds.add(targetItem.getJiraId());
            String[] typeArray = linkType.split("-");
            String outwardIssue = "";
            String inwardIssue = "";
            String type = "";
            if (PropertyValidator.isValid((String[])typeArray) && typeArray.length < 2) {
                inwardIssue = sourceId;
            } else if (PropertyValidator.isValid((Object)typeArray[1]) && "OUT".equals(typeArray[1])) {
                inwardIssue = sourceId;
            } else {
                outwardIssue = sourceId;
            }
            type = typeArray[0];
            for (String targetJiraId : targetJiraIds) {
                if (PropertyValidator.isValid((Object)outwardIssue)) {
                    inwardIssue = targetJiraId;
                } else {
                    outwardIssue = targetJiraId;
                }
                if (!PropertyValidator.isValid((Object)sourceId) || !PropertyValidator.isValid((Object)targetJiraId) || !PropertyValidator.isValid((Object)type)) continue;
                this.planService.createIssueLinkInJira2(inwardIssue, outwardIssue, type, almAccount.getId(), syncId);
            }
            targetJiraIds.add(sourceId);
            SessionBoard sessionBoard = null;
            ArrayList<Item> kendisItems = new ArrayList<Item>();
            kendisItems.add(sourceItem);
            kendisItems.add(targetItem);
            List _jiraLinkTypes = null;
            if (PropertyValidator.isValid((Collection)sourceItem.getSessionBoards())) {
                sessionBoard = (SessionBoard)sourceItem.getSessionBoards().get(0);
                Session session = this.sessionRepository.findById(sessionBoard.getSession().getId());
                _jiraLinkTypes = session.getJiraLinkTypes();
            } else {
                _jiraLinkTypes = jiraLinkTypes;
            }
            List items = this.almSyncService.retrieveAndSaveJiraDependenciesForSolutionBoard(kendisItems, almAccount, _jiraLinkTypes, targetJiraIds, sessionBoard, syncId, "ADD", solutionId);
            if (PropertyValidator.isValid((Collection)items)) {
                for (Item item : items) {
                    if (!item.getId().equals(sourceItem.getId()) || !PropertyValidator.isValid((Collection)item.getJiraDependencies())) continue;
                    for (ItemJiraDependency jD : item.getJiraDependencies()) {
                        if (!PropertyValidator.isValid((Object)jD) || !PropertyValidator.isValid((Object)jD.getSourceItemId()) || !PropertyValidator.isValid((Object)jD.getTargetItemId()) || (!jD.getSourceItemId().equals(updateLink.getSourceItemId()) || !jD.getTargetItemId().equals(updateLink.getTargetItemId())) && (!jD.getTargetItemId().equals(updateLink.getSourceItemId()) || !jD.getSourceItemId().equals(updateLink.getTargetItemId()))) continue;
                        updateLink.setAlmLinkId(jD.getJiraDependencyId());
                        break;
                    }
                    this.customRepository.updateItemLinkOnAlmLinking(updateLink, "Jira");
                }
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                String itemLink = ow.writeValueAsString((Object)updateLink);
                String itemsString = ow.writeValueAsString((Object)items);
                Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                JSONObject pushJson = new JSONObject();
                HashMap<String, String> pushData = new HashMap<String, String>();
                pushData.put("items", itemsString);
                pushData.put("link", itemLink);
                String itemStr = gsonExclusive.toJson(pushData);
                pushJson.put("data", (Object)itemStr);
                pushJson.put("type", (Object)"Links");
                pushJson.put("metaMap", (Object)("{\"event\":\"DepedencyUpdateIdJira\", \"boardId\":\"" + solutionId + "\"}"));
                PushSender.sendMsg((String)pushJson.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteExistingLink(String jiraId, String linkedJiraId, JiraIssue jiraIssue, AlmAccount almAccount) {
        block11: {
            if (!PropertyValidator.isValid((Object)linkedJiraId)) {
                return;
            }
            if (!PropertyValidator.isValid((Object)jiraId)) {
                throw new ViztrendJiraException(Integer.valueOf(500), "");
            }
            if (jiraIssue == null) {
                try {
                    jiraIssue = this.almService.retrieveJiraIssueById(jiraId, almAccount);
                }
                catch (ViztrendJiraException e1) {
                    LOGGER.error("Failed to fetch jira Issue. " + e1.getAlmError(), (Throwable)e1);
                    if (500 != e1.getCode()) break block11;
                    LOGGER.error("Retrying ...");
                    jiraIssue = this.almService.retrieveJiraIssueById(jiraId, almAccount);
                }
            }
        }
        if (PropertyValidator.isValid((Collection)jiraIssue.getFields().getIssuelinks())) {
            JiraIssueLink eLink = null;
            Iterator existingLinkItr = jiraIssue.getFields().getIssuelinks().iterator();
            try {
                while (existingLinkItr.hasNext()) {
                    eLink = (JiraIssueLink)existingLinkItr.next();
                    if (PropertyValidator.isValid((Object)eLink.getOutwardIssue()) && eLink.getOutwardIssue().getJiraId().equals(linkedJiraId)) {
                        eLink.getType().setDirection("OUT");
                        this.exportUtil.deleteJiraIssueLink(eLink.getId(), almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                        existingLinkItr.remove();
                    } else {
                        if (!PropertyValidator.isValid((Object)eLink.getInwardIssue()) || !eLink.getInwardIssue().getJiraId().equals(linkedJiraId)) continue;
                        eLink.getType().setDirection("IN");
                        this.exportUtil.deleteJiraIssueLink(eLink.getId(), almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                        existingLinkItr.remove();
                    }
                    break;
                }
            }
            catch (ViztrendJiraException e) {
                LOGGER.error("Deleting Link ALM:: SolutionServiceImpl.deleteExistingLink().", (Throwable)e);
                throw e;
            }
        }
    }

    public Map<String, Object> searchSolutionBoards(String searchQuery, String tenant) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Query query = new Query();
            query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
            String options = "i";
            Criteria criteria1 = Criteria.where((String)"title").regex(searchQuery, options);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)criteria1);
            List solutionBoards = this.mongoTemplate.find(query, SolutionBoard.class);
            responseJson.put("success", true);
            responseJson.put("solutionBoards", solutionBoards);
        }
        catch (Exception e) {
            LOGGER.error("Error searching solution boards: ", (Throwable)e);
            responseJson.put("success", false);
            responseJson.put("error", "Failed to search solution boards");
        }
        return responseJson;
    }

    public List<Session> getSolutionBoardSessions(String solutionId) throws Exception {
        ArrayList<Session> sessions = new ArrayList();
        SolutionBoard solutionBoard = this.solutionBoardRepository.findById(solutionId);
        sessions = this.sessionRepository.findByIdIn((List)solutionBoard.getPiSessions());
        return sessions;
    }

    static /* synthetic */ Item access$000(SolutionServiceImpl x0, String x1, Item x2, AlmAccount x3, HashMap x4, Item x5, ItemLink x6) {
        return x0.addRelationLinkInTFS(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ void access$100(SolutionServiceImpl x0, String x1, ItemLink x2, Item x3, Item x4, String x5, AlmAccount x6, List x7, String x8) {
        x0.addIssueLinkInJira(x1, x2, x3, x4, x5, x6, x7, x8);
    }

    static /* synthetic */ TFSservice access$200(SolutionServiceImpl x0) {
        return x0.tfSservice;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ ALMSyncService access$400(SolutionServiceImpl x0) {
        return x0.almSyncService;
    }
}

