/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.FieldMapping;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ScoreCard;
import com.viztrend.safe.persistence.entity.ScoreParam;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ScoreCardRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.ScoreCardService;
import com.viztrend.safe.service.ScoreCardServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScoreCardServiceImpl
implements ScoreCardService {
    @Autowired
    private ScoreCardRepository scoreCardRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private PlanService planService;
    private HashMap<String, String> wsjfIdToParam = new HashMap();

    public ScoreCardServiceImpl() {
        this.wsjfIdToParam.put(WSJFField.UBV.getValue(), "param1");
        this.wsjfIdToParam.put(WSJFField.TC.getValue(), "param2");
        this.wsjfIdToParam.put(WSJFField.RROE.getValue(), "param3");
        this.wsjfIdToParam.put(WSJFField.CC.getValue(), "param4");
        this.wsjfIdToParam.put(WSJFField.SCORE.getValue(), WSJFField.SCORE.getValue());
    }

    public ScoreCard findById(String id) throws Exception {
        return this.scoreCardRepository.findById(id);
    }

    public void saveMappedFieldsToCustomFieldsLocally(Item item, ScoreCard scoreCard, boolean isJira) throws Exception {
        Map params = item.getScoreParams();
        for (FieldMapping fieldMapping : scoreCard.getMappings()) {
            String fieldId = fieldMapping.getMappedToFieldId();
            String type = fieldMapping.getType();
            if (fieldId == null || fieldId.isEmpty()) continue;
            String key = (String)this.wsjfIdToParam.get(fieldMapping.getId());
            String value = null;
            if (params.get(key) != null) {
                if (!((String)params.get(key)).isEmpty()) {
                    if (type != null && type.equals("integer")) {
                        double valueAsDouble = Double.parseDouble((String)params.get(key));
                        int valueAsInt = (int)Math.round(valueAsDouble);
                        value = String.valueOf(valueAsInt);
                    } else {
                        value = (String)params.get(key);
                    }
                }
            } else if (key.equals(WSJFField.SCORE.getValue()) && item.getScore() != null && item.getScore() != 0.0) {
                if (type != null && type.equals("integer")) {
                    int intValue = (int)Math.round(item.getScore());
                    value = Integer.toString(intValue);
                } else {
                    value = Double.toString(item.getScore());
                }
            }
            if (value == null || value.isEmpty()) continue;
            if (isJira) {
                boolean found = false;
                for (ItemJiraFieldMap itemJiraFieldMap : item.getJiraFieldMap()) {
                    if (!itemJiraFieldMap.getKey().equals(fieldId)) continue;
                    itemJiraFieldMap.setValue(value);
                    found = true;
                }
                if (!found) {
                    item.getJiraFieldMap().add(new ItemJiraFieldMap(fieldId, value, "Double"));
                }
                item.getJiraFieldByKey().put(fieldId, value);
                continue;
            }
            if (item.getTfsFieldByKey() == null) {
                item.setTfsFieldByKey(new HashMap());
            }
            item.getTfsFieldByKey().put(fieldId, value);
        }
        this.itemRepository.save((Object)item);
    }

    public void updateScorecardFieldsAccordingToMappedFields(Session session, Item item, Map<String, Object> itemMap) throws Exception {
        if (session != null && session.getScoreCard() != null && session.getScoreCard().getMappings() != null && session.getWsjfWithMappingEnabled().booleanValue() && itemMap != null) {
            HashMap params = session.getScoreCard().getParams();
            session.getScoreCard().getMappings().forEach(fieldMapping -> {
                String value;
                String key = fieldMapping.getMappedToFieldId();
                if (key != null && itemMap.containsKey(key) && itemMap.get(key) != null && !(value = itemMap.get(key).toString()).isEmpty()) {
                    String mappingIdToParamKey = (String)this.wsjfIdToParam.get(fieldMapping.getId());
                    double doubleValue = Double.parseDouble(value);
                    if (mappingIdToParamKey.equals(WSJFField.SCORE.getValue())) {
                        item.setScore(Double.valueOf(doubleValue));
                    } else {
                        int max = (Integer)((ScoreParam)params.get(mappingIdToParamKey)).getMax();
                        int min = (Integer)((ScoreParam)params.get(mappingIdToParamKey)).getMin();
                        if (item.getScoreParams() == null) {
                            HashMap defaultParams = new HashMap();
                            defaultParams.put(this.wsjfIdToParam.get(WSJFField.access$000((WSJFField)WSJFField.UBV)), "");
                            defaultParams.put(this.wsjfIdToParam.get(WSJFField.access$000((WSJFField)WSJFField.TC)), "");
                            defaultParams.put(this.wsjfIdToParam.get(WSJFField.access$000((WSJFField)WSJFField.CC)), "");
                            defaultParams.put(this.wsjfIdToParam.get(WSJFField.access$000((WSJFField)WSJFField.RROE)), "");
                            item.setScoreParams(defaultParams);
                        }
                        if (doubleValue > (double)max) {
                            item.getScoreParams().put(mappingIdToParamKey, String.valueOf(max));
                        } else if (doubleValue < (double)min) {
                            item.getScoreParams().put(mappingIdToParamKey, String.valueOf(min));
                        } else if (fieldMapping.getId().equals(WSJFField.CC.getValue())) {
                            item.getScoreParams().put(mappingIdToParamKey, String.valueOf(doubleValue));
                        } else {
                            item.getScoreParams().put(mappingIdToParamKey, String.valueOf((int)Math.round(doubleValue)));
                        }
                    }
                }
            });
        }
    }

    public List<ItemJiraFieldMap> getScoreCardOnlyItemJiraFieldMap(List<FieldMapping> mappings, Item item) throws Exception {
        FieldMapping fm2;
        Optional<FieldMapping> m;
        ArrayList<ItemJiraFieldMap> lsPairs = new ArrayList<ItemJiraFieldMap>();
        item.getJiraFieldByKey().forEach((k, v) -> {
            Optional<FieldMapping> m;
            if (v != null && (m = mappings.stream().filter(fm -> fm.getMappedToFieldId() != null && fm.getMappedToFieldId().equals(k)).findAny()).isPresent()) {
                lsPairs.add(new ItemJiraFieldMap(k, v.toString(), "Double"));
            }
        });
        if (item.getScore() != null && (m = mappings.stream().filter(fm -> fm.getMappedToFieldId() != null && fm.getId().equals(WSJFField.SCORE.getValue())).findAny()).isPresent() && (fm2 = m.get()).getMappedToFieldId() != null && item.getScore() != 0.0) {
            lsPairs.add(new ItemJiraFieldMap(fm2.getMappedToFieldId(), item.getScore().toString(), "Double"));
        }
        return lsPairs;
    }

    public void putScoreCardFieldsInItemFromJson(List<FieldMapping> mappings, Item item, JSONObject jsonItem) throws Exception {
        mappings.forEach(fm -> {
            if (jsonItem.keySet().contains(fm.getMappedToFieldId()) && jsonItem.get(fm.getMappedToFieldId()) != null) {
                item.getTfsFieldByKey().put(fm.getMappedToFieldId(), jsonItem.get(fm.getMappedToFieldId()));
            }
        });
    }

    public Map<String, Object> getScoreCardOnlyItemTfsFieldMap(List<FieldMapping> mappings, Item item) throws Exception {
        HashMap<String, Object> scoreCardOnlyTfsFields = new HashMap<String, Object>();
        item.getTfsFieldByKey().forEach((k, v) -> {
            if (v != null) {
                FieldMapping fm2;
                Optional<FieldMapping> m = mappings.stream().filter(fm -> fm.getMappedToFieldId() != null && fm.getMappedToFieldId().equals(k)).findAny();
                if (m.isPresent()) {
                    scoreCardOnlyTfsFields.put((String)k, v);
                }
                if ((m = mappings.stream().filter(fm -> fm.getMappedToFieldId() != null && fm.getId().equals(WSJFField.SCORE.getValue()) && fm.getMappedToFieldId().equals(k)).findAny()).isPresent() && (fm2 = m.get()).getMappedToFieldId() != null && item.getScore() != null && item.getScore() != 0.0) {
                    String value = "";
                    if (fm2.getType() != null && fm2.getType().equals("integer")) {
                        double valueAsDouble = item.getScore();
                        int valueAsInt = (int)Math.round(valueAsDouble);
                        value = String.valueOf(valueAsInt);
                    } else {
                        value = Double.toString(item.getScore());
                    }
                    scoreCardOnlyTfsFields.put(fm2.getMappedToFieldId(), value);
                }
            }
        });
        return scoreCardOnlyTfsFields;
    }
}

