/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.Gson;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskMatrix;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.RiskImpactRepository;
import com.viztrend.safe.persistence.repository.RiskMatrixRepository;
import com.viztrend.safe.persistence.repository.RiskProbabilityRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncServiceImpl;
import com.viztrend.safe.service.RiskRegisterService;
import com.viztrend.safe.service.RiskRegisterServiceImpl;
import com.viztrend.safe.service.TFSRiskService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="RiskRegisterService")
public class RiskRegisterServiceImpl
implements RiskRegisterService {
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private RiskProbabilityRepository riskProbabilityRepository;
    @Autowired
    private RiskImpactRepository riskImpactRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private RiskMatrixRepository riskMatrixRepository;
    @Autowired
    private CustomRepositoryImpl customRepositoryImpl;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private ConversationRepository conversationRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(ALMSyncServiceImpl.class);
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private TFSRiskService tfsRiskService;

    public Map<String, Object> getLinkedWithOrgRegisters(String id, Boolean archive) throws Exception {
        WorkSpace workSpace = this.workSpaceRepository.findByIdOrKey(id, id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<RiskRegister> registers = new ArrayList<RiskRegister>();
        if (PropertyValidator.isValid((Object)workSpace) && PropertyValidator.isValid((Collection)workSpace.getRiskRegisters())) {
            User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
            for (RiskRegister register : workSpace.getRiskRegisters()) {
                if (PropertyValidator.isValid((Collection)register.getFavoriteOfUsers())) {
                    int index = register.getFavoriteOfUsers().indexOf(loggedInUser.getId());
                    if (index > -1) {
                        register.setFavoriteOfCurrentUser(true);
                    } else {
                        register.setFavoriteOfCurrentUser(false);
                    }
                } else {
                    register.setFavoriteOfCurrentUser(false);
                }
                if ((!archive.booleanValue() || !register.isArchive()) && (archive.booleanValue() || register.isArchive())) continue;
                registers.add(register);
            }
            result.put("registers", registers);
        }
        return result;
    }

    public RiskRegister saveRiskRegister(RiskRegister riskRegister) throws Exception {
        User owner;
        RiskRegister updatedRiskRegister = null;
        if (riskRegister.getId() != null) {
            RiskRegister savedRiskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegister.getId()));
            Integer lastSavedRiskNumber = savedRiskRegister.getLastRiskIndex();
            riskRegister.setLastRiskIndex(lastSavedRiskNumber);
            riskRegister.setWatcherList(savedRiskRegister.getWatcherList());
            riskRegister.setProbabilityList(savedRiskRegister.getProbabilityList());
            riskRegister.setImpactList(savedRiskRegister.getImpactList());
        }
        if (riskRegister.getId() == null) {
            riskRegister.setProbabilityList(this.riskProbabilityRepository.findAll());
            riskRegister.setImpactList(this.riskImpactRepository.findAll());
        }
        updatedRiskRegister = (RiskRegister)this.riskRegisterRepository.save((Object)riskRegister);
        RiskMatrix riskMatrix = (RiskMatrix)this.riskMatrixRepository.findOne((Serializable)((Object)riskRegister.getRiskMatrix().getId()));
        updatedRiskRegister.setRiskMatrix(riskMatrix);
        updatedRiskRegister.setStatus((Status)this.statusRepository.findOne((Serializable)((Object)riskRegister.getStatus().getId())));
        String userName = updatedRiskRegister.getCreatedBy();
        if (userName == null) {
            userName = updatedRiskRegister.getUpdatedBy();
        }
        if ((owner = this.userRepository.findByUserName(userName)) != null) {
            updatedRiskRegister.setOwnerName(owner.getFullName());
        }
        return updatedRiskRegister;
    }

    public Map<String, Object> linkWithOrg(String id, RiskRegister riskRegister) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkSpace workSpace = this.workSpaceRepository.findByIdOrKey(id, id);
        if (PropertyValidator.isValid((Object)workSpace)) {
            if (!PropertyValidator.isValid((Collection)workSpace.getRiskRegisters())) {
                workSpace.setRiskRegisters(new ArrayList());
            }
            workSpace.getRiskRegisters().add(riskRegister);
            workSpace = (WorkSpace)this.workSpaceRepository.save((Object)workSpace);
            result.put("workSpace", workSpace);
        }
        return result;
    }

    public Map<String, Object> linkGlobalRegister(Map param) throws Exception {
        List ids = (List)param.get("ids");
        String registerId = (String)param.get("riskRegisterId");
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)registerId));
        String type = (String)param.get("type");
        List ObjectIds = ids.stream().map(id -> new ObjectId(id)).collect(Collectors.toList());
        if (type.equalsIgnoreCase("sol")) {
            this.customRepositoryImpl.updateRiskRegisterForSolutionBoards(ObjectIds, riskRegister);
        } else if (type.equalsIgnoreCase("org")) {
            this.customRepositoryImpl.updateRiskRegisterForCollections(ObjectIds, riskRegister);
        }
        return param;
    }

    public void saveBulkRisks(Map map) throws Exception {
        Map fieldsMap = (Map)map.get("fieldsMap");
        String requestId = (String)map.get("requestId");
        String sessionId = (String)map.get("sessionId");
        String riskRegisterId = (String)map.get("riskRegisterId");
        String solutionBoardId = (String)map.get("solutionBoardId");
        ArrayList riskIds = (ArrayList)map.get("ids");
        if (PropertyValidator.isValid((Object)sessionId)) {
            this.customRepositoryImpl.checkIfSessionLocked(sessionId, "Bulk save risk");
        } else if (PropertyValidator.isValid((Object)riskRegisterId)) {
            this.customRepositoryImpl.checkIfRiskRegisterLocked(riskRegisterId, "Bulk save risk", EnumKendis.RISK.getCode());
        } else if (PropertyValidator.isValid((Object)solutionBoardId)) {
            this.customRepositoryImpl.checkIfSolutionBoardLocked(solutionBoardId, "Bulk save risk", EnumKendis.RISK.getCode());
        }
        List risksToUpdate = new ArrayList();
        if (PropertyValidator.isValid((Collection)riskIds)) {
            risksToUpdate = this.riskRepository.findByIdIn((List)riskIds);
            this.updateRiskObjects(risksToUpdate, fieldsMap);
        }
        int chunkSize = 5;
        if (PropertyValidator.isValid(risksToUpdate)) {
            for (int i = 0; i < risksToUpdate.size(); i += chunkSize) {
                int end = Math.min(i + chunkSize, risksToUpdate.size());
                List chunk = risksToUpdate.subList(i, end);
                chunk = this.riskRepository.save(chunk);
                JSONObject pushJson = new JSONObject();
                pushJson.put("risks", (Collection)chunk);
                pushJson.put("updated", chunk.size());
                pushJson.put("metaMap", true);
                if (!PropertyValidator.isValid((Object)requestId)) continue;
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(false)));
            }
        }
        JSONObject pushJson = new JSONObject();
        pushJson.put("completed", true);
        pushJson.put("metaMap", true);
        if (PropertyValidator.isValid((Object)requestId)) {
            this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(true)));
        }
        if (PropertyValidator.isValid((Object)sessionId)) {
            this.customRepositoryImpl.removeSessionLock(sessionId);
        } else if (PropertyValidator.isValid((Object)riskRegisterId)) {
            this.customRepositoryImpl.removeRiskRegisterLock(riskRegisterId, EnumKendis.RISK.getCode());
        } else if (PropertyValidator.isValid((Object)solutionBoardId)) {
            this.customRepositoryImpl.removeSolutionBoardLock(solutionBoardId, EnumKendis.RISK.getCode());
        }
    }

    public void updateRiskObjects(List<Risk> risks, Map fieldsMap) throws Exception {
        for (Risk risk : risks) {
            SimpleDateFormat sdf;
            if (fieldsMap.containsKey("status")) {
                Map statusMap = (Map)fieldsMap.get("status");
                Status status = new Status((String)statusMap.get("id"));
                status.setCategory((String)statusMap.get("category"));
                status.setTitle((String)statusMap.get("title"));
                risk.setStatus(status);
            }
            if (fieldsMap.containsKey("responsible")) {
                Map respMap = (Map)fieldsMap.get("responsible");
                if (PropertyValidator.isValid((Object)respMap) && !respMap.isEmpty()) {
                    User resp = new User((String)respMap.get("id"));
                    risk.setResponsible(resp);
                } else {
                    risk.setResponsible(null);
                }
            }
            if (fieldsMap.containsKey("targetDate")) {
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                try {
                    Date due = sdf.parse((String)fieldsMap.get("targetDate"));
                    risk.setResolutionDate(due);
                }
                catch (ParseException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (fieldsMap.containsKey("raisedOn")) {
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                try {
                    Date raisedOn = sdf.parse((String)fieldsMap.get("raisedOn"));
                    risk.setRaisedDate(raisedOn);
                }
                catch (ParseException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (fieldsMap.containsKey("comment")) {
                String text = (String)fieldsMap.get("comment");
                Conversation conv = new Conversation();
                conv.setText(text);
                User convoUser = new User(UserContextUtil.getUserContext().getLoggedInUser().getId());
                conv.setUser(convoUser);
                conv.setRisk(risk);
                conv = (Conversation)this.conversationRepository.save((Object)conv);
                risk.setConversationCount(Integer.valueOf(risk.getConversationCount() + 1));
            }
            if (fieldsMap.containsKey("linkedSessions")) {
                ArrayList existingLinkedSessions = risk.getLinkedPiBoards();
                if (existingLinkedSessions == null) {
                    existingLinkedSessions = new ArrayList();
                    risk.setLinkedPiBoards(existingLinkedSessions);
                }
                this.mergeListsWithoutDuplicates(existingLinkedSessions, (List)fieldsMap.get("linkedSessions"));
            }
            if (fieldsMap.containsKey("linkedSolutionBoards")) {
                ArrayList existingLinkedSolutionBoards = risk.getLinkedSolutionBoards();
                if (existingLinkedSolutionBoards == null) {
                    existingLinkedSolutionBoards = new ArrayList();
                    risk.setLinkedSolutionBoards(existingLinkedSolutionBoards);
                }
                this.mergeListsWithoutDuplicates(existingLinkedSolutionBoards, (List)fieldsMap.get("linkedSolutionBoards"));
            }
            if (!fieldsMap.containsKey("linkedOrgCollections")) continue;
            ArrayList existingLinkedOrgCollections = risk.getLinkedOrgCollections();
            if (existingLinkedOrgCollections == null) {
                existingLinkedOrgCollections = new ArrayList();
                risk.setLinkedOrgCollections(existingLinkedOrgCollections);
            }
            this.mergeListsWithoutDuplicates(existingLinkedOrgCollections, (List)fieldsMap.get("linkedOrgCollections"));
        }
        ArrayList<Risk> tfsRisks = new ArrayList<Risk>();
        for (Risk risk : risks) {
            if (!PropertyValidator.isValid((Object)risk.getTfsAttributes()) || !PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsId())) continue;
            tfsRisks.add(risk);
        }
        if (PropertyValidator.isValid(tfsRisks)) {
            RiskRegister riskRegister = ((Risk)tfsRisks.get(0)).getRiskRegister();
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
    }

    private void mergeListsWithoutDuplicates(List<Map> existing, List<Map> newItems) {
        if (newItems != null) {
            for (Map newItem : newItems) {
                boolean exists = existing.stream().anyMatch(existingItem -> existingItem.get("id").equals(newItem.get("id")));
                if (exists) continue;
                existing.add(newItem);
            }
        }
    }

    public void saveInlineRisk(Map map) throws Exception {
        this.customRepositoryImpl.inlineSaveRisk(map);
        String riskId = (String)map.get("riskId");
        Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)riskId));
        if (PropertyValidator.isValid((Object)risk)) {
            2 T;
            String metaMap;
            Gson g;
            HashMap metaMapJSON;
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (PropertyValidator.isValid((Object)risk.getMetaMap()) && (metaMapJSON = (HashMap)(g = new Gson()).fromJson(metaMap = risk.getMetaMap(), (T = new /* Unavailable Anonymous Inner Class!! */).getType())).containsKey("requestId")) {
                String requestId = (String)metaMapJSON.get("requestId");
                parameters.put("requestId", requestId);
            }
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
    }

    public void updateRiskRegisterLastUpdatedOnSavingRisk(String riskRegisterId, Date str) {
        this.customRepositoryImpl.updateRiskRegisterLastUpdatedOnSavingRisk(riskRegisterId, str);
    }

    public Map<String, Object> updateRiskRegisterTitle(String riskRegisterId, String registerName) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (riskRegisterId == null || riskRegisterId.trim().isEmpty()) {
                result.put("success", false);
                result.put("message", "Risk Register ID cannot be empty");
                return result;
            }
            if (registerName == null || registerName.trim().isEmpty()) {
                result.put("success", false);
                result.put("message", "Register name cannot be empty");
                return result;
            }
            boolean updateSuccess = this.customRepositoryImpl.updateRiskRegisterTitle(riskRegisterId, registerName.trim());
            if (updateSuccess) {
                result.put("success", true);
                result.put("message", "Risk register title updated successfully");
                result.put("updatedName", registerName.trim());
            } else {
                result.put("success", false);
                result.put("message", "Risk Register not found or no changes were made");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in updateRiskRegisterTitle service method", (Throwable)e);
            result.put("success", false);
            result.put("message", "Database error: " + e.getMessage());
            throw e;
        }
        return result;
    }

    public Map getLinkedCollectionsAndSolutionBoards() {
        HashMap response = new HashMap();
        try {
            List collections;
            HashMap collectionsMap = new HashMap();
            HashMap solutionMap = new HashMap();
            List solutionBoards = this.customRepositoryImpl.fetchSolutionBoardWithLinkedRiskRegisters();
            if (PropertyValidator.isValid((Collection)solutionBoards)) {
                for (SolutionBoard solutionBoard : solutionBoards) {
                    if (!PropertyValidator.isValid((Collection)solutionBoard.getRiskRegisters())) continue;
                    for (RiskRegister riskRegister : solutionBoard.getRiskRegisters()) {
                        String riskRegisterId = riskRegister.getId();
                        HashMap<String, String> solutionInfo = new HashMap<String, String>();
                        solutionInfo.put("id", solutionBoard.getId());
                        solutionInfo.put("title", solutionBoard.getTitle());
                        solutionInfo.put("name", solutionBoard.getTitle());
                        if (!solutionMap.containsKey(riskRegisterId)) {
                            solutionMap.put(riskRegisterId, new ArrayList());
                        }
                        ((List)solutionMap.get(riskRegisterId)).add(solutionInfo);
                    }
                }
            }
            if (PropertyValidator.isValid((Collection)(collections = this.customRepositoryImpl.fetchCollectionListWithLinkedRiskRegisters()))) {
                collections.removeIf(obj -> obj.getType() == null);
                for (WorkSpace collection : collections) {
                    if (!PropertyValidator.isValid((Collection)collection.getRiskRegisters())) continue;
                    for (RiskRegister riskRegister : collection.getRiskRegisters()) {
                        String riskRegisterId = riskRegister.getId();
                        HashMap<String, String> collectionInfo = new HashMap<String, String>();
                        collectionInfo.put("id", collection.getId());
                        collectionInfo.put("title", collection.getTitle());
                        if (!collectionsMap.containsKey(riskRegisterId)) {
                            collectionsMap.put(riskRegisterId, new ArrayList());
                        }
                        ((List)collectionsMap.get(riskRegisterId)).add(collectionInfo);
                    }
                }
            }
            response.put("collections", collectionsMap);
            response.put("solution", solutionMap);
        }
        catch (Exception e) {
            LOGGER.error("Error in Fetching linked collection and sol boards", (Throwable)e);
        }
        return response;
    }

    static /* synthetic */ TFSRiskService access$000(RiskRegisterServiceImpl x0) {
        return x0.tfsRiskService;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

