/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WatcherRepository;
import com.viztrend.safe.service.APIServiceImpl;
import com.viztrend.safe.service.RiskAPIService;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="RiskAPIService")
@Transactional
public class RiskAPIServiceImpl
implements RiskAPIService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskAPIServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private APIServiceImpl apiServiceImpl;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private WatcherRepository watcherRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;

    private List<DBObject> getAllRiskRegister(int startAt, int pageLimit) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.fields().include("_id");
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("riskRegister").find(query.getQueryObject()).skip(startAt).limit(pageLimit);
        List listOfRiskRegister = dbCursorPrefix.toArray();
        return listOfRiskRegister;
    }

    private List<DBObject> getAllRiskByRiskRegisterIdWithLimit(String riskRegisterId, int startAt, int pageLimit) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegister.$id").is((Object)new ObjectId(riskRegisterId)));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("risk").find(query.getQueryObject()).skip(startAt).limit(pageLimit);
        List listOfRiskWithLinkedRiskRegister = dbCursorPrefix.toArray();
        return listOfRiskWithLinkedRiskRegister;
    }

    private List<DBObject> getRiskByRiskIdOrKey(String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("risk").find(query.getQueryObject());
        List listOfRiskWithLinkedRiskRegister = dbCursorPrefix.toArray();
        return listOfRiskWithLinkedRiskRegister;
    }

    private List<DBObject> getSessionLinkedWithRiskRegister(String riskRegisterId, int startAt, int pageLimit, boolean isLimitedData) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.fields().include("_id");
        query.fields().include("title");
        query.fields().include("prefix");
        query.fields().include("activeSessionBoard");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegister.$id").is((Object)new ObjectId(riskRegisterId)));
        DBCursor dbCursorPrefix = null;
        dbCursorPrefix = isLimitedData ? this.customRepositoryImpl.getMongoTemplate().getCollection("session").find(query.getQueryObject()).skip(startAt).limit(pageLimit) : this.customRepositoryImpl.getMongoTemplate().getCollection("session").find(query.getQueryObject()).skip(startAt).limit(pageLimit);
        List listOfSessionsLinkedToRiskRegister = dbCursorPrefix.toArray();
        return listOfSessionsLinkedToRiskRegister;
    }

    public HashMap<String, Object> getListOfRiskRegister(String fields, String expand, int startAt, int pageLimit) throws Exception {
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        List listOfRiskRegister = this.getAllRiskRegister(startAt, pageLimit);
        Map statusMapByIds = this.getAndBuildMapForStatus(listOfRiskRegister);
        List allRiskRegister = this.riskRegisterRepository.findAll();
        if (PropertyValidator.isValid((Collection)listOfRiskRegister)) {
            HashSet<LinkedHashMap> riskRegisterList = new HashSet<LinkedHashMap>();
            HashMap fieldsMap = this.apiServiceImpl.getfieldsMap(fields, expand);
            for (DBObject riskRegister : listOfRiskRegister) {
                LinkedHashMap riskRegisterData = this.getDataBySelectedFieldsForRiskRegister(riskRegister, fieldsMap, statusMapByIds);
                if (!PropertyValidator.isValid((Object)riskRegisterData)) continue;
                riskRegisterList.add(riskRegisterData);
            }
            responseJson.put("startAt", startAt);
            responseJson.put("pageLimit", pageLimit);
            responseJson.put("total", allRiskRegister.size());
            responseJson.put("data", riskRegisterList);
        } else {
            responseJson.put("startAt", startAt);
            responseJson.put("pageLimit", pageLimit);
            responseJson.put("total", allRiskRegister.size());
            responseJson.put("data", new ArrayList());
        }
        return responseJson;
    }

    private Map<String, Status> getAndBuildMapForStatus(List<DBObject> listOfRiskRegister) throws Exception {
        ArrayList<String> statusLinkToRiskRegister = new ArrayList<String>();
        for (DBObject riskRegister : listOfRiskRegister) {
            DBRef statusRef = (DBRef)riskRegister.get("status");
            if (!PropertyValidator.isValid((Object)statusRef)) continue;
            statusLinkToRiskRegister.add(String.valueOf(statusRef.getId()));
        }
        List allStatuses = this.statusRepository.findByIdIn(statusLinkToRiskRegister);
        HashMap<String, Status> statusMapByIds = new HashMap<String, Status>();
        for (Status status : allStatuses) {
            statusMapByIds.put(status.getId(), status);
        }
        return statusMapByIds;
    }

    private LinkedHashMap<String, Object> getDataBySelectedFieldsForRiskRegister(DBObject riskRegister, HashMap<String, String> fieldsMap, Map<String, Status> statusMapByIds) {
        LinkedHashMap<String, Object> linkedRiskData = new LinkedHashMap<String, Object>();
        try {
            DBRef statusRef;
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("key"))) {
                linkedRiskData.put("key", riskRegister.get("registerKey"));
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("title"))) {
                linkedRiskData.put("title", riskRegister.get("registerName"));
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("id"))) {
                linkedRiskData.put("id", String.valueOf(riskRegister.get("_id")));
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("createdBy"))) {
                linkedRiskData.put("createdBy", riskRegister.get("createdBy"));
            }
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("status"))) && PropertyValidator.isValid((Object)riskRegister.get("status")) && PropertyValidator.isValid((Object)(statusRef = (DBRef)riskRegister.get("status"))) && PropertyValidator.isValid((Object)statusRef.getId()) && PropertyValidator.isValid((Object)statusMapByIds.get(statusRef.getId().toString()))) {
                Status status = statusMapByIds.get(statusRef.getId().toString());
                HashMap<String, String> statusData = new HashMap<String, String>();
                statusData.put("status", status.getTitle());
                statusData.put("id", status.getId());
                linkedRiskData.put("status", statusData);
            }
            return linkedRiskData;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build objectice Data By fields by api key -> ", (Throwable)e);
            return linkedRiskData;
        }
    }

    public HashMap<String, Object> getListOfRiskByRiskRegister(String riskRegisterId, String fields, String expand, int startAt, int pageLimit) throws Exception {
        this.getRiskRegisterLinkedBoards(riskRegisterId, startAt, pageLimit);
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        List listOfLinkedRisks = this.getAllRiskByRiskRegisterIdWithLimit(riskRegisterId, startAt, pageLimit);
        List allRiskLinkToRiskRegister = this.riskRepository.findAllByRiskRegisterId(riskRegisterId);
        if (PropertyValidator.isValid((Collection)listOfLinkedRisks)) {
            HashSet riskList = new HashSet();
            HashMap fieldsMap = this.apiServiceImpl.getfieldsMap(fields, expand);
            this.RiskDataMapping(riskList, listOfLinkedRisks, fieldsMap);
            responseJson.put("startAt", startAt);
            responseJson.put("pageLimit", pageLimit);
            responseJson.put("total", allRiskLinkToRiskRegister.size());
            responseJson.put("data", riskList);
        } else {
            responseJson.put("startAt", startAt);
            responseJson.put("pageLimit", pageLimit);
            responseJson.put("total", allRiskLinkToRiskRegister.size());
            responseJson.put("data", new ArrayList());
        }
        return responseJson;
    }

    private void RiskDataMapping(Set<Object> riskList, List<DBObject> listOfLinkedRisks, HashMap<String, String> fieldsMap) throws Exception {
        HashSet<String> statusLinkToRisk = new HashSet<String>();
        ArrayList<String> riskRegisterLinkToRisk = new ArrayList<String>();
        ArrayList<String> responsibleLinkToRisk = new ArrayList<String>();
        ArrayList<String> watcherListLinkToRisk = new ArrayList<String>();
        ArrayList<String> riskIdsForConversation = new ArrayList<String>();
        LinkedHashMap<String, LinkedHashMap> riskMapById = new LinkedHashMap<String, LinkedHashMap>();
        for (DBObject linkedRisk : listOfLinkedRisks) {
            List watcherList;
            DBRef responsibleRef;
            DBRef riskRegisterRef;
            DBRef statusRef = (DBRef)linkedRisk.get("status");
            if (PropertyValidator.isValid((Object)statusRef)) {
                statusLinkToRisk.add(String.valueOf(statusRef.getId()));
            }
            if (PropertyValidator.isValid((Object)(riskRegisterRef = (DBRef)linkedRisk.get("riskRegister")))) {
                riskRegisterLinkToRisk.add(String.valueOf(riskRegisterRef.getId()));
            }
            if (PropertyValidator.isValid((Object)(responsibleRef = (DBRef)linkedRisk.get("responsible")))) {
                responsibleLinkToRisk.add(String.valueOf(responsibleRef.getId()));
            }
            if (PropertyValidator.isValid((Collection)(watcherList = (List)linkedRisk.get("watcherList")))) {
                for (int i = 0; i < watcherList.size(); ++i) {
                    DBRef watcherRef = (DBRef)watcherList.get(i);
                    if (!PropertyValidator.isValid((Object)watcherRef)) continue;
                    watcherListLinkToRisk.add(String.valueOf(watcherRef.getId()));
                }
            }
            riskIdsForConversation.add(String.valueOf(linkedRisk.get("_id")));
            LinkedHashMap linkedRiskData = this.getDataBySelectedFieldsForRisk(linkedRisk, fieldsMap);
            if (!PropertyValidator.isValid((Object)linkedRiskData)) continue;
            riskMapById.put(String.valueOf(linkedRisk.get("_id")), linkedRiskData);
            riskList.add(linkedRiskData);
        }
        HashMap allExtraAdditionalDataMap = new HashMap();
        this.buildHashMapData(fieldsMap, statusLinkToRisk, riskRegisterLinkToRisk, responsibleLinkToRisk, watcherListLinkToRisk, riskIdsForConversation, allExtraAdditionalDataMap);
        if (PropertyValidator.isValid(allExtraAdditionalDataMap)) {
            riskList = new HashSet<Object>();
            for (DBObject linkedRisk : listOfLinkedRisks) {
                if (!PropertyValidator.isValid(riskMapById.get(String.valueOf(linkedRisk.get("_id"))))) continue;
                LinkedHashMap linkedRiskData = (LinkedHashMap)riskMapById.get(String.valueOf(linkedRisk.get("_id")));
                this.getExtraAdditionalDataBySelectedFieldsForRisk(linkedRisk, fieldsMap, linkedRiskData, allExtraAdditionalDataMap);
                riskList.add(linkedRiskData);
            }
        }
    }

    private void buildHashMapData(HashMap<String, String> fieldsMap, Set<String> statusLinkToRisk, List<String> riskRegisterLinkToRisk, List<String> responsibleLinkToRisk, List<String> watcherListLinkToRisk, List<String> riskIdsForConversation, Map<String, Object> allExtraAdditionalDataMap) {
        try {
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("status"))) {
                List allStatuses = this.statusRepository.findByIdIn(statusLinkToRisk);
                for (Status status : allStatuses) {
                    allExtraAdditionalDataMap.put(String.valueOf(status.getId()), status);
                }
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("riskRegister"))) {
                List allRiskRegister = this.riskRegisterRepository.findAllByIdIn(riskRegisterLinkToRisk);
                for (RiskRegister riskRegister : allRiskRegister) {
                    allExtraAdditionalDataMap.put(String.valueOf(riskRegister.getId()), riskRegister);
                }
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("watcherList"))) {
                List allWatcher = this.watcherRepository.findByIdIn(watcherListLinkToRisk);
                for (Watcher watcher : allWatcher) {
                    allExtraAdditionalDataMap.put(String.valueOf(watcher.getId()), watcher);
                }
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("responsible"))) {
                List allResponsible = this.userRepository.findByIdIn(responsibleLinkToRisk);
                for (User user : allResponsible) {
                    allExtraAdditionalDataMap.put(String.valueOf(user.getId()), user);
                }
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("conversation"))) {
                List allConversation = this.conversationRepository.findAllByIdIn(riskIdsForConversation);
                for (Conversation conversation : allConversation) {
                    if (!PropertyValidator.isValid((Object)conversation.getRisk())) continue;
                    allExtraAdditionalDataMap.put(String.valueOf(conversation.getRisk().getId()), conversation);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build hashmap Data By fields by api key -> ", (Throwable)e);
        }
    }

    private LinkedHashMap<String, Object> getDataBySelectedFieldsForRisk(DBObject risk, HashMap<String, String> fieldsMap) throws Exception {
        LinkedHashMap<String, Object> riskData = new LinkedHashMap<String, Object>();
        try {
            DBObject probability;
            DBObject impact;
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("title"))) {
                riskData.put("title", risk.get("riskTitle"));
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("id"))) {
                riskData.put("id", String.valueOf(risk.get("_id")));
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("createdBy"))) {
                riskData.put("createdBy", risk.get("createdBy"));
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("linkedItems"))) {
                HashSet linkItemKeys = new HashSet();
                if (PropertyValidator.isValid((Object)risk.get("linkedItemsById"))) {
                    Map linkedItemsById = (Map)risk.get("linkedItemsById");
                    if (PropertyValidator.isValid((Object)risk.get("linkedItemsIds"))) {
                        List listOfLinkedItems = (List)risk.get("linkedItemsIds");
                        for (String itemId : listOfLinkedItems) {
                            Map itemMap = (Map)linkedItemsById.get(itemId);
                            if (!PropertyValidator.isValid((Object)itemMap)) continue;
                            HashMap itemData = new HashMap();
                            itemData.put("key", itemMap.get("key"));
                            itemData.put("id", itemId);
                            linkItemKeys.add(itemData);
                        }
                    }
                }
                riskData.put("linkedItems", linkItemKeys);
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("boardTeams"))) {
                HashSet linkTeamTitles = new HashSet();
                if (PropertyValidator.isValid((Object)risk.get("boardTeams"))) {
                    List listOfLinkedBoardTeams = (List)risk.get("boardTeams");
                    for (DBObject boardTeam : listOfLinkedBoardTeams) {
                        if (!PropertyValidator.isValid((Object)boardTeam.get("teamId")) || !PropertyValidator.isValid((Object)boardTeam.get("teamTitle"))) continue;
                        HashMap<String, Object> teamData = new HashMap<String, Object>();
                        teamData.put("teamTitle", boardTeam.get("teamTitle"));
                        teamData.put("teamId", boardTeam.get("teamId"));
                        linkTeamTitles.add(teamData);
                    }
                }
                riskData.put("boardTeams", linkTeamTitles);
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("boardSprints"))) {
                HashSet linkSprintTitles = new HashSet();
                if (PropertyValidator.isValid((Object)risk.get("boardSprints"))) {
                    List listOfLinkedBoardSprints = (List)risk.get("boardSprints");
                    for (DBObject boardSprint : listOfLinkedBoardSprints) {
                        if (!PropertyValidator.isValid((Object)boardSprint.get("sprintId")) || !PropertyValidator.isValid((Object)boardSprint.get("sprintTitle"))) continue;
                        HashMap<String, Object> sprintData = new HashMap<String, Object>();
                        sprintData.put("sprintTitle", boardSprint.get("sprintTitle"));
                        sprintData.put("sprintId", boardSprint.get("sprintId"));
                        linkSprintTitles.add(sprintData);
                    }
                }
                riskData.put("boardSprints", linkSprintTitles);
            }
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("impact"))) && PropertyValidator.isValid((Object)risk.get("impact")) && PropertyValidator.isValid((Object)(impact = (DBObject)risk.get("impact")).get("title"))) {
                riskData.put("impact", impact.get("title"));
            }
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("probability"))) && PropertyValidator.isValid((Object)risk.get("probability")) && PropertyValidator.isValid((Object)(probability = (DBObject)risk.get("probability")).get("Title"))) {
                riskData.put("probability", probability.get("Title"));
            }
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("raisedDate"))) && PropertyValidator.isValid((Object)risk.get("raisedDate"))) {
                riskData.put("raisedDate", formatter.format(risk.get("raisedDate")));
            }
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("resolutionDate"))) && PropertyValidator.isValid((Object)risk.get("resolutionDate"))) {
                riskData.put("resolutionDate", formatter.format(risk.get("resolutionDate")));
            }
            return riskData;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build objectice Data By fields by api key -> ", (Throwable)e);
            return riskData;
        }
    }

    private void getExtraAdditionalDataBySelectedFieldsForRisk(DBObject risk, HashMap<String, String> fieldsMap, LinkedHashMap<String, Object> linkedRiskData, Map<String, Object> allExtraAdditionalDataMap) throws Exception {
        DBRef responsibleRef;
        DBRef riskRegisterRef;
        DBRef statusRef;
        if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("status"))) && PropertyValidator.isValid((Object)risk.get("status")) && PropertyValidator.isValid((Object)(statusRef = (DBRef)risk.get("status"))) && PropertyValidator.isValid((Object)statusRef.getId()) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(statusRef.getId().toString()))) {
            Status status = (Status)allExtraAdditionalDataMap.get(statusRef.getId().toString());
            HashMap<String, String> statusData = new HashMap<String, String>();
            statusData.put("status", status.getTitle());
            statusData.put("id", status.getId());
            linkedRiskData.put("status", statusData);
        }
        if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("riskRegister"))) && PropertyValidator.isValid((Object)risk.get("riskRegister")) && PropertyValidator.isValid((Object)(riskRegisterRef = (DBRef)risk.get("riskRegister"))) && PropertyValidator.isValid((Object)riskRegisterRef.getId()) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(riskRegisterRef.getId().toString()))) {
            RiskRegister riskRegister = (RiskRegister)allExtraAdditionalDataMap.get(riskRegisterRef.getId().toString());
            HashMap riskRegisterData = new HashMap();
            riskRegisterData.put("riskRegister", riskRegister.getRegisterName());
            riskRegisterData.put("id", riskRegister.getId());
            linkedRiskData.put("riskRegister", riskRegisterData);
        }
        if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("watcherList"))) {
            HashSet linkWatcherList = new HashSet();
            List watcherList = (List)risk.get("watcherList");
            if (PropertyValidator.isValid((Collection)watcherList)) {
                for (DBRef watcherRef : watcherList) {
                    if (!PropertyValidator.isValid((Object)watcherRef) || !PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(watcherRef.getId().toString()))) continue;
                    Watcher watcher = (Watcher)allExtraAdditionalDataMap.get(watcherRef.getId().toString());
                    HashMap<String, String> watcherData = new HashMap<String, String>();
                    watcherData.put("Watcher", watcher.getUser().getFullName());
                    watcherData.put("id", watcher.getUser().getId());
                    linkWatcherList.add(watcherData);
                }
            }
            linkedRiskData.put("watcherList", linkWatcherList);
        }
        if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("responsible"))) && PropertyValidator.isValid((Object)risk.get("responsible")) && PropertyValidator.isValid((Object)(responsibleRef = (DBRef)risk.get("responsible"))) && PropertyValidator.isValid((Object)responsibleRef.getId()) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(responsibleRef.getId().toString()))) {
            User responsible = (User)allExtraAdditionalDataMap.get(responsibleRef.getId().toString());
            HashMap<String, String> userData = new HashMap<String, String>();
            userData.put("user", responsible.getFullName());
            userData.put("id", responsible.getId());
            linkedRiskData.put("responsible", userData);
        }
    }

    public HashMap<String, Object> getRiskRegisterLinkToTheBoard(String activeSessionId, String fields, String expand) throws Exception {
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        SessionBoard activeSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)activeSessionId));
        if (PropertyValidator.isValid((Object)activeSessionBoard)) {
            if (PropertyValidator.isValid((Object)activeSessionBoard.getSession()) && PropertyValidator.isValid((Object)activeSessionBoard.getSession().getRiskRegister())) {
                RiskRegister linkedRiskRegister = activeSessionBoard.getSession().getRiskRegister();
                List allRiskLinkToRiskRegister = this.riskRepository.findAllByRiskRegisterId(linkedRiskRegister.getId());
                HashMap fieldsMap = this.apiServiceImpl.getfieldsMap(fields, expand);
                LinkedHashMap<String, Object> linkedRiskData = new LinkedHashMap<String, Object>();
                if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("key"))) {
                    linkedRiskData.put("key", linkedRiskRegister.getRegisterKey());
                }
                if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("title"))) {
                    linkedRiskData.put("title", linkedRiskRegister.getRegisterName());
                }
                if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("id"))) {
                    linkedRiskData.put("id", String.valueOf(linkedRiskRegister.getId()));
                }
                if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("createdBy"))) {
                    linkedRiskData.put("createdBy", linkedRiskRegister.getCreatedBy());
                }
                if ((PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("status"))) && PropertyValidator.isValid((Object)linkedRiskRegister.getStatus()) && PropertyValidator.isValid((Object)linkedRiskRegister.getStatus().getTitle())) {
                    HashMap<String, String> statusData = new HashMap<String, String>();
                    statusData.put("status", linkedRiskRegister.getStatus().getTitle());
                    statusData.put("id", linkedRiskRegister.getStatus().getId());
                    linkedRiskData.put("status", statusData);
                }
                if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("boardTitle"))) {
                    HashMap<String, String> boardData = new HashMap<String, String>();
                    boardData.put("boardTitle", activeSessionBoard.getSession().getTitle());
                    boardData.put("id", activeSessionBoard.getId());
                    linkedRiskData.put("board", boardData);
                }
                ArrayList<LinkedHashMap<String, Object>> listOfRiskRegisterData = new ArrayList<LinkedHashMap<String, Object>>();
                listOfRiskRegisterData.add(linkedRiskData);
                responseJson.put("data", listOfRiskRegisterData);
            } else {
                responseJson.put("data", new ArrayList());
            }
        } else {
            responseJson.put("errorMessages", "Board does not exist or you do not have permission to see it.");
        }
        return responseJson;
    }

    public HashMap<String, Object> getRiskRegisterLinkedBoards(String riskRegisterId, int startAt, int pageLimit) throws Exception {
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        List allSessionLinkedWithRiskRegister = this.getSessionLinkedWithRiskRegister(riskRegisterId, startAt, pageLimit, true);
        List sessionLinkedWithRiskRegister = this.getSessionLinkedWithRiskRegister(riskRegisterId, startAt, pageLimit, true);
        HashSet boardList = new HashSet();
        if (PropertyValidator.isValid((Collection)sessionLinkedWithRiskRegister)) {
            for (DBObject session : sessionLinkedWithRiskRegister) {
                LinkedHashMap<String, Object> boardJson = new LinkedHashMap<String, Object>();
                boardJson.put("id", session.get("activeSessionBoard"));
                boardJson.put("title", session.get("title"));
                boardJson.put("prefix", session.get("prefix"));
                boardList.add(boardJson);
            }
        }
        responseJson.put("startAt", startAt);
        responseJson.put("pageLimit", pageLimit);
        responseJson.put("total", allSessionLinkedWithRiskRegister.size());
        responseJson.put("data", boardList);
        return responseJson;
    }

    public HashMap<String, Object> getRiskById(String id, String fields, String expand) throws Exception {
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        List risk = this.getRiskByRiskIdOrKey(id);
        if (PropertyValidator.isValid((Collection)risk)) {
            HashSet riskList = new HashSet();
            HashMap fieldsMap = this.apiServiceImpl.getfieldsMap(fields, expand);
            this.RiskDataMapping(riskList, risk, fieldsMap);
            responseJson.put("data", riskList);
        } else {
            responseJson.put("data", new ArrayList());
        }
        return responseJson;
    }
}

