/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.entity.ALMFilter;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssue2;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.alm.jira.bo.JiraSearch2;
import com.viztrend.safe.alm.tfs.TFSFilter;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumFeature;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumRTModules;
import com.viztrend.safe.enums.EnumWorkSpaceType;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmHierarchyLevelMapping;
import com.viztrend.safe.persistence.entity.BacklogHierarchy;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.BacklogSettings;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Board;
import com.viztrend.safe.persistence.entity.BoardConfiguration;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.FieldsLayout;
import com.viztrend.safe.persistence.entity.FilterCriteria;
import com.viztrend.safe.persistence.entity.GroupConfig;
import com.viztrend.safe.persistence.entity.HierarchyLevel;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.JiraProjectIssueTypes;
import com.viztrend.safe.persistence.entity.Lane;
import com.viztrend.safe.persistence.entity.ObjectiveCustomView;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionArea;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.TFSItemLinkType;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.WorkSpaceConfiguration;
import com.viztrend.safe.persistence.entity.WorkSpaceType;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.AlmHierarchyLevelMappingRepository;
import com.viztrend.safe.persistence.repository.BacklogHierarchyRepository;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.BoardRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.FilterCriteriaRepository;
import com.viztrend.safe.persistence.repository.GroupConfigRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.HierarchyLevelRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.persistence.repository.LaneRepository;
import com.viztrend.safe.persistence.repository.ObjectiveCustomViewRepository;
import com.viztrend.safe.persistence.repository.PiSiteRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.RoleRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSAlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceConfigurationRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceTypeRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.ALMSyncServiceImpl;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.ExternalEntitiesService;
import com.viztrend.safe.service.MongoService;
import com.viztrend.safe.service.RTItemTfsSyncService;
import com.viztrend.safe.service.RTTfsMetaService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.service.ReleaseTrainServiceImpl;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.WorkSpaceTypeService;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.BacklogItemVO;
import com.viztrend.safe.vos.ResyncParamsVO;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="ReleaseTrainService")
public class ReleaseTrainServiceImpl
implements ReleaseTrainService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReleaseTrainServiceImpl.class);
    @Autowired
    private BoardRepository boardRepository;
    @Autowired
    private LaneRepository laneRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoService mongoService;
    @Autowired
    private WorkSpaceConfigurationRepository workSpaceConfigurationRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private HierarchyLevelRepository almHierarchyLevelRepository;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private ImportUtil importUtil;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private ALMSyncServiceImpl almSyncServiceImpl;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private FilterCriteriaRepository filterCriteriaRepository;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private TFSAlmConfigurationsRepository tfsAlmConfigurationsRepository;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private RTTfsMetaService tfsMetaService;
    @Autowired
    private RTItemTfsSyncService itemTfsSyncService;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    private WorkSpaceTypeService workSpaceTypeService;
    @Autowired
    private WorkSpaceTypeRepository workSpaceTypeRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private BacklogHierarchyRepository almHierarchyRepository;
    @Autowired
    private AlmHierarchyLevelMappingRepository almHierarchyLevelMappingRepository;
    @Autowired
    private BacklogHierarchyRepository backlogHierarchyRepository;
    @Autowired
    private HierarchyLevelRepository hierarchyLevelRepository;
    @Autowired
    private PiSiteRepository piSiteRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private GroupConfigRepository groupConfigRepository;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private ExternalEntitiesService externalEntitiesService;
    @Autowired
    private ObjectiveCustomViewRepository objectiveCustomViewRepository;
    @Autowired
    private TFSservice tfsService;

    public boolean isKendisSyncOn(String tenant) {
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            return UserContextUtil.getUserContext().getCurrentCompany().checkFlagOnORG(EnumFeature.COM_FLAG_SYNC.getCode());
        }
        Query query1 = new Query();
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        Company company = (Company)this.mongoTemplate.findOne(query1, Company.class, KendisUtils.dbName(Company.class));
        if (company != null) {
            return company.checkFlagOnORG(EnumFeature.COM_FLAG_SYNC.getCode());
        }
        return true;
    }

    public Map<String, Object> getAllReleaseTrainsByWsType(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List workSpaces = new ArrayList();
        WorkSpaceType workSpaceType = (WorkSpaceType)this.workSpaceTypeRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)workSpaceType)) {
            workSpaces = this.workSpaceRepository.findAllByTypeIdOrderBySequenceAsc(workSpaceType.getId());
        }
        result.put("releaseTrains", workSpaces);
        return result;
    }

    public Map<String, Object> getAllWorkSpaceTypes() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List workspaceTypes = this.workSpaceTypeService.getListOfAllWorkSpacesTypes();
        result.put("workSpaceTypes", workspaceTypes);
        return result;
    }

    public Map<String, Object> archiveOrUnarchiveBoard(String id, boolean isArchive) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (isArchive) {
            this.customRepository.setRowStatus(id, 1, Board.class);
            result.put("id", id);
            result.put("archiveFlag", true);
        } else {
            this.customRepository.setRowStatus(id, 0, Board.class);
            result.put("id", id);
            result.put("archiveFlag", false);
        }
        return result;
    }

    public List<BaseItem> getBatchList(String releaseTrainId) {
        List baseItemLinksTypeBatchGroups = null;
        List batchesGroupsBaseItems = new ArrayList();
        ArrayList<BaseItem> batchesList = null;
        try {
            if (PropertyValidator.isValid((Object)releaseTrainId)) {
                baseItemLinksTypeBatchGroups = this.loadBaseItemLinksByReleasaeTrainIdAndType(releaseTrainId);
            }
            batchesGroupsBaseItems = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinksTypeBatchGroups);
            batchesList = new ArrayList<BaseItem>();
            if (PropertyValidator.isValid(batchesGroupsBaseItems)) {
                for (BaseItem batchGroup : batchesGroupsBaseItems) {
                    if (batchGroup.isArchive()) continue;
                    batchesList.add(batchGroup);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return batchesList;
    }

    private List<BaseItemLink> loadBaseItemLinksByReleasaeTrainIdAndType(String releasaeTrainId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"release_train_batch"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"releaseTrainId").is((Object)releasaeTrainId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        return this.mongoTemplate.find(query, BaseItemLink.class);
    }

    public Map<String, Object> moveItemsToParentLane(String parentLaneId, String[] removedLaneIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List baseItemLinks = null;
        for (String laneId : removedLaneIds) {
            baseItemLinks = this.baseItemLinkRepository.findByLaneId(laneId);
            if (!PropertyValidator.isValid((Collection)baseItemLinks)) continue;
            for (BaseItemLink baseItemLink : baseItemLinks) {
                baseItemLink.setLaneId(parentLaneId);
                System.out.println(baseItemLink);
            }
            this.baseItemLinkRepository.save((Iterable)baseItemLinks);
        }
        result.put("baseItemLink", baseItemLinks);
        return result;
    }

    public Map<String, Object> getBoard(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Board board = this.boardRepository.findByIdOrKey(id, id);
        if (PropertyValidator.isValid((Object)board)) {
            List lanes = this.laneRepository.findByBoardId(board.getId());
            result.put("board", board);
            result.put("lanes", lanes);
        }
        return result;
    }

    public Map<String, Object> saveBoard(Board board) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)board.getKey())) {
            if (board.getViewType().equals(Board.EnumBoardType.KANBAN.getValue())) {
                board.setKey(this.customRepository.generateKey(Board.EnumBoardType.KANBAN.getPrefix()));
                board.setBacklogColumnTitle("Backlog");
            } else if (board.getViewType().equals(Board.EnumBoardType.TIMELINE.getValue())) {
                board.setKey(this.customRepository.generateKey(Board.EnumBoardType.TIMELINE.getPrefix()));
            } else if (board.getViewType().equals(Board.EnumBoardType.ROADMAP.getValue())) {
                board.setKey(this.customRepository.generateKey(Board.EnumBoardType.ROADMAP.getPrefix()));
            } else if (board.getViewType().equals(Board.EnumBoardType.OKR_ROADMAP.getValue())) {
                board.setKey(this.customRepository.generateKey(Board.EnumBoardType.ROADMAP.getPrefix()));
            }
        }
        Board savedBoard = (Board)this.boardRepository.save((Object)board);
        result.put("board", savedBoard);
        return result;
    }

    public Map<String, Object> saveLane(Lane lane) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Lane savedLane = (Lane)this.laneRepository.save((Object)lane);
        result.put("lane", savedLane);
        return result;
    }

    public Map<String, Object> saveAllLanes(Collection<Lane> lanes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List savedLanes = this.laneRepository.save(lanes);
        result.put("lanes", savedLanes);
        return result;
    }

    public void deleteLanes(Set<String> laneIds) {
        ArrayList<Lane> lanes = new ArrayList<Lane>();
        for (String laneId : laneIds) {
            lanes.add(new Lane(laneId));
        }
        this.laneRepository.delete(lanes);
    }

    public Map<String, Object> getAboutReleaseTrainDescription(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkSpace workSpace = this.workSpaceRepository.findByIdOrKey(id, id);
        if (PropertyValidator.isValid((Object)workSpace)) {
            result.put("releaseTrain", workSpace.getId());
            result.put("description", workSpace.getDescription());
            result.put("name", workSpace.getTitle());
            result.put("color", workSpace.getColor());
            result.put("shortName", workSpace.getShortName());
            result.put("workspaceType", workSpace.getType());
            result.put("success", true);
        }
        return result;
    }

    public Map<String, Object> saveAboutReleaseTrainDescription(String id, String description) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkSpace workSpace = this.workSpaceRepository.findByIdOrKey(id, id);
        if (PropertyValidator.isValid((Object)workSpace)) {
            workSpace.setDescription(description);
            this.workSpaceRepository.save((Object)workSpace);
            result.put("releaseTrain", workSpace.getId());
            result.put("description", workSpace.getDescription());
            result.put("success", true);
        }
        return result;
    }

    public Map<String, Object> getWorkSpaceProjects(String workspaceKey, String almAccountId, String almAccountType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            if (PropertyValidator.isValid((Object)almAccount)) {
                if (almAccount.getType().equalsIgnoreCase("tfs")) {
                    result.put("tfsProjects", this.tfsMetaService.fetchLinkedTfsProjects(almAccount.getId(), workspaceKey));
                } else {
                    result.put("jiraProjects", this.fetchLinkedJiraProjects(almAccount));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        return result;
    }

    public Map<String, Object> getReleaseTrain(String id) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, FieldsLayout> layouts = new HashMap<String, FieldsLayout>();
        WorkSpace workSpace = this.workSpaceRepository.findByIdOrKey(id, id);
        if (PropertyValidator.isValid((Object)workSpace)) {
            List workFlowList;
            result.put("releaseTrain", workSpace);
            WorkSpaceConfiguration workSpaceConfig = this.workSpaceConfigurationRepository.findByWorkSpaceId(workSpace.getId());
            if (PropertyValidator.isValid((Object)workSpaceConfig)) {
                result.put("releaseTrainConfig", workSpaceConfig);
            }
            if (!PropertyValidator.isValid((Object)workSpace.getWorkflow()) && PropertyValidator.isValid((Collection)(workFlowList = this.workFlowRepository.findAllByWorkflowType("General")))) {
                workSpace.setWorkflow((WorkFlow)workFlowList.get(0));
                this.workSpaceRepository.save((Object)workSpace);
            }
            if (PropertyValidator.isValid((Object)workSpace.getWorkflow())) {
                List statuses = this.statusRepository.findByWorkFlow(workSpace.getWorkflow());
                result.put("statuses", statuses);
            }
            List milestoneWorkflowList = this.workFlowRepository.findAllByWorkflowType(EnumKendis.MILESTONE.getCode());
            List milestoneStatus = new ArrayList();
            if (!PropertyValidator.isValid((Collection)milestoneWorkflowList)) {
                milestoneWorkflowList.add(this.createMilestoneWorkFlow());
            }
            milestoneStatus = this.statusRepository.findByWorkFlow((WorkFlow)milestoneWorkflowList.get(0));
            result.put("milestoneStatuses", milestoneStatus);
            if (PropertyValidator.isValid((Collection)workSpace.getLinkedAlmAccounts())) {
                AlmAccount almAccount = (AlmAccount)workSpace.getLinkedAlmAccounts().get(0);
                if (almAccount.getType().equalsIgnoreCase("tfs")) {
                    result.put("tfsProjects", this.tfsMetaService.fetchLinkedTfsProjects(almAccount.getId(), workSpace.getKey()));
                } else {
                    result.put("jiraProjects", this.fetchLinkedJiraProjects(almAccount));
                    List allStatuses = this.statusRepository.findByAlmId(almAccount.getId());
                    result.put("jiraStatuses", allStatuses);
                }
                result.put("almAccounts", workSpace.getLinkedAlmAccounts());
            }
            List hierarchyLevels = this.getHierarchyLevels(workSpace);
            result.put("backlogHierarchyLevels", hierarchyLevels);
            List accessRoles = new ArrayList();
            accessRoles = this.workSpaceAccessRoleRepository.findByWorkSpace(workSpace);
            if (PropertyValidator.isValid(accessRoles)) {
                workSpace.setAccessRoles(accessRoles);
            }
            result.put("filterCriterias", this.getAllFilterCriteria(workSpace.getId()));
            List groupConfigs = this.groupConfigRepository.findByHeirarchyId(workSpace.getLinkedAlmHierarchy());
            result.put("groupConfigs", groupConfigs);
            if (PropertyValidator.isValid((Object)workSpace.getKendisOnlyLayout())) {
                layouts.put("kendisCard", workSpace.getKendisOnlyLayout());
            } else {
                layouts.put("kendisCard", this.customFieldService.getDefaultLayoutFromItemType(EnumKendis.KENDIS_ONLY_CARD.getCode()));
            }
            result.put("layouts", layouts);
            WorkFlow dependencyWorkflow = null;
            List workFlowList2 = this.workFlowRepository.findAllByWorkflowType("Dependency");
            dependencyWorkflow = PropertyValidator.isValid((Collection)workFlowList2) ? (WorkFlow)workFlowList2.get(0) : this.tfsService.createDefaultDependencyWorkflow();
            List dependencyStatuses = this.statusRepository.findByWorkFlow(dependencyWorkflow);
            ArrayList sortedStatuses = new ArrayList();
            HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
            if (PropertyValidator.isValid((Object)dependencyWorkflow.getStatusSequence())) {
                String[] sortedStatusIds = dependencyWorkflow.getStatusSequence().split(",");
                for (Status status : dependencyStatuses) {
                    sortedStatusesMap.put(status.getId(), status);
                }
                for (String statusId : sortedStatusIds) {
                    Status status = (Status)sortedStatusesMap.get(statusId);
                    if (status == null) continue;
                    sortedStatuses.add(sortedStatusesMap.get(statusId));
                }
                dependencyWorkflow.setStatuses(sortedStatuses);
            } else {
                dependencyWorkflow.setStatuses(dependencyStatuses);
            }
            result.put("dependencyWorkflow", dependencyWorkflow);
        }
        return result;
    }

    public Map<String, Object> getReleaseTrainItemHierarchy(HashMap<String, Object> requestBody) throws Exception {
        String releaseTrainId = (String)requestBody.get("releaseTrainId");
        Boolean fetchHierarchies = null != requestBody.get("fetchHierarchies");
        Boolean fetchFilters = null != requestBody.get("fetchFilters");
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        WorkSpace collection = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        if (PropertyValidator.isValid((Object)collection)) {
            if (fetchHierarchies.booleanValue()) {
                List hierarchyLevels = new ArrayList();
                if (PropertyValidator.isValid((Object)collection)) {
                    hierarchyLevels = this.getHierarchyLevels(collection);
                }
                responseJson.put("hierarchyLevels", hierarchyLevels);
            }
            if (fetchFilters.booleanValue()) {
                responseJson.put("filterCriterias", this.getAllFilterCriteria(collection.getId()));
            }
        }
        responseJson.put("defaultKendisCardLayout", this.customFieldService.getDefaultLayoutFromItemType(EnumKendis.KENDIS_ONLY_CARD.getCode()));
        return responseJson;
    }

    public Map<String, Object> fetchBacklogItemsSettings(Map<String, String> requestBody) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String releaseTrainId = requestBody.get("releaseTrainId");
        String hierarchyLevelId = requestBody.get("hierarchyLevelId");
        if (PropertyValidator.isValid((Object)releaseTrainId) && PropertyValidator.isValid((Object)hierarchyLevelId)) {
            WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
            if (PropertyValidator.isValid((Object)workSpace)) {
                HashMap backlogSettingsMap = workSpace.getBacklogSettingsMap();
                if (PropertyValidator.isValid((Object)backlogSettingsMap)) {
                    BacklogSettings backlogSettings = (BacklogSettings)backlogSettingsMap.get(hierarchyLevelId);
                    if (PropertyValidator.isValid((Object)backlogSettings)) {
                        FilterCriteria defaultFilterCriteria;
                        if (PropertyValidator.isValid((Collection)backlogSettings.getBackLogItemsColumns())) {
                            responseJson.put("backlogItemColumns", backlogSettings.getBackLogItemsColumns());
                        }
                        if (PropertyValidator.isValid((Object)backlogSettings.getDefaultFilterId()) && PropertyValidator.isValid((Object)(defaultFilterCriteria = (FilterCriteria)this.filterCriteriaRepository.findOne((Serializable)((Object)backlogSettings.getDefaultFilterId()))))) {
                            responseJson.put("defaultFilterCriteria", defaultFilterCriteria);
                        }
                        if (PropertyValidator.isValid((Object)backlogSettings.getDefaultProject())) {
                            responseJson.put("defaultProject", backlogSettings.getDefaultProject());
                        }
                        if (PropertyValidator.isValid((Object)backlogSettings.getDefaultItemType())) {
                            responseJson.put("defaultItemType", backlogSettings.getDefaultItemType());
                        }
                        if (PropertyValidator.isValid((Object)backlogSettings.getDefaultStatus())) {
                            responseJson.put("defaultStatus", backlogSettings.getDefaultStatus());
                        }
                        if (PropertyValidator.isValid((Collection)backlogSettings.getDefaultJiraFields())) {
                            responseJson.put("defaultJiraFields", backlogSettings.getDefaultJiraFields());
                        }
                        if (PropertyValidator.isValid((Collection)backlogSettings.getItemRestrictions())) {
                            responseJson.put("restrictedProjectsAndIssueTypes", backlogSettings.getItemRestrictions());
                        }
                        responseJson.put("isRestrictionApplied", backlogSettings.isRestrictionApplied());
                    } else {
                        responseJson.put("error", "Settings not found for the specified hierarchy level.");
                    }
                }
            } else {
                responseJson.put("error", "Workspace not found.");
            }
        } else {
            responseJson.put("error", "Invalid releaseTrainId or hierarchyLevelId.");
        }
        return responseJson;
    }

    public Map<String, Object> fetchFiltersByHierarchyLevel(String releaseTrainId, Integer hierarchyLevel) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List filterCriteriaList = this.filterCriteriaRepository.findByReleaseTrainIdAndLevel(releaseTrainId, hierarchyLevel);
        if (PropertyValidator.isValid((Collection)filterCriteriaList)) {
            responseJson.put("filterCriterias", filterCriteriaList);
        }
        return responseJson;
    }

    public Map<String, Object> getItemBreadCrumbs(String releaseTrainId, String itemId) throws Exception {
        ArrayList breadCrumbs = new ArrayList();
        this.generateBreadCrumbs(itemId, releaseTrainId, breadCrumbs);
        Collections.reverse(breadCrumbs);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("breadCrumbs", breadCrumbs);
        return response;
    }

    private void generateBreadCrumbs(String itemId, String releaseTrainId, List<Map<String, String>> breadCrumbs) {
        String parentItemId;
        BacklogItem currentItem = this.backlogItemRepository.findById(itemId);
        if (!PropertyValidator.isValid((Object)currentItem)) {
            return;
        }
        String iconUrl = "";
        if (PropertyValidator.isValid(currentItem.getFields().get("itemTypeIcon"))) {
            iconUrl = (String)currentItem.getFields().get("itemTypeIcon");
        } else {
            Map issuetype;
            Map almfields = currentItem.getAlmFields();
            if (PropertyValidator.isValid(almfields.get("issuetype")) && PropertyValidator.isValid((issuetype = (Map)almfields.get("issuetype")).get("iconUrl"))) {
                iconUrl = (String)issuetype.get("iconUrl");
            }
        }
        HashMap<String, String> itemDetails = new HashMap<String, String>();
        itemDetails.put("key", currentItem.getKendisKey());
        itemDetails.put("title", currentItem.getTitle());
        itemDetails.put("id", currentItem.getId());
        itemDetails.put("almKey", currentItem.getAlmKey());
        itemDetails.put("almUrl", currentItem.getUrl());
        itemDetails.put("itemTypeIcon", iconUrl);
        if (PropertyValidator.isValid((Object)currentItem.getArtRelationMap()) && PropertyValidator.isValid(currentItem.getArtRelationMap().get(releaseTrainId))) {
            itemDetails.put("level", String.valueOf(((BaseItemLink)currentItem.getArtRelationMap().get(releaseTrainId)).getBacklogLevel()));
        }
        breadCrumbs.add(itemDetails);
        if (currentItem.getParentRelationMap().containsKey(releaseTrainId) && !((List)currentItem.getParentRelationMap().get(releaseTrainId)).isEmpty() && PropertyValidator.isValid((Object)(parentItemId = ((BaseItemLink)((List)currentItem.getParentRelationMap().get(releaseTrainId)).get(0)).getBacklogItemId().toString()))) {
            this.generateBreadCrumbs(parentItemId, releaseTrainId, breadCrumbs);
        }
    }

    public Map<String, Object> getReleaseTrainPiBoards(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)workSpace)) {
            List sessions = this.sessionRepository.findPiBoardsByWorkSpaceAndRowStatus(workSpace, Integer.valueOf(0));
            List sessionsIds = sessions.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List sessionBoards = new ArrayList();
            sessionBoards = this.sessionBoardRepository.findBySessionIdIn(sessionsIds);
            if (PropertyValidator.isValid(sessionBoards)) {
                result.put("sessions", sessions);
                result.put("sessionBoards", sessionBoards);
            }
        }
        return result;
    }

    public Map<String, Object> fetchBacklogItemByKey(HashMap<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String itemKey = null;
        String releaseTrainId = null;
        if (params.containsKey("itemKey")) {
            itemKey = (String)params.get("itemKey");
        }
        if (PropertyValidator.isValid(itemKey)) {
            Optional backlogItemOptional = this.backlogItemRepository.findByKendisKey(itemKey.toUpperCase());
            if (backlogItemOptional.isPresent()) {
                WorkSpace workSpace;
                BacklogItem backlogItem = (BacklogItem)backlogItemOptional.get();
                if (params.containsKey("releaseTrainId")) {
                    releaseTrainId = (String)params.get("releaseTrainId");
                } else {
                    Map artRelations = backlogItem.getArtRelationMap();
                    releaseTrainId = artRelations.keySet().toArray()[0].toString();
                }
                if (PropertyValidator.isValid((Object)releaseTrainId) && PropertyValidator.isValid((Object)(workSpace = this.workSpaceRepository.findByIdOrKey(releaseTrainId, releaseTrainId)))) {
                    result.put("releaseTrain", workSpace);
                }
                List milestoneWorkflowList = this.workFlowRepository.findAllByWorkflowType(EnumKendis.MILESTONE.getCode());
                List milestoneStatus = new ArrayList();
                if (!PropertyValidator.isValid((Collection)milestoneWorkflowList)) {
                    milestoneWorkflowList.add(this.createMilestoneWorkFlow());
                }
                milestoneStatus = this.statusRepository.findByWorkFlow((WorkFlow)milestoneWorkflowList.get(0));
                result.put("statuses", milestoneStatus);
                result.put("backlogItem", backlogItem);
            } else {
                result.put("error", "No Backlog Item Found");
            }
        } else {
            result.put("error", "Invalid Item Key");
        }
        return result;
    }

    public Map<String, Object> getReleaseTrainSolutionBoards(String id) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)id));
        HashMap<String, String> fullNameMap = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)workSpace)) {
            List boards = this.solutionBoardRepository.findByWorkSpaceAndRowStatus(workSpace, 0);
            ArrayList userEmails = new ArrayList();
            boards.forEach(board -> userEmails.add(board.getCreatedBy()));
            List users = this.userRepository.findByEmailInOrUserNameIn(userEmails, userEmails);
            for (User user : users) {
                fullNameMap.put(user.getEmail(), user.getFullName());
            }
            result.put("boards", boards);
            result.put("fullNameMap", fullNameMap);
        }
        return result;
    }

    public Map<String, Object> getReleaseSolutionBoardsAndPiBoards(String id) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkSpace workSpace = this.workSpaceRepository.findByIdOrKey(id, id);
        if (PropertyValidator.isValid((Object)workSpace)) {
            List boards = this.solutionBoardRepository.findByWorkSpace(workSpace);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace").is((Object)workSpace));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.fields().include("title").include("id");
            List sessions = this.mongoTemplate.find(query, Session.class);
            result.put("sessions", sessions);
            result.put("solutionBoards", boards);
        }
        return result;
    }

    public Map<String, Object> getReleaseSolutionBoardsAndPiBoardsByKey(String workspaceKey) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkSpace workSpace = this.workSpaceRepository.findByKey(workspaceKey);
        if (PropertyValidator.isValid((Object)workSpace)) {
            List boards = this.solutionBoardRepository.findByWorkSpace(workSpace);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace").is((Object)workSpace));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.fields().include("title").include("id");
            List sessions = this.mongoTemplate.find(query, Session.class);
            result.put("sessions", sessions);
            result.put("solutionBoards", boards);
        }
        return result;
    }

    public Map<String, Object> getReleaseTrainKanbanBoards(Map<String, Object> params) throws Exception {
        String id = (String)params.get("id");
        String viewType = (String)params.get("viewType");
        Boolean isArchive = (Boolean)params.get("isArchive");
        if (isArchive == null) {
            isArchive = false;
        }
        Integer level = null;
        if (params.containsKey("level")) {
            level = Integer.parseInt((String)params.get("level"));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        switch (viewType) {
            case "OKR_ROADMAP": {
                String context = (String)params.get("context");
                this.handleOkrRoadmapViewType(id, result, context);
                break;
            }
            default: {
                this.handleDefaultViewType(id, viewType, isArchive, level, result);
            }
        }
        return result;
    }

    private void handleOkrRoadmapViewType(String id, Map<String, Object> result, String context) {
        if ("ObjCustomView".equalsIgnoreCase(context)) {
            ObjectiveCustomView customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)id));
            if (PropertyValidator.isValid((Object)customView)) {
                List boards = this.boardRepository.findByObjectiveCustomViewAndViewType(customView, "OKR_ROADMAP");
                result.put("boards", boards);
            }
        } else {
            WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)id));
            if (PropertyValidator.isValid((Object)workSpace)) {
                List boards = this.boardRepository.findByWorkSpaceAndViewTypeAndRowStatus(workSpace, "OKR_ROADMAP", 0);
                result.put("boards", boards);
            }
        }
    }

    private void handleDefaultViewType(String id, String viewType, Boolean isArchive, Integer level, Map<String, Object> result) throws Exception {
        HashMap<String, String> fullNameMap = new HashMap<String, String>();
        ArrayList<String> userEmails = new ArrayList<String>();
        WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)workSpace)) {
            List boards;
            List<Object> list = boards = isArchive != false ? this.boardRepository.findByWorkSpaceAndViewTypeAndRowStatus(workSpace, viewType, 1) : this.boardRepository.findByWorkSpaceAndViewTypeAndRowStatus(workSpace, viewType, 0);
            if (level != null) {
                Integer finalLevel = level;
                boards = boards.stream().filter(b -> b.getLevel().equals(finalLevel)).collect(Collectors.toList());
            }
            for (Board board : boards) {
                userEmails.add(board.getCreatedBy());
            }
            List users = this.userRepository.findByEmailInOrUserNameIn(userEmails, userEmails);
            for (User user : users) {
                fullNameMap.put(user.getEmail(), user.getFullName());
            }
            if (PropertyValidator.isValid(boards)) {
                result.put("boards", boards);
                result.put("fullNameMap", fullNameMap);
            }
        }
    }

    public Map<String, Object> getReleaseTrainTeams(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            WorkSpace currentWorkspace = this.workSpaceRepository.findByIdOrKey(id, id);
            if (PropertyValidator.isValid((Object)currentWorkspace)) {
                ArrayList<WorkSpace> workSpaceList = new ArrayList<WorkSpace>();
                workSpaceList.add(new WorkSpace(currentWorkspace.getId()));
                List teams = this.teamRepository.findByWorkSpacesIn(workSpaceList);
                if (PropertyValidator.isValid((Collection)teams)) {
                    result.put("teams", teams);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public void savePushResponseInFile(String requestId, Map<String, Object> response, boolean completed) throws Exception {
        PushResponse pushResponse = new PushResponse();
        pushResponse.setRequestId(requestId);
        pushResponse.setResponseCompleted(Boolean.valueOf(completed));
        String fileReferenceKey = UUID.randomUUID().toString();
        pushResponse.setFileReferenceKey(fileReferenceKey);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MongoSyncUtils.storeData((String)fileReferenceKey, (String)mapper.writeValueAsString(response), (AppConfig.MongoConfig)this.mongoConfig);
        pushResponse.setContentType("JSON");
        this.pushResponseRepository.save((Object)pushResponse);
    }

    public void fetchMeta(Map<String, Object> responseJson, String artId, String workFlowId, String requestId) {
        try {
            List alms = (List)responseJson.get("almAccounts");
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("metaMap", "{}");
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            Criteria workflow = null;
            if (workFlowId != null) {
                workflow = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"itemWorkFlow.$id").is((Object)new ObjectId(workFlowId)), Criteria.where((String)"subItemWorkFlow.$id").is((Object)new ObjectId(workFlowId))});
            }
            if (PropertyValidator.isValid((Collection)alms)) {
                List jiraConfigs = this.almConfigurationsRepository.findByAlmAccountIn(alms);
                List tfsConfigs = this.tfsAlmConfigurationsRepository.findByAlmAccountIn(alms);
                ArrayList<ObjectId> almConfigIds = new ArrayList<ObjectId>();
                if (PropertyValidator.isValid((Collection)tfsConfigs)) {
                    for (TFSAlmConfigurations almConfig : tfsConfigs) {
                        almConfigIds.add(new ObjectId(almConfig.getId()));
                    }
                }
                if (PropertyValidator.isValid((Collection)jiraConfigs)) {
                    for (TFSAlmConfigurations almConfig : jiraConfigs) {
                        almConfigIds.add(new ObjectId(almConfig.getId()));
                    }
                }
                Object criteria = null;
                criteria = workflow == null ? new Criteria().orOperator(new Criteria[]{Criteria.where((String)"almConfigurations.$id").in(almConfigIds), Criteria.where((String)"tfsAlmConfigurations.$id").in(almConfigIds)}) : new Criteria().orOperator(new Criteria[]{workflow, Criteria.where((String)"almConfigurations.$id").in(almConfigIds), Criteria.where((String)"tfsAlmConfigurations.$id").in(almConfigIds)});
                query.addCriteria((CriteriaDefinition)criteria);
            } else if (workflow == null) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace.$id").is((Object)new ObjectId(artId)));
            } else {
                Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"workSpace.$id").is((Object)new ObjectId(artId)), workflow});
                query.addCriteria((CriteriaDefinition)criteria);
            }
            query.fields().include("id");
            query.fields().include("title");
            query.fields().include("prefix");
            query.fields().include("prefixColor");
            query.fields().include("activeSessionBoard");
            query.fields().include("workSpace");
            query.fields().include("itemWorkFlow");
            query.fields().include("subItemWorkFlow");
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("session").find(query.getQueryObject()).sort((DBObject)new BasicDBObject("updatedOn", (Object)1));
            List allItems = dbCursorPrefix.toArray();
            ArrayList<Object> allSessions = new ArrayList<Object>();
            if (PropertyValidator.isValid((Collection)allItems)) {
                for (DBObject session : allItems) {
                    BasicDBObject _session = new BasicDBObject();
                    _session.put("id", (Object)String.valueOf(session.get("_id")));
                    _session.put("title", session.get("title"));
                    _session.put("prefix", session.get("prefix"));
                    _session.put("prefixColor", session.get("prefixColor"));
                    _session.put("activeSessionBoard", session.get("activeSessionBoard"));
                    if (session.containsField("workSpace")) {
                        DBRef dBRef = (DBRef)session.get("workSpace");
                        _session.put("workSpace", (Object)new BasicDBObject("id", (Object)String.valueOf(dBRef.getId())));
                    }
                    if (session.containsField("itemWorkFlow")) {
                        DBRef dBRef = (DBRef)session.get("itemWorkFlow");
                        _session.put("itemWorkFlow", (Object)new BasicDBObject("id", (Object)String.valueOf(dBRef.getId())));
                    }
                    if (session.containsField("subItemWorkFlow")) {
                        DBRef dBRef = (DBRef)session.get("subItemWorkFlow");
                        _session.put("subItemWorkFlow", (Object)new BasicDBObject("id", (Object)String.valueOf(dBRef.getId())));
                    }
                    allSessions.add(_session);
                }
            }
            response.put("property", "boards");
            response.put("groupBy", "activeSessionBoard");
            response.put("data", allSessions);
            this.savePushResponseInFile(requestId, response, false);
            ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
            ArrayList<String> tids = new ArrayList<String>();
            for (DBObject dBObject : allSessions) {
                ids.add(new ObjectId((String)dBObject.get("activeSessionBoard")));
            }
            ArrayList list = null;
            try {
                list = this.customRepositoryImpl.getByObjectId(ids, SessionBoard.class);
            }
            catch (Exception exception) {
                LOGGER.error(StringUtils.getTraceString((Throwable)exception));
                list = new ArrayList();
            }
            ids = new ArrayList();
            ids = new ArrayList();
            ArrayList<Container> arrayList = new ArrayList<Container>();
            for (DBObject dbo : list) {
                Object ref22;
                String boardId = String.valueOf(dbo.get("_id"));
                List list2 = (List)dbo.get("teams");
                for (Object ref22 : list2) {
                    tids.add(String.valueOf(ref22.getId()));
                }
                list2 = (List)dbo.get("containers");
                ArrayList<String> boardContainerIds = new ArrayList<String>();
                ref22 = list2.iterator();
                while (ref22.hasNext()) {
                    DBRef ref3 = (DBRef)ref22.next();
                    String refId = String.valueOf(ref3.getId());
                    boardContainerIds.add(refId);
                }
                List boardContainers = this.containerRepository.findByIdIn(boardContainerIds);
                if (!PropertyValidator.isValid((Collection)boardContainers)) continue;
                for (Container container : boardContainers) {
                    container.setSessionBoardId(boardId);
                    arrayList.add(container);
                }
            }
            response.put("property", "teams");
            response.put("groupBy", "id");
            response.put("data", this.teamRepository.findTeamsByIdIn(tids));
            this.savePushResponseInFile(requestId, response, false);
            response.put("property", "containers");
            response.put("groupBy", "id");
            response.put("data", arrayList);
            this.savePushResponseInFile(requestId, response, false);
            response.put("property", "solutionBoards");
            response.put("groupBy", "id");
            Query solutionBoardQuery = new Query();
            solutionBoardQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            solutionBoardQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            solutionBoardQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            solutionBoardQuery.fields().include("id");
            solutionBoardQuery.fields().include("title");
            solutionBoardQuery.fields().include("prefix");
            solutionBoardQuery.fields().include("prefixColor");
            solutionBoardQuery.fields().include("workSpace");
            List solBoards = this.mongoTemplate.find(solutionBoardQuery, SolutionBoard.class);
            response.put("data", solBoards);
            this.savePushResponseInFile(requestId, response, false);
            List jiraProjectIssueTypes = (List)responseJson.get("jiraProjects");
            ArrayList projectKeys = new ArrayList();
            HashMap<String, String> json = new HashMap<String, String>();
            json.put("property", "jiraIssueTypes");
            if (PropertyValidator.isValid((Collection)jiraProjectIssueTypes)) {
                jiraProjectIssueTypes.stream().forEach(issueType -> projectKeys.add(issueType.getJiraKey()));
                this.fetchJiraIssueTypes(((AlmAccount)alms.get(0)).getId(), projectKeys, json);
            }
            this.savePushResponseInFile(requestId, json, false);
            ArrayList<String> bTypes = new ArrayList<String>();
            bTypes.add(EnumBaseItemTypes.BATCH.getName());
            bTypes.add(EnumBaseItemTypes.BATCH_GROUP.getName());
            response.put("property", "batches");
            response.put("groupBy", "id");
            response.put("data", this.baseItemRepository.findItemsByTypeIn(bTypes));
            response.put("done", true);
            this.savePushResponseInFile(requestId, response, true);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public List<HierarchyLevel> getHierarchyLevels(WorkSpace workspace) throws Exception {
        BacklogHierarchy hierarchy;
        List levels = null;
        if (workspace.getLinkedAlmHierarchy() != null && PropertyValidator.isValid((Object)(hierarchy = (BacklogHierarchy)this.backlogHierarchyRepository.findOne((Serializable)((Object)workspace.getLinkedAlmHierarchy()))))) {
            levels = hierarchy.getHierarchyLevels();
            Collections.sort(levels, new /* Unavailable Anonymous Inner Class!! */);
        }
        return levels;
    }

    private List<HierarchyLevel> getHierarchyLevels(String linkedAlmHierarchy) {
        List levels = null;
        BacklogHierarchy hierarchy = (BacklogHierarchy)this.backlogHierarchyRepository.findOne((Serializable)((Object)linkedAlmHierarchy));
        if (PropertyValidator.isValid((Object)hierarchy)) {
            levels = hierarchy.getHierarchyLevels();
            Collections.sort(levels, new /* Unavailable Anonymous Inner Class!! */);
        }
        return levels;
    }

    private List<AlmHierarchyLevelMapping> getAlmHierarchyLevelMapping(List<HierarchyLevel> levels, String almAccountId) {
        ArrayList<AlmHierarchyLevelMapping> mappings = new ArrayList<AlmHierarchyLevelMapping>();
        for (HierarchyLevel level : levels) {
            for (AlmHierarchyLevelMapping almMapping : level.getAlmHierarchyLevelMappings()) {
                if (!almMapping.getAlmAccountId().equalsIgnoreCase(almAccountId)) continue;
                mappings.add(almMapping);
            }
        }
        return mappings;
    }

    public Map<String, Object> getAlmAccounts() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List almAccountList = this.almAccountRepository.findAll();
        result.put("almAccountList", almAccountList);
        return result;
    }

    public Map<String, Object> linkAlmAccount(String request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    public Map<String, Object> fetchJiraIssueMeta(AlmAccount almAccount) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("issueTypes", this.importUtil.retrieveJiraIssueTypes("", almAccount.getUsername(), almAccount.getPassword(), almAccount));
        result.put("issueLinkTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(almAccount, false));
        result.put("jiraFields", this.almSyncService.retrieveJiraFieldsJSON(almAccount, false));
        return result;
    }

    public BacklogHierarchy saveALMHierarchy(BacklogHierarchy backlogHierarchy) {
        BacklogHierarchy bH = null;
        try {
            for (HierarchyLevel level : backlogHierarchy.getHierarchyLevels()) {
                level.setAlmHierarchyLevelMappings(this.almHierarchyLevelMappingRepository.save((Iterable)level.getAlmHierarchyLevelMappings()));
            }
            backlogHierarchy.setHierarchyLevels(this.almHierarchyLevelRepository.save((Iterable)backlogHierarchy.getHierarchyLevels()));
            bH = (BacklogHierarchy)this.almHierarchyRepository.save((Object)backlogHierarchy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bH;
    }

    public List<BacklogHierarchy> getBacklogHierarchies() {
        List list = this.almHierarchyRepository.findAll();
        return list;
    }

    public Map<String, Object> createHierarchyMeta(List<BacklogHierarchy> list) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> almAccountLists = new ArrayList<String>();
        ArrayList<String> backlogHierarchyIdList = new ArrayList<String>();
        for (BacklogHierarchy backlogHierarchy : list) {
            if (PropertyValidator.isValid((Collection)backlogHierarchy.getLinkedAlmAccounts())) {
                for (String almId : backlogHierarchy.getLinkedAlmAccounts()) {
                    almAccountLists.add(almId);
                }
            }
            backlogHierarchyIdList.add(backlogHierarchy.getId());
        }
        List almAccounts = this.almAccountRepository.findByIdIn(almAccountLists);
        List linkedWorkspaceList = this.workSpaceRepository.findByLinkedAlmHierarchyIn(backlogHierarchyIdList);
        result.put("almAccountList", almAccounts);
        result.put("linkedWorkspaceList", linkedWorkspaceList);
        return result;
    }

    public Map<String, List> findItemsBySystemProperty(String businessProperty, String value) {
        return null;
    }

    public void addBoardsInMap(String tenant, Collection<String> almItemIds, ResyncParamsVO param) {
        block39: {
            try {
                String version = this.mongoService.getMongoDBVersion();
                if (version == null) break block39;
                String[] v = version.split("\\.");
                if (v.length > 1) {
                    if (new Double(v[0] + "." + v[1]) >= 4.4) break block39;
                }
                return;
            }
            catch (Exception e1) {
                return;
            }
        }
        try {
            if (!this.isKendisSyncOn(tenant)) {
                return;
            }
            String artId = param.getBoardId();
            List sessions = new ArrayList();
            Query query = new Query();
            HashMap<String, String> ws = new HashMap<String, String>();
            String fieldKey = "kendisId";
            ObjectId alm = null;
            if (param != null) {
                if (param.almConfigurations == null) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace.$id").is((Object)new ObjectId(artId)));
                    DBCursor dbc = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class)).find(query.getQueryObject());
                    sessions = dbc.toArray();
                    dbc.close();
                } else if (param.almConfigurations.getAlmAccount() != null) {
                    Object dbc;
                    query = new Query();
                    ArrayList cIds = new ArrayList();
                    List list = null;
                    alm = new ObjectId(param.almConfigurations.getAlmAccount().getId());
                    if ("tfs".equals(param.almConfigurations.getAlmAccount().getType())) {
                        fieldKey = "tfsId";
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccount.$id").is((Object)alm));
                        dbc = this.mongoTemplate.getCollection(KendisUtils.dbName(TFSAlmConfigurations.class)).find(query.getQueryObject());
                        list = dbc.toArray();
                        dbc.close();
                    } else {
                        fieldKey = "jiraId";
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccount.$id").is((Object)alm));
                        dbc = this.mongoTemplate.getCollection(KendisUtils.dbName(AlmConfigurations.class)).find(query.getQueryObject());
                        list = dbc.toArray();
                        dbc.close();
                    }
                    for (DBObject o : list) {
                        cIds.add((ObjectId)o.get("_id"));
                    }
                    Criteria criteria = new Criteria();
                    criteria.orOperator(new Criteria[]{Criteria.where((String)"almConfigurations.$id").in((Collection)cIds), Criteria.where((String)"tfsAlmConfigurations.$id").in((Collection)cIds)});
                    query = new Query();
                    query.addCriteria((CriteriaDefinition)criteria);
                    DBCursor dbc2 = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class)).find(query.getQueryObject());
                    sessions = dbc2.toArray();
                    dbc2.close();
                } else if (param.sessionBoards != null) {
                    for (SessionBoard board : param.sessionBoards) {
                        if (board.getSession() == null) continue;
                        if (artId == null) {
                            artId = board.getSession().getWorkSpace().getId();
                        }
                        ws.put(board.getId(), board.getSession().getWorkSpace().getId());
                        ws.put("session_" + board.getId(), board.getSession().getId());
                    }
                }
            }
            ArrayList<ObjectId> bids = new ArrayList<ObjectId>();
            for (DBObject session : sessions) {
                if (!session.containsField("workSpace")) continue;
                DBRef w = (DBRef)session.get("workSpace");
                if (w != null && artId == null) {
                    artId = String.valueOf(w.getId());
                }
                if (!session.containsField("activeSessionBoard")) continue;
                String bid = String.valueOf(session.get("activeSessionBoard"));
                bids.add(new ObjectId(bid));
                ws.put(bid, String.valueOf(w.getId()));
                ws.put("session_" + bid, String.valueOf(session.get("_id")));
            }
            if (fieldKey.equals("kendisId") && param.backlogAlmIds != null) {
                almItemIds = param.backlogAlmIds.values();
            }
            boolean usingLoop = false;
            List tids = null;
            List result = this.findItemBoards(tenant, fieldKey, almItemIds, bids, alm);
            tids = (List)result.get(1);
            ArrayList tcs = null;
            try {
                tcs = this.customRepositoryImpl.getByObjectId((Collection)tids, TeamContainer.class);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                tcs = new ArrayList();
            }
            HashMap<String, String[]> mapTC = new HashMap<String, String[]>();
            if (PropertyValidator.isValid(tcs)) {
                for (DBObject dbo : tcs) {
                    if (!dbo.containsField("team") || !dbo.containsField("container")) continue;
                    DBRef t = (DBRef)dbo.get("team");
                    DBRef c = (DBRef)dbo.get("container");
                    if (t == null || c == null) continue;
                    mapTC.put(String.valueOf(dbo.get("_id")), new String[]{String.valueOf(t.getId()), String.valueOf(c.getId())});
                }
            }
            boolean updateHere = false;
            List backlogVOs = null;
            HashMap<String, Boolean> removed = new HashMap<String, Boolean>();
            if (param.backlogAlmIds == null) {
                param.backlogAlmIds = new HashMap();
                updateHere = true;
                if (PropertyValidator.isValid((Object)param.almConfigurations.getAlmAccount()) && PropertyValidator.isValid((Object)param.almConfigurations.getAlmAccount().getId())) {
                    try {
                        backlogVOs = this.customRepositoryImpl.findBacklogItemsAlmIds(null, almItemIds, artId, param.almConfigurations.getAlmAccount().getId(), true, tenant);
                    }
                    catch (Exception e) {
                        LOGGER.error("backlogVOs list is empty due to error");
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
                if (backlogVOs != null) {
                    for (BacklogItemVO vo : backlogVOs) {
                        param.backlogAlmIds.put(vo.getAlmItemId(), vo.getId());
                        removed.put(vo.getAlmItemId(), true);
                    }
                }
            }
            HashMap<String, BacklogItem> backlog = new HashMap<String, BacklogItem>();
            List dbos = (List)result.get(0);
            for (DBObject dbo : dbos) {
                String almKey = (String)dbo.get("_id");
                if (almKey == null) {
                    removed.remove(almKey);
                }
                if (!backlog.containsKey(almKey)) {
                    backlog.put(almKey, new BacklogItem((String)param.backlogAlmIds.get(almKey), almKey));
                }
                List docs = (List)dbo.get("items");
                for (Object doc : docs) {
                    boolean overwrite = false;
                    ((BacklogItem)backlog.get(almKey)).parseBoardFromDB(artId, (DBObject)doc, mapTC, overwrite, ws);
                }
            }
            Set ids = removed.keySet();
            for (String key : ids) {
                BacklogItem item;
                if (!backlog.containsKey(key)) {
                    backlog.put(key, new BacklogItem((String)param.backlogAlmIds.get(key), key));
                }
                if ((item = (BacklogItem)backlog.get(key)) == null || updateHere) continue;
                item.initLinks(artId);
            }
            if (PropertyValidator.isValid(almItemIds)) {
                this.customRepositoryImpl.savePartialPiLinksInBacklog(param, almItemIds, backlog);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    private Board findBoardById(List<Board> boards, String id) {
        for (Board board : boards) {
            if (!board.getId().equals(id)) continue;
            return board;
        }
        return null;
    }

    private List findItemBoards(String tenant, String fieldKey, Collection<String> keys, List<ObjectId> bids, ObjectId alm) {
        DBObject dbo;
        List<ObjectId> tcs = new ArrayList();
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        BasicDBObject in = new BasicDBObject("$in", keys);
        BasicDBList or = new BasicDBList();
        if (PropertyValidator.isValid(bids) && !fieldKey.equals("kendisId")) {
            or.add((Object)new BasicDBObject("sessionBoards.$id", (Object)new BasicDBObject("$in", bids)));
        }
        if (PropertyValidator.isValid((Object)alm)) {
            or.add((Object)new BasicDBObject("almId", (Object)String.valueOf(alm)).append("solutionBoard", (Object)new BasicDBObject("$exists", (Object)true)));
        }
        BasicDBObject match = new BasicDBObject("tenant", (Object)tenant).append("archive", (Object)new BasicDBObject("$ne", (Object)true)).append(fieldKey, (Object)in);
        if (or.size() > 0) {
            match.append("$or", (Object)or);
        }
        match = new BasicDBObject("$match", (Object)match);
        boolean useLoop = false;
        try {
            BasicDBObject group2 = new BasicDBObject("$group", (Object)BasicDBObject.parse((String)"{'_id':'0','teamContainers':{'$addToSet':'$teamContainers.$id'}}"));
            BasicDBObject project = new BasicDBObject("$project", (Object)BasicDBObject.parse((String)"{'teamContainers':{'$reduce':{'input':'$teamContainers','initialValue':[],'in':{'$setUnion':['$$value','$$this']}}}}"));
            List<DBObject> pipe = Arrays.asList(match, group2, project);
            Cursor db = collection.aggregate(pipe, ao);
            if (db.hasNext() && (dbo = (DBObject)db.next()).containsField("teamContainers")) {
                tcs = (List)dbo.get("teamContainers");
            }
            db.close();
        }
        catch (Exception e) {
            useLoop = true;
        }
        BasicDBObject group = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)BasicDBObject.parse((String)"{'$ifNull':['$jiraId',{'$ifNull':['$tfsId', {'$ifNull':['$kendisId',{'$toString':'$_id'}]} ]}]}")).append("jiraId", (Object)BasicDBObject.parse((String)"{'$first':'$jiraId'}")).append("tfsId", (Object)BasicDBObject.parse((String)"{'$first':'$tfsId'}")).append("items", (Object)BasicDBObject.parse((String)"{'$addToSet':{'teamContainers':'$teamContainers','sessionBoards':'$sessionBoards','solutionBoard':'$solutionBoard','batches':'$batches'}}")));
        List<DBObject> pipeline = Arrays.asList(match, group);
        Cursor db = collection.aggregate(pipeline, ao);
        ArrayList<DBObject> dbos = new ArrayList<DBObject>();
        while (db.hasNext()) {
            dbo = (DBObject)db.next();
            if (useLoop) {
                List docs = (List)dbo.get("items");
                for (DBObject doc : docs) {
                    List list;
                    if (!doc.containsField("teamContainers") || (list = (List)doc.get("teamContainers")) == null || list.size() <= 0) continue;
                    for (DBRef ref : list) {
                        tcs.add((ObjectId)ref.getId());
                    }
                }
            }
            dbos.add(dbo);
        }
        db.close();
        return Arrays.asList(dbos, tcs);
    }

    private List findItemBoardsWithLoop(String tenant, String fieldKey, Collection<String> keys, List<ObjectId> bids, ObjectId alm) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"sessionBoards.$id").in(bids), Criteria.where((String)"solutionBoard").exists(true).andOperator(new Criteria[]{Criteria.where((String)"almId").is((Object)String.valueOf(alm))})});
        query.addCriteria((CriteriaDefinition)criteria);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)fieldKey).in(keys));
        query.fields().include("_id");
        query.fields().include("jiraId");
        query.fields().include("tfsId");
        query.fields().include("solutionBoard");
        query.fields().include("sessionBoards");
        query.fields().include("teamContainers");
        query.fields().include("batches");
        DBCursor dbc = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class)).find(query.getQueryObject());
        List dbos = dbc.toArray();
        dbc.close();
        ArrayList<ObjectId> tcIds = new ArrayList<ObjectId>();
        for (DBObject dbo : dbos) {
            if (!dbo.containsField("teamContainers")) continue;
            List list = (List)dbo.get("teamContainers");
            for (DBRef ref : list) {
                tcIds.add((ObjectId)ref.getId());
            }
        }
        return Arrays.asList(dbos, tcIds);
    }

    public List<BacklogItem> saveBulkItems(ResyncParamsVO param, Collection<BacklogItem> itemsToSave, Map<String, Object> responseMap) {
        List subsetItems = Lists.partition(new ArrayList<BacklogItem>(itemsToSave), (int)100);
        for (List subset : subsetItems) {
            this.backlogItemRepository.save((Iterable)subset);
        }
        return null;
    }

    public void pushResyncUpdates(String progressType, String syncId, Map data, boolean hasPendingPush) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            String cid = null;
            JSONObject pushJson = new JSONObject();
            JSONObject metaMap = new JSONObject();
            metaMap.put("syncId", (Object)syncId);
            metaMap.put("event", (Object)progressType);
            pushJson.put("type", (Object)"Resync");
            pushJson.put("push", (Object)"Self");
            pushJson.put("data", data);
            metaMap.put("releaseTrainId", data.get("releaseTrainId"));
            metaMap.put("isJira", data.get("isJira"));
            cid = (String)data.get("cid");
            pushJson.put("metaMap", (Object)metaMap.toString());
            if (!PropertyValidator.isValid((Object)requestId)) {
                if (cid == null) {
                    PushSender.sendMsg((String)pushJson.toString());
                } else {
                    PushSender.sendMsg((String)cid, (String)pushJson.toString());
                }
            } else {
                PushResponse pr = new PushResponse();
                pr.setRequestId(requestId);
                pr.setResponseCompleted(Boolean.valueOf(!hasPendingPush));
                pr.setFileReferenceKey(UUID.randomUUID().toString());
                MongoSyncUtils.storeData((String)pr.getFileReferenceKey(), (String)pushJson.toString(), (AppConfig.MongoConfig)this.mongoConfig);
                pr.setContentType("JSON");
                this.pushResponseRepository.save((Object)pr);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public Map<String, Object> linkJiraBacklogItemsToBoard(String boardId, String artId, Collection<BacklogItem> backlogItems, String itemIds, String almId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Board board = this.boardRepository.findByIdOrKey(boardId, boardId);
        List<String> items = Arrays.asList(itemIds.split("\\s*,\\s*"));
        List existingItems = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId(items, almId);
        if (PropertyValidator.isValid((Collection)existingItems)) {
            for (BacklogItem item : existingItems) {
                BaseItemLink relation = (BaseItemLink)item.getArtRelationMap().get(artId);
                if (!PropertyValidator.isValid((Object)relation)) continue;
                backlogItems.add(item);
            }
        }
        if (PropertyValidator.isValid((Object)board) && PropertyValidator.isValid(backlogItems)) {
            for (BacklogItem backlogItem : backlogItems) {
                if (backlogItem.getArtRelationMap().get(artId) == null || !((BaseItemLink)backlogItem.getArtRelationMap().get(artId)).getBacklogLevel().equals(board.getLevel())) continue;
                if (!PropertyValidator.isValid((Collection)board.getLinkedBacklogItems())) {
                    board.setLinkedBacklogItems(new ArrayList());
                }
                if (board.getLinkedBacklogItems().contains(backlogItem.getId())) continue;
                board.getLinkedBacklogItems().add(backlogItem.getId());
            }
            result.put("board", this.boardRepository.save((Object)board));
        }
        return result;
    }

    public void setLevelMeta(Collection<String> artIds, ResyncParamsVO param, StringBuilder logs) {
        String almId = param.almConfigurations.getAlmAccount().getId();
        boolean debugMode = Boolean.TRUE.equals(param.almConfigurations.getAlmAccount().isDebug());
        param.levelMeta = new HashMap();
        List arts = new ArrayList();
        arts = artIds == null ? this.workSpaceRepository.findByLinkedAlmAccounts(almId) : this.workSpaceRepository.findByIdInAndLinkedAlmAccounts(artIds, almId);
        ArrayList<String> hIds = new ArrayList<String>();
        for (WorkSpace art : arts) {
            param.levelMeta.put(art.getId(), art.getLinkedAlmHierarchy());
            hIds.add(art.getLinkedAlmHierarchy());
        }
        List almLevelsMapping = this.almHierarchyLevelMappingRepository.findByAlmAccountId(almId);
        HashMap<String, AlmHierarchyLevelMapping> lvlMap = new HashMap<String, AlmHierarchyLevelMapping>();
        for (AlmHierarchyLevelMapping lvlMapping : almLevelsMapping) {
            lvlMap.put(lvlMapping.getId(), lvlMapping);
        }
        List hierarcies = this.backlogHierarchyRepository.findByIdIn(hIds);
        HashSet fieldIds = new HashSet();
        HashMap<String, Integer> hIndex = new HashMap<String, Integer>();
        for (int i = 0; i < hierarcies.size(); ++i) {
            hIndex.put(((BacklogHierarchy)hierarcies.get(i)).getId(), i);
        }
        for (WorkSpace art : arts) {
            String artId = art.getId();
            Integer i = (Integer)hIndex.get(param.levelMeta.get(artId));
            if (i <= -1 || i >= hierarcies.size()) continue;
            List levels = ((BacklogHierarchy)hierarcies.get(i)).getHierarchyLevels();
            HierarchyLevel prev = null;
            for (HierarchyLevel level : levels) {
                List mapping = level.getAlmHierarchyLevelMappings();
                for (AlmHierarchyLevelMapping m : mapping) {
                    AlmHierarchyLevelMapping mm = (AlmHierarchyLevelMapping)lvlMap.get(m.getId());
                    if (mm == null || !almId.equals(mm.getAlmAccountId())) continue;
                    param.levelMeta.put(artId + level.getLevel(), mm);
                    ArrayList<Integer> nums = (ArrayList<Integer>)param.levelMeta.get(artId + "levels");
                    if (nums == null) {
                        nums = new ArrayList<Integer>();
                    }
                    nums.add(level.getLevel());
                    param.levelMeta.put(artId + "levels", nums);
                    if (mm.getJiraFieldsIds() != null) {
                        fieldIds.addAll(mm.getJiraFieldsIds());
                    }
                    if (logs == null || !debugMode) continue;
                    logs.append("\nconfiguration ART " + artId + " level " + level.getLevel());
                    logs.append("\nissue types : ");
                    if (mm.getJiraIssueTypes() != null) {
                        for (JiraIssueType type : mm.getJiraIssueTypes()) {
                            logs.append(" [").append(type.getName()).append(" - ").append(type.getId()).append("],");
                        }
                    }
                    logs.append("\nlink types : ");
                    if (mm.getLinkTypes() == null) continue;
                    for (JiraIssueLinkType link : mm.getLinkTypes()) {
                        logs.append(" [").append(link.getName()).append(" - ").append(link.getId()).append("-").append(link.getDirection()).append("],");
                    }
                }
                if (prev != null) {
                    param.levelMeta.put(artId + level.getLevel() + "_prev", prev.getLevel());
                }
                prev = level;
            }
        }
        if (param.fields != null) {
            for (String key : fieldIds) {
                param.fields.add(new JiraField(key, key, key));
            }
        }
    }

    public Collection<BacklogItem> fetchJiraItems(ResyncParamsVO resyncParams) {
        Collection result = null;
        Gson gson = new Gson();
        HashMap<String, Serializable> responseMap = new HashMap<String, Serializable>();
        String almAccountId = resyncParams.almConfigurations.getAlmAccount().getId();
        String lockedKey = resyncParams.releaseTrainId + "_" + almAccountId;
        LOGGER.debug("started jira sync backlog : " + resyncParams.releaseTrainId);
        try {
            HashMap validationJson;
            this.customRepositoryImpl.checkIfSessionLockedWithTime(lockedKey, "Backlog sync", Long.valueOf(600000L));
            resyncParams.cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            resyncParams.user = UserContextUtil.getUserContext().getLoggedInUser();
            result = this.onJiraSync(false, resyncParams, responseMap);
            if (Boolean.TRUE.equals(responseMap.get("validate")) && (validationJson = this.almSyncService.validateAlmAccountUser(resyncParams.almConfigurations.getAlmAccount(), null)).containsKey("exception") && validationJson.containsKey("validationFailed")) {
                responseMap.put("error", Boolean.valueOf(true));
                Exception exp = (Exception)validationJson.get("exception");
                if (exp instanceof ViztrendJiraException) {
                    responseMap.put("almError", (Serializable)((ViztrendJiraException)((Object)exp)).getAlmError());
                } else {
                    responseMap.put("kendisError", exp);
                }
                responseMap.put("exception", (Serializable)validationJson.get("exception"));
                KendisUtils.onResyncError((String)resyncParams.syncId, null, (String)gson.toJson(responseMap), (String)resyncParams.getBoardId(), (PushResponseRepository)this.pushResponseRepository);
            }
        }
        catch (Exception e) {
            AlmAccount alm;
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            HashMap<String, Object> exp = new HashMap<String, Object>();
            if (resyncParams.filter != null) {
                exp.put("filterId", resyncParams.filter.getId());
            }
            if ((alm = resyncParams.almConfigurations.getAlmAccount()) != null) {
                exp.put("almAccountId", alm.getId());
            }
            exp.put("kendisError", e);
            if (e instanceof ViztrendJiraException) {
                exp.put("almError", ((ViztrendJiraException)((Object)e)).getAlmError());
            }
            responseMap.put("error", Boolean.valueOf(true));
            KendisUtils.onResyncError((String)resyncParams.syncId, null, (String)gson.toJson(exp), (String)resyncParams.getBoardId(), (PushResponseRepository)this.pushResponseRepository);
        }
        if (PropertyValidator.isValid((Collection)result)) {
            HashMap<String, String> added = new HashMap<String, String>();
            responseMap.put("added", added);
            for (BacklogItem backlogItem : result) {
                added.put(backlogItem.getAlmKey(), backlogItem.getUrl());
            }
        }
        responseMap.remove("items");
        responseMap.remove("items_updated");
        KendisUtils.onResyncComplete((String)resyncParams.syncId, null, (String)gson.toJson(responseMap), (Boolean)false, null, (String)resyncParams.getBoardId(), (PushResponseRepository)this.pushResponseRepository);
        this.customRepositoryImpl.removeSessionLock(lockedKey);
        LOGGER.debug("ended jira sync backlog : " + resyncParams.releaseTrainId);
        return result;
    }

    public Map<String, Object> unlinkBacklogItemFromTimeline(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String timelineId = (String)params.get("timelineId");
            List itemIds = (List)params.get("itemIds");
            Board timeline = (Board)this.boardRepository.findOne((Serializable)((Object)timelineId));
            if (PropertyValidator.isValid((Object)timeline) && PropertyValidator.isValid((Collection)itemIds)) {
                timeline.getLinkedBacklogItems().removeIf(itemIds::contains);
                this.boardRepository.save((Object)timeline);
                result.put("success", true);
                result.put("timeline", timeline);
                return result;
            }
            result.put("success", false);
            return result;
        }
        catch (Exception e) {
            result.put("error", true);
            return result;
        }
    }

    public void onJiraSyncWhbhook(String cid, List<JiraIssue2> issues, Set<String> jiraIds, AlmAccount almAccount, String event) throws Exception {
        boolean linking = "issuelink_created".equals(event);
        int startAt = 0;
        int pageSize = 2;
        int totalRecord = 0;
        int totalSaved = 0;
        boolean alreadyFetched = false;
        Gson gson = new Gson();
        HashSet<String> keys = new HashSet<String>();
        HashSet<String> artIds = new HashSet<String>();
        JiraIssueLinkType epicLink = new JiraIssueLinkType("+1", "", almAccount.getJiraEpicLinkLabel(), almAccount.getJiraEpicLinkLabel(), almAccount.getJiraEpicLinkLabel(), "UP");
        List backlogVOs = this.customRepositoryImpl.findBacklogItemsAlmIds(null, jiraIds, null, almAccount.getId(), false, almAccount.getTenant());
        ResyncParamsVO webhook = new ResyncParamsVO();
        webhook.isAlmBacklog = true;
        webhook.cid = cid;
        webhook.syncId = null;
        webhook.almConfigurations = new AlmConfigurations();
        webhook.filter = new JiraFilter();
        webhook.projects = new HashMap();
        webhook.backlogSatuses = new HashMap();
        webhook.backlogAlmIds = new HashMap();
        webhook.backlog = new HashMap();
        webhook.backlogParentId = new HashMap();
        webhook.backlogOldParent = new HashMap();
        webhook.isWebhook = true;
        String jql = "ID in (" + String.join((CharSequence)",", jiraIds) + ")";
        if (!PropertyValidator.isValid((Collection)backlogVOs)) {
            return;
        }
        webhook.restBacklogItems();
        HashMap<String, BacklogItemVO> bMap = new HashMap<String, BacklogItemVO>();
        for (BacklogItemVO vo : backlogVOs) {
            String id = vo.getId();
            Map arts = vo.getArtRelationMap();
            if (arts != null) {
                vo.artIds = new HashSet();
                for (String artId : arts.keySet()) {
                    artIds.add(artId);
                    vo.artIds.add(artId);
                    if (webhook.backlogParentId.get(artId) == null) {
                        webhook.backlogParentId.put(artId, new HashMap());
                    }
                    if (webhook.backlogOldParent.get(artId) != null) continue;
                    webhook.backlogOldParent.put(artId, new HashMap());
                }
            }
            webhook.backlogAlmIds.put(vo.getAlmItemId(), id);
            webhook.backlogAlmIds.put(vo.getAlmKey(), id);
            webhook.backlogAlmIds.put(id, vo.getAlmItemId());
            webhook.backlogAlmIds.put(id + "_key", vo.getAlmKey());
            bMap.put(vo.getAlmItemId(), vo);
        }
        if (!PropertyValidator.isValid(artIds)) {
            return;
        }
        this.almSyncService.setupMetaForResync(webhook, almAccount);
        this.setLevelMeta(artIds, webhook, null);
        if (PropertyValidator.isValid(issues)) {
            alreadyFetched = true;
            totalRecord = issues.size();
        }
        ArrayList<Status> statuses = null;
        boolean anyData = false;
        boolean isLast = false;
        boolean isCloud = almAccount.cloud();
        String nextPageToken = null;
        do {
            JiraSearch2 result = null;
            if (alreadyFetched) {
                isLast = true;
                startAt = totalRecord;
            } else {
                result = this.importUtil.retrievePagedJiraDataAgainstFilter2(almAccount.getUrl(), jql, almAccount.getUsername(), almAccount.getPassword(), nextPageToken, startAt, pageSize, gson, webhook.fields, almAccount);
                nextPageToken = result.getNextPageToken();
                if (!isCloud) {
                    startAt += pageSize;
                    if (result.getTotal() != null) {
                        totalRecord = result.getTotal();
                    }
                }
                isLast = result.ended(isCloud, startAt, totalRecord);
            }
            boolean parseIssues = false;
            if (PropertyValidator.isValid(result) && PropertyValidator.isValid((Collection)result.getIssues())) {
                issues = result.getIssues();
                parseIssues = true;
                startAt += pageSize;
                if (issues != null) {
                    totalRecord += issues.size();
                }
            } else if (alreadyFetched) {
                parseIssues = true;
            }
            if (!PropertyValidator.isValid((Object)parseIssues) || issues == null) continue;
            for (JiraIssue2 issue : issues) {
                BacklogItemVO vo = (BacklogItemVO)bMap.get(issue.getId());
                webhook.putBacklogItem(vo == null ? null : vo.getId(), issue, webhook.parentLevel, almAccount, this.customRepositoryImpl);
                anyData = true;
                BacklogItem item = webhook.getBacklogItem(issue.getId());
                Status status = this.getKendisStatus(issue, webhook);
                if (status != null) {
                    item.setStatus(status);
                    if (statuses == null) {
                        statuses = new ArrayList<Status>();
                    }
                    statuses.add(status);
                }
                if (linking) {
                    block4: for (String artId : artIds) {
                        List nums = (List)webhook.levelMeta.get(artId + "levels");
                        if (nums == null) continue;
                        for (Integer level : nums) {
                            Integer prevL = (Integer)webhook.levelMeta.get(artId + level + "_prev");
                            AlmHierarchyLevelMapping m = (AlmHierarchyLevelMapping)webhook.levelMeta.get(artId + level);
                            AlmHierarchyLevelMapping mm = (AlmHierarchyLevelMapping)webhook.levelMeta.get(artId + prevL);
                            if (!m.hasIssueType(issue.issueTypeId()) || mm == null || mm == null || !PropertyValidator.isValid((Collection)mm.getLinkTypes())) continue;
                            ArrayList<BacklogMappingLinks> parentLinkMappings = new ArrayList<BacklogMappingLinks>();
                            parentLinkMappings.add(new BacklogMappingLinks(mm.getLinkTypes(), mm.getJiraIssueTypes()));
                            String projectKey = issue.projectKey();
                            List parentId = webhook.processForParent(projectKey, (Map)issue.getFields(), issue.issuelinks(), parentLinkMappings, null);
                            if (parentId == null || parentId.size() <= 0) continue;
                            item.linkToRTE(artId, level).setTenant(almAccount.getTenant());
                            if (vo != null) {
                                if (vo.artIds == null) {
                                    vo.artIds = new HashSet();
                                }
                                vo.artIds.add(artId);
                            }
                            ((Map)webhook.backlogParentId.get(artId)).put(issue.getId(), parentId.get(0));
                            for (String pid : parentId) {
                                if (bMap.get(pid) == null) continue;
                                ((Map)webhook.backlogParentId.get(artId)).put(issue.getId(), pid);
                            }
                            continue block4;
                        }
                    }
                }
                keys.add(issue.getKey());
                ++totalSaved;
            }
        } while (!isLast);
        HashMap push = webhook.pushData(keys, artIds);
        if (anyData) {
            this.customRepositoryImpl.savePartialBacklog(null, artIds, webhook.parentLevel, null, Integer.valueOf(totalSaved), Integer.valueOf(totalRecord), backlogVOs, keys, webhook, almAccount);
            if (linking) {
                Iterator parseIssues = artIds.iterator();
                while (parseIssues.hasNext()) {
                    String artId;
                    webhook.releaseTrainId = artId = (String)parseIssues.next();
                    if (!linking) continue;
                    this.customRepositoryImpl.savePartialParentChildInBacklog(webhook, almAccount.getTenant());
                }
            }
            webhook.releaseTrainId = "isJira";
            if (PropertyValidator.isValid(statuses)) {
                Map statusMap = webhook.convertStatusListToMap(statuses, webhook.almConfigurations.getAlmAccount().getId(), null);
                push.put("releaseTrainId", webhook.releaseTrainId);
                push.put("partialSyncing", "update");
                this.customRepositoryImpl.savePartialSatusInBacklog(push, webhook, statusMap);
            }
        }
    }

    public Collection<BacklogItem> onJiraSync(boolean viaWebhook, ResyncParamsVO resyncParams, Map<String, Object> responseMap) throws Exception {
        AlmAccount almAccount = null;
        String almId = "";
        ArrayList<BacklogItem> miniSet1 = new ArrayList<BacklogItem>();
        boolean alreadyFetched = false;
        try {
            int i;
            StringBuilder upLevelParenIds = new StringBuilder();
            resyncParams.isAlmBacklog = true;
            if (resyncParams.filter != null && resyncParams.filter.getFilterFetchedBy() != null) {
                resyncParams.filter.setFilterFetchedBy(this.userRepository.findById(resyncParams.filter.getFilterFetchedBy().getId()));
            }
            if (viaWebhook) {
                alreadyFetched = true;
                almAccount = resyncParams.almConfigurations.getAlmAccount();
            } else {
                almAccount = this.almAccountRepository.findById(resyncParams.almConfigurations.getAlmAccount().getId());
                this.almSyncServiceImpl.setupMetaForResync(resyncParams, almAccount);
                StringBuilder logs = new StringBuilder();
                this.setLevelMeta((Collection)new /* Unavailable Anonymous Inner Class!! */, resyncParams, logs);
                LOGGER.debug(logs.toString());
                resyncParams.backlog = new HashMap();
                resyncParams.projects = new HashMap();
                resyncParams.parentKeys = new HashSet();
                resyncParams.backlogSatuses = new HashMap();
                resyncParams.backlogAlmIds = new HashMap();
            }
            resyncParams.jiraIssuesParent = null;
            resyncParams.jiraIssuesChild = null;
            resyncParams.backlogOldParent = new HashMap();
            resyncParams.backlogParentId = new HashMap();
            resyncParams.backlogParentId.put(resyncParams.releaseTrainId, new HashMap());
            resyncParams.backlogOldParent.put(resyncParams.releaseTrainId, new HashMap());
            almId = almAccount.getId();
            List levels = (List)resyncParams.levelMeta.get(resyncParams.releaseTrainId + "levels");
            if (levels == null) {
                throw new Exception("Invalid Hierarchy");
            }
            Integer start = (Integer)levels.get(0);
            Integer end = (Integer)levels.get(levels.size() - 1);
            Map statusMap = new HashMap();
            int currentLevelIndex = 0;
            if (PropertyValidator.isValid((Object)resyncParams.backlogLevel)) {
                currentLevelIndex = resyncParams.backlogLevel;
            }
            Integer init = null;
            if (!viaWebhook) {
                this.customRepositoryImpl.savePartialSyncFlag(resyncParams.releaseTrainId, "1", "items");
            }
            LinkedList<StringBuilder> jqls = new LinkedList<StringBuilder>();
            AlmHierarchyLevelMapping upLevel = null;
            for (i = 0; i < levels.size(); ++i) {
                AlmHierarchyLevelMapping lvl;
                if (init == null && currentLevelIndex == (Integer)levels.get(i)) {
                    init = i;
                }
                if (init == null) continue;
                resyncParams.parentLevel = (Integer)levels.get(i);
                resyncParams.childLevel = null;
                String nextLevelJQL = null;
                AlmHierarchyLevelMapping downLevel = (AlmHierarchyLevelMapping)resyncParams.levelMeta.get(resyncParams.releaseTrainId + resyncParams.parentLevel);
                if (upLevel == null && currentLevelIndex > start && currentLevelIndex == resyncParams.parentLevel) {
                    upLevel = (AlmHierarchyLevelMapping)resyncParams.levelMeta.get(resyncParams.releaseTrainId + levels.get(i - 1));
                }
                if (i + 1 < levels.size() && (lvl = (AlmHierarchyLevelMapping)resyncParams.levelMeta.get(resyncParams.releaseTrainId + levels.get(i + 1))) != null && lvl.getJiraIssueTypesJQL() != null) {
                    nextLevelJQL = lvl.getJiraIssueTypesJQL();
                }
                resyncParams.parentLevelJQL = downLevel.getJiraIssueTypesJQL();
                if (!alreadyFetched) {
                    StringBuilder fql = new StringBuilder(resyncParams.filter.getJql());
                    if (PropertyValidator.isValid((Object)resyncParams.filter.getId()) && PropertyValidator.isValid((Object)resyncParams.parentLevelJQL)) {
                        fql = Boolean.TRUE.equals(resyncParams.filter.getCustom()) ? new StringBuilder().append(resyncParams.parentLevelJQL).append(" AND ").append(resyncParams.filter.getJql()) : new StringBuilder().append("filter = ").append(resyncParams.filter.getId()).append(" AND ").append(resyncParams.parentLevelJQL);
                    }
                    if (fql.length() > 0) {
                        jqls.push(fql);
                    }
                }
                this.fetchParentChildData(1, nextLevelJQL, jqls, resyncParams, almAccount, downLevel, upLevel, upLevel == null ? null : upLevelParenIds, responseMap);
                upLevel = downLevel;
                alreadyFetched = true;
                if (!viaWebhook) continue;
            }
            resyncParams.parentLevel = null;
            resyncParams.parentLevelJQL = null;
            resyncParams.childLevelJQL = null;
            this.fetchParentChildData(0, null, jqls, resyncParams, almAccount, null, upLevel, null, responseMap);
            try {
                jqls = new LinkedList();
                for (i = init - 1; i > -1; --i) {
                    resyncParams.parentLevel = (Integer)levels.get(i);
                    resyncParams.childLevel = null;
                    AlmHierarchyLevelMapping up = null;
                    if (i - 1 > -1) {
                        up = (AlmHierarchyLevelMapping)resyncParams.levelMeta.get(resyncParams.releaseTrainId + levels.get(i - 1));
                    }
                    if (PropertyValidator.isValid((Object)upLevelParenIds) && upLevelParenIds.length() > 0) {
                        resyncParams.byPassChildSave = true;
                        resyncParams.parentKeys = new HashSet();
                        StringBuilder pids = new StringBuilder();
                        jqls = new LinkedList();
                        jqls.push(new StringBuilder().append("ID in (").append(upLevelParenIds.toString()).append(")"));
                        this.fetchParentChildData(-1, null, jqls, resyncParams, almAccount, null, up, pids, responseMap);
                        upLevelParenIds = pids;
                    }
                    if (!viaWebhook) continue;
                }
            }
            catch (Exception e) {
                LOGGER.error("problem in down to up in Hierarchy............ " + StringUtils.getTraceString((Throwable)e));
            }
            if (!viaWebhook) {
                if (PropertyValidator.isValid((Object)resyncParams.projects) && !(statusMap = this.syncJiraStatuses(resyncParams, false)).isEmpty()) {
                    this.customRepositoryImpl.savePartialSyncFlag(resyncParams.releaseTrainId, "2", "items' status");
                    this.customRepositoryImpl.savePartialSatusInBacklog(null, resyncParams, statusMap);
                }
                this.customRepositoryImpl.savePartialSyncFlag(resyncParams.releaseTrainId, "3", "links in hierarchy");
            }
            this.customRepositoryImpl.savePartialParentChildInBacklog(resyncParams, almAccount.getTenant());
            this.customRepositoryImpl.removePartialParentChildInBacklog(resyncParams);
            if (!viaWebhook) {
                this.customRepositoryImpl.savePartialSyncFlag(resyncParams.releaseTrainId, "4", "board tags");
                this.addBoardsInMap(almAccount.getTenant(), resyncParams.backlogAlmIds.keySet(), resyncParams);
                this.customRepositoryImpl.savePartialSyncFlag(resyncParams.releaseTrainId, null, null);
            }
        }
        catch (Exception e) {
            if (!viaWebhook) {
                this.customRepositoryImpl.savePartialSyncFlag(resyncParams.releaseTrainId, "error", new Gson().toJson((Object)e));
            }
            throw e;
        }
        return miniSet1;
    }

    private Status getKendisStatus(JiraIssue2 jIssue, ResyncParamsVO resyncParams) {
        Status status = null;
        String sid = jIssue.statusId();
        if (!PropertyValidator.isValid((Object)sid)) {
            return null;
        }
        AlmAccount alm = resyncParams.almConfigurations.getAlmAccount();
        status = this.statusRepository.findByJiraProjKeyAndJiraIssueTypeIdAndJiraStatusIdAndTenantAndArchiveAndAlmId(jIssue.projectKey(), jIssue.issueTypeId(), sid, alm.getTenant(), Boolean.valueOf(false), alm.getId());
        if (status == null) {
            LOGGER.debug("getKendisStatus --> It seems we have pulled a new project. Lets go fetch statuses");
            status = new Status();
            status.setSuspendActivity(true);
            status.setJiraProjKey(jIssue.projectKey());
            status.setJiraIssueTypeId(jIssue.issueTypeId());
            status.setJiraStatusCatId(jIssue.statusCategory("id").replace(".0", ""));
            status.setJiraStatusId(jIssue.statusId());
            status.setTitle(jIssue.status());
            status.setCategory(AlmUtils.getMappedStatusCategory((String)jIssue.statusCategory("key")));
            status.setSyncRequired(Boolean.valueOf(true));
            status.setTenant(alm.getTenant());
            status.setAlmId(alm.getId());
            this.statusRepository.save((Object)status);
        }
        return status;
    }

    public Map<String, Status> syncJiraStatuses(ResyncParamsVO resyncParams, boolean statusOnly) {
        HashMap<String, Status> statusMap = new HashMap();
        HashMap projectMap = new HashMap();
        ArrayList jiraStatuses = new ArrayList();
        AlmAccount almAccount = resyncParams.almConfigurations.getAlmAccount();
        Set pKeys = resyncParams.projects.keySet();
        String groupId = almAccount.getId();
        if (resyncParams.isAlmBacklog) {
            jiraStatuses.addAll(this.statusRepository.findByJiraProjKeyInAndAlmId(pKeys, almAccount.getId()));
        } else {
            groupId = resyncParams.session.getId();
            jiraStatuses.addAll(this.statusRepository.findByJiraProjKeyInAndSessionId(pKeys, resyncParams.session.getId()));
        }
        statusMap = resyncParams.convertStatusListToMap(jiraStatuses, groupId, projectMap);
        ArrayList statuses = new ArrayList();
        for (Object prjKey : pKeys) {
            List issueTypes = this.importUtil.retrieveJiraStatuses((String)prjKey, almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
            statuses.addAll(resyncParams.processJiraStatuses((String)prjKey, almAccount, groupId, statusMap, true, issueTypes, this.statusRepository));
        }
        List subSetsStatuses = Lists.partition(new ArrayList(statuses), (int)100);
        for (List subSetStatuses : subSetsStatuses) {
            this.statusRepository.save((Iterable)subSetStatuses);
        }
        if (statusOnly) {
            return statusMap;
        }
        List pList = this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndJiraProjectKeyInAndFromBacklogIsTrue(almAccount.getId(), pKeys);
        for (JiraProjectIssueTypes jp : pList) {
            resyncParams.projects.remove(jp.getJiraKey());
        }
        this.jiraProjectIssueTypesRepository.save(resyncParams.projects.values());
        return statusMap;
    }

    public void fetchParentChildData(int direction, String nextLevelJQL, LinkedList<StringBuilder> jqls, ResyncParamsVO syncUtil, AlmAccount almAccount, AlmHierarchyLevelMapping downLevel, AlmHierarchyLevelMapping upLevel, StringBuilder upLevelParenIds, Map<String, Object> responseMap) throws Exception {
        almAccount = syncUtil.almConfigurations.getAlmAccount();
        boolean debugMode = Boolean.TRUE.equals(almAccount.isDebug());
        boolean isCloud = almAccount.cloud();
        JiraIssueLinkType epicLink = new JiraIssueLinkType("+1", "", almAccount.getJiraEpicLinkLabel(), almAccount.getJiraEpicLinkLabel(), almAccount.getJiraEpicLinkLabel(), "UP");
        HashSet parentFields = new HashSet();
        HashSet linkedIds = new HashSet();
        HashSet epicIds = new HashSet();
        HashSet parentLinkIds = new HashSet();
        HashMap epicKeys = new HashMap();
        HashMap ngParentMap = new HashMap();
        ArrayList<BacklogMappingLinks> childLinkMappings = new ArrayList<BacklogMappingLinks>();
        if (downLevel != null && PropertyValidator.isValid((Collection)downLevel.getLinkTypes())) {
            childLinkMappings.add(new BacklogMappingLinks(downLevel.getLinkTypes()));
        }
        ArrayList<BacklogMappingLinks> parentLinkMappings = null;
        if (upLevel != null && PropertyValidator.isValid((Collection)upLevel.getLinkTypes())) {
            parentLinkMappings = new ArrayList<BacklogMappingLinks>();
            parentLinkMappings.add(new BacklogMappingLinks(upLevel.getLinkTypes(), upLevel.getJiraIssueTypes()));
            List parentLinks = upLevel.getLinkTypes();
            for (JiraIssueLinkType link : parentLinks) {
                if (!link.getId().startsWith("customfield_")) continue;
                syncUtil.fields.add(new JiraField(link.getId(), link.getId(), link.getId()));
            }
        }
        JiraSearch2 result = new JiraSearch2();
        result.setNextPageToken(null);
        Map parentIdsMap = (Map)syncUtil.backlogParentId.get(syncUtil.releaseTrainId);
        while (!jqls.isEmpty()) {
            Gson gson = new Gson();
            String jql = jqls.pop().toString();
            int startAt = 0;
            int pageSize = 100;
            int totalRecord = 0;
            int totalSaved = 0;
            LOGGER.debug("jql at  ART [" + syncUtil.releaseTrainId + "] level " + syncUtil.parentLevel + " : " + jql);
            do {
                result = this.importUtil.retrievePagedJiraDataAgainstFilter2(almAccount.getUrl(), jql, almAccount.getUsername(), almAccount.getPassword(), result.getNextPageToken(), startAt, pageSize, gson, syncUtil.fields, almAccount);
                if (!isCloud) {
                    startAt += pageSize;
                    if (result.getTotal() != null) {
                        totalRecord = result.getTotal();
                    }
                }
                if (PropertyValidator.isValid((Object)result) && !PropertyValidator.isValid((Collection)result.getIssues()) && PropertyValidator.isValid((Collection)result.getWarningMessages())) {
                    responseMap.put("error", true);
                    responseMap.put("validate", true);
                    if (syncUtil.syncId != null) {
                        KendisUtils.onResyncError((String)syncUtil.syncId, null, (String)gson.toJson((Object)result), (String)syncUtil.getBoardId(), (PushResponseRepository)this.pushResponseRepository);
                    }
                }
                List jIssues2 = result.getIssues();
                HashSet<String> keys = new HashSet<String>();
                if (jIssues2 == null) continue;
                syncUtil.restBacklogItems();
                for (JiraIssue2 jiraIssue : jIssues2) {
                    List parentId;
                    StringBuilder logs = null;
                    if (debugMode) {
                        logs = new StringBuilder();
                        logs.append("\n[" + jiraIssue.getKey() + "] child links started.......................................");
                    }
                    syncUtil.putBacklogItem(null, jiraIssue, syncUtil.parentLevel, almAccount, this.customRepositoryImpl);
                    keys.add(jiraIssue.getKey());
                    ++totalSaved;
                    String projectKey = jiraIssue.projectKey();
                    if (syncUtil.parentLevel != null) {
                        syncUtil.processForChildren(jiraIssue.getKey(), jiraIssue.getId(), projectKey, jiraIssue.issuelinks(), almAccount, epicLink, childLinkMappings, epicIds, linkedIds, parentLinkIds, parentFields, null, ngParentMap, epicKeys, logs, this.importUtil);
                    }
                    if (parentLinkMappings != null && (parentId = syncUtil.processForParent(projectKey, (Map)jiraIssue.getFields(), jiraIssue.issuelinks(), parentLinkMappings, null)) != null && parentId.size() > 0 && PropertyValidator.isValid(parentId.get(0))) {
                        if (parentIdsMap.get(jiraIssue.getId()) == null) {
                            parentIdsMap.put(jiraIssue.getId(), parentId.get(0));
                        }
                        if (upLevelParenIds != null && upLevel != null) {
                            if (upLevelParenIds.length() > 0) {
                                upLevelParenIds.append(",");
                            }
                            upLevelParenIds.append((String)parentId.get(0));
                        }
                    }
                    if (!debugMode) continue;
                    logs.append("\n[" + jiraIssue.getKey() + "] child links ended.......................................");
                    LOGGER.debug("\n" + logs.toString());
                }
                LOGGER.debug("resoponse fetched at ART level " + syncUtil.parentLevel + " : " + ((Object)keys).toString());
                this.customRepositoryImpl.savePartialBacklog(Integer.valueOf(direction), null, syncUtil.parentLevel, null, Integer.valueOf(totalSaved), Integer.valueOf(totalRecord), null, keys, syncUtil, almAccount);
            } while (!result.ended(isCloud, startAt, totalRecord));
        }
        syncUtil.setChildQueries(nextLevelJQL, jqls, epicIds, linkedIds, parentLinkIds, parentFields);
    }

    public void syncWithBoards(String tenant, Item item) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public void syncWithBoards(String tenant, SessionBoard board, Set<String> ids) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public void syncWithBoards(String tenant, AlmAccount alm, Collection<String> ids) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public List<JiraProjectIssueTypes> fetchLinkedJiraProjects(AlmAccount almAccount) {
        List jiraProjects = this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndFromBacklogIsTrue(almAccount.getId());
        return jiraProjects;
    }

    public Map<String, Object> saveJiraProject(String payload) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)payload)) {
                Gson g = new Gson();
                7 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
                String projectKey = (String)requestBody.get("projectKey");
                AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)((String)requestBody.get("almAccountId"))));
                this.almSyncService.retrieveJiraProjectFields(almAccount, projectKey, Boolean.valueOf(true), Boolean.valueOf(true));
                ArrayList<String> projectKeys = new ArrayList<String>();
                projectKeys.add(projectKey);
                this.fetchJiraIssueTypes(almAccount.getId(), projectKeys, result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Map<String, Object> removeJiraProject(String payload) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)payload)) {
                Gson g = new Gson();
                8 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
                String projectKey = (String)requestBody.get("projectKey");
                String almAccountId = (String)requestBody.get("almAccountId");
                String projectId = (String)requestBody.get("projectId");
                Query query = new Query();
                Criteria criteria = new Criteria();
                criteria.and("almFields.project.id").is((Object)projectId);
                query.addCriteria((CriteriaDefinition)criteria);
                int itemCount = this.mongoTemplate.getCollection("backlogItem").find(query.getQueryObject()).count();
                if (itemCount == 0) {
                    this.jiraProjectIssueTypesRepository.deleteByAlmAccountIdAndJiraProjectIdAndFromBacklogIsTrue(almAccountId, projectId);
                    result.put("success", true);
                } else {
                    result.put("success", false);
                    result.put("errorMsg", "item exist for the project");
                }
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("errorMsg", e.getMessage());
        }
        return result;
    }

    public void fetchJiraIssueTypes(String almAccountId, List<String> projectKeys, HashMap<String, Object> responseJson) {
        if (PropertyValidator.isValid(projectKeys)) {
            List jiraProjectIssueTypes = this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndJiraProjectKeyIn(almAccountId, projectKeys);
            for (JiraProjectIssueTypes jpType : jiraProjectIssueTypes) {
                if (!PropertyValidator.isValid((Object)jpType.getIssueTypesReference())) continue;
                jpType.setIssueTypes(MongoSyncUtils.retrieveData((String)jpType.getIssueTypesReference(), (AppConfig.MongoConfig)this.mongoConfig));
            }
            responseJson.put("jiraProjectIssueTypes", jiraProjectIssueTypes);
        }
    }

    public Map<String, Object> saveJiraFilter(ResyncParamsVO resyncParams) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)resyncParams)) {
                JiraFilter filter = resyncParams.filter;
                filter.setFilterFetchedBy(UserContextUtil.getUserContext().getLoggedInUser());
                if (filter.getCreatedOn() == null) {
                    filter.setCreatedOn(new Date());
                }
                filter.setUpdatedOn(new Date());
                String releaseTrainId = resyncParams.releaseTrainId;
                WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
                ALMFilter almFilter = new ALMFilter();
                almFilter.setBacklogLevel(resyncParams.parentLevel);
                almFilter.setJiraFilter(filter);
                almFilter.setAlmAccount(new AlmAccount(resyncParams.almConfigurations.getAlmAccount().getId()));
                if (PropertyValidator.isValid((Object)workSpace)) {
                    if (workSpace.getAlmFilters() == null) {
                        workSpace.setAlmFilters(new ArrayList());
                    }
                    workSpace.getAlmFilters().add(almFilter);
                    this.workSpaceRepository.save((Object)workSpace);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getJiraMeta(String payload) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)payload)) {
                Gson g = new Gson();
                9 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
                AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)((String)requestBody.get("almAccountId"))));
                result.put("jiraMeta", this.fetchJiraIssueMeta(almAccount));
                result.put("success", true);
            }
        }
        catch (ViztrendJiraException e) {
            result.put("success", false);
            result.put("viztrend", true);
            result.put("error", (Object)e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> searchExistingBackLogJiraItems(String ids, String almId, String releaseTrainId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List<String> itemIds = Arrays.asList(ids.split("\\s*,\\s*"));
        List existingItems = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId(itemIds, almId);
        ArrayList<BacklogItem> alreadyExist = new ArrayList<BacklogItem>();
        if (PropertyValidator.isValid((Collection)existingItems)) {
            for (BacklogItem item : existingItems) {
                BaseItemLink relation = (BaseItemLink)item.getArtRelationMap().get(releaseTrainId);
                if (!PropertyValidator.isValid((Object)relation)) continue;
                alreadyExist.add(item);
            }
        }
        if (PropertyValidator.isValid(alreadyExist)) {
            response.put("success", false);
            response.put("reason", "AlreadyExist");
            response.put("items", existingItems);
        } else {
            response.put("success", true);
        }
        return response;
    }

    public Map<String, Object> savejiraFields(String almId, String releaseTrainId, HashMap<String, Object> requestBody) throws Exception {
        List hierarchyLevels;
        List mappings;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List selectedFields = (List)requestBody.get("selectedFields");
        List unSelectedFields = (List)requestBody.get("unSelectedFields");
        WorkSpace workspace = this.workSpaceRepository.findByIdOrKey(releaseTrainId, releaseTrainId);
        if (PropertyValidator.isValid((Object)workspace) && PropertyValidator.isValid((Collection)(mappings = this.getAlmHierarchyLevelMapping(hierarchyLevels = this.getHierarchyLevels(workspace), almId)))) {
            for (AlmHierarchyLevelMapping level : mappings) {
                level.setJiraFields(selectedFields);
                level.setJiraFieldsIds(new HashSet());
                for (Map field : selectedFields) {
                    level.getJiraFieldsIds().add((String)field.get("id"));
                }
            }
            this.almHierarchyLevelMappingRepository.save((Iterable)mappings);
            result.put("levels", hierarchyLevels);
        }
        if (PropertyValidator.isValid((Object)workspace.getBacklogSettingsMap()) && PropertyValidator.isValid((Collection)unSelectedFields) && !unSelectedFields.isEmpty()) {
            HashMap backlogSettingsMap = workspace.getBacklogSettingsMap();
            for (BacklogSettings backlogSettings : backlogSettingsMap.values()) {
                if (PropertyValidator.isValid((Collection)backlogSettings.getBackLogItemsColumns())) {
                    List backlogItemColumns = backlogSettings.getBackLogItemsColumns();
                    backlogItemColumns.removeAll(unSelectedFields);
                }
                if (!PropertyValidator.isValid((Collection)backlogSettings.getDefaultJiraFields())) continue;
                List defaultJiraFields = backlogSettings.getDefaultJiraFields();
                defaultJiraFields.removeAll(unSelectedFields);
            }
            this.workSpaceRepository.save((Object)workspace);
        }
        return result;
    }

    public Map<String, Object> getAllJiraFields(String almId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
        result.put("jiraFields", this.almSyncService.retrieveJiraFieldsJSON(almAccount, false));
        return result;
    }

    public void unlinkItemsReursively(List<String> itemIds) {
        List subSetsOfItemIds = Lists.partition(new ArrayList<String>(itemIds), (int)100);
        ArrayList childIds = new ArrayList();
        for (List subSetOfItemIds : subSetsOfItemIds) {
            List items = this.backlogItemRepository.findByIdIn((Collection)subSetOfItemIds);
            for (BacklogItem item : items) {
                Set artIds = item.getChildRelationMap().keySet();
                for (String artId : artIds) {
                    item.getArtRelationMap().remove(artId);
                    item.fillChildrenIds(childIds, (List)item.getChildRelationMap().get(artId));
                }
            }
            this.backlogItemRepository.save((Iterable)items);
        }
        if (PropertyValidator.isValid(childIds)) {
            this.unlinkItemsReursively(childIds);
        }
    }

    public void unlinkBacklogItemFromPi(Item item, boolean delete) {
        try {
            BacklogItem backlogItem = this.backlogItemRepository.findById(item.getKendisId());
            ArrayList removedBoardIds = new ArrayList();
            ArrayList removedArtIds = new ArrayList();
            backlogItem.removeBoardLink(((SessionBoard)item.getSessionBoards().get(0)).getId(), ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId(), removedArtIds, removedBoardIds);
            if (delete) {
                ArrayList childIds = new ArrayList();
                Set artIds = backlogItem.getChildRelationMap().keySet();
                for (String artId : artIds) {
                    backlogItem.getArtRelationMap().remove(artId);
                    backlogItem.fillChildrenIds(childIds, (List)backlogItem.getChildRelationMap().get(artId));
                }
                this.unlinkItemsReursively(childIds);
            }
            this.backlogItemRepository.save((Object)backlogItem);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(backlogItem.getId());
            this.unlinkBacklogItemFromPi(backlogItem.getTenant(), true, ids, removedArtIds, removedBoardIds);
        }
        catch (Exception e) {
            LOGGER.error("DEV-10253 unlinking Backlog Item from Pi Board");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void unlinkBacklogItemFromPi(String tenant, boolean removeId, List<String> backlogItemIds, List<String> artIds, List<String> remvedBoardLinks) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"kendisId").in(backlogItemIds));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            if (remvedBoardLinks != null && PropertyValidator.isValid(remvedBoardLinks)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in((Collection)KendisUtils.getListAsObjectIds(remvedBoardLinks)));
            }
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"fields.artRelationMap").exists(true));
            Update update = new Update();
            if (removeId) {
                update.unset("kendisId");
            }
            for (String artId : artIds) {
                update.unset("fields.artRelationMap." + artId);
            }
            this.mongoTemplate.updateMulti(query, update, Item.class);
        }
        catch (Exception e) {
            LOGGER.error("DEV-10253 unlinking Backlog Item from Pi Board");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void saveBacklogItemToPi(String artId, BacklogItem backlogItem, Map<String, Boolean> skipBoards) {
        try {
            if (backlogItem.getKendisKey() != null && backlogItem.getAlmAccountId() == null && PropertyValidator.isValid((Collection)backlogItem.getBoardRelations())) {
                String cKey = "_" + Item.Type.UserStory.name();
                HashSet<String> ids = new HashSet<String>();
                HashSet<String> childIds = new HashSet<String>();
                BacklogItem parent = null;
                HashMap kendisOnly = new HashMap();
                HashMap kendisChild = new HashMap();
                HashMap<Object, String> sessionIdMap = new HashMap<Object, String>();
                HashSet<Object> boardIds = new HashSet<Object>();
                HashSet<ObjectId> sessionIds = new HashSet<ObjectId>();
                for (BaseItemLink link : backlogItem.getBoardRelations()) {
                    sessionIds.add(new ObjectId(link.getSessionId()));
                }
                Query query = new Query();
                query.fields().include("_id");
                query.fields().include("activeSessionBoard");
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(sessionIds));
                DBCursor cursor = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class)).find(query.getQueryObject());
                while (cursor.hasNext()) {
                    DBObject dbo = cursor.next();
                    if (!PropertyValidator.isValid((Object)dbo) || !dbo.containsField("activeSessionBoard")) continue;
                    String bid = (String)dbo.get("activeSessionBoard");
                    sessionIdMap.put(bid, String.valueOf(dbo.get("_id")));
                    if (skipBoards != null && Boolean.TRUE.equals(skipBoards.get(bid))) continue;
                    boardIds.add(bid);
                    kendisOnly.put(bid, null);
                    kendisOnly.put((String)bid + cKey, null);
                    kendisChild.put(bid, new HashMap());
                }
                if (backlogItem.getChildRelationMap() != null) {
                    Collection children = backlogItem.getChildRelationMap().values();
                    for (List list : children) {
                        for (BaseItemLink vo : list) {
                            ids.add(vo.getBacklogItemId().toString());
                            childIds.add(vo.getBacklogItemId().toString());
                        }
                    }
                }
                if (backlogItem.getParentRelationMap() != null) {
                    Collection parents = backlogItem.getParentRelationMap().values();
                    for (List list : parents) {
                        Iterator iterator = list.iterator();
                        if (iterator.hasNext()) {
                            BaseItemLink vo;
                            vo = (BaseItemLink)iterator.next();
                            ids.add(vo.getBacklogItemId().toString());
                            parent = this.backlogItemRepository.findById(vo.getBacklogItemId().toString());
                        }
                        if (parent == null) continue;
                        break;
                    }
                }
                ids.add(backlogItem.getId());
                List boardItems = this.itemRepository.findBySessionBoardsIdInAndKendisIdInAndJiraIdIsNullAndTfsIdIsNull(boardIds, ids);
                for (int i = 0; i < boardItems.size(); ++i) {
                    Item item = (Item)boardItems.get(i);
                    item.setSuspendActivity(true);
                    String bidUS = null;
                    String bid = ((SessionBoard)item.getSessionBoards().get(0)).getId();
                    if (!item.getKendisId().equals(backlogItem.getId())) {
                        bidUS = bid;
                        bid = bid + cKey;
                    }
                    if (kendisOnly.get(bid) == null) {
                        kendisOnly.put(bid, new HashMap());
                    }
                    ((Map)kendisOnly.get(bid)).put(item.getKendisId(), i);
                    if (bidUS == null) continue;
                    if (kendisChild.get(bidUS) == null) {
                        kendisChild.put(bidUS, new HashMap());
                    }
                    ((Map)kendisChild.get(bidUS)).put(item.getKendisId(), true);
                }
                for (String string : boardIds) {
                    Integer index;
                    String id = backlogItem.getId();
                    Integer current = null;
                    Integer other = null;
                    String sub = string + cKey;
                    Map map = (Map)kendisOnly.get(string);
                    Map map2 = (Map)kendisOnly.get(sub);
                    if (map != null) {
                        current = (Integer)map.get(id);
                    }
                    if (map2 != null) {
                        other = (Integer)map2.get(id);
                    }
                    int cacheNew = -1;
                    if (current == null && other == null) {
                        cacheNew = 0;
                    } else if (current == null && !backlogItem.getId().equals(((Item)boardItems.get(other)).getKendisId())) {
                        cacheNew = 1;
                    } else if (current != null && backlogItem.getId().equals(((Item)boardItems.get(current)).getKendisId())) {
                        backlogItem.convertToPiItem((Item)boardItems.get(current), parent, null);
                    } else if (other != null && backlogItem.getId().equals(((Item)boardItems.get(other)).getKendisId())) {
                        backlogItem.convertToPiItem((Item)boardItems.get(other), parent, null);
                    }
                    if (cacheNew <= -1) continue;
                    Item item = backlogItem.convertToPiItem(null, parent, new SessionBoard(string));
                    this.putPiItemInList(string, item, boardItems, kendisOnly);
                    if (cacheNew >= 1 || parent == null || kendisOnly.get(sub) == null || (index = (Integer)((Map)kendisOnly.get(sub)).get(parent.getId())) == null || index >= boardItems.size() || !Item.Type.Feature.name().equals(((Item)boardItems.get(index)).getType())) continue;
                    item.setType(Item.Type.UserStory.name());
                    item.setParent((Item)boardItems.get(index));
                }
                HashMap<String, BacklogItem> partialItems = new HashMap<String, BacklogItem>();
                HashSet<String> hashSet = new HashSet<String>();
                List subItems = this.backlogItemRepository.findByIdIn(childIds);
                for (BacklogItem child : subItems) {
                    for (String string : boardIds) {
                        Integer indexP;
                        Map boardChild = (Map)kendisChild.get(string);
                        if (boardChild != null && Boolean.TRUE.equals(boardChild.get(child.getId())) || (indexP = (Integer)((Map)kendisOnly.get(string)).get(backlogItem.getId())) == null || indexP >= boardItems.size()) continue;
                        Item story = null;
                        story = child.convertToPiItem(null, backlogItem, new SessionBoard(string));
                        story.setType(Item.Type.UserStory.name());
                        story.setParent((Item)boardItems.get(indexP));
                        this.putPiItemInList(string + cKey, story, boardItems, kendisOnly);
                        if (artId == null || sessionIdMap.get(string) == null) continue;
                        child.linkToBoard(artId, string, (String)sessionIdMap.get(string));
                        partialItems.put(child.getId(), child);
                        hashSet.add(child.getId());
                    }
                }
                this.itemRepository.save((Iterable)boardItems);
                if (PropertyValidator.isValid(hashSet)) {
                    this.customRepositoryImpl.savePartialPiLinksInBacklog(null, hashSet, partialItems);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("DEV-10253 Backlog Item To Pi Board");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void putPiItemInList(String key, Item item, List<Item> baordItems, Map<String, Map<String, Integer>> kendisOnly) {
        item.setSuspendActivity(true);
        baordItems.add(item);
        int i = baordItems.size() - 1;
        if (kendisOnly.get(key) == null) {
            kendisOnly.put(key, new HashMap());
        }
        kendisOnly.get(key).put(baordItems.get(i).getKendisId(), i);
    }

    public void unsyncBacklogItem(BacklogItem backlogItem, Map<String, Object> linkedArts, Map<String, Object> unLinkedArts) {
        if (unLinkedArts != null && !unLinkedArts.isEmpty()) {
            ArrayList removedBoardIds = new ArrayList();
            ArrayList removedArtIds = new ArrayList();
            ArrayList<String> ids = new ArrayList<String>();
            Set<String> keys = unLinkedArts.keySet();
            ids.add(backlogItem.getId());
            for (String k : keys) {
                Map link = (Map)unLinkedArts.get(k);
                backlogItem.removeBoardLink((String)link.get("sessionBoardId"), (String)link.get("sessionId"), removedArtIds, removedBoardIds);
            }
            this.unlinkBacklogItemFromPi(backlogItem.getTenant(), false, ids, removedArtIds, removedBoardIds);
        }
    }

    public void savePiItemToBackLog(Item item, Map<String, Object> linkedArts, Map<String, Object> unLinkedArts) {
        try {
            String parentKendisId = null;
            String parentId = null;
            BacklogItem backlogItem = null;
            BacklogItem parentItem = null;
            ArrayList<String> ids = new ArrayList<String>();
            HashMap<String, Integer> backlogItems = new HashMap<String, Integer>();
            HashMap skipBoards = new HashMap();
            List<BacklogItem> list = new ArrayList();
            String key = null;
            if (item.getFields() != null && item.getFields().containsKey("externalKey")) {
                key = (String)item.getFields().get("externalKey");
            }
            if (item.getKendisId() == null) {
                if (!PropertyValidator.isValid(key)) {
                    key = item.getKendisKey();
                }
                if (!PropertyValidator.isValid(key)) {
                    key = item.getJiraKey();
                }
            }
            if (Item.Type.UserStory.name().equals(item.getType())) {
                if (PropertyValidator.isValid((Object)item.getParent())) {
                    if (PropertyValidator.isValid((Object)item.getParent().getKendisId())) {
                        parentKendisId = item.getParent().getKendisId();
                        parentId = item.getParent().getId();
                    } else {
                        Item prt = this.itemRepository.findItemFieldsById(item.getParent().getId());
                        if (prt != null) {
                            if (PropertyValidator.isValid((Object)prt.getKendisId())) {
                                parentKendisId = prt.getKendisId();
                            }
                            parentId = item.getParent().getId();
                        }
                    }
                }
                if (!PropertyValidator.isValid(parentKendisId)) {
                    return;
                }
                ids.add(parentKendisId);
            }
            if (item.getKendisId() != null) {
                ids.add(item.getKendisId());
            }
            if (!(item.getKendisId() != null || PropertyValidator.isValid(linkedArts) && !linkedArts.isEmpty() || PropertyValidator.isValid(unLinkedArts) && !unLinkedArts.isEmpty())) {
                return;
            }
            list = this.backlogItemRepository.findByAlmAccountIdIsNullAndIdIn(ids);
            for (int i = 0; i < list.size(); ++i) {
                backlogItems.put(((BacklogItem)list.get(i)).getId(), i);
            }
            if (item.getKendisId() != null && backlogItems.get(item.getKendisId()) != null) {
                backlogItem = (BacklogItem)list.get((Integer)backlogItems.get(item.getKendisId()));
            }
            if (parentKendisId != null && list.size() > 0) {
                parentItem = (BacklogItem)list.get((Integer)backlogItems.get(parentKendisId));
            }
            backlogItem = this.convertPiToBacklogItem(key, backlogItem, item);
            boolean isNew = Boolean.TRUE.equals(backlogItem.getIsNew());
            boolean isKey = false;
            if (!PropertyValidator.isValid((Object)key) || !backlogItem.getKendisKey().equals(key)) {
                key = backlogItem.getKendisKey();
                isKey = true;
            }
            if (isNew) {
                list.add(backlogItem);
                backlogItems.put(backlogItem.getId(), list.size() - 1);
            }
            SessionBoard pi = null;
            if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && PropertyValidator.isValid(item.getSessionBoards().get(0)) && PropertyValidator.isValid((Object)((SessionBoard)item.getSessionBoards().get(0)).getSession())) {
                pi = (SessionBoard)item.getSessionBoards().get(0);
            }
            boolean isAnyLink = this.linkBacklogItemToArts(backlogItem, parentItem, item, pi, skipBoards, linkedArts, "backlogLevel");
            this.unsyncBacklogItem(backlogItem, linkedArts, unLinkedArts);
            Update val = new Update();
            if (isNew || isKey) {
                val.set("kendisId", (Object)backlogItem.getId());
                val.set("kendisKey", (Object)key);
                val.set("jiraKey", (Object)key);
            }
            if (isNew || isAnyLink || isKey) {
                if (isNew || isAnyLink) {
                    val.set("fields", (Object)item.getFields());
                }
                this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)item.getId())})), val, Item.class);
                if (UserContextUtil.getUserContext() != null) {
                    JSONObject data = new JSONObject();
                    JSONObject pushJson = new JSONObject();
                    JSONObject metaMap = new JSONObject();
                    data.put("itemId", (Object)item.getId());
                    data.put("kendisKey", (Object)key);
                    data.put("kendisId", (Object)item.getKendisId());
                    data.put("jiraKey", (Object)key);
                    data.put("fields", item.getFields());
                    if (parentId != null) {
                        data.put("parentId", (Object)parentId);
                    }
                    if (PropertyValidator.isValid((Object)pi)) {
                        metaMap.put("boardId", (Object)pi.getId());
                    }
                    metaMap.put("event", (Object)"NewKendisId");
                    pushJson.put("type", (Object)item.getType());
                    pushJson.put("push", (Object)"Self");
                    pushJson.put("data", (Object)data);
                    pushJson.put("metaMap", (Object)metaMap.toString());
                    PushSender.sendMsg((String)UserContextUtil.getUserContext().getCurrentCompanyId(), (String)pushJson.toString());
                }
            }
            try {
                if (parentItem == null && (isNew || isAnyLink)) {
                    List stories = this.itemRepository.findByParentAndJiraIdIsNullAndTfsIdIsNull(item);
                    for (Item us : stories) {
                        us.setSuspendActivity(true);
                        String _key = null;
                        if (us.getKendisId() == null) {
                            if (us.getKendisKey() != null) {
                                _key = us.getKendisKey();
                            } else if (us.getJiraKey() != null) {
                                _key = us.getJiraKey();
                            }
                        }
                        if (us.getFields() == null) {
                            us.setFields(new HashMap());
                        }
                        BacklogItem child = this.convertPiToBacklogItem(_key, null, us);
                        boolean _isNew = Boolean.TRUE.equals(child.getIsNew());
                        boolean _isKey = false;
                        if (!PropertyValidator.isValid((Object)_key) || !child.getKendisKey().equals(_key)) {
                            _key = child.getKendisKey();
                            _isKey = true;
                        }
                        if (!Boolean.TRUE.equals(child.getIsNew()) && us.getKendisId() != null) {
                            child.setId(us.getKendisId());
                            child.setKendisKey(us.getKendisKey());
                        }
                        if (_isKey || _isNew) {
                            us.setKendisId(child.getId());
                            us.setKendisKey(_key);
                            us.setJiraKey(_key);
                        }
                        this.linkBacklogItemToArts(child, backlogItem, us, pi, skipBoards, linkedArts, "nextLevel");
                        list.add(child);
                    }
                    this.itemRepository.save((Iterable)stories);
                }
            }
            catch (Exception e) {
                LOGGER.error("DEV-10253 problem in converting pi stories backlog item child level");
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            this.backlogItemRepository.save(list);
            if (parentItem != null && isNew) {
                this.saveBacklogItemToPi(null, parentItem, null);
            } else {
                this.saveBacklogItemToPi(null, backlogItem, skipBoards);
            }
        }
        catch (Exception e) {
            LOGGER.error("DEV-10253 Backlog Item To Pi Board");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private BacklogItem convertPiToBacklogItem(String key, BacklogItem backlogItem, Item item) {
        if (backlogItem == null) {
            backlogItem = new BacklogItem(ObjectId.get().toString(), UserContextUtil.getUserContext().getLoggedInUser());
            if (item.getKendisId() == null) {
                backlogItem.setKendisKey(this.customRepositoryImpl.generateKey("K"));
                if (!PropertyValidator.isValid((Object)key)) {
                    // empty if block
                }
                item.setKendisId(backlogItem.getId());
                item.setKendisKey(key);
                backlogItem.setIsNew(Boolean.valueOf(true));
            }
            backlogItem.setFields(new HashMap());
            backlogItem.setAlmFields(new HashMap());
            backlogItem.setArtRelationMap(new HashMap());
            backlogItem.setBoardRelations(new ArrayList());
        }
        if (!PropertyValidator.isValid((Object)key)) {
            // empty if block
        }
        backlogItem.setTitle(item.getTitle());
        backlogItem.setStatus(item.getStatus());
        backlogItem.setStoryPoints(Double.valueOf(item.getStoryPoints() == null ? 0.0 : item.getStoryPoints()));
        backlogItem.setDescription(item.getDescription());
        backlogItem.getFields().putAll(item.getFields());
        backlogItem.getFields().put("externalLink", item.getExternalReferenceURL());
        if (PropertyValidator.isValid((Object)key)) {
            backlogItem.getFields().put("externalKey", key);
            item.getFields().put("externalKey", key);
        }
        SimpleDateFormat yyyy_mm_dd = new SimpleDateFormat("yyyy-MM-dd'T00:00:00.000Z'");
        if (item.getStartDate() != null) {
            backlogItem.getFields().put("StartDate", yyyy_mm_dd.format(item.getStartDate()));
        }
        if (item.getEndDate() != null) {
            backlogItem.getFields().put("EndDate", yyyy_mm_dd.format(item.getEndDate()));
        }
        if (item.getDueDate() != null) {
            backlogItem.getFields().put("DueDate", yyyy_mm_dd.format(item.getDueDate()));
        }
        backlogItem.getFields().remove("artRelationMap");
        backlogItem.getFields().remove("childRelationMap");
        backlogItem.getFields().remove("parentRelationMap");
        return backlogItem;
    }

    private boolean linkBacklogItemToArts(BacklogItem backlogItem, BacklogItem parentBacklogItem, Item item, SessionBoard pi, Map<String, Boolean> skipBoards, Map<String, Object> arts, String property) throws Exception {
        boolean isAnyLink = false;
        Map art = backlogItem.getArtRelationMap();
        ResyncParamsVO syncUtils = new ResyncParamsVO();
        syncUtils.backlogAlmIds = new HashMap();
        if (PropertyValidator.isValid(arts)) {
            Set<String> artIds = arts.keySet();
            for (String artId : artIds) {
                List links;
                if (art.get(artId) == null) {
                    Map map = (Map)arts.get(artId);
                    if (map != null && map.containsKey(property)) {
                        if (parentBacklogItem == null) {
                            backlogItem.linkToRTE(artId, Integer.valueOf(Integer.parseInt((String)map.get(property))));
                        } else {
                            backlogItem.linkToRTE(artId, Integer.valueOf(Integer.parseInt((String)map.get(property))));
                        }
                        if (PropertyValidator.isValid((Object)pi)) {
                            backlogItem.linkToBoard(artId, pi.getId(), pi.getSession().getId());
                        }
                        isAnyLink = true;
                    }
                } else if (parentBacklogItem != null) {
                    parentBacklogItem.getArtRelationMap().get(artId);
                    System.out.println("ss");
                }
                if (PropertyValidator.isValid((Object)pi)) {
                    List links2 = backlogItem.getTeamContainerRelations();
                    if (links2 != null) {
                        links2.removeIf(o -> pi.getId().equals(o.getSessionBoardId()));
                    }
                    if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                        List tcs = item.getTeamContainers();
                        for (TeamContainer tc : tcs) {
                            if (tc == null || tc.getTeam() == null || tc.getContainer() == null) continue;
                            backlogItem.linkToTeamSprint(artId, pi.getId(), tc.getId(), tc.getTeam().getId(), tc.getContainer().getId());
                            if (!Item.Type.UserStory.name().equals(item.getType())) continue;
                            break;
                        }
                    }
                    skipBoards.put(pi.getId(), true);
                }
                if (parentBacklogItem == null) continue;
                BaseItemLink link = null;
                if (backlogItem.getParentRelationMap() != null && PropertyValidator.isValid((Collection)(links = (List)backlogItem.getParentRelationMap().remove(artId)))) {
                    link = (BaseItemLink)links.get(0);
                }
                if (PropertyValidator.isValid(link)) {
                    String pid = String.valueOf(link.getBacklogItemId());
                    syncUtils.releaseTrainId = artId;
                    syncUtils.backlogParentId = new HashMap();
                    syncUtils.backlogParentId.put(artId, new HashMap());
                    syncUtils.backlogOldParent = new HashMap();
                    syncUtils.backlogOldParent.put(artId, new HashMap());
                    ((Map)syncUtils.backlogOldParent.get(artId)).put(backlogItem.getId(), pid);
                    syncUtils.backlogAlmIds.put(backlogItem.getId(), backlogItem.getId());
                    syncUtils.backlogAlmIds.put(pid, pid);
                    this.customRepositoryImpl.removePartialParentChildInBacklog(syncUtils);
                }
                parentBacklogItem.linkToChild(artId, backlogItem.getId());
                parentBacklogItem.getArtRelationMap().get(art);
                backlogItem.linkToParent(artId, parentBacklogItem.getId());
                isAnyLink = true;
            }
        }
        if (parentBacklogItem != null && parentBacklogItem.getBoardRelations() != null) {
            backlogItem.getBoardRelations().addAll(parentBacklogItem.getBoardRelations());
        }
        item.getFields().putAll(backlogItem.fields(parentBacklogItem));
        return isAnyLink;
    }

    public Map<String, Object> saveFilterCriteria(FilterCriteria filterCriteria) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FilterCriteria savedFilterCriteria = (FilterCriteria)this.filterCriteriaRepository.save((Object)filterCriteria);
        result.put("filteredCriteria", savedFilterCriteria);
        return result;
    }

    public List<FilterCriteria> getAllFilterCriteria(String releaseTrainId) {
        String userId = UserContextUtil.getUserContext().getLoggedInUser().getId();
        ArrayList<String> list = new ArrayList<String>();
        list.add(userId);
        list.add(null);
        List filterCriterias = this.filterCriteriaRepository.findByReleaseTrainIdAndUserIdIn(releaseTrainId, list);
        return filterCriterias;
    }

    public Map<String, Object> getAllStatuses(String almAccountId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List allStatuses = this.statusRepository.findByAlmId(almAccountId);
        result.put("statuses", allStatuses);
        return result;
    }

    public Map<String, Object> deleteCriteria(HashMap<String, Object> requestBody) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            WorkSpace workSpace;
            String filterId = (String)requestBody.get("filterId");
            String workSpaceId = (String)requestBody.get("workSpaceId");
            if (PropertyValidator.isValid((Object)filterId)) {
                this.filterCriteriaRepository.delete((Serializable)((Object)filterId));
                result.put("success", true);
            }
            if (PropertyValidator.isValid((Object)workSpaceId) && PropertyValidator.isValid((Object)(workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)workSpaceId)))) && PropertyValidator.isValid((Object)workSpace.getBacklogSettingsMap())) {
                HashMap backlogSettingsMap = workSpace.getBacklogSettingsMap();
                for (BacklogSettings backlogSettings : backlogSettingsMap.values()) {
                    if (!PropertyValidator.isValid((Object)backlogSettings.getDefaultFilterId()) || !filterId.equals(backlogSettings.getDefaultFilterId())) continue;
                    backlogSettings.setDefaultFilterId(null);
                }
                this.workSpaceRepository.save((Object)workSpace);
            }
        }
        catch (Exception ex) {
            result.put("success", false);
        }
        return result;
    }

    public Map<String, Object> getJiraStatuses(List<String> statuses) {
        return null;
    }

    public ArrayList<WorkSpace> getWorkSpacesForSolutionBoard(Map<String, Object> params) {
        try {
            Map result = this.getAllReleaseTrains(params);
            ArrayList allowedWorkspaces = (ArrayList)result.get("releaseTrains");
            ArrayList<WorkSpace> selectedAllowedWorkspaces = new ArrayList<WorkSpace>();
            for (WorkSpace workSpace : allowedWorkspaces) {
                selectedAllowedWorkspaces.add(workSpace);
            }
            return selectedAllowedWorkspaces;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching work Spaces for solution board -> ", (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> getAllReleaseTrainsWithSameHierarchy(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    public Map<String, Object> getAllReleaseTrains(Map<String, Object> params) {
        List users;
        List workSpaceKeys;
        List ids;
        Boolean fetchTypes;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (params.containsKey("fetchTypes") && (fetchTypes = (Boolean)params.get("fetchTypes")).booleanValue()) {
            List workSpaceTypes = this.workSpaceTypeService.getListOfAllWorkSpacesTypes();
            result.put("releaseTrainTypes", workSpaceTypes);
        }
        Query query = new Query();
        Query query2 = null;
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        if (!params.containsKey("fetchArchived")) {
            if (params.containsKey("archieve")) {
                Boolean archieve = (Boolean)params.get("archieve");
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)(archieve != false ? 1 : 0)));
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            }
        }
        if (params.containsKey("level")) {
            Integer level = (Integer)params.get("level");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"level").is((Object)level));
        }
        if (params.containsKey("linkedAlmHierarchy")) {
            String linkedAlmHierarchy = (String)params.get("linkedAlmHierarchy");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"linkedAlmHierarchy").is((Object)linkedAlmHierarchy));
        }
        if (params.containsKey("ids") && PropertyValidator.isValid((Collection)(ids = (List)params.get("ids")))) {
            ArrayList<ObjectId> idsObjects = new ArrayList<ObjectId>();
            for (String _id : ids) {
                idsObjects.add(new ObjectId(_id));
            }
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(idsObjects));
        }
        if (PropertyValidator.isValid((Collection)(workSpaceKeys = (List)params.get("workSpaceKeys")))) {
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"isModule").is(null), Criteria.where((String)"isModule").is((Object)false), Criteria.where((String)"key").in((Collection)workSpaceKeys)}));
            query2 = query;
        } else {
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"isModule").is(null), Criteria.where((String)"isModule").is((Object)false)}));
        }
        List releaseTrains = this.mongoTemplate.find(query, WorkSpace.class);
        HashSet almAccountList = new HashSet();
        ArrayList<String> userEmails = new ArrayList<String>();
        User user = UserContextUtil.getUserContext().getLoggedInUser();
        HashMap<String, String> userFullNameByEmail = new HashMap<String, String>();
        ArrayList<WorkSpace> allowedWorkspaces = new ArrayList<WorkSpace>();
        if (user.getIsAdmin().booleanValue()) {
            allowedWorkspaces.addAll(releaseTrains);
            for (WorkSpace rt : releaseTrains) {
                userEmails.add(rt.getCreatedBy());
            }
        } else {
            List workSpaceAccessRoles = this.customRepositoryImpl.findWorkspaceAccessRoles(user, query2);
            HashMap accessRollMap = new HashMap();
            for (WorkSpaceAccessRole role : workSpaceAccessRoles) {
                WorkSpace workspace = role.getWorkSpace();
                if (!PropertyValidator.isValid((Object)workspace)) continue;
                accessRollMap.put(role.getWorkSpace().getId(), true);
            }
            for (WorkSpace rt : releaseTrains) {
                if (accessRollMap.get(rt.getId()) != null) {
                    allowedWorkspaces.add(rt);
                } else if (workSpaceKeys != null && workSpaceKeys.indexOf(rt.getKey()) > -1) {
                    allowedWorkspaces.add(rt);
                }
                if (!PropertyValidator.isValid((Object)rt.getCreatedBy())) continue;
                userEmails.add(rt.getCreatedBy());
            }
        }
        if (PropertyValidator.isValid(userEmails) && PropertyValidator.isValid((Collection)(users = this.userRepository.findByUserNameIgnoreCaseIn(userEmails)))) {
            for (User userObj : users) {
                if (!PropertyValidator.isValid((Object)userObj.getUserName())) continue;
                userFullNameByEmail.put(userObj.getUserName(), userObj.getFullName());
            }
        }
        for (WorkSpace workspace : allowedWorkspaces) {
            if (PropertyValidator.isValid((Collection)workspace.getLinkedAlmAccounts())) {
                ArrayList linkedAccountList = new ArrayList();
                workspace.getLinkedAlmAccounts().stream().forEach(almAccount -> {
                    almAccountList.add(almAccount);
                    AlmAccount alm = new AlmAccount(almAccount.getId(), almAccount.getType(), almAccount.getName());
                    linkedAccountList.add(alm);
                });
                workspace.setLinkedAlmAccounts(linkedAccountList);
            }
            if (!PropertyValidator.isValid((Collection)workspace.getAlmFilters())) continue;
            workspace.getAlmFilters().stream().forEach(filter -> filter.setAlmAccount(new AlmAccount(filter.getAlmAccount().getId())));
        }
        result.put("userNames", userFullNameByEmail);
        result.put("releaseTrains", allowedWorkspaces);
        return result;
    }

    public Map<String, Object> archiveWorkspace(String workspaceId, Boolean archive) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (archive.booleanValue()) {
            this.customRepository.setRowStatus(workspaceId, 1, WorkSpace.class);
            result.put("isArchive", true);
        } else {
            this.customRepository.setRowStatus(workspaceId, 0, WorkSpace.class);
            result.put("isArchive", false);
        }
        return result;
    }

    public Map<String, Object> saveTfsFields(String almId, String releaseTrainId, HashMap<String, Object> requestBody) throws Exception {
        List hierarchyLevels;
        List mappings;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List fields = (List)requestBody.get("selectedFields");
        List unSelectedFieldIds = (List)requestBody.get("unSelectedFieldIds");
        WorkSpace workspace = this.workSpaceRepository.findByIdOrKey(releaseTrainId, releaseTrainId);
        if (PropertyValidator.isValid((Object)workspace) && PropertyValidator.isValid((Collection)(mappings = this.getAlmHierarchyLevelMapping(hierarchyLevels = this.getHierarchyLevels(workspace), almId)))) {
            for (AlmHierarchyLevelMapping level : mappings) {
                level.setTfsFields(fields);
            }
            this.almHierarchyLevelMappingRepository.save((Iterable)mappings);
            result.put("levels", hierarchyLevels);
        }
        if (PropertyValidator.isValid((Object)workspace.getBacklogSettingsMap()) && PropertyValidator.isValid((Collection)unSelectedFieldIds) && !unSelectedFieldIds.isEmpty()) {
            HashMap backlogSettingsMap = workspace.getBacklogSettingsMap();
            for (BacklogSettings backlogSettings : backlogSettingsMap.values()) {
                List backlogItems = backlogSettings.getBackLogItemsColumns();
                for (int i = 0; i < backlogItems.size(); ++i) {
                    String item = (String)backlogItems.get(i);
                    item = item.replaceAll("\\s+", "");
                    backlogItems.set(i, item);
                }
                backlogItems.removeAll(unSelectedFieldIds);
            }
            this.workSpaceRepository.save((Object)workspace);
        }
        return result;
    }

    public Map<String, Object> saveKanbanWidgetFields(String id, List<Map<String, Object>> fields) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Board board = (Board)this.boardRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)board)) {
            if (PropertyValidator.isValid((Object)board.getConfigurations())) {
                board.getConfigurations().setWidgetFieldsList(fields);
            } else {
                BoardConfiguration boardConfig = new BoardConfiguration();
                boardConfig.setWidgetFieldsList(fields);
                board.setConfigurations(boardConfig);
            }
            this.boardRepository.save((Object)board);
            result.put("boardConfiguration", board.getConfigurations());
        }
        return result;
    }

    public Map<String, Object> updateBoardSettings(Map<String, Object> inputBoard) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Board board = (Board)this.boardRepository.findOne((Serializable)((Object)((String)inputBoard.get("id"))));
        if (PropertyValidator.isValid((Object)board)) {
            String value;
            if (inputBoard.containsKey("timelineVisiblePiBoards")) {
                board.setTimelineVisiblePiBoards((List)inputBoard.get("timelineVisiblePiBoards"));
            }
            if (inputBoard.containsKey("timelineBarMode")) {
                value = (String)inputBoard.get("timelineBarMode");
                board.setTimelineBarMode(Integer.valueOf(Integer.parseInt(value)));
            }
            if (inputBoard.containsKey("timelineUnplannedItemsMode")) {
                value = (String)inputBoard.get("timelineUnplannedItemsMode");
                board.setTimelineUnplannedItemsMode(Integer.valueOf(Integer.parseInt(value)));
            }
            if (inputBoard.containsKey("timelineIterationDate")) {
                value = (String)inputBoard.get("timelineIterationDate");
                board.setTimelineIterationDate(Integer.valueOf(Integer.parseInt(value)));
            }
            if (inputBoard.containsKey("timelineDatePreferences")) {
                value = (String)inputBoard.get("timelineDatePreferences");
                board.setTimelineDatePreferences(Integer.valueOf(Integer.parseInt(value)));
            }
            if (inputBoard.containsKey("timelineColumns")) {
                board.setTimelineColumns((List)inputBoard.get("timelineColumns"));
            }
            this.boardRepository.save((Object)board);
            result.put("success", true);
            result.put("board", board);
        } else {
            result.put("success", false);
        }
        return result;
    }

    public Map<String, Object> kanbanMappingOrder(Map<String, Object> input) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String boardId = (String)input.get("boardId");
        Board board = this.boardRepository.findByIdOrKey(boardId, boardId);
        if (PropertyValidator.isValid((Object)board)) {
            List kanbanMappingOrder = (List)input.get("kanbanMappingOrder");
            if (PropertyValidator.isValid((Collection)kanbanMappingOrder)) {
                board.setKanbanMappingOrder(kanbanMappingOrder);
                board = (Board)this.boardRepository.save((Object)board);
                result.put("success", true);
                result.put("board", board);
            } else {
                result.put("success", false);
            }
        } else {
            result.put("success", false);
        }
        return result;
    }

    public Map<String, Object> otherCollectionBoards(Map<String, Object> input) throws Exception {
        String search = (String)input.get("search");
        String releaseTrainId = (String)input.get("releaseTrainId");
        HashMap<String, Object> result = new HashMap<String, Object>();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace.$id").ne((Object)new ObjectId(releaseTrainId)));
        String options = "i";
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").regex(search, options));
        query.fields().include("id");
        query.fields().include("title");
        query.fields().include("prefix");
        query.fields().include("prefixColor");
        query.fields().include("activeSessionBoard");
        query.fields().include("workSpace");
        query.fields().include("itemWorkFlow");
        query.fields().include("subItemWorkFlow");
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("session").find(query.getQueryObject()).sort((DBObject)new BasicDBObject("updatedOn", (Object)1));
        List allItems = dbCursorPrefix.toArray();
        ArrayList<BasicDBObject> allSessions = new ArrayList<BasicDBObject>();
        if (PropertyValidator.isValid((Collection)allItems)) {
            for (DBObject session : allItems) {
                DBRef ref;
                BasicDBObject _session = new BasicDBObject();
                _session.put("id", (Object)String.valueOf(session.get("_id")));
                _session.put("title", session.get("title"));
                _session.put("prefix", session.get("prefix"));
                _session.put("prefixColor", session.get("prefixColor"));
                _session.put("activeSessionBoard", session.get("activeSessionBoard"));
                if (session.containsField("workSpace")) {
                    ref = (DBRef)session.get("workSpace");
                    _session.put("workSpace", (Object)new BasicDBObject("id", (Object)String.valueOf(ref.getId())));
                }
                if (session.containsField("itemWorkFlow")) {
                    ref = (DBRef)session.get("itemWorkFlow");
                    _session.put("itemWorkFlow", (Object)new BasicDBObject("id", (Object)String.valueOf(ref.getId())));
                }
                if (session.containsField("subItemWorkFlow")) {
                    ref = (DBRef)session.get("subItemWorkFlow");
                    _session.put("subItemWorkFlow", (Object)new BasicDBObject("id", (Object)String.valueOf(ref.getId())));
                }
                allSessions.add(_session);
            }
        }
        result.put("boards", allSessions);
        return result;
    }

    public Map<String, Object> getWorkpaceMeta(String workspaceId) {
        Map<String, Object> result = new HashMap();
        ArrayList accessRoles = new ArrayList();
        JSONArray optionList = new JSONArray();
        for (EnumRTModules module : EnumRTModules.values()) {
            JSONObject value = new JSONObject();
            value.put("id", (Object)module.getCode());
            value.put("detail", (Object)module.getNarrative());
            value.put("checked", true);
            value.put("isEdit", false);
            optionList.put((Object)value);
        }
        List workspaceTypes = this.workSpaceTypeService.getListOfAllWorkSpacesTypes();
        HashMap workspaceMap = (HashMap)this.getAllReleaseTrains(new HashMap());
        List almHierarchyList = this.almHierarchyRepository.findAll();
        result = this.getAlmAccounts();
        result.put("modules", optionList.toString());
        result.put("workspaceTypes", workspaceTypes);
        result.put("linkableWorkSpaces", workspaceMap.get("releaseTrains"));
        result.put("almHierarchyList", almHierarchyList);
        return result;
    }

    public Map<String, Object> getRolesAndPermissionMeta(HashMap<String, Object> body) {
        int j;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List accessRoles = new ArrayList();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        List users = this.customRepository.findUnarchviedUsersByCompany(cid);
        PageRequest pageable = new PageRequest(0, 10000);
        Page page = this.groupRepository.findAll((Pageable)pageable);
        List groups = page.getContent();
        List roles = this.roleRepository.findAll();
        String workspaceId = (String)body.get("workspaceId");
        String customViewId = (String)body.get("customViewId");
        String solutionAreaId = (String)body.get("solutionAreaId");
        if (PropertyValidator.isValid((Object)workspaceId)) {
            accessRoles = this.workSpaceAccessRoleRepository.findByWorkSpace(new WorkSpace(workspaceId));
            for (WorkSpaceAccessRole accessRole : accessRoles) {
                User user = accessRole.getUser();
                if (!PropertyValidator.isValid((Object)user) || !PropertyValidator.isValid((Collection)user.getUserCompanies())) continue;
                for (int j2 = 0; j2 < user.getUserCompanies().size(); ++j2) {
                    if (!((UserCompany)user.getUserCompanies().get(j2)).getCompany().getId().equals(cid)) continue;
                    user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(j2)).getIsAdmin());
                    user.setIsAdmin(((UserCompany)user.getUserCompanies().get(j2)).getIsAdmin());
                    user.setIsActive(((UserCompany)user.getUserCompanies().get(j2)).getIsActive());
                    user.setIsGuest(((UserCompany)user.getUserCompanies().get(j2)).getIsGuest());
                }
            }
            result.put("accessRoles", accessRoles);
        }
        if (PropertyValidator.isValid((Object)customViewId)) {
            ObjectiveCustomView tempView = new ObjectiveCustomView();
            tempView.setId(customViewId);
            accessRoles = this.workSpaceAccessRoleRepository.findByCustomView(tempView);
            for (WorkSpaceAccessRole accessRole : accessRoles) {
                User user = accessRole.getUser();
                if (!PropertyValidator.isValid((Object)user) || !PropertyValidator.isValid((Collection)user.getUserCompanies())) continue;
                for (j = 0; j < user.getUserCompanies().size(); ++j) {
                    if (!((UserCompany)user.getUserCompanies().get(j)).getCompany().getId().equals(cid)) continue;
                    user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                    user.setIsAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                    user.setIsActive(((UserCompany)user.getUserCompanies().get(j)).getIsActive());
                    user.setIsGuest(((UserCompany)user.getUserCompanies().get(j)).getIsGuest());
                }
            }
            result.put("accessRoles", accessRoles);
        }
        if (PropertyValidator.isValid((Object)solutionAreaId)) {
            SolutionArea tempSA = new SolutionArea();
            tempSA.setId(solutionAreaId);
            accessRoles = this.workSpaceAccessRoleRepository.findBySolutionArea(tempSA);
            for (WorkSpaceAccessRole accessRole : accessRoles) {
                User user = accessRole.getUser();
                if (!PropertyValidator.isValid((Object)user) || !PropertyValidator.isValid((Collection)user.getUserCompanies())) continue;
                for (j = 0; j < user.getUserCompanies().size(); ++j) {
                    if (!((UserCompany)user.getUserCompanies().get(j)).getCompany().getId().equals(cid)) continue;
                    user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                    user.setIsAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                    user.setIsActive(((UserCompany)user.getUserCompanies().get(j)).getIsActive());
                    user.setIsGuest(((UserCompany)user.getUserCompanies().get(j)).getIsGuest());
                }
            }
            result.put("accessRoles", accessRoles);
        }
        result.put("users", users);
        result.put("groups", groups);
        result.put("roles", roles);
        return result;
    }

    public Map<String, Object> getWorkspaceModule(String type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String workspaceType = null;
        String title = "";
        if (type.equalsIgnoreCase("Objective")) {
            workspaceType = EnumWorkSpaceType.OBJECTIVES.getValue();
            title = "Strategic Themes";
        } else if (type.equalsIgnoreCase("batch")) {
            workspaceType = EnumWorkSpaceType.BATCHES.getValue();
            title = "Batches View";
        }
        WorkSpace workspace = new WorkSpace();
        workspace.setModuleType(workspaceType);
        workspace.setIsModule(Boolean.valueOf(true));
        workspace.setTitle(title);
        WorkSpace savedworkspace = this.workSpaceRepository.findByIsModuleIsTrueAndModuleType(workspaceType);
        if (!PropertyValidator.isValid((Object)savedworkspace)) {
            workspace = (WorkSpace)this.workSpaceRepository.save((Object)workspace);
            result.put("workspace", workspace);
        } else {
            result.put("workspace", savedworkspace);
        }
        return result;
    }

    public Map<String, Object> sortArt(HashMap<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String releaseTrainId = (String)params.get("releaseTrainId");
        Double sequence = Double.parseDouble((String)params.get("artSequence"));
        WorkSpace workspace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        if (PropertyValidator.isValid((Object)workspace)) {
            workspace.setSequence(sequence);
            this.workSpaceRepository.save((Object)workspace);
            result.put("success", true);
        }
        return result;
    }

    public HashMap<String, Object> saveBackLogItemDefaultSettings(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String workSpaceId = (String)requestBody.get("workSpaceId");
        String hierarchyLevelIdForColumns = (String)requestBody.get("hierarchyLevelIdForColumns");
        String hierarchyLevelIdForFilter = (String)requestBody.get("hierarchyLevelIdForFilter");
        String hierarchyLevelIdForItemSettings = (String)requestBody.get("hierarchyLevelIdForItemSettings");
        List backLogColumnsList = (List)requestBody.get("columnIds");
        List objectiveColumnsList = (List)requestBody.get("okrColumnIds");
        List customViewColumnsList = (List)requestBody.get("cvColumnIds");
        String filterId = (String)requestBody.get("filterId");
        String defaultProject = (String)requestBody.get("defaultProject");
        String defaultItemType = (String)requestBody.get("defaultItemType");
        String defaultStatus = (String)requestBody.get("defaultStatus");
        List defaultJiraFields = (List)requestBody.get("defaultJiraFields");
        String workSpaceTitle = (String)requestBody.get("workSpaceTitle");
        boolean removeDefaultFilter = null != requestBody.get("removeDefaultFilter");
        Boolean legacyThemeEnabled = null;
        if (requestBody.containsKey("legacyThemeEnabled")) {
            Object legacyThemeEnabledObj = requestBody.get("legacyThemeEnabled");
            if (legacyThemeEnabledObj instanceof Boolean) {
                legacyThemeEnabled = (Boolean)legacyThemeEnabledObj;
            } else if (legacyThemeEnabledObj instanceof String) {
                legacyThemeEnabled = Boolean.valueOf((String)legacyThemeEnabledObj);
            }
            if (legacyThemeEnabled != null) {
                List customViewWorkFlows = this.workFlowRepository.findAllByWorkflowType(EnumKendis.STRATEGIC_THEME.getCode());
                if (PropertyValidator.isValid((Collection)customViewWorkFlows)) {
                    WorkFlow customViewWorkFlow = (WorkFlow)customViewWorkFlows.get(0);
                    customViewWorkFlow.setLegacyThemeEnabled(legacyThemeEnabled.booleanValue());
                    this.workFlowRepository.save((Object)customViewWorkFlow);
                    result.put("updatedWorkSpace", customViewWorkFlow);
                }
                result.put("legacyThemeEnabled", legacyThemeEnabled);
            }
        }
        boolean restrictionApplied = false;
        Object restrictionAppliedObj = requestBody.get("restrictionApplied");
        if (restrictionAppliedObj instanceof Boolean) {
            restrictionApplied = (Boolean)restrictionAppliedObj;
        }
        List itemRestrictions = null;
        if (requestBody.containsKey("restrictedProjectsAndIssueTypes")) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
            itemRestrictions = (List)objectMapper.readValue(objectMapper.writeValueAsString(requestBody.get("restrictedProjectsAndIssueTypes")), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (PropertyValidator.isValid((Object)workSpaceId)) {
            WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)workSpaceId));
            if (PropertyValidator.isValid((Object)workSpace)) {
                HashMap backlogSettingsMap = new HashMap();
                if (PropertyValidator.isValid((Object)workSpace.getBacklogSettingsMap())) {
                    backlogSettingsMap = workSpace.getBacklogSettingsMap();
                }
                BacklogSettings backlogSettings = new BacklogSettings();
                if (PropertyValidator.isValid((Object)hierarchyLevelIdForColumns) && PropertyValidator.isValid((Collection)backLogColumnsList)) {
                    backlogSettings = backlogSettingsMap.getOrDefault(hierarchyLevelIdForColumns, new BacklogSettings());
                    if (!PropertyValidator.isValid((Object)backlogSettings.getHierarchyLevelId())) {
                        backlogSettings.setHierarchyLevelId(hierarchyLevelIdForColumns);
                    }
                    backlogSettings.setBackLogItemsColumns(backLogColumnsList);
                    backlogSettingsMap.put(hierarchyLevelIdForColumns, backlogSettings);
                }
                if (PropertyValidator.isValid((Object)hierarchyLevelIdForFilter)) {
                    backlogSettings = backlogSettingsMap.getOrDefault(hierarchyLevelIdForFilter, new BacklogSettings());
                    if (!PropertyValidator.isValid((Object)backlogSettings.getHierarchyLevelId())) {
                        backlogSettings.setHierarchyLevelId(hierarchyLevelIdForFilter);
                    }
                    if (PropertyValidator.isValid((Object)filterId)) {
                        backlogSettings.setDefaultFilterId(filterId);
                    } else if (removeDefaultFilter) {
                        backlogSettings.setDefaultFilterId(null);
                    }
                    backlogSettingsMap.put(hierarchyLevelIdForFilter, backlogSettings);
                }
                if (PropertyValidator.isValid((Object)hierarchyLevelIdForItemSettings)) {
                    backlogSettings = backlogSettingsMap.getOrDefault(hierarchyLevelIdForItemSettings, new BacklogSettings());
                    if (!PropertyValidator.isValid((Object)backlogSettings.getHierarchyLevelId())) {
                        backlogSettings.setHierarchyLevelId(hierarchyLevelIdForItemSettings);
                    }
                    if (PropertyValidator.isValid((Object)defaultProject)) {
                        backlogSettings.setDefaultProject(defaultProject);
                    } else {
                        backlogSettings.setDefaultProject(null);
                    }
                    if (PropertyValidator.isValid((Object)defaultItemType)) {
                        backlogSettings.setDefaultItemType(defaultItemType);
                    } else {
                        backlogSettings.setDefaultItemType(null);
                    }
                    if (PropertyValidator.isValid((Object)defaultStatus)) {
                        backlogSettings.setDefaultStatus(defaultStatus);
                    }
                    if (PropertyValidator.isValid((Collection)defaultJiraFields)) {
                        backlogSettings.setDefaultJiraFields(defaultJiraFields);
                    }
                    backlogSettings.setRestrictionApplied(restrictionApplied);
                    if (PropertyValidator.isValid((Collection)itemRestrictions)) {
                        backlogSettings.setItemRestrictions(itemRestrictions);
                    }
                    backlogSettingsMap.put(hierarchyLevelIdForItemSettings, backlogSettings);
                }
                workSpace.setBacklogSettingsMap(backlogSettingsMap);
                if (PropertyValidator.isValid((Object)workSpaceTitle)) {
                    workSpace.setTitle(workSpaceTitle);
                }
                if (PropertyValidator.isValid((Collection)objectiveColumnsList)) {
                    workSpace.setColumnSettings(objectiveColumnsList);
                }
                if (PropertyValidator.isValid((Collection)customViewColumnsList)) {
                    workSpace.setCustomViewColumnSettings(customViewColumnsList);
                }
                this.workSpaceRepository.save((Object)workSpace);
                result.put("updatedWorkSpace", workSpace);
            }
        } else {
            result.put("error", "WorkSpace ID is not valid");
        }
        return result;
    }

    public Map<String, Object> validateFiltersLinking(FilterCriteria filter) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List boardList = this.boardRepository.findByFilterCriteria(filter);
        if (PropertyValidator.isValid((Collection)boardList)) {
            JSONArray boardItemList = new JSONArray();
            for (Board board : boardList) {
                JSONObject value = new JSONObject();
                value.put("key", (Object)board.getKey());
                value.put("name", (Object)board.getName());
                value.put("type", (Object)board.getViewType());
                boardItemList.put((Object)value);
            }
            result.put("success", false);
            result.put("boardList", boardItemList.toString());
        } else {
            result.put("success", true);
        }
        return result;
    }

    public Map<String, Object> checkLevelDeletion(Map<String, Object> params) {
        HierarchyLevel hierarchyLevel;
        BacklogHierarchy hierarchy;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String backlogHierarchyId = (String)params.get("backlogHierarchyId");
        Double level = (Double)params.get("level");
        boolean deleteLevel = false;
        List workSpaces = this.workSpaceRepository.findByLinkedAlmHierarchy(backlogHierarchyId);
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            Query query = new Query();
            Criteria orCriteria = new Criteria();
            ArrayList<Criteria> orExpression = new ArrayList<Criteria>();
            for (WorkSpace workspace : workSpaces) {
                Criteria expression = new Criteria();
                expression.and("artRelationMap." + workspace.getId() + ".backlogLevel").is((Object)level.intValue());
                orExpression.add(expression);
            }
            query.addCriteria((CriteriaDefinition)orCriteria.orOperator(orExpression.toArray(new Criteria[orExpression.size()])));
            int itemCount = this.mongoTemplate.getCollection("backlogItem").find(query.getQueryObject()).count();
            if (itemCount > 0) {
                result.put("success", false);
            } else {
                deleteLevel = true;
            }
        } else {
            deleteLevel = true;
        }
        if (deleteLevel && PropertyValidator.isValid((Object)(hierarchy = (BacklogHierarchy)this.backlogHierarchyRepository.findOne((Serializable)((Object)backlogHierarchyId)))) && PropertyValidator.isValid((Object)(hierarchyLevel = (HierarchyLevel)hierarchy.getHierarchyLevels().stream().filter(mp -> mp.getLevel().equals(level.intValue())).findAny().orElse(null)))) {
            this.almHierarchyLevelMappingRepository.delete((Iterable)hierarchyLevel.getAlmHierarchyLevelMappings());
            this.almHierarchyLevelRepository.delete((Object)hierarchyLevel);
            hierarchy.getHierarchyLevels().remove(hierarchyLevel);
            hierarchy = (BacklogHierarchy)this.backlogHierarchyRepository.save((Object)hierarchy);
            result.put("success", true);
            result.put("hierarchy", hierarchy);
        }
        return result;
    }

    public Map<String, Object> addSiteInWorkspace(String releaseTrainId, PiSite site) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        if (PropertyValidator.isValid((Object)releaseTrain)) {
            TimeZone timeZone = TimeZone.getTimeZone(site.getTimeZone());
            site.setDstSavings(timeZone.getDSTSavings());
            site.setRawOffset(timeZone.getRawOffset());
            site = (PiSite)this.piSiteRepository.save((Object)site);
            if (releaseTrain.getSites() == null) {
                releaseTrain.setSites(new ArrayList());
            }
            releaseTrain.getSites().add(site);
            releaseTrain = (WorkSpace)this.workSpaceRepository.save((Object)releaseTrain);
            result.put("releaseTrain", releaseTrain);
            result.put("site", site);
        }
        return result;
    }

    public Map<String, Object> removeSiteFromWorkspace(String releaseTrainId, String siteId) {
        int index;
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        if (PropertyValidator.isValid((Object)releaseTrain) && releaseTrain.getSites() != null && (index = IntStream.range(0, releaseTrain.getSites().size()).filter(siteIndex -> ((PiSite)releaseTrain.getSites().get(siteIndex)).getId().equals(siteId)).findFirst().orElse(-1)) > -1) {
            this.piSiteRepository.delete(releaseTrain.getSites().get(index));
            releaseTrain.getSites().remove(index);
            this.workSpaceRepository.save((Object)releaseTrain);
            result.put("releaseTrain", releaseTrain);
            result.put("siteId", siteId);
        }
        return result;
    }

    public String loadTfsProjects(String almId) {
        return this.tfsMetaService.loadTfsProjects(almId);
    }

    public Map<String, Object> linkTfsProject(String projectId, String almId, String metaMap, String syncId, String releaseTrainKey) {
        return this.tfsMetaService.linkTfsProject(projectId, almId, metaMap, syncId, releaseTrainKey);
    }

    public Map<String, Object> resyncTfsProject(Map<String, Object> params) throws Exception {
        return this.tfsMetaService.resyncTfsProject(params);
    }

    public Map<String, Object> deleteTfsProject(String projectId, String almId, String metaMap, String syncId, String workspaceKey) throws Exception {
        return this.tfsMetaService.deleteTfsProject(projectId, almId, metaMap, syncId, workspaceKey);
    }

    public Map<String, Object> getTfsProcess(String almAccountId) {
        return this.tfsMetaService.getTfsProcess(almAccountId);
    }

    public Map<String, Object> getTfsProcessWorkItemType(String payload) {
        return this.tfsMetaService.getTfsProcessWorkItemType(payload);
    }

    public List<TFSProject> fetchLinkedTfsProjects(String almId, String releaseTrainKey) {
        return this.tfsMetaService.fetchLinkedTfsProjects(almId, releaseTrainKey);
    }

    public Map<String, Object> getAllTFSFields(String almAccountId) {
        return this.tfsMetaService.getAllTFSFields(almAccountId);
    }

    public Map<String, Object> fetchAndSyncTfsFilters(List<String> tfsIds, TFSFilter tfsFilter, String releaseTrainId, String almId, Map<String, Object> otherParams) {
        return this.itemTfsSyncService.fetchAndSyncTfsFilters(tfsIds, tfsFilter, releaseTrainId, almId, otherParams);
    }

    public Map<String, Object> addExistingTfsItems(Map<String, Object> params) {
        return this.itemTfsSyncService.addExistingTfsItems(params);
    }

    public Map<String, Object> resyncTfsItems(Map<String, Object> params) {
        return this.itemTfsSyncService.resyncTfsItems(params);
    }

    public Map<String, Object> deleteFilters(String filterId, String releaseTrainId, String almId, Map<String, Object> otherParams) {
        return this.itemTfsSyncService.deleteFilters(filterId, releaseTrainId, almId, otherParams);
    }

    public Map<String, Object> getAllReleaseTrainsWithoutPIs() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Query query = new Query();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"isModule").is(null), Criteria.where((String)"isModule").is((Object)false)}));
        query.fields().include("key").include("title").include("type").include("level");
        List releaseTrains = this.mongoTemplate.find(query, WorkSpace.class);
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        ArrayList<WorkSpace> allowedWorkspaces = new ArrayList<WorkSpace>();
        if (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue()) {
            allowedWorkspaces.addAll(releaseTrains);
        } else {
            List workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            HashMap<String, Boolean> accessRollMap = new HashMap<String, Boolean>();
            for (WorkSpaceAccessRole role : workSpaceAccessRoles) {
                WorkSpace workspace = role.getWorkSpace();
                if (!PropertyValidator.isValid((Object)workspace)) continue;
                accessRollMap.put(role.getWorkSpace().getId(), true);
            }
            for (WorkSpace rt : releaseTrains) {
                if (accessRollMap.get(rt.getId()) == null) continue;
                allowedWorkspaces.add(rt);
            }
        }
        result.put("releaseTrains", allowedWorkspaces);
        return result;
    }

    public WorkFlow createMilestoneWorkFlow() {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Milestone Workflow");
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType(EnumKendis.MILESTONE.getCode());
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (int j = 0; j < 3; ++j) {
            Status status1;
            Status status;
            if (j == 0) {
                status = new Status();
                status.setCategory("ToDo");
                status.setArchive(false);
                status.setWorkFlow(defaultScheme);
                status.setTitle("Waiting for Acceptance");
                statusList.add(status);
                status1 = new Status();
                status1.setCategory("ToDo");
                status1.setArchive(false);
                status1.setWorkFlow(defaultScheme);
                status1.setTitle("Accepted");
                statusList.add(status1);
                Status status2 = new Status();
                status2.setCategory("ToDo");
                status2.setArchive(false);
                status2.setWorkFlow(defaultScheme);
                status2.setTitle("Not Started");
                statusList.add(status2);
                continue;
            }
            if (j == 1) {
                status = new Status();
                status.setCategory("InProgress");
                status.setArchive(false);
                status.setWorkFlow(defaultScheme);
                status.setTitle("Progressing");
                statusList.add(status);
                continue;
            }
            status = new Status();
            status.setCategory("Done");
            status.setArchive(false);
            status.setWorkFlow(defaultScheme);
            status.setTitle("Done");
            statusList.add(status);
            status1 = new Status();
            status1.setCategory("Done");
            status1.setArchive(false);
            status1.setWorkFlow(defaultScheme);
            status1.setTitle("Done with Acceptance");
            statusList.add(status1);
        }
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        this.statusRepository.save(statusList);
        return defaultScheme;
    }

    public Map<String, Object> getMilestonesLinkedToPiBoard(String boardId) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"boardRelations.sessionId").is((Object)boardId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"boardRelations.rowStatus").is((Object)0));
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"fields.itemType").is((Object)"Milestone"), Criteria.where((String)"fields.itemType").is((Object)"Phase")}));
        List linkedMilestones = this.mongoTemplate.find(query, BacklogItem.class);
        responseJson.put("linkedMilestones", linkedMilestones);
        return responseJson;
    }

    private void populateLinkedItemById(List<BaseItemLink> itemLinks, Session session) {
        List itemIds = itemLinks.stream().filter(link -> PropertyValidator.isValid((Object)link.getItemId())).map(BaseItemLink::getItemId).collect(Collectors.toList());
        if (itemIds.isEmpty()) {
            return;
        }
        List items = this.itemRepository.findByIdIn(itemIds);
        Map<String, Map> linkedItemsById = items.stream().collect(Collectors.toMap(BaseEntity::getId, item -> {
            HashMap<String, String> itemDetails = new HashMap<String, String>();
            itemDetails.put("session_title", session.getTitle());
            itemDetails.put("externalReferenceURL", item.getExternalReferenceURL());
            itemDetails.put("session_id", session.getId());
            itemDetails.put("sessionBoard_id", session.getActiveSessionBoard());
            if (PropertyValidator.isValid((Object)item.getJiraId())) {
                itemDetails.put("jiraKey", item.getJiraKey());
                itemDetails.put("jiraId", item.getJiraId());
                itemDetails.put("key", item.getJiraKey());
            } else if (PropertyValidator.isValid((Object)item.getTfsId())) {
                itemDetails.put("tfsURL", item.getTfsURL());
                itemDetails.put("tfsId", item.getTfsId());
                itemDetails.put("key", item.getTfsId());
            }
            return itemDetails;
        }));
        itemLinks.forEach(itemLink -> {
            if (PropertyValidator.isValid((Object)itemLink.getItemId())) {
                itemLink.setLinkedItemById(Collections.singletonMap(itemLink.getItemId(), linkedItemsById.get(itemLink.getItemId())));
            }
        });
    }

    public Map<String, Object> linkPiItemsWithMilestones(Map<String, Object> requestBody) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String milestoneId = (String)KendisUtils.getValue(requestBody, (String)"milestoneId", String.class);
            String releaseTrainId = (String)KendisUtils.getValue(requestBody, (String)"releaseTrainId", String.class);
            String sessionId = (String)KendisUtils.getValue(requestBody, (String)"sessionId", String.class);
            String almType = (String)KendisUtils.getValue(requestBody, (String)"almType", String.class);
            Map selectedItemsMap = KendisUtils.getMapValue(requestBody, (String)"selectedItemsMap", Object.class);
            BacklogItem milestone = this.backlogItemRepository.findById(milestoneId);
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            if (session == null) {
                response.put("error", true);
                response.put("message", "Session is not valid");
                return response;
            }
            if (!PropertyValidator.isValid((Object)milestone)) {
                response.put("error", true);
                response.put("message", "Milestone is not valid");
                return response;
            }
            List existingLinks = milestone.getItemRelations();
            Set existingItemIds = existingLinks.stream().filter(link -> PropertyValidator.isValid((Object)link.getItemId())).map(BaseItemLink::getItemId).collect(Collectors.toSet());
            ArrayList<BaseItemLink> newLinks = new ArrayList<BaseItemLink>();
            for (Map.Entry entry : selectedItemsMap.entrySet()) {
                String key;
                BacklogItem backlogItem;
                Item kendisItem;
                String itemId = (String)entry.getKey();
                Map itemDetails = KendisUtils.getMapValue((Map)selectedItemsMap, (String)itemId, Object.class);
                String almItemId = (String)KendisUtils.getValue((Map)itemDetails, (String)"almItemId", String.class);
                if (PropertyValidator.isValid((Object)almItemId) && PropertyValidator.isValid((Object)releaseTrainId)) {
                    boolean exists = existingLinks.stream().anyMatch(link -> almItemId.equals(link.getAlmItemId()) && releaseTrainId.equals(link.getReleaseTrainId()) && EnumKendis.BACKLOG_ITEM.getCode().equals(link.getLinkType()));
                    if (!exists) {
                        Query query = new Query();
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"almItemId").is((Object)almItemId));
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)("artRelationMap." + releaseTrainId)).exists(true));
                        query.fields().include("_id").include("almItemId");
                        List foundItems = this.mongoTemplate.find(query, BacklogItem.class, "backlogItem");
                        if (PropertyValidator.isValid((Collection)foundItems)) {
                            for (BacklogItem currentBacklogItem : foundItems) {
                                BaseItemLink baseItemLink = milestone.linkToBacklogItem(releaseTrainId, currentBacklogItem.getId(), currentBacklogItem.getAlmItemId(), almType);
                            }
                        }
                    }
                } else if (!PropertyValidator.isValid((Object)almItemId) && PropertyValidator.isValid((Object)releaseTrainId) && PropertyValidator.isValid((Object)(kendisItem = this.itemRepository.findById(itemId))) && PropertyValidator.isValid((Object)(backlogItem = (BacklogItem)this.backlogItemRepository.findByKendisKey(key = kendisItem.getKendisKey()).orElse(null)))) {
                    Set releaseTrainIds = backlogItem.getArtRelationMap().keySet();
                    boolean exists = existingLinks.stream().anyMatch(link -> backlogItem.getId().equals(link.getBaseItemId()) && releaseTrainIds.contains(link.getReleaseTrainId()) && EnumKendis.BACKLOG_ITEM.getCode().equals(link.getLinkType()));
                    if (!exists && PropertyValidator.isValid((Object)kendisItem.getFields()) && kendisItem.getFields().containsKey("artRelationMap")) {
                        HashMap artRelationMap = (HashMap)kendisItem.getFields().get("artRelationMap");
                        Set artRelationIds = artRelationMap.keySet();
                        Optional<String> commonReleaseTrain = releaseTrainIds.stream().filter(artRelationIds::contains).findFirst();
                        if (commonReleaseTrain.isPresent()) {
                            milestone.linkToBacklogItem(commonReleaseTrain.get(), backlogItem.getId(), backlogItem.getAlmItemId(), almType);
                        }
                    }
                }
                if (existingItemIds.contains(itemId)) continue;
                BaseItemLink link2 = new BaseItemLink();
                link2.setIsSystemLink(Boolean.valueOf(true));
                link2.setSessionId(sessionId);
                link2.setItemId(itemId);
                if (PropertyValidator.isValid((Object)almItemId) && PropertyValidator.isValid((Object)almType)) {
                    link2.setAlmItemId(almItemId);
                    link2.setAlmType(almType);
                }
                link2.setLinkType(EnumKendis.PI_BOARD_ITEM.getCode());
                link2.setId(link2.getLinkType() + "_" + itemId);
                newLinks.add(link2);
            }
            this.populateLinkedItemById(newLinks, session);
            milestone.getItemRelations().addAll(newLinks);
            milestone = (BacklogItem)this.backlogItemRepository.save((Object)milestone);
            response.put("success", true);
            response.put("milestone", milestone);
        }
        catch (Exception e) {
            response.put("error", true);
            response.put("message", e.getMessage());
        }
        return response;
    }

    public Map<String, Object> fetchPiItemsLinkedWithMilestone(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List linkedItems = new ArrayList();
        try {
            List linkedBacklogKendisItems;
            Object link22;
            ArrayList<Object> newLinks;
            List items;
            Query query;
            List sessionBoardIds;
            List sessionBoards;
            String milestoneId = (String)KendisUtils.getValue(requestBody, (String)"milestoneId", String.class);
            String almType = (String)KendisUtils.getValue(requestBody, (String)"almType", String.class);
            String sessionId = (String)KendisUtils.getValue(requestBody, (String)"sessionId", String.class);
            BacklogItem milestone = this.backlogItemRepository.findById(milestoneId);
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            if (!PropertyValidator.isValid((Object)session)) {
                response.put("error", true);
                response.put("message", "Session is not valid");
                return response;
            }
            if (!PropertyValidator.isValid((Object)milestone)) {
                response.put("error", true);
                response.put("message", "Milestone is not valid");
                return response;
            }
            List itemRelations = milestone.getItemRelations();
            List piAlmItems = itemRelations.stream().filter(link -> PropertyValidator.isValid((Object)link.getAlmItemId()) && link.getLinkType().equals(EnumKendis.PI_BOARD_ITEM.getCode())).collect(Collectors.toList());
            if (PropertyValidator.isValid(piAlmItems)) {
                List ids = piAlmItems.stream().map(BaseItemLink::getAlmItemId).collect(Collectors.toList());
                List activeItems = new ArrayList();
                if (almType.equals("jira")) {
                    activeItems = this.itemRepository.findByJiraIdInAndSessionBoardsIdIn(ids, Collections.singletonList(session.getActiveSessionBoard()));
                } else if (almType.equals("tfs")) {
                    activeItems = this.itemRepository.findByTfsIdInAndSessionBoardsIdIn(ids, Collections.singletonList(session.getActiveSessionBoard()));
                }
                if (PropertyValidator.isValid(activeItems)) {
                    Map<String, Item> activeItemsMap = activeItems.stream().collect(Collectors.toMap(BaseEntity::getId, item -> item));
                    List inactiveBoardItemLinks = piAlmItems.stream().filter(link -> !activeItemsMap.containsKey(link.getItemId())).collect(Collectors.toList());
                    for (BaseItemLink link3 : inactiveBoardItemLinks) {
                        Item matchingActiveItem = null;
                        if (almType.equals("jira")) {
                            matchingActiveItem = activeItems.stream().filter(item -> item.getJiraId().equals(link3.getAlmItemId())).findFirst().orElse(null);
                        } else if (almType.equals("tfs")) {
                            matchingActiveItem = activeItems.stream().filter(item -> item.getTfsId().equals(link3.getAlmItemId())).findFirst().orElse(null);
                        }
                        if (!PropertyValidator.isValid(matchingActiveItem) || !link3.getSessionId().equals(sessionId) || !link3.getAlmType().equals(almType) || (!almType.equals("jira") || !link3.getAlmItemId().equals(matchingActiveItem.getJiraId())) && (!almType.equals("tfs") || !link3.getAlmItemId().equals(matchingActiveItem.getTfsId()))) continue;
                        link3.setItemId(matchingActiveItem.getId());
                        link3.setId(link3.getLinkType() + "_" + matchingActiveItem.getId());
                    }
                }
            }
            List backlogItemRelations = itemRelations.stream().filter(link -> EnumKendis.BACKLOG_ITEM.getCode().equals(link.getLinkType())).collect(Collectors.toList());
            List piBoardItemRelations = itemRelations.stream().filter(link -> EnumKendis.PI_BOARD_ITEM.getCode().equals(link.getLinkType())).collect(Collectors.toList());
            ArrayList<String> tfsIds = new ArrayList<String>();
            ArrayList<String> jiraIds = new ArrayList<String>();
            ArrayList<String> kendisIds = new ArrayList<String>();
            for (BaseItemLink link4 : backlogItemRelations) {
                String almItemId = link4.getAlmItemId();
                if ("jira".equals(link4.getAlmType())) {
                    jiraIds.add(almItemId);
                    continue;
                }
                if ("tfs".equals(link4.getAlmType())) {
                    tfsIds.add(almItemId);
                    continue;
                }
                kendisIds.add(link4.getBaseItemId());
            }
            if ("jira".equals(almType)) {
                jiraIds.removeIf(id -> piBoardItemRelations.stream().anyMatch(link -> id.equals(link.getAlmItemId()) && almType.equals(link.getAlmType()) && sessionId.equals(link.getSessionId())));
                if (PropertyValidator.isValid(jiraIds) && PropertyValidator.isValid((Collection)(sessionBoards = this.sessionBoardRepository.findBySessionId(sessionId)))) {
                    sessionBoardIds = sessionBoards.stream().map(sessionBoard -> new ObjectId(sessionBoard.getId())).collect(Collectors.toList());
                    query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").in(jiraIds));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in(sessionBoardIds));
                    items = this.mongoTemplate.find(query, Item.class);
                    newLinks = new ArrayList<Object>();
                    for (Item item2 : items) {
                        link22 = new BaseItemLink();
                        link22.setIsSystemLink(Boolean.valueOf(true));
                        link22.setSessionId(sessionId);
                        link22.setItemId(item2.getId());
                        link22.setAlmItemId(item2.getJiraId());
                        link22.setAlmType(almType);
                        link22.setLinkType(EnumKendis.PI_BOARD_ITEM.getCode());
                        link22.setId(link22.getLinkType() + "_" + item2.getId());
                        newLinks.add(link22);
                    }
                    piBoardItemRelations.addAll(newLinks);
                }
            } else if ("tfs".equals(almType)) {
                tfsIds.removeIf(id -> piBoardItemRelations.stream().anyMatch(link -> id.equals(link.getAlmItemId()) && almType.equals(link.getAlmType()) && sessionId.equals(link.getSessionId())));
                if (PropertyValidator.isValid(tfsIds) && PropertyValidator.isValid((Collection)(sessionBoards = this.sessionBoardRepository.findBySessionId(sessionId)))) {
                    sessionBoardIds = sessionBoards.stream().map(sessionBoard -> new ObjectId(sessionBoard.getId())).collect(Collectors.toList());
                    query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"tfsId").in(tfsIds));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in(sessionBoardIds));
                    items = this.mongoTemplate.find(query, Item.class);
                    newLinks = new ArrayList();
                    for (Item item2 : items) {
                        link22 = new BaseItemLink();
                        link22.setIsSystemLink(Boolean.valueOf(true));
                        link22.setSessionId(sessionId);
                        link22.setItemId(item2.getId());
                        link22.setAlmItemId(item2.getTfsId());
                        link22.setAlmType(almType);
                        link22.setLinkType(EnumKendis.PI_BOARD_ITEM.getCode());
                        link22.setId(link22.getLinkType() + "_" + item2.getId());
                        newLinks.add(link22);
                    }
                    piBoardItemRelations.addAll(newLinks);
                }
            }
            if (PropertyValidator.isValid(kendisIds) && PropertyValidator.isValid((Collection)(linkedBacklogKendisItems = this.backlogItemRepository.findByIdIn(kendisIds)))) {
                List linkedKeys = linkedBacklogKendisItems.stream().map(BacklogItem::getKendisKey).collect(Collectors.toList());
                List sessionBoards2 = this.sessionBoardRepository.findBySessionId(sessionId);
                if (PropertyValidator.isValid((Collection)sessionBoards2)) {
                    List sessionBoardIds2 = sessionBoards2.stream().map(sessionBoard -> new ObjectId(sessionBoard.getId())).collect(Collectors.toList());
                    Query query2 = new Query();
                    query2.addCriteria((CriteriaDefinition)Criteria.where((String)"kendisKey").in(linkedKeys));
                    query2.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in(sessionBoardIds2));
                    List items2 = this.mongoTemplate.find(query2, Item.class);
                    ArrayList<BaseItemLink> newLinks2 = new ArrayList<BaseItemLink>();
                    for (Item item3 : items2) {
                        BaseItemLink link5 = new BaseItemLink();
                        link5.setIsSystemLink(Boolean.valueOf(true));
                        link5.setSessionId(sessionId);
                        link5.setItemId(item3.getId());
                        link5.setLinkType(EnumKendis.PI_BOARD_ITEM.getCode());
                        link5.setId(link5.getLinkType() + "_" + item3.getId());
                        newLinks2.add(link5);
                    }
                    piBoardItemRelations.addAll(newLinks2);
                }
            }
            if (PropertyValidator.isValid(piBoardItemRelations)) {
                HashMap<String, Boolean> addFieldInItem = new HashMap<String, Boolean>();
                addFieldInItem.put("sessionBoards", false);
                addFieldInItem.put("featureStoryPoints", false);
                HashMap activeBoardItemsMap = this.externalEntitiesService.setActiveBoardItems((BaseItem)milestone, Collections.singletonList(session), null, new HashMap(), piBoardItemRelations, addFieldInItem);
                linkedItems = KendisUtils.getListValue((Map)activeBoardItemsMap, (String)"linkedItems", Item.class);
                HashMap updatedLinkedItemsById = new HashMap();
                if (PropertyValidator.isValid(linkedItems)) {
                    ArrayList<String> parentIds = new ArrayList<String>();
                    for (Item item4 : linkedItems) {
                        if (!item4.getType().equals("Feature")) continue;
                        parentIds.add(item4.getId());
                    }
                    String tenant = session.getTenant();
                    Map parentChildItemsMap = this.externalEntitiesService.fetchChildItemsGroupedByParentId(parentIds, tenant);
                    if (PropertyValidator.isValid((Object)parentChildItemsMap)) {
                        for (Item item5 : linkedItems) {
                            if (!item5.getType().equals("Feature") || !PropertyValidator.isValid((Collection)((Collection)parentChildItemsMap.get(item5.getId())))) continue;
                            item5.setSubItems((List)parentChildItemsMap.get(item5.getId()));
                        }
                    }
                    activeBoardItemsMap.put("linkedItems", linkedItems);
                    for (Object link22 : piBoardItemRelations) {
                        if (!PropertyValidator.isValid((Object)link22.getLinkedItemById())) continue;
                        updatedLinkedItemsById.putAll(link22.getLinkedItemById());
                    }
                    for (Item linkedItem : linkedItems) {
                        String linkedItemId = linkedItem.getId();
                        if (PropertyValidator.isValid((Object)linkedItem.getJiraId())) {
                            this.updateLinkedItemById(updatedLinkedItemsById, linkedItem, linkedItemId, "jiraId", linkedItem.getJiraId(), piBoardItemRelations);
                            continue;
                        }
                        if (!PropertyValidator.isValid((Object)linkedItem.getTfsId())) continue;
                        this.updateLinkedItemById(updatedLinkedItemsById, linkedItem, linkedItemId, "tfsId", linkedItem.getTfsId(), piBoardItemRelations);
                    }
                }
                List linkedItemsIds = KendisUtils.getListValue((Map)activeBoardItemsMap, (String)"linkedItemsIds", String.class);
                ArrayList combinedItemRelations = new ArrayList(backlogItemRelations);
                combinedItemRelations.addAll(piBoardItemRelations);
                milestone.setItemRelations(combinedItemRelations);
                milestone.setLinkedItems(linkedItems);
                milestone.setLinkedItemsIds(linkedItemsIds);
                milestone.setLinkedItemsById(updatedLinkedItemsById);
                milestone = (BacklogItem)this.backlogItemRepository.save((Object)milestone);
                response.put("linkedItemsIds", linkedItemsIds);
                response.put("linkedItemsById", updatedLinkedItemsById);
            }
            response.put("success", true);
            response.put("linkedItems", linkedItems);
        }
        catch (Exception e) {
            response.put("error", true);
            response.put("message", e.getMessage());
        }
        return response;
    }

    private void updateLinkedItemById(Map<String, Object> linkedItemsById, Item linkedItem, String linkedItemId, String idField, String idValue, List<BaseItemLink> itemRelations) {
        for (Map.Entry<String, Object> entry : linkedItemsById.entrySet()) {
            Map itemMap = (Map)entry.getValue();
            if (!PropertyValidator.isValid((Object)itemMap) || !idValue.equals(itemMap.get(idField)) || entry.getKey().equals(linkedItemId)) continue;
            String oldKey = entry.getKey();
            this.updateItemRelation(itemRelations, linkedItemId, oldKey);
        }
    }

    private void updateItemRelation(List<BaseItemLink> itemRelations, String newItemId, String oldItemId) {
        for (BaseItemLink link : itemRelations) {
            if (!oldItemId.equals(link.getItemId())) continue;
            link.setItemId(newItemId);
            link.setLinkedItemById(Collections.singletonMap(newItemId, link.getLinkedItemById().get(oldItemId)));
        }
    }

    public Map<String, Object> unlinkPiItemsLinkedWithMilestone(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String milestoneId = (String)KendisUtils.getValue(requestBody, (String)"milestoneId", String.class);
            String sessionId = (String)KendisUtils.getValue(requestBody, (String)"sessionId", String.class);
            String itemId = (String)KendisUtils.getValue(requestBody, (String)"itemId", String.class);
            String almType = (String)KendisUtils.getValue(requestBody, (String)"almType", String.class);
            if (!PropertyValidator.isValid((Object)sessionId)) {
                response.put("error", true);
                response.put("message", "Session Id is not valid");
                return response;
            }
            if (!PropertyValidator.isValid((Object)itemId)) {
                response.put("error", true);
                response.put("message", "Item Id is not valid");
                return response;
            }
            BacklogItem milestone = this.backlogItemRepository.findById(milestoneId);
            if (!PropertyValidator.isValid((Object)milestone)) {
                response.put("error", true);
                response.put("message", "Milestone is not valid");
                return response;
            }
            List itemRelations = milestone.getItemRelations();
            BaseItemLink matchingLink = itemRelations.stream().filter(item -> sessionId.equals(item.getSessionId()) && EnumKendis.PI_BOARD_ITEM.getCode().equals(item.getLinkType()) && itemId.equals(item.getItemId())).findFirst().orElse(null);
            if (PropertyValidator.isValid((Object)matchingLink) && PropertyValidator.isValid((Object)matchingLink.getAlmItemId())) {
                String almItemId = matchingLink.getAlmItemId();
                itemRelations.removeIf(baseItemLink -> baseItemLink.getAlmType() != null && baseItemLink.getAlmItemId() != null && baseItemLink.getAlmType().equals(almType) && baseItemLink.getAlmItemId().equals(almItemId));
            } else {
                itemRelations.removeIf(baseItemLink -> PropertyValidator.isValid((Object)baseItemLink.getItemId()) && itemId.equals(baseItemLink.getItemId()));
            }
            milestone.setItemRelations(itemRelations);
            milestone = (BacklogItem)this.backlogItemRepository.save((Object)milestone);
            response.put("success", true);
            response.put("milestone", milestone);
        }
        catch (Exception e) {
            response.put("error", true);
            response.put("message", e.getMessage());
        }
        return response;
    }

    public Map<String, Object> deleteMilestoneFromPi(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String milestoneId = (String)KendisUtils.getValue(requestBody, (String)"milestoneId", String.class);
            String sessionId = (String)KendisUtils.getValue(requestBody, (String)"sessionId", String.class);
            String releaseTrainId = (String)KendisUtils.getValue(requestBody, (String)"releaseTrainId", String.class);
            if (!PropertyValidator.isValid((Object)sessionId)) {
                response.put("error", true);
                response.put("message", "Session ID is not valid");
                return response;
            }
            if (!PropertyValidator.isValid((Object)releaseTrainId)) {
                response.put("error", true);
                response.put("message", "Release Train ID is not valid");
                return response;
            }
            BacklogItem milestone = this.backlogItemRepository.findById(milestoneId);
            if (!PropertyValidator.isValid((Object)milestone)) {
                response.put("error", true);
                response.put("message", "Milestone is not valid");
                return response;
            }
            milestone.getBoardRelations().removeIf(boardRelation -> sessionId.equals(boardRelation.getSessionId()) && releaseTrainId.equals(boardRelation.getReleaseTrainId()) && EnumKendis.ART_BOARD_LINK.getCode().equals(boardRelation.getLinkType()));
            milestone.getItemRelations().removeIf(itemRelation -> PropertyValidator.isValid((Object)itemRelation.getSessionId()) && sessionId.equals(itemRelation.getSessionId()) && EnumKendis.PI_BOARD_ITEM.getCode().equals(itemRelation.getLinkType()));
            milestone = (BacklogItem)this.backlogItemRepository.save((Object)milestone);
            response.put("success", true);
            response.put("milestone", milestone);
        }
        catch (Exception e) {
            response.put("error", true);
            response.put("message", e.getMessage());
        }
        return response;
    }

    public Map<String, Object> searchCollections(String searchQuery, String tenant) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Query query = new Query();
            query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"isModule").is((Object)false));
            String options = "i";
            Criteria criteria1 = Criteria.where((String)"title").regex(searchQuery, options);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)criteria1);
            List collections = this.mongoTemplate.find(query, WorkSpace.class);
            responseJson.put("success", true);
            responseJson.put("collections", collections);
        }
        catch (Exception e) {
            LOGGER.error("Error searching collections: ", (Throwable)e);
            responseJson.put("success", false);
            responseJson.put("error", "Failed to search collections");
        }
        return responseJson;
    }

    public Map<String, Object> searchFromALM(Map<String, Object> requestBody) throws Exception {
        String result;
        HashMap<String, Object> responseJson;
        block9: {
            responseJson = new HashMap<String, Object>();
            Gson g = new Gson();
            String almId = (String)requestBody.get("almAccountId");
            AlmAccount almAccount = this.almAccountRepository.findById(almId);
            String query = (String)requestBody.get("query");
            String type = (String)requestBody.get("type");
            String url = null;
            result = "";
            if (almAccount.getType().equals("jira")) {
                url = type.equalsIgnoreCase("user") ? (almAccount.getUrl().contains("atlassian.net") ? "/rest/api/2/user/search?query=" + URLEncoder.encode(query, StandardCharsets.UTF_8.toString()) : "/rest/api/2/user/picker?query=" + URLEncoder.encode(query, StandardCharsets.UTF_8.toString())) : "/rest/greenhopper/1.0/sprint/picker?query=" + URLEncoder.encode(query, StandardCharsets.UTF_8.toString());
                try {
                    result = this.almSyncService.searchFromJira(url, almAccount);
                    responseJson.put("success", true);
                }
                catch (ViztrendJiraException e) {
                    if (e.getCode() == 401) {
                        responseJson.put("success", false);
                        responseJson.put("reason", 401);
                    } else if (e.getCode() == 404) {
                        responseJson.put("success", false);
                        responseJson.put("reason", 404);
                    }
                    break block9;
                }
            }
            try {
                result = this.tfsUtils.getUsers("10", query, almAccount);
                responseJson.put("success", true);
            }
            catch (ViztrendJiraException e) {
                if (e.getCode() == 401) {
                    responseJson.put("success", false);
                    responseJson.put("reason", 401);
                }
                if (e.getCode() != 404) break block9;
                responseJson.put("success", false);
                responseJson.put("reason", 404);
            }
        }
        responseJson.put("result", result);
        return responseJson;
    }

    public Map<String, Object> saveGroupConfig(GroupConfig groupConfig) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)groupConfig.getId())) {
            GroupConfig existingGroup = (GroupConfig)this.groupConfigRepository.findOne((Serializable)((Object)groupConfig.getId()));
            if (PropertyValidator.isValid((Object)existingGroup)) {
                existingGroup.setName(groupConfig.getName());
                existingGroup.setUserId(groupConfig.getUserId());
                existingGroup.setEntries(groupConfig.getEntries());
                GroupConfig newGroupConfig = (GroupConfig)this.groupConfigRepository.save((Object)existingGroup);
                responseJson.put("group", newGroupConfig);
                responseJson.put("success", true);
            }
            responseJson.put("new", false);
        } else {
            GroupConfig newGroupConfig = (GroupConfig)this.groupConfigRepository.save((Object)groupConfig);
            responseJson.put("new", true);
            responseJson.put("success", true);
            responseJson.put("group", newGroupConfig);
        }
        return responseJson;
    }

    public Map<String, Object> deleteGroupConfig(Map<String, Object> params) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String groupId = (String)params.get("groupId");
        this.groupConfigRepository.delete((Serializable)((Object)groupId));
        responseJson.put("success", true);
        return responseJson;
    }

    public void updateRoadmapSettings(HashMap<String, Object> reqbody) {
        String iterationPathDates = (String)reqbody.get("iterationPathDates");
        String datePreference = (String)reqbody.get("datePreference");
        String boardId = (String)reqbody.get("boardId");
        Board board = (Board)this.boardRepository.findOne((Serializable)((Object)boardId));
        if (PropertyValidator.isValid((Object)board)) {
            board.setIterationPathDates(Integer.valueOf(Integer.parseInt(iterationPathDates)));
            board.setDatePreference(Integer.valueOf(Integer.parseInt(datePreference)));
            this.boardRepository.save((Object)board);
        }
    }

    public Map<String, Object> getMilestonesStatuses() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List milestoneWorkflowList = this.workFlowRepository.findAllByWorkflowType(EnumKendis.MILESTONE.getCode());
        List milestoneStatus = new ArrayList();
        if (!PropertyValidator.isValid((Collection)milestoneWorkflowList)) {
            milestoneWorkflowList.add(this.createMilestoneWorkFlow());
        }
        milestoneStatus = this.statusRepository.findByWorkFlow((WorkFlow)milestoneWorkflowList.get(0));
        result.put("milestoneStatuses", milestoneStatus);
        return result;
    }

    public Map<String, Object> releaseTrainIgnoreListAdd(String releaseTrainId, String itemTfsId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        if (releaseTrain.getIgnoreItemsInResync() == null) {
            releaseTrain.setIgnoreItemsInResync(new HashMap());
        }
        releaseTrain.getIgnoreItemsInResync().put(itemTfsId, itemTfsId);
        this.workSpaceRepository.save((Object)releaseTrain);
        responseJson.put("success", true);
        return responseJson;
    }

    public Map<String, Object> releaseTrainIgnoreListRemove(String releaseTrainId, String itemTfsId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        if (PropertyValidator.isValid((Object)releaseTrain.getIgnoreItemsInResync())) {
            if (releaseTrain.getIgnoreItemsInResync().containsKey(itemTfsId)) {
                responseJson.put("success", true);
                releaseTrain.getIgnoreItemsInResync().remove(itemTfsId);
                this.workSpaceRepository.save((Object)releaseTrain);
            } else {
                responseJson.put("success", false);
            }
        } else {
            responseJson.put("success", false);
        }
        return responseJson;
    }

    public Map<String, Object> releaseTrainIgnoreListClear(String releaseTrainId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        if (PropertyValidator.isValid((Object)releaseTrain.getIgnoreItemsInResync())) {
            responseJson.put("success", true);
            releaseTrain.setIgnoreItemsInResync(new HashMap());
            this.workSpaceRepository.save((Object)releaseTrain);
        } else {
            responseJson.put("success", false);
        }
        return responseJson;
    }

    public Map<String, Object> saveMilestoneDateHistoryTags(Map<String, Object> params) throws Exception {
        BacklogItem milestone;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String milestoneId = params.getOrDefault("milestoneId", null);
        String historyTag = params.getOrDefault("historyTag", null);
        Boolean isRemove = (Boolean)params.getOrDefault("isRemove", false);
        if (PropertyValidator.isValid((Object)milestoneId) && PropertyValidator.isValid((Object)"historyTag") && PropertyValidator.isValid((Object)(milestone = this.backlogItemRepository.findById(milestoneId))) && milestone.getFields() != null) {
            Date dateValue;
            List historyTags = (List)milestone.getFields().computeIfAbsent("historyTags", k -> new ArrayList());
            if (isRemove.booleanValue()) {
                if (historyTags.contains(historyTag)) {
                    historyTags.remove(historyTag);
                    milestone.getFields().put("historyTags", historyTags);
                    BacklogItem saved = (BacklogItem)this.backlogItemRepository.save((Object)milestone);
                    responseJson.put("milestone", saved);
                }
            } else if (!historyTags.contains(historyTag) && (dateValue = PropertyValidator.parseDate((String)historyTag, (String)"yyyy-MM-dd'T'HH:mm:ss'Z'")) != null) {
                historyTags.add(ZonedDateTime.parse(historyTag).format(DateTimeFormatter.ISO_DATE_TIME));
                milestone.getFields().put("historyTags", historyTags);
                BacklogItem saved = (BacklogItem)this.backlogItemRepository.save((Object)milestone);
                responseJson.put("milestone", saved);
            }
        }
        return responseJson;
    }

    public Map<String, Object> enableLocalProjectSettings(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String projectId = (String)requestBody.get("projectId");
        String collectionId = (String)requestBody.get("collectionId");
        Boolean enableLocalSettings = (Boolean)requestBody.get("enableLocalSettings");
        TFSProject tfsProject = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)projectId));
        List allStatuses = this.statusRepository.findStatusAllByTfsProjectIdAndAlmId(tfsProject.getTfsId(), tfsProject.getAlmId());
        if (PropertyValidator.isValid((Object)tfsProject)) {
            if (enableLocalSettings.booleanValue()) {
                if (!PropertyValidator.isValid((Object)tfsProject.getHasMappingByCollectionId())) {
                    tfsProject.setHasMappingByCollectionId(new HashMap());
                }
                tfsProject.getHasMappingByCollectionId().put(collectionId, Boolean.TRUE);
                if (PropertyValidator.isValid((Collection)allStatuses)) {
                    for (Status status : allStatuses) {
                        if (status.getCategoryMappingByCollectionId() != null) continue;
                        status.setCategoryMappingByCollectionId(new HashMap());
                    }
                }
                this.statusRepository.save((Iterable)allStatuses);
                this.tfsProjectRepository.save((Object)tfsProject);
                responseJson.put("success", true);
                responseJson.put("statuses", allStatuses);
                responseJson.put("project", tfsProject);
            } else {
                if (PropertyValidator.isValid((Object)tfsProject.getHasMappingByCollectionId())) {
                    tfsProject.getHasMappingByCollectionId().remove(collectionId);
                }
                if (PropertyValidator.isValid((Collection)allStatuses)) {
                    for (Status status : allStatuses) {
                        if (!PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId())) continue;
                        status.getCategoryMappingByCollectionId().remove(collectionId);
                    }
                }
                this.statusRepository.save((Iterable)allStatuses);
                this.tfsProjectRepository.save((Object)tfsProject);
                responseJson.put("success", true);
                responseJson.put("statuses", allStatuses);
                responseJson.put("project", tfsProject);
            }
        }
        return responseJson;
    }

    public List<BacklogItem> searchKendisOnlyItems(String searchQuery, String releaseTrainId, Integer hierarchyLevel, String excludeParentId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)("artRelationMap." + releaseTrainId)).exists(true));
            if (hierarchyLevel != null) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)("artRelationMap." + releaseTrainId + ".backlogLevel")).is((Object)hierarchyLevel));
            }
            Criteria searchCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"title").regex(searchQuery, "i"), Criteria.where((String)"kendisKey").regex(searchQuery, "i"), Criteria.where((String)"almKey").regex(searchQuery, "i"), Criteria.where((String)"almItemId").regex(searchQuery, "i")});
            query.addCriteria((CriteriaDefinition)searchCriteria);
            query.limit(50);
            return this.mongoTemplate.find(query, BacklogItem.class);
        }
        catch (Exception e) {
            LOGGER.error("Error searching Kendis-only items: ", (Throwable)e);
            return new ArrayList<BacklogItem>();
        }
    }

    public Map<String, Object> addExistingKendisItems(String itemIds, String releaseTrainId, String parentId, String boardId, Integer backlogLevel) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] itemIdArray = itemIds.split(",");
            List<String> itemIdList = Arrays.asList(itemIdArray);
            List itemsToAdd = this.backlogItemRepository.findByIdIn(itemIdList);
            if (!PropertyValidator.isValid((Collection)itemsToAdd)) {
                result.put("error", true);
                result.put("message", "No valid items found with the provided IDs");
                return result;
            }
            BacklogItem parentItem = this.updateParentChildExistingItems(releaseTrainId, parentId, itemsToAdd);
            if (parentItem == null) {
                result.put("error", true);
                result.put("message", "Parent item not found");
                return result;
            }
            result.put("success", true);
            result.put("items", itemsToAdd);
        }
        catch (Exception e) {
            LOGGER.error("Error adding existing Kendis items: ", (Throwable)e);
            result.put("error", true);
            result.put("message", "Error occurred while adding items: " + e.getMessage());
        }
        return result;
    }

    public BacklogItem updateParentChildExistingItems(String releaseTrainId, String parentId, List<BacklogItem> itemsToAdd) throws Exception {
        BacklogItem parentItem = null;
        if (PropertyValidator.isValid((Object)parentId)) {
            parentItem = this.backlogItemRepository.findById(parentId);
        }
        if (PropertyValidator.isValid(parentItem)) {
            List itemsToUpdate;
            if (parentItem.getChildRelationMap() == null) {
                parentItem.setChildRelationMap(new HashMap());
            }
            if (parentItem.getChildRelationMap().get(releaseTrainId) == null) {
                parentItem.getChildRelationMap().put(releaseTrainId, new ArrayList());
            }
            HashMap<String, HashMap<String, String>> removeChildLink = new HashMap<String, HashMap<String, String>>();
            for (BacklogItem item : itemsToAdd) {
                try {
                    String existingParentId = null;
                    if (item.getParentRelationMap() == null) {
                        item.setParentRelationMap(new HashMap());
                    }
                    if (PropertyValidator.isValid((Object)item.getParentRelationMap()) && PropertyValidator.isValid((Collection)((Collection)item.getParentRelationMap().get(releaseTrainId)))) {
                        List parentsLinks = (List)item.getParentRelationMap().get(releaseTrainId);
                        BaseItemLink existingParentLink = (BaseItemLink)parentsLinks.get(0);
                        existingParentId = existingParentLink.getBacklogItemId().toString();
                    }
                    if (existingParentId != null) {
                        HashMap<String, String> childLinkMap = (HashMap<String, String>)removeChildLink.get(existingParentId);
                        if (childLinkMap == null) {
                            childLinkMap = new HashMap<String, String>();
                            removeChildLink.put(existingParentId, childLinkMap);
                        }
                        childLinkMap.put(item.getId(), item.getId());
                    }
                    ((List)parentItem.getChildRelationMap().get(releaseTrainId)).removeIf(link -> item.getId().equals(link.getBacklogItemId().toString()));
                    parentItem.linkToChild(releaseTrainId, item.getId());
                    item.getParentRelationMap().put(releaseTrainId, new ArrayList());
                    item.linkToParent(releaseTrainId, parentItem.getId());
                }
                catch (Exception e) {
                    LOGGER.error("Error processing item {}: ", (Object)item.getId(), (Object)e);
                }
            }
            if (PropertyValidator.isValid(itemsToAdd)) {
                itemsToAdd = this.backlogItemRepository.save(itemsToAdd);
            }
            if (PropertyValidator.isValid((Object)parentItem)) {
                this.backlogItemRepository.save((Object)parentItem);
            }
            if (!removeChildLink.isEmpty() && PropertyValidator.isValid((Collection)(itemsToUpdate = this.backlogItemRepository.findByIdIn(removeChildLink.keySet())))) {
                for (BacklogItem item : itemsToUpdate) {
                    HashMap childToRemove = (HashMap)removeChildLink.get(item.getId());
                    if (childToRemove.isEmpty()) continue;
                    ((List)item.getChildRelationMap().get(releaseTrainId)).removeIf(link -> childToRemove.containsKey(link.getBacklogItemId().toString()));
                }
                this.backlogItemRepository.save((Iterable)itemsToUpdate);
            }
            return parentItem;
        }
        return null;
    }

    public List<BacklogItem> searchPotentialParents(String searchQuery, String releaseTrainId, Integer hierarchyLevel, String excludeItemId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)("artRelationMap." + releaseTrainId)).exists(true));
            if (hierarchyLevel != null) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)("artRelationMap." + releaseTrainId + ".backlogLevel")).is((Object)hierarchyLevel));
            }
            if (PropertyValidator.isValid((Object)excludeItemId)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").ne((Object)excludeItemId));
            }
            Criteria searchCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"title").regex(searchQuery, "i"), Criteria.where((String)"kendisKey").regex(searchQuery, "i"), Criteria.where((String)"almKey").regex(searchQuery, "i")});
            query.addCriteria((CriteriaDefinition)searchCriteria);
            query.limit(50);
            return this.mongoTemplate.find(query, BacklogItem.class);
        }
        catch (Exception e) {
            LOGGER.error("Error searching potential parents: ", (Throwable)e);
            return new ArrayList<BacklogItem>();
        }
    }

    public Map<String, Object> addParentToItem(String itemId, String parentId, String releaseTrainId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            AlmAccount almAccount;
            BacklogItem item = this.backlogItemRepository.findById(itemId);
            BacklogItem parent = this.backlogItemRepository.findById(parentId);
            if (item == null) {
                result.put("error", true);
                result.put("message", "Item not found");
                return result;
            }
            if (parent == null) {
                result.put("error", true);
                result.put("message", "Parent item not found");
                return result;
            }
            String olderParentId = null;
            if (item.getParentRelationMap() != null && item.getParentRelationMap().containsKey(releaseTrainId) && !((List)item.getParentRelationMap().get(releaseTrainId)).isEmpty()) {
                olderParentId = ((BaseItemLink)((List)item.getParentRelationMap().get(releaseTrainId)).get(0)).getBacklogItemId().toString();
            }
            BacklogItem olderParent = null;
            if (olderParentId != null) {
                olderParent = this.backlogItemRepository.findById(olderParentId);
            }
            if (item.getParentRelationMap() == null) {
                item.setParentRelationMap(new HashMap());
            }
            item.getParentRelationMap().put(releaseTrainId, new ArrayList());
            if (parent.getChildRelationMap() == null) {
                parent.setChildRelationMap(new HashMap());
            }
            if (!parent.getChildRelationMap().containsKey(releaseTrainId)) {
                parent.getChildRelationMap().put(releaseTrainId, new ArrayList());
            }
            if (PropertyValidator.isValid((Object)olderParent)) {
                if (PropertyValidator.isValid((Object)olderParent.getChildRelationMap()) && PropertyValidator.isValid((Collection)((Collection)olderParent.getChildRelationMap().get(releaseTrainId)))) {
                    ((List)olderParent.getChildRelationMap().get(releaseTrainId)).removeIf(link -> link.getBacklogItemId().toString().equals(item.getId()));
                }
                this.backlogItemRepository.save((Object)olderParent);
                result.put("oldParent", olderParent);
                if (PropertyValidator.isValid((Object)olderParent.getAlmItemId()) && PropertyValidator.isValid((Object)item.getAlmItemId()) && PropertyValidator.isValid((Object)(almAccount = this.almAccountRepository.findById(item.getAlmAccountId()))) && PropertyValidator.isValid((Object)almAccount.getType()) && almAccount.getType().equals("tfs")) {
                    this.tfsService.removeRelationInTFS(item.getAlmItemId(), olderParent.getAlmItemId(), almAccount);
                }
            }
            item.linkToParent(releaseTrainId, parentId);
            parent.linkToChild(releaseTrainId, itemId);
            if (PropertyValidator.isValid((Object)parent.getAlmItemId()) && PropertyValidator.isValid((Object)item.getAlmItemId()) && PropertyValidator.isValid((Object)(almAccount = this.almAccountRepository.findById(item.getAlmAccountId())))) {
                BaseItemLink artRelation;
                WorkSpace releaseTrain = this.workSpaceRepository.findByIdOrKey(releaseTrainId, releaseTrainId);
                BacklogHierarchy backlogHierarchy = (BacklogHierarchy)this.backlogHierarchyRepository.findOne((Serializable)((Object)releaseTrain.getLinkedAlmHierarchy()));
                int parentLevel = -1;
                if (PropertyValidator.isValid((Object)parent.getArtRelationMap()) && PropertyValidator.isValid((Object)(artRelation = (BaseItemLink)parent.getArtRelationMap().get(releaseTrainId)))) {
                    parentLevel = artRelation.getBacklogLevel();
                }
                int _parentLevel = parentLevel;
                HierarchyLevel hierarchyLevel = backlogHierarchy.getHierarchyLevels().stream().filter(_level -> _level.getLevel() == _parentLevel).findAny().orElse(null);
                if (PropertyValidator.isValid((Object)hierarchyLevel)) {
                    AlmHierarchyLevelMapping almMapping = hierarchyLevel.getAlmHierarchyLevelMappings().stream().filter(mapping -> mapping.getAlmAccountId().equals(almAccount.getId())).findAny().orElse(null);
                    if (PropertyValidator.isValid((Object)almAccount.getType()) && almAccount.getType().equals("tfs") && PropertyValidator.isValid((Object)almMapping) && PropertyValidator.isValid((Collection)almMapping.getTfsItemLinkTypes())) {
                        HashMap<String, JSONObject> fields = new HashMap<String, JSONObject>();
                        TFSItemLinkType itemLinkType = (TFSItemLinkType)almMapping.getTfsItemLinkTypes().get(0);
                        String relation = itemLinkType.getReferenceName();
                        JSONObject relationObj = new JSONObject();
                        relationObj.put("rel", (Object)relation);
                        relationObj.put("url", (Object)item.getUrl());
                        fields.put("relation", relationObj);
                        TFSResponse response = null;
                        try {
                            response = this.tfsUtils.updateItemInTFS(parent.getAlmItemId(), fields, almAccount);
                            if (parent.getFields().containsKey("AlmSyncError")) {
                                parent.getFields().remove("AlmSyncError");
                            }
                            if (parent.getFields().containsKey("AlmErrorMesaage")) {
                                parent.getFields().remove("AlmErrorMesaage");
                            }
                            parent.getFields().put("AlmSyncError", false);
                        }
                        catch (ViztrendJiraException vje) {
                            LOGGER.error("Error: ", (Throwable)vje);
                            if (parent.getFields().containsKey("AlmSyncError")) {
                                parent.getFields().remove("AlmSyncError");
                            }
                            if (parent.getFields().containsKey("AlmErrorMesaage")) {
                                parent.getFields().remove("AlmErrorMesaage");
                            }
                            parent.getFields().put("AlmSyncError", true);
                            parent.getFields().put("AlmErrorMesaage", vje.getMessage());
                        }
                    }
                }
            }
            this.backlogItemRepository.save((Object)item);
            this.backlogItemRepository.save((Object)parent);
            result.put("success", true);
            result.put("item", item);
            result.put("parent", parent);
            result.put("message", "Parent added successfully");
        }
        catch (Exception e) {
            LOGGER.error("Error adding parent to item: ", (Throwable)e);
            result.put("error", true);
            result.put("message", "Error occurred while adding parent: " + e.getMessage());
        }
        return result;
    }

    public List<WorkSpace> getCompatibleCollections(String currentReleaseTrainId) {
        try {
            WorkSpace currentReleaseTrain = this.workSpaceRepository.findByIdOrKey(currentReleaseTrainId, currentReleaseTrainId);
            if (currentReleaseTrain == null) {
                LOGGER.warn("Current release train not found: {}", (Object)currentReleaseTrainId);
                return new ArrayList<WorkSpace>();
            }
            String linkedAlmHierarchy = currentReleaseTrain.getLinkedAlmHierarchy();
            if (!PropertyValidator.isValid((Object)linkedAlmHierarchy)) {
                LOGGER.warn("Current release train has no linked ALM hierarchy: {}", (Object)currentReleaseTrainId);
                return new ArrayList<WorkSpace>();
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"linkedAlmHierarchy").is((Object)linkedAlmHierarchy));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").ne((Object)currentReleaseTrainId));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").ne((Object)currentReleaseTrainId));
            List compatibleCollections = this.mongoTemplate.find(query, WorkSpace.class);
            LOGGER.info("Found {} compatible collections for release train {}", (Object)compatibleCollections.size(), (Object)currentReleaseTrainId);
            return compatibleCollections;
        }
        catch (Exception e) {
            LOGGER.error("Error getting compatible collections: ", (Throwable)e);
            return new ArrayList<WorkSpace>();
        }
    }

    public Map<String, Object> addItemToCollection(String itemId, String sourceReleaseTrainId, String targetReleaseTrainId, Boolean addWithHierarchy) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<BacklogItem> processedItems = new ArrayList<BacklogItem>();
        try {
            List childRelations;
            BacklogItem item = this.backlogItemRepository.findById(itemId);
            if (item == null) {
                result.put("error", true);
                result.put("message", "Item not found");
                return result;
            }
            WorkSpace sourceReleaseTrain = this.workSpaceRepository.findByIdOrKey(sourceReleaseTrainId, sourceReleaseTrainId);
            WorkSpace targetReleaseTrain = this.workSpaceRepository.findByIdOrKey(targetReleaseTrainId, targetReleaseTrainId);
            if (sourceReleaseTrain == null) {
                result.put("error", true);
                result.put("message", "Source release train not found");
                return result;
            }
            if (targetReleaseTrain == null) {
                result.put("error", true);
                result.put("message", "Target release train not found");
                return result;
            }
            if (!(PropertyValidator.isValid((Object)sourceReleaseTrain.getLinkedAlmHierarchy()) && PropertyValidator.isValid((Object)targetReleaseTrain.getLinkedAlmHierarchy()) && sourceReleaseTrain.getLinkedAlmHierarchy().equals(targetReleaseTrain.getLinkedAlmHierarchy()))) {
                result.put("error", true);
                result.put("message", "Source and target collections must have the same backlog hierarchy");
                return result;
            }
            if (PropertyValidator.isValid((Object)item.getFields()) && item.getFields().containsKey("tfsProjectId")) {
                TFSProject matchedProject;
                String tfsProjectId = (String)item.getFields().get("tfsProjectId");
                List tfsProjects = this.tfsProjectRepository.findProjectByAlmIdAndLinkedWorkspaceKeysIn(item.getAlmAccountId(), targetReleaseTrain.getKey());
                boolean projectFound = false;
                if (PropertyValidator.isValid((Collection)tfsProjects) && (matchedProject = (TFSProject)tfsProjects.stream().filter(pr -> pr.getTfsId().equals(tfsProjectId)).findFirst().orElse(null)) != null) {
                    projectFound = true;
                }
                if (!projectFound) {
                    result.put("error", true);
                    result.put("message", "Tfs Project of item is not loaded in target Collection.");
                    return result;
                }
            }
            ArrayList<BacklogItem> itemsToProcess = new ArrayList<BacklogItem>();
            itemsToProcess.add(item);
            if (addWithHierarchy != null && addWithHierarchy.booleanValue() && item.getChildRelationMap() != null && item.getChildRelationMap().containsKey(sourceReleaseTrainId) && (childRelations = (List)item.getChildRelationMap().get(sourceReleaseTrainId)) != null && !childRelations.isEmpty()) {
                List childIds = childRelations.stream().map(relation -> relation.getBacklogItemId().toString()).collect(Collectors.toList());
                this.collectItemHierarchy(childIds, sourceReleaseTrainId, itemsToProcess);
            }
            for (BacklogItem itemToProcess : itemsToProcess) {
                try {
                    List childRelations2;
                    List parentRelations;
                    if (itemToProcess.getArtRelationMap() != null && itemToProcess.getArtRelationMap().containsKey(targetReleaseTrainId)) {
                        LOGGER.info("Item {} is already in target collection {}", (Object)itemToProcess.getId(), (Object)targetReleaseTrainId);
                        continue;
                    }
                    if (itemToProcess.getArtRelationMap() == null) {
                        itemToProcess.setArtRelationMap(new HashMap());
                    }
                    BaseItemLink sourceRelation = (BaseItemLink)itemToProcess.getArtRelationMap().get(sourceReleaseTrainId);
                    itemToProcess.linkToRTE(targetReleaseTrainId, sourceRelation.getBacklogLevel());
                    if (itemToProcess.getParentRelationMap() != null && itemToProcess.getParentRelationMap().containsKey(sourceReleaseTrainId) && (parentRelations = (List)itemToProcess.getParentRelationMap().get(sourceReleaseTrainId)) != null && !parentRelations.isEmpty()) {
                        if (itemToProcess.getParentRelationMap() == null) {
                            itemToProcess.setParentRelationMap(new HashMap());
                        }
                        itemToProcess.getParentRelationMap().put(targetReleaseTrainId, new ArrayList());
                        for (BaseItemLink parentRelation : parentRelations) {
                            itemToProcess.linkToParent(targetReleaseTrainId, parentRelation.getBacklogItemId().toString());
                        }
                    }
                    if (itemToProcess.getChildRelationMap() != null && itemToProcess.getChildRelationMap().containsKey(sourceReleaseTrainId) && (childRelations2 = (List)itemToProcess.getChildRelationMap().get(sourceReleaseTrainId)) != null && !childRelations2.isEmpty()) {
                        if (itemToProcess.getChildRelationMap() == null) {
                            itemToProcess.setChildRelationMap(new HashMap());
                        }
                        itemToProcess.getChildRelationMap().put(targetReleaseTrainId, new ArrayList());
                        for (BaseItemLink childRelation : childRelations2) {
                            itemToProcess.linkToChild(targetReleaseTrainId, childRelation.getBacklogItemId().toString());
                        }
                    }
                    processedItems.add(itemToProcess);
                }
                catch (Exception e) {
                    LOGGER.error("Error processing item {}: ", (Object)itemToProcess.getId(), (Object)e);
                }
            }
            if (!processedItems.isEmpty()) {
                this.backlogItemRepository.save(processedItems);
            }
            result.put("success", true);
            result.put("item", item);
            result.put("processedItems", processedItems);
            result.put("sourceCollection", sourceReleaseTrain);
            result.put("targetCollection", targetReleaseTrain);
        }
        catch (Exception e) {
            LOGGER.error("Error adding item to collection: ", (Throwable)e);
            result.put("error", true);
            result.put("message", "Error occurred while adding item: " + e.getMessage());
        }
        return result;
    }

    private void collectItemHierarchy(List<String> childIds, String releaseTrainId, List<BacklogItem> collectedItems) {
        try {
            List children = this.backlogItemRepository.findByIdIn(childIds);
            if (PropertyValidator.isValid((Collection)children)) {
                ArrayList<String> nextLevelChildIds = new ArrayList<String>();
                for (BacklogItem child : children) {
                    collectedItems.add(child);
                    if (child.getChildRelationMap() == null || !child.getChildRelationMap().containsKey(releaseTrainId)) continue;
                    List childRelations = (List)child.getChildRelationMap().get(releaseTrainId);
                    for (BaseItemLink link : childRelations) {
                        nextLevelChildIds.add(link.getBacklogItemId().toString());
                    }
                }
                if (PropertyValidator.isValid(nextLevelChildIds)) {
                    this.collectItemHierarchy(nextLevelChildIds, releaseTrainId, collectedItems);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error collecting item hierarc", (Throwable)e);
        }
    }

    public boolean saveLinksMeta(String id, Map<String, Object> requestBody) throws Exception {
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"key").is((Object)id), Criteria.where((String)"tenant").is((Object)tenant)}));
            Update update = new Update();
            if (requestBody.containsKey("title")) {
                String title = (String)requestBody.get("title");
                update.set("workspaceLinksTitle", (Object)title);
            }
            if (requestBody.containsKey("description")) {
                String description = (String)requestBody.get("description");
                update.set("workspaceLinksDescription", (Object)description);
            }
            if (update.getUpdateObject().keySet().size() > 0) {
                this.mongoTemplate.updateFirst(query, update, WorkSpace.class);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Unable to update links meta for key: " + id);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }
}

