/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.entity.ALMFilter;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.TFSIssue;
import com.viztrend.safe.alm.jira.bo.TFSWebhookMappedData;
import com.viztrend.safe.alm.tfs.TFSFilter;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmHierarchyLevelMapping;
import com.viztrend.safe.persistence.entity.BacklogHierarchy;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.HierarchyLevel;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSItemLinkType;
import com.viztrend.safe.persistence.entity.TFSWorkItemType;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.BacklogHierarchyRepository;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.RTItemOperationsService;
import com.viztrend.safe.service.RTItemTfsSyncService;
import com.viztrend.safe.service.ReleaseTrainServiceImpl;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmErrorUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.ResyncParamsVO;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="RTItemTfsSyncService")
public class RTItemTfsSyncServiceImpl
implements RTItemTfsSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTItemTfsSyncServiceImpl.class);
    private static final Logger LOGGER_WH_HEALTH = LoggerFactory.getLogger((String)"wh_health");
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private ReleaseTrainServiceImpl releaseTrainServiceImpl;
    @Autowired
    private RTItemOperationsService itemOperationsService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private BacklogHierarchyRepository backlogHierarchyRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;

    public Map<String, Object> fetchAndSyncTfsFilters(List<String> tfsIds, TFSFilter tfsFilter, String releaseTrainId, String almId, Map<String, Object> otherParams) {
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
        User user = UserContextUtil.getUserContext().getLoggedInUser();
        if (tfsFilter.getIsWiql().booleanValue()) {
            tfsFilter.setTfsId(UUID.randomUUID().toString());
        }
        otherParams.put("user", user);
        WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        Map result = this.fetchAndSyncTfsItems(tfsIds, tfsFilter, almAccount, otherParams, releaseTrain);
        String backlogLevelStr = (String)otherParams.get("backlogLevel");
        ALMFilter almFilter = new ALMFilter();
        almFilter.setAlmAccount(almAccount);
        almFilter.setTfsFilter(tfsFilter);
        almFilter.setBacklogLevel(Integer.valueOf(Integer.parseInt(backlogLevelStr)));
        tfsFilter.setFilterFetchedBy(user);
        tfsFilter.setUpdatedOn(new Date());
        tfsFilter.setCreatedOn(new Date());
        if (releaseTrain.getAlmFilters() == null) {
            releaseTrain.setAlmFilters(new ArrayList());
        }
        releaseTrain.getAlmFilters().add(almFilter);
        this.workSpaceRepository.save((Object)releaseTrain);
        result.put("filter", almFilter);
        return result;
    }

    public Map<String, Object> addExistingTfsItems(Map<String, Object> params) {
        HashMap<String, String> itemMap = null;
        Map parentMap = null;
        if (params.containsKey("parent")) {
            parentMap = (Map)params.get("parent");
        }
        if (params.containsKey("item")) {
            itemMap = (HashMap<String, String>)params.get("item");
        }
        Map metaMap = null;
        if (params.containsKey("metaMap")) {
            metaMap = (Map)params.get("metaMap");
        }
        String boardId = null;
        if (params.containsKey("boardId")) {
            boardId = (String)params.get("boardId");
        }
        String itemIdsStr = (String)params.get("itemIds");
        String almId = (String)params.get("almId");
        String releaseTrainId = (String)params.get("releaseTrainId");
        String backlogLevelStr = (String)params.get("backlogLevel");
        List<String> tfsIds = Arrays.asList(itemIdsStr.split("\\s*,\\s*"));
        HashMap<String, String> otherOptions = new HashMap<String, String>();
        otherOptions.put("backlogLevel", backlogLevelStr);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List existingItems = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId(tfsIds, almId);
        ArrayList<BacklogItem> alreadyExist = new ArrayList<BacklogItem>();
        if (PropertyValidator.isValid((Collection)existingItems)) {
            for (BacklogItem item : existingItems) {
                BaseItemLink relation = (BaseItemLink)item.getArtRelationMap().get(releaseTrainId);
                if (!PropertyValidator.isValid((Object)relation)) continue;
                alreadyExist.add(item);
            }
        }
        if (PropertyValidator.isValid(alreadyExist)) {
            result.put("success", false);
            result.put("reason", "AlreadyExist");
            result.put("items", existingItems);
        } else {
            try {
                if (params.containsKey("parent")) {
                    params.remove("parent");
                }
                AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
                User user = UserContextUtil.getUserContext().getLoggedInUser();
                params.put("user", user);
                WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
                Map _result = this.fetchAndSyncTfsItems(tfsIds, null, almAccount, params, releaseTrain);
                HashMap levelsResultMap = (HashMap)_result.get("levelsResult");
                HashMap levelResultMap = (HashMap)levelsResultMap.get(backlogLevelStr);
                ArrayList itemsAdded = (ArrayList)levelResultMap.get("itemsAdded");
                ArrayList itemsUpdated = (ArrayList)levelResultMap.get("itemsUpdated");
                HashSet mergedItems = new HashSet();
                mergedItems.addAll(itemsAdded);
                mergedItems.addAll(itemsUpdated);
                boolean removeMiscStatusItems = false;
                if (almAccount.getExcludeMiscStatuses() != null) {
                    removeMiscStatusItems = almAccount.getExcludeMiscStatuses();
                }
                if (itemMap != null || parentMap != null) {
                    if (itemMap == null) {
                        itemMap = new HashMap<String, String>();
                    }
                    for (BacklogItem itemAdded : mergedItems) {
                        itemMap.put("id", itemAdded.getId());
                        HashMap<String, Object> saveCallParams = new HashMap<String, Object>();
                        HashMap<String, String> releaseTrainMap = new HashMap<String, String>();
                        releaseTrainMap.put("id", releaseTrainId);
                        saveCallParams.put("releaseTrain", releaseTrainMap);
                        saveCallParams.put("almAccountId", almId);
                        saveCallParams.put("item", itemMap);
                        if (parentMap != null) {
                            saveCallParams.put("parent", parentMap);
                        }
                        if (metaMap != null) {
                            saveCallParams.put("metaMap", metaMap);
                        }
                        if (boardId != null) {
                            saveCallParams.put("boardId", boardId);
                        }
                        if (removeMiscStatusItems && PropertyValidator.isValid((Object)itemAdded.getStatus()) && itemAdded.getStatus().getCategory().equals("Misc")) {
                            result.put("success", false);
                            result.put("reason", "InvalidItem");
                            continue;
                        }
                        Map saveCallResult = this.itemOperationsService.saveItem(saveCallParams);
                        if (((Boolean)saveCallResult.get("success")).booleanValue()) {
                            result.put("success", true);
                            continue;
                        }
                        result.put("success", false);
                        result.put("reason", "InvalidItem");
                    }
                }
                if (!result.containsKey("reason")) {
                    result.put("success", true);
                }
                if (removeMiscStatusItems) {
                    for (BacklogItem item : mergedItems) {
                        if (!PropertyValidator.isValid((Object)item) || !PropertyValidator.isValid((Object)item.getStatus()) || !item.getStatus().getCategory().equals("Misc")) continue;
                        result.put("success", false);
                        result.put("reason", "InvalidItem");
                    }
                }
                result.put("items", mergedItems);
            }
            catch (Exception e) {
                result.put("success", false);
            }
        }
        return result;
    }

    private AlmAccount getCopyAlmAccount(AlmAccount almAccount) {
        AlmAccount almAccountTemp = new AlmAccount();
        almAccountTemp.setId(almAccount.getId());
        almAccountTemp.setUrl(almAccount.getUrl());
        almAccountTemp.setUsername(almAccount.getUsername());
        almAccountTemp.setPassword(almAccount.getPassword());
        almAccountTemp.setAzureOAuthToken(almAccount.getAzureOAuthToken());
        almAccountTemp.setIsTaggedUser(almAccount.getIsTaggedUser());
        almAccountTemp.setTenant(almAccount.getTenant());
        almAccountTemp.setType(almAccount.getType());
        almAccountTemp.setExcludeMiscStatuses(almAccount.getExcludeMiscStatuses());
        almAccountTemp.setDebug(almAccount.isDebug());
        return almAccountTemp;
    }

    public Map<String, Object> resyncTfsItems(Map<String, Object> params) {
        String almId = (String)params.get("almId");
        String releaseTrainId = (String)params.get("releaseTrainId");
        String backlogLevelStr = (String)params.get("backlogLevel");
        String syncId = (String)params.get("syncId");
        String metaMap = (String)params.get("metaMap");
        HashMap<String, String> otherOptions = new HashMap<String, String>();
        otherOptions.put("backlogLevel", backlogLevelStr);
        HashMap<String, Object> result = new HashMap<String, Object>();
        AlmAccount almAccount = this.almAccountRepository.findById(almId);
        WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        if (PropertyValidator.isValid((Object)releaseTrain)) {
            List syncGroups = (List)params.get("syncGroups");
            boolean saveReleaseTrain = false;
            ArrayList<Map> syncGroupsResyncResults = new ArrayList<Map>();
            boolean processWithResync = true;
            try {
                this.customRepositoryImpl.checkIfReleaseTrainLocked(releaseTrainId, "Item Sync");
            }
            catch (ViztrendJiraException vje) {
                processWithResync = false;
                result.put("error", true);
            }
            if (processWithResync) {
                for (Map syncGroup : syncGroups) {
                    String userId = (String)syncGroup.get("userId");
                    AlmAccount almAccountTemp = this.getCopyAlmAccount(almAccount);
                    User user = UserContextUtil.getUserContext().getLoggedInUser();
                    params.put("user", user);
                    if (!userId.equals("alm")) {
                        AlmAccount taggedAlmAccount;
                        User taggedUser = this.userRepository.findById(userId);
                        if (taggedUser != null && PropertyValidator.isValid((Object)(taggedAlmAccount = TFSUtils.getTaggedAlmUserCopyAlm((User)taggedUser, (AlmAccount)almAccount)))) {
                            almAccountTemp.setUsername(taggedAlmAccount.getUsername());
                            almAccountTemp.setPassword(taggedAlmAccount.getPassword());
                            almAccountTemp.setAzureOAuthToken(taggedAlmAccount.getAzureOAuthToken());
                            almAccountTemp.setOAuthTokenOwnerUserId(taggedAlmAccount.getOAuthTokenOwnerUserId());
                            almAccountTemp.setIsTaggedUser(Boolean.valueOf(true));
                            almAccountTemp.setAdminAlmAcc(Boolean.valueOf(false));
                            params.put("user", taggedUser);
                        }
                    } else {
                        almAccountTemp.setIsTaggedUser(Boolean.valueOf(true));
                    }
                    almAccountTemp.setExcludeMiscStatuses(almAccount.getExcludeMiscStatuses());
                    if (syncGroup.containsKey("filterId")) {
                        Map<String, String> _result;
                        String filterId = (String)syncGroup.get("filterId");
                        ALMFilter almFilter = releaseTrain.getAlmFilters().stream().filter(af -> af.getTfsFilter() != null && af.getTfsFilter().getTfsId().equals(filterId)).findAny().orElse(null);
                        if (!PropertyValidator.isValid((Object)almFilter)) continue;
                        if (almFilter.getBacklogLevel() != null) {
                            params.put("backlogLevel", "" + almFilter.getBacklogLevel());
                        }
                        try {
                            List filtersTfsIds = this.getTfsItemsFromFilter(almFilter.getTfsFilter(), almAccountTemp);
                            _result = this.fetchAndSyncTfsItems(filtersTfsIds, almFilter.getTfsFilter(), almAccountTemp, params, releaseTrain);
                            almFilter.getTfsFilter().setUpdatedOn(new Date());
                            saveReleaseTrain = true;
                            _result.put("filterId", filterId);
                            _result.remove("alm");
                            syncGroupsResyncResults.add(_result);
                        }
                        catch (ViztrendJiraException vzE) {
                            _result = new HashMap<String, String>();
                            _result.put("filterId", filterId);
                            _result.remove("alm");
                            _result.put("vzError", vzE.getMessage());
                            syncGroupsResyncResults.add(_result);
                        }
                        catch (Exception e) {
                            _result = new HashMap();
                            _result.put("filterId", filterId);
                            _result.remove("alm");
                            _result.put("error", e.getMessage());
                            syncGroupsResyncResults.add(_result);
                        }
                        continue;
                    }
                    if (!syncGroup.containsKey("itemIds")) continue;
                    List tfsIds = (List)syncGroup.get("itemIds");
                    Map _result = this.fetchAndSyncTfsItems(tfsIds, null, almAccountTemp, params, releaseTrain);
                    _result.put("itemIds", tfsIds);
                    _result.remove("alm");
                    syncGroupsResyncResults.add(_result);
                }
            }
            for (Map syncGroupsResyncResult : syncGroupsResyncResults) {
                Map levelsResult;
                if (!syncGroupsResyncResult.containsKey("levelsResult") || (levelsResult = (Map)syncGroupsResyncResult.get("levelsResult")) == null) continue;
                for (String key : levelsResult.keySet()) {
                    Map levelResult = (Map)levelsResult.get(key);
                    levelResult.remove("itemsAdded");
                    levelResult.remove("itemsUpdated");
                }
            }
            result.put("syncResult", syncGroupsResyncResults);
            if (saveReleaseTrain) {
                WorkSpace newReleaseTrainCopy = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
                releaseTrain.setIgnoreItemsInResync(newReleaseTrainCopy.getIgnoreItemsInResync());
                this.workSpaceRepository.save((Object)releaseTrain);
                result.put("releaseTrain", releaseTrain);
            }
            this.customRepositoryImpl.removeReleaseTrainLock(releaseTrainId, "Item Sync");
        }
        return result;
    }

    public Map<String, Object> deleteFilters(String filterId, String releaseTrainId, String almId, Map<String, Object> otherParams) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        int index = IntStream.range(0, releaseTrain.getAlmFilters().size()).filter(i -> ((ALMFilter)releaseTrain.getAlmFilters().get(i)).getTfsFilter() != null && ((ALMFilter)releaseTrain.getAlmFilters().get(i)).getTfsFilter().getTfsId().equals(filterId) || ((ALMFilter)releaseTrain.getAlmFilters().get(i)).getJiraFilter() != null && ((ALMFilter)releaseTrain.getAlmFilters().get(i)).getJiraFilter().getId().equals(filterId)).findFirst().orElse(-1);
        if (index > -1) {
            releaseTrain.getAlmFilters().remove(index);
            this.workSpaceRepository.save((Object)releaseTrain);
            result.put("success", true);
            result.put("filters", releaseTrain.getAlmFilters());
            List allItems = this.backlogItemRepository.findByFilterIdsInAndAlmAccountId(filterId, almId);
            if (PropertyValidator.isValid((Collection)allItems)) {
                ArrayList itemsIds = new ArrayList();
                allItems.forEach(item -> {
                    itemsIds.add(item.getId());
                    if (PropertyValidator.isValid(item.getArtRelationMap().get(releaseTrainId))) {
                        item.getArtRelationMap().remove(releaseTrainId);
                        item.getChildRelationMap().remove(releaseTrainId);
                        item.getParentRelationMap().remove(releaseTrainId);
                    }
                    if (item.getArtRelationMap().isEmpty()) {
                        item.setArchive(true);
                    }
                });
                result.put("items", allItems);
                this.backlogItemRepository.save((Iterable)allItems);
                try {
                    this.itemOperationsService.removeItemReferenceFromOtherItems(itemsIds, releaseTrainId);
                    this.handleDependenciesOnDeleteItems(allItems);
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        }
        return result;
    }

    private void setValidChildParentRelations(JSONArray allRelations, Set<String> childIds, Set<String> parentIds, AlmHierarchyLevelMapping hierarchyLevelMapping, AlmHierarchyLevelMapping parentHierarchyLevel) {
        for (int i = 0; i < allRelations.length(); ++i) {
            try {
                TFSItemLinkType itemLinkType;
                JSONObject relationObject = allRelations.getJSONObject(i);
                String rel = relationObject.getString("rel");
                String url = relationObject.getString("url");
                String tfsId = url.substring(url.lastIndexOf("/") + 1);
                if (hierarchyLevelMapping != null && PropertyValidator.isValid((Object)(itemLinkType = (TFSItemLinkType)hierarchyLevelMapping.getTfsItemLinkTypes().stream().filter(ilt -> ilt.getReferenceName().equals(rel)).findAny().orElse(null)))) {
                    childIds.add(tfsId);
                }
                if (parentHierarchyLevel == null) continue;
                String reverseRelation = this.reverseTFSRelation(rel);
                TFSItemLinkType itemLinkType2 = parentHierarchyLevel.getTfsItemLinkTypes().stream().filter(ilt -> ilt.getReferenceName().equals(reverseRelation)).findAny().orElse(null);
                if (!PropertyValidator.isValid((Object)itemLinkType2)) continue;
                parentIds.add(tfsId);
                continue;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String sStackTrace = sw.toString();
                LOGGER.debug(" ::  Exception ..  " + sStackTrace);
            }
        }
    }

    private boolean isItemValidForHierarchyLevel(BacklogItem item, AlmHierarchyLevelMapping hierarchyLevel) {
        TFSWorkItemType workItemType;
        return PropertyValidator.isValid((Object)item.getAlmType()) && (workItemType = (TFSWorkItemType)hierarchyLevel.getTfsWorkItemTypes().stream().filter(wit -> wit.getName().equals(item.getAlmType())).findAny().orElse(null)) != null;
    }

    public void deleteBacklogItems(List<BacklogItem> existingItems, boolean deleteItemFromSystem) throws Exception {
        HashMap<String, ArrayList<String>> parentsLinkMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> childLinkMap = new HashMap<String, ArrayList<String>>();
        ArrayList<String> existingItemsIds = new ArrayList<String>();
        HashMap<String, String> existingItemsIdMap = new HashMap<String, String>();
        ArrayList<BacklogItem> backlogItemsToDelete = new ArrayList<BacklogItem>();
        ArrayList<BacklogItem> backlogItemsToSave = new ArrayList<BacklogItem>();
        for (BacklogItem backlogItem : existingItems) {
            ArrayList releaseTrains;
            String itemId;
            List links;
            if (PropertyValidator.isValid((Object)backlogItem.isArchive()) && backlogItem.isArchive()) continue;
            LOGGER.info("ITEM FOUND : " + backlogItem.getAlmItemId());
            backlogItem.setArchive(true);
            existingItemsIds.add(backlogItem.getId());
            existingItemsIdMap.put(backlogItem.getId(), backlogItem.getId());
            if (PropertyValidator.isValid((Object)backlogItem.getParentRelationMap())) {
                for (String releaseTrainId : backlogItem.getParentRelationMap().keySet()) {
                    links = (List)backlogItem.getParentRelationMap().get(releaseTrainId);
                    if (!PropertyValidator.isValid((Collection)links)) continue;
                    for (BaseItemLink link2 : links) {
                        if (!(link2 instanceof BaseItemLink)) continue;
                        itemId = link2.getBacklogItemId().toString();
                        releaseTrains = (ArrayList)parentsLinkMap.get(itemId);
                        if (releaseTrains == null) {
                            releaseTrains = new ArrayList();
                            parentsLinkMap.put(itemId, releaseTrains);
                        }
                        releaseTrains.add(releaseTrainId);
                    }
                }
            }
            if (PropertyValidator.isValid((Object)backlogItem.getChildRelationMap())) {
                for (String releaseTrainId : backlogItem.getChildRelationMap().keySet()) {
                    links = (List)backlogItem.getChildRelationMap().get(releaseTrainId);
                    if (!PropertyValidator.isValid((Collection)links)) continue;
                    for (BaseItemLink link2 : links) {
                        if (!(link2 instanceof BaseItemLink)) continue;
                        itemId = link2.getBacklogItemId().toString();
                        releaseTrains = (ArrayList)childLinkMap.get(itemId);
                        if (releaseTrains == null) {
                            releaseTrains = new ArrayList();
                            childLinkMap.put(itemId, releaseTrains);
                        }
                        releaseTrains.add(releaseTrainId);
                    }
                }
            }
            backlogItem.setArtRelationMap(new HashMap());
            backlogItem.setParentRelationMap(new HashMap());
            backlogItem.setChildRelationMap(new HashMap());
            backlogItemsToDelete.add(backlogItem);
        }
        ArrayList<String> backlogItemIdsToUpdate = new ArrayList<String>();
        for (Object backlogItemId : parentsLinkMap.keySet()) {
            backlogItemIdsToUpdate.add((String)backlogItemId);
        }
        for (Object backlogItemId : childLinkMap.keySet()) {
            backlogItemIdsToUpdate.add((String)backlogItemId);
        }
        if (PropertyValidator.isValid(backlogItemIdsToUpdate)) {
            List list = this.backlogItemRepository.findByIdIn(backlogItemIdsToUpdate);
            for (BacklogItem backlogItem : list) {
                boolean anyLinksRemoved;
                List links;
                String releaseTrainId;
                Iterator iterator;
                Object releaseTrainIds;
                if (parentsLinkMap.get(backlogItem.getId()) != null) {
                    releaseTrainIds = (List)parentsLinkMap.get(backlogItem.getId());
                    iterator = releaseTrainIds.iterator();
                    while (iterator.hasNext()) {
                        releaseTrainId = (String)iterator.next();
                        links = (List)backlogItem.getChildRelationMap().get(releaseTrainId);
                        LOGGER.info("LINKS LENTH EFORE SAVING : " + links.size());
                        if (PropertyValidator.isValid((Collection)links) && (anyLinksRemoved = links.removeIf(link -> existingItemsIdMap.get(link.getBacklogItemId().toString()) != null))) {
                            backlogItem.getChildRelationMap().put(releaseTrainId, links);
                        }
                        LOGGER.info("LINKS LENTH AFTER SAVING : " + links.size());
                    }
                }
                if (childLinkMap.get(backlogItem.getId()) != null) {
                    releaseTrainIds = (List)childLinkMap.get(backlogItem.getId());
                    iterator = releaseTrainIds.iterator();
                    while (iterator.hasNext()) {
                        releaseTrainId = (String)iterator.next();
                        links = (List)backlogItem.getParentRelationMap().get(releaseTrainId);
                        if (!PropertyValidator.isValid((Collection)links) || !(anyLinksRemoved = links.removeIf(link -> existingItemsIdMap.get(link.getBacklogItemId().toString()) != null))) continue;
                        backlogItem.getParentRelationMap().put(releaseTrainId, links);
                    }
                }
                backlogItemsToSave.add(backlogItem);
            }
        }
        if (PropertyValidator.isValid(backlogItemsToDelete)) {
            this.handleDependenciesOnDeleteItems(backlogItemsToDelete);
            if (deleteItemFromSystem) {
                this.backlogItemRepository.delete(backlogItemsToDelete);
            } else {
                this.backlogItemRepository.save(backlogItemsToDelete);
            }
        }
        this.backlogItemRepository.save(backlogItemsToSave);
        List list = this.baseItemLinkRepository.findByBaseItemIdIn(existingItemsIds);
        if (PropertyValidator.isValid((Collection)list)) {
            ArrayList<BaseItem> baseItemsToSave = new ArrayList<BaseItem>();
            List baseItems = this.baseItemRepository.findByBaseItemLinksIn(list);
            if (PropertyValidator.isValid((Collection)baseItems)) {
                for (BaseItem baseItem : baseItems) {
                    boolean anyRemoved = false;
                    int arraySize = baseItem.getBaseItemLinks().size();
                    for (int i = 0; i < arraySize; ++i) {
                        BaseItemLink link3 = (BaseItemLink)baseItem.getBaseItemLinks().get(i);
                        if (existingItemsIdMap.get(link3.getBaseItemId()) == null) continue;
                        baseItem.getBaseItemLinks().remove(i);
                        --i;
                        anyRemoved = true;
                        --arraySize;
                    }
                    if (!anyRemoved) continue;
                    baseItemsToSave.add(baseItem);
                }
            }
            if (PropertyValidator.isValid(baseItemsToSave)) {
                this.baseItemRepository.save(baseItemsToSave);
            }
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"itemRelations.baseItemId").in(existingItemsIds));
        List milestones = this.mongoTemplate.find(query, BacklogItem.class);
        if (PropertyValidator.isValid((Collection)milestones)) {
            ArrayList<BacklogItem> milestonesToUpdate = new ArrayList<BacklogItem>();
            for (BacklogItem milestone : milestones) {
                boolean anyRemoved = false;
                int arraySize = milestone.getItemRelations().size();
                for (int i = 0; i < arraySize; ++i) {
                    BaseItemLink link4 = (BaseItemLink)milestone.getItemRelations().get(i);
                    if (existingItemsIdMap.get(link4.getBaseItemId()) == null) continue;
                    milestone.getItemRelations().remove(i);
                    --i;
                    --arraySize;
                    anyRemoved = true;
                }
                if (!anyRemoved) continue;
                milestonesToUpdate.add(milestone);
            }
            if (PropertyValidator.isValid(milestonesToUpdate)) {
                this.backlogItemRepository.save(milestonesToUpdate);
            }
        }
    }

    public ArrayList<BacklogItem> deleteBacklogItemsAndGetUpdatedItems(List<BacklogItem> existingItems, boolean deleteItemFromSystem) throws Exception {
        ArrayList<BacklogItem> updatedParentAndChildItems = new ArrayList<BacklogItem>();
        HashMap<String, ArrayList<String>> parentsLinkMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> childLinkMap = new HashMap<String, ArrayList<String>>();
        ArrayList<String> existingItemsIds = new ArrayList<String>();
        HashMap<String, String> existingItemsIdMap = new HashMap<String, String>();
        ArrayList<BacklogItem> backlogItemsToDelete = new ArrayList<BacklogItem>();
        ArrayList<BacklogItem> backlogItemsToSave = new ArrayList<BacklogItem>();
        for (BacklogItem backlogItem : existingItems) {
            ArrayList releaseTrains;
            String itemId;
            List links;
            if (PropertyValidator.isValid((Object)backlogItem.isArchive()) && backlogItem.isArchive()) continue;
            backlogItem.setArchive(true);
            existingItemsIds.add(backlogItem.getId());
            existingItemsIdMap.put(backlogItem.getId(), backlogItem.getId());
            if (PropertyValidator.isValid((Object)backlogItem.getParentRelationMap())) {
                for (String releaseTrainId : backlogItem.getParentRelationMap().keySet()) {
                    links = (List)backlogItem.getParentRelationMap().get(releaseTrainId);
                    if (!PropertyValidator.isValid((Collection)links)) continue;
                    for (BaseItemLink link2 : links) {
                        if (!(link2 instanceof BaseItemLink)) continue;
                        itemId = link2.getBacklogItemId().toString();
                        releaseTrains = (ArrayList)parentsLinkMap.get(itemId);
                        if (releaseTrains == null) {
                            releaseTrains = new ArrayList();
                            parentsLinkMap.put(itemId, releaseTrains);
                        }
                        releaseTrains.add(releaseTrainId);
                    }
                }
            }
            if (PropertyValidator.isValid((Object)backlogItem.getChildRelationMap())) {
                for (String releaseTrainId : backlogItem.getChildRelationMap().keySet()) {
                    links = (List)backlogItem.getChildRelationMap().get(releaseTrainId);
                    if (!PropertyValidator.isValid((Collection)links)) continue;
                    for (BaseItemLink link2 : links) {
                        if (!(link2 instanceof BaseItemLink)) continue;
                        itemId = link2.getBacklogItemId().toString();
                        releaseTrains = (ArrayList)childLinkMap.get(itemId);
                        if (releaseTrains == null) {
                            releaseTrains = new ArrayList();
                            childLinkMap.put(itemId, releaseTrains);
                        }
                        releaseTrains.add(releaseTrainId);
                    }
                }
            }
            backlogItem.setArtRelationMap(new HashMap());
            backlogItem.setParentRelationMap(new HashMap());
            backlogItem.setChildRelationMap(new HashMap());
            backlogItemsToDelete.add(backlogItem);
        }
        ArrayList<String> backlogItemIdsToUpdate = new ArrayList<String>();
        for (Object backlogItemId : parentsLinkMap.keySet()) {
            backlogItemIdsToUpdate.add((String)backlogItemId);
        }
        for (Object backlogItemId : childLinkMap.keySet()) {
            backlogItemIdsToUpdate.add((String)backlogItemId);
        }
        if (PropertyValidator.isValid(backlogItemIdsToUpdate)) {
            List list = this.backlogItemRepository.findByIdIn(backlogItemIdsToUpdate);
            for (BacklogItem backlogItem : list) {
                boolean anyLinksRemoved;
                List links;
                List releaseTrainIds;
                boolean itemUpdated = false;
                if (parentsLinkMap.get(backlogItem.getId()) != null) {
                    releaseTrainIds = (List)parentsLinkMap.get(backlogItem.getId());
                    for (String releaseTrainId : releaseTrainIds) {
                        links = (List)backlogItem.getChildRelationMap().get(releaseTrainId);
                        if (!PropertyValidator.isValid((Collection)links) || !(anyLinksRemoved = links.removeIf(link -> existingItemsIdMap.get(link.getBacklogItemId().toString()) != null))) continue;
                        backlogItem.getChildRelationMap().put(releaseTrainId, links);
                        itemUpdated = true;
                    }
                }
                if (childLinkMap.get(backlogItem.getId()) != null) {
                    releaseTrainIds = (List)childLinkMap.get(backlogItem.getId());
                    for (String releaseTrainId : releaseTrainIds) {
                        links = (List)backlogItem.getParentRelationMap().get(releaseTrainId);
                        if (!PropertyValidator.isValid((Collection)links) || !(anyLinksRemoved = links.removeIf(link -> existingItemsIdMap.get(link.getBacklogItemId().toString()) != null))) continue;
                        backlogItem.getParentRelationMap().put(releaseTrainId, links);
                        itemUpdated = true;
                    }
                }
                if (itemUpdated) {
                    updatedParentAndChildItems.add(backlogItem);
                }
                backlogItemsToSave.add(backlogItem);
            }
        }
        if (PropertyValidator.isValid(backlogItemsToDelete)) {
            this.handleDependenciesOnDeleteItems(backlogItemsToDelete);
            if (deleteItemFromSystem) {
                this.backlogItemRepository.delete(backlogItemsToDelete);
            } else {
                this.backlogItemRepository.save(backlogItemsToDelete);
            }
        }
        this.backlogItemRepository.save(backlogItemsToSave);
        List list = this.baseItemLinkRepository.findByBaseItemIdIn(existingItemsIds);
        if (PropertyValidator.isValid((Collection)list)) {
            ArrayList<BaseItem> baseItemsToSave = new ArrayList<BaseItem>();
            List baseItems = this.baseItemRepository.findByBaseItemLinksIn(list);
            if (PropertyValidator.isValid((Collection)baseItems)) {
                for (BaseItem baseItem : baseItems) {
                    boolean anyRemoved = false;
                    int arraySize = baseItem.getBaseItemLinks().size();
                    for (int i = 0; i < arraySize; ++i) {
                        BaseItemLink link3 = (BaseItemLink)baseItem.getBaseItemLinks().get(i);
                        if (existingItemsIdMap.get(link3.getBaseItemId()) == null) continue;
                        baseItem.getBaseItemLinks().remove(i);
                        --i;
                        anyRemoved = true;
                        --arraySize;
                    }
                    if (!anyRemoved) continue;
                    baseItemsToSave.add(baseItem);
                }
            }
            if (PropertyValidator.isValid(baseItemsToSave)) {
                this.baseItemRepository.save(baseItemsToSave);
            }
        }
        Query query = new Query();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"itemRelations.baseItemId").in(existingItemsIds));
        List milestones = this.mongoTemplate.find(query, BacklogItem.class);
        if (PropertyValidator.isValid((Collection)milestones)) {
            ArrayList<BacklogItem> milestonesToUpdate = new ArrayList<BacklogItem>();
            for (BacklogItem milestone : milestones) {
                boolean anyRemoved = false;
                int arraySize = milestone.getItemRelations().size();
                for (int i = 0; i < arraySize; ++i) {
                    BaseItemLink link4 = (BaseItemLink)milestone.getItemRelations().get(i);
                    if (existingItemsIdMap.get(link4.getBaseItemId()) == null) continue;
                    milestone.getItemRelations().remove(i);
                    --i;
                    --arraySize;
                    anyRemoved = true;
                }
                if (!anyRemoved) continue;
                milestonesToUpdate.add(milestone);
            }
            if (PropertyValidator.isValid(milestonesToUpdate)) {
                this.backlogItemRepository.save(milestonesToUpdate);
            }
        }
        return updatedParentAndChildItems;
    }

    public void tfsWebhookItemReceived(TFSWebhookMappedData webhookMappedData) {
        AlmAccount almAccount = this.almAccountRepository.findById(webhookMappedData.getAlmAccountId());
        ArrayList executionLogs = new ArrayList();
        if (PropertyValidator.isValid((Object)almAccount)) {
            String tenant = almAccount.getTenant();
            JSONObject webHookJson = webhookMappedData.payload();
            String eventType = "";
            if (webHookJson.has("eventType")) {
                eventType = webHookJson.getString("eventType");
            }
            JSONObject tfsItemObject = null;
            if (!webHookJson.has("resource")) {
                this.printLogs(webhookMappedData.getAlmAccountId(), executionLogs);
                return;
            }
            tfsItemObject = webHookJson.getJSONObject("resource");
            String tfsId = null;
            if (!tfsItemObject.isNull("workItemId")) {
                tfsId = tfsItemObject.getString("workItemId");
            } else if (!tfsItemObject.isNull("id")) {
                tfsId = tfsItemObject.getString("id");
            }
            List existingItems = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId(Arrays.asList(tfsId), almAccount.getId());
            HashMap itemMeta = this.getResyncMetaForAlmAccount(almAccount);
            HashMap statusMapByItemTypeAndName = (HashMap)itemMeta.get("statusMap");
            HashMap projectMapById = (HashMap)itemMeta.get("projectMapById");
            HashMap projectMapByName = (HashMap)itemMeta.get("projectMapByName");
            itemMeta.put("completeResync", false);
            boolean removeMiscStatusItems = false;
            if (almAccount.getExcludeMiscStatuses() != null) {
                removeMiscStatusItems = almAccount.getExcludeMiscStatuses();
            }
            if (PropertyValidator.isValid((Collection)existingItems)) {
                Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (date, type, jsonSerializationContext) -> new JsonPrimitive((Number)date.getTime())).create();
                if (eventType.equals("workitem.deleted")) {
                    try {
                        this.deleteBacklogItems(existingItems, false);
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    String pushString = null;
                    JSONObject pushJson = null;
                    try {
                        pushJson = new JSONObject();
                        pushJson.put("isTFS", true);
                        pushJson.put("isRT", true);
                        if (PropertyValidator.isValid((Collection)existingItems)) {
                            pushJson.put("items", (Object)gsonExclusive.toJson((Object)existingItems));
                        }
                        String event = "TFSWebhookDelete";
                        pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"isTFS\":" + Boolean.TRUE + "}"));
                        pushString = pushJson.toString();
                    }
                    catch (JSONException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    String companyId = this.companyRepository.findByTenant(almAccount.getTenant()).getId();
                    if (pushString != null) {
                        PushSender.sendPushMsg((String)companyId, pushString);
                    }
                } else {
                    for (BacklogItem existingItem : existingItems) {
                        boolean currentItemUpdated = false;
                        boolean skipItem = false;
                        if (eventType.equals("workitem.updated")) {
                            ArrayList almLinksForward = new ArrayList();
                            ArrayList<String> forwardLinksSourceTfsIds = new ArrayList<String>();
                            ArrayList<String> forwardLinksTargetTfsIds = new ArrayList<String>();
                            ArrayList<String> forwardMissingTfsIds = new ArrayList<String>();
                            ArrayList almLinksReverse = new ArrayList();
                            ArrayList<String> reverseLinksSourceTfsIds = new ArrayList<String>();
                            ArrayList<String> reverseLinksTargetTfsIds = new ArrayList<String>();
                            ArrayList<String> reverseMissingTfsIds = new ArrayList<String>();
                            HashMap<String, BacklogItem> backlogItemByTfsIdMap = new HashMap<String, BacklogItem>();
                            backlogItemByTfsIdMap.put(existingItem.getAlmItemId(), existingItem);
                            HashMap<String, ItemJiraDependency> existingLinksToDelete = new HashMap<String, ItemJiraDependency>();
                            JSONObject relationsObject = null;
                            if (!tfsItemObject.isNull("relations")) {
                                relationsObject = tfsItemObject.getJSONObject("relations");
                            }
                            if (PropertyValidator.isValid(relationsObject)) {
                                if (!relationsObject.isNull("added")) {
                                    JSONArray relationsAdded = relationsObject.getJSONArray("added");
                                    for (int i = 0; i < relationsAdded.length(); ++i) {
                                        JSONObject relationObject = relationsAdded.getJSONObject(i);
                                        String rel = relationObject.getString("rel");
                                        String url = relationObject.getString("url");
                                        String otherItemTfsId = url.substring(url.lastIndexOf("/") + 1);
                                        if (!PropertyValidator.isValid((Collection)almAccount.getDependencyLinkTypes()) || !almAccount.getDependencyLinkTypes().contains(rel)) continue;
                                        String linkType = rel;
                                        boolean isItemSource = true;
                                        if (rel.contains("Reverse")) {
                                            linkType = this.reverseTFSRelation(rel);
                                            isItemSource = false;
                                        }
                                        HashMap<String, Object> dependencyMap = new HashMap<String, Object>();
                                        String otherItemURL = url.replace("_apis/wit/workItems", "_workitems/edit");
                                        if (isItemSource) {
                                            dependencyMap.put("sItemId", existingItem.getId());
                                            dependencyMap.put("sItemTfsId", existingItem.getAlmItemId());
                                            dependencyMap.put("sItemUrl", existingItem.getUrl());
                                            forwardLinksSourceTfsIds.add(existingItem.getAlmItemId());
                                            forwardLinksTargetTfsIds.add(otherItemTfsId);
                                            dependencyMap.put("tItemTfsId", otherItemTfsId);
                                            dependencyMap.put("tItemUrl", otherItemURL);
                                            forwardMissingTfsIds.add(otherItemTfsId);
                                            almLinksForward.add(dependencyMap);
                                        } else {
                                            dependencyMap.put("tItemId", existingItem.getId());
                                            dependencyMap.put("tItemTfsId", existingItem.getAlmItemId());
                                            dependencyMap.put("tItemUrl", existingItem.getUrl());
                                            reverseLinksTargetTfsIds.add(existingItem.getAlmItemId());
                                            reverseLinksSourceTfsIds.add(otherItemTfsId);
                                            dependencyMap.put("sItemTfsId", otherItemTfsId);
                                            dependencyMap.put("sItemUrl", otherItemURL);
                                            reverseMissingTfsIds.add(otherItemTfsId);
                                            almLinksReverse.add(dependencyMap);
                                        }
                                        dependencyMap.put("type", linkType);
                                    }
                                }
                                if (!relationsObject.isNull("removed")) {
                                    JSONArray relationsRemoved = relationsObject.getJSONArray("removed");
                                    List allDependencies = this.itemJiraDependencyRepository.findByIdIn(existingItem.getDependencyLinkIds());
                                    HashMap<String, ItemJiraDependency> allDependenciesMapByKey = new HashMap<String, ItemJiraDependency>();
                                    for (ItemJiraDependency link : allDependencies) {
                                        String key = "";
                                        if (PropertyValidator.isValid((Object)link.getSourceTFSItem())) {
                                            key = key + link.getSourceTFSItem().getTfsId();
                                        }
                                        if (PropertyValidator.isValid((Object)link.getTargetTFSItem())) {
                                            key = key + link.getTargetTFSItem().getTfsId();
                                        }
                                        key = key + link.getTfsLinkType();
                                        allDependenciesMapByKey.put(key, link);
                                    }
                                    for (int i = 0; i < relationsRemoved.length(); ++i) {
                                        JSONObject relationObject = relationsRemoved.getJSONObject(i);
                                        String rel = relationObject.getString("rel");
                                        String url = relationObject.getString("url");
                                        String otherItemTfsId = url.substring(url.lastIndexOf("/") + 1);
                                        if (!PropertyValidator.isValid((Collection)almAccount.getDependencyLinkTypes()) || !almAccount.getDependencyLinkTypes().contains(rel)) continue;
                                        String linkType = rel;
                                        boolean isItemSource = true;
                                        if (rel.contains("Reverse")) {
                                            linkType = this.reverseTFSRelation(rel);
                                            isItemSource = false;
                                        }
                                        String key = "";
                                        key = isItemSource ? key + existingItem.getAlmItemId() + otherItemTfsId + linkType : key + otherItemTfsId + existingItem.getAlmItemId() + linkType;
                                        ItemJiraDependency itemJiraLink = (ItemJiraDependency)allDependenciesMapByKey.get(key);
                                        if (!PropertyValidator.isValid((Object)itemJiraLink)) continue;
                                        existingLinksToDelete.put(key, itemJiraLink);
                                    }
                                }
                            }
                            this.handleCreationAndDeletionOfTfsDependencies(almLinksForward, forwardLinksSourceTfsIds, forwardLinksTargetTfsIds, forwardMissingTfsIds, almLinksReverse, reverseLinksSourceTfsIds, reverseLinksTargetTfsIds, reverseMissingTfsIds, almAccount, backlogItemByTfsIdMap, existingLinksToDelete);
                            if (!(almLinksForward.isEmpty() && almLinksReverse.isEmpty() && existingLinksToDelete.isEmpty())) {
                                this.backlogItemRepository.save((Object)existingItem);
                            }
                        }
                        for (String releaseTrainId : existingItem.getArtRelationMap().keySet()) {
                            JSONObject tfsItemRevision;
                            LOGGER.info("WEBHOOK RELEASE TRIAN ID : " + releaseTrainId);
                            ArrayList<BacklogItem> itemsToUpdate = new ArrayList<BacklogItem>();
                            ArrayList<BacklogItem> itemsToAdd = new ArrayList<BacklogItem>();
                            if (skipItem) continue;
                            ArrayList<BacklogItem> childrenAdded = new ArrayList<BacklogItem>();
                            ArrayList<String> childrenRemoved = new ArrayList<String>();
                            ArrayList<BacklogItem> parentAdded = new ArrayList<BacklogItem>();
                            ArrayList<String> parentRemoved = new ArrayList<String>();
                            itemMeta.put("releaseTrainId", releaseTrainId);
                            WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
                            BacklogHierarchy backlogHierarchy = (BacklogHierarchy)this.backlogHierarchyRepository.findOne((Serializable)((Object)releaseTrain.getLinkedAlmHierarchy()));
                            HierarchyLevel currentHierarchyLevel = this.getHierarchyLevelForItem(backlogHierarchy.getHierarchyLevels(), existingItem, releaseTrainId);
                            HierarchyLevel parentHierarchyLevel = this.getNextLevel(backlogHierarchy.getHierarchyLevels(), currentHierarchyLevel, -1);
                            HierarchyLevel childHierarchyLevel = this.getNextLevel(backlogHierarchy.getHierarchyLevels(), currentHierarchyLevel, 1);
                            AlmHierarchyLevelMapping currentLevelMapping = null;
                            AlmHierarchyLevelMapping parentLevelMapping = null;
                            AlmHierarchyLevelMapping childLevelMapping = null;
                            if (currentHierarchyLevel != null && currentHierarchyLevel.getAlmHierarchyLevelMappings() != null) {
                                currentLevelMapping = currentHierarchyLevel.getAlmHierarchyLevelMappings().stream().filter(mp -> mp.getAlmAccountId().equals(almAccount.getId())).findAny().orElse(null);
                            }
                            if (parentHierarchyLevel != null && parentHierarchyLevel.getAlmHierarchyLevelMappings() != null) {
                                parentLevelMapping = parentHierarchyLevel.getAlmHierarchyLevelMappings().stream().filter(mp -> mp.getAlmAccountId().equals(almAccount.getId())).findAny().orElse(null);
                            }
                            if (childHierarchyLevel != null && childHierarchyLevel.getAlmHierarchyLevelMappings() != null) {
                                childLevelMapping = childHierarchyLevel.getAlmHierarchyLevelMappings().stream().filter(mp -> mp.getAlmAccountId().equals(almAccount.getId())).findAny().orElse(null);
                            }
                            if (eventType.equals("workitem.updated") && !tfsItemObject.isNull("fields") && !tfsItemObject.isNull("revision") && !(tfsItemRevision = tfsItemObject.getJSONObject("revision")).isNull("fields")) {
                                JSONObject tfsFields = tfsItemRevision.getJSONObject("fields");
                                Map tfsItemInfo = this.tfsItemFromRawJSON(existingItem, tfsItemRevision, tfsFields, (Map)projectMapById, (Map)projectMapByName, (Map)statusMapByItemTypeAndName, currentLevelMapping);
                                TFSProject tfsProject = (TFSProject)tfsItemInfo.get("tfsProject");
                                if (tfsProject == null) {
                                    skipItem = true;
                                    continue;
                                }
                                if (removeMiscStatusItems && PropertyValidator.isValid((Object)existingItem.getStatus()) && existingItem.getStatus().getCategory().equals("Misc")) {
                                    try {
                                        this.deleteBacklogItems(Arrays.asList(existingItem), false);
                                    }
                                    catch (Exception e) {
                                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                                    }
                                    String pushString = null;
                                    JSONObject pushJson = null;
                                    try {
                                        pushJson = new JSONObject();
                                        pushJson.put("isTFS", true);
                                        pushJson.put("isRT", true);
                                        if (PropertyValidator.isValid((Collection)existingItems)) {
                                            pushJson.put("items", (Object)gsonExclusive.toJson((Object)existingItems));
                                        }
                                        String event = "TFSWebhookDelete";
                                        pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"isTFS\":" + Boolean.TRUE + "}"));
                                        pushString = pushJson.toString();
                                    }
                                    catch (JSONException e) {
                                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                                    }
                                    String companyId = this.companyRepository.findByTenant(almAccount.getTenant()).getId();
                                    if (pushString != null) {
                                        PushSender.sendPushMsg((String)companyId, pushString);
                                    }
                                    skipItem = true;
                                    continue;
                                }
                                currentItemUpdated = true;
                            }
                            if (currentHierarchyLevel != null && !eventType.equals("workitem.created")) {
                                if (eventType.equals("workitem.updated")) {
                                    JSONObject relationsObject = null;
                                    if (!tfsItemObject.isNull("relations")) {
                                        relationsObject = tfsItemObject.getJSONObject("relations");
                                    }
                                    if (PropertyValidator.isValid(relationsObject)) {
                                        List items;
                                        if (!relationsObject.isNull("added")) {
                                            ArrayList itemsUpdated;
                                            ArrayList itemsAdded;
                                            Map currentLevelResult;
                                            HierarchyLevel nextHierarchyLevel;
                                            BaseItemLink releaseLink;
                                            JSONArray relationsAdded = relationsObject.getJSONArray("added");
                                            HashSet addedChildIds = new HashSet();
                                            HashSet addedParentIds = new HashSet();
                                            if (childHierarchyLevel == null) {
                                                this.setValidChildParentRelations(relationsAdded, addedChildIds, addedParentIds, null, parentLevelMapping);
                                            } else {
                                                this.setValidChildParentRelations(relationsAdded, addedChildIds, addedParentIds, currentLevelMapping, parentLevelMapping);
                                            }
                                            if (PropertyValidator.isValid(addedChildIds)) {
                                                items = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId(addedChildIds, almAccount.getId());
                                                if (PropertyValidator.isValid((Collection)items)) {
                                                    for (BacklogItem item : items) {
                                                        if (this.isItemValidForHierarchyLevel(item, childLevelMapping)) {
                                                            LOGGER.info("EXISTING ITEM ADDED : " + item.getAlmItemId());
                                                            existingItem.linkToChild(releaseTrainId, item.getId());
                                                            item.linkToParent(releaseTrainId, existingItem.getId());
                                                            currentItemUpdated = true;
                                                            childrenAdded.add(item);
                                                            itemsToAdd.add(item);
                                                            releaseLink = (BaseItemLink)item.getArtRelationMap().get(releaseTrainId);
                                                            if (releaseLink == null && releaseTrainId != null) {
                                                                item.linkToRTE(releaseTrainId, childHierarchyLevel.getLevel());
                                                            }
                                                        }
                                                        addedChildIds.remove(item.getAlmItemId());
                                                    }
                                                }
                                                if (PropertyValidator.isValid(addedChildIds)) {
                                                    Object nextDownLevelItems = new ArrayList();
                                                    HashMap parentMapForNextDownLevel = new HashMap();
                                                    for (String _id : addedChildIds) {
                                                        ((ArrayList)nextDownLevelItems).add(_id);
                                                        parentMapForNextDownLevel.put(_id, existingItem);
                                                    }
                                                    nextHierarchyLevel = childHierarchyLevel;
                                                    almAccount.setIsTaggedUser(Boolean.valueOf(true));
                                                    while (nextHierarchyLevel != null && PropertyValidator.isValid((Collection)nextDownLevelItems)) {
                                                        currentLevelResult = this.fetchAndSyncTfsItemForSingleLevel((List)nextDownLevelItems, nextHierarchyLevel, null, parentMapForNextDownLevel, null, true, false, almAccount, itemsToAdd, itemMeta);
                                                        nextDownLevelItems = (ArrayList)currentLevelResult.get("downItems");
                                                        parentMapForNextDownLevel = (HashMap)currentLevelResult.get("parentsForDownItems");
                                                        itemsAdded = (ArrayList)currentLevelResult.get("itemsAdded");
                                                        for (BacklogItem _item : itemsAdded) {
                                                            LOGGER.info("FETCH ITEM ADDED : " + _item.getAlmItemId());
                                                        }
                                                        itemsUpdated = (ArrayList)currentLevelResult.get("itemsUpdated");
                                                        childrenAdded.addAll(itemsAdded);
                                                        childrenAdded.addAll(itemsUpdated);
                                                        if (PropertyValidator.isValid(childrenAdded)) {
                                                            currentItemUpdated = true;
                                                        }
                                                        nextHierarchyLevel = this.getNextLevel(backlogHierarchy.getHierarchyLevels(), nextHierarchyLevel, 1);
                                                    }
                                                }
                                            }
                                            if (PropertyValidator.isValid(addedParentIds)) {
                                                items = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId(addedParentIds, almAccount.getId());
                                                if (PropertyValidator.isValid((Collection)items)) {
                                                    for (BacklogItem item : items) {
                                                        if (this.isItemValidForHierarchyLevel(item, parentLevelMapping)) {
                                                            existingItem.linkToParent(releaseTrainId, item.getId());
                                                            item.linkToChild(releaseTrainId, existingItem.getId());
                                                            itemsToAdd.add(item);
                                                            releaseLink = (BaseItemLink)item.getArtRelationMap().get(releaseTrainId);
                                                            if (releaseLink == null && releaseTrainId != null) {
                                                                item.linkToRTE(releaseTrainId, parentHierarchyLevel.getLevel());
                                                            }
                                                            currentItemUpdated = true;
                                                            parentAdded.add(item);
                                                        }
                                                        addedParentIds.remove(item.getAlmItemId());
                                                    }
                                                }
                                                if (PropertyValidator.isValid(addedParentIds)) {
                                                    Object nextUpperLevelItems = new ArrayList();
                                                    HashMap childrenMapForNextUpperLevel = new HashMap();
                                                    for (String _id : addedParentIds) {
                                                        ((ArrayList)nextUpperLevelItems).add((String)_id);
                                                        ArrayList<BacklogItem> array = new ArrayList<BacklogItem>();
                                                        array.add(existingItem);
                                                        childrenMapForNextUpperLevel.put(_id, array);
                                                    }
                                                    nextHierarchyLevel = parentHierarchyLevel;
                                                    almAccount.setIsTaggedUser(Boolean.valueOf(true));
                                                    while (nextHierarchyLevel != null && PropertyValidator.isValid(nextUpperLevelItems)) {
                                                        currentLevelResult = this.fetchAndSyncTfsItemForSingleLevel(nextUpperLevelItems, nextHierarchyLevel, parentHierarchyLevel, null, childrenMapForNextUpperLevel, false, true, almAccount, itemsToAdd, itemMeta);
                                                        nextUpperLevelItems = (ArrayList)currentLevelResult.get("upperItems");
                                                        childrenMapForNextUpperLevel = (HashMap)currentLevelResult.get("chilrenForUpperItems");
                                                        itemsAdded = (ArrayList)currentLevelResult.get("itemsAdded");
                                                        itemsUpdated = (ArrayList)currentLevelResult.get("itemsUpdated");
                                                        parentAdded.addAll(itemsAdded);
                                                        parentAdded.addAll(itemsUpdated);
                                                        if (PropertyValidator.isValid(parentAdded)) {
                                                            currentItemUpdated = true;
                                                        }
                                                        if ((nextHierarchyLevel = this.getNextLevel(backlogHierarchy.getHierarchyLevels(), nextHierarchyLevel, -1)) == null) continue;
                                                        parentHierarchyLevel = this.getNextLevel(backlogHierarchy.getHierarchyLevels(), nextHierarchyLevel, -1);
                                                    }
                                                }
                                            }
                                        }
                                        if (!relationsObject.isNull("removed")) {
                                            JSONArray relationsRemoved = relationsObject.getJSONArray("removed");
                                            HashSet removedChildIds = new HashSet();
                                            HashSet removedParentIds = new HashSet();
                                            if (childHierarchyLevel == null) {
                                                this.setValidChildParentRelations(relationsRemoved, removedChildIds, (Set)removedParentIds, null, parentLevelMapping);
                                            } else {
                                                this.setValidChildParentRelations(relationsRemoved, removedChildIds, (Set)removedParentIds, currentLevelMapping, parentLevelMapping);
                                            }
                                            if (PropertyValidator.isValid(removedChildIds) && PropertyValidator.isValid((Collection)(items = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId(removedChildIds, almAccount.getId())))) {
                                                for (BacklogItem item : items) {
                                                    LOGGER.info("ITEM REMOVED IN UPDATE WEBHOOK : " + item.getAlmItemId());
                                                    BaseItemLink existingChildLink = this.findBaseItemLink(existingItem, releaseTrainId, EnumKendis.ART_CHILD_LINK.getCode(), item.getId());
                                                    BaseItemLink existingParentLink = this.findBaseItemLink(item, releaseTrainId, EnumKendis.ART_PARENT_LINK.getCode(), existingItem.getId());
                                                    if (existingChildLink != null) {
                                                        LOGGER.info("ITEM REMOVED");
                                                        existingItem.removeChildLink(releaseTrainId, item.getId());
                                                        currentItemUpdated = true;
                                                    }
                                                    if (existingParentLink != null) {
                                                        item.removeParentLink(releaseTrainId, existingItem.getId());
                                                        itemsToAdd.add(item);
                                                    }
                                                    if (existingChildLink == null && existingParentLink == null) continue;
                                                    childrenRemoved.add(item.getId());
                                                }
                                            }
                                            if (PropertyValidator.isValid((Collection)removedParentIds) && PropertyValidator.isValid((Collection)(items = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId((Collection)removedParentIds, almAccount.getId())))) {
                                                for (BacklogItem item : items) {
                                                    existingItem.removeParentLink(releaseTrainId, item.getId());
                                                    item.removeChildLink(releaseTrainId, existingItem.getId());
                                                    currentItemUpdated = true;
                                                    parentRemoved.add(item.getId());
                                                    itemsToAdd.add(item);
                                                }
                                            }
                                        }
                                    }
                                } else if (eventType.equals("workitem.deleted")) {
                                    // empty if block
                                }
                            }
                            boolean shouldSendPush = false;
                            if (currentItemUpdated) {
                                shouldSendPush = true;
                                itemsToUpdate.add(existingItem);
                            }
                            if (PropertyValidator.isValid(itemsToAdd)) {
                                shouldSendPush = true;
                                ArrayList<BacklogItem> finalItemsToAdd = new ArrayList<BacklogItem>();
                                ArrayList<String> finalItemsIds = new ArrayList<String>();
                                for (BacklogItem item : itemsToAdd) {
                                    if (item.getTenant() == null) {
                                        finalItemsToAdd.add(item);
                                        item.setTenant(almAccount.getTenant());
                                        finalItemsIds.add(item.getAlmItemId());
                                        continue;
                                    }
                                    itemsToUpdate.add(item);
                                }
                                if (PropertyValidator.isValid(finalItemsIds)) {
                                    List alreadyCreatedItems = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId(finalItemsIds, almAccount.getId());
                                    HashMap<String, Boolean> alreadyCreatedCheckMap = new HashMap<String, Boolean>();
                                    if (PropertyValidator.isValid((Collection)alreadyCreatedItems)) {
                                        for (BacklogItem it : alreadyCreatedItems) {
                                            alreadyCreatedCheckMap.put(it.getAlmItemId(), Boolean.TRUE);
                                        }
                                    }
                                    ArrayList<BacklogItem> finalItemsToAddAfterDuplicationTest = new ArrayList<BacklogItem>();
                                    for (BacklogItem it : finalItemsToAdd) {
                                        if (alreadyCreatedCheckMap.get(it.getAlmItemId()) != null) continue;
                                        finalItemsToAddAfterDuplicationTest.add(it);
                                    }
                                    if (PropertyValidator.isValid(finalItemsToAddAfterDuplicationTest)) {
                                        this.backlogItemRepository.save(finalItemsToAddAfterDuplicationTest);
                                        this.addBoardsInItems(releaseTrainId, finalItemsToAddAfterDuplicationTest, almAccount, almAccount.getTenant());
                                    }
                                }
                            }
                            if (PropertyValidator.isValid(itemsToUpdate)) {
                                this.backlogItemRepository.save(itemsToUpdate);
                                if (PropertyValidator.isValid((Object)existingItem)) {
                                    existingItem = this.backlogItemRepository.findById(existingItem.getId());
                                }
                            }
                            if (!shouldSendPush) continue;
                            String companyId = this.companyRepository.findByTenant(almAccount.getTenant()).getId();
                            String pushString = AlmErrorUtils.buildAlmPushJsonForBacklogItemTFSWebhook((BacklogItem)existingItem, (boolean)currentItemUpdated, (String)"TFSWebhookUpdate", childrenAdded, childrenRemoved, parentAdded, parentRemoved, (Gson)gsonExclusive, null, (String)releaseTrainId);
                            if (pushString == null) continue;
                            PushSender.sendPushMsg((String)companyId, (String)pushString);
                        }
                    }
                }
            }
        }
        this.printLogs(webhookMappedData.getAlmAccountId(), executionLogs);
    }

    public void printLogs(String almId, Collection<String> logs) {
        if (almId != null) {
            LOGGER_WH_HEALTH.debug("webhoook log from alm : " + almId);
        }
        LOGGER_WH_HEALTH.debug(String.join((CharSequence)"\n", logs));
    }

    private HierarchyLevel getHierarchyLevelForItem(List<HierarchyLevel> hierarchyLevels, BacklogItem item, String releaseTrainId) {
        BaseItemLink artRelation = (BaseItemLink)item.getArtRelationMap().get(releaseTrainId);
        HierarchyLevel level = hierarchyLevels.stream().filter(hlevel -> hlevel.getLevel() == artRelation.getBacklogLevel()).findAny().orElse(null);
        return level;
    }

    private HierarchyLevel getNextLevel(List<HierarchyLevel> hierarchyLevels, HierarchyLevel currentLevel, int step) {
        int newIndex;
        int index = IntStream.range(0, hierarchyLevels.size()).filter(ind -> ((HierarchyLevel)hierarchyLevels.get(ind)).getLevel() == currentLevel.getLevel()).findAny().orElse(-1);
        if (index > -1 && (newIndex = index + step) > -1 && newIndex < hierarchyLevels.size()) {
            return hierarchyLevels.get(newIndex);
        }
        return null;
    }

    private HierarchyLevel getLevelWithLevelIndex(List<HierarchyLevel> hierarchyLevels, int index) {
        HierarchyLevel level = hierarchyLevels.stream().filter(lvl -> lvl.getLevel() == index).findAny().orElse(null);
        return level;
    }

    private HashMap<String, Object> getResyncMetaForAlmAccount(AlmAccount almAccount) {
        List tfsProjects = this.tfsProjectRepository.findByAlmId(almAccount.getId());
        HashMap<String, Status> statusMapByItemTypeAndName = new HashMap<String, Status>();
        HashMap<String, TFSProject> projectMapById = new HashMap<String, TFSProject>();
        HashMap<String, TFSProject> projectMapByName = new HashMap<String, TFSProject>();
        for (TFSProject project : tfsProjects) {
            projectMapById.put(project.getTfsId(), project);
            projectMapByName.put(project.getName(), project);
            List statuses = this.statusRepository.findByTfsProjectIdAndAlmId(project.getTfsId(), almAccount.getId());
            if (!PropertyValidator.isValid((Collection)statuses)) continue;
            for (Status status : statuses) {
                String key = project.getTfsId() + ":" + status.getItemType() + ":" + status.getTitle();
                statusMapByItemTypeAndName.put(key, status);
            }
        }
        HashMap<String, Object> itemMeta = new HashMap<String, Object>();
        itemMeta.put("statusMap", statusMapByItemTypeAndName);
        itemMeta.put("projectMapById", projectMapById);
        itemMeta.put("projectMapByName", projectMapByName);
        return itemMeta;
    }

    private Map<String, Object> fetchAndSyncTfsItems(List<String> tfsIds, TFSFilter tfsFilter, AlmAccount almAccount, Map<String, Object> otherParams, WorkSpace releaseTrain) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("alm", almAccount);
        List hierarchyLevels = null;
        try {
            hierarchyLevels = this.getHierarchyLevels(releaseTrain);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        String currentLevelStr = (String)otherParams.get("backlogLevel");
        int currentLevel = Integer.parseInt(currentLevelStr);
        HierarchyLevel currentHierarchyLevel = this.getLevelWithLevelIndex(hierarchyLevels, currentLevel);
        HashMap itemMeta = this.getResyncMetaForAlmAccount(almAccount);
        itemMeta.put("filter", tfsFilter);
        itemMeta.put("releaseTrainId", releaseTrain.getId());
        itemMeta.put("user", otherParams.get("user"));
        ArrayList<BacklogItem> itemsToSave = new ArrayList<BacklogItem>();
        if (PropertyValidator.isValid(tfsIds)) {
            HashMap levelsResultMap = new HashMap();
            try {
                HierarchyLevel parentHierarchyLevel = null;
                Object parentLevelMap = null;
                boolean goUpward = true;
                if (otherParams.containsKey("parent")) {
                    BacklogItem parentItem = (BacklogItem)otherParams.get("parent");
                    parentLevelMap = new HashMap<String, BacklogItem>();
                    for (String _id : tfsIds) {
                        ((HashMap)parentLevelMap).put(_id, parentItem);
                    }
                    itemsToSave.add(parentItem);
                    goUpward = false;
                } else {
                    parentHierarchyLevel = this.getNextLevel(hierarchyLevels, currentHierarchyLevel, -1);
                }
                itemMeta.put("completeResync", true);
                Map firstLevelResult = this.fetchAndSyncTfsItemForSingleLevel(tfsIds, currentHierarchyLevel, parentHierarchyLevel, parentLevelMap, null, true, goUpward, almAccount, itemsToSave, itemMeta);
                this.addLevelResultInMap(levelsResultMap, firstLevelResult, currentHierarchyLevel);
                ArrayList nextDownLevelItems = (ArrayList)firstLevelResult.get("downItems");
                HashMap parentMapForNextDownLevel = (HashMap)firstLevelResult.get("parentsForDownItems");
                HierarchyLevel nextHierarchyLevel = this.getNextLevel(hierarchyLevels, currentHierarchyLevel, 1);
                while (nextHierarchyLevel != null && PropertyValidator.isValid((Collection)nextDownLevelItems)) {
                    Map currentLevelResult = this.fetchAndSyncTfsItemForSingleLevel((List)nextDownLevelItems, nextHierarchyLevel, null, parentMapForNextDownLevel, null, true, false, almAccount, itemsToSave, itemMeta);
                    nextDownLevelItems = (ArrayList)currentLevelResult.get("downItems");
                    parentMapForNextDownLevel = (HashMap)currentLevelResult.get("parentsForDownItems");
                    this.addLevelResultInMap(levelsResultMap, currentLevelResult, nextHierarchyLevel);
                    nextHierarchyLevel = this.getNextLevel(hierarchyLevels, nextHierarchyLevel, 1);
                }
                ArrayList nextUpperLevelItems = (ArrayList)firstLevelResult.get("upperItems");
                HashMap childrenMapForNextUpperLevel = (HashMap)firstLevelResult.get("chilrenForUpperItems");
                nextHierarchyLevel = this.getNextLevel(hierarchyLevels, currentHierarchyLevel, -1);
                if (nextHierarchyLevel != null) {
                    parentHierarchyLevel = this.getNextLevel(hierarchyLevels, nextHierarchyLevel, -1);
                }
                while (nextHierarchyLevel != null && PropertyValidator.isValid((Collection)nextUpperLevelItems)) {
                    Map currentLevelResult = this.fetchAndSyncTfsItemForSingleLevel((List)nextUpperLevelItems, nextHierarchyLevel, parentHierarchyLevel, null, childrenMapForNextUpperLevel, false, true, almAccount, itemsToSave, itemMeta);
                    this.addLevelResultInMap(levelsResultMap, currentLevelResult, nextHierarchyLevel);
                    nextUpperLevelItems = (ArrayList)currentLevelResult.get("upperItems");
                    childrenMapForNextUpperLevel = (HashMap)currentLevelResult.get("chilrenForUpperItems");
                    if ((nextHierarchyLevel = this.getNextLevel(hierarchyLevels, nextHierarchyLevel, -1)) == null) continue;
                    parentHierarchyLevel = this.getNextLevel(hierarchyLevels, nextHierarchyLevel, -1);
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                throw e;
            }
            result.put("levelsResult", levelsResultMap);
            Boolean isThereAnyError = false;
            for (String key : levelsResultMap.keySet()) {
                Map levelResultMap = (Map)levelsResultMap.get(key);
                if (!levelResultMap.containsKey("error") && !levelResultMap.containsKey("vzError")) continue;
                LOGGER.info("------------------------------------------");
                LOGGER.info("        ERROR FOUND IN LEVELS");
                isThereAnyError = true;
                break;
            }
            result.put("error", isThereAnyError);
        }
        LOGGER.info("------------------------------------------");
        LOGGER.info("        PROCESSING COMPLETED");
        try {
            boolean error = false;
            if (result.containsKey("error")) {
                error = (Boolean)result.get("error");
            }
            if (!error && PropertyValidator.isValid(itemsToSave)) {
                LOGGER.info("------------------------------------------");
                LOGGER.info("        BEFORE SAVING ITEMS");
                this.backlogItemRepository.save(itemsToSave);
                ArrayList<BacklogItem> actualItemsToSave = new ArrayList<BacklogItem>();
                ArrayList<BacklogItem> actualItemsToDelete = new ArrayList<BacklogItem>();
                HashMap<String, BacklogItem> dulicationCheckMap = new HashMap<String, BacklogItem>();
                for (BacklogItem item : itemsToSave) {
                    if (!dulicationCheckMap.containsKey(item.getAlmItemId())) {
                        dulicationCheckMap.put(item.getAlmItemId(), item);
                        actualItemsToSave.add(item);
                        continue;
                    }
                    actualItemsToDelete.add(item);
                }
                if (PropertyValidator.isValid(actualItemsToSave)) {
                    this.backlogItemRepository.save(actualItemsToSave);
                }
                if (PropertyValidator.isValid(actualItemsToDelete)) {
                    this.backlogItemRepository.delete(actualItemsToDelete);
                }
                LOGGER.info("        AFTER SAVING ITEMS");
                this.addBoardsInItems(releaseTrain.getId(), actualItemsToSave, almAccount, null);
                this.customRepositoryImpl.bulkLogs(actualItemsToSave, almAccount.getTenant());
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        return result;
    }

    private Map<String, Object> fetchAndSyncTfsItemForSingleLevel(List<String> itemIds, HierarchyLevel currentHierarchyLevel, HierarchyLevel parentHierarchyLevel, HashMap<String, BacklogItem> uperLevelParentMap, HashMap<String, ArrayList<BacklogItem>> lowerLevelChildrenMap, boolean goDownward, boolean goUpward, AlmAccount almAccount, ArrayList<BacklogItem> itemsToSave, HashMap<String, Object> itemMeta) {
        User user = null;
        boolean noContext = true;
        if (itemMeta.containsKey("user")) {
            user = (User)itemMeta.get("user");
        }
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            if (user == null) {
                user = UserContextUtil.getUserContext().getLoggedInUser();
            }
            noContext = false;
        }
        boolean completeResync = true;
        if (itemMeta.containsKey("completeResync")) {
            completeResync = (Boolean)itemMeta.get("completeResync");
        }
        List existingItems = this.backlogItemRepository.findByAlmItemIdInAndAlmAccountId(itemIds, almAccount.getId());
        HashMap existingItemsMap = new HashMap();
        if (PropertyValidator.isValid((Collection)existingItems)) {
            existingItems.forEach(item -> existingItemsMap.put(item.getAlmItemId(), item));
        }
        AlmHierarchyLevelMapping currentHierarchyLevelMapping = null;
        AlmHierarchyLevelMapping parentHierarchyLevelMapping = null;
        if (currentHierarchyLevel != null && currentHierarchyLevel.getAlmHierarchyLevelMappings() != null) {
            currentHierarchyLevelMapping = currentHierarchyLevel.getAlmHierarchyLevelMappings().stream().filter(_mapping -> _mapping.getAlmAccountId().equalsIgnoreCase(almAccount.getId())).findAny().orElse(null);
        }
        if (parentHierarchyLevel != null && parentHierarchyLevel.getAlmHierarchyLevelMappings() != null) {
            parentHierarchyLevelMapping = parentHierarchyLevel.getAlmHierarchyLevelMappings().stream().filter(_mapping -> _mapping.getAlmAccountId().equalsIgnoreCase(almAccount.getId())).findAny().orElse(null);
        }
        HashMap statusMapByItemTypeAndName = (HashMap)itemMeta.get("statusMap");
        HashMap projectMapById = (HashMap)itemMeta.get("projectMapById");
        HashMap projectMapByName = (HashMap)itemMeta.get("projectMapByName");
        String releaseTrainId = (String)itemMeta.get("releaseTrainId");
        WorkSpace releaseTrain = (WorkSpace)itemMeta.get("releaseTrain");
        if (releaseTrain == null) {
            releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        }
        HashMap ignoreItemsInResync = releaseTrain.getIgnoreItemsInResync();
        TFSFilter tfsFilter = (TFSFilter)itemMeta.get("filter");
        ArrayList<BacklogItem> newAddedItems = new ArrayList<BacklogItem>();
        ArrayList<BacklogItem> existingUpdatedItems = new ArrayList<BacklogItem>();
        ArrayList<String> nextDownLevelItems = new ArrayList<String>();
        HashMap<String, BacklogItem> parentMapForNextDownLevel = new HashMap<String, BacklogItem>();
        ArrayList<String> nextUpLevelItems = new ArrayList<String>();
        HashMap<String, ArrayList<BacklogItem>> childMapForNextUpLevel = new HashMap<String, ArrayList<BacklogItem>>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, BacklogItem> existingChildIdsMapToRemoveUnlinkedChild = new HashMap<String, BacklogItem>();
        HashMap<String, String> itemTfsItdsToCheckLinks = new HashMap<String, String>();
        if (PropertyValidator.isValid(uperLevelParentMap)) {
            Set<String> keys = uperLevelParentMap.keySet();
            ArrayList<ObjectId> existingParentIds = new ArrayList<ObjectId>();
            for (String key : keys) {
                BacklogItem item2 = uperLevelParentMap.get(key);
                existingParentIds.add(new ObjectId(item2.getId()));
            }
            if (PropertyValidator.isValid(existingParentIds)) {
                Query query = new Query();
                query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)("parentRelationMap." + releaseTrainId + ".backlogItemId")).in(existingParentIds));
                String tenant = "";
                tenant = noContext ? almAccount.getTenant() : UserContextUtil.getUserContext().getCurrentCompany().getTenant();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                List existingChildren = this.mongoTemplate.find(query, BacklogItem.class);
                if (completeResync && PropertyValidator.isValid((Collection)existingChildren)) {
                    for (BacklogItem child : existingChildren) {
                        existingChildIdsMapToRemoveUnlinkedChild.put(child.getId(), child);
                        if (!PropertyValidator.isValid((Object)child.getAlmItemId())) continue;
                        itemTfsItdsToCheckLinks.put(child.getAlmItemId(), child.getAlmItemId());
                    }
                }
            }
        }
        boolean removeMiscStatusItems = false;
        if (almAccount.getExcludeMiscStatuses() != null) {
            removeMiscStatusItems = almAccount.getExcludeMiscStatuses();
        }
        ArrayList<BacklogItem> miscStatusItemsToRemove = new ArrayList<BacklogItem>();
        AlmAccount saveAlmAccount = this.almAccountRepository.findById(almAccount.getId());
        ArrayList almLinksForward = new ArrayList();
        ArrayList<String> forwardLinksSourceTfsIds = new ArrayList<String>();
        ArrayList<String> forwardLinksTargetTfsIds = new ArrayList<String>();
        ArrayList<String> forwardMissingTfsIds = new ArrayList<String>();
        ArrayList almLinksReverse = new ArrayList();
        ArrayList<String> reverseLinksSourceTfsIds = new ArrayList<String>();
        ArrayList<String> reverseLinksTargetTfsIds = new ArrayList<String>();
        ArrayList<String> reverseMissingTfsIds = new ArrayList<String>();
        HashMap<String, BacklogItem> backlogItemByTfsIdMap = new HashMap<String, BacklogItem>();
        try {
            List subSetsItemIds = Lists.partition(new ArrayList<String>(itemIds), (int)100);
            for (List subSetItemIds : subSetsItemIds) {
                JSONArray itemIDsArray = new JSONArray();
                HashMap addTfsItemIdsToIgnoreListMap = new HashMap();
                subSetItemIds.stream().forEach(_id -> {
                    addTfsItemIdsToIgnoreListMap.put(_id, _id);
                    itemIDsArray.put(_id);
                });
                JSONObject requetBody = new JSONObject();
                requetBody.put("fields", (Object)new JSONArray());
                requetBody.put("errorPolicy", (Object)"omit");
                requetBody.put("$expand", (Object)"all");
                requetBody.put("ids", (Object)itemIDsArray);
                TFSResponse respons = this.tfsUtils.getBatchItems(requetBody, almAccount);
                try {
                    if (PropertyValidator.isValid((Object)almAccount) && almAccount.isDebug()) {
                        LOGGER.debug("------------------------ RESYNC ITEM RESPONSE FROM ADO ----------------------");
                        LOGGER.debug(respons.getContent());
                    }
                    JSONObject dataObjects = new JSONObject(respons.getContent());
                    JSONArray itemsDataArray = dataObjects.getJSONArray("value");
                    for (int i = 0; i < itemsDataArray.length(); ++i) {
                        JSONArray relationsArray;
                        ArrayList<BacklogItem> children;
                        Object itemObject = itemsDataArray.get(i);
                        if (itemObject == JSONObject.NULL) {
                            BacklogItem parentItem;
                            BaseItemLink existingLink;
                            String tfsId = (String)subSetItemIds.get(i);
                            if (!PropertyValidator.isValid((Object)tfsId)) continue;
                            BacklogItem item3 = null;
                            if (existingItemsMap.containsKey(tfsId)) {
                                item3 = (BacklogItem)existingItemsMap.get(tfsId);
                            }
                            if (!PropertyValidator.isValid(item3)) continue;
                            if (PropertyValidator.isValid(uperLevelParentMap) && uperLevelParentMap.containsKey(tfsId) && (existingLink = this.findBaseItemLink(parentItem = uperLevelParentMap.get(tfsId), releaseTrainId, EnumKendis.ART_CHILD_LINK.getCode(), item3.getId())) == null) {
                                parentItem.linkToChild(releaseTrainId, item3.getId());
                            }
                            if (!existingChildIdsMapToRemoveUnlinkedChild.containsKey(item3.getId())) continue;
                            existingChildIdsMapToRemoveUnlinkedChild.remove(item3.getId());
                            continue;
                        }
                        JSONObject itemDataObject = (JSONObject)itemObject;
                        JSONObject itemTfsFields = itemDataObject.getJSONObject("fields");
                        String itemId = itemDataObject.getString("id");
                        if (addTfsItemIdsToIgnoreListMap.containsKey(itemId)) {
                            addTfsItemIdsToIgnoreListMap.remove(itemId);
                        }
                        String itemType = itemTfsFields.getString("System.WorkItemType");
                        TFSWorkItemType workItemType = null;
                        if (PropertyValidator.isValid((Object)currentHierarchyLevelMapping)) {
                            workItemType = currentHierarchyLevelMapping.getTfsWorkItemTypes().stream().filter(wit -> wit.getName().equals(itemType)).findAny().orElse(null);
                        }
                        if (!PropertyValidator.isValid(workItemType)) continue;
                        BacklogItem item4 = null;
                        boolean isNewItem = false;
                        if (existingItemsMap.containsKey(itemId)) {
                            ArrayList<BacklogItem> children2;
                            item4 = (BacklogItem)existingItemsMap.get(itemId);
                            existingUpdatedItems.add(item4);
                            if (goDownward) {
                                item4.setDirty(Boolean.valueOf(false));
                            }
                            boolean isUpperLevelParentFound = false;
                            if (PropertyValidator.isValid(lowerLevelChildrenMap) && PropertyValidator.isValid(children2 = lowerLevelChildrenMap.get(itemId))) {
                                isUpperLevelParentFound = true;
                            }
                            if (!isUpperLevelParentFound) {
                                item4.getParentRelationMap().put(releaseTrainId, new ArrayList());
                                item4.getChildRelationMap().put(releaseTrainId, new ArrayList());
                            }
                            if (existingChildIdsMapToRemoveUnlinkedChild.containsKey(item4.getId())) {
                                existingChildIdsMapToRemoveUnlinkedChild.remove(item4.getId());
                            }
                        } else {
                            isNewItem = true;
                            item4 = new BacklogItem(ObjectId.get().toString(), user);
                            newAddedItems.add(item4);
                            if (goUpward && !goDownward) {
                                item4.setDirty(Boolean.valueOf(true));
                            }
                            if (noContext) {
                                item4.setKendisKey(this.customRepositoryImpl.generateKey("K", almAccount.getTenant()));
                            } else {
                                item4.setKendisKey(this.customRepositoryImpl.generateKey("K"));
                            }
                        }
                        item4.setFetchedBy(user);
                        Map tfsItemInfo = this.tfsItemFromRawJSON(item4, itemDataObject, itemTfsFields, (Map)projectMapById, (Map)projectMapByName, (Map)statusMapByItemTypeAndName, currentHierarchyLevelMapping);
                        TFSProject tfsProject = (TFSProject)tfsItemInfo.get("tfsProject");
                        item4 = (BacklogItem)tfsItemInfo.get("backlogItem");
                        if (tfsProject == null) continue;
                        if (removeMiscStatusItems && PropertyValidator.isValid((Object)item4.getStatus()) && item4.getStatus().getCategory().equals("Misc")) {
                            if (isNewItem) continue;
                            miscStatusItemsToRemove.add(item4);
                            continue;
                        }
                        backlogItemByTfsIdMap.put(item4.getAlmItemId(), item4);
                        item4.setAlmAccountId(almAccount.getId());
                        if (item4.getFilterIds() == null) {
                            item4.setFilterIds(new HashSet());
                        }
                        BaseItemLink releaseLink = null;
                        HashMap<String, BaseItemLink> parentLinksMap = new HashMap<String, BaseItemLink>();
                        HashMap<String, BaseItemLink> childLinksMap = new HashMap<String, BaseItemLink>();
                        if (item4.getRelations() == null) {
                            item4.setRelations(new ArrayList());
                        }
                        releaseLink = (BaseItemLink)item4.getArtRelationMap().get(releaseTrainId);
                        if (PropertyValidator.isValid((Collection)((Collection)item4.getParentRelationMap().get(releaseTrainId)))) {
                            for (BaseItemLink itemLink : (List)item4.getParentRelationMap().get(releaseTrainId)) {
                                parentLinksMap.put(itemLink.getBacklogItemId().toString(), itemLink);
                            }
                        }
                        if (PropertyValidator.isValid((Collection)((Collection)item4.getChildRelationMap().get(releaseTrainId)))) {
                            for (BaseItemLink itemLink : (List)item4.getChildRelationMap().get(releaseTrainId)) {
                                childLinksMap.put(itemLink.getBacklogItemId().toString(), itemLink);
                            }
                        }
                        if (PropertyValidator.isValid((Object)tfsFilter) && !item4.getFilterIds().contains(tfsFilter.getTfsId())) {
                            item4.getFilterIds().add(tfsFilter.getTfsId());
                        }
                        itemsToSave.add(item4);
                        if (releaseLink == null && releaseTrainId != null) {
                            item4.linkToRTE(releaseTrainId, currentHierarchyLevel.getLevel());
                        }
                        if (PropertyValidator.isValid(uperLevelParentMap) && uperLevelParentMap.containsKey(itemId)) {
                            BacklogItem parentItem = uperLevelParentMap.get(itemId);
                            Object existingLink = this.findBaseItemLink(parentItem, releaseTrainId, EnumKendis.ART_CHILD_LINK.getCode(), item4.getId());
                            if (existingLink == null) {
                                parentItem.linkToChild(releaseTrainId, item4.getId());
                            }
                            if ((existingLink = (BaseItemLink)parentLinksMap.get(parentItem.getId())) == null) {
                                item4.linkToParent(releaseTrainId, parentItem.getId());
                            }
                        }
                        if (PropertyValidator.isValid(lowerLevelChildrenMap) && lowerLevelChildrenMap.containsKey(itemId) && PropertyValidator.isValid(children = lowerLevelChildrenMap.get(itemId))) {
                            for (BacklogItem child : children) {
                                BaseItemLink existingLink = this.findBaseItemLink(child, releaseTrainId, EnumKendis.ART_PARENT_LINK.getCode(), item4.getId());
                                if (existingLink == null) {
                                    child.linkToParent(releaseTrainId, item4.getId());
                                }
                                if ((existingLink = (BaseItemLink)childLinksMap.get(child.getId())) != null) continue;
                                item4.linkToChild(releaseTrainId, child.getId());
                            }
                        }
                        if (itemDataObject.isNull("relations") || !PropertyValidator.isValid((Object)(relationsArray = itemDataObject.getJSONArray("relations")))) continue;
                        for (int j = 0; j < relationsArray.length(); ++j) {
                            JSONObject relationObject = relationsArray.getJSONObject(j);
                            String relationType = relationObject.getString("rel");
                            String relationURL = relationObject.getString("url");
                            if (goDownward) {
                                TFSItemLinkType itemLinkType = null;
                                if (PropertyValidator.isValid((Object)currentHierarchyLevelMapping)) {
                                    itemLinkType = currentHierarchyLevelMapping.getTfsItemLinkTypes().stream().filter(ilt -> ilt.getReferenceName().equals(relationType)).findAny().orElse(null);
                                }
                                if (PropertyValidator.isValid(itemLinkType)) {
                                    String childId = relationURL.substring(relationURL.lastIndexOf("/") + 1);
                                    nextDownLevelItems.add(childId);
                                    parentMapForNextDownLevel.put(childId, item4);
                                }
                            }
                            if (goUpward && PropertyValidator.isValid((Object)parentHierarchyLevelMapping)) {
                                String reverseRelation = this.reverseTFSRelation(relationType);
                                TFSItemLinkType itemLinkType = parentHierarchyLevelMapping.getTfsItemLinkTypes().stream().filter(ilt -> ilt.getReferenceName().equals(reverseRelation)).findAny().orElse(null);
                                if (PropertyValidator.isValid((Object)itemLinkType)) {
                                    String parentId = relationURL.substring(relationURL.lastIndexOf("/") + 1);
                                    nextUpLevelItems.add(parentId);
                                    ArrayList<BacklogItem> children3 = (ArrayList<BacklogItem>)childMapForNextUpLevel.get(parentId);
                                    if (children3 == null) {
                                        children3 = new ArrayList<BacklogItem>();
                                        childMapForNextUpLevel.put(parentId, children3);
                                    }
                                    children3.add(item4);
                                }
                            }
                            if (!PropertyValidator.isValid((Collection)saveAlmAccount.getDependencyLinkTypes()) || !saveAlmAccount.getDependencyLinkTypes().contains(relationType)) continue;
                            String linkType = relationType;
                            boolean isItemSource = true;
                            String otherItemTfsId = relationURL.substring(relationURL.lastIndexOf("/") + 1);
                            String otherItemURL = relationURL.replace("_apis/wit/workItems", "_workitems/edit");
                            if (relationType.contains("Reverse")) {
                                linkType = this.reverseTFSRelation(relationType);
                                isItemSource = false;
                            }
                            HashMap<String, String> dependencyMap = new HashMap<String, String>();
                            if (isItemSource) {
                                dependencyMap.put("sItemId", item4.getId());
                                dependencyMap.put("sItemTfsId", item4.getAlmItemId());
                                dependencyMap.put("sItemUrl", item4.getUrl());
                                forwardLinksSourceTfsIds.add(item4.getAlmItemId());
                                forwardLinksTargetTfsIds.add(otherItemTfsId);
                                dependencyMap.put("tItemTfsId", otherItemTfsId);
                                dependencyMap.put("tItemUrl", otherItemURL);
                                forwardMissingTfsIds.add(otherItemTfsId);
                                almLinksForward.add(dependencyMap);
                            } else {
                                dependencyMap.put("tItemId", item4.getId());
                                dependencyMap.put("tItemTfsId", item4.getAlmItemId());
                                dependencyMap.put("tItemUrl", item4.getUrl());
                                reverseLinksTargetTfsIds.add(item4.getAlmItemId());
                                reverseLinksSourceTfsIds.add(otherItemTfsId);
                                dependencyMap.put("sItemTfsId", otherItemTfsId);
                                dependencyMap.put("sItemUrl", otherItemURL);
                                reverseMissingTfsIds.add(otherItemTfsId);
                                almLinksReverse.add(dependencyMap);
                            }
                            dependencyMap.put("type", linkType);
                        }
                    }
                    if (addTfsItemIdsToIgnoreListMap.isEmpty()) continue;
                    releaseTrain.setIgnoreItemsInResync(new HashMap());
                    for (String key : addTfsItemIdsToIgnoreListMap.keySet()) {
                        releaseTrain.getIgnoreItemsInResync().put(key, key);
                    }
                    this.workSpaceRepository.save((Object)releaseTrain);
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    result.put("error", e);
                }
            }
        }
        catch (ViztrendJiraException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            result.put("vzError", e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            result.put("error", e.getMessage());
        }
        if (PropertyValidator.isValid(existingChildIdsMapToRemoveUnlinkedChild)) {
            Set keys = existingChildIdsMapToRemoveUnlinkedChild.keySet();
            for (String key : keys) {
                BacklogItem item5 = (BacklogItem)existingChildIdsMapToRemoveUnlinkedChild.get(key);
                item5.getParentRelationMap().put(releaseTrainId, new ArrayList());
                itemsToSave.add(item5);
            }
        }
        if (PropertyValidator.isValid(miscStatusItemsToRemove)) {
            try {
                this.deleteBacklogItems(miscStatusItemsToRemove, false);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        if (itemTfsItdsToCheckLinks.isEmpty()) {
            for (String tfsId : backlogItemByTfsIdMap.keySet()) {
                itemTfsItdsToCheckLinks.put(tfsId, tfsId);
            }
        }
        Query query0 = new Query();
        query0.addCriteria((CriteriaDefinition)Criteria.where((String)"almId").is((Object)saveAlmAccount.getId()));
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"sourceTFSItem.tfsId").in(itemTfsItdsToCheckLinks.keySet()), Criteria.where((String)"targetTFSItem.tfsId").in(itemTfsItdsToCheckLinks.keySet())});
        query0.addCriteria((CriteriaDefinition)criteria);
        query0.addCriteria((CriteriaDefinition)Criteria.where((String)"isOrg").is((Object)true));
        List existingLinks1 = this.mongoTemplate.find(query0, ItemJiraDependency.class);
        HashMap<String, ItemJiraDependency> existingLinksToDelete = new HashMap<String, ItemJiraDependency>();
        if (PropertyValidator.isValid((Collection)existingLinks1)) {
            for (ItemJiraDependency link : existingLinks1) {
                String key = "";
                if (PropertyValidator.isValid((Object)link.getSourceTFSItem())) {
                    key = key + link.getSourceTFSItem().getTfsId();
                }
                if (PropertyValidator.isValid((Object)link.getTargetTFSItem())) {
                    key = key + link.getTargetTFSItem().getTfsId();
                }
                if (PropertyValidator.isValid((Object)link.getTfsLinkType())) {
                    key = key + link.getTfsLinkType();
                }
                existingLinksToDelete.put(key, link);
            }
        }
        this.handleCreationAndDeletionOfTfsDependencies(almLinksForward, forwardLinksSourceTfsIds, forwardLinksTargetTfsIds, forwardMissingTfsIds, almLinksReverse, reverseLinksSourceTfsIds, reverseLinksTargetTfsIds, reverseMissingTfsIds, saveAlmAccount, backlogItemByTfsIdMap, existingLinksToDelete);
        result.put("itemsAdded", newAddedItems);
        result.put("itemsUpdated", existingUpdatedItems);
        result.put("downItems", nextDownLevelItems);
        result.put("parentsForDownItems", parentMapForNextDownLevel);
        result.put("upperItems", nextUpLevelItems);
        result.put("chilrenForUpperItems", childMapForNextUpLevel);
        return result;
    }

    public void handleDependenciesOnDeleteItems(List<BacklogItem> itemsToDelete) throws Exception {
        LOGGER.debug("Inside handle dependencies on delete items");
        ArrayList<String> itemIDs = new ArrayList<String>();
        HashMap<String, String> deleteItemsMap = new HashMap<String, String>();
        for (BacklogItem item : itemsToDelete) {
            itemIDs.add(item.getId());
            deleteItemsMap.put(item.getId(), item.getId());
        }
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query1 = new Query();
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"sourceBacklogItemId").in(itemIDs), Criteria.where((String)"targetBacklogItemId").in(itemIDs)});
        query1.addCriteria((CriteriaDefinition)criteria);
        List links = this.mongoTemplate.find(query1, ItemJiraDependency.class);
        ArrayList<ItemJiraDependency> linksToSave = new ArrayList<ItemJiraDependency>();
        ArrayList<ItemJiraDependency> linksToDelete = new ArrayList<ItemJiraDependency>();
        if (PropertyValidator.isValid((Collection)links)) {
            for (ItemJiraDependency link : links) {
                if (deleteItemsMap.containsKey(link.getSourceBacklogItemId())) {
                    link.setSourceBacklogItemId(null);
                }
                if (deleteItemsMap.containsKey(link.getTargetBacklogItemId())) {
                    link.setTargetBacklogItemId(null);
                }
                if (link.getSourceBacklogItemId() == null && link.getTargetBacklogItemId() == null) {
                    link.setArchive(true);
                    linksToDelete.add(link);
                    continue;
                }
                linksToSave.add(link);
            }
        }
        if (PropertyValidator.isValid(linksToSave)) {
            this.itemJiraDependencyRepository.save(linksToSave);
        }
        if (PropertyValidator.isValid(linksToDelete)) {
            this.itemJiraDependencyRepository.save(linksToDelete);
        }
    }

    private void handleCreationAndDeletionOfTfsDependencies(ArrayList<HashMap<String, String>> almLinksForward, ArrayList<String> forwardLinksSourceTfsIds, ArrayList<String> forwardLinksTargetTfsIds, ArrayList<String> forwardMissingTfsIds, ArrayList<HashMap<String, String>> almLinksReverse, ArrayList<String> reverseLinksSourceTfsIds, ArrayList<String> reverseLinksTargetTfsIds, ArrayList<String> reverseMissingTfsIds, AlmAccount saveAlmAccount, HashMap<String, BacklogItem> backlogItemByTfsIdMap, HashMap<String, ItemJiraDependency> existingLinksToDelete) {
        boolean linkIdAlreadyExist;
        BacklogItem targetBacklgoItem;
        BacklogItem sourceBacklgoItem;
        ItemJiraDependency dependency;
        String key;
        ArrayList<ItemJiraDependency> dependencies;
        ArrayList<BacklogItem> backlogItemsToUpdate;
        HashMap missingItemMapByTfsId;
        List missingItems;
        Object query2;
        List links;
        Query query1;
        HashMap<String, ItemJiraDependency> existingLinks = new HashMap<String, ItemJiraDependency>();
        String tenant = PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && PropertyValidator.isValid((Object)UserContextUtil.getUserContext().getCurrentCompany()) ? UserContextUtil.getUserContext().getCurrentCompany().getTenant() : saveAlmAccount.getTenant();
        if (PropertyValidator.isValid(almLinksForward)) {
            query1 = new Query();
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"almId").in(new Object[]{saveAlmAccount.getId()}));
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"sourceTFSItem.tfsId").in(forwardLinksSourceTfsIds));
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"targetTFSItem.tfsId").in(forwardLinksTargetTfsIds));
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"isOrg").is((Object)true));
            links = this.mongoTemplate.find(query1, ItemJiraDependency.class);
            if (PropertyValidator.isValid((Collection)links)) {
                for (ItemJiraDependency link : links) {
                    String key2 = "";
                    if (PropertyValidator.isValid((Object)link.getSourceTFSItem())) {
                        key2 = key2 + link.getSourceTFSItem().getTfsId();
                    }
                    if (PropertyValidator.isValid((Object)link.getTargetTFSItem())) {
                        key2 = key2 + link.getTargetTFSItem().getTfsId();
                    }
                    if (PropertyValidator.isValid((Object)link.getTfsLinkType())) {
                        key2 = key2 + link.getTfsLinkType();
                    }
                    existingLinks.put(key2, link);
                }
            }
            query2 = new Query();
            query2.fields().include("linkIds");
            query2.fields().include("almItemId");
            query2.fields().include("dependencyLinkIds");
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"almItemId").in(forwardMissingTfsIds));
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").is((Object)saveAlmAccount.getId()));
            missingItems = this.mongoTemplate.find((Query)query2, BacklogItem.class);
            missingItemMapByTfsId = new HashMap();
            if (PropertyValidator.isValid((Collection)missingItems)) {
                missingItems.forEach(item -> missingItemMapByTfsId.put(item.getAlmItemId(), item));
            }
            backlogItemsToUpdate = new ArrayList<BacklogItem>();
            dependencies = new ArrayList<ItemJiraDependency>();
            for (Map map : almLinksForward) {
                key = (String)map.get("sItemTfsId") + "" + (String)map.get("tItemTfsId") + "" + (String)map.get("type");
                existingLinksToDelete.remove(key);
                dependency = (ItemJiraDependency)existingLinks.get(key);
                if (dependency == null) {
                    dependency = new ItemJiraDependency();
                    dependency.setId(ObjectId.get().toString());
                    dependency.setIsOrg(Boolean.valueOf(true));
                    dependency.setIsTFS(Boolean.valueOf(true));
                    dependency.setAlmId(saveAlmAccount.getId());
                    dependency.setTenant(tenant);
                    existingLinks.put(key, dependency);
                }
                if (dependency.getSourceTFSItem() == null) {
                    dependency.setSourceTFSItem(new TFSIssue());
                }
                if (dependency.getTargetTFSItem() == null) {
                    dependency.setTargetTFSItem(new TFSIssue());
                }
                dependency.getSourceTFSItem().setTfsId((String)map.get("sItemTfsId"));
                dependency.getSourceTFSItem().setUrl((String)map.get("sItemUrl"));
                dependency.getTargetTFSItem().setTfsId((String)map.get("tItemTfsId"));
                dependency.getTargetTFSItem().setUrl((String)map.get("tItemUrl"));
                dependency.setTfsLinkType((String)map.get("type"));
                dependencies.add(dependency);
                sourceBacklgoItem = backlogItemByTfsIdMap.get(dependency.getSourceTFSItem().getTfsId());
                if (PropertyValidator.isValid((Object)sourceBacklgoItem)) {
                    dependency.setSourceBacklogItemId(sourceBacklgoItem.getId());
                    boolean linkIdAlreadyExist2 = false;
                    if (PropertyValidator.isValid((Collection)sourceBacklgoItem.getDependencyLinkIds()) && sourceBacklgoItem.getDependencyLinkIds().contains(dependency.getId())) {
                        linkIdAlreadyExist2 = true;
                    }
                    if (!linkIdAlreadyExist2) {
                        if (sourceBacklgoItem.getDependencyLinkIds() == null) {
                            sourceBacklgoItem.setDependencyLinkIds(new ArrayList());
                        }
                        sourceBacklgoItem.getDependencyLinkIds().add(dependency.getId());
                    }
                }
                if (!PropertyValidator.isValid((Object)(targetBacklgoItem = (BacklogItem)missingItemMapByTfsId.get(dependency.getTargetTFSItem().getTfsId())))) continue;
                dependency.setTargetBacklogItemId(targetBacklgoItem.getId());
                linkIdAlreadyExist = false;
                if (PropertyValidator.isValid((Collection)targetBacklgoItem.getDependencyLinkIds()) && targetBacklgoItem.getDependencyLinkIds().contains(dependency.getId())) {
                    linkIdAlreadyExist = true;
                }
                if (linkIdAlreadyExist) continue;
                if (targetBacklgoItem.getDependencyLinkIds() == null) {
                    targetBacklgoItem.setDependencyLinkIds(new ArrayList());
                }
                targetBacklgoItem.getDependencyLinkIds().add(dependency.getId());
                backlogItemsToUpdate.add(targetBacklgoItem);
            }
            if (PropertyValidator.isValid(backlogItemsToUpdate)) {
                this.customRepositoryImpl.bulkUpdateBacklogItemsLinkIds(backlogItemsToUpdate);
            }
            if (PropertyValidator.isValid(dependencies)) {
                this.itemJiraDependencyRepository.save(dependencies);
            }
        }
        if (PropertyValidator.isValid(almLinksReverse)) {
            query1 = new Query();
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"almId").in(new Object[]{saveAlmAccount.getId()}));
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"sourceTFSItem.tfsId").in(reverseLinksSourceTfsIds));
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"targetTFSItem.tfsId").in(reverseLinksTargetTfsIds));
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"isOrg").is((Object)true));
            links = this.mongoTemplate.find(query1, ItemJiraDependency.class);
            if (PropertyValidator.isValid((Collection)links)) {
                for (ItemJiraDependency link : links) {
                    String key2 = "";
                    if (PropertyValidator.isValid((Object)link.getSourceTFSItem())) {
                        key2 = key2 + link.getSourceTFSItem().getTfsId();
                    }
                    if (PropertyValidator.isValid((Object)link.getTargetTFSItem())) {
                        key2 = key2 + link.getTargetTFSItem().getTfsId();
                    }
                    if (PropertyValidator.isValid((Object)link.getTfsLinkType())) {
                        key2 = key2 + link.getTfsLinkType();
                    }
                    existingLinks.put(key2, link);
                }
            }
            query2 = new Query();
            query2.fields().include("linkIds");
            query2.fields().include("almItemId");
            query2.fields().include("dependencyLinkIds");
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"almItemId").in(reverseMissingTfsIds));
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").is((Object)saveAlmAccount.getId()));
            missingItems = this.mongoTemplate.find((Query)query2, BacklogItem.class);
            missingItemMapByTfsId = new HashMap();
            if (PropertyValidator.isValid((Collection)missingItems)) {
                missingItems.forEach(item -> missingItemMapByTfsId.put(item.getAlmItemId(), item));
            }
            backlogItemsToUpdate = new ArrayList();
            dependencies = new ArrayList();
            for (Map map : almLinksReverse) {
                key = (String)map.get("sItemTfsId") + "" + (String)map.get("tItemTfsId") + "" + (String)map.get("type");
                existingLinksToDelete.remove(key);
                dependency = (ItemJiraDependency)existingLinks.get(key);
                if (dependency == null) {
                    dependency = new ItemJiraDependency();
                    dependency.setId(ObjectId.get().toString());
                    dependency.setIsOrg(Boolean.valueOf(true));
                    dependency.setIsTFS(Boolean.valueOf(true));
                    dependency.setAlmId(saveAlmAccount.getId());
                    dependency.setTenant(tenant);
                    existingLinks.put(key, dependency);
                }
                if (dependency.getSourceTFSItem() == null) {
                    dependency.setSourceTFSItem(new TFSIssue());
                }
                if (dependency.getTargetTFSItem() == null) {
                    dependency.setTargetTFSItem(new TFSIssue());
                }
                dependency.getSourceTFSItem().setTfsId((String)map.get("sItemTfsId"));
                dependency.getSourceTFSItem().setUrl((String)map.get("sItemUrl"));
                dependency.getTargetTFSItem().setTfsId((String)map.get("tItemTfsId"));
                dependency.getTargetTFSItem().setUrl((String)map.get("tItemUrl"));
                dependency.setTfsLinkType((String)map.get("type"));
                dependencies.add(dependency);
                sourceBacklgoItem = (BacklogItem)missingItemMapByTfsId.get(dependency.getSourceTFSItem().getTfsId());
                if (PropertyValidator.isValid((Object)sourceBacklgoItem)) {
                    dependency.setSourceBacklogItemId(sourceBacklgoItem.getId());
                    boolean linkIdAlreadyExist3 = false;
                    if (PropertyValidator.isValid((Collection)sourceBacklgoItem.getDependencyLinkIds()) && sourceBacklgoItem.getDependencyLinkIds().contains(dependency.getId())) {
                        linkIdAlreadyExist3 = true;
                    }
                    if (!linkIdAlreadyExist3) {
                        if (sourceBacklgoItem.getDependencyLinkIds() == null) {
                            sourceBacklgoItem.setDependencyLinkIds(new ArrayList());
                        }
                        sourceBacklgoItem.getDependencyLinkIds().add(dependency.getId());
                        backlogItemsToUpdate.add(sourceBacklgoItem);
                    }
                }
                if (!PropertyValidator.isValid((Object)(targetBacklgoItem = backlogItemByTfsIdMap.get(dependency.getTargetTFSItem().getTfsId())))) continue;
                dependency.setTargetBacklogItemId(targetBacklgoItem.getId());
                linkIdAlreadyExist = false;
                if (PropertyValidator.isValid((Collection)targetBacklgoItem.getDependencyLinkIds()) && targetBacklgoItem.getDependencyLinkIds().contains(dependency.getId())) {
                    linkIdAlreadyExist = true;
                }
                if (linkIdAlreadyExist) continue;
                if (targetBacklgoItem.getDependencyLinkIds() == null) {
                    targetBacklgoItem.setDependencyLinkIds(new ArrayList());
                }
                targetBacklgoItem.getDependencyLinkIds().add(dependency.getId());
            }
            if (PropertyValidator.isValid(backlogItemsToUpdate)) {
                this.customRepositoryImpl.bulkUpdateBacklogItemsLinkIds(backlogItemsToUpdate);
            }
            if (PropertyValidator.isValid(dependencies)) {
                this.itemJiraDependencyRepository.save(dependencies);
            }
        }
        if (!existingLinksToDelete.isEmpty()) {
            HashMap<String, Boolean> deleteLinksMapById = new HashMap<String, Boolean>();
            HashMap<String, Boolean> duplicationCheckMap = new HashMap<String, Boolean>();
            ArrayList<String> itemIdsToFetch = new ArrayList<String>();
            ArrayList<BacklogItem> currentThreadItems = new ArrayList<BacklogItem>();
            for (ItemJiraDependency link : existingLinksToDelete.values()) {
                deleteLinksMapById.put(link.getId(), true);
                if (PropertyValidator.isValid((Object)link.getSourceTFSItem())) {
                    if (backlogItemByTfsIdMap.containsKey(link.getSourceTFSItem().getTfsId())) {
                        currentThreadItems.add(backlogItemByTfsIdMap.get(link.getSourceTFSItem().getTfsId()));
                    } else if (!duplicationCheckMap.containsKey(link.getSourceTFSItem().getTfsId())) {
                        itemIdsToFetch.add(link.getSourceTFSItem().getTfsId());
                        duplicationCheckMap.put(link.getSourceTFSItem().getTfsId(), true);
                    }
                }
                if (!PropertyValidator.isValid((Object)link.getTargetTFSItem())) continue;
                if (backlogItemByTfsIdMap.containsKey(link.getTargetTFSItem().getTfsId())) {
                    currentThreadItems.add(backlogItemByTfsIdMap.get(link.getTargetTFSItem().getTfsId()));
                    continue;
                }
                if (duplicationCheckMap.containsKey(link.getTargetTFSItem().getTfsId())) continue;
                itemIdsToFetch.add(link.getTargetTFSItem().getTfsId());
                duplicationCheckMap.put(link.getTargetTFSItem().getTfsId(), true);
            }
            if (PropertyValidator.isValid(currentThreadItems)) {
                for (BacklogItem item2 : currentThreadItems) {
                    if (!PropertyValidator.isValid((Collection)item2.getDependencyLinkIds())) continue;
                    item2.getDependencyLinkIds().removeIf(linkId -> deleteLinksMapById.containsKey(linkId));
                }
            }
            if (PropertyValidator.isValid(itemIdsToFetch)) {
                Query query22 = new Query();
                query22.fields().include("linkIds");
                query22.fields().include("almItemId");
                query22.fields().include("dependencyLinkIds");
                query22.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                query22.addCriteria((CriteriaDefinition)Criteria.where((String)"almItemId").in(itemIdsToFetch));
                query22.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").is((Object)saveAlmAccount.getId()));
                List itemsToFetch = this.mongoTemplate.find(query22, BacklogItem.class);
                for (BacklogItem item3 : itemsToFetch) {
                    if (!PropertyValidator.isValid((Collection)item3.getDependencyLinkIds())) continue;
                    item3.getDependencyLinkIds().removeIf(linkId -> deleteLinksMapById.containsKey(linkId));
                }
                this.customRepositoryImpl.bulkUpdateBacklogItemsLinkIds(itemsToFetch);
            }
            this.itemJiraDependencyRepository.delete(existingLinksToDelete.values());
        }
    }

    private List<String> getTfsItemsFromFilter(TFSFilter tfsFilter, AlmAccount almAccount) {
        try {
            String tfsItemIdsStr;
            AlmAccount tempALMAccount = new AlmAccount();
            tempALMAccount.setId(almAccount.getId());
            tempALMAccount.setUrl(almAccount.getUrl());
            tempALMAccount.setUsername(almAccount.getUsername());
            tempALMAccount.setPassword(almAccount.getPassword());
            tempALMAccount.setAzureOAuthToken(almAccount.getAzureOAuthToken());
            tempALMAccount.setIsTaggedUser(Boolean.valueOf(false));
            tempALMAccount.setAdminAlmAcc(almAccount.getAdminAlmAcc());
            ArrayList<String> tfsIds = new ArrayList<String>();
            tempALMAccount.setIsTaggedUser(Boolean.valueOf(true));
            if (PropertyValidator.isValid((Object)tfsFilter.getIsWiql()) && tfsFilter.getIsWiql().booleanValue()) {
                String wiql = tfsFilter.getQueryJSON();
                wiql = wiql.replace("\"", "'");
                String queryStr = "{query:\"" + wiql + "\"}";
                TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(queryStr, tempALMAccount, false);
                tfsItemIdsStr = tfsResponse.getContent();
            } else {
                String filterId = tfsFilter.getTfsId();
                tfsItemIdsStr = this.tfsUtils.getWorkItemsByTFSQueryId(this.tfsUtils.encodeValue(tfsFilter.getTfsProjectId()), filterId, tempALMAccount);
            }
            try {
                JSONObject jsonObject = new JSONObject(tfsItemIdsStr);
                String queryType = jsonObject.getString("queryType");
                ArrayList<String> relations = new ArrayList<String>();
                if (queryType.equals("flat")) {
                    JSONArray workItemsArray = jsonObject.getJSONArray("workItems");
                    for (int i = 0; i < workItemsArray.length(); ++i) {
                        JSONObject wiObject = workItemsArray.getJSONObject(i);
                        String itemId = wiObject.getString("id");
                        tfsIds.add(itemId);
                    }
                } else {
                    JSONArray workItemsArray = new JSONArray();
                    JSONArray workItemsRelationsArray = jsonObject.getJSONArray("workItemRelations");
                    ArrayList<String> subItemIds = new ArrayList<String>();
                    for (int i = 0; i < workItemsRelationsArray.length(); ++i) {
                        JSONObject wirObject = workItemsRelationsArray.getJSONObject(i);
                        Object sourceObject = null;
                        JSONObject targetObject = null;
                        String relation = null;
                        if (wirObject.isNull("source") && !wirObject.isNull("target")) {
                            targetObject = wirObject.getJSONObject("target");
                        }
                        if (!wirObject.isNull("rel")) {
                            relation = wirObject.getString("rel");
                        }
                        if (PropertyValidator.isValid(targetObject)) {
                            JSONObject workItemObject = new JSONObject();
                            String itemId = targetObject.getString("id");
                            String itemURL = targetObject.getString("url");
                            tfsIds.add(itemId);
                            workItemObject.put("id", (Object)itemId);
                            workItemObject.put("url", (Object)itemURL);
                            workItemsArray.put((Object)workItemObject);
                        }
                        if (PropertyValidator.isValid((Object)targetObject)) {
                            String itemId = targetObject.getString("id");
                            subItemIds.add(itemId);
                        }
                        if (!PropertyValidator.isValid((Object)relation)) continue;
                        relations.add(relation);
                    }
                }
                return tfsIds;
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                return null;
            }
        }
        catch (ViztrendJiraException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    private BaseItemLink findBaseItemLink(BacklogItem backlogItem, String releaseTrainId, String linkType, String itemId) {
        List links = null;
        if (linkType.equals(EnumKendis.ART_PARENT_LINK.getCode())) {
            links = (List)backlogItem.getParentRelationMap().get(releaseTrainId);
        } else if (linkType.equals(EnumKendis.ART_CHILD_LINK.getCode())) {
            links = (List)backlogItem.getChildRelationMap().get(releaseTrainId);
        }
        if (PropertyValidator.isValid((Collection)links)) {
            for (BaseItemLink l : links) {
                if (!l.getBacklogItemId().toString().equals(itemId)) continue;
                return l;
            }
        }
        return null;
    }

    public List<HierarchyLevel> getHierarchyLevels(WorkSpace workspace) throws Exception {
        List levels = null;
        BacklogHierarchy hierarchy = (BacklogHierarchy)this.backlogHierarchyRepository.findOne((Serializable)((Object)workspace.getLinkedAlmHierarchy()));
        if (PropertyValidator.isValid((Object)hierarchy)) {
            levels = hierarchy.getHierarchyLevels();
            Collections.sort(levels, new /* Unavailable Anonymous Inner Class!! */);
        }
        return levels;
    }

    private String reverseTFSRelation(String relation) {
        String reverseRelation = null;
        if (relation.contains("Forward")) {
            reverseRelation = relation.replace("Forward", "Reverse");
        } else if (relation.contains("Reverse")) {
            reverseRelation = relation.replace("Reverse", "Forward");
        }
        return reverseRelation;
    }

    public Map<String, String> getTfsUserMap(Object userObject) throws Exception {
        HashMap<String, String> userMap = new HashMap<String, String>();
        if (userObject instanceof JSONObject) {
            JSONObject assignedTo = (JSONObject)userObject;
            String displayName = "unknown";
            String uniqueName = "unknown";
            if (assignedTo.has("displayName")) {
                displayName = (String)assignedTo.get("displayName");
            }
            if (assignedTo.has("uniqueName")) {
                uniqueName = (String)assignedTo.get("uniqueName");
            }
            userMap.put("displayName", displayName);
            userMap.put("uniqueName", uniqueName);
        } else if (userObject instanceof String) {
            String userInfo = (String)userObject;
            String[] userInfoParts = userInfo.split("<");
            if (userInfoParts.length == 2) {
                String displayName = userInfoParts[0];
                displayName = displayName.trim();
                String uniqueName = userInfoParts[1];
                uniqueName = uniqueName.replace(">", "");
                userMap.put("displayName", displayName);
                userMap.put("uniqueName", uniqueName);
            } else {
                userMap.put("displayName", userInfo);
                userMap.put("uniqueName", userInfo);
            }
        }
        return userMap;
    }

    public Map<String, Object> tfsItemFromRawJSON(BacklogItem backlogItem, JSONObject itemObject, JSONObject tfsFields, Map<String, TFSProject> tfsProjectsMapById, Map<String, TFSProject> tfsProjectsMapByName, Map<String, Status> statusMapByKey, AlmHierarchyLevelMapping currentHierarchyLevelMapping) {
        JSONObject links;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String tfsId = itemObject.getString("id");
        String url = itemObject.getString("url");
        String areaPath = (String)tfsFields.get("System.AreaPath");
        String teamProject = (String)tfsFields.get("System.TeamProject");
        String iterationPath = (String)tfsFields.get("System.IterationPath");
        String title = (String)tfsFields.get("System.Title");
        String state = (String)tfsFields.get("System.State");
        String workItemType = (String)tfsFields.get("System.WorkItemType");
        List tfsFieldsSelected = null;
        if (PropertyValidator.isValid((Object)currentHierarchyLevelMapping)) {
            tfsFieldsSelected = currentHierarchyLevelMapping.getTfsFields();
        }
        if (backlogItem.getFields() == null) {
            backlogItem.setFields(new HashMap());
        }
        if (backlogItem.getAlmFields() == null) {
            backlogItem.setAlmFields(new HashMap());
        }
        if (backlogItem != null) {
            if (backlogItem.getBoardRelations() == null) {
                backlogItem.setBoardRelations(new ArrayList());
            }
            if (backlogItem.getTeamContainerRelations() == null) {
                backlogItem.setTeamContainerRelations(new ArrayList());
            }
            if (backlogItem.getBatchRelations() == null) {
                backlogItem.setBatchRelations(new ArrayList());
            }
            if (backlogItem.getSolutionRelations() == null) {
                backlogItem.setSolutionRelations(new ArrayList());
            }
        }
        String[] urlComponents = url.split("/");
        String projectId = null;
        projectId = urlComponents.length >= 9 ? urlComponents[4] : urlComponents[3];
        TFSProject tfsProject = null;
        if (tfsProjectsMapById != null && tfsProjectsMapByName != null) {
            if (tfsProjectsMapById.containsKey(projectId)) {
                tfsProject = tfsProjectsMapById.get(projectId);
            } else {
                tfsProject = tfsProjectsMapByName.get(teamProject);
                if (!PropertyValidator.isValid((Object)tfsProject)) {
                    return result;
                }
                projectId = tfsProject.getTfsId();
            }
        }
        if (PropertyValidator.isValid(tfsProject)) {
            String dateStr;
            if (statusMapByKey != null) {
                String statusKey = tfsProject.getTfsId() + ":" + workItemType + ":" + state;
                Status status = statusMapByKey.get(statusKey);
                backlogItem.setStatus(status);
                if (status == null) {
                    LOGGER.debug("------------------------------------------- RESYNC ITEM TFS STATUS ----------------------");
                    LOGGER.debug("STATUS NOT FOUND : " + statusKey);
                }
            } else {
                LOGGER.debug("------------------------------------------- RESYNC ITEM TFS STATUS ----------------------");
                LOGGER.debug("STATUS MAP NOT FOUND");
            }
            if (PropertyValidator.isValid((Object)tfsProject.getIconByItemType())) {
                String itemTypeIconUrl = (String)tfsProject.getIconByItemType().get(workItemType);
                backlogItem.getFields().put("itemTypeIcon", itemTypeIconUrl);
            }
            if (PropertyValidator.isValid((Object)tfsProject.getItemEstimationField()) && !tfsFields.isNull(tfsProject.getItemEstimationField())) {
                Double storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProject.getItemEstimationField())));
                if (PropertyValidator.isValid((Object)storyPoint)) {
                    storyPoint = StringUtils.round((double)storyPoint, (int)2);
                }
                backlogItem.setStoryPoints(storyPoint);
            }
            if (PropertyValidator.isValid((Object)tfsProject.getItemDueDateField()) && !tfsFields.isNull(tfsProject.getItemDueDateField())) {
                dateStr = (String)tfsFields.get(tfsProject.getItemDueDateField());
                backlogItem.getFields().put("DueDate", PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
            }
            if (PropertyValidator.isValid((Object)tfsProject.getItemStartDateField()) && !tfsFields.isNull(tfsProject.getItemStartDateField())) {
                dateStr = (String)tfsFields.get(tfsProject.getItemStartDateField());
                backlogItem.getFields().put("StartDate", PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
            }
            if (PropertyValidator.isValid((Object)tfsProject.getItemEndDateField()) && !tfsFields.isNull(tfsProject.getItemEndDateField())) {
                dateStr = (String)tfsFields.get(tfsProject.getItemEndDateField());
                backlogItem.getFields().put("EndDate", PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
            }
        }
        try {
            Object userObj;
            if (!tfsFields.isNull("System.AssignedTo")) {
                userObj = tfsFields.get("System.AssignedTo");
                backlogItem.getFields().put("AssignedTo", this.getTfsUserMap(userObj));
            }
            if (!tfsFields.isNull("System.CreatedBy")) {
                userObj = tfsFields.get("System.CreatedBy");
                backlogItem.getFields().put("CreatedBy", this.getTfsUserMap(userObj));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        if (!tfsFields.isNull("System.CreatedDate")) {
            Object createdDate = tfsFields.get("System.CreatedDate");
            backlogItem.getFields().put("CreatedDate", createdDate);
        }
        if (!tfsFields.isNull("System.ChangedDate")) {
            Object changedDate = tfsFields.get("System.ChangedDate");
            backlogItem.getFields().put("ChangedDate", changedDate);
        }
        if (!itemObject.isNull("_links") && !(links = itemObject.getJSONObject("_links")).isNull("html")) {
            JSONObject linkHTML = links.getJSONObject("html");
            backlogItem.setUrl(linkHTML.getString("href"));
        }
        if (PropertyValidator.isValid((Collection)tfsFieldsSelected)) {
            for (HashMap tfsField : tfsFieldsSelected) {
                String referenceName = (String)tfsField.get("referenceName");
                if (tfsFields.isNull(referenceName)) continue;
                Object assignedToObj = tfsFields.get(referenceName);
                String key = referenceName.replace(".", "_");
                if (assignedToObj instanceof JSONObject) {
                    JSONObject assignedTo = (JSONObject)assignedToObj;
                    String displayName = (String)assignedTo.get("displayName");
                    backlogItem.getAlmFields().put(key, displayName);
                    continue;
                }
                if (assignedToObj instanceof String) {
                    String displayName = (String)assignedToObj;
                    backlogItem.getAlmFields().put(key, displayName);
                    continue;
                }
                if (!(assignedToObj instanceof Integer) && !(assignedToObj instanceof Boolean) && !(assignedToObj instanceof Double)) continue;
                backlogItem.getAlmFields().put(key, assignedToObj);
            }
        }
        backlogItem.setTitle(title);
        backlogItem.setAlmItemId(tfsId);
        backlogItem.setAlmKey(tfsId);
        backlogItem.setAlmType(workItemType);
        backlogItem.setAlmItemId(tfsId);
        backlogItem.getFields().put("tfsAreaPath", areaPath);
        backlogItem.getFields().put("tfsIterationPath", iterationPath);
        backlogItem.getFields().put("tfsProjectId", projectId);
        backlogItem.getFields().put("tfsProject", teamProject);
        result.put("backlogItem", backlogItem);
        result.put("tfsProject", tfsProject);
        return result;
    }

    private void addLevelResultInMap(HashMap<String, Object> levelsResultMap, Map<String, Object> currentLevelResult, HierarchyLevel hierarchyLevel) {
        HashMap<String, Object> levelResultMapEntry = (HashMap<String, Object>)levelsResultMap.get("" + hierarchyLevel.getLevel());
        if (levelResultMapEntry == null) {
            levelResultMapEntry = new HashMap<String, Object>();
            levelResultMapEntry.put("itemsAdded", new ArrayList());
            levelResultMapEntry.put("itemsUpdated", new ArrayList());
            levelsResultMap.put("" + hierarchyLevel.getLevel(), levelResultMapEntry);
        }
        ArrayList itemsAdded = (ArrayList)currentLevelResult.get("itemsAdded");
        ArrayList itemsUpdated = (ArrayList)currentLevelResult.get("itemsUpdated");
        if (currentLevelResult.containsKey("error")) {
            levelResultMapEntry.put("error", currentLevelResult.get("error"));
        }
        if (currentLevelResult.containsKey("vzError")) {
            levelResultMapEntry.put("vzError", currentLevelResult.get("vzError"));
        }
        ArrayList _itemsAdded = (ArrayList)levelResultMapEntry.get("itemsAdded");
        ArrayList _itemsUpdated = (ArrayList)levelResultMapEntry.get("itemsUpdated");
        _itemsAdded.addAll(itemsAdded);
        _itemsUpdated.addAll(itemsUpdated);
        levelResultMapEntry.put("itemsAdded", _itemsAdded);
        levelResultMapEntry.put("itemsUpdated", _itemsUpdated);
    }

    private void addBoardsInItems(String artId, List<BacklogItem> items, AlmAccount almAccount, String tenant) {
        try {
            ResyncParamsVO param = new ResyncParamsVO();
            param.releaseTrainId = artId;
            param.almConfigurations = new AlmConfigurations(almAccount);
            param.backlogAlmIds = new HashMap();
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < items.size(); ++i) {
                ids.add(items.get(i).getAlmItemId());
                param.backlogAlmIds.put(items.get(i).getAlmItemId(), items.get(i).getId());
            }
            if (tenant == null) {
                tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            }
            this.releaseTrainServiceImpl.addBoardsInMap(tenant, ids, param);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }
}

