/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ExportUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.JiraIssue2;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraStatus;
import com.viztrend.safe.alm.jira.bo.JiraTransition;
import com.viztrend.safe.api.dto.RTItemsOperationsDTO;
import com.viztrend.safe.enums.EnumBaseItemLinkTypes;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumRTItemsOperations;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.AlmHierarchyLevelMapping;
import com.viztrend.safe.persistence.entity.BacklogHierarchy;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Board;
import com.viztrend.safe.persistence.entity.HierarchyLevel;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.Lane;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.roadmap.RoadmapSection;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmErrorRepository;
import com.viztrend.safe.persistence.repository.AlmHierarchyLevelMappingRepository;
import com.viztrend.safe.persistence.repository.BacklogHierarchyRepository;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.BoardRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.HierarchyLevelRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.LaneRepository;
import com.viztrend.safe.persistence.repository.ObjectiveCustomViewRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.RoadmapSectionRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.PlanServiceImpl;
import com.viztrend.safe.service.RTItemOperationsService;
import com.viztrend.safe.service.RTItemOperationsServiceImpl;
import com.viztrend.safe.service.RTItemTfsSyncService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.ResyncParamsVO;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component(value="RTItemOperationsService")
public class RTItemOperationsServiceImpl
implements RTItemOperationsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTItemOperationsServiceImpl.class);
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private BoardRepository boardRepository;
    @Autowired
    private TFSservice tfsService;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private AlmHierarchyLevelMappingRepository almHierarchyLevelMappingRepository;
    @Autowired
    private ExportUtil exportUtil;
    @Autowired
    private PlanServiceImpl planServiceImpl;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private AlmErrorRepository almErrorRepository;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private ReleaseTrainService releaseTrainService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private CustomRepositoryImpl customRepository;
    @Autowired
    private RoadmapSectionRepository roadmapSectionRepository;
    @Autowired
    private BacklogHierarchyRepository backlogHierarchyRepository;
    @Autowired
    private LaneRepository laneRepository;
    @Autowired
    private RTItemTfsSyncService itemTfsSyncService;
    @Autowired
    private ObjectiveCustomViewRepository objectiveCustomViewRepository;
    @Autowired
    private HierarchyLevelRepository hierarchyLevelRepository;

    private Integer toInteger(Object object) {
        if (object != null) {
            String str;
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof Double) {
                double value = (Double)object;
                int result = (int)value;
                return result;
            }
            if (object instanceof String && !(str = (String)object).isEmpty()) {
                return Integer.parseInt((String)object);
            }
        }
        return null;
    }

    private Double toDouble(Object object) {
        if (object != null) {
            String str;
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof Integer) {
                int value = (Integer)object;
                double result = value;
                return result;
            }
            if (object instanceof String && !(str = (String)object).isEmpty()) {
                return Double.parseDouble((String)object);
            }
        }
        return null;
    }

    public Map<String, Object> archieveMilestone(HashMap<String, Object> params) {
        Boolean removeLinkedBacklogItems;
        Boolean isArchive;
        List itemIds;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String releaseTrainId = (String)params.get("releaseTrainId");
        Map recursiveResult = this.archiveMilestoneRecursively(releaseTrainId, itemIds = (List)params.get("itemIds"), isArchive = params.containsKey("archieve") ? (Boolean)KendisUtils.getValue(params, (String)"archieve", Boolean.class) : Boolean.valueOf(false), removeLinkedBacklogItems = params.containsKey("removeLinkedBacklogItems") ? (Boolean)KendisUtils.getValue(params, (String)"removeLinkedBacklogItems", Boolean.class) : Boolean.valueOf(false));
        if (recursiveResult != null) {
            return recursiveResult;
        }
        result.put("success", true);
        result.put("itemIds", itemIds);
        return result;
    }

    public Map<String, Object> archiveMilestoneRecursively(String releaseTrainId, List<String> itemIds, Boolean isArchive, Boolean removeLinkedBacklogItems) {
        Map recursiveResult;
        List subSetsOfItemIds = Lists.partition(new ArrayList<String>(itemIds), (int)100);
        ArrayList<String> childIds = new ArrayList<String>();
        for (List subSetOfItemIds : subSetsOfItemIds) {
            List items = this.backlogItemRepository.findByIdIn((Collection)subSetOfItemIds);
            for (BacklogItem item : items) {
                if (PropertyValidator.isValid((Object)releaseTrainId)) {
                    if (item.getArtRelationMap().size() == 1) {
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        result.put("success", false);
                        result.put("message", item.getFields().get("itemType") + " must be linked with at least one collection.");
                        return result;
                    }
                    BaseItemLink releaseTrainRelation = (BaseItemLink)item.getArtRelationMap().get(releaseTrainId);
                    if (PropertyValidator.isValid((Object)releaseTrainRelation)) {
                        item.getArtRelationMap().remove(releaseTrainId);
                    }
                    item.getRelations().removeIf(relation -> releaseTrainId.equals(relation.getReleaseTrainId()));
                    if (removeLinkedBacklogItems.booleanValue()) {
                        item = this.removeLinkedBacklogItemsFromMilestone(item, releaseTrainId);
                    }
                    if (!PropertyValidator.isValid((Collection)((Collection)item.getChildRelationMap().get(releaseTrainId)))) continue;
                    for (Object obj : (List)item.getChildRelationMap().get(releaseTrainId)) {
                        Object link;
                        if (obj instanceof BaseItemLink) {
                            link = (BaseItemLink)obj;
                            childIds.add(link.getBacklogItemId().toString());
                            continue;
                        }
                        link = (Map)obj;
                        ObjectId _id = (ObjectId)link.get("backlogItemId");
                        childIds.add(_id.toString());
                    }
                    continue;
                }
                for (Map.Entry entry : item.getArtRelationMap().entrySet()) {
                    BaseItemLink releaseTrainRelation = (BaseItemLink)entry.getValue();
                    if (!PropertyValidator.isValid((Object)releaseTrainRelation)) continue;
                    releaseTrainRelation.setRowStatus(isArchive != false ? 1 : 0);
                    item.getArtRelationMap().put(entry.getKey(), releaseTrainRelation);
                }
                for (Map.Entry entry : item.getChildRelationMap().entrySet()) {
                    for (Object obj : (List)entry.getValue()) {
                        Object link;
                        if (obj instanceof BaseItemLink) {
                            link = (BaseItemLink)obj;
                            childIds.add(link.getBacklogItemId().toString());
                            continue;
                        }
                        link = (Map)obj;
                        ObjectId _id = (ObjectId)link.get("backlogItemId");
                        childIds.add(_id.toString());
                    }
                }
                if (!PropertyValidator.isValid((Collection)item.getBoardRelations())) continue;
                for (BaseItemLink boardRelation : item.getBoardRelations()) {
                    boardRelation.setRowStatus(isArchive != false ? 1 : 0);
                }
            }
            this.backlogItemRepository.save((Iterable)items);
        }
        if (PropertyValidator.isValid(childIds) && (recursiveResult = this.archiveMilestoneRecursively(releaseTrainId, childIds, isArchive, removeLinkedBacklogItems)) != null) {
            return recursiveResult;
        }
        return null;
    }

    public Map<String, Object> archieveBacklogItems(HashMap<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String releaseTrainId = (String)params.get("releaseTrainId");
        List itemIds = (List)params.get("itemIds");
        Boolean archieve = (Boolean)params.get("archieve");
        Boolean unlink = (Boolean)params.get("unlink");
        Map metaMap = null;
        if (params.containsKey("metaMap")) {
            metaMap = (Map)params.get("metaMap");
        }
        this.archieveItemsReursively(releaseTrainId, itemIds, archieve, unlink);
        if (unlink != null && Boolean.TRUE.equals(unlink) && PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(releaseTrainId);
            this.releaseTrainService.unlinkBacklogItemFromPi(UserContextUtil.getUserContext().getCurrentCompany().getTenant(), false, itemIds, ids, null);
        }
        result.put("success", true);
        result.put("itemIds", itemIds);
        return result;
    }

    public void archieveItemsReursively(String releaseTrainId, List<String> itemIds, Boolean archieve, Boolean unlink) {
        List subSetsOfItemIds = Lists.partition(new ArrayList<String>(itemIds), (int)100);
        ArrayList childIds = new ArrayList();
        for (List subSetOfItemIds : subSetsOfItemIds) {
            List items = this.backlogItemRepository.findByIdIn((Collection)subSetOfItemIds);
            for (BacklogItem item : items) {
                BaseItemLink releaseTrainRelation = (BaseItemLink)item.getArtRelationMap().get(releaseTrainId);
                if (archieve != null && PropertyValidator.isValid((Object)releaseTrainRelation)) {
                    releaseTrainRelation.setRowStatus(archieve != false ? 1 : 0);
                    item.getArtRelationMap().put(releaseTrainId, releaseTrainRelation);
                }
                if (unlink != null && Boolean.TRUE.equals(unlink)) {
                    item.getArtRelationMap().remove(releaseTrainId);
                }
                if (!PropertyValidator.isValid((Collection)((Collection)item.getChildRelationMap().get(releaseTrainId)))) continue;
                item.fillChildrenIds(childIds, (List)item.getChildRelationMap().get(releaseTrainId));
            }
            this.backlogItemRepository.save((Iterable)items);
        }
        if (PropertyValidator.isValid(childIds)) {
            this.archieveItemsReursively(releaseTrainId, childIds, archieve, unlink);
        }
    }

    private HierarchyLevel getNextLevel(List<HierarchyLevel> hierarchyLevels, HierarchyLevel currentLevel, int step) throws Exception {
        int newIndex;
        int index = IntStream.range(0, hierarchyLevels.size()).filter(ind -> ((HierarchyLevel)hierarchyLevels.get(ind)).getLevel() == currentLevel.getLevel()).findAny().orElse(-1);
        if (index > -1 && (newIndex = index + step) > -1 && newIndex < hierarchyLevels.size()) {
            return hierarchyLevels.get(newIndex);
        }
        return null;
    }

    public void removeItemReferenceFromOtherItems(List<String> itemsIds, String releaseTrainId) throws Exception {
        List milestones;
        HashMap existingItemsIdMap = new HashMap();
        itemsIds.forEach(itid -> existingItemsIdMap.put(itid, itid));
        List baseItemLinks = null;
        baseItemLinks = releaseTrainId == null ? this.baseItemLinkRepository.findByBaseItemIdIn(itemsIds) : this.baseItemLinkRepository.findByBaseItemIdInAndReleaseTrainId(itemsIds, releaseTrainId);
        if (PropertyValidator.isValid((Collection)baseItemLinks)) {
            ArrayList<BaseItem> baseItemsToSave = new ArrayList<BaseItem>();
            List baseItems = this.baseItemRepository.findByBaseItemLinksIn(baseItemLinks);
            if (PropertyValidator.isValid((Collection)baseItems)) {
                for (BaseItem baseItem : baseItems) {
                    boolean anyRemoved = false;
                    int arraySize = baseItem.getBaseItemLinks().size();
                    for (int i = 0; i < arraySize; ++i) {
                        BaseItemLink link = (BaseItemLink)baseItem.getBaseItemLinks().get(i);
                        if (existingItemsIdMap.get(link.getBaseItemId()) == null) continue;
                        if (releaseTrainId != null) {
                            if (link.getReleaseTrainId() == null || !link.getReleaseTrainId().equals(releaseTrainId)) continue;
                            baseItem.getBaseItemLinks().remove(i);
                            --i;
                            anyRemoved = true;
                            --arraySize;
                            continue;
                        }
                        baseItem.getBaseItemLinks().remove(i);
                        --i;
                        anyRemoved = true;
                        --arraySize;
                    }
                    if (!anyRemoved) continue;
                    baseItemsToSave.add(baseItem);
                }
            }
            if (PropertyValidator.isValid(baseItemsToSave)) {
                this.baseItemRepository.save(baseItemsToSave);
            }
        }
        Query query = new Query();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"itemRelations.baseItemId").in(itemsIds));
        if (releaseTrainId != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"itemRelations.releaseTrainId").is((Object)releaseTrainId));
        }
        if (PropertyValidator.isValid((Collection)(milestones = this.mongoTemplate.find(query, BacklogItem.class)))) {
            ArrayList<BacklogItem> milestonesToUpdate = new ArrayList<BacklogItem>();
            for (BacklogItem milestone : milestones) {
                boolean anyRemoved = false;
                int arraySize = milestone.getItemRelations().size();
                for (int i = 0; i < arraySize; ++i) {
                    BaseItemLink link = (BaseItemLink)milestone.getItemRelations().get(i);
                    if (existingItemsIdMap.get(link.getBaseItemId()) == null) continue;
                    if (releaseTrainId != null) {
                        if (link.getReleaseTrainId() == null || !link.getReleaseTrainId().equals(releaseTrainId)) continue;
                        milestone.getItemRelations().remove(i);
                        --i;
                        --arraySize;
                        anyRemoved = true;
                        continue;
                    }
                    milestone.getItemRelations().remove(i);
                    --i;
                    --arraySize;
                    anyRemoved = true;
                }
                if (!anyRemoved) continue;
                milestonesToUpdate.add(milestone);
            }
            if (PropertyValidator.isValid(milestonesToUpdate)) {
                this.backlogItemRepository.save(milestonesToUpdate);
            }
        }
    }

    public Map<String, Object> deleteItem(HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String releaseTrainId = (String)params.get("releaseTrainId");
        String almAccountId = (String)params.get("almAccountId");
        List itemIds = (List)params.get("itemIds");
        Boolean removeFromCollection = Boolean.FALSE;
        Boolean deleteChildren = Boolean.FALSE;
        if (params.containsKey("removeFromCollection")) {
            removeFromCollection = (Boolean)params.get("removeFromCollection");
        }
        if (params.containsKey("deleteChildren")) {
            deleteChildren = (Boolean)params.get("deleteChildren");
        }
        List backlogItems = this.backlogItemRepository.findByIdIn((Collection)itemIds);
        if (removeFromCollection.booleanValue()) {
            ArrayList<BacklogItem> allItemsToSave = new ArrayList<BacklogItem>();
            ArrayList<String> allItemIds = new ArrayList<String>();
            for (BacklogItem item : backlogItems) {
                Object link2;
                item.getArtRelationMap().remove(releaseTrainId);
                allItemsToSave.add(item);
                allItemIds.add(item.getId());
                ArrayList allChildren = new ArrayList();
                HashMap duplicationCheckMap = new HashMap();
                if (PropertyValidator.isValid((Object)item.getChildRelationMap()) && PropertyValidator.isValid((Collection)((Collection)item.getChildRelationMap().get(releaseTrainId)))) {
                    List childrenLinks = (List)item.getChildRelationMap().get(releaseTrainId);
                    ArrayList<String> childIds = new ArrayList<String>();
                    Iterator iterator = childrenLinks.iterator();
                    while (iterator.hasNext()) {
                        link2 = (BaseItemLink)iterator.next();
                        if (!(link2 instanceof BaseItemLink)) continue;
                        childIds.add(link2.getBacklogItemId().toString());
                    }
                    if (PropertyValidator.isValid(childIds)) {
                        this.getRecursiveChildren(childIds, allChildren, releaseTrainId, duplicationCheckMap);
                    }
                }
                if (PropertyValidator.isValid(allChildren)) {
                    for (BacklogItem child : allChildren) {
                        child.getArtRelationMap().remove(releaseTrainId);
                        allItemsToSave.add(child);
                        child.getChildRelationMap().remove(releaseTrainId);
                        child.getParentRelationMap().remove(releaseTrainId);
                        allItemIds.add(child.getId());
                    }
                }
                item.getChildRelationMap().remove(releaseTrainId);
                if (PropertyValidator.isValid((Collection)((Collection)item.getParentRelationMap().get(releaseTrainId)))) {
                    List parentLinks = (List)item.getParentRelationMap().get(releaseTrainId);
                    ArrayList<String> parentIDs = new ArrayList<String>();
                    for (Object link2 : parentLinks) {
                        if (!(link2 instanceof BaseItemLink)) continue;
                        parentIDs.add(link2.getBacklogItemId().toString());
                    }
                    if (PropertyValidator.isValid(parentIDs)) {
                        List parentItems = this.backlogItemRepository.findByIdIn(parentIDs);
                        link2 = parentItems.iterator();
                        while (link2.hasNext()) {
                            BacklogItem parent = (BacklogItem)link2.next();
                            parent.removeChildLink(releaseTrainId, item.getId());
                            allItemsToSave.add(parent);
                        }
                    }
                }
                item.getParentRelationMap().remove(releaseTrainId);
            }
            try {
                this.removeItemReferenceFromOtherItems(allItemIds, releaseTrainId);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            if (PropertyValidator.isValid(allItemsToSave)) {
                this.backlogItemRepository.save(allItemsToSave);
            }
        } else if (deleteChildren.booleanValue()) {
            ArrayList<BacklogItem> allItemsDelete = new ArrayList<BacklogItem>();
            ArrayList<String> allItemIds = new ArrayList<String>();
            for (BacklogItem item : backlogItems) {
                BacklogItem child2;
                allItemsDelete.add(item);
                allItemIds.add(item.getId());
                ArrayList allChildren = new ArrayList();
                HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
                if (PropertyValidator.isValid((Object)item.getChildRelationMap())) {
                    ArrayList<String> _childIds = new ArrayList<String>();
                    Set releaseTrains = item.getChildRelationMap().keySet();
                    for (String _releaseTrainId : releaseTrains) {
                        List childrenLinks = (List)item.getChildRelationMap().get(_releaseTrainId);
                        if (!PropertyValidator.isValid((Collection)childrenLinks)) continue;
                        for (Object link : childrenLinks) {
                            if (!(link instanceof BaseItemLink) || duplicationCheckMap.containsKey(link.getBacklogItemId().toString())) continue;
                            duplicationCheckMap.put(link.getBacklogItemId().toString(), link.getBacklogItemId().toString());
                            _childIds.add(link.getBacklogItemId().toString());
                        }
                    }
                    if (PropertyValidator.isValid(_childIds)) {
                        this.getRecursiveChildrenAllReleaseTrains(_childIds, allChildren, duplicationCheckMap);
                    }
                    if (PropertyValidator.isValid(allChildren)) {
                        for (BacklogItem child2 : allChildren) {
                            allItemsDelete.add(child2);
                            allItemIds.add(child2.getId());
                        }
                    }
                }
                if (!PropertyValidator.isValid((Object)item.getParentRelationMap())) continue;
                ArrayList<BacklogItem> parentsToUpdate = new ArrayList<BacklogItem>();
                ArrayList<String> parentIDs = new ArrayList<String>();
                Set releaseTrains = item.getParentRelationMap().keySet();
                child2 = releaseTrains.iterator();
                while (child2.hasNext()) {
                    Object link;
                    String _releaseTrainId = (String)child2.next();
                    List parentLinks = (List)item.getParentRelationMap().get(_releaseTrainId);
                    if (!PropertyValidator.isValid((Collection)parentLinks)) continue;
                    link = parentLinks.iterator();
                    while (link.hasNext()) {
                        BaseItemLink link3 = (BaseItemLink)link.next();
                        if (!(link3 instanceof BaseItemLink) || duplicationCheckMap.containsKey(link3.getBacklogItemId().toString())) continue;
                        duplicationCheckMap.put(link3.getBacklogItemId().toString(), link3.getBacklogItemId().toString());
                        parentIDs.add(link3.getBacklogItemId().toString());
                    }
                }
                if (PropertyValidator.isValid(parentIDs)) {
                    List parentItems = this.backlogItemRepository.findByIdIn(parentIDs);
                    for (BacklogItem parent : parentItems) {
                        Set _releaseTrains = parent.getChildRelationMap().keySet();
                        for (String _releaseTrainId : _releaseTrains) {
                            parent.removeChildLink(_releaseTrainId, item.getId());
                        }
                        parentsToUpdate.add(parent);
                    }
                }
                if (!PropertyValidator.isValid(parentsToUpdate)) continue;
                this.backlogItemRepository.save(parentsToUpdate);
            }
            try {
                this.removeItemReferenceFromOtherItems(allItemIds, null);
                this.itemTfsSyncService.handleDependenciesOnDeleteItems(allItemsDelete);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            this.backlogItemRepository.delete(allItemsDelete);
        } else {
            ArrayList<BacklogItem> allItemsDelete = new ArrayList<BacklogItem>();
            ArrayList<String> allItemIds = new ArrayList<String>();
            for (BacklogItem item : backlogItems) {
                Set _releaseTrains;
                Set releaseTrains;
                allItemsDelete.add(item);
                allItemIds.add(item.getId());
                HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
                if (PropertyValidator.isValid((Object)item.getChildRelationMap())) {
                    ArrayList<BacklogItem> childrenToUpdate = new ArrayList<BacklogItem>();
                    ArrayList<String> childIDs = new ArrayList<String>();
                    releaseTrains = item.getChildRelationMap().keySet();
                    for (Object _releaseTrainId : releaseTrains) {
                        List childLinks = (List)item.getChildRelationMap().get(_releaseTrainId);
                        if (!PropertyValidator.isValid((Collection)childLinks)) continue;
                        for (Object link : childLinks) {
                            if (!(link instanceof BaseItemLink) || duplicationCheckMap.containsKey(link.getBacklogItemId().toString())) continue;
                            duplicationCheckMap.put(link.getBacklogItemId().toString(), link.getBacklogItemId().toString());
                            childIDs.add(link.getBacklogItemId().toString());
                        }
                    }
                    if (PropertyValidator.isValid(childIDs)) {
                        Object _releaseTrainId;
                        List childItems = this.backlogItemRepository.findByIdIn(childIDs);
                        _releaseTrainId = childItems.iterator();
                        while (_releaseTrainId.hasNext()) {
                            Object link;
                            BacklogItem child = (BacklogItem)_releaseTrainId.next();
                            _releaseTrains = child.getParentRelationMap().keySet();
                            link = _releaseTrains.iterator();
                            while (link.hasNext()) {
                                String _releaseTrainId2 = (String)link.next();
                                child.removeParentLink(_releaseTrainId2, item.getId());
                            }
                            childrenToUpdate.add(child);
                        }
                    }
                    if (PropertyValidator.isValid(childrenToUpdate)) {
                        this.backlogItemRepository.save(childrenToUpdate);
                    }
                }
                if (!PropertyValidator.isValid((Object)item.getParentRelationMap())) continue;
                ArrayList<BacklogItem> parentsToUpdate = new ArrayList<BacklogItem>();
                ArrayList<String> parentIDs = new ArrayList<String>();
                releaseTrains = item.getParentRelationMap().keySet();
                for (Object _releaseTrainId : releaseTrains) {
                    List parentLinks = (List)item.getParentRelationMap().get(_releaseTrainId);
                    if (!PropertyValidator.isValid((Collection)parentLinks)) continue;
                    for (Object link : parentLinks) {
                        if (!(link instanceof BaseItemLink) || duplicationCheckMap.containsKey(link.getBacklogItemId().toString())) continue;
                        duplicationCheckMap.put(link.getBacklogItemId().toString(), link.getBacklogItemId().toString());
                        parentIDs.add(link.getBacklogItemId().toString());
                    }
                }
                if (PropertyValidator.isValid(parentIDs)) {
                    List parentItems = this.backlogItemRepository.findByIdIn(parentIDs);
                    for (BacklogItem parent : parentItems) {
                        _releaseTrains = parent.getChildRelationMap().keySet();
                        for (String _releaseTrainId2 : _releaseTrains) {
                            parent.removeChildLink(_releaseTrainId2, item.getId());
                        }
                        parentsToUpdate.add(parent);
                    }
                }
                if (!PropertyValidator.isValid(parentsToUpdate)) continue;
                this.backlogItemRepository.save(parentsToUpdate);
            }
            try {
                this.removeItemReferenceFromOtherItems(allItemIds, null);
                this.itemTfsSyncService.handleDependenciesOnDeleteItems(allItemsDelete);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            this.backlogItemRepository.delete(allItemsDelete);
        }
        result.put("success", true);
        return result;
    }

    private void getRecursiveChildrenAllReleaseTrains(ArrayList<String> childIds, ArrayList<BacklogItem> allChildren, HashMap<String, String> duplicationCheckMap) {
        List backlogItems = this.backlogItemRepository.findByIdIn(childIds);
        for (BacklogItem item : backlogItems) {
            allChildren.add(item);
            if (!PropertyValidator.isValid((Object)item.getChildRelationMap())) continue;
            ArrayList<String> _childIds = new ArrayList<String>();
            Set releaseTrains = item.getChildRelationMap().keySet();
            for (String releaseTrainId : releaseTrains) {
                List childrenLinks = (List)item.getChildRelationMap().get(releaseTrainId);
                if (!PropertyValidator.isValid((Collection)childrenLinks)) continue;
                for (BaseItemLink link : childrenLinks) {
                    if (!(link instanceof BaseItemLink) || duplicationCheckMap.containsKey(link.getBacklogItemId().toString())) continue;
                    duplicationCheckMap.put(link.getBacklogItemId().toString(), link.getBacklogItemId().toString());
                    _childIds.add(link.getBacklogItemId().toString());
                }
            }
            if (!PropertyValidator.isValid(_childIds)) continue;
            this.getRecursiveChildrenAllReleaseTrains(_childIds, allChildren, duplicationCheckMap);
        }
    }

    private void getRecursiveChildren(ArrayList<String> childIds, ArrayList<BacklogItem> allChildren, String releaseTrainId, HashMap<String, String> duplicationCheckMap) {
        List backlogItems = this.backlogItemRepository.findByIdIn(childIds);
        for (BacklogItem item : backlogItems) {
            allChildren.add(item);
            if (!PropertyValidator.isValid((Object)item.getChildRelationMap()) || !PropertyValidator.isValid((Collection)((Collection)item.getChildRelationMap().get(releaseTrainId)))) continue;
            List childrenLinks = (List)item.getChildRelationMap().get(releaseTrainId);
            ArrayList<String> _childIds = new ArrayList<String>();
            for (BaseItemLink link : childrenLinks) {
                if (!(link instanceof BaseItemLink) || duplicationCheckMap.containsKey(link.getBacklogItemId().toString())) continue;
                duplicationCheckMap.put(link.getBacklogItemId().toString(), link.getBacklogItemId().toString());
                _childIds.add(link.getBacklogItemId().toString());
            }
            if (!PropertyValidator.isValid(_childIds)) continue;
            this.getRecursiveChildren(_childIds, allChildren, releaseTrainId, duplicationCheckMap);
        }
    }

    public Map<String, Object> saveItem(HashMap<String, Object> params) {
        Double sequence;
        Iterator almTypeStr;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map releaseTrain = (Map)params.get("releaseTrain");
        if (releaseTrain == null) {
            result.put("success", false);
            return result;
        }
        String backlogLevelStr = (String)params.get("backlogLevel");
        String releaseTrainId = (String)releaseTrain.get("id");
        String releaseTrainTitle = (String)releaseTrain.get("title");
        Map itemMap = (Map)params.get("item");
        Map metaMap = null;
        if (params.containsKey("metaMap")) {
            metaMap = (Map)params.get("metaMap");
        }
        Map parentMap = null;
        if (params.containsKey("parent")) {
            parentMap = (Map)params.get("parent");
        }
        String boardId = null;
        if (params.containsKey("boardId")) {
            boardId = (String)params.get("boardId");
            metaMap.put("boardId", boardId);
        }
        String syncId = null;
        if (params.containsKey("syncId")) {
            syncId = (String)params.get("syncId");
        }
        String requestId = null;
        if (params.containsKey("requestId")) {
            requestId = (String)params.get("requestId");
        }
        String almAccountId = null;
        AlmAccount almAccount = null;
        if (params.containsKey("almAccountId")) {
            almAccountId = (String)params.get("almAccountId");
            almAccount = this.almAccountRepository.findById(almAccountId);
        }
        User user = null;
        boolean noContext = true;
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            user = UserContextUtil.getUserContext().getLoggedInUser();
        }
        boolean convertingKendisToAlm = false;
        String itemId = (String)itemMap.get("id");
        BacklogItem item = null;
        BacklogItem newParentItem = null;
        BacklogItem oldParentItem = null;
        if (PropertyValidator.isValid((Object)itemId)) {
            item = this.backlogItemRepository.findById(itemId);
            if (!PropertyValidator.isValid((Object)item)) {
                result.put("success", false);
                return result;
            }
            if (item.getFields() == null) {
                item.setFields(new HashMap());
            }
            if (almAccount != null) {
                convertingKendisToAlm = true;
            }
        } else {
            item = new BacklogItem(ObjectId.get().toString(), user);
            item.setFields(new HashMap());
            item.setAlmFields(new HashMap());
            item.linkToRTE(releaseTrainId, Integer.valueOf(Integer.parseInt(backlogLevelStr)));
            item.setKendisKey(this.customRepositoryImpl.generateKey("K"));
        }
        if (almAccount != null) {
            item.setAlmAccountId(almAccountId);
            Object almTypeObj = itemMap.get("almType");
            if (null != almTypeObj && almTypeObj instanceof String && !((String)((Object)(almTypeStr = (String)almTypeObj))).isEmpty()) {
                item.setAlmType((String)((Object)almTypeStr));
            }
        }
        if (PropertyValidator.isValid((Object)parentMap)) {
            if (PropertyValidator.isValid((Collection)((Collection)item.getParentRelationMap().get(releaseTrainId)))) {
                BaseItemLink relation = null;
                almTypeStr = ((List)item.getParentRelationMap().get(releaseTrainId)).iterator();
                if (almTypeStr.hasNext()) {
                    BaseItemLink rel;
                    relation = rel = (BaseItemLink)almTypeStr.next();
                }
                if (PropertyValidator.isValid((Object)(oldParentItem = this.backlogItemRepository.findById(relation.getBacklogItemId().toString())))) {
                    item.removeParentLink(releaseTrainId, oldParentItem.getId());
                    oldParentItem.removeChildLink(releaseTrainId, item.getId());
                }
            }
            String parentId = (String)parentMap.get("id");
            WorkSpace ws = this.workSpaceRepository.findById(releaseTrainId);
            BacklogHierarchy backlogHierarchy = (BacklogHierarchy)this.backlogHierarchyRepository.findOne((Serializable)((Object)ws.getLinkedAlmHierarchy()));
            int currentLevel = ((BaseItemLink)item.getArtRelationMap().get(releaseTrainId)).getBacklogLevel();
            HierarchyLevel currentHierarchyLevel = backlogHierarchy.getHierarchyLevels().stream().filter(h -> h.getLevel() == currentLevel).findAny().orElse(null);
            HierarchyLevel parentHierarchyLevel = null;
            try {
                parentHierarchyLevel = this.getNextLevel(backlogHierarchy.getHierarchyLevels(), currentHierarchyLevel, -1);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            if (PropertyValidator.isValid((Object)parentHierarchyLevel)) {
                parentMap.put("backlogLevel", parentHierarchyLevel.getLevel());
                newParentItem = this.backlogItemRepository.findById(parentId);
                if (PropertyValidator.isValid((Object)newParentItem)) {
                    item.linkToParent(releaseTrainId, newParentItem.getId());
                    newParentItem.linkToChild(releaseTrainId, item.getId());
                }
            }
        }
        if (itemMap.containsKey("title")) {
            String title = (String)itemMap.get("title");
            if ((title = title.trim()).length() > 0) {
                item.setTitle(title);
            }
        }
        if (itemMap.containsKey("description")) {
            String description = (String)itemMap.get("description");
            item.setDescription(description);
        }
        if (itemMap.containsKey("otherRequirements")) {
            String otherRequirements = (String)itemMap.get("otherRequirements");
            item.setOtherRequirements(otherRequirements);
        }
        if (itemMap.containsKey("artSequence")) {
            sequence = this.toDouble(itemMap.get("artSequence"));
            BaseItemLink artRelation = (BaseItemLink)item.getArtRelationMap().get(releaseTrainId);
            if (artRelation != null) {
                artRelation.setSequence(sequence);
            }
        }
        if (itemMap.containsKey("sequence")) {
            sequence = this.toDouble(itemMap.get("sequence"));
            item.setSequence(sequence);
        }
        if (itemMap.containsKey("status")) {
            Map statusMap = (Map)itemMap.get("status");
            item.setStatus(new Status((String)statusMap.get("id")));
        }
        if (itemMap.containsKey("storyPoints")) {
            Double storyPoints = this.toDouble(itemMap.get("storyPoints"));
            item.setStoryPoints(storyPoints);
        }
        if (itemMap.containsKey("fields")) {
            Map feildsMap = (Map)itemMap.get("fields");
            for (String key : feildsMap.keySet()) {
                Object value = feildsMap.get(key);
                if (value instanceof String) {
                    String strValue = (String)value;
                    if (!strValue.isEmpty()) {
                        Date date = PropertyValidator.parseDate((String)strValue, (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
                        if (date == null) {
                            item.getFields().put(key, value);
                            continue;
                        }
                        item.getFields().put(key, date);
                        continue;
                    }
                    if (!item.getFields().containsKey(key)) continue;
                    item.getFields().remove(key);
                    continue;
                }
                item.getFields().put(key, value);
            }
        }
        if (almAccount != null && almAccount.getType().equals("tfs") && itemMap.containsKey("tfsFields")) {
            List tfsFields;
            if (item.getAlmFields() == null) {
                item.setAlmFields(new HashMap());
            }
            if (PropertyValidator.isValid((Collection)(tfsFields = (List)itemMap.get("tfsFields")))) {
                for (Map field : tfsFields) {
                    String key = (String)field.get("key");
                    String type = (String)field.get("type");
                    Object value = field.get("value");
                    key = key.replace(".", "_");
                    if (type.equals("dateTime")) {
                        Date date = PropertyValidator.parseDate((String)((String)value), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
                        if (date == null) {
                            item.getAlmFields().put(key, value);
                            continue;
                        }
                        item.getAlmFields().put(key, date);
                        continue;
                    }
                    item.getAlmFields().put(key, value);
                }
            }
        }
        if (itemMap.containsKey("batchId") && itemId == null) {
            String batchId = (String)itemMap.get("batchId");
            if (item.getBatchRelations() == null) {
                item.setBatchRelations(new ArrayList());
            }
            BaseItemLink link = new BaseItemLink("Batch_" + ObjectId.get().toString());
            link.setBaseItemId(batchId);
            link.setLinkType("Batch");
            item.getBatchRelations().add(link);
        }
        ArrayList removedBoardIds = new ArrayList();
        ArrayList removedArtIds = new ArrayList();
        if (itemMap.containsKey("piBoards")) {
            HashMap<String, BaseItemLink> existingTagsMap = new HashMap<String, BaseItemLink>();
            if (item.getBoardRelations() != null) {
                for (BaseItemLink link : item.getBoardRelations()) {
                    existingTagsMap.put(link.getSessionId(), link);
                }
            }
            ArrayList piBoards = (ArrayList)itemMap.get("piBoards");
            for (Object piBoard : piBoards) {
                String sessionId = (String)piBoard.get("id");
                String sessionBoardId = (String)piBoard.get("activeSessionBoard");
                BaseItemLink link = (BaseItemLink)existingTagsMap.remove(sessionId);
                if (PropertyValidator.isValid((Object)link)) continue;
                item.linkToBoard(releaseTrainId, sessionBoardId, sessionId);
                Session session = this.sessionRepository.findById(sessionId);
                if (!PropertyValidator.isValid((Object)session)) continue;
                WorkSpace rt = new WorkSpace();
                rt.setId(releaseTrainId);
                rt.setTitle(releaseTrainTitle);
                this.addBacklogItemOnPiBoard(item, session, rt, null, almAccount);
            }
            if (PropertyValidator.isValid(existingTagsMap) && !existingTagsMap.isEmpty()) {
                Set ids = existingTagsMap.keySet();
                for (String id : ids) {
                    item.removeBoardLink(((BaseItemLink)existingTagsMap.get(id)).getSessionBoardId(), id, removedArtIds, removedBoardIds);
                }
            }
        }
        ArrayList<BacklogItem> itemsToSave = new ArrayList<BacklogItem>();
        itemsToSave.add(item);
        if (newParentItem != null) {
            itemsToSave.add(newParentItem);
        }
        if (oldParentItem != null) {
            itemsToSave.add(oldParentItem);
        }
        this.backlogItemRepository.save(itemsToSave);
        result.put("success", true);
        item = this.backlogItemRepository.findById(item.getId());
        this.saveKendisOnlyToPIboards(item, releaseTrainId, removedArtIds, removedBoardIds);
        result.put("item", item);
        if (PropertyValidator.isValid((Object)newParentItem)) {
            result.put("parent", newParentItem);
            parentMap.put("url", newParentItem.getUrl());
        }
        if (PropertyValidator.isValid((Object)oldParentItem)) {
            result.put("oldParent", oldParentItem);
        }
        if (itemMap.containsKey("batchId") && itemId == null) {
            String batchId = (String)itemMap.get("batchId");
            BaseItem batch = this.baseItemRepository.findById(batchId);
            if (batch.getBaseItemLinks() == null) {
                batch.setBaseItemLinks(new ArrayList());
            }
            BaseItemLink link = new BaseItemLink(ObjectId.get().toString());
            link.setLinkType("backLogItem");
            link.setReleaseTrainId(releaseTrainId);
            link.setBaseItemId(item.getId());
            this.baseItemLinkRepository.save((Object)link);
            batch.getBaseItemLinks().add(link);
            this.baseItemRepository.save((Object)batch);
            result.put("batch", batch);
        }
        if (PropertyValidator.isValid((Object)boardId)) {
            Board board = (Board)this.boardRepository.findOne((Serializable)((Object)boardId));
            if (PropertyValidator.isValid((Object)board)) {
                int index;
                if (board.getLinkedBacklogItems() == null) {
                    board.setLinkedBacklogItems(new ArrayList());
                }
                if ((index = board.getLinkedBacklogItems().indexOf(item.getId())) == -1) {
                    board.getLinkedBacklogItems().add(item.getId());
                }
            }
            this.boardRepository.save((Object)board);
        }
        if (PropertyValidator.isValid((Object)metaMap)) {
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            JSONObject pushJson = new JSONObject();
            HashMap<String, BacklogItem> pushData = new HashMap<String, BacklogItem>();
            pushData.put("item", item);
            if (PropertyValidator.isValid((Object)newParentItem)) {
                pushData.put("parent", newParentItem);
            }
            if (PropertyValidator.isValid((Object)oldParentItem)) {
                pushData.put("oldParent", oldParentItem);
            }
            String itemStr = gsonExclusive.toJson(pushData);
            pushJson.put("data", (Object)itemStr);
            String metaMapStr = gsonExclusive.toJson((Object)metaMap);
            pushJson.put("metaMap", (Object)metaMapStr);
            PushSender.sendMsg((String)pushJson.toString());
        }
        if (almAccount != null) {
            AlmAccount finalAlmAccount = almAccount;
            BacklogItem finalItem = item;
            HashMap<String, Object> _params = new HashMap<String, Object>();
            _params.put("almAccount", finalAlmAccount);
            _params.put("syncId", syncId);
            _params.put("releaseTrainId", releaseTrainId);
            if (requestId != null) {
                _params.put("requestId", requestId);
            }
            if (convertingKendisToAlm) {
                _params.put("addParentRelation", true);
                if (item.getAlmItemId() == null) {
                    _params.put("sendToAlm", true);
                }
            }
            if (!PropertyValidator.isValid((Object)newParentItem) || !PropertyValidator.isValid((Object)newParentItem.getAlmItemId())) {
                parentMap = null;
            }
            Map finalParentMap = parentMap;
            if (almAccount.getType().equals("tfs")) {
                itemMap.put("metaMap", metaMap);
                if (PropertyValidator.isValid((Object)itemId) && PropertyValidator.isValid((Object)finalItem.getAlmItemId())) {
                    _params.put("update", Boolean.TRUE);
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                } else {
                    _params.put("update", Boolean.FALSE);
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                }
            } else {
                metaMap.put("convertingKendisToAlm", convertingKendisToAlm);
                this.saveInJira(releaseTrainId, finalItem, metaMap, almAccount, UserContextUtil.getUserContext().getLoggedInUser());
            }
        }
        return result;
    }

    private void saveKendisOnlyToPIboards(BacklogItem item, String releaseTrainId, List<String> removedArtIds, List<String> removedBoardIds) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public Map<String, Object> saveMilestone(HashMap<String, Object> params) {
        List sectionRelations;
        String field;
        BacklogItem item;
        Map itemMap;
        String itemId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map releaseTrain = (Map)params.get("releaseTrain");
        if (releaseTrain == null) {
            result.put("success", false);
            return result;
        }
        String backlogLevelStr = (String)params.get("backlogLevel");
        String releaseTrainId = (String)releaseTrain.get("id");
        User user = null;
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            user = UserContextUtil.getUserContext().getLoggedInUser();
        }
        String boardId = null;
        if (params.containsKey("boardId")) {
            boardId = (String)params.get("boardId");
        }
        Boolean isProgramBoardMilestone = false;
        if (params.get("isProgramBoardMilestone") instanceof Boolean) {
            isProgramBoardMilestone = (Boolean)params.get("isProgramBoardMilestone");
        }
        Boolean isRoadmapMilestone = false;
        if (params.get("isRoadmapMilestone") instanceof Boolean) {
            isRoadmapMilestone = (Boolean)params.get("isRoadmapMilestone");
        }
        Boolean isObjCustomViewMilestone = false;
        if (params.get("isObjCustomViewMilestone") instanceof Boolean) {
            isObjCustomViewMilestone = (Boolean)params.get("isObjCustomViewMilestone");
        }
        Boolean isOkrMilestone = false;
        if (params.get("isOkrMilestone") instanceof Boolean) {
            isOkrMilestone = (Boolean)params.get("isOkrMilestone");
        }
        if (PropertyValidator.isValid((Object)(itemId = (String)(itemMap = (Map)params.get("item")).get("id")))) {
            item = this.backlogItemRepository.findById(itemId);
            if (item.getFields() == null) {
                item.setFields(new HashMap());
            }
        } else {
            item = new BacklogItem(ObjectId.get().toString(), user);
            item.setFields(new HashMap());
            if (isObjCustomViewMilestone.booleanValue()) {
                item.linkToObjCustomView(releaseTrainId, Integer.valueOf(Integer.parseInt(backlogLevelStr)));
            } else {
                item.linkToRTE(releaseTrainId, Integer.valueOf(Integer.parseInt(backlogLevelStr)));
            }
        }
        if (PropertyValidator.isValid((Object)(field = (String)params.get("field")))) {
            String oldTitle = item.getTitle();
            Object value = itemMap.get(field);
            this.updateField(item, field, value);
            if (params.containsKey("metaMap")) {
                String metaMapJson = (String)params.get("metaMap");
                Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                4 typeToken = new /* Unavailable Anonymous Inner Class!! */;
                HashMap pushMeta = (HashMap)gson.fromJson(metaMapJson, typeToken.getType());
                HashMap<String, Object> pushJson = new HashMap<String, Object>();
                if (!pushMeta.isEmpty()) {
                    pushJson.put("metaMap", gson.toJson((Object)pushMeta));
                }
                HashMap<String, String> itemData = new HashMap<String, String>();
                itemData.put("id", item.getId());
                itemData.put("key", item.getKendisKey());
                itemData.put("title", oldTitle);
                pushJson.put("data", itemData);
                pushJson.put("push", "Self");
                pushJson.put("action", "milestone-field-update");
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
                }
                catch (JsonProcessingException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        } else {
            if (itemMap.containsKey("title")) {
                String title = (String)itemMap.get("title");
                if ((title = title.trim()).length() > 0) {
                    item.setTitle(title);
                }
            }
            if (itemMap.containsKey("description")) {
                String description = (String)itemMap.get("description");
                item.setDescription(description);
            }
            if (itemMap.containsKey("status")) {
                Map statusMap = (Map)itemMap.get("status");
                item.setStatus(new Status((String)statusMap.get("id")));
            }
            if (itemMap.containsKey("fields")) {
                Map fieldsMap = (Map)itemMap.get("fields");
                this.updateFields(item, fieldsMap);
            }
            if (PropertyValidator.isValid((Object)boardId)) {
                this.linkMilestoneWithBoard(item, boardId, releaseTrainId, isProgramBoardMilestone, isRoadmapMilestone, isOkrMilestone, isObjCustomViewMilestone);
            }
        }
        if (params.containsKey("sectionRelations") && (sectionRelations = (List)params.get("sectionRelations")) != null && !sectionRelations.isEmpty()) {
            LOGGER.info("Processing section relations for milestone: {}", (Object)item.getId());
            List sectionIdsToValidate = sectionRelations.stream().map(relation -> (String)relation.get("baseItemId")).filter(PropertyValidator::isValid).collect(Collectors.toList());
            if (!sectionIdsToValidate.isEmpty()) {
                this.validateMilestoneSectionIds(sectionIdsToValidate);
            }
            item.setSectionRelations(new ArrayList());
            for (Map relation2 : sectionRelations) {
                BaseItemLink sectionLink = new BaseItemLink();
                sectionLink.setLinkType((String)relation2.get("linkType"));
                sectionLink.setBaseItemId((String)relation2.get("baseItemId"));
                sectionLink.setReleaseTrainId((String)relation2.get("releaseTrainId"));
                sectionLink.setIsSystemLink((Boolean)relation2.get("isSystemLink"));
                sectionLink.setWeightage(Double.valueOf(((Number)relation2.get("weightage")).doubleValue()));
                sectionLink.setArchive(((Boolean)relation2.get("archive")).booleanValue());
                sectionLink.setTenant((String)relation2.get("tenant"));
                sectionLink.setRowStatus(((Integer)relation2.get("rowStatus")).intValue());
                item.getSectionRelations().add(sectionLink);
                LOGGER.info("Added section relation: {} -> {}", (Object)sectionLink.getBaseItemId(), (Object)item.getId());
            }
        }
        item = (BacklogItem)this.backlogItemRepository.save((Object)item);
        result.put("success", true);
        result.put("item", item);
        return result;
    }

    private void updateField(BacklogItem item, String field, Object value) {
        if ("title".equals(field)) {
            if (value instanceof String) {
                String title = (String)value;
                if ((title = title.trim()).length() > 0) {
                    item.setTitle(title);
                }
            }
        } else if ("description".equals(field)) {
            item.setDescription((String)value);
        } else if ("status".equals(field)) {
            Map statusMap = (Map)value;
            item.setStatus(new Status((String)statusMap.get("id")));
        } else if ("itemType".equals(field) || "responsibles".equals(field) || "Color".equals(field)) {
            if (item.getFields() == null) {
                item.setFields(new HashMap());
            }
            if ("itemType".equals(field)) {
                this.updateItemKey(item, Collections.singletonMap(field, value), (String)item.getFields().get("itemType"));
                if ("Milestone".equals(value)) {
                    item.getFields().remove("EndDate");
                } else if ("Phase".equals(value)) {
                    item.getFields().put("EndDate", item.getFields().get("StartDate"));
                }
            }
            item.getFields().put(field, value);
        } else if ("StartDate".equals(field) || "EndDate".equals(field)) {
            Date dateValue;
            if (item.getFields() == null) {
                item.setFields(new HashMap());
            }
            if ((dateValue = PropertyValidator.parseDate((String)((String)value), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'")) != null) {
                item.getFields().put(field, ZonedDateTime.parse((String)value).format(DateTimeFormatter.ISO_DATE_TIME));
            }
        }
    }

    private void updateFields(BacklogItem item, Map<String, Object> fieldsMap) {
        if (fieldsMap.containsKey("itemType")) {
            String itemType = item.getFields().getOrDefault("itemType", null);
            if ("Milestone".equals(fieldsMap.get("itemType"))) {
                fieldsMap.remove("EndDate");
                item.getFields().remove("EndDate");
            }
            this.updateItemKey(item, fieldsMap, itemType);
        }
        for (Map.Entry<String, Object> entry : fieldsMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String strValue = (String)value;
                if (strValue.isEmpty()) continue;
                if ("StartDate".equals(key) || "EndDate".equals(key)) {
                    item.getFields().put(key, ZonedDateTime.parse(strValue).format(DateTimeFormatter.ISO_DATE_TIME));
                    continue;
                }
                if (key.equalsIgnoreCase("lastKey")) continue;
                item.getFields().put(key, value);
                continue;
            }
            item.getFields().put(key, value);
        }
    }

    private void updateItemKey(BacklogItem item, Map<String, Object> fieldsMap, String itemType) {
        if (PropertyValidator.isValid((Object)itemType)) {
            String lastKey = item.getFields().getOrDefault("lastKey", null);
            if (PropertyValidator.isValid((Object)lastKey) && !itemType.equalsIgnoreCase((String)fieldsMap.get("itemType"))) {
                String currentKey = item.getKendisKey();
                item.setKendisKey(lastKey);
                item.getFields().put("lastKey", currentKey);
            } else if (!itemType.equalsIgnoreCase((String)fieldsMap.get("itemType"))) {
                if (!item.getFields().containsKey("lastKey")) {
                    item.getFields().put("lastKey", item.getKendisKey());
                }
                item.setKendisKey(this.customRepositoryImpl.generateKey(((String)fieldsMap.get("itemType")).charAt(0) + ""));
            }
        } else {
            item.setKendisKey(this.customRepositoryImpl.generateKey(((String)fieldsMap.get("itemType")).charAt(0) + ""));
        }
    }

    private void linkMilestoneWithBoard(BacklogItem item, String boardId, String releaseTrainId, Boolean isProgramBoardMilestone, Boolean isRoadmapMilestone, Boolean isOkrMilestone, Boolean isObjCustomViewMilestone) {
        if (isProgramBoardMilestone.booleanValue()) {
            boolean sessionLinked;
            Session session = this.sessionRepository.findById(boardId);
            if (PropertyValidator.isValid((Object)session) && !(sessionLinked = item.getBoardRelations().stream().anyMatch(relation -> relation.getSessionId().equals(session.getId())))) {
                item.linkToBoard(releaseTrainId, session.getActiveSessionBoard(), session.getId());
            }
        } else if (isRoadmapMilestone.booleanValue()) {
            Board board = (Board)this.boardRepository.findOne((Serializable)((Object)boardId));
            if (PropertyValidator.isValid((Object)board)) {
                int index;
                item.linkToTimeline(releaseTrainId, boardId, EnumKendis.ROADMAP_RELATION.getCode());
                if (board.getLinkedBacklogItems() == null) {
                    board.setLinkedBacklogItems(new ArrayList());
                }
                if ((index = board.getLinkedBacklogItems().indexOf(item.getId())) == -1) {
                    board.getLinkedBacklogItems().add(item.getId());
                }
            }
            this.boardRepository.save((Object)board);
        } else if (isOkrMilestone.booleanValue()) {
            Board board = (Board)this.boardRepository.findOne((Serializable)((Object)boardId));
            if (PropertyValidator.isValid((Object)board)) {
                int index;
                if (isObjCustomViewMilestone.booleanValue()) {
                    item.linkToTimeline(releaseTrainId, boardId, EnumKendis.OBJ_CUSTOM_VIEW_LINK.getCode());
                } else {
                    item.linkToTimeline(releaseTrainId, boardId, EnumKendis.OKR_ROADMAP_RELATION.getCode());
                }
                if (board.getLinkedBacklogItems() == null) {
                    board.setLinkedBacklogItems(new ArrayList());
                }
                if ((index = board.getLinkedBacklogItems().indexOf(item.getId())) == -1) {
                    board.getLinkedBacklogItems().add(item.getId());
                }
            }
            this.boardRepository.save((Object)board);
        } else {
            Board board = (Board)this.boardRepository.findOne((Serializable)((Object)boardId));
            if (PropertyValidator.isValid((Object)board)) {
                int index;
                item.linkToTimeline(releaseTrainId, boardId, EnumKendis.TIMELINE_RELATION.getCode());
                if (board.getLinkedBacklogItems() == null) {
                    board.setLinkedBacklogItems(new ArrayList());
                }
                if ((index = board.getLinkedBacklogItems().indexOf(item.getId())) == -1) {
                    board.getLinkedBacklogItems().add(item.getId());
                }
            }
            this.boardRepository.save((Object)board);
        }
    }

    public Map<String, Object> linkItemsWithBacklogItem(HashMap<String, Object> params) throws Exception {
        try {
            return this.processLinking(params, true);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public Map<String, Object> unlinkItemsWithBacklogItem(HashMap<String, Object> params) throws Exception {
        try {
            return this.processLinking(params, false);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    private Map<String, Object> processLinking(HashMap<String, Object> params, boolean isLinking) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String backlogItemId = (String)this.getParam(params, "backlogItemId", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List itemIds = (List)this.getParam(params, isLinking ? "itemsToLink" : "itemsToUnlink", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            String itemType = (String)this.getParam(params, "itemType", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            String artId = (String)this.getParam(params, "releaseTrainId", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (!PropertyValidator.isValid((Object)backlogItemId) || !PropertyValidator.isValid((Collection)itemIds)) {
                throw new IllegalArgumentException(isLinking ? "Failed to link items due to invalid parameters" : "Failed to unlink items due to invalid parameters");
            }
            BacklogItem backlogItem = this.backlogItemRepository.findById(backlogItemId);
            if (!PropertyValidator.isValid((Object)backlogItem)) {
                throw new IllegalArgumentException("Invalid Backlog Item");
            }
            if (!PropertyValidator.isValid((Object)itemType) || !EnumKendis.MILESTONE.getCode().equals(itemType)) {
                throw new IllegalArgumentException("Invalid Item Type");
            }
            List backlogItems = this.backlogItemRepository.findByIdIn((Collection)itemIds);
            boolean isSuccess = this.processItems(backlogItem, backlogItems, artId, isLinking);
            if (isSuccess) {
                backlogItems = this.backlogItemRepository.save((Iterable)backlogItems);
                backlogItem = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
            }
            result.put("updatedItem", backlogItem);
            result.put("backlogItems", backlogItems);
            result.put("success", isSuccess);
            if (!isSuccess) {
                result.put("error", "Failed to process items");
            }
        }
        catch (IllegalArgumentException e) {
            result.put("error", e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
        return result;
    }

    private boolean processItems(BacklogItem backlogItem, List<BacklogItem> backlogItems, String artId, boolean isLinking) throws Exception {
        boolean isSuccess = false;
        for (BacklogItem currentBacklogItem : backlogItems) {
            String almType;
            boolean processSuccess = false;
            if (PropertyValidator.isValid((Object)currentBacklogItem.getAlmAccountId())) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)currentBacklogItem.getAlmAccountId()));
                query.fields().include("type");
                AlmAccount almAccount = (AlmAccount)this.mongoTemplate.findOne(query, AlmAccount.class);
                almType = PropertyValidator.isValid((Object)almAccount) ? almAccount.getType() : "";
            } else {
                almType = "";
            }
            if (isLinking) {
                BaseItemLink milestoneLink = currentBacklogItem.linkToMilestone(artId, backlogItem.getId());
                BaseItemLink backlogLink = backlogItem.linkToBacklogItem(artId, currentBacklogItem.getId(), currentBacklogItem.getAlmItemId(), almType);
                if (null != milestoneLink && null != backlogLink) {
                    processSuccess = true;
                }
            } else {
                boolean isUnlinkedWithBacklogItem;
                boolean isUnlinkedWithMilestone = currentBacklogItem.unlinkWithMilestone(artId, backlogItem.getId());
                if (PropertyValidator.isValid((Object)currentBacklogItem.getAlmItemId())) {
                    List itemsToRemove = backlogItem.getItemRelations().stream().filter(baseItemLink -> PropertyValidator.isValid((Object)baseItemLink.getAlmType()) && PropertyValidator.isValid((Object)baseItemLink.getAlmItemId()) && baseItemLink.getAlmType().equals(almType) && baseItemLink.getAlmItemId().equals(currentBacklogItem.getAlmItemId())).collect(Collectors.toList());
                    isUnlinkedWithBacklogItem = backlogItem.getItemRelations().removeAll(itemsToRemove);
                } else {
                    isUnlinkedWithBacklogItem = backlogItem.getItemRelations().removeIf(baseItemLink -> currentBacklogItem.getId().equals(baseItemLink.getBaseItemId()));
                }
                processSuccess = isUnlinkedWithMilestone || isUnlinkedWithBacklogItem;
            }
            isSuccess = isSuccess || processSuccess;
        }
        return isSuccess;
    }

    private Map<String, Object> handleException(Exception e) {
        HashMap<String, Object> errorResult = new HashMap<String, Object>();
        errorResult.put("success", false);
        errorResult.put("error", e.getMessage());
        return errorResult;
    }

    private <T> T getParam(HashMap<String, Object> params, String key, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = new ObjectMapper();
        Object value = params.get(key);
        if (null != value) {
            try {
                return (T)objectMapper.convertValue(value, typeReference);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public Map<String, Object> fetchAttachedReleaseTrains(HashMap<String, Object> params) {
        String backlogItemId;
        BacklogItem backlogItem;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (params.containsKey("backlogItemId") && PropertyValidator.isValid((Object)(backlogItem = (BacklogItem)this.backlogItemRepository.findOne((Serializable)((Object)(backlogItemId = (String)params.get("backlogItemId"))))))) {
            ArrayList<String> releaseTrains = new ArrayList<String>();
            for (BaseItemLink baseItemLink : backlogItem.getItemRelations()) {
                releaseTrains.add(baseItemLink.getReleaseTrainId());
            }
            List workSpaces = this.workSpaceRepository.findByIdIn(releaseTrains);
            result.put("attachedReleaseTrains", workSpaces);
        }
        return result;
    }

    public Map<String, Object> createBacklogItemRelation(HashMap<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String relationType = (String)params.get("relationType");
        List backlogItemIds = params.getOrDefault("backlogItemIds", new ArrayList());
        String releaseTrainId = (String)params.get("releaseTrainId");
        List batchIds = params.getOrDefault("batchIds", new ArrayList());
        List timelineIds = params.getOrDefault("timelineIds", new ArrayList());
        List programBoardIds = params.getOrDefault("programBoardIds", new ArrayList());
        List roadmapIds = params.getOrDefault("roadmapIds", new ArrayList());
        if (!PropertyValidator.isValid((Object)relationType) || !PropertyValidator.isValid((Collection)backlogItemIds)) {
            result.put("error", "Invalid Relation Type or Item Id");
            return result;
        }
        ArrayList updatedBacklogItems = new ArrayList();
        ArrayList archivedMilestones = new ArrayList();
        for (String backlogItemId : backlogItemIds) {
            BacklogItem backlogItem = this.backlogItemRepository.findById(backlogItemId);
            if (!PropertyValidator.isValid((Object)backlogItem)) {
                result.put("error", "Invalid Item");
                continue;
            }
            if (!PropertyValidator.isValid((Object)releaseTrainId)) {
                result.put("error", "Collection is not Selected");
                continue;
            }
            this.handleRelationType(result, backlogItem, releaseTrainId, relationType, batchIds, timelineIds, programBoardIds, updatedBacklogItems, archivedMilestones, roadmapIds);
        }
        if (!archivedMilestones.isEmpty()) {
            result.put("archivedMilestones", archivedMilestones);
        }
        if (!updatedBacklogItems.isEmpty()) {
            result.put("updatedItems", updatedBacklogItems);
        } else {
            result.put("error", "No backlog items were updated.");
        }
        return result;
    }

    private void handleRelationType(Map<String, Object> result, BacklogItem backlogItem, String releaseTrainId, String relationType, List<String> batchIds, List<String> timelineIds, List<String> programBoardIds, List<BacklogItem> updatedBacklogItems, List<BacklogItem> archivedMilestones, List<String> roadmapIds) {
        boolean isArchived;
        Integer level = this.getBacklogItemLevel(backlogItem);
        boolean bl = isArchived = backlogItem.getArtRelationMap().getOrDefault(releaseTrainId, new BaseItemLink()).getRowStatus() == 1;
        if (isArchived) {
            archivedMilestones.add(backlogItem);
            return;
        }
        switch (relationType) {
            case "collections": {
                this.handleCollectionsRelation(backlogItem, releaseTrainId, level, timelineIds);
                result.put("message", "Milestone is linked with timeline(s)");
                break;
            }
            case "batches": {
                this.handleBatchesRelation(backlogItem, releaseTrainId, batchIds);
                result.put("message", "Milestone is linked with batch");
                break;
            }
            case "program-boards": {
                this.handleProgramBoardsRelation(backlogItem, releaseTrainId, level, programBoardIds);
                result.put("message", "Milestone is linked with program board(s)");
                break;
            }
            case "obj-custom-views": {
                this.handleObjCustomViewsRelation(backlogItem, releaseTrainId, level, roadmapIds);
                result.put("message", "Milestone is linked with okr roadmap");
                break;
            }
            default: {
                result.put("error", "Invalid Relation Type");
                return;
            }
        }
        backlogItem = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
        updatedBacklogItems.add(backlogItem);
    }

    private void handleObjCustomViewsRelation(BacklogItem backlogItem, String customViewId, Integer level, List<String> roadmapIds) {
        if (PropertyValidator.isValid((Object)level) && backlogItem.getArtRelationMap().getOrDefault(customViewId, null) == null) {
            backlogItem.linkToObjCustomView(customViewId, level);
        }
        for (String roadmapId : roadmapIds) {
            Board roadmap = (Board)this.boardRepository.findOne((Serializable)((Object)roadmapId));
            if (!PropertyValidator.isValid((Object)roadmap)) continue;
            roadmap.getLinkedBacklogItems().add(backlogItem.getId());
            this.boardRepository.save((Object)roadmap);
            if (roadmap.getViewType().equals(Board.EnumBoardType.ROADMAP.getValue())) {
                backlogItem.linkToTimeline(customViewId, roadmapId, Board.EnumBoardType.ROADMAP.getValue());
                continue;
            }
            if (roadmap.getViewType().equals(Board.EnumBoardType.OKR_ROADMAP.getValue())) {
                backlogItem.linkToTimeline(customViewId, roadmapId, EnumKendis.OBJ_CUSTOM_VIEW_LINK.getCode());
                continue;
            }
            backlogItem.linkToTimeline(customViewId, roadmapId, EnumKendis.TIMELINE_RELATION.getCode());
        }
    }

    private Integer getBacklogItemLevel(BacklogItem backlogItem) {
        return backlogItem.getArtRelationMap().values().stream().map(BaseItemLink::getBacklogLevel).filter(PropertyValidator::isValid).findFirst().orElse(null);
    }

    private void handleCollectionsRelation(BacklogItem backlogItem, String releaseTrainId, Integer level, List<String> timelineIds) {
        if (PropertyValidator.isValid((Object)level) && backlogItem.getArtRelationMap().getOrDefault(releaseTrainId, null) == null) {
            backlogItem.linkToRTE(releaseTrainId, level);
        }
        for (String timelineId : timelineIds) {
            Board timeline = (Board)this.boardRepository.findOne((Serializable)((Object)timelineId));
            if (!PropertyValidator.isValid((Object)timeline)) continue;
            timeline.getLinkedBacklogItems().add(backlogItem.getId());
            this.boardRepository.save((Object)timeline);
            if (timeline.getViewType().equals(Board.EnumBoardType.ROADMAP.getValue())) {
                backlogItem.linkToTimeline(releaseTrainId, timelineId, Board.EnumBoardType.ROADMAP.getValue());
                continue;
            }
            if (timeline.getViewType().equals(Board.EnumBoardType.OKR_ROADMAP.getValue())) {
                backlogItem.linkToTimeline(releaseTrainId, timelineId, EnumKendis.OKR_ROADMAP_RELATION.getCode());
                continue;
            }
            backlogItem.linkToTimeline(releaseTrainId, timelineId, EnumKendis.TIMELINE_RELATION.getCode());
        }
    }

    private void handleBatchesRelation(BacklogItem backlogItem, String releaseTrainId, List<String> batchIds) {
        for (String batchId : batchIds) {
            backlogItem.linkToBatch(releaseTrainId, batchId);
        }
    }

    private void handleProgramBoardsRelation(BacklogItem backlogItem, String releaseTrainId, Integer level, List<String> programBoardIds) {
        if (PropertyValidator.isValid((Object)level) && backlogItem.getArtRelationMap().getOrDefault(releaseTrainId, null) == null) {
            backlogItem.linkToRTE(releaseTrainId, level);
        }
        for (String programBoardId : programBoardIds) {
            Session session = this.sessionRepository.findById(programBoardId);
            backlogItem.linkToBoard(releaseTrainId, session.getActiveSessionBoard(), session.getId());
        }
    }

    public Map<String, Object> removeBacklogItemRelation(HashMap<String, Object> params) {
        String backlogItemId;
        Boolean removeLinkedBacklogItems;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String relationType = null;
        List linkedTimelineIds = params.containsKey("linkedTimelineIds") ? KendisUtils.getListValue(params, (String)"linkedTimelineIds", String.class) : new ArrayList();
        Boolean bl = removeLinkedBacklogItems = params.containsKey("removeLinkedBacklogItems") ? (Boolean)KendisUtils.getValue(params, (String)"removeLinkedBacklogItems", Boolean.class) : Boolean.valueOf(false);
        if (params.containsKey("relationType")) {
            relationType = (String)params.get("relationType");
        }
        String relationId = params.containsKey("relationId") ? (String)params.get("relationId") : null;
        String string = backlogItemId = params.containsKey("backlogItemId") ? (String)KendisUtils.getValue(params, (String)"backlogItemId", String.class) : null;
        if (PropertyValidator.isValid(backlogItemId)) {
            BacklogItem backlogItem = this.backlogItemRepository.findById(backlogItemId);
            if (PropertyValidator.isValid((Object)backlogItem)) {
                if (PropertyValidator.isValid((Object)relationType) && PropertyValidator.isValid((Object)relationId)) {
                    if (relationType.equals("collections")) {
                        if (backlogItem.getArtRelationMap().size() > 1) {
                            backlogItem.getArtRelationMap().remove(relationId);
                            if (PropertyValidator.isValid(linkedTimelineIds)) {
                                backlogItem.getRelations().removeIf(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.TIMELINE_RELATION.getCode()) && linkedTimelineIds.contains(baseItemLink.getBaseItemId()));
                                List timelineObjectIds = linkedTimelineIds.stream().map(ObjectId::new).collect(Collectors.toList());
                                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(timelineObjectIds));
                                List timelines = this.mongoTemplate.find(query, Board.class);
                                if (PropertyValidator.isValid((Collection)timelines)) {
                                    for (Board timeline : timelines) {
                                        timeline.getLinkedBacklogItems().remove(backlogItemId);
                                        this.boardRepository.save((Object)timeline);
                                    }
                                }
                            }
                            if (Boolean.TRUE.equals(removeLinkedBacklogItems)) {
                                backlogItem = this.removeLinkedBacklogItemsFromMilestone(backlogItem, relationId);
                            }
                            backlogItem = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
                            result.put("updatedItem", backlogItem);
                            result.put("message", "Milestone/Phase is unlinked from ART");
                        } else {
                            result.put("error", "You can not remove relation of Milestone/Phase from all ARTs");
                        }
                    } else if (relationType.equals("timelines")) {
                        Board board = (Board)this.boardRepository.findOne((Serializable)((Object)relationId));
                        if (PropertyValidator.isValid((Object)board)) {
                            board.getLinkedBacklogItems().removeIf(milestoneId -> milestoneId.equals(backlogItemId));
                            this.boardRepository.save((Object)board);
                        }
                        backlogItem.unlinkFromTimeline(relationId);
                        backlogItem = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
                        result.put("updatedItem", backlogItem);
                        result.put("message", "Milestone/Phase is unlinked from timeline");
                    } else if (relationType.equals("batches")) {
                        backlogItem.getBatchRelations().removeIf(baseItemLink -> baseItemLink.getBaseItemId().equals(relationId));
                        backlogItem = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
                        result.put("updatedItem", backlogItem);
                        result.put("message", "Milestone/Phase is unlinked from batch");
                    } else if (relationType.equals("program-boards")) {
                        backlogItem.getBoardRelations().removeIf(baseItemLink -> baseItemLink.getSessionId().equals(relationId));
                        backlogItem = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
                        result.put("updatedItem", backlogItem);
                        result.put("message", "Milestone/Phase is unlinked from program board");
                    } else if (relationType.equals("custom-views")) {
                        if (backlogItem.getArtRelationMap().size() > 1) {
                            backlogItem.getArtRelationMap().remove(relationId);
                            backlogItem = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
                            result.put("updatedItem", backlogItem);
                            result.put("message", "Milestone/Phase is unlinked from Custom View");
                        } else {
                            result.put("error", "You can not remove relation of Milestone/Phase from all Custom Views");
                        }
                    }
                }
            } else {
                result.put("error", "Invalid Item");
            }
        } else {
            result.put("error", "Invalid Item Id");
        }
        return result;
    }

    public BacklogItem removeLinkedBacklogItemsFromMilestone(BacklogItem milestone, String releaseTrainId) {
        List almItemIds = milestone.getItemRelations().stream().filter(baseItemLink -> releaseTrainId.equals(baseItemLink.getReleaseTrainId()) && baseItemLink.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode())).map(BaseItemLink::getAlmItemId).collect(Collectors.toList());
        List itemIds = milestone.getItemRelations().stream().filter(baseItemLink -> releaseTrainId.equals(baseItemLink.getReleaseTrainId()) && baseItemLink.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode())).map(BaseItemLink::getBaseItemId).collect(Collectors.toList());
        milestone.getItemRelations().removeIf(baseItemLink -> almItemIds.contains(baseItemLink.getAlmItemId()));
        List items = this.backlogItemRepository.findByIdIn(itemIds);
        if (PropertyValidator.isValid((Collection)items)) {
            for (BacklogItem item : items) {
                item.getMilestoneRelations().removeIf(baseItemLink -> releaseTrainId.equals(baseItemLink.getReleaseTrainId()) && baseItemLink.getLinkType().equals(EnumBaseItemTypes.MILESTONES.getName()) && milestone.getId().equals(baseItemLink.getBaseItemId()));
                this.backlogItemRepository.save((Object)item);
            }
        }
        return milestone;
    }

    public Map<String, Object> fetchBacklogItemRelation(HashMap<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Boolean fetchLinkedBatches = false;
        Boolean fetchLinkedReleaseTrains = false;
        Boolean fetchLinkedProgramBoards = false;
        Boolean fetchLinkedTimelines = false;
        Boolean fetchLinkedCustomViews = false;
        String backlogItemId = null;
        if (params.containsKey("backlogItemId")) {
            backlogItemId = (String)params.get("backlogItemId");
        }
        if (params.containsKey("fetchLinkedBatches")) {
            fetchLinkedBatches = (Boolean)params.get("fetchLinkedBatches");
        }
        if (params.containsKey("fetchLinkedReleaseTrains")) {
            fetchLinkedReleaseTrains = (Boolean)params.get("fetchLinkedReleaseTrains");
        }
        if (params.containsKey("fetchLinkedProgramBoards")) {
            fetchLinkedProgramBoards = (Boolean)params.get("fetchLinkedProgramBoards");
        }
        if (params.containsKey("fetchLinkedTimelines")) {
            fetchLinkedTimelines = (Boolean)params.get("fetchLinkedTimelines");
        }
        if (params.containsKey("fetchLinkedCustomViews")) {
            fetchLinkedCustomViews = (Boolean)params.get("fetchLinkedCustomViews");
        }
        if (PropertyValidator.isValid((Object)backlogItemId)) {
            BacklogItem backlogItem = this.backlogItemRepository.findById(backlogItemId);
            if (PropertyValidator.isValid((Object)backlogItem)) {
                List sessionIds;
                List ids;
                List timelineResults = new ArrayList();
                if (fetchLinkedBatches.booleanValue() && PropertyValidator.isValid(ids = backlogItem.getBatchRelations().stream().map(baseItemLink -> baseItemLink.getBaseItemId()).collect(Collectors.toList()))) {
                    List batches = this.baseItemRepository.findBatchesByIdIn(ids);
                    result.put("linkedBatches", batches);
                }
                if (fetchLinkedProgramBoards.booleanValue() && PropertyValidator.isValid(sessionIds = backlogItem.getBoardRelations().stream().map(baseItemLink -> new ObjectId(baseItemLink.getSessionId())).collect(Collectors.toList()))) {
                    List sessions = this.fetchProgramBoardsBySessionIdsIn(sessionIds);
                    result.put("linkedProgramBoards", sessions);
                }
                if (fetchLinkedTimelines.booleanValue() && PropertyValidator.isValid(ids = backlogItem.getRelations().stream().filter(baseItemLink -> EnumKendis.TIMELINE_RELATION.getCode().equals(baseItemLink.getLinkType())).map(baseItemLink -> new ObjectId(baseItemLink.getBaseItemId())).collect(Collectors.toList()))) {
                    timelineResults = this.fetchTimelineBoards(ids);
                    result.put("linkedTimelines", timelineResults);
                }
                if (fetchLinkedReleaseTrains.booleanValue() && PropertyValidator.isValid(ids = backlogItem.getArtRelationMap().entrySet().stream().filter(e -> EnumKendis.ART_MAIN_LINK.getCode().equals(((BaseItemLink)e.getValue()).getLinkType())).map(Map.Entry::getKey).collect(Collectors.toList()))) {
                    Map workSpaceWithTimelines = this.fetchWorkSpacesWithTimelines(ids, timelineResults, backlogItem);
                    result.putAll(workSpaceWithTimelines);
                }
                if (fetchLinkedCustomViews.booleanValue() && PropertyValidator.isValid(ids = backlogItem.getArtRelationMap().entrySet().stream().filter(e -> EnumKendis.OBJ_CUSTOM_VIEW_LINK.getCode().equals(((BaseItemLink)e.getValue()).getLinkType())).map(Map.Entry::getKey).collect(Collectors.toList()))) {
                    List linkedCustomViews = this.objectiveCustomViewRepository.findAllByIdIn(ids);
                    result.put("linkedCustomViews", linkedCustomViews);
                }
                result.put("success", true);
            } else {
                result.put("error", "Invalid Item");
            }
        } else {
            result.put("error", "Invalid Item Id");
        }
        return result;
    }

    public BacklogItem updateItemField(RTItemsOperationsDTO rtItemsOperationsDTO) {
        if (EnumRTItemsOperations.MOVE_FIELD.equals((Object)rtItemsOperationsDTO.getOperation())) {
            return this.addItemField(rtItemsOperationsDTO);
        }
        throw new KendisException("Invalid Operation");
    }

    public void removeSectionRelation(String sectionId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sectionRelations.baseItemId").is((Object)sectionId));
        Update update = new Update();
        update.pull("sectionRelations", (Object)new BasicDBObject("baseItemId", (Object)sectionId));
        this.mongoTemplate.updateMulti(query, update, BacklogItem.class);
    }

    private BacklogItem addItemField(RTItemsOperationsDTO rtItemsOperationsDTO) {
        if (!(PropertyValidator.isValid((Object)rtItemsOperationsDTO.getCollectionId()) && PropertyValidator.isValid((Object)rtItemsOperationsDTO.getItemId()) && PropertyValidator.isValid((Object)rtItemsOperationsDTO.getFieldName()))) {
            throw new KendisException("Invalid Parameters");
        }
        BacklogItem backlogItem = this.backlogItemRepository.findById(rtItemsOperationsDTO.getItemId());
        if (!PropertyValidator.isValid((Object)backlogItem)) {
            LOGGER.debug("Invalid Backlog Item");
            throw new KendisException("Invalid Backlog Item");
        }
        if ("sectionRelations".equals(rtItemsOperationsDTO.getFieldName())) {
            ArrayList<BaseItemLink> sectionRelations = backlogItem.getSectionRelations();
            if (sectionRelations == null) {
                sectionRelations = new ArrayList<BaseItemLink>();
            }
            Map<String, RoadmapSection> currentSectionMap = this.roadmapSectionRepository.findAllByIdIn(sectionRelations.stream().map(BaseItemLink::getBaseItemId).collect(Collectors.toList())).stream().collect(Collectors.toMap(BaseEntity::getId, roadmapSection -> roadmapSection));
            this.validateSectionIds(rtItemsOperationsDTO.getSourceFieldId(), rtItemsOperationsDTO.getDestinationFieldId());
            if (PropertyValidator.isValid((Object)rtItemsOperationsDTO.getDestinationFieldId()) && currentSectionMap.containsKey(rtItemsOperationsDTO.getDestinationFieldId())) {
                LOGGER.debug("Section is already attached");
                throw new KendisException("Section is already attached");
            }
            if (!PropertyValidator.isValid((Object)rtItemsOperationsDTO.getSourceFieldId()) && !PropertyValidator.isValid((Object)rtItemsOperationsDTO.getDestinationFieldId())) {
                throw new KendisException("Invalid Params");
            }
            if (!PropertyValidator.isValid((Object)rtItemsOperationsDTO.getSourceFieldId())) {
                BaseItemLink baseItemLink2 = new BaseItemLink();
                baseItemLink2.setBaseItemId(rtItemsOperationsDTO.getDestinationFieldId());
                baseItemLink2.setLinkType(EnumBaseItemLinkTypes.ITEM_TO_ROADMAP_SECTION.getLinkType());
                sectionRelations.add(baseItemLink2);
            } else if (!PropertyValidator.isValid((Object)rtItemsOperationsDTO.getDestinationFieldId())) {
                sectionRelations.removeIf(section -> section.getBaseItemId().equals(rtItemsOperationsDTO.getSourceFieldId()));
            } else {
                sectionRelations.stream().filter(section -> section.getBaseItemId().equals(rtItemsOperationsDTO.getSourceFieldId())).findFirst().ifPresent(baseItemLink -> baseItemLink.setBaseItemId(rtItemsOperationsDTO.getDestinationFieldId()));
            }
            backlogItem.setSectionRelations(sectionRelations);
            LOGGER.debug("Going to save backlog item id{}", (Object)backlogItem.getId());
            return (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
        }
        throw new KendisException("Invalid Field Name");
    }

    private void validateSectionIds(String sourceFieldId, String destinationFieldId) {
        ArrayList<String> sectionIdsToValidate = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)sourceFieldId)) {
            sectionIdsToValidate.add(sourceFieldId);
        }
        if (PropertyValidator.isValid((Object)destinationFieldId)) {
            sectionIdsToValidate.add(destinationFieldId);
        }
        if (sectionIdsToValidate.isEmpty()) {
            return;
        }
        List existingSections = this.roadmapSectionRepository.findAllByIdIn(sectionIdsToValidate);
        Set existingSectionIds = existingSections.stream().map(BaseEntity::getId).collect(Collectors.toSet());
        for (String sectionId : sectionIdsToValidate) {
            if (existingSectionIds.contains(sectionId)) continue;
            LOGGER.error("Section ID {} does not exist in roadmapSection collection", (Object)sectionId);
            throw new KendisException("Section with ID '" + sectionId + "' does not exist");
        }
        LOGGER.debug("Successfully validated section IDs: {}", sectionIdsToValidate);
    }

    private void validateMilestoneSectionIds(List<String> sectionIds) {
        if (sectionIds == null || sectionIds.isEmpty()) {
            return;
        }
        List existingSections = this.roadmapSectionRepository.findAllByIdIn(sectionIds);
        Set existingSectionIds = existingSections.stream().map(BaseEntity::getId).collect(Collectors.toSet());
        for (String sectionId : sectionIds) {
            if (existingSectionIds.contains(sectionId)) continue;
            LOGGER.error("Section ID {} does not exist in roadmapSection collection for milestone operation", (Object)sectionId);
            throw new KendisException("Section with ID '" + sectionId + "' does not exist");
        }
        LOGGER.debug("Successfully validated milestone section IDs: {}", sectionIds);
    }

    private List<Map<String, Object>> fetchTimelineBoards(List<ObjectId> ids) {
        ArrayList<BasicDBObject> pipelines = new ArrayList<BasicDBObject>();
        BasicDBObject basicMatch = new BasicDBObject();
        basicMatch.append("_id", (Object)new BasicDBObject("$in", ids));
        basicMatch.append("rowStatus", (Object)0);
        BasicDBObject finalMatchPipeline = new BasicDBObject("$match", (Object)basicMatch);
        pipelines.add(finalMatchPipeline);
        BasicDBObject lookupWorkspace = new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)"workSpace").append("localField", (Object)"workSpace.$id").append("foreignField", (Object)"_id").append("as", (Object)"workspace"));
        pipelines.add(lookupWorkspace);
        BasicDBObject unwindWorkspace = new BasicDBObject("$unwind", (Object)"$workspace");
        pipelines.add(unwindWorkspace);
        BasicDBObject matchWorkspaceRowStatus = new BasicDBObject("$match", (Object)new BasicDBObject("workspace.rowStatus", (Object)0));
        pipelines.add(matchWorkspaceRowStatus);
        BasicDBObject projectFields = new BasicDBObject("$project", (Object)new BasicDBObject("key", (Object)1).append("name", (Object)1).append("workSpace", (Object)1));
        pipelines.add(projectFields);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Board.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.FALSE).build();
        Cursor dbCursor = collection.aggregate(pipelines, ao);
        ArrayList<Map<String, Object>> timelineResults = new ArrayList<Map<String, Object>>();
        while (dbCursor.hasNext()) {
            DBObject document = (DBObject)dbCursor.next();
            Board board = (Board)this.mongoTemplate.getConverter().read(Board.class, (Object)document);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", board.getId());
            map.put("name", board.getName());
            map.put("key", board.getKey());
            if (PropertyValidator.isValid((Object)board.getWorkSpace())) {
                HashMap<String, String> workSpaceMap = new HashMap<String, String>();
                workSpaceMap.put("id", board.getWorkSpace().getId());
                workSpaceMap.put("title", board.getWorkSpace().getTitle());
                workSpaceMap.put("key", board.getWorkSpace().getKey());
                map.put("workSpace", workSpaceMap);
            }
            timelineResults.add(map);
        }
        return timelineResults;
    }

    private List<Session> fetchProgramBoardsBySessionIdsIn(List<ObjectId> sessionIds) {
        ArrayList<BasicDBObject> pipelines = new ArrayList<BasicDBObject>();
        BasicDBObject basicMatch = new BasicDBObject();
        basicMatch.append("_id", (Object)new BasicDBObject("$in", sessionIds));
        basicMatch.append("rowStatus", (Object)0);
        BasicDBObject finalMatchPipeline = new BasicDBObject("$match", (Object)basicMatch);
        pipelines.add(finalMatchPipeline);
        BasicDBObject lookupWorkspace = new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)"workSpace").append("localField", (Object)"workSpace.$id").append("foreignField", (Object)"_id").append("as", (Object)"workspace"));
        pipelines.add(lookupWorkspace);
        BasicDBObject unwindWorkspace = new BasicDBObject("$unwind", (Object)"$workspace");
        pipelines.add(unwindWorkspace);
        BasicDBObject matchWorkspaceRowStatus = new BasicDBObject("$match", (Object)new BasicDBObject("workspace.rowStatus", (Object)0));
        pipelines.add(matchWorkspaceRowStatus);
        BasicDBObject projectFields = new BasicDBObject("$project", (Object)new BasicDBObject("title", (Object)1).append("activeSessionBoard", (Object)1).append("id", (Object)1).append("workSpace", (Object)1).append("rowStatus", (Object)1));
        pipelines.add(projectFields);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.FALSE).build();
        Cursor dbCursor = collection.aggregate(pipelines, ao);
        ArrayList<Session> sessions = new ArrayList<Session>();
        while (dbCursor.hasNext()) {
            DBObject document = (DBObject)dbCursor.next();
            Session session = (Session)this.mongoTemplate.getConverter().read(Session.class, (Object)document);
            sessions.add(session);
        }
        return sessions;
    }

    private Map<String, Object> fetchWorkSpacesWithTimelines(List<String> workSpaceIds, List<Map<String, Object>> timelineResults, BacklogItem backlogItem) {
        HashMap<String, Object> workSpaceWithTimelines = new HashMap<String, Object>();
        List workSpacesFromDB = this.workSpaceRepository.findByIdInAndRowStatus(workSpaceIds, 0);
        if (PropertyValidator.isValid((Collection)workSpacesFromDB)) {
            List workSpaces = workSpacesFromDB.stream().map(workSpace -> {
                HashMap<String, Object> workSpaceMap = new HashMap<String, Object>();
                workSpaceMap.put("id", workSpace.getId());
                workSpaceMap.put("title", workSpace.getTitle());
                workSpaceMap.put("key", workSpace.getKey());
                List linkedTimelines = timelineResults.stream().filter(timeline -> {
                    Map timelineWorkSpace = (Map)timeline.get("workSpace");
                    return PropertyValidator.isValid((Object)timelineWorkSpace) && workSpace.getId().equals(timelineWorkSpace.get("id"));
                }).map(timeline -> {
                    HashMap timelineMap = new HashMap();
                    timelineMap.put("id", timeline.get("id"));
                    timelineMap.put("title", timeline.get("name"));
                    timelineMap.put("key", timeline.get("key"));
                    return timelineMap;
                }).collect(Collectors.toList());
                boolean hasLinkedItems = backlogItem.getItemRelations().stream().anyMatch(baseItemLink -> workSpace.getId().equals(baseItemLink.getReleaseTrainId()));
                workSpaceMap.put("linkedTimelines", linkedTimelines);
                workSpaceMap.put("hasLinkedItems", hasLinkedItems);
                return workSpaceMap;
            }).collect(Collectors.toList());
            workSpaceWithTimelines.put("linkedReleaseTrains", workSpaces);
        }
        return workSpaceWithTimelines;
    }

    private boolean addBacklogItemOnPiBoard(BacklogItem backlogItem, Session session, WorkSpace releaseTrain, Board board, AlmAccount almAccount) {
        if (almAccount == null || backlogItem.getAlmKey() == null) {
            return false;
        }
        List items = null;
        boolean isTFS = "tfs".equals(almAccount.getType());
        boolean isJIRA = "jira".equals(almAccount.getType());
        if (isTFS) {
            items = this.itemRepository.findBySessionBoardsIdInAndTfsId(session.getActiveSessionBoard(), backlogItem.getAlmItemId());
        } else if (isJIRA) {
            ArrayList<String> jids = new ArrayList<String>();
            jids.add(backlogItem.getAlmItemId());
            items = this.itemRepository.findBySessionBoardsIdInAndJiraIdIn(session.getActiveSessionBoard(), jids);
        }
        if (PropertyValidator.isValid(items)) {
            return false;
        }
        if (session.getItemsAddedFromKanban() == null) {
            session.setItemsAddedFromKanban(new ArrayList());
        }
        String almItemId = backlogItem.getAlmItemId();
        Object entry = session.getItemsAddedFromKanban().stream().filter(map -> {
            String _itemId = (String)map.get("itemId");
            if (_itemId != null) {
                return _itemId.equals(almItemId);
            }
            return false;
        }).findAny().orElse(null);
        if (entry == null) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("itemId", backlogItem.getAlmItemId());
            map2.put("itemTitle", backlogItem.getTitle());
            map2.put("itemUrl", backlogItem.getUrl());
            map2.put("itemKey", backlogItem.getAlmKey());
            if (isTFS) {
                if (backlogItem.getFields() != null) {
                    map2.put("itemProject", (String)backlogItem.getFields().get("tfsProjectId"));
                }
            } else if (isJIRA && backlogItem.getAlmFields() != null) {
                if (backlogItem.getAlmFields().get("project") != null) {
                    map2.put("itemProject", (String)((Map)backlogItem.getAlmFields().get("project")).get("key"));
                }
                if (backlogItem.getAlmFields().get("issuetype") != null) {
                    map2.put("issueTypeId", (String)((Map)backlogItem.getAlmFields().get("issuetype")).get("id"));
                }
            }
            map2.put("releaseTrainId", releaseTrain.getId());
            map2.put("releaseTrainTitle", releaseTrain.getTitle());
            if (PropertyValidator.isValid((Object)board)) {
                map2.put("boardId", board.getId());
                map2.put("boardName", board.getName());
            }
            session.getItemsAddedFromKanban().add(map2);
            this.sessionRepository.save((Object)session);
        }
        return true;
    }

    private void addItemFromCollectionToCollection(List<BacklogItem> items, String fromCollectionId, String toCollectionId, Boolean setParent, ArrayList<BacklogItem> itemsToSave) {
        ArrayList<String> childItemsIds = new ArrayList<String>();
        for (BacklogItem item : items) {
            List childLinks;
            List parentLinks;
            BaseItemLink currentReleaseTrainLink = (BaseItemLink)item.getArtRelationMap().get(fromCollectionId);
            item.linkToRTE(toCollectionId, currentReleaseTrainLink.getBacklogLevel());
            if (setParent.booleanValue() && PropertyValidator.isValid((Collection)(parentLinks = (List)item.getParentRelationMap().get(fromCollectionId)))) {
                for (BaseItemLink link : parentLinks) {
                    item.linkToParent(toCollectionId, link.getBacklogItemId().toString());
                }
            }
            if (PropertyValidator.isValid((Collection)(childLinks = (List)item.getChildRelationMap().get(fromCollectionId)))) {
                for (BaseItemLink link : childLinks) {
                    item.linkToChild(toCollectionId, link.getBacklogItemId().toString());
                    childItemsIds.add(link.getBacklogItemId().toString());
                }
            }
            itemsToSave.add(item);
        }
        if (PropertyValidator.isValid(childItemsIds)) {
            List nextLevelItems = this.backlogItemRepository.findByIdIn(childItemsIds);
            this.addItemFromCollectionToCollection(nextLevelItems, fromCollectionId, toCollectionId, Boolean.valueOf(true), itemsToSave);
        }
    }

    public Map<String, Object> moveKanbanItem(HashMap<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String newLaneId = (String)params.get("newLaneId");
        Boolean applyLane = false;
        if (params.containsKey("applyLane")) {
            applyLane = (Boolean)params.get("applyLane");
        }
        String metaMap = (String)params.get("metaMap");
        String itemId = (String)params.get("itemId");
        String boardId = (String)params.get("boardId");
        Double sequence = (Double)params.get("sequence");
        String statusId = (String)params.get("status");
        String sessionId = (String)params.get("session");
        String releaseTrainId = (String)params.get("releaseTrainId");
        String almAccountId = (String)params.get("almAccountId");
        String groupType = (String)params.get("groupType");
        String groupId = (String)params.get("groupId");
        if (groupType != null && groupType.equals("assignee") && groupId == null) {
            groupId = "";
        }
        String oldGroupId = (String)params.get("oldGroupId");
        String errorMessage = (String)params.get("errorMessage");
        String errorType = (String)params.get("errorType");
        String areaPath = null;
        if (params.containsKey("areaPath")) {
            areaPath = (String)params.get("areaPath");
        }
        String iterationPath = null;
        if (params.containsKey("iterationPath")) {
            iterationPath = (String)params.get("iterationPath");
        }
        ArrayList customValues = (ArrayList)params.get("customValues");
        BacklogItem backlogItem = this.backlogItemRepository.findById(itemId);
        List baseItemLinks = backlogItem.getRelations();
        Gson gson = new Gson();
        9 T = new /* Unavailable Anonymous Inner Class!! */;
        AlmAccount almAccount = null;
        if (PropertyValidator.isValid((Object)backlogItem.getAlmAccountId()) && PropertyValidator.isValid((Object)almAccountId)) {
            almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
        }
        if (PropertyValidator.isValid((Object)errorMessage)) {
            backlogItem.setShowError(Boolean.valueOf(true));
            AlmError almError = new AlmError();
            almError.setItemId(backlogItem.getId());
            almError.setDescription(errorMessage);
            almError.setType(errorType);
            if (PropertyValidator.isValid((Object)almAccount)) {
                almError.setUserName(almAccount.getUsername());
            }
            if (!PropertyValidator.isValid((Collection)backlogItem.getAlmErrors())) {
                backlogItem.setAlmErrors(new ArrayList());
            }
            backlogItem.getAlmErrors().add(almError);
        } else {
            backlogItem.setShowError(Boolean.valueOf(false));
        }
        backlogItem = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
        boolean updateStatusOnAlm = false;
        if (PropertyValidator.isValid((Collection)customValues)) {
            updateStatusOnAlm = true;
        }
        if (PropertyValidator.isValid((Object)areaPath)) {
            backlogItem.getFields().put("tfsAreaPath", areaPath);
            this.backlogItemRepository.save((Object)backlogItem);
            updateStatusOnAlm = true;
        }
        if (PropertyValidator.isValid((Object)iterationPath)) {
            backlogItem.getFields().put("tfsIterationPath", iterationPath);
            this.backlogItemRepository.save((Object)backlogItem);
            updateStatusOnAlm = true;
        }
        if (PropertyValidator.isValid((Object)groupType)) {
            if (groupType.equals("status") && PropertyValidator.isValid((Object)groupId)) {
                backlogItem.setStatus(new Status(groupId));
                updateStatusOnAlm = true;
            } else if (groupType.equals("parent")) {
                if (PropertyValidator.isValid((Object)oldGroupId)) {
                    BacklogItem oldParentItem = this.backlogItemRepository.findById(oldGroupId);
                    backlogItem.removeParentLink(releaseTrainId, oldGroupId);
                    if (PropertyValidator.isValid((Object)oldParentItem)) {
                        oldParentItem.removeChildLink(releaseTrainId, itemId);
                        this.backlogItemRepository.save((Object)oldParentItem);
                    }
                }
                if (PropertyValidator.isValid((Object)groupId)) {
                    BacklogItem newParentItem = this.backlogItemRepository.findById(groupId);
                    backlogItem.linkToParent(releaseTrainId, groupId);
                    if (PropertyValidator.isValid((Object)newParentItem)) {
                        newParentItem.linkToParent(releaseTrainId, itemId);
                        this.backlogItemRepository.save((Object)newParentItem);
                    }
                }
            } else if (groupType.equals("batches") && PropertyValidator.isValid((Object)groupId)) {
                backlogItem.linkToBatch(releaseTrainId, groupId);
                BaseItem baseItem = this.baseItemRepository.findById(groupId);
                if (PropertyValidator.isValid((Object)baseItem)) {
                    BaseItemLink baseItemLink = new BaseItemLink();
                    baseItemLink.setBaseItemId(backlogItem.getId());
                    baseItemLink.setReleaseTrainId(releaseTrainId);
                    baseItemLink.setLinkType("backLogItem");
                    baseItemLink = (BaseItemLink)this.baseItemLinkRepository.save((Object)baseItemLink);
                    if (!PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks())) {
                        baseItem.setBaseItemLinks(new ArrayList());
                    }
                    baseItem.getBaseItemLinks().add(baseItemLink);
                    this.baseItemRepository.save((Object)baseItem);
                }
            } else if (groupType.equals("milestones") && PropertyValidator.isValid((Object)groupId)) {
                backlogItem.linkToMilestone(releaseTrainId, groupId);
                BacklogItem milestone = this.backlogItemRepository.findById(groupId);
                if (PropertyValidator.isValid((Object)milestone)) {
                    String almType = "";
                    if (PropertyValidator.isValid((Object)almAccount)) {
                        almType = almAccount.getType();
                    }
                    milestone.linkToBacklogItem(releaseTrainId, backlogItem.getId(), backlogItem.getAlmItemId(), almType);
                    this.backlogItemRepository.save((Object)milestone);
                }
            } else if (groupType.equals("assignee")) {
                if (PropertyValidator.isValid((Object)almAccount)) {
                    if (almAccount.getType().equals("tfs")) {
                        Map assignee = (Map)params.get("groupData");
                        backlogItem.getFields().put("AssignedTo", assignee);
                        if (customValues == null) {
                            customValues = new ArrayList();
                        }
                        HashMap<String, String> customField = new HashMap<String, String>();
                        customField.put("customField", "System.AssignedTo");
                        customField.put("customValue", groupId);
                        customValues.add(customField);
                    } else if (almAccount.getType().equals("jira")) {
                        String assigneeString = (String)params.get("groupData");
                        HashMap assignee = (HashMap)gson.fromJson(assigneeString, T.getType());
                        backlogItem.getFields().put("assignee", assignee);
                    }
                    this.backlogItemRepository.save((Object)backlogItem);
                    updateStatusOnAlm = true;
                }
            } else if (groupType.equals("area-path") && PropertyValidator.isValid((Object)groupId)) {
                if (PropertyValidator.isValid((Object)backlogItem.getAlmAccountId()) && PropertyValidator.isValid((Object)almAccount) && almAccount.getType().equals("tfs")) {
                    backlogItem.getFields().put("tfsAreaPath", groupId);
                    this.backlogItemRepository.save((Object)backlogItem);
                    updateStatusOnAlm = true;
                }
            } else if (groupType.equals("iteration-path") && PropertyValidator.isValid((Object)groupId) && PropertyValidator.isValid((Object)backlogItem.getAlmAccountId()) && PropertyValidator.isValid((Object)almAccount) && almAccount.getType().equals("tfs")) {
                backlogItem.getFields().put("tfsIterationPath", groupId);
                this.backlogItemRepository.save((Object)backlogItem);
                updateStatusOnAlm = true;
            }
        }
        BaseItemLink oldLaneLink = null;
        for (BaseItemLink baseItemLink : baseItemLinks) {
            if (!baseItemLink.getLinkType().equals("KANBAN") || !baseItemLink.getKanbanId().equals(boardId)) continue;
            oldLaneLink = baseItemLink;
        }
        WorkSpace releaseTrain = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)releaseTrainId));
        Board board = (Board)this.boardRepository.findOne((Serializable)((Object)boardId));
        if (!board.getPlannedItems().contains(itemId)) {
            board.getPlannedItems().add(itemId);
            this.boardRepository.save((Object)board);
        }
        if (sequence != null) {
            BaseItemLink sequenceLink = null;
            for (BaseItemLink baseItemLink : baseItemLinks) {
                if (!baseItemLink.getLinkType().equals("KANBAN_SEQUENCE") || !baseItemLink.getKanbanId().equals(boardId)) continue;
                sequenceLink = baseItemLink;
            }
            if (sequenceLink == null) {
                sequenceLink = new BaseItemLink();
                sequenceLink.setKanbanId(boardId);
                sequenceLink.setReleaseTrainId(releaseTrainId);
                sequenceLink.setLinkType("KANBAN_SEQUENCE");
                if (!PropertyValidator.isValid((Collection)backlogItem.getRelations())) {
                    backlogItem.setRelations(new ArrayList());
                }
                backlogItem.getRelations().add(sequenceLink);
            }
            sequenceLink.setSequence(sequence);
        }
        boolean removedFromPrviousLane = false;
        if (PropertyValidator.isValid((Object)statusId) || PropertyValidator.isValid((Object)sessionId)) {
            if (oldLaneLink != null) {
                removedFromPrviousLane = true;
                this.removeKanbanLaneFromItem(backlogItem, oldLaneLink.getLaneId());
            }
            if (PropertyValidator.isValid((Object)statusId)) {
                Status updatedStatus = new Status(statusId);
                backlogItem.setStatus(updatedStatus);
                updateStatusOnAlm = true;
            }
            if (PropertyValidator.isValid((Object)sessionId)) {
                Session session = this.sessionRepository.findById(sessionId);
                if (PropertyValidator.isValid((Object)session)) {
                    List links;
                    BaseItemLink sessionLink = null;
                    if (PropertyValidator.isValid((Collection)backlogItem.getBoardRelations()) && PropertyValidator.isValid((Collection)(links = backlogItem.getBoardRelations()))) {
                        for (BaseItemLink link : links) {
                            if (!releaseTrainId.equals(link.getReleaseTrainId()) || !session.getId().equals(link.getSessionId())) continue;
                            sessionLink = link;
                            break;
                        }
                    }
                    if (sessionLink == null) {
                        backlogItem.linkToBoard(releaseTrainId, session.getActiveSessionBoard(), session.getId());
                    }
                    if (PropertyValidator.isValid((Collection)releaseTrain.getLinkedAlmAccounts())) {
                        almAccount = (AlmAccount)releaseTrain.getLinkedAlmAccounts().get(0);
                    }
                    if (PropertyValidator.isValid((Object)backlogItem.getAlmItemId()) && almAccount != null && almAccount.getType() != null) {
                        Object items = null;
                        boolean isTFS = "tfs".equals(almAccount.getType());
                        boolean isJIRA = "jira".equals(almAccount.getType());
                        if (isTFS) {
                            items = this.itemRepository.findBySessionBoardsIdInAndTfsId(session.getActiveSessionBoard(), backlogItem.getAlmItemId());
                        } else if (isJIRA) {
                            ArrayList<String> jids = new ArrayList<String>();
                            jids.add(backlogItem.getAlmItemId());
                            items = this.itemRepository.findBySessionBoardsIdInAndJiraIdIn(session.getActiveSessionBoard(), jids);
                        }
                        if (!PropertyValidator.isValid(items)) {
                            this.addBacklogItemOnPiBoard(backlogItem, session, releaseTrain, board, almAccount);
                        }
                    }
                    if (backlogItem.getAlmItemId() == null) {
                        this.saveKendisOnlyToPIboards(backlogItem, releaseTrainId, new ArrayList(), new ArrayList());
                    }
                } else {
                    AlmError almError = new AlmError();
                    almError.setItemId(backlogItem.getId());
                    almError.setDescription("Failed to Assign the Mapped Board or Lane");
                    almError.setReason("Board is not Deleted");
                    almError.setType("KANBAN_MAPPING");
                    if (!PropertyValidator.isValid((Collection)backlogItem.getAlmErrors())) {
                        backlogItem.setAlmErrors(new ArrayList());
                    }
                    backlogItem.getAlmErrors().add(almError);
                    backlogItem.setShowError(Boolean.valueOf(true));
                }
            }
        }
        Lane newLane = null;
        if (PropertyValidator.isValid((Object)newLaneId)) {
            if (applyLane.booleanValue()) {
                if (oldLaneLink == null) {
                    oldLaneLink = new BaseItemLink();
                    oldLaneLink.setKanbanId(boardId);
                    oldLaneLink.setItemId(itemId);
                    oldLaneLink.setLaneId(newLaneId);
                    oldLaneLink.setReleaseTrainId(releaseTrainId);
                    oldLaneLink.setLinkType("KANBAN");
                    if (!PropertyValidator.isValid((Collection)backlogItem.getRelations())) {
                        backlogItem.setRelations(new ArrayList());
                    }
                    backlogItem.getRelations().add(oldLaneLink);
                } else if (removedFromPrviousLane) {
                    backlogItem.getRelations().add(oldLaneLink);
                }
                oldLaneLink.setItemId(itemId);
                oldLaneLink.setLaneId(newLaneId);
            }
            if (PropertyValidator.isValid((Object)(newLane = (Lane)this.laneRepository.findOne((Serializable)((Object)newLaneId)))) && PropertyValidator.isValid((Collection)newLane.getOtherKanbanMappings())) {
                ArrayList backlogItemsToSave = new ArrayList();
                for (Map map : newLane.getOtherKanbanMappings()) {
                    int index;
                    Board _board;
                    String _releaseTrainId = (String)map.get("releaseTrainId");
                    String _newLaneId = (String)map.get("laneId");
                    String string = (String)map.get("boardId");
                    if (!releaseTrainId.equals(_releaseTrainId) && backlogItem.getArtRelationMap().get(_releaseTrainId) == null) {
                        ArrayList<BacklogItem> items = new ArrayList<BacklogItem>();
                        items.add(backlogItem);
                        this.addItemFromCollectionToCollection(items, releaseTrainId, _releaseTrainId, Boolean.valueOf(false), backlogItemsToSave);
                    }
                    if ((_board = (Board)this.boardRepository.findOne((Serializable)((Object)string))).getLinkedBacklogItems() == null) {
                        _board.setLinkedBacklogItems(new ArrayList());
                    }
                    if ((index = _board.getLinkedBacklogItems().indexOf(backlogItem.getId())) == -1) {
                        _board.getLinkedBacklogItems().add(backlogItem.getId());
                        this.boardRepository.save((Object)_board);
                    }
                    if (_newLaneId.equals("-1")) continue;
                    BaseItemLink _oldLaneLink = null;
                    List _baseItemLinks = backlogItem.getRelations();
                    for (BaseItemLink baseItemLink : _baseItemLinks) {
                        if (!baseItemLink.getLinkType().equals("KANBAN") || !baseItemLink.getKanbanId().equals(string)) continue;
                        _oldLaneLink = baseItemLink;
                    }
                    if (_oldLaneLink == null) {
                        _oldLaneLink = new BaseItemLink();
                        _oldLaneLink.setKanbanId(string);
                        _oldLaneLink.setItemId(backlogItem.getId());
                        _oldLaneLink.setLaneId(_newLaneId);
                        _oldLaneLink.setReleaseTrainId(_releaseTrainId);
                        _oldLaneLink.setLinkType("KANBAN");
                        if (!PropertyValidator.isValid((Collection)backlogItem.getRelations())) {
                            backlogItem.setRelations(new ArrayList());
                        }
                        backlogItem.getRelations().add(_oldLaneLink);
                    }
                    _oldLaneLink.setItemId(backlogItem.getId());
                    _oldLaneLink.setLaneId(_newLaneId);
                }
                if (PropertyValidator.isValid((Collection)backlogItemsToSave)) {
                    this.backlogItemRepository.save((Iterable)backlogItemsToSave);
                }
            }
        }
        backlogItem = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
        result.put("item", backlogItem);
        if (PropertyValidator.isValid((Object)newLane) && PropertyValidator.isValid((Collection)newLane.getOtherKanbanMappings())) {
            for (Map map : newLane.getOtherKanbanMappings()) {
                Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                JSONObject pushJson = new JSONObject();
                HashMap<String, Object> pushData = new HashMap<String, Object>();
                LOGGER.debug("========PUSH FROM KANBAN=========");
                LOGGER.debug("ITEM ID : " + backlogItem.getId());
                BacklogItem backlogItem2 = new BacklogItem();
                backlogItem2.setId(backlogItem.getId());
                pushData.put("item", backlogItem2);
                pushData.put("laneMapping", map);
                String itemStr = gsonExclusive.toJson(pushData);
                pushJson.put("data", (Object)itemStr);
                String metaMapStr = metaMap;
                pushJson.put("metaMap", (Object)metaMapStr);
                String pushContent = pushJson.toString();
                LOGGER.debug("PUSH CONTENT SIZE : " + pushContent.length());
                LOGGER.debug("PUSH CONTENT : " + pushContent);
                PushSender.sendMsg((String)pushContent);
            }
        }
        if (updateStatusOnAlm && PropertyValidator.isValid((Object)backlogItem.getAlmAccountId()) && PropertyValidator.isValid((Object)almAccountId)) {
            almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            BacklogItem finalItem = backlogItem;
            if (almAccount.getType().equals("tfs")) {
                HashMap itemMap = new HashMap();
                HashMap<String, Object> _params = new HashMap<String, Object>();
                _params.put("almAccount", almAccount);
                _params.put("releaseTrainId", releaseTrainId);
                _params.put("update", Boolean.TRUE);
                if (PropertyValidator.isValid(customValues)) {
                    ArrayList tfsFields = new ArrayList();
                    for (Map map : customValues) {
                        HashMap tfsField = new HashMap();
                        tfsField.put("key", map.get("customField"));
                        tfsField.put("value", map.get("customValue"));
                        tfsFields.add(tfsField);
                    }
                    itemMap.put("tfsFields", tfsFields);
                }
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            } else {
                HashMap _metaMap = (HashMap)gson.fromJson(metaMap, T.getType());
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
        }
        return result;
    }

    public Map<String, Object> removeKanbanLaneFromItem(String itemId, String laneId, String kanbanId, Double sequence) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)itemId)) {
            BacklogItem backlogItem = this.backlogItemRepository.findById(itemId);
            if (PropertyValidator.isValid((Object)backlogItem)) {
                boolean isRemoved = this.removeKanbanLaneFromItem(backlogItem, laneId);
                this.updateItemSequence(backlogItem, kanbanId, sequence);
                if (isRemoved) {
                    Board board = (Board)this.boardRepository.findOne((Serializable)((Object)kanbanId));
                    if (board.getPlannedItems().contains(itemId)) {
                        board.getPlannedItems().remove(itemId);
                        board = (Board)this.boardRepository.save((Object)board);
                    }
                    backlogItem.setShowError(Boolean.valueOf(false));
                    this.backlogItemRepository.save((Object)backlogItem);
                }
            }
            result.put("item", backlogItem);
        }
        return result;
    }

    public Map<String, Object> removeBoardFromItem(String itemId, List<String> boardsToRemove) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BacklogItem item = (BacklogItem)this.backlogItemRepository.findOne((Serializable)((Object)itemId));
        if (PropertyValidator.isValid((Object)item)) {
            HashMap<String, String> boardsToRemoveMap = new HashMap<String, String>();
            for (String board : boardsToRemove) {
                boardsToRemoveMap.put(board, board);
            }
            if (PropertyValidator.isValid((Collection)item.getBoardRelations())) {
                block1: for (int i = 0; i < item.getBoardRelations().size(); ++i) {
                    Session session;
                    BaseItemLink relation = (BaseItemLink)item.getBoardRelations().get(i);
                    if (!boardsToRemoveMap.containsKey(relation.getSessionId())) continue;
                    item.getBoardRelations().remove(i);
                    --i;
                    if (!PropertyValidator.isValid((Object)item.getAlmItemId()) || !PropertyValidator.isValid((Object)(session = this.sessionRepository.findById(relation.getSessionId()))) || !PropertyValidator.isValid((Collection)session.getItemsAddedFromKanban())) continue;
                    for (int j = 0; j < session.getItemsAddedFromKanban().size(); ++j) {
                        Map itemRef = (Map)session.getItemsAddedFromKanban().get(j);
                        if (!((String)itemRef.get("itemId")).equals(item.getAlmItemId())) continue;
                        session.getItemsAddedFromKanban().remove(j);
                        this.sessionRepository.save((Object)session);
                        continue block1;
                    }
                }
                item = (BacklogItem)this.backlogItemRepository.save((Object)item);
            }
            result.put("success", true);
            result.put("item", item);
        } else {
            result.put("success", false);
        }
        return result;
    }

    private Boolean removeKanbanLaneFromItem(BacklogItem backlogItem, String laneId) {
        List baseItemLinks = backlogItem.getRelations();
        boolean result = false;
        if (PropertyValidator.isValid((Collection)baseItemLinks)) {
            for (int i = 0; i < baseItemLinks.size(); ++i) {
                BaseItemLink currentBaseItemLink = (BaseItemLink)baseItemLinks.get(i);
                if (!currentBaseItemLink.getLinkType().equals("KANBAN") || !PropertyValidator.isValid((Object)currentBaseItemLink.getLaneId()) || !currentBaseItemLink.getLaneId().equals(laneId)) continue;
                baseItemLinks.remove(i);
                result = true;
                break;
            }
            backlogItem.setRelations(baseItemLinks);
        }
        return result;
    }

    private void updateItemSequence(BacklogItem backlogItem, String kanbanId, Double sequence) {
        List baseItemLinks = backlogItem.getRelations();
        if (PropertyValidator.isValid((Collection)baseItemLinks) && PropertyValidator.isValid((Object)kanbanId) && PropertyValidator.isValid((Object)sequence)) {
            for (int i = 0; i < baseItemLinks.size(); ++i) {
                BaseItemLink currentBaseItemLink = (BaseItemLink)baseItemLinks.get(i);
                if (!currentBaseItemLink.getLinkType().equals("KANBAN_SEQUENCE") || !currentBaseItemLink.getKanbanId().equals(kanbanId)) continue;
                currentBaseItemLink.setSequence(sequence);
                break;
            }
            backlogItem.setRelations(baseItemLinks);
        }
    }

    private JiraIssue updateJiraStatus(String jiraId, Status jiraStatus, AlmAccount alm) throws Exception {
        JiraIssue issue = null;
        boolean applySelectedStatus = false;
        try {
            issue = this.almSyncService.retrieveJiraIssueById(jiraId, alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), alm);
            if (jiraStatus != null && jiraStatus.getJiraStatusId() != null && PropertyValidator.isValid((Object)issue) && PropertyValidator.isValid((Object)issue.getFields().getStatus()) && !issue.getFields().getStatus().getId().equals(jiraStatus.getJiraStatusId())) {
                applySelectedStatus = true;
            }
        }
        catch (ViztrendJiraException e) {
            LOGGER.error("update Jira Status --> Failed to reterieve jira issue. AFTER CREATE|UPDATE");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        if (applySelectedStatus) {
            List transitions;
            JiraTransition transition = null;
            if (PropertyValidator.isValid((Object)jiraId) && PropertyValidator.isValid((Collection)(transitions = this.almSyncService.retrieveTransitionsByIssueId(jiraId, alm, alm.getUsernameForApi(), alm.getPasswordForApi())))) {
                for (JiraTransition trans : transitions) {
                    if (!trans.getTo().getId().equals(jiraStatus.getJiraStatusId())) continue;
                    transition = trans;
                    break;
                }
            }
            if (transition != null) {
                try {
                    String response = this.exportUtil.doTransitionInJira(transition.getId(), jiraId, alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), alm, Boolean.valueOf(false));
                    issue.getFields().setStatus(transition.getTo());
                    LOGGER.info("update Jira Status --> postTransitionToJira response from ALM::" + response);
                }
                catch (ViztrendJiraException e) {
                    LOGGER.error("update Jira Status --> Failed to postTransitionToJira ");
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    issue.setError(e);
                }
            } else {
                issue.setError(new ViztrendJiraException(Integer.valueOf(0), "Transition to selected Status is not possible In Jira. Please select status according to workflow in Jira.", new AlmError()));
            }
        }
        return issue;
    }

    private AlmAccount getJiraLoginForApi(AlmAccount alm, User loggedInUser) {
        AlmAccUser almAccUser = this.planServiceImpl.getUserAlmCredntials(alm.getId(), loggedInUser);
        alm.setUsernameForApi("");
        alm.setPasswordForApi("");
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                alm.setJiraOauthToken(almAccUser.getJiraOauthToken());
                alm.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                alm.setJiraOauthToken(null);
                alm.setUsernameForApi(almAccUser.getAlmUsername());
                alm.setPasswordForApi(almAccUser.getAlmPassword());
            }
            alm.setIsTaggedUser(Boolean.valueOf(true));
        } else {
            alm.setUsernameForApi(alm.getUsername());
            alm.setPasswordForApi(alm.getPassword());
            alm.setAdminAlmAcc(Boolean.valueOf(true));
        }
        alm.setOAuthTokenOwnerUserId(loggedInUser.getId());
        return alm;
    }

    public void linkMultipleInJira(ResyncParamsVO param) {
        if (PropertyValidator.isValid((Collection)param.jiraIssuesChild) && PropertyValidator.isValid((Collection)param.items)) {
            ArrayList errors = new ArrayList();
            Item parent = (Item)param.items.get(0);
            param.almConfigurations.setAlmAccount(this.almAccountRepository.findById(param.almConfigurations.getAlmAccount().getId()));
            parent.setSessionBoards((List)new /* Unavailable Anonymous Inner Class!! */);
            ((SessionBoard)parent.getSessionBoards().get(0)).setSession(new Session());
            ((SessionBoard)parent.getSessionBoards().get(0)).getSession().setAlmConfigurations((List)new /* Unavailable Anonymous Inner Class!! */);
            this.planServiceImpl.addJiraItemAsChild((Collection)param.jiraIssuesChild, (Item)param.items.get(0), (JiraIssueLinkType)((List)param.links.get("-")).get(0), null, errors);
        }
    }

    public void saveInJira(String releaseTrainId, BacklogItem backlogItem, Map<String, Object> metaMap, AlmAccount alm, User loggedInUser) {
        boolean updated = false;
        Gson gson = new Gson();
        Item item = (Item)gson.fromJson((String)metaMap.get("jiraJson"), Item.class);
        String jiraId = null;
        String jiraKey = null;
        String jiraUrl = null;
        ViztrendJiraException error = null;
        try {
            HashMap<String, String> jiraJson = new HashMap<String, String>();
            List parents = null;
            BacklogItem parent = null;
            if (backlogItem.getParentRelationMap() != null && (parents = (List)backlogItem.getParentRelationMap().get(releaseTrainId)).iterator().hasNext()) {
                parent = this.backlogItemRepository.findById(String.valueOf(((BaseItemLink)parents.iterator().next()).getBacklogItemId()));
            }
            jiraId = item.getJiraId();
            jiraKey = item.getJiraKey();
            boolean editMode = PropertyValidator.isValid((Object)jiraId);
            boolean createLink = false;
            alm = this.getJiraLoginForApi(alm, loggedInUser);
            jiraJson.put("AlmAccountId", alm.getId());
            JiraIssueLinkType linkType = item.getLinkType();
            if (PropertyValidator.isValid((Object)linkType) && PropertyValidator.isValid((Object)parent)) {
                if ("+1".equals(linkType.getJiraId())) {
                    jiraJson.put(alm.getJiraEpicLinkClause(), parent.getAlmKey());
                } else if (PropertyValidator.isValid((Object)linkType.getJiraId()) && linkType.getJiraId().indexOf("parent") > -1) {
                    jiraJson.put(item.getLinkType().getJiraId(), parent.getAlmKey());
                } else if (PropertyValidator.isValid((Object)linkType.getJiraId()) && linkType.getJiraId().indexOf("customfield_") > -1) {
                    jiraJson.put(linkType.getJiraId(), parent.getAlmKey());
                } else {
                    createLink = true;
                }
            }
            String response = "";
            if (editMode) {
                jiraJson.put("almAccount", (String)alm);
                response = this.exportUtil.updateIssueInJira(jiraId, alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), jiraJson, item.getJiraFieldMap(), false);
            } else {
                jiraJson.put("almAccount", (String)alm);
                if (Boolean.TRUE.equals(metaMap.get("convertingKendisToAlm")) && backlogItem.getDescription() != null) {
                    jiraJson.put("description", JiraUtils.convertHtmlJiraMarkup((String)backlogItem.getDescription()));
                }
                if (PropertyValidator.isValid((Object)(response = this.exportUtil.createJiraIssue(alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), jiraJson, item.getJiraFieldMap())))) {
                    try {
                        JSONObject responseObj = new JSONObject(response);
                        jiraId = responseObj.getString("id");
                        jiraKey = responseObj.getString("key");
                        jiraUrl = responseObj.getString("self");
                        this.setBasicJiraInfoBackLogItem(backlogItem, jiraId, jiraKey, jiraUrl, alm);
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        throw e;
                    }
                }
            }
            JiraIssue issue = this.updateJiraStatus(jiraId, item.getStatus(), alm);
            if (issue != null) {
                this.almErrorRepository.deleteByItemId(backlogItem.getId());
                JiraStatus jiraStatus = issue.getFields().getStatus();
                JiraIssue2 copy = new JiraIssue2(issue);
                copy.getFields().put(JiraField.FIXED.status.name(), gson.fromJson(gson.toJson((Object)jiraStatus), Map.class));
                Status staus = jiraStatus.parseStatus(issue.getFields().getProject().getKey(), issue.getFields().getIssuetype().getId(), alm, loggedInUser, this.statusRepository);
                this.updateBackLogItemLatestFromJira(backlogItem, copy, staus, alm, item.getJiraFieldByKey());
                updated = true;
                if (createLink) {
                    if ("IN".equals(linkType.getDirection())) {
                        this.exportUtil.createJiraIssueLink(parent.getAlmItemId(), jiraId, item.getLinkType().getId(), alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), alm);
                    } else if (!PropertyValidator.isValid((Object)item.getLinkType().getJiraId()) || !item.getLinkType().getJiraId().contains("customfield_")) {
                        this.exportUtil.createJiraIssueLink(jiraId, parent.getAlmItemId(), item.getLinkType().getId(), alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), alm);
                    }
                }
                error = issue.getError();
            }
        }
        catch (ViztrendJiraException e) {
            List jiraFields;
            error = e;
            if (jiraId != null && jiraId != null && (jiraFields = item.getJiraFieldMap()) != null) {
                if (backlogItem.getFields() == null) {
                    backlogItem.setFields(new HashMap());
                }
                for (ItemJiraFieldMap field : jiraFields) {
                    try {
                        backlogItem.getFields().put(field.getKey(), gson.fromJson(field.getValue(), Object.class));
                    }
                    catch (Exception exception) {}
                }
            }
            updated = true;
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        if (error != null) {
            if (error.getAlmError() != null) {
                error.getAlmError().setDescription(error.getMessage());
                error.getAlmError().setCreatedBy(loggedInUser.getUserName());
            }
            String json = gson.toJson((Object)error);
            backlogItem.getFields().put("AlmSyncError", true);
            backlogItem.getFields().put("AlmErrorMessage", json);
            updated = true;
        }
        if (updated) {
            BacklogItem backlogItem1 = (BacklogItem)this.backlogItemRepository.save((Object)backlogItem);
            SecureUser secureUser = UserContextUtil.getUserContext();
            if (PropertyValidator.isValid((Object)secureUser)) {
                HashMap<String, Object> responseMap = new HashMap<String, Object>();
                responseMap.put("releaseTrainId", "isJira");
                responseMap.put("isJira", true);
                responseMap.put("cid", secureUser.getCurrentCompanyId());
                responseMap.put("item_updated", backlogItem1);
                responseMap.put("metaMap", metaMap);
                KendisUtils.pushProgressUpdates((String)"ResyncProgress", (String)"xyz", responseMap, (PushResponseRepository)this.pushResponseRepository, (boolean)true);
            }
        }
    }

    public void removeJiraParentChildLink(String releaseTrainId, BacklogItem backlogItem, Map<String, Object> metaMap, AlmAccount alm, User loggedInUser) {
        block5: {
            alm = this.getJiraLoginForApi(alm, loggedInUser);
            alm.setUsername(alm.getUsernameForApi());
            alm.setPassword(alm.getPasswordForApi());
            Object jiraIssue = null;
            try {
                List links = (List)backlogItem.getParentRelationMap().get(releaseTrainId);
                ArrayList<String> ids = new ArrayList<String>();
                for (BaseItemLink link : links) {
                    backlogItem.removeParentLink(releaseTrainId, link.getBacklogItemId().toString());
                    ids.add(String.valueOf(link.getBaseItemId()));
                }
                List parents = this.backlogItemRepository.findByIdIn(ids);
                if (!PropertyValidator.isValid((Collection)parents)) break block5;
                ArrayList lids = new ArrayList();
                if (backlogItem.getAlmItemId() != null) {
                    // empty if block
                }
                for (BacklogItem parent : parents) {
                    parent.removeChildLink(releaseTrainId, backlogItem.getId());
                    if (!PropertyValidator.isValid((Object)parent.getAlmItemId())) continue;
                }
                parents.add(backlogItem);
                this.backlogItemRepository.save((Iterable)parents);
            }
            catch (Exception e) {
                if (e instanceof ViztrendJiraException) break block5;
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
    }

    public Map<String, Object> removeParentFromItem(String itemId, String releaseTrainId, String hierarchyLevelId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        try {
            BacklogItem item;
            block14: {
                item = this.backlogItemRepository.findById(itemId);
                if (item == null) {
                    result.put("error", true);
                    result.put("message", "Item not found");
                    return result;
                }
                String oldParentId = null;
                if (item.getParentRelationMap() != null && item.getParentRelationMap().containsKey(releaseTrainId) && !((List)item.getParentRelationMap().get(releaseTrainId)).isEmpty()) {
                    oldParentId = ((BaseItemLink)((List)item.getParentRelationMap().get(releaseTrainId)).get(0)).getBacklogItemId().toString();
                }
                if (oldParentId == null) {
                    result.put("error", true);
                    result.put("message", "Item does not have a parent in this collection");
                    return result;
                }
                BacklogItem oldParent = this.backlogItemRepository.findById(oldParentId);
                item.removeParentLink(releaseTrainId, oldParentId);
                if (PropertyValidator.isValid((Object)oldParent)) {
                    AlmAccount almAccount;
                    if (PropertyValidator.isValid((Object)oldParent.getChildRelationMap()) && PropertyValidator.isValid((Collection)((Collection)oldParent.getChildRelationMap().get(releaseTrainId)))) {
                        ((List)oldParent.getChildRelationMap().get(releaseTrainId)).removeIf(link -> link.getBacklogItemId().toString().equals(item.getId()));
                    }
                    this.backlogItemRepository.save((Object)oldParent);
                    result.put("oldParent", oldParent);
                    if (PropertyValidator.isValid((Object)oldParent.getAlmItemId()) && PropertyValidator.isValid((Object)item.getAlmItemId()) && PropertyValidator.isValid((Object)(almAccount = this.almAccountRepository.findById(item.getAlmAccountId())))) {
                        try {
                            if (PropertyValidator.isValid((Object)almAccount.getType()) && almAccount.getType().equals("tfs")) {
                                this.tfsService.removeRelationInTFS(item.getAlmItemId(), oldParent.getAlmItemId(), almAccount);
                                break block14;
                            }
                            if (!PropertyValidator.isValid((Object)almAccount.getType()) || !almAccount.getType().equals("jira")) break block14;
                            HierarchyLevel level = (HierarchyLevel)this.hierarchyLevelRepository.findOne((Serializable)((Object)hierarchyLevelId));
                            List almTypeLevels = level.getAlmHierarchyLevelMappings();
                            for (AlmHierarchyLevelMapping mapping : almTypeLevels) {
                                if (!mapping.getAlmAccountId().equals(almAccount.getId())) continue;
                                almAccount = this.getJiraLoginForApi(almAccount, loggedInUser);
                                almAccount.setUsername(almAccount.getUsernameForApi());
                                almAccount.setPassword(almAccount.getPasswordForApi());
                                JiraIssue2 jiraIssue = this.almSyncService.retrieveJiraIssue(item.getAlmItemId(), almAccount);
                                this.exportUtil.removeParenChildLinkInJira(item.getAlmItemId(), oldParent.getAlmItemId(), oldParent.getAlmKey(), jiraIssue, null, (Collection)mapping.getLinkTypes(), almAccount, almAccount.getUsernameForApi(), almAccount.getPasswordForApi(), loggedInUser);
                                break;
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof ViztrendJiraException) {
                                ViztrendJiraException error = (ViztrendJiraException)((Object)e);
                                if (error.getAlmError() != null) {
                                    error.getAlmError().setDescription(error.getMessage());
                                    error.getAlmError().setCreatedBy(loggedInUser.getUserName());
                                }
                                Gson gson = new Gson();
                                String json = gson.toJson((Object)error);
                                item.getFields().put("AlmSyncError", true);
                                item.getFields().put("AlmErrorMessage", json);
                            }
                            LOGGER.error("Could not remove TFS relation: ");
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                    }
                }
            }
            this.backlogItemRepository.save((Object)item);
            result.put("success", true);
            result.put("item", item);
            result.put("message", "Parent link removed successfully");
        }
        catch (Exception e) {
            LOGGER.error("Error removing parent from item: ");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            result.put("error", true);
            result.put("message", "Error occurred while removing parent: " + e.getMessage());
        }
        return result;
    }

    public void setBasicJiraInfoBackLogItem(BacklogItem backlogItem, String jiraId, String jiraKey, String url, AlmAccount alm) {
        if (!PropertyValidator.isValid((Object)backlogItem.getAlmItemId())) {
            backlogItem.setAlmItemId(jiraId);
            backlogItem.setAlmKey(jiraKey);
            backlogItem.setUrl(url.split("/rest")[0] + "/browse/" + jiraKey);
            backlogItem.setAlmAccountId(alm.getId());
            this.customRepositoryImpl.savePartialBacklog(backlogItem);
            if (PropertyValidator.isValid((Object)jiraKey)) {
                this.planServiceImpl.updateJiraKeyInLogs(backlogItem.getId(), jiraKey, jiraId);
            }
        }
    }

    public ResyncParamsVO updateBackLogItemLatestFromJira(BacklogItem backlogItem, JiraIssue2 issue, Status status, AlmAccount alm, Map<String, Object> skippedFields) {
        if (backlogItem != null) {
            if (status != null) {
                backlogItem.setStatus(status);
            }
            issue.setGeneratedKendisId(backlogItem.getId());
        }
        List levels = this.almHierarchyLevelMappingRepository.findByAlmAccountId(alm.getId());
        ResyncParamsVO syncUitls = new ResyncParamsVO();
        syncUitls.almConfigurations = new AlmConfigurations();
        syncUitls.filter = new JiraFilter();
        this.almSyncService.setupMetaForResync(syncUitls, alm);
        if (skippedFields != null) {
            if (alm.getStoryPointField() != null && Boolean.TRUE.equals(skippedFields.get(alm.getStoryPointField().getId()))) {
                alm.setStoryPointField(null);
            }
            if (alm.getNextGenStoryPointField() != null && Boolean.TRUE.equals(skippedFields.get(alm.getNextGenStoryPointField().getId()))) {
                alm.setNextGenStoryPointField(null);
            }
            if (alm.getDueDateField() != null && Boolean.TRUE.equals(skippedFields.get(alm.getDueDateField().getId()))) {
                alm.setDueDateField(null);
            }
            if (alm.getStartDateField() != null && Boolean.TRUE.equals(skippedFields.get(alm.getStartDateField().getId()))) {
                alm.setStartDateField(null);
            }
            if (alm.getEndDateField() != null && Boolean.TRUE.equals(skippedFields.get(alm.getEndDateField().getId()))) {
                alm.setEndDateField(null);
            }
        }
        for (AlmHierarchyLevelMapping lvl : levels) {
            List saved = lvl.getJiraFields();
            if (saved == null) continue;
            for (HashMap map : saved) {
                String fieldId = (String)map.get("id");
                syncUitls.fields.add(new JiraField(fieldId, fieldId, fieldId));
            }
        }
        if (backlogItem != null) {
            backlogItem = issue.fillBackLogItem(UserContextUtil.getUserContext().getCurrentCompanyId(), backlogItem, syncUitls.fields, alm, null, null);
        }
        return syncUitls;
    }

    static /* synthetic */ TFSservice access$000(RTItemOperationsServiceImpl x0) {
        return x0.tfsService;
    }

    static /* synthetic */ ReleaseTrainService access$100(RTItemOperationsServiceImpl x0) {
        return x0.releaseTrainService;
    }

    static /* synthetic */ AlmAccountRepository access$200(RTItemOperationsServiceImpl x0) {
        return x0.almAccountRepository;
    }
}

