/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.service.AppInitConfigService;
import com.viztrend.safe.service.ProxyService;
import com.viztrend.safe.utils.StringUtils;
import java.net.URI;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ProxyServiceImpl
implements ProxyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyServiceImpl.class);
    private final RestTemplate restTemplate;
    private final AppInitConfigService appInitConfigService;

    @Autowired
    public ProxyServiceImpl(RestTemplate restTemplate, AppInitConfigService appInitConfigService) {
        this.restTemplate = restTemplate;
        this.appInitConfigService = appInitConfigService;
    }

    public ResponseEntity<byte[]> proxyRequest(String body, HttpMethod method, HttpServletRequest request) {
        try {
            AppInitConfig appInitConfig = this.appInitConfigService.getAppInitConfig();
            if (appInitConfig == null || appInitConfig.getExportServerUrl() == null) {
                throw new IllegalArgumentException("Export server url is not defined in app init config. Cannot proceed.");
            }
            URI uri = new URI(appInitConfig.getExportServerUrl());
            HttpHeaders headers = new HttpHeaders();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                headers.set(headerName, request.getHeader(headerName));
            }
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.remove((Object)"X-CSRF-TOKEN");
            headers.remove((Object)"X-Requested-With");
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            LOGGER.debug("Proxying request to PDF EXPORT SERVER: {}", (Object)uri);
            ResponseEntity serverResponse = this.restTemplate.exchange(uri, method, httpEntity, byte[].class);
            HttpHeaders browserHeaders = new HttpHeaders();
            browserHeaders.setContentType(serverResponse.getHeaders().getContentType());
            browserHeaders.setContentDispositionFormData("attachment", "output.pdf");
            browserHeaders.setContentLength(serverResponse.getHeaders().getContentLength());
            return new ResponseEntity(serverResponse.getBody(), (MultiValueMap)browserHeaders, serverResponse.getStatusCode());
        }
        catch (RestClientException e) {
            LOGGER.error("Error proxying request to export server: {}", (Object)StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.BAD_GATEWAY);
        }
        catch (Exception e) {
            LOGGER.error("Error proxying request: {}", (Object)StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

