/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.common.collect.Sets;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ExportUtil;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.JiraIssue2;
import com.viztrend.safe.alm.jira.bo.JiraIssueLink;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.alm.jira.bo.JiraSprint;
import com.viztrend.safe.alm.jira.bo.JiraStatus;
import com.viztrend.safe.alm.jira.bo.JiraTransition;
import com.viztrend.safe.alm.jira.bo.JiraVersion;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.enums.EnumActivityType;
import com.viztrend.safe.enums.EnumPermission;
import com.viztrend.safe.enums.EnumRTModules;
import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.BacklogMapping;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.CollaborationType;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Counters;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Role;
import com.viztrend.safe.persistence.entity.ScoreCard;
import com.viztrend.safe.persistence.entity.ScoreParam;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Sprint;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.StatsExclusion;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.StatusCategory;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserBoardPreferences;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.AlmErrorRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.CollaborationTypeRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemSyncMapperRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.JiraFieldRepository;
import com.viztrend.safe.persistence.repository.JiraIssueRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.persistence.repository.JiraRepository;
import com.viztrend.safe.persistence.repository.JiraSprintRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.RoleRepository;
import com.viztrend.safe.persistence.repository.ScoreCardRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SprintRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StatsExclusionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.UserBoardPreferenceRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WebhookItemRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.PlanServiceImpl;
import com.viztrend.safe.service.ScoreCardService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmErrorUtils;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.FilterActionsVO;
import com.viztrend.safe.vos.SearchVO;
import com.viztrend.safe.vos.SessionBoardVo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;

@Component(value="planService")
@Transactional
class PlanServiceImpl
implements PlanService {
    @Autowired
    private ItemLogRepository itemLogRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private WebhookItemRepository webhookItemRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private ScoreCardRepository scoreCardRepository;
    @Autowired
    private ItemSyncMapperRepository itemSyncMapperRepository;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private ItemLinkTypeRepository itemLinkTypeRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private ALMSyncService almService;
    @Autowired
    private JiraFieldRepository jiraFieldRepository;
    @Autowired
    private JiraIssueRepository jiraIssueRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private SprintRepository sprintRepository;
    @Autowired
    private CustomRepository<?> customRepository;
    @Autowired
    private ExportUtil exportUtil;
    @Autowired
    private JiraRepository<Serializable> jiraRepository;
    @Autowired
    private AlmConfigurationsRepository almConfigRepository;
    @Autowired
    private AlmErrorRepository almErrorRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private JiraSprintRepository jiraSprintRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    private ImportUtil importUtil;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    UserBoardPreferenceRepository userBoardPreferenceRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private TFSservice tfsService;
    @Autowired
    private StatsExclusionRepository statsExclusionRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private ScoreCardService scoreCardService;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private CollaborationTypeRepository collaborationTypeRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanServiceImpl.class);
    List<StatusCategory> stCats = null;
    boolean resyncData = false;

    PlanServiceImpl() {
    }

    public List<Item> getAllItems() {
        return this.itemRepository.findAll();
    }

    private void pushAlmError(String log, ViztrendJiraException e, Item item, SessionBoard sessionBoard, User loggedInUser, Boolean isStatusErr) {
        if (log != null) {
            LOGGER.warn("Failed to save jira issue.");
            LOGGER.error(log, (Object)StringUtils.getTraceString((Throwable)e));
        }
        item.setErrorInAlmSync(Boolean.valueOf(true));
        item.setAlmErrorMessage(e.getMessage());
        this.itemRepository.save((Object)item);
        if (sessionBoard != null) {
            this.almErrorRepository.save((Object)AlmErrorUtils.buildAlmErrorObj((Item)item, (String)sessionBoard.getId(), (User)loggedInUser, (ViztrendJiraException)e, (Boolean)isStatusErr));
            PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)item, (String)sessionBoard.getId(), (String)"AlmError", (String)e.getMessage(), (Boolean)false, (Boolean)false));
        }
    }

    private void pushAlmErrors(ViztrendJiraException e, List<Item> items, SessionBoard sessionBoard, User loggedInUser) {
        if (sessionBoard != null) {
            ArrayList<AlmError> errors = new ArrayList<AlmError>();
            ArrayList<ObjectId> itemIds = new ArrayList<ObjectId>();
            for (Item item : items) {
                errors.add(AlmErrorUtils.buildAlmErrorObj(null, (String)sessionBoard.getId(), (User)loggedInUser, (ViztrendJiraException)e, (Boolean)false));
                itemIds.add(new ObjectId(item.getId()));
                ((AlmError)errors.get(errors.size() - 1)).setItem(item);
                JSONObject pushJson = new JSONObject();
                AlmErrorUtils.fillPushJson((JSONObject)pushJson, (Item)item, (String)sessionBoard.getId(), (String)"AlmError", (String)e.getMessage());
                PushSender.sendMsg((String)pushJson.toString());
            }
            this.almErrorRepository.save(errors);
            this.customRepositoryImpl.updateAlmErrorFlagBulk(itemIds, true);
        }
    }

    public SessionBoardVo saveSessionBoard(String sessionBoardJson) {
        LOGGER.trace("INSIDE saveSession");
        Gson gson = new Gson();
        SessionBoardVo sbVo = (SessionBoardVo)gson.fromJson(sessionBoardJson, SessionBoardVo.class);
        SessionBoard sessionBoard = null;
        if (PropertyValidator.isValid((Object)sbVo)) {
            if (sbVo.getId() == null) {
                sessionBoard = new SessionBoard();
                sessionBoard.setTeams(this.teamRepository.save((Iterable)sbVo.getTeams()));
                sessionBoard.setContainers(this.containerRepository.save((Iterable)sbVo.getContainers()));
                sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
            } else {
                sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sbVo.getId()));
            }
        }
        return sbVo;
    }

    public UserBoardPreferences savePreferrence(UserBoardPreferences boardPref) throws Exception {
        UserBoardPreferences userBoardPreferences = this.userBoardPreferenceRepository.findByUserIdAndSessionId(boardPref.getUserId(), boardPref.getSessionId());
        if (PropertyValidator.isValid((Object)userBoardPreferences)) {
            this.userBoardPreferenceRepository.delete((Object)userBoardPreferences);
        } else {
            this.userBoardPreferenceRepository.save((Object)boardPref);
        }
        return boardPref;
    }

    public SessionBoardVo saveSession(String sessionBoardJson) {
        LOGGER.trace("INSIDE saveSession");
        Gson gson = new Gson();
        SessionBoardVo sbVo = (SessionBoardVo)gson.fromJson(sessionBoardJson, SessionBoardVo.class);
        SessionBoard sessionBoard = null;
        if (PropertyValidator.isValid((Object)sbVo)) {
            if (sbVo.getId() == null) {
                sessionBoard = new SessionBoard();
                sessionBoard.setTeams(sbVo.getTeams());
                sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
            } else {
                sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sbVo.getId()));
            }
        }
        HashMap<String, Container> sprintTeamIdMap = new HashMap<String, Container>();
        List containers = sbVo.getContainers();
        if (PropertyValidator.isValid((Collection)containers)) {
            for (Container cont : containers) {
                if (cont.getTempId() != null && cont.getTempId().equals(cont.getId())) {
                    String tmpId = cont.getTempId();
                    cont.setId(null);
                    cont = (Container)this.containerRepository.save((Object)cont);
                    sprintTeamIdMap.put(tmpId, cont);
                    continue;
                }
                sprintTeamIdMap.put(cont.getId(), cont);
            }
        }
        sessionBoard.setContainers(containers);
        sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
        List itemSyncMapper = sbVo.getItemSyncMapper();
        if (PropertyValidator.isValid((Collection)itemSyncMapper)) {
            for (ItemSyncMapper tsm : itemSyncMapper) {
                tsm.setSessionBoard(sessionBoard);
                Container containr = (Container)sprintTeamIdMap.get(tsm.getContainer().getId());
                if (PropertyValidator.isValid((Object)containr)) {
                    tsm.setContainer(containr);
                }
                this.itemSyncMapperRepository.save((Object)tsm);
            }
        }
        sbVo.setSessionBoard(sessionBoard);
        sbVo.setId(sessionBoard.getId());
        sbVo.setContainers(containers);
        sbVo.setItemSyncMapper(itemSyncMapper);
        this.convertJiraIssuesAccordingToMapping(sbVo, null, null);
        return sbVo;
    }

    public Map<String, Status> convertJiraStatusToKendis(String sessionBoardId, String projectKey) {
        SessionBoardVo sbVo = new SessionBoardVo(sessionBoardId);
        sbVo.setSessionBoard((SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId)));
        return this.convertJiraStatusToKendis(sbVo.getSessionBoard().getSession(), projectKey);
    }

    protected Map<String, Status> getStatusMap(String sessionBoardId) {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        List dbStatusList = this.statusRepository.findBySessionId(sessionBoard.getSession().getId());
        return this.convertStatusListToMap(dbStatusList, sessionBoard.getSession().getId());
    }

    private Map<String, Status> convertJiraStatusToKendis(Session session, String projectKey) {
        ArrayList<Status> convertedStatuses = new ArrayList<Status>();
        String featureTye = "Feature";
        String storyType = "UserStory";
        LOGGER.trace("INSIDE convertJiraStatusToKendis");
        List dbStatusList = this.statusRepository.findBySessionId(session.getId());
        Map stMap = this.convertStatusListToMap(dbStatusList, session.getId());
        AlmAccount almAcc = ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount();
        List issueTypes = this.importUtil.retrieveJiraStatuses(projectKey, almAcc.getUrl(), almAcc.getUsername(), almAcc.getPassword(), almAcc);
        if (PropertyValidator.isValid((Collection)issueTypes)) {
            for (JiraIssueType jissType : issueTypes) {
                if (jissType.getStatuses() == null) continue;
                for (JiraStatus jStatsus : jissType.getStatuses()) {
                    Status lvl1Status = new Status();
                    lvl1Status.setSuspendActivity(true);
                    lvl1Status.setJiraProjKey(projectKey);
                    lvl1Status.setJiraIssueTypeId(jissType.getId());
                    lvl1Status.setJiraStatusCatId(jStatsus.getStatusCategory().getId());
                    lvl1Status.setJiraStatusId(jStatsus.getId());
                    lvl1Status.setTitle(jStatsus.getName());
                    lvl1Status.setItemType(featureTye);
                    lvl1Status.setCategory(AlmUtils.getMappedStatusCategory((String)jStatsus.getStatusCategory().getKey()));
                    lvl1Status.setJiraStatusOriginalCategory(AlmUtils.getMappedStatusCategory((String)jStatsus.getStatusCategory().getKey()));
                    lvl1Status.setSessionId(session.getId());
                    String key = session.getId() + "_" + lvl1Status.getJiraProjKey() + "_" + lvl1Status.getItemType() + "_" + lvl1Status.getJiraIssueTypeId() + "_" + lvl1Status.getJiraStatusId();
                    if (stMap.get(key) == null) {
                        convertedStatuses.add(lvl1Status);
                        stMap.put(key, lvl1Status);
                    }
                    Status lvl2Status = new Status(lvl1Status);
                    lvl2Status.setItemType(storyType);
                    lvl2Status.setSuspendActivity(true);
                    lvl2Status.setSessionId(session.getId());
                    key = session.getId() + "_" + lvl2Status.getJiraProjKey() + "_" + lvl2Status.getItemType() + "_" + lvl2Status.getJiraIssueTypeId() + "_" + lvl2Status.getJiraStatusId();
                    if (stMap.get(key) != null) continue;
                    convertedStatuses.add(lvl2Status);
                    stMap.put(key, lvl2Status);
                }
            }
        }
        if (PropertyValidator.isValid(convertedStatuses)) {
            this.statusRepository.save(convertedStatuses);
        }
        return stMap;
    }

    private String getMappedStatusCategory(String key) {
        if (key != null) {
            if (key.equalsIgnoreCase("indeterminate")) {
                return EnumStatusCategory.INPROGRESS.getCode();
            }
            if (key.equalsIgnoreCase("done")) {
                return EnumStatusCategory.DONE.getCode();
            }
            if (key.equalsIgnoreCase("undefined")) {
                return EnumStatusCategory.OPEN.getCode();
            }
            return EnumStatusCategory.OPEN.getCode();
        }
        return EnumStatusCategory.OPEN.getCode();
    }

    private List<Item>[] convertJiraIssuesAccordingToMapping(SessionBoardVo sbVo, IssueType issueType, List<JiraIssueLinkType> linkTypes) {
        JiraField dueDateField;
        JiraField storyPointField;
        LOGGER.trace("INSIDE convertJiraIssuesAccordingToMapping");
        AlmAccount almAccount = ((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getAlmAccount();
        JiraField jspField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-sprint", almAccount.getId());
        if (!PropertyValidator.isValid((Object)jspField)) {
            this.almSyncService.retrieveJiraFields(almAccount, null);
            jspField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-sprint", almAccount.getId());
        }
        if (!PropertyValidator.isValid((Object)(storyPointField = almAccount.getStoryPointField()))) {
            storyPointField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountId("Story Points", almAccount.getId());
        }
        if (!PropertyValidator.isValid((Object)(dueDateField = almAccount.getDueDateField()))) {
            dueDateField = this.jiraFieldRepository.findByJiraIdIgnoreCaseAndAlmAccountId("duedate", almAccount.getId());
        }
        int startAt = 0;
        Map statusMap = this.getStatusMap(sbVo.getSessionBoard().getId());
        ArrayList<String> parentItems = new ArrayList<String>();
        HashSet<String> featuresAlreadyProcessed = new HashSet<String>();
        Double sysSequence = new Double(System.nanoTime() / 100000L);
        boolean done = false;
        ArrayList savedItems = new ArrayList();
        ArrayList<ObjectId> jiraIssueids = new ArrayList<ObjectId>();
        int page = 0;
        Set<Object> jiraKeysOfStoriesAdded = new HashSet();
        if (sbVo.getFromAddExisting().booleanValue()) {
            ArrayList<SessionBoard> boards = new ArrayList<SessionBoard>();
            boards.add(sbVo.getSessionBoard());
            List existingJiraKeys = this.itemRepository.findBySessionBoardsInAndJiraKeyNotNullAndType(boards, Item.USER_STORY);
            if (PropertyValidator.isValid((Collection)existingJiraKeys)) {
                jiraKeysOfStoriesAdded = existingJiraKeys.stream().map(Item::getJiraKey).collect(Collectors.toSet());
            }
            if (!PropertyValidator.isValid(jiraKeysOfStoriesAdded)) {
                jiraKeysOfStoriesAdded = new HashSet();
            }
        }
        while (!done) {
            ArrayList<Item> pagedSavedItems = new ArrayList<Item>();
            LOGGER.trace("startAt: " + startAt);
            Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "itemTypeTobeConvertedInto")});
            PageRequest pageable = new PageRequest(page, 100, sort);
            Page jiraItems = this.jiraIssueRepository.findByConvertedToItemAndSessionBoardIdOrderByItemTypeTobeConvertedInto(Boolean.FALSE, sbVo.getSessionBoard().getId(), (Pageable)pageable);
            LOGGER.trace("TotalItems = " + jiraItems.getTotalElements());
            if (PropertyValidator.isValid((Collection)jiraItems.getContent())) {
                for (JiraIssue jIssue : jiraItems.getContent()) {
                    Item tmpItem;
                    jiraIssueids.add(new ObjectId(jIssue.getMongoId()));
                    sysSequence = sysSequence + 1000.0;
                    if (!"Feature".equals(jIssue.getItemTypeTobeConvertedInto())) {
                        if (jiraKeysOfStoriesAdded.contains(jIssue.getKey())) {
                            jIssue.setConvertedToItem(Boolean.valueOf(true));
                            continue;
                        }
                        tmpItem = new Item();
                        tmpItem.setSuspendActivity(true);
                        tmpItem.setTitle(jIssue.getFields().getSummary());
                        tmpItem.setType(Item.USER_STORY);
                        tmpItem.setJiraId(jIssue.getId());
                        tmpItem.setJiraKey(jIssue.getKey());
                        tmpItem.setJiraProjectKey(jIssue.getFields().getProject().getKey());
                        tmpItem.setJiraIssueTypeId(jIssue.getFields().getIssuetype().getId());
                        tmpItem.setJiraIssueType(jIssue.getFields().getIssuetype());
                        String stKey = sbVo.getSessionBoard().getSession().getId() + "_" + jIssue.getFields().getProject().getKey() + "_UserStory_" + jIssue.getFields().getIssuetype().getId() + "_" + jIssue.getFields().getStatus().getId();
                        tmpItem.setStatus((Status)statusMap.get(stKey));
                        try {
                            Double storyPoint = (Double)jIssue.getMapFields().get(storyPointField.getJiraId());
                            tmpItem.setStoryPoints(storyPoint);
                        }
                        catch (Exception storyPoint) {
                            // empty catch block
                        }
                        ArrayList tmpJsprints = (ArrayList)jIssue.getMapFields().get(jspField.getJiraId());
                        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
                        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                        sessionBoards.add(sbVo.getSessionBoard());
                        tmpItem.setSessionBoards(sessionBoards);
                        Item parentFeature = this.itemRepository.findByJiraIdAndSessionBoards(jIssue.getJiraParentId(), sbVo.getSessionBoard());
                        ArrayList<TeamContainer> parentTeamCont = null;
                        if (!PropertyValidator.isValid((Object)parentFeature)) {
                            LOGGER.info("Parent not found : " + jIssue.toString());
                            jIssue.setConvertedToItem(Boolean.valueOf(true));
                            continue;
                        }
                        parentFeature.setSuspendActivity(true);
                        parentTeamCont = parentFeature.getTeamContainers();
                        if (!PropertyValidator.isValid((Collection)parentTeamCont)) {
                            parentTeamCont = new ArrayList<TeamContainer>();
                        }
                        if (PropertyValidator.isValid((Collection)tmpJsprints)) {
                            LOGGER.trace("Sprints to map: " + tmpJsprints.toString());
                            boolean activeFound = false;
                            JiraSprint activeJsp = null;
                            JiraSprint jsp = null;
                            try {
                                for (String sp : tmpJsprints) {
                                    jsp = JiraUtils.parseStrForJsprint((String)sp);
                                    if (jsp == null || "CLOSED".equalsIgnoreCase(jsp.getState())) continue;
                                    activeFound = true;
                                    activeJsp = jsp;
                                }
                            }
                            catch (ClassCastException e) {
                                ArrayList tmpJsprintsMap = (ArrayList)jIssue.getMapFields().get(jspField.getJiraId());
                                for (LinkedHashMap sp : tmpJsprintsMap) {
                                    jsp = JiraUtils.parseStrForJsprint((LinkedHashMap)sp);
                                    if (jsp == null || "CLOSED".equalsIgnoreCase(jsp.getState())) continue;
                                    activeFound = true;
                                    activeJsp = jsp;
                                }
                            }
                            if (activeFound) {
                                jsp = activeJsp;
                            }
                            if (jsp != null) {
                                if (!PropertyValidator.isValid((Object)tmpItem.getMapJiraFields())) {
                                    tmpItem.setMapJiraFields(new HashMap());
                                }
                                tmpItem.getMapJiraFields().put("sprint", jsp);
                                List sessionSyncMapper = this.itemSyncMapperRepository.findBySessionBoardAndTenantAndArchive(sbVo.getSessionBoard(), parentFeature.getTenant(), false);
                                ItemSyncMapper destinationSyncMapper = null;
                                if (PropertyValidator.isValid((Collection)sessionSyncMapper)) {
                                    for (ItemSyncMapper itemSyncMapper : sessionSyncMapper) {
                                        if (!PropertyValidator.isValid((Object)itemSyncMapper.getSprint()) || jsp.getId() == null || !jsp.getId().equalsIgnoreCase(itemSyncMapper.getSprint().getJiraId())) continue;
                                        destinationSyncMapper = itemSyncMapper;
                                        break;
                                    }
                                    if (PropertyValidator.isValid(destinationSyncMapper)) {
                                        for (TeamContainer ptc : parentTeamCont) {
                                            if (!ptc.getTeam().equals((Object)destinationSyncMapper.getTeam()) || !ptc.getContainer().equals((Object)destinationSyncMapper.getContainer())) continue;
                                            teamContainers.add(ptc);
                                            break;
                                        }
                                        if (!PropertyValidator.isValid(teamContainers)) {
                                            TeamContainer newTsp = new TeamContainer(destinationSyncMapper.getTeam(), destinationSyncMapper.getContainer());
                                            newTsp.setSuspendActivity(true);
                                            newTsp.setSource(1);
                                            newTsp = (TeamContainer)this.teamContainerRepository.save((Object)newTsp);
                                            teamContainers.add(newTsp);
                                            parentTeamCont.add(newTsp);
                                        }
                                    }
                                }
                            }
                        }
                        LOGGER.trace("Setting TeamContainers: DONE ");
                        tmpItem.setTeamContainers(teamContainers);
                        parentFeature.setTeamContainers(parentTeamCont);
                        this.itemRepository.save((Object)parentFeature);
                        tmpItem.setParent(parentFeature);
                        jIssue.setConvertedToItem(Boolean.valueOf(true));
                        tmpItem.setSequence(sysSequence);
                        tmpItem.setBacklogSequence(sysSequence);
                        pagedSavedItems.add(tmpItem);
                        jiraKeysOfStoriesAdded.add(tmpItem.getJiraKey());
                        continue;
                    }
                    if (!featuresAlreadyProcessed.contains(jIssue.getKey())) {
                        tmpItem = new Item();
                        tmpItem.setSuspendActivity(true);
                        tmpItem.setTitle(jIssue.getFields().getSummary());
                        if (PropertyValidator.isValid((Object)jIssue.getItemTypeTobeConvertedInto())) {
                            tmpItem.setType(jIssue.getItemTypeTobeConvertedInto());
                        } else {
                            tmpItem.setType(Item.FEATURE);
                        }
                        tmpItem.setJiraId(jIssue.getJiraId());
                        tmpItem.setJiraKey(jIssue.getKey());
                        tmpItem.setJiraProjectKey(jIssue.getFields().getProject().getKey());
                        tmpItem.setLinkTypes(linkTypes);
                        tmpItem.setJiraIssueType(jIssue.getFields().getIssuetype());
                        tmpItem.setIsEnabler(jIssue.getIsEnabler());
                        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                        sessionBoards.add(sbVo.getSessionBoard());
                        tmpItem.setSessionBoards(sessionBoards);
                        String stKey = sbVo.getSessionBoard().getSession().getId() + "_" + jIssue.getFields().getProject().getKey() + "_Feature_" + jIssue.getFields().getIssuetype().getId() + "_" + jIssue.getFields().getStatus().getId();
                        tmpItem.setStatus((Status)statusMap.get(stKey));
                        tmpItem.setJiraIssueTypeId(jIssue.getFields().getIssuetype().getId());
                        if (PropertyValidator.isValid(jIssue.getMapFields().get(dueDateField.getJiraId()))) {
                            tmpItem.setDueDate(PropertyValidator.parseDate((String)((String)jIssue.getMapFields().get(dueDateField.getJiraId())), (String)"yyyy-MM-dd"));
                        }
                        if (PropertyValidator.isValid((Object)issueType)) {
                            tmpItem.setIssueType(issueType);
                        }
                        tmpItem.setSequence(sysSequence);
                        tmpItem.setBacklogSequence(sysSequence);
                        tmpItem = (Item)this.itemRepository.save((Object)tmpItem);
                        parentItems.add(tmpItem.getId());
                        featuresAlreadyProcessed.add(tmpItem.getJiraKey());
                    }
                    jIssue.setConvertedToItem(Boolean.valueOf(true));
                }
                savedItems.addAll(this.itemRepository.save(pagedSavedItems));
            } else {
                done = true;
            }
            if (jiraItems.getTotalPages() != 0 && ++page != jiraItems.getTotalPages()) continue;
            break;
        }
        if (PropertyValidator.isValid(jiraIssueids)) {
            this.customRepository.setJiraIssueConvertedToItem(jiraIssueids, true);
        }
        LOGGER.trace("Leaving convertJiraIssuesAccordingToMapping");
        List parents = this.itemRepository.findByIdIn(parentItems);
        ArrayList[] result = new ArrayList[]{parents, savedItems, new ArrayList()};
        return result;
    }

    private Boolean applyTeamContainers(ItemSyncMapper tsm, List<TeamContainer> parentTeamCont, List<TeamContainer> teamContainers, Double sysSequence, Boolean isVersion) {
        Boolean sprintAssigned = false;
        for (TeamContainer ptc : parentTeamCont) {
            if (!ptc.getTeam().equals((Object)tsm.getTeam()) || !ptc.getContainer().equals((Object)tsm.getContainer())) continue;
            teamContainers.add(ptc);
            if (isVersion.booleanValue()) break;
            sprintAssigned = true;
            break;
        }
        if (!PropertyValidator.isValid(teamContainers)) {
            TeamContainer newTsp = new TeamContainer(tsm.getTeam(), tsm.getContainer());
            newTsp.setSuspendActivity(true);
            newTsp.setSequence(sysSequence);
            newTsp = (TeamContainer)this.teamContainerRepository.save((Object)newTsp);
            teamContainers.add(newTsp);
            parentTeamCont.add(newTsp);
            if (!isVersion.booleanValue()) {
                sprintAssigned = true;
            }
        }
        return sprintAssigned;
    }

    private void putSprintInJSON(Map<String, Object> updateJson, String sprintId, String almId) {
        JSONObject sprint = new JSONObject();
        this.exportUtil.putSprintInJSON(sprint, sprintId, almId);
        Set keys = sprint.keySet();
        for (String key : keys) {
            if (!sprint.has(key)) continue;
            updateJson.put(key, sprint.get(key));
        }
    }

    public List<Item> convertJiraIssueToLvl2Item(List<JiraIssue> jiraItems, Item parent, JiraIssueLinkType linkType, TeamContainer teamContainer) {
        LOGGER.trace("INSIDE convertJiraIssueToLvl2Item");
        AlmConfigurations almConfigurations = (AlmConfigurations)((SessionBoard)parent.getSessionBoards().get(0)).getSession().getAlmConfigurations().get(0);
        JiraField storyPointField = almConfigurations.getAlmAccount().getStoryPointField();
        if (!PropertyValidator.isValid((Object)storyPointField)) {
            storyPointField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountId("Story Points", almConfigurations.getAlmAccount().getId());
        }
        Map statusMap = this.getStatusMap(((SessionBoard)parent.getSessionBoards().get(0)).getId());
        ArrayList<Item> savedItems = new ArrayList<Item>();
        Double sysSequence = new Double(System.nanoTime() / 100000L);
        AlmAccount almAccount = almConfigurations.getAlmAccount();
        if (PropertyValidator.isValid(jiraItems)) {
            User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
            almAccount = this.getJiraLoginForApi((SessionBoard)parent.getSessionBoards().get(0), loggedInUser);
            String almUsername = almAccount.getUsernameForApi();
            String almPassword = almAccount.getPasswordForApi();
            ArrayList<ItemJiraFieldMap> extraFields = null;
            if (PropertyValidator.isValid((Collection)almConfigurations.getTeamMappings()) && PropertyValidator.isValid((Object)teamContainer)) {
                extraFields = new ArrayList<ItemJiraFieldMap>();
                for (BacklogMapping bm : almConfigurations.getTeamMappings()) {
                    if (!bm.getTeamId().equals(teamContainer.getTeam().getId()) || !PropertyValidator.isValid((Collection)bm.getJiraFieldMap())) continue;
                    for (ItemJiraFieldMap ijf : bm.getJiraFieldMap()) {
                        extraFields.add(ijf);
                    }
                }
            }
            ArrayList<String> jiraProjectKeys = new ArrayList<String>();
            for (JiraIssue jIssue : jiraItems) {
                jiraProjectKeys.add(jIssue.getFields().getProject().getKey());
            }
            List jiraProjectIssueTypes = this.jiraProjectIssueTypesRepository.findProjectStyleByAlmAccountIdAndJiraProjectKeyIn(almAccount.getId(), jiraProjectKeys);
            HashMap jiraProjectStylesByKey = new HashMap();
            if (PropertyValidator.isValid((Collection)jiraProjectIssueTypes)) {
                jiraProjectIssueTypes.forEach(issueType -> jiraProjectStylesByKey.put(issueType.getJiraProjectKey(), issueType.getStyle()));
            }
            ItemJiraFieldMap flaggedField = ((SessionBoard)parent.getSessionBoards().get(0)).getSession().getJiraFlaggedField();
            ArrayList<Item> stories = new ArrayList<Item>();
            for (JiraIssue jIssue : jiraItems) {
                sysSequence = sysSequence + 1000.0;
                if (!Item.USER_STORY.equals(jIssue.getItemTypeTobeConvertedInto())) continue;
                Item tmpItem = new Item();
                tmpItem.setSuspendActivity(true);
                tmpItem.setTitle(jIssue.getFields().getSummary());
                tmpItem.setType(jIssue.getItemTypeTobeConvertedInto());
                tmpItem.setJiraId(jIssue.getId());
                tmpItem.setJiraKey(jIssue.getKey());
                tmpItem.setSequence(sysSequence);
                tmpItem.setJiraProjectKey(jIssue.getFields().getProject().getKey());
                tmpItem.setJiraIssueTypeId(jIssue.getFields().getIssuetype().getId());
                String stKey = ((SessionBoard)parent.getSessionBoards().get(0)).getSession().getId() + "_" + jIssue.getFields().getProject().getKey() + "_UserStory_" + jIssue.getFields().getIssuetype().getId() + "_" + jIssue.getFields().getStatus().getId();
                if (statusMap.get(stKey) != null) {
                    tmpItem.setStatus((Status)statusMap.get(stKey));
                } else {
                    LOGGER.debug("convertJiraIssueToLvl2Item --> It seems we have pulled a new project. Lets go fetch statuses");
                    statusMap = this.convertJiraStatusToKendis(((SessionBoard)parent.getSessionBoards().get(0)).getSession(), jIssue.getFields().getProject().getKey());
                    tmpItem.setStatus((Status)statusMap.get(stKey));
                }
                try {
                    if (PropertyValidator.isValid(jiraProjectStylesByKey) && jiraProjectStylesByKey.containsKey(tmpItem.getJiraProjectKey()) && PropertyValidator.isValid(jiraProjectStylesByKey.get(tmpItem.getJiraProjectKey())) && "next-gen".equals(jiraProjectStylesByKey.get(tmpItem.getJiraProjectKey())) && PropertyValidator.isValid((Object)almAccount.getNextGenStoryPointField())) {
                        storyPointField = almAccount.getNextGenStoryPointField();
                    }
                    Double storyPoint = (Double)jIssue.getMapFields().get(storyPointField.getJiraId());
                    tmpItem.setStoryPoints(storyPoint);
                }
                catch (Exception storyPoint) {
                    // empty catch block
                }
                ArrayList<Object> teamContainers = new ArrayList<Object>();
                ArrayList sessionBoards = new ArrayList();
                sessionBoards.add(parent.getSessionBoards().get(0));
                tmpItem.setSessionBoards(sessionBoards);
                parent.setSuspendActivity(true);
                ItemSyncMapper tsm = null;
                if (PropertyValidator.isValid((Object)teamContainer)) {
                    TeamContainer newTsp;
                    List parentTeamCont = parent.getTeamContainers();
                    tsm = this.itemSyncMapperRepository.findByTeamAndContainer(teamContainer.getTeam(), teamContainer.getContainer());
                    if (PropertyValidator.isValid((Object)tsm)) {
                        for (Object ptc : parentTeamCont) {
                            if (!ptc.getTeam().equals((Object)tsm.getTeam()) || !ptc.getContainer().equals((Object)tsm.getContainer())) continue;
                            teamContainers.add(ptc);
                            break;
                        }
                        if (!PropertyValidator.isValid(teamContainers)) {
                            newTsp = new TeamContainer(tsm.getTeam(), tsm.getContainer());
                            newTsp.setSuspendActivity(true);
                            newTsp.setSequence(sysSequence);
                            newTsp = (TeamContainer)this.teamContainerRepository.save((Object)newTsp);
                            teamContainers.add(newTsp);
                            parentTeamCont.add(newTsp);
                        }
                    } else {
                        for (Object ptc : parentTeamCont) {
                            if (!ptc.getTeam().equals((Object)teamContainer.getTeam()) || !ptc.getContainer().equals((Object)teamContainer.getContainer())) continue;
                            teamContainers.add(ptc);
                            break;
                        }
                        if (!PropertyValidator.isValid(teamContainers)) {
                            newTsp = new TeamContainer(teamContainer.getTeam(), teamContainer.getContainer());
                            newTsp.setSuspendActivity(true);
                            newTsp.setSequence(sysSequence);
                            newTsp = (TeamContainer)this.teamContainerRepository.save((Object)newTsp);
                            teamContainers.add(newTsp);
                            parentTeamCont.add(newTsp);
                        }
                    }
                    tmpItem.setTeamContainers(teamContainers);
                    tmpItem.applySprintDates(((SessionBoard)parent.getSessionBoards().get(0)).getSession(), null, null);
                    parent.setTeamContainers(parentTeamCont);
                }
                if (PropertyValidator.isValid((Object)linkType)) {
                    try {
                        if (!PropertyValidator.isValid((Collection)parent.getLinkTypes())) {
                            parent.setLinkTypes(new ArrayList());
                        }
                        HashSet<JiraIssueLinkType> linkSet = new HashSet<JiraIssueLinkType>(parent.getLinkTypes());
                        linkSet.add(JiraUtils.reverseJiraLinkDirection((JiraIssueLinkType)linkType));
                        parent.setLinkTypes(new ArrayList(linkSet));
                    }
                    catch (Exception linkSet) {
                        // empty catch block
                    }
                }
                tmpItem.setParent(parent);
                if (PropertyValidator.isValid((Object)parent.getJiraFilter()) && !parent.getJiraFilter().contains("AddExisting")) {
                    tmpItem.setJiraFilter(parent.getJiraFilter());
                }
                jIssue.setConvertedToItem(Boolean.valueOf(true));
                tmpItem.setJiraFieldMap(extraFields);
                if (PropertyValidator.isValid((Object)flaggedField)) {
                    ArrayList fieldArray = (ArrayList)jIssue.getMapFields().get(flaggedField.getKey());
                    ArrayList jobjects = new ArrayList();
                    if (PropertyValidator.isValid((Collection)fieldArray)) {
                        Object ptc;
                        ptc = fieldArray.iterator();
                        while (ptc.hasNext()) {
                            LinkedTreeMap fieldValue = (LinkedTreeMap)ptc.next();
                            String value = (String)fieldValue.get((Object)"id");
                            HashMap<String, String> jobj = new HashMap<String, String>();
                            jobj.put("id", value);
                            jobjects.add(jobj);
                        }
                        if (PropertyValidator.isValid(jobjects)) {
                            Gson gson = new Gson();
                            ItemJiraFieldMap itemField = new ItemJiraFieldMap(flaggedField.getKey(), gson.toJson(jobjects), flaggedField.getType());
                            if (!PropertyValidator.isValid((Collection)tmpItem.getJiraFieldMap())) {
                                tmpItem.setJiraFieldMap(new ArrayList());
                            }
                            tmpItem.getJiraFieldMap().add(itemField);
                            tmpItem.setFlagged(flaggedField.getIsFlagged());
                        }
                    }
                }
                savedItems.add((Item)this.itemRepository.save((Object)tmpItem));
                if (PropertyValidator.isValid((Object)parent)) {
                    List childItems = this.itemRepository.findByParentId(parent.getId());
                    Double totalEstimate = 0.0;
                    for (Item childItem : childItems) {
                        totalEstimate = totalEstimate + childItem.getStoryPoints();
                    }
                    this.customRepository.updateItemStoryPoints(parent.getId(), totalEstimate);
                    parent.setSubItemEstimate(totalEstimate);
                }
                parent = (Item)this.itemRepository.save((Object)parent);
                List extra = null;
                HashMap<String, Object> updateJson = new HashMap<String, Object>();
                HashMap<String, String> nextGenJson = new HashMap<String, String>();
                if (PropertyValidator.isValid((Object)tsm) && PropertyValidator.isValid((Object)tsm.getSprint()) && PropertyValidator.isValid((Object)tsm.getSprint().getJiraId())) {
                    if (tsm.getSprint().getIsVersion().booleanValue()) {
                        updateJson.put("fixVersions", tsm.getSprint().getJiraId());
                    } else {
                        this.putSprintInJSON(updateJson, tsm.getSprint().getJiraId(), almAccount.getId());
                    }
                }
                if (PropertyValidator.isValid((Object)parent.getJiraId())) {
                    if (((SessionBoard)parent.getSessionBoards().get(0)).getSession().getJiraSynapseRTEnabled().booleanValue()) {
                        this.exportUtil.deleteParentRequirementFromSynapseRT(tmpItem.getJiraKey(), almAccount);
                        this.exportUtil.addChildRequirementToSynapseRT(parent.getJiraKey(), tmpItem.getJiraKey(), almAccount);
                    } else {
                        if ("+1".equals(linkType.getJiraId())) {
                            updateJson.put(almAccount.getJiraEpicLinkClause(), parent.getJiraKey());
                        } else if (PropertyValidator.isValid((Object)linkType.getJiraId()) && linkType.getJiraId().indexOf("parent") > -1) {
                            nextGenJson.put("parent", parent.getJiraKey());
                        } else if (PropertyValidator.isValid((Object)linkType.getJiraId()) && linkType.getJiraId().indexOf("customfield_") > -1) {
                            updateJson.put(linkType.getJiraId(), parent.getJiraKey());
                        } else if ("IN".equals(linkType.getDirection())) {
                            this.exportUtil.createJiraIssueLink(parent.getJiraId(), tmpItem.getJiraId(), linkType.getId(), almAccount.getUrl(), almUsername, almPassword, almAccount);
                        } else {
                            this.exportUtil.createJiraIssueLink(tmpItem.getJiraId(), parent.getJiraId(), linkType.getId(), almAccount.getUrl(), almUsername, almPassword, almAccount);
                        }
                        if (PropertyValidator.isValid((Collection)tmpItem.getJiraFieldMap())) {
                            extra = tmpItem.getJiraFieldMap();
                        }
                    }
                }
                try {
                    if (!nextGenJson.isEmpty()) {
                        this.saveNextGenParent(tmpItem, nextGenJson, (SessionBoard)parent.getSessionBoards().get(0), almAccount, loggedInUser, false);
                    }
                    if (!updateJson.isEmpty()) {
                        updateJson.put("AlmAccountId", almAccount.getId());
                        updateJson.put("almAccount", almAccount);
                        updateJson.put("project", tmpItem.getJiraProjectKey());
                        updateJson.put("projectKey", tmpItem.getJiraProjectKey());
                        updateJson.put("issuetype", tmpItem.getJiraIssueTypeId());
                        if (PropertyValidator.isValid((Object)((SessionBoard)parent.getSessionBoards().get(0)).getSession())) {
                            updateJson.put("notifyUsers", ((SessionBoard)parent.getSessionBoards().get(0)).getSession().getNotifyJiraUsers());
                        }
                        this.exportUtil.updateIssueInJira(tmpItem.getJiraId(), almAccount.getUrl(), almUsername, almPassword, updateJson, extra, false);
                    }
                }
                catch (ViztrendJiraException e) {
                    this.pushAlmError("Creating Link ALM:: FAILED.. error message saved in item.", e, tmpItem, (SessionBoard)tmpItem.getSessionBoards().get(0), loggedInUser, Boolean.valueOf(false));
                }
                KendisUtils.addChanges((boolean)false, (boolean)true, (Item)tmpItem, null);
                stories.add(tmpItem);
            }
            this.jiraIssueRepository.save(jiraItems);
            if (PropertyValidator.isValid(stories)) {
                this.customRepositoryImpl.bulkLogs(((SessionBoard)parent.getSessionBoards().get(0)).getId(), stories, null, null, almAccount.getTenant());
            }
        }
        LOGGER.trace("Leaving convertJiraIssueToLvl2Item");
        return savedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> addJiraItemAsChild(Collection<JiraIssue> jiraItems, Item parent, JiraIssueLinkType linkType, TeamContainer teamContainer, List<ViztrendJiraException> errors) {
        LOGGER.trace("INSIDE linkExistingJiraIssueAsChild");
        HashMap<String, Object> ids = new HashMap<String, Object>();
        Double sysSequence = new Double(System.nanoTime() / 100000L);
        SessionBoard board = (SessionBoard)parent.getSessionBoards().get(0);
        AlmConfigurations config = (AlmConfigurations)board.getSession().getAlmConfigurations().get(0);
        AlmAccount almAccount = config.getAlmAccount();
        if (PropertyValidator.isValid(jiraItems)) {
            User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
            almAccount = this.getJiraLoginForApi(board, loggedInUser);
            String almUsername = almAccount.getUsernameForApi();
            String almPassword = almAccount.getPasswordForApi();
            ItemSyncMapper tsm = null;
            List extra = null;
            if (PropertyValidator.isValid((Object)teamContainer) && PropertyValidator.isValid((Object)(tsm = this.itemSyncMapperRepository.findByTeamAndContainer(teamContainer.getTeam(), teamContainer.getContainer()))) && tsm.getSprint() != null) {
                List teamMappings = ((AlmConfigurations)board.getSession().getAlmConfigurations().get(0)).getTeamMappings();
                for (BacklogMapping mapping : teamMappings) {
                    if (!mapping.getTeamId().equals(teamContainer.getTeam().getId()) || !PropertyValidator.isValid((Collection)mapping.getJiraFieldMap()) || !PropertyValidator.isValid(mapping.getJiraFieldMap().get(0)) || !PropertyValidator.isValid((Object)((ItemJiraFieldMap)mapping.getJiraFieldMap().get(0)).getValue())) continue;
                    extra = mapping.getJiraFieldMap();
                    break;
                }
            }
            if (PropertyValidator.isValid((Object)linkType) && PropertyValidator.isValid((Object)parent.getId())) {
                try {
                    if (!PropertyValidator.isValid((Collection)parent.getLinkTypes())) {
                        parent.setLinkTypes(new ArrayList());
                    }
                    HashSet<JiraIssueLinkType> linkSet = new HashSet<JiraIssueLinkType>(parent.getLinkTypes());
                    linkSet.add(JiraUtils.reverseJiraLinkDirection((JiraIssueLinkType)linkType));
                    parent.setLinkTypes(new ArrayList(linkSet));
                }
                catch (Exception linkSet) {
                }
                finally {
                    parent.setSuspendActivity(true);
                    parent = (Item)this.itemRepository.save((Object)parent);
                }
            }
            Map statusMap = null;
            for (JiraIssue jIssue : jiraItems) {
                String stKey;
                ViztrendJiraException anyError = null;
                sysSequence = sysSequence + 1000.0;
                String jiraId = jIssue.getId();
                String jiraKey = jIssue.getKey();
                ids.put(jIssue.getKey(), true);
                Item tmpItem = new Item();
                tmpItem.setSuspendActivity(true);
                tmpItem.setJiraId(jIssue.getId());
                tmpItem.setJiraKey(jIssue.getKey());
                HashMap<String, Object> updateJson = new HashMap<String, Object>();
                HashMap<String, String> nextGenJson = new HashMap<String, String>();
                if (PropertyValidator.isValid((Object)tsm) && PropertyValidator.isValid((Object)tsm.getSprint()) && PropertyValidator.isValid((Object)tsm.getSprint().getJiraId())) {
                    if (tsm.getSprint().getIsVersion().booleanValue()) {
                        updateJson.put("fixVersions", tsm.getSprint().getJiraId());
                    } else {
                        this.putSprintInJSON(updateJson, tsm.getSprint().getJiraId(), almAccount.getId());
                    }
                }
                if (PropertyValidator.isValid((Object)parent.getJiraId())) {
                    try {
                        if (board.getSession().getJiraSynapseRTEnabled().booleanValue()) {
                            this.exportUtil.deleteParentRequirementFromSynapseRT(jiraKey, almAccount);
                            this.exportUtil.addChildRequirementToSynapseRT(parent.getJiraKey(), jiraKey, almAccount);
                        } else if ("+1".equals(linkType.getJiraId())) {
                            updateJson.put(almAccount.getJiraEpicLinkClause(), parent.getJiraKey());
                        } else if (PropertyValidator.isValid((Object)linkType.getJiraId()) && linkType.getJiraId().indexOf("parent") > -1) {
                            nextGenJson.put("parent", parent.getJiraKey());
                        } else if (PropertyValidator.isValid((Object)linkType.getJiraId()) && linkType.getJiraId().indexOf("customfield_") > -1) {
                            updateJson.put(linkType.getJiraId(), parent.getJiraKey());
                        } else if ("IN".equals(linkType.getDirection())) {
                            this.exportUtil.createJiraIssueLink(parent.getJiraId(), jiraId, linkType.getId(), almAccount.getUrl(), almUsername, almPassword, almAccount);
                        } else {
                            this.exportUtil.createJiraIssueLink(jiraId, parent.getJiraId(), linkType.getId(), almAccount.getUrl(), almUsername, almPassword, almAccount);
                        }
                    }
                    catch (ViztrendJiraException e) {
                        errors.add(e);
                        ids.remove(jIssue.getKey());
                        anyError = e;
                    }
                }
                try {
                    if (!nextGenJson.isEmpty()) {
                        this.saveNextGenParent(tmpItem, nextGenJson, board, almAccount, loggedInUser, true);
                    }
                    if (!updateJson.isEmpty() || extra != null) {
                        updateJson.put("AlmAccountId", almAccount.getId());
                        updateJson.put("almAccount", almAccount);
                        updateJson.put("project", tmpItem.getJiraProjectKey());
                        updateJson.put("projectKey", tmpItem.getJiraProjectKey());
                        updateJson.put("issuetype", tmpItem.getJiraIssueTypeId());
                        if (PropertyValidator.isValid((Object)board.getSession())) {
                            updateJson.put("notifyUsers", board.getSession().getNotifyJiraUsers());
                        }
                        this.exportUtil.updateIssueInJira(jiraId, almAccount.getUrl(), almUsername, almPassword, updateJson, extra, false);
                    }
                }
                catch (ViztrendJiraException e) {
                    errors.add(e);
                    ids.remove(jIssue.getKey());
                    anyError = e;
                }
                if (anyError == null) continue;
                tmpItem.setTitle(jIssue.getFields().getSummary());
                tmpItem.setType(jIssue.getItemTypeTobeConvertedInto());
                tmpItem.setSequence(sysSequence);
                tmpItem.setJiraProjectKey(jIssue.getFields().getProject().getKey());
                tmpItem.setJiraIssueTypeId(jIssue.getFields().getIssuetype().getId());
                tmpItem.setParent(parent);
                if (PropertyValidator.isValid((Object)teamContainer)) {
                    tmpItem.setTeamContainers(new ArrayList());
                    tmpItem.getTeamContainers().add(teamContainer);
                }
                if (statusMap == null) {
                    statusMap = this.getStatusMap(board.getId());
                }
                if (statusMap.get(stKey = board.getSession().getId() + "_" + jIssue.getFields().getProject().getKey() + "_" + Item.Type.UserStory.name() + "_" + jIssue.getFields().getIssuetype().getId() + "_" + jIssue.getFields().getStatus().getId()) != null) {
                    tmpItem.setStatus((Status)statusMap.get(stKey));
                } else {
                    LOGGER.debug("convertJiraIssueToLvl2Item --> It seems we have pulled a new project. Lets go fetch statuses");
                    statusMap.putAll(this.convertJiraStatusToKendis(board.getSession(), jIssue.getFields().getProject().getKey()));
                    tmpItem.setStatus((Status)statusMap.get(stKey));
                }
                this.pushAlmError("Creating Link ALM:: FAILED.. error message saved in item.", anyError, tmpItem, board, loggedInUser, Boolean.valueOf(false));
            }
        }
        LOGGER.trace("Leaving linkExistingJiraIssueAsChild");
        return ids;
    }

    @Deprecated
    public Map<String, Object> processExistingJiraIssueAsFeatures(SearchVO searchVO) {
        return null;
    }

    public void updateBoardItemsForResync(SessionBoardVo sbVo) {
        JiraField dueDateField;
        if (((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getAlmAccount() == null) {
            this.almConfigRepository.findOne((Serializable)((Object)((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getId()));
        }
        JiraField jspField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-sprint", ((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getAlmAccount().getId());
        JiraField storyPointField = ((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getAlmAccount().getStoryPointField();
        if (!PropertyValidator.isValid((Object)storyPointField)) {
            storyPointField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountId("Story Points", ((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getAlmAccount().getId());
        }
        if (!PropertyValidator.isValid((Object)(dueDateField = ((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getAlmAccount().getDueDateField()))) {
            dueDateField = this.jiraFieldRepository.findByJiraIdIgnoreCaseAndAlmAccountId("duedate", ((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getAlmAccount().getId());
        }
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        sessionBoards.add(sbVo.getSessionBoard());
        Map itemsMap = new HashMap();
        itemsMap = this.convertItemListToMap(this.itemRepository.findBySessionBoardsInAndJiraKeyNotNull(sessionBoards));
        Double sysSequence = new Double(System.nanoTime() / 100000L);
        Map statusMap = this.getStatusMap(sbVo.getSessionBoard().getId());
        boolean done = false;
        int startAt = 0;
        int countUpdated = 0;
        int countAdded = 0;
        HashSet<String> jiraKeysOfStoriesAdded = new HashSet<String>();
        while (!done) {
            LOGGER.debug("startAt: " + startAt);
            Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "itemTypeTobeConvertedInto")});
            PageRequest pageable = new PageRequest(startAt, 100, sort);
            Page jiraItems = this.jiraIssueRepository.findByConvertedToItemAndSessionBoardIdOrderByItemTypeTobeConvertedInto(Boolean.FALSE, sbVo.getSessionBoard().getId(), (Pageable)pageable);
            ArrayList<Item> savedItems = new ArrayList<Item>();
            ArrayList<Object> parentItems = new ArrayList<Object>();
            if (!PropertyValidator.isValid((Collection)jiraItems.getContent())) {
                done = true;
                break;
            }
            for (JiraIssue jIssue : jiraItems.getContent()) {
                String stKey;
                Item tmpItem;
                String key;
                sysSequence = sysSequence + 1000.0;
                if (!"Feature".equals(jIssue.getItemTypeTobeConvertedInto())) {
                    key = jIssue.getKey() + "_" + jIssue.getFields().getIssuetype().getId() + "_" + jIssue.getJiraId();
                    tmpItem = (Item)itemsMap.get(key);
                    if (!PropertyValidator.isValid((Object)tmpItem)) {
                        if (jiraKeysOfStoriesAdded.contains(jIssue.getKey())) {
                            jIssue.setConvertedToItem(Boolean.valueOf(true));
                            continue;
                        }
                        tmpItem = new Item();
                        tmpItem.setSequence(sysSequence);
                        tmpItem.setBacklogSequence(sysSequence);
                        ++countAdded;
                    } else {
                        if (PropertyValidator.isValid((Object)tmpItem.getParent()) && PropertyValidator.isValid((Object)tmpItem.getParent().getJiraId()) && !tmpItem.getParent().getJiraId().equalsIgnoreCase(jIssue.getJiraParentId())) {
                            jIssue.setConvertedToItem(Boolean.valueOf(true));
                            continue;
                        }
                        ++countUpdated;
                    }
                    tmpItem.setSuspendActivity(true);
                    tmpItem.setTitle(jIssue.getFields().getSummary());
                    tmpItem.setType(jIssue.getItemTypeTobeConvertedInto());
                    tmpItem.setJiraId(jIssue.getId());
                    tmpItem.setJiraKey(jIssue.getKey());
                    tmpItem.setJiraProjectKey(jIssue.getFields().getProject().getKey());
                    tmpItem.setJiraIssueTypeId(jIssue.getFields().getIssuetype().getId());
                    stKey = sbVo.getSessionBoard().getSession().getId() + "_" + jIssue.getFields().getProject().getKey() + "_UserStory_" + jIssue.getFields().getIssuetype().getId() + "_" + jIssue.getFields().getStatus().getId();
                    tmpItem.setStatus((Status)statusMap.get(stKey));
                    try {
                        Double storyPoint = (Double)jIssue.getMapFields().get(storyPointField.getJiraId());
                        tmpItem.setStoryPoints(storyPoint);
                    }
                    catch (Exception storyPoint) {
                        // empty catch block
                    }
                    ArrayList tmpJsprints = (ArrayList)jIssue.getMapFields().get(jspField.getJiraId());
                    List tmpJiraVersions = jIssue.getFields().getFixVersions();
                    ArrayList teamContainers = new ArrayList();
                    sessionBoards = new ArrayList();
                    sessionBoards.add(sbVo.getSessionBoard());
                    tmpItem.setSessionBoards(sessionBoards);
                    Item parentFeature = this.itemRepository.findByJiraIdAndSessionBoards(jIssue.getJiraParentId(), sbVo.getSessionBoard());
                    parentFeature.setSuspendActivity(true);
                    ArrayList parentTeamCont = parentFeature.getTeamContainers();
                    boolean sprintAssigned = false;
                    if (!PropertyValidator.isValid((Collection)parentTeamCont)) {
                        parentTeamCont = new ArrayList();
                    }
                    if (PropertyValidator.isValid((Collection)tmpJsprints)) {
                        boolean activeFound = false;
                        JiraSprint activeJsp = null;
                        JiraSprint jsp = null;
                        try {
                            for (String sp : tmpJsprints) {
                                jsp = JiraUtils.parseStrForJsprint((String)sp);
                                if (jsp == null || "CLOSED".equalsIgnoreCase(jsp.getState())) continue;
                                activeFound = true;
                                activeJsp = jsp;
                            }
                        }
                        catch (ClassCastException e) {
                            ArrayList tmpJsprintsMap = (ArrayList)jIssue.getMapFields().get(jspField.getJiraId());
                            for (LinkedHashMap sp : tmpJsprintsMap) {
                                jsp = JiraUtils.parseStrForJsprint((LinkedHashMap)sp);
                                if (jsp == null || "CLOSED".equalsIgnoreCase(jsp.getState())) continue;
                                activeFound = true;
                                activeJsp = jsp;
                            }
                        }
                        if (activeFound) {
                            jsp = activeJsp;
                        }
                        if (jsp != null) {
                            Sprint tmpSp = this.sprintRepository.findSprintByJiraIdAndIsVersionAndAlmAccountIdAndSessionBoardId(jsp.getJiraId(), Boolean.valueOf(false), ((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getAlmAccount().getId(), sbVo.getSessionBoard().getId());
                            boolean skipMapping = false;
                            if (!PropertyValidator.isValid((Object)tmpSp)) {
                                skipMapping = true;
                            }
                            Team team = null;
                            if (!skipMapping) {
                                ItemSyncMapper itemSyncMapper = this.itemSyncMapperRepository.findBySessionBoardAndSprintAndTenantAndArchive(sbVo.getSessionBoard(), tmpSp, parentFeature.getTenant(), false);
                                if (PropertyValidator.isValid((Object)itemSyncMapper)) {
                                    sprintAssigned = this.applyTeamContainers(itemSyncMapper, parentTeamCont, teamContainers, sysSequence, tmpSp.getIsVersion());
                                } else {
                                    team = this.findTeamAccordingToMappings((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0), tmpSp, false, null);
                                    if (team != null) {
                                        ItemSyncMapper tsm;
                                        List tsmList = this.itemSyncMapperRepository.findByTeamAndSprint(team, tmpSp);
                                        Iterator iterator = tsmList.iterator();
                                        while (iterator.hasNext() && !(sprintAssigned = this.applyTeamContainers(tsm = (ItemSyncMapper)iterator.next(), parentTeamCont, teamContainers, sysSequence, tmpSp.getIsVersion()).booleanValue())) {
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (PropertyValidator.isValid((Collection)tmpJiraVersions) && !sprintAssigned) {
                        for (JiraVersion sp : tmpJiraVersions) {
                            ItemSyncMapper tsm;
                            Sprint tmpSp = this.sprintRepository.findSprintByJiraIdAndIsVersionAndAlmAccountId(sp.getJiraId(), Boolean.valueOf(true), ((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0)).getAlmAccount().getId());
                            if (!PropertyValidator.isValid((Object)tmpSp)) continue;
                            Team team = null;
                            ItemSyncMapper itemSyncMapper = this.itemSyncMapperRepository.findBySessionBoardAndSprintAndTenantAndArchive(sbVo.getSessionBoard(), tmpSp, parentFeature.getTenant(), false);
                            if (PropertyValidator.isValid((Object)itemSyncMapper)) {
                                sprintAssigned = this.applyTeamContainers(itemSyncMapper, parentTeamCont, teamContainers, sysSequence, tmpSp.getIsVersion());
                                continue;
                            }
                            team = this.findTeamAccordingToMappings((AlmConfigurations)sbVo.getSessionBoard().getSession().getAlmConfigurations().get(0), tmpSp, false, null);
                            if (team == null) continue;
                            List tsmList = this.itemSyncMapperRepository.findByTeamAndSprint(team, tmpSp);
                            Iterator iterator = tsmList.iterator();
                            while (iterator.hasNext() && !(sprintAssigned = this.applyTeamContainers(tsm = (ItemSyncMapper)iterator.next(), parentTeamCont, teamContainers, sysSequence, tmpSp.getIsVersion()).booleanValue())) {
                            }
                        }
                    }
                    tmpItem.setTeamContainers(teamContainers);
                    parentFeature.setTeamContainers(parentTeamCont);
                    this.itemRepository.save((Object)parentFeature);
                    tmpItem.setParent(parentFeature);
                    jIssue.setConvertedToItem(Boolean.valueOf(true));
                    savedItems.add(tmpItem);
                    jiraKeysOfStoriesAdded.add(tmpItem.getJiraKey());
                    continue;
                }
                key = jIssue.getKey() + "_" + jIssue.getFields().getIssuetype().getId() + "_" + jIssue.getJiraId();
                tmpItem = (Item)itemsMap.get(key);
                if (!PropertyValidator.isValid((Object)tmpItem)) {
                    tmpItem = new Item();
                    tmpItem.setSequence(sysSequence);
                    tmpItem.setIsEnabler(jIssue.getIsEnabler());
                    ++countAdded;
                } else {
                    ++countUpdated;
                }
                tmpItem.setSuspendActivity(true);
                tmpItem.setTitle(jIssue.getFields().getSummary());
                tmpItem.setType(jIssue.getItemTypeTobeConvertedInto());
                tmpItem.setJiraId(jIssue.getJiraId());
                tmpItem.setJiraKey(jIssue.getKey());
                tmpItem.setJiraProjectKey(jIssue.getFields().getProject().getKey());
                sessionBoards = new ArrayList();
                sessionBoards.add(sbVo.getSessionBoard());
                tmpItem.setSessionBoards(sessionBoards);
                stKey = sbVo.getSessionBoard().getSession().getId() + "_" + jIssue.getFields().getProject().getKey() + "_Feature_" + jIssue.getFields().getIssuetype().getId() + "_" + jIssue.getFields().getStatus().getId();
                tmpItem.setStatus((Status)statusMap.get(stKey));
                tmpItem.setJiraIssueTypeId(jIssue.getFields().getIssuetype().getId());
                if (PropertyValidator.isValid(jIssue.getMapFields().get(dueDateField.getJiraId()))) {
                    tmpItem.setDueDate(PropertyValidator.parseDate((String)((String)jIssue.getMapFields().get(dueDateField.getJiraId())), (String)"yyyy-MM-dd"));
                }
                parentItems.add(this.itemRepository.save((Object)tmpItem));
                jIssue.setConvertedToItem(Boolean.valueOf(true));
            }
            this.itemRepository.save(savedItems);
            LOGGER.info("Number of items updated: " + countUpdated);
            LOGGER.info("Number of items Added: " + countAdded);
            this.jiraIssueRepository.save((Iterable)jiraItems.getContent());
            if (jiraItems.getTotalPages() != 0) continue;
            break;
        }
    }

    private Map<String, Status> convertStatusListToMap(List<Status> statuses, String sessionId) {
        HashMap<String, Status> statusMap = new HashMap<String, Status>();
        if (PropertyValidator.isValid(statuses)) {
            for (Status st : statuses) {
                String key = sessionId + "_" + st.getJiraProjKey() + "_" + st.getItemType() + "_" + st.getJiraIssueTypeId() + "_" + st.getJiraStatusId();
                statusMap.put(key, st);
            }
        }
        return statusMap;
    }

    private Map<String, Sprint> convertSprintListToMap(List<Sprint> sprints, String sessionId) {
        HashMap<String, Sprint> sprintMap = new HashMap<String, Sprint>();
        if (PropertyValidator.isValid(sprints)) {
            for (Sprint st : sprints) {
                sprintMap.put(st.getJiraId(), st);
            }
        }
        return sprintMap;
    }

    private Map<String, Item> convertItemListToMap(List<Item> bItems) {
        HashMap<String, Item> itemsMap = new HashMap<String, Item>();
        if (PropertyValidator.isValid(bItems)) {
            for (Item item : bItems) {
                String key = item.getJiraKey() + "_" + item.getJiraIssueTypeId() + "_" + item.getJiraId();
                itemsMap.put(key, item);
            }
        }
        return itemsMap;
    }

    private Team findTeamAccordingToMappings(AlmConfigurations almConfigs, Sprint sprint, boolean isRelease, String projectId) {
        block4: {
            List teamMappinglist;
            block5: {
                teamMappinglist = almConfigs.getTeamMappings();
                if (!PropertyValidator.isValid((Collection)teamMappinglist)) break block4;
                if (!isRelease) break block5;
                for (BacklogMapping tMap : teamMappinglist) {
                    if (!PropertyValidator.isValid((Object)tMap) || !tMap.isSyncedFlag() || !tMap.getProjectKey().equals(projectId)) continue;
                    return (Team)this.teamRepository.findOne((Serializable)((Object)tMap.getTeamId()));
                }
                break block4;
            }
            Query q = new Query();
            q.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").is((Object)sprint.getJiraId()).and("self").regex(almConfigs.getAlmAccount().getUrl()));
            JiraSprint jSprint = (JiraSprint)this.jiraRepository.getMongoTemplate().findOne(q, JiraSprint.class);
            if (!PropertyValidator.isValid((Object)jSprint)) break block4;
            for (BacklogMapping tMap : teamMappinglist) {
                if (!PropertyValidator.isValid((Object)tMap) || !tMap.isSyncedFlag()) continue;
                if (PropertyValidator.isValid((Object)jSprint.getName()) && !jSprint.getName().equalsIgnoreCase(sprint.getTitle())) {
                    q = new Query();
                    q.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)jSprint.getName()).and("almAccountId").is((Object)almConfigs.getAlmAccount().getId()));
                    Sprint tempSprint = (Sprint)this.jiraRepository.getMongoTemplate().findOne(q, Sprint.class);
                    if (PropertyValidator.isValid((Object)tempSprint)) {
                        sprint = tempSprint;
                    }
                }
                return (Team)this.teamRepository.findOne((Serializable)((Object)tMap.getTeamId()));
            }
        }
        return null;
    }

    public SessionBoard saveSessionWithChange(SessionBoard sessionBoard) {
        this.sessionBoardRepository.save((Object)sessionBoard);
        return sessionBoard;
    }

    public void changeItemSprintInJiraIssue(Item savedItem, Item actionItem, User loggedInUser) {
        if (savedItem.getJiraId() != null) {
            Double totalEstimate;
            List childItems;
            JiraIssue jiraIssue;
            List syncMappedList;
            String almPassword;
            String almUsername;
            AlmAccount alm;
            SessionBoard sessionBoard;
            HashMap<String, Object> updateJson;
            block24: {
                if (actionItem != null) {
                    actionItem.setSuspendActivity(true);
                }
                if (savedItem != null) {
                    savedItem.setSuspendActivity(true);
                }
                updateJson = new HashMap<String, Object>();
                String sessionId = ((SessionBoard)actionItem.getSessionBoards().get(0)).getId();
                sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionId));
                List linkedSprints = sessionBoard.getContainers().stream().map(BaseEntity::getId).collect(Collectors.toList());
                alm = this.getJiraLoginForApi(sessionBoard, loggedInUser);
                almUsername = alm.getUsernameForApi();
                almPassword = alm.getPasswordForApi();
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"container.id").in(linkedSprints));
                syncMappedList = this.customRepository.getMongoTemplate().find(query, ItemSyncMapper.class);
                jiraIssue = null;
                try {
                    jiraIssue = this.almService.retrieveJiraIssueById(savedItem.getJiraId(), alm);
                }
                catch (ViztrendJiraException e1) {
                    LOGGER.error("Failed to fetch jira Issue. " + e1.getAlmError(), (Throwable)e1);
                    if (500 != e1.getCode()) break block24;
                    LOGGER.error("Retrying ...");
                    jiraIssue = this.almService.retrieveJiraIssueById(savedItem.getJiraId(), alm);
                }
            }
            Sprint changedSprint = null;
            Sprint oldSprint = null;
            if (syncMappedList != null) {
                for (int i = 0; i < syncMappedList.size(); ++i) {
                    if (((ItemSyncMapper)syncMappedList.get(i)).getContainer().getId().equals(((TeamContainer)actionItem.getTeamContainers().get(0)).getContainer().getId()) && ((ItemSyncMapper)syncMappedList.get(i)).getTeam().getId().equals(((TeamContainer)actionItem.getTeamContainers().get(0)).getTeam().getId())) {
                        changedSprint = ((ItemSyncMapper)syncMappedList.get(i)).getSprint();
                    }
                    if (!PropertyValidator.isValid((Collection)savedItem.getTeamContainers()) || !((ItemSyncMapper)syncMappedList.get(i)).getContainer().getId().equals(((TeamContainer)savedItem.getTeamContainers().get(0)).getContainer().getId()) || !((ItemSyncMapper)syncMappedList.get(i)).getTeam().getId().equals(((TeamContainer)savedItem.getTeamContainers().get(0)).getTeam().getId())) continue;
                    oldSprint = ((ItemSyncMapper)syncMappedList.get(i)).getSprint();
                }
            }
            boolean sameParent = false;
            boolean linkCreated = false;
            boolean fetch = false;
            Item parent = null;
            Item oldParent = null;
            if (PropertyValidator.isValid((Object)actionItem.getParent())) {
                parent = (Item)this.itemRepository.findOne((Serializable)((Object)actionItem.getParent().getId()));
            }
            if (PropertyValidator.isValid((Object)savedItem.getParent())) {
                oldParent = (Item)this.itemRepository.findOne((Serializable)((Object)savedItem.getParent().getId()));
            }
            if (Item.Type.UserStory.name().equals(savedItem.getType())) {
                boolean[] flages = this.changeItemParentInJira(sessionBoard, actionItem, jiraIssue, parent, oldParent, updateJson, loggedInUser, alm);
                sameParent = flages[0];
                linkCreated = flages[1];
                List itemJiraFieldsValues = actionItem.getJiraFieldMap();
                if (changedSprint != null) {
                    if (changedSprint.getIsVersion().booleanValue()) {
                        updateJson.put("fixVersions", changedSprint.getJiraId());
                        if (oldSprint != null && PropertyValidator.isValid((Object)oldSprint.getJiraId()) && oldSprint.getIsVersion().booleanValue()) {
                            updateJson.put("fixVersions_remove", oldSprint.getJiraId());
                        }
                        fetch = true;
                    } else {
                        this.putSprintInJSON(updateJson, changedSprint.getJiraId(), alm.getId());
                    }
                    fetch = true;
                }
                if (!updateJson.isEmpty()) {
                    try {
                        updateJson.put("AlmAccountId", alm.getId());
                        updateJson.put("almAccount", alm);
                        if (PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                            updateJson.put("notifyUsers", sessionBoard.getSession().getNotifyJiraUsers());
                        }
                        updateJson.put("projectKey", actionItem.getJiraProjectKey());
                        updateJson.put("issuetype", actionItem.getJiraIssueTypeId());
                        this.exportUtil.updateIssueInJira(actionItem.getJiraId(), alm.getUrl(), almUsername, almPassword, updateJson, itemJiraFieldsValues, false);
                    }
                    catch (ViztrendJiraException e) {
                        this.pushAlmError("Updating feature in ALM:: FAILED.. error message saved in item.", e, actionItem, sessionBoard, loggedInUser, Boolean.valueOf(false));
                    }
                }
                if (fetch) {
                    this.syncItemFieldsAfterSave(false, actionItem, sessionBoard, alm);
                }
            }
            if ((linkCreated || sessionBoard.getSession().getJiraSynapseRTEnabled().booleanValue()) && !sameParent && PropertyValidator.isValid((Object)parent) && PropertyValidator.isValid((Object)parent.getId()) && PropertyValidator.isValid((Object)parent.getJiraProjectKey()) && !"0".equals(parent.getJiraProjectKey())) {
                childItems = this.itemRepository.findByParentId(actionItem.getParent().getId());
                totalEstimate = 0.0;
                for (Item childItem : childItems) {
                    totalEstimate = totalEstimate + childItem.getStoryPoints();
                }
                this.customRepository.updateItemStoryPoints(actionItem.getParent().getId(), totalEstimate);
                actionItem.getParent().setSubItemEstimate(totalEstimate);
                parent.setSubItemEstimate(totalEstimate);
            }
            if (PropertyValidator.isValid((Object)oldParent) && PropertyValidator.isValid((Object)oldParent.getId()) && PropertyValidator.isValid((Object)oldParent.getJiraProjectKey()) && !"0".equals(oldParent.getJiraProjectKey())) {
                childItems = this.itemRepository.findByParentId(savedItem.getParent().getId());
                totalEstimate = 0.0;
                for (Item childItem : childItems) {
                    totalEstimate = totalEstimate + childItem.getStoryPoints();
                }
                this.customRepository.updateItemStoryPoints(oldParent.getId(), totalEstimate);
                savedItem.getParent().setSubItemEstimate(totalEstimate);
                oldParent.setSubItemEstimate(totalEstimate);
            }
        }
    }

    public List<Item> updateChildrenInTcs(SessionBoard sessionBoard, TeamContainer teamContainer) {
        ArrayList<TeamContainer> tcs = new ArrayList<TeamContainer>();
        tcs.add(teamContainer);
        List lvl2 = null;
        lvl2 = this.itemRepository.findByTypeAndTeamContainersIn(Item.USER_STORY, tcs);
        if (PropertyValidator.isValid((Collection)lvl2) && PropertyValidator.isValid((Object)teamContainer)) {
            for (Item item : lvl2) {
                item.applySprintDates(sessionBoard.getSession(), null, null);
            }
            this.itemRepository.save((Iterable)lvl2);
        }
        return lvl2;
    }

    public void updateOnDragDrop(Item parentItem, List<Item> children, String boardId, User loggedInUser, TeamContainer teamContainer, Boolean moveChildrenToJira, String oldParentId, ItemJiraFieldMap jiraField) {
        LOGGER.trace("INSIDE addLabelToFeatureItemInJira");
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
        AlmAccount alm = this.getJiraLoginForApi(sessionBoard, loggedInUser);
        ItemSyncMapper syncMapper = this.itemSyncMapperRepository.findByTeamAndContainer(teamContainer.getTeam(), teamContainer.getContainer());
        LOGGER.trace("INSIDE addLabelToFeatureItemInJira --> syncMapper := " + syncMapper);
        Sprint changedSprint = null;
        if (PropertyValidator.isValid((Object)syncMapper)) {
            changedSprint = syncMapper.getSprint();
        }
        if (PropertyValidator.isValid((Object)parentItem) && this.addLabelToFeatureItemInJira(parentItem, sessionBoard, alm, loggedInUser, changedSprint)) {
            return;
        }
        if (children == null) {
            children = this.updateChildrenInTcs(sessionBoard, teamContainer);
        }
        if (PropertyValidator.isValid(children)) {
            HashMap<String, Object> updateJson = new HashMap<String, Object>();
            ArrayList<ItemJiraFieldMap> itemJiraFieldMap = null;
            if (PropertyValidator.isValid((Object)jiraField)) {
                itemJiraFieldMap = new ArrayList<ItemJiraFieldMap>();
                itemJiraFieldMap.add(jiraField);
            }
            boolean saved = false;
            Item child = null;
            if (oldParentId != null) {
                child = (Item)children.get(0);
                if (child.getJiraId() == null) {
                    return;
                }
                this.changeParent(sessionBoard, child, oldParentId, updateJson, loggedInUser, alm);
            }
            if (PropertyValidator.isValid((Object)changedSprint) && moveChildrenToJira.booleanValue()) {
                if (!changedSprint.getIsVersion().booleanValue()) {
                    this.putSprintInJSON(updateJson, changedSprint.getJiraId(), alm.getId());
                }
                saved = this.moveItemToSprintInJira(sessionBoard, children, teamContainer, changedSprint, updateJson, itemJiraFieldMap, alm, loggedInUser);
            }
            try {
                if (!saved) {
                    if (updateJson.isEmpty() && !PropertyValidator.isValid(itemJiraFieldMap)) {
                        return;
                    }
                    if (child == null && PropertyValidator.isValid((Collection)children)) {
                        child = (Item)children.get(0);
                    }
                    if (PropertyValidator.isValid((Object)child) && PropertyValidator.isValid((Object)child.getJiraId())) {
                        updateJson.put("AlmAccountId", alm.getId());
                        updateJson.put("almAccount", alm);
                        updateJson.put("project", child.getJiraProjectKey());
                        updateJson.put("projectKey", child.getJiraProjectKey());
                        updateJson.put("issuetype", child.getJiraIssueTypeId());
                        if (PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                            updateJson.put("notifyUsers", sessionBoard.getSession().getNotifyJiraUsers());
                        }
                        this.exportUtil.updateIssueInJira(child.getJiraId(), alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), updateJson, itemJiraFieldMap, false);
                        saved = true;
                    }
                }
                if (saved) {
                    this.syncItemFieldsAfterSave(true, child == null ? (Item)children.get(0) : child, sessionBoard, alm);
                }
            }
            catch (ViztrendJiraException e) {
                this.pushAlmError("Creating Link ALM:: FAILED.. error message saved in item.", e, child, sessionBoard, loggedInUser, Boolean.valueOf(false));
            }
        }
        LOGGER.debug("Leaving addLabelToFeatureItemInJira");
    }

    private void syncItemFieldsAfterSave(boolean push, Item actionItem, SessionBoard sessionBoard, AlmAccount alm) {
        JiraIssue2 jIssueAfterSave = this.almService.retrieveJiraIssue(actionItem.getJiraId(), alm);
        if (PropertyValidator.isValid((Object)jIssueAfterSave) && PropertyValidator.isValid((Object)jIssueAfterSave.getFields())) {
            Set configFields = this.getExtraFields(alm.getId(), actionItem, null);
            if (sessionBoard != null && PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                configFields.addAll(sessionBoard.getSession().combineAdditionalFields(null, null, true, null));
            }
            actionItem = this.itemRepository.findById(actionItem.getId());
            if (PropertyValidator.isValid((Collection)configFields)) {
                actionItem.putCustomeFieldValues((Map)jIssueAfterSave.getFields(), (Collection)configFields, false);
            }
            this.itemRepository.save((Object)actionItem);
            if (push && PropertyValidator.isValid((Object)actionItem.getJiraFieldByKey())) {
                PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)actionItem, (String)sessionBoard.getId(), (String)"Update", null, (Boolean)false, (Boolean)false));
            }
        }
    }

    private boolean addLabelToFeatureItemInJira(Item savedItem, SessionBoard sessionBoard, AlmAccount alm, User loggedInUser, Sprint changedSprint) {
        boolean skipFurther = false;
        if (PropertyValidator.isValid((Object)changedSprint)) {
            HashMap<String, Object> updateJson = new HashMap<String, Object>();
            ArrayList lbls = new ArrayList();
            if (PropertyValidator.isValid(lbls)) {
                try {
                    LOGGER.trace("Going to add labels:: " + lbls);
                    updateJson.put("almAccount", alm);
                    if (PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                        updateJson.put("notifyUsers", sessionBoard.getSession().getNotifyJiraUsers());
                    }
                    updateJson.put("projectKey", savedItem.getJiraProjectKey());
                    updateJson.put("issuetype", savedItem.getJiraIssueTypeId());
                    this.exportUtil.updateIssueInJira(savedItem.getJiraId(), alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), updateJson, null, false);
                }
                catch (ViztrendJiraException e) {
                    this.pushAlmError("Updating feature in ALM:: FAILED.. error message saved in item.", e, savedItem, sessionBoard, loggedInUser, Boolean.valueOf(false));
                }
            }
        }
        if ("nexus".equals(sessionBoard.getSession().getSessionType())) {
            if (PropertyValidator.isValid((Object)changedSprint) && !changedSprint.getIsVersion().booleanValue()) {
                this.updateSprintInJira(savedItem, changedSprint.getJiraId(), sessionBoard, alm, alm.getUsernameForApi(), alm.getPasswordForApi(), loggedInUser);
            }
            skipFurther = true;
        }
        return skipFurther;
    }

    public List<ItemJiraFieldMap> getSharedSprintValue(SessionBoard sessionBoard, TeamContainer teamContainer) {
        List teamMappings;
        List extra = null;
        BacklogMapping currentTeamMapping = null;
        if (sessionBoard != null && sessionBoard.getSession() != null && sessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations()) && PropertyValidator.isValid(sessionBoard.getSession().getAlmConfigurations().get(0)) && PropertyValidator.isValid((Collection)(teamMappings = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getTeamMappings()))) {
            for (BacklogMapping teamMapping : teamMappings) {
                if (!teamMapping.getTeamId().equals(teamContainer.getTeam().getId())) continue;
                ItemSyncMapper itemSyncMapper = this.itemSyncMapperRepository.findByTeamAndContainer(teamContainer.getTeam(), teamContainer.getContainer());
                if (itemSyncMapper != null && itemSyncMapper.getSprint() == null) break;
                currentTeamMapping = teamMapping;
                break;
            }
        }
        if (PropertyValidator.isValid(currentTeamMapping) && PropertyValidator.isValid((Collection)currentTeamMapping.getJiraFieldMap())) {
            extra = currentTeamMapping.getJiraFieldMap();
        }
        return extra;
    }

    private boolean moveItemToSprintInJira(SessionBoard sessionBoard, List<Item> children, TeamContainer teamContainer, Sprint changedSprint, HashMap<String, Object> updateJson, List<ItemJiraFieldMap> fields, AlmAccount alm, User loggedInUser) {
        boolean saved = false;
        if (PropertyValidator.isValid(children)) {
            ArrayList<String> issueIds = new ArrayList<String>();
            for (Item item : children) {
                if (!PropertyValidator.isValid((Object)item.getJiraId())) continue;
                issueIds.add(item.getJiraId());
                if (changedSprint.getIsVersion().booleanValue()) continue;
                try {
                    ArrayList<ItemJiraFieldMap> extra = this.getSharedSprintValue(sessionBoard, teamContainer);
                    if (PropertyValidator.isValid(fields)) {
                        if (extra == null) {
                            extra = new ArrayList<ItemJiraFieldMap>();
                        }
                        extra.addAll(fields);
                    }
                    if (updateJson.isEmpty() && !PropertyValidator.isValid((Collection)extra)) continue;
                    updateJson.put("AlmAccountId", alm.getId());
                    updateJson.put("almAccount", alm);
                    updateJson.put("projectKey", item.getJiraProjectKey());
                    updateJson.put("project", item.getJiraProjectKey());
                    updateJson.put("issuetype", item.getJiraIssueTypeId());
                    if (PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                        updateJson.put("notifyUsers", sessionBoard.getSession().getNotifyJiraUsers());
                    }
                    this.exportUtil.updateIssueInJira(item.getJiraId(), alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), updateJson, extra, false);
                    saved = true;
                }
                catch (ViztrendJiraException e) {
                    this.pushAlmError("Failed: Updating Feature in ALM:: FAILED.. error message saved in item.", e, item, sessionBoard, loggedInUser, Boolean.valueOf(false));
                }
            }
            if (!changedSprint.getIsVersion().booleanValue()) {
                LOGGER.debug("Moving following stories. " + issueIds);
            }
        }
        return saved;
    }

    private void changeParent(SessionBoard sessionBoard, Item item, String oldParentId, HashMap<String, Object> updateJson, User loggedInUser, AlmAccount alm) {
        Item oldParent;
        Item parent;
        JiraIssue jiraIssue;
        block4: {
            jiraIssue = null;
            parent = null;
            oldParent = null;
            if (PropertyValidator.isValid((Object)item.getParent())) {
                parent = (Item)this.itemRepository.findOne((Serializable)((Object)item.getParent().getId()));
            }
            if (PropertyValidator.isValid((Object)oldParentId)) {
                oldParent = (Item)this.itemRepository.findOne((Serializable)((Object)oldParentId));
            }
            try {
                jiraIssue = this.almService.retrieveJiraIssueById(item.getJiraId(), alm);
            }
            catch (ViztrendJiraException e1) {
                LOGGER.error("Failed to fetch jira Issue. " + e1.getAlmError(), (Throwable)e1);
                if (500 != e1.getCode()) break block4;
                LOGGER.error("Retrying ...");
                jiraIssue = this.almService.retrieveJiraIssueById(item.getJiraId(), alm);
            }
        }
        this.changeItemParentInJira(sessionBoard, item, jiraIssue, parent, oldParent, updateJson, loggedInUser, alm);
    }

    /*
     * Unable to fully structure code
     */
    public boolean[] changeItemParentInJira(SessionBoard sessionBoard, Item item, JiraIssue jiraIssue, Item parent, Item oldParent, Map<String, Object> updateJson, User loggedInUser, AlmAccount alm) {
        sameParent = false;
        linkCreated = false;
        nextGenJson = new HashMap<String, String>();
        almConfig = (AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0);
        almUsername = alm.getUsernameForApi();
        almPassword = alm.getPasswordForApi();
        epicLinkField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-epic-link", ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount().getId());
        if (PropertyValidator.isValid((Object)oldParent) && PropertyValidator.isValid((Object)oldParent.getId()) && PropertyValidator.isValid((Object)parent) && PropertyValidator.isValid((Object)parent.getId()) && oldParent.getId().equals(parent.getId())) {
            sameParent = true;
        }
        if (sessionBoard.getSession().getJiraSynapseRTEnabled().booleanValue()) {
            if (!sameParent) {
                this.exportUtil.deleteParentRequirementFromSynapseRT(item.getJiraKey(), alm);
                this.exportUtil.addChildRequirementToSynapseRT(parent.getJiraKey(), item.getJiraKey(), alm);
                PlanServiceImpl.LOGGER.warn("Parent link deleted and added in SynapseRT");
            }
        } else {
            linkMappings = new ArrayList<BacklogMappingLinks>();
            if (PropertyValidator.isValid((Object)parent.getJiraFilter())) {
                featureFilters = almConfig.getFeatureFilter();
                if (PropertyValidator.isValid((Collection)featureFilters)) {
                    for (JiraFilter jiraFilter : featureFilters) {
                        if (!parent.getJiraFilter().equals(jiraFilter.getId())) continue;
                        linkMappings = jiraFilter.getFeatureLinkMappings();
                    }
                }
            } else if (PropertyValidator.isValid((Collection)parent.getLinkTypes())) {
                linkTypes = new ArrayList<JiraIssueLinkType>();
                linkTypes.addAll(parent.getLinkTypes());
                mappingLinks = new BacklogMappingLinks();
                mappingLinks.setProjectKey(parent.getJiraProjectKey());
                mappingLinks.setLinkTypes(parent.getLinkTypes());
                linkMappings.add(mappingLinks);
            } else if (PropertyValidator.isValid((Object)parent.getLinkType())) {
                linkTypes = new ArrayList<E>();
                linkTypes.add(parent.getLinkType());
                linkMappings.add(new BacklogMappingLinks(linkTypes));
            }
            projectkey = parent.getJiraProjectKey();
            if (projectkey == null && PropertyValidator.isValid((Object)parent) && PropertyValidator.isValid((Object)parent.getJiraId()) && PropertyValidator.isValid((Object)parent.getJiraKey())) {
                projectkey = parent.getJiraKey().substring(0, parent.getJiraKey().indexOf("-"));
            }
            preferedLinkIsEpic = false;
            preferedLinkIsParentNextGen = false;
            eLink = null;
            if (PropertyValidator.isValid(jiraIssue.getMapFields().get(epicLinkField.getId()))) {
                epicParentKey = (String)jiraIssue.getMapFields().get(epicLinkField.getId());
                try {
                    if (PropertyValidator.isValid((Object)oldParent.getJiraKey()) && oldParent.getJiraKey().equalsIgnoreCase(epicParentKey)) {
                        issueIds = new ArrayList<String>();
                        issueIds.add(item.getJiraId());
                        if (!sameParent) {
                            this.exportUtil.removeIssuesFromJiraEpic(issueIds, alm.getUrl(), almUsername, almPassword, alm);
                        }
                        preferedLinkIsEpic = true;
                    }
                }
                catch (ViztrendJiraException e) {
                    this.pushAlmError("Deleting Link ALM:: FAILED.. error message saved in item.", e, item, sessionBoard, loggedInUser, Boolean.valueOf(false));
                }
            }
            if (PropertyValidator.isValid(jiraIssue.getMapFields().get("parent"))) {
                parentObject = (LinkedTreeMap)jiraIssue.getMapFields().get("parent");
                parentKey = (String)parentObject.get((Object)"key");
                if (PropertyValidator.isValid((Object)oldParent.getJiraKey()) && oldParent.getJiraKey().equalsIgnoreCase(parentKey)) {
                    if (!sameParent) {
                        nextGenJson.put("parent", null);
                    }
                    preferedLinkIsParentNextGen = true;
                }
            }
            if (!preferedLinkIsEpic && !preferedLinkIsParentNextGen && PropertyValidator.isValid((Collection)jiraIssue.getFields().getIssuelinks())) {
                existingLinkItr = jiraIssue.getFields().getIssuelinks().iterator();
                try {
                    while (existingLinkItr.hasNext()) {
                        eLink = (JiraIssueLink)existingLinkItr.next();
                        if (PropertyValidator.isValid((Object)eLink.getOutwardIssue()) && eLink.getOutwardIssue().getJiraId().equals(oldParent.getJiraId())) {
                            eLink.getType().setDirection("OUT");
                            if (!sameParent) {
                                this.exportUtil.deleteJiraIssueLink(eLink.getId(), alm.getUrl(), almUsername, almPassword, alm);
                            }
                            existingLinkItr.remove();
                        } else {
                            if (!PropertyValidator.isValid((Object)eLink.getInwardIssue()) || !eLink.getInwardIssue().getJiraId().equals(oldParent.getJiraId())) continue;
                            eLink.getType().setDirection("IN");
                            if (!sameParent) {
                                this.exportUtil.deleteJiraIssueLink(eLink.getId(), alm.getUrl(), almUsername, almPassword, alm);
                            }
                            existingLinkItr.remove();
                        }
                        break;
                    }
                }
                catch (ViztrendJiraException e) {
                    this.pushAlmError("Deleting Link ALM:: FAILED.. error message saved in item.", e, item, sessionBoard, loggedInUser, Boolean.valueOf(false));
                }
                this.jiraIssueRepository.save((Object)jiraIssue);
            }
            if (PropertyValidator.isValid(linkMappings)) {
                for (BacklogMappingLinks bLink : linkMappings) {
                    if (!bLink.getProjectKey().equalsIgnoreCase(projectkey)) continue;
                    if (!PropertyValidator.isValid((Collection)bLink.getLinkTypes())) break;
                    if ("+1".equals(((JiraIssueLinkType)bLink.getLinkTypes().get(0)).getJiraId())) {
                        if (!sameParent) {
                            updateJson.put(alm.getJiraEpicLinkLabel(), parent.getJiraKey());
                        }
                        linkCreated = true;
                    } else if (((JiraIssueLinkType)bLink.getLinkTypes().get(0)).getJiraId().indexOf("parent") > -1) {
                        if (!sameParent) {
                            nextGenJson.put("parent", parent.getJiraKey());
                        }
                        linkCreated = true;
                    } else if (((JiraIssueLinkType)bLink.getLinkTypes().get(0)).getJiraId().indexOf("customfield_") > -1) {
                        if (!sameParent) {
                            updateJson.put(((JiraIssueLinkType)bLink.getLinkTypes().get(0)).getJiraId(), parent.getJiraKey());
                        }
                        linkCreated = true;
                    } else {
                        if (!sameParent) {
                            if ("IN".equals(((JiraIssueLinkType)bLink.getLinkTypes().get(0)).getDirection())) {
                                this.exportUtil.createJiraIssueLink(item.getJiraId(), parent.getJiraId(), ((JiraIssueLinkType)bLink.getLinkTypes().get(0)).getId(), alm.getUrl(), almUsername, almPassword, alm);
                            } else {
                                this.exportUtil.createJiraIssueLink(parent.getJiraId(), item.getJiraId(), ((JiraIssueLinkType)bLink.getLinkTypes().get(0)).getId(), alm.getUrl(), almUsername, almPassword, alm);
                            }
                        }
                        linkCreated = true;
                    }
                    break;
                }
            } else if (preferedLinkIsParentNextGen) {
                if (!sameParent) {
                    nextGenJson.put("parent", parent.getJiraKey());
                }
                linkCreated = true;
            } else if (preferedLinkIsEpic) {
                if (!sameParent) {
                    updateJson.put(alm.getJiraEpicLinkLabel(), parent.getJiraKey());
                }
                linkCreated = true;
            } else if (PropertyValidator.isValid(eLink) && !preferedLinkIsEpic && PropertyValidator.isValid((Object)parent.getJiraId())) {
                try {
                    if (!PropertyValidator.isValid((Object)eLink.getType())) ** GOTO lbl150
                    if ("IN".equals(eLink.getType().getDirection())) {
                        if (!sameParent) {
                            this.exportUtil.createJiraIssueLink(parent.getJiraId(), item.getJiraId(), eLink.getType().getId(), alm.getUrl(), almUsername, almPassword, alm);
                        }
                        linkCreated = true;
                    }
                    if (!sameParent) {
                        this.exportUtil.createJiraIssueLink(item.getJiraId(), parent.getJiraId(), eLink.getType().getId(), alm.getUrl(), almUsername, almPassword, alm);
                    }
                    linkCreated = true;
                }
                catch (ViztrendJiraException e) {
                    this.pushAlmError("Creating Link ALM:: FAILED.. error message saved in item.", e, item, sessionBoard, loggedInUser, Boolean.valueOf(false));
                }
            }
        }
        if (!nextGenJson.isEmpty()) {
            this.saveNextGenParent(item, nextGenJson, sessionBoard, alm, loggedInUser, false);
        }
        flages = new boolean[3];
        flages[0] = sameParent;
        flages[1] = linkCreated;
        return flages;
    }

    public void saveNextGenParent(Item item, Map<String, Object> nextGenJson, SessionBoard sessionBoard, AlmAccount alm, User loggedInUser, boolean isItemNotSaved) {
        try {
            nextGenJson.put("AlmAccountId", alm.getId());
            nextGenJson.put("almAccount", alm);
            if (PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                nextGenJson.put("notifyUsers", sessionBoard.getSession().getNotifyJiraUsers());
            }
            nextGenJson.put("projectKey", item.getJiraProjectKey());
            nextGenJson.put("issuetype", item.getJiraIssueTypeId());
            this.exportUtil.updateIssueInJira(item.getJiraId(), alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), nextGenJson, null, true);
        }
        catch (ViztrendJiraException e) {
            String log = "Creating Link ALM (Next Gen):: FAILED.. error message saved in item.";
            if (isItemNotSaved) {
                LOGGER.error(log, (Object)StringUtils.getTraceString((Throwable)e));
                throw e;
            }
            this.pushAlmError(log, e, item, sessionBoard, loggedInUser, Boolean.valueOf(false));
        }
    }

    public List<Team> saveTeamsWithSprints(List<Team> teamsToSave, AlmConfigurations almConfigs, List<Team> teamsToUpdate) {
        ArrayList<Team> resultList = new ArrayList<Team>();
        if (PropertyValidator.isValid(teamsToSave)) {
            for (Team team : teamsToSave) {
                team.setId(null);
                team.setSuspendActivity(true);
                team = (Team)this.teamRepository.save((Object)team);
                if (PropertyValidator.isValid((Object)almConfigs)) {
                    List teamMappings = almConfigs.getTeamMappings();
                    for (BacklogMapping tMap : teamMappings) {
                        if (!PropertyValidator.isValid((Object)tMap) || !PropertyValidator.isValid((Object)tMap.getTeamId()) || !tMap.getTeamId().equals(team.getTempId())) continue;
                        tMap.setTeamId(team.getId());
                    }
                    List linkMappings = almConfigs.getStoryLinkMappings();
                    for (BacklogMappingLinks tMap : linkMappings) {
                        if (!PropertyValidator.isValid((Object)tMap.getTeamMapping()) || !PropertyValidator.isValid((Object)tMap.getTeamMapping().getTeamId()) || !tMap.getTeamMapping().getTeamId().equals(team.getTempId())) continue;
                        tMap.getTeamMapping().setTeamId(team.getId());
                    }
                    team = this.convertJiraSprintsAndVersionToKSprints(team, almConfigs.getAlmAccount().getId());
                } else {
                    team = this.convertJiraSprintsAndVersionToKSprints(team, null);
                }
                resultList.add(team);
            }
        }
        if (PropertyValidator.isValid(teamsToUpdate)) {
            for (Team team : teamsToUpdate) {
                team = PropertyValidator.isValid((Object)almConfigs) ? this.convertJiraSprintsAndVersionToKSprints(team, almConfigs.getAlmAccount().getId()) : this.convertJiraSprintsAndVersionToKSprints(team, null);
                resultList.add(team);
            }
        }
        return resultList;
    }

    public Team convertJiraSprintsAndVersionToKSprints(Team team, String almAccId) {
        Sprint sp;
        if (PropertyValidator.isValid((Collection)team.getJiraSprints())) {
            ArrayList<Sprint> sprints = new ArrayList<Sprint>();
            for (JiraSprint jiraSprint : team.getJiraSprints()) {
                sp = new Sprint();
                sp.setSuspendActivity(true);
                sp.setTitle(jiraSprint.getName());
                sp.setJiraId(jiraSprint.getJiraId());
                sp.setAlmAccountId(almAccId);
                this.sprintRepository.save((Object)sp);
                sprints.add(sp);
            }
            team.setSprints(sprints);
        }
        if (PropertyValidator.isValid((Collection)team.getJiraVersions())) {
            ArrayList<Sprint> versions = new ArrayList<Sprint>();
            for (JiraVersion jiraVersion : team.getJiraVersions()) {
                sp = new Sprint();
                sp.setSuspendActivity(true);
                sp.setTitle(jiraVersion.getName());
                sp.setJiraId(jiraVersion.getJiraId());
                sp.setIsVersion(Boolean.TRUE);
                sp.setAlmAccountId(almAccId);
                this.sprintRepository.save((Object)sp);
                versions.add(sp);
            }
            team.setSprints(versions);
        }
        return team;
    }

    public void saveItemSyncMappers(SessionBoardVo sessionBoardVo, AlmConfigurations almConfigs, SessionBoard sessionBoard) {
        HashMap<String, Container> sprintTeamIdMap = new HashMap<String, Container>();
        LOGGER.trace("INSIDE saveItemSyncMappers");
        List containers = sessionBoardVo.getContainers();
        if (PropertyValidator.isValid((Collection)containers)) {
            for (Container cont : containers) {
                if (cont.getTempId() != null && cont.getTempId().equals(cont.getId())) {
                    String tmpId = cont.getTempId();
                    cont.setId(null);
                    cont.setSuspendActivity(true);
                    cont = (Container)this.containerRepository.save((Object)cont);
                    sprintTeamIdMap.put(tmpId, cont);
                    continue;
                }
                sprintTeamIdMap.put(cont.getId(), cont);
            }
        }
        sessionBoard.setContainers(containers);
        sessionBoard.setSuspendActivity(true);
        sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
        List itemSyncMapper = sessionBoardVo.getItemSyncMapper();
        if (PropertyValidator.isValid((Collection)itemSyncMapper)) {
            for (ItemSyncMapper tsm : itemSyncMapper) {
                tsm.setSessionBoard(sessionBoard);
                Container containr = (Container)sprintTeamIdMap.get(tsm.getContainer().getId());
                if (PropertyValidator.isValid((Object)containr)) {
                    tsm.setContainer(containr);
                }
                Team team = tsm.getTeam();
                List sessionTeams = sessionBoardVo.getTeams();
                if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Collection)sessionTeams)) {
                    Team sTeam = sessionTeams.stream().filter(tm -> team.getId().equals(tm.getTempId())).findAny().orElse(null);
                    tsm.setTeam(sTeam);
                }
                String tempSprintId = tsm.getSprint().getId();
                for (BacklogMapping teamMapping : almConfigs.getTeamMappings()) {
                    if (!PropertyValidator.isValid((Object)teamMapping) || !teamMapping.isSyncedFlag() || !teamMapping.getTeamId().equals(tsm.getTeam().getId()) || !PropertyValidator.isValid((Object)tempSprintId)) continue;
                    tsm.setCreateNewInJira(Boolean.FALSE);
                    if ("0".equals(tempSprintId)) {
                        tsm.setSprint(null);
                        continue;
                    }
                    if ("+1".equals(tempSprintId)) {
                        tsm.setSprint(this.createSprintInJira(tsm, almConfigs.getAlmAccount(), teamMapping, tsm.getContainer(), sessionBoard.getId(), null, null, null));
                        tsm.setCreateNewInJira(Boolean.FALSE);
                        continue;
                    }
                    if ("+2".equals(tempSprintId)) {
                        tsm.setSprint(this.createVersionInJira(tsm, almConfigs.getAlmAccount(), teamMapping, tsm.getContainer()));
                        tsm.setCreateNewInJira(Boolean.FALSE);
                        continue;
                    }
                    Sprint sprint = this.sprintRepository.findSprintByJiraIdAndIsVersionAndAlmAccountId(tempSprintId, tsm.getSprint().getIsVersion(), almConfigs.getAlmAccount().getId());
                    tsm.setSprint(sprint);
                }
                tsm.setSuspendActivity(true);
                this.itemSyncMapperRepository.save((Object)tsm);
            }
        }
        sessionBoardVo.setSessionBoard(sessionBoard);
        sessionBoardVo.setId(sessionBoard.getId());
        sessionBoardVo.setContainers(containers);
        sessionBoardVo.setItemSyncMapper(itemSyncMapper);
        this.convertJiraIssuesAccordingToMapping(sessionBoardVo, null, null);
        LOGGER.trace("Leaving saveItemSyncMappers");
    }

    public void saveItemSyncMappersForResync(SessionBoard sessionBoard) {
        SessionBoardVo sessionBoardVo = new SessionBoardVo();
        sessionBoardVo.setSessionBoard(sessionBoard);
        sessionBoardVo.setId(sessionBoard.getId());
        sessionBoardVo.setContainers(sessionBoard.getContainers());
        sessionBoardVo.setItemSyncMapper(this.itemSyncMapperRepository.findBySessionBoard(sessionBoard));
        this.updateBoardItemsForResync(sessionBoardVo);
    }

    private Set<ItemJiraFieldMap> getExtraFields(String almAccountId, Item item, JiraField sprintField) {
        HashSet<ItemJiraFieldMap> extraFields = new HashSet<ItemJiraFieldMap>();
        if (PropertyValidator.isValid((Collection)item.getJiraFieldMap())) {
            extraFields.addAll(item.getJiraFieldMap());
        }
        extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.reporter.name(), null, "JSONObject"));
        extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.assignee.name(), null, "JSONObject"));
        extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.issuetype.name(), null, "JSONObject"));
        extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.updated.name(), null, "string"));
        extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.created.name(), null, "string"));
        if (sprintField == null) {
            sprintField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-sprint", almAccountId);
        }
        if (sprintField != null) {
            extraFields.add(new ItemJiraFieldMap(sprintField.getJiraId(), null, "JSONArray"));
        }
        return extraFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUsInJira(Item item, SessionBoard board, User loggedInUser) {
        HashMap<String, Object> updateJson;
        if (item != null) {
            item.setSuspendActivity(true);
        }
        board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)board.getId()));
        HashMap<String, Object> jiraJson = new HashMap<String, Object>();
        Item parent = (Item)this.itemRepository.findOne((Serializable)((Object)item.getParent().getId()));
        AlmConfigurations almConfigurations = (AlmConfigurations)board.getSession().getAlmConfigurations().get(0);
        AlmAccount almAccount = almConfigurations.getAlmAccount();
        AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
        String almUsername = "";
        String almPassword = "";
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                almAccount.setJiraOauthToken(almAccUser.getJiraOauthToken());
                almAccount.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                almAccount.setJiraOauthToken(null);
                almUsername = almAccUser.getAlmUsername();
                almPassword = almAccUser.getAlmPassword();
                almAccount.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
            almAccount.setIsTaggedUser(Boolean.valueOf(true));
        } else {
            almUsername = almAccount.getUsername();
            almPassword = almAccount.getPassword();
            almAccount.setAdminAlmAcc(Boolean.valueOf(true));
        }
        almAccount.setOAuthTokenOwnerUserId(loggedInUser.getId());
        item.setSuspendActivity(true);
        jiraJson.put("AlmAccountId", almAccount.getId());
        jiraJson.put("title", item.getTitle());
        List teamMappings = almConfigurations.getTeamMappings();
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            TeamContainer tc = (TeamContainer)item.getTeamContainers().get(0);
            tc = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)tc.getId()));
            Sprint sprint = null;
            for (BacklogMapping teamMapping : teamMappings) {
                if (PropertyValidator.isValid((Object)teamMapping) && teamMapping.isSyncedFlag() && teamMapping.getTeamId().equals(tc.getTeam().getId())) {
                    jiraJson.put("project", item.getJiraProjectKey());
                    jiraJson.put("issuetype", item.getJiraIssueTypeId());
                    ItemSyncMapper itemSyncMapper = this.itemSyncMapperRepository.findByTeamAndContainer(tc.getTeam(), tc.getContainer());
                    if (PropertyValidator.isValid((Object)itemSyncMapper)) {
                        sprint = itemSyncMapper.getSprint();
                    }
                    if (sprint != null) {
                        if (sprint.getIsVersion().booleanValue()) {
                            jiraJson.put("fixVersions", sprint.getJiraId());
                        } else {
                            jiraJson.put("sprint", sprint.getJiraId());
                        }
                    }
                    break;
                }
                if (sprint != null) continue;
                jiraJson.put("project", item.getJiraProjectKey());
                jiraJson.put("issuetype", item.getJiraIssueTypeId());
            }
        } else {
            jiraJson.put("project", item.getJiraProjectKey());
            jiraJson.put("issuetype", item.getJiraIssueTypeId());
        }
        if (PropertyValidator.isValid((Object)item.getStoryPoints())) {
            jiraJson.put("Story Points", item.getStoryPoints());
        }
        boolean linkCreated = false;
        boolean createLink = Boolean.FALSE;
        if (parent.getJiraId() != null && PropertyValidator.isValid((Object)item.getLinkType()) && !board.getSession().getJiraSynapseRTEnabled().booleanValue()) {
            if ("+1".equals(item.getLinkType().getJiraId())) {
                jiraJson.put(almAccount.getJiraEpicLinkClause(), parent.getJiraKey());
                linkCreated = true;
            } else if (item.getLinkType().getId().equals("parent")) {
                jiraJson.put(item.getLinkType().getId(), parent.getJiraKey());
                linkCreated = true;
            } else if (item.getLinkType().getId().contains("custom")) {
                linkCreated = true;
            }
        }
        try {
            jiraJson.put("almAccount", almAccount);
            String response = this.exportUtil.createJiraIssue(almAccount.getUrl(), almUsername, almPassword, jiraJson, item.getJiraFieldMap());
            List duplicatedItem = null;
            if (PropertyValidator.isValid((Object)response)) {
                JSONObject responseObj = new JSONObject(response);
                String jiraId = responseObj.getString("id");
                item.setJiraKey(responseObj.getString("key"));
                item.setJiraId(jiraId);
                item.setDeletedInJira(false);
                item = (Item)this.itemRepository.save((Object)item);
                HashMap<String, String> doc = new HashMap<String, String>();
                doc.put("_id", jiraId + "_" + board.getId());
                doc.put("kendisId", item.getId());
                this.customRepositoryImpl.saveItemTTL(doc, 30L);
                Item itemForSprintReport = item;
                new Thread(() -> {
                    Item dbItem = this.itemRepository.findById(itemForSprintReport.getId());
                    if (PropertyValidator.isValid((Object)dbItem) && PropertyValidator.isValid((Object)dbItem.getParent())) {
                        this.customRepositoryImpl.addAuditLogEntryInActiveSprintForSingleItem(dbItem);
                    }
                }).start();
                if (board.getSession().getJiraSynapseRTEnabled().booleanValue() && item.getParent().getJiraId() != null) {
                    String synapseResponse = this.exportUtil.addChildRequirementToSynapseRT(item.getParent().getJiraKey(), item.getJiraKey(), almAccount);
                    LOGGER.info("Succes: response synapseResponse::" + synapseResponse);
                }
                LOGGER.info("Succes: response from ALM::" + response);
            }
            if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                if (!linkCreated) {
                    createLink = Boolean.TRUE;
                }
                createLink = Boolean.TRUE;
                PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)item, (String)board.getId(), (String)"Update", null, (Boolean)true, (Boolean)false));
                this.updateJiraKeyInLogs(item.getId(), item.getJiraKey(), item.getJiraId());
            }
            if (PropertyValidator.isValid(duplicatedItem)) {
                for (Item del : duplicatedItem) {
                    PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)del, (String)board.getId(), (String)"WebhookDelete", (String)"Item has been deleted in JIRA", (Boolean)false, (Boolean)true));
                }
            }
            JiraIssue jIssue = null;
            boolean applySelectedStatus = false;
            try {
                jIssue = this.almService.retrieveJiraIssueById(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, almAccount);
                jIssue.setItemTypeTobeConvertedInto(Item.USER_STORY);
                jIssue.setConvertedToItem(Boolean.valueOf(true));
                item.setJiraProjectKey(jIssue.getFields().getProject().getKey());
                item.setJiraIssueTypeId(jIssue.getFields().getIssuetype().getId());
                if (PropertyValidator.isValid((Object)jIssue.getMapFields())) {
                    item.putCustomeFieldValues((Map)jIssue.getMapFields(), (Collection)this.getExtraFields(almAccount.getId(), item, null), false);
                    if (PropertyValidator.isValid((Object)item.getJiraFieldByKey())) {
                        PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)item, (String)board.getId(), (String)"Update", null, (Boolean)false, (Boolean)false));
                    }
                }
                item = (Item)this.itemRepository.save((Object)item);
                if (PropertyValidator.isValid((Object)jIssue) && PropertyValidator.isValid((Object)jIssue.getFields().getStatus())) {
                    item.setStatus((Status)this.statusRepository.findOne((Serializable)((Object)item.getStatus().getId())));
                    if (!jIssue.getFields().getStatus().getId().equals(item.getStatus().getJiraStatusId())) {
                        applySelectedStatus = true;
                    }
                }
            }
            catch (ViztrendJiraException e) {
                LOGGER.warn("createUsInJira --> Failed to reterieve jira issue. AFTER CREATE|UPDATE" + e.getMessage());
            }
            if (applySelectedStatus) {
                JiraTransition transition = this.checkWhetherTransitionIsPossible(item, board, almUsername, almPassword);
                if (transition != null) {
                    response = this.postTransitionToJira(transition, item, board, almUsername, almPassword);
                    LOGGER.info("createUsInJira response from ALM::" + response);
                    item.setErrorInAlmSync(Boolean.valueOf(false));
                    item.setAlmErrorMessage(null);
                    this.itemRepository.save((Object)item);
                    this.almErrorRepository.deleteByItemId(item.getId());
                } else {
                    ViztrendJiraException e = new ViztrendJiraException(Integer.valueOf(0), "Transition to selected Status is not possible In Jira. Please select status according to workflow in Jira.");
                    this.pushAlmError(null, e, item, board, loggedInUser, Boolean.valueOf(true));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error("ERROR setting jira Key. ");
        }
        catch (ViztrendJiraException e) {
            this.pushAlmError("Creating Link ALM:: FAILED.. error message saved in item.", e, item, board, loggedInUser, Boolean.valueOf(false));
        }
        if (createLink && !board.getSession().getJiraSynapseRTEnabled().booleanValue() && parent.getJiraId() != null && PropertyValidator.isValid((Object)item.getLinkType())) {
            try {
                if ("+1".equals(item.getLinkType().getJiraId())) {
                    updateJson = new HashMap();
                    updateJson.put(almAccount.getJiraEpicLinkLabel(), parent.getJiraKey());
                    updateJson.put("almAccount", almAccount);
                    updateJson.put("AlmAccountId", almAccount.getId());
                    updateJson.put("projectKey", item.getJiraProjectKey());
                    if (PropertyValidator.isValid((Object)((SessionBoard)parent.getSessionBoards().get(0)).getSession())) {
                        updateJson.put("notifyUsers", ((SessionBoard)parent.getSessionBoards().get(0)).getSession().getNotifyJiraUsers());
                    }
                    jiraJson.put("issuetype", item.getJiraIssueTypeId());
                    this.exportUtil.updateIssueInJira(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, updateJson, null, false);
                    linkCreated = true;
                } else if ("parent".equals(item.getLinkType().getJiraId())) {
                    updateJson = new HashMap();
                    updateJson.put(item.getLinkType().getJiraId(), parent.getJiraKey());
                    updateJson.put("almAccount", almAccount);
                    updateJson.put("AlmAccountId", almAccount.getId());
                    updateJson.put("projectKey", item.getJiraProjectKey());
                    if (PropertyValidator.isValid((Object)((SessionBoard)parent.getSessionBoards().get(0)).getSession())) {
                        updateJson.put("notifyUsers", ((SessionBoard)parent.getSessionBoards().get(0)).getSession().getNotifyJiraUsers());
                    }
                    jiraJson.put("issuetype", item.getJiraIssueTypeId());
                    this.exportUtil.updateIssueInJira(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, updateJson, null, true);
                    linkCreated = true;
                } else if (PropertyValidator.isValid((Object)item.getLinkType().getJiraId()) && item.getLinkType().getJiraId().contains("customfield_")) {
                    updateJson = new HashMap();
                    updateJson.put(item.getLinkType().getJiraId(), parent.getJiraKey());
                    updateJson.put("almAccount", almAccount);
                    updateJson.put("AlmAccountId", almAccount.getId());
                    updateJson.put("projectKey", item.getJiraProjectKey());
                    if (PropertyValidator.isValid((Object)((SessionBoard)parent.getSessionBoards().get(0)).getSession())) {
                        updateJson.put("notifyUsers", ((SessionBoard)parent.getSessionBoards().get(0)).getSession().getNotifyJiraUsers());
                    }
                    jiraJson.put("issuetype", item.getJiraIssueTypeId());
                    this.exportUtil.updateIssueInJira(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, updateJson, null, false);
                    linkCreated = true;
                } else if ("IN".equals(item.getLinkType().getDirection())) {
                    this.exportUtil.createJiraIssueLink(parent.getJiraId(), item.getJiraId(), item.getLinkType().getId(), almAccount.getUrl(), almUsername, almPassword, almConfigurations.getAlmAccount());
                    linkCreated = true;
                } else if (!PropertyValidator.isValid((Object)item.getLinkType().getJiraId()) || !item.getLinkType().getJiraId().contains("customfield_")) {
                    this.exportUtil.createJiraIssueLink(item.getJiraId(), parent.getJiraId(), item.getLinkType().getId(), almAccount.getUrl(), almUsername, almPassword, almConfigurations.getAlmAccount());
                    linkCreated = true;
                }
            }
            catch (ViztrendJiraException e) {
                this.pushAlmError("Creating Link ALM:: FAILED.. error message saved in item.", e, item, board, loggedInUser, Boolean.valueOf(false));
            }
        }
        if (linkCreated || board.getSession().getJiraSynapseRTEnabled().booleanValue()) {
            updateJson = new HashMap<String, Object>();
            if (PropertyValidator.isValid((Object)parent)) {
                List childItems = this.itemRepository.findByParentId(parent.getId());
                Double totalEstimate = 0.0;
                for (Item childItem : childItems) {
                    totalEstimate = totalEstimate + childItem.getStoryPoints();
                }
                this.customRepository.updateItemStoryPoints(parent.getId(), totalEstimate);
                parent.setSubItemEstimate(totalEstimate);
                if (PropertyValidator.isValid((Object)item.getLinkType())) {
                    try {
                        if (!PropertyValidator.isValid((Collection)parent.getLinkTypes())) {
                            parent.setLinkTypes(new ArrayList());
                        }
                        HashSet<JiraIssueLinkType> linkSet = new HashSet<JiraIssueLinkType>(parent.getLinkTypes());
                        linkSet.add(JiraUtils.reverseJiraLinkDirection((JiraIssueLinkType)item.getLinkType()));
                        parent.setLinkTypes(new ArrayList(linkSet));
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        parent.setSuspendActivity(true);
                        parent = (Item)this.itemRepository.save((Object)parent);
                    }
                } else {
                    this.customRepository.updateItemStoryPoints(parent.getId(), totalEstimate);
                }
            }
        }
    }

    public void createIssueLinkInJira2(String inwardIssueId, String outwardIssueId, String type, String almId, String syncId) {
        HashMap jiraJson = new HashMap();
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
        String almUsername = "";
        String almPassword = "";
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                almAccount.setJiraOauthToken(almAccUser.getJiraOauthToken());
                almAccount.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                almAccount.setJiraOauthToken(null);
                almUsername = almAccUser.getAlmUsername();
                almPassword = almAccUser.getAlmPassword();
                almAccount.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
            almAccount.setIsTaggedUser(Boolean.valueOf(true));
        } else {
            almUsername = almAccount.getUsername();
            almPassword = almAccount.getPassword();
            almAccount.setAdminAlmAcc(Boolean.valueOf(true));
        }
        almAccount.setOAuthTokenOwnerUserId(loggedInUser.getId());
        this.exportUtil.createJiraIssueLink(inwardIssueId, outwardIssueId, type, almAccount.getUrl(), almUsername, almPassword, almAccount);
    }

    public void createIssueLinkInJira(String inwardIssueId, String outwardIssueId, String type, String direction) {
        HashMap<String, String> jiraJson = new HashMap<String, String>();
        Item inwardIssue = (Item)this.itemRepository.findOne((Serializable)((Object)inwardIssueId));
        Item outwardIssue = (Item)this.itemRepository.findOne((Serializable)((Object)outwardIssueId));
        AlmConfigurations almConfigurations = (AlmConfigurations)((SessionBoard)inwardIssue.getSessionBoards().get(0)).getSession().getAlmConfigurations().get(0);
        AlmAccount almAccount = almConfigurations.getAlmAccount();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
        String almUsername = "";
        String almPassword = "";
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                almAccount.setJiraOauthToken(almAccUser.getJiraOauthToken());
                almAccount.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                almAccount.setJiraOauthToken(null);
                almUsername = almAccUser.getAlmUsername();
                almPassword = almAccUser.getAlmPassword();
                almAccount.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
            almAccount.setIsTaggedUser(Boolean.valueOf(true));
        } else {
            almUsername = almAccount.getUsername();
            almPassword = almAccount.getPassword();
            almAccount.setAdminAlmAcc(Boolean.valueOf(true));
        }
        almAccount.setOAuthTokenOwnerUserId(loggedInUser.getId());
        try {
            if ("+1".equals(type)) {
                HashMap<String, Object> updateJson = new HashMap<String, Object>();
                updateJson.put(almAccount.getJiraEpicLinkClause(), outwardIssue.getJiraKey());
                updateJson.put("almAccount", almAccount);
                updateJson.put("AlmAccountId", almAccount.getId());
                updateJson.put("projectKey", outwardIssue.getJiraProjectKey());
                if (PropertyValidator.isValid((Object)((SessionBoard)outwardIssue.getSessionBoards().get(0)).getSession())) {
                    updateJson.put("notifyUsers", ((SessionBoard)outwardIssue.getSessionBoards().get(0)).getSession().getNotifyJiraUsers());
                }
                jiraJson.put("issuetype", inwardIssue.getJiraIssueTypeId());
                this.exportUtil.updateIssueInJira(inwardIssue.getJiraId(), almAccount.getUrl(), almUsername, almPassword, updateJson, null, false);
            } else if ("IN".equals(direction)) {
                this.exportUtil.createJiraIssueLink(outwardIssue.getJiraId(), inwardIssue.getJiraId(), type, almAccount.getUrl(), almUsername, almPassword, almConfigurations.getAlmAccount());
            } else if (!PropertyValidator.isValid((Object)type) || !type.contains("customfield_")) {
                this.exportUtil.createJiraIssueLink(inwardIssue.getJiraId(), outwardIssue.getJiraId(), type, almAccount.getUrl(), almUsername, almPassword, almConfigurations.getAlmAccount());
            }
        }
        catch (ViztrendJiraException e) {
            this.pushAlmError("Creating Link ALM:: FAILED.. error message saved in item.", e, inwardIssue, (SessionBoard)inwardIssue.getSessionBoards().get(0), loggedInUser, Boolean.valueOf(false));
        }
    }

    public void editUsInJira(Item savedItem, Item item, SessionBoard board, User loggedInUser) {
        if (item != null) {
            item.setSuspendActivity(true);
        }
        if (savedItem != null) {
            savedItem.setSuspendActivity(true);
        }
        if (item == null || item.getJiraId() == null) {
            return;
        }
        HashMap<String, Object> jiraJson = new HashMap<String, Object>();
        AlmConfigurations almConfigurations = (AlmConfigurations)board.getSession().getAlmConfigurations().get(0);
        AlmAccount almAccount = this.getJiraLoginForApi(board, loggedInUser);
        String almUsername = almAccount.getUsernameForApi();
        String almPassword = almAccount.getPasswordForApi();
        jiraJson.put("AlmAccountId", almAccount.getId());
        jiraJson.put("title", item.getTitle());
        List teamMappings = almConfigurations.getTeamMappings();
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            TeamContainer tc = (TeamContainer)item.getTeamContainers().get(0);
            if (PropertyValidator.isValid((Object)tc) && PropertyValidator.isValid((Object)tc.getId())) {
                tc = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)tc.getId()));
            }
            Sprint sprint = null;
            if (PropertyValidator.isValid((Collection)teamMappings) && PropertyValidator.isValid((Object)tc)) {
                for (BacklogMapping teamMapping : teamMappings) {
                    if (!teamMapping.getTeamId().equals(tc.getTeam().getId())) continue;
                    jiraJson.put("project", item.getJiraProjectKey());
                    jiraJson.put("issuetype", item.getJiraIssueTypeId());
                    ItemSyncMapper itemSyncMapper = this.itemSyncMapperRepository.findByTeamAndContainer(tc.getTeam(), tc.getContainer());
                    if (PropertyValidator.isValid((Object)itemSyncMapper)) {
                        sprint = itemSyncMapper.getSprint();
                    }
                    if (sprint == null) break;
                    if (sprint.getIsVersion().booleanValue()) {
                        jiraJson.put("fixVersions", sprint.getJiraId());
                        break;
                    }
                    jiraJson.put("sprint", sprint.getJiraId());
                    break;
                }
            }
        }
        jiraJson.put("Story Points", item.getStoryPoints());
        String response = null;
        this.itemRepository.save((Object)item);
        try {
            if (PropertyValidator.isValid((Object)item.getMetaMap())) {
                ArrayList<String> issueIds = new ArrayList<String>();
                issueIds.add(item.getJiraId());
                Gson gson = new Gson();
                1 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap paramMap = (HashMap)gson.fromJson(item.getMetaMap(), T.getType());
                String sprintId = (String)paramMap.get("jiraSprintId");
                if ((PropertyValidator.isValid((Object)sprintId) || "".equals(sprintId)) && !"-1".equals(sprintId)) {
                    if ("".equals(sprintId)) {
                        this.exportUtil.moveIssuesToBacklog(issueIds, almAccount.getUrl(), almUsername, almPassword, almAccount);
                    } else {
                        this.putSprintInJSON(jiraJson, sprintId, almAccount.getId());
                    }
                }
            }
            jiraJson.put("almAccount", almAccount);
            if (PropertyValidator.isValid((Object)board.getSession())) {
                jiraJson.put("notifyUsers", board.getSession().getNotifyJiraUsers());
            }
            jiraJson.put("projectKey", item.getJiraProjectKey());
            jiraJson.put("issuetype", item.getJiraIssueTypeId());
            response = this.exportUtil.updateIssueInJira(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, jiraJson, item.getJiraFieldMap(), false);
            LOGGER.info("Story update response from ALM::" + response);
            boolean applySelectedStatus = false;
            try {
                JiraIssue jIssue = this.almService.retrieveJiraIssueById(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, almAccount);
                jIssue.setItemTypeTobeConvertedInto(Item.FEATURE);
                jIssue.setConvertedToItem(Boolean.valueOf(true));
                if (PropertyValidator.isValid((Object)jIssue) && PropertyValidator.isValid((Object)jIssue.getFields().getStatus())) {
                    item.setStatus((Status)this.statusRepository.findOne((Serializable)((Object)item.getStatus().getId())));
                    if (!jIssue.getFields().getStatus().getId().equals(item.getStatus().getJiraStatusId())) {
                        applySelectedStatus = true;
                    }
                    Set configFields = this.getExtraFields(almAccount.getId(), item, null);
                    if (PropertyValidator.isValid((Object)board.getSession())) {
                        configFields.addAll(board.getSession().combineAdditionalFields(null, null, true, null));
                    }
                    if (PropertyValidator.isValid((Object)jIssue.getMapFields()) && PropertyValidator.isValid((Collection)configFields)) {
                        item.putCustomeFieldValues((Map)jIssue.getMapFields(), (Collection)configFields, false);
                    }
                }
            }
            catch (ViztrendJiraException e) {
                LOGGER.warn("createUsInJira --> Failed to reterieve jira issue. AFTER CREATE|UPDATE" + e.getMessage());
            }
            boolean statusError = false;
            if (applySelectedStatus) {
                JiraTransition transition = this.checkWhetherTransitionIsPossible(item, board, almUsername, almPassword);
                if (transition != null) {
                    response = this.postTransitionToJira(transition, item, board, almUsername, almPassword);
                    LOGGER.info("editUsInJira --> postTransitionToJira response from ALM::" + response);
                    item.setErrorInAlmSync(Boolean.valueOf(false));
                    item.setAlmErrorMessage(null);
                    this.itemRepository.save((Object)item);
                    this.almErrorRepository.deleteByItemId(item.getId());
                } else {
                    ViztrendJiraException e = new ViztrendJiraException(Integer.valueOf(0), "Transition to selected Status is not possible In Jira. Please select status according to workflow in Jira.");
                    this.pushAlmError(null, e, item, board, loggedInUser, Boolean.valueOf(true));
                    statusError = true;
                }
            }
            if (!statusError) {
                item.setErrorInAlmSync(Boolean.valueOf(false));
                item.setAlmErrorMessage(null);
                item.setDeletedInJira(false);
                this.itemRepository.save((Object)item);
                this.almErrorRepository.deleteByItemId(item.getId());
                PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)item, (String)board.getId(), (String)"Update", null, (Boolean)true, (Boolean)false));
            }
            if (PropertyValidator.isValid((Object)savedItem) && PropertyValidator.isValid((Object)savedItem.getParent())) {
                if (!savedItem.getParent().getId().equals(item.getParent().getId())) {
                    // empty if block
                }
                HashMap hashMap = new HashMap();
            }
        }
        catch (ViztrendJiraException e) {
            this.pushAlmError("editUsInJira --> response from ALM:: FAILED.. error message saved in item.", e, item, board, loggedInUser, Boolean.valueOf(false));
        }
    }

    public String postTransitionToJira(JiraTransition transition, Item item, SessionBoard board, String username, String password) {
        AlmConfigurations almConfigurations = (AlmConfigurations)board.getSession().getAlmConfigurations().get(0);
        AlmAccount almAccount = almConfigurations.getAlmAccount();
        boolean notifyUsers = false;
        if (PropertyValidator.isValid((Object)board.getSession())) {
            notifyUsers = board.getSession().getNotifyJiraUsers();
        }
        return this.exportUtil.doTransitionInJira(transition.getId(), item.getJiraId(), almAccount.getUrl(), username, password, almAccount, Boolean.valueOf(notifyUsers));
    }

    private JiraTransition checkWhetherTransitionIsPossible(Item item, SessionBoard board, String almUsername, String almPassword) {
        List transitions;
        AlmConfigurations almConfigurations = (AlmConfigurations)board.getSession().getAlmConfigurations().get(0);
        AlmAccount almAccount = almConfigurations.getAlmAccount();
        if (PropertyValidator.isValid((Object)item.getJiraId()) && PropertyValidator.isValid((Collection)(transitions = this.almSyncService.retrieveTransitionsByIssueId(item.getJiraId(), almAccount, almUsername, almPassword)))) {
            Status status = (Status)this.statusRepository.findOne((Serializable)((Object)item.getStatus().getId()));
            for (JiraTransition trans : transitions) {
                if (!trans.getTo().getId().equals(status.getJiraStatusId())) continue;
                return trans;
            }
        }
        return null;
    }

    public void editFeatureScoreInJira(Item item, SessionBoard board, boolean editMode, User loggedInUser) throws Exception {
        if (editMode && (item == null || item.getJiraId() == null)) {
            LOGGER.error("Failed: Feature is a Kendis Only item");
            return;
        }
        HashMap<String, Object> jiraJson = new HashMap<String, Object>();
        board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)board.getId()));
        Session session = this.sessionRepository.findById(board.getSession().getId());
        AlmConfigurations almConfigurations = (AlmConfigurations)board.getSession().getAlmConfigurations().get(0);
        AlmAccount almAccount = almConfigurations.getAlmAccount();
        AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
        String almUsername = "";
        String almPassword = "";
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                almAccount.setJiraOauthToken(almAccUser.getJiraOauthToken());
                almAccount.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                almAccount.setJiraOauthToken(null);
                almUsername = almAccUser.getAlmUsername();
                almPassword = almAccUser.getAlmPassword();
                almAccount.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
            almAccount.setIsTaggedUser(Boolean.valueOf(true));
        } else {
            almUsername = almAccount.getUsername();
            almPassword = almAccount.getPassword();
            almAccount.setAdminAlmAcc(Boolean.valueOf(true));
        }
        almAccount.setOAuthTokenOwnerUserId(loggedInUser.getId());
        jiraJson.put("almAccount", almAccount);
        if (PropertyValidator.isValid((Object)item.getScore()) && PropertyValidator.isValid((Object)board.getSession()) && PropertyValidator.isValid((Object)board.getSession().getwsjfAlmFieldKey())) {
            jiraJson.put(board.getSession().getwsjfAlmFieldKey(), item.getScore());
        }
        String response = "";
        Item freshItem = null;
        if (editMode) {
            List lsPairs = this.scoreCardService.getScoreCardOnlyItemJiraFieldMap(session.getScoreCard().getMappings(), item);
            try {
                response = this.exportUtil.updateIssueInJira(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, jiraJson, lsPairs, false);
                freshItem = this.itemRepository.findById(item.getId());
                freshItem.setAlmScoreField(item.getScore());
                freshItem = (Item)this.itemRepository.save((Object)item);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
    }

    private void updateSprintInJira(Item actionItem, String jiraSprintId, SessionBoard board, AlmAccount alm, String almUsername, String almPassword, User loggedInUser) {
        if (PropertyValidator.isValid((Object)jiraSprintId) && !"-1".equals(jiraSprintId)) {
            HashMap<String, Object> updateJson = new HashMap<String, Object>();
            this.putSprintInJSON(updateJson, jiraSprintId, alm.getId());
            if (!updateJson.isEmpty()) {
                try {
                    updateJson.put("projectKey", actionItem.getJiraProjectKey());
                    updateJson.put("issuetype", actionItem.getJiraIssueTypeId());
                    updateJson.put("AlmAccountId", alm.getId());
                    updateJson.put("almAccount", alm);
                    if (PropertyValidator.isValid((Object)board.getSession())) {
                        updateJson.put("notifyUsers", board.getSession().getNotifyJiraUsers());
                    }
                    this.exportUtil.updateIssueInJira(actionItem.getJiraId(), alm.getUrl(), almUsername, almPassword, updateJson, null, false);
                }
                catch (ViztrendJiraException e) {
                    this.pushAlmError("Updating feature in ALM:: FAILED.. error message saved in item.", e, actionItem, board, loggedInUser, Boolean.valueOf(false));
                }
            }
        }
    }

    public void editFeatureInJira(Item savedItem, Item item, SessionBoard board, boolean editMode, User loggedInUser) {
        block55: {
            if (item != null) {
                item.setSuspendActivity(true);
            }
            if (savedItem != null) {
                savedItem.setSuspendActivity(true);
            }
            if (editMode && (item == null || item.getJiraId() == null)) {
                LOGGER.error("Failed: Feature is a Kendis Only item");
                return;
            }
            board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)board.getId()));
            String sesseionType = board.getSession().getSessionType();
            HashMap<String, Object> jiraJson = new HashMap<String, Object>();
            LOGGER.info("INSIDE editFeatureInJira: " + item.toString());
            if (PropertyValidator.isValid((Object)item.getDueDate())) {
                jiraJson.put("duedate", item.getDueDate());
            } else if (PropertyValidator.isValid((Object)savedItem) && PropertyValidator.isValid((Object)savedItem.getDueDate())) {
                jiraJson.put("duedate", null);
            }
            jiraJson.put("title", item.getTitle());
            AlmConfigurations almConfigurations = (AlmConfigurations)board.getSession().getAlmConfigurations().get(0);
            AlmAccount almAccount = almConfigurations.getAlmAccount();
            if (PropertyValidator.isValid((Object)almAccount.getStartDateField())) {
                if (PropertyValidator.isValid((Object)item.getStartDate())) {
                    jiraJson.put("startDate", item.getStartDate());
                } else {
                    jiraJson.put("startDate", null);
                }
            }
            if (PropertyValidator.isValid((Object)almAccount.getEndDateField())) {
                if (PropertyValidator.isValid((Object)item.getEndDate())) {
                    jiraJson.put("endDate", item.getEndDate());
                } else {
                    jiraJson.put("endDate", null);
                }
            }
            AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
            String almUsername = "";
            String almPassword = "";
            if (PropertyValidator.isValid((Object)almAccUser)) {
                if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                    almAccount.setJiraOauthToken(almAccUser.getJiraOauthToken());
                    almAccount.setAdminAlmAcc(Boolean.valueOf(false));
                } else {
                    almAccount.setJiraOauthToken(null);
                    almUsername = almAccUser.getAlmUsername();
                    almPassword = almAccUser.getAlmPassword();
                    almAccount.setIsPatOnProfile(almAccUser.getIsPatOn());
                }
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
            } else {
                almUsername = almAccount.getUsername();
                almPassword = almAccount.getPassword();
                almAccount.setAdminAlmAcc(Boolean.valueOf(true));
            }
            almAccount.setOAuthTokenOwnerUserId(loggedInUser.getId());
            jiraJson.put("AlmAccountId", almAccount.getId());
            BacklogMapping feaMapping = null;
            if (PropertyValidator.isValid((Object)item.getJiraProjectKey())) {
                String projectkey = item.getJiraProjectKey();
                List featureMappings = almConfigurations.getFeatureMappings();
                if (PropertyValidator.isValid((Collection)featureMappings)) {
                    for (BacklogMapping bMap : featureMappings) {
                        if (!bMap.getProjectKey().equals(projectkey)) continue;
                        feaMapping = bMap;
                        break;
                    }
                }
            }
            if (PropertyValidator.isValid((Object)item.getMetaMap()) && "nexus".equals(sesseionType) && !PropertyValidator.isValid(feaMapping)) {
                feaMapping = board.getSession().nexusFeatureMapping(item.getJiraProjectKey());
            }
            if (!editMode) {
                jiraJson.put("project", feaMapping.getProjectKey());
                jiraJson.put("issuetype", item.getJiraIssueTypeId());
                if (feaMapping.getJiraSprint() != null) {
                    jiraJson.put("sprint", feaMapping.getJiraSprint().getJiraId());
                }
                if (feaMapping.getJiraVersion() != null) {
                    jiraJson.put("fixVersions", feaMapping.getJiraVersion().getJiraId());
                }
            }
            jiraJson.put("Status", item.getStatus());
            if (PropertyValidator.isValid((Object)item.getMetaMap()) && "nexus".equals(sesseionType)) {
                jiraJson.put("Story Points", item.getStoryPoints() == null ? 0.0 : item.getStoryPoints());
            }
            String response = "";
            if (editMode) {
                try {
                    jiraJson.put("almAccount", almAccount);
                    if (PropertyValidator.isValid((Object)board.getSession())) {
                        jiraJson.put("notifyUsers", board.getSession().getNotifyJiraUsers());
                    }
                    jiraJson.put("projectKey", item.getJiraProjectKey());
                    jiraJson.put("issuetype", item.getJiraIssueTypeId());
                    response = this.exportUtil.updateIssueInJira(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, jiraJson, item.getJiraFieldMap(), false);
                    if (PropertyValidator.isValid((Object)item.getMetaMap()) && "nexus".equals(sesseionType)) {
                        Gson gson = new Gson();
                        2 T = new /* Unavailable Anonymous Inner Class!! */;
                        HashMap paramMap = (HashMap)gson.fromJson(item.getMetaMap(), T.getType());
                        this.updateSprintInJira(item, (String)paramMap.get("jiraSprintId"), board, almAccount, almUsername, almPassword, loggedInUser);
                    }
                    LOGGER.info("editFeatureInJira --> Feature update response from ALM::" + response);
                    boolean applySelectedStatus = false;
                    try {
                        JiraIssue jIssue = this.almService.retrieveJiraIssueById(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, almAccount);
                        jIssue.setItemTypeTobeConvertedInto(Item.FEATURE);
                        jIssue.setConvertedToItem(Boolean.valueOf(true));
                        if (PropertyValidator.isValid((Object)jIssue) && PropertyValidator.isValid((Object)jIssue.getFields().getStatus())) {
                            item.setStatus((Status)this.statusRepository.findOne((Serializable)((Object)item.getStatus().getId())));
                            if (!jIssue.getFields().getStatus().getId().equals(item.getStatus().getJiraStatusId())) {
                                applySelectedStatus = true;
                            }
                        }
                        Set configFields = new HashSet();
                        if (PropertyValidator.isValid((Object)jIssue.getMapFields())) {
                            configFields = this.getExtraFields(almAccount.getId(), item, null);
                        }
                        if (PropertyValidator.isValid((Object)board.getSession())) {
                            configFields.addAll(board.getSession().combineAdditionalFields(null, null, true, null));
                        }
                        if (PropertyValidator.isValid(configFields)) {
                            item.putCustomeFieldValues((Map)jIssue.getMapFields(), configFields, false);
                        }
                    }
                    catch (ViztrendJiraException e) {
                        LOGGER.warn("editFeatureInJira --> Failed to reterieve jira issue. AFTER CREATE|UPDATE" + e.getMessage());
                    }
                    boolean statusError = false;
                    if (applySelectedStatus) {
                        JiraTransition transition = this.checkWhetherTransitionIsPossible(item, board, almUsername, almPassword);
                        if (transition != null) {
                            response = this.postTransitionToJira(transition, item, board, almUsername, almPassword);
                            LOGGER.info("editFeatureInJira --> postTransitionToJira response from ALM::" + response);
                            item.setErrorInAlmSync(Boolean.valueOf(false));
                            item.setAlmErrorMessage(null);
                            this.itemRepository.save((Object)item);
                            this.almErrorRepository.deleteByItemId(item.getId());
                        } else {
                            ViztrendJiraException e = new ViztrendJiraException(Integer.valueOf(0), "Transition to selected Status is not possible In Jira. Please select status according to workflow in Jira.");
                            this.pushAlmError(null, e, item, board, loggedInUser, Boolean.valueOf(true));
                            statusError = true;
                        }
                    }
                    if (!statusError) {
                        item.setErrorInAlmSync(Boolean.valueOf(false));
                        item.setAlmErrorMessage(null);
                        item.setDeletedInJira(false);
                        this.itemRepository.save((Object)item);
                        this.almErrorRepository.deleteByItemId(item.getId());
                        PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)item, (String)board.getId(), (String)"Update", null, (Boolean)true, (Boolean)false));
                    }
                }
                catch (ViztrendJiraException e) {
                    this.pushAlmError("editFeatureInJira --> postTransitionToJira response from ALM:: FAILED.. error message saved in item.", e, item, board, loggedInUser, Boolean.valueOf(false));
                }
            } else {
                try {
                    jiraJson.put("almAccount", almAccount);
                    response = this.exportUtil.createJiraIssue(almAccount.getUrl(), almUsername, almPassword, jiraJson, item.getJiraFieldMap());
                    if (!PropertyValidator.isValid((Object)response)) break block55;
                    LOGGER.info("editFeatureInJira --> Feature create response from ALM::" + response);
                    try {
                        boolean statusError = false;
                        JSONObject responseObj = new JSONObject(response);
                        item.setJiraKey(responseObj.getString("key"));
                        item.setJiraId(responseObj.getString("id"));
                        item.setJiraProjectKey(feaMapping.getProjectKey());
                        boolean applySelectedStatus = false;
                        try {
                            JiraIssue jIssue = this.almService.retrieveJiraIssueById(item.getJiraId(), almAccount.getUrl(), almUsername, almPassword, almAccount);
                            jIssue.setItemTypeTobeConvertedInto(Item.FEATURE);
                            jIssue.setConvertedToItem(Boolean.valueOf(true));
                            if (PropertyValidator.isValid((Object)jIssue) && PropertyValidator.isValid((Object)jIssue.getFields().getStatus())) {
                                item.setStatus((Status)this.statusRepository.findOne((Serializable)((Object)item.getStatus().getId())));
                                if (!jIssue.getFields().getStatus().getId().equals(item.getStatus().getJiraStatusId())) {
                                    applySelectedStatus = true;
                                }
                            }
                            if (PropertyValidator.isValid((Object)jIssue.getMapFields())) {
                                item.putCustomeFieldValues((Map)jIssue.getMapFields(), (Collection)this.getExtraFields(almAccount.getId(), item, null), false);
                            }
                        }
                        catch (ViztrendJiraException e) {
                            this.pushAlmError(null, e, item, board, loggedInUser, Boolean.valueOf(true));
                            statusError = true;
                        }
                        if (applySelectedStatus) {
                            JiraTransition transition = this.checkWhetherTransitionIsPossible(item, board, almUsername, almPassword);
                            if (transition != null) {
                                response = this.postTransitionToJira(transition, item, board, almUsername, almPassword);
                                LOGGER.trace("editFeatureInJira --> postTransitionToJira response from ALM::" + response);
                                item.setErrorInAlmSync(Boolean.valueOf(false));
                                item.setAlmErrorMessage(null);
                                this.itemRepository.save((Object)item);
                                this.almErrorRepository.deleteByItemId(item.getId());
                            } else {
                                ViztrendJiraException e = new ViztrendJiraException(Integer.valueOf(0), "Transition to selected Status is not possible In Jira. Please select status according to workflow in Jira.");
                                this.pushAlmError(null, e, item, board, loggedInUser, Boolean.valueOf(true));
                                statusError = true;
                            }
                            LOGGER.debug("editFeatureInJira --> Feature status update response from ALM::" + response);
                        }
                        if (!statusError) {
                            item.setErrorInAlmSync(Boolean.valueOf(false));
                            item.setAlmErrorMessage(null);
                            item.setDeletedInJira(false);
                            item = (Item)this.itemRepository.save((Object)item);
                            this.almErrorRepository.deleteByItemId(item.getId());
                            PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)item, (String)board.getId(), (String)"Update", null, (Boolean)true, (Boolean)false));
                        }
                    }
                    catch (JSONException e) {
                        LOGGER.error("editFeatureInJira --> ERROR pushing jira Key", (Throwable)e);
                    }
                    if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                        this.updateJiraKeyInLogs(item.getId(), item.getJiraKey(), item.getJiraId());
                    }
                }
                catch (ViztrendJiraException e) {
                    this.pushAlmError("editFeatureInJira --> Failed to create jira issue.", e, item, board, loggedInUser, Boolean.valueOf(false));
                }
            }
        }
        LOGGER.trace("Leaving editFeatureInJira");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SessionBoard editSessionBoard(SessionBoardVo sBVo) {
        SessionBoard sessionBoard;
        block33: {
            Iterator almConfig2;
            boolean containerAdded;
            block34: {
                HashMap<String, Container> sprintTeamIdMap;
                Session sessionWrapper;
                boolean teamsAdded;
                block31: {
                    Object featureLinkMapping2;
                    block32: {
                        block30: {
                            sessionBoard = new SessionBoard();
                            teamsAdded = false;
                            containerAdded = false;
                            sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sBVo.getId()));
                            sessionWrapper = new Session();
                            if (PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                                sessionWrapper = sessionBoard.getSession();
                            }
                            sessionWrapper.setTitle(sBVo.getTitle());
                            sessionWrapper.setJiraBaseURL(sBVo.getJiraBaseURL());
                            sessionWrapper.setAlmEnabled(sBVo.getAlmEnabled());
                            sessionWrapper.setUseEnabler(sBVo.getUseEnabler());
                            sessionWrapper.setParentItem(sBVo.getParentItem());
                            sessionWrapper.setChildItem(sBVo.getChildItem());
                            sessionWrapper.setJiraContainer(sBVo.getJiraContainer());
                            if (Boolean.TRUE.equals(sBVo.getAlmEnabled())) {
                                sessionWrapper.setJiraBaseURL(AlmUtils.getJiraBrowseURL((String)((AlmConfigurations)sBVo.getAlmConfigurations().get(0)).getAlmAccount().getUrl()));
                            } else {
                                sessionWrapper.setJiraBaseURL(sBVo.getJiraBaseURL());
                            }
                            if (PropertyValidator.isValid((Object)sBVo.getDeleteActions())) {
                                this.handleContainerDelete((List)sBVo.getDeleteActions().get("sprint"), sessionBoard);
                                this.handleTeamDelete((List)sBVo.getDeleteActions().get("team"), sessionBoard);
                            }
                            if (!sBVo.getAlmEnabled().booleanValue()) break block30;
                            LOGGER.info("editSessionBoard --> ALM enabled");
                            this.jiraIssueRepository.deleteBySessionBoardIdAndConvertedToItem(sessionBoard.getId(), Boolean.valueOf(false));
                            AlmConfigurations almConfig2 = (AlmConfigurations)sBVo.getAlmConfigurations().get(0);
                            Map updatedFiltersMap = this.almSyncService.checkWhichFiltersWereUpdated(almConfig2);
                            List updatedFilters = (List)updatedFiltersMap.get("filter");
                            List updatedEnablers = (List)updatedFiltersMap.get("enabler");
                            if (PropertyValidator.isValid((Collection)updatedFilters) || PropertyValidator.isValid((Collection)updatedEnablers)) {
                                this.resyncData = true;
                            }
                            if (PropertyValidator.isValid((Collection)almConfig2.getFeatureFilter())) {
                                for (JiraFilter featureFilter : almConfig2.getFeatureFilter()) {
                                    for (FilterActionsVO feactions : almConfig2.getFeatureFilterActions()) {
                                        if (!PropertyValidator.isValid((Object)feactions.getAction()) || !"CREATION".equalsIgnoreCase(feactions.getAction())) continue;
                                        this.resyncData = true;
                                    }
                                }
                            }
                            if (PropertyValidator.isValid((Collection)almConfig2.getEnablerFilter())) {
                                for (JiraFilter featureFilter : almConfig2.getEnablerFilter()) {
                                    for (FilterActionsVO enablerFilActions : almConfig2.getEnablerFilterActions()) {
                                        if (!PropertyValidator.isValid((Object)enablerFilActions.getAction()) || !"CREATION".equalsIgnoreCase(enablerFilActions.getAction())) continue;
                                        this.resyncData = true;
                                    }
                                }
                            }
                            if (PropertyValidator.isValid((Collection)almConfig2.getFeatureLinkMappings())) {
                                for (Object featureLinkMapping2 : almConfig2.getFeatureLinkMappings()) {
                                    if ((!PropertyValidator.isValid((Object)featureLinkMapping2.getAction()) || !"CREATION".equalsIgnoreCase(featureLinkMapping2.getAction())) && (!PropertyValidator.isValid((Object)featureLinkMapping2.getAction()) || !"update".equalsIgnoreCase(featureLinkMapping2.getAction()))) continue;
                                    this.resyncData = true;
                                    break;
                                }
                            }
                            sprintTeamIdMap = new HashMap<String, Container>();
                            if (!PropertyValidator.isValid((Collection)sBVo.getContainers())) break block31;
                            featureLinkMapping2 = sBVo.getContainers().iterator();
                            break block32;
                        }
                        sessionWrapper = (Session)this.sessionRepository.save((Object)sessionWrapper);
                        sessionBoard.setSession(sessionWrapper);
                        sessionBoard.setTeams(this.saveTeamsWithSprints(sBVo.getTeams(), null, null));
                        if (!PropertyValidator.isValid((Collection)sBVo.getContainers())) break block33;
                        almConfig2 = sBVo.getContainers().iterator();
                        break block34;
                    }
                    while (featureLinkMapping2.hasNext()) {
                        Container cont = (Container)featureLinkMapping2.next();
                        if (PropertyValidator.isValid((Object)cont.getAction()) && "CREATION".equalsIgnoreCase(cont.getAction())) {
                            if (cont.getId() != null && cont.getId().indexOf("-") != -1) {
                                String tmpId = cont.getTempId();
                                cont.setId(null);
                                cont.setSuspendActivity(true);
                                cont = (Container)this.containerRepository.save((Object)cont);
                                sprintTeamIdMap.put(tmpId, cont);
                            } else {
                                cont = (Container)this.containerRepository.save((Object)cont);
                                LOGGER.debug("editSessionBoard --> Container Saved. " + cont.getId());
                            }
                            containerAdded = true;
                        }
                        if (!PropertyValidator.isValid((Object)cont.getAction()) || !"UPDATION".equalsIgnoreCase(cont.getAction()) || cont.getTempId() == null || !cont.getTempId().equals(cont.getId())) continue;
                        cont.setId(null);
                        cont.setSuspendActivity(true);
                        cont = (Container)this.containerRepository.save((Object)cont);
                        LOGGER.debug("editSessionBoard --> Container Updated. " + cont.getId());
                    }
                }
                if (PropertyValidator.isValid((Collection)sBVo.getTeams())) {
                    ArrayList<Team> teamsToAdd = new ArrayList<Team>();
                    ArrayList<Object> teamsToUpdate = new ArrayList<Object>();
                    for (Team team : sBVo.getTeams()) {
                        if (PropertyValidator.isValid((Object)team.getAction()) && "CREATION".equalsIgnoreCase(team.getAction())) {
                            if (team.getTempId() != null && team.getTempId().equals(team.getId())) {
                                String tmpId = team.getTempId();
                                team.setId(null);
                                team.setSuspendActivity(true);
                                teamsToAdd.add(team);
                            }
                            teamsAdded = true;
                            this.resyncData = true;
                        }
                        if (!PropertyValidator.isValid((Object)team.getAction()) || !"UPDATION".equalsIgnoreCase(team.getAction())) continue;
                        team.setSuspendActivity(true);
                        teamsToUpdate.add(this.teamRepository.save((Object)team));
                        this.resyncData = true;
                    }
                    this.saveTeamsWithSprints(teamsToAdd, (AlmConfigurations)sBVo.getAlmConfigurations().get(0), teamsToUpdate);
                    sBVo.setTeams(sBVo.getTeams());
                    LOGGER.trace("editSessionBoard --> Teams Saved. " + sBVo.getTeams());
                }
                sBVo.setAlmConfigurations(this.almSyncService.saveAlmConfigurations(sBVo.getAlmConfigurations()));
                sessionWrapper.setAlmConfigurations(sBVo.getAlmConfigurations());
                sessionBoard.setSession(sessionWrapper);
                sessionBoard.setTeams(sBVo.getTeams());
                sessionWrapper = (Session)this.sessionRepository.save((Object)sessionWrapper);
                sessionBoard.setSession(sessionWrapper);
                sessionBoard.setContainers(sBVo.getContainers());
                sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
                sBVo.setId(sessionBoard.getId());
                sBVo.setSessionBoard(sessionBoard);
                try {
                    this.updateItemSyncMappers(sBVo, sprintTeamIdMap);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to updateItemSyncMappers " + sBVo, (Throwable)e);
                }
                if (!this.resyncData) return sessionBoard;
                return sessionBoard;
            }
            while (almConfig2.hasNext()) {
                Container cont = (Container)almConfig2.next();
                if (PropertyValidator.isValid((Object)cont.getAction()) && "CREATION".equalsIgnoreCase(cont.getAction())) {
                    if (cont.getId() != null && cont.getId().indexOf("-") != -1) {
                        String tmpId = cont.getTempId();
                        cont.setId(null);
                        cont.setSuspendActivity(true);
                        cont = (Container)this.containerRepository.save((Object)cont);
                    } else {
                        cont = (Container)this.containerRepository.save((Object)cont);
                    }
                    containerAdded = true;
                }
                if (!PropertyValidator.isValid((Object)cont.getAction()) || !"UPDATION".equalsIgnoreCase(cont.getAction()) || cont.getTempId() == null || !cont.getTempId().equals(cont.getId())) continue;
                cont.setId(null);
                cont.setSuspendActivity(true);
                cont = (Container)this.containerRepository.save((Object)cont);
            }
        }
        if (PropertyValidator.isValid((Collection)sBVo.getTeams())) {
            ArrayList<Team> teamsToAdd = new ArrayList<Team>();
            for (Team team : sBVo.getTeams()) {
                if (PropertyValidator.isValid((Object)team.getAction()) && "CREATION".equalsIgnoreCase(team.getAction()) && team.getTempId() != null && team.getTempId().equals(team.getId())) {
                    team.setId(null);
                    team.setSuspendActivity(true);
                    teamsToAdd.add(team);
                }
                if (!PropertyValidator.isValid((Object)team.getAction()) || !"UPDATION".equalsIgnoreCase(team.getAction()) || team.getTempId() == null || !team.getTempId().equals(team.getId())) continue;
                team.setSuspendActivity(true);
                this.teamRepository.save((Object)team);
            }
            sBVo.setTeams(this.saveTeamsWithSprints(teamsToAdd, null, null));
        }
        sessionBoard.setContainers(this.containerRepository.save((Iterable)sBVo.getContainers()));
        return (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
    }

    public void updateItemSyncMappers(SessionBoardVo sessionBoardVo, Map<String, Container> sprintTeamIdMap) {
        AlmConfigurations almConfigs = (AlmConfigurations)sessionBoardVo.getAlmConfigurations().get(0);
        SessionBoard sessionBoard = sessionBoardVo.getSessionBoard();
        List itemSyncMapper = sessionBoardVo.getItemSyncMapper();
        if (PropertyValidator.isValid((Collection)itemSyncMapper)) {
            ItemSyncMapper tsmSaved = null;
            for (ItemSyncMapper tsm : itemSyncMapper) {
                Container containr;
                Team sTeam;
                List sessionTeams;
                Team team;
                if ("UPDATION".equalsIgnoreCase(tsm.getAction())) {
                    tsmSaved = this.itemSyncMapperRepository.findByTeamAndContainer(tsm.getTeam(), tsm.getContainer());
                    if (PropertyValidator.isValid((Object)tsmSaved)) {
                        tsmSaved.setSprint(tsm.getSprint());
                        tsm = tsmSaved;
                        this.resyncData = true;
                    } else {
                        team = tsm.getTeam();
                        sessionTeams = sessionBoardVo.getTeams();
                        if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Collection)sessionTeams)) {
                            if (team.getId() != null && team.getId().indexOf("-") != -1) {
                                sTeam = sessionTeams.stream().filter(tm -> team.getId().equals(tm.getTempId())).findAny().orElse(null);
                                if (PropertyValidator.isValid((Object)sTeam)) {
                                    tsm.setTeam(sTeam);
                                    this.resyncData = true;
                                }
                            } else {
                                sTeam = sessionTeams.stream().filter(tm -> team.getId().equals(tm.getId())).findAny().orElse(null);
                                if (PropertyValidator.isValid((Object)sTeam)) {
                                    tsm.setTeam(sTeam);
                                }
                            }
                        }
                        if (PropertyValidator.isValid((Object)(containr = sprintTeamIdMap.get(tsm.getContainer().getId())))) {
                            tsm.setContainer(containr);
                        }
                        tsm.setSessionBoard(sessionBoard);
                    }
                } else {
                    if (!"CREATION".equalsIgnoreCase(tsm.getAction())) continue;
                    team = tsm.getTeam();
                    sessionTeams = sessionBoardVo.getTeams();
                    if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Collection)sessionTeams)) {
                        if (team.getId() != null && team.getId().indexOf("-") != -1) {
                            sTeam = sessionTeams.stream().filter(tm -> team.getId().equals(tm.getTempId())).findAny().orElse(null);
                            if (PropertyValidator.isValid((Object)sTeam)) {
                                tsm.setTeam(sTeam);
                                this.resyncData = true;
                            }
                        } else {
                            sTeam = sessionTeams.stream().filter(tm -> team.getId().equals(tm.getId())).findAny().orElse(null);
                            if (PropertyValidator.isValid((Object)sTeam)) {
                                tsm.setTeam(sTeam);
                            }
                        }
                    }
                    if (PropertyValidator.isValid((Object)(containr = sprintTeamIdMap.get(tsm.getContainer().getId())))) {
                        tsm.setContainer(containr);
                    }
                    tsm.setSessionBoard(sessionBoard);
                }
                String tempSprintId = tsm.getSprint().getId();
                for (BacklogMapping teamMapping : almConfigs.getTeamMappings()) {
                    if (!PropertyValidator.isValid((Object)teamMapping) || !teamMapping.isSyncedFlag() || !PropertyValidator.isValid((Object)tsm.getTeam()) || !teamMapping.getTeamId().equals(tsm.getTeam().getId()) || !PropertyValidator.isValid((Object)tempSprintId)) continue;
                    tsm.setCreateNewInJira(Boolean.FALSE);
                    if ("0".equals(tempSprintId)) {
                        tsm.setSprint(null);
                        continue;
                    }
                    if ("+1".equals(tempSprintId)) {
                        tsm.setSprint(this.createSprintInJira(tsm, almConfigs.getAlmAccount(), teamMapping, tsm.getContainer(), sessionBoard.getId(), null, null, null));
                        tsm.setCreateNewInJira(Boolean.FALSE);
                        continue;
                    }
                    if ("+2".equals(tempSprintId)) {
                        tsm.setSprint(this.createVersionInJira(tsm, almConfigs.getAlmAccount(), teamMapping, tsm.getContainer()));
                        tsm.setCreateNewInJira(Boolean.FALSE);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)sessionBoard.getSession()) || sessionBoard.getSession().getJiraContainer() == null) continue;
                    tsm.setSprint(this.sprintRepository.findSprintByJiraIdAndIsVersionAndAlmAccountId(tempSprintId, tsm.getSprint().getIsVersion(), almConfigs.getAlmAccount().getId()));
                }
                tsm.setSuspendActivity(true);
                this.itemSyncMapperRepository.save((Object)tsm);
            }
        }
        sessionBoardVo.setSessionBoard(sessionBoard);
        sessionBoardVo.setId(sessionBoard.getId());
        sessionBoardVo.setItemSyncMapper(itemSyncMapper);
    }

    public AlmAccUser getUserAlmCredntials(String almAccountId, User user) {
        if (PropertyValidator.isValid((Collection)(user = (User)this.userRepository.findOne((Serializable)((Object)user.getId()))).getAlmCredentials())) {
            for (AlmAccUser userCreds : user.getAlmCredentials()) {
                if (!almAccountId.equals(userCreds.getAlmAccId())) continue;
                return userCreds;
            }
        }
        return null;
    }

    private AlmAccount getJiraLoginForApi(SessionBoard sessionBoard, User loggedInUser) {
        AlmConfigurations almConfig = (AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0);
        AlmAccount alm = almConfig.getAlmAccount();
        AlmAccUser almAccUser = this.getUserAlmCredntials(alm.getId(), loggedInUser);
        alm.setUsernameForApi("");
        alm.setPasswordForApi("");
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                alm.setJiraOauthToken(almAccUser.getJiraOauthToken());
                alm.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                alm.setJiraOauthToken(null);
                alm.setUsernameForApi(almAccUser.getAlmUsername());
                alm.setPasswordForApi(almAccUser.getAlmPassword());
                alm.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
            alm.setIsTaggedUser(Boolean.valueOf(true));
        } else {
            alm.setUsernameForApi(alm.getUsername());
            alm.setPasswordForApi(alm.getPassword());
            alm.setAdminAlmAcc(Boolean.valueOf(true));
        }
        alm.setOAuthTokenOwnerUserId(loggedInUser.getId());
        return alm;
    }

    public Sprint createSprintInJira(ItemSyncMapper itemSyncMapper, AlmAccount almAccount, BacklogMapping teamMapping, Container container, String sessionBoardId, String toZoneId, String startTime, String endTime) {
        Sprint sprint = new Sprint();
        try {
            String seprator = " ";
            JiraSprint jsp = new JiraSprint();
            String sprintTitle = itemSyncMapper.getTeam().getTitle() + seprator + (container.getTitle() != null ? container.getTitle() : "Sprint created from Kendis");
            if (sprintTitle.length() > 30) {
                if (itemSyncMapper.getTeam().getTitle().indexOf(" ") > -1) {
                    String[] titles = itemSyncMapper.getTeam().getTitle().split(" ");
                    sprintTitle = titles[0] + seprator + container.getTitle();
                } else {
                    sprintTitle = itemSyncMapper.getTeam().getLabel() + seprator + container.getTitle();
                }
            }
            if (sprintTitle.length() > 30) {
                sprintTitle = container.getTitle();
            }
            if (sprintTitle.length() > 30) {
                sprintTitle = container.getTitle().substring(0, 30);
            }
            jsp.setName(sprintTitle);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat Z = new SimpleDateFormat("Z");
            Date now = new Date();
            if (startTime == null) {
                startTime = "00:00:00";
            }
            if (endTime == null) {
                endTime = "00:00:00";
            }
            if (toZoneId == null) {
                Z.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
            } else {
                Z.setTimeZone(TimeZone.getTimeZone(toZoneId));
            }
            if (PropertyValidator.isValid((Object)container.getStartDate())) {
                jsp.setStartDate(sdf.format(container.getStartDate()) + "T" + startTime + Z.format(now));
            }
            if (PropertyValidator.isValid((Object)container.getEndDate())) {
                jsp.setEndDate(sdf.format(container.getEndDate()) + "T" + endTime + Z.format(now));
            }
            jsp.setOriginBoardId(teamMapping.getBoardId());
            jsp = this.exportUtil.createJiraSprint(jsp, almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
            if (jsp == null) {
                LOGGER.error("Error in creating sprint in ALM.\n");
                return null;
            }
            this.customRepository.getMongoTemplate().save((Object)jsp);
            sprint = new Sprint();
            sprint.setTitle(jsp.getName());
            sprint.setJiraId(jsp.getJiraId());
            sprint.setAlmAccountId(almAccount.getId());
            sprint.setSessionBoardId(sessionBoardId);
            sprint = (Sprint)this.sprintRepository.save((Object)sprint);
        }
        catch (ViztrendJiraException e) {
            LOGGER.error("Error : Create Sprint in Jira");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        return sprint;
    }

    private Sprint createVersionInJira(ItemSyncMapper itemSyncMapper, AlmAccount almAccount, BacklogMapping teamMapping, Container container) {
        Sprint sprint = new Sprint();
        try {
            JiraVersion jVersion = new JiraVersion();
            jVersion.setName(itemSyncMapper.getContainer().getTitle() != null ? itemSyncMapper.getContainer().getTitle() : "Version created from Kendis");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            jVersion.setStartDate(sdf.format(container.getStartDate()));
            jVersion.setReleaseDate(sdf.format(container.getEndDate()));
            jVersion.setProjectKey(teamMapping.getProjectKey());
            jVersion = this.exportUtil.createJiraVersion(jVersion, almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), null);
            if (jVersion == null) {
                LOGGER.error("Error in creating version in ALM.\n");
                return null;
            }
            this.customRepository.getMongoTemplate().save((Object)jVersion);
            sprint = new Sprint();
            sprint.setTitle(jVersion.getName());
            sprint.setJiraId(jVersion.getJiraId());
            sprint.setIsVersion(Boolean.TRUE);
            sprint.setAlmAccountId(almAccount.getId());
            sprint = (Sprint)this.sprintRepository.save((Object)sprint);
        }
        catch (ViztrendJiraException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return sprint;
    }

    private void handleContainerDelete(List<String> containersToDelete, SessionBoard sessionBoard) {
        if (PropertyValidator.isValid(containersToDelete)) {
            for (String contId : containersToDelete) {
                List tcs = this.teamContainerRepository.findByContainer(new Container(contId));
                List itemsToUpdate = this.itemRepository.findByTeamContainersIn(tcs);
                for (Item item : itemsToUpdate) {
                    for (TeamContainer tc : tcs) {
                        item.getTeamContainers().remove(tc);
                        item.setSuspendActivity(true);
                    }
                }
                this.itemRepository.save((Iterable)itemsToUpdate);
                this.teamContainerRepository.delete((Iterable)tcs);
                List sbs = this.sessionBoardRepository.findByContainersId(contId);
                for (SessionBoard sb : sbs) {
                    sb.getContainers().remove(new Container(contId));
                    sb.setSuspendActivity(true);
                }
                sessionBoard.getContainers().remove(new Container(contId));
                this.sessionBoardRepository.save((Iterable)sbs);
                this.itemSyncMapperRepository.deleteByContainerId(contId);
                this.containerRepository.delete((Serializable)((Object)contId));
            }
        }
    }

    private void handleTeamDelete(List<String> teamsToDelete, SessionBoard sessionBoard) {
        if (PropertyValidator.isValid(teamsToDelete)) {
            for (String teamId : teamsToDelete) {
                List tcs = this.teamContainerRepository.findByTeam(new Team(teamId));
                List itemsToUpdate = this.itemRepository.findByTeamContainersIn(tcs);
                for (Item item : itemsToUpdate) {
                    for (TeamContainer tc : tcs) {
                        item.getTeamContainers().remove(tc);
                        item.setSuspendActivity(true);
                    }
                }
                this.itemRepository.save((Iterable)itemsToUpdate);
                this.teamContainerRepository.delete((Iterable)tcs);
                List sbs = this.sessionBoardRepository.findByTeamsId(teamId);
                for (SessionBoard sb : sbs) {
                    sb.getTeams().remove(new Team(teamId));
                    sb.setSuspendActivity(true);
                }
                sessionBoard.getTeams().remove(new Team(teamId));
                this.itemSyncMapperRepository.deleteByTeamId(teamId);
                this.sessionBoardRepository.save((Iterable)sbs);
                this.teamRepository.delete((Serializable)((Object)teamId));
            }
        }
    }

    private String getNextSeq(String seqCol) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)seqCol));
        if (!PropertyValidator.isValid((Collection)this.customRepository.getMongoTemplate().find(query, Counters.class))) {
            Counters counters = new Counters();
            counters.setId(seqCol);
            counters.setSeq(1);
            this.customRepository.getMongoTemplate().insert((Object)counters);
        }
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)seqCol));
        Update update = new Update();
        update.inc("seq", (Number)1);
        Counters savedCounters = (Counters)this.customRepository.getMongoTemplate().findAndModify(q, update, Counters.class);
        return String.valueOf(savedCounters.getSeq());
    }

    public List<ItemLog> getActivitiesByTeamAndSprint(String searchString, String sessionBoardId, String team, String sprint, Boolean isWebhook, String page) {
        Query query = new Query();
        if (PropertyValidator.isValid((Object)searchString)) {
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"key").regex(searchString, "i"), Criteria.where((String)"changes").regex(searchString, "i"), Criteria.where((String)"detail.title").regex(searchString, "i"), Criteria.where((String)"detail.score").regex(searchString, "i")});
            query.addCriteria((CriteriaDefinition)criteria);
        }
        if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Object)sprint)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"changes").regex(team, "i").orOperator(new Criteria[]{Criteria.where((String)"changes").regex(sprint, "i")}));
        } else if (PropertyValidator.isValid((Object)sprint)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"changes").regex(sprint, "i"));
        } else if (PropertyValidator.isValid((Object)team)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"changes").regex(team, "i"));
        }
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoard.id").is((Object)sessionBoardId));
        }
        if (isWebhook.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"activitySource").is((Object)"WEBHOOK"));
        }
        ArrayList<String> nin = new ArrayList<String>();
        nin.add(EnumActivityType.BULK.getCode());
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"eventType").nin(nin));
        int offset = 0;
        if (page != null) {
            offset = new Integer(page);
        }
        query.with((Pageable)new PageRequest(offset, 50, new Sort(Sort.Direction.DESC, new String[]{"createdOn"})));
        List itemlogs = this.customRepository.getMongoTemplate().find(query, ItemLog.class);
        return itemlogs;
    }

    public List<ItemLog> getAllActivitiesByTeamAndSprint(String searchString, String sessionBoardId, String team, String sprint, Boolean isWebhook) {
        Query query = new Query();
        if (PropertyValidator.isValid((Object)searchString)) {
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"key").regex(searchString, "i"), Criteria.where((String)"changes").regex(searchString, "i"), Criteria.where((String)"detail.title").regex(searchString, "i"), Criteria.where((String)"detail.score").regex(searchString, "i")});
            query.addCriteria((CriteriaDefinition)criteria);
        }
        if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Object)sprint)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"changes").regex(team, "i").orOperator(new Criteria[]{Criteria.where((String)"changes").regex(sprint, "i")}));
        } else if (PropertyValidator.isValid((Object)sprint)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"changes").regex(sprint, "i"));
        } else if (PropertyValidator.isValid((Object)team)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"changes").regex(team, "i"));
        }
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoard.id").is((Object)sessionBoardId));
        }
        if (isWebhook.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"activitySource").is((Object)"WEBHOOK"));
        }
        ArrayList<String> nin = new ArrayList<String>();
        nin.add(EnumActivityType.BULK.getCode());
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"eventType").nin(nin));
        query.with(new Sort(Sort.Direction.DESC, new String[]{"createdOn"}));
        List itemlogs = this.customRepository.getMongoTemplate().find(query, ItemLog.class);
        return itemlogs;
    }

    public void deleteItemLinkInJira(Item item, User loggedInUser) {
        JiraIssue2 jiraIssue;
        AlmAccount alm;
        AlmConfigurations almConfig;
        SessionBoard sessionBoard;
        block10: {
            String sessionId = ((SessionBoard)item.getSessionBoards().get(0)).getId();
            sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionId));
            almConfig = (AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0);
            alm = this.getJiraLoginForApi(sessionBoard, loggedInUser);
            jiraIssue = null;
            try {
                jiraIssue = this.almService.retrieveJiraIssue(item.getJiraId(), alm);
            }
            catch (ViztrendJiraException e1) {
                LOGGER.error("Failed to fetch jira Issue. " + e1.getAlmError(), (Throwable)e1);
                if (500 != e1.getCode()) break block10;
                LOGGER.error("Retrying ...");
                jiraIssue = this.almService.retrieveJiraIssue(item.getJiraId(), alm);
            }
        }
        Item parent = null;
        if (PropertyValidator.isValid((Object)item.getParent())) {
            parent = (Item)this.itemRepository.findOne((Serializable)((Object)item.getParent().getId()));
        }
        if (parent != null) {
            if (((SessionBoard)item.getSessionBoards().get(0)).getSession().getJiraSynapseRTEnabled().booleanValue()) {
                this.exportUtil.deleteParentRequirementFromSynapseRT(item.getJiraKey(), alm);
                LOGGER.warn("relation removed from synapseRT");
            } else {
                this.removeLinkInJira(item, parent, jiraIssue, sessionBoard, almConfig.getFeatureFilter(), alm, alm.getUsernameForApi(), alm.getPasswordForApi(), loggedInUser);
            }
            try {
                if (!item.getType().equals("Feature") && PropertyValidator.isValid((Object)item.getParent().getId())) {
                    List childItems = this.itemRepository.findByParentId(item.getParent().getId());
                    Double totalEstimate = 0.0;
                    for (Item childItem : childItems) {
                        totalEstimate = totalEstimate + childItem.getStoryPoints();
                    }
                    this.customRepository.updateItemStoryPoints(item.getParent().getId(), totalEstimate);
                }
            }
            catch (ViztrendJiraException e) {
                this.pushAlmError("Upadting feature :: FAILED.. error message saved in item.", e, parent, (SessionBoard)parent.getSessionBoards().get(0), loggedInUser, Boolean.valueOf(false));
            }
        }
    }

    public void removeLinkInJira(Item item, Item parent, JiraIssue2 jiraIssue, SessionBoard sessionBoard, List<JiraFilter> featureFilters, AlmAccount alm, String almUsername, String almPassword, User loggedInUser) {
        String projectkey;
        ArrayList<JiraIssueLinkType> linkTypes;
        ArrayList<JiraIssueLinkType> jiraIssueLinkTypes = new ArrayList<JiraIssueLinkType>();
        List<BacklogMappingLinks> linkMappings = new ArrayList<BacklogMappingLinks>();
        if (PropertyValidator.isValid((Object)parent.getJiraFilter())) {
            if (PropertyValidator.isValid(featureFilters)) {
                for (JiraFilter jiraFilter : featureFilters) {
                    if (!parent.getJiraFilter().equals(jiraFilter.getId())) continue;
                    linkMappings = jiraFilter.getFeatureLinkMappings();
                }
            }
        } else if (PropertyValidator.isValid((Collection)parent.getLinkTypes())) {
            linkTypes = new ArrayList<JiraIssueLinkType>();
            linkTypes.addAll(parent.getLinkTypes());
            BacklogMappingLinks mappingLinks = new BacklogMappingLinks();
            mappingLinks.setProjectKey(parent.getJiraProjectKey());
            mappingLinks.setLinkTypes(parent.getLinkTypes());
            linkMappings.add(mappingLinks);
        } else if (PropertyValidator.isValid((Object)parent.getLinkType())) {
            linkTypes = new ArrayList();
            linkTypes.add(parent.getLinkType());
            linkMappings.add(new BacklogMappingLinks(linkTypes));
        }
        if ((projectkey = parent.getJiraProjectKey()) == null) {
            projectkey = parent.getJiraKey().substring(0, parent.getJiraKey().indexOf("-"));
        }
        if (PropertyValidator.isValid(linkMappings)) {
            for (BacklogMappingLinks bLink : linkMappings) {
                if (!bLink.getProjectKey().equalsIgnoreCase(projectkey)) continue;
                try {
                    if (!PropertyValidator.isValid((Collection)bLink.getLinkTypes())) break;
                    for (JiraIssueLinkType issuelink : bLink.getLinkTypes()) {
                        if (issuelink.getJiraId().indexOf("customfield_") <= -1) continue;
                        jiraIssueLinkTypes.add(issuelink);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                break;
            }
        }
        try {
            Boolean notifyUsers = null;
            if (PropertyValidator.isValid((Collection)parent.getSessionBoards()) && PropertyValidator.isValid((Object)((SessionBoard)parent.getSessionBoards().get(0)).getSession())) {
                notifyUsers = ((SessionBoard)parent.getSessionBoards().get(0)).getSession().getNotifyJiraUsers();
            }
            this.exportUtil.removeParenChildLinkInJira(item.getJiraId(), parent.getJiraId(), parent.getJiraKey(), jiraIssue, notifyUsers, jiraIssueLinkTypes, alm, almUsername, almPassword, loggedInUser);
        }
        catch (Exception e) {
            if (e instanceof ViztrendJiraException) {
                this.pushAlmError("Deleting Link ALM:: FAILED.. error message saved in item.", (ViztrendJiraException)((Object)e), item, sessionBoard, loggedInUser, Boolean.valueOf(false));
            }
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void moveItemsToBacklogInJira(List<Item> items, TeamContainer teamContainer, User loggedInUser) {
        if (PropertyValidator.isValid(items)) {
            ItemSyncMapper syncMapper;
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)((SessionBoard)items.get(0).getSessionBoards().get(0)).getId()));
            if (!PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
                return;
            }
            boolean isCellMappedWithJira = false;
            if (PropertyValidator.isValid((Object)teamContainer) && PropertyValidator.isValid((Object)teamContainer.getTeam()) && PropertyValidator.isValid((Object)teamContainer.getContainer()) && PropertyValidator.isValid((Object)(syncMapper = this.itemSyncMapperRepository.findByTeamAndContainer(teamContainer.getTeam(), teamContainer.getContainer()))) && PropertyValidator.isValid((Object)syncMapper.getSprint())) {
                isCellMappedWithJira = true;
            }
            if (!isCellMappedWithJira) {
                return;
            }
            AlmAccount alm = this.getJiraLoginForApi(sessionBoard, loggedInUser);
            ArrayList<String> jiraIds = new ArrayList<String>();
            for (Item item : items) {
                if (!PropertyValidator.isValid((Object)item.getJiraId())) continue;
                jiraIds.add(item.getJiraId());
            }
            if (jiraIds.size() > 0) {
                int startAt = 0;
                int pageSize = 50;
                int indexTo = startAt + pageSize - 1;
                do {
                    if ((indexTo = startAt + pageSize - 1) > jiraIds.size()) {
                        indexTo = jiraIds.size();
                    }
                    List sublist = jiraIds.subList(startAt, indexTo);
                    try {
                        this.exportUtil.moveIssuesToBacklog(sublist, alm.getUrl(), alm.getUsernameForApi(), alm.getPasswordForApi(), alm);
                    }
                    catch (ViztrendJiraException e) {
                        LOGGER.warn("Failed to moveIssuesToBacklog.");
                        this.pushAlmErrors(e, items.subList(startAt, indexTo), sessionBoard, loggedInUser);
                    }
                    startAt += pageSize;
                } while (indexTo < jiraIds.size());
            }
        }
    }

    public List<Sprint> convertJiraSprints(String jiraBoardId, String almAccId, String sessionBoardId) {
        List jiraSprints = this.jiraSprintRepository.findByJiraBoardIdAndAlmAccountIdAndSessionBoardId(jiraBoardId, almAccId, sessionBoardId);
        List kSprints = this.sprintRepository.findSprintsByAlmAccountIdAndSessionBoardId(almAccId, sessionBoardId);
        Map sprintMap = this.convertSprintListToMap(kSprints, sessionBoardId);
        ArrayList<Object> sprints = null;
        if (PropertyValidator.isValid((Collection)jiraSprints)) {
            sprints = new ArrayList<Object>(jiraSprints.size());
            for (JiraSprint jiraSprint : jiraSprints) {
                if (PropertyValidator.isValid(sprintMap.get(jiraSprint.getJiraId()))) {
                    sprints.add(sprintMap.get(jiraSprint.getJiraId()));
                    continue;
                }
                Sprint sp = new Sprint();
                sp.setSuspendActivity(true);
                sp.setTitle(jiraSprint.getName());
                sp.setJiraId(jiraSprint.getJiraId());
                sp.setAlmAccountId(almAccId);
                sp.setStartDate(jiraSprint.getStartDate());
                sp.setEndDate(jiraSprint.getEndDate());
                sp.setState(jiraSprint.getState());
                sp.setOriginBoardId(jiraSprint.getOriginBoardId());
                sp.setJiraBoardId(jiraBoardId);
                sp.setAlmAccountId(almAccId);
                sp.setSessionBoardId(sessionBoardId);
                this.sprintRepository.save((Object)sp);
                sprints.add(sp);
            }
        }
        return sprints;
    }

    public List<SessionBoard> getAllAccessableBoards() {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(user);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        List sessions = new ArrayList();
        List<Object> parentBoards = new ArrayList<SessionBoard>();
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            sessions = this.sessionRepository.findByWorkSpaceIn(new ArrayList(workSpaces));
            parentBoards = this.sessionBoardRepository.findBySessionInAndParentBoardIsNullOrderByCreatedOnDesc(sessions);
        }
        return parentBoards;
    }

    public List<SessionBoard> getAllAccessableBoards(String type) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(user);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        List sessions = new ArrayList();
        List<Object> parentBoards = new ArrayList<SessionBoard>();
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            sessions = this.sessionRepository.findByWorkSpaceIn(new ArrayList(workSpaces));
            ArrayList sessionsFiltered = new ArrayList();
            if (type == null) {
                sessionsFiltered.addAll(sessions);
            } else {
                sessions.forEach(session -> {
                    if (type.equals("jira") && PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
                        sessionsFiltered.add(session);
                    }
                    if (type.equals("tfs") && PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                        sessionsFiltered.add(session);
                    }
                    if (type.equals("not_tfs") && !PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                        sessionsFiltered.add(session);
                    }
                });
            }
            parentBoards = this.sessionBoardRepository.findBySessionInAndParentBoardIsNullOrderByCreatedOnDesc(sessionsFiltered);
        }
        return parentBoards;
    }

    private List<Session> getSessionWithLimitedData(ArrayList<WorkSpace> workSpaces) {
        Query query = new Query();
        query.fields().include("_id");
        query.fields().include("title");
        query.fields().include("activeSessionBoard");
        query.fields().include("originIdSynched");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace").in(workSpaces));
        List sessions = this.mongoTemplate.find(query, Session.class);
        return sessions;
    }

    private List<SessionBoard> getSessionBoardWithLimitedData(ArrayList<ObjectId> sessionIds) {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.fields().include("_id");
        query.fields().include("title");
        query.fields().include("status");
        query.fields().include("state");
        query.with(new Sort(Sort.Direction.DESC, new String[]{"createdOn"}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"session.$id").in(sessionIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"parentBoard").is(null));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        List sessionBoard = this.mongoTemplate.find(query, SessionBoard.class);
        return sessionBoard;
    }

    public List<Team> getAllCompanyTeamWithLimitedData() {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.fields().include("_id");
        query.fields().include("title");
        query.fields().include("label");
        query.fields().include("color");
        query.fields().include("sequence");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").in(new Object[]{tenant}));
        List companyTeam = this.mongoTemplate.find(query, Team.class);
        return companyTeam;
    }

    public List<State> getAllCompanyStatesWithLimitedData() {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.fields().include("_id");
        query.fields().include("title");
        query.fields().include("sequence");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").in(new Object[]{tenant}));
        List companyState = this.mongoTemplate.find(query, State.class);
        return companyState;
    }

    public List<SessionBoard> getAllAccessableBoardsWithMinimumData(String type) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(user);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        List sessions = new ArrayList();
        ArrayList<SessionBoard> parentBoards = new ArrayList<SessionBoard>();
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            sessions = this.getSessionWithLimitedData(new ArrayList(workSpaces));
            ArrayList sessionsFiltered = new ArrayList();
            HashMap sessionsFilteredMap = new HashMap();
            if (type == null) {
                sessions.forEach(session -> {
                    sessionsFiltered.add(new ObjectId(session.getId()));
                    sessionsFilteredMap.put(session.getActiveSessionBoard().toString(), session);
                });
            } else {
                sessions.forEach(session -> {
                    if (type.equals("jira") && PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
                        sessionsFiltered.add(new ObjectId(session.getId()));
                    }
                    if (type.equals("tfs") && PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                        sessionsFiltered.add(new ObjectId(session.getId()));
                    }
                    if (type.equals("not_tfs") && !PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                        sessionsFiltered.add(new ObjectId(session.getId()));
                    }
                });
            }
            List parentBoardsWithOutSession = this.getSessionBoardWithLimitedData(sessionsFiltered);
            for (SessionBoard sessionBoard : parentBoardsWithOutSession) {
                if (!PropertyValidator.isValid(sessionsFilteredMap.get(sessionBoard.getId()))) continue;
                sessionBoard.setSession((Session)sessionsFilteredMap.get(sessionBoard.getId()));
                parentBoards.add(sessionBoard);
            }
        }
        return parentBoards;
    }

    public List<SessionBoard> getSessionBoards(String sessionId) {
        return this.sessionBoardRepository.findBySessionIdOrderByCreatedOnAsc(sessionId);
    }

    public Session getSession(String id) {
        return (Session)this.sessionRepository.findOne((Serializable)((Object)id));
    }

    public void saveSession(Session session) {
        this.sessionRepository.save((Object)session);
    }

    public void updateJiraKeyInLogs(String itemId, String itemJiraKey, String itemJiraId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"detail").ne(null));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"itemId").in(new Object[]{itemId}));
            List logs = this.customRepository.getMongoTemplate().find(query, ItemLog.class);
            if (PropertyValidator.isValid((Collection)logs)) {
                for (ItemLog log : logs) {
                    log.setKey(itemJiraKey);
                    Map detail = (Map)log.getDetail();
                    if (!PropertyValidator.isValid((Object)detail)) continue;
                    detail.put("jiraKey", itemJiraKey);
                    detail.put("jiraId", itemJiraId);
                    detail.put("almKey", itemJiraKey);
                    detail.put("almItemId", itemJiraId);
                    log.setDetail((Object)detail);
                }
                this.itemLogRepository.save((Iterable)logs);
            }
        }
        catch (Exception e) {
            LOGGER.info("Succes: jira key not set on creation::" + e.getMessage());
        }
    }

    public void updateTcInLinksOnChangeCell(Item item1) {
        try {
            if (PropertyValidator.isValid((Object)item1.getId()) && PropertyValidator.isValid((Collection)item1.getTeamContainers()) && PropertyValidator.isValid(item1.getTeamContainers().get(0)) && PropertyValidator.isValid((Object)((TeamContainer)item1.getTeamContainers().get(0)).getId())) {
                List links = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId(item1.getId(), item1.getId());
                if (PropertyValidator.isValid((Collection)links)) {
                    for (int i = 0; i < links.size(); ++i) {
                        if (((ItemLink)links.get(i)).getSourceUserStoryId() != null && ((ItemLink)links.get(i)).getSourceUserStoryId().equals(item1.getId())) {
                            ((ItemLink)links.get(i)).setSourceTeamContainerId(((TeamContainer)item1.getTeamContainers().get(0)).getId());
                        }
                        if (((ItemLink)links.get(i)).getTargetUserStoryId() == null || !((ItemLink)links.get(i)).getTargetUserStoryId().equals(item1.getId())) continue;
                        ((ItemLink)links.get(i)).setTargetTeamContainerId(((TeamContainer)item1.getTeamContainers().get(0)).getId());
                    }
                }
                this.itemLinkRepository.save((Iterable)links);
            }
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
        }
    }

    public List<ItemLink> updateItemLinksStatusBasedOnItemStatus(Item item, Status oldStatus, SessionBoard sessionBoard, String cid) {
        try {
            Session session = sessionBoard.getSession();
            HashMap openOrResolveDependenciesMap = new HashMap();
            HashSet openStatusDependencies = new HashSet();
            HashSet resolveStatusDependencies = new HashSet();
            HashMap<String, Object> linkStatusMap = new HashMap<String, Object>();
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (date, type, jsonSerializationContext) -> new JsonPrimitive((Number)date.getTime())).create();
            HashMap<String, Object> metaMap = new HashMap<String, Object>();
            JSONObject pushJson = new JSONObject();
            pushJson.put("isJira", true);
            pushJson.put("isWebhook", true);
            pushJson.put("type", (Object)item.getType());
            pushJson.put("id", (Object)item.getId());
            pushJson.put("boardId", (Object)sessionBoard.getId());
            metaMap.put("event", "itemLinksUpdated");
            metaMap.put("boardId", sessionBoard.getId());
            metaMap.put("boardid", sessionBoard.getId());
            metaMap.put("isJira", Boolean.TRUE);
            try {
                pushJson.put("metaMap", (Object)gsonExclusive.toJson(metaMap));
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            openOrResolveDependenciesMap.put("Open", openStatusDependencies);
            openOrResolveDependenciesMap.put("Resolved", resolveStatusDependencies);
            if (PropertyValidator.isValid((Object)item) && Item.USER_STORY.equals(item.getType()) && PropertyValidator.isValid((Object)session.getSubItemLinkStatusDependentOn()) && !session.getSubItemLinkStatusDependentOn().equals("-1")) {
                boolean resolveSubItemDependencies = false;
                boolean openSubItemDependencies = false;
                if (PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory()) && PropertyValidator.isValid((Object)oldStatus) && PropertyValidator.isValid((Object)oldStatus.getCategory()) && item.getStatus().getCategory().equals("Done") && !oldStatus.getCategory().equals(item.getStatus().getCategory())) {
                    resolveSubItemDependencies = true;
                }
                if (session.getReOpenDependencyIfSubItemReOpen().booleanValue() && PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory()) && PropertyValidator.isValid((Object)oldStatus) && PropertyValidator.isValid((Object)oldStatus.getCategory()) && oldStatus.getCategory().equals("Done") && !oldStatus.getCategory().equals(item.getStatus().getCategory())) {
                    openSubItemDependencies = true;
                }
                if (resolveSubItemDependencies || openSubItemDependencies) {
                    Set openLinks;
                    Set resolveLinks;
                    boolean ignoreIfWrongItem;
                    List itemLinks = new ArrayList();
                    itemLinks = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId(item.getId(), item.getId());
                    List kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
                    String key = session.getSubItemLinkStatusDependentOn();
                    List statuses = this.statusRepository.findByWorkFlow(session.getDependencyWorkFlow());
                    Object openStatus = null;
                    Object closeStatus = null;
                    for (Object st : statuses) {
                        if (openStatus == null && st.getCategory().equals("ToDo")) {
                            openStatus = st;
                            linkStatusMap.put("ToDo", openStatus);
                        }
                        if (closeStatus != null || !st.getCategory().equals("Done")) continue;
                        closeStatus = st;
                        linkStatusMap.put("Done", closeStatus);
                    }
                    ArrayList<ItemLink> linksToBeUpdated = new ArrayList<ItemLink>();
                    if (PropertyValidator.isValid(itemLinks)) {
                        for (ItemLink itemLink : itemLinks) {
                            ignoreIfWrongItem = true;
                            ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, item.getId(), kendisLinkTypes, key, sessionBoard.getSession());
                            if (session.getIgnoreUpdateIfManualResolvedForSubItem().booleanValue() && itemLink.getIsManuallyResolved().booleanValue() || ignoreIfWrongItem) continue;
                            itemLink.setStatus(resolveSubItemDependencies ? "Resolved" : "Open");
                            if (resolveSubItemDependencies) {
                                itemLink.setResolvedOn(new Date());
                                itemLink.setWfStatus((Status)closeStatus);
                                if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                                    resolveLinks = (Set)openOrResolveDependenciesMap.get("Resolved");
                                    resolveLinks.add(itemLink.getAlmLinkId());
                                }
                            } else {
                                itemLink.setResolvedOn(null);
                                itemLink.setWfStatus((Status)openStatus);
                                if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                                    openLinks = (Set)openOrResolveDependenciesMap.get("Open");
                                    openLinks.add(itemLink.getAlmLinkId());
                                }
                            }
                            itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                            linksToBeUpdated.add(itemLink);
                        }
                        this.itemLinkRepository.save(linksToBeUpdated);
                        try {
                            pushJson.put("itemLinks", (Object)gsonExclusive.toJson(linksToBeUpdated));
                        }
                        catch (JSONException e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                    }
                    if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                        for (ItemJiraDependency itemJiraDependency : item.getJiraDependencies()) {
                            if (!PropertyValidator.isValid((Object)itemJiraDependency)) continue;
                            ignoreIfWrongItem = true;
                            ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemJiraDependency, item.getId(), kendisLinkTypes, key, sessionBoard.getSession());
                            if (ignoreIfWrongItem) continue;
                            if (resolveSubItemDependencies) {
                                resolveLinks = (Set)openOrResolveDependenciesMap.get("Resolved");
                                resolveLinks.add(itemJiraDependency.getJiraDependencyId());
                                continue;
                            }
                            openLinks = (Set)openOrResolveDependenciesMap.get("Open");
                            openLinks.add(itemJiraDependency.getJiraDependencyId());
                        }
                    }
                    this.customRepositoryImpl.updateJiraDependencyStatusOnItemStatus(openOrResolveDependenciesMap, linkStatusMap, sessionBoard.getId());
                    try {
                        pushJson.put("jiraDependencyIds", (Object)gsonExclusive.toJson(openOrResolveDependenciesMap));
                    }
                    catch (JSONException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            if (PropertyValidator.isValid((Object)item) && Item.FEATURE.equals(item.getType()) && PropertyValidator.isValid((Object)session.getItemLinkStatusDependentOn()) && !session.getItemLinkStatusDependentOn().equals("-1")) {
                boolean resolveItemDependencies = false;
                boolean openItemDependencies = false;
                if (PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory()) && PropertyValidator.isValid((Object)oldStatus) && PropertyValidator.isValid((Object)oldStatus.getCategory()) && item.getStatus().getCategory().equals("Done") && !oldStatus.getCategory().equals(item.getStatus().getCategory())) {
                    resolveItemDependencies = true;
                }
                if (session.getReOpenDependencyIfItemReOpen().booleanValue() && PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory()) && PropertyValidator.isValid((Object)oldStatus) && PropertyValidator.isValid((Object)oldStatus.getCategory()) && oldStatus.getCategory().equals("Done") && !oldStatus.getCategory().equals(item.getStatus().getCategory())) {
                    openItemDependencies = true;
                }
                if (resolveItemDependencies || openItemDependencies) {
                    Set openLinks;
                    Set resolveLinks;
                    List kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
                    String key = session.getItemLinkStatusDependentOn();
                    ArrayList itemLinks = new ArrayList();
                    ArrayList tcIds = new ArrayList();
                    if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                        item.getTeamContainers().forEach(tc -> {
                            if (PropertyValidator.isValid((Object)tc)) {
                                tcIds.add(tc.getId());
                            }
                        });
                    }
                    itemLinks.addAll(this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcIds, tcIds));
                    List statuses = this.statusRepository.findByWorkFlow(session.getDependencyWorkFlow());
                    Object openStatus = null;
                    Object closeStatus = null;
                    for (Object st : statuses) {
                        if (openStatus == null && st.getCategory().equals("ToDo")) {
                            openStatus = st;
                            linkStatusMap.put("ToDo", openStatus);
                        }
                        if (closeStatus != null || !st.getCategory().equals("Done")) continue;
                        closeStatus = st;
                        linkStatusMap.put("Done", closeStatus);
                    }
                    ArrayList<ItemLink> linksToBeUpdated = new ArrayList<ItemLink>();
                    if (PropertyValidator.isValid(itemLinks)) {
                        for (ItemLink itemLink : itemLinks) {
                            boolean ignoreIfWrongItem = true;
                            if (session.getItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.Source.toString()) && PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId()) || session.getItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.Target.toString()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) continue;
                            ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, item.getId(), kendisLinkTypes, key, sessionBoard.getSession());
                            if (session.getIgnoreUpdateIfManualResolvedForItem().booleanValue() && itemLink.getIsManuallyResolved().booleanValue() || ignoreIfWrongItem) continue;
                            itemLink.setStatus(resolveItemDependencies ? "Resolved" : "Open");
                            if (resolveItemDependencies) {
                                itemLink.setResolvedOn(new Date());
                                itemLink.setWfStatus((Status)closeStatus);
                                if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                                    resolveLinks = (Set)openOrResolveDependenciesMap.get("Resolved");
                                    resolveLinks.add(itemLink.getAlmLinkId());
                                }
                            } else {
                                itemLink.setResolvedOn(null);
                                itemLink.setWfStatus((Status)openStatus);
                                if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                                    openLinks = (Set)openOrResolveDependenciesMap.get("Open");
                                    openLinks.add(itemLink.getAlmLinkId());
                                }
                            }
                            itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                            linksToBeUpdated.add(itemLink);
                        }
                        if (PropertyValidator.isValid(linksToBeUpdated)) {
                            this.itemLinkRepository.save(linksToBeUpdated);
                            try {
                                pushJson.put("itemLinks", (Object)gsonExclusive.toJson(linksToBeUpdated));
                            }
                            catch (JSONException e) {
                                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                            }
                        }
                    }
                    if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                        for (ItemJiraDependency itemJiraDependency : item.getJiraDependencies()) {
                            if (!PropertyValidator.isValid((Object)itemJiraDependency)) continue;
                            boolean ignoreIfWrongItem = true;
                            ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemJiraDependency, item.getId(), kendisLinkTypes, key, sessionBoard.getSession());
                            if (ignoreIfWrongItem) continue;
                            if (resolveItemDependencies) {
                                resolveLinks = (Set)openOrResolveDependenciesMap.get("Resolved");
                                resolveLinks.add(itemJiraDependency.getJiraDependencyId());
                                continue;
                            }
                            openLinks = (Set)openOrResolveDependenciesMap.get("Open");
                            openLinks.add(itemJiraDependency.getJiraDependencyId());
                        }
                    }
                    this.customRepositoryImpl.updateJiraDependencyStatusOnItemStatus(openOrResolveDependenciesMap, linkStatusMap, sessionBoard.getId());
                    try {
                        pushJson.put("jiraDependencyIds", (Object)gsonExclusive.toJson(openOrResolveDependenciesMap));
                    }
                    catch (JSONException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            Item _item = new Item(item.getId(), item.getTitle(), item.getDescription(), item.getType(), item.getStoryPoints(), item.getDueDate(), item.getStartDate(), item.getEndDate(), null, item.getStatus(), item.getFlagged(), item.getParent(), item.getJiraId(), item.getJiraKey(), null, item.getItemLinks(), item.getTeamContainers(), null);
            _item.setSessionBoards(item.getSessionBoards());
            _item.setIssueType(item.getIssueType());
            pushJson.put("item", (Object)gsonExclusive.toJson((Object)_item));
            PushSender.sendMsg((String)cid, (String)pushJson.toString());
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    public void saveItemInJira(Item savedItem, Item item, SessionBoard sessionBoard, boolean editMode, @PathVariable(value="optional") Optional<String> optional) {
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public List<UserBoardPreferences> getUserBoardPreferences() {
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        List boardPreferences = this.userBoardPreferenceRepository.findByUserId(loggedInUser.getId());
        return boardPreferences;
    }

    public List<BaseItemLink> stateChangeForBaseItems(Map<String, String> oldIdsMap, String sessionId) {
        LOGGER.trace("INSIDE stateChangeForBaseItems");
        try {
            Set<String> oldItemIds = oldIdsMap.keySet();
            List baseItemLinks = this.baseItemLinkRepository.findBySessionIdAndItemIdIn(sessionId, new ArrayList<String>(oldItemIds));
            for (BaseItemLink baseItemLink : baseItemLinks) {
                baseItemLink.setItemId(oldIdsMap.get(baseItemLink.getItemId()));
            }
            baseItemLinks = this.baseItemLinkRepository.save((Iterable)baseItemLinks);
            return baseItemLinks;
        }
        catch (Exception ex) {
            LOGGER.error(ex.toString());
            return new ArrayList<BaseItemLink>();
        }
    }

    public HashMap<String, Object> saveExcludedItems(StatsExclusion excludedItemsVO) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Session existingSessionId = this.getSession(excludedItemsVO.getSessionId());
        if (existingSessionId != null) {
            String sessionId = existingSessionId.getId();
            String viewType = excludedItemsVO.getViewType();
            Map excludedItems = excludedItemsVO.getExcludedItems();
            StatsExclusion statsExclusion = this.statsExclusionRepository.findBySessionIdAndViewType(sessionId, viewType);
            if (statsExclusion != null) {
                statsExclusion.setExcludedItems(excludedItems);
                statsExclusion = (StatsExclusion)this.statsExclusionRepository.save((Object)statsExclusion);
            } else {
                statsExclusion = new StatsExclusion();
                statsExclusion.setSessionId(sessionId);
                statsExclusion.setViewType(viewType);
                statsExclusion.setExcludedItems(excludedItems);
                statsExclusion = (StatsExclusion)this.statsExclusionRepository.save((Object)statsExclusion);
            }
            response.put("statsExclusion", statsExclusion);
        } else {
            response.put("error", true);
            response.put("reason", "Session Id " + excludedItemsVO.getSessionId() + " does not exist in DB.");
        }
        return response;
    }

    public HashMap<String, Object> fetchExcludedItems(HashMap<String, String> statsExclusionMap) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Session existingSessionId = this.getSession(statsExclusionMap.get("sessionId"));
        if (existingSessionId != null) {
            String viewType;
            String sessionId = existingSessionId.getId();
            StatsExclusion statsExclusion = this.statsExclusionRepository.findBySessionIdAndViewType(sessionId, viewType = statsExclusionMap.get("viewType"));
            if (statsExclusion != null) {
                response.put("statsExclusion", statsExclusion);
            } else {
                response.put("error", true);
                response.put("reason", "No entry found in database against the session id " + sessionId + " and viewtype " + viewType);
            }
        } else {
            response.put("error", true);
            response.put("reason", "Session Id " + statsExclusionMap.get("sessionId") + " does not exist in DB.");
        }
        return response;
    }

    public HashMap<String, Object> saveCustomWsjfSettings(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String sessionId = (String)requestBody.get("sessionId");
            Integer businessValue = this.safelyConvertToInteger(requestBody.get("businessValue"));
            Integer timeCriticality = this.safelyConvertToInteger(requestBody.get("timeCriticality"));
            Integer riskReduction = this.safelyConvertToInteger(requestBody.get("riskReduction"));
            Integer jobSize = this.safelyConvertToInteger(requestBody.get("jobSize"));
            Integer maxCardLimit = this.safelyConvertToInteger(requestBody.get("maxCardLimit"));
            ScoreCard savedScoreCard = this.scoreCardRepository.findBySessionId(sessionId);
            if (PropertyValidator.isValid((Object)savedScoreCard)) {
                HashMap savedWsjfParams = savedScoreCard.getParams();
                ScoreParam param1 = (ScoreParam)savedWsjfParams.get("param1");
                ScoreParam param2 = (ScoreParam)savedWsjfParams.get("param2");
                ScoreParam param3 = (ScoreParam)savedWsjfParams.get("param3");
                ScoreParam param4 = (ScoreParam)savedWsjfParams.get("param4");
                ArrayList allowedListParam1 = this.generateAllowedList(businessValue.intValue());
                param1.setAllowedValues((List)allowedListParam1);
                param1.setMax((Object)businessValue);
                ArrayList allowedListParam2 = this.generateAllowedList(timeCriticality.intValue());
                param2.setAllowedValues((List)allowedListParam2);
                param2.setMax((Object)timeCriticality);
                ArrayList allowedListParam3 = this.generateAllowedList(riskReduction.intValue());
                param3.setAllowedValues((List)allowedListParam3);
                param3.setMax((Object)riskReduction);
                ArrayList allowedListParam4 = this.generateAllowedList(jobSize.intValue());
                param4.setAllowedValues((List)allowedListParam4);
                param4.setMax((Object)jobSize);
                savedWsjfParams.put("param1", param1);
                savedWsjfParams.put("param2", param2);
                savedWsjfParams.put("param3", param3);
                savedWsjfParams.put("param4", param4);
                savedScoreCard.setParams(savedWsjfParams);
                savedScoreCard.setMaxCriteriaCardLimit(maxCardLimit);
                this.scoreCardRepository.save((Object)savedScoreCard);
                response.put("boardScoreParams", savedWsjfParams);
                response.put("maxCardLimit", maxCardLimit);
            } else {
                Session savedSession = this.getSession(sessionId);
                if (PropertyValidator.isValid((Object)savedSession)) {
                    ArrayList<Object> allowedListForJobSize = new ArrayList<Object>();
                    HashMap<String, ScoreParam> params = new HashMap<String, ScoreParam>();
                    ScoreParam param1 = new ScoreParam();
                    param1.setKey("param1");
                    param1.setName("User-Business Value");
                    param1.setAbbreviation("UBV");
                    param1.setAllowedValues((List)this.generateAllowedList(businessValue.intValue()));
                    param1.setMax((Object)businessValue);
                    param1.setMin((Object)1);
                    param1.setDefaultValue((Object)0);
                    param1.setDisplayType("DropDown");
                    param1.setDataType("Integer");
                    ScoreParam param2 = new ScoreParam();
                    param2.setKey("param2");
                    param2.setName("Time Criticality");
                    param2.setAbbreviation("TC");
                    param2.setMax((Object)timeCriticality);
                    param2.setMin((Object)1);
                    param2.setAllowedValues((List)this.generateAllowedList(timeCriticality.intValue()));
                    param2.setDefaultValue((Object)0);
                    param2.setDataType("Integer");
                    param2.setDisplayType("DropDown");
                    ScoreParam param3 = new ScoreParam();
                    param3.setKey("param3");
                    param3.setName("Risk Reduction(RR)/Opportunity Enablement(OE)");
                    param3.setAbbreviation("RR/OE");
                    param3.setMax((Object)riskReduction);
                    param3.setMin((Object)1);
                    param3.setAllowedValues((List)this.generateAllowedList(riskReduction.intValue()));
                    param3.setDefaultValue((Object)0);
                    param3.setDisplayType("DropDown");
                    param3.setDataType("Integer");
                    ScoreParam param4 = new ScoreParam();
                    allowedListForJobSize.add("");
                    for (int i = 1; i <= 99; ++i) {
                        allowedListForJobSize.add(i);
                    }
                    param4.setKey("param4");
                    param4.setName("Job Size");
                    param4.setAbbreviation("Job Size");
                    param4.setMax((Object)99);
                    param4.setMin((Object)1);
                    param4.setAllowedValues(allowedListForJobSize);
                    param4.setDefaultValue((Object)0);
                    param4.setDisplayType("TextField");
                    param4.setDataType("Integer");
                    params.put("param1", param1);
                    params.put("param2", param2);
                    params.put("param3", param3);
                    params.put("param4", param4);
                    ScoreCard newScoreCard = new ScoreCard();
                    newScoreCard.setTitle(ScoreCard.Type.WSJF.toString() + "_" + savedSession.getTitle());
                    newScoreCard.setType(ScoreCard.Type.WSJF.toString());
                    newScoreCard.setSessionId(savedSession.getId());
                    newScoreCard.setCustom(false);
                    newScoreCard.setParams(params);
                    newScoreCard.setFormula("abc");
                    newScoreCard.setMaxCriteriaCardLimit(maxCardLimit);
                    this.scoreCardRepository.save((Object)newScoreCard);
                    savedSession.setScoreCard(newScoreCard);
                    this.sessionRepository.save((Object)savedSession);
                    response.put("boardScoreParams", params);
                    response.put("maxCardLimit", maxCardLimit);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("*****saveCustomWsjfSettings**** -----> Unable to save custom WSJF settings. Exception occurred. ---------------" + StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        return response;
    }

    private ArrayList<Object> generateAllowedList(int maxValue) {
        ArrayList<Object> allowedList = new ArrayList<Object>();
        allowedList.add("");
        for (int i = 1; i <= maxValue; ++i) {
            allowedList.add(i);
        }
        return allowedList;
    }

    private Integer safelyConvertToInteger(Object value) throws Exception {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new Exception("Error converting String to Integer: " + e.getMessage(), e);
            }
        }
        throw new Exception("Invalid type for conversion to Integer");
    }

    public Map<String, Item> getJiraItemsMapBySessionBoard(String sessionBoardId) {
        HashMap<String, Item> itemsMap = new HashMap<String, Item>();
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        sessionBoards.add(new SessionBoard(sessionBoardId));
        List items = this.itemRepository.findBySessionBoardsIdInAndJiraIdIsNotNull(sessionBoardId);
        for (Item item : items) {
            itemsMap.put(item.getJiraId(), item);
        }
        return itemsMap;
    }

    public List<SessionBoard> getSessionBoardsBySessions(List sessions, List<State> states, Map<String, Boolean> sessionIdsForTfs, String requestId, Map<String, UserBoardPreferences> pref, Map<String, Integer> countsByWorkspaces) {
        HashMap<String, Session> sessionMap = new HashMap<String, Session>();
        ArrayList<ObjectId> sessionIds = new ArrayList<ObjectId>();
        for (int i = 0; i < sessions.size(); ++i) {
            Session session = null;
            if (sessions.get(i) instanceof DBObject) {
                session = new Session((BasicDBObject)sessions.get(i));
                if (countsByWorkspaces != null) {
                    if (countsByWorkspaces.get(session.getWorkSpace().getId()) == null) {
                        countsByWorkspaces.put(session.getWorkSpace().getId(), 0);
                    }
                    countsByWorkspaces.put(session.getWorkSpace().getId(), countsByWorkspaces.get(session.getWorkSpace().getId()) + 1);
                }
            } else if (sessions.get(i) instanceof Session) {
                session = (Session)sessions.get(i);
            }
            if (session == null) continue;
            if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                sessionIdsForTfs.put(session.getId(), true);
            }
            sessionMap.put(session.getId(), session);
            sessionIds.add(new ObjectId(session.getId()));
        }
        ArrayList<ObjectId> openBoardsStateIds = new ArrayList<ObjectId>();
        ArrayList<ObjectId> closeBoardsStateIds = new ArrayList<ObjectId>();
        HashMap<String, State> stateMap = new HashMap<String, State>();
        for (State state : states) {
            stateMap.put(state.getId(), state);
            if (state.getSequence() != 3) {
                openBoardsStateIds.add(new ObjectId(state.getId()));
                continue;
            }
            closeBoardsStateIds.add(new ObjectId(state.getId()));
        }
        List openBoardsList = this.getSessionBoardsBasedOnStates(sessionIds, openBoardsStateIds, sessionMap, stateMap, sessionIdsForTfs, pref);
        if (requestId != null) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        return openBoardsList;
    }

    public List<SessionBoard> getSessionBoardsBasedOnStates(List<ObjectId> sessionIds, List<ObjectId> stateIds, Map<String, Session> sessionMap, Map<String, State> stateMap, Map<String, Boolean> sessionIdsForTfs, Map<String, UserBoardPreferences> pref) {
        ArrayList<SessionBoard> parentBoards = new ArrayList<SessionBoard>();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"session.$id").in(sessionIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"parentBoard").is(null));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"state.$id").in(stateIds));
        query.with(new Sort(Sort.Direction.DESC, new String[]{"createdOn"}));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("sessionBoard").find(query.getQueryObject()).sort(query.getSortObject());
        List sessionBoards = dbCursorPrefix.toArray();
        try {
            for (DBObject sb : sessionBoards) {
                Session session;
                DBRef sessionRef = (DBRef)sb.get("session");
                List containersDBRef = (List)sb.get("containers");
                List teamsDBRef = (List)sb.get("teams");
                DBRef stateRef = (DBRef)sb.get("state");
                List teams = new ArrayList();
                ArrayList<Container> containers = new ArrayList<Container>();
                List teamIds = teamsDBRef.stream().map(dbo -> new ObjectId(dbo.getId().toString())).collect(Collectors.toList());
                teams = this.getTeamsUsingAggregation(teamIds);
                for (DBRef dbo2 : containersDBRef) {
                    containers.add(new Container(String.valueOf(dbo2.getId())));
                }
                boolean starred = false;
                SessionBoard sessionBoard = new SessionBoard(String.valueOf(sb.get("_id")), sessionMap.get(String.valueOf(sessionRef.getId())), containers, teams, stateMap.get(String.valueOf(stateRef.getId())), (Date)sb.get("creationDate"), (Date)sb.get("creationOn"), (String)sb.get("creationBy"), Boolean.valueOf(starred));
                if (sb.get("stateChangeDate") != null) {
                    sessionBoard.setStateChangeDate((Date)sb.get("stateChangeDate"));
                }
                if (null == sessionBoard.getSession().getAlmType() && null != sessionIdsForTfs && Boolean.TRUE.equals(sessionIdsForTfs.get(sessionBoard.getSession().getId()))) {
                    sessionBoard.getSession().setAlmType("tfs");
                }
                if (PropertyValidator.isValid(pref) && pref.containsKey((session = sessionMap.get(String.valueOf(sessionRef.getId()))).getId()) && pref.containsKey(session.getId())) {
                    UserBoardPreferences boardPreference = pref.get(session.getId());
                    sessionBoard.setStarred(boardPreference.getStarred());
                    sessionBoard.setSequence(boardPreference.getSequence());
                }
                parentBoards.add(sessionBoard);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return parentBoards;
    }

    private List<Team> getTeamsUsingAggregation(List<ObjectId> teamIds) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"_id").in(teamIds)), Aggregation.project((String[])new String[]{"id", "title"})});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "team", Team.class);
        return results.getMappedResults();
    }

    public Map<String, Boolean> getSessionIdsMapForTfsBoards(List<Session> sessions) {
        HashMap<String, Boolean> sidsTFS = new HashMap<String, Boolean>();
        if (PropertyValidator.isValid(sessions)) {
            ArrayList<ObjectId> sids = new ArrayList<ObjectId>();
            for (Session session : sessions) {
                sids.add(new ObjectId(session.getId()));
            }
            Query query = new Query();
            query.fields().include("id");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(sids));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tfsAlmConfigurations").ne(null));
            List tfsSessions = this.mongoTemplate.find(query, Session.class);
            if (PropertyValidator.isValid((Collection)tfsSessions)) {
                for (Session session : tfsSessions) {
                    sidsTFS.put(session.getId(), true);
                }
            }
        }
        return sidsTFS;
    }

    public Collection<ItemJiraFieldMap> getItemJiraFieldMap(SessionBoard sessionBoard) throws Exception {
        ArrayList<ItemJiraFieldMap> configFields = new ArrayList<ItemJiraFieldMap>();
        try {
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.reporter.name(), null, "JSONObject"));
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.assignee.name(), null, "JSONObject"));
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.updated.name(), null, "string"));
            if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAdditionalFieldsValuesFeature())) {
                List tmp = null;
                tmp = sessionBoard.getSession().getAdditionalFieldsValuesFeature();
                if (PropertyValidator.isValid((Collection)tmp)) {
                    for (ItemJiraFieldMap field : tmp) {
                        field.setClientTimeZone(sessionBoard.getSession().getClientTimeZone());
                        configFields.add(field);
                    }
                }
                if (PropertyValidator.isValid((Collection)(tmp = sessionBoard.getSession().getAdditionalFieldsValuesUserStory()))) {
                    for (ItemJiraFieldMap field : tmp) {
                        field.setClientTimeZone(sessionBoard.getSession().getClientTimeZone());
                        configFields.add(field);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return configFields;
    }

    public Set<WorkSpace> getUserWorkSpaces(User user, List<WorkSpaceAccessRole> workSpaceAccessRoles) {
        boolean ws_by_roles = workSpaceAccessRoles != null;
        HashSet workSpaces = new HashSet();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findWorkSpacesByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                if (workSpace.getRowStatus() != 0) continue;
                Boolean showWorkspace = false;
                if (PropertyValidator.isValid((Object)workSpace.getType()) && PropertyValidator.isValid((Collection)workSpace.getModules())) {
                    for (HashMap map : workSpace.getModules()) {
                        String id = (String)map.get("id");
                        if (!id.equalsIgnoreCase(EnumRTModules.ART_BOARDS.getCode())) continue;
                        showWorkspace = true;
                    }
                } else {
                    showWorkspace = true;
                }
                if (!showWorkspace.booleanValue()) continue;
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(new User(user.getId()));
                if (!ws_by_roles) continue;
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            if (!PropertyValidator.isValid((Collection)user.getGroups())) {
                user.setGroups(new HashSet());
            }
            Query query = new Query();
            ArrayList<ObjectId> groupIds = new ArrayList<ObjectId>();
            for (Object groupId : user.getGroups()) {
                if (!PropertyValidator.isValid((Object)groupId) || !ObjectId.isValid((String)groupId)) continue;
                groupIds.add(new ObjectId((String)groupId));
            }
            if (groupIds.isEmpty()) {
                List samlGroupList = this.groupRepository.findByTitleInOrExternalReferenceIn(new ArrayList(user.getGroups()), new ArrayList(user.getGroups()));
                for (Group group : samlGroupList) {
                    if (!PropertyValidator.isValid((Object)group.getId()) || !ObjectId.isValid((String)group.getId())) continue;
                    groupIds.add(new ObjectId(group.getId()));
                }
            }
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"user.$id").is((Object)new ObjectId(user.getId())), Criteria.where((String)"group.$id").in(groupIds)});
            query.addCriteria((CriteriaDefinition)criteria);
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("workSpaceAccessRole").find(query.getQueryObject());
            List accessRoles = dbCursorPrefix.toArray();
            if (PropertyValidator.isValid((Collection)accessRoles)) {
                HashSet<String> roleIds = new HashSet<String>();
                HashSet<String> workSpaceIds = new HashSet<String>();
                for (Object workSpaceAccessRole : accessRoles) {
                    List roleList;
                    DBRef groupRef;
                    Object userRef;
                    WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                    DBRef workSpaceRef = (DBRef)workSpaceAccessRole.get("workSpace");
                    if (PropertyValidator.isValid((Object)workSpaceRef) && PropertyValidator.isValid((Object)workSpaceRef.getId())) {
                        workSpaceIds.add(String.valueOf(workSpaceRef.getId()));
                        accessRole.setWorkSpace(new WorkSpace(String.valueOf(workSpaceRef.getId())));
                    }
                    if (PropertyValidator.isValid((Object)(userRef = (DBRef)workSpaceAccessRole.get("user"))) && PropertyValidator.isValid((Object)userRef.getId())) {
                        accessRole.setUser(new User(String.valueOf(userRef.getId())));
                    }
                    if (PropertyValidator.isValid((Object)(groupRef = (DBRef)workSpaceAccessRole.get("group"))) && PropertyValidator.isValid((Object)groupRef.getId())) {
                        accessRole.setGroup(new Group(String.valueOf(groupRef.getId())));
                    }
                    if (PropertyValidator.isValid((Collection)(roleList = (List)workSpaceAccessRole.get("roles")))) {
                        ArrayList<Role> roles = new ArrayList<Role>();
                        for (DBRef role : roleList) {
                            if (!PropertyValidator.isValid((Object)role) || !PropertyValidator.isValid((Object)role.getId())) continue;
                            roles.add(new Role(String.valueOf(role.getId())));
                            roleIds.add(role.getId().toString());
                        }
                        if (!roles.isEmpty()) {
                            accessRole.setRoles(roles);
                        }
                    }
                    if (!ws_by_roles) continue;
                    workSpaceAccessRoles.add(accessRole);
                }
                if (ws_by_roles) {
                    List roles = this.roleRepository.findByIdIn(new ArrayList(roleIds));
                    for (WorkSpaceAccessRole accessRole : workSpaceAccessRoles) {
                        if (!PropertyValidator.isValid((Collection)accessRole.getRoles())) continue;
                        ArrayList<Role> rolesToSet = new ArrayList<Role>();
                        block7: for (Role workSpaceRole : accessRole.getRoles()) {
                            Iterator iterator = roles.iterator();
                            while (iterator.hasNext()) {
                                Role role = (Role)iterator.next();
                                if (!role.equals((Object)workSpaceRole)) continue;
                                rolesToSet.add(role);
                                continue block7;
                            }
                        }
                        accessRole.setRoles(rolesToSet);
                    }
                }
                if (!workSpaceIds.isEmpty() && PropertyValidator.isValid((Collection)(workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findWorkSpaceByIdIn(new ArrayList(workSpaceIds))))) && ws_by_roles) {
                    block9: for (WorkSpaceAccessRole accessRole : workSpaceAccessRoles) {
                        if (!PropertyValidator.isValid((Object)accessRole.getWorkSpace())) continue;
                        String workSpaceId = accessRole.getWorkSpace().getId();
                        for (WorkSpace workSpace : workSpaces) {
                            if (!workSpace.getId().equals(workSpaceId)) continue;
                            accessRole.setWorkSpace(workSpace);
                            continue block9;
                        }
                    }
                }
            }
            if (ws_by_roles) {
                ArrayList<WorkSpaceAccessRole> accessRolesToRemove = new ArrayList<WorkSpaceAccessRole>();
                for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                    WorkSpace workspace = workSpaceAccessRole.getWorkSpace();
                    if (!PropertyValidator.isValid((Object)workspace) || workspace.getRowStatus() != 0) continue;
                    workSpaces.add(workSpaceAccessRole.getWorkSpace());
                    Boolean showWorkspace = false;
                    if (PropertyValidator.isValid((Object)workspace.getType()) && PropertyValidator.isValid((Collection)workspace.getModules())) {
                        for (HashMap map : workspace.getModules()) {
                            String id = (String)map.get("id");
                            if (!id.equalsIgnoreCase(EnumRTModules.ART_BOARDS.getCode())) continue;
                            showWorkspace = true;
                        }
                    } else {
                        showWorkspace = true;
                    }
                    if (showWorkspace.booleanValue()) continue;
                    accessRolesToRemove.add(workSpaceAccessRole);
                }
                if (PropertyValidator.isValid(accessRolesToRemove)) {
                    workSpaceAccessRoles.removeAll(accessRolesToRemove);
                }
            }
        }
        return workSpaces;
    }

    public HashMap<String, Object> getBoards(HashMap<String, Object> requestBody) {
        boolean empty = false;
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List parentBoardsList = new ArrayList();
        HashMap countsByWorkspaces = new HashMap();
        HashMap pref = new HashMap();
        Boolean showArchived = null != requestBody.get("showArchived");
        String requestId = (String)requestBody.get("requestId");
        List workSpacesIds = KendisUtils.getListAsObjectIds2((Collection)((Collection)requestBody.get("workSpacesIds")));
        ArrayList ids = new ArrayList();
        Long diff = 0L;
        Long startTime = 0L;
        startTime = System.currentTimeMillis();
        List boardPreferences = this.getUserBoardPreferences();
        boardPreferences.forEach(preference -> {
            pref.put(preference.getSessionId(), preference);
            ids.add(new ObjectId(preference.getSessionId()));
        });
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        if (showArchived.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").ne((Object)0));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        }
        if (PropertyValidator.isValid((Object)requestBody.get("title"))) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").regex((String)requestBody.get("title"), "i"));
        }
        if (Boolean.TRUE.equals(requestBody.get("starred"))) {
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"_id").in(ids), Criteria.where((String)"workSpace.$id").in((Collection)workSpacesIds)});
            query.addCriteria((CriteriaDefinition)criteria);
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace.$id").in((Collection)workSpacesIds));
        }
        HashMap sidsTFS = new HashMap();
        query.fields().include(requestId);
        query.fields().include("title");
        query.fields().include("activeSessionBoard");
        query.fields().include("rowStatus");
        query.fields().include("loadOldObjectivesView");
        query.fields().include("sequence");
        query.fields().include("workSpace");
        query.fields().include("riskRegister");
        query.fields().include("tfsAlmConfigurations");
        query.fields().include("almConfigurations");
        DBCursor cursor = this.customRepositoryImpl.getMongoTemplate().getCollection(KendisUtils.dbName(Session.class)).find(query.getQueryObject());
        List rows = cursor.toArray();
        cursor.close();
        if (!rows.isEmpty()) {
            List states = null;
            states = PropertyValidator.isValid((Object)requestBody.get("stateIds")) ? this.stateRepository.findByIdIn((List)requestBody.get("stateIds")) : this.stateRepository.findAll();
            parentBoardsList = this.getSessionBoardsBySessions(rows, states, sidsTFS, requestId, pref, countsByWorkspaces);
        } else {
            empty = true;
        }
        responseJson.put("parentBoards", parentBoardsList);
        responseJson.put("countsByWorkspaces", countsByWorkspaces);
        if (empty) {
            PushResponse pushResponse = new PushResponse();
            JSONObject json = new JSONObject();
            json.put("closedBoards", new ArrayList());
            json.put("metaMap", (Object)"{}");
            pushResponse.setContent(json.toString());
            pushResponse.setRequestId(requestId);
            pushResponse.setResponseCompleted(Boolean.TRUE);
            this.pushResponseRepository.save((Object)pushResponse);
        }
        return responseJson;
    }

    public HashMap<String, Object> getUserWorkSpaces(HashMap<String, Object> requestBody) {
        List dependencyStatusSchemes;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        ArrayList workSpaceAccessRoles = new ArrayList();
        Set workSpaces = this.getUserWorkSpaces(UserContextUtil.getUserContext().getLoggedInUser(), workSpaceAccessRoles);
        ArrayList<WorkFlow> statusSchemes = this.customRepository.findAllByTfsProjectIsNullAndWorkflowTypeNullOrGiven("General");
        if (!PropertyValidator.isValid((Collection)statusSchemes)) {
            statusSchemes = new ArrayList<WorkFlow>();
            statusSchemes.add(this.getDefaultWorkFlow());
        }
        if (!PropertyValidator.isValid((Collection)(dependencyStatusSchemes = this.workFlowRepository.findAllByWorkflowType("Dependency")))) {
            this.tfsService.createDefaultDependencyWorkflow();
        }
        ArrayList parentBoardsList = new ArrayList();
        responseJson.put("starred", this.userBoardPreferenceRepository.findAll());
        responseJson.put("parentBoards", parentBoardsList);
        responseJson.put("workSpaceAccessRoles", workSpaceAccessRoles);
        responseJson.put("permissionCodes", EnumPermission.getAllCodesList());
        return responseJson;
    }

    public HashMap<String, Object> getBoard(String id) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("board", this.sessionBoardRepository.findOneBySessionId(id));
        return responseJson;
    }

    public WorkFlow getDefaultWorkFlow() {
        WorkFlow defaultWorkFlow = this.workFlowRepository.findByIsDefaultIsTrue();
        if (!PropertyValidator.isValid((Object)defaultWorkFlow)) {
            WorkFlow defaultScheme = new WorkFlow();
            defaultScheme.setTitle("Default Workflow");
            defaultScheme.setDefault(true);
            defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
            List stlist = this.statusRepository.findAll();
            if (!PropertyValidator.isValid((Collection)stlist)) {
                List itemTypes = this.itemTypeRepository.findAll();
                if (!PropertyValidator.isValid((Collection)itemTypes)) {
                    ItemType type1 = new ItemType();
                    type1.setTitle("Feature");
                    ItemType type2 = new ItemType();
                    type2.setTitle("User story");
                    ArrayList<ItemType> types = new ArrayList<ItemType>();
                    types.add(type1);
                    types.add(type2);
                    itemTypes = this.itemTypeRepository.save(types);
                }
                for (ItemType category : EnumStatusCategory.values()) {
                    ArrayList<Status> statuses;
                    if (category.getCode().equals("ToDo")) {
                        for (ItemType type : itemTypes) {
                            if (type.getTitle().equals("Feature")) {
                                Status status1 = new Status();
                                status1.setTitle("In Business Refinement");
                                status1.setCategory(category.getCode());
                                status1.setColor("#f2930c");
                                status1.setWorkFlow(defaultScheme);
                                Status status2 = new Status();
                                status2.setTitle("In Technical Refinement");
                                status2.setCategory(category.getCode());
                                status2.setColor("#f2930c");
                                status2.setWorkFlow(defaultScheme);
                                Status status3 = new Status();
                                status3.setTitle("Awaiting Approval");
                                status3.setCategory(category.getCode());
                                status3.setColor("#f2930c");
                                status3.setWorkFlow(defaultScheme);
                                statuses = new ArrayList<Status>();
                                statuses.add(status1);
                                statuses.add(status2);
                                statuses.add(status3);
                                this.statusRepository.save(statuses);
                                continue;
                            }
                            if (!type.getTitle().equals("User story")) continue;
                            Status status8 = new Status();
                            status8.setTitle("Not Started");
                            status8.setCategory(category.getCode());
                            status8.setColor("#f2930c");
                            status8.setWorkFlow(defaultScheme);
                            this.statusRepository.save((Object)status8);
                        }
                        continue;
                    }
                    if (category.getCode().equals("InProgress")) {
                        for (ItemType type : itemTypes) {
                            if (type.getTitle().equals("Feature")) {
                                Status status4 = new Status();
                                status4.setTitle("In Progress");
                                status4.setCategory(category.getCode());
                                status4.setColor("#6498d8");
                                status4.setWorkFlow(defaultScheme);
                                this.statusRepository.save((Object)status4);
                                continue;
                            }
                            if (!type.getTitle().equals("User story")) continue;
                            Status status9 = new Status();
                            status9.setTitle("In Progress");
                            status9.setCategory(category.getCode());
                            status9.setColor("#6498d8");
                            status9.setWorkFlow(defaultScheme);
                            this.statusRepository.save((Object)status9);
                        }
                        continue;
                    }
                    if (!category.getCode().equals("Done")) continue;
                    for (ItemType type : itemTypes) {
                        if (type.getTitle().equals("Feature")) {
                            Status status5 = new Status();
                            status5.setTitle("Dev Complete");
                            status5.setCategory(category.getCode());
                            status5.setColor("#00BEA0");
                            status5.setWorkFlow(defaultScheme);
                            Status status6 = new Status();
                            status6.setTitle("Testing");
                            status6.setCategory(category.getCode());
                            status6.setColor("#00BEA0");
                            status6.setWorkFlow(defaultScheme);
                            Status status7 = new Status();
                            status7.setTitle("Done");
                            status7.setCategory(category.getCode());
                            status7.setColor("#00BEA0");
                            status7.setWorkFlow(defaultScheme);
                            statuses = new ArrayList();
                            statuses.add(status5);
                            statuses.add(status6);
                            statuses.add(status7);
                            this.statusRepository.save(statuses);
                            continue;
                        }
                        if (!type.getTitle().equals("User story")) continue;
                        Status status10 = new Status();
                        status10.setTitle("Dev Complete");
                        status10.setCategory(category.getCode());
                        status10.setColor("#00BEA0");
                        status10.setWorkFlow(defaultScheme);
                        Status status11 = new Status();
                        status11.setTitle("Testing");
                        status11.setCategory(category.getCode());
                        status11.setColor("#00BEA0");
                        status11.setWorkFlow(defaultScheme);
                        Status status12 = new Status();
                        status12.setTitle("Done");
                        status12.setCategory(category.getCode());
                        status12.setColor("#00BEA0");
                        status12.setWorkFlow(defaultScheme);
                        statuses = new ArrayList();
                        statuses.add(status10);
                        statuses.add(status11);
                        statuses.add(status12);
                        this.statusRepository.save(statuses);
                    }
                }
            } else {
                for (Status status : stlist) {
                    status.setWorkFlow(defaultScheme);
                }
                this.statusRepository.save((Iterable)stlist);
            }
        }
        defaultWorkFlow = this.workFlowRepository.findByIsDefaultIsTrue();
        return defaultWorkFlow;
    }

    private Map<String, DBObject> getItemsMapWithLastUpdated(String sessionBoardId) {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoardId)));
        List<String> fields = Arrays.asList("_id", "jiraId", "jiraFieldByKey");
        if (PropertyValidator.isValid(fields)) {
            for (String field : fields) {
                query.fields().include(field);
            }
        }
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
        dbCursorPrefix.sort((DBObject)new BasicDBObject("sequence", (Object)1));
        HashMap<String, DBObject> itemsMap = new HashMap<String, DBObject>();
        List allItems = dbCursorPrefix.toArray();
        for (DBObject dbo : allItems) {
            if (!dbo.containsField("jiraId")) continue;
            itemsMap.put((String)dbo.get("jiraId"), dbo);
        }
        return itemsMap;
    }

    public void copyCollaborationTypesFromOriginalBoard(String originalSessionBoardId, String newSessionBoardId, String newSessionId) throws Exception {
        try {
            Query query = new Query();
            Session session = this.sessionRepository.findByActiveSessionBoard(originalSessionBoardId);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessions").in(new Object[]{session.getId()}));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"defaultOrigin").exists(false));
            List originalCollaborationTypes = this.customRepositoryImpl.getMongoTemplate().find(query, CollaborationType.class);
            if (PropertyValidator.isValid((Collection)originalCollaborationTypes) && !originalCollaborationTypes.isEmpty()) {
                Session newSession = this.sessionRepository.findById(newSessionId);
                if (!PropertyValidator.isValid((Object)newSession)) {
                    LOGGER.error("New session not found with ID: {}", (Object)newSessionId);
                    return;
                }
                for (CollaborationType originalType : originalCollaborationTypes) {
                    try {
                        boolean sessionExists;
                        ArrayList<Session> existingSessions = originalType.getSessions();
                        if (existingSessions == null) {
                            existingSessions = new ArrayList<Session>();
                        }
                        if (sessionExists = existingSessions.stream().anyMatch(s -> s.getId().equals(newSessionId))) continue;
                        existingSessions.add(newSession);
                        originalType.setSessions(existingSessions);
                        this.collaborationTypeRepository.save((Object)originalType);
                        LOGGER.info("Successfully added new session {} to collaboration type: {}", (Object)newSessionId, (Object)originalType.getTitle());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error updating collaboration type: {}", (Object)originalType.getTitle(), (Object)e);
                    }
                }
                LOGGER.info("Completed copying {} collaboration types from original session board {} to new session board {}", new Object[]{originalCollaborationTypes.size(), originalSessionBoardId, newSessionBoardId});
            }
        }
        catch (Exception e) {
            LOGGER.error("Error copying collaboration types from original session board: {}", (Object)originalSessionBoardId, (Object)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ AppConfig.MongoConfig access$100(PlanServiceImpl x0) {
        return x0.mongoConfig;
    }

    static /* synthetic */ PushResponseRepository access$200(PlanServiceImpl x0) {
        return x0.pushResponseRepository;
    }
}

