/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.service.PIService;
import com.viztrend.safe.service.PIServiceImpl;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.utils.IntercommUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class PIServiceImpl
implements PIService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PIServiceImpl.class);
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private UserService userService;
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private ItemLogRepository itemLogRepository;

    public Map<String, Object> saveLinks(String requestBody) throws Exception {
        Item savedItem;
        SessionBoard board;
        Gson g = new Gson();
        1 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestMap = (HashMap)g.fromJson(requestBody, T.getType());
        String itemJson = (String)requestMap.get("item");
        String syncId = (String)requestMap.get("syncId");
        String requestId = (String)requestMap.get("requestId");
        String metaMap = (String)requestMap.get("metaMap");
        ObjectMapper mapper = new ObjectMapper();
        Item item = null;
        try {
            item = (Item)mapper.readValue(itemJson, mapper.getTypeFactory().constructType(Item.class));
        }
        catch (JsonParseException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonMappingException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        List linkIdsBeingUpdated = (List)requestMap.get("linkIds");
        ArrayList<ItemLink> linksBeingUpdated = new ArrayList<ItemLink>();
        ArrayList<ItemLink> linksBeingCreated = new ArrayList<ItemLink>();
        ArrayList<ItemLink> linksToBeCreatedInTFS = new ArrayList<ItemLink>();
        HashMap<String, Object> response = new HashMap<String, Object>();
        for (int i = 0; i < item.getItemLinks().size(); ++i) {
            ItemLink link2 = (ItemLink)item.getItemLinks().get(i);
            if (link2.getId() == null) {
                if (PropertyValidator.isValid((Object)link2.getWfStatus())) {
                    if (link2.getWfStatus().getCategory().equals("Done")) {
                        link2.setIsManuallyResolved(Boolean.valueOf(true));
                        link2.setResolvedOn(new Date());
                    } else {
                        link2.setResolvedOn(null);
                    }
                }
                linksBeingCreated.add(link2);
            } else if (linkIdsBeingUpdated != null) {
                linkIdsBeingUpdated.forEach(id -> {
                    if (id.equals(link2.getId())) {
                        linksBeingUpdated.add(link2);
                        return;
                    }
                });
            }
            if (!Boolean.TRUE.equals(link2.getSyncTfs())) continue;
            linksToBeCreatedInTFS.add(link2);
        }
        linksBeingUpdated.forEach(link -> {
            ItemLink savedLink = (ItemLink)this.itemLinkRepository.findOne((Serializable)((Object)link.getId()));
            String st1 = "";
            String st2 = "";
            if (PropertyValidator.isValid((Object)savedLink.getWfStatus()) && PropertyValidator.isValid((Object)link.getWfStatus())) {
                st1 = savedLink.getWfStatus().getId();
                st2 = link.getWfStatus().getId();
            } else {
                st1 = link.getWfStatus().getCategory();
                st2 = savedLink.getStatus().equals("Resolved") ? "Done" : "ToDo";
            }
            HashMap emailTemp = new HashMap();
            if (!st1.equals(st2)) {
                if (link.getWfStatus().getCategory().equals("Done")) {
                    link.setIsManuallyResolved(Boolean.valueOf(true));
                    link.setResolvedOn(new Date());
                } else {
                    link.setResolvedOn(null);
                }
                this.notificationService.startNotificationThread(link, savedLink, "dependency_statuschange_template", Boolean.valueOf(false), "");
            }
            if (!(link.getResponsible() == null && savedLink.getResponsible() == null || link.getResponsible() != null && savedLink.getResponsible() != null && link.getResponsible().getId().equals(savedLink.getResponsible().getId()))) {
                this.notificationService.startNotificationThread(link, savedLink, "dependency_responsible_template", Boolean.valueOf(false), "");
                if (PropertyValidator.isValid((Object)savedLink.getResponsible())) {
                    this.notificationService.startNotificationThread(link, savedLink, "dependency_old_responsible_template", Boolean.valueOf(true), "");
                }
            }
            link.setWatcherList(savedLink.getWatcherList());
            if (PropertyValidator.isValid((Object)link.getAlmLinkId())) {
                List linkedAlmLinks = (List)this.almSyncService.syncKendisAndAlmLink(link);
                response.put("linkedAlmLinks", linkedAlmLinks);
            }
        });
        Session session = null;
        if (PropertyValidator.isValid(linksBeingCreated)) {
            int index = 0;
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(((ItemLink)linksBeingCreated.get(0)).getSessionBoardId());
            session = sessionBoard.getSession();
            if (PropertyValidator.isValid((Object)session.getDependencyPrefix())) {
                for (ItemLink link3 : linksBeingCreated) {
                    link3.setCustomId(Integer.valueOf(this.customRepository.getNextSeq(session.getId(), null, null)).intValue());
                    try {
                        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    }
                    catch (Exception ex) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                    }
                }
            }
        }
        if (PropertyValidator.isValid((Collection)(board = (SessionBoard)(savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()))).getSessionBoards().get(0)).getSession().getAlmConfigurations()) && PropertyValidator.isValid((Object)savedItem.getJiraId())) {
            JiraUtils.saveLinks((Item)savedItem, (List)item.getItemLinks(), (String)syncId, (String)requestId);
        } else {
            for (int i = 0; i < item.getItemLinks().size(); ++i) {
                ItemLink link3;
                link3 = (ItemLink)item.getItemLinks().get(i);
                link3.setJiraDependency(null);
            }
        }
        List itemLinks = this.itemLinkRepository.save((Iterable)item.getItemLinks());
        if (!PropertyValidator.isValid((Collection)savedItem.getItemLinks())) {
            savedItem.setItemLinks(new ArrayList());
        }
        savedItem.setItemLinks(itemLinks);
        savedItem.setMetaMap(metaMap);
        savedItem.putLastUpdatedValue(Item.Actions.itemLinks.name(), (Object)itemLinks);
        this.itemRepository.save((Object)savedItem);
        if (PropertyValidator.isValid((Object)board.getSession().getTfsAlmConfigurations())) {
            AlmAccount almAccount = board.getSession().getTfsAlmConfigurations().getAlmAccount();
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        this.userService.setOnboardingMeta("Create_Dependencies", true);
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("dependencies_created", 1);
        String username = null;
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
            username = UserContextUtil.getUserContext().getLoggedInUser().getUserName();
        } else if ("apiUser".equals(SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            username = (String)UserContextDTO.getFromLocalThread().get("apiKeyUsername");
        }
        IntercommUtils.post((String)username, vars);
        response.put("itemLinks", itemLinks);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Feature");
            pushJson.put("boardId", (Object)board.getId());
            pushJson.put("metaMap", (Object)metaMap);
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return response;
    }

    public ResponseEntity<Object> saveTfsLink(ItemJiraDependency dependency) throws Exception {
        ItemJiraDependency reverseDependency;
        String metaMap = dependency.getMetaMap();
        ArrayList<ItemJiraDependency> linksToSave = new ArrayList<ItemJiraDependency>();
        ItemJiraDependency oldLink = (ItemJiraDependency)this.itemJiraDependencyRepository.findOne((Serializable)((Object)dependency.getId()));
        if (PropertyValidator.isValid((Object)oldLink.getSourceItemId()) && PropertyValidator.isValid((Object)oldLink.getTargetItemId()) && PropertyValidator.isValid((Object)(reverseDependency = this.itemJiraDependencyRepository.findBySourceItemIdAndTargetItemId(oldLink.getTargetItemId(), oldLink.getSourceItemId())))) {
            this.almSyncService.setLinkMeta(reverseDependency, dependency);
            linksToSave.add(reverseDependency);
        }
        if (PropertyValidator.isValid((Object)oldLink)) {
            this.almSyncService.setLinkMeta(oldLink, dependency);
            linksToSave.add(oldLink);
        }
        HashMap<String, ArrayList<ItemJiraDependency>> response = new HashMap<String, ArrayList<ItemJiraDependency>>();
        for (ItemJiraDependency link : linksToSave) {
            if (!dependency.getWfStatus().getCategory().equalsIgnoreCase("Done")) continue;
            link.setResolvedOn(new Date());
        }
        this.itemJiraDependencyRepository.save(linksToSave);
        response.put("linksToSave", linksToSave);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Feature");
            pushJson.put("boardId", (Object)dependency.getSessionBoardId());
            pushJson.put("metaMap", (Object)metaMap);
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    public ResponseEntity<Object> saveConversationByItemLink(String parentId, List<Conversation> conversations) throws Exception {
        List<String> itemLinkIds = Arrays.asList(parentId.split(","));
        ArrayList itemLinks = (ArrayList)this.customRepository.getItemLink(itemLinkIds);
        if (PropertyValidator.isValid(conversations)) {
            for (Conversation conv : conversations) {
                if (PropertyValidator.isValid((Object)conv.getId())) continue;
                Pattern p = Pattern.compile("\\[-(.*?)\\]");
                Matcher m = p.matcher(conv.getText());
                while (m.find()) {
                    ArrayList<String> emails = new ArrayList<String>();
                    emails.add(m.group(1));
                }
                itemLinks.forEach(link -> this.notificationService.startNotificationThread(link, link, "dependency_comment_template", Boolean.valueOf(false), conv.getText()));
            }
        }
        conversations = this.conversationRepository.save(conversations);
        if (PropertyValidator.isValid((Collection)itemLinks)) {
            for (ItemLink itemLink : itemLinks) {
                itemLink.setConversations(conversations);
            }
            this.itemLinkRepository.save((Iterable)itemLinks);
            conversations.forEach(con -> con.getUser());
            return new ResponseEntity((Object)itemLinks, HttpStatus.OK);
        }
        ArrayList itemJiraDependencies = (ArrayList)this.itemJiraDependencyRepository.findByIdIn(itemLinkIds);
        if (PropertyValidator.isValid((Collection)itemJiraDependencies)) {
            for (ItemJiraDependency itemJiraDependency : itemJiraDependencies) {
                itemJiraDependency.setConversations(conversations);
            }
            this.itemJiraDependencyRepository.save((Iterable)itemJiraDependencies);
            conversations.forEach(con -> con.getUser());
            return new ResponseEntity((Object)itemJiraDependencies, HttpStatus.OK);
        }
        return null;
    }

    public Map<String, Object> getStateItems(String sessionBoardId) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)sessionBoardId)) {
            return response;
        }
        SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
        Map settingOptions = sessionBoard.getSession().getInspectAndAdaptSetting();
        List boards = this.sessionBoardRepository.findBySessionId(sessionBoard.getSession().getId());
        if (!PropertyValidator.isValid((Collection)boards)) {
            return response;
        }
        List sortedBoards = this.sortBoardsBySequence(boards);
        SessionBoard planningBoard = this.getPlanningBoard(sortedBoards);
        SessionBoard trackingBoard = this.getTrackingBoard(sortedBoards);
        Map plannedData = this.getItemsByBoardAndOrganizeByType(planningBoard, settingOptions);
        Map trackingData = this.getItemsByBoardAndOrganizeByType(trackingBoard, settingOptions);
        HashMap<String, SessionBoard> sessionBoards = new HashMap<String, SessionBoard>();
        if (PropertyValidator.isValid((Object)planningBoard)) {
            sessionBoards.put("planning", planningBoard);
        }
        if (PropertyValidator.isValid((Object)trackingBoard)) {
            sessionBoards.put("tracking", trackingBoard);
        }
        response.put("sessionBoards", sessionBoards);
        response.put("planned", plannedData);
        response.put("tracking", trackingData);
        return response;
    }

    private SessionBoard getPlanningBoard(List<SessionBoard> sortedBoards) throws Exception {
        if (sortedBoards.size() == 1) {
            return sortedBoards.get(0);
        }
        if (sortedBoards.size() >= 2) {
            return sortedBoards.get(1);
        }
        return null;
    }

    private SessionBoard getTrackingBoard(List<SessionBoard> sortedBoards) throws Exception {
        if (sortedBoards.size() >= 3) {
            return sortedBoards.get(2);
        }
        return null;
    }

    private Map<String, Object> getItemsByBoardAndOrganizeByType(SessionBoard board, Map<String, Object> settings) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)board)) {
            return data;
        }
        List<Object> teamIds = new ArrayList();
        if (PropertyValidator.isValid((Collection)board.getTeams())) {
            teamIds = board.getTeams().stream().map(t -> new ObjectId(t.getId())).collect(Collectors.toList());
        }
        List items = new ArrayList();
        if (PropertyValidator.isValid(teamIds) && !teamIds.isEmpty()) {
            items = this.findItemsBySessionBoardAndTeams(new ObjectId(board.getId()), teamIds, settings);
        }
        List features = items.stream().filter(item -> Item.Type.Feature.name().equals(item.getType())).collect(Collectors.toList());
        List stories = items.stream().filter(item -> Item.Type.UserStory.name().equals(item.getType())).collect(Collectors.toList());
        data.put("features", features);
        data.put("stories", stories);
        return data;
    }

    public Map<String, Object> getItems(List<String> itemIds, String boardId, boolean removedLogs) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList logs = new ArrayList();
        if (PropertyValidator.isValid(itemIds)) {
            List items = this.fetchItemsWithCalculatedPoints(itemIds, boardId, removedLogs);
            List originItemIds = items.stream().map(BaseEntity::getOriginItemId).filter(Objects::nonNull).collect(Collectors.toList());
            response.put("items", items);
        }
        return response;
    }

    private List<Item> fetchItemsWithCalculatedPoints(List<String> itemIds, String boardId, boolean isRemoved) throws Exception {
        if (itemIds == null || itemIds.isEmpty()) {
            return new ArrayList<Item>();
        }
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        String itemCollection = this.mongoTemplate.getCollectionName(Item.class);
        List objectIds = itemIds.stream().map(ObjectId::new).collect(Collectors.toList());
        ArrayList<Object> operations = new ArrayList<Object>();
        Criteria criteria = Criteria.where((String)"_id").in(objectIds).and("tenant").is((Object)tenant);
        if (isRemoved) {
            criteria.and("archive").in(Arrays.asList(true, false));
        }
        operations.add(Aggregation.match((Criteria)criteria));
        operations.add(Aggregation.project((String[])new String[0]).and("_id").as("_id").and("jiraKey").as("jiraKey").and("jiraURL").as("jiraURL").and("tfsId").as("tfsId").and("kendisKey").as("kendisKey").and("title").as("title").and("type").as("type").and("storyPoints").as("storyPoints").and("teamContainers").as("teamContainers").and("originItemId").as("originItemId").and("tfsItemTypeIcon").as("tfsItemTypeIcon").and("jiraFieldByKey").as("jiraFieldByKey").and("tfsURL").as("tfsURL").and("parent").as("parent").and("createdBy").as("createdBy").and("createdOn").as("createdOn").and("sequence").as("sequence").and("status").as("status"));
        Aggregation aggregation = Aggregation.newAggregation(operations);
        List items = this.mongoTemplate.aggregate(aggregation, itemCollection, Item.class).getMappedResults();
        Status status = null;
        Item parent = null;
        for (Item item : items) {
            status = new Status();
            if (PropertyValidator.isValid((Object)item.getStatus())) {
                status.setId(item.getStatus().getId());
                status.setTitle(item.getStatus().getTitle());
                status.setCategory(item.getStatus().getCategory());
                item.setStatus(status);
            } else {
                status.setTitle("Misc");
                status.setCategory("Misc");
                status.setColor("#7c50b1");
                item.setStatus(status);
            }
            if (PropertyValidator.isValid((Object)item.getParent())) {
                parent = new Item();
                parent.setId(item.getParent().getId());
                parent.setTitle(item.getParent().getTitle());
                parent.setTfsId(item.getParent().getTfsId());
                parent.setTfsURL(item.getParent().getTfsURL());
                parent.setTfsItemTypeIcon(item.getParent().getTfsItemTypeIcon());
                parent.setJiraKey(item.getParent().getJiraKey());
                parent.setJiraURL(item.getParent().getJiraURL());
                parent.setKendisKey(item.getParent().getKendisKey());
                parent.setOriginItemId(item.getParent().getOriginItemId());
                parent.setJiraFieldByKey(item.getParent().getJiraFieldByKey());
                parent.setSequence(item.getParent().getSequence());
                item.setParent(parent);
            }
            if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
            for (TeamContainer container : item.getTeamContainers()) {
                Team team = container.getTeam();
                if (team == null) continue;
                team.setWorkSpaces(null);
            }
        }
        List featureIds = items.stream().filter(i -> Item.Type.Feature.name().equals(i.getType())).map(i -> new ObjectId(i.getId())).collect(Collectors.toList());
        if (!featureIds.isEmpty()) {
            Map pointsMap = this.aggregateStoryPointsMap(featureIds, boardId);
            for (Item item : items) {
                if (!Item.Type.Feature.name().equals(item.getType())) continue;
                Double calculatedPoints = pointsMap.getOrDefault(item.getId(), 0.0);
                item.setStoryPoints(calculatedPoints);
            }
        }
        return items;
    }

    private Map<String, Double> aggregateStoryPointsMap(List<ObjectId> parentFeatureIds, String boardId) throws Exception {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        String collectionName = this.mongoTemplate.getCollectionName(Item.class);
        Criteria parentCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"parent.$id").in(parentFeatureIds), Criteria.where((String)"parent").in(parentFeatureIds)});
        Criteria mainCriteria = new Criteria().andOperator(new Criteria[]{parentCriteria, Criteria.where((String)"type").is((Object)Item.Type.UserStory.name()), Criteria.where((String)"tenant").is((Object)tenant), Criteria.where((String)"archive").ne((Object)true), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"teamContainers").ne(null), Criteria.where((String)"teamContainers").not().size(0)})});
        if (PropertyValidator.isValid((Object)boardId)) {
            ObjectId boardObjId = new ObjectId(boardId);
            Criteria boardCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"sessionBoards.$id").is((Object)boardObjId), Criteria.where((String)"sessionBoards").is((Object)boardObjId)});
            mainCriteria = new Criteria().andOperator(new Criteria[]{mainCriteria, boardCriteria});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)mainCriteria), Aggregation.group((String[])new String[]{"parent"}).sum("storyPoints").as("totalPoints")});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, BasicDBObject.class);
        HashMap<String, Double> resultMap = new HashMap<String, Double>();
        for (BasicDBObject result : results.getMappedResults()) {
            Object idObj = result.get("_id");
            String parentId = null;
            if (idObj == null) continue;
            if (idObj instanceof DBRef) {
                Object innerId = ((DBRef)idObj).getId();
                parentId = innerId != null ? innerId.toString() : null;
            } else if (idObj instanceof ObjectId) {
                parentId = ((ObjectId)idObj).toHexString();
            } else if (idObj instanceof Map) {
                Map doc = (Map)idObj;
                if (doc.containsKey("$id")) {
                    parentId = doc.get("$id").toString();
                } else if (doc.containsKey("id")) {
                    parentId = doc.get("id").toString();
                }
            }
            Double points = 0.0;
            if (result.containsField("totalPoints") && result.get("totalPoints") != null) {
                Number num = (Number)result.get("totalPoints");
                points = num.doubleValue();
            }
            if (parentId == null) continue;
            resultMap.put(parentId, points);
        }
        return resultMap;
    }

    private List<Item> findItemsBySessionBoardAndTeams(ObjectId sessionBoardId, List<ObjectId> teamIds, Map<String, Object> settings) throws Exception {
        if (teamIds == null || teamIds.isEmpty()) {
            return new ArrayList<Item>();
        }
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        String itemCollectionName = this.mongoTemplate.getCollectionName(Item.class);
        ArrayList<Object> operations = new ArrayList<Object>();
        operations.add(context -> new BasicDBObject("$match", (Object)new BasicDBObject("sessionBoards.$id", (Object)sessionBoardId).append("tenant", (Object)tenant).append("archive", (Object)new BasicDBObject("$ne", (Object)true))));
        operations.add(context -> new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)"issueType").append("localField", (Object)"issueType.$id").append("foreignField", (Object)"_id").append("as", (Object)"issueTypeObj")));
        operations.add(Aggregation.unwind((String)"issueTypeObj", (boolean)true));
        boolean showBucket = false;
        if (PropertyValidator.isValid(settings) && settings.get("showBuckets") instanceof Boolean) {
            showBucket = (Boolean)settings.get("showBuckets");
        }
        if (!showBucket) {
            operations.add(Aggregation.match((Criteria)Criteria.where((String)"issueTypeObj.isBucket").ne((Object)true)));
            operations.add(context -> new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)itemCollectionName).append("localField", (Object)"parent.$id").append("foreignField", (Object)"_id").append("as", (Object)"parentObj")));
            operations.add(Aggregation.unwind((String)"parentObj", (boolean)true));
            operations.add(context -> new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)"issueType").append("localField", (Object)"parentObj.issueType.$id").append("foreignField", (Object)"_id").append("as", (Object)"parentIssueTypeObj")));
            operations.add(Aggregation.unwind((String)"parentIssueTypeObj", (boolean)true));
            operations.add(Aggregation.match((Criteria)Criteria.where((String)"parentIssueTypeObj.isBucket").ne((Object)true)));
        }
        operations.add(context -> new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)"teamContainer").append("localField", (Object)"teamContainers.$id").append("foreignField", (Object)"_id").append("as", (Object)"teamContainers")));
        operations.add(Aggregation.unwind((String)"teamContainers"));
        operations.add(context -> new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)"team").append("localField", (Object)"teamContainers.team.$id").append("foreignField", (Object)"_id").append("as", (Object)"teamContainers.team")));
        operations.add(Aggregation.unwind((String)"teamContainers.team"));
        operations.add(Aggregation.match((Criteria)Criteria.where((String)"teamContainers.team._id").in(teamIds)));
        operations.add(Aggregation.group((String[])new String[]{"_id"}).first("$$ROOT").as("tempItem").push("teamContainers").as("gatheredContainers"));
        operations.add(Aggregation.project((String[])new String[0]).and("_id").as("id").and("tempItem.title").as("title").and("tempItem.type").as("type").and("tempItem.storyPoints").as("storyPoints").and("tempItem.originItemId").as("originItemId").and("tempItem.status").as("status").and("tempItem.issueType").as("issueType").and(context -> new BasicDBObject("_id", (Object)"$tempItem.parent.$id")).as("parent").and("gatheredContainers").as("teamContainers").and("tempItem.description").as("description").and("tempItem.kendisId").as("kendisId"));
        Aggregation aggregation = Aggregation.newAggregation(operations);
        List items = this.mongoTemplate.aggregate(aggregation, itemCollectionName, Item.class).getMappedResults();
        Status status = null;
        Item parent = null;
        for (Item item : items) {
            status = new Status();
            if (PropertyValidator.isValid((Object)item.getStatus())) {
                status.setId(item.getStatus().getId());
                status.setTitle(item.getStatus().getTitle());
                status.setCategory(item.getStatus().getCategory());
                item.setStatus(status);
            }
            if (PropertyValidator.isValid((Object)item.getParent())) {
                parent = new Item();
                parent.setId(item.getParent().getId());
                parent.setTitle(item.getParent().getTitle());
                parent.setTfsId(item.getParent().getTfsId());
                parent.setTfsURL(item.getParent().getTfsURL());
                parent.setTfsItemTypeIcon(item.getParent().getTfsItemTypeIcon());
                parent.setJiraKey(item.getParent().getJiraKey());
                parent.setJiraURL(item.getParent().getJiraURL());
                parent.setKendisKey(item.getParent().getKendisKey());
                parent.setOriginItemId(item.getParent().getOriginItemId());
                parent.setJiraFieldByKey(item.getParent().getJiraFieldByKey());
                parent.setSequence(item.getParent().getSequence());
                item.setParent(parent);
            }
            if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
            for (TeamContainer container : item.getTeamContainers()) {
                Team team = container.getTeam();
                if (team == null) continue;
                team.setWorkSpaces(null);
            }
        }
        return items;
    }

    private List<SessionBoard> sortBoardsBySequence(List<SessionBoard> boards) throws Exception {
        if (!PropertyValidator.isValid(boards)) {
            return new ArrayList<SessionBoard>();
        }
        return boards.stream().filter(board -> board.getState() != null && board.getState().getSequence() != null).sorted(Comparator.comparing(board -> board.getState().getSequence())).collect(Collectors.toList());
    }

    static /* synthetic */ NotificationService access$000(PIServiceImpl x0) {
        return x0.notificationService;
    }

    static /* synthetic */ ItemRepository access$100(PIServiceImpl x0) {
        return x0.itemRepository;
    }

    static /* synthetic */ TFSservice access$200(PIServiceImpl x0) {
        return x0.tfSservice;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ CustomRepository access$400(PIServiceImpl x0) {
        return x0.customRepository;
    }
}

